DEFINT A-Z

DECLARE SUB Center (row, text$)
DECLARE FUNCTION CheckDrive (drive$)
DECLARE SUB Decode (source$, dest$)
DECLARE SUB Encode (source$, dest$)
DECLARE SUB FileCheck (fileName$)
DECLARE FUNCTION GetDir (files$(), path$, filePos)
DECLARE FUNCTION GetDirectories (files$(), path$, filePos)
DECLARE FUNCTION GetDrive$ ()
DECLARE FUNCTION GetFullPath$ ()
DECLARE FUNCTION GetNumDrives ()
DECLARE FUNCTION GetOpenFileName$ ()
DECLARE FUNCTION GetPath$ ()
DECLARE FUNCTION GetSpeed& ()
DECLARE FUNCTION GetString$ (row, col, length, fASCII, lASCII)
DECLARE FUNCTION GetType (lType)
DECLARE SUB Help ()
DECLARE SUB InitBoard ()
DECLARE SUB InitColours ()
DECLARE SUB InitGraphics ()
DECLARE SUB InitScreen ()
DECLARE SUB LoadLevel (fileName$)
DECLARE SUB Main ()
DECLARE SUB OpenFile ()
DECLARE SUB RedrawLand (x, y, landType)
DECLARE SUB SaveFile ()
DECLARE SUB SetColours (first, last)
DECLARE SUB Sort (array$(), first, last)

COMMON SHARED timeLimit, xStart, yStart, numDogs, lName$, compSpeed&

TYPE Hues
    r AS INTEGER
    g AS INTEGER
    B AS INTEGER
END TYPE

TYPE RegType
   AX AS INTEGER
   BX AS INTEGER
   CX AS INTEGER
   DX AS INTEGER
   BP AS INTEGER
   Si AS INTEGER
   DI AS INTEGER
   FLAGS AS INTEGER
   Ds AS INTEGER
   ES AS INTEGER
END TYPE

TYPE FileBuffer
    DOS AS STRING * 19
 Create AS STRING * 1
 Attrib AS INTEGER
 AcTime AS INTEGER
 AcDate AS INTEGER
  FSize AS LONG
  FName AS STRING * 13
END TYPE

'$DYNAMIC

DIM SHARED graphic(2995)
DIM SHARED background(515)
DIM SHARED mask(2547)
DIM SHARED board(19, 11)
DIM SHARED pal(255) AS Hues
DIM SHARED Regs AS RegType

CONST UGRASS = 0, CGRASS = 1, UFLOWER = 2, CFLOWER = 3, MANL1 = 4, MANL2 = 5
CONST MANU1 = 6, MANU2 = 7, MANR1 = 8, MANR2 = 9, MAND1 = 10, wall = 11
CONST VFENCE = 12, HFENCE = 13, DFENCE = 14, HOLE = 15, DOGSR = 16: DOGSL = 17
CONST DOGMRD = 18, DOGMLD = 19, DOGMRU = 20, DOGMLU = 21, WOMAND1 = 22
CONST WOMAND2 = 23, WOMANR1 = 24, WOMANR2 = 25, WOMANL1 = 26, WOMANL2 = 27
CONST WOMANU1 = 28, WOMANU2 = 29

CONST MDOGMLD = 0, MDOGMLU = 1, MDOGMRD = 2, MDOGMRU = 3, MDOGSL = 4
CONST MDOGSR = 5, MDFENCE = 6, MHFENCE = 7, MVFENCE = 8, MHOLE = 9
CONST MMAND1 = 10, MMANL1 = 11, MMANL2 = 12, MMANR1 = 13, MMANR2 = 14
CONST MMANU1 = 15, MMANU2 = 16, MWOMAND1 = 17, MWOMAND2 = 18, MWOMANL1 = 19
CONST MWOMANL2 = 20, MWOMANR1 = 21, MWOMANR2 = 22, MWOMANU1 = 23
CONST MWOMANU2 = 24

ON ERROR GOTO handler

compSpeed& = GetSpeed&

SCREEN 13
CLS

InitColours
InitGraphics
Main
CLS : SCREEN 0: WIDTH 80: SYSTEM

handler:

SELECT CASE ERR
       CASE 71
           RESUME NEXT
       CASE ELSE
           SCREEN 0: WIDTH 80
           PRINT "Program terminated.  Error code"; ERR
           SYSTEM
END SELECT

REM $STATIC
SUB Center (row, text$)

col = 20 - LEN(text$) \ 2
LOCATE row, col
PRINT text$

END SUB

FUNCTION CheckDrive (drive$)

Regs.AX = &H440E
Regs.BX = ASC(drive$) - 64
CALL interrupt(&H21, Regs, Regs)
IF Regs.FLAGS AND 1 THEN CheckDrive = 0 ELSE CheckDrive = 1

END FUNCTION

SUB Decode (source$, dest$)

DIM char AS STRING * 1

OPEN source$ FOR BINARY AS #1

sourceStr$ = ""
DO WHILE NOT EOF(1)
  GET #1, , char
  sourceStr$ = sourceStr$ + char
LOOP

CLOSE #1

destStr$ = ""
length = LEN(sourceStr$)
FOR i = 1 TO length
   char = MID$(sourceStr$, i, 1)
   ascii = ASC(char)
   IF ascii > 127 THEN
     charCtr = ascii - 128
     i = i + 1
     char = MID$(sourceStr$, i, 1)
     FOR j = 1 TO charCtr: destStr$ = destStr$ + char: NEXT
   ELSE
     destStr$ = destStr$ + char
   END IF
NEXT

OPEN dest$ FOR BINARY AS #1

PUT #1, , destStr$

CLOSE #1

END SUB

SUB Encode (source$, dest$)

DIM char AS STRING * 1
DIM char2 AS STRING * 1

OPEN source$ FOR BINARY AS #1

sourceStr$ = ""
DO WHILE NOT EOF(1)
  GET #1, , char
  sourceStr$ = sourceStr$ + char
LOOP

CLOSE #1

destStr$ = ""
length = LEN(sourceStr$)
FOR i = 1 TO length
   char = MID$(sourceStr$, i, 1)
   charCtr = 1
   DO WHILE i < length
     i = i + 1
     char2 = MID$(sourceStr$, i, 1)
     IF char = char2 THEN
       charCtr = charCtr + 1
     ELSE
       i = i - 1
       EXIT DO
     END IF
   LOOP

   IF charCtr = 1 THEN
     destStr$ = destStr$ + char
   ELSE
     destStr$ = destStr$ + CHR$(charCtr + 128) + char
   END IF
NEXT

OPEN dest$ FOR BINARY AS #1

PUT #1, , destStr$

CLOSE #1

END SUB

SUB FileCheck (fileName$)

OPEN fileName$ FOR APPEND AS #1
IF LOF(1) < 1 THEN
  CLOSE #1
  KILL fileName$
  BEEP
  CLS
  PRINT "Error, could not find game file."
  SYSTEM
END IF

CLOSE #1

END SUB

FUNCTION GetDir (files$(), path$, filePos)

DIM Buffer AS FileBuffer

IF RIGHT$(path$, 1) <> CHR$(0) THEN path$ = path$ + CHR$(0)

Regs.AX = &H1A00
Regs.Ds = VARSEG(Buffer)
Regs.DX = VARPTR(Buffer)
CALL interrupt(&H21, Regs, Regs)

Regs.AX = &H4E00
Regs.CX = 16
Regs.DX = SADD(path$)
CALL Interruptx(&H21, Regs, Regs)
FM = (Regs.AX AND &HF)
IF Regs.FLAGS AND 1 THEN
  GetDir = 0
  EXIT FUNCTION
END IF

DO WHILE FM = 0
  IF LEFT$(Buffer.FName, 1) <> "." THEN
    fileName$ = RTRIM$(Buffer.FName)
    files$(filePos) = fileName$
    IF LEN(files$(filePos)) < 18 THEN
      files$(filePos) = files$(filePos) + STRING$(18 - LEN(files$(filePos)), 32)
    END IF
    IF Buffer.Attrib = &H1000 THEN
      files$(filePos) = LEFT$(files$(filePos), 13)
      files$(filePos) = files$(filePos) + "<DIR>"
    END IF
    Buffer.Attrib = 0: Buffer.AcTime = 0: Buffer.AcDate = 0
    Buffer.FSize = 0: Buffer.FName = STRING$(13, 32)
    filePos = filePos + 1
  END IF

  Regs.AX = &H4F00
  Regs.DX = SADD(path$)
  CALL interrupt(&H21, Regs, Regs)
  FM = Regs.AX AND &HF
LOOP
                   
GetDir = 1

END FUNCTION

FUNCTION GetDirectories (files$(), path$, filePos)

DIM Buffer AS FileBuffer

IF RIGHT$(path$, 1) <> CHR$(0) THEN path$ = path$ + CHR$(0)

Regs.AX = &H1A00
Regs.Ds = VARSEG(Buffer)
Regs.DX = VARPTR(Buffer)
CALL interrupt(&H21, Regs, Regs)

Regs.AX = &H4E00
Regs.CX = 16
Regs.DX = SADD(path$)
CALL Interruptx(&H21, Regs, Regs)
FM = (Regs.AX AND &HF)
IF Regs.FLAGS AND 1 THEN
  GetDirectories = 0
  EXIT FUNCTION
END IF

DO WHILE FM = 0
  IF LEFT$(Buffer.FName, 1) <> "." THEN
    fileName$ = RTRIM$(Buffer.FName)
    IF Buffer.Attrib = &H1000 THEN
      files$(filePos) = fileName$
      IF LEN(files$(filePos)) < 13 THEN
        files$(filePos) = files$(filePos) + STRING$(13 - LEN(files$(filePos)), 32)
      END IF
      files$(filePos) = files$(filePos) + "<DIR>"
      filePos = filePos + 1
    END IF
    Buffer.Attrib = 0: Buffer.AcTime = 0: Buffer.AcDate = 0
    Buffer.FSize = 0: Buffer.FName = STRING$(13, 32)
  END IF

  Regs.AX = &H4F00
  Regs.DX = SADD(path$)
  CALL interrupt(&H21, Regs, Regs)
  FM = Regs.AX AND &HF
LOOP
                  
GetDirectories = 1

END FUNCTION

FUNCTION GetDrive$

Regs.AX = &H1900
CALL interrupt(&H21, Regs, Regs)
GetDrive$ = CHR$(65 + Regs.AX MOD 256)

END FUNCTION

FUNCTION GetFullPath$

GetFullPath$ = GetDrive$ + ":\" + GetPath$

END FUNCTION

FUNCTION GetNumDrives

curDrive$ = GetDrive$

Regs.AX = &HE00
Regs.DX = ASC(curDrive$) - 65
CALL interrupt(&H21, Regs, Regs)
tempVal = (Regs.AX MOD 256) - 1

FOR i = 1 TO tempVal
   IF CheckDrive(CHR$(i + 64)) = 0 THEN EXIT FOR
NEXT

GetNumDrives = i - 1

END FUNCTION

FUNCTION GetOpenFileName$

DIM files$(1000)

DIM highlight(712)
DIM tempBack(712)

GET (0, 0)-(156, 8), tempBack
LINE (0, 0)-(156, 8), 15, BF
GET (0, 0)-(156, 8), highlight
PUT (0, 0), tempBack, PSET
ERASE tempBack

LINE (80, 50)-(240, 150), 0, BF
FOR i = 0 TO 2: LINE (80 - i, 50 - i)-(240 + i, 150 + i), 15 - i * 3, B: NEXT

highlightPos = 0
startPos = 0
filePos = 0
path$ = GetFullPath$

numDrives = GetNumDrives

FOR i = 1 TO numDrives
   files$(filePos) = "[-" + CHR$(i + 64) + "-]" + STRING$(13, 32)
   filePos = filePos + 1
NEXT

DO
  highlightPos = 0
  startPos = 0

  IF GetPath$ <> "" THEN
    files$(filePos) = "..           <DIR>"
    filePos = filePos + 1
  END IF

  tempPath$ = ""
  IF LEN(path$) > 3 THEN tempPath$ = path$ + "\" ELSE tempPath$ = path$
  tempPath$ = tempPath$ + "*.*"
  isGood = GetDirectories(files$(), tempPath$, filePos)
  IF isGood THEN Sort files$(), numDrives, filePos - 1

  startFilePos = filePos
  noneFirstTry = 0
  tempPath$ = ""
  IF LEN(path$) > 3 THEN tempPath$ = path$ + "\" ELSE tempPath$ = path$
  tempPath$ = tempPath$ + "*.mcl"
  isGood = GetDir(files$(), tempPath$, filePos)
  IF isGood = 0 THEN noneFirstTry = 1
  tempPath$ = ""
  IF LEN(path$) > 3 THEN tempPath$ = path$ + "\" ELSE tempPath$ = path$
  tempPath$ = tempPath$ + "*.lvl"
  isGood = GetDir(files$(), tempPath$, filePos)
  IF isGood = 0 AND noneFirstTry = 1 THEN
    files$(filePos) = "--No files found--"
    filePos = filePos + 1
  ELSE
    Sort files$(), startFilePos, filePos - 1
  END IF

  selection$ = ""

  DO
    FOR i = startPos TO startPos + 10
       LOCATE i - startPos + 8, 12
       PRINT files$(i)
       IF (i - startPos) = highlightPos THEN PUT (82, (i - startPos) * 8 + 55), highlight
    NEXT

    DO: a$ = INKEY$: LOOP UNTIL a$ <> ""
    DO: LOOP UNTIL INKEY$ = ""

    oldHPos = highlightPos

    SELECT CASE a$
           CASE CHR$(0) + CHR$(72)
               IF highlightPos > 0 THEN
                 highlightPos = highlightPos - 1
               ELSE
                 IF startPos > 0 THEN startPos = startPos - 1
               END IF
           CASE CHR$(0) + CHR$(80)
               IF highlightPos < 10 AND highlightPos < filePos THEN
                 highlightPos = highlightPos + 1
               ELSE
                 IF startPos < filePos - 11 THEN startPos = startPos + 1
               END IF
           CASE CHR$(13)
               selection$ = files$(startPos + highlightPos)
    END SELECT

    WAIT &H3DA, 8

    PUT (82, oldHPos * 8 + 55), highlight, XOR
  LOOP UNTIL a$ = CHR$(27) OR a$ = CHR$(13)

  IF a$ = CHR$(13) THEN
    IF LEFT$(selection$, 1) = "[" THEN
      drive$ = MID$(selection$, 3, 1)
      drive$ = drive$ + ":\"
      CHDIR drive$
      newFilePos = numDrives
      FOR i = newFilePos TO filePos: files$(i) = "": NEXT
      filePos = newFilePos
      path$ = GetFullPath$
      LINE (81, 51)-(239, 149), 0, BF
    ELSEIF selection$ = "--No files found--" THEN
      BEEP
      newFilePos = numDrives
      FOR i = newFilePos TO filePos: files$(i) = "": NEXT
      filePos = newFilePos
      path$ = GetFullPath$
      LINE (81, 51)-(239, 149), 0, BF
    ELSEIF LEFT$(selection$, 2) = ".." THEN
      DO
        path$ = LEFT$(path$, LEN(path$) - 1)
      LOOP UNTIL RIGHT$(path$, 1) = "\"
      path$ = LEFT$(path$, LEN(path$) - 1)
      IF LEN(path$) = 2 THEN path$ = path$ + "\"
      CHDIR path$
      newFilePos = numDrives
      FOR i = newFilePos TO filePos: files$(i) = "": NEXT
      filePos = newFilePos
      path$ = GetFullPath$
      LINE (81, 51)-(239, 149), 0, BF
    ELSEIF RIGHT$(selection$, 5) = "<DIR>" THEN
      selection$ = RTRIM$(LEFT$(selection$, 13))
      IF LEN(path$) > 3 THEN path$ = path$ + "\"
      path$ = path$ + selection$
      CHDIR path$
      newFilePos = numDrives
      FOR i = newFilePos TO filePos: files$(i) = "": NEXT
      filePos = newFilePos
      path$ = GetFullPath$
      LINE (81, 51)-(239, 149), 0, BF
    ELSE
      selection$ = RTRIM$(selection$)
      a$ = CHR$(27)
    END IF
  END IF
LOOP UNTIL a$ = CHR$(27)

IF RIGHT$(selection$, 1) = CHR$(0) THEN selection$ = LEFT$(selection$, LEN(selection$) - 1)
GetOpenFileName$ = selection$

END FUNCTION

FUNCTION GetPath$

path$ = STRING$(64, 32)
curDrive$ = GetDrive$

Regs.AX = &H4700
Regs.DX = ASC(curDrive$) - 64
Regs.Ds = VARSEG(path$)
Regs.Si = SADD(path$)
CALL Interruptx(&H21, Regs, Regs)
path$ = RTRIM$(path$)
GetPath$ = LEFT$(path$, LEN(path$) - 1)

END FUNCTION

FUNCTION GetSpeed&

ctr& = 0
endTime! = TIMER + .5
DO
  ctr& = ctr& + 1
LOOP UNTIL TIMER > endTime!

GetSpeed& = ctr& * 5.5

END FUNCTION

FUNCTION GetString$ (row, col, length, fASCII, lASCII)

ctr = 1

DO: a$ = INKEY$: LOOP UNTIL a$ = ""
tempStr$ = ""

LOCATE row, col: PRINT STRING$(length, 32)

DO
  DO: a$ = INKEY$: LOOP UNTIL a$ <> ""
  DO: LOOP UNTIL INKEY$ = ""

  asciiVal = ASC(a$)
 
  IF ctr <= length AND asciiVal >= fASCII AND asciiVal <= lASCII THEN
    tempStr$ = tempStr$ + a$
    LOCATE row, col + ctr - 1: PRINT a$
    ctr = ctr + 1
  END IF

  IF asciiVal = 13 THEN
    EXIT DO
  ELSEIF asciiVal = 8 THEN
    IF ctr > 2 THEN
      LOCATE row, col + ctr - 2: PRINT " "
      ctr = ctr - 1
      tempStr$ = LEFT$(tempStr$, ctr - 1)
    ELSEIF ctr = 2 THEN
      LOCATE row, col + ctr - 2: PRINT " "
      ctr = 1
      tempStr$ = ""
    END IF
  END IF
LOOP

DO: LOOP UNTIL INP(&H60) <> &H1C

GetString$ = tempStr$

END FUNCTION

FUNCTION GetType (lType)

IF lType = 0 THEN
  GetType = 0
ELSEIF lType = 1 THEN
  GetType = 2
ELSEIF lType = 2 THEN
  GetType = 4
ELSEIF lType = 3 THEN
  GetType = 5
ELSEIF lType = 4 THEN
  GetType = 6
ELSEIF lType = 5 THEN
  GetType = 8
ELSEIF lType = 6 THEN
  GetType = 9
ELSEIF lType = 7 THEN
  GetType = 10
END IF

END FUNCTION

SUB Help

CLS

Center 7, "Mower Level Editor Help"

Center 9, "Arrow keys - move around screen"
Center 10, "Alt + left or right - change tile type"
Center 11, "Enter - place tile"
Center 12, "Alt + T - change time limit"
Center 13, "Alt + D - change number of dogs"
Center 14, "Alt + L - change level name"
Center 15, "Alt + N - new level"
Center 16, "Alt + O - open level"
Center 17, "Alt + S - save level"
Center 18, "Esc - quit program"

DO: LOOP UNTIL INKEY$ <> ""
DO: LOOP UNTIL INKEY$ = ""

InitScreen

END SUB

SUB InitBoard

FOR y = 0 TO 11
   FOR x = 0 TO 19
      IF x = 1 AND y = 0 THEN
        board(x, y) = 10
      ELSEIF x = 0 OR x = 19 OR y = 11 THEN
        board(x, y) = 4
      ELSE
        board(x, y) = 0
      END IF
   NEXT
NEXT

timeLimit = 50
xStart = 1
yStart = 0
numDogs = 1
lName$ = "New Level"

END SUB

SUB InitColours

ctr = 0
pal(ctr).r = 0
pal(ctr).g = 0
pal(ctr).B = 0
ctr = ctr + 1
FOR i = 21 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = 0
   pal(ctr).B = 0
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = 0
   pal(ctr).g = i
   pal(ctr).B = 0
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = 0
   pal(ctr).g = 0
   pal(ctr).B = i
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = i
   pal(ctr).B = 0
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = 0
   pal(ctr).B = i
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = 0
   pal(ctr).g = i
   pal(ctr).B = i
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = i / 2
   pal(ctr).B = 0
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = i / 2
   pal(ctr).B = i / 1.5
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i / 1.25
   pal(ctr).g = 0
   pal(ctr).B = i
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = 0
   pal(ctr).g = i
   pal(ctr).B = i / 1.25
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = 0
   pal(ctr).g = i / 1.25
   pal(ctr).B = i
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i / 1.5
   pal(ctr).g = i / 2.5
   pal(ctr).B = i / 2.5
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i / 3
   pal(ctr).g = i / 1.75
   pal(ctr).B = i / 2.5
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = i / 1.5
   pal(ctr).B = i / 1.5
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i / 2
   pal(ctr).g = i / 2
   pal(ctr).B = i / 2
   ctr = ctr + 1
NEXT i
FOR i = 18 TO 63 STEP 3
   pal(ctr).r = i
   pal(ctr).g = i
   pal(ctr).B = i
   ctr = ctr + 1
NEXT i

SetColours 0, 255

END SUB

SUB InitGraphics

Center 11, "Loading graphics"
Center 12, "Please wait"

FileCheck "grassunc.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "grassunc.pic", 0

FileCheck "grasscut.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "grasscut.pic", 196

FileCheck "flowers.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "flowers.pic", 196 * 2

FileCheck "flowersc.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "flowersc.pic", 196 * 3

FileCheck "manl1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manl1.pic", 196 * 4

FileCheck "manl2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manl2.pic", 196 * 5

FileCheck "manu1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manu1.pic", 196 * 6

FileCheck "manu2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manu2.pic", 196 * 7

FileCheck "manr1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manr1.pic", 196 * 8

FileCheck "manr2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manr2.pic", 196 * 9

FileCheck "mand1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "mand1.pic", 196 * 10

FileCheck "wall.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "wall.pic", 196 * 11

FileCheck "fencev.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "fencev.pic", 196 * 12

FileCheck "fenceh.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "fenceh.pic", 196 * 13

FileCheck "fenced.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "fenced.pic", 196 * 14

FileCheck "hole.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "hole.pic", 196 * 15

FileCheck "dogsr.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogsr.pic", 196 * 16

FileCheck "dogsl.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogsl.pic", 196 * 17

FileCheck "dogmrd.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmrd.pic", 196 * 18

FileCheck "dogmld.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmld.pic", 196 * 19

FileCheck "dogmru.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmru.pic", 196 * 20

FileCheck "dogmlu.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmlu.pic", 196 * 21

FileCheck "womand1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womand1.pic", 196 * 22

FileCheck "womand2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womand2.pic", 196 * 23

FileCheck "womanr1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanr1.pic", 196 * 24

FileCheck "womanr2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanr2.pic", 196 * 25

FileCheck "womanl1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanl1.pic", 196 * 26

FileCheck "womanl2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanl2.pic", 196 * 27

FileCheck "womanu1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanu1.pic", 196 * 28

FileCheck "womanu2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanu2.pic", 196 * 29

FileCheck "back.pic"
DEF SEG = VARSEG(background(0))
BLOAD "back.pic", 0

FileCheck "mower.msk"
DEF SEG = VARSEG(mask(0))
BLOAD "mower.msk", 0

END SUB

SUB InitScreen

WAIT &H3DA, 8
CLS

FOR i = 0 TO 4: LINE (5 + i, 21 + i)-(314 - i, 199 - i), 15 - i * 2, B: NEXT i

FOR i = 20 TO 260 STEP 40: PUT (i, 26), background, PSET: NEXT i
LINE (10, 50)-(19, 50), 25
LINE (300, 50)-(309, 50), 25
LINE (10, 26)-(19, 49), 93, BF
LINE (300, 26)-(309, 49), 93, BF

FOR i = 0 TO 11
   FOR j = 0 TO 19
      x = 10 + 15 * j
      y = 51 + 12 * i
      SELECT CASE board(j, i)
             CASE 0
                 PUT (x, y), graphic(98 * UGRASS), PSET
             CASE 2
                 PUT (x, y), graphic(98 * UFLOWER), PSET
             CASE 4
                 PUT (x, y), graphic(98 * wall), PSET
             CASE 5
                 PUT (x, y), graphic(98 * UGRASS), PSET
                 PUT (x, y), mask(98 * MVFENCE), AND
                 PUT (x, y), graphic(98 * VFENCE), XOR
             CASE 6
                 PUT (x, y), graphic(98 * UGRASS), PSET
                 PUT (x, y), mask(98 * MHFENCE), AND
                 PUT (x, y), graphic(98 * HFENCE), XOR
             CASE 8
                 PUT (x, y), graphic(98 * wall), PRESET
             CASE 9
                 PUT (x, y), graphic(98 * UGRASS), PSET
                 PUT (x, y), mask(98 * MHOLE), AND
                 PUT (x, y), graphic(98 * HOLE), XOR
             CASE 10
                 PUT (x, y), graphic(98 * CGRASS), PSET
                 PUT (x, y), mask(98 * MMAND1), AND
                 PUT (x, y), graphic(98 * MAND1), XOR
      END SELECT
   NEXT j
NEXT i

PUT (5, 8), graphic(98 * UGRASS), PSET
PUT (25, 8), graphic(98 * UFLOWER), PSET
PUT (45, 8), graphic(98 * wall), PSET
PUT (65, 8), graphic(98 * UGRASS), PSET
PUT (65, 8), mask(98 * MVFENCE), AND
PUT (65, 8), graphic(98 * VFENCE), XOR
PUT (85, 8), graphic(98 * UGRASS), PSET
PUT (85, 8), mask(98 * MHFENCE), AND
PUT (85, 8), graphic(98 * HFENCE), XOR
PUT (105, 8), graphic(98 * wall), PRESET
PUT (125, 8), graphic(98 * UGRASS), PSET
PUT (125, 8), mask(98 * MHOLE), AND
PUT (125, 8), graphic(98 * HOLE), XOR
PUT (145, 8), graphic(98 * CGRASS), PSET
PUT (145, 8), mask(98 * MMAND1), AND
PUT (145, 8), graphic(98 * MAND1), XOR
          
LOCATE 1, 25: PRINT "Time"
LOCATE 2, 26: PRINT LTRIM$(RTRIM$(STR$(timeLimit)))

LOCATE 1, 33: PRINT "Dogs"
LOCATE 2, 34: PRINT LTRIM$(RTRIM$(STR$(numDogs)))

LOCATE 1, 2: PRINT lName$

END SUB

SUB LoadLevel (fileName$)

DIM char AS STRING * 1

OPEN fileName$ FOR BINARY AS #1

FOR i = 0 TO 11
   FOR j = 0 TO 19
      GET #1, , char
      board(j, i) = ASC(char) - 48
   NEXT j
NEXT i

tempStr$ = ""

FOR i = 0 TO 2
   GET #1, , char
   tempStr$ = tempStr$ + char
NEXT i

timeLimit = VAL(tempStr$)

tempStr$ = ""

FOR i = 0 TO 1
   GET #1, , char
   tempStr$ = tempStr$ + char
NEXT i

xStart = VAL(tempStr$)

tempStr$ = ""

FOR i = 0 TO 1
   GET #1, , char
   tempStr$ = tempStr$ + char
NEXT i

yStart = VAL(tempStr$)

board(xStart, yStart) = 10

GET #1, , char
numDogs = VAL(char)

lName$ = ""
DO
  GET #1, , char
  IF char = CHR$(13) THEN EXIT DO
  lName$ = lName$ + char
LOOP

CLOSE #1

END SUB

SUB Main

DIM box(97)

LINE (0, 0)-(14, 11), 255, B
GET (0, 0)-(14, 11), box
PUT (0, 0), box, XOR

InitBoard
InitScreen

x = 0: y = 0: lType = 0: altFlag = 0

DO
  PUT (x * 15 + 10, y * 12 + 51), box, OR
  PUT (lType * 20 + 5, 8), box, OR

  FOR t& = 1 TO compSpeed& * 5: NEXT t&
  char = INP(&H60)
  DO: LOOP UNTIL INKEY$ = ""
 
  oldX = x: oldY = y: oldLType = lType
 
  SELECT CASE char
         CASE 72
             y = (y + 11) MOD 12
         CASE 75
             IF altFlag THEN lType = (lType + 7) MOD 8 ELSE x = (x + 19) MOD 20
         CASE 77
             IF altFlag THEN lType = (lType + 1) MOD 8 ELSE x = (x + 1) MOD 20
         CASE 80
             y = (y + 1) MOD 12
         CASE &H14
             IF altFlag THEN
               altFlag = 0
               timeLimit$ = GetString$(2, 26, 2, 48, 57)
               timeLimit = VAL(timeLimit$)
             END IF
         CASE &H18
             IF altFlag THEN
               altFlag = 0
               OpenFile
             END IF
         CASE &H1C
             board(x, y) = GetType(lType)
             IF board(x, y) = 10 THEN
               xStart = x
               yStart = y

               FOR tY = 0 TO 11
                  FOR tX = 0 TO 19
                     IF board(tX, tY) = 10 THEN
                       IF tX <> xStart OR tY <> yStart THEN
                         board(tX, tY) = 0
                         RedrawLand tX * 15 + 10, tY * 12 + 51, 0
                       END IF
                     END IF
                  NEXT
               NEXT
             END IF
         CASE &H1F
             IF altFlag THEN
               altFlag = 0
               SaveFile
             END IF
         CASE &H20
             IF altFlag THEN
               altFlag = 0
               numDogs$ = GetString$(2, 34, 1, 48, 57)
               numDogs = VAL(numDogs$)
             END IF
         CASE &H26
             IF altFlag THEN
               altFlag = 0
               lName$ = GetString$(1, 2, 18, 32, 123)
             END IF
         CASE &H31
             IF altFlag THEN
               altFlag = 0
               InitBoard
               InitScreen
             END IF
         CASE &H38
             altFlag = 1
         CASE &H38 + 128
             altFlag = 0
         CASE &H3B
             altFlag = 0
             Help
  END SELECT

  changedLType = GetType(oldLType)
  WAIT &H3DA, 8
  RedrawLand oldX * 15 + 10, oldY * 12 + 51, board(oldX, oldY)
  RedrawLand oldLType * 20 + 5, 8, changedLType
LOOP UNTIL char = 1

END SUB

SUB OpenFile

fileName$ = GetOpenFileName$

IF fileName$ <> "" THEN
  OPEN fileName$ FOR BINARY AS #1

  IF LOF(1) > 0 THEN
    CLOSE #1
    Decode fileName$, "~level.tmp"
    LoadLevel "~level.tmp"
    KILL "~level.tmp"
  ELSE
    CLOSE #1
    KILL fileName$
  END IF
END IF

InitScreen

END SUB

SUB RedrawLand (x, y, landType)

IF landType < 4 THEN
  PUT (x, y), graphic(98 * landType), PSET
ELSEIF landType = 4 THEN
  PUT (x, y), graphic(98 * wall), PSET
ELSEIF landType > 4 AND landType < 7 THEN
  PUT (x, y), graphic(98 * UGRASS), PSET
  IF landType = 5 THEN PUT (x, y), mask(98 * MVFENCE), AND
  IF landType = 6 THEN PUT (x, y), mask(98 * MHFENCE), AND
  PUT (x, y), graphic(98 * (VFENCE + landType - 5)), XOR
ELSEIF landType = 7 THEN
  PUT (x, y), graphic(98 * CGRASS), PSET
  PUT (x, y), mask(98 * MDFENCE), AND
  PUT (x, y), graphic(98 * DFENCE), XOR
ELSEIF landType = 8 THEN
  PUT (x, y), graphic(98 * wall), PRESET
ELSEIF landType = 9 THEN
  PUT (x, y), graphic(98 * UGRASS), PSET
  PUT (x, y), mask(98 * MHOLE), AND
  PUT (x, y), graphic(98 * HOLE), XOR
ELSEIF landType = 10 THEN
  PUT (x, y), graphic(98 * CGRASS), PSET
  PUT (x, y), mask(98 * MMAND1), AND
  PUT (x, y), graphic(98 * MAND1), XOR
END IF

END SUB

SUB SaveFile

DIM char AS STRING * 1

dontSave = 0

LINE (75, 95)-(250, 105), 0, BF
FOR i = 0 TO 2: LINE (75 - i, 94 - i)-(250 + i, 105 + i), 15 - i * 3, B: NEXT
LOCATE 13, 11: PRINT "Save as:         .mcl"
fileName$ = GetString$(13, 20, 8, 48, 123)

IF fileName$ <> "" THEN
  fileName$ = fileName$ + ".mcl"
 
  OPEN fileName$ FOR BINARY AS #1

  IF LOF(1) > 0 THEN
    CLS
    Center 11, "File already exists.  Overwrite? (y/n)"
    DO: a$ = INKEY$: a$ = LCASE$(a$): LOOP UNTIL a$ = "y" OR a$ = "n"
    IF a$ = "n" THEN dontSave = 1
  END IF

  CLOSE #1

  IF dontSave = 0 THEN
    OPEN "~level.tmp" FOR BINARY AS #1

    FOR y = 0 TO 11
       FOR x = 0 TO 19
          IF board(x, y) = 10 THEN char = "0" ELSE char = CHR$(board(x, y) + 48)
          PUT #1, , char
       NEXT
    NEXT

    timeLimit$ = LTRIM$(RTRIM$(STR$(timeLimit)))
    DO WHILE LEN(timeLimit$) < 3
      timeLimit$ = "0" + timeLimit$
    LOOP
    PUT #1, , timeLimit$
   
    xStart$ = LTRIM$(RTRIM$(STR$(xStart)))
    DO WHILE LEN(xStart$) < 2
      xStart$ = "0" + xStart$
    LOOP
    PUT #1, , xStart$

    yStart$ = LTRIM$(RTRIM$(STR$(yStart)))
    DO WHILE LEN(yStart$) < 2
      yStart$ = "0" + yStart$
    LOOP
    PUT #1, , yStart$

    numDogs$ = LTRIM$(RTRIM$(STR$(numDogs)))
    PUT #1, , numDogs$

    PUT #1, , lName$

    char = CHR$(13)
    PUT #1, , char

    CLOSE #1

    Encode "~level.tmp", fileName$
    KILL "~level.tmp"
  END IF
END IF

InitScreen

END SUB

SUB SetColours (first, last)

OUT &H3C8, first
FOR i = first TO last
   OUT &H3C9, pal(i).r
   OUT &H3C9, pal(i).g
   OUT &H3C9, pal(i).B
NEXT i

END SUB

SUB Sort (array$(), first, last)

FOR i = first TO last - 1
   FOR j = i + 1 TO last
      IF array$(j) < array$(i) THEN SWAP array$(j), array$(i)
   NEXT
NEXT

END SUB

