DEFINT A-Z

DECLARE SUB Add1 (n%)
DECLARE SUB Center (y%, text$, font())
DECLARE FUNCTION CheckDrive (drive$)
DECLARE SUB ClearKeys ()
DECLARE SUB Clock (timeLeft, lastTicked!, cTime)
DECLARE SUB Decode (source$, dest$)
DECLARE SUB Delay (delayTime!)
DECLARE SUB DrawLevel (board(), graphic(), background(), pal() AS ANY, plyr() AS ANY, cur, mask(), font(), lName$)
DECLARE SUB EndLevel (pal() AS ANY, level, font(), score&, timeLimit)
DECLARE SUB FadeIn (pal() AS ANY, cRed$, cGreen$, cBlue$)
DECLARE SUB FadeOut (pal() AS ANY, cRed$, cGreen$, cBlue$)
DECLARE SUB FileCheck (fileName$)
DECLARE FUNCTION GetDir (files$(), path$, filePos)
DECLARE FUNCTION GetDirectories (files$(), path$, filePos)
DECLARE FUNCTION GetDrive$ ()
DECLARE FUNCTION GetFullPath$ ()
DECLARE FUNCTION GetNumDrives ()
DECLARE FUNCTION GetOpenFileName$ ()
DECLARE FUNCTION GetPath$ ()
DECLARE FUNCTION GetSpeed& ()
DECLARE FUNCTION GetString$ (length, x, y, font())
DECLARE SUB GetVect (s, o, i)
DECLARE SUB GPrint (text$, x%, y%, font())
DECLARE SUB HighScores (newScore1&, newScore2&, graphic(), font(), pal() AS ANY)
DECLARE SUB InitColours (pal() AS ANY)
DECLARE SUB InitGraphics (graphic(), background(), font(), mask())
DECLARE SUB InstallISR ()
DECLARE SUB Instructions (font(), pal() AS ANY)
DECLARE SUB Intro (graphic(), font(), numPlayers, pal() AS ANY, mask(), custLevel$, startLevel)
DECLARE SUB LoadLevel (board(), timeLimit, plyr() AS ANY, cur, uGrassCount, lName$, maxDogs, custLevel$)
DECLARE SUB NewWoman (x, y, dir, board())
DECLARE SUB PlayMower (plyr() AS ANY, graphic(), background(), numPlayers, font(), pal() AS ANY, mask(), custLevel$, startLevel)
DECLARE SUB PreIntro (font(), pal() AS ANY)
DECLARE SUB RedrawLand (x, y, landType, graphic(), mask())
DECLARE SUB RestorePlayer (oldDir, plyr() AS ANY, cur, graphic(), mask())
DECLARE SUB SetColours (pal() AS ANY, first, last)
DECLARE SUB SetVect (s, o, i)
DECLARE SUB Sort (array$(), first, last)

COMMON SHARED compSpeed&, oldKeyIntSeg, oldKeyIntOff

'$DYNAMIC

TYPE Hues                                        'define the type for hues
    red AS INTEGER                               'red component
  green AS INTEGER                               'green component
   blue AS INTEGER                               'blue component
END TYPE

TYPE PlayerStuff
  lives AS INTEGER
  score AS LONG
  level AS INTEGER
   scrX AS INTEGER
   scrY AS INTEGER
   brdX AS INTEGER
   brdY AS INTEGER
    dir AS INTEGER
 moving AS INTEGER
  frame AS INTEGER
 fCount AS INTEGER
 nextUp AS LONG
END TYPE

TYPE RegType
   AX AS INTEGER
   BX AS INTEGER
   CX AS INTEGER
   DX AS INTEGER
   BP AS INTEGER
   SI AS INTEGER
   DI AS INTEGER
   FLAGS AS INTEGER
   DS AS INTEGER
   ES AS INTEGER
END TYPE

TYPE FileBuffer
    DOS AS STRING * 19
 Create AS STRING * 1
 Attrib AS INTEGER
 AcTime AS INTEGER
 AcDate AS INTEGER
  FSize AS LONG
  FName AS STRING * 13
END TYPE

DIM SHARED Regs AS RegType
DIM SHARED keyboard(63)
DIM pal(255) AS Hues
DIM plyr(2) AS PlayerStuff
DIM graphic(2994)
DIM background(515)
DIM font(1589)
DIM mask(2547)

CONST UGRASS = 0, CGRASS = 1, UFLOWER = 2, CFLOWER = 3, MANL1 = 4, MANL2 = 5
CONST MANU1 = 6, MANU2 = 7, MANR1 = 8, MANR2 = 9, MAND1 = 10, WALL = 11
CONST VFENCE = 12, HFENCE = 13, DFENCE = 14, HOLE = 15, DOGSR = 16: DOGSL = 17
CONST DOGMRD = 18, DOGMLD = 19, DOGMRU = 20, DOGMLU = 21, WOMAND1 = 22
CONST WOMAND2 = 23, WOMANR1 = 24, WOMANR2 = 25, WOMANL1 = 26, WOMANL2 = 27
CONST WOMANU1 = 28, WOMANU2 = 29
CONST MDOGMLD = 0, MDOGMLU = 1, MDOGMRD = 2, MDOGMRU = 3, MDOGSL = 4
CONST MDOGSR = 5, MDFENCE = 6, MHFENCE = 7, MVFENCE = 8, MHOLE = 9
CONST MMAND1 = 10, MMANL1 = 11, MMANL2 = 12, MMANR1 = 13, MMANR2 = 14
CONST MMANU1 = 15, MMANU2 = 16, MWOMAND1 = 17, MWOMAND2 = 18, MWOMANL1 = 19
CONST MWOMANL2 = 20, MWOMANR1 = 21, MWOMANR2 = 22, MWOMANU1 = 23
CONST MWOMANU2 = 24

oldKeyIntSeg = 0: oldKeyIntOff = 0

ON ERROR GOTO handler
RANDOMIZE TIMER
SCREEN 13
CLS

InitColours pal()
COLOR 255
InitGraphics graphic(), background(), font(), mask()
compSpeed& = GetSpeed&
PreIntro font(), pal()

DO
  Intro graphic(), font(), numPlayers, pal(), mask(), custLevel$, startLevel
  PlayMower plyr(), graphic(), background(), numPlayers, font(), pal(), mask(), custLevel$, startLevel
LOOP

handler:
IF oldKeyIntSeg <> 0 OR oldKeyIntOff <> 0 THEN
  SetVect oldKeyIntSeg, oldKeyIntOff, &H9
  oldKeyIntSeg = 0: oldKeyIntOff = 0
END IF

SELECT CASE ERR
       CASE 71
           RESUME NEXT
       CASE ELSE
           SCREEN 0: WIDTH 80
           PRINT "Program terminated.  Error code"; ERR
           PRINT "Press a key..."
           DO: LOOP UNTIL INKEY$ <> ""
           SYSTEM
END SELECT

REM $STATIC
SUB Add1 (n%)

n% = n% + 1

END SUB

SUB Center (y%, text$, font())

x% = 160 - ((LEN(text$) * 7) \ 2)
GPrint text$, x%, y%, font()

END SUB

SUB ClearKeys

DO: LOOP UNTIL INKEY$ = ""

END SUB

SUB Clock (timeLeft, lastTicked!, cTime)

IF lastTicked! < TIMER - 1 THEN
  timeLeft = timeLeft - 1
  lastTicked! = TIMER
  cTime = 1
END IF

END SUB

SUB Decode (source$, dest$)

DIM char AS STRING * 1

OPEN source$ FOR BINARY AS #1

sourceStr$ = ""
DO WHILE NOT EOF(1)
  GET #1, , char
  sourceStr$ = sourceStr$ + char
LOOP

CLOSE #1

destStr$ = ""
length = LEN(sourceStr$)
FOR i = 1 TO length
   char = MID$(sourceStr$, i, 1)
   ascii = ASC(char)
   IF ascii > 127 THEN
     charCtr = ascii - 128
     i = i + 1
     char = MID$(sourceStr$, i, 1)
     FOR j = 1 TO charCtr: destStr$ = destStr$ + char: NEXT
   ELSE
     destStr$ = destStr$ + char
   END IF
NEXT

OPEN dest$ FOR BINARY AS #1
PUT #1, , destStr$
CLOSE #1

END SUB

SUB Delay (delayTime!)

endTime! = TIMER + delayTime!
DO: curTime! = TIMER: LOOP UNTIL curTime! > endTime!

END SUB

SUB DrawLevel (board(), graphic(), background(), pal() AS Hues, plyr() AS PlayerStuff, cur, mask(), font(), lName$)

cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$

CLS
FOR i = 0 TO 4: LINE (5 + i, 21 + i)-(314 - i, 199 - i), 15 - i * 2, B: NEXT

FOR i = 20 TO 260 STEP 40: PUT (i, 26), background, PSET: NEXT
LINE (10, 50)-(19, 50), 25
LINE (300, 50)-(309, 50), 25
LINE (10, 26)-(19, 49), 93, BF
LINE (300, 26)-(309, 49), 93, BF

FOR i = 0 TO 11
   FOR j = 0 TO 19
      x = 10 + 15 * j
      y = 51 + 12 * i
      SELECT CASE board(j, i)
             CASE 0
                 PUT (x, y), graphic(98 * UGRASS), PSET
             CASE 2
                 PUT (x, y), graphic(98 * UFLOWER), PSET
             CASE 4
                 PUT (x, y), graphic(98 * WALL), PSET
             CASE 5
                 PUT (x, y), graphic(98 * UGRASS), PSET
                 PUT (x, y), mask(98 * MVFENCE), AND
                 PUT (x, y), graphic(98 * VFENCE), XOR
             CASE 6
                 PUT (x, y), graphic(98 * UGRASS), PSET
                 PUT (x, y), mask(98 * MHFENCE), AND
                 PUT (x, y), graphic(98 * HFENCE), XOR
             CASE 8
                 PUT (x, y), graphic(98 * WALL), PSET
             CASE 9
                 PUT (x, y), graphic(98 * UGRASS), PSET
                 PUT (x, y), mask(98 * MHOLE), AND
                 PUT (x, y), graphic(98 * HOLE), XOR
      END SELECT
   NEXT
NEXT

PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * CGRASS), PSET
PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMAND1), AND
PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * MAND1), XOR

GPrint "level:", 5, 0, font()
GPrint "lives:", 5, 10, font()
GPrint "score:", 230, 0, font()
GPrint "time :", 230, 10, font()
Center 0, lName$, font()
tempStr$ = LTRIM$(RTRIM$(STR$(cur)))
pName$ = "Player " + tempStr$
Center 10, pName$, font()

FadeIn pal(), cRed$, cGreen$, cBlue$

END SUB

SUB EndLevel (pal() AS Hues, level, font(), score&, timeLimit)

cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$
CLS

message$ = "level" + STR$(level) + " completed."
IF level = 0 THEN message$ = "custom level completed."
score$ = LTRIM$(RTRIM$(STR$(score&)))
Center 86, message$, font()
Center 96, "time bonus", font()
Center 106, score$, font()

FadeIn pal(), cRed$, cGreen$, cBlue$

DO WHILE timeLimit > 0
  FOR i = 1 TO 50
     score& = score& + 1
     score$ = LTRIM$(RTRIM$(STR$(score&)))
     LINE (135, 106)-(185, 114), 0, BF
     Center 106, score$, font()
     FOR t& = 1 TO compSpeed& \ 4: NEXT t&
  NEXT i
  timeLimit = timeLimit - 1
LOOP

END SUB

SUB FadeIn (pal() AS Hues, cRed$, cGreen$, cBlue$)

DIM char AS STRING * 1

FOR i = 0 TO 63
   FOR j = 0 TO 255
      char = MID$(cRed$, j + 1, 1): nRed = ASC(char) - 32
      char = MID$(cGreen$, j + 1, 1): nGreen = ASC(char) - 32
      char = MID$(cBlue$, j + 1, 1): nBlue = ASC(char) - 32
      IF pal(j).red > nRed THEN pal(j).red = pal(j).red - 1
      IF pal(j).green > nGreen THEN pal(j).green = pal(j).green - 1
      IF pal(j).blue > nBlue THEN pal(j).blue = pal(j).blue - 1
   NEXT
   SetColours pal(), 0, 255
NEXT

END SUB

SUB FadeOut (pal() AS Hues, cRed$, cGreen$, cBlue$)

DIM char AS STRING * 1

FOR i = 0 TO 63
   FOR j = 0 TO 255
      IF i = 0 THEN
        char = CHR$(pal(j).red + 32): cRed$ = cRed$ + char
        char = CHR$(pal(j).green + 32): cGreen$ = cGreen$ + char
        char = CHR$(pal(j).blue + 32): cBlue$ = cBlue$ + char
      END IF
      IF pal(j).red < 63 THEN pal(j).red = pal(j).red + 1
      IF pal(j).green < 63 THEN pal(j).green = pal(j).green + 1
      IF pal(j).blue < 63 THEN pal(j).blue = pal(j).blue + 1
   NEXT
   SetColours pal(), 0, 255
NEXT

END SUB

SUB FileCheck (fileName$)

OPEN fileName$ FOR APPEND AS #1

IF LOF(1) < 1 THEN
  CLOSE #1: KILL fileName$: BEEP: CLS
  PRINT "Error, could not find game file."
  SYSTEM
END IF

CLOSE #1

END SUB

FUNCTION GetSpeed&

ctr& = 0: endTime! = TIMER + .5
DO: ctr& = ctr& + 1: LOOP UNTIL TIMER > endTime!
GetSpeed& = ctr& * 5.5

END FUNCTION

FUNCTION GetString$ (length, x, y, font())

ctr = 1
boxStage = 0
boxTime! = TIMER
changeBox = 1
DO: a$ = INKEY$: LOOP UNTIL a$ = ""

DO
  IF changeBox THEN
    LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
    LINE (x + 7 * (ctr - 1) + boxStage, y + boxStage)-(x + 7 * (ctr - 1) + 5 - boxStage, y + 7 - boxStage), 15 - boxStage * 2, B
    changeBox = 0
  END IF

  a$ = INKEY$

  IF a$ <> "" THEN
    asciiVal = ASC(a$)
    IF ctr < length THEN
      SELECT CASE asciiVal
             CASE 32
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 ctr = ctr + 1
             CASE 33 TO 59
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint a$, x + 7 * (ctr - 1), y, font()
                 ctr = ctr + 1
             CASE 61
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint a$, x + 7 * (ctr - 1), y, font()
                 ctr = ctr + 1
             CASE 63 TO 91
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint a$, x + 7 * (ctr - 1), y, font()
                 ctr = ctr + 1
             CASE 93 TO 94
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint a$, x + 7 * (ctr - 1), y, font()
                 ctr = ctr + 1
             CASE 97 TO 123
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint a$, x + 7 * (ctr - 1), y, font()
                 ctr = ctr + 1
             CASE 125
                 tempStr$ = tempStr$ + a$
                 LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
                 GPrint a$, x + 7 * (ctr - 1), y, font()
                 ctr = ctr + 1
      END SELECT
    END IF

    IF asciiVal = 13 THEN
      EXIT DO
    ELSEIF asciiVal = 8 THEN
      IF ctr > 2 THEN
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
        ctr = ctr - 1
        tempStr$ = LEFT$(tempStr$, ctr - 1)
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
      ELSEIF ctr = 2 THEN
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
        ctr = 1
        LINE (x + 7 * (ctr - 1), y)-(x + 7 * (ctr - 1) + 5, y + 7), 0, BF
        tempStr$ = ""
      END IF
    END IF
    DO: a$ = INKEY$: LOOP UNTIL a$ = ""
  END IF

  IF boxTime! <> TIMER THEN
    boxStage = (boxStage + 1) MOD 3
    changeBox = 1
    boxTime! = TIMER
  END IF
LOOP

GetString$ = tempStr$

END FUNCTION

' Written by Steven Sensarn.
SUB GetVect (s, o, i)

    'GETVECT RETURNS THE ADDRESS OF A FUNCTION POINTED TO IN THE
    'INTERRUPT VECTOR TABLE (STARTS AT 0000:0000H)

    STATIC ASM AS STRING 'THE CODE FOR GETVECT

    STATIC INI AS INTEGER 'USED TO DETECT WHETHER GETVECT HAS PREVIOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN
     
        'CREATE ML FUNCTION IF NOT ALREADY CREATED

        ASM = ASM + CHR$(&H55)                          'PUSH    BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV     BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV     BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV     AL,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H35)             'MOV     AH,35
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT     21
        ASM = ASM + CHR$(&H53)                          'PUSH    BX
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV     BX,[BP+0A]
        ASM = ASM + CHR$(&H8C) + CHR$(&H7)              'MOV     [BX],ES
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV     BX,[BP+08]
        ASM = ASM + CHR$(&H58)                          'POP     AX
        ASM = ASM + CHR$(&H89) + CHR$(&H7)              'MOV     [BX],AX
        ASM = ASM + CHR$(&H5D)                          'POP     BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF    0006
        INI = 1 'FLAG CREATION
    END IF

    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN FUNCTION

END SUB

SUB GPrint (text$, x%, y%, font())

text$ = UCASE$(text$)
length = LEN(text$)

FOR i = 1 TO length
   ascii = ASC(MID$(text$, i, 1))
   SELECT CASE ascii
          CASE 65 TO 90: ascii = ascii - 65
          CASE 48: ascii = 9 + 26
          CASE 49 TO 57: ascii = ascii - 49 + 26
          CASE 33: ascii = 36
          CASE 64: ascii = 37
          CASE 35 TO 37: ascii = ascii - 35 + 38
          CASE 94: ascii = 41
          CASE 38: ascii = 42
          CASE 42: ascii = 43
          CASE 40 TO 41: ascii = ascii - 40 + 44
          CASE 45: ascii = 46
          CASE 43: ascii = 47
          CASE 61: ascii = 48
          CASE 123: ascii = 49
          CASE 125: ascii = 50
          CASE 91: ascii = 51
          CASE 93: ascii = 52
          CASE 58 TO 59: ascii = ascii - 58 + 53
          CASE 34: ascii = 55
          CASE 39: ascii = 56
          CASE 44: ascii = 57
          CASE 46: ascii = 58
          CASE 63: ascii = 59
          CASE 47: ascii = 60
          CASE ELSE: ascii = 61
   END SELECT

   IF ascii < 61 THEN
     PUT (x%, y%), font(26 * ascii), PSET
     x% = x% + 7
   ELSE
     x% = x% + 7
   END IF
NEXT i

END SUB

SUB HighScores (newScore1&, newScore2&, graphic(), font(), pal() AS Hues)

DIM char AS STRING * 1
DIM scores(9) AS LONG
DIM names(9) AS STRING * 20

p1Place = 10: p2Place = 10

OPEN "mower.hi" FOR BINARY AS #1

IF LOF(1) = 0 THEN
  FOR i = 0 TO 9
     names(i) = "the gardener        "
     scores(i) = 2500 * (ABS(i - 10))
     PUT #1, , names(i): PUT #1, , scores(i)
  NEXT
ELSE
  FOR i = 0 TO 9
     GET #1, , names(i): GET #1, , scores(i)
  NEXT
END IF
     
CLOSE #1

IF newScore1& > scores(9) THEN
  CLS
  Center 85, "Player 1, you have a new high score.", font()
  Center 95, "Enter your name and be immortalized.", font()
  names(9) = GetString$(21, 90, 110, font())
  scores(9) = newScore1&: p1Place = 9

  DO WHILE LEN(names(9)) < 20: names(9) = names(9) + " ": LOOP

  FOR place = 9 TO 1 STEP -1
     IF scores(place) >= scores(place - 1) THEN
       SWAP scores(place), scores(place - 1)
       SWAP names(place), names(place - 1)
       p1Place = p1Place - 1
     ELSE
       EXIT FOR
     END IF
  NEXT

  KILL "mower.hi"
 
  OPEN "mower.hi" FOR BINARY AS #1
  FOR i = 0 TO 9
     PUT #1, , names(i): PUT #1, , scores(i)
  NEXT
  CLOSE #1
END IF

IF newScore2& > scores(9) THEN
  CLS
  Center 85, "Player 2, you have a new high score.", font()
  Center 95, "Enter your name and be immortalized.", font()
  names(9) = GetString$(21, 90, 110, font())
  scores(9) = newScore2&: p2Place = 9

  DO WHILE LEN(names(9)) < 20: names(9) = names(9) + " ": LOOP

  FOR place = 9 TO 1 STEP -1
     IF scores(place) >= scores(place - 1) THEN
       SWAP scores(place), scores(place - 1)
       SWAP names(place), names(place - 1)
       p2Place = p2Place - 1
     ELSE
       EXIT FOR
     END IF
  NEXT

  KILL "mower.hi"
 
  OPEN "mower.hi" FOR BINARY AS #1
  FOR i = 0 TO 9
     PUT #1, , names(i): PUT #1, , scores(i)
  NEXT
  CLOSE #1
END IF
                      
cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$

CLS
FOR x = 2 TO 310 STEP 15
   PUT (x, 4), graphic(98 * UFLOWER), PSET
   PUT (x, 184), graphic(98 * UFLOWER), PSET
NEXT
FOR y = 16 TO 183 STEP 12
   PUT (2, y), graphic(98 * UFLOWER), PSET
   PUT (302, y), graphic(98 * UFLOWER), PSET
NEXT

Center 30, "Top 10 Mowers", font()
FOR i = 0 TO 9
   scrStr$ = LTRIM$(RTRIM$(STR$(scores(i))))
   namStr$ = RTRIM$(names(i))
   IF p1Place = i THEN namStr$ = namStr$ + " (player 1)"
   IF p2Place = i THEN namStr$ = namStr$ + " (player 2)"
   tempStr$ = namStr$ + " - " + scrStr$
   Center 65 + i * 10, tempStr$, font()
NEXT i

FadeIn pal(), cRed$, cGreen$, cBlue$

DO: LOOP UNTIL INKEY$ <> ""
ClearKeys

END SUB

SUB InitColours (pal() AS Hues)

FileCheck "mower.pal"
OPEN "mower.pal" FOR BINARY AS #1
FOR i = 0 TO 255
   GET #1, , pal(i).red: GET #1, , pal(i).green: GET #1, , pal(i).blue
NEXT
CLOSE #1

SetColours pal(), 0, 255

END SUB

SUB InitGraphics (graphic(), background(), font(), mask())

FileCheck "mower.fnt"
DEF SEG = VARSEG(font(0))
BLOAD "mower.fnt", 0

Center 95, "Loading graphics", font()
Center 105, "Please wait", font()

FileCheck "grassunc.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "grassunc.pic", 0

FileCheck "grasscut.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "grasscut.pic", 196

FileCheck "flowers.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "flowers.pic", 196 * 2

FileCheck "flowersc.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "flowersc.pic", 196 * 3

FileCheck "manl1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manl1.pic", 196 * 4

FileCheck "manl2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manl2.pic", 196 * 5

FileCheck "manu1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manu1.pic", 196 * 6

FileCheck "manu2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manu2.pic", 196 * 7

FileCheck "manr1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manr1.pic", 196 * 8

FileCheck "manr2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "manr2.pic", 196 * 9

FileCheck "mand1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "mand1.pic", 196 * 10

FileCheck "wall.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "wall.pic", 196 * 11

FileCheck "fencev.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "fencev.pic", 196 * 12

FileCheck "fenceh.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "fenceh.pic", 196 * 13

FileCheck "fenced.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "fenced.pic", 196 * 14

FileCheck "hole.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "hole.pic", 196 * 15

FileCheck "dogsr.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogsr.pic", 196 * 16

FileCheck "dogsl.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogsl.pic", 196 * 17

FileCheck "dogmrd.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmrd.pic", 196 * 18

FileCheck "dogmld.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmld.pic", 196 * 19

FileCheck "dogmru.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmru.pic", 196 * 20

FileCheck "dogmlu.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "dogmlu.pic", 196 * 21

FileCheck "womand1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womand1.pic", 196 * 22

FileCheck "womand2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womand2.pic", 196 * 23

FileCheck "womanr1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanr1.pic", 196 * 24

FileCheck "womanr2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanr2.pic", 196 * 25

FileCheck "womanl1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanl1.pic", 196 * 26

FileCheck "womanl2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanl2.pic", 196 * 27

FileCheck "womanu1.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanu1.pic", 196 * 28

FileCheck "womanu2.pic"
DEF SEG = VARSEG(graphic(0))
BLOAD "womanu2.pic", 196 * 29

FileCheck "back.pic"
DEF SEG = VARSEG(background(0))
BLOAD "back.pic", 0

FileCheck "mower.msk"
DEF SEG = VARSEG(mask(0))
BLOAD "mower.msk", 0

END SUB

' Based on code by Steven Sensarn.  I rewrote the assembly portion.
SUB InstallISR

DIM SGL AS INTEGER, SGH AS INTEGER              'Segment of keyboard()
DIM OFL AS INTEGER, OFH AS INTEGER              'Offset of keyboard()

DIM BYTE AS STRING * 1

STATIC ASM AS STRING                            'Holds machine code for ISR

SGL = VARSEG(keyboard(0)) AND &HFF              'Get low byte of segment
SGH = INT(VARSEG(keyboard(0)) / 256) AND &HFF   'Get high byte of segment

OFL = VARPTR(keyboard(0)) AND &HFF              'Get low byte of offset
OFH = INT(VARPTR(keyboard(0)) / 256) AND &HFF   'Get high byte of offset

'Assembly code for the ISR.

ASM = ""
ASM = ASM + CHR$(&H52)                          'PUSH DX
ASM = ASM + CHR$(&H51)                          'PUSH CX
ASM = ASM + CHR$(&H53)                          'PUSH BX
ASM = ASM + CHR$(&H50)                          'PUSH AX
ASM = ASM + CHR$(&H1E)                          'PUSH DS
ASM = ASM + CHR$(&H56)                          'PUSH SI
ASM = ASM + CHR$(&HFB)                          'STI
ASM = ASM + CHR$(&HE4) + CHR$(&H60)             'IN   AL,60h
ASM = ASM + CHR$(&H30) + CHR$(&HE4)             'XOR  AH,AH
ASM = ASM + CHR$(&HB1) + CHR$(&H7F)             'MOV  CL,7Fh
ASM = ASM + CHR$(&H88) + CHR$(&HC3)             'MOV  BL,AL
ASM = ASM + CHR$(&H20) + CHR$(&HCB)             'AND  BL,CL
ASM = ASM + CHR$(&HBA) + CHR$(SGL) + CHR$(SGH)  'MOV  DX,SEG keyboard()
ASM = ASM + CHR$(&H8E) + CHR$(&HDA)             'MOV  DS,DX
ASM = ASM + CHR$(&HB1) + CHR$(&H80)             'MOV  CL,80h
ASM = ASM + CHR$(&H20) + CHR$(&HC8)             'AND  AL,CL
ASM = ASM + CHR$(&H30) + CHR$(&HFF)             'XOR  BH,BH
ASM = ASM + CHR$(&HBE) + CHR$(OFL) + CHR$(OFH)  'MOV  SI,OFFSET keyboard()
ASM = ASM + CHR$(&H1) + CHR$(&HDE)              'ADD  SI,BX
ASM = ASM + CHR$(&H88) + CHR$(&H4)              'MOV  [SI],AL
ASM = ASM + CHR$(&HE4) + CHR$(&H61)             'IN   AL,61h
ASM = ASM + CHR$(&H80) + CHR$(&HCC) + CHR$(&H82)'OR   AH,82h
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL
ASM = ASM + CHR$(&H24) + CHR$(&H7F)             'AND  AL,7Fh
ASM = ASM + CHR$(&HE6) + CHR$(&H61)             'OUT  61h,AL
ASM = ASM + CHR$(&HB0) + CHR$(&H20)             'MOV  AL,20h
ASM = ASM + CHR$(&HE6) + CHR$(&H20)             'OUT  20h,AL
ASM = ASM + CHR$(&H5E)                          'POP  SI
ASM = ASM + CHR$(&H1F)                          'POP  DS
ASM = ASM + CHR$(&H58)                          'POP  AX
ASM = ASM + CHR$(&H5B)                          'POP  BX
ASM = ASM + CHR$(&H59)                          'POP  CX
ASM = ASM + CHR$(&H5A)                          'POP  DX
ASM = ASM + CHR$(&HCF)                          'IRET
      
BYTE = CHR$(INP(&H21))
  
OUT &H21, (ASC(BYTE) AND (255 XOR 2))           'Clear bit 2 (irq 1)

CALL GetVect(oldKeyIntSeg, oldKeyIntOff, &H9)   'Save old ISR address
CALL SetVect(VARSEG(ASM), SADD(ASM), &H9)       'Load new ISR address

DEF SEG = VARSEG(keyboard(0))
FOR i = 0 TO 127: POKE i, 128: NEXT i    'Initialize the flags

END SUB

SUB Instructions (font(), pal() AS Hues)

cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$

CLS
Center 10, "The object of mower is to mow all the", font()
Center 20, "grass on each level.  Uncut grass is", font()
Center 30, "dark green, cut grass is light green.", font()
Center 40, "When all grass is cut, you advance to", font()
Center 50, "the next level.  Watch out for dogs that", font()
Center 60, "bound across the screen, if one catches", font()
Center 70, "you, you lose a life, and you only have", font()
Center 80, "three.  Also, try not to mow fences and", font()
Center 90, "flower gardens, you will lose points", font()
Center 100, "if you do.  When you mow flowers an", font()
Center 110, "angry woman will come running after you,", font()
Center 120, "watch she doesn't catch you.  Also, watch", font()
Center 130, "you don't step in a hole, you will die.", font()
Center 140, "In Mower, you will be awarded an extra", font()
Center 150, "life first at 10000 points, then at", font()
Center 160, "20000, 40000, 80000, and then every 40000", font()
Center 170, "points after that.", font()
Center 190, "Press a key", font()

FadeIn pal(), cRed$, cGreen$, cBlue$

DO: LOOP UNTIL INKEY$ <> ""
ClearKeys

cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$

CLS
Center 10, "Controls", font()
Center 30, "Use the arrow keys to move yourself", font()
Center 40, "around the screen.", font()
Center 50, "To pause, hold down Alt and press P,", font()
Center 60, "to continue your game press any key.", font()
Center 70, "If you want to quit at any time in the", font()
Center 80, "game, press Esc.", font()
Center 100, "How to play two player games", font()
Center 120, "Select the two player game option at the", font()
Center 130, "intro screen (press 2).  Player 1 goes", font()
Center 140, "first and then player 2 follows when", font()
Center 150, "player 1 dies.  The current player is", font()
Center 160, "displayed at the top of the screen under", font()
Center 170, "the level name", font()
Center 190, "Press a key", font()

FadeIn pal(), cRed$, cGreen$, cBlue$

DO: LOOP UNTIL INKEY$ <> ""
ClearKeys

cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$

CLS
Center 10, "Playing custom levels", font()
Center 30, "Custom levels can be designed by you in", font()
Center 40, "the level editor provided with Mower.", font()
Center 50, "To play one, select option 5 from the", font()
Center 60, "intro screen and then select the level", font()
Center 70, "you want to play in the file open", font()
Center 80, "window.  The level is then played like", font()
Center 90, "any other, and when finished you will", font()
Center 100, "be prompted for another level to play.", font()
Center 110, "Custom games do not count in the high", font()
Center 120, "scores.", font()
Center 190, "Press a key", font()

FadeIn pal(), cRed$, cGreen$, cBlue$

DO: LOOP UNTIL INKEY$ <> ""
ClearKeys

END SUB

SUB Intro (graphic(), font(), numPlayers, pal() AS Hues, mask(), custLevel$, startLevel)

DO
  cRed$ = "": cGreen$ = "": cBlue$ = ""
  FadeOut pal(), cRed$, cGreen$, cBlue$

  CLS
  FOR y = 0 TO 150 STEP 12
     FOR x = 2 TO 310 STEP 15
        IF x = 2 OR y = 0 OR x = 302 OR y = 144 THEN
          PUT (x, y), graphic(98 * UFLOWER), PSET
        ELSE
          PUT (x, y), graphic(98 * UGRASS), PSET
        END IF
     NEXT
  NEXT

  FOR y = 25 TO 125 STEP 12
     PUT (15, y), mask(98 * MVFENCE), AND
     PUT (15, y), graphic(98 * VFENCE), XOR
     PUT (60, y), mask(98 * MVFENCE), AND
     PUT (60, y), graphic(98 * VFENCE), XOR
     PUT (195, y), mask(98 * MVFENCE), AND
     PUT (195, y), graphic(98 * VFENCE), XOR
     PUT (245, y), mask(98 * MVFENCE), AND
     PUT (245, y), graphic(98 * VFENCE), XOR
  NEXT

  FOR x = 30 TO 45 STEP 15
     PUT (x, 25), mask(98 * MHFENCE), AND
     PUT (x, 25), graphic(98 * HFENCE), XOR
  NEXT

  FOR y = 37 TO 60 STEP 12
     PUT (37, y), mask(98 * MVFENCE), AND
     PUT (37, y), graphic(98 * VFENCE), XOR
  NEXT

  FOR y = 37 TO 112 STEP 12
     PUT (80, y), mask(98 * MVFENCE), AND
     PUT (80, y), graphic(98 * VFENCE), XOR
     PUT (110, y), mask(98 * MVFENCE), AND
     PUT (110, y), graphic(98 * VFENCE), XOR
     PUT (130, y), mask(98 * MVFENCE), AND
     PUT (130, y), graphic(98 * VFENCE), XOR
     PUT (175, y), mask(98 * MVFENCE), AND
     PUT (175, y), graphic(98 * VFENCE), XOR
     IF y <> 73 THEN
       PUT (290, y), mask(98 * MVFENCE), AND
       PUT (290, y), graphic(98 * VFENCE), XOR
     END IF
  NEXT

  PUT (95, 25), mask(98 * MHFENCE), AND
  PUT (95, 25), graphic(98 * HFENCE), XOR
  PUT (95, 121), mask(98 * MHFENCE), AND
  PUT (95, 121), graphic(98 * HFENCE), XOR
  
  PUT (130, 25), mask(98 * MVFENCE), AND
  PUT (130, 25), graphic(98 * VFENCE), XOR
  PUT (175, 25), mask(98 * MVFENCE), AND
  PUT (175, 25), graphic(98 * VFENCE), XOR

  FOR x = 145 TO 174 STEP 15
     PUT (x, 121), mask(98 * MHFENCE), AND
     PUT (x, 121), graphic(98 * HFENCE), XOR
  NEXT
  
  FOR y = 97 TO 109 STEP 12
     PUT (152, y), mask(98 * MVFENCE), AND
     PUT (152, y), graphic(98 * VFENCE), XOR
  NEXT

  FOR x = 210 TO 225 STEP 15
     PUT (x, 25), mask(98 * MHFENCE), AND
     PUT (x, 25), graphic(98 * HFENCE), XOR
     IF x = 210 THEN
       PUT (x, 73), mask(98 * MHFENCE), AND
       PUT (x, 73), graphic(98 * HFENCE), XOR
     END IF
     PUT (x, 121), mask(98 * MHFENCE), AND
     PUT (x, 121), graphic(98 * HFENCE), XOR
  NEXT

  FOR x = 260 TO 275 STEP 15
     PUT (x, 25), mask(98 * MHFENCE), AND
     PUT (x, 25), graphic(98 * HFENCE), XOR
     PUT (x, 73), mask(98 * MHFENCE), AND
     PUT (x, 73), graphic(98 * HFENCE), XOR
  NEXT

  PUT (290, 121), mask(98 * MVFENCE), AND
  PUT (290, 121), graphic(98 * VFENCE), XOR

  Center 160, "1. One player game       2. Two player game", font()
  Center 170, "3. View high scores      4. Instructions   ", font()
  Center 180, "5. Load custom level     6. Quit           ", font()
 
  FadeIn pal(), cRed$, cGreen$, cBlue$

  DO
    DO: a$ = INKEY$: LOOP UNTIL a$ <> ""
  LOOP UNTIL ASC(a$) >= 49 AND ASC(a$) <= 54
 
  SELECT CASE a$
         CASE "1"
             numPlayers = 1: custLevel$ = "": startLevel = 1: EXIT DO
         CASE "2"
             numPlayers = 2: custLevel$ = "": startLevel = 1: EXIT DO
         CASE "3"
             HighScores 0, 0, graphic(), font(), pal()
         CASE "4"
             Instructions font(), pal()
         CASE "5"
             numPlayers = 1
             custLevel$ = GetOpenFileName$
             IF custLevel$ <> "" THEN
               startLevel = 0
               EXIT DO
             END IF
         CASE "6"
             cRed$ = "": cGreen$ = "": cBlue$ = ""
             FadeOut pal(), cRed$, cGreen$, cBlue$
             CLS
             FadeIn pal(), cRed$, cGreen$, cBlue$
             SCREEN 0: WIDTH 80: SYSTEM
  END SELECT
LOOP

END SUB

SUB LoadLevel (board(), timeLimit, plyr() AS PlayerStuff, cur, uGrassCount, lName$, maxDogs, custLevel$)

DIM char AS STRING * 1

IF plyr(cur).level = 0 THEN
  level$ = LTRIM$(RTRIM$(custLevel$))
  IF RIGHT$(level$, 1) = CHR$(0) THEN level$ = LEFT$(level$, LEN(level$) - 1)
ELSE
  level$ = LTRIM$(RTRIM$(STR$(plyr(cur).level)))
  IF LEN(level$) = 1 THEN level$ = "00" + level$
  IF LEN(level$) = 2 THEN level$ = "0" + level$
  level$ = "mower" + level$ + ".lvl"
END IF

Decode level$, "~level.tmp"

OPEN "~level.tmp" FOR BINARY AS #1

FOR i = 0 TO 11
   FOR j = 0 TO 19
      GET #1, , char
      board(j, i) = ASC(char) - 48
      IF board(j, i) = 0 THEN Add1 uGrassCount
   NEXT j
NEXT i

tempStr$ = ""
FOR i = 0 TO 2
   GET #1, , char
   tempStr$ = tempStr$ + char
NEXT i
timeLimit = VAL(tempStr$)

tempStr$ = ""
FOR i = 0 TO 1
   GET #1, , char
   tempStr$ = tempStr$ + char
NEXT i
plyr(cur).brdX = VAL(tempStr$)
plyr(cur).scrX = 10 + 15 * plyr(cur).brdX

tempStr$ = ""
FOR i = 0 TO 1
   GET #1, , char
   tempStr$ = tempStr$ + char
NEXT i
plyr(cur).brdY = VAL(tempStr$)
plyr(cur).scrY = 51 + 12 * plyr(cur).brdY

board(plyr(cur).brdX, plyr(cur).brdY) = 1
uGrassCount = uGrassCount - 1

GET #1, , char
maxDogs = VAL(char) - 1

DO
  GET #1, , char
  IF char = CHR$(13) THEN EXIT DO
  lName$ = lName$ + char
LOOP

CLOSE #1
KILL "~level.tmp"

END SUB

SUB NewWoman (x, y, dir, board())

y = 0
DO: x = INT(RND * 20): LOOP UNTIL board(x, y) < 2

DO
  tryAgain = 0
  dir = INT(RND * 3) + 1
  IF dir = 2 THEN dir = 4
  IF dir = 1 THEN
    IF x = 0 THEN
      tryAgain = 1
    ELSEIF board(x - 1, y) > 1 THEN
      tryAgain = 1
    END IF
  END IF
  IF dir = 3 THEN
    IF x = 19 THEN
      tryAgain = 1
    ELSEIF board(x + 1, y) > 1 THEN
      tryAgain = 1
    END IF
  END IF
  IF dir = 4 AND board(x, y + 1) > 1 THEN tryAgain = 1
LOOP WHILE tryAgain

END SUB

SUB PlayMower (plyr() AS PlayerStuff, graphic(), background(), numPlayers, font(), pal() AS Hues, mask(), custLevel$, startLevel)

DIM board(19, 11)

DIM curDog(4)
DIM cDog(4)
DIM dogBrdX(4)
DIM dogBrdY(4)
DIM dogScrX(4)
DIM dogScrY(4)
DIM dogStartTime!(4)
DIM dogStatus(4)
DIM dogDir(4)
DIM dogOldDir(4)
DIM dogMoving(4)
DIM dogRunAway(4)
DIM dogRunAwayDir(4)

FOR i = 1 TO numPlayers
   plyr(i).lives = 3
   plyr(i).score = 0
   plyr(i).level = startLevel
   plyr(i).dir = 4
   plyr(i).moving = 0
   plyr(i).frame = 1
   plyr(i).fCount = 0
   plyr(i).nextUp = 10000
NEXT

cur = 1: numLevels = 20
ClearKeys

DO
  uGrassCount = 0: lName$ = ""
  LoadLevel board(), timeLimit, plyr(), cur, uGrassCount, lName$, maxDogs, custLevel$
  IF oldKeyIntSeg <> 0 OR oldKeyIntOff <> 0 THEN
    SetVect oldKeyIntSeg, oldKeyIntOff, &H9
    oldKeyIntSeg = 0: oldKeyIntOff = 0
  END IF
  DrawLevel board(), graphic(), background(), pal(), plyr(), cur, mask(), font(), lName$
  ClearKeys
  InstallISR
 
  cLevel = 1: cLives = 1: cScore = 1: cTime = 1: cMan = 0: cGrss = 0
  isDead = 0: curWoman = 0: cWoman = 0

  FOR i = 0 TO maxDogs
     curDog(i) = 0: cDog(i) = 0: dogOldDir(i) = 0: dogRunAway(i) = 0
  NEXT

  lastTicked! = TIMER
  DO
    IF cLevel = 1 THEN
      LINE (47, 0)-(61, 9), 0, BF
      tempStr$ = LTRIM$(RTRIM$(STR$(plyr(cur).level)))
      IF plyr(cur).level = 0 THEN tempStr$ = "custom"
      IF LEN(tempStr$) = 1 THEN tempStr$ = " " + tempStr$
      GPrint tempStr$, 47, 0, font()
      cLevel = 0
    END IF
    IF cLives = 1 THEN
      LINE (47, 10)-(61, 19), 0, BF
      tempStr$ = LTRIM$(RTRIM$(STR$(plyr(cur).lives)))
      IF LEN(tempStr$) = 1 THEN tempStr$ = " " + tempStr$
      GPrint tempStr$, 47, 10, font()
      cLives = 0
    END IF
    IF cScore = 1 THEN
      LINE (271, 0)-(314, 9), 0, BF
      tempStr$ = LTRIM$(RTRIM$(STR$(plyr(cur).score)))
      WHILE (LEN(tempStr$) < 6): tempStr$ = " " + tempStr$: WEND
      GPrint tempStr$, 272, 0, font()
      cScore = 0
    END IF
    IF cTime = 1 THEN
      LINE (279, 10)-(314, 19), 0, BF
      tempStr$ = LTRIM$(RTRIM$(STR$(timeLimit)))
      WHILE (LEN(tempStr$) < 6): tempStr$ = " " + tempStr$: WEND
      GPrint tempStr$, 272, 10, font()
      cTime = 0
    END IF
 
    Clock timeLimit, lastTicked!, cTime
    IF timeLimit < 0 THEN isDead = 1
   
    FOR t& = 1 TO compSpeed&: NEXT t&
    DEF SEG = VARSEG(keyboard(0))
    IF PEEK(72) = 0 THEN
      IF plyr(cur).brdY <> 0 THEN
        IF board(plyr(cur).brdX, plyr(cur).brdY - 1) <> 4 THEN
          IF plyr(cur).moving = 0 THEN
            plyr(cur).dir = 2: plyr(cur).moving = 1: plyr(cur).fCount = 1
          END IF
        END IF
      END IF
    END IF
    IF PEEK(75) = 0 THEN
      IF plyr(cur).brdX <> 0 THEN
        IF board(plyr(cur).brdX - 1, plyr(cur).brdY) <> 4 THEN
          IF plyr(cur).moving = 0 THEN
            plyr(cur).dir = 1: plyr(cur).moving = 1: plyr(cur).fCount = 1
          END IF
        END IF
      END IF
    END IF
    IF PEEK(77) = 0 THEN
      IF plyr(cur).brdX <> 19 THEN
        IF board(plyr(cur).brdX + 1, plyr(cur).brdY) <> 4 THEN
          IF plyr(cur).moving = 0 THEN
            plyr(cur).dir = 3: plyr(cur).moving = 1: plyr(cur).fCount = 1
          END IF
        END IF
      END IF
    END IF
    IF PEEK(80) = 0 THEN
      IF plyr(cur).brdY <> 11 THEN
        IF board(plyr(cur).brdX, plyr(cur).brdY + 1) <> 4 THEN
          IF plyr(cur).moving = 0 THEN
            plyr(cur).dir = 4: plyr(cur).moving = 1: plyr(cur).fCount = 1
          END IF
        END IF
      END IF
    END IF
    IF PEEK(1) = 0 THEN
      isDead = 1: plyr(cur).lives = 1
      IF numPlayers = 2 THEN
        IF cur = 1 THEN plyr(2).lives = 0 ELSE plyr(1).lives = 0
      END IF
    END IF
    IF PEEK(&H19) = 0 AND PEEK(&H38) = 0 THEN
      DO: LOOP UNTIL PEEK(&H19) <> 0 AND PEEK(&H38) <> 0
      DO
        FOR i = 0 TO 127
           IF PEEK(i) = 0 THEN EXIT FOR
        NEXT
      LOOP UNTIL i < 128
    END IF

    oldX = plyr(cur).brdX: oldY = plyr(cur).brdY: oldDir = plyr(cur).dir
    IF plyr(cur).moving = 1 THEN
      cMan = 1
      IF plyr(cur).fCount = 3 THEN
        plyr(cur).fCount = 1
        IF plyr(cur).dir = 4 THEN
          plyr(cur).frame = 1
        ELSE
          IF plyr(cur).frame = 1 THEN plyr(cur).frame = 2 ELSE plyr(cur).frame = 1
        END IF
      END IF
    
      SELECT CASE plyr(cur).dir
             CASE 1
                 plyr(cur).scrX = plyr(cur).scrX - 1
                 IF board(plyr(cur).brdX - 1, plyr(cur).brdY) = 0 THEN
                   plyr(cur).score = plyr(cur).score + 4: cScore = 1
                 ELSEIF board(plyr(cur).brdX - 1, plyr(cur).brdY) = 2 THEN
                   plyr(cur).score = plyr(cur).score - 4: cScore = 1
                   IF curWoman = 0 THEN
                     NewWoman womanBrdX, womanBrdY, womanDir, board()
                     womanScrX = 10 + 15 * womanBrdX
                     womanScrY = 51 + 12 * womanBrdY
                     womanFrame = 1: womanFrameCtr = 1: curWoman = 1
                     cWoman = 1: womanTime = 1
                     startWomanTime! = TIMER
                     womanMoving = 1: womanRunAway = 0
                   ELSE
                     womanTime = womanTime + 1
                   END IF
                 ELSEIF board(plyr(cur).brdX - 1, plyr(cur).brdY) = 5 OR board(plyr(cur).brdX - 1, plyr(cur).brdY) = 6 THEN
                   plyr(cur).score = plyr(cur).score - 8
                   cScore = 1
                 END IF

                 IF plyr(cur).scrX = 10 + 15 * (plyr(cur).brdX - 1) THEN
                   cGrss = 1
                   plyr(cur).brdX = plyr(cur).brdX - 1
                   IF board(plyr(cur).brdX, plyr(cur).brdY) = 9 THEN isDead = 1
                   plyr(cur).fCount = 0: plyr(cur).moving = 0
                 END IF
             CASE 2
                 plyr(cur).scrY = plyr(cur).scrY - 1
                 IF board(plyr(cur).brdX, plyr(cur).brdY - 1) = 0 THEN
                   plyr(cur).score = plyr(cur).score + 5
                   cScore = 1
                 ELSEIF board(plyr(cur).brdX, plyr(cur).brdY - 1) = 2 THEN
                   plyr(cur).score = plyr(cur).score - 5
                   cScore = 1
                   IF curWoman = 0 THEN
                     NewWoman womanBrdX, womanBrdY, womanDir, board()
                     womanScrX = 10 + 15 * womanBrdX
                     womanScrY = 51 + 12 * womanBrdY
                     womanFrame = 1: womanFrameCtr = 1: curWoman = 1
                     cWoman = 1: womanTime = 1
                     startWomanTime! = TIMER
                     womanMoving = 1: womanRunAway = 0
                   ELSE
                     womanTime = womanTime + 1
                   END IF
                 ELSEIF board(plyr(cur).brdX, plyr(cur).brdY - 1) = 5 OR board(plyr(cur).brdX, plyr(cur).brdY - 1) = 6 THEN
                   plyr(cur).score = plyr(cur).score - 10
                   cScore = 1
                 END IF

                 IF plyr(cur).scrY = 51 + 12 * (plyr(cur).brdY - 1) THEN
                   cGrss = 1
                   plyr(cur).brdY = plyr(cur).brdY - 1
                   IF board(plyr(cur).brdX, plyr(cur).brdY) = 9 THEN isDead = 1
                   plyr(cur).fCount = 0: plyr(cur).moving = 0
                 END IF
             CASE 3
                 Add1 plyr(cur).scrX
                 IF board(plyr(cur).brdX + 1, plyr(cur).brdY) = 0 THEN
                   plyr(cur).score = plyr(cur).score + 4
                   cScore = 1
                 ELSEIF board(plyr(cur).brdX + 1, plyr(cur).brdY) = 2 THEN
                   plyr(cur).score = plyr(cur).score - 4
                   cScore = 1
                   IF curWoman = 0 THEN
                     NewWoman womanBrdX, womanBrdY, womanDir, board()
                     womanScrX = 10 + 15 * womanBrdX
                     womanScrY = 51 + 12 * womanBrdY
                     womanFrame = 1: womanFrameCtr = 1: curWoman = 1
                     cWoman = 1: womanTime = 1
                     startWomanTime! = TIMER
                     womanMoving = 1: womanRunAway = 0
                   ELSE
                     womanTime = womanTime + 1
                   END IF
                 ELSEIF board(plyr(cur).brdX + 1, plyr(cur).brdY) = 5 OR board(plyr(cur).brdX + 1, plyr(cur).brdY) = 6 THEN
                   plyr(cur).score = plyr(cur).score - 8
                   cScore = 1
                 END IF

                 IF plyr(cur).scrX = 10 + 15 * (plyr(cur).brdX + 1) THEN
                   cGrss = 1
                   Add1 plyr(cur).brdX
                   IF board(plyr(cur).brdX, plyr(cur).brdY) = 9 THEN isDead = 1
                   plyr(cur).fCount = 0: plyr(cur).moving = 0
                 END IF
             CASE 4
                 Add1 plyr(cur).scrY
                 IF board(plyr(cur).brdX, plyr(cur).brdY + 1) = 0 THEN
                   plyr(cur).score = plyr(cur).score + 5
                   cScore = 1
                 ELSEIF board(plyr(cur).brdX, plyr(cur).brdY + 1) = 2 THEN
                   plyr(cur).score = plyr(cur).score - 5
                   cScore = 1
                   IF curWoman = 0 THEN
                     NewWoman womanBrdX, womanBrdY, womanDir, board()
                     womanScrX = 10 + 15 * womanBrdX
                     womanScrY = 51 + 12 * womanBrdY
                     womanFrame = 1: womanFrameCtr = 1: curWoman = 1
                     cWoman = 1: womanTime = 1
                     startWomanTime! = TIMER
                     womanMoving = 1: womanRunAway = 0
                   ELSE
                     womanTime = womanTime + 1
                   END IF
                 ELSEIF board(plyr(cur).brdX, plyr(cur).brdY + 1) = 5 OR board(plyr(cur).brdX, plyr(cur).brdY + 1) = 6 THEN
                   plyr(cur).score = plyr(cur).score - 10
                   cScore = 1
                 END IF

                 IF plyr(cur).scrY = 51 + 12 * (plyr(cur).brdY + 1) THEN
                   cGrss = 1
                   Add1 plyr(cur).brdY
                   IF board(plyr(cur).brdX, plyr(cur).brdY) = 9 THEN isDead = 1
                   plyr(cur).fCount = 0: plyr(cur).moving = 0
                 END IF
      END SELECT
      Add1 plyr(cur).fCount
    END IF
   
    IF plyr(cur).score >= plyr(cur).nextUp THEN
      Add1 plyr(cur).lives
      cLives = 1
      IF plyr(cur).nextUp < 80000 THEN
        plyr(cur).nextUp = plyr(cur).nextUp * 2
      ELSE
        plyr(cur).nextUp = plyr(cur).nextUp + 40000
      END IF
    END IF
   
    FOR i = 0 TO maxDogs
       IF curDog(i) = 0 THEN
         rndDog = INT(RND * 250)
         IF rndDog = 0 THEN
           curDog(i) = 1: dogBrdX(i) = INT(RND * 20): dogBrdY(i) = 0
           dogScrX(i) = 10 + dogBrdX(i) * 15
           dogScrY(i) = 51 + dogBrdY(i) * 12
           dogStartTime!(i) = TIMER
           dogStatus(i) = 1: dogDir(i) = 0: dogMoving(i) = 0
           dogRunAway(i) = 0: cDog(i) = 1
         END IF
       ELSEIF curDog(i) = 1 THEN
         curTime! = TIMER
         IF (curTime! > dogStartTime!(i) + 15) AND dogRunAway(i) = 0 THEN
           dogRunAway(i) = 1: dogRunAwayDir(i) = INT(RND * 4): cDog(i) = 1
         ELSEIF dogMoving(i) = 0 THEN
           rndDog = INT(RND * 40)
           IF rndDog = 0 THEN
             dogDir(i) = INT(RND * 6)
             IF dogDir(i) = 0 AND dogBrdX(i) <> 19 AND dogBrdY(i) <> 11 THEN
               dogStatus(i) = 3: dogMoving(i) = 1
               dogScrX(i) = dogScrX(i) + 4
               Add1 dogScrY(i): cDog(i) = 1
             ELSEIF dogDir(i) = 1 AND dogBrdX(i) <> 0 AND dogBrdY(i) <> 11 THEN
               dogStatus(i) = 4: dogMoving(i) = 1
               dogScrX(i) = dogScrX(i) - 4
               Add1 dogScrY(i): cDog(i) = 1
             ELSEIF dogDir(i) = 2 AND dogBrdX(i) <> 19 AND dogBrdY(i) <> 0 THEN
               dogStatus(i) = 5: dogMoving(i) = 1
               dogScrX(i) = dogScrX(i) + 4
               dogScrY(i) = dogScrY(i) - 1
               cDog(i) = 1
             ELSEIF dogDir(i) = 3 AND dogBrdX(i) <> 0 AND dogBrdY(i) <> 0 THEN
               dogStatus(i) = 6: dogMoving(i) = 1
               dogScrX(i) = dogScrX(i) - 4
               dogScrY(i) = dogScrY(i) - 1
               cDog(i) = 1
             ELSE
               IF plyr(cur).brdX > dogBrdX(i) THEN
                 IF plyr(cur).brdY > dogBrdY(i) THEN
                   IF dogBrdX(i) <> 19 AND dogBrdY(i) <> 11 THEN
                     dogDir(i) = 0: dogStatus(i) = 3: dogMoving(i) = 1
                     dogScrX(i) = dogScrX(i) + 4
                     Add1 dogScrY(i)
                   END IF
                 ELSE
                   IF dogBrdX <> 19 AND dogBrdY(i) <> 0 THEN
                     dogDir(i) = 2: dogStatus(i) = 5: dogMoving(i) = 1
                     dogScrX(i) = dogScrX(i) + 4
                     dogScrY(i) = dogScrY(i) - 1
                   END IF
                 END IF
               ELSE
                 IF plyr(cur).brdY > dogBrdY(i) THEN
                   IF dogBrdX(i) <> 0 AND dogBrdY(i) <> 11 THEN
                     dogDir(i) = 1: dogStatus(i) = 4: dogMoving(i) = 1
                     dogScrX(i) = dogScrX(i) - 4
                     Add1 dogScrY(i)
                     cDog(i) = 1
                   END IF
                 ELSE
                   IF dogBrdX(i) <> 0 AND dogBrdY(i) <> 0 THEN
                     dogDir(i) = 3: dogStatus(i) = 6: dogMoving(i) = 1
                     dogScrX(i) = dogScrX(i) - 4
                     dogScrY(i) = dogScrY(i) - 1
                     cDog(i) = 1
                   END IF
                 END IF
               END IF
             END IF
           END IF
         ELSEIF dogMoving(i) = 1 THEN
           IF dogDir(i) = 0 THEN
             Add1 dogScrX(i): Add1 dogScrY(i)
             cDog(i) = 1
             IF dogScrX(i) = 10 + 15 * (dogBrdX(i) + 1) THEN
               dogMoving(i) = 0: dogStatus(i) = 1: dogDir(i) = 0
               dogOldDir(i) = 1: Add1 dogBrdX(i): Add1 dogBrdY(i)
               IF dogBrdX(i) = plyr(cur).brdX AND dogBrdY(i) = plyr(cur).brdY THEN isDead = 1
             END IF
           ELSEIF dogDir(i) = 1 THEN
             dogScrX(i) = dogScrX(i) - 1: Add1 dogScrY(i)
             cDog(i) = 1
             IF dogScrX(i) = 10 + 15 * (dogBrdX(i) - 1) THEN
               dogMoving(i) = 0: dogStatus(i) = 2: dogDir(i) = 0
               dogOldDir(i) = 2: dogBrdX(i) = dogBrdX(i) - 1: Add1 dogBrdY(i)
               IF dogBrdX(i) = plyr(cur).brdX AND dogBrdY(i) = plyr(cur).brdY THEN isDead = 1
             END IF
           ELSEIF dogDir(i) = 2 THEN
             Add1 dogScrX(i): dogScrY(i) = dogScrY(i) - 1
             cDog(i) = 1
             IF dogScrX(i) = 10 + 15 * (dogBrdX(i) + 1) THEN
               dogMoving(i) = 0: dogStatus(i) = 1: dogDir(i) = 0
               dogOldDir(i) = 3
               Add1 dogBrdX(i): dogBrdY(i) = dogBrdY(i) - 1
               IF dogBrdX(i) = plyr(cur).brdX AND dogBrdY(i) = plyr(cur).brdY THEN isDead = 1
             END IF
           ELSEIF dogDir(i) = 3 THEN
             dogScrX(i) = dogScrX(i) - 1: dogScrY(i) = dogScrY(i) - 1
             cDog(i) = 1
             IF dogScrX(i) = 10 + 15 * (dogBrdX(i) - 1) THEN
               dogMoving(i) = 0: dogStatus(i) = 2: dogDir(i) = 0
               dogOldDir(i) = 4
               dogBrdX(i) = dogBrdX(i) - 1: dogBrdY(i) = dogBrdY(i) - 1
               IF dogBrdX(i) = plyr(cur).brdX AND dogBrdY(i) = plyr(cur).brdY THEN isDead = 1
             END IF
           END IF
         END IF
         IF dogRunAway(i) THEN
           IF dogMoving(i) = 0 THEN
             dogDir(i) = dogRunAwayDir(i)
             dogStatus(i) = dogDir(i) + 3
             dogMoving(i) = 1
             IF dogDir(i) = 0 OR dogDir(i) = 2 THEN
               IF dogBrdX(i) = 19 THEN
                 curDog(i) = 0: dogStatus(i) = 1: dogMoving(i) = 0
               ELSE
                 dogScrX(i) = dogScrX(i) + 4
               END IF
             ELSE
               IF dogBrdX(i) = 0 THEN
                 curDog(i) = 0: dogStatus(i) = 2: dogMoving(i) = 0
               ELSE
                 dogScrX(i) = dogScrX(i) - 4
               END IF
             END IF
             IF curDog(i) = 1 THEN
               IF dogDir(i) = 0 OR dogDir(i) = 1 THEN
                 IF dogBrdY(i) = 11 THEN
                   curDog(i) = 0: dogStatus(i) = dogDir(i) + 1: dogMoving(i) = 0
                 ELSE
                   Add1 dogScrY(i)
                 END IF
               ELSE
                 IF dogBrdY(i) = 0 THEN
                   curDog(i) = 0: dogStatus(i) = dogDir(i) - 1: dogMoving(i) = 0
                 ELSE
                   dogScrY(i) = dogScrY(i) - 1
                 END IF
               END IF
             END IF
             cDog(i) = 1
           END IF
         END IF
       END IF
    NEXT
   
    IF curWoman THEN
      Clock womanTime, startWomanTime!, garbage
      IF womanTime < 0 AND womanMoving = 0 THEN
        womanRunAway = 1: womanDir = 2
        IF womanBrdY = 0 THEN
          curWoman = 0: cWoman = 1
        END IF
      END IF

      IF womanMoving = 1 THEN
        Add1 womanFrameCtr
        IF womanFrameCtr = 4 THEN
          womanFrameCtr = 1
          IF womanFrame = 1 THEN womanFrame = 2 ELSE womanFrame = 1
        END IF

        SELECT CASE womanDir
               CASE 1
                   womanScrX = womanScrX - 1: cWoman = 1
                   IF womanScrX = 10 + 15 * (womanBrdX - 1) THEN
                     womanMoving = 0: womanJustStopped = 1: womanBrdX = womanBrdX - 1
                     IF womanBrdX = plyr(cur).brdX AND womanBrdY = plyr(cur).brdY THEN isDead = 1
                   END IF
               CASE 2
                   womanScrY = womanScrY - 1: cWoman = 1
                   IF womanScrY = 51 + 12 * (womanBrdY - 1) THEN
                     womanMoving = 0: womanJustStopped = 1: womanBrdY = womanBrdY - 1
                     IF womanBrdX = plyr(cur).brdX AND womanBrdY = plyr(cur).brdY THEN isDead = 1
                   END IF
               CASE 3
                   Add1 womanScrX: cWoman = 1
                   IF womanScrX = 10 + 15 * (womanBrdX + 1) THEN
                     womanMoving = 0: womanJustStopped = 1: Add1 womanBrdX
                     IF womanBrdX = plyr(cur).brdX AND womanBrdY = plyr(cur).brdY THEN isDead = 1
                   END IF
               CASE 4
                   Add1 womanScrY: cWoman = 1
                   IF womanScrY = 51 + 12 * (womanBrdY + 1) THEN
                     womanMoving = 0: womanJustStopped = 1: Add1 womanBrdY
                     IF womanBrdX = plyr(cur).brdX AND womanBrdY = plyr(cur).brdY THEN isDead = 1
                   END IF
        END SELECT
      ELSEIF womanRunAway = 1 THEN
        womanScrY = womanScrY - 1
        IF womanScrY = 51 + 12 * (womanBrdY - 1) THEN
          womanBrdY = womanBrdY - 1: womanJustStopped = 1
          IF womanBrdX = plyr(cur).brdX AND womanBrdY = plyr(cur).brdY THEN isDead = 1
          IF womanBrdY = 0 THEN
            curWoman = 0: cWoman = 1
          END IF
        END IF
      ELSEIF womanMoving = 0 THEN
        womanMoving = 1
        DO
          tryAgain = 0
          womanDir = INT(RND * 8) + 1
          IF womanDir = 5 OR womanDir = 6 THEN
            IF womanBrdX > plyr(cur).brdX THEN womanDir = 1 ELSE womanDir = 3
          ELSEIF womanDir = 7 OR womanDir = 8 THEN
            IF womanBrdY > plyr(cur).brdY THEN womanDir = 2 ELSE womanDir = 4
          END IF
          IF womanDir = 1 THEN
            IF womanBrdX = 0 THEN
              tryAgain = 1
            ELSEIF board(womanBrdX - 1, womanBrdY) > 1 THEN
              tryAgain = 1
            END IF
          END IF
          IF womanDir = 2 THEN
            IF womanBrdY = 0 THEN
              tryAgain = 1
            ELSEIF board(womanBrdX, womanBrdY - 1) > 1 THEN
              tryAgain = 1
            END IF
          END IF
          IF womanDir = 3 THEN
            IF womanBrdX = 19 THEN
              tryAgain = 1
            ELSEIF board(womanBrdX + 1, womanBrdY) > 1 THEN
              tryAgain = 1
            END IF
          END IF
          IF womanDir = 4 THEN
            IF womanBrdY = 11 THEN
              tryAgain = 1
            ELSEIF board(womanBrdX, womanBrdY + 1) > 1 THEN
              tryAgain = 1
            END IF
          END IF
        LOOP WHILE tryAgain
      END IF
    END IF

    IF cGrss THEN
      cGrss = 0
      SELECT CASE board(plyr(cur).brdX, plyr(cur).brdY)
             CASE 0
                 board(plyr(cur).brdX, plyr(cur).brdY) = 1
                 PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * CGRASS), PSET
                 uGrassCount = uGrassCount - 1
             CASE 2
                 board(plyr(cur).brdX, plyr(cur).brdY) = 3
                 PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * CFLOWER), PSET
             CASE 5 TO 6
                 board(plyr(cur).brdX, plyr(cur).brdY) = 7
                 PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * CGRASS), PSET
                 PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MDFENCE), AND
                 PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * DFENCE), XOR
      END SELECT
    END IF
    
    IF cMan THEN
      cMan = 0
      IF oldX = plyr(cur).brdX AND oldY = plyr(cur).brdY THEN
        IF board(oldX, oldY) < 4 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * board(oldX, oldY)), PSET
        ELSEIF board(oldX, oldY) = 4 OR board(oldX, oldY) = 8 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * WALL), PSET
        ELSEIF board(oldX, oldY) = 7 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * CGRASS), PSET
          PUT (10 + 15 * oldX, 51 + 12 * oldY), mask(98 * MDFENCE), AND
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * DFENCE), XOR
        ELSEIF board(oldX, oldY) = 9 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * UGRASS), PSET
          PUT (10 + 15 * oldX, 51 + 12 * oldY), mask(98 * MHOLE), AND
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * HOLE), XOR
        END IF

        SELECT CASE plyr(cur).dir
               CASE 1: oldX = oldX - 1
               CASE 2: oldY = oldY - 1
               CASE 3: Add1 oldX
               CASE 4: Add1 oldY
        END SELECT
       
        IF board(oldX, oldY) < 4 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * board(oldX, oldY)), PSET
        ELSEIF board(oldX, oldY) = 4 OR board(oldX, oldY) = 8 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * WALL), PSET
        ELSEIF board(oldX, oldY) = 7 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * CGRASS), PSET
          PUT (10 + 15 * oldX, 51 + 12 * oldY), mask(98 * MDFENCE), AND
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * DFENCE), XOR
        ELSEIF board(oldX, oldY) = 9 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * UGRASS), PSET
          PUT (10 + 15 * oldX, 51 + 12 * oldY), mask(98 * MHOLE), AND
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * HOLE), XOR
        END IF
      ELSE
        IF board(oldX, oldY) < 4 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * board(oldX, oldY)), PSET
        ELSEIF board(oldX, oldY) = 4 OR board(oldX, oldY) = 8 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * WALL), PSET
        ELSEIF board(oldX, oldY) = 7 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * CGRASS), PSET
          PUT (10 + 15 * oldX, 51 + 12 * oldY), mask(98 * MDFENCE), AND
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * DFENCE), XOR
        ELSEIF board(oldX, oldY) = 9 THEN
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * UGRASS), PSET
          PUT (10 + 15 * oldX, 51 + 12 * oldY), mask(98 * MHOLE), AND
          PUT (10 + 15 * oldX, 51 + 12 * oldY), graphic(98 * HOLE), XOR
        END IF
      END IF
      RestorePlayer oldDir, plyr(), cur, graphic(), mask()
    END IF

    FOR i = 0 TO maxDogs
       IF cDog(i) THEN
         IF dogStatus(i) = 1 OR dogStatus(i) = 2 THEN
           RedrawLand dogBrdX(i), dogBrdY(i), board(dogBrdX(i), dogBrdY(i)), graphic(), mask()
           IF curDog(i) THEN
             IF dogStatus(i) = 1 THEN PUT (dogScrX(i), dogScrY(i)), mask(98 * MDOGSR), AND
             IF dogStatus(i) = 2 THEN PUT (dogScrX(i), dogScrY(i)), mask(98 * MDOGSL), AND
             PUT (dogScrX(i), dogScrY(i)), graphic(98 * (DOGSR + dogStatus(i) - 1)), XOR
           END IF
         ELSEIF dogStatus(i) = 3 THEN
           RedrawLand dogBrdX(i), dogBrdY(i), board(dogBrdX(i), dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i) + 1, dogBrdY(i), board(dogBrdX(i) + 1, dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i), dogBrdY(i) + 1, board(dogBrdX(i), dogBrdY(i) + 1), graphic(), mask()
           RedrawLand dogBrdX(i) + 1, dogBrdY(i) + 1, board(dogBrdX(i) + 1, dogBrdY(i) + 1), graphic(), mask()
           IF dogBrdX(i) + 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           IF curDog(i) THEN
             PUT (dogScrX(i), dogScrY(i)), mask(98 * MDOGMRD), AND
             PUT (dogScrX(i), dogScrY(i)), graphic(98 * DOGMRD), XOR
           END IF
         ELSEIF dogStatus(i) = 4 THEN
           RedrawLand dogBrdX(i), dogBrdY(i), board(dogBrdX(i), dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i) - 1, dogBrdY(i), board(dogBrdX(i) - 1, dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i), dogBrdY(i) + 1, board(dogBrdX(i), dogBrdY(i) + 1), graphic(), mask()
           RedrawLand dogBrdX(i) - 1, dogBrdY(i) + 1, board(dogBrdX(i) - 1, dogBrdY(i) + 1), graphic(), mask()
           IF dogBrdX(i) - 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           IF curDog(i) THEN
             PUT (dogScrX(i), dogScrY(i)), mask(98 * MDOGMLD), AND
             PUT (dogScrX(i), dogScrY(i)), graphic(98 * DOGMLD), XOR
           END IF
         ELSEIF dogStatus(i) = 5 THEN
           RedrawLand dogBrdX(i), dogBrdY(i), board(dogBrdX(i), dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i) + 1, dogBrdY(i), board(dogBrdX(i) + 1, dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i), dogBrdY(i) - 1, board(dogBrdX(i), dogBrdY(i) - 1), graphic(), mask()
           RedrawLand dogBrdX(i) + 1, dogBrdY(i) - 1, board(dogBrdX(i) + 1, dogBrdY(i) - 1), graphic(), mask()
           IF dogBrdX(i) + 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           IF curDog(i) THEN
             PUT (dogScrX(i), dogScrY(i)), mask(98 * MDOGMRU), AND
             PUT (dogScrX(i), dogScrY(i)), graphic(98 * DOGMRU), XOR
           END IF
         ELSEIF dogStatus(i) = 6 THEN
           RedrawLand dogBrdX(i), dogBrdY(i), board(dogBrdX(i), dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i) - 1, dogBrdY(i), board(dogBrdX(i) - 1, dogBrdY(i)), graphic(), mask()
           RedrawLand dogBrdX(i), dogBrdY(i) - 1, board(dogBrdX(i), dogBrdY(i) - 1), graphic(), mask()
           RedrawLand dogBrdX(i) - 1, dogBrdY(i) - 1, board(dogBrdX(i) - 1, dogBrdY(i) - 1), graphic(), mask()
           IF dogBrdX(i) - 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           IF curDog(i) THEN
             PUT (dogScrX(i), dogScrY(i)), mask(98 * MDOGMLU), AND
             PUT (dogScrX(i), dogScrY(i)), graphic(98 * DOGMLU), XOR
           END IF
         END IF
         IF dogOldDir(i) = 1 THEN
           RedrawLand dogBrdX(i) - 1, dogBrdY(i), board(dogBrdX(i) - 1, dogBrdY(i)), graphic(), mask()
           IF dogBrdX(i) + 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           dogOldDir(i) = 0
         ELSEIF dogOldDir(i) = 2 THEN
           RedrawLand dogBrdX(i) + 1, dogBrdY(i), board(dogBrdX(i) + 1, dogBrdY(i)), graphic(), mask()
           IF dogBrdX(i) - 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) + 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           dogOldDir(i) = 0
         ELSEIF dogOldDir(i) = 3 THEN
           RedrawLand dogBrdX(i), dogBrdY(i) + 1, board(dogBrdX(i), dogBrdY(i) + 1), graphic(), mask()
           IF dogBrdX(i) + 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           dogOldDir(i) = 0
         ELSEIF dogOldDir(i) = 4 THEN
           RedrawLand dogBrdX(i), dogBrdY(i) + 1, board(dogBrdX(i), dogBrdY(i) + 1), graphic(), mask()
           RedrawLand dogBrdX(i) + 1, dogBrdY(i) + 1, board(dogBrdX(i) + 1, dogBrdY(i) + 1), graphic(), mask()
           IF dogBrdX(i) - 1 = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           ELSEIF dogBrdX(i) = plyr(cur).brdX THEN
             IF dogBrdY(i) = plyr(cur).brdY OR dogBrdY(i) - 1 = plyr(cur).brdY THEN
               RestorePlayer oldDir, plyr(), cur, graphic(), mask()
             END IF
           END IF
           dogOldDir(i) = 0
         END IF
         cDog(i) = 0
       END IF
    NEXT

    IF cWoman THEN
      RedrawLand womanBrdX, womanBrdY, board(womanBrdX, womanBrdY), graphic(), mask()
      SELECT CASE womanDir
             CASE 1
                 IF womanJustStopped THEN
                   RedrawLand womanBrdX + 1, womanBrdY, board(womanBrdX + 1, womanBrdY), graphic(), mask()
                   justStopped = 0
                 ELSE
                   RedrawLand womanBrdX - 1, womanBrdY, board(womanBrdX - 1, womanBrdY), graphic(), mask()
                 END IF
                 IF curWoman THEN
                   PUT (womanScrX, womanScrY), mask(98 * (MWOMANL1 + womanFrame - 1)), AND
                   PUT (womanScrX, womanScrY), graphic(98 * (WOMANL1 + womanFrame - 1)), XOR
                 END IF
             CASE 2
                 IF womanJustStopped THEN
                   RedrawLand womanBrdX, womanBrdY + 1, board(womanBrdX, womanBrdY + 1), graphic(), mask()
                   womanJustStopped = 0
                 ELSE
                   IF womanBrdY > 0 THEN RedrawLand womanBrdX, womanBrdY - 1, board(womanBrdX, womanBrdY - 1), graphic(), mask()
                 END IF
                 IF curWoman THEN
                   PUT (womanScrX, womanScrY), mask(98 * (MWOMANU1 + womanFrame - 1)), AND
                   PUT (womanScrX, womanScrY), graphic(98 * (WOMANU1 + womanFrame - 1)), XOR
                 END IF
             CASE 3
                 IF womanJustStopped THEN
                   RedrawLand womanBrdX - 1, womanBrdY, board(womanBrdX - 1, womanBrdY), graphic(), mask()
                   womanJustStopped = 0
                 ELSE
                   RedrawLand womanBrdX + 1, womanBrdY, board(womanBrdX + 1, womanBrdY), graphic(), mask()
                 END IF
                 IF curWoman THEN
                   PUT (womanScrX, womanScrY), mask(98 * (MWOMANR1 + womanFrame - 1)), AND
                   PUT (womanScrX, womanScrY), graphic(98 * (WOMANR1 + womanFrame - 1)), XOR
                 END IF
             CASE 4
                 IF womanJustStopped THEN
                   IF womanBrdY > 0 THEN RedrawLand womanBrdX, womanBrdY - 1, board(womanBrdX, womanBrdY - 1), graphic(), mask()
                   womanJustStopped = 0
                 ELSE
                   RedrawLand womanBrdX, womanBrdY + 1, board(womanBrdX, womanBrdY + 1), graphic(), mask()
                 END IF
                 IF curWoman THEN
                   PUT (womanScrX, womanScrY), mask(98 * (MWOMAND1 + womanFrame - 1)), AND
                   PUT (womanScrX, womanScrY), graphic(98 * (WOMAND1 + womanFrame - 1)), XOR
                 END IF
      END SELECT
    END IF
  LOOP UNTIL uGrassCount = 0 OR isDead = 1

  plyr(cur).dir = 4: plyr(cur).moving = 0: plyr(cur).frame = 1: plyr(cur).fCount = 0

  IF uGrassCount = 0 THEN
    EndLevel pal(), plyr(cur).level, font(), plyr(cur).score, timeLimit
    IF plyr(cur).level > 0 THEN
      Add1 plyr(cur).level
      IF plyr(cur).level > numLevels THEN plyr(cur).level = numLevels
    ELSE
      SetVect oldKeyIntSeg, oldKeyIntOff, &H9
      oldKeyIntSeg = 0: oldKeyIntOff = 0
      custLevel$ = GetOpenFileName$
      IF custLevel$ = "" THEN EXIT DO
      ClearKeys
      InstallISR
    END IF
  ELSEIF isDead = 1 THEN
    plyr(cur).lives = plyr(cur).lives - 1
    IF plyr(cur).lives = 0 THEN
      IF numPlayers = 1 THEN EXIT DO
      IF cur = 1 THEN
        IF plyr(2).lives = 0 THEN EXIT DO
      ELSE
        IF plyr(1).lives = 0 THEN EXIT DO
      END IF
    END IF
    IF numPlayers = 2 THEN
      IF cur = 1 THEN
        IF plyr(2).lives > 0 THEN cur = 2
      ELSE
        IF plyr(1).lives > 0 THEN cur = 1
      END IF
    END IF
  END IF
LOOP

SetVect oldKeyIntSeg, oldKeyIntOff, &H9
oldKeyIntSeg = 0: oldKeyIntOff = 0

IF plyr(cur).level > 0 THEN
  IF numPlayers = 2 THEN
    HighScores plyr(1).score, plyr(2).score, graphic(), font(), pal()
  ELSE
    HighScores plyr(1).score, 0, graphic(), font(), pal()
  END IF
END IF

END SUB

SUB PreIntro (font(), pal() AS Hues)

cRed$ = "": cGreen$ = "": cBlue$ = ""
FadeOut pal(), cRed$, cGreen$, cBlue$

CLS
Center 95, "A Game by Aaron Severn", font()

FadeIn pal(), cRed$, cGreen$, cBlue$

ClearKeys
endTime! = TIMER + 2
DO: LOOP UNTIL TIMER > endTime! OR INKEY$ <> ""

END SUB

SUB RedrawLand (x, y, landType, graphic(), mask())

IF landType < 4 THEN
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * landType), PSET
ELSEIF landType = 4 OR landType = 8 THEN
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * WALL), PSET
ELSEIF landType > 4 AND landType < 7 THEN
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * UGRASS), PSET
  IF landType = 5 THEN PUT (10 + 15 * x, 51 + 12 * y), mask(98 * MVFENCE), AND
  IF landType = 6 THEN PUT (10 + 15 * x, 51 + 12 * y), mask(98 * MHFENCE), AND
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * (VFENCE + landType - 5)), XOR
ELSEIF landType = 7 THEN
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * CGRASS), PSET
  PUT (10 + 15 * x, 51 + 12 * y), mask(98 * MDFENCE), AND
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * DFENCE), XOR
ELSEIF landType = 9 THEN
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * UGRASS), PSET
  PUT (10 + 15 * x, 51 + 12 * y), mask(98 * MHOLE), AND
  PUT (10 + 15 * x, 51 + 12 * y), graphic(98 * HOLE), XOR
END IF

END SUB

SUB RestorePlayer (oldDir, plyr() AS PlayerStuff, cur, graphic(), mask())

IF oldDir = 1 AND plyr(cur).frame = 1 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMANL1), AND
IF oldDir = 1 AND plyr(cur).frame = 2 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMANL2), AND
IF oldDir = 2 AND plyr(cur).frame = 1 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMANU1), AND
IF oldDir = 2 AND plyr(cur).frame = 2 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMANU2), AND
IF oldDir = 3 AND plyr(cur).frame = 1 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMANR1), AND
IF oldDir = 3 AND plyr(cur).frame = 2 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMANR2), AND
IF oldDir = 4 THEN PUT (plyr(cur).scrX, plyr(cur).scrY), mask(98 * MMAND1), AND
PUT (plyr(cur).scrX, plyr(cur).scrY), graphic(98 * (4 + ((oldDir - 1) * 2) + (plyr(cur).frame - 1))), XOR

END SUB

SUB SetColours (pal() AS Hues, first, last)
  
OUT &H3C8, first
FOR i = first TO last
   OUT &H3C9, pal(i).red
   OUT &H3C9, pal(i).green
   OUT &H3C9, pal(i).blue
NEXT

END SUB

' Written by Steven Sensarn.
SUB SetVect (s, o, i)

    'SETVECT CHANGES THE ADDRESSES IN THE INTERRUPT VECTOR TABLE
    'TO POINT TO NEW FUNCTIONS

    STATIC ASM AS STRING 'HOLDS THE SETVECT FUNCTION
    STATIC INI AS INTEGER 'USED TO TEST WHETHER OR NOT FUNCTION HAS PREVOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN

        'CREATE FUNCTION IF NOT ALREADY CREATED

        ASM = ""
        ASM = ASM + CHR$(&H55)                          'PUSH BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV BX,[BP+08]
        ASM = ASM + CHR$(&H8B) + CHR$(&H17)             'MOV DX,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV AL,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV BX,[BP+0A]
        ASM = ASM + CHR$(&H1E)                          'PUSH DS
        ASM = ASM + CHR$(&H8E) + CHR$(&H1F)             'MOV DS,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H25)             'MOV AH,25
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT 21
        ASM = ASM + CHR$(&H1F)                          'POP DS
        ASM = ASM + CHR$(&H5D)                          'POP BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF 0006
        INI = 1 'FLAG CREATION
    END IF
    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(s, o, i, SADD(ASM)) 'RUN SETVECT

END SUB

