// **************************************************************************
// ********************** ஥ " 㦡 " **********************
// ********************** (C) Copper Feet Corp., 1998. **********************
// **************************************************************************

// ********* :  . .,  . .,  . . ***********

#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <stdlib.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <graphics.h>
#include <math.h>
#include <fcntl.h>
#include <sys\stat.h>

typedef unsigned char BYTE;
typedef unsigned int WORD;
typedef unsigned long DWORD;

#define PI 3.141592654

#define O_NORMAL 0
//  .
#define O_BOLD 1
//  .

// ࠬ :
#define LINE_STEP 15
#define FONT_HEIGHT 11
#define FONT_WIDTH 8

// । 梥⮢:
#define BLACK 0
#define DARKGRAY 1
#define GRAY 2
#define GREEN 3
#define DARKBLUE 4
#define BLUE 5
#define LIGHTBLUE 6
#define RED 7
#define YELLOW 8
#define WHITE 15

#define TESTCOLOR 14
// १ࢨ஢  ⮢ 梥. 室  ⬠ ண
// ।    ⨢  ५졥 (㦨 
// ᭥, 뫠  ᮢ 孮  ᥫ ⮢
// 梥).

#define BK 0
#define DG 1
#define GY 2
#define GR 3
#define DB 4
#define BU 5
#define LB 6
#define RD 7
#define YL 8
#define WH 15

#define SFILL SOLID_FILL
#define DFILL INTERLEAVE_FILL

// ⥬ ⠭  ஢ ࠡ  䨪:
#define EGA_GRAPHICS 0x3CE
#define EGA_SEQUENCER 0x3C4
#define EGA_BIT_MASK 8
#define EGA_MAP_MASK 2

// ᮪ , ᯮ ⮤  low_io:
#define UP_MASK 1
#define DOWN_MASK 2
#define LEFT_MASK 4
#define RIGHT_MASK 8
#define FORWARD_MASK 16
#define BACKWARD_MASK 32
#define FIRE_MASK 64
#define ENTER_MASK 128
#define ESC_MASK 256
#define F2_MASK 512
#define F3_MASK 1024

#define LEFT 2
#define RIGHT 3
#define ENTER 4
#define ESC 5
#define DEL 18
#define SPACE 19
#define BACKSPACE 20
#define TAB 30

// ᨬ쭮 ⢮   .
#define MAX_LINES 16

//  ࠧ塞 ⠡ ⥪饩  ꥪ.
#define SHARED_PNTS_NUM 32
#define SHARED_POLYS_NUM 20

#define ANGLES_NUM 256
// ⢮  㣫 .   ४!

#define OBJS_NUM 32
// ᨬ쭮 ⢮ ꥪ⮢ ஢ .

#define VISIBLE_RADIUS 1500*256L
//  ,  । ன ꥪ ਭ  .
#define DESTRUCTION_RADIUS 2000*256L
//  ,  । ன ꥪ ⠥ 騬.
#define FIRE_RADIUS 1300*256L
//  ,  । ன ꥪ  ५  襬 ࠡ.

#define ZN 20*256L
// ﭨ ⥫  窨 業 न (ࠢ  Z
// ࠭ ).
#define OBJ_Z_VISIBLE -5*256L
// 쭮 Z,  ஬ ꥪ  .
#define XSCALE 8.67*6
// 樥 ⠡஢  ࠦ  X.
#define YSCALE 6.0*6
// 樥 ⠡஢  ࠦ  Y.

#define MLS 60*32L
// MAX_LIN_SIZE - ᨬ쭮 ﭨ  - 窨 ꥪ
//   業. ᯮ  業 ࠭ ꥪ  ஬
// 祭.

#define X0 320
// न x 窨 業  ࠭.
#define Y0 120
// न y 窨 業  ࠭.

#define CLIP_ON 1
//  祭 ࠦ, 室  । .
#define CLIP_OFF 0
// ⪫祭 ० 祭 ࠦ, 室  । .

#define DUST_RADIUS 25*256L
//   ஭ 2*DUST_RADIUS ।⠢ ᮡ ࠭⢮
// 砩 롮 x,y-न 뫨    ᮧ.
#define DUST_Z0 60*256L
// Z-न 뫨    ᮧ.
#define DUST_Z_VISIBLE -19*256L
// 쭮 Z,  ஬ 뫨  .
#define RND_DUST_TABLE_SIZE 1024
//  ⠡ 砩 x,y-न 뫨    ᮧ.
#define DUSTIES_NUM 64
// ⢮ 뫨, ६   ࠭.

#define STARS_NUM 7
// ⢮ " ",  .

#define FIRE_DELAY_TIME 25L
// ६ ( ⠪ ⠩),  祭 ண  ୮
// ⨥  FIRE.
#define BEAM_VISIBLE_TIME 5L
// ६ ( ⠪ ⠩),  祭 ண  ᮢ뢠
//   ᫥   FIRE.

#define MAX_LT 1000*256L
// ᨬ쭠 ⥬ .
#define LT_DEC_STEP 150L
//  㬥襭 ⥬   祭  ⠪ ⠩.
#define LT_INC_STEP 41*256L
//  㢥祭 ⥬  ᫥  ५.
#define SHIELDS_DEC_STEP 19*256L
// 뢠  ࠭ 饣 祭 襣 ࠡ  ५졥
//  ࠡ ⨢.

#define NATIVE_WEAPONS 100*256L
//  襣 㦨.
#define NATIVE_SHIELDS 1000*256L
//  ⭮   襣 ࠭.
#define SHIELDS_INC_STEP 70L
//  ॣ樨 ⭮   襣 ࠭  祭 
// ⠪ ⠩.  ࠣ  ࠬ   ᫠ -  
// ॣ樨 ⭮   뢠 :-))

// ࠬ ᨫ 㦨  ࠣ.
#define WEAPONS1 100*256L
#define SHIELDS1 1200*256L
#define WEAPONS2 140*256L
#define SHIELDS2 2000*256L
#define WEAPONS3 120*256L
#define SHIELDS3 1800*256L

// ࠬ, ⭮騥  ⮫.
#define COLLISION_RADIUS 15*256L
//  ,  । ன ਭ ⮫ ꥪ⮢.
#define PRE_COLLISION_RADIUS 60*256L
//  ,  । ன ꥪ 稭 ᫥ 
// 㪫  ⮫.
#define COLLISION_DELAY_TIME 216L
// ஬⮪ ६ ᫥ ⮫,  祭 ண  ᫥騥
// ⮫  ॣ.
#define ENEMY_DEC_SHIELDS_AFTER_COLLISION 900*256L
// 뢠  ࠡ ⨢  ⮫.
#define NATIVE_DEC_SHIELDS_AFTER_COLLISION 1500*256L
// 뢠  襣 ࠡ  ⮫.

// ࠬ 뢮 ᮮ饭.
#define MESSAGE_VISIBLE_TIME 216L
// ६ ( ⠪ ⠩),  祭 ண  ࠭ 뢮 ⥪饥
// ᮮ饭.
#define MESSAGE_DELAY_TIME 144L
// ६ ( ⠪ ⠩),  祭 ண  ࠭ 뢮 ⥪饥
// ᮮ饭.

// ⨭ ࠬ.
#define HARMLESS 0
#define MOSTLY_HARMLESS 1
#define POOR 2
#define AVERAGE 3
#define ABOVE_AVERAGE 4
#define COMPETENT 5
#define DANGEROUS 6
#define ELITE 7

#define HARMLESS_CASH 0L
#define MOSTLY_HARMLESS_CASH 100L
#define POOR_CASH 250L
#define AVERAGE_CASH 625L
#define ABOVE_AVERAGE_CASH 1563L
#define COMPETENT_CASH 3906L
#define DANGEROUS_CASH 9765L
#define ELITE_CASH 24412L

// ⠭  cmdialog_io:
#define O_SAVE 1
#define O_LOAD 0
#define MAX_PATH 8
#define O_NODEF 0
#define O_DEF 1
#define ENTER_DELAY_TIME 144L
// ஬⮪ ६ ᫥ ⢥ত   cmdialog_handler(),
//  祭 ண  쭥訥   ENTER.
//    䫨  main_manager().

// । ࠬ  ࠡ.
#define VFB_LIMIT 30*256L
#define VUD_LIMIT 120*256L
#define VLR_LIMIT 60*256L

// ࠨ ࠬ  ࠡ.
signed long MAX_VFB=4*256L;
signed long VFB_STEP=18L;
signed long MAX_VUD=24*210L;
signed long VUD_INC_STEP=318L;
signed long VUD_DEC_STEP=128L;
signed long MAX_VLR=8*180L;
signed long VLR_INC_STEP=68L;
signed long VLR_DEC_STEP=27L;

int DELAY=1;
// ६ প ᫥ ४祭 ࠭.

long cdecl MIN_TIME_SLICE=1;
// 쭮 ६ ( ⠪ ⠩),  ஥ ॣ  .

BYTE upattern1[]=
//   ꥪ⮢  i-蠣.
{  0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55 };

BYTE upattern2[]=
//   ꥪ⮢  i+1-蠣.
{  0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA };

BYTE *upatterns[2]=
{  upattern1, upattern2 };

BYTE *upattern;
//  ⥪  (४砥  饫 ࠭).

// **************************************************************************
// *****  ஢ ᪮  ணࠬ - low_graph. *****
// **************************************************************************

// ***   . ***
   int font_options;
   // O_BOLD -  , O_NORMAL -  .
   BYTE cdecl pages_toggle;
   //  ࠭栬 ࠭.
   BYTE *charbuf;
   // , ᯮ㥬  뢮 ᨬ  ࠭.
   BYTE *linebuf;
   // , ᯮ㥬  뢮 ப  ࠭.
   BYTE *lenbuf;
   // , ᮤঠ騩  ᨬ ⥬ .
   extern "C" char *font;
   // ন ⥬ .
   int exit_flag;
   //  訡 ᮧ ꥪ  .
   char f_col, b_col;
   // ᯮ  ⮤ put_symbol(),put_string(),put_text().

class low_graph
//  ஢ 権  VGA-஬.
{
   public:

   // ***  . ***
   // : ᫨  ७ , ⮤ ।   ⨢,
   // ⠪   ⥭ ࠭.
   inline void save_sprite(char huge *ptr,int x,int y,int dx,int dy);
   inline void restore_sprite(char huge *ptr,int x,int y);
   inline void put_pixel(int x,int y, int c);
   inline void clear_screen(char color);
   void put_symbol(int x,int y,char symbol);
   void put_string(int x,int y,char *string);
   void put_undl_string(int x, int y, char *string);
   void put_text(int x,int y,char *text);
   int str_len(char *text);
   void h_line(int x,int y,int dx,char c);
   void v_line(int x,int y,int dy,char c);
   void box(int x, int y, int dx, int dy, char c);
   inline void clear_window(int x, int y, int dx, int dy, char c);
   inline int center_string(char *str);
   inline void write_reg(int base, int reg, int value);
   //   .
   void toggle_screen();
   // ४祭 ࠭ ࠭.
   void wait_beam();
   //  ⭮ 室 .
   void prepare_view();
   //  ⮢     뢮 । .
   // (⪠    뢮 ࠬ.)
   void redraw_3d(int x, int y, int dx, int dy);
   // ᮢ 㪫 ꥪ.
   void redraw_state_bar(int x, int y, int dx, int dy, char *text,
      char _b_col);
   // ᮢ  ﭨ. ᫨ text==NULL,    祣 
   // 뢮.
   void redraw_win(int x, int y, int dx, int dy, char *title);
   // ᮢ ࠧ .
   void init_graph();
   // 樠 ᪮ ० 640x350x16.
   void close_graph();
   // 饭  ⥪⮢ ०.
};

BYTE mask_table[9]=
{0,128,128+64,128+64+32,128+64+32+16,128+64+32+16+8,128+64+32+16+8+4,
128+64+32+16+8+4+2,128+64+32+16+8+4+2+1};

inline void low_graph::save_sprite(char huge *ptr,int x,int y,int dx,int dy)
{
   getimage(x,y,x+dx-1,y+dy-1,ptr);
}

inline void low_graph::restore_sprite(char huge *ptr,int x,int y)
{
   putimage(x,y,ptr,COPY_PUT);
}

BYTE pxlmask[8]=
{128,64,32,16,8,4,2,1};

inline void low_graph::put_pixel(int x,int y, int c)
{
   putpixel(x,y,c);
}

inline void low_graph::clear_screen(char color)
{
   setfillstyle(SOLID_FILL,color);
   bar(0,0,639,349);
}

void low_graph::h_line(int x,int y,int dx,char c)
{
   setcolor(c);
   line(x,y,x+dx-1,y);
}

void low_graph::v_line(int x,int y,int dy,char c)
{
   setcolor(c);
   line(x,y,x,y+dy-1);
}

void low_graph::put_symbol(int x,int y,char symbol)
{
   BYTE huge *dest_ptr=charbuf+4;
   BYTE huge *src_ptr=font+symbol*16;
   BYTE and_mask,xor_mask,f_bit,b_bit;
   int i, j;
   int shr;
   BYTE curr_char;
   if (font_options==O_NORMAL) shr=0; else shr=1;
   for (i=0; i<4; i++)
   {
      f_bit=f_col&pxlmask[4+i];
      b_bit=b_col&pxlmask[4+i];
      if (f_bit^b_bit) and_mask=0xFF; else and_mask=0x00;
      if (b_bit) xor_mask=0xFF; else xor_mask=0x00;
      for (j=0; j<FONT_HEIGHT; j++)
      {
         curr_char=((src_ptr[j]|(src_ptr[j]>>shr))&and_mask)^xor_mask;
         dest_ptr[(j<<2)+i]=curr_char;
      }
   }
   restore_sprite(charbuf,x,y);
}

void low_graph::put_string(int x,int y,char *string)
{
   int i=0,curr_x=x,len,add_len;
   if (font_options==O_NORMAL) add_len=0; else add_len=1;
   while (string[i])
   {
      put_symbol(curr_x,y,string[i]);
      len=lenbuf[string[i++]]+add_len;
      len-=(((len&8)>>3)&(len&1));
      curr_x+=len;
   }
}

void low_graph::put_undl_string(int x,int y,char *string)
{
   put_string(x,y,string);
   h_line(x,y+FONT_HEIGHT-1,str_len(string),f_col);
}

void low_graph::put_text(int x,int y,char *text)
{
   int curr_y=y,curr_x=0;
   while ((*text)!='\x0')
   {
      while (((linebuf[curr_x++]=*(text++))!='\n')&&
         linebuf[curr_x-1]);
      if (!linebuf[curr_x-1]) text--;
      linebuf[curr_x-1]='\x0';
      curr_x=0;
      put_string(x,curr_y,linebuf);
      curr_y+=LINE_STEP;
   }
}

int low_graph::str_len(char *text)
{

   int i=0,curr_len=0,len,add_len;
   if (font_options==O_NORMAL) add_len=0; else add_len=1;
   while (text[i])
   {
      len=lenbuf[text[i++]]+add_len;
      len-=(((len&8)>>3)&(len&1));
      curr_len+=len;
   }
   return curr_len;
}

void low_graph::box(int x, int y, int dx, int dy, char c)
{
  h_line(x,y,dx,c);
  h_line(x,y+dy-1,dx,c);
  v_line(x,y,dy,c);
  v_line(x+dx-1,y,dy,c);
}

inline void low_graph::clear_window(int x, int y, int dx, int dy, char c)
{
      setfillstyle(SOLID_FILL,c);
      bar(x,y,x+dx-1,y+dy-1);
}

inline int low_graph::center_string(char *str)
{
   return (640-str_len(str))>>1;
}

inline void low_graph::write_reg(int base, int reg, int value)
{
   outportb(base,reg);
   outportb(base+1,value);
}

void low_graph::toggle_screen()
{
   WORD i;
   upattern=upatterns[pages_toggle];
   pages_toggle^=1;
   setvisualpage(pages_toggle);
   setactivepage(pages_toggle^1);
   if (DELAY) delay(DELAY);
   return;
}

WORD cdecl save_ss;
WORD cdecl save_sp;
//  ࠭塞 ⥪. ᯮ 楤ன low_graph::prepare_view().

void low_graph::prepare_view()
{

   asm {
      mov al,byte ptr _pages_toggle
      or  al,al
      mov bx,0A000h
      jnz _main_scr
      mov bx,0A800h
   }
_main_scr:
   asm {
      mov _save_ss,ss
      mov _save_sp,sp
      mov al,8
      mov dx,03CEh
      out dx,al
      mov al,0FFh
      inc dx
      out dx,al
      mov al,2
      mov dx,03C4h
      out dx,al
      mov al,0Fh
      inc dx
      out dx,al
      cli
      mov ss,bx
      mov sp,04B00h
      mov cx,119
      mov ebx,001000000h
      mov dl,080h
   }
_pvloop:
   asm {
      mov eax,ebx
      push eax
      xor eax,eax
      push eax eax eax eax eax
      push eax eax eax eax eax
      push eax eax eax eax eax
      push eax eax eax
      mov al,dl
      push eax
      xor al,al

      mov eax,ebx
      push eax
      xor eax,eax
      push eax eax eax eax eax
      push eax eax eax eax eax
      push eax eax eax eax eax
      push eax eax eax
      mov al,dl
      push eax
      xor al,al
      loop _pvloop

      mov eax,ebx
      push eax
      xor eax,eax
      push eax eax eax eax eax
      push eax eax eax eax eax
      push eax eax eax eax eax
      push eax eax eax
      mov al,dl
      push eax
      xor al,al

      mov sp,_save_sp
      mov ss,_save_ss
      sti
   }
}

void low_graph::redraw_3d(int x, int y, int dx, int dy)
{
   clear_window(x,y,dx,dy,DARKGRAY);
   h_line(x,y+dy-1,dx,WHITE);
   v_line(x+dx-1,y,dy,WHITE);
   h_line(x+1,y+1,dx-3,GRAY);
   v_line(x+1,y+1,dy-3,GRAY);
   h_line(x+1,y+dy-2,dx-2,GRAY);
   v_line(x+dx-2,y+1,dy-2,GRAY);
   h_line(x,y,dx,BLACK);
   v_line(x,y,dy-1,BLACK);
}

void low_graph::redraw_state_bar(int x, int y, int dx, int dy,
   char *text, char _b_col)
{
   h_line(x,y,dx,BLACK);
   v_line(x,y,dy,BLACK);
   h_line(x,y+dy-1,dx,GRAY);
   v_line(x+dx-1,y,dy,GRAY);
   clear_window(x+1,y+1,dx-2,dy-2,_b_col);
   if (text==NULL) return;
   b_col=_b_col; f_col=WHITE;
   put_string(x+3,y+3,text);
}

void low_graph::redraw_win(int x, int y, int dx, int dy, char *title)
{
   redraw_3d(x,y,dx,dy);
   clear_window(x+4,y+4,dx-8,16,YELLOW);
   font_options=O_BOLD;
   b_col=YELLOW; f_col=BLACK;
   put_string(x+15,y+6,title);
   h_line(x,y,dx-1,DARKGRAY);
   putpixel(x+dx-1,y,WHITE);
   h_line(x,y-1,dx,DARKGRAY);
   v_line(x,y,dy-1,DARKGRAY);
   v_line(x-1,y-1,dy+1,DARKGRAY);
}

void low_graph::init_graph()
{
   // 樠 䨪.
   int gdriver=EGA, gmode=EGAHI, errorcode;
   errorcode = registerfarbgidriver(EGAVGA_driver_far);
   if (errorcode < 0)
   {
      clrscr();
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      exit_flag=1;
   }
   exit_flag=0;
   initgraph(&gdriver, &gmode, "");
   errorcode=graphresult();
   if (errorcode!=grOk)
   {
      clrscr();
      printf("low_graph::init_graph : %s\n", grapherrormsg(errorcode));
      exit_flag=1;
   }
   setlinestyle(SOLID_LINE,0xFF,1);
   pages_toggle=0;
   setvisualpage(0);
   setactivepage(1);
   // 뤥   㦥 ꥪ.
   charbuf=(BYTE *) farmalloc(imagesize(1,1,FONT_WIDTH,FONT_HEIGHT));
   linebuf=(BYTE *) farmalloc(256);
   lenbuf=(BYTE *) farmalloc(256);
   *((unsigned *) charbuf)=FONT_WIDTH-1;
   *(((unsigned *) charbuf)+1)=FONT_HEIGHT-1;
   // ᫥ ⠡  ᨬ.
   int i,j,blank_flag;
   BYTE huge *curr_ptr=font;
   BYTE mask;
   for (i=0; i<256; i++)
   {
      if (i==32)
      {
         lenbuf[i]=4;
         curr_ptr+=16;
         continue;
      }
      lenbuf[i]=1;
      mask=128;
      do
      {
         blank_flag=1;
         for (j=0; j<FONT_HEIGHT; j++)
         {
            if (curr_ptr[j]&mask)
            {
               blank_flag=0;
               break;
            }
         }
         if (!blank_flag) lenbuf[i]++;
         mask>>=1;
      } while ((!blank_flag) && (lenbuf[i]<=8));
      if (lenbuf[i]>8) lenbuf[i]=8;
      curr_ptr+=16;
   }
   // ⠭ .
   setpalette(BLACK,0x00);
   setpalette(DARKGRAY,0x38);
   setpalette(GRAY,0x07);
   setpalette(WHITE,0x3F);
   setpalette(GREEN,0x2A);
   setpalette(DARKBLUE,0x01);
   setpalette(BLUE,0x03);
   setpalette(LIGHTBLUE,0x1B);
   setpalette(RED,0x04);
   setpalette(YELLOW,0x0E);

   setpalette(TESTCOLOR,0x00);
}

void low_graph::close_graph()
{
   closegraph();
   farfree(charbuf);
   farfree(linebuf);
   farfree(lenbuf);
}

low_graph LG;
// ⢥ ꥪ  low_graph.

// **************************************************************************
// *******  ஢ 䥩᭮  ணࠬ low_io. *******
// **************************************************************************

// ***    ***

int command_mode;
// 뫠  ᯮ .
int command;
// ᫨ 뫠 ,   .

int char_mode;
//    ⨬ ᨬ  .
unsigned char ch;
// ᫨   ᨬ,   .

void far * cdecl old_int09h_vec;
//   ࠡ⪨ 뢠  .

BYTE cdecl scan_code;
// ᯮ  ஬ ࠡ⪨ 뢠  .
volatile WORD kbd_status;
// ﭨ  .
volatile WORD kbd_flags;
//  ⦠  .

WORD key_masks[256]=
// ᪨    kbd_status, kbd_flags.
{
   0x0000,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0080,0x0000,0x0040,0x0001,

   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0010,0x0000,0x0000,0x0002,0x0000,0x0000,
   0x0000,0x0004,0x0008,0x0000,0x0000,0x0000,0x0010,0x0000,
   0x0000,0x0020,0x0000,0x0000,0x0200,0x0400,0x0000,0x0000,

   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
};

void kbd_interrupt()
// ८।塞 ࠡ稪 뢠  .
{
   asm {
         push    ds
         push    ax
         push    bx
         mov     ax,DGROUP
         mov     ds,ax
         in      al,060h
         xor     ah,ah
         mov     bx,ax
         test    ax,128
         jne     short _unpressed
         shl     bx,1
         mov     ax,word ptr _key_masks[bx]
         or      word ptr _kbd_status,ax
         jmp     short _end
       }
   _unpressed:
   asm {
         and     bx,127
         shl     bx,1
         mov     ax,word ptr _key_masks[bx]
         or      word ptr _kbd_flags,ax
         xor     ax,0FFFFh
         and     word ptr _kbd_status,ax
       }
   _end:
   asm {
         in      al,061h
         mov     ah,al
         or      al,080h
         out     061h,al
         mov     al,ah
         out     061h,al
         mov     al,020h
         out     020h,al
         pop     bx
         pop     ax
         pop     ds
         iret
       }
}

typedef void (*INTERRUPT)();

const INTERRUPT cdecl new_int09h_vec=&kbd_interrupt;

class low_io
//  ஢ 権 ᪮ /뢮.
{
   public:
   // ***  . ***
   void reset_keyboard();
   // ⪠  .
   void kbd_input();
   // 뢠 ᨬ    ᯮ .
   void init_io();
   // 樠 ⮪ /뢮  .
   void close_io();
   // ⨥ ⮪ /뢮  .
};

void low_io::reset_keyboard()
{
   REGS regs;
   regs.h.ah = 0x0C;
   regs.h.al = 0x00;
   int86(0x21, &regs, &regs);
}

void low_io::kbd_input()
{
   int symbol_flag=0;
   unsigned char ch1,ch2;
   do
   {
      asm {
         mov ah,0x01
         int 0x16
         jz nosym
         mov word ptr symbol_flag,1
         jmp end
      }
      nosym:
      asm {
         mov word ptr symbol_flag,0
      }
      end:
      if (!symbol_flag) continue;
      asm {
         xor ah,ah
         int 0x16
         mov ch1,al
         mov ch2,ah
      }
      if (!ch1)
      {
         switch (ch2)
         {
            case 75:
               command_mode=1;
               command=LEFT;
               return;
            case 77:
               command_mode=1;
               command=RIGHT;
               return;
            case 83:
               command_mode=1;
               command=DEL;
               return;
         }
      }
      switch (ch1)
      {
         case 8:
            command_mode=1;
            command=BACKSPACE;
            return;
         case 9:
            command_mode=1;
            command=TAB;
            return;
         case 13:
            command_mode=1;
            command=ENTER;
            return;
         case 27:
            command_mode=1;
            command=ESC;
            return;
         case 32:
            command_mode=1;
            command=SPACE;
            return;
      }
      if (((ch1>=' ')&&(ch1<='~'))||
         ((ch1>='A')&&(ch1<='Z'))||((ch1>='a')&&(ch1<='z')))
      {
         char_mode=1;
         ch=ch1;
         return;
      }
   }
   while (1);
}

void low_io::init_io()
{
   reset_keyboard();
   kbd_status=0;
   kbd_flags=0;
   asm {
      push ds
      mov ah,035h
      mov al,09h
      int 021h
      mov word ptr _old_int09h_vec, bx
      mov word ptr _old_int09h_vec[2], es
      lds dx, _new_int09h_vec
      mov ah,025h
      mov al,09h
      int 021h
      pop ds
   }
}

void low_io::close_io()
{
   asm {
      push ds
      lds dx, _old_int09h_vec
      mov ah,025h
      mov al,09h
      int 021h
      pop ds
   }
   reset_keyboard();
}

low_io LI;
// ⢥ ꥪ  low_io.

// **************************************************************************
// *************  権  ⠩஬  㪮 low_timer. **************
// **************************************************************************

// ***    ***

void far * cdecl old_int08h_vec;
//   ࠡ⪨ 뢠  ⠩.

volatile BYTE cdecl tick;
// ᪠ ६ - 稪 ⠪⮢ ⠩.  
// 짮⥫. ᯮ  맮 ண ࠡ稪 뢠
//  ⠩.  室  ࠭ ⥬ ६.

volatile DWORD cdecl time_counter;
// 稪 ⠪⮢ ⠩. 騢   72 ࠧ  ᥪ㭤.
//  ணࠬ  , . . ᯮ  ࠧ塞 
// ᪮쪨 ணࠬ묨 ꥪ⠬.

struct SAMPLE
//  ⥩襣 㪮 .
{
   WORD size;
   //  㪮  - ⢮   .  
   // ந뢠 뢠  ⠩  1/72 ᥪ㭤.
   const WORD *sample;
   // ᫥⥫쭮 , ⠢ . ଠ   
   // 뢠  ଠ, ਣ  ।⢥ 뤠  
   // ⠩.
};

// ᠭ 䥪 #1 - ⮣ ५, ந 訬 ࠡ.
const WORD sample1[]=
{
   1700,0,1700,0,1700
};
SAMPLE sfx1={ 5, sample1 };

// ᠭ 䥪 #2 - ५  , ந 訬
// ࠡ.
const WORD sample2[]=
{
   32000,20000,32000,20000,32000,1700,8000,1700,8000,1700
};
SAMPLE sfx2={ 10, sample2 };

// ᠭ 䥪 #3 -    ࠡ.
const WORD sample3[]=
{
   32000,20000,32000,20000,32000,3700,8000,3700,8000,3700
};
SAMPLE sfx3={ 10, sample3 };

// ᠭ 䥪 #4 - ᮯ஢ 뢮 ᮮ饭.
const WORD sample4[]=
{
   900,900
};
SAMPLE sfx4={ 2, sample4 };

// ᠭ 䥪 #5 - ⮫ ࠡ.
const WORD sample5[]=
{
   14000,12000,10000,9000,9500,
   10000,11000,12000,13000,14000,15000,16000,17000,
   18000,0,20000,0,22000,0,24000

};
SAMPLE sfx5={ 19, sample5 };

// ᠭ 䥪 #6 - 㭨⮦ 襣 ࠡ. :-(
const WORD sample6[]=
{
   1*0x0100,2*0x0100,3*0x0100,4*0x0100,
   5*0x0100,6*0x0100,7*0x0100,8*0x0100,
   9*0x0100,10*0x0100,11*0x0100,12*0x0100,
   13*0x0100,14*0x0100,15*0x0100,16*0x0100,
   17*0x0100,18*0x0100,19*0x0100,20*0x0100,
   21*0x0100,22*0x0100,23*0x0100,24*0x0100,
   25*0x0100,26*0x0100,27*0x0100,28*0x0100,
   29*0x0100,30*0x0100,31*0x0100,32*0x0100
};
SAMPLE sfx6={ 32, sample6 };

// ᠭ 䥪 #7 - 㭨⮦ ࠡ ⨢. :-(
const WORD sample7[]=
{
   14000,12000,10000,9000,9500,
   10000,10250,10500,10750,11000,11250,11500,11750,12000,12250,12500,
   13000,13500,14000,14500,
   15000,16000,17000,
   18000,0,20000,0,22000,0,24000
};
SAMPLE sfx7={ 29, sample7 };


BYTE cdecl sounds_flag;
// ⠭  ᠬ 砫 . 1 - 㪨   ࠧ襭, 0 - .
//   짮⥫ 㪨    ⪫ (ࠬ 
// ப "-nosound").
volatile BYTE cdecl sfx_status;
//  ந뢠 㪮 䥪  ⥪騩  ६.
// 1 -  騩  ந뢠 䥪 curr_sfx, 0 - .
SAMPLE cdecl curr_sfx;
// 騩 ந뢠 䥪.
volatile WORD cdecl sfx_counter;
//  ந뢠 .

void timer_interrupt()
// ८।塞 ࠡ稪 뢠  ⠩.
{
   asm {
         push ds
         push ax
         mov ax,DGROUP
         mov ds,ax

         mov al,byte ptr _sfx_status
         or al,al
         jz _no_sound
         mov al,byte ptr _sounds_flag
         or al,al
         jz _no_sound

         mov ax,word ptr _sfx_counter
         cmp ax,word ptr _curr_sfx
         jl _play_sound

         in al,061h
         and al,0FCh
         out 061h,al
         xor al,al
         mov byte ptr _sfx_status,al
         jmp short _no_sound
       }
_play_sound:
   asm {
         mov al,0B6h
         out 043h,al
         push bx
         mov bx,word ptr _curr_sfx[2]
         add bx,word ptr _sfx_counter
         add bx,word ptr _sfx_counter
         mov al,byte ptr [bx]
         out 042h,al
         mov al,byte ptr [bx+1]
         out 042h,al
         in al,061h
         or al,03h
         out 061h,al
         inc word ptr _sfx_counter
         pop bx
       }
_no_sound:
   asm {
         inc dword ptr _time_counter
         mov al, byte ptr _tick
         inc al
         and al,03h
         mov byte ptr _tick, al
         jnz _end
         pop ax
         pop ds
         sub sp,4
         push ds
         push ax
         mov ax,DGROUP
         mov ds,ax
         mov ax,word ptr _old_int08h_vec[2]
         add sp,8
         push ax
         mov ax,word ptr _old_int08h_vec
         push ax
         sub sp,4
         pop ax
         pop ds
         ret
       }
_end:
   asm {
         mov     al,020h
         out     020h,al
         pop     ax
         pop     ds
         iret
       }
}

const INTERRUPT cdecl new_int08h_vec=&timer_interrupt;

class low_timer
//  ஢ 権  ⠩஬.
{
   public:
   // ***  . ***
   void init_timer();
   // 樠 ᮢ ⠩.
   void close_timer();
   // ⨥ ᮢ ⠩.
};

void low_timer::init_timer()
{
   tick=0;
   time_counter=1000L;
   sfx_status=0;
   //   ।  騢 祭 ⥬
   // ६.
   asm {
      push ds
      xor ax,ax
      mov ds,ax
      mov si,046Ch
      mov ebx,[si]
   }
_wait_int08h:
   asm {
      mov eax,[si]
      cmp eax,ebx
      jz _wait_int08h
      pop ds
   }

   asm {
      push ds
      mov al,03Ch
      out 043h,al
      mov al,0FFh
      out 040h,al
      mov al,03Fh
      out 040h,al

      mov ah,035h
      mov al,08h
      int 021h
      mov word ptr _old_int08h_vec, bx
      mov word ptr _old_int08h_vec[2], es
      lds dx, _new_int08h_vec
      mov ah,025h
      mov al,08h
      int 021h
      pop ds
   }
}

void low_timer::close_timer()
{
   //   ।  騢 祭 ⥬
   // ६.
   asm {
      push ds
      xor ax,ax
      mov ds,ax
      mov si,046Ch
      mov ebx,[si]
   }
_wait_int08h:
   asm {
      mov eax,[si]
      cmp eax,ebx
      jz _wait_int08h
      pop ds
   }

   asm {
      mov al,03Ch
      out 043h,al
      mov al,0FFh
      out 040h,al
      mov al,0FFh
      out 040h,al
      push ds
      lds dx, _old_int08h_vec
      mov ah,025h
      mov al,08h
      int 021h
      pop ds
      in al,061h
      and al,0FCh
      out 061h,al
   }
}

low_timer LT;
// ⢥ ꥪ  low_timer.

// **************************************************************************
// ***********************  砫쭮 ⠢. **********************
// **************************************************************************

char *start_msg[]=
{
   "Copyright  1998 Copper Feet Corp.",
   " ࠢ 饭",
   "",
   " 㦡 ",
   "    ⢨  ᬨ᪮ ࠭⢥",
   "짮⥫᪠ ",
   "",
   "ணࠬ஢:  . . ",
   " ᮭ:  . . ",
   "",
   " ࠢ:",
   "S, X, N, M - ६饭 ࠡ",
   "SPC, SHIFT -  ᪮ ࠡ",
   "A - ५졠  襭",
   "F2 - ࠭ ஢ 樨",
   "F3 - ⠭ ஢ 樨",
   "ENTER -  ",
   "ESC - 室",
   "",
   " த  ENTER"
};

char start_cols[]=
{
   LIGHTBLUE, LIGHTBLUE, WHITE,
   YELLOW,WHITE,WHITE,WHITE,
   GREEN,GREEN,WHITE,
   LB,LB,LB,LB,LB,LB,LB,LB,WHITE,
   GREEN
};

char start_options[]=
// Bit 0 - centering / none
// Bit 1 - bold / normal
// Bit 2 - underlined / none
{
   1,1,0, 7,3,1,0, 5,5,0, 4,0,0,0,0,0,0,0,0, 1
};

char start_x0[]=
{
   0,0,0, 0,0,0,0, 0,0,0, 210,210,210,210,210,210,210,210,0, 0
};

extern void main_close();

void first_screen()
{
   setviewport(0,0,639,349,CLIP_OFF);
   LG.clear_screen(BLACK);
   LG.clear_window(90,5,460,340,DARKGRAY);
   b_col=DARKGRAY;
   int curr_y=25, curr_x;
   int i;
   for (i=0; i<20; i++)
   {
      f_col=start_cols[i];
      if (start_options[i]&2) font_options=O_BOLD;
      else font_options=O_NORMAL;
      if (start_options[i]&1) curr_x=LG.center_string(start_msg[i]);
      else curr_x=start_x0[i];
      if (start_options[i]&4)
         LG.put_undl_string(curr_x,curr_y,start_msg[i]);
      else LG.put_string(curr_x,curr_y,start_msg[i]);
      curr_y+=LINE_STEP;
   }
   LG.box(90,5,460,340,WHITE);
   LG.box(200,170,250,127,LIGHTBLUE);
   LG.toggle_screen();
   do
   {
   } while(!(kbd_flags&(ENTER_MASK|ESC_MASK)));
   if (kbd_flags&ESC_MASK)
   {
      main_close();
      exit(0);
   }
   kbd_flags=0;
}

// *************************************************************************
// ********   ⥬᪮ ।⠢ . ********
// *************************************************************************

typedef signed long FXP;
//   ⢥ ᫠  䨪஢ ⮩. (24.8)
// 訩  - ⢥ , 訥  - 楫.

typedef signed long FXPE;
//   ⢥ ᫠  䨪஢ ⮩
//  襭 筮. (16.16)
// 訥   - ⢥ , 訥  - 楫.

// *************************************************************************
// ***** ᠭ 権  権  ᥫ  䨪஢ ⮩. *****
// *************************************************************************

FXP iqmul(FXP a, FXP b)
// 頥 १ ६ a  b. ஬ १ -
// ⢥७ ᫮.
{
   asm {
      mov  eax, a
      imul dword ptr b
      push eax
      pop  ax
      pop  bx
      mov  al,ah
      mov  ah,bl
      mov  dh,dl
      mov  dl,bh
   }
}

FXP iqdiv(FXP a, FXP b)
// 頥 १  a  b. ஬ १ -
// ⢥७ ᫮.
{
   asm {
      mov   eax, dword ptr a[-1]
      xor   al,al
      movsx edx, byte ptr a[3]
      idiv  dword ptr b
      push  eax
      pop   ax
      pop   dx
   }
}

inline FXP idmul(FXP a, FXP b)
// 頥 १ ६ a  b. ஬ १ -
//  ᫮.
{
   return (FXP) ((signed long)a*(signed long)b)>>8;
}

inline FXP iddiv(FXP a, FXP b)
// 頥 १  a  b. ஬ १ -
//  ᫮.
{
   return (FXP) ((((signed long)a)<<8)/(signed long)b);
}

FXP iqmd(FXP a, FXP b, FXP c)
// 頥 a*b/c. ஬ १ - ⢥७ ᫮.
{
   asm {
      mov  eax, a
      imul dword ptr b
      idiv dword ptr c
      push eax
      pop  ax
      pop  dx
   }
}

FXP *sine_table;
//    ᫥ ਣ᪨ 㭪権.
// : [0, 2*PI).

FXPE *esine_table;
FXPE *ecosine_table;
//    ᫥ ਣ᪨ 㭪権  㣫
//  襭 筮. : [-2*PI/32, 2*PI/32).

void init_sine()
// 樠 ⠡ sine_table, esine_table.
{
   sine_table=(FXP *) farmalloc(ANGLES_NUM*sizeof(FXP));
   esine_table=(FXPE *) farmalloc(ANGLES_NUM*sizeof(FXPE));
   ecosine_table=(FXPE *) farmalloc(ANGLES_NUM*sizeof(FXPE));
   float a;
   WORD i;
   for (i=0; i<ANGLES_NUM; i++)
   {
      a=sin(i*2.0*PI/ANGLES_NUM)*256.0;
      if (a>0) a+=0.5; else a-=0.5;
      sine_table[i]=(signed long) a;
   }
   for (i=0; i<ANGLES_NUM; i++)
   {
      a=sin(-16.0*PI/ANGLES_NUM+i*32.0*PI/ANGLES_NUM/ANGLES_NUM)*65536.0;
      if (a>0) a+=0.5; else a-=0.5;
      esine_table[(BYTE)(i+0x80)]=(signed long) a;
      a=cos(-16.0*PI/ANGLES_NUM+i*32.0*PI/ANGLES_NUM/ANGLES_NUM)*65536.0;
      if (a>0) a+=0.5; else a-=0.5;
      ecosine_table[(BYTE)(i+0x80)]=(signed long) a;
   }
}

void close_sine()
//  ⠡ sine_table, esine_table  .
{
   farfree(sine_table);
   farfree(esine_table);
   farfree(ecosine_table);
}

inline FXP isin(BYTE angle)
// ᫥ ᨭ 㣫. 㬥 - signed char  unsigned char.
{
   return sine_table[angle];
}

inline FXP icos(BYTE angle)
// ᫥ ᨭ 㣫. 㬥 - signed char  unsigned char.
{
   return sine_table[(BYTE)(angle+0x40)];
}

inline FXPE iesin(BYTE angle)
// ᫥ ᨭ  㣫  襭 筮.
// 㬥 - signed char  unsigned char.
{
   return esine_table[angle];
}

inline FXPE iecos(BYTE angle)
// ᫥ ᨭ  㣫  襭 筮.
// 㬥 - signed char  unsigned char.
{
   return ecosine_table[angle];
}

WORD *sqrt_table;
//    ᫥ ⭮ .

void init_sqrt()
// 樠 ⠡ sqrt_table.
{
   sqrt_table=(WORD *) farmalloc(1024*sizeof(WORD));
   WORD i;
   for (i=0; i<1024; i++)
   {
      sqrt_table[i]=sqrt(i)*2048+0.5;
   }
}

void close_sqrt()
//  ⠡ sqrt_table  .
{
   farfree(sqrt_table);
}

long isqrt(long s)
// ஥ ᫥ .
{
   asm { xor esi, esi
         les si, dword ptr sqrt_table
         mov ebx, s
         mov dx, 11
         bsr ecx, ebx
         jz  _less
         sub cx, 9
         jle _less
         shr cx, 1
         adc cx, 0
         sub dx, cx
         shl cx, 1
         shr ebx, cl
       }
_less:
   asm { mov ax, es:[esi+ebx*2]
         mov cx, dx
         shr ax, cl
       }
   return ((DWORD) _AX) << 4;
}

inline FXP iabs(FXP x)
{
   return (x>=0) ? x:-x;
}

FXP* xsctb;
//  樥⮢ ᯥ⨢ ८ࠧ  X.

FXP* xscales;
// 窠 室  ⠡ 樥⮢ ᯥ⨢ ८ࠧ  X.
// xscales[i] ᮮ⢥ i-⮩ ⠡㥬 z-न.

FXP* ysctb;
//  樥⮢ ᯥ⨢ ८ࠧ  Y.

FXP* yscales;
// 窠 室  ⠡ 樥⮢ ᯥ⨢ ८ࠧ  Y.
// yscales[i] ᮮ⢥ i-⮩ ⠡㥬 z-न.

void init_scales()
// 樠 ⠡ 樥⮢ ᯥ⨢ ८ࠧ
// xsctb, ysctb.
{
   float k=1.0/(ZN/256L);
   WORD i;
   xsctb=(FXP *) farmalloc((2*ZN/256L+DESTRUCTION_RADIUS/256L)*sizeof(FXP));
   ysctb=(FXP *) farmalloc((2*ZN/256L+DESTRUCTION_RADIUS/256L)*sizeof(FXP));
   xscales=xsctb+ZN/256L;
   yscales=ysctb+ZN/256L;
   for (i=1; i<2*ZN/256L+DESTRUCTION_RADIUS/256L; i++)
   {
      xsctb[i]=(FXP) (XSCALE*256.0/(k*(i-ZN/256L)+1)+0.5);
      ysctb[i]=(FXP) (YSCALE*256.0/(k*(i-ZN/256L)+1)+0.5);
   }
   xsctb[0]=xsctb[1];
   ysctb[0]=ysctb[1];
}

void close_scales()
//  ⠡ 樥⮢ ᯥ⨢ ८ࠧ xsctb, ysctb
//  .
{
   farfree(xsctb);
   farfree(ysctb);
}

// *************************************************************************
// ********* ᠭ ᪨ ࠪ⨪ ᭮ ꥪ⮢. *********
// *************************************************************************

struct PNT
//  ।⠢ न 窨.
{
   FXP x,y,z;
   // ⢥ xyz-न.
};

struct PNTXY
//  ।⠢ ᪨ x,y-न 窨 (⢥
// ।⠢).
{
   FXP x,y;
   // ⢥ x,y-न.
};

struct IPNTXY
//  ।⠢ ᪨ x,y-न 窨 (楫᫥
// ।⠢).
{
   int x,y;
   // ⢥ x,y-न.
};

const PNT zero_pnt={0L,0L,0L};
// 窠  㫥묨 न⠬.

struct POLY
//  ।⠢ .
{
    WORD pnts_num;
    // ⢮ 祪, ⠢ .
    BYTE fcol;
    //  ⮭ .
    BYTE pattern;
    //  .
    WORD pnts[MAX_LINES];
    //  祪   ᮮ⢥饬 ᨢ.
};

// ᠭ ᪨ 㠫 ࠬ஢ ࢮ ࠡ
// (" ஭").
const WORD pnts1_num=32;
const WORD polys1_num=20;
const PNT cpnts1[]=
{
   {-20*32L,10*32L,0*32L}, // point #0
   {0*32L,10*32L,20*32L},
   {-30*32L,0*32L,20*32L},
   {-20*32L,10*32L,20*32L},
   {-10*32L,10*32L,30*32L},

   {-10*32L,0*32L,40*32L}, // point #5
   {0*32L,10*32L,-20*32L},
   {20*32L,10*32L,0*32L},
   {-20*32L,0*32L,-40*32L},
   {-20*32L,10*32L,-30*32L},

   {-30*32L,10*32L,-20*32L}, // point #10
   {-40*32L,0*32L,-20*32L},
   {40*32L,0*32L,-20*32L},
   {30*32L,10*32L,-20*32L},
   {20*32L,10*32L,-30*32L},

   {20*32L,0*32L,-40*32L}, // point #15
   {10*32L,0*32L,40*32L},
   {10*32L,10*32L,30*32L},
   {20*32L,10*32L,20*32L},
   {30*32L,0*32L,20*32L},

   {30*32L,-10*32L,-20*32L}, // point #20
   {20*32L,-10*32L,-30*32L},
   {10*32L,-10*32L,30*32L},
   {20*32L,-10*32L,20*32L},
   {-20*32L,-10*32L,20*32L},

   {-10*32L,-10*32L,30*32L}, // point #25
   {-20*32L,-10*32L,-30*32L},
   {-30*32L,-10*32L,-20*32L},
   {20*32L,-10*32L,0*32L},
   {0*32L,-10*32L,-20*32L},

   {0*32L,-10*32L,20*32L}, // point #30
   {-20*32L,-10*32L,0*32L}
};

const PNT cnormals1[]=
{
   {0*256L,64*256L,0*256L}, // polygon #0
   {0*256L,64*256L,0*256L},
   {-64*256L,64*256L,16*256L},
   {-64*256L,64*256L,-64*256L},
   {0*256L,64*256L,-64*256L},

   {64*256L,64*256L,-64*256L}, // polygon #5
   {64*256L,64*256L,16*256L},
   {64*256L,64*256L,64*256L},
   {0*256L,64*256L,64*256L},
   {-64*256L,64*256L,64*256L},

   {0*256L,-64*256L,0*256L}, // polygon #10
   {0*256L,-64*256L,0*256L},
   {-64*256L,-64*256L,16*256L},
   {-64*256L,-64*256L,-64*256L},
   {0*256L,-64*256L,-64*256L},

   {64*256L,-64*256L,-64*256L}, // polygon #15
   {64*256L,-64*256L,16*256L},
   {64*256L,-64*256L,64*256L},
   {0*256L,-64*256L,64*256L},
   {-64*256L,-64*256L,64*256L}
};

const POLY cpolys1[]=
{
   {8,YL,SFILL,{3,10,9,14,13,18,17,4}}, // polygon #0
   {4,DG,SFILL,{0,6,7,1}},
   {4,RD,DFILL,{2,11,10,3}},
   {4,YL,DFILL,{11,8,9,10}},
   {4,DG,DFILL,{8,15,14,9}},

   {4,YL,DFILL,{15,12,13,14}}, // polygon #5
   {4,RD,DFILL,{12,19,18,13}},
   {4,YL,DFILL,{19,16,17,18}},
   {4,DG,DFILL,{16,5,4,17}},
   {4,YL,DFILL,{5,2,3,4}},

   {8,YL,SFILL,{24,27,26,21,20,23,22,25}}, // polygon #10
   {4,DG,SFILL,{31,29,28,30}},
   {4,RD,DFILL,{2,11,27,24}},
   {4,YL,DFILL,{11,8,26,27}},
   {4,DG,DFILL,{8,15,21,26}},

   {4,YL,DFILL,{15,12,20,21}}, // polygon #15
   {4,RD,DFILL,{12,19,23,20}},
   {4,YL,DFILL,{19,16,22,23}},
   {4,DG,DFILL,{16,5,25,22}},
   {4,YL,DFILL,{5,2,24,25}}
};

// ᠭ ᪨ 㠫 ࠬ஢ ண ࠡ
// ("⨧").
const WORD pnts2_num=11;
const WORD polys2_num=12;
const PNT cpnts2[]=
{
   {0*32L,15*32L,0*32L}, // point #0
   {-38*32L,0*32L,12*32L},
   {0*32L,0*32L,40*32L},
   {38*32L,0*32L,12*32L},
   {24*32L,0*32L,-32*32L},

   {-24*32L,0*32L,-32*32L}, // point #5
   {0*32L,-15*32L,20*32L},
   {19*32L,-15*32L,6*32L},
   {12*32L,-15*32L,-16*32L},
   {-12*32L,-15*32L,-16*32L},

   {-19*32L,-15*32L,6*32L} // point #10
};

const PNT cnormals2[]=
{
   {-17*256L,64*256L,24*256L}, // polygon #0
   {17*256L,64*256L,24*256L},
   {28*256L,64*256L,-9*256L},
   {0*256L,64*256L,-29*256L},
   {-28*256L,64*256L,-9*256L},

   {-34*256L,-64*256L,47*256L}, // polygon #5
   {34*256L,-64*256L,47*256L},
   {55*256L,-64*256L,-18*256L},
   {0*256L,-64*256L,-58*256L},
   {-55*256L,-64*256L,-18*256L},

   {0*256L,-64*256L,0*256L}, // polygon #10
   {-17*256L,64*256L,24*256L}
};

const POLY cpolys2[]=
{
   {3,YL,SFILL,{1,2,0}}, // polygon #0
   {3,YL,SFILL,{2,3,0}},
   {3,RD,SFILL,{3,4,0}},
   {3,YL,SFILL,{4,5,0}},
   {3,RD,SFILL,{5,1,0}},

   {4,RD,DFILL,{1,2,6,10}}, // polygon #5
   {4,RD,DFILL,{2,3,7,6}},
   {4,YL,DFILL,{3,4,8,7}},
   {4,RD,DFILL,{4,5,9,8}},
   {4,YL,DFILL,{5,1,10,9}},

   {5,RD,SFILL,{10,6,7,8,9}}, // polygon #10
   {2,RD,SFILL,{2,0}}
};

// ᠭ ᪨ 㠫 ࠬ஢ 쥣 ࠡ
// ("孮").
const WORD pnts3_num=20;
const WORD polys3_num=19;
const PNT cpnts3[]=
{
   {-20*32L,0*32L,-35*32L}, // point #0
   {0*32L,-5*32L,-35*32L},
   {20*32L,0*32L,-35*32L},
   {0*32L,5*32L,-35*32L},
   {-40*32L,5*32L,-35*32L},

   {-40*32L,-5*32L,-35*32L}, // point #5
   {0*32L,-15*32L,-35*32L},
   {40*32L,-5*32L,-35*32L},
   {40*32L,5*32L,-35*32L},
   {0*32L,15*32L,-35*32L},

   {-20*32L,-5*32L,15*32L}, // point #10
   {-20*32L,5*32L,15*32L},
   {0*32L,10*32L,15*32L},
   {20*32L,5*32L,15*32L},
   {20*32L,-5*32L,15*32L},

   {0*32L,-10*32L,15*32L}, // point #15
   {-10*32L,-5*32L,35*32L},
   {-10*32L,5*32L,35*32L},
   {10*32L,5*32L,35*32L},
   {10*32L,-5*32L,35*32L}
};

const PNT cnormals3[]=
{
   {0*256L,0*256L,-64*256L}, // polygon #0
   {0*256L,0*256L,-64*256L},
   {-16*256L,64*256L,6*256L},
   {-16*256L,-64*256L,6*256L},
   {16*256L,64*256L,6*256L},

   {16*256L,-64*256L,6*256L}, // polygon #5
   {-16*256L,64*256L,8*256L},
   {-16*256L,-64*256L,8*256L},
   {0*256L,64*256L,16*256L},
   {0*256L,-64*256L,16*256L},

   {16*256L,64*256L,8*256L}, // polygon #10
   {16*256L,-64*256L,8*256L},
   {-64*256L,0*256L,25*256L},
   {-64*256L,0*256L,32*256L},
   {0*256L,0*256L,64*256L},

   {64*256L,0*256L,32*256L}, // polygon #15
   {64*256L,0*256L,25*256L},
   {-16*256L,64*256L,6*256L},
   {16*256L,-64*256L,6*256L},
};

const POLY cpolys3[]=
{
   {6,BU,SFILL,{4,5,6,7,8,9}}, // polygon #0
   {4,WH,DFILL,{0,1,2,3}},
   {4,GY,SFILL,{4,9,12,11}},
   {4,GY,SFILL,{5,6,15,10}},
   {4,GY,SFILL,{9,8,13,12}},

   {4,GY,SFILL,{6,7,14,15}}, // polygon #5
   {3,WH,SFILL,{11,12,17}},
   {3,WH,SFILL,{10,15,16}},
   {3,BU,SFILL,{12,17,18}},
   {3,BU,SFILL,{15,16,19}},

   {3,WH,SFILL,{12,13,18}}, // polygon #10
   {3,WH,SFILL,{15,14,19}},
   {4,BU,SFILL,{4,5,10,11}},
   {4,WH,SFILL,{11,10,16,17}},
   {4,BU,SFILL,{17,16,19,18}},

   {4,WH,SFILL,{13,14,19,18}}, // polygon #15
   {4,BU,SFILL,{8,7,14,13}},
   {2,BU,SFILL,{9,12}},
   {2,BU,SFILL,{6,15}},
};

// ᠭ ᪨ 㠫 ࠬ஢ ᬨ᪮  - 㡨.
const WORD pnts4_num=8;
const WORD polys4_num=16;
const PNT cpnts4[]=
{
   {-10*32L,-10*32L,-10*32L}, // point #0
   {10*32L,-10*32L,-10*32L},
   {10*32L,-10*32L,10*32L},
   {-10*32L,-10*32L,10*32L},
   {-10*32L,10*32L,-10*32L},

   {10*32L,10*32L,-10*32L}, // point #5
   {10*32L,10*32L,10*32L},
   {-10*32L,10*32L,10*32L}
};

const PNT cnormals4[]=
{
   {0*256L,64*256L,0*256L}, // polygon #0
   {-64*256L,0*256L,0*256L},
   {0*256L,-64*256L,0*256L},
   {64*256L,0*256L,0*256L},
   {0*256L,64*256L,0*256L},

   {-64*256L,0*256L,0*256L}, // polygon #5
   {0*256L,-64*256L,0*256L},
   {64*256L,0*256L,0*256L},
   {0*256L,64*256L,0*256L},
   {-64*256L,0*256L,0*256L},

   {0*256L,-64*256L,0*256L}, // polygon #10
   {64*256L,0*256L,0*256L},
   {0*256L,-64*256L,0*256L},
   {64*256L,0*256L,0*256L},
   {0*256L,64*256L,0*256L},

   {-63*256L,0*256L,0*256L}, // polygon #15
};

const POLY cpolys4[]=
{
   {4,RD,DFILL,{0,1,2,3}}, // polygon #0
   {4,RD,DFILL,{1,2,6,5}},
   {4,RD,DFILL,{4,5,6,7}},
   {4,RD,DFILL,{0,3,7,4}},
   {2,GY,SFILL,{0,1}},

   {2,GY,SFILL,{1,5}}, // polygon #5
   {2,GY,SFILL,{5,4}},
   {2,GY,SFILL,{4,0}},
   {2,GY,SFILL,{3,2}},
   {2,GY,SFILL,{2,6}},

   {2,GY,SFILL,{6,7}}, // polygon #10
   {2,GY,SFILL,{7,3}},
   {4,GY,DFILL,{0,1,2,3}},
   {4,GY,DFILL,{1,2,6,5}},
   {4,GY,DFILL,{4,5,6,7}},

   {4,GY,DFILL,{0,3,7,4}} // polygon #15
};

// ᠭ ᪨ 㠫 ࠬ஢ ᬨ᪮  - ࠬ.
const WORD pnts5_num=6;
const WORD polys5_num=12;
const PNT cpnts5[]=
{
   {-10*32L,-10*32L,-10*32L}, // point #0
   {-10*32L,-10*32L,10*32L},
   {-10*32L,10*32L,-10*32L},
   {10*32L,10*32L,-10*32L},
   {10*32L,10*32L,10*32L},

   {-10*32L,10*32L,10*32L} // point #5
};

const PNT cnormals5[]=
{
   {64*256L,0*256L,0*256L}, // polygon #0
   {0*256L,-64*256L,0*256L},
   {-64*256L,64*256L,0*256L},
   {64*256L,0*256L,0*256L},
   {0*256L,-64*256L,0*256L},

   {-64*256L,64*256L,0*256L}, // polygon #5
   {64*256L,0*256L,0*256L},
   {0*256L,-64*256L,0*256L},
   {-64*256L,64*256L,0*256L},
   {64*256L,-64*256L,0*256L},

   {-64*256L,0*256L,0*256L}, // polygon #10
   {0*256L,64*256L,0*256L}
};

const POLY cpolys5[]=
{
   {4,RD,DFILL,{0,2,5,1}}, // polygon #0
   {4,RD,DFILL,{2,3,4,5}},
   {4,RD,DFILL,{0,1,4,3}},
   {2,GY,SFILL,{2,0}},
   {2,GY,SFILL,{3,2}},

   {2,GY,SFILL,{0,3}}, // polygon #5
   {2,GY,SFILL,{5,1}},
   {2,GY,SFILL,{4,5}},
   {2,GY,SFILL,{1,4}},
   {4,GY,DFILL,{0,1,4,3}},

   {4,GY,DFILL,{0,2,5,1}}, // polygon #10
   {4,GY,DFILL,{2,3,4,5}}
};

// *************************************************************************
// ***************** 塞  ।⠢. ********************
// *************************************************************************

// ᠭ 㦥 ᮢ, ࠧ塞 ꥪ⠬.
PNT *pnts;
// 騩  न 祪.
int *polypnts;
// 騩  न 祪, ਭ  .
PNT *normals;
// 騩  ଠ  .
BYTE *pntflags;
//  祪.
BYTE *polyflags;
//  .

void init_shared()
// 樠 ࠧ塞 ᮢ ।⠢.
{
   pnts=(PNT *) farmalloc(SHARED_PNTS_NUM*sizeof(PNT));
   polypnts=(int *) farmalloc(SHARED_PNTS_NUM*sizeof(int)*2);
   normals=(PNT *) farmalloc(SHARED_POLYS_NUM*sizeof(PNT));
   pntflags=(BYTE *) farmalloc(SHARED_PNTS_NUM*sizeof(BYTE));
   polyflags=(BYTE *) farmalloc(SHARED_POLYS_NUM*sizeof(BYTE));
}

void close_shared()
//  ࠧ塞 ᮢ ।⠢  .
{
   farfree(pnts);
   farfree(polypnts);
   farfree(normals);
   farfree(pntflags);
   farfree(polyflags);
}

// *************************************************************************
// ***** ᠭ ⨯ ᪨ ࠪ⨪ ᭮ ꥪ⮢. *****
// *************************************************************************

struct FORM
//  ᪮ ।⠢ ꥪ.
{
   BYTE form_type;
   //  ⥪饩  ꥪ: 0 -  ࠡ (""),
   // 1 - " ஭", 2 - "⨧", 3 - "孮".
   WORD pnts_num;
   // ⢮ 祪  ꥪ.
   WORD polys_num;
   // ⢮   ꥪ.
   const PNT *pnts;
   // ⥫  ﭭ ᨢ 祪, ⠢ ꥪ.
   const PNT *normals;
   // ⥫  ﭭ ᨢ ଠ  ,
   // ⠢ ꥪ.
   const POLY *polys;
   // ⥫  ﭭ ᨢ , ⠢ ꥪ.
   PNT fire_center;
   // 窠  ࠡ ⨢,  ன 室   ५졥.
};

// *************************************************************************
// ******** ᠭ ᪨ ࠪ⨪ ᭮ ꥪ⮢. *********
// *************************************************************************

struct OBJ
//  ᠭ  ꥪ.
{
   BYTE active;
   // 1 - ꥪ  ⨢  ⥪騩 , 0 - .
   // ᯮ  ᬮ ⠡ ꥪ⮢.

   BYTE radar_flag;
   // 1 - ꥪ   ࠤ  ⥪騩 , 0 - .
   BYTE visible_flag;
   // 1 - ꥪ 뢮 楤ன 㠫樨  ⥪饬 ⠪ ࠡ祣
   // 横, 0 - .
   FXP radius;
   // ﭨ  ࠡ ⨢  訬 ࠡ.

   FORM form;
   // ଠ ꥪ.
   PNT fire_rcenter;
   // 窠  ࠡ ⨢,  ன 室   ५졥,
   // ⠭   न.  ந 㭪
   // vizualize_obj().
   IPNTXY bob_pnt;
   // "Beam On Border" Point - 窠 砭  ࠦ᪮ 
   //  襬 ࠭.  室 ⮫쪮  ࠬ, ࠬ饩
   //   襩  .

   PNT center;
   //  ꥪ  ⭮⥫ न,   
   // 襣 ࠡ.
   PNT rcenter;
   //  ꥪ  ⭮⥫ न,  ⮬ 
   // 襣 ࠡ.

   signed char vlr;
   //  㣫 ᪮ ᮡ⢥ ⥫쭮  ࠡ.
   signed char vud;
   //  㣫 ᪮ ꥬ ⥫쭮  ࠡ.
   FXP vlrfxp;
   //  㣫 ᪮ ᮡ⢥ ⥫쭮  ࠡ.
   // (⢥ ।⠢.)
   FXP vudfxp;
   //  㣫 ᪮ ꥬ ⥫쭮  ࠡ.
   // (⢥ ।⠢.)
   FXP alrfxp;
   //  㣮  ᮡ⢥ ⥫쭮  ࠡ.
   // (⢥ ।⠢.)
   FXP audfxp;
   //  㣮  ꥬ ⥫쭮  ࠡ.
   // (⢥ ।⠢.)
   FXP vfbfxp;
   //  ଠ ᪮ 㯠⥫쭮  ࠡ.
   // (⢥ ।⠢.)
   BYTE mov_flags;
   // ⮢ ᪠ 䫠,  ஢ ᯫ஢
   // ( 堮) ⢨ 祫  ⨨  ࠢ.
   //  0 - ஢ 楫ࠢ ६ ᪮ vlrfxp,
   //  1 - ஢ 楫ࠢ ६ ᪮ vlrfxp,
   //  2 - ஢ 楫ࠢ ६ ᪮ vudfxp,
   //  2 - ஢ 楫ࠢ ६ ᪮ vudfxp.

   PNT dirlin;
   // 騩  ࠢ 㯠⥫쭮   ᮫
   // न.
   PNT dirrot;
   // 騩  ࠢ ᮡ⢥ 饭  ᮫
   // न.
   BYTE udsra;
   // Up/Down Self-Rotation Angle.  ᮡ⢥  ꥪ.
   //  砥, ᫨ 砫쭮  0, ꥪ  㤥  ⠪
   // 饭,  㣮 ⮬᪨ 騢  楤
   // visualize_obj().

   FXP shields;
   // 饥 ﭨ   _ࠦ᪮_ ࠡ. ⭮ 
   //  ࠣ  ॣ,  ࠧ  F. / R. / G. Shields.
   //   :  __ ࠡ 㫥 祭 ⮣ 
   // 砥,   㭨⮦ ⨢.
   FXP weapons;
   //  㦨 - 襣  ࠦ᪮.
   DWORD price;
   // ⮨ ⮣ ࠡ.
   BYTE fire_status;
   // 1 - ࠡ ⨢ ந ५, 0 - .
   DWORD fire_counter;
   // 稪 ६.  ஢    ५
   //  祭 ६ ( ⠪ ⠩) FIRE_DELAY_TIME  ᮢ뢠
   //    祭 ६ BEAM_VISIBLE_TIME.

   void (*init_obj)(OBJ *);
   // ⥫  楤 樠樨 ࠬ஢ ꥪ.  ⢥ ࠬ
   // 楤   ꥪ⮢ 㪠뢠 ᠬ "뢠騩" ꥪ OBJ.

   void (*calc_obj)(OBJ *);
   // ⥫  楤 ᫥ ࠬ஢ ꥪ. 뢠 
   //  ⠪ ࠡ祣 横.  ᮤঠ ⮫쪮 樨
   // ७祭 ࠬ஢ vlrfxp, vudfxp, vfbfxp.
};

// **************************************************************************
// *************** ᠭ ᮡ⢥ ꥪ⮢ ஢ . **************
// **************************************************************************

// ⥫ 襣, த ࠡ.
OBJ native;
//  ᠭ.
FXP laser_temperature;
//  ࠬ Laser Temperature - ⥬   ⥪騩
//  ६.
FXP fshields, rshields, gshields;
//  ࠬ - ⥪ 魮 ᨫ  襣 ࠡ.
DWORD cash;
//  ࠬ - ⥪ 筮.
BYTE rating;
//  ࠬ - ⥪騩 ३⨭.


PNT native_mov;
//  ६饭 襣 ࠡ  ⥪饬 ⠪ .

WORD objs_num;
// 饥 ⢮ ꥪ⮢ ஢ .
WORD trashies_num;
// 饥 ⢮   ஢ .

OBJ *objs;
// ꥪ ஢ .

WORD visible_objs_num;
// 饥 ⢮  ꥪ⮢ ஢ .

OBJ **visible_objs;
//  㪠⥫   ꥪ ஢ , ஢ 
// 뢠 न z 窨 rcenter.

void init_objs()
// 樠 ⠡ ꥪ⮢ ஢ .
{
   objs=(OBJ *) farmalloc(OBJS_NUM*sizeof(OBJ));
   visible_objs=(OBJ **) farmalloc(OBJS_NUM*sizeof(OBJ*));
}

void close_objs()
//  ⠡ ꥪ⮢ ஢   .
{
   farfree(objs);
   farfree(visible_objs);
}

// **************************************************************************
// **************** ᠭ 楤-ࠡ稪 ꥪ⮢. ****************
// **************************************************************************

// ᠭ ࠡ稪 ᪨ ࠬ஢ 襣, த ࠡ
// ("").
void init_obj0(OBJ *obj)
{  obj->center.x=0L; obj->center.y=0L; obj->center.z=0L;

   obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
   obj->vfbfxp=VFB_STEP;

   obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
   obj->dirrot.x=1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;

   obj->weapons=NATIVE_WEAPONS;
   obj->shields=1L;
}

void calc_obj0(OBJ *obj)
{
   if (kbd_status&FORWARD_MASK)
      if (obj->vfbfxp<=MAX_VFB-VFB_STEP) obj->vfbfxp+=VFB_STEP;
      else obj->vfbfxp=MAX_VFB;
   else
      if (kbd_status&BACKWARD_MASK)
         if (obj->vfbfxp>=(VFB_STEP<<1)) obj->vfbfxp-=VFB_STEP;
         else obj->vfbfxp=VFB_STEP;

   if (kbd_status&DOWN_MASK)
      if (obj->vudfxp<=MAX_VUD-VUD_INC_STEP)
         obj->vudfxp+=VUD_INC_STEP;
      else obj->vudfxp=MAX_VUD;
   else if (kbd_status&UP_MASK)
           if (obj->vudfxp>=-MAX_VUD+VUD_INC_STEP)
              obj->vudfxp-=VUD_INC_STEP;
           else obj->vudfxp=-MAX_VUD;
        else if ((!(kbd_status&DOWN_MASK))&&(obj->vudfxp>0L))
                if (obj->vudfxp>=VUD_DEC_STEP)
                   obj->vudfxp-=VUD_DEC_STEP;
                else obj->vudfxp=0L;
             else if ((!(kbd_status&UP_MASK))&&(obj->vudfxp<0L))
                     if (obj->vudfxp<=-VUD_DEC_STEP)
                        obj->vudfxp+=VUD_DEC_STEP;
                     else obj->vudfxp=0L;

   if (kbd_status&RIGHT_MASK)
      if (obj->vlrfxp<=MAX_VLR-VLR_INC_STEP)
         obj->vlrfxp+=VLR_INC_STEP;
      else obj->vlrfxp=MAX_VLR;
   else if (kbd_status&LEFT_MASK)
           if (obj->vlrfxp>=-MAX_VLR+VLR_INC_STEP)
              obj->vlrfxp-=VLR_INC_STEP;
           else obj->vlrfxp=-MAX_VLR;
        else if ((!(kbd_status&RIGHT_MASK))&&(obj->vlrfxp>0L))
                if (obj->vlrfxp>=VLR_DEC_STEP)
                   obj->vlrfxp-=VLR_DEC_STEP;
                else obj->vlrfxp=0L;
             else if ((!(kbd_status&LEFT_MASK))&&(obj->vlrfxp<0L))
                     if (obj->vlrfxp<=-VLR_DEC_STEP)
                        obj->vlrfxp+=VLR_DEC_STEP;
                     else obj->vlrfxp=0;
}

// ᠭ ࠡ稪 ᪨ ࠬ஢ ࢮ ࠡ
// (" ஭").
void init_obj1(OBJ *obj)
{
   obj->weapons=WEAPONS1;
   obj->shields=SHIELDS1;
   obj->vfbfxp=MAX_VFB/3L;
   if (!obj->vfbfxp) obj->vfbfxp=1L;
}

void calc_obj(OBJ *obj)
{
   PNT v1=obj->center, v2=obj->dirlin;
   FXP sqm=iqmul(v1.x,v2.x)+iqmul(v1.y,v2.y)+iqmul(v1.z,v2.z);
   int rnd;
   if ((obj->radius>FIRE_RADIUS) || (sqm>=0L) ||
   (rand()>(MIN_TIME_SLICE*200)) ||
   ((time_counter-obj->fire_counter)<FIRE_DELAY_TIME))
      obj->fire_status=0;
   else
   {
      obj->fire_status=1;
      obj->fire_counter=time_counter;
   }
   rnd=rand();
   if ((!obj->vlrfxp)&&(!obj->vudfxp)&&(rnd<MIN_TIME_SLICE*75))
   {
      switch (rnd&0x03)
      {
         case 0:
            obj->mov_flags=0x04;
            break;
         case 1:
            obj->mov_flags=0x08;
            break;
         case 2:
            obj->mov_flags=0x01;
            break;
         case 3:
            obj->mov_flags=0x02;
            break;
      }
   }

   if ((sqm>=0L)&&(rand()<(MIN_TIME_SLICE*200))) obj->mov_flags=0x08;
   if (obj->radius<PRE_COLLISION_RADIUS) obj->mov_flags=0x04;

   if (obj->vlrfxp||obj->vudfxp||obj->mov_flags)
   {
      WORD _kbd_status=0, save_kbd_status;
      FXP save_MAX_VUD=MAX_VUD;
      MAX_VUD=MAX_VUD*3L/2L;
      FXP vlrfxp=obj->vlrfxp;
      FXP vudfxp=obj->vudfxp;
      BYTE mov_flags=obj->mov_flags;
      if (vlrfxp>=MAX_VLR) obj->mov_flags&=0x01^0xFF;
      if (vlrfxp<=-MAX_VLR) obj->mov_flags&=0x02^0xFF;
      if (vudfxp>=MAX_VUD) obj->mov_flags&=0x04^0xFF;
      if (vudfxp<=-MAX_VUD) obj->mov_flags&=0x08^0xFF;
      if (mov_flags&0x01) _kbd_status|=RIGHT_MASK;
      if (mov_flags&0x02) _kbd_status|=LEFT_MASK;
      if (mov_flags&0x04) _kbd_status|=DOWN_MASK;
      if (mov_flags&0x08) _kbd_status|=UP_MASK;
      asm cli
      save_kbd_status=kbd_status;
      kbd_status=_kbd_status;
      calc_obj0(obj);
      kbd_status=save_kbd_status;
      MAX_VUD=save_MAX_VUD;
      asm sti
   }
}

// ᠭ ࠡ稪 ᪨ ࠬ஢ ண ࠡ
// ("⨧").
void init_obj2(OBJ *obj)
{
   obj->weapons=WEAPONS2;
   obj->shields=SHIELDS2;
   obj->vfbfxp=MAX_VFB/2L;
   if (!obj->vfbfxp) obj->vfbfxp=1L;
}

// ᠭ ࠡ稪 ᪨ ࠬ஢ 쥣 ࠡ
// ("孮").
void init_obj3(OBJ *obj)
{
   obj->weapons=WEAPONS3;
   obj->shields=SHIELDS3;
   obj->vfbfxp=MAX_VFB*5L/12L;
   if (!obj->vfbfxp) obj->vfbfxp=1L;
}

// ᠭ ࠡ稪 ᪨ ࠬ஢ ᬨ᪮ .
void init_obj4(OBJ *obj)
{
   obj->vlrfxp=MAX_VLR/4L;
   if (!obj->vlrfxp) obj->vlrfxp=1L;
   obj->vudfxp=0*256L;
   obj->alrfxp=0L; obj->audfxp=0L;
   obj->vfbfxp=MAX_VFB/6L;
   if (!obj->vfbfxp) obj->vfbfxp=1L;
   obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
   obj->dirrot.x=1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;
   obj->shields=1L;
}

void calc_obj4(OBJ *obj)
{  obj; }

// ᠭ ࠡ稪 ᪨ ࠬ஢ ⮢ ࠡ
// ( ᭮  "⨧"). ᯮ  ஢
// த⢨ ⥬.
void init_test_obj(OBJ *obj)
{
   obj->center.x=30*256L; obj->center.y=30*256L; obj->center.z=350*256L;
   obj->vlrfxp=0L; obj->vudfxp=0*256L; obj->alrfxp=0L; obj->audfxp=0L;
   obj->vfbfxp=0L;
   obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=-1*256L;
   obj->dirrot.x=-1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;
   obj->weapons=WEAPONS2;
   obj->shields=SHIELDS2;
}

void calc_test_obj(OBJ *obj)
{
   PNT v1=obj->center, v2=obj->dirlin;
   if ((obj->radius>FIRE_RADIUS) ||
   ((iqmul(v1.x,v2.x)+iqmul(v1.y,v2.y)+iqmul(v1.z,v2.z))<=0L) ||
   (rand()>(MIN_TIME_SLICE*150)) ||
   ((time_counter-obj->fire_counter)<FIRE_DELAY_TIME))
      obj->fire_status=0;
   else
   {
      obj->fire_status=0;
      obj->fire_counter=0L;
   }
}

// *************************************************************************
// **** ᠭ ⨯ ᪨ ࠪ⨪ ᭮ ꥪ⮢. *****
// *************************************************************************

const OBJ obj0=
//  "".
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     0, pnts1_num, polys1_num,
     cpnts1, cnormals1, cpolys1, {0L,0L,0L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   0, /* udsra */
   0L, /* shields */  0L, /* weapons */ 0L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_obj0, calc_obj0
};

const OBJ obj1=
// " ஭".
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     1, pnts1_num, polys1_num,
     cpnts1, cnormals1, cpolys1, {0L,0L,40*32L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   0, /* udsra */
   0L, /* shields */  0L, /* weapons */ 10L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_obj1, calc_obj
};

const OBJ obj2=
// "⨧".
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     2, pnts2_num, polys2_num,
     cpnts2, cnormals2, cpolys2, {0L,0L,40*32L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   0, /* udsra */
   0L, /* shields */  0L, /* weapons */ 25L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_obj2, calc_obj
};

const OBJ obj3=
// "孮".
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     3, pnts3_num, polys3_num,
     cpnts3, cnormals3, cpolys3, {0L,0L,35*32L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   0, /* udsra */
   0L, /* shields */  0L, /* weapons */ 15L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_obj3, calc_obj
};

const OBJ obj4=
// ᬨ᪨  - 㡨.
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     4, pnts4_num, polys4_num,
     cpnts4, cnormals4, cpolys4, {0L,0L,0L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   1, /* udsra */
   0L, /* shields */  0L, /* weapons */ 0L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_obj4, calc_obj4
};

const OBJ obj5=
// ᬨ᪨  - ࠬ.
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     5, pnts5_num, polys5_num,
     cpnts5, cnormals5, cpolys5, {0L,0L,0L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   1, /* udsra */
   0L, /* shields */  0L, /* weapons */ 0L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_obj4, calc_obj4
};

const OBJ test_obj=
// ⮢ ࠡ ( ᭮  "⨧"). ᯮ 
// ஢ த⢨ ⥬.
{
   1, // active
   0, // radar_flag
   0, // visible_flag
   0L, // radius
   {
     2, pnts2_num, polys2_num,
     cpnts2, cnormals2, cpolys2, {0L,0L,40*32L}
   }, // form
   {0L,0L,0L}, // fire_rcenter
   {0,0}, // bob_pnt
   {0L,0L,0L}, // center
   {0L,0L,0L}, // rcenter
   0, /* vlr */ 0, /* vud */
   0L, /* vlrfxp */ 0L, /* vudfxp */ 0L, /* alrfxp */ 0L, /* audfxp */
   0L, // vfbfxp
   0, // mov_flags
   {0L,0L,0L}, // dirlin
   {0L,0L,0L}, // dirrot
   1, /* udsra */
   0L, /* shields */  0L, /* weapons */ 25L, /* price */
   0, /* fire_status */ 0L, /* fire_counter */
   init_test_obj, calc_test_obj
};

// *************************************************************************
// ********************* ᪮  ணࠬ. ***********************
// *************************************************************************

// *************************************************************************
// ****************** 㭪樨   権 *******************
// ******************  ࠭⢥ ८ࠧ. *******************
// *************************************************************************

inline FXP idnorm(PNT vec)
// ᫥   vec. ஬ १ -  ᫮.
{
   return isqrt(vec.x*vec.x+vec.y*vec.y+vec.z*vec.z)>>4;
}

inline FXP iqnorm(PNT vec)
// ᫥   vec. ஬ १ - ⢥७
// ᫮.
{
   return isqrt(iqmul(vec.x,vec.x)+iqmul(vec.y,vec.y)+iqmul(vec.z,vec.z));
}

void normalize(PNT *vec, FXP norm)
// ଠ  vec   norm.   㬥
// 騥 訡 ᫥.
{
   FXP k=iddiv(norm, idnorm(*vec));
   vec->x=idmul(vec->x,k); vec->y=idmul(vec->y,k); vec->z=idmul(vec->z,k);
}

inline FXP sqmul(PNT v1, PNT v2)
// ᫥ ᪠୮ ந ஢. ஬ १ -
// ⢥७ ᫮.
{
   return iqmul(v1.x,v2.x)+iqmul(v1.y,v2.y)+iqmul(v1.z,v2.z);
}

inline FXP sdmul(PNT v1, PNT v2)
// ᫥ ᪠୮ ந ஢. ஬ १ -
//  ᫮.
{
   return (v1.x*v2.x+v1.y*v2.y+v1.z*v2.z)>>8;
}

PNT vmul(PNT v1, PNT v2)
// ᫥ ୮ ந ஢.
{
  PNT v;
  v.x=(v1.z*v2.y-v1.y*v2.z)>>8;
  v.y=(v1.x*v2.z-v1.z*v2.x)>>8;
  v.z=(v1.y*v2.x-v1.x*v2.y)>>8;
  return v;
}


inline void rot_x(PNT *p, char a)
//  窨 ⭮⥫쭮  x  㣮 a.
{
   FXP c;
   c=(icos(a)*p->z-isin(a)*p->y)>>8;
   p->y=(icos(a)*p->y+isin(a)*p->z)>>8;
   p->z=c;
}

inline void rot_y(PNT *p, char a)
//  窨 ⭮⥫쭮  y  㣮 a.
{
   FXP c;
   c=(icos(a)*p->x-isin(a)*p->z)>>8;
   p->z=(icos(a)*p->z+isin(a)*p->x)>>8;
   p->x=c;
}

void rot_vv_ort(PNT vb, PNT *vr, char a)
//   vr ⭮⥫쭮  vb  㣮 a. ⠥, 
//  ᢥ   .
// .   ८ࠧ  ⠭ ⮣묨
// ⭮⥫쭮  㣠.
{
   PNT v=*vr;
   FXP sna,na,nacosa,nasina;
   FXP nb,nbcosb,nbsinb;
   sna=vb.x*vb.x+vb.y*vb.y;
   na=isqrt(sna)>>4;
   nacosa=vb.y;
   nasina=vb.x;
   nb=isqrt(sna+vb.z*vb.z)>>4;
   nbcosb=na;
   nbsinb=vb.z;
   FXP c;
   if (na)
   {
      c=(nacosa*v.x-nasina*v.y)/na;
      v.y=(nacosa*v.y+nasina*v.x)/na;
      v.x=c;
   }
   // 窠  ⬥ ८ࠧ ஢  ⮣.
   // c=(nbcosb*v.y+nbsinb*v.z)/nb;
   c=0L;
   v.z=(nbcosb*v.z-nbsinb*v.y)/nb;
   v.y=c;
   rot_y(&v,a);
   c=(nbcosb*v.y-nbsinb*v.z)/nb;
   v.z=(nbcosb*v.z+nbsinb*v.y)/nb;
   v.y=c;
   if (na)
   {
      c=(nacosa*v.x+nasina*v.y)/na;
      v.y=(nacosa*v.y-nasina*v.x)/na;
      v.x=c;
   }
   *vr=v;
}

void rot_evv_ort(PNT vb, PNT *vr, char a)
//   vr ⭮⥫쭮  vb   㣮 a  襭
// 筮. ⠥,   ᢥ   .
// .   ८ࠧ  ⠭ ⮣묨
// ⭮⥫쭮  㣠.
{
   PNT v=*vr;
   FXP sna,na,nacosa,nasina;
   FXP nb,nbcosb,nbsinb;
   sna=vb.x*vb.x+vb.y*vb.y;
   na=isqrt(sna)>>4;
   nacosa=vb.y;
   nasina=vb.x;
   nb=isqrt(sna+vb.z*vb.z)>>4;
   nbcosb=na;
   nbsinb=vb.z;
   FXP c;
   if (na)
   {
      c=(nacosa*v.x-nasina*v.y)/na;
      v.y=(nacosa*v.y+nasina*v.x)/na;
      v.x=c;
   }
   // 窠  ⬥ ८ࠧ ஢  ⮣.
   // c=(nbcosb*v.y+nbsinb*v.z)/nb;
   c=0L;
   v.z=(nbcosb*v.z-nbsinb*v.y)/nb;
   v.y=c;

   //     㣮  襭 筮 -
   // 筮 rot_y(&v,a).
   c=(iqmul(iecos(a),v.x)-iqmul(iesin(a),v.z))>>8;
   v.z=(iqmul(iecos(a),v.z)+iqmul(iesin(a),v.x))>>8;
   v.x=c;

   c=(nbcosb*v.y-nbsinb*v.z)/nb;
   v.z=(nbcosb*v.z+nbsinb*v.y)/nb;
   v.y=c;
   if (na)
   {
      c=(nacosa*v.x+nasina*v.y)/na;
      v.y=(nacosa*v.y-nasina*v.x)/na;
      v.x=c;
   }
   *vr=v;
}

// ।⥫쭮 塞   ண 믮 ᫥⥫-
//  ᫥ 㭪樥 rot_vxyz2s().
FXP na1,nacosa1,nasina1;
FXP nb1,nbcosb1,nbsinb1;
FXP ng1,ngcosg1,ngsing1;

void prepare_vxyz2s(PNT vz, PNT vx)
// ⮢    ᮫ न ஢ 
// न ⥬ ௥ ஢ vz, vx. ⠥,
//  vz  ࠢ  Z, vx  ࠢ  X.
{
   FXP sna;
   sna=vz.z*vz.z+vz.x*vz.x;
   na1=isqrt(sna)>>4;
   nacosa1=vz.z;
   nasina1=vz.x;
   nb1=isqrt(sna+vz.y*vz.y)>>4;
   nbcosb1=na1;
   nbsinb1=-vz.y;
   FXP c;
   if (na1)
   {
      c=(nacosa1*vx.x-nasina1*vx.z)/na1;
      vx.z=(nacosa1*vx.z+nasina1*vx.x)/na1;
      vx.x=c;
   }
   vx.y=(nbcosb1*vx.y+nbsinb1*vx.z)/nb1;
   ng1=isqrt(vx.x*vx.x+vx.y*vx.y)>>4;
   ngcosg1=vx.x;
   ngsing1=-vx.y;
}

void rot_vxyz2s(PNT *vr)
//  ᮫ न  v  न ⥬
// ௥ ஢ vz, vx. ⠥,  vz 
// ࠢ  Z, vx  ࠢ  X.   
// ।⥫쭮 ⠢ 㭪樥 prepare_vxyz2s().
{
   PNT v=*vr;
   FXP c;
   if (na1)
   {
      c=(nacosa1*v.x-nasina1*v.z)/na1;
      v.z=(nacosa1*v.z+nasina1*v.x)/na1;
      v.x=c;
   }
   c=(nbcosb1*v.y+nbsinb1*v.z)/nb1;
   v.z=(nbcosb1*v.z-nbsinb1*v.y)/nb1;
   v.y=c;
   c=(ngcosg1*v.x-ngsing1*v.y)/ng1;
   v.y=(ngcosg1*v.y+ngsing1*v.x)/ng1;
   v.x=c;
   *vr=v;
}

inline void rot_vxyz2native(PNT *vr)
//  ᮫ न  v  न ⥬
// ௥ ஢ vz, vx 襣 ࠡ, 稭
//  窥 ⥫. ⠥,  vz  ࠢ  Z, vx 
// ࠢ  X.    ।⥫쭮 ⠢
// 㭪樥 prepare_vxyz2s().
{
   vr->z+=ZN;
   rot_vxyz2s(vr);
   vr->z-=ZN;
}

void inv_rot_vxyz2s(PNT *vr)
//  न  v,   न⭮ ⥬
// ௥ ஢ vz, vx 襣 ࠡ,  ᮫
// ⥬ न. ⠥,  vz  ࠢ  Z, vx 
// ࠢ  X.    ।⥫쭮 ⠢
// 㭪樥 prepare_vxyz2s().

{
   FXP c;

   PNT v=*vr;
   c=(ngcosg1*v.x+ngsing1*v.y)/ng1;
   v.y=(ngcosg1*v.y-ngsing1*v.x)/ng1;
   v.x=c;
   c=(nbcosb1*v.y-nbsinb1*v.z)/nb1;
   v.z=(nbcosb1*v.z+nbsinb1*v.y)/nb1;
   v.y=c;
   if (na1)
   {
      c=(nacosa1*v.x+nasina1*v.z)/na1;
      v.z=(nacosa1*v.z-nasina1*v.x)/na1;
      v.x=c;
   }
   *vr=v;
}

inline void inv_rot_vxyz2native(PNT *vr)
//  न  v,   न⭮ ⥬
// ௥ ஢ vz, vx 襣 ࠡ, 稭
//  窥 ⥫,  ᮫ न. ⠥,  vz 
// ࠢ  Z, vx  ࠢ  X.   
// ।⥫쭮 ⠢ 㭪樥 prepare_vxyz2s().

{
   vr->z+=ZN;
   inv_rot_vxyz2s(vr);
   vr->z-=ZN;
}

// ।⥫쭮 塞   ண 믮 ᫥⥫-
//  ᫥ 㭪樥 rot_vs2xyz().
FXP na2,nacosa2,nasina2;
FXP nb2,nbcosb2,nbsinb2;
FXP ng2,ngcosg2,ngsing2;

void prepare_vs2xyz(PNT vz, PNT vx)
// ⮢    न ஢,   न⭮
// ⥬ ௥ ஢ vz, vx,  ᮫ ⥬
// न. ⠥,  vz  ࠢ  Z, vx 
// ࠢ  X.
{
   FXP sna;
   sna=vz.z*vz.z+vz.x*vz.x;
   na2=isqrt(sna)>>4;
   nacosa2=vz.z;
   nasina2=vz.x;
   nb2=isqrt(sna+vz.y*vz.y)>>4;
   nbcosb2=na2;
   nbsinb2=-vz.y;
   FXP c;
   if (na2)
   {
      c=(nacosa2*vx.x-nasina2*vx.z)/na2;
      vx.z=(nacosa2*vx.z+nasina2*vx.x)/na2;
      vx.x=c;
   }
   vx.y=(nbcosb2*vx.y+nbsinb2*vx.z)/nb2;
   ng2=isqrt(vx.x*vx.x+vx.y*vx.y)>>4;
   ngcosg2=vx.x;
   ngsing2=-vx.y;
}

void rot_vs2xyz(PNT *vr)
//  न  v,   न⭮ ⥬
// ௥ ஢ vz, vx,  ᮫ ⥬ न.
// ⠥,  vz  ࠢ  Z, vx  ࠢ  X.
//    ।⥫쭮 ⠢ 㭪樥
// prepare_vs2xyz().
{
   PNT v=*vr;
   FXP c;
   c=(ngcosg2*v.x+ngsing2*v.y)/ng2;
   v.y=(ngcosg2*v.y-ngsing2*v.x)/ng2;
   v.x=c;
   c=(nbcosb2*v.y-nbsinb2*v.z)/nb2;
   v.z=(nbcosb2*v.z+nbsinb2*v.y)/nb2;
   v.y=c;
   if (na2)
   {
      c=(nacosa2*v.x+nasina2*v.z)/na2;
      v.z=(nacosa2*v.z-nasina2*v.x)/na2;
      v.x=c;
   }
   *vr=v;
}

// *************************************************************************
// ****** 㭪樨 ࠭⢥ ८ࠧ ꥪ⭮ ஢. *******
// *************************************************************************

void calc_v(OBJ *obj)
// ᫥  dirlin, dirrot ꥪ obj. ᯮ 
// vlrfxp, vudfxp, alrfxp, audfxp.
{
   obj->alrfxp+=obj->vlrfxp;
   if (obj->alrfxp>=0) obj->vlr=obj->alrfxp>>8;
   else obj->vlr=-((-obj->alrfxp)>>8);

   obj->audfxp+=obj->vudfxp;
   if (obj->audfxp>=0) obj->vud=obj->audfxp>>8;
   else obj->vud=-((-obj->audfxp)>>8);

   if (obj->vlr)
   {
      obj->alrfxp-=((FXP)obj->vlr)<<8;
      rot_vv_ort(obj->dirlin,&(obj->dirrot),obj->vlr);
   }
   if (obj->vud)
   {
      obj->audfxp-=((FXP)obj->vud)<<8;
      rot_evv_ort(obj->dirrot,&(obj->dirlin),obj->vud);
   }
}

void update_v(OBJ *obj)
//   dirlin, dirrot ꥪ obj  楫 㬥襭
// ᫨⥫ 譮⥩.
{
   normalize(&(obj->dirlin),16*256L);
   normalize(&(obj->dirrot),16*256L);
}

void calc_center(OBJ *obj)
// ᫥  center ꥪ obj.
{
   PNT dp=obj->dirlin;
   normalize(&dp,obj->vfbfxp);
   obj->center.x+=dp.x;
   obj->center.y+=dp.y;
   obj->center.z+=dp.z;
   obj->center.x-=native_mov.x;
   obj->center.y-=native_mov.y;
   obj->center.z-=native_mov.z;
}

void calc_rcenter(OBJ *obj)
// ᫥  rcenter ꥪ obj.
{
   obj->rcenter=obj->center;
   rot_vxyz2native(&obj->rcenter);
}

extern BYTE fire_status;
extern OBJ* shot_obj;
extern IPNTXY native_fire_center;

BYTE save_pels_col[2];
// ᨢ ᯮ  ࠭ 梥⮢  祪  ⭮ 業
// 楫. ᯮ  ॠ樨 ⬠ ண ।
//    ⨢  ५졥.

void visualize_obj(OBJ *obj)
// 楤 㠫樨 ꥪ obj.
{
   WORD curr_pnt;
   const POLY *curr_poly;
   FORM form=obj->form;
   PNT dirlin=obj->dirlin;
   PNT dirrot=obj->dirrot;
   BYTE udsra=obj->udsra;
   PNT rcenter=obj->rcenter;
   WORD i,j,k;

   _fmemcpy(pnts, form.pnts, form.pnts_num*sizeof(PNT));
   _fmemcpy(normals, form.normals, form.polys_num*sizeof(PNT));
   _fmemset(pntflags,0,form.pnts_num);
   _fmemset(polyflags,0,form.polys_num);

   if (fire_status)
   {
      save_pels_col[0]=getpixel(native_fire_center.x,native_fire_center.y);
      save_pels_col[1]=getpixel(native_fire_center.x+1,native_fire_center.y);
      putpixel(native_fire_center.x,native_fire_center.y,TESTCOLOR);
      putpixel(native_fire_center.x+1,native_fire_center.y,TESTCOLOR);
   }

   prepare_vs2xyz(dirlin, dirrot);

   if ((time_counter-obj->fire_counter)<=BEAM_VISIBLE_TIME)
   {
      PNT fire_rcenter=obj->form.fire_center;
      rot_vs2xyz(&fire_rcenter);
      rot_vxyz2s(&fire_rcenter);
      if (udsra) rot_x(&fire_rcenter,udsra);
      fire_rcenter.x+=rcenter.x;
      fire_rcenter.y+=rcenter.y;
      fire_rcenter.z+=rcenter.z;
      obj->fire_rcenter=fire_rcenter;
   }

   for (i=0; i<form.polys_num; i++)
   {
      curr_pnt=form.polys[i].pnts[0];
      rot_vs2xyz(normals+i);
      rot_vxyz2s(normals+i);
      if (udsra) rot_x(normals+i,udsra);
      if (!(pntflags[curr_pnt]&1))
      {
         rot_vs2xyz(pnts+curr_pnt);
         rot_vxyz2s(pnts+curr_pnt);
         if (udsra) rot_x(pnts+curr_pnt,udsra);
         pnts[curr_pnt].x+=rcenter.x;
         pnts[curr_pnt].y+=rcenter.y;
         pnts[curr_pnt].z+=rcenter.z;
         pntflags[curr_pnt]|=1;
      }
      pnts[curr_pnt].z+=ZN;
      if (sqmul(pnts[curr_pnt],normals[i])<0)
      {
         polyflags[i]=1;
         k=form.polys[i].pnts_num;
         for (j=0; j<k; j++)
            pntflags[form.polys[i].pnts[j]]|=2;
      }
      pnts[curr_pnt].z-=ZN;
   }
   for (i=0; i<form.pnts_num; i++)
   {
      if (!(pntflags[i]&2)) continue;
      if (!(pntflags[i]&1))
      {
         rot_vs2xyz(pnts+i);
         rot_vxyz2s(pnts+i);
         if (udsra) rot_x(pnts+i,udsra);
         pnts[i].x+=rcenter.x;
         pnts[i].y+=rcenter.y;
         pnts[i].z+=rcenter.z;
      }
      pnts[i].x=X0+(iqmul(xscales[pnts[i].z>>8],pnts[i].x)>>8);
      pnts[i].y=Y0-(iqmul(yscales[pnts[i].z>>8],pnts[i].y)>>8);
   }
   for (i=0; i<form.polys_num; i++)
   {
      if (!polyflags[i]) continue;
      curr_poly=form.polys+i;
      k=curr_poly->pnts_num;
      for (j=0; j<k; j++)
      {
         polypnts[j<<1]=pnts[curr_poly->pnts[j]].x;
         polypnts[(j<<1)+1]=pnts[curr_poly->pnts[j]].y;
      }
      polypnts[k<<1]=pnts[curr_poly->pnts[0]].x;
      polypnts[(k<<1)+1]=pnts[curr_poly->pnts[0]].y;
      setcolor(curr_poly->fcol);
      if (curr_poly->pattern!=SOLID_FILL)
         setfillpattern(upattern,curr_poly->fcol);
      else setfillstyle(SOLID_FILL,curr_poly->fcol);
      fillpoly(k+1,polypnts);
   }

   if (fire_status)
   {
      if (getpixel(native_fire_center.x,native_fire_center.y)!=TESTCOLOR) shot_obj=obj;
      else putpixel(native_fire_center.x,native_fire_center.y,save_pels_col[0]);
      if (getpixel(native_fire_center.x+1,native_fire_center.y)!=TESTCOLOR) shot_obj=obj;
      else putpixel(native_fire_center.x+1,native_fire_center.y,save_pels_col[1]);
   }

   if (udsra)
   {
      if (MAX_VLR>>9) udsra+=MAX_VLR>>9; else udsra++;
      if (!udsra) udsra++;
      obj->udsra=udsra;
   }
}

// *************************************************************************
// ************ 㭪樨, ⢥騥  뢮 ᬨ᪮ 뫨. *************
// *************************************************************************

PNTXY *rnd_dust_table;
//  砩 x,y-न 뫨    (뫨) ᮧ.
WORD rdt_ptr;
// ᪠ ६ - 㪠⥫  ⥪騥 砩 न 
// ⠡ rnd_dust_table. ᯮ  樨 ᫥⥫쭮
// 砩 砫 x,y-न 뫨.
PNT *dusties;
// ᨢ ⭮⥫ न 뫨,   ࠭
//  ⥪騩  ६,    襣 ࠡ.
IPNTXY *rdusties;
// ᨢ ⭮⥫ न 뫨,   ࠭
//  ⥪騩  ६,  ⮬  襣 ࠡ  ᯥ⨢.

PNT *prev_rdusties;
// ᨢ ⭮⥫ न 뫨, ⢮  ࠭
//  ।騩  ६,  ⮬  襣 ࠡ.

// 㡫 ।⥫쭮 塞   ண 믮
// ᫥⥫쭮 ᫥ 㭪樥 rot_vxyz2s() -  ।饣
//  ६.
FXP prev_na1,prev_nacosa1,prev_nasina1;
FXP prev_nb1,prev_nbcosb1,prev_nbsinb1;
FXP prev_ng1,prev_ngcosg1,prev_ngsing1;

void init_dust()
// 樠 ⠡ rnd_dust_table, dusties, rdusties  rdt_ptr.
{
   WORD i;
   PNTXY rpnt;
   rnd_dust_table=(PNTXY *) farmalloc(RND_DUST_TABLE_SIZE*sizeof(PNTXY));
   rdt_ptr=0;
   dusties=(PNT *) farmalloc(DUSTIES_NUM*sizeof(PNT));
   rdusties=(IPNTXY *) farmalloc(DUSTIES_NUM*sizeof(IPNTXY));
   prev_rdusties=(PNT *) farmalloc(DUSTIES_NUM*sizeof(PNT));
   randomize();
   for (i=0; i<RND_DUST_TABLE_SIZE; i++)
   {
      rpnt.x=(((rand()*(2L*DUST_RADIUS/256L))/RAND_MAX)<<8)-DUST_RADIUS;
      rpnt.y=(((rand()*(2L*DUST_RADIUS/256L))/RAND_MAX)<<8)-DUST_RADIUS;
      rnd_dust_table[i].x=rpnt.x;
      rnd_dust_table[i].y=rpnt.y;
   }
}

void close_dust()
//  rnd_dust_table, dusties, rdusties  .
{
   farfree(rnd_dust_table);
   farfree(dusties);
   farfree(rdusties);
   farfree(prev_rdusties);
}

inline PNTXY calc_rnd_dustie()
//  砩  x,y-न 뫨   ᮧ.
{
   if ((++rdt_ptr)>=RND_DUST_TABLE_SIZE) rdt_ptr=0;
   return rnd_dust_table[rdt_ptr];
}

void first_dust()
// 樠 ⠡ dusties 砫묨 祭ﬨ  ᠬ ࢮ
//  .
{
   WORD i;
   PNTXY xy_dustie;
   prepare_vxyz2s(native.dirlin, native.dirrot);
   for (i=0; i<DUSTIES_NUM; i++)
   {
      xy_dustie=calc_rnd_dustie();
      dusties[i].x=xy_dustie.x;
      dusties[i].y=xy_dustie.y;
      dusties[i].z=((rand()*((DUST_Z0-DUST_Z_VISIBLE)/256L))/RAND_MAX)<<8+
         DUST_Z_VISIBLE;
      inv_rot_vxyz2native(dusties+i);
      prev_rdusties[i]=dusties[i];
      rot_vxyz2native(prev_rdusties+i);
   }
   prev_na1=na1; prev_nacosa1=nacosa1; prev_nasina1=nasina1;
   prev_nb1=nb1; prev_nbcosb1=nbcosb1; prev_nbsinb1=nbsinb1;
   prev_ng1=ng1; prev_ngcosg1=ngcosg1; prev_ngsing1=ngsing1;
}

void prepare_dust()
// 楤 ⮢  㠫樨 ᬨ᪮ 뫨. 믮 
// 祭 "ମ" ६  ४祭 ࠭ .
{
   WORD i;
   PNTXY xy_dustie;
   PNT curr_dustie, curr_rdustie, prev_rdustie;
   PNT v;
   FXP c;
   BYTE mirror_flag;

   for (i=0; i<DUSTIES_NUM; i++)
   {
      curr_dustie=dusties[i];
      mirror_flag=0;
_mirror_dustie:
      curr_dustie.x-=native_mov.x;
      curr_dustie.y-=native_mov.y;
      curr_dustie.z-=native_mov.z;
      curr_rdustie=curr_dustie;
      rot_vxyz2native(&curr_rdustie);
_replace_dustie:
      if (curr_rdustie.z<DUST_Z_VISIBLE)
      {
         xy_dustie=calc_rnd_dustie();
         curr_dustie.x=xy_dustie.x;
         curr_dustie.y=xy_dustie.y;
         curr_dustie.z=DUST_Z0;
         curr_rdustie=curr_dustie;
         inv_rot_vxyz2native(&curr_dustie);
      }
      prev_rdustie=curr_rdustie;
      curr_rdustie.x=(iqmul(xscales[curr_rdustie.z>>8],curr_rdustie.x)>>8);
      curr_rdustie.y=(iqmul(yscales[curr_rdustie.z>>8],curr_rdustie.y)>>8);
      if ((iabs(curr_rdustie.x)>319L) || (iabs(curr_rdustie.y)>160L))
      {
         if (!mirror_flag)
         {

            // 樨  ।⠢ ᮡ 㭪 rot_vxyz2s(),
            // 樨 ன 믮  ⭮ 浪 
            // ⨢ 㣫. ᯮ ।饥 ஢
            // ﭨ.
            v=prev_rdusties[i];
            v.y=-v.y;
            v.z+=ZN;
            c=(prev_ngcosg1*v.x+prev_ngsing1*v.y)/prev_ng1;
            v.y=(prev_ngcosg1*v.y-prev_ngsing1*v.x)/prev_ng1;
            v.x=c;
            c=(prev_nbcosb1*v.y-prev_nbsinb1*v.z)/prev_nb1;
            v.z=(prev_nbcosb1*v.z+prev_nbsinb1*v.y)/prev_nb1;
            v.y=c;
            if (prev_na1)
            {
               c=(prev_nacosa1*v.x+prev_nasina1*v.z)/prev_na1;
               v.z=(prev_nacosa1*v.z-prev_nasina1*v.x)/prev_na1;
               v.x=c;
            }
            v.z-=ZN;
            curr_dustie=v;

            mirror_flag=1;
            goto _mirror_dustie;
         }
         else
         {
            curr_rdustie.z=-10000000L;
            goto _replace_dustie;
         }
      }
      curr_rdustie.x+=X0;
      curr_rdustie.y=Y0-curr_rdustie.y;
      dusties[i]=curr_dustie;
      rdusties[i].x=curr_rdustie.x;
      rdusties[i].y=curr_rdustie.y;
      prev_rdusties[i]=prev_rdustie;
   }
   prev_na1=na1; prev_nacosa1=nacosa1; prev_nasina1=nasina1;
   prev_nb1=nb1; prev_nbcosb1=nbcosb1; prev_nbsinb1=nbsinb1;
   prev_ng1=ng1; prev_ngcosg1=ngcosg1; prev_ngsing1=ngsing1;
}

void visualize_dust()
// 楤 㠫樨 ᬨ᪮ 뫨. ᯮ ,
// ⮢  prepare_dust().
{
   for (WORD i=0; i<DUSTIES_NUM; i++)
      putpixel(rdusties[i].x,rdusties[i].y,WHITE);
}

// *************************************************************************
// ************ 㭪樨, ⢥騥  뢮 " ". **************
// *************************************************************************

const PNT star_centers[STARS_NUM]=
//    ⭮⥫ न,    襣
// ࠡ.
{
   {-150*256L, 100*256L, 1000*256L},
   {500*256L, 500*256L, 500*256L},
   {-100*256L, -100*256L, -1000*256L},
   {-300*256L, -700*256L, 300*256L},
   {1000*256L, 150*256L, -100*256L},
   {-1000*256L, -50*256L, 50*256L},
   {-1000*256L, 50*256L, 50*256L},
};

const IPNTXY star_radiuses[STARS_NUM]=
// _㠫_ ࠤ   X   Y -  , . .  訥
//  室   祭  -      ⨬. :-)
{
   {17,12}, {20,14}, {14,10}, {25,17}, {16,11}, {14,10}, {14,10}
};

const BYTE star_cols[STARS_NUM]=
//  .
{   YELLOW, WHITE, RED, GRAY, RED, WHITE, WHITE};

void visualize_stars()
// 楤 㠫樨 .
{
   WORD i;
   PNT star_rcenter;
   for (i=0; i<STARS_NUM; i++)
   {
      star_rcenter=star_centers[i];
      rot_vxyz2native(&star_rcenter);
      if (star_rcenter.z<OBJ_Z_VISIBLE) continue;
      star_rcenter.x=(iqmul(xscales[star_rcenter.z>>8],star_rcenter.x)>>8);
      star_rcenter.y=(iqmul(yscales[star_rcenter.z>>8],star_rcenter.y)>>8);
      if (((iabs(star_rcenter.x)-star_radiuses[i].x)>319L) ||
      ((iabs(star_rcenter.y)-star_radiuses[i].y)>119L))
         continue;
      star_rcenter.x+=X0;
      star_rcenter.y=Y0-star_rcenter.y;

      setcolor(star_cols[i]);
      setfillstyle(SOLID_FILL,star_cols[i]);
      fillellipse(star_rcenter.x,star_rcenter.y,star_radiuses[i].x,
         star_radiuses[i].y);
   }
}

// *************************************************************************
// **************** 㭪樨, ⢥騥  뢮 ᮮ饭. ****************
// *************************************************************************

char *std_messages[]=
// ᨢ ⠭ ᮮ饭.
{
   "筮:                               ", // message #0
   ": ⥭",
   ": ⠭",
   ": ",
   ": ",

   ": ", // message #5
   ": ࠫ-",
   ": ࠫ-⥭",
   ": ࠫ-",
   ":  ",

   "⮫ !", // message #10
   "஧ 㭨⮦ ࠡ !",
   "ࠡ 㭨⮦, ⮢   ...",
   "窠 ⨭㬠 ࠭   -100 !",
   "窠 ⨭㬠     -100 !",

   "窠 ⨭㬠 ᯥ譮 ⠭ !" // message #15
};

BYTE message_status;
//  㭪樨 뢮 ᮮ饭.
// 1 -    뢮 - ᮮ饭, 0 - .

DWORD message_counter;
// 稪 ६.  뢮 ᮮ饭  祭
// MESSAGE_VISIBLE_TIME ⠪⮢ ⠩.
DWORD dm_counter;
// 稪 ६ (Delay Message Counter).  뢮 ᮮ饭
// १ MESSAGE_DELAY_TIME ⠪⮢ ⠩ ᫥   뢮 ᮮ饭.
BYTE fm_flag;
// "First Message" Flag. 1 -  ᮮ饭 뢮 , 室
// 樠஢ message_counter 砫 祭 ६ 뢮.
BYTE dm_flag;
// "Delay Message" Flag. 1 -   뢮 ᮮ饭 祭, ᮮ饭
// ⫮  ६ MESSAGE_DELAY_TIME, 0 - .

char *message;
// ⥫  ᮮ饭.
int message_x;
// -न  孥 窨 ࠩ ᮮ饭.
int message_y;
// Y-न  孥 窨 ࠩ ᮮ饭.

BYTE *message_sprite;
// ⥫  ࠩ ᮮ饭.
BYTE *save_background_sprite;
// ⥫  ࠩ  ᮮ饭. ᯮ  ࢮ 뢮
// ᮮ饭.

void init_messages()
// 樠 ᮢ ᮮ饭.
{
   message_sprite=(BYTE *) farmalloc(5120);
   save_background_sprite=(BYTE *) farmalloc(5120);
}

void close_messages()
// ⨥ ᮢ ᮮ饭.
{
   farfree(message_sprite);
   farfree(save_background_sprite);
}

void first_message()
// ⮢ ࠬ஢ ᮮ饭  뢮 ࢮ ᮮ饭.
{
   message_status=1;
   message=std_messages[1];
   fm_flag=1;
   dm_flag=0;
   message_y=210;
}

void manage_message()
// ࠡ稪 ᮡ 뢮 ᮮ饭. ⠥,   뢠 
// main_manager() ⮫쪮  砥, ᫨ message_status ࠢ 1.
{
   if ((!dm_flag)&&fm_flag)
   {
      dm_counter=time_counter;
      dm_flag=1;
   }
   if (dm_flag&&((time_counter-dm_counter)<MESSAGE_DELAY_TIME)) return;
   dm_flag=0;

   if (fm_flag) message_counter=time_counter;
   if ((time_counter-message_counter)>MESSAGE_VISIBLE_TIME)
   {
      message_status=0;
      fm_flag=1;
      if (message==std_messages[15])
      {
         message=std_messages[rating+1];
         message_status=1;
      }
      return;
   }
   if (fm_flag)
   {
      sfx_status=0; curr_sfx=sfx4; sfx_counter=0; sfx_status=1;
      font_options=O_BOLD;
      int message_dx=LG.str_len(message);
      message_x=(640-message_dx)/2;
      LG.save_sprite(save_background_sprite,message_x,message_y,
         message_dx,16);
      LG.clear_window(message_x,message_y,message_dx,16,BLACK);
      f_col=WHITE;
      b_col=BLACK;
      LG.put_string(message_x,message_y,message);
      LG.save_sprite(message_sprite,message_x,message_y,message_dx,16);
      LG.restore_sprite(save_background_sprite,message_x,message_y);
      putimage(message_x,message_y,message_sprite,OR_PUT);
      fm_flag=0;
   }
   else putimage(message_x,message_y,message_sprite,OR_PUT);
}

// *************************************************************************
// ************ 㭪樨, ⢥騥  뢮  ࠢ. ************
// *************************************************************************

char *panel_msgs[7][2]=
{
  {"FS","SP"},{"RS","RL"},{"FU","DC"},{"CT","1"},
  {"LT","2"},{"AL","3"},{"RC","4"}
};

int prev_vfbx[2];
// । न x 筮 ⨪쭮  襭
// ᪨ ᪮ (vfb) ( 0-  1-࠭).
int prev_ltx[2];
//    ⥬  (laser_temperature) ( 0-  1-࠭).
int prev_fsx[2];
//    । ࠭  (fshields) ( 0-  1-࠭).
int prev_rsx[2];
//     ࠭  (rshields) ( 0-  1-࠭).
int prev_gs1x[2];
//    ࠭  饣 祭 (gshields1) ( 0-  1-࠭).
int prev_gs2x[2];
//    ࠭  饣 祭 (gshields2) ( 0-  1-࠭).
int prev_gs3x[2];
//    ࠭  饣 祭 (gshields3) ( 0-  1-࠭).
int prev_gs4x[2];
//    ࠭  饣 祭 (gshields4) ( 0-  1-࠭).

int prev_vudx[2];
// । न x 砫쭮 ⨪쭮  襭
// થ ᪮ (vud) ( 0-  1-࠭).
int prev_vlrx[2];
//    ᪮ (vlr) ( 0-  1-࠭).

BYTE prev_sic[2];
// Previous Security Indicator Color.   ᭮ 
// ।襬 蠣 ࠡ祣 横 ( 0-  1-࠭).


BYTE* cdecl radar_sprite;
// ࠩ ࠤ  ᯥ樠쭮 ଠ.

void init_panel()
// 樠 ᮢ .
{
   radar_sprite=(BYTE *) farmalloc(3360);
}

void close_panel()
// ⨥ ᮢ .
{
   farfree(radar_sprite);
}

void save_radar_sprite()
// ࠭ ࠩ ࠤ    radar_sprite.
{
   asm {
      mov al,byte ptr _pages_toggle
      or  al,al
      mov bx,0A000h
      jnz  _main_scr
      mov bx,0A800h
   }
_main_scr:
   asm {
      mov al,8
      mov dx,03CEh
      out dx,al
      mov al,0FFh
      inc dx
      out dx,al
      mov al,2
      mov dx,03C4h
      out dx,al
      mov al,0Fh
      inc dx
      out dx,al
      cld
      les di,_radar_sprite
      push ds
      mov ds,bx
      mov si,04E89h
      mov dx,11
      mov bx,48
      xor cx,cx
      mov al,8
   }
_srsloop1:
   asm {
      mov cl,al
      rep movsd
      add si,bx
      mov cl,al
      rep movsd
      add si,bx
      mov cl,al
      rep movsd
      add si,bx
      dec dx
      jnz _srsloop1
   }
   asm {
      mov si,058D4h
      mov dx,16
      mov bx,44
      xor cx,cx
      mov al,9
   }
_srsloop2:
   asm {
      mov cl,al
      rep movsd
      add si,bx
      mov cl,al
      rep movsd
      add si,bx
      mov cl,al
      rep movsd
      add si,bx
      mov cl,al
      rep movsd
      add si,bx
      dec dx
      jnz _srsloop2
   }
   asm pop ds
}

void restore_radar_sprite()
// ⠭ ࠩ ࠤ    radar_sprite
//      ࠭.
{
   asm {
      mov al,byte ptr _pages_toggle
      or  al,al
      mov bx,0A000h
      jnz  _main_scr
      mov bx,0A800h
   }
_main_scr:
   asm {
      mov al,8
      mov dx,03CEh
      out dx,al
      mov al,0FFh
      inc dx
      out dx,al
      mov al,2
      mov dx,03C4h
      out dx,al
      mov al,0Fh
      inc dx
      out dx,al
      cld
      push ds
      lds si,_radar_sprite
      mov es,bx
      mov di,04E89h
      mov dx,11
      mov bx,48
      xor cx,cx
      mov al,8
   }
_srsloop1:
   asm {
      mov cl,al
      rep movsd
      add di,bx
      mov cl,al
      rep movsd
      add di,bx
      mov cl,al
      rep movsd
      add di,bx
      dec dx
      jnz _srsloop1
   }
   asm {
      mov di,058D4h
      mov dx,16
      mov bx,44
      xor cx,cx
      mov al,9
   }
_srsloop2:
   asm {
      mov cl,al
      rep movsd
      add di,bx
      mov cl,al
      rep movsd
      add di,bx
      mov cl,al
      rep movsd
      add di,bx
      mov cl,al
      rep movsd
      add di,bx
      dec dx
      jnz _srsloop2
   }
   asm pop ds
}

void first_panel()
// 뢮 砫쭮 ﭨ  ࠢ.
{
   WORD j;
   int curr_x;
   font_options=O_BOLD;
   f_col=WHITE;
   b_col=BLACK;

   setviewport(0,0,639,349,CLIP_OFF);
   LG.clear_screen(BLACK);
   LG.box(0,0,640,241,WHITE);
   setviewport(0,250,639,349,CLIP_OFF);
   LG.box(0,0,640,99,WHITE);
   LG.clear_window(20,0,139,99,RED);
   LG.clear_window(480,0,139,99,RED);
   for (j=0; j<7; j++)
   {
      LG.h_line(0,j*14,160,WHITE);
      curr_x=(21-LG.str_len(panel_msgs[j][0]))>>1;
      LG.put_string(curr_x,j*14+3,panel_msgs[j][0]);
      curr_x=620+((21-LG.str_len(panel_msgs[j][1]))>>1);
      LG.put_string(curr_x,j*14+3,panel_msgs[j][1]);
      LG.h_line(480,j*14,160,WHITE);
   }
   LG.clear_window(142,85,17,13,BLACK);
   LG.h_line(0,7*14,160,WHITE);
   LG.h_line(480,7*14,160,WHITE);
   LG.v_line(159,0,99,WHITE);
   LG.v_line(20,0,99,WHITE);
   LG.v_line(480,0,99,WHITE);
   LG.v_line(619,0,99,WHITE);
   LG.v_line(141,84,14,WHITE);

   ellipse(320,50, 0,360, 120,35);
   setlinestyle(USERBIT_LINE,0x1111,1);
   LG.h_line(200,50,240,WHITE);
   setlinestyle(USERBIT_LINE,0xAAAA,1);
   LG.h_line(217,33,84,WHITE);
   LG.h_line(339,33,84,WHITE);
   LG.h_line(217,67,206,WHITE);
   line(320,50,282,16);
   line(320,50,358,16);
   LG.v_line(320,50,35,WHITE);
   setlinestyle(USERBIT_LINE,0xFFFF,1);
   save_radar_sprite();

   // Security Indicator.
   setcolor(GREEN);
   setfillstyle(SOLID_FILL,GREEN);
   fillellipse(181,18,16,12);
   setfillstyle(SOLID_FILL,BLACK);
   fillellipse(181,18,8,6);
   prev_sic[pages_toggle]=GREEN;

   // Front Shield Indicator.
   prev_fsx[pages_toggle]=20L+iqmd(fshields,137L,NATIVE_SHIELDS);
   LG.clear_window(20,2,prev_fsx[pages_toggle]-20+1,11,WHITE);
   // Rear Shield Indicator.
   prev_rsx[pages_toggle]=20L+iqmd(rshields,137L,NATIVE_SHIELDS);
   LG.clear_window(20,16,prev_rsx[pages_toggle]-20+1,11,WHITE);
   // Fuel Indicator.
   LG.clear_window(20,30,120,11,WHITE);
   // Corpus Temperature Indicator.
   LG.clear_window(20,44,10,11,WHITE);
   // Laser Temperature Indicator.
   prev_ltx[pages_toggle]=20L+iqmd(laser_temperature,137L,MAX_LT);
   LG.clear_window(20,58,prev_ltx[pages_toggle]-20+1,11,WHITE);
   // Altitude Indicator.
   LG.clear_window(20,72,138,11,WHITE);
   // Rockets Indicator.
   LG.box(23,86,25,11,WHITE);
   LG.box(51,86,25,11,WHITE);
   LG.box(79,86,25,11,WHITE);
   LG.box(107,86,25,11,WHITE);
   // Speed Indicator.
   prev_vfbx[pages_toggle]=480L+iqmd(native.vfbfxp,137L,MAX_VFB);
   LG.clear_window(480,2,prev_vfbx[pages_toggle]-480+1,11,WHITE);
   // Right-Left Rotation Speed Indicator.
   prev_vlrx[pages_toggle]=549L+iqmd(native.vlrfxp,65L,MAX_VLR);
   LG.clear_window(prev_vlrx[pages_toggle],16,2,11,WHITE);
   // Up-Down Rotation Speed Indicator.
   prev_vudx[pages_toggle]=549L+iqmd(native.vudfxp,65L,MAX_VUD);
   LG.clear_window(prev_vudx[pages_toggle],30,2,11,WHITE);
   // 1st General Purpose Shield Indicator.
   curr_x=iqmd(gshields-NATIVE_SHIELDS*3,137L,NATIVE_SHIELDS);
   if (curr_x<0) curr_x=0;
   prev_gs1x[pages_toggle]=480L+curr_x;
   LG.clear_window(480,44,prev_gs1x[pages_toggle]-480+1,11,WHITE);
   // 2nd General Purpose Shield Indicator.
   curr_x=iqmd(gshields-NATIVE_SHIELDS*2,137L,NATIVE_SHIELDS);
   if (curr_x<0) curr_x=0;
   if (curr_x>137) curr_x=137;
   prev_gs2x[pages_toggle]=480L+curr_x;
   LG.clear_window(480,58,prev_gs2x[pages_toggle]-480+1,11,WHITE);
   // 3rd General Purpose Shield Indicator.
   curr_x=iqmd(gshields-NATIVE_SHIELDS,137L,NATIVE_SHIELDS);
   if (curr_x<0) curr_x=0;
   if (curr_x>137) curr_x=137;
   prev_gs3x[pages_toggle]=480L+curr_x;
   LG.clear_window(480,72,prev_gs3x[pages_toggle]-480+1,11,WHITE);
   // 4th General Purpose Shield Indicator.
   curr_x=iqmd(gshields,137L,NATIVE_SHIELDS);
   if (curr_x>137) curr_x=137;
   prev_gs4x[pages_toggle]=480L+curr_x;
   LG.clear_window(480,86,prev_gs4x[pages_toggle]-480+1,11,WHITE);
}

void visualize_panel()
// 뢮 ⥪饣 ﭨ  ࠢ.
{
   int curr_x;
   int _prev_vfbx=prev_vfbx[pages_toggle];
   int _prev_vlrx=prev_vlrx[pages_toggle];
   int _prev_vudx=prev_vudx[pages_toggle];
   int _prev_ltx=prev_ltx[pages_toggle];
   int _prev_fsx=prev_fsx[pages_toggle];
   int _prev_rsx=prev_rsx[pages_toggle];
   int _prev_gs1x=prev_gs1x[pages_toggle];
   int _prev_gs2x=prev_gs2x[pages_toggle];
   int _prev_gs3x=prev_gs3x[pages_toggle];
   int _prev_gs4x=prev_gs4x[pages_toggle];

   BYTE curr_sic;
   BYTE _prev_sic=prev_sic[pages_toggle];

   setviewport(0,250,639,349,CLIP_OFF);
   // Speed Indicator.
   curr_x=480L+iqmd(native.vfbfxp,137L,MAX_VFB);
   if (curr_x!=_prev_vfbx)
   {
      if (curr_x>_prev_vfbx)
         LG.clear_window(_prev_vfbx+1,2,curr_x-_prev_vfbx,11,WHITE);
      else LG.clear_window(curr_x+1,2,_prev_vfbx-curr_x,11,RED);
      prev_vfbx[pages_toggle]=curr_x;
   }
   // Right-Left Rotation Speed Indicator.
   curr_x=549L+iqmd(native.vlrfxp,65L,MAX_VLR);
   if (curr_x!=_prev_vlrx)
   {
      LG.clear_window(_prev_vlrx,16,2,11,RED);
      LG.clear_window(curr_x,16,2,11,WHITE);
      prev_vlrx[pages_toggle]=curr_x;
   }
   // Up-Down Rotation Speed Indicator.
   curr_x=549L+iqmd(native.vudfxp,65L,MAX_VUD);
   if (curr_x!=_prev_vudx)
   {
      LG.clear_window(_prev_vudx,30,2,11,RED);
      LG.clear_window(curr_x,30,2,11,WHITE);
      prev_vudx[pages_toggle]=curr_x;
   }
   // Laser Temperature Indicator.
   curr_x=20L+iqmd(laser_temperature,137L,MAX_LT);
   if (curr_x!=_prev_ltx)
   {
      if (curr_x>_prev_ltx)
         LG.clear_window(_prev_ltx+1,58,curr_x-_prev_ltx,11,WHITE);
      else LG.clear_window(curr_x+1,58,_prev_ltx-curr_x,11,RED);
      prev_ltx[pages_toggle]=curr_x;
   }
   // Front Shield Indicator.
   curr_x=20L+iqmd(fshields,137L,NATIVE_SHIELDS);
   if (curr_x!=_prev_fsx)
   {
      if (curr_x>_prev_fsx)
         LG.clear_window(_prev_fsx+1,2,curr_x-_prev_fsx,11,WHITE);
      else LG.clear_window(curr_x+1,2,_prev_fsx-curr_x,11,RED);
      prev_fsx[pages_toggle]=curr_x;
   }
   // Rear Shield Indicator.
   curr_x=20L+iqmd(rshields,137L,NATIVE_SHIELDS);
   if (curr_x!=_prev_rsx)
   {
      if (curr_x>_prev_rsx)
         LG.clear_window(_prev_rsx+1,16,curr_x-_prev_rsx,11,WHITE);
      else LG.clear_window(curr_x+1,16,_prev_rsx-curr_x,11,RED);
      prev_rsx[pages_toggle]=curr_x;
   }
   // 1st General Purpose Shield Indicator.
   curr_x=iqmd(gshields-NATIVE_SHIELDS*3,137L,NATIVE_SHIELDS);
   if (curr_x<0) curr_x=0;
   curr_x+=480;
   if (curr_x!=_prev_gs1x)
   {
      if (curr_x>_prev_gs1x)
         LG.clear_window(_prev_gs1x+1,44,curr_x-_prev_gs1x,11,WHITE);
      else LG.clear_window(curr_x+1,44,_prev_gs1x-curr_x,11,RED);
      prev_gs1x[pages_toggle]=curr_x;
   }
   // 2nd General Purpose Shield Indicator.
   curr_x=iqmd(gshields-NATIVE_SHIELDS*2,137L,NATIVE_SHIELDS);
   if (curr_x<0) curr_x=0;
   if (curr_x>137) curr_x=137;
   curr_x+=480;
   if (curr_x!=_prev_gs2x)
   {
      if (curr_x>_prev_gs2x)
         LG.clear_window(_prev_gs2x+1,58,curr_x-_prev_gs2x,11,WHITE);
      else LG.clear_window(curr_x+1,58,_prev_gs2x-curr_x,11,RED);
      prev_gs2x[pages_toggle]=curr_x;
   }
   // 3rd General Purpose Shield Indicator.
   curr_x=iqmd(gshields-NATIVE_SHIELDS,137L,NATIVE_SHIELDS);
   if (curr_x<0) curr_x=0;
   if (curr_x>137) curr_x=137;
   curr_x+=480;
   if (curr_x!=_prev_gs3x)
   {
      if (curr_x>_prev_gs3x)
         LG.clear_window(_prev_gs3x+1,72,curr_x-_prev_gs3x,11,WHITE);
      else LG.clear_window(curr_x+1,72,_prev_gs3x-curr_x,11,RED);
      prev_gs3x[pages_toggle]=curr_x;
   }
   // 4th General Purpose Shield Indicator.
   curr_x=iqmd(gshields,137L,NATIVE_SHIELDS);
   if (curr_x>137) curr_x=137;
   curr_x+=480;
   if (curr_x!=_prev_gs4x)
   {
      if ((_prev_gs4x==617)&&(curr_x<617))
         { message_status=1; fm_flag=1; message=std_messages[11]; }
      if (curr_x>_prev_gs4x)
         LG.clear_window(_prev_gs4x+1,86,curr_x-_prev_gs4x,11,WHITE);
      else LG.clear_window(curr_x+1,86,_prev_gs4x-curr_x,11,RED);
      prev_gs4x[pages_toggle]=curr_x;
   }

   // Security Indicator.
   curr_sic=GREEN;
   if ((objs_num-trashies_num)||(fshields<NATIVE_SHIELDS)||
   (rshields<NATIVE_SHIELDS)) curr_sic=YELLOW;
   if ((!fshields)&&(!rshields)) curr_sic=RED;
   if (gshields<NATIVE_SHIELDS)
      if (time_counter&0x20L) curr_sic=RED; else curr_sic=BLACK;
   if (curr_sic!=_prev_sic)
   {
      setcolor(curr_sic);
      setfillstyle(SOLID_FILL,curr_sic);
      fillellipse(181,18,16,12);
      setfillstyle(SOLID_FILL,BLACK);
      fillellipse(181,18,8,6);
      prev_sic[pages_toggle]=curr_sic;
   }
}

void visualize_radar()
// 뢮 ⥪饣 ﭨ ࠤ.
{
   WORD i;
   PNT radar;
   OBJ *curr_obj;

   restore_radar_sprite();
   setviewport(0,250,639,347,CLIP_ON);

   for (i=0; i<OBJS_NUM; i++)
   {
      curr_obj=objs+i;
      if (curr_obj->active && curr_obj->radar_flag)
      {
         radar=curr_obj->rcenter;
         radar.x=iqmd(radar.x,120L,VISIBLE_RADIUS)+320L;
         radar.y=iqmd(radar.y,35L,VISIBLE_RADIUS);
         radar.z=50L-iqmd(radar.z,35L,VISIBLE_RADIUS);
         switch (curr_obj->form.form_type)
         {
            case 1: setcolor(YELLOW); break;
            case 2: setcolor(RED); break;
            case 3: setcolor(BLUE); break;
            case 4: setcolor(WHITE); break;
            case 5: setcolor(WHITE); break;
         }
         line(radar.x,radar.z,radar.x,radar.z-radar.y);
         line(radar.x,radar.z-radar.y,radar.x+5L,radar.z-radar.y);
      }
   }
}

// *************************************************************************
// ************************  ஢ ꥪ⮢ ***********************
// *************************************************************************

signed char compare_objs(int i1, int i2)
// ࠢ  rcenter.z  ꥪ⮢  ᫥饩 ஢.
{
   if (visible_objs[i1]->rcenter.z>visible_objs[i2]->rcenter.z) return -1;
   if (visible_objs[i1]->rcenter.z<visible_objs[i2]->rcenter.z) return 1;
   else return 0;
}

OBJ* swap_data;

void qsort_core(int l, int r)
//  ஢ ᨢ visible_objs.
{
   int i=l;
   int j=r;
   int x=(l+r)/2;
   do
   {
      while (compare_objs(i,x)==-1)
      {
         i++;
      }
      while (compare_objs(x,j)==-1)
      {
         j--;
      }
      if (i<=j)
      {
         if (x==i) x=j;
         else if (x==j) x=i;
         swap_data=visible_objs[i];
         visible_objs[i]=visible_objs[j];
         visible_objs[j]=swap_data;
         i++;
         j--;
      }
   } while (i<=j);
   if (l<j) qsort_core(l, j);
   if (i<r) qsort_core(i, r);
}

void sort_objs()
// ஢ ᨢ visible_objs  뢠  rcenter.z.
{
   qsort_core(0,visible_objs_num-1);
}

// *************************************************************************
// ******************* ⥫㠫쭮  ணࠬ *********************
// *************** (   ⢥ ⥫). ****************
// *************************************************************************

// *************************************************************************
// ******* 㭪樨, ⢥騥   ᮧ  㭨⮦ ꥪ⮢. ********
// *************************************************************************

OBJ* add_to_objs(const OBJ *obj)
//  ꥪ  ᨢ ꥪ⮢. 樠樨 ꥪ  ந室.
// 頥  㪠⥫  ꥪ (㦥  ᨢ)  NULL  砥
// 㤠 樨 (ᨢ ꥪ⮢ ).
{
   if (objs_num==OBJS_NUM) return NULL;
   WORD i=0;
   while (objs[i].active) i++;
   objs[i]=*obj;
   objs_num++;
   if ((obj->form.form_type==4)||(obj->form.form_type==5)) trashies_num++;
   return objs+i;
}

BYTE init_obj(OBJ *obj)
// 樠 ࠬ஢ ꥪ. ⥫  NULL .
// 1 -  諠 ᯥ譮, 0 -  (⪠ 樠஢ ꥪ
//  ᮬ NULL).
{
   if (obj==NULL) return 0;
   obj->init_obj(obj);
   return 1;
}

void first_objs()
// 樠 ᨢ ꥪ⮢.
{
   for (WORD i=0; i<OBJS_NUM; i++) objs[i].active=0;
   objs_num=0;
   trashies_num=0;
}

void create_native()
//  襣, த ꥪ. :-)
{
   native=obj0;
   init_obj(&native);
   laser_temperature=0L;
   fshields=rshields=NATIVE_SHIELDS;
   gshields=NATIVE_SHIELDS*4L;
   cash=0L;
   rating=HARMLESS;
}

OBJ* create_obj(const OBJ *obj)
//  । ࠦ᪮ ꥪ. :-(
// 頥  㪠⥫  ꥪ (㦥  ᨢ)  NULL  砥
// 㤠 樨 (ᨢ ꥪ⮢ ).
{
   OBJ *curr_obj;
   init_obj(curr_obj=add_to_objs(obj));
   return curr_obj;
}

OBJ* create_random_obj()
//  । ࠦ᪮ ꥪ 砩 ࠧ.
// 頥  㪠⥫  ꥪ (㦥  ᨢ)  NULL  砥
// 㤠 樨 (ᨢ ꥪ⮢ ).
{
   WORD random_enemy=rand();
      if (random_enemy<10000)
         return create_obj(&obj1);
      else if (random_enemy<20000)
              return create_obj(&obj2);
           else return create_obj(&obj3);
}


void manage_objs_creation()
// ࠡ稪 砩 ᮧ ꥪ⮢ ⨢.
{
   if ((objs_num-trashies_num)||(objs_num==OBJS_NUM)||
   (rand()>(native.vfbfxp)))
      return;
   WORD situations[3];
   // ᨢ 樮 ࠭. ᫨ 砩 ᫮ 室  ।
   //   ᥤ ࠭,  ᮮ⢥ 
   // .   ᥣ   ⨯ 砩 権 
   // ࠭ 0  RAND_MAX ।।,   室 ।
   //  ࠭.  ⢥  ᮮ⭮襭,  ஬  
   // 樨 ࠧ筮 ⥯ ᫮.
   switch (rating)
   {
      case HARMLESS:
         situations[0]=20000;
         situations[1]=30000;
         situations[2]=32000;
         break;
      case MOSTLY_HARMLESS:
         situations[0]=15000;
         situations[1]=25000;
         situations[2]=30000;
         break;
      case POOR:
         situations[0]=7000;
         situations[1]=25000;
         situations[2]=30000;
         break;
      case AVERAGE:
         situations[0]=7000;
         situations[1]=20000;
         situations[2]=27000;
         break;
      case ABOVE_AVERAGE:
         situations[0]=5000;
         situations[1]=15000;
         situations[2]=25000;
         break;
      case COMPETENT:
         situations[0]=2000;
         situations[1]=10000;
         situations[2]=25000;
         break;
      case DANGEROUS:
         situations[0]=2000;
         situations[1]=7000;
         situations[2]=20000;
         break;
      case ELITE:
         situations[0]=15000;
         situations[1]=25000;
         situations[2]=30000;
         break;
   }
   WORD random_situation=rand();
   OBJ *obj;
   if (random_situation<situations[0])
   {
      obj=create_random_obj();
      obj->center.x=20*256L; obj->center.y=0L; obj->center.z=-1300*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
      obj->dirrot.x=1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;
      return;
   }
   if ((random_situation>=situations[0])&&(random_situation<situations[1]))
   {
      obj=create_random_obj();
      obj->center.x=-920*256L; obj->center.y=-10*256L; obj->center.z=-920*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=1*256L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
      obj->dirrot.x=1*256L; obj->dirrot.y=0L; obj->dirrot.z=-1*256L;

      obj=create_random_obj();
      if (!obj) return;
      obj->center.x=970*256L; obj->center.y=10*256L; obj->center.z=-970*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=-1*256L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
      obj->dirrot.x=-1*256L; obj->dirrot.y=0L; obj->dirrot.z=-1*256L;
      return;
   }
   if ((random_situation>=situations[1])&&(random_situation<situations[2]))
   {
      obj=create_random_obj();
      obj->center.x=20*256L; obj->center.y=-10*256L; obj->center.z=1200*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=-1*256L;
      obj->dirrot.x=-1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;

      obj=create_random_obj();
      if (!obj) return;
      obj->center.x=-920*256L; obj->center.y=0L; obj->center.z=-920*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=1*256L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
      obj->dirrot.x=1*256L; obj->dirrot.y=0L; obj->dirrot.z=-1*256L;

      obj=create_random_obj();
      if (!obj) return;
      obj->center.x=970*256L; obj->center.y=10*256L; obj->center.z=-970*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=-1*256L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
      obj->dirrot.x=-1*256L; obj->dirrot.y=0L; obj->dirrot.z=-1*256L;
      return;
   }
   // ᫨   , , ᣥ஢ ᠬ ᫮
   //  .
   {
      obj=create_random_obj();
      obj->center.x=10*256L; obj->center.y=-10*256L; obj->center.z=1100*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=-1*256L;
      obj->dirrot.x=-1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;

      obj=create_random_obj();
      obj->center.x=-10*256L; obj->center.y=0*256L; obj->center.z=-1150*256L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=0L; obj->dirlin.y=0L; obj->dirlin.z=1*256L;
      obj->dirrot.x=1*256L; obj->dirrot.y=0L; obj->dirrot.z=0L;

      obj=create_random_obj();
      obj->center.x=1250*256L; obj->center.y=10*256L; obj->center.z=10L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=-1*256L; obj->dirlin.y=0L; obj->dirlin.z=0L;
      obj->dirrot.x=0L; obj->dirrot.y=0L; obj->dirrot.z=1*256L;

      obj=create_random_obj();
      obj->center.x=-1300*256L; obj->center.y=20*256L; obj->center.z=-10L;
      obj->vlrfxp=0L; obj->vudfxp=0L; obj->alrfxp=0L; obj->audfxp=0L;
      obj->dirlin.x=1*256L; obj->dirlin.y=0L; obj->dirlin.z=0L;
      obj->dirrot.x=0L; obj->dirrot.y=0L; obj->dirrot.z=-1*256L;
   }
}

void kill_native()
// ⮦ 襣, த ꥪ. :-(
{
    WORD i;
    OBJ *curr_obj;
    FXP radius;
    DWORD start_time,demo_start_time;

    native.vlrfxp=MAX_VLR/4L;
    if (!native.vlrfxp) native.vlrfxp=1L;
    native.vudfxp=0L;
    native.vfbfxp=0L;
    native.dirlin.x=-native.dirlin.x;
    native.dirlin.y=-native.dirlin.y;
    native.dirlin.z=-native.dirlin.z;
    prepare_vxyz2s(native.dirlin, native.dirrot);

    curr_obj=create_obj(&obj4); /* trashie #1 */
    if (curr_obj)
    {
       curr_obj->center.x=5*256L;
       curr_obj->center.y=3*256L;
       curr_obj->center.z=0*256L;
       curr_obj->vlrfxp=MAX_VLR;
       curr_obj->udsra=32;
       inv_rot_vxyz2s(&curr_obj->dirlin);
       inv_rot_vxyz2native(&curr_obj->center);
    }

    curr_obj=create_obj(&obj5); /* trashie #2 */
    if (curr_obj)
    {
       curr_obj->center.x=-6*256L;
       curr_obj->center.y=5*256L;
       curr_obj->center.z=5*256L;
       curr_obj->dirlin.x=4L;
       curr_obj->dirlin.y=-12L;
       curr_obj->vlrfxp=-MAX_VLR;
       curr_obj->udsra=16;
       inv_rot_vxyz2s(&curr_obj->dirlin);
       inv_rot_vxyz2native(&curr_obj->center);
    }

    curr_obj=create_obj(&obj4); /* trashie #3 */
    if (curr_obj)
    {
       curr_obj->center.x=8*256L;
       curr_obj->center.y=-6*256L;
       curr_obj->center.z=-2*256L;
       curr_obj->dirlin.x=-14L;
       curr_obj->dirlin.y=5L;
       curr_obj->vlrfxp=MAX_VLR/2L;
       if (!curr_obj->vlrfxp) curr_obj->vlrfxp=1L;
       curr_obj->udsra=48;
       inv_rot_vxyz2s(&curr_obj->dirlin);
       inv_rot_vxyz2native(&curr_obj->center);
    }

    curr_obj=create_obj(&obj5); /* trashie #4 */
    if (curr_obj)
    {
       curr_obj->center.x=-3*256L;
       curr_obj->center.y=-2*256L;
       curr_obj->center.z=-2*256L;
       curr_obj->dirlin.x=3L;
       curr_obj->dirlin.y=-4L;
       curr_obj->vlrfxp=MAX_VLR;
       curr_obj->udsra=96;
       inv_rot_vxyz2s(&curr_obj->dirlin);
       inv_rot_vxyz2native(&curr_obj->center);
    }

    curr_obj=create_obj(&obj5); /* trashie #5 */
    if (curr_obj)
    {
       curr_obj->center.x=6*256L;
       curr_obj->center.y=-2*256L;
       curr_obj->center.z=-3*256L;
       curr_obj->vlrfxp=-MAX_VLR/2;
       if (!curr_obj->vlrfxp) curr_obj->vlrfxp=1L;
       curr_obj->udsra=64;
       inv_rot_vxyz2s(&curr_obj->dirlin);
       inv_rot_vxyz2native(&curr_obj->center);
    }

    first_dust();
    for (i=0; i<2; i++)
    {
       visualize_radar();
       visualize_panel();
       setcolor(RED);
       setfillstyle(SOLID_FILL,RED);
       fillellipse(181,18,16,12);
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       fillellipse(181,18,8,6);
       LG.toggle_screen();
    }

    fm_flag=1; message_status=1; message=std_messages[12];
    message_y=112;
    sfx_status=0; curr_sfx=sfx6; sfx_counter=0; sfx_status=1;

    demo_start_time=start_time=time_counter;
    do
    {
      calc_v(&native);
      update_v(&native);
      native_mov=native.dirlin;
      normalize(&native_mov,native.vfbfxp);
      prepare_vxyz2s(native.dirlin, native.dirrot);
      visible_objs_num=0;
      for (i=0; i<OBJS_NUM; i++)
      {
        if (objs[i].active)
        {
          curr_obj=objs+i;
          curr_obj->calc_obj(curr_obj);
          calc_v(curr_obj);
          update_v(curr_obj);
          calc_center(curr_obj);
          calc_rcenter(curr_obj);
          curr_obj->rcenter.z+=ZN;
          radius=iqnorm(curr_obj->rcenter);
          curr_obj->rcenter.z-=ZN;
          if (radius>DESTRUCTION_RADIUS)
          {
            curr_obj->active=0;
            objs_num--;
            if ((curr_obj->form.form_type==4)||
            (curr_obj->form.form_type==5)) trashies_num--;
          }
          else
          {
             if (radius<VISIBLE_RADIUS)
             {
   curr_obj->radar_flag=1;
   if ((curr_obj->rcenter.z>OBJ_Z_VISIBLE)&&
      (iabs(iqmul(curr_obj->rcenter.x,xscales[curr_obj->rcenter.z>>8]))-
         iqmul(MLS,xscales[(curr_obj->rcenter.z-MLS)>>8])<320*256L)&&
       (iabs(iqmul(curr_obj->rcenter.y,yscales[curr_obj->rcenter.z>>8]))-
         iqmul(MLS,yscales[(curr_obj->rcenter.z-MLS)>>8])<120*256L))
   {
      visible_objs[visible_objs_num++]=curr_obj;
   }
             }
             else
             {
                curr_obj->radar_flag=0;
             }
          }
        }
      }
      if (visible_objs_num>1) sort_objs();
      prepare_dust();
      LG.prepare_view();
      setviewport(1,1,638,239,CLIP_ON);
      visualize_stars();
      visualize_dust();
      for (i=0; i<visible_objs_num; i++)
        visualize_obj(visible_objs[i]);
      message_counter=time_counter;
      if (message_status) manage_message();
_wait:
      asm mov ebx, start_time
      asm {
         mov eax,dword ptr _time_counter
         sub eax,ebx
         cmp eax,dword ptr _MIN_TIME_SLICE
         jl _wait
      }
      start_time=time_counter;
      LG.toggle_screen();
    } while ((time_counter-demo_start_time)<360L);
   kbd_flags=ENTER_MASK;
   native.shields=0L;
}

void kill_obj(OBJ *obj)
//  㭨⮦ ࠡ ⨢. :-)
{
   sfx_status=0; curr_sfx=sfx7; sfx_counter=0; sfx_status=1;
   if ((obj->form.form_type!=4)&&(obj->form.form_type!=5))
   {
      OBJ *curr_obj=create_obj(&obj4); /* trashie #1 */
      if (curr_obj)
      {
         curr_obj->center=obj->center;
         curr_obj->vlrfxp=MAX_VLR;
         curr_obj->udsra=32;
         curr_obj->dirlin.x=0*256L;
         curr_obj->dirlin.y=1*256L;
         curr_obj->dirlin.z=0*256L;
      }

      curr_obj=create_obj(&obj5); /* trashie #2 */
      if (curr_obj)
      {
         curr_obj->center=obj->center;
         curr_obj->vlrfxp=MAX_VLR;
         curr_obj->udsra=64;
         curr_obj->dirlin.x=0*256L;
         curr_obj->dirlin.y=-1*128L;
         curr_obj->dirlin.z=0*256L;
      }
   }
   else trashies_num--;

   obj->active=0;
   objs_num--;
}

// *************************************************************************
// ************ 㭪樨, ⢥騥  ५,  ࠡ ***********
// **** ⥬ , ஢ ⮫, 㭨⮦ ꥪ⮢. ***
// *************************************************************************

BYTE fire_status;
//  ५:     ந ५  ⥪饬 ⠪
// ࠡ祣 横.   ࠡ稩 横.

DWORD fire_counter;
// 稪 ६.  ஢ ୮ ⨥  FIRE
//  祭 ६ ( ⠪ ⠩) FIRE_DELAY_TIME  ᮢ뢠
//    祭 ६ BEAM_VISIBLE_TIME.
DWORD laser_counter;
// 稪 ६.  ⠡஢ ᪮ 뢠 ⥬
//   ஢ LASER_DEC_STEP/⠪ ⠩.
DWORD shields_counter;
// 稪 ६.  ⠡஢ ᪮ ॣ樨 
//   ஢ SHIELDS_INC_STEP/⠪ ⠩.

OBJ* shot_obj;
// ⪫ 楤 㠫樨 ꥪ⮢    ५.
//  砥 ᯥ 㪠⥫ ⠭   ꥪ,
//   ᮤন  .

IPNTXY native_fire_center;
//  窠 業 ࠦ  ⨢.  न 
//   ⭮ 窨 業 楫 -  .

//  ਠ  窨 業 ࠦ  ⨢.
const IPNTXY native_fire_center1={X0-2,Y0-2};
const IPNTXY native_fire_center2={X0+2,Y0+2};
const IPNTXY native_fire_center3={X0+2,Y0-2};
const IPNTXY native_fire_center4={X0-2,Y0+2};

BYTE collision_status;
// 1 -  ⮫, 0 - . ६ ᯮ  main_manager()
//  manage_shields().

BYTE fc_flag;
// "First Collision" flag. ﭨ  ࠡﬨ ⠫ 
// . 쭥 ᫥⥫쭮  ﭨ 
//   ,    ४,    ⮢  ᫥饬
// ⮫. ६ ᯮ  main_manager()  manage_shields().

DWORD collision_counter;
// 稪 ६.   ॣ樨 ⮫, ᫥
//   㣮 १ ஬⮪ ६  COLLISION_DELAY_TIME.

OBJ* collided_obj;
// ⥫  ꥪ,   ந諮 ⮫.


void init_params()
// ⠭ ࠬ஢ 襣 ࠡ  砫 ࠡ祣 横.
{
   fire_status=0;
   collision_status=0;
   fc_flag=1;
   collision_counter=0L;
   fire_counter=0L;
   laser_counter=time_counter;
   shields_counter=time_counter;
   native_fire_center=native_fire_center1;
}

void detect_fire()
// ⥪஢ ᮡ ५ 襣 ࠡ  ⨢  ⥪饣
// ⠪ ࠡ祣 横. ந  믮 楤 㠫樨
// ꥪ⮢.
{
   shot_obj=NULL;
   if ((!(kbd_status&FIRE_MASK)) ||
   ((time_counter-fire_counter)<FIRE_DELAY_TIME)||
   ((laser_temperature+LT_INC_STEP)>MAX_LT))
      fire_status=0;
   else
   {
      fire_counter=time_counter;
      fire_status=1;
      if ((native_fire_center.x==native_fire_center1.x)&&
      (native_fire_center.y==native_fire_center1.y))
         { native_fire_center=native_fire_center2; return; }
      if ((native_fire_center.x==native_fire_center2.x)&&
      (native_fire_center.y==native_fire_center2.y))
         { native_fire_center=native_fire_center3; return; }
      if ((native_fire_center.x==native_fire_center3.x)&&
      (native_fire_center.y==native_fire_center3.y))
         { native_fire_center=native_fire_center4; return; }
      if ((native_fire_center.x==native_fire_center4.x)&&
      (native_fire_center.y==native_fire_center4.y))
         { native_fire_center=native_fire_center1; return; }
   }
}

void manage_native_fire()
// ࠡ⪠ ᮡ ५ 襣 ࠡ  ⨢  ⥪饣 ⠪
// ࠡ祣 横. ந ᫥ 믮 楤 㠫樨
// ꥪ⮢.
{
   if (((time_counter-fire_counter)>BEAM_VISIBLE_TIME)&&(!fire_status))
      return;
   setcolor(WHITE);
   line(139,238,native_fire_center.x,native_fire_center.y);
   line(179,238,native_fire_center.x,native_fire_center.y);
   line(459,238,native_fire_center.x,native_fire_center.y);
   line(499,238,native_fire_center.x,native_fire_center.y);
   if (fire_status)
   {
      sfx_status=0;
      if (shot_obj==NULL) curr_sfx=sfx1; else curr_sfx=sfx2;
      sfx_counter=0;
      sfx_status=1;
   }
   if (shot_obj)
   {
      shot_obj->shields-=NATIVE_WEAPONS;
      if (shot_obj->shields<0L)
      {
         DWORD prev_cash=cash;
         cash+=shot_obj->price;
         _fmemset(std_messages[0]+12,0x00,30);
         ultoa(cash, std_messages[0]+12, 10);
         WORD i=32;
         while (!(std_messages[0][i])) i--;
         std_messages[0][++i]=' ';
         std_messages[0][++i]='';
         std_messages[0][++i]='';
         std_messages[0][++i]='';
         std_messages[0][++i]='';
         std_messages[0][++i]='';
         std_messages[0][++i]='';
         message=std_messages[0];
         if ((cash>=MOSTLY_HARMLESS_CASH)&&(prev_cash<MOSTLY_HARMLESS_CASH))
            { message=std_messages[2]; rating=MOSTLY_HARMLESS; }
         if ((cash>=POOR_CASH)&&(prev_cash<POOR_CASH))
            { message=std_messages[3]; rating=POOR; }
         if ((cash>=AVERAGE_CASH)&&(prev_cash<AVERAGE_CASH))
            { message=std_messages[4]; rating=AVERAGE; }
         if ((cash>=ABOVE_AVERAGE_CASH)&&(prev_cash<ABOVE_AVERAGE_CASH))
            { message=std_messages[5]; rating=ABOVE_AVERAGE; }
         if ((cash>=COMPETENT_CASH)&&(prev_cash<COMPETENT_CASH))
            { message=std_messages[6]; rating=COMPETENT; }
         if ((cash>=DANGEROUS_CASH)&&(prev_cash<DANGEROUS_CASH))
            { message=std_messages[7]; rating=DANGEROUS; }
         if ((cash>=ELITE_CASH)&&(prev_cash<ELITE_CASH))
            { message=std_messages[8]; rating=ELITE; }
         if (prev_cash!=cash)
         {
            message_status=1;
            fm_flag=1;
         }
         kill_obj(shot_obj);
      }
   }
}

void manage_lt()
// ࠡ⪠   ⥬  襣 ࠡ.
{
   if (fire_status) laser_temperature+=LT_INC_STEP;
   if (laser_temperature)
   {
      laser_temperature-=LT_DEC_STEP*(time_counter-laser_counter);
      if (laser_temperature<0L) laser_temperature=0L;
   }
   laser_counter=time_counter;
}

void manage_shields()
// ࠡ⪠   魮   襣 ࠡ.
{
   //  ६⮢ ࠬ஢  _ ७_.
   if (fire_status) gshields-=SHIELDS_DEC_STEP;

   //  ६⮢ ࠬ஢  _ ७_.
   if (objs_num-trashies_num)
      gshields+=SHIELDS_INC_STEP*(time_counter-shields_counter);
   else gshields+=SHIELDS_INC_STEP*6L*(time_counter-shields_counter);
   //  饭 gshields 筮  ஢ ॣ樨
   // __  ࠭, . . ९ gshields  ࠧ
   // ࠡ뢠 .
   shields_counter=time_counter;

   //   ७ 饭 ࠬ஢   ஢ઠ  ࠭.
   if (fshields<0L) { gshields+=fshields; fshields=0L; }
   if (rshields<0L) { gshields+=rshields; rshields=0L; }
   if (gshields<0L)
   {
      gshields=0L;
      kill_native();
   }

   if (gshields>(NATIVE_SHIELDS*4))
   {
      fshields+=gshields-(NATIVE_SHIELDS*4);
      rshields+=gshields-(NATIVE_SHIELDS*4);
      gshields=NATIVE_SHIELDS*4;
   }
   if (fshields>NATIVE_SHIELDS) fshields=NATIVE_SHIELDS;
   if (rshields>NATIVE_SHIELDS) rshields=NATIVE_SHIELDS;
}

void manage_collision()
// ࠡ⪠ ᮡ ⮫ 襣 ࠡ  ⨢  ⥪饣
// ⠪ ࠡ祣 横. 楤 뢠 ⮫쪮  砥, ᫨
// ((fc_flag==1)&&(collision_status=1))
{
   fc_flag=0;
   if ((time_counter-collision_counter)<COLLISION_DELAY_TIME)
   {
      collision_counter=time_counter;
      return;
   }
   collision_counter=time_counter;
   sfx_status=0; curr_sfx=sfx5; sfx_counter=0; sfx_status=1;
   message_status=1;
   fm_flag=1;
   message=std_messages[10];
   collided_obj->shields-=ENEMY_DEC_SHIELDS_AFTER_COLLISION;
   fshields-=NATIVE_DEC_SHIELDS_AFTER_COLLISION;
   rshields-=NATIVE_DEC_SHIELDS_AFTER_COLLISION;
   if (collided_obj->shields<0L)
   {
      kill_obj(collided_obj);
   }
}

void manage_objs_fire()
// ࠡ⪠ ᮡ ५ ࠡ ⨢  襬 ࠡ 
// ⥪饣 ⠪ ࠡ祣 横.
{
   WORD i;
   OBJ *obj;
   PNT fire_rcenter;
   for (i=0; i<OBJS_NUM; i++)
   {
      obj=objs+i;
      if ((!obj->active)||
      ((time_counter-obj->fire_counter)>BEAM_VISIBLE_TIME))
         continue;

      if (!obj->visible_flag)
      // ꥪ - , 楤 vizualize_obj()  ⠫ 
      //   業 ५ fire_rcenter, ਤ   ᠬ.
      {
         prepare_vs2xyz(obj->dirlin, obj->dirrot);
         fire_rcenter=obj->form.fire_center;
         rot_vs2xyz(&fire_rcenter);
         rot_vxyz2s(&fire_rcenter);
         if (obj->udsra) rot_x(&fire_rcenter,obj->udsra);
         fire_rcenter.x+=obj->rcenter.x;
         fire_rcenter.y+=obj->rcenter.y;
         fire_rcenter.z+=obj->rcenter.z;
         obj->fire_rcenter=fire_rcenter;
      }

      fire_rcenter=obj->fire_rcenter;
      if (obj->fire_status)
      {
         sfx_status=0;
         curr_sfx=sfx3;
         sfx_counter=0;
         sfx_status=1;
         if (fire_rcenter.z<=-ZN) rshields-=obj->weapons;
         else fshields-=obj->weapons;
         int rnd=rand()&0x03;
         switch (rnd)
         {
            case 0:
               obj->bob_pnt.x=0;
               obj->bob_pnt.y=((long)rand()*239L)/RAND_MAX;
               break;
            case 1:
               obj->bob_pnt.x=639;
               obj->bob_pnt.y=((long)rand()*239L)/RAND_MAX;
               break;
           case 2:
               obj->bob_pnt.x=((long)rand()*639L)/RAND_MAX;
               obj->bob_pnt.y=0;
               break;
            case 3:
               obj->bob_pnt.x=((long)rand()*639L)/RAND_MAX;
               obj->bob_pnt.y=239;
               break;
         }
      }
      if (fire_rcenter.z<=(-ZN+3*256L)) continue;
      fire_rcenter.x=X0+(iqmul(xscales[fire_rcenter.z>>8],fire_rcenter.x)>>8);
      fire_rcenter.y=Y0-(iqmul(yscales[fire_rcenter.z>>8],fire_rcenter.y)>>8);
      setcolor(WHITE);
      line(fire_rcenter.x,fire_rcenter.y,
         obj->bob_pnt.x,obj->bob_pnt.y);
   }
}

void view_cursor()
// ᮢ 楫 襣 ࠡ.
{
   LG.h_line(X0-44,Y0,25,WHITE);
   LG.h_line(X0+20,Y0,25,WHITE);
   LG.v_line(X0,Y0-31,17,WHITE);
   LG.v_line(X0,Y0+14,17,WHITE);
}

// *************************************************************************
// ********** 㭪樨, ⢥騥    ⠭ . *********
// *************************************************************************

int file_handler;
// ਯ 뢠/뢠 䠩.

char huge ok_text[]="OK";
char huge cancel_text[]="⬥";

class cmbutton_io
//  ।⠢  .
{
   public:
   // ***   ***
   int x,y,dx,dy;
   // ᯮ    ⥭/⨢ ࠭.
   char *str_ptr;
   // , ⠥   .

   // ***  /. ***
   cmbutton_io(int _x=0, int _y=0, int _dx=100, int _dy=19,
      char *_str_ptr);
   //   cmbutton_io.

   // ***  . ***
   void put_cmbutton();
   // ᮢ    ⥭/⨢ ࠭.
};

cmbutton_io::cmbutton_io(int _x, int _y, int _dx, int _dy,
   char *_str_ptr)
{
   x=_x;
   y=_y;
   dx=_dx;
   dy=_dy;
   str_ptr=_str_ptr;
}

void cmbutton_io::put_cmbutton()
{
   LG.redraw_3d(x,y,dx,dy);
   f_col=WHITE;
   b_col=DARKGRAY;
   LG.put_string(x+(dx-LG.str_len(str_ptr))/2,y+(dy-FONT_HEIGHT)/2,str_ptr);
}

char save_text[]="࠭ ";
char load_text[]="⠭ ";
char filename_text[]=" :";

class cmdialog_io
//  ।⠢  / 䠩.
{
   public:
   // ***   ***
   int x,y,dx,dy;
   // ᯮ   ⨢ ࠭.
   int event_options;
   // O_LOAD - প 䥩  䠩,
   // O_SAVE - প 䥩  䠩.
   int def_options;
   // O_DEF -  १ ⢨ 짮⥫ 뫮 ।  䠩,
   // O_NODEF - .
   cmbutton_io *ok_button;
   cmbutton_io *cancel_button;
   char str_ptr[MAX_PATH+2];
   int curr_csr;
   // 饥    ப .
   int name_x,name_y,name_dx,name_dy;
   // ᯮ ப  䠩  ⨢ ࠭.
   int curr_chars;
   // 饥 ⢮  ᨬ  ப  䠩.
   int curr_tag;
   // 騩 ꥪ  - ப ,  ,  CANCEL.

   // ***  /. ***
   cmdialog_io(int _event_options=O_LOAD);
   //   cmdialog_io.
   ~cmdialog_io();
   //   cmdialog_io.

   // ***  . ***
   void redraw_cmdialog();
   // ᮢ   ⨢ ࠭.
   void calc_dx();
   void redraw_name();
   void rdr_clr_cursor(char c);
   void redraw_cursor();
   void clear_cursor();
   void name_handler();
   // ࠡ稪 ᮡ⨩    䠩.
   void cmdialog_handler();
   //  ࠡ稪 ᮡ⨩ .
};

cmdialog_io::cmdialog_io(int _event_options)
{
   dx=350;
   dy=93;
   x=(640-dx)/2;
   y=(350-dy)/2;
   event_options=_event_options;
   ok_button=new cmbutton_io(x+(dx-70)/2-45, y+dy-33,70,19,
      ok_text);
   cancel_button=new cmbutton_io(x+(dx-70)/2+45, y+dy-33,70,19,
      cancel_text);
   name_x=x+20+LG.str_len(filename_text)+7;
   name_y=y+35;
   name_dy=FONT_HEIGHT;
}

cmdialog_io::~cmdialog_io()
{
   delete ok_button;
   delete cancel_button;
}

void cmdialog_io::redraw_cmdialog()
{
   if (event_options==O_SAVE) LG.redraw_win(x,y,dx,dy,save_text);
   else LG.redraw_win(x,y,dx,dy,load_text);
   f_col=WHITE; b_col=DARKGRAY;
   font_options=O_NORMAL;
   LG.put_string(x+10,y+35,filename_text);
   int curr_x=x+20+LG.str_len(filename_text);
   LG.redraw_state_bar(curr_x,y+32,dx-(curr_x-x)-15,17,NULL,DARKGRAY);
   ok_button->put_cmbutton();
   cancel_button->put_cmbutton();
}

void cmdialog_io::calc_dx()
{
   name_dx=LG.str_len(str_ptr);
}

void cmdialog_io::redraw_name()
{
   str_ptr[curr_chars]=' ';
   str_ptr[curr_chars+1]=' ';
   str_ptr[curr_chars+2]='\x0';
   f_col=WHITE; b_col=DARKGRAY;
   LG.put_string(name_x,name_y,str_ptr);
   str_ptr[curr_chars]='\x0';
}

void cmdialog_io::rdr_clr_cursor(char c)
{
   int csr_x0, csr_y0, csr_dy;
   csr_y0=name_y-1;
   csr_dy=FONT_HEIGHT+2;
   char sav_char=str_ptr[curr_csr];
   str_ptr[curr_csr]=0;
   csr_x0=name_x+LG.str_len(str_ptr)-1;
   str_ptr[curr_csr]=sav_char;
   LG.v_line(csr_x0,csr_y0,csr_dy,c);
}

void cmdialog_io::redraw_cursor()
{
   rdr_clr_cursor(WHITE);
}

void cmdialog_io::clear_cursor()
{
   rdr_clr_cursor(DARKGRAY);
}

void cmdialog_io::name_handler()
{
   curr_csr=0;
   redraw_cursor();
   char_mode=0;
   command_mode=0;
   do
   {
      LI.kbd_input();
      if (command_mode)
      {
         unsigned char huge *dest_ptr;
         unsigned char huge *src_ptr;
         switch (command)
         {
            case RIGHT:
               command_mode=0;
               if (!str_ptr[curr_csr]) break;
               clear_cursor();
               curr_csr++;
               redraw_cursor();
               break;
            case LEFT:
               command_mode=0;
               if (!curr_csr) break;
               clear_cursor();
               curr_csr--;
               redraw_cursor();
               break;
            case DEL:
               command_mode=0;
               if (!str_ptr[curr_csr]) break;
               clear_cursor();
               curr_chars--;
               dest_ptr=str_ptr+curr_csr;
               src_ptr=str_ptr+curr_csr+1;
               do *(dest_ptr++)=*(src_ptr++); while (*(dest_ptr-1));
               calc_dx();
               redraw_name();
               redraw_cursor();
               break;
            case BACKSPACE:
               command_mode=0;
               if (!curr_csr) break;
               clear_cursor();
               curr_csr--;
               curr_chars--;
               dest_ptr=str_ptr+curr_csr;
               src_ptr=str_ptr+curr_csr+1;
               do *(dest_ptr++)=*(src_ptr++); while (*(dest_ptr-1));
               calc_dx();
               redraw_name();
               redraw_cursor();
               break;
         }
      }
      if (char_mode)
      {
         char_mode=0;
         if (curr_chars==MAX_PATH-1) continue;
         curr_chars++;
         clear_cursor();
         char sav_char, prev_sav_char;
         char huge *dest_ptr=str_ptr+curr_csr+1;
         prev_sav_char=*(dest_ptr-1);
         do
         {
            sav_char=*dest_ptr;
            *(dest_ptr++)=prev_sav_char;
            prev_sav_char=sav_char;
         } while (*(dest_ptr-1));
         str_ptr[curr_csr]=ch;
         curr_csr++;
         calc_dx();
         redraw_name();
         redraw_cursor();
      }
   } while ((!command_mode) || ((command!=ENTER)&&(command!=TAB)));
   clear_cursor();
}

void cmdialog_io::cmdialog_handler()
{
   str_ptr[0]=0;
   curr_chars=0;
   curr_csr=0;
   curr_tag=0;
   do
   {
      command_mode=0;
      if (curr_tag==0) name_handler();
      else LI.kbd_input();
      if (command_mode&&(command==TAB))
      {
         switch (curr_tag)
         {
            case 0:
               LG.box(ok_button->x-1,ok_button->y-1,ok_button->dx+2,
                  ok_button->dy+2,WHITE);
               break;
            case 1:
               LG.box(ok_button->x-1,ok_button->y-1,ok_button->dx+2,
                  ok_button->dy+2,DARKGRAY);
               LG.box(cancel_button->x-1,cancel_button->y-1,cancel_button->dx+2,
                  cancel_button->dy+2,WHITE);
               break;
            case 2:
               LG.box(cancel_button->x-1,cancel_button->y-1,cancel_button->dx+2,
                  cancel_button->dy+2,DARKGRAY);
               break;
         }
         curr_tag++;
         if (curr_tag==3) curr_tag=0;
      }
   } while ((!command_mode)||(command!=ENTER));
   command_mode=0;
   if ((curr_tag==2)||(!str_ptr[0])) def_options=O_NODEF;
   else def_options=O_DEF;
}

cmdialog_io *_cmdialog;
char filename[16];

DWORD enter_counter=0L;
// 稪 ६.  ஢ ⨥ ENTER  祭
// ENTER_DELAY_TIME. ,  ᢮ ।,   䫨
//  ⢥ত   cmdialog_io::cmdialog_handler() 
// ᯮ 砭 ࠡ祣 横  main_manager().

void _xwrite(int handle, void *buf, unsigned len)
//   xor 0ACh.
{
   WORD i;
   BYTE *chbuf=(BYTE *) buf;
   for (i=0; i<len; i++) chbuf[i]^=(BYTE) i;
   _write(handle,buf,len);
   for (i=0; i<len; i++) chbuf[i]^=(BYTE) i;
}

void save_game()
{
   WORD i;
   LI.close_io();
   _cmdialog=new cmdialog_io();
   _cmdialog->event_options=O_SAVE;
   _cmdialog->redraw_cmdialog();
   setvisualpage(pages_toggle^1);

   _cmdialog->cmdialog_handler();

   LI.init_io();
   enter_counter=time_counter;
   init_params();

   if (_cmdialog->def_options==O_NODEF) return;

   i=0;
   while (filename[i]=_cmdialog->str_ptr[i]) i++;
   filename[i++]='.';
   filename[i++]='d';
   filename[i++]='a';
   filename[i++]='t';
   filename[i++]=0;

   file_handler=open(filename,O_TRUNC | O_CREAT | O_RDWR | O_BINARY,
      S_IREAD | S_IWRITE);
   if (file_handler==-1)
   {
      message_status=1; fm_flag=1; message=std_messages[14];
      _cmdialog->def_options=O_NODEF;
      return;
   }

   _xwrite(file_handler,&objs_num,sizeof(int));
   _xwrite(file_handler,&trashies_num,sizeof(int));
   for (i=0; i<OBJS_NUM; i++)
   {
      _xwrite(file_handler,objs+i,sizeof(OBJ));
   }
   _xwrite(file_handler,&native,sizeof(OBJ));
   _xwrite(file_handler,&laser_temperature,sizeof(FXP));
   _xwrite(file_handler,&fshields,sizeof(FXP));
   _xwrite(file_handler,&rshields,sizeof(FXP));
   _xwrite(file_handler,&gshields,sizeof(FXP));
   _xwrite(file_handler,&cash,sizeof(DWORD));
   _xwrite(file_handler,&rating,sizeof(BYTE));

   close(file_handler);
   delete _cmdialog;
   message_status=1; fm_flag=1; message=std_messages[13];
}

void _xread(int handle, void *buf, unsigned len)
// ⥭  ᫥騬 xor 0ACh.
{
   _read(handle,buf,len);
   WORD i;
   BYTE *chbuf=(BYTE *) buf;
   for (i=0; i<len; i++) chbuf[i]^=(BYTE) i;
}

void load_game()
{
   WORD i;
   LI.close_io();
   _cmdialog=new cmdialog_io();
   _cmdialog->event_options=O_LOAD;
   _cmdialog->redraw_cmdialog();
   setvisualpage(pages_toggle^1);

   _cmdialog->cmdialog_handler();

   LI.init_io();
   enter_counter=time_counter;
   init_params();

   if (_cmdialog->def_options==O_NODEF) return;

   i=0;
   while (filename[i]=_cmdialog->str_ptr[i]) i++;
   filename[i++]='.';
   filename[i++]='d';
   filename[i++]='a';
   filename[i++]='t';
   filename[i++]=0;

   file_handler=open(filename,O_RDWR|O_BINARY);
   if (file_handler==-1)
   {
      message_status=1; fm_flag=1; message=std_messages[14];
      _cmdialog->def_options=O_NODEF;
      return;
   }

   _xread(file_handler,&objs_num,sizeof(int));
   _xread(file_handler,&trashies_num,sizeof(int));
   for (i=0; i<OBJS_NUM; i++)
   {
      _xread(file_handler,objs+i,sizeof(OBJ));
      switch (objs[i].form.form_type)
      {
         case 1:
            objs[i].form.pnts=obj1.form.pnts;
            objs[i].form.normals=obj1.form.normals;
            objs[i].form.polys=obj1.form.polys;
            objs[i].init_obj=obj1.init_obj;
            objs[i].calc_obj=obj1.calc_obj;
            objs[i].vfbfxp=MAX_VFB/3L;
            if (!objs[i].vfbfxp) objs[i].vfbfxp=1L;
            break;
         case 2:
            objs[i].form.pnts=obj2.form.pnts;
            objs[i].form.normals=obj2.form.normals;
            objs[i].form.polys=obj2.form.polys;
            objs[i].init_obj=obj2.init_obj;
            objs[i].calc_obj=obj2.calc_obj;
            objs[i].vfbfxp=MAX_VFB/2L;
            if (!objs[i].vfbfxp) objs[i].vfbfxp=1L;
            break;
         case 3:
            objs[i].form.pnts=obj3.form.pnts;
            objs[i].form.normals=obj3.form.normals;
            objs[i].form.polys=obj3.form.polys;
            objs[i].init_obj=obj3.init_obj;
            objs[i].calc_obj=obj3.calc_obj;
            objs[i].vfbfxp=MAX_VFB*5L/12L;
            if (!objs[i].vfbfxp) objs[i].vfbfxp=1L;
            break;
         case 4:
            objs[i].form.pnts=obj4.form.pnts;
            objs[i].form.normals=obj4.form.normals;
            objs[i].form.polys=obj4.form.polys;
            objs[i].init_obj=obj4.init_obj;
            objs[i].calc_obj=obj4.calc_obj;
            objs[i].vlrfxp=MAX_VLR/4L;
            if (!objs[i].vlrfxp) objs[i].vlrfxp=1L;
            objs[i].vfbfxp=MAX_VFB/6L;
            if (!objs[i].vfbfxp) objs[i].vfbfxp=1L;
            break;
         case 5:
            objs[i].form.pnts=obj5.form.pnts;
            objs[i].form.normals=obj5.form.normals;
            objs[i].form.polys=obj5.form.polys;
            objs[i].init_obj=obj5.init_obj;
            objs[i].calc_obj=obj5.calc_obj;
            objs[i].vlrfxp=MAX_VLR/4L;
            if (!objs[i].vlrfxp) objs[i].vlrfxp=1L;
            objs[i].vfbfxp=MAX_VFB/6L;
            if (!objs[i].vfbfxp) objs[i].vfbfxp=1L;
            break;
      }

   }
   _xread(file_handler,&native,sizeof(OBJ));
   native.init_obj=obj0.init_obj;
   native.calc_obj=obj0.calc_obj;
   if (native.vfbfxp>MAX_VFB) native.vfbfxp=MAX_VFB;
   if (native.vlrfxp>MAX_VLR) native.vlrfxp=MAX_VLR;
   if (native.vlrfxp<-MAX_VLR) native.vlrfxp=-MAX_VLR;
   if (native.vudfxp>MAX_VUD) native.vudfxp=MAX_VUD;
   if (native.vudfxp<-MAX_VUD) native.vudfxp=-MAX_VUD;
   _xread(file_handler,&laser_temperature,sizeof(FXP));
   _xread(file_handler,&fshields,sizeof(FXP));
   _xread(file_handler,&rshields,sizeof(FXP));
   _xread(file_handler,&gshields,sizeof(FXP));
   _xread(file_handler,&cash,sizeof(DWORD));
   _xread(file_handler,&rating,sizeof(BYTE));

   first_dust();
   first_message();
   for (i=0; i<2; i++)
   {
      LG.toggle_screen();
      first_panel();
   }

   close(file_handler);
   delete _cmdialog;
   message_status=1; fm_flag=1; message=std_messages[15];
}

// *************************************************************************
// ************** 㭪樨, ⢥騥  ன ࠬ஢ **************
// ************************** ॠ쭮 ६. ***************************
// *************************************************************************

void tune_delay()
// ன ࠬ DELAY - ६ প ᫥ ४祭 ࠭.
{
   DWORD start_time;
   //  稪 ⠩  砫 ஢.
   DWORD cycles_num=0L;
   // ⢮ 横 ।᫥  祭 36- ⠪⮢ ⠩.

   //  樠樨 ࠬ஢ ⮢ main_manager().
   WORD i;
   OBJ *curr_obj;
   FXP radius;

   first_objs();
   create_native();
   first_dust();
   init_params();

   //   । 뢠  ⠩.
   asm {
      mov ebx,dword ptr _time_counter
   }
_wait_int08h:
   asm {
      mov eax,dword ptr _time_counter
      cmp eax,ebx
      jz _wait_int08h
      mov start_time, eax
   }

   //  ஢ ६ ।᫥  権,  뢠
   // 栭  ࠭.
_test_incomplete:
      native.calc_obj(&native);
      calc_v(&native);
      update_v(&native);
      native_mov=native.dirlin;
      normalize(&native_mov,native.vfbfxp);
      prepare_vxyz2s(native.dirlin, native.dirrot);
      visible_objs_num=0;
      for (i=0; i<OBJS_NUM; i++)
      {
        if (objs[i].active)
        {
        } //  ।쭮 砥 ᫮  ࠧ  믮.
      }
      if (visible_objs_num>1) sort_objs();
      prepare_dust();
      visualize_radar();
   cycles_num++;
   asm {
      mov eax,dword ptr _time_counter
      sub eax,start_time
      cmp eax,36
      jge _end
      jmp far _test_incomplete
   }
_end:
   float d=ceil((14.0-495.0/cycles_num)*4.0);
   DELAY=(int) d;
   if (DELAY<0) DELAY=0;
}

void tune_speed()
// ன ࠬ஢ ᪮⥩  ࠡ.
{
   DWORD start_time;
   //  稪 ⠩  砫 ஢.
   DWORD cycles_num=0L;
   // ⢮ ࠡ 横  祭 108- ⠪⮢ ⠩.

   //  樠樨 ࠬ஢ ⮢ main_manager().
   WORD i;
   OBJ *curr_obj;
   FXP radius;

   first_objs();
   create_native();
   native.vfbfxp=0L;

   curr_obj=create_obj(&test_obj);
   curr_obj->center.x*=-1;
   curr_obj->center.y*=-1;
   curr_obj=create_obj(&test_obj);
   curr_obj->center.x*=-1;
   curr_obj->center.y*=1;
   curr_obj=create_obj(&test_obj);
   curr_obj->center.x*=1;
   curr_obj->center.y*=-1;
   curr_obj=create_obj(&test_obj);
   curr_obj->center.x*=1;
   curr_obj->center.y*=1;

   first_dust();
   init_params();
   first_panel();
   upattern=upattern1;

   //   । 뢠  ⠩.
   asm {
      mov ebx,dword ptr _time_counter
   }
_wait_int08h:
   asm {
      mov eax,dword ptr _time_counter
      cmp eax,ebx
      jz _wait_int08h
      mov start_time, eax
   }

   //  ஢ ६ । ࠡ祣 横.
_test_incomplete:

      native.calc_obj(&native);
      native.vlrfxp=5*256L;
      native.vfbfxp=native.vudfxp=0L;
      calc_v(&native);
      update_v(&native);
      native_mov=native.dirlin;
      normalize(&native_mov,native.vfbfxp);
      prepare_vxyz2s(native.dirlin, native.dirrot);
      visible_objs_num=0;
      for (i=0; i<OBJS_NUM; i++)
      {
        if (objs[i].active)
        {
          curr_obj=objs+i;
          curr_obj->calc_obj(curr_obj);
          calc_v(curr_obj);
          update_v(curr_obj);
          calc_center(curr_obj);
          calc_rcenter(curr_obj);
          radius=iqnorm(curr_obj->rcenter);
          if (radius>DESTRUCTION_RADIUS)
          {
            curr_obj->active=0;
            objs_num--;
            if ((curr_obj->form.form_type==4)||
            (curr_obj->form.form_type==5)) trashies_num--;
          }
          else
          {
             if (radius<VISIBLE_RADIUS)
             {
   curr_obj->radar_flag=1;
   if ((curr_obj->rcenter.z>OBJ_Z_VISIBLE)&&
      (iabs(iqmul(curr_obj->rcenter.x,xscales[curr_obj->rcenter.z>>8]))-
         iqmul(MLS,xscales[(curr_obj->rcenter.z-MLS)>>8])<320*256L)&&
       (iabs(iqmul(curr_obj->rcenter.y,yscales[curr_obj->rcenter.z>>8]))-
         iqmul(MLS,yscales[(curr_obj->rcenter.z-MLS)>>8])<120*256L))
   {
      visible_objs[visible_objs_num++]=curr_obj;
   }
             }
             else
             {
                curr_obj->radar_flag=0;
             }
          }
        }
      }
      if (visible_objs_num>1) sort_objs();
      prepare_dust();
      visualize_radar();
      visualize_panel();
      LG.prepare_view();
      setviewport(1,1,638,239,CLIP_ON);
      visualize_stars();
      visualize_dust();
      for (i=0; i<visible_objs_num; i++)
        visualize_obj(visible_objs[i]);
      view_cursor();
      setactivepage(pages_toggle^1);
      setvisualpage(pages_toggle);
      if (DELAY) delay(DELAY);

   cycles_num++;
   asm {
      mov eax,dword ptr _time_counter
      sub eax,start_time
      cmp eax,108
      jge _end
      jmp far _test_incomplete
   }
_end:

   float k=ceil(108.0/cycles_num);
   MIN_TIME_SLICE=k;

   k=MIN_TIME_SLICE/3.0;
   MAX_VFB*=k;
   if (MAX_VFB>VFB_LIMIT) MAX_VFB=VFB_LIMIT;
   if (MAX_VFB==0L) MAX_VFB=1L;
   VFB_STEP*=k*k;
   if (VFB_STEP>VFB_LIMIT) VFB_STEP=VFB_LIMIT;
   if (VFB_STEP==0L) VFB_STEP=1L;

   MAX_VUD*=k;
   if (MAX_VUD>VUD_LIMIT) MAX_VUD=VUD_LIMIT;
   if (MAX_VUD==0L) MAX_VUD=1L;
   VUD_INC_STEP*=k*k;
   if (VUD_INC_STEP>VUD_LIMIT) VUD_INC_STEP=VUD_LIMIT;
   if (VUD_INC_STEP==0L) VUD_INC_STEP=1L;
   VUD_DEC_STEP*=k*k;
   if (VUD_DEC_STEP>VUD_LIMIT) VUD_DEC_STEP=VUD_LIMIT;
   if (VUD_DEC_STEP==0L) VUD_DEC_STEP=1L;

   MAX_VLR*=k;
   if (MAX_VLR>VLR_LIMIT) MAX_VLR=VLR_LIMIT;
   if (MAX_VLR==0L) MAX_VLR=1L;
   VLR_INC_STEP*=k*k;
   if (VLR_INC_STEP>VLR_LIMIT) VLR_INC_STEP=VLR_LIMIT;
   if (VLR_INC_STEP==0L) VLR_INC_STEP=1L;
   VLR_DEC_STEP*=k*k;
   if (VLR_DEC_STEP>VLR_LIMIT) VLR_DEC_STEP=VLR_LIMIT;
   if (VLR_DEC_STEP==0L) VLR_DEC_STEP=1L;
}


// *************************************************************************
// ************************* 稩 横 ணࠬ. ***********************
// *************************************************************************

void main_manager()
// 稩 横 ணࠬ.
{
  WORD i;
  OBJ *curr_obj;
  FXP radius;
  DWORD start_time;
  BYTE collided;
  OBJ *_collided_obj;

  do
  {
    first_screen();

    first_objs();
    create_native();
    native.dirlin.y=iqmd(rand(),1*256L,RAND_MAX)-128L;
    if (rand()>(RAND_MAX/2)) native.dirlin.z=-native.dirlin.z;
    first_dust();
    first_message();
    init_params();
    for (i=0; i<2; i++)
    {
       first_panel();
       LG.toggle_screen();
    }
    start_time=time_counter;
    do
    {
      manage_objs_creation();
      native.calc_obj(&native);
      calc_v(&native);
      update_v(&native);
      native_mov=native.dirlin;
      normalize(&native_mov,native.vfbfxp);
      prepare_vxyz2s(native.dirlin, native.dirrot);
      visible_objs_num=0;
      collided=0;
      for (i=0; i<OBJS_NUM; i++)
      {
        if (objs[i].active)
        {
          curr_obj=objs+i;
          curr_obj->rcenter.z+=ZN;
          radius=iqnorm(curr_obj->rcenter);
          curr_obj->rcenter.z-=ZN;
          curr_obj->radius=radius;
          curr_obj->calc_obj(curr_obj);
          calc_v(curr_obj);
          update_v(curr_obj);
          calc_center(curr_obj);
          calc_rcenter(curr_obj);
          curr_obj->visible_flag=0;
          if (radius>DESTRUCTION_RADIUS)
          {
            curr_obj->active=0;
            objs_num--;
            if ((curr_obj->form.form_type==4)||
            (curr_obj->form.form_type==5)) trashies_num--;
          }
          else
          {
             if (radius<VISIBLE_RADIUS)
             {
   if (radius<COLLISION_RADIUS)
   {
      collided=1;
      _collided_obj=curr_obj;
   }
   curr_obj->radar_flag=1;
   if ((curr_obj->rcenter.z>OBJ_Z_VISIBLE)&&
      (iabs(iqmul(curr_obj->rcenter.x,xscales[curr_obj->rcenter.z>>8]))-
         iqmul(MLS,xscales[(curr_obj->rcenter.z-MLS)>>8])<320*256L)&&
       (iabs(iqmul(curr_obj->rcenter.y,yscales[curr_obj->rcenter.z>>8]))-
         iqmul(MLS,yscales[(curr_obj->rcenter.z-MLS)>>8])<120*256L))
   {
      visible_objs[visible_objs_num++]=curr_obj;
      curr_obj->visible_flag=1;
   }
             }
             else
             {
                curr_obj->radar_flag=0;
             }
          }
        }
      }
      if (collided&&(!collision_status))
      {
         collision_status=1;
         collided_obj=_collided_obj;
      }
      if ((!collided)&&(collision_status))
      {
         collision_status=0;
         fc_flag=1;
      }
      if (visible_objs_num>1) sort_objs();
      prepare_dust();
      visualize_radar();
      visualize_panel();
      LG.prepare_view();
      setviewport(1,1,638,239,CLIP_ON);
      visualize_stars();
      visualize_dust();
      detect_fire();
      for (i=0; i<visible_objs_num; i++)
        visualize_obj(visible_objs[i]);
      manage_native_fire();
      manage_objs_fire();
      if (fc_flag&&collision_status) manage_collision();
      manage_lt();
      manage_shields();
      if (message_status) manage_message();
      if (native.shields) view_cursor();
_wait:
      asm mov ebx, start_time
      asm {
         mov eax,dword ptr _time_counter
         sub eax,ebx
         cmp eax,dword ptr _MIN_TIME_SLICE
         jl _wait
      }
      if (kbd_flags&F2_MASK)
         { kbd_flags&=F2_MASK^0xFFFFU; save_game(); }
      if (kbd_flags&F3_MASK)
         { kbd_flags&=F3_MASK^0xFFFFU; load_game(); }
      start_time=time_counter;
      if (!(kbd_flags&ENTER_MASK)) LG.toggle_screen();
      if ((time_counter-enter_counter)<ENTER_DELAY_TIME)
         kbd_flags&=ENTER_MASK^0xFFFFU;
    } while (!(kbd_flags&(ESC_MASK | ENTER_MASK)));
    kbd_flags&=ENTER_MASK^0xFFFFU;
  } while (!(kbd_flags&ESC_MASK));
}

// *************************************************************************
// ******** 㫨 樠樨   ணࠬ. 窠 室. ********
// *************************************************************************

void main_init()
{
   LG.init_graph();
   LG.clear_screen(BLACK);
   LG.clear_window(120,137,400,36,DARKGRAY);
   b_col=DARKGRAY;
   f_col=LIGHTBLUE;
   font_options=O_NORMAL;
   int curr_y=149, curr_x;
   char *curr_msg="। த⢨ ⥬,  ...";
   curr_x=LG.center_string(curr_msg);
   LG.put_string(curr_x,curr_y,curr_msg);
   LG.box(120,137,400,36,GREEN);
   LG.toggle_screen();

   setactivepage(pages_toggle);
   init_shared();
   init_objs();
   init_panel();
   init_messages();
   init_sine();
   init_sqrt();
   init_dust();
   init_scales();
   LI.init_io();
   LT.init_timer();
   setactivepage(pages_toggle^1);
   tune_delay();
   tune_speed();
}

void main_close()
{
   close_shared();
   close_objs();
   close_sine();
   close_sqrt();
   close_scales();
   close_dust();
   close_panel();
   close_messages();

   LI.close_io();
   LT.close_timer();
   LG.close_graph();
   printf("AT FATHERLAND SERVICE\n");
   printf("Copyright (c) 1998 Copper Feet Corp., All Rights Reserved\n");
   printf("Thanks for playing AFS!\n");
}

void main()
{
   system("BREAK OFF");

   if (_argc==1)
   {
      sounds_flag=1;
      main_init(); // 맮 楤 樠樨
      main_manager(); // 맮 楤 ᭮ 横 ணࠬ
      main_close();  // ⨥ ணࠬ
   }
   else
   {
      if (!strcmp(_argv[1],"/?"))
      {
         clrscr();
         printf("AT FATHERLAND SERVICE\n");
         printf("Copyright (c) 1998 Copper Feet Corp., All Rights Reserved\n\n");
         printf("Note: if launched with \"-nosound\" option AFS will run with ");
         printf("sounds turned off.\n\n");
      }
      if (!strcmp(_argv[1],"-nosound"))
      {
         sounds_flag=0;
         main_init(); // 맮 楤 樠樨
         main_manager(); // 맮 楤 ᭮ 横 ணࠬ
         main_close();  // ⨥ ணࠬ
      }
   }
}