'***************************************************************************
'* *********************************************************************** *
'* *      --- by KCL ---  Outer Space's Labyrinth  --- by KCL ---        * *
'* *                      ------------------------                        * *
'* *  This is a DEMO game.                                     (1998)    * *
'* *  Please, read the READ-ME.TXT file!                                * *
'* *  Programmed by Kleber Caf Lins (KCL) - Use freely, but mention me. * *
'* *********************************************************************** *
'***************************************************************************

DECLARE SUB GameSeq (levelshortcut)
DECLARE SUB Info ()
DECLARE SUB ReadScenario (n, xscreen, yscreen, xposition, yposition)
DECLARE SUB GameOn ()
DECLARE SUB KeyboardStatus ()
DECLARE SUB MovePersonagem ()
DECLARE SUB Morre (jeito$)
DECLARE SUB OpenEnergyWall ()
DECLARE SUB PegaObjeto ()
DECLARE SUB SoundConfig ()
DECLARE SUB Redraw ()
DECLARE SUB LerImagens ()
DECLARE SUB MapImages (MapNumber)
DECLARE SUB SoundTest ()                         'Dmaplay.bas
DECLARE SUB WriteDSP (byte%)
'--- Definir o tamanho de acordo com o sample .SND --------------
DIM SHARED WavBuffer1(1 TO 1) AS STRING * 20000    '(Mx 32k)
'----------------------------------------------------------------
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
DECLARE SUB PlayWave (soundfile$)
DECLARE SUB Atrasar (quantidade)                'Atraso
DECLARE SUB VelocityFactor ()                   'VeloFact
DECLARE SUB FadeToBlack (passos, modo)          'ColorFunctions
DECLARE SUB FadeToGrayScale (passos)
DECLARE SUB GetPalette ()
DECLARE SUB SetPalette ()
DECLARE SUB KCLlogo ()
'------------------------------------
DECLARE SUB EndGame (modo$)
DECLARE SUB OpenMap (MapFileName$)
DECLARE SUB PutObject ()
DECLARE SUB RestoreScreen (n!)
DECLARE SUB SetEnergy (EnergyChange!)
DECLARE SUB Menu ()
DECLARE SUB ReadGIF (filename$, nodefine$)
DECLARE SUB PutMessage (message$)
'-- blocos do cenrio --
DIM SHARED Bloco1(512), Bloco2(512), Piso(512), Teto(512), PisoTeto(512), Bloco3(512), Bloco4(512)
DIM SHARED Saida(512), PisoLaser(512), PisoTetoLaser(512), MuroEnergiaOn(512), MuroEnergiaOff(512), ObjWall(512)
'-- objetos ------------
DIM SHARED Booster(30), Unlocker(30), Objeto3(30), Objeto4(30)
'-- outros blocos --
DIM SHARED Vazio(512), TelaPiece(960)
'----------------------
DIM SHARED xtela, ytela, telasaltura, telaslargura, largdim, altdim, larglim, altlim
DIM SHARED message$, yop$(6)
'-------------------------------------
DIM SHARED MyPalette(256, 3)
COMMON SHARED velofact                          'VelocityFactor
COMMON SHARED SoundTestVerif, Length&, Freq&, BasePort%, LenPort%, Channel%      'Dmaply1
'--- Personagem --------------------------------------------------------------
DIM SHARED Lparado(384), Lcorre1(384), Lcorre2(384), Lcorre3(384), Lcorre4(384), Lcorre5(384)
DIM SHARED Rparado(384), Rcorre1(384), Rcorre2(384), Rcorre3(384), Rcorre4(384), Rcorre5(384)
DIM SHARED Lvirada(384), Labaix1(384), Labaix2(384), Llevant(384), Lsobe1(384), Lsobe2(384), Lsobe3(384)
DIM SHARED Rvirada(384), Rabaix1(384), Rabaix2(384), Rlevant(384), Rsobe1(384), Rsobe2(384), Rsobe3(384)
DIM SHARED Lpula(384), Lcaindo(384), Lsofre1(384), Lsofre2(384), Lsofre3(384), Lmorre(384), Lpega(384)
DIM SHARED Rpula(384), Rcaindo(384), Rsofre1(384), Rsofre2(384), Rsofre3(384), Rmorre(384), Rpega(384)
'-----------------------------------------------------------------------------
DIM SHARED MoveUp, MoveDown, MoveLeft, MoveRight, MoveJump
DIM SHARED xbloco, ybloco, xpixel, ypixel, Pstatus$, Nquadro, bloco$, Lbloco$, Rbloco$
DIM SHARED QuadrosQueda, Energy, Nobjetos, Objetos(20, 5), Unlocker, xcols, yrows

'--- Parmetros do Cenrio ----------------------------
'--- limite mximo do cenrio ---
   larglim = 250
   altlim = 45
DIM SHARED Cenario$(altlim)

'*********************************************************************
'*** Abertura, leitura de imagens e determinao de parmetros *******
'*********************************************************************

'--- Definindo a velocidade do sistema ------------------
                                                 
SCREEN 13: CLS

   GetPalette
   FadeToBlack 1, 1        'determina velofact sem que nada aparea
VelocityFactor

'--- Abertura -------------------------------------------

KCLlogo

CLS
ReadGIF "logo-ini.gif", "yes"
GetPalette
FadeToBlack 2, 1
BLOAD "lab-logo.qbg", 13785
FadeToBlack 30, -1
SLEEP 8
FadeToBlack 30, 1
CLS

'*** Leitura das Imagens **********

LerImagens
 
'*** Deteco da SoundBlaster *****
  
SoundConfig

'*** Menu *************************

Menu

SUB Atrasar (quantidade)

FOR atraso = 0 TO quantidade * velofact
NEXT atraso

END SUB

SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
'-----------------------------------------
'--- Retirado do programa DMAPLAY.BAS ---
'-----------------------------------------
' Transfers and plays the contents of the buffer.
Length& = Length& - 1
Page% = 0
MemLoc& = Segment& * 16 + Offset&
PgPort% = &H83
AddPort% = &H2
LenPort% = &H3
ModeReg% = &H49
OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, MemLoc& AND &HFF
OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page% = Page% + 1
IF (MemLoc& AND 131072) THEN Page% = Page% + 2
IF (MemLoc& AND 262144) THEN Page% = Page% + 4
IF (MemLoc& AND 524288) THEN Page% = Page% + 8
OUT PgPort%, Page%
OUT LenPort%, Length& AND &HFF
OUT LenPort%, (Length& AND &HFFFF&) \ &H100
OUT &HA, Channel%

   TimeConst% = 256 - 1000000 \ Freq&
   WriteDSP &H40
   WriteDSP TimeConst%
   WriteDSP &H14
   WriteDSP (Length& AND &HFF)
   WriteDSP ((Length& AND &HFFFF&) \ &H100)

END SUB

SUB EndGame (modo$)                  '**************************
                                     '*** modo$ = "morreu"
   FadeToGrayScale 30                '**************************

IF modo$ = "morreu" THEN
   PutMessage ("Another Way to Go to Heaven")
   RestoreScreen (3)
   u$ = "y"
   GOTO direto
END IF
  
   PutMessage ("Really want to quit? (y/n)")
   u$ = INPUT$(1): u$ = LCASE$(u$)
direto:
   IF u$ = "y" THEN
      RestoreScreen (1)
      FadeToBlack 30, 1
      CLS
      SetPalette
      FadeToBlack 2, 1
      Menu           'Volta ao Menu
   ELSE
      RestoreScreen (1)    'Volta ao jogo
      SetPalette
   END IF
      

END SUB

SUB FadeToBlack (passos, modo)
  
   '@@@ Usar o GetPalette antes para definir as cores atuais @@@
  
   '"passos" define a velocidade de transio
   '"modo"  igual a 1 no fade out e -1 no fade in
   'para usarmos o fade in deve ter ocorrido um fade out antes
   IF ABS(modo) <> 1 THEN modo = 1
  
   DIM UsedPalette(256, 3)
  
   cores = 256       'exemplo para screen 13 - altere aqui!
  
   ultima = cores - 1
   FOR index = 0 TO ultima    'copia a matriz de valores da palette
      FOR corprim = 1 TO 3    'para uma outra (de uso)
         IF modo = 1 THEN UsedPalette(index, corprim) = MyPalette(index, corprim)
         IF modo = -1 THEN UsedPalette(index, corprim) = 0
      NEXT corprim
   NEXT index

   FOR t = 1 TO passos        'inicia a transio
      Atrasar 10
      FOR index = 0 TO ultima
         FOR corprim = 1 TO 3
            'calcular a diferenca a partir da matriz original, pois
            'a de uso vai mudando com tempo
            dif = MyPalette(index, corprim) / passos
            UsedPalette(index, corprim) = UsedPalette(index, corprim) - dif * modo
         NEXT corprim
         OUT &H3C8, index
         OUT &H3C9, UsedPalette(index, 1)
         OUT &H3C9, UsedPalette(index, 2)
         OUT &H3C9, UsedPalette(index, 3)
      NEXT index
   NEXT t

END SUB

SUB FadeToGrayScale (passos)
   '"passos" define a velocidade de transio
   DIM UsedPalette(256, 3)
 
   GetPalette        'recupera os dados da Palette atual
 
   cores = 256       'exemplo para screen 13 - altere aqui!
 
   ultima = cores - 1
   FOR index = 0 TO ultima    'copia a matriz de valores da palette
      FOR corprim = 1 TO 3    'para uma outra (de uso)
         UsedPalette(index, corprim) = MyPalette(index, corprim)
      NEXT corprim
   NEXT index

   FOR t = 1 TO passos        'inicia a transio
      Atrasar 10
      FOR index = 0 TO ultima
         'o valormedio ser repetido para R, G e B, formando o tom de cinza
         valormedio = (MyPalette(index, 1) + MyPalette(index, 2) + MyPalette(index, 3)) / 3
         FOR corprim = 1 TO 3
            'calcular a diferenca a partir da matriz original, pois
            'a de uso vai mudando com tempo
            dif = (MyPalette(index, corprim) - valormedio) / passos
            UsedPalette(index, corprim) = UsedPalette(index, corprim) - dif
         NEXT corprim
         OUT &H3C8, index
         OUT &H3C9, UsedPalette(index, 1)
         OUT &H3C9, UsedPalette(index, 2)
         OUT &H3C9, UsedPalette(index, 3)
      NEXT index
   NEXT t





END SUB

SUB GameOn

Action:
 
   '*** Condies de mudana de tela (normais) **************************
   '# pela direita ##########
   IF xpixel > 288 AND LEFT$(Pstatus$, 1) = "R" THEN
      xtela = xtela + 1
      xbloco = 0
      Redraw
      GOTO PutFirstTime
   END IF
   '# pela esquerda #########
   IF xpixel < 0 AND LEFT$(Pstatus$, 1) = "L" THEN
      xtela = xtela - 1
      xbloco = 9
      Redraw
      GOTO PutFirstTime
   END IF
   '# por baixo (indo para a direita) ##########
   IF ypixel > 142 AND LEFT$(Pstatus$, 1) = "R" THEN
      ytela = ytela + 1
      Redraw
      ybloco = 0
      xpixel = 32 * xbloco
      ypixel = 64 * ybloco + 10
      PUT (xpixel, ypixel), Rcaindo
      Pstatus$ = "R cai"
      Nquadro = 7
      GOTO Skip   'para que a imagem aparea pelo menos um pouco
   END IF
   '# por baixo (indo para a esquerda) ############
   IF ypixel > 142 AND LEFT$(Pstatus$, 1) = "L" THEN
      ytela = ytela + 1
      Redraw
      ybloco = 0
      xpixel = 32 * xbloco
      ypixel = 64 * ybloco + 10
      PUT (xpixel, ypixel), Lcaindo
      Pstatus$ = "L cai"
      Nquadro = 7
      GOTO Skip
   END IF
   '# por cima (indo para a direita) ############
   IF ypixel < 0 AND LEFT$(Pstatus$, 1) = "R" THEN
      ytela = ytela - 1
      Redraw
      ybloco = 2
      xbloco = xbloco + 1
      xpixel = 32 * xbloco
      ypixel = 64 * ybloco + 10
      PUT (xpixel - 8, ypixel + 5), Rsobe3, XOR
      Pstatus$ = "R sobe"
      Nquadro = 6
      GOTO Skip
   END IF
   '# por cima (indo para a esquerda) ############
   IF ypixel < 0 AND LEFT$(Pstatus$, 1) = "L" THEN
      ytela = ytela - 1
      Redraw
      ybloco = 2
      xbloco = xbloco - 1
      xpixel = 32 * xbloco
      ypixel = 64 * ybloco + 10
      PUT (xpixel + 8, ypixel + 5), Lsobe3, XOR
      Pstatus$ = "L sobe"
      Nquadro = 6
      GOTO Skip
   END IF
     

   '*** Verifica condio do teclado **************************
   KeyboardStatus
 
   '*** Condies de Movimentao do Personagem Principal *****
   MovePersonagem


Skip:
Atrasar 40

   IF (Pstatus$ = "R parado" OR Pstatus$ = "L parado") AND bloco$ = "x" THEN
      EXIT SUB
   END IF

GOTO Action

'--- Tambm presente em ReadScenario (sem label) ---

PutFirstTime:
xpixel = 32 * xbloco
ypixel = 64 * ybloco + 10

   IF LEFT$(Pstatus$, 1) = "R" THEN
      PUT (xpixel, ypixel), Rparado, PSET
      Pstatus$ = "R parado"
   ELSE
      PUT (xpixel, ypixel), Lparado, PSET
      Pstatus$ = "L parado"
   END IF
   Nquadro = 0
'---------------------------------------------

GOTO Action

END SUB

SUB GameSeq (levelshortcut)
'*****************************************
'*** Esta  sequncia de fases de jogo ***
'*****************************************

COLOR 255   'para o texto das mensagens
Unlocker = 0
Energy = 100
ON levelshortcut GOTO Stage1, Stage2, Stage3, Stage4, Stage5, Stage6

Stage0:
   MapImages 1                      'usa map1.gif
   ReadScenario 0, 1, 0, 6, 0
   SetEnergy 0
   PlayWave ("Stage")
   PutMessage ("Stage 0 - Just a little try")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 0 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS

Stage1:
   MapImages 1                      'usa map1.gif
   ReadScenario 1, 1, 0, 8, 0
   SetEnergy 0
   PlayWave ("Stage")
   PutMessage ("Stage 1 - Password: try4")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 1 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS

Stage2:
   MapImages 1                      'usa map1.gif
   ReadScenario 2, 1, 1, 4, 1
   SetEnergy 0
   PlayWave ("Stage")
   PutMessage ("Stage 2 - Password: bpm9")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 2 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS

Stage3:
   MapImages 1                      'usa map1.gif
   ReadScenario 3, 3, 3, 8, 2
   SetEnergy 0      'para desenhar a barra
   PlayWave ("Stage")
   PutMessage ("Stage 3 - Password: frk2")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 3 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS
     
Stage4:
   MapImages 2                      'usa map2.gif
   ReadScenario 4, 1, 0, 3, 0
   SetEnergy 0
   PlayWave ("Stage")
   PutMessage ("Stage 4 - Password: oak1")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 4 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS
     
Stage5:
   MapImages 2                      'usa map2.gif
   ReadScenario 5, 0, 0, 2, 0
   SetEnergy 0
   PlayWave ("Stage")
   PutMessage ("Stage 5 - Password: dth7")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 5 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS
    
Stage6:
   MapImages 2                      'usa map2.gif
   ReadScenario 6, 4, 2, 5, 1
   SetEnergy 0
   PlayWave ("Stage")
   PutMessage ("Stage 6 - Password: srg5")
   RestoreScreen (4)
   GOSUB ZeraMov
   GameOn
      PlayWave ("Final")
      message$ = "Congratulations - Stage 6 Ok!"
      PutMessage (message$)
      RestoreScreen (4)
      FadeToBlack 30, 1
      CLS
    
Stage7:
   Menu

ZeraMov:
   'zerando a movimentao
   MoveUp = 0: MoveRight = 0: MoveLeft = 0: MoveDown = 0: MoveJump = 0
RETURN

END SUB

SUB GetPalette

   'Valores na matriz 256x3 MyPalette
   'Exemplo para a Screen 13 (256 cores)
   cores = 256   'altere aqui!
   
   ultima = cores - 1
   FOR index = 0 TO ultima
      OUT &H3C7, index
      MyPalette(index, 1) = INP(&H3C9)  'RedValue
      MyPalette(index, 2) = INP(&H3C9)  'GreenValue
      MyPalette(index, 3) = INP(&H3C9)  'BlueValue
   NEXT index

END SUB

SUB Info

CLS
DEF SEG = &HA000
   BLOAD "menulogo.qbg", 10
DEF SEG
COLOR 251: LOCATE 2, 17: PRINT "Version 0.7b - Freeware"
COLOR 251: LOCATE 4, 17: PRINT "by ";
COLOR 255: LOCATE 5, 17: PRINT "Kleber Caf Lins (KCL)"
COLOR 251: LOCATE 8, 2: PRINT "More credits and other information in";
COLOR 251: LOCATE 9, 6: PRINT "the READ-ME.TXT file."
COLOR 254: LOCATE 11, 2: PRINT "Character Control:"
COLOR 255: LOCATE 13, 2: PRINT "Arrow Keys to Move"
LOCATE 14, 2: PRINT "Right Shift to Jump Forward and"
LOCATE 15, 2: PRINT "            to pick/use objects"
COLOR 254: LOCATE 17, 2: PRINT "Other Keys:"
COLOR 255: LOCATE 19, 2: PRINT "ESC - back to Menu"
LOCATE 21, 2: PRINT "+ or - (on Menu screen) to change"
LOCATE 22, 2: PRINT "game speed (alter the delay)"
LOCATE 23, 2: PRINT "(now Velocity Factor ="; velofact; ")"

'* esvaziando o buffer do teclado *
DEF SEG = 0: POKE &H41A, PEEK(&H41C)

FadeToBlack 30, -1

o$ = INPUT$(1)

FadeToBlack 30, 1
CLS

Menu

END SUB

SUB KCLlogo

'---utilizando o KCLLOGO1.BAS---
FOR cor = 0 TO 63
    PALETTE cor, cor
NEXT cor
FOR incr = 0 TO 63 STEP .05
    '---------rotina de atraso----------
    Atrasar 1
    '-----------------------------------
    LOCATE 13, 19: COLOR incr: PRINT "KCL"
    IF incr MOD 2 THEN LINE (x - 60 * COS(incr / 18) + 115, 168 - incr)-(x + 139 + 60 * SIN(incr / 20), 168 - incr), incr
NEXT incr

SLEEP 4
GetPalette
FadeToBlack 10, 1

END SUB

SUB KeyboardStatus
'*****************************************************************************
'*************************** Para determinar o status de quaisquer teclas
'*** Keyboard Scan Codes *** (a mudana de estado de uma tecla altera a outra)
'*************************** cdigo da liberada = (cdigo pressionada + 128)
'*****************************************************************************
'--- na Bblia no Programador, pg.153 ---
'Ainda no sei como identificar se s o LALT est pressionado ou se
' o LALT + RALT, assim como no CTRL.

'* lendo a porta de I/O 60H *
scancode = INP(&H60)

'* detectando o pressionamento *
IF scancode = 72 THEN MoveUp = -1: MoveRight = 0: MoveLeft = 0: MoveDown = 0: MoveJump = 0
IF scancode = 80 THEN MoveDown = -1: MoveRight = 0: MoveLeft = 0: MoveUp = 0: MoveJump = 0
IF scancode = 77 THEN MoveRight = -1: MoveUp = 0: MoveLeft = 0: MoveDown = 0: MoveJump = 0
IF scancode = 75 THEN MoveLeft = -1: MoveRight = 0: MoveUp = 0: MoveDown = 0: MoveJump = 0
IF scancode = 54 THEN MoveJump = -1: MoveRight = 0: MoveUp = 0: MoveDown = 0: MoveLeft = 0

'* detectando a liberao *
IF scancode = 200 THEN MoveUp = 0
IF scancode = 208 THEN MoveDown = 0
IF scancode = 205 THEN MoveRight = 0
IF scancode = 203 THEN MoveLeft = 0
IF scancode = 182 THEN MoveJump = 0

'* verificando o pressionamento de outras teclas *
IF INKEY$ = CHR$(27) THEN EndGame "normal"         'ESC para sair do jogo

'* esvaziando o buffer do teclado *
DEF SEG = 0: POKE &H41A, PEEK(&H41C)

END SUB

SUB LerImagens

'### LEITURA DAS IMAGENS ###################################

'--- palheta de cores ---
ReadGIF "map1-ini.gif", ""       'l uma figura simblica para definir
   GetPalette
   FadeToBlack 1, 1              'a palheta de cores, sem aparecer nada

'********************************************************************
'** A leitura dos blocos que compe o cenrio  feita em MapImages **
'** Sua chamada se d antes de ler o mapa, no GameSeq              **
'********************************************************************

'--- Objetos ------------
CLS                                         'Objetos 12x10
ReadGIF "obj1.gif", "nodefine"

GET (0, 0)-(11, 9), Booster           'Energy Booster
GET (12, 0)-(23, 9), Unlocker         'Energy-Wall Unlocker Control
'GET (192, 16)-(207, 31), Objeto3
'GET (208, 16)-(223, 31), Objeto4
'--- Vazio ------------------------
CLS
GET (0, 128)-(31, 191), Vazio
'----------------------------------

'*** Personagem ******************************************

ReadGIF "a-parado.gif", "nodefine"
    GET (0, 0)-(31, 47), Lparado
    GET (32, 0)-(63, 47), Rparado

ReadGIF "a-abaix1.gif", "nodefine"
    GET (0, 0)-(31, 47), Labaix1
    GET (32, 0)-(63, 47), Rabaix1

ReadGIF "a-abaix2.gif", "nodefine"
    GET (0, 0)-(31, 47), Labaix2
    GET (32, 0)-(63, 47), Rabaix2

ReadGIF "a-caindo.gif", "nodefine"
    GET (0, 0)-(31, 47), Lcaindo
    GET (32, 0)-(63, 47), Rcaindo

ReadGIF "a-corre1.gif", "nodefine"
    GET (0, 0)-(31, 47), Lcorre1
    GET (32, 0)-(63, 47), Rcorre1

ReadGIF "a-corre2.gif", "nodefine"
    GET (0, 0)-(31, 47), Lcorre2
    GET (32, 0)-(63, 47), Rcorre2

ReadGIF "a-corre3.gif", "nodefine"
    GET (0, 0)-(31, 47), Lcorre3
    GET (32, 0)-(63, 47), Rcorre3

ReadGIF "a-corre4.gif", "nodefine"
    GET (0, 0)-(31, 47), Lcorre4
    GET (32, 0)-(63, 47), Rcorre4

ReadGIF "a-corre5.gif", "nodefine"
    GET (0, 0)-(31, 47), Lcorre5
    GET (32, 0)-(63, 47), Rcorre5

ReadGIF "a-levant.gif", "nodefine"
    GET (0, 0)-(31, 47), Llevant
    GET (32, 0)-(63, 47), Rlevant

ReadGIF "a-pula.gif", "nodefine"
    GET (0, 0)-(31, 47), Lpula
    GET (32, 0)-(63, 47), Rpula

ReadGIF "a-virada.gif", "nodefine"
    GET (0, 0)-(31, 47), Lvirada
    GET (32, 0)-(63, 47), Rvirada

ReadGIF "a-sobe1.gif", "nodefine"
    GET (0, 0)-(31, 47), Lsobe1
    GET (32, 0)-(63, 47), Rsobe1

ReadGIF "a-sobe2.gif", "nodefine"
    GET (0, 0)-(31, 47), Lsobe2
    GET (32, 0)-(63, 47), Rsobe2

ReadGIF "a-sobe3.gif", "nodefine"
    GET (0, 0)-(31, 47), Lsobe3
    GET (32, 0)-(63, 47), Rsobe3

ReadGIF "a-sofre1.gif", "nodefine"
    GET (0, 0)-(31, 47), Lsofre1
    GET (32, 0)-(63, 47), Rsofre1

ReadGIF "a-sofre2.gif", "nodefine"
    GET (0, 0)-(31, 47), Lsofre2
    GET (32, 0)-(63, 47), Rsofre2

ReadGIF "a-sofre3.gif", "nodefine"
    GET (0, 0)-(31, 47), Lsofre3
    GET (32, 0)-(63, 47), Rsofre3

ReadGIF "a-morre.gif", "nodefine"
    GET (0, 0)-(31, 47), Lmorre
    GET (32, 0)-(63, 47), Rmorre

ReadGIF "a-pega.gif", "nodefine"
    GET (0, 0)-(31, 47), Lpega
    GET (32, 0)-(63, 47), Rpega

'*** fim personagem *****************************

CLS

END SUB

SUB MapImages (MapNumber)

SELECT CASE MapNumber
   CASE 1
      ReadGIF "map1.gif", "nodefine"   'l o mapa sem redefinir a palheta que
                                    'est sendo conservada no fade-out.
   CASE 2
      ReadGIF "map2.gif", "nodefine"
  
   CASE ELSE
      ReadGIF "map1.gif", "nodefine"

END SELECT

'--- Cenrio ----------------------------------
GET (0, 0)-(31, 63), Bloco1
GET (32, 0)-(63, 63), Bloco2
GET (64, 0)-(95, 63), Piso            'Blocos
GET (96, 0)-(127, 63), Teto           '32x64
GET (128, 0)-(159, 63), PisoTeto
GET (160, 0)-(191, 63), Bloco3
GET (192, 0)-(223, 63), Bloco4
GET (0, 64)-(31, 127), Saida
GET (32, 64)-(63, 127), PisoLaser
GET (64, 64)-(95, 127), PisoTetoLaser
GET (96, 64)-(127, 127), MuroEnergiaOn
GET (128, 64)-(159, 127), MuroEnergiaOff
GET (160, 64)-(191, 127), ObjWall

END SUB

SUB Menu

'* esvaziando o buffer do teclado *
DEF SEG = 0: POKE &H41A, PEEK(&H41C)

yop$(0) = "| Start Game  |"
yop$(1) = "| Info & Help |"
yop$(2) = "|  Password   |"
yop$(3) = "|    Quit     |"

IniMenu:

CLS

DEF SEG = &HA000
   BLOAD "menulogo.qbg", 100
DEF SEG

COLOR 255: LOCATE 10, 13: PRINT yop$(0)
COLOR 255: LOCATE 11, 13: PRINT yop$(1)
COLOR 255: LOCATE 12, 13: PRINT yop$(2)
COLOR 255: LOCATE 13, 13: PRINT yop$(3)

FadeToBlack 30, -1

yop = 0
 
MenuRot:
   levelshortcut = 0
   COLOR 255: LOCATE 10, 13: PRINT yop$(0)
   COLOR 255: LOCATE 11, 13: PRINT yop$(1)
   COLOR 255: LOCATE 12, 13: PRINT yop$(2)
   COLOR 255: LOCATE 13, 13: PRINT yop$(3)
  
   COLOR 251: LOCATE 10 + yop, 13: PRINT yop$(yop)
   op$ = INPUT$(1)
   op = INP(&H60)

   IF op = 72 THEN              'Up
      PlayWave ("sound4")
      yop = yop - 1
      IF yop = -1 THEN yop = 2
   END IF
  
   IF op = 80 THEN               'Down
      PlayWave ("sound4")
      yop = yop + 1
      IF yop = 4 THEN yop = 0
   END IF

   IF op = 28 THEN         'Enter
      PlayWave ("sound4")
      IF yop = 0 THEN FadeToBlack 30, 1: GameSeq 0  'vai para o jogo
      IF yop = 1 THEN FadeToBlack 30, 1: Info
      IF yop = 2 THEN GOSUB ShortCut: FadeToBlack 30, 1: GameSeq levelshortcut
      IF yop = 3 THEN FadeToBlack 30, 1: CLS : SYSTEM
   END IF

IF op$ = "+" THEN                            '"+" para acelerar
   velofact = velofact - 20
   IF velofact < 0 THEN velofact = 0
   COLOR 255
   message$ = "Velocity Factor =" + STR$(velofact): PutMessage (message$): RestoreScreen (2)
END IF
IF op$ = "-" THEN                            '"-" para retardar
   velofact = velofact + 20
   COLOR 255
   message$ = "Velocity Factor =" + STR$(velofact): PutMessage (message$): RestoreScreen (2)
END IF

GOTO MenuRot

ShortCut:
   password$ = ""
   PutMessage ("Type the level password")
   FOR inputpass = 1 TO 4
      pw$ = INPUT$(1)
      PlayWave ("Sound4")
      password$ = password$ + pw$
   NEXT inputpass
   password$ = LCASE$(password$)
   IF password$ = "try4" THEN levelshortcut = 1
   IF password$ = "bpm9" THEN levelshortcut = 2
   IF password$ = "frk2" THEN levelshortcut = 3
   IF password$ = "oak1" THEN levelshortcut = 4
   IF password$ = "dth7" THEN levelshortcut = 5
   IF password$ = "srg5" THEN levelshortcut = 6
   RestoreScreen (1)
   IF levelshortcut = 0 THEN GOTO MenuRot ELSE RETURN

END SUB

SUB Morre (jeito$)

LINE (1, 197)-(100, 197), 0   'Clears the energy bar

SELECT CASE jeito$

   CASE "eletrocutado"
       PlayWave ("shock")
       FOR t = 1 TO 10
          IF LEFT$(Pstatus$, 1) = "R" THEN
              PUT (xpixel, ypixel), Rsofre2, PSET
          ELSE PUT (xpixel, ypixel), Lsofre2, PSET
          END IF
          Atrasar 40
          IF LEFT$(Pstatus$, 1) = "R" THEN
              PUT (xpixel, ypixel), Rsofre3, PSET
          ELSE PUT (xpixel, ypixel), Lsofre3, PSET
          END IF
          Atrasar 40
         '* esvaziando o buffer do teclado *
          DEF SEG = 0: POKE &H41A, PEEK(&H41C)
       NEXT t
       PlayWave ("death")
       CIRCLE (xpixel + 15, ypixel + 23), 10, 254
       PAINT (xpixel + 15, ypixel + 23), 254
       Atrasar 15
       LINE (xpixel, ypixel)-(xpixel + 31, ypixel + 47), 0, BF

   CASE "queda"
       QuadrosQueda = 0
       IF LEFT$(Pstatus$, 1) = "R" THEN
         PUT (xpixel, ypixel), Rabaix1, PSET
       ELSE PUT (xpixel, ypixel), Labaix1, PSET
       END IF
       Atrasar 60
       IF LEFT$(Pstatus$, 1) = "R" THEN
         PUT (xpixel, ypixel), Rmorre, PSET
       ELSE PUT (xpixel, ypixel), Lmorre, PSET
       END IF

END SELECT

terminaMorre:
  
   Atrasar 300
   EndGame "morreu"     '*** o mesmo efeito de sada mas sem perguntas ***

END SUB

SUB MovePersonagem

   '--- verifica os blocos ao redor ----------------------------------
   bloco$ = MID$(Cenario$(ybloco + ytela * 3), xbloco + xtela * 10 + 1, 1)
   Lbloco$ = MID$(Cenario$(ybloco + ytela * 3), xbloco + xtela * 10 + 1 - 1, 1)
   Rbloco$ = MID$(Cenario$(ybloco + ytela * 3), xbloco + xtela * 10 + 1 + 1, 1)
   IF ybloco + ytela * 3 = 0 THEN
      Ubloco$ = "": URbloco$ = "": ULbloco$ = ""
   ELSE
      Ubloco$ = MID$(Cenario$(ybloco + ytela * 3 - 1), xbloco + xtela * 10 + 1, 1)
      URbloco$ = MID$(Cenario$(ybloco + ytela * 3 - 1), xbloco + xtela * 10 + 1 + 1, 1)
      ULbloco$ = MID$(Cenario$(ybloco + ytela * 3 - 1), xbloco + xtela * 10 + 1 - 1, 1)
   END IF
   '------------------------------------------------------------------
  
   '--- deteco do bloco "ObjWall" para pegar objetos ( um mov. especial)---
   IF Pstatus$ = "R parado" AND Rbloco$ = "g" AND MoveJump AND xbloco <> 9 THEN Pstatus$ = "R pega"
   IF Pstatus$ = "L parado" AND Lbloco$ = "g" AND MoveJump AND xbloco <> 0 THEN Pstatus$ = "L pega"
  
   '--- deteco do "MuroEnergiaOn" para usar o Unlocker ( um mov. especial)---
   IF Pstatus$ = "R parado" AND Rbloco$ = "d" AND MoveJump AND xbloco <> 9 THEN OpenEnergyWall
   IF Pstatus$ = "L parado" AND Lbloco$ = "d" AND MoveJump AND xbloco <> 0 THEN OpenEnergyWall
 
   '--- deteco das minas de energia ---
   IF (bloco$ = "a" OR bloco$ = "s") THEN
      IF Pstatus$ = "R parado" THEN Morre ("eletrocutado")
      IF (Pstatus$ = "R corre" AND Nquadro = 2) THEN xpixel = xpixel - 8: Morre ("eletrocutado")
   END IF
   IF (bloco$ = "a" OR bloco$ = "s") THEN
      IF Pstatus$ = "L parado" THEN Morre ("eletrocutado")
      IF (Pstatus$ = "L corre" AND Nquadro = 2) THEN xpixel = xpixel + 8: Morre ("eletrocutado")
   END IF
   '--- Atribui ao dependendo do movimento ---
   IF Pstatus$ = "R parado" AND MoveRight THEN Pstatus$ = "R ini corre"
   IF Pstatus$ = "L parado" AND MoveLeft THEN Pstatus$ = "L ini corre"
   IF Pstatus$ = "R parado" AND MoveLeft THEN Pstatus$ = "R vir"
   IF Pstatus$ = "L parado" AND MoveRight THEN Pstatus$ = "L vir"
   IF Pstatus$ = "R parado" AND MoveJump AND xbloco < 8 THEN Pstatus$ = "R pula"
   IF Pstatus$ = "L parado" AND MoveJump AND xbloco > 1 THEN Pstatus$ = "L pula"
   IF Pstatus$ = "R parado" AND MoveDown THEN Pstatus$ = "R abaixa"
   IF Pstatus$ = "L parado" AND MoveDown THEN Pstatus$ = "L abaixa"

   IF Pstatus$ = "R parado" AND MoveUp THEN
      IF (Ubloco$ = "0" OR Ubloco$ = "r") AND (URbloco$ = "e" OR URbloco$ = "t" OR URbloco$ = "a" OR URbloco$ = "s" OR URbloco$ = "x" OR URbloco$ = "f") THEN Pstatus$ = "R sobe"
   END IF
 
   IF Pstatus$ = "L parado" AND MoveUp THEN
      IF (Ubloco$ = "0" OR Ubloco$ = "r") AND (ULbloco$ = "e" OR ULbloco$ = "t" OR ULbloco$ = "a" OR ULbloco$ = "s" OR ULbloco$ = "x" OR ULbloco$ = "f") THEN Pstatus$ = "L sobe"
   END IF

   '--- deteco da queda correndo + bloco na frente ---
   IF xbloco <> 0 AND RIGHT$(Pstatus$, 5) = "corre" AND LEFT$(Pstatus$, 1) = "L" THEN
      IF (Lbloco$ = "r" OR Lbloco$ = "0") AND xpixel MOD 32 <> 0 THEN Pstatus$ = "L cai": xpixel = xpixel + 8: Nquadro = 0
      IF (Lbloco$ = "q" OR Lbloco$ = "w" OR Lbloco$ = "y" OR Lbloco$ = "u" OR Lbloco$ = "d" OR Lbloco$ = "g") AND xpixel MOD 32 <> 0 THEN Pstatus$ = "L bate": xpixel = xpixel + 8: Nquadro = 0
   END IF
   IF xbloco <> 9 AND RIGHT$(Pstatus$, 5) = "corre" AND LEFT$(Pstatus$, 1) = "R" THEN
      IF (Rbloco$ = "r" OR Rbloco$ = "0") AND xpixel MOD 32 <> 0 THEN Pstatus$ = "R cai": xpixel = xpixel - 8: Nquadro = 0
      IF (Rbloco$ = "q" OR Rbloco$ = "w" OR Rbloco$ = "y" OR Rbloco$ = "u" OR Rbloco$ = "d" OR Rbloco$ = "g") AND xpixel MOD 32 <> 0 THEN Pstatus$ = "R bate": xpixel = xpixel - 8: Nquadro = 0
   END IF
                                                                      
   '--- deteco do bloco na frente ou buraco ao pular ---
   IF Pstatus$ = "L pula" THEN
      IF (Lbloco$ = "q" OR Lbloco$ = "w" OR Lbloco$ = "y" OR Lbloco$ = "u" OR Lbloco$ = "d" OR Lbloco$ = "g") AND Nquadro < 3 THEN Pstatus$ = "L bate"
      IF Nquadro = 1 AND Pstatus$ = "L bate" THEN xpixel = xpixel + 32: ypixel = ypixel + 9: Nquadro = 0
      IF Nquadro = 2 AND Pstatus$ = "L bate" THEN xpixel = xpixel + 20: ypixel = ypixel + 10: Nquadro = 0
      IF Nquadro = 4 AND (bloco$ = "0" OR bloco$ = "r") THEN
         PUT (xpixel + 4, ypixel), Lpula, XOR
         xpixel = xpixel + 8
         ypixel = ypixel + 4
         PUT (xpixel, ypixel), Labaix1, XOR
         xpixel = xpixel - 3
         ypixel = ypixel + 10
         Pstatus$ = "L cai"
         Nquadro = 4
         EXIT SUB
      END IF
   END IF
   IF Pstatus$ = "R pula" THEN
      IF (Rbloco$ = "q" OR Rbloco$ = "w" OR Rbloco$ = "y" OR Rbloco$ = "u" OR Rbloco$ = "d" OR Rbloco$ = "g") AND Nquadro < 3 THEN Pstatus$ = "R bate"
      IF Nquadro = 1 AND Pstatus$ = "R bate" THEN xpixel = xpixel - 32: ypixel = ypixel + 9: Nquadro = 0
      IF Nquadro = 2 AND Pstatus$ = "R bate" THEN xpixel = xpixel - 20: ypixel = ypixel + 10: Nquadro = 0
      IF Nquadro = 4 AND (bloco$ = "0" OR bloco$ = "r") THEN
         PUT (xpixel - 4, ypixel), Rpula, XOR
         xpixel = xpixel - 8
         ypixel = ypixel + 4
         PUT (xpixel, ypixel), Rabaix1, XOR
         xpixel = xpixel + 3
         ypixel = ypixel + 10
         Pstatus$ = "R cai"
         Nquadro = 4
         EXIT SUB
      END IF
   END IF
 
   '---   ---

   SELECT CASE Pstatus$
      CASE "L parado"
      CASE "R parado"
'BATE #######################
      CASE "L bate"
         SELECT CASE Nquadro
            CASE 0                                   'evita problema de saber
               PUT (xpixel, ypixel), Lsofre1, PSET   'qual a figura est por
               Nquadro = 1                           'baixo: corre1 ou corre2
               PlayWave ("sound1")
            CASE 1
               'para deteco de pulo de cara na parede e depois cai:
               IF (bloco$ = "0" OR bloco$ = "r") THEN
                  PUT (xpixel, ypixel), Lsofre1, XOR
                  xpixel = xpixel + 8
                  ypixel = ypixel + 4
                  PUT (xpixel, ypixel), Labaix1, XOR
                  xpixel = xpixel - 3
                  ypixel = ypixel + 10
                  Pstatus$ = "L cai"
                  Nquadro = 4
               ELSE
                  'caso normal de "bate":
                  PUT (xpixel, ypixel), Lsofre1, XOR
                  PUT (xpixel, ypixel), Llevant, XOR
                  Nquadro = 2
               END IF
            CASE 2
               PUT (xpixel, ypixel), Llevant, XOR
               PUT (xpixel, ypixel), Lparado, XOR
               Nquadro = 0
               Pstatus$ = "L parado"
         END SELECT
    
      CASE "R bate"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rsofre1, PSET   'leia no "L bate"
               Nquadro = 1
               PlayWave ("sound1")
            CASE 1
               'para deteco de pulo de cara na parede e depois cai:
               IF (bloco$ = "0" OR bloco$ = "r") THEN
                  PUT (xpixel, ypixel), Rsofre1, XOR
                  xpixel = xpixel - 8
                  ypixel = ypixel + 4
                  PUT (xpixel, ypixel), Rabaix1, XOR
                  xpixel = xpixel + 3
                  ypixel = ypixel + 10
                  Pstatus$ = "R cai"
                  Nquadro = 4
               ELSE
                  'caso normal de "bate":
                  PUT (xpixel, ypixel), Rsofre1, XOR
                  PUT (xpixel, ypixel), Rlevant, XOR
                  Nquadro = 2
               END IF
            CASE 2
               PUT (xpixel, ypixel), Rlevant, XOR
               PUT (xpixel, ypixel), Rparado, XOR
               Nquadro = 0
               Pstatus$ = "R parado"
         END SELECT
'L FREIA ########################
      CASE "L freia"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel + 8, ypixel), Lcorre4, XOR
               PUT (xpixel, ypixel), Lcorre1, XOR
               Nquadro = 1
               xpixel = xpixel - 8
            CASE 1
               PUT (xpixel + 8, ypixel), Lcorre1, XOR
               PUT (xpixel, ypixel), Lparado, XOR
               Nquadro = 0
              xbloco = xbloco - 1
               Pstatus$ = "L parado"
         END SELECT
'L CORRE ######################
      CASE "L corre"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel + 8, ypixel), Lcorre4, XOR
               PUT (xpixel, ypixel), Lcorre5, XOR
               Nquadro = 1
               xpixel = xpixel - 8
            CASE 1
               PUT (xpixel + 8, ypixel), Lcorre5, XOR
               PUT (xpixel, ypixel), Lcorre2, XOR
              xbloco = xbloco - 1
               Nquadro = 2
               xpixel = xpixel - 8
            CASE 2
               PUT (xpixel + 8, ypixel), Lcorre2, XOR
               PUT (xpixel, ypixel), Lcorre3, XOR
               Nquadro = 3
               xpixel = xpixel - 8
            CASE 3
               PUT (xpixel + 8, ypixel), Lcorre3, XOR
               PUT (xpixel, ypixel), Lcorre4, XOR
               IF MoveLeft THEN Pstatus$ = "L corre" ELSE Pstatus$ = "L freia"
               Nquadro = 0
               xpixel = xpixel - 8
         END SELECT
'L INI CORRE ##########################
      CASE "L ini corre"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Lparado, XOR
               PUT (xpixel, ypixel), Lcorre1, XOR
               Nquadro = 1
               xpixel = xpixel - 8
            CASE 1
               PUT (xpixel + 8, ypixel), Lcorre1, XOR
               PUT (xpixel, ypixel), Lcorre2, XOR
               Nquadro = 2
               xpixel = xpixel - 8
            CASE 2
               PUT (xpixel + 8, ypixel), Lcorre2, XOR
               PUT (xpixel, ypixel), Lcorre4, XOR
               Nquadro = 3
               IF MoveLeft THEN Pstatus$ = "L corre" ELSE Pstatus$ = "L freia"
               Nquadro = 0
               xpixel = xpixel - 8
         END SELECT
'R FREIA ##########################
      CASE "R freia"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel - 8, ypixel), Rcorre4, XOR
               PUT (xpixel, ypixel), Rcorre1, XOR
               Nquadro = 1
               xpixel = xpixel + 8
            CASE 1
               PUT (xpixel - 8, ypixel), Rcorre1, XOR
               PUT (xpixel, ypixel), Rparado, XOR
               Nquadro = 0
              xbloco = xbloco + 1
               Pstatus$ = "R parado"
         END SELECT
'R CORRE ###########################
      CASE "R corre"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel - 8, ypixel), Rcorre4, XOR
               PUT (xpixel, ypixel), Rcorre5, XOR
               Nquadro = 1
               xpixel = xpixel + 8
            CASE 1
               PUT (xpixel - 8, ypixel), Rcorre5, XOR
               PUT (xpixel, ypixel), Rcorre2, XOR
              xbloco = xbloco + 1
               Nquadro = 2
               xpixel = xpixel + 8
            CASE 2
               PUT (xpixel - 8, ypixel), Rcorre2, XOR
               PUT (xpixel, ypixel), Rcorre3, XOR
               Nquadro = 3
               xpixel = xpixel + 8
            CASE 3
               PUT (xpixel - 8, ypixel), Rcorre3, XOR
               PUT (xpixel, ypixel), Rcorre4, XOR
               IF MoveRight THEN Pstatus$ = "R corre" ELSE Pstatus$ = "R freia"
               Nquadro = 0
               xpixel = xpixel + 8
         END SELECT
'R INI CORRE ##########################
      CASE "R ini corre"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rparado, XOR
               PUT (xpixel, ypixel), Rcorre1, XOR
               Nquadro = 1
               xpixel = xpixel + 8
            CASE 1
               PUT (xpixel - 8, ypixel), Rcorre1, XOR
               PUT (xpixel, ypixel), Rcorre2, XOR
               Nquadro = 2
               xpixel = xpixel + 8
            CASE 2
               PUT (xpixel - 8, ypixel), Rcorre2, XOR
               PUT (xpixel, ypixel), Rcorre4, XOR
               Nquadro = 3
               IF MoveRight THEN Pstatus$ = "R corre" ELSE Pstatus$ = "R freia"
               Nquadro = 0
               xpixel = xpixel + 8
         END SELECT
'VIRADA ##############################
      CASE "L vir"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Lparado, XOR
               PUT (xpixel, ypixel), Lvirada, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Lvirada, XOR
               PUT (xpixel, ypixel), Rparado, XOR
               Nquadro = 0
               Pstatus$ = "R parado"
         END SELECT
      CASE "R vir"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rparado, XOR
               PUT (xpixel, ypixel), Rvirada, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Rvirada, XOR
               PUT (xpixel, ypixel), Lparado, XOR
               Nquadro = 0
               Pstatus$ = "L parado"
         END SELECT
'LEVANTA - ABAIXA ########################
      CASE "R levanta"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rabaix2, XOR
               PUT (xpixel, ypixel), Rlevant, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Rlevant, XOR
               PUT (xpixel, ypixel), Rparado, XOR
               Nquadro = 0
               Pstatus$ = "R parado"
         END SELECT
      CASE "R abaixa"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rabaix1, PSET
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Rabaix2, PSET
               Nquadro = 2
            CASE 2
               IF NOT MoveDown THEN Pstatus$ = "R levanta": Nquadro = 0
         END SELECT
    
      CASE "L levanta"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Labaix2, XOR
               PUT (xpixel, ypixel), Llevant, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Llevant, XOR
               PUT (xpixel, ypixel), Lparado, XOR
               Nquadro = 0
               Pstatus$ = "L parado"
         END SELECT
      CASE "L abaixa"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Labaix1, PSET
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Labaix2, PSET
               Nquadro = 2
            CASE 2
               IF NOT MoveDown THEN Pstatus$ = "L levanta": Nquadro = 0
         END SELECT
'CAI ################################
      CASE "R cai"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rcorre3, PSET     'para no me preocupar
               Nquadro = 1                            'com a figura abaixo
               xpixel = xpixel + 8
            CASE 1
               PUT (xpixel - 8, ypixel), Rcorre3, XOR
               PUT (xpixel, ypixel), Rcorre4, XOR
               Nquadro = 2
               xpixel = xpixel + 8
            CASE 2
               PUT (xpixel - 8, ypixel), Rcorre4, XOR
               PUT (xpixel, ypixel), Rcorre5, XOR
               Nquadro = 3
               xpixel = xpixel + 8
               ypixel = ypixel + 4
            CASE 3
               PUT (xpixel - 8, ypixel - 4), Rcorre5, XOR
               PUT (xpixel, ypixel), Rabaix1, XOR
              xbloco = xbloco + 1
               Nquadro = 4
               xpixel = xpixel + 3
               ypixel = ypixel + 10
            CASE 4
               PUT (xpixel - 3, ypixel - 10), Rabaix1, XOR
               PUT (xpixel, ypixel), Rcaindo, XOR
               Nquadro = 5
               xpixel = xpixel + 3
               ypixel = ypixel + 20
            CASE 5
               PUT (xpixel - 3, ypixel - 20), Rcaindo, XOR
               PUT (xpixel, ypixel), Rcaindo, XOR
              ybloco = ybloco + 1
               Nquadro = 6
               xpixel = xpixel + 2
               ypixel = ypixel + 30
            CASE 6
               PUT (xpixel - 2, ypixel - 30), Rcaindo, XOR
               PUT (xpixel, ypixel), Rcaindo, XOR
               Nquadro = 7
            CASE 7
               QuadrosQueda = QuadrosQueda + 1
               IF (bloco$ = "0") THEN
                  PUT (xpixel, ypixel), Rcaindo, XOR
                  PUT (xpixel, ypixel), Rcaindo, XOR
                  Nquadro = 8
                  ypixel = ypixel + 64
               ELSE
                  IF QuadrosQueda > 1 THEN
                     PlayWave ("sound3")
                  ELSE
                     PlayWave ("sound2")
                  END IF
                  PUT (xpixel, ypixel), Rcaindo, XOR
                  PUT (xpixel, ypixel), Rabaix1, XOR
                  IF QuadrosQueda = 2 THEN SetEnergy -10
                  IF QuadrosQueda = 3 THEN SetEnergy -50
                  IF QuadrosQueda > 3 THEN Morre "queda"
                  QuadrosQueda = 0
                  Pstatus$ = "R abaixa"
                  Nquadro = 1           'para j estar abaixado!
               END IF
            CASE 8              's para quedas mltiplas
              ybloco = ybloco + 1
               PUT (xpixel, ypixel - 64), Rcaindo, XOR
               PUT (xpixel, ypixel), Rcaindo, XOR
               Nquadro = 7
         END SELECT
      CASE "L cai"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Lcorre3, PSET     'para no me preocupar
               Nquadro = 1                            'com a figura abaixo
               xpixel = xpixel - 8
            CASE 1
               PUT (xpixel + 8, ypixel), Lcorre3, XOR
               PUT (xpixel, ypixel), Lcorre4, XOR
               Nquadro = 2
               xpixel = xpixel - 8
            CASE 2
               PUT (xpixel + 8, ypixel), Lcorre4, XOR
               PUT (xpixel, ypixel), Lcorre5, XOR
               Nquadro = 3
               xpixel = xpixel - 8
               ypixel = ypixel + 4
            CASE 3
               PUT (xpixel + 8, ypixel - 4), Lcorre5, XOR
               PUT (xpixel, ypixel), Labaix1, XOR
              xbloco = xbloco - 1
               Nquadro = 4
               xpixel = xpixel - 3
               ypixel = ypixel + 10
            CASE 4
               PUT (xpixel + 3, ypixel - 10), Labaix1, XOR
               PUT (xpixel, ypixel), Lcaindo, XOR
               Nquadro = 5
               xpixel = xpixel - 3
               ypixel = ypixel + 20
            CASE 5
               PUT (xpixel + 3, ypixel - 20), Lcaindo, XOR
               PUT (xpixel, ypixel), Lcaindo, XOR
              ybloco = ybloco + 1
               Nquadro = 6
               xpixel = xpixel - 2
               ypixel = ypixel + 30
            CASE 6
               PUT (xpixel + 2, ypixel - 30), Lcaindo, XOR
               PUT (xpixel, ypixel), Lcaindo, XOR
               Nquadro = 7
            CASE 7
               QuadrosQueda = QuadrosQueda + 1
               PUT (xpixel, ypixel), Lcaindo, XOR
               PUT (xpixel, ypixel), Lcaindo, XOR
               IF (bloco$ = "0") THEN
                  Nquadro = 8
                  ypixel = ypixel + 64
               ELSE
                  IF QuadrosQueda > 1 THEN
                     PlayWave ("sound3")
                  ELSE
                     PlayWave ("sound2")
                  END IF
                  PUT (xpixel, ypixel), Lcaindo, XOR
                  PUT (xpixel, ypixel), Labaix1, XOR
                  IF QuadrosQueda = 2 THEN SetEnergy -10
                  IF QuadrosQueda = 3 THEN SetEnergy -50
                  IF QuadrosQueda > 3 THEN Morre "queda"
                  QuadrosQueda = 0
                  Pstatus$ = "L abaixa"
                  Nquadro = 1           'para j estar abaixado!
               END IF
            CASE 8              's para quedas mltiplas
              ybloco = ybloco + 1
               PUT (xpixel, ypixel - 64), Lcaindo, XOR
               PUT (xpixel, ypixel), Lcaindo, XOR
               Nquadro = 7
         END SELECT
'PULA ###################################
      CASE "R pula"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rparado, XOR
               PUT (xpixel, ypixel), Rlevant, XOR
               Nquadro = 1
               xpixel = xpixel + 32
               ypixel = ypixel - 9
            CASE 1
               PUT (xpixel - 32, ypixel + 9), Rlevant, XOR
               PUT (xpixel, ypixel), Rpula, XOR
               Nquadro = 2
              xbloco = xbloco + 1
               xpixel = xpixel + 20
               ypixel = ypixel - 1
               PlayWave ("sound5")
            CASE 2
               PUT (xpixel - 20, ypixel + 1), Rpula, XOR
               PUT (xpixel, ypixel), Rpula, XOR
               Nquadro = 3
               xpixel = xpixel + 8
               ypixel = ypixel + 10
            CASE 3
               PUT (xpixel - 8, ypixel - 10), Rpula, XOR
               PUT (xpixel, ypixel), Rpula, XOR
             Nquadro = 4
              xbloco = xbloco + 1
              xpixel = xpixel + 4
            CASE 4
               PUT (xpixel - 4, ypixel), Rpula, XOR
               PUT (xpixel, ypixel), Rabaix2, XOR
               Nquadro = 0
               Pstatus$ = "R levanta"
         END SELECT
      CASE "L pula"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Lparado, XOR
               PUT (xpixel, ypixel), Llevant, XOR
               Nquadro = 1
               xpixel = xpixel - 32
               ypixel = ypixel - 9
            CASE 1
               PUT (xpixel + 32, ypixel + 9), Llevant, XOR
               PUT (xpixel, ypixel), Lpula, XOR
               Nquadro = 2
              xbloco = xbloco - 1
               xpixel = xpixel - 20
               ypixel = ypixel - 1
               PlayWave ("sound5")
            CASE 2
               PUT (xpixel + 20, ypixel + 1), Lpula, XOR
               PUT (xpixel, ypixel), Lpula, XOR
               Nquadro = 3
               xpixel = xpixel - 8
               ypixel = ypixel + 10
            CASE 3
               PUT (xpixel + 8, ypixel - 10), Lpula, XOR
               PUT (xpixel, ypixel), Lpula, XOR
               Nquadro = 4
              xbloco = xbloco - 1
               xpixel = xpixel - 4
            CASE 4
               PUT (xpixel + 4, ypixel), Lpula, XOR
               PUT (xpixel, ypixel), Labaix2, XOR
               Nquadro = 0
               Pstatus$ = "L levanta"
         END SELECT
'SOBE #############################
      CASE "R sobe"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rparado, XOR
               PUT (xpixel, ypixel), Rabaix1, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Rabaix1, XOR
               PUT (xpixel, ypixel), Rlevant, XOR
               Nquadro = 2
               xpixel = xpixel + 1
               ypixel = ypixel - 15
            CASE 2
               PUT (xpixel - 1, ypixel + 15), Rlevant, XOR
               PUT (xpixel, ypixel), Rsobe1, XOR
               Nquadro = 3
               xpixel = xpixel + 1
               ypixel = ypixel - 8
               PlayWave ("sound5")
            CASE 3
               PUT (xpixel - 1, ypixel + 8), Rsobe1, XOR
               PUT (xpixel, ypixel), Rsobe1, XOR
               Nquadro = 4
               xpixel = xpixel + 2
               ypixel = ypixel - 6
            CASE 4
               PUT (xpixel - 2, ypixel + 6), Rsobe1, XOR
               PUT (xpixel, ypixel), Rsobe2, XOR
               Nquadro = 5
               xpixel = xpixel + 20
               ypixel = ypixel - 30
            CASE 5
               PUT (xpixel - 20, ypixel + 30), Rsobe2, XOR
               PUT (xpixel, ypixel), Rsobe3, XOR
              xbloco = xbloco + 1
              ybloco = ybloco - 1
               Nquadro = 6
               xpixel = xpixel + 8
               ypixel = ypixel - 5
            CASE 6
               PUT (xpixel - 8, ypixel + 5), Rsobe3, XOR
               PUT (xpixel, ypixel), Rabaix2, XOR
               Pstatus$ = "R abaixa"
               Nquadro = 2           'para j estar abaixado!
         END SELECT
      CASE "L sobe"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Lparado, XOR
               PUT (xpixel, ypixel), Labaix1, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Labaix1, XOR
               PUT (xpixel, ypixel), Llevant, XOR
               Nquadro = 2
               xpixel = xpixel - 1
               ypixel = ypixel - 15
            CASE 2
               PUT (xpixel + 1, ypixel + 15), Llevant, XOR
               PUT (xpixel, ypixel), Lsobe1, XOR
               Nquadro = 3
               xpixel = xpixel - 1
               ypixel = ypixel - 8
               PlayWave ("sound5")
            CASE 3
               PUT (xpixel + 1, ypixel + 8), Lsobe1, XOR
               PUT (xpixel, ypixel), Lsobe1, XOR
               Nquadro = 4
               xpixel = xpixel - 2
               ypixel = ypixel - 6
            CASE 4
               PUT (xpixel + 2, ypixel + 6), Lsobe1, XOR
               PUT (xpixel, ypixel), Lsobe2, XOR
               Nquadro = 5
               xpixel = xpixel - 20
               ypixel = ypixel - 30
            CASE 5
               PUT (xpixel + 20, ypixel + 30), Lsobe2, XOR
               PUT (xpixel, ypixel), Lsobe3, XOR
               Nquadro = 6
              xbloco = xbloco - 1
              ybloco = ybloco - 1
               xpixel = xpixel - 8
               ypixel = ypixel - 5
            CASE 6
               PUT (xpixel + 8, ypixel + 5), Lsobe3, XOR
               PUT (xpixel, ypixel), Labaix2, XOR
               Pstatus$ = "L abaixa"
               Nquadro = 2           'para j estar abaixado!
         END SELECT

'PEGA OBJETOS ###############################
      CASE "L pega"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Lparado, XOR
               PUT (xpixel, ypixel), Lpega, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Lpega, XOR
               PUT (xpixel, ypixel), Lpega, XOR
               Nquadro = 2
               PegaObjeto
            CASE 2
               PUT (xpixel, ypixel), Lpega, XOR
               PUT (xpixel, ypixel), Lparado, XOR
               Nquadro = 0
               Pstatus$ = "L parado"
         END SELECT
      CASE "R pega"
         SELECT CASE Nquadro
            CASE 0
               PUT (xpixel, ypixel), Rparado, XOR
               PUT (xpixel, ypixel), Rpega, XOR
               Nquadro = 1
            CASE 1
               PUT (xpixel, ypixel), Rpega, XOR
               PUT (xpixel, ypixel), Rpega, XOR
               Nquadro = 2
               PegaObjeto
            CASE 2
               PUT (xpixel, ypixel), Rpega, XOR
               PUT (xpixel, ypixel), Rparado, XOR
               Nquadro = 0
               Pstatus$ = "R parado"
         END SELECT
  
   END SELECT


END SUB

SUB OpenEnergyWall
'--- testa se tem o Unlocker e usa ---

IF Unlocker THEN
   IF LEFT$(Pstatus$, 1) = "L" THEN fatorbloco = -1 ELSE fatorbloco = 1
   IF LEFT$(Pstatus$, 1) = "L" THEN
      PUT (xpixel, ypixel), Labaix1, PSET
   ELSE PUT (xpixel, ypixel), Rabaix1, PSET
   END IF
   Atrasar 60
   IF LEFT$(Pstatus$, 1) = "L" THEN
      PUT (xpixel, ypixel), Labaix2, PSET
   ELSE PUT (xpixel, ypixel), Rabaix2, PSET
   END IF
   Atrasar 200
   PlayWave "sound4"
   Unlocker = Unlocker - 1
   IF Unlocker = 0 THEN PSET (110, 195), 0: DRAW "D4R2U4"  'retira a marca
   Atrasar 150
   xplosion = xpixel + 32 * fatorbloco
       PlayWave ("shock")
       CIRCLE (xplosion + 15, ypixel + 10), 10, 254
       PAINT (xplosion + 15, ypixel + 10), 254
       Atrasar 15
       LINE (xplosion, ypixel)-(xplosion + 31, ypixel + 47), 0, BF
       Atrasar 15
       CIRCLE (xplosion + 15, ypixel + 35), 10, 254
       PAINT (xplosion + 15, ypixel + 35), 254
       Atrasar 15
       PUT ((xbloco + fatorbloco) * 32, ybloco * 64), MuroEnergiaOff, PSET
       '* InsertBlock "f" *
       xsel = (xbloco + fatorbloco) * 32
       xins = (xtela * 10) + (xsel / 32)
       yins = (ytela * 3) + (ybloco)
       Cenario$(yins) = LEFT$(Cenario$(yins), xins) + "f" + RIGHT$(Cenario$(yins), larglim - xins - 1)

   IF LEFT$(Pstatus$, 1) = "L" THEN
      Pstatus$ = "L levanta"
      Nquadro = 0
   ELSE
      Pstatus$ = "R levanta"
      Nquadro = 0
   END IF

ELSE
   PutMessage ("You need the Unlocker")
   RestoreScreen 2
   MoveJump = 0
END IF

MoveJump = 0

END SUB

SUB OpenMap (MapFileName$)
  
   PutMessage ("Reading Scenario..."): RestoreScreen (1)
  
      IF MapFileName$ = "" THEN GOTO finalopen
      IF RIGHT$(MapFileName$, 4) <> ".map" THEN MapFileName$ = MapFileName$ + ".map"
      ObjFileName$ = LEFT$(MapFileName$, LEN(MapFileName$) - 4) + ".obj"
   OPEN MapFileName$ FOR INPUT AS #1
      INPUT #1, telasaltura
      INPUT #1, telaslargura
         altdim = telasaltura * 3
         largdim = telaslargura * 10
      FOR linhas = 0 TO altdim - 1
         INPUT #1, linha$
         Cenario$(linhas) = linha$
      NEXT linhas
   CLOSE #1
   OPEN ObjFileName$ FOR INPUT AS #1
      INPUT #1, Nobjetos
      FOR mytry = 1 TO Nobjetos
         INPUT #1, Objetos(mytry, 1)
         INPUT #1, Objetos(mytry, 2)
         INPUT #1, Objetos(mytry, 3)
         INPUT #1, Objetos(mytry, 4)
         INPUT #1, Objetos(mytry, 5)
      NEXT mytry
   CLOSE #1
  
finalopen:
   
END SUB

SUB PegaObjeto

   IF LEFT$(Pstatus$, 1) = "L" THEN fatorbloco = -1 ELSE fatorbloco = 1
      xobj = (xbloco + fatorbloco) * 32 + 10
      yobj = ybloco * 64 + 24
      FOR mytry = 1 TO Nobjetos
         IF Objetos(mytry, 1) = xtela AND Objetos(mytry, 2) = ytela AND Objetos(mytry, 3) = xbloco + fatorbloco AND Objetos(mytry, 4) = ybloco THEN
            objnumber = Objetos(mytry, 5)
            IF objnumber = 1 THEN PlayWave "stage": SetEnergy 10
            IF objnumber = 2 THEN
               PlayWave "stage"
               Unlocker = Unlocker + 1
               PSET (110, 195), 258: DRAW "D4R2U4"
            END IF
            Objetos(mytry, 5) = 0                'esvaziando o holder
         END IF
      NEXT mytry
      CIRCLE (xobj + 6, yobj + 5), 5, 254
      PAINT (xobj + 6, yobj + 5), 254
      Atrasar 10
      LINE (xobj, yobj)-(xobj + 12, yobj + 10), 0, BF

END SUB

SUB PlayWave (soundfile$)
'--- Utiliza as rotinas do DMAPlay.bas ---

IF SoundTestVerif THEN
   IF RIGHT$(soundfile$, 4) <> ".snd" THEN soundfile$ = soundfile$ + ".snd"

   OPEN soundfile$ FOR BINARY AS #1
   GET #1, 44, WavBuffer1(1) 'Get 32k from file (skip header on WAV)
   Length& = LOF(1) - 220

   'Length& = LOF(1) - 44
   'IF Length& > 32767 THEN Length& = 32767  'Adjust length if needed to 32k

   DMAPlay VARSEG(WavBuffer1(1)), VARPTR(WavBuffer1(1)), Length&, Freq&

   CLOSE #1

ELSE

   'colocar alternativas em PC-Speaker?
   SOUND 100, .5

END IF

END SUB

SUB PutMessage (message$)

   COLOR 255

   xini = 160 - (LEN(message$) / 2 + 1) * 8
   xfim = 160 + (LEN(message$) / 2 + 1) * 8
   xtolocate = 20 - LEN(message$) / 2 + 1
  
   GET (3, 86)-(316, 97), TelaPiece
   LINE (xini, 86)-(xfim, 97), 0, BF
   LINE (xini, 86)-(xfim, 97), , B
   LOCATE 12, xtolocate
   PRINT message$;

END SUB

SUB PutObject
     
      xobj = xcols * 32 + 10
      yobj = yrows * 64 + 24
      FOR mytry = 1 TO Nobjetos
         IF Objetos(mytry, 1) = xtela AND Objetos(mytry, 2) = ytela AND Objetos(mytry, 3) = xcols AND Objetos(mytry, 4) = yrows THEN
            objnumber = Objetos(mytry, 5)
            IF objnumber = 0 THEN LINE (xobj, yobj)-(xobj + 12, yobj + 10), 0, BF
            IF objnumber = 1 THEN PUT (xobj, yobj), Booster
            IF objnumber = 2 THEN PUT (xobj, yobj), Unlocker
         END IF
      NEXT mytry

END SUB

DEFINT A-Z
SUB ReadGIF (filename$, nodefine$)
'--- Extrado do programa GIF.BAS (Rich Geldreich) ---
'Eu adicionei o -nodefine- para que possamos ler as figuras e desenh-las
'a partir da palheta atual, ou seja, sem definir a palheta. Assim, escreva
'"nodefine" como o seg. parmetro se no quiser redefinir a palheta, ou
'qualquer coisa para defin-la durante a leitura da GIF
'+-----------------------------------------------------------------------+
'| Usar GIF87a entrelaado, 256 cores                                    |
'| A ordem da palette aparece corretamente, assim como no PSP            |
'| O ideal  converter as figuras para 256 cores mantendo as do Windows  |
'| (opo do PSP), para que possamos utiliz-las para mensagens, etc.    |
'+-----------------------------------------------------------------------+
nodefine$ = LCASE$(nodefine$)

DEFINT A-Z
DIM Prefix(4095), Suffix(4095), OutStack(4095), shiftout%(8)
DIM Ybase AS LONG, powersof2(11) AS LONG, WorkCode AS LONG

FOR a% = 0 TO 7: shiftout%(8 - a%) = 2 ^ a%: NEXT a%
FOR a% = 0 TO 11: powersof2(a%) = 2 ^ a%: NEXT a%

OPEN filename$ FOR BINARY AS #1
a$ = "      ": GET #1, , a$
IF a$ <> "GIF87a" THEN PRINT "Not a GIF87a file.": END
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
NumColors = 2 ^ ((a% AND 7) + 1): NoPalette = (a% AND 128) = 0
GOSUB GetByte: Background = a%
GOSUB GetByte: IF a% <> 0 THEN PRINT "Bad screen descriptor.": END
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
DO
    GOSUB GetByte
    IF a% = 44 THEN
        EXIT DO
    ELSEIF a% <> 33 THEN
        PRINT "Unknown extension type.": END
    END IF
    GOSUB GetByte
    DO: GOSUB GetByte: a$ = SPACE$(a%): GET #1, , a$: LOOP UNTIL a% = 0
LOOP
GET #1, , XStart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
XEnd = XStart + XLength: YEnd = YStart + YLength: GOSUB GetByte
IF a% AND 128 THEN PRINT "Can't handle local colormaps.": END
Interlaced = a% AND 64: PassNumber = 0: PassStep = 8
GOSUB GetByte
ClearCode = 2 ^ a%
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = a% + 1: CodeSize = StartCodeSize
StartMaxCode = 2 ^ (a% + 1) - 1: MaxCode = StartMaxCode

BitsIn = 0: BlockSize = 0: BlockPointer = 1
x% = XStart: y% = YStart: Ybase = y% * 320&

SCREEN 13: DEF SEG = &HA000
IF NoPalette = 0 THEN
    OUT &H3C7, 0: IF nodefine$ <> "nodefine" THEN OUT &H3C8, 0
    IF nodefine$ <> "nodefine" THEN FOR a% = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, a%, 1)) \ 4: NEXT a%
END IF
LINE (0, 0)-(319, 199), Background, BF
DO
    GOSUB GetCode
    IF Code <> EOSCode THEN
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            GOSUB GetCode
            CurCode = Code: LastCode = Code: LastPixel = Code
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0
            IF Code > NextCode THEN EXIT DO
            IF Code = NextCode THEN
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF

            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP

            LastPixel = CurCode
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine

            FOR a% = StackPointer - 1 TO 0 STEP -1
                IF x% < 320 THEN POKE x% + Ybase, OutStack(a%)
                x% = x% + 1: IF x% = XEnd THEN GOSUB NextScanLine
            NEXT a%

            IF NextCode < 4096 THEN
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                IF NextCode > MaxCode AND CodeSize < 12 THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL DoneFlag OR Code = EOSCode

GOTO termina

GetByte: a$ = " ": GET #1, , a$: a% = ASC(a$): RETURN

NextScanLine:
    IF Interlaced THEN
        y% = y% + PassStep
        IF y% >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: y% = 4: PassStep = 8
            CASE 2: y% = 2: PassStep = 4
            CASE 3: y% = 1: PassStep = 2
            END SELECT
        END IF
    ELSE
        y% = y% + 1
    END IF
    x% = XStart: Ybase = y% * 320&: DoneFlag = y% > 199
RETURN
GetCode:
    IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = a%: BitsIn = 8
    WorkCode = LastChar \ shiftout%(BitsIn)
    DO WHILE CodeSize > BitsIn
        GOSUB ReadBufferedByte: LastChar = a%
        WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
    BitsIn = BitsIn - CodeSize
    Code = WorkCode AND MaxCode
RETURN
ReadBufferedByte:
    IF BlockPointer > BlockSize THEN
        GOSUB GetByte: BlockSize = a%
        a$ = SPACE$(BlockSize): GET #1, , a$
        BlockPointer = 1
    END IF
    a% = ASC(MID$(a$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN

termina:

CLOSE #1

END SUB

DEFSNG A-Z
SUB ReadScenario (n, xscreen, yscreen, xposition, yposition)

'n = nmero (inteiro) do estgio, devendo haver o arquivo correspondente
'xscreen = coord x da tela inicial dentre as da telas largura
'yscreen = coord y da tela inicial dentre as da telas altura
'xposition = xbloco inicial do personagem
'yposition = ybloco inicial do personagem

'* Desabilitando NUM LOCK * (ele trava o boneco em seus movimentos) *
   DEF SEG = 0
   ks = PEEK(&H417)
   oldks = ks
   IF ks > 127 THEN ks = ks - 128
   IF ks > 63 THEN ks = ks - 64
   IF ks > 31 THEN POKE &H417, (oldks XOR &H20)

'--- Zerando o Cenrio - o "0"  o bloco vazio! ---
   FOR y = 0 TO altlim - 1
      Cenario$(y) = STRING$(larglim, "0")
   NEXT y

'### Abrindo o n-simo MAPA #####################################

MapFileName$ = "stage" + RIGHT$(STR$(n), 1) + ".map"

OpenMap MapFileName$
   xtela = xscreen      'definindo qual ser a primeira tela!
   ytela = yscreen
   Redraw

FadeToBlack 30, -1         'fade-in da tela

'#################################################################

'**************************************************************************
'  Personagem no ponto de partida --- devemos definir este ponto no mapa?
'**************************************************************************

xbloco = xposition
ybloco = yposition

'--- Igual a PutFirstTime do GameOn -----------------------------------
xpixel = 32 * xbloco
ypixel = 64 * ybloco + 10

   IF LEFT$(Pstatus$, 1) = "R" THEN
      PUT (xpixel, ypixel), Rparado, PSET
      Pstatus$ = "R parado"
   ELSE
      PUT (xpixel, ypixel), Lparado, PSET
      Pstatus$ = "L parado"
   END IF
   Nquadro = 0
'----------------------------------------------------------------------

END SUB

SUB Redraw
'********************************************************************
'*** Redesenha a tela com xtela e ytela previamente especificados ***
'********************************************************************

   FOR yrows = 0 TO 2
      ys = yrows * 64
      FOR xcols = 0 TO 9
         xs = xcols * 32
         a$ = MID$(Cenario$(yrows + ytela * 3), xcols + xtela * 10 + 1, 1)
         IF a$ = "q" THEN PUT (xs, ys), Bloco1, PSET
         IF a$ = "w" THEN PUT (xs, ys), Bloco2, PSET
         IF a$ = "e" THEN PUT (xs, ys), Piso, PSET
         IF a$ = "r" THEN PUT (xs, ys), Teto, PSET
         IF a$ = "t" THEN PUT (xs, ys), PisoTeto, PSET
         IF a$ = "y" THEN PUT (xs, ys), Bloco3, PSET
         IF a$ = "u" THEN PUT (xs, ys), Bloco4, PSET
         IF a$ = "x" THEN PUT (xs, ys), Saida, PSET
         IF a$ = "a" THEN PUT (xs, ys), PisoLaser, PSET
         IF a$ = "s" THEN PUT (xs, ys), PisoTetoLaser, PSET
         IF a$ = "d" THEN PUT (xs, ys), MuroEnergiaOn, PSET
         IF a$ = "f" THEN PUT (xs, ys), MuroEnergiaOff, PSET
         IF a$ = "g" THEN PUT (xs, ys), ObjWall, PSET: PutObject
         IF a$ = "0" THEN PUT (xs, ys), Vazio, PSET
      NEXT xcols
   NEXT yrows
   a$ = ""

END SUB

SUB RestoreScreen (n)

   SLEEP n

   PUT (3, 86), TelaPiece, PSET

END SUB

SUB SetEnergy (EnergyChange)

LINE (1, 197)-(100, 197), 0   'Clears the energy bar

IF EnergyChange = 0 THEN
   LINE (0, 196)-(101, 198), 258, B  'Barra de energia
   PSET (103, 195), 258: DRAW "R2L2D2R1L1D2R2"
END IF
  
Energy = Energy + EnergyChange
IF Energy > 100 THEN Energy = 100
IF Energy <= 1 THEN Morre "queda"
IF Energy > 20 THEN EnergyColor = 250 ELSE EnergyColor = 249
LINE (1, 197)-(Energy, 197), EnergyColor     'Draw new energy status

END SUB

SUB SetPalette

   'Valores na matriz 256x3 MyPalette
   'Exemplo para a Screen 13 (256 cores)
   cores = 256   'altere aqui!
  
   ultima = cores - 1
   FOR index = 0 TO ultima
         OUT &H3C8, index
         OUT &H3C9, MyPalette(index, 1)
         OUT &H3C9, MyPalette(index, 2)
         OUT &H3C9, MyPalette(index, 3)
   NEXT index

END SUB

SUB SoundConfig

trycounter = 0
MySoundTry:
   SoundTest      '-- Verificao de parmetros importantes (10 tentativas) --
   trycounter = trycounter + 1
   IF trycounter = 10 THEN GOTO ContSound
   IF NOT SoundTestVerif THEN GOTO MySoundTry

ContSound:
   Freq& = 10000  '--- frequncia de reproduo ---
   Channel% = 1   '--- DMA channel used ---

END SUB

SUB SoundTest
'-----------------------------------------
'--- Retirado do programa DMAPLAY.BAS ---
'-----------------------------------------
'--- GetBLASTER ----------
IF LEN(ENVIRON$("BLASTER")) = 0 THEN PRINT "BLASTER environment variable not set.": GOTO ContS1
FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
      CASE "A"
        BasePort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
      CASE "I"
        IRQ% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
      CASE "D"
        DMA% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
   END SELECT
NEXT
'----------------------------
ContS1:
'------- ResetDSP -----------------
OUT BasePort% + 6, 1
FOR Count% = 1 TO 4
   junk% = INP(BasePort% + 6)
NEXT
OUT BasePort% + 6, 0
IF INP(BasePort% + 14) AND &H80 = &H80 AND INP(BasePort% + 10) = &HAA THEN
   ResetDSP% = -1
ELSE
   ResetDSP% = 0
END IF
'----------------------------------
IF ResetDSP% THEN 'resets DSP (returns true if sucessful)
   SoundTestVerif = -1
ELSE
   SoundTestVerif = 0
END IF
END SUB

SUB VelocityFactor
'----------------------------------------
'--- Rotina de Controle de Velocidade ---
'----------------------------------------
'Gera um fator (nmero) que ser usado em rotinas de atraso
'dos programas KCL

   '### Teste depende da tela usada! ##########################
  
   velofact = 0
   OldTimer = TIMER
   CLS
  
   DO
      c = INT(RND(1) * 16) + 1
      CIRCLE (160, 100), 30 + ABS(SIN(n)) * 30, c
      PAINT (160, 100), c
      velofact = velofact + 1
   LOOP UNTIL (TIMER - OldTimer) > 2
  
   '------------------------------------------------
   CLS
   'PRINT "The velocity test is done! Factor is"; velofact

END SUB

SUB WriteDSP (byte%)
'-----------------------------------------
'--- Retirado do programa DMAPLAY.BAS ---
'-----------------------------------------
' Writes a byte to the DSP
DO
LOOP WHILE INP(BasePort% + 12) AND &H80
OUT BasePort% + 12, byte%
END SUB

