'---
' ..Another PacMan Clone.  Made just for fun one day in May'98.
'
' Keys are as follows..
'
'               Cursor keys to move PacMan up, down, left, right
'               R           to redraw level (Sometimes you may be stuck!)
'               Q           to quit game at any time
'               P           to pause game, space to continue.
'
' Programmed by SkurK/b. (skurk@multinet.no)
'
'---

DECLARE SUB Instructions ()
DECLARE SUB GameOverSub ()
DECLARE SUB NextLevel ()
DECLARE SUB Intro ()
DECLARE SUB SoundEffect (N!)
DECLARE SUB Sync ()
DECLARE SUB MonsterMove ()
DECLARE SUB PlayGame ()
DECLARE SUB DrawLevel ()
DECLARE SUB Sprite (XPos, YPos, W)
DECLARE SUB LoadGFX ()
DECLARE SUB Center (N!, a$)

DIM SHARED Figures(0 TO 18, 0 TO 63)
DIM SHARED LevelMap(0 TO 39, 0 TO 20)
DIM SHARED MonsterX(0 TO 9), MonsterY(0 TO 9), MonsterAlive(0 TO 9)

COMMON SHARED XPos, YPos, Ticks, AnimCount, Add, Lives
COMMON SHARED MonsterAnim, MonsterStatus, MonsterDelay
COMMON SHARED Score, SFX, eat, GameOver

        LoadGFX
        Intro
        DrawLevel

        DO WHILE GameOver <> 1
                Sync
                PlayGame
                MonsterMove
        LOOP
       
        SCREEN 0: WIDTH 80
        END

'---
'                  Graphics (ByteRun-Clone Compressed)
'---
DATA 15,0,50,14,0,14,0,15,0,6,14,0,15,0,12,14,15,14,2,0,15,0,4,14,15,14,2
DATA 0,15,0,4,14,15,14,2,0,15,0,34,3,15,3,7,0,15,0,18,14,15,14,3,0,15,0,3
DATA 14,15,14,3,0,15,0,3,14,15,14,3,0,15,0,3,14,15,14,3,0,15,0,3,14,15,14
DATA 3,0,15,0,3,14,15,14,3,0,15,0,2,14,15,14,1,0,14,15,14,1,0,15,0,2,14,0
DATA 15,0,1,14,15,14,1,0,15,0,2,14,0,15,0,2,14,0,15,0,2,14,15,14,4,0,15,0
DATA 2,14,15,14,4,0,15,0,2,14,15,14,4,0,15,0,3,12,15,12,3,0,15,0,2,12,15
DATA 12,5,0,15,0,2,7,15,7,3,0,15,0,2,7,15,7,5,0,3,9,15,9,5,1,0,15,0,17,14
DATA 15,14,2,11,14,15,14,1,0,15,0,1,14,15,14,2,11,14,15,14,1,0,15,0,1,14
DATA 15,14,2,11,14,15,14,1,0,15,0,1,14,15,14,1,11,14,15,14,2,0,15,0,1,14
DATA 15,14,1,11,14,15,14,2,0,15,0,1,14,15,14,1,11,14,15,14,2,0,14,15,14,2
DATA 0,14,15,14,2,0,14,15,14,2,0,14,15,14,2,0,14,15,14,1,0,15,0,1,14,15
DATA 14,2,0,14,15,14,6,0,14,15,14,6,0,14,15,14,6,0,15,0,1,12,15,12,5,0,12
DATA 1,12,15,12,3,1,12,0,7,15,7,5,0,7,15,7,1,11,7,15,7,1,11,7,15,7,1,3,9
DATA 15,9,5,1,0,15,0,16,14,15,14,5,0,15,0,1,14,15,14,31,0,15,0,1,14,15,14
DATA 10,11,14,0,14,15,14,4,11,14,0,14,15,14,2,0,14,11,14,0,14,15,14,6,0,14
DATA 15,14,6,0,14,15,14,6,0,12,1,12,15,12,3,1,12,15,12,2,1,12,15,12,1,1,12
DATA 15,12,1,7,15,7,1,11,7,15,7,1,11,7,15,7,2,11,7,15,7,3,11,7,3,9,15,9,5
DATA 1,0,15,0,3,10,0,15,0,5,13,15,13,1,5,0,15,0,2,14,15,14,3,0,15,0,3,14,15
DATA 14,4,0,15,0,2,14,15,14,4,0,15,0,5,14,15,14,4,0,15,0,2,14,15,14,4,0,15
DATA 0,3,14,15,14,10,0,14,15,14,6,0,14,15,14,6,0,14,15,14,4,11,14,0,14,15
DATA 14,4,11,14,0,14,15,14,2,0,14,11,14,0,12,15,12,1,1,12,15,12,1,1,12,15
DATA 12,9,7,11,7,15,7,3,11,7,15,7,8,3,9,15,9,5,1,0,15,0,2,10,2,15,2,1,0,15
DATA 0,3,13,5,15,5,3,0,15,0,1,14,15,14,4,0,15,0,2,14,15,14,5,0,15,0,1,14,15
DATA 14,15,0,15,0,1,14,15,14,5,0,15,0,2,14,15,14,11,0,14,15,14,6,0,14,15,14
DATA 6,0,14,15,14,2,0,14,15,14,2,0,14,15,14,2,0,14,15,14,2,0,14,15,14,1,0,15
DATA 0,1,14,15,14,2,0,12,15,12,15,7,15,7,15,3,9,15,9,5,1,0,15,0,3,2,0,15,0,5
DATA 5,15,5,2,0,15,0,3,14,15,14,5,0,15,0,1,14,15,14,5,0,15,0,1,14,15,14,5,0
DATA 15,0,1,14,15,14,5,0,15,0,1,14,15,14,5,0,15,0,1,14,15,14,5,0,15,0,1,14
DATA 15,14,4,0,15,0,2,14,15,14,4,0,15,0,2,14,15,14,4,0,15,0,2,14,15,14,1,0
DATA 14,15,14,1,0,15,0,2,14,0,15,0,1,14,15,14,1,0,15,0,2,14,0,15,0,2,14,0
DATA 15,0,1,12,0,12,0,12,0,12,0,15,0,1,12,0,12,0,12,0,12,7,0,7,0,7,0,7,0,15
DATA 0,1,7,0,7,0,7,0,7,3,9,15,9,5,1,0,15,0,18,14,15,14,3,0,15,0,3,14,15,14
DATA 3,0,15,0,3,14,15,14,3,0,15,0,3,14,15,14,3,0,15,0,3,14,15,14,3,0,15,0,3
DATA 14,15,14,3,0,15,0,3,14,15,14,2,0,15,0,4,14,15,14,2,0,15,0,4,14,15,14,2
DATA 0,15,0,4,14,0,14,0,15,0,6,14,0,15,0,11,12,0,12,0,12,0,12,15,12,1,0,12
DATA 0,12,0,12,0,15,0,1,7,0,7,0,7,0,7,15,7,1,0,7,0,7,0,7,0,3,1,15,1,6,0

' That's all folks! :)

SUB Center (N, a$)
        LOCATE N, 21 - (LEN(a$) / 2): PRINT a$
END SUB

SUB DrawLevel
        RANDOMIZE TIMER

'-- make walls

        FOR X = 0 TO 39
                LevelMap(X, 0) = 16
                LevelMap(X, 20) = 16
        NEXT X
        FOR Y = 0 TO 19
                LevelMap(0, Y) = 16
                LevelMap(39, Y) = 16
        NEXT Y
     
'-- place some food and random blocks

        FOR Y = 1 TO 19
        LevelMap(1, Y) = 99
        LevelMap(38, Y) = 99
        NEXT Y

        eat = 0
        FOR X = 2 TO 37
        FOR Y = 1 TO 19
                N = INT(RND(1) * 100)
                LevelMap(X, Y) = 99             'default
                IF N < 25 THEN LevelMap(X, Y) = 17: eat = eat + 1
                IF N < 20 THEN LevelMap(X, Y) = 16: eat = eat - 1
                IF N = 99 THEN LevelMap(X, Y) = 18: eat = eat + 1
        NEXT Y, X
 
'-- Make two warpzones in left and right side

        Y = INT(RND(1) * 15) + 3
        LevelMap(0, Y) = 99
        LevelMap(39, Y) = 99

'-- Place out some monsters and modify map data

        FOR N = 0 TO 9
Again:
             X = INT(RND(1) * 37) + 2
             Y = INT(RND(1) * 17) + 2
             IF LevelMap(X, Y) <> 99 THEN GOTO Again    'only put where blank
             MonsterX(N) = X * 8
             MonsterY(N) = Y * 8
             MonsterAlive(N) = 1
             LevelMap(X, Y) = 12
        NEXT N


'-- OK, Map is finished, now draw it:

        LevelMap(1, 1) = 0
        FOR X = 0 TO 39
        FOR Y = 0 TO 20
                IF LevelMap(X, Y) <> 99 THEN Sprite X * 8, Y * 8, LevelMap(X, Y)
        NEXT Y, X
        SoundEffect (4)
        MonsterStatus = 0
        Ticks = 0
        XPos = 8
        YPos = 8

END SUB

SUB GameOverSub
      SoundEffect (7)
      IF Lives = 0 THEN GameOver = 1 ELSE Lives = Lives - 1
      FOR N = 380 TO 1 STEP -3
      IF SFX = 1 THEN IF (N AND (7)) = 0 THEN SOUND N * 2 + 300, .3
      Sync
      FOR U = 1 TO 3
        CIRCLE (XPos, YPos), N + U, 15
        CIRCLE (XPos + 1, YPos), N + U, 15
        CIRCLE (XPos, YPos), N + U, 0
        CIRCLE (XPos + 1, YPos), N + U, 0
      NEXT U, N
      CLS
      COLOR 13
      Center 12, "Game Over"
      Center 14, "Play again? (Y/N)"
      DO WHILE ((a$ <> "Y") AND (a$ <> "N")): a$ = UCASE$(INKEY$): LOOP
      CLS
      XPos = 8
      YPos = 8: Score = 0: Lives = 2
      IF a$ = "Y" THEN GameOver = 0: DrawLevel
      IF a$ = "N" THEN GameOver = 1

END SUB

SUB Instructions
        CLS
        FOR X = 0 TO 39
                Sprite X * 8, 0, 16
                Sprite X * 8, 20 * 8, 16
        NEXT X
        FOR Y = 0 TO 19
                Sprite 0, Y * 8, 16
                Sprite 39 * 8, Y * 8, 16
        NEXT Y
        COLOR 7
        Center 3, "Instructions"
        Center 5, "Use your cursor keys to move around."
        Center 6, "Eat all the food  and advance"
        Center 7, "to the next level."
      
        Center 9, "If you eat a superpill   "
        Center 10, "the monsters   become grey    "
        Center 11, "and you can eat them too."
             
        Center 13, "You have 3 lives.  Each time you"
        Center 14, "hear a sqeek or get transported"
        Center 15, "to the upper left corner, you have"
        Center 16, "collided with a monster."

        Center 18, "Press [SPACE] to return"
      
        Sprite 170, 40, 17
        Sprite 235, 63, 18
        Sprite 144, 72, 13
        Sprite 256, 72, 15

        DO WHILE INKEY$ <> " ": LOOP
        CLS
        Intro
END SUB

SUB Intro
        MaxStars = 32: Lives = 2
        DEF SEG = &HA000
        Text$ = "BackMan... Pacman's Back again!  Use your cursor keys to move around.. Q at any time to quit.   R to redraw level (if you're stuck) ...      This not-too-seriously-developed game was programmed 13th of May 1998.  Have fun!         "

        DIM ScrArea(1 TO 320 * 8)

        SCREEN 13
    
        Center 1, "Pacman's Back - Backman!"
        Center 2, "by SkurK/b."
        COLOR 5
        Center 5, "----------------------------"
        COLOR 11
        Center 6, "Name                  Points"
        COLOR 6
        Center 8, "Food                       1"
        Center 10, "Superpill                  5"
        Center 12, "Wall                       -"
        Center 14, "Sissy Ghost               15"
        Center 16, "Angry Ghost          You die"
        Center 18, "You                        -"
        COLOR 5
        Center 19, "----------------------------"

        COLOR 14
        Center 21, "Press N to start with sounds "
        Center 22, "Press S to start in silent mode"
        Center 23, "Press I for instructions screen"

        Sprite 150, 8 * 7, 17
        Sprite 150, 8 * 9, 18
        Sprite 150, 8 * 11, 16
        Sprite 150, 8 * 13, 15
        Sprite 150, 8 * 15, 13
        Sprite 150, 8 * 17, 0

        DIM Xp(MaxStars)
        DIM Yp(MaxStars)
        DIM Sa(MaxStars)
       
        FOR N = 1 TO MaxStars
            Xp(N) = 160 + RND(1) * 9 - 4
            Yp(N) = 100 + RND(1) * 9 - 4
        NEXT N

        LINE (0, 188)-(319, 188), 7
        LINE (0, 189)-(319, 199), 8, BF
        DO WHILE ((a$ <> "S") AND (a$ <> "N") AND (a$ <> "I") AND (a$ <> "Q"))
        Sync
        a$ = UCASE$(INKEY$)
        GOSUB Stars
        GOSUB Scroller
        LOOP
        IF a$ = "Q" THEN
                SCREEN 0: WIDTH 80
                END
        END IF
        IF a$ = "S" THEN SFX = 0 ELSE SFX = 1
        IF a$ = "I" THEN Instructions
        CLS
        EXIT SUB


Stars:
        FOR N = 1 TO MaxStars
            IF Sa(N) = 0 THEN PSET (INT(Xp!(N)), INT(Yp!(N))), 0
            IF Xp!(N) < 1 OR Xp!(N) > 319 OR Yp!(N) < 10 OR Yp!(N) > 187 THEN
               Xp!(N) = 160 + (RND(1) * 9) - 4
               Yp!(N) = 100 + (RND(1) * 9) - 4
            END IF
            Xp!(N) = Xp!(N) - (160 - Xp!(N)) / 80
            Yp!(N) = (Yp!(N) - (100 - Yp!(N)) / 80)
            Sa(N) = PEEK(INT(Xp!(N)) + INT(Yp!(N)) * 320)
            IF Sa(N) = 0 THEN PSET (INT(Xp!(N)), INT(Yp!(N))), (N AND 15) + 15
        NEXT N
        RETURN


Scroller:
        GET (1, 190)-(319, 199), ScrArea
        PUT (0, 190), ScrArea, PSET
        FOR Y = 0 TO 7
                a = PEEK(8 - charptr + Y * 320)
                IF a > 0 THEN
                        PSET (317, 192 + Y), 30
                        PSET (318, 191 + Y), 20
                END IF
        NEXT Y
        IF charptr = 0 THEN
        IF txtptr > LEN(Text$) THEN txtptr = 0
        txtptr = txtptr + 1
        COLOR 16
        LOCATE 1, 1
        PRINT MID$(Text$, txtptr, 1);
        charptr = 8
        ELSE
        charptr = charptr - 1
        END IF
        RETURN

END SUB

'---
' This part uncompresses the sprites and loads them into individual banks.
'---
SUB LoadGFX
        SCREEN 13
        Center 10, "Please wait"
        Center 12, "Uncompressing graphics"
        FOR N = 1 TO 584
        READ a
       
        IF a = 15 THEN
                READ Col
                READ Num
                FOR T = 1 TO Num
                        X = X + 1: IF X > 153 THEN X = 1: Y = Y + 1
                        PSET (X, Y), Col
                NEXT T
        ELSE
                X = X + 1: IF X > 153 THEN X = 1: Y = Y + 1
                PSET (X, Y), a
        END IF
        NEXT N
     
'---------------------------------------------

        Center 12, "Loading data into banks"

        DEF SEG = &HA000
        FOR N = 0 TO 18
        FOR X = 0 TO 7
        FOR Y = 0 TO 7
                Figures(N, X + Y * 8) = PEEK(N * 8 + X + 1 + Y * 320)
        NEXT Y, X, N

        CLS
END SUB

SUB MonsterMove

'-- first see if it's time to update monsters
        IF MonsterDelay = 0 THEN GOTO Update
        MonsterDelay = MonsterDelay - 1
        EXIT SUB

'-- then let's check if monsters should be "ticking"
       
Update: MonsterDelay = 5
        MonsterStatus = 0
       
        IF AnimCount = 2 THEN AnimCount = 0
        AnimCount = AnimCount + 1

        IF Ticks > 0 THEN
                MonsterStatus = 2
                Ticks = Ticks - 1
        END IF
        IF Ticks < 15 THEN MonsterStatus = (Ticks AND 1) * 2     ' for blinking
        IF Ticks < 15 THEN IF (Ticks AND 1) = 1 THEN SoundEffect (6)

        MonsterAnim = (MonsterAnim + 1) AND 1
        FOR N = 0 TO 9
                IF MonsterAlive(N) = 1 THEN
                        I = INT(RND(1) * 4) + 1
                        PMX = MonsterX(N)
                        PMY = MonsterY(N)
                        IF I = 1 THEN MonsterX(N) = MonsterX(N) - 8
                        IF I = 2 THEN MonsterX(N) = MonsterX(N) + 8
                        IF I = 3 THEN MonsterY(N) = MonsterY(N) - 8
                        IF I = 4 THEN MonsterY(N) = MonsterY(N) + 8
                        IF MonsterX(N) = 320 THEN MonsterX(N) = 0
                        IF MonsterX(N) = -8 THEN MonsterX(N) = 320 - 8
                        Position = LevelMap(INT(MonsterX(N) \ 8), INT(MonsterY(N) \ 8))
                       
                        IF Position < 12 THEN
                                IF MonsterStatus = 0 THEN
                                        'Sprite PMX, PMY, 13
                                        IF Lives = 0 THEN
                                                Sprite MonsterX(N), MonsterY(N), 12
                                                GameOverSub
                                        ELSE
                                                Lives = Lives - 1
                                                SoundEffect (8)
                                                Sprite XPos, YPos, 99
                                                XPos = 8
                                                YPos = 8
                                                Position = 99
                                        END IF
                                END IF
                                IF MonsterStatus = 2 THEN
                                        MonsterAlive(N) = 0
                                        SoundEffect (3)
                                        Score = Score + 15
                                        Sprite PMX, PMY, 99
                                        LevelMap(INT(PMX \ 8), INT(PMY \ 8)) = 99
                                        GOTO SkipMe
                                END IF
                        END IF


                        IF Position <> 99 THEN
                                MonsterX(N) = PMX: MonsterY(N) = PMY
                        ELSE
                                LevelMap(INT(PMX / 8), INT(PMY / 8)) = 99
                                LevelMap(INT(MonsterX(N) / 8), INT(MonsterY(N) / 8)) = 12 + MonsterStatus
                                Sprite PMX, PMY, 99
                                Sprite MonsterX(N), MonsterY(N), 12 + MonsterAnim + MonsterStatus
                        END IF
                END IF
SkipMe:
        NEXT N
END SUB

SUB NextLevel
        DEF SEG
        FOR N = 0 TO 319 STEP 2
        IF (N AND 5) = 0 THEN Sync
        LINE (319 - N, 0)-(319 - N, 199), 0
        LINE (N, 0)-(N, 199), 0
        NEXT N
        XPos = 8: YPos = 8
      
        COLOR 14
        Center 12, "Prepare for the next level"
        Center 14, "Press [SPACE] to start"
        SoundEffect (5)
        DO WHILE INKEY$ <> " ": LOOP
        CLS
        DrawLevel
END SUB

SUB PlayGame

    a$ = UCASE$(INKEY$)
    IF a$ <> "" THEN

        PrevX = XPos
        PrevY = YPos

        SELECT CASE a$
            CASE CHR$(0) + CHR$(72)
                YPos = YPos - 8
                Add = 6
            CASE CHR$(0) + CHR$(80)
                YPos = YPos + 8
                Add = 9
            CASE CHR$(0) + CHR$(75)
                XPos = XPos - 8
                Add = 3
            CASE CHR$(0) + CHR$(77)
                XPos = XPos + 8
                Add = 0
            CASE "P"
                
                COLOR 15
                a = 49
                DO WHILE INKEY$ <> " "
                Sync
                a = a + 1
                IF a = 25 THEN
                LOCATE 23, 1
                PRINT "                                        "
                END IF
                IF a = 50 THEN
                LOCATE 23, 1
                PRINT "Game paused - Press [SPACE] to continue."
                a = 0
                END IF
                LOOP
                LOCATE 23, 1
                PRINT "                                        "
            CASE "Q"
                GameOver = 1
            CASE "R"
                CLS
                DrawLevel
        END SELECT
     
        IF XPos = -8 THEN XPos = 320 - 8
        IF XPos = 320 THEN XPos = 0
        Position = LevelMap(INT(XPos / 8), INT(YPos / 8))
       
' check if pacman eats something good first... ----------------------------

        IF Position = 18 THEN
                Score = Score + 5: eat = eat - 1
                Ticks = 50
                SoundEffect (1)
                LevelMap(INT(XPos / 8), INT(YPos / 8)) = 99
                Position = 99
        END IF
        IF Position = 17 THEN
                SoundEffect (2)
                Score = Score + 1: eat = eat - 1
                LevelMap(INT(XPos / 8), INT(YPos / 8)) = 99
                Position = 99
        END IF

        IF eat = 0 THEN NextLevel: EXIT SUB

'--------------------------------------------------------------------------
      
        IF ((Position <> 99) AND (Position <> 0)) THEN XPos = PrevX: YPos = PrevY
        Sprite PrevX, PrevY, 99
       
        LevelMap(INT(PrevX / 8), INT(PrevY / 8)) = 99
        LevelMap(INT(XPos / 8), INT(YPos / 8)) = 1

   END IF
   Sprite XPos, YPos, Add + AnimCount

'-- update scores etc..
        LOCATE 23, 1
        COLOR 3
        PRINT "Score: "; Score; " Food: "; eat; "  Lives: "; Lives + 1
END SUB

SUB SoundEffect (N)
        IF SFX = 0 THEN EXIT SUB
        IF N = 1 THEN
              FOR U = 500 TO 1100 STEP 200
                 Sync
                 SOUND U, .3
              NEXT U
        END IF
        IF N = 2 THEN
                FOR U = 200 TO 500 STEP 200
                Sync
                SOUND U, .3
                NEXT U
        END IF
        IF N = 3 THEN
                FOR U = 200 TO 1000 STEP 100
                Sync
                SOUND U, .3
                NEXT U
                FOR U = 1000 TO 600 STEP -50
                Sync
                SOUND U, .3
                NEXT U
        END IF
        IF N = 4 THEN
                SOUND 300, 3
                SOUND 370, 3
                SOUND 400, 3
        END IF
        IF N = 5 THEN
                SOUND 300, 1.5
                SOUND 400, 1.5
                SOUND 500, 1.5
                SOUND 600, 3
                SOUND 500, 1.5
                SOUND 600, 3
        END IF
        IF N = 6 THEN SOUND 1550, .05
        IF N = 7 THEN SOUND 60, 5
        IF N = 8 THEN
                FOR U = 200 TO 1600 STEP 200
                SOUND U, .2
                Sync
                NEXT U
                FOR U = 1600 TO 1000 STEP -200
                SOUND U, .2
                Sync
                NEXT U
        END IF
END SUB

SUB Sprite (XPos, YPos, W)
        IF W = 99 THEN
                FOR X = 0 TO 7
                FOR Y = 0 TO 7
                        PSET (X + XPos, Y + YPos), 0
                NEXT Y, X
        ELSE
                FOR X = 0 TO 7
                FOR Y = 0 TO 7
                        PSET (X + XPos, Y + YPos), Figures(W, X + Y * 8)
                NEXT Y, X
        END IF
END SUB

SUB Sync
        WAIT &H3DA, 8
        WAIT &H3DA, 8, 8
END SUB

