DECLARE SUB sprites (file$)
DECLARE SUB loadlev (file$)
DECLARE SUB loadsnd (file$)
DECLARE SUB drawinit ()
DECLARE SUB title ()
DECLARE SUB font (Text$, Xstart%, Ystart%, Xscale%, Yscale%, Style%, Tclr%)
DECLARE SUB loadfont (file$)
DECLARE SUB main ()
DECLARE SUB dead ()
DECLARE SUB gameover ()
DECLARE SUB winlevel ()
DECLARE SUB wingame ()
DECLARE SUB help ()
DECLARE SUB credits ()
DECLARE SUB intro ()
DECLARE SUB pause ()

TYPE sndtype
 title AS STRING * 10
 credits AS STRING * 10
END TYPE
TYPE objtype
 x AS INTEGER
 y AS INTEGER
 d AS INTEGER
END TYPE

CONST cpuspeed = 10000, maxbad = 5, maxeggfall = 3, maxlevels = 3, maxlives = 3
DIM SHARED penR(200), penL(200), egg(200), snow(200), ice1(200), ice2(200)
DIM SHARED ice3(200), mound(200), bearR(200), bearL(200), igloo(200)
DIM SHARED eggS(200), penD(200), wigloo(200), eggB(200), ball(200)
DIM SHARED smat(1 TO 22, 1 TO 14), penP AS objtype, eggP AS objtype, custom$
DIM SHARED FontBuf(0) AS STRING * 10368, s AS STRING * 1, snds(70) AS sndtype
DIM SHARED bad(1 TO maxbad) AS objtype, iglooP AS objtype, iceB(1 TO 2) AS objtype
COMMON SHARED level, lives

SCREEN 13
sprites "penguin.spr"
loadfont "penguin.fnt"
loadsnd "penguin.snd"
'intro
title

SUB credits
CLS
OPEN "penguin3.pal" FOR BINARY AS #1
FOR i = 0 TO 256
 GET #1, , s
 a = ASC(s)
 GET #1, , s
 B = ASC(s)
 GET #1, , s
 c = ASC(s)
 OUT &H3C8, i
 OUT &H3C9, a
 OUT &H3C9, B
 OUT &H3C9, c
NEXT i
CLOSE #1
DEF SEG = &HA000
BLOAD "penguin3.scr", 0
DEF SEG
font "head designer", 30, 10, 1, 1, 1, 200
font "GLENN POWELL", 30, 20, 1, 1, 1, 7
font "assistant designer", 30, 150, 1, 1, 1, 59
font "SEAN SHETTLE", 30, 160, 1, 1, 1, 7
PLAY "P3"
snum = 0
x = 1
key$ = ""
DO
 key$ = INKEY$
 IF key$ = CHR$(13) THEN
  x = x + 1
  IF x = 4 THEN EXIT SUB
  CLS
  OPEN "penguin" + LTRIM$(RTRIM$(STR$(x + 2))) + ".pal" FOR BINARY AS #1
  FOR i = 0 TO 256
   GET #1, , s
   a = ASC(s)
   GET #1, , s
   B = ASC(s)
   GET #1, , s
   c = ASC(s)
   OUT &H3C8, i
   OUT &H3C9, a
   OUT &H3C9, B
   OUT &H3C9, c
  NEXT i
  CLOSE #1
  DEF SEG = &HA000
  BLOAD "penguin" + LTRIM$(RTRIM$(STR$(x + 2))) + ".scr", 0
  DEF SEG
  IF x = 2 THEN
   font "lead programmer", 150, 10, 1, 1, 1, 68
   font "GLENN POWELL", 150, 20, 1, 1, 1, 7
   font "graphics designer", 105, 160, 1, 1, 1, 77
   font "GLENN POWELL", 105, 170, 1, 1, 1, 7
  END IF
  IF x = 3 THEN
   font "sound manager", 160, 10, 1, 1, 1, 210
   font "GLENN POWELL", 160, 20, 1, 1, 1, 7
   font "game tester", 30, 170, 1, 1, 1, 73
   font "AURELIA PEZZI", 30, 180, 1, 1, 1, 15
   font "game tester", 170, 170, 1, 1, 1, 73
   font "SEAN SHETTLE", 170, 180, 1, 1, 1, 15
  END IF
 END IF
 IF PLAY(0) = 0 THEN
  IF snds(snum).credits = "END       " THEN snum = 0
  PLAY snds(snum).credits
  snum = snum + 1
 END IF
LOOP
END SUB

SUB dead
PLAY "P5"
LINE (105, 75)-(198, 100), 0, BF
LINE (105, 75)-(198, 100), 75, B
font "OOPS!", 110, 80, 2, 2, 2, 40
PLAY "O0L3AG"
pause
CLS
font "EGGS LEFT", 80, 30, 2, 2, 2, 74
y = 150 / maxlives
FOR x = 1 TO lives
 PUT (x * y + 50, 80), egg, PSET
NEXT x
FOR x = lives + 1 TO maxlives
 PUT (x * y + 50, 100), eggB, PSET
NEXT x
FOR z = -cpuspeed * 3 TO cpuspeed * 3
NEXT z
lives = lives - 1
LINE ((lives + 1) * y + 50, 80)-((lives + 1) * y + 65, 95), 0, BF
PUT ((lives + 1) * y + 50, 100), eggB, PSET
SOUND 100, 1
pause
END SUB

SUB drawinit
CLS
IF custom$ = "." THEN
 font "LEVEL " + LTRIM$(STR$(level)), 100, 80, 2, 2, 2, 40
ELSE
 font "CUSTOM LEVEL", 55, 80, 2, 2, 2, 40
 LOCATE 15, 17
 PRINT custom$
END IF
PLAY "P3O2L20AAABP10AL5B"
FOR z = -cpuspeed * 3 TO cpuspeed * 3
NEXT z
CLS
FOR y = 1 TO 14
 FOR x = 1 TO 22
  SELECT CASE smat(x, y)
   CASE 0
   CASE 3
    PUT ((x - 1) * 14 + 1, (y - 1) * 14 + 1), snow, PSET
   CASE 4
    PUT ((x - 1) * 14 + 1, (y - 1) * 14 + 1), ice1, PSET
   CASE 5
    PUT ((x - 1) * 14 + 1, (y - 1) * 14 + 1), mound, PSET
   CASE 8
    PUT ((x - 1) * 14 + 1, (y - 1) * 14 + 1), ice2, PSET
   CASE 9
    PUT ((x - 1) * 14 + 1, (y - 1) * 14 + 1), ice3, PSET
  END SELECT
 NEXT x
NEXT y
PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penR, PSET
PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), egg, PSET
FOR bnum# = 1 TO maxbad
 IF bad(bnum#).x > 0 THEN
  PUT ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1), bearR, PSET
 END IF
NEXT bnum#
PUT ((iglooP.x - 1) * 14 + 1, (iglooP.y - 1) * 14 + 1), igloo, PSET
END SUB

SUB font (Text$, Xstart%, Ystart%, Xscale%, Yscale%, Style%, Tclr%)
px% = Xstart%
py% = Ystart%
DEF SEG = VARSEG(FontBuf(0))
FOR H% = 1 TO LEN(Text$)
 FPtr% = 81 * (ASC(MID$(Text$, H%, 1)) - 1) '- 1
 FOR x% = 0 TO 8
  FOR y% = 0 TO 8
   Col% = PEEK(VARPTR(FontBuf(0)) + FPtr%)
   FPtr% = FPtr% + 1
   IF Col% THEN
    SELECT CASE Style%

     CASE 1
      LINE (px%, py%)-(px% + Xscale% - 1, py% + Yscale% - 1), (py% - Ystart%) + Tclr%, BF
 
     CASE 2
      FOR sty% = px% TO px% + Xscale% - 1
       FOR sty2% = py% TO py% + Yscale% - 1
        PSET (sty%, sty2%), (py% - Ystart%) + Tclr%
        IF POINT(sty% - 1, sty2%) = 0 THEN
         PSET (sty% - 1, sty2%), (py% - Ystart%) + Tclr% + 72
         PSET (sty% - 2, sty2%), (py% - Ystart%) + Tclr% + 144
        END IF
        IF POINT(sty%, sty2% - 1) = 0 THEN
         PSET (sty%, sty2% - 1), (py% - Ystart%) + Tclr% + 72
         PSET (sty%, sty2% - 2), (py% - Ystart%) + Tclr% + 144
        END IF
        IF POINT(sty% + 1, sty2%) = 0 THEN
         PSET (sty% + 1, sty2%), (py% - Ystart%) + Tclr% + 72
         PSET (sty% + 2, sty2%), (py% - Ystart%) + Tclr% + 144
        END IF
        IF POINT(sty%, sty2% + 1) = 0 THEN
         PSET (sty%, sty2% + 1), (py% - Ystart%) + Tclr% + 72
         PSET (sty%, sty2% + 2), (py% - Ystart%) + Tclr% + 144
        END IF
       NEXT
      NEXT
    
     CASE 3
      LINE (px%, py%)-(px% + Xscale% - 1, py% + Yscale% - 1), (py% - Ystart%) + Tclr%, BF
   
    END SELECT
   END IF
   py% = py% + Yscale%
  NEXT
  px% = px% + Xscale%
  py% = Ystart%
  IF Style% = 3 THEN
   LINE (px% + Xscale% + 1, py%)-(px%, py% + Yscale% * 8), 0, BF
   PUT (px% + Xscale% * 2, py% + 3), penR, PSET
   FOR z = 1 TO cpuspeed / 5
   NEXT z
  END IF
 NEXT
NEXT H%
DEF SEG
END SUB

SUB gameover
PLAY "P5"
LINE (70, 75)-(237, 100), 0, BF
LINE (70, 75)-(237, 100), 75, B
font "GAME OVER", 75, 80, 2, 2, 2, 40
PLAY "O0L3AG"
pause
END SUB

SUB help
CLS
PALETTE
font "STORY", 110, 10, 2, 2, 2, 74
font "You are potbelly penguin and you", 1, 30, 1, 1, 1, 70
font "are trying to deliver your egg to", 1, 40, 1, 1, 1, 71
font "your little igloo. This happens to", 1, 50, 1, 1, 1, 72
font "be quite a challenge, though,", 1, 60, 1, 1, 1, 73
font "considering the many obstacles you", 1, 70, 1, 1, 1, 74
font "need to overcome to obtain your", 1, 80, 1, 1, 1, 75
font "goal.", 1, 90, 1, 1, 1, 76
font "POLAR BEARS, THIN ICE, and PIT", 1, 100, 1, 1, 1, 77
font "FALLS are some of your barriers", 1, 110, 1, 1, 1, 78
font "in this snowy labyrinth.", 1, 120, 1, 1, 1, 79
font "See if you have the snowballs", 1, 140, 1, 1, 1, 80
font "enough to solve these puzzles!", 1, 150, 1, 1, 1, 81
pause
CLS
font "PLAY", 120, 10, 2, 2, 2, 74
font "You move with the left and right", 1, 30, 1, 1, 1, 70
font "arrow keys. You can push your egg", 1, 40, 1, 1, 1, 71
font "across the snow or off cliffs, but", 1, 50, 1, 1, 1, 72
font "don't let it fall too far or it", 1, 60, 1, 1, 1, 73
font "will crack. If you land on your", 1, 70, 1, 1, 1, 74
font "egg when it can only roll one way,", 1, 80, 1, 1, 1, 75
font "it will, allowing you to fall next", 1, 90, 1, 1, 1, 76
font "to it.", 1, 100, 1, 1, 1, 77
font "The polar bears are nasty, so don't", 1, 110, 1, 1, 1, 78
font "touch them. You can, however, drop", 1, 120, 1, 1, 1, 79
font "your egg on their heads to send", 1, 130, 1, 1, 1, 80
font "them to that big ice berg in the", 1, 140, 1, 1, 1, 81
font "sky.", 1, 150, 1, 1, 1, 82
pause
CLS
font "PLAY", 120, 10, 2, 2, 2, 74
font "Be careful walking across ice.", 1, 30, 1, 1, 1, 70
font "The first step will crack it, but", 1, 40, 1, 1, 1, 71
font "the next touch will shatter it when", 1, 50, 1, 1, 1, 72
font "you remove your weight. Sometimes", 1, 60, 1, 1, 1, 73
font "this can be helpful, so think", 1, 70, 1, 1, 1, 74
font "ahead.", 1, 80, 1, 1, 1, 75
font "The levels span across the globe,", 1, 90, 1, 1, 1, 76
font "so if you walk off one side, you", 1, 100, 1, 1, 1, 77
font "will end up on the other. This is", 1, 110, 1, 1, 1, 78
font "also true about the floor and", 1, 120, 1, 1, 1, 79
font "ceiling.", 1, 130, 1, 1, 1, 80
font "If you want to restart the level,", 1, 140, 1, 1, 1, 81
font "hit the space bar at any time.", 1, 150, 1, 1, 1, 82
pause
END SUB

SUB intro
CLS
FOR z = -cpuspeed * 3 TO cpuspeed * 3
NEXT z
FOR x = 60 TO 250 STEP 14
 PUT (x, 97), snow, PSET
NEXT x
PUT (80, 83), penR, PSET
PLAY "O3L10GAA"
font "POWELLCO", 80, 80, 2, 2, 3, 74
FOR z = 1 TO cpuspeed * 2
NEXT z
font "presents", 120, 120, 1, 1, 1, 74
PLAY "O3L10BDBCAA"
FOR z = -cpuspeed * 3 TO cpuspeed * 3
NEXT z
END SUB

SUB loadfont (file$)
OPEN file$ FOR BINARY AS #1
IF LOF(1) < 2 THEN
 NoFile% = 1
END IF
IF NoFile% <> 1 THEN GET #1, , FontBuf(0)
CLOSE #1
IF NoFile% THEN
 KILL "basefont.dat"
 CLS
 PRINT "The font data file couldn't be found!"
 PRINT
 PRINT "Would you like to create it? (Y/N)"
 INPUT "> ", Choice$
 IF UCASE$(Choice$) = "N" THEN
  PRINT "The program cannot run without this file!"
  SYSTEM
 ELSE
  PRINT "Hit a key to make the file."
  PRINT "You will hear a beep if it is working."
  SLEEP
  OPEN "basefont.dat" FOR BINARY AS #1
  SCREEN 13
  COLOR 16
  FOR ascii% = 1 TO 128
   CLS
   PRINT CHR$(ascii%)
   FOR x = 0 TO 8
    FOR y = 0 TO 8
     pnt$ = CHR$(POINT(x, y))
     PUT #1, , pnt$
     pnt$ = ""
    NEXT
   NEXT
  NEXT
  CLOSE
  OPEN "basefont.dat" FOR BINARY AS #1
  GET #1, , FontBuf(0)
  CLOSE #1
 END IF
END IF
END SUB

SUB loadlev (file$)
ERASE bad, smat
OPEN file$ FOR INPUT AS #1
bnum# = 1
FOR y = 1 TO 14
 FOR x = 1 TO 22
  INPUT #1, a
  IF a = 1 THEN
   penP.x = x
   penP.y = y
  ELSEIF a = 2 THEN
   eggP.x = x
   eggP.y = y
  ELSEIF a = 6 THEN
   bad(bnum#).x = x
   bad(bnum#).y = y
   bad(bnum#).d = 1
   bnum# = bnum# + 1
  ELSEIF a = 7 THEN
   iglooP.x = x
   iglooP.y = y
  ELSE
   smat(x, y) = a
  END IF
 NEXT x
NEXT y
CLOSE #1
END SUB

SUB loadsnd (file$)
OPEN file$ FOR INPUT AS #1
CLS
DO
 INPUT #1, sndtype$
 IF sndtype$ = "DONE" THEN EXIT DO
 SELECT CASE sndtype$
  CASE "TITLE"
   snum = 0
   DO
    INPUT #1, sndbyte$
    snds(snum).title = sndbyte$
    snum = snum + 1
   LOOP UNTIL sndbyte$ = "END"
  CASE "CREDITS"
   snum = 0
   DO
    INPUT #1, sndbyte$
    snds(snum).credits = sndbyte$
    snum = snum + 1
   LOOP UNTIL sndbyte$ = "END"
 END SELECT
LOOP
CLOSE #1
END SUB

SUB main
level = 1
lives = maxlives
LevelStart:
IF custom$ = "." THEN
 loadlev "p" + LTRIM$(RTRIM$(STR$(level))) + ".pen"
ELSE
 loadlev custom$
END IF
drawinit
ERASE iceB
key$ = ""
eggP.d = 0
DO UNTIL key$ = CHR$(27)
 key$ = INKEY$
 SELECT CASE key$
  CASE CHR$(0) + "K"                   'LEFT
   newx = penP.x - 1
   IF newx = 0 THEN newx = 22
   IF smat(newx, penP.y) = 0 THEN
    IF eggP.y = penP.y AND eggP.x = newx THEN
     newerx = eggP.x - 1
     IF newerx = 0 THEN newerx = 22
     IF smat(newerx, eggP.y) = 0 THEN
      LINE ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1)-((eggP.x) * 14, (eggP.y) * 14), 0, BF
      eggP.x = newerx
      PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), egg, PSET
      LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
      penP.x = newx
      PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penL, PSET
      SOUND 100, 1
      lowy = eggP.y + 1
      IF lowy = 15 THEN lowy = 1
      IF iceB(2).d = 1 THEN
       smat(iceB(2).x, iceB(2).y) = 0
       LINE ((iceB(2).x - 1) * 14 + 1, (iceB(2).y - 1) * 14 + 1)-((iceB(2).x) * 14, (iceB(2).y) * 14), 0, BF
       iceB(2).d = 0
       SOUND 40, .7
      END IF
      IF smat(eggP.x, lowy) = 8 THEN
       smat(eggP.x, lowy) = 9
       PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
       iceB(2).x = eggP.x
       iceB(2).y = lowy
       iceB(2).d = 1
       SOUND 1000, .5
      END IF
      IF smat(eggP.x, lowy) = 4 THEN
       smat(eggP.x, lowy) = 8
       PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
       SOUND 1000, .5
      END IF
      lowy = penP.y + 1
      IF lowy = 15 THEN lowy = 1
      IF iceB(1).d = 1 THEN
       smat(iceB(1).x, iceB(1).y) = 0
       LINE ((iceB(1).x - 1) * 14 + 1, (iceB(1).y - 1) * 14 + 1)-((iceB(1).x) * 14, (iceB(1).y) * 14), 0, BF
       iceB(1).d = 0
       SOUND 40, 1
      END IF
      IF smat(penP.x, lowy) = 8 THEN
       smat(penP.x, lowy) = 9
       PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
       iceB(1).x = penP.x
       iceB(1).y = lowy
       iceB(1).d = 1
       SOUND 1000, .5
      END IF
      IF smat(penP.x, lowy) = 4 THEN
       smat(penP.x, lowy) = 8
       PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
       SOUND 1000, .5
      END IF
     END IF
    ELSEIF iglooP.y = penP.y AND iglooP.x = newx THEN
    ELSE
     LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
     penP.x = newx
     PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penL, PSET
     SOUND 300, 1
     lowy = penP.y + 1
     IF lowy = 15 THEN lowy = 1
     IF iceB(1).d = 1 THEN
      smat(iceB(1).x, iceB(1).y) = 0
      LINE ((iceB(1).x - 1) * 14 + 1, (iceB(1).y - 1) * 14 + 1)-((iceB(1).x) * 14, (iceB(1).y) * 14), 0, BF
      iceB(1).d = 0
      SOUND 40, 1
     END IF
     IF smat(penP.x, lowy) = 8 THEN
      smat(penP.x, lowy) = 9
      PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
      iceB(1).x = penP.x
      iceB(1).y = lowy
      iceB(1).d = 1
      SOUND 1000, .5
     END IF
     IF smat(penP.x, lowy) = 4 THEN
      smat(penP.x, lowy) = 8
      PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
      SOUND 1000, .5
     END IF
    END IF
   END IF
 
  CASE CHR$(0) + "M"                   'RIGHT
   newx = penP.x + 1
   IF newx = 23 THEN newx = 1
   IF smat(newx, penP.y) = 0 THEN
    IF eggP.y = penP.y AND eggP.x = newx THEN
     newerx = eggP.x + 1
     IF newerx = 23 THEN newerx = 1
     IF smat(newerx, eggP.y) = 0 THEN
      LINE ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1)-((eggP.x) * 14, (eggP.y) * 14), 0, BF
      eggP.x = newerx
      PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), egg, PSET
      LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
      penP.x = newx
      PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penR, PSET
      SOUND 100, 1
      lowy = eggP.y + 1
      IF lowy = 15 THEN lowy = 1
      IF iceB(2).d = 1 THEN
       smat(iceB(2).x, iceB(2).y) = 0
       LINE ((iceB(2).x - 1) * 14 + 1, (iceB(2).y - 1) * 14 + 1)-((iceB(2).x) * 14, (iceB(2).y) * 14), 0, BF
       iceB(2).d = 0
       SOUND 40, 1
      END IF
      IF smat(eggP.x, lowy) = 8 THEN
       smat(eggP.x, lowy) = 9
       PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
       iceB(2).x = eggP.x
       iceB(2).y = lowy
       iceB(2).d = 1
       SOUND 1000, .5
      END IF
      IF smat(eggP.x, lowy) = 4 THEN
       smat(eggP.x, lowy) = 8
       PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
       SOUND 1000, .5
      END IF
      lowy = penP.y + 1
      IF lowy = 15 THEN lowy = 1
      IF iceB(1).d = 1 THEN
       smat(iceB(1).x, iceB(1).y) = 0
       LINE ((iceB(1).x - 1) * 14 + 1, (iceB(1).y - 1) * 14 + 1)-((iceB(1).x) * 14, (iceB(1).y) * 14), 0, BF
       iceB(1).d = 0
       SOUND 40, 1
      END IF
      IF smat(penP.x, lowy) = 8 THEN
       smat(penP.x, lowy) = 9
       PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
       iceB(1).x = penP.x
       iceB(1).y = lowy
       iceB(1).d = 1
       SOUND 1000, .5
      END IF
      IF smat(penP.x, lowy) = 4 THEN
       smat(penP.x, lowy) = 8
       PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
       SOUND 1000, .5
      END IF
     END IF
    ELSEIF iglooP.y = penP.y AND iglooP.x = newx THEN
    ELSE
     LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
     penP.x = newx
     PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penR, PSET
     SOUND 300, 1
     lowy = penP.y + 1
     IF lowy = 15 THEN lowy = 1
     IF iceB(1).d = 1 THEN
      smat(iceB(1).x, iceB(1).y) = 0
      LINE ((iceB(1).x - 1) * 14 + 1, (iceB(1).y - 1) * 14 + 1)-((iceB(1).x) * 14, (iceB(1).y) * 14), 0, BF
      iceB(1).d = 0
     END IF
     IF smat(penP.x, lowy) = 8 THEN
      smat(penP.x, lowy) = 9
      PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
      iceB(1).x = penP.x
      iceB(1).y = lowy
      iceB(1).d = 1
     END IF
     IF smat(penP.x, lowy) = 4 THEN
      smat(penP.x, lowy) = 8
      PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
     END IF
    END IF
   END IF

  CASE " "
   'FOR x = 1200 TO 200 STEP -200
   ' SOUND x, 1
   'NEXT x
   GOTO LevelStart
 END SELECT

 lowy = penP.y + 1
 IF lowy = 15 THEN lowy = 1
 IF smat(penP.x, lowy) = 0 THEN
  IF eggP.x = penP.x AND eggP.y = lowy THEN
   leftx = eggP.x - 1
   IF leftx = 0 THEN leftx = 22
   rightx = eggP.x + 1
   IF rightx = 23 THEN rightx = 1
   IF smat(leftx, eggP.y) = 0 AND smat(rightx, eggP.y) > 0 THEN
    LINE ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1)-((eggP.x) * 14, (eggP.y) * 14), 0, BF
    eggP.x = leftx
    PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), egg, PSET
    LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
    penP.y = eggP.y
    PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penL, PSET
   ELSEIF smat(rightx, eggP.y) = 0 AND smat(leftx, eggP.y) > 0 THEN
    LINE ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1)-((eggP.x) * 14, (eggP.y) * 14), 0, BF
    eggP.x = rightx
    PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), egg, PSET
    LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
    penP.y = eggP.y
    PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penR, PSET
   END IF
  ELSEIF iglooP.x = penP.x AND iglooP.y = lowy THEN
  ELSE
   LINE ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1)-((penP.x) * 14, (penP.y) * 14), 0, BF
   penP.y = lowy
   PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penR, PSET
   SOUND (15 - penP.y) * 100, 1
  END IF
  lowy = penP.y + 1
  IF lowy = 15 THEN lowy = 1
  IF iceB(1).d = 1 THEN
   smat(iceB(1).x, iceB(1).y) = 0
   LINE ((iceB(1).x - 1) * 14 + 1, (iceB(1).y - 1) * 14 + 1)-((iceB(1).x) * 14, (iceB(1).y) * 14), 0, BF
   iceB(1).d = 0
   SOUND 40, 1
  END IF
  IF smat(penP.x, lowy) = 8 THEN
   smat(penP.x, lowy) = 9
   PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
   iceB(1).x = penP.x
   iceB(1).y = lowy
   iceB(1).d = 1
   SOUND 1000, .5
  END IF
  IF smat(penP.x, lowy) = 4 THEN
   smat(penP.x, lowy) = 8
   PUT ((penP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
   SOUND 1000, .5
  END IF
 END IF

 lowy = eggP.y + 1
 IF lowy = 15 THEN lowy = 1
 IF smat(eggP.x, lowy) = 0 THEN
  LINE ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1)-((eggP.x) * 14, (eggP.y) * 14), 0, BF
  SOUND (15 - eggP.y) * 100, 1
  FOR bnum# = 1 TO maxbad
   IF bad(bnum#).x = eggP.x AND bad(bnum#).y = lowy THEN
    bad(bnum#).x = 0
    PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), eggS, PSET
    SOUND 40, 2
    FOR z = 1 TO cpuspeed * 2
    NEXT z
   END IF
  NEXT bnum#
  eggP.y = lowy
  PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), egg, PSET
  eggP.d = eggP.d + 1
  lowy = eggP.y + 1
  IF lowy = 15 THEN lowy = 1
  IF iceB(1).d = 1 THEN
   smat(iceB(1).x, iceB(1).y) = 0
   LINE ((iceB(1).x - 1) * 14 + 1, (iceB(1).y - 1) * 14 + 1)-((iceB(1).x) * 14, (iceB(1).y) * 14), 0, BF
   iceB(1).d = 0
   SOUND 40, 1
  END IF
  IF smat(eggP.x, lowy) = 8 THEN
   smat(eggP.x, lowy) = 9
   PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice3, PSET
   iceB(1).x = eggP.x
   iceB(1).y = lowy
   iceB(1).d = 1
   SOUND 1000, .5
  END IF
  IF smat(eggP.x, lowy) = 4 THEN
   smat(eggP.x, lowy) = 8
   PUT ((eggP.x - 1) * 14 + 1, (lowy - 1) * 14 + 1), ice2, PSET
   SOUND 1000, .5
  END IF
 ELSE
  IF eggP.d > maxeggfall THEN
   LINE ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1)-((eggP.x) * 14, (eggP.y) * 14), 0, BF
   PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), eggB, PSET
   SOUND 200, 1
   IF lives = 0 THEN
    gameover
    EXIT SUB
   END IF
   dead
   GOTO LevelStart
  END IF
  eggP.d = 0
 END IF

 FOR bnum# = 1 TO maxbad
  IF bad(bnum#).x > 0 THEN
   newx = bad(bnum#).x + bad(bnum#).d
   IF newx = 23 THEN newx = 1
   IF newx = 0 THEN newx = 22
   lowy = bad(bnum#).y + 1
   IF lowy = 15 THEN lowy = 1
   IF smat(newx, bad(bnum#).y) = 0 AND smat(newx, lowy) > 0 THEN
    IF eggP.y = bad(bnum#).y AND eggP.x = newx THEN
     PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), eggB, PSET
     SOUND 200, 1
     IF lives = 0 THEN
      gameover
      EXIT SUB
     END IF
     dead
     GOTO LevelStart
    ELSEIF penP.y = bad(bnum#).y AND penP.x = newx THEN
     PUT ((penP.x - 1) * 14 + 1, (penP.y - 1) * 14 + 1), penD, PSET
     SOUND 200, 1
     IF lives = 0 THEN
      gameover
      EXIT SUB
     END IF
     dead
     GOTO LevelStart
    ELSE
     LINE ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1)-((bad(bnum#).x) * 14, (bad(bnum#).y) * 14), 0, BF
     bad(bnum#).x = newx
     IF bad(bnum#).d = 1 THEN
      PUT ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1), bearR, PSET
     ELSE
      PUT ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1), bearL, PSET
     END IF
     'SOUND 40, .7
    END IF
   ELSE
    bad(bnum#).d = -bad(bnum#).d
    LINE ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1)-((bad(bnum#).x) * 14, (bad(bnum#).y) * 14), 0, BF
    IF bad(bnum#).d = 1 THEN
     PUT ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1), bearR, PSET
    ELSE
     PUT ((bad(bnum#).x - 1) * 14 + 1, (bad(bnum#).y - 1) * 14 + 1), bearL, PSET
    END IF
   END IF
  END IF
 NEXT bnum#

 IF eggP.x = iglooP.x AND eggP.y = iglooP.y THEN
  PUT ((eggP.x - 1) * 14 + 1, (eggP.y - 1) * 14 + 1), wigloo, PSET
  winlevel
  IF level = 1 THEN EXIT SUB
  GOTO LevelStart
 END IF

 FOR z = 1 TO cpuspeed
 NEXT z
LOOP
FOR x = 1200 TO 200 STEP -200
 SOUND x, 1
NEXT x
END SUB

SUB pause
DO UNTIL key$ = ""
 key$ = INKEY$
LOOP
DO UNTIL key$ = CHR$(13)
 key$ = INKEY$
 IF key$ = CHR$(27) THEN SYSTEM
LOOP
END SUB

SUB sprites (file$)
CLS
FOR x = 1 TO 255
 OUT &H3C8, x
 OUT &H3C9, 0
 OUT &H3C9, 0
 OUT &H3C9, 0
NEXT x
DEF SEG = &HA000
BLOAD file$, 0
DEF SEG
FOR x = 1 TO 14
 FOR y = 1 TO 14
  p = POINT(x, y)
  PSET (15 - x, y + 14), p
 NEXT y
NEXT x
FOR x = 113 TO 126
 FOR y = 1 TO 14
  p = POINT(x, y)
  PSET (239 - x, y + 14), p
 NEXT y
NEXT x
GET (1, 1)-(14, 14), penR
GET (1, 15)-(14, 28), penL
GET (15, 1)-(28, 14), egg
GET (29, 1)-(42, 14), eggB
GET (43, 1)-(56, 14), snow
GET (71, 1)-(84, 14), mound
GET (85, 1)-(98, 14), ice2
GET (57, 1)-(70, 14), ice1
GET (99, 1)-(112, 14), ice3
GET (113, 15)-(126, 28), bearR
GET (113, 1)-(126, 14), bearL
GET (127, 1)-(140, 14), igloo
GET (141, 1)-(154, 14), penD
GET (155, 1)-(168, 14), wigloo
GET (169, 1)-(182, 14), eggS
CLS
PALETTE
END SUB

SUB title
custom$ = "."
CLS
OPEN "title.pal" FOR BINARY AS #1
FOR i = 0 TO 256
 GET #1, , s
 a = ASC(s)
 GET #1, , s
 B = ASC(s)
 GET #1, , s
 c = ASC(s)
 OUT &H3C8, i
 OUT &H3C9, a
 OUT &H3C9, B
 OUT &H3C9, c
NEXT i
CLOSE #1
DEF SEG = &HA000
BLOAD "title.scr", 0
DEF SEG
PLAY "O1L10AABL5AL10ABA"
PLAY "O2L10DDEL5DL10DED"
pause
TitleTop:
CLS
OPEN "menu.pal" FOR BINARY AS #1
FOR i = 0 TO 256
 GET #1, , s
 a = ASC(s)
 GET #1, , s
 B = ASC(s)
 GET #1, , s
 c = ASC(s)
 OUT &H3C8, i
 OUT &H3C9, a
 OUT &H3C9, B
 OUT &H3C9, c
NEXT i
CLOSE #1
FOR x = 94 TO 90 STEP -1
 CIRCLE ((x - 7) / 3 - 9, (x - 7) / 3 - 9), x - 87, x
 PAINT ((x - 7) / 3 - 9, (x - 7) / 3 - 9), x
NEXT x
PSET (18, 18), 69
GET (13, 14)-(27, 26), ball
DEF SEG = &HA000
BLOAD "menu.scr", 0
DEF SEG
FOR x = 1 TO 5
 CIRCLE (110, 18 * x + 57), 8, 1
 CIRCLE (110, 18 * x + 57), 7, 0
 PAINT (110, 18 * x + 57), 0, 1
NEXT x
PUT (103, 69), ball
PLAY "P3"
snum = 0
x = 1
key$ = ""
DO UNTIL key$ = CHR$(13)
 key$ = INKEY$
 IF key$ = CHR$(0) + "H" THEN
  PAINT (110, 18 * x + 57), 0, 1
  x = x - 1
  IF x = 0 THEN x = 5
  PUT (103, 18 * x + 51), ball
  'SOUND 300, .7
 END IF
 IF key$ = CHR$(0) + "P" THEN
  PAINT (110, 18 * x + 57), 0, 1
  x = x + 1
  IF x = 6 THEN x = 1
  PUT (103, 18 * x + 51), ball
  'SOUND 300, .7
 END IF
 IF PLAY(0) = 0 THEN
  IF snds(snum).title = "END       " THEN snum = 0
  PLAY snds(snum).title
  snum = snum + 1
 END IF
LOOP
SOUND 500, 1
IF x = 1 THEN
 CLS
 PALETTE
 main
 GOTO TitleTop
END IF
IF x = 2 THEN
 CLS
 PALETTE
 font "CUSTOM LEVEL", 40, 20, 2, 2, 2, 40
 LOCATE 10, 10
 INPUT "File name: ", custom$
 IF INSTR(custom$, ".") = 0 THEN custom$ = custom$ + ".pen"
 main
 GOTO TitleTop
END IF
IF x = 3 THEN
 credits
 GOTO TitleTop
END IF
IF x = 4 THEN
 help
 GOTO TitleTop
END IF
IF x = 5 THEN
 CLS
 PALETTE
 SYSTEM
END IF
END SUB

SUB wingame
CLS
OPEN "penguin2.pal" FOR BINARY AS #1
FOR i = 0 TO 256
 GET #1, , s
 a = ASC(s)
 GET #1, , s
 B = ASC(s)
 GET #1, , s
 c = ASC(s)
 OUT &H3C8, i
 OUT &H3C9, a
 OUT &H3C9, B
 OUT &H3C9, c
NEXT i
CLOSE #1
DEF SEG = &HA000
BLOAD "penguin2.scr", 0
DEF SEG
PLAY "MFO2L1DL10DL1D-L10D-O1L1B"
PLAY "P5O1L9BL3BO2D-"
PLAY "O2L1DL10DL1D-L10D-O1L1B"
PLAY "P5O1L9BL3BO2D-"
PLAY "O2L1DL10DL1D-L10D-L1EL10EL1D#"
PLAY "P5O1L10BL7BP20O2L8D-O1L2B"
pause
END SUB

SUB winlevel
PLAY "P5"
LINE (25, 75)-(282, 100), 0, BF
LINE (25, 75)-(282, 100), 75, B
font "STAGE COMPLETE", 30, 80, 2, 2, 2, 40
PLAY "O3L15AAABP10AL5B"
pause
level = level + 1
IF custom$ <> "." THEN
 level = 1
 EXIT SUB
END IF
IF level > maxlevels THEN
 wingame
 level = 1
END IF
END SUB

