DECLARE SUB Finished ()
DECLARE FUNCTION GetFile$ (Ext$)
DECLARE SUB Help ()
DECLARE SUB TitleScreen ()
DECLARE SUB ImageIncorrect (ResX%, ResY%)
DECLARE SUB CheckSetup ()
DECLARE FUNCTION SongTime% ()
DECLARE SUB NextSong ()
DECLARE SUB CheckPuzzle ()
DECLARE FUNCTION Connection% (b%)
DECLARE SUB PutBlock (A%, b%)
DECLARE SUB MouseCheck (X%, Y%, b%)
DECLARE SUB RandomPieces ()
DECLARE SUB GetPieces ()
DECLARE SUB GifLoader (A$)
DECLARE SUB Load ()
DECLARE SUB StopMIDI ()
DECLARE SUB LoadAndPlayMidi (Filename$, MIDISegment%, MIDIOffset%)

'$DYNAMIC
'$INCLUDE: 'SVGALib\SVGA.BI'
CLS : SCREEN 12: DEFINT A-Z
DIM SHARED Piece1(0 TO 5104), Piece2(0 TO 5104), Piece3(0 TO 5104)
DIM SHARED Piece4(0 TO 5104), Piece5(0 TO 5104), Piece6(0 TO 5104)
DIM SHARED Piece7(0 TO 5104), Piece8(0 TO 5104)
DIM SHARED ResX, ResY, StartVideoMode, BlockPos(1 TO 9)
DIM SHARED Tim AS SINGLE, Song, PlaySound, Puzzle$

CLEAR
Start:
TitleScreen
Puzzle$ = GetFile$("Puzzles\*.gif")
Load
GifLoader "Puzzles\" + Puzzle$
GetPieces
RandomPieces
MouseEnter
MouseShow
DO: MouseStatus Mx, My, Buttons
MouseCheck Mx, My, Buttons
IF PlaySound = 1 AND TIMER >= Tim + SongTime THEN NextSong
LOOP WHILE INKEY$ = ""

StopMIDI
VideoModeSet StartVideoMode
CLEAR
END

103                             '*** didn't run setup first... ***
LOCATE 1, 1: PRINT "Please run SETUP.EXE first..."
LOCATE 2, 1: PRINT "Press any key to continue"
DO: LOOP WHILE INKEY$ = ""
StopMIDI
VideoModeSet StartVideoMode
END

IllegalPicture:
LOCATE 1, 1: PRINT "The filename you typed in, is illegal."
LOCATE 2, 1: PRINT "Press any key to end..."
DO: LOOP WHILE INKEY$ = ""
StopMIDI
VideoModeSet StartVideoMode
END

REM $STATIC
SUB CheckPuzzle
FOR A = 1 TO 8
        IF BlockPos(A) <> A THEN EXIT SUB
NEXT
Finished
END SUB

SUB CheckSetup
ON ERROR GOTO 103
CLOSE
OPEN "..\Sound.cfg" FOR INPUT AS 1
INPUT #1, PlaySound
CLOSE 1
END SUB

FUNCTION Connection (b)
FOR A = 1 TO 9
        IF BlockPos(A) = 0 THEN c = A: EXIT FOR
NEXT
SELECT CASE c
CASE 1: IF b = 2 OR b = 4 THEN Connection = -1
CASE 2: IF b = 1 OR b = 3 OR b = 5 THEN Connection = -1
CASE 3: IF b = 2 OR b = 6 THEN Connection = -1
CASE 4: IF b = 1 OR b = 5 OR b = 7 THEN Connection = -1
CASE 5: IF b = 2 OR b = 4 OR b = 6 OR b = 8 THEN Connection = -1
CASE 6: IF b = 3 OR b = 5 OR b = 9 THEN Connection = -1
CASE 7: IF b = 4 OR b = 8 THEN Connection = -1
CASE 8: IF b = 7 OR b = 9 OR b = 5 THEN Connection = -1
CASE 9: IF b = 8 OR b = 6 THEN Connection = -1
END SELECT
END FUNCTION

SUB Finished
A$ = "Congratulations! You've finished the puzzle! Press any key to continue..."
DrwString 1, 100, 0, A$, 0, 380
DO: LOOP WHILE INKEY$ = ""
StopMIDI
RUN
END
END SUB

FUNCTION GetFile$ (Ext$)
CLS : COLOR 7, 1

FILES Ext$
X = 1: Y = 2
DO
        Filename$ = ""
        FOR i = 0 TO 11
        Filename$ = Filename$ + CHR$(SCREEN(Y, X + i))
        NEXT i
        Filename$ = RTRIM$(Filename$)
        COLOR 7, 8: LOCATE Y, X
        PRINT Filename$

        DO
        Key$ = INKEY$
        LOOP UNTIL LEN(Key$)
        COLOR 7, 1: LOCATE Y, X
        PRINT Filename$
        SELECT CASE ASC(RIGHT$(Key$, 1))
        CASE 13, 27: EXIT DO
        CASE 72: Y = Y + (Y > 2)
        CASE 80: IF CHR$(SCREEN(Y + 1, X)) <> " " THEN Y = Y + 1
        CASE 75: X = X + 18 * (X > 1)
        CASE 77: X = X - 18 * (X < 54)
        END SELECT
LOOP
GetFile$ = Filename$
END FUNCTION

SUB GetPieces
DrwLine 1, 0, 100, 0, 100, 300
DrwLine 1, 0, 200, 0, 200, 300
DrwLine 1, 0, 300, 0, 300, 300
DrwLine 1, 0, 0, 100, 300, 100
DrwLine 1, 0, 0, 200, 300, 200
DrwLine 1, 0, 0, 300, 300, 300
BlkGet 0, 0, 99, 99, Piece1(0)
BlkGet 100, 0, 199, 99, Piece2(0)
BlkGet 200, 0, 299, 99, Piece3(0)
BlkGet 0, 100, 99, 199, Piece4(0)
BlkGet 100, 100, 199, 199, Piece5(0)
BlkGet 200, 100, 299, 199, Piece6(0)
BlkGet 0, 200, 99, 299, Piece7(0)
BlkGet 100, 200, 199, 299, Piece8(0)
END SUB

SUB GifLoader (A$)
DIM Prefix(4095), Suffix(4095), OutStack(4095), shiftout(8)
DIM Ybase AS LONG, powersof2(11) AS LONG, WorkCode AS LONG

ON ERROR GOTO IllegalPicture
FOR A = 0 TO 7: shiftout(8 - A) = 2 ^ A: NEXT A
FOR A = 0 TO 11: powersof2(A) = 2 ^ A: NEXT A

IF UCASE$(RIGHT$(A$, 4)) <> ".GIF" THEN A$ = A$ + ".GIF"
OPEN A$ FOR BINARY AS #1
A$ = "      ": GET #1, , A$
IF A$ <> "GIF87a" THEN PRINT "Not a GIF87a file.": END
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
NumColors = 2 ^ ((A AND 7) + 1): NoPalette = (A AND 128) = 0
GOSUB GetByte: Background = A
GOSUB GetByte: IF A <> 0 THEN PRINT "Bad screen descriptor.": END
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
DO
    GOSUB GetByte
    IF A = 44 THEN
        EXIT DO
    ELSEIF A <> 33 THEN
        PRINT "Unknown extension type.": END
    END IF
    GOSUB GetByte
    DO: GOSUB GetByte: A$ = SPACE$(A): GET #1, , A$: LOOP UNTIL A = 0
LOOP
GET #1, , Xstart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
IF XLength <> 300 OR YLength <> 300 THEN ImageIncorrect XLength, YLength
XEnd = Xstart + XLength: YEnd = YStart + YLength: GOSUB GetByte
IF A AND 128 THEN PRINT "Can't handle local colormaps.": END
Interlaced = A AND 64: PassNumber = 0: PassStep = 8
GOSUB GetByte
ClearCode = 2 ^ A
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = A + 1: CodeSize = StartCodeSize
StartMaxCode = 2 ^ (A + 1) - 1: MaxCode = StartMaxCode

BitsIn = 0: BlockSize = 0: BlockPointer = 1
X = Xstart: Y = YStart: Ybase = Y * 320&

DEF SEG = &HA000
IF NoPalette = 0 THEN
    OUT &H3C7, 0: OUT &H3C8, 0
    FOR A = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, A, 1)) \ 4: NEXT A
END IF
DrwLine 1, Background, 1, 1, ResX - 1, ResY - 1
DO
    GOSUB GetCode
    IF Code <> EOSCode THEN
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            GOSUB GetCode
            CurCode = Code: LastCode = Code: LastPixel = Code
            IF X < ResX THEN DrwPoint 1, LastPixel, X, Y
            X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0
            IF Code > NextCode THEN EXIT DO
            IF Code = NextCode THEN
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF

            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP

            LastPixel = CurCode
            IF X < ResX THEN DrwPoint 1, LastPixel, X, Y
            X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
            FOR A = StackPointer - 1 TO 0 STEP -1
                IF X < ResX THEN DrwPoint 1, OutStack(A), X, Y
                X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
            NEXT A

            IF NextCode < 4096 THEN
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                IF NextCode > MaxCode AND CodeSize < 12 THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL DoneFlag OR Code = EOSCode
EXIT SUB

GetByte: A$ = " ": GET #1, , A$: A = ASC(A$): RETURN

NextScanLine:
    IF Interlaced THEN
        Y = Y + PassStep
        IF Y >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: Y = 4: PassStep = 8
            CASE 2: Y = 2: PassStep = 4
            CASE 3: Y = 1: PassStep = 2
            END SELECT
        END IF
    ELSE
        Y = Y + 1
    END IF
    X = Xstart: Ybase = Y * 320&: DoneFlag = Y > ResY - 1
RETURN
GetCode:
    IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = A: BitsIn = 8
    WorkCode = LastChar \ shiftout(BitsIn)
    DO WHILE CodeSize > BitsIn
        GOSUB ReadBufferedByte: LastChar = A
        WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
    BitsIn = BitsIn - CodeSize
    Code = WorkCode AND MaxCode
RETURN
ReadBufferedByte:
    IF BlockPointer > BlockSize THEN
        GOSUB GetByte: BlockSize = A
        A$ = SPACE$(BlockSize): GET #1, , A$
        BlockPointer = 1
    END IF
    A = ASC(MID$(A$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN
END SUB

SUB Help
CLS : COLOR 10, 1
SHELL "Type ..\Readme.txt|more"
DO: LOOP WHILE INKEY$ = ""
CLS
END SUB

SUB ImageIncorrect (ResX, ResY)
VideoModeSet StartVideoMode
CLS
PRINT "The resolution of the image you tried to load is "; ResX; "*"; ResY
PRINT "It has to be 300 * 300."
PRINT "Press any key to end..."
DO: LOOP WHILE INKEY$ = ""
CLEAR
END
END SUB

SUB Load
CheckSetup
StartVideoMode = VIDEOMODEGET
VGA = WhichVGA: VideoMemory = WhichMEM
OK = RES640L: ResX = 640: ResY = 400
Mouse = WhichMOUSE
END SUB

SUB MouseCheck (X, Y, b)
IF X >= 320 AND X <= 620 AND Y >= 0 AND Y <= 300 AND b > 0 THEN
        SELECT CASE X
        CASE IS < 420: BX = 1: X1 = 320
        CASE IS < 520: BX = 2: X1 = 420
        CASE IS < 620: BX = 3: X1 = 520
        END SELECT
        SELECT CASE Y
        CASE IS < 100: BY = 0: Y1 = 0
        CASE IS < 200: BY = 1: Y1 = 100
        CASE IS < 300: BY = 2: Y1 = 200
        END SELECT
        b = BX + BY * 3
        A = Connection(b)
        IF NOT A THEN EXIT SUB
        MouseHide
        DrwFillBox 1, 0, X1, Y1, X1 + 99, Y1 + 99
        FOR A = 1 TO 9
                IF BlockPos(A) = 0 THEN PutBlock A, b: EXIT FOR
        NEXT
        BlockPos(b) = 0
END IF
CheckPuzzle
END SUB

SUB NextSong
IF Song = 0 THEN
        RANDOMIZE TIMER
        Song = RND * 6 + 1
END IF
Song = Song + 1
IF Song = 8 THEN Song = 1
DIM MIDI%(16000)
SELECT CASE Song
CASE 1: LoadAndPlayMidi "Sound\Play1.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
CASE 2: LoadAndPlayMidi "Sound\Play2.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
CASE 3: LoadAndPlayMidi "Sound\Play3.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
CASE 4: LoadAndPlayMidi "Sound\Play4.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
CASE 5: LoadAndPlayMidi "Sound\Play5.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
CASE 6: LoadAndPlayMidi "Sound\Play6.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
CASE 7: LoadAndPlayMidi "Sound\Play7.MID", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SELECT
Tim = TIMER
END SUB

SUB PutBlock (A, b)
SELECT CASE A
CASE 1: X = 320: Y = 0
CASE 2: X = 420: Y = 0
CASE 3: X = 520: Y = 0
CASE 4: X = 320: Y = 100
CASE 5: X = 420: Y = 100
CASE 6: X = 520: Y = 100
CASE 7: X = 320: Y = 200
CASE 8: X = 420: Y = 200
CASE 9: X = 520: Y = 200
END SELECT

IF BlockPos(b) = 1 THEN BlkPut 1, X, Y, Piece1(0): BlockPos(A) = 1
IF BlockPos(b) = 2 THEN BlkPut 1, X, Y, Piece2(0): BlockPos(A) = 2
IF BlockPos(b) = 3 THEN BlkPut 1, X, Y, Piece3(0): BlockPos(A) = 3
IF BlockPos(b) = 4 THEN BlkPut 1, X, Y, Piece4(0): BlockPos(A) = 4
IF BlockPos(b) = 5 THEN BlkPut 1, X, Y, Piece5(0): BlockPos(A) = 5
IF BlockPos(b) = 6 THEN BlkPut 1, X, Y, Piece6(0): BlockPos(A) = 6
IF BlockPos(b) = 7 THEN BlkPut 1, X, Y, Piece7(0): BlockPos(A) = 7
IF BlockPos(b) = 8 THEN BlkPut 1, X, Y, Piece8(0): BlockPos(A) = 8
MouseShow
END SUB

SUB RandomPieces
DIM Block(1 TO 8), X AS INTEGER, Y AS INTEGER
X = 220: c = 1
RANDOMIZE TIMER
RandomBlock:
FOR A = c TO 8
        Block(A) = RND * 7 + 1
        FOR b = 1 TO A - 1
                IF Block(A) = Block(b) THEN c = A: GOTO RandomBlock
        NEXT
GOSUB PutBlock
NEXT

PutBlock:
X = X + 100: IF X = 620 THEN X = 320: Y = Y + 100
IF Block(A) = 1 THEN BlkPut 1, X, Y, Piece1(0): BlockPos(A) = 1
IF Block(A) = 2 THEN BlkPut 1, X, Y, Piece2(0): BlockPos(A) = 2
IF Block(A) = 3 THEN BlkPut 1, X, Y, Piece3(0): BlockPos(A) = 3
IF Block(A) = 4 THEN BlkPut 1, X, Y, Piece4(0): BlockPos(A) = 4
IF Block(A) = 5 THEN BlkPut 1, X, Y, Piece5(0): BlockPos(A) = 5
IF Block(A) = 6 THEN BlkPut 1, X, Y, Piece6(0): BlockPos(A) = 6
IF Block(A) = 7 THEN BlkPut 1, X, Y, Piece7(0): BlockPos(A) = 7
IF Block(A) = 8 THEN BlkPut 1, X, Y, Piece8(0): BlockPos(A) = 8
IF A = 8 THEN EXIT SUB
RETURN
END SUB

FUNCTION SongTime
SELECT CASE Song
CASE 1: SongTime = 73
CASE 2: SongTime = 50
CASE 3: SongTime = 128
CASE 4: SongTime = 49
CASE 5: SongTime = 84
CASE 6: SongTime = 49
CASE 7: SongTime = 131
END SELECT
END FUNCTION

SUB TitleScreen
CLS : SCREEN 0
DIM Col(1 TO 3)
Col(1) = 10: Col(2) = 8: Col(3) = 8
TitleStart1:
LOCATE 1, 1: COLOR 1, 1: PRINT STRING$(2000, " ")
TitleStart:
LOCATE 11, 33: COLOR Col(1), 1: PRINT "Load a puzzle"
LOCATE 12, 33: COLOR Col(2), 1: PRINT "    Help    "
LOCATE 13, 33: COLOR Col(3), 1: PRINT "    Quit    "
DO: A$ = INKEY$
IF A$ <> "" THEN P = ASC(RIGHT$(A$, 1)): EXIT DO
LOOP UNTIL LEN(A$)
SELECT CASE P
CASE 13:
        IF Col(1) = 10 THEN EXIT SUB
        IF Col(2) = 10 THEN Help: GOTO TitleStart1
        IF Col(3) = 10 THEN END
CASE 27: END
CASE 72:
        IF Col(1) = 10 THEN Col(1) = 8: Col(3) = 10: GOTO TitleStart
        IF Col(2) = 10 THEN Col(2) = 8: Col(1) = 10: GOTO TitleStart
        IF Col(3) = 10 THEN Col(3) = 8: Col(2) = 10: GOTO TitleStart
CASE 80:
        IF Col(1) = 10 THEN Col(1) = 8: Col(2) = 10: GOTO TitleStart
        IF Col(2) = 10 THEN Col(2) = 8: Col(3) = 10: GOTO TitleStart
        IF Col(3) = 10 THEN Col(3) = 8: Col(1) = 10: GOTO TitleStart
CASE ELSE: GOTO TitleStart
END SELECT
END SUB

