'QMIDI v2.1
'QBasic/QuickBASIC background MIDI player
'by Jesse Dorland (jessedorland@hotmail.com)
'Released to the Public Domain, July 1997
'
'See SAMPLE.BAS for a QMIDI demo.
'
'Big thanks to Mike Huff, who wrote some QuickBASIC MIDI code from which
'QMIDI was adapted.
'
'For all of you who ever wanted to play MIDI files in the background using
'QBasic, here's everything you need.
'
'VERY IMPORTANT!!!  You really should read QMIDI.DOC before using these
'routines.  Section 5 is required reading if you've never used QMIDI
'before.  You will save yourself A LOT of potential trouble by reading the
'documentation.
'
'NOTE TO USERS OF QMIDI V1.0 AND 1.1:  Be sure to read the documentation
'thoroughly, as most of the routines in QMIDI v2.X have to be used
'differently than in previous versions.
'
'If you decide to use QMIDI, please tell me what you think of it and
'give me some ideas for improvements.  My e-mail address is at the top of
'the code and in the documentation.
'
'-Jesse
'
'DISCLAIMER
'----------
'If your computer suffers crashes, loss of data, or any other irregularities
'as a result of using QMIDI, I won't be responsible for it.  Reading the
'documentation should ensure safe operation, but I'm not making any
'guarantees.  You have been warned....

DECLARE FUNCTION BytesRequired& (Filename$)
DECLARE FUNCTION DriverLoaded% (DriverFN$)
DECLARE SUB LoadAndPlayLarge (Filename$)
DECLARE SUB LoadAndPlayMidi (Filename$, MIDISegment%, MIDIOffset%)
DECLARE SUB LoadLarge (Filename$)
DECLARE SUB LoadMIDI (Filename$, MIDISegment%, MIDIOffset%)
DECLARE FUNCTION MIDIError$ ()
DECLARE SUB PlayLarge ()
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB StopMIDI ()
DECLARE FUNCTION TimeMIDI! ()
'The following code is REQUIRED in programs that use QMIDI in order for
'all features to work properly.

DIM SHARED MIDI.PLAYTIME AS SINGLE
DIM SHARED MIDI.ERROR AS INTEGER
DIM SHARED MIDI.LOADED AS INTEGER
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
MIDI.LOADED = 0


'BytesRequired - Returns the amount of memory needed to store a file.
FUNCTION BytesRequired& (Filename$)
'Open the file.
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
'Store the length of the file.
FileLen& = LOF(FF%)
'Close the file.
CLOSE FF%
'If the length of the file is 0, assume it does not exist and delete it.
IF FileLen& = 0 THEN KILL Filename$
'Return the length of the file as the number of bytes required.
BytesRequired& = FileLen&
MIDI.ERROR = 0
END FUNCTION

'DriverLoaded - Primitive function to detect if sound driver is loaded
FUNCTION DriverLoaded% (DriverFN$)
'See if a filename for the SBMIDI driver has been supplied.
IF DriverFN$ <> "" THEN
	'If so, check to see if a file extension was supplied.
	IF INSTR(DriverFN$, ".") <> 0 THEN
		'If an extension was supplied, remove it.
		DriverFN$ = LEFT$(DriverFN$, LEN(DriverFN$) - 4)
	END IF
'If no filename was supplied, use the default
ELSE DriverFN$ = "SBMIDI"
END IF
'Call the MEM command with the /CLASSIFY option, and save the output
'to a temporary file.
SHELL "MEM /CLASSIFY > QMIDIMEM.TMP"

'Open the temporary file.
FF% = FREEFILE
OPEN "QMIDIMEM.TMP" FOR INPUT AS #FF%
'See if the file is valid.
LINE INPUT #1, A$: LINE INPUT #1, A$
LINE INPUT #1, B$: LINE INPUT #1, B$
'If not, exit now.
IF A$ <> "Modules using memory below 1 MB:" OR B$ <> "  Name           Total       =   Conventional   +   Upper Memory" THEN
	'Return an error
	DriverLoaded% = 2
	EXIT FUNCTION
END IF
'Otherwise, begin searching the file
DriverFound% = 0
LINE INPUT #1, A$
DO UNTIL EOF(FF%)
LINE INPUT #1, A$
IF A$ = "" THEN EXIT DO
IF RTRIM$(MID$(A$, 3, 8)) = UCASE$(DriverFN$) THEN DriverFound% = 1
LOOP
'Close the temporary file.
CLOSE #FF%
'Delete it.
KILL "QMIDIMEM.TMP"

'Return whether or not the drivers are loaded.
DriverLoaded% = DriverFound%
MIDI.ERROR = 0
END FUNCTION

SUB LoadAndPlayLarge (Filename$) STATIC
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(Filename$, 1) <> CHR$(0) THEN Filename$ = Filename$ + CHR$(0)
'Initialize the MIDI driver and load the file in memory
IF LoadCodeLoaded% = 0 THEN
	Lasm$ = ""
	Lasm$ = Lasm$ + CHR$(&H55)
	Lasm$ = Lasm$ + CHR$(&H89) + CHR$(&HE5)
	Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H7)
	Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H17)
	Lasm$ = Lasm$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H5)
	Lasm$ = Lasm$ + CHR$(&HCD) + CHR$(&H81)
	Lasm$ = Lasm$ + CHR$(&H5D)
	Lasm$ = Lasm$ + CHR$(&HCB)
	LoadCodeLoaded% = 1
END IF
DEF SEG = VARSEG(Lasm$)
Offset% = SADD(Lasm$)
CALL ABSOLUTE(SADD(Filename$), VARSEG(Filename$), Offset%)

'Start the music!!
IF PlayCodeLoaded% = 0 THEN
	Pasm$ = ""
	Pasm$ = Pasm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)
	Pasm$ = Pasm$ + CHR$(&HBA) + CHR$(&H1) + CHR$(&H0)
	Pasm$ = Pasm$ + CHR$(&HBB) + CHR$(&H1) + CHR$(&H5)
	Pasm$ = Pasm$ + CHR$(&HCD) + CHR$(&H81)
	Pasm$ = Pasm$ + CHR$(&HCB)
	PlayCodeLoaded% = 1
END IF
DEF SEG = VARSEG(Pasm$)
Offset% = SADD(Pasm$)
CALL ABSOLUTE(Offset%)
MIDI.ERROR = 0
MIDI.LOADED = 1
MIDI.PLAYTIME = TIMER
END SUB

'LoadAndPlayMIDI - Loads a MIDI file into memory and plays it
SUB LoadAndPlayMidi (Filename$, MIDISegment%, MIDIOffset%)
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)
'Check if the MIDI loading code has already been loaded;
'if not, do it now.
IF LoadCodeLoaded% = 0 THEN
	asm1$ = asm1$ + CHR$(&H1E)
	asm1$ = asm1$ + CHR$(&H55)
	asm1$ = asm1$ + CHR$(&H89) + CHR$(&HE5)
	asm1$ = asm1$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H17)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
	asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F)
	asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
	asm1$ = asm1$ + CHR$(&H89) + CHR$(&HC6)
	asm1$ = asm1$ + CHR$(&HB4) + CHR$(&H3F)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&HF)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H17)
	asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
	asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F)
	asm1$ = asm1$ + CHR$(&H89) + CHR$(&HF3)
	asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
	asm1$ = asm1$ + CHR$(&HB4) + CHR$(&H3E)
	asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
	asm1$ = asm1$ + CHR$(&H5D)
	asm1$ = asm1$ + CHR$(&H1F)
	asm1$ = asm1$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
	LoadCodeLoaded% = 1
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm1$)
CALL ABSOLUTE(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm1$))
MIDI.ERROR = 0
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF PlayCodeLoaded% = 0 THEN
	'Load the machine codes into a string.
	asm2$ = asm2$ + CHR$(&H55)
	asm2$ = asm2$ + CHR$(&H89) + CHR$(&HE5)
	asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H17)
	asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H7)
	asm2$ = asm2$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
	asm2$ = asm2$ + CHR$(&HCD) + CHR$(&H80)
	asm2$ = asm2$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
	asm2$ = asm2$ + CHR$(&HCD) + CHR$(&H80)
	asm2$ = asm2$ + CHR$(&H5D)
	asm2$ = asm2$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
	'Indicate that the code has been loaded.
	PlayCodeLoaded% = 1
END IF
'Call the machine language routine to play the music.
DEF SEG = VARSEG(asm2$)
CALL ABSOLUTE(MIDISegment%, MIDIOffset%, SADD(asm2$))
'Start the MIDI timer.
MIDI.PLAYTIME = TIMER
END SUB

SUB LoadLarge (Filename$) STATIC
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(Filename$, 1) <> CHR$(0) THEN Filename$ = Filename$ + CHR$(0)
'Initialize the MIDI driver and load the file in memory
IF CodeLoaded% = 0 THEN
	asm$ = ""
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H5)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H81)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&HCB)
	CodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(SADD(Filename$), VARSEG(Filename$), Offset%)
MIDI.ERROR = 0
MIDI.LOADED = 1
END SUB

'LoadMIDI - loads a MIDI file into memory
SUB LoadMIDI (Filename$, MIDISegment%, MIDIOffset%) STATIC
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)
'Check if the assembly language code has already been loaded;
'if not, do it now.
IF CodeLoaded% = 0 THEN
	asm$ = asm$ + CHR$(&H1E)
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
	asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
	asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&H1F)
	asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
	CodeLoaded% = 1
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
MIDI.ERROR = 0
END SUB

FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
	CASE 0: MIDIError$ = "NO ERROR"
	CASE 1: MIDIError$ = "FILE CONTAINS NO DATA"
	CASE 2: MIDIError$ = "FILE IS TOO LARGE"
	CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
	CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

SUB PlayLarge STATIC
'If no MIDI file is loaded, exit now
IF MIDI.LOADED = 0 THEN EXIT SUB
'Start the music!!
IF CodeLoaded% = 0 THEN
	asm$ = ""
	asm$ = asm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HBA) + CHR$(&H1) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H1) + CHR$(&H5)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H81)
	asm$ = asm$ + CHR$(&HCB)
	CodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
MIDI.PLAYTIME = TIMER
MIDI.ERROR = 0
MIDI.PLAYTIME = TIMER
END SUB

'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF CodeLoaded% = 0 THEN
	'Load the machine codes into a string.
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
	'Indicate that the code has been loaded.
	CodeLoaded% = 1
END IF
'Call the machine language routine to play the music.
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(MIDISegment%, MIDIOffset%, Offset%)
'Start the MIDI timer.
MIDI.PLAYTIME = TIMER
MIDI.ERROR = 0
END SUB

'StopMIDI - Stops playing MIDI file
SUB StopMIDI
'Stop the music!!
asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
asm$ = asm$ + CHR$(&HCB)
'These next commented lines are for using the converted code.
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is playing, carry out the timing routine
IF MIDI.PLAYTIME THEN
'Get the current time
CurrentTime! = TIMER
'If midnight has come since the MIDI file started playing, change
'CurrentTime! accordingly
IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
CurrentTime! = 86400 + CurrentTime!
END IF
'Get the final result
TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
MIDI.ERROR = 0
ELSE
MIDI.ERROR = 3
END IF
END FUNCTION

