'***************************************************
'* QMan V 0.3                   By: David Jennings *
'*                              A.K.A. Energy!     *
'* This is my first game I have every programmed,  *
'* which is good considering that I'm only 13.     *
'* I loved Pac - Man, and decided to make a QBasic *
'* version of the classic, seeing that no one has  *
'* done so yet.                                    *
'*      I'm short on cash, so if you can, please   *
'* send me a contribution to the address below.    *
'***************************************************
'*   1289 Quarry Road  *
'*  Danville,KY. 40422 *
'***************************************************
'*Thank you for playing QMan, and watch for V 1.0  *
'***************************************************

DECLARE SUB Instructions ()
DECLARE SUB CenterText (y, t$)
DECLARE SUB OutText (x, y, t$)
DECLARE SUB Delay (DelayTime)
DECLARE SUB GetPics ()
DECLARE SUB Logo ()
DECLARE SUB Intro ()
DECLARE SUB MainMenu ()
DECLARE SUB EndPage ()
DECLARE SUB LoadPal ()
DECLARE SUB LoadLevel ()
DECLARE SUB DrawLevel ()
DECLARE SUB MoveGhosts ()
DECLARE SUB GhostD (GhostNum)
DECLARE SUB PlayGame ()
DECLARE SUB Intstructions ()
DECLARE SUB PacD ()
DECLARE SUB PrintStats ()

COMMON SHARED Level, MaxLevel, Points, Pow, Score, Lives

TYPE Player
        x AS INTEGER
        y AS INTEGER
        Lives AS INTEGER
        ExtraLife AS INTEGER
        Dir AS INTEGER
        NextDir AS INTEGER
        Died AS INTEGER
        Score AS LONG
        Bonus AS INTEGER
        PowerB AS INTEGER
        Lx AS INTEGER
        Ly AS INTEGER
        Action AS INTEGER
END TYPE
TYPE Ghost
        x AS INTEGER
        y AS INTEGER
        Lx AS INTEGER
        Ly AS INTEGER
        Typ AS INTEGER
        Status AS INTEGER
        NextDir AS INTEGER
        Dir AS INTEGER
END TYPE
TYPE Object
        Status AS INTEGER
        x AS INTEGER
        y AS INTEGER
END TYPE

DIM SHARED Pacs&(8 * 500), Ghosts&(7 * 500), Goodies&(7 * 500)
DIM SHARED Ball(19, 19), POWERBALL(19 * 10, 19), Explode&(3 * 500)
DIM SHARED Lett&(38 * 200), Blank(19, 19), LevelL(10 * 16, 16)
DIM SHARED Wall(19, 19), Letters(30, 138)
DIM SHARED Player(1) AS Player, Ghost(4) AS Ghost
DIM SHARED Object(1) AS Object

CONST Inactive = 0, Moving = 1, None = 0, Up = 1, Down = 2
CONST Left = 3, Right = 4, BLL = 0, SBall = 1, WLL = 2
CONST BLNK = 3, GHST = 4, Pac = 5, False = 0, True = NOT False
CONST Normal = 1, Vuln = 2

Level = 1
MaxLevel = 7
SCREEN 13

GetPics
LoadPal
MainMenu
PlayGame

SUB CenterText (y, t$)
x = (320 - (LEN(t$) * 8)) / 2
OutText x, y, t$
END SUB

SUB Delay (DelayTime)
IF DelayTime = 0 THEN EXIT SUB
Start = TIMER
DO WHILE TIMER <= (Start + DelayTime): LOOP
END SUB

SUB DrawLevel
Gh = 1
FOR y = 1 TO 8
FOR x = 1 TO 14
SELECT CASE LevelL(x, y)
CASE WLL
        PUT (x * 19, y * 19), Wall, PSET
CASE BLL
        PUT (x * 19, y * 19), Ball, PSET
CASE SBall
        PUT (x * 19, y * 19), POWERBALL, PSET
CASE BLNK
        PUT (x * 19, y * 19), Blank, PSET
END SELECT
NEXT x, y
PUT (Player(1).x, Player(1).y), Pacs&(7 * 100), PSET
END SUB

SUB EndPage
SCREEN 0
PRINT "QMan V 1.0    By: David Jennings"
PRINT "Hopefully in Version 1.1, I'll  "
PRINT "have about 50 levels."
PRINT ""
PRINT ""
PRINT " I'm only 13, and a little short"
PRINT "on cash, so if you liked my     "
PRINT "product, please send a small    "
PRINT "contribution to the address below"
PRINT "---------------------------------"
PRINT "        1289 Quarry Road"
PRINT "       Danville,KY. 40422"
PRINT ""
PRINT "Thank you for Playing, and wait "
PRINT "for future games from Energy!"
END
END SUB

SUB GetPics
COLOR 56
FOR c = 1 TO 255
PALETTE c, 0
NEXT c
CLS : DEF SEG = &HA000
BLOAD "pacguys.pag", 0
FOR I = 1 TO 8: GET (I * 19 - 18, 1)-(I * 19, 19), Pacs&(I * 100): NEXT I
FOR I = 1 TO 7: GET (I * 19 - 18, 20)-(I * 19, 38), Ghosts&(I * 100): NEXT I
FOR I = 1 TO 7: GET (I * 19 - 18, 39)-(I * 19, 57), Goodies&(I * 100): NEXT I
GET (1, 58)-(19, 76), Ball
GET (20, 58)-(38, 76), POWERBALL
FOR I = 1 TO 3: GET (I * 19 - 18, 77)-(I * 19, 95), Explode&(I * 100): NEXT I
CLS
DEF SEG = &HA000
BLOAD "Shade.Fnt", 0
FOR I = 0 TO 38: GET (I * 8, 0)-((I * 8) + 7, 6), Lett&(I * 20): NEXT I
CLS
DEF SEG = &HA000
BLOAD "MainL.pgm", 0
GET (1, 1)-(138, 30), Letters
CLS
GET (1, 1)-(19, 19), Blank
PALETTE
END SUB

SUB GhostD (GhostNum)
IF GhostNum = 1 THEN GOTO Ghost1
IF GhostNum = 2 THEN GOTO Ghost2
IF GhostNum = 3 THEN GOTO Ghost3
IF GhostNum = 4 THEN GOTO Ghost4
Ghost1:
        PUT (Ghost(1).x, Ghost(1).y), Blank, PSET
        Ghost(1).x = 6 * 19
        Ghost(1).y = 4 * 19
        Ghost(1).Status = Normal
        GOTO Nxt
Ghost2:
        PUT (Ghost(2).x, Ghost(2).y), Blank, PSET
        Ghost(2).x = 7 * 19
        Ghost(2).y = 4 * 19
        Ghost(2).Status = Normal
        GOTO Nxt
Ghost3:
        PUT (Ghost(3).x, Ghost(3).y), Blank, PSET
        Ghost(3).x = 8 * 19
        Ghost(3).y = 4 * 19
        Ghost(3).Status = Normal
        GOTO Nxt
Ghost4:
        PUT (Ghost(4).x, Ghost(4).y), Blank, PSET
        Ghost(4).x = 9 * 19
        Ghost(4).y = 4 * 19
        Ghost(4).Status = Normal
        GOTO Nxt
Nxt:
Points = 200
Score = Score + Points
END SUB

SUB Instructions
CLS
CenterText 1, "QMAN VERSION 1.0"
CenterText 10, "BY DAVID JENNINGS"
CenterText 29, "THE INSTRUCTIONS ARE SIMPLE"
CenterText 40, "THE DIRECTIONS ARE"
CenterText 50, "THE DIRECTION KEYS"
CenterText 70, "ENTER USES A POWERBALL"
CenterText 80, "IF YOU HAVE ONE TO USE"
CenterText 100, "SINGLE COLORED GHOSTS KILL YOU"
CenterText 110, "MULTI COLORED GHOSTS GIVE POINTS"
CenterText 120, "WHEN EATEN. THEY CAN ONLY BE "
CenterText 130, "MULTI COLORED WHEN "
CenterText 130, "MULTI COLORED WHEN "
CenterText 140, "A POWERBALL IS USED"
CenterText 150, "ALL BALLS MUST BE EATEN "
CenterText 160, "TO GOTO NEXT LEVEL"
CenterText 180, "HAVE FUN!"
CenterText 190, "PRESS ANY KEY TO CONTINUE"
WHILE INKEY$ = "": WEND
CLS
CALL MainMenu
END SUB

SUB Intro
END SUB

SUB LoadLevel
IF MaxLevel < Level THEN CALL EndPage
FOR p = 1 TO 255
PALETTE p, 0
NEXT p
DEF SEG = &HA000: BLOAD "LEVEL" + LTRIM$(STR$(Level)) + ".PGM", 0
GET (1, 1)-(19, 19), Wall
Gh = 1
FOR y = 0 TO 9
FOR x = 0 TO 15
IF POINT(x, y) = 34 THEN PSET (x, y), 0
SELECT CASE POINT(x + 20, y + 1)
CASE 1
        LevelL(x, y) = WLL
CASE 12
        LevelL(x, y) = BLL
CASE 23
        LevelL(x, y) = SBall
CASE 0, 34
        LevelL(x, y) = BLNK
END SELECT
NEXT x, y
CLS
Delay 2
END SUB

SUB LoadPal
PALETTE 1, 65536 * 63: PALETTE 2, 65536 * 59: PALETTE 3, 65536 * 53
PALETTE 4, 65536 * 47: PALETTE 5, 65536 * 41: PALETTE 6, 65536 * 35
PALETTE 7, 65536 * 29: PALETTE 8, 65536 * 23: PALETTE 9, 65536 * 17
PALETTE 10, 65536 * 11: PALETTE 11, 65536 * 5
PALETTE 12, 65536 * 0 + 256 * 63: PALETTE 13, 65536 * 0 + 256 * 57
PALETTE 14, 65536 * 0 + 256 * 51: PALETTE 15, 65536 * 0 + 256 * 45
PALETTE 16, 65536 * 0 + 256 * 39: PALETTE 17, 65536 * 0 + 256 * 33
PALETTE 18, 65536 * 0 + 256 * 27: PALETTE 19, 65536 * 0 + 256 * 21
PALETTE 20, 65536 * 0 + 256 * 15: PALETTE 21, 65536 * 0 + 256 * 9
PALETTE 22, 65536 * 0 + 256 * 3: PALETTE 23, 65536 * 0 + 256 * 0 + 63
PALETTE 24, 65536 * 0 + 256 * 0 + 57: PALETTE 25, 65536 * 0 + 256 * 0 + 51
PALETTE 26, 65536 * 0 + 256 * 0 + 45: PALETTE 27, 65536 * 0 + 256 * 0 + 39
PALETTE 28, 65536 * 0 + 256 * 0 + 33: PALETTE 29, 65536 * 0 + 256 * 0 + 27
PALETTE 30, 65536 * 0 + 256 * 0 + 21: PALETTE 31, 65536 * 0 + 256 * 0 + 15
PALETTE 32, 65536 * 0 + 256 * 0 + 9: PALETTE 33, 65536 * 0 + 256 * 0 + 3
PALETTE 34, 65536 * 63 + 256 * 0 + 63: PALETTE 35, 65536 * 57 + 256 * 0 + 57
PALETTE 36, 65536 * 51 + 256 * 0 + 51: PALETTE 37, 65536 * 45 + 256 * 0 + 45
PALETTE 38, 65536 * 39 + 256 * 0 + 39: PALETTE 39, 65536 * 33 + 256 * 0 + 33
PALETTE 40, 65536 * 27 + 256 * 0 + 27: PALETTE 41, 65536 * 21 + 256 * 0 + 21
PALETTE 42, 65536 * 15 + 256 * 0 + 15: PALETTE 43, 65536 * 9 + 256 * 0 + 9
PALETTE 44, 65536 * 3 + 256 * 0 + 3: PALETTE 45, 65536 * 0 + 256 * 63 + 63
PALETTE 46, 65536 * 0 + 256 * 57 + 57: PALETTE 47, 65536 * 0 + 256 * 51 + 51
PALETTE 48, 65536 * 0 + 256 * 45 + 45: PALETTE 49, 65536 * 0 + 256 * 39 + 39
PALETTE 50, 65536 * 0 + 256 * 33 + 33: PALETTE 51, 65536 * 0 + 256 * 27 + 27
PALETTE 52, 65536 * 0 + 256 * 21 + 21: PALETTE 53, 65536 * 0 + 256 * 15 + 15
PALETTE 54, 65536 * 0 + 256 * 9 + 9: PALETTE 55, 65536 * 0 + 256 * 3 + 3
PALETTE 56, 65536 * 63 + 256 * 63 + 63: PALETTE 57, 65536 * 61 + 256 * 61 + 61
PALETTE 58, 65536 * 59 + 256 * 59 + 59: PALETTE 59, 65536 * 57 + 256 * 57 + 57
PALETTE 60, 65536 * 55 + 256 * 55 + 55: PALETTE 61, 65536 * 52 + 256 * 52 + 52
PALETTE 62, 65536 * 49 + 256 * 49 + 49: PALETTE 63, 65536 * 46 + 256 * 46 + 46
PALETTE 64, 65536 * 43 + 256 * 43 + 43: PALETTE 65, 65536 * 40 + 256 * 40 + 40
PALETTE 66, 65536 * 37 + 256 * 37 + 37: PALETTE 67, 65536 * 34 + 256 * 34 + 34
PALETTE 68, 65536 * 31 + 256 * 31 + 31: PALETTE 69, 65536 * 28 + 256 * 28 + 28
PALETTE 70, 65536 * 25 + 256 * 25 + 25: PALETTE 71, 65536 * 22 + 256 * 22 + 22
PALETTE 72, 65536 * 19 + 256 * 19 + 19: PALETTE 73, 65536 * 16 + 256 * 16 + 16
PALETTE 74, 65536 * 13 + 256 * 13 + 13: PALETTE 75, 65536 * 10 + 256 * 10 + 10
PALETTE 76, 65536 * 7 + 256 * 7 + 7: PALETTE 77, 65536 * 4 + 256 * 4 + 4
PALETTE 78, 65536 * 1 + 256 * 1 + 1: PALETTE 79, 65536 * 0 + 256 * 0 + 0
PALETTE 80, 65536 * 20 + 256 * 0 + 10: PALETTE 81, 65536 * 25 + 256 * 0 + 10
PALETTE 82, 65536 * 30 + 256 * 0 + 10: PALETTE 83, 65536 * 35 + 256 * 0 + 10
PALETTE 84, 65536 * 40 + 256 * 0 + 10: PALETTE 85, 65536 * 45 + 256 * 0 + 10
PALETTE 86, 65536 * 50 + 256 * 0 + 10: PALETTE 87, 65536 * 0 + 256 * 10 + 63
PALETTE 88, 65536 * 0 + 256 * 10 + 60: PALETTE 89, 65536 * 0 + 256 * 10 + 55
PALETTE 90, 65536 * 0 + 256 * 10 + 50: PALETTE 91, 65536 * 0 + 256 * 10 + 45
PALETTE 92, 65536 * 0 + 256 * 10 + 40: PALETTE 93, 65536 * 0 + 256 * 10 + 35
PALETTE 94, 65536 * 0 + 256 * 10 + 30: PALETTE 95, 65536 * 60 + 256 * 60 + 0
PALETTE 96, 65536 * 50 + 256 * 50 + 0: PALETTE 97, 65536 * 40 + 256 * 40 + 0
PALETTE 98, 65536 * 30 + 256 * 30 + 0: PALETTE 99, 65536 * 20 + 256 * 20 + 0
END SUB

SUB Logo
DEF SEG = &HA000
BLOAD "logo.pgm", 0
x = 20
1 FOR y = 1 TO 200
IF POINT(x, y) = 56 THEN PSET (x, y), 79
NEXT y
Delay 0
FOR y = 1 TO 200
IF POINT(x, y) = 79 THEN PSET (x, y), 56
NEXT y
x = x + 1
IF x < 281 THEN GOTO 1
x = 15
2 FOR y = 1 TO 100
IF POINT(x * 2, y) = 56 THEN PSET (x * 2, y), x - 14
NEXT y
x = x + .5
IF x < 281 THEN GOTO 2
END SUB

SUB MainMenu
CLS
PUT (91, 40), Letters, PSET
exc = 110: eyc = 130: et = 1
FOR I = 1 TO 7
PUT (I * 47 - 43, 1), Ghosts&(1 * 100)
NEXT I
FOR I = 1 TO 7
PUT (I * 47 - 43, 181), Ghosts&(1 * 100)
NEXT I
PUT (150, 80), Pacs&(7 * 100), PSET

CenterText 130, "START"
CenterText 140, "INSTRUCTIONS"
CenterText 150, "EXIT"
4 OutText 105, eyc, "!"
OutText 209, eyc, "!"
DO
        k$ = INKEY$
        IF k$ = CHR$(0) + CHR$(72) THEN
        OutText 105, eyc, " ": OutText 209, eyc, " "
        et = et - 1: GOTO 3
        END IF
        IF k$ = CHR$(0) + CHR$(80) THEN
        OutText 105, eyc, " ": OutText 209, eyc, " "
        et = et + 1: GOTO 3
        END IF
        IF k$ = CHR$(13) THEN GOTO 5
LOOP
3 IF et = 4 THEN et = 1: eyc = 130
IF et = 0 THEN et = 3: eyc = 150
IF et = 1 THEN eyc = 130: pc = 7
IF et = 2 THEN eyc = 140: pc = 6
IF et = 3 THEN eyc = 150: pc = 8
PUT (150, 80), Pacs&(pc * 100), PSET
GOTO 4
5 IF et = 1 THEN EXIT SUB
IF et = 2 THEN CALL Instructions
IF et = 3 THEN CALL EndPage
END SUB

SUB MoveGhosts
FOR c = 1 TO 4
        IF Ghost(c).x MOD 19 = 0 AND Ghost(c).x MOD 19 = 0 THEN
                IF Ghost(c).Dir = None AND Ghost(c).NextDir = None THEN
                        gd = INT((RND * 3) + 1)
                        gd2 = INT((RND * 3) + 1)
                        Ghost(c).Dir = gd
                        Ghost(c).NextDir = gd2
                END IF
        END IF
NEXT c
FOR c = 1 TO 4
        IF Ghost(c).x MOD 19 = 0 AND Ghost(c).y MOD 19 = 0 THEN
                Ghost(c).Lx = Ghost(c).x / 19
                Ghost(c).Ly = Ghost(c).y / 19
                Ghost(c).Dir = Ghost(c).NextDir
                Ghost(c).NextDir = None
        END IF
NEXT c
Slct:
SELECT CASE Ghost(1).Dir
        CASE Up
                IF LevelL(Ghost(1).Lx, Ghost(1).Ly - 1) = WLL THEN
                        Ghost(1).Dir = Left
                        GOTO Slct
                ELSE
                        Ghost(1).y = Ghost(1).y - 1
                END IF
        CASE Down
                IF LevelL(Ghost(1).Lx, Ghost(1).Ly + 1) = WLL THEN
                        Ghost(1).Dir = Right
                        GOTO Slct
                ELSE
                        Ghost(1).y = Ghost(1).y + 1
                END IF
        CASE Left
                IF LevelL(Ghost(1).Lx - 1, Ghost(1).Ly) = WLL THEN
                        Ghost(1).Dir = Down
                        GOTO Slct
                ELSE
                        Ghost(1).x = Ghost(1).x - 1
                END IF
        CASE Right
                IF LevelL(Ghost(1).Lx + 1, Ghost(1).Ly) = WLL THEN
                        Ghost(1).Dir = Up
                        GOTO Slct
                ELSE
                        Ghost(1).x = Ghost(1).x + 1
                END IF
        END SELECT
Slct2:
SELECT CASE Ghost(2).Dir
        CASE Up
                IF LevelL(Ghost(2).Lx, Ghost(2).Ly - 1) = WLL THEN
                        Ghost(2).Dir = Left
                        GOTO Slct2
                ELSE
                        Ghost(2).y = Ghost(2).y - 1
                END IF
        CASE Down
                IF LevelL(Ghost(2).Lx, Ghost(2).Ly + 1) = WLL THEN
                        Ghost(2).Dir = Right
                        GOTO Slct2
                ELSE
                        Ghost(2).y = Ghost(2).y + 1
                END IF
        CASE Left
                IF LevelL(Ghost(2).Lx - 1, Ghost(2).Ly) = WLL THEN
                        Ghost(2).Dir = Down
                        GOTO Slct2
                ELSE
                        Ghost(2).x = Ghost(2).x - 1
                END IF
        CASE Right
                IF LevelL(Ghost(2).Lx + 1, Ghost(2).Ly) = WLL THEN
                        Ghost(2).Dir = Up
                        GOTO Slct2
                ELSE
                        Ghost(2).x = Ghost(2).x + 1
                END IF
        END SELECT
Slct3:
SELECT CASE Ghost(3).Dir
        CASE Up
                IF LevelL(Ghost(3).Lx, Ghost(3).Ly - 1) = WLL THEN
                        Ghost(3).Dir = Down
                        GOTO Slct3
                ELSE
                        Ghost(3).y = Ghost(3).y - 1
                END IF
        CASE Down
                IF LevelL(Ghost(3).Lx, Ghost(3).Ly + 1) = WLL THEN
                        Ghost(3).Dir = Left
                        GOTO Slct3
                ELSE
                        Ghost(3).y = Ghost(3).y + 1
                END IF
        CASE Left
                IF LevelL(Ghost(3).Lx - 1, Ghost(3).Ly) = WLL THEN
                        Ghost(3).Dir = Right
                        GOTO Slct3
                ELSE
                        Ghost(3).x = Ghost(3).x - 1
                END IF
        CASE Right
                IF LevelL(Ghost(3).Lx + 1, Ghost(3).Ly) = WLL THEN
                        Ghost(3).Dir = Up
                        GOTO Slct3
                ELSE
                        Ghost(3).x = Ghost(3).x + 1
                END IF
        END SELECT
Slct4:
SELECT CASE Ghost(4).Dir
        CASE Up
                IF LevelL(Ghost(4).Lx, Ghost(4).Ly - 1) = WLL THEN
                        Ghost(4).Dir = Down
                        GOTO Slct4
                ELSE
                        Ghost(4).y = Ghost(4).y - 1
                END IF
        CASE Down
                IF LevelL(Ghost(4).Lx, Ghost(4).Ly + 1) = WLL THEN
                        Ghost(4).Dir = Left
                        GOTO Slct4
                ELSE
                        Ghost(4).y = Ghost(4).y + 1
                END IF
        CASE Left
                IF LevelL(Ghost(4).Lx - 1, Ghost(4).Ly) = WLL THEN
                        Ghost(4).Dir = Right
                        GOTO Slct4
                ELSE
                        Ghost(4).x = Ghost(4).x - 1
                END IF
        CASE Right
                IF LevelL(Ghost(4).Lx + 1, Ghost(4).Ly) = WLL THEN
                        Ghost(4).Dir = Up
                        GOTO Slct4
                ELSE
                        Ghost(4).x = Ghost(4).x + 1
                END IF
        END SELECT
FOR c = 1 TO 4
        IF Ghost(c).Status = Vuln THEN
                PUT (Ghost(c).x, Ghost(c).y), Ghosts&(7 * 100), PSET
        ELSE
                PUT (Ghost(c).x, Ghost(c).y), Ghosts&(Ghost(c).Typ * 100), PSET
        END IF
NEXT c
    FOR c = 1 TO 4
      IF Ghost(c).x > Player(1).x - 16 AND Ghost(c).x < Player(1).x + 16 THEN
        IF Ghost(c).y > Player(1).y - 16 AND Ghost(c).y < Player(1).y + 16 THEN
                IF Ghost(c).Status = Vuln THEN
                        GhostD c
                ELSE
                        PacD
                END IF
        END IF
      END IF
    NEXT c
END SUB

SUB OutText (x, y, t$)
FOR I = 1 TO LEN(t$)
  Tcode = ASC(MID$(t$, I, 1))
SELECT CASE Tcode
CASE 65 TO 90: Ch = Tcode - 65
CASE 33: Ch = 26
CASE 46: Ch = 27
CASE 49 TO 57: Ch = Tcode - 20
CASE 48: Ch = 28
CASE 32: Ch = 38
END SELECT
PUT (x, y), Lett&(Ch * 20), PSET
x = x + 8
NEXT I
END SUB

SUB PacD
PUT (Player(1).x, Player(1).y), Pacs&(8 * 100), PSET
Delay .3
PUT (Player(1).x, Player(1).y), Explode&(1 * 100), PSET
Delay .1
PUT (Player(1).x, Player(1).y), Explode&(2 * 100), PSET
Delay .1
PUT (Player(1).x, Player(1).y), Explode&(3 * 100), PSET
Delay .1
Lives = Lives - 1
CLS
PlayGame
END SUB

SUB PlayGame
IF Score > 0 THEN GOTO Skp
Score = 0
Lives = 3
Skp:
Player(1).Action = Moving
Player(1).Dir = Down
Player(1).NextDir = Up
Player(1).Lives = 3
Player(1).x = 19
Player(1).y = 38
Object(1).Status = False
ScoreNewLife = 50000
P1 = 1
P2 = 3
P3 = 5
P4 = 6
IF Lives < 0 THEN CALL EndPage
DO
        LoadLevel
        LoadPal
        DrawLevel
FOR c = 1 TO 4
        Ghost(c).Typ = c
        Ghost(c).x = (c + 5) * 19
        Ghost(c).y = 4 * 19
        Ghost(c).Dir = Up
        Ghost(c).NextDir = 0
        Ghost(c).Lx = (c + 5)
        Ghost(c).Ly = 4
        Ghost(c).Status = Normal
NEXT c
        PUT (Player(1).x, Player(1).y), Pacs&(6 * 100), PSET
        FOR x = 0 TO 15
                PUT (x * 19, 0), Wall, PSET
                PUT (x * 19, 9 * 19), Wall, PSET
        NEXT x
        FOR y = 0 TO 9
                PUT (0, y * 19), Wall, PSET
                PUT (15 * 19, y * 19), Wall, PSET
        NEXT y
        Delay 2
        DO
        FOR gx = 1 TO 15
        FOR r = 1 TO 19
        g = 0
        A$ = INKEY$: A$ = UCASE$(A$)
        LevelL(Player(1).Lx, Player(1).Ly) = BLNK
        SELECT CASE A$
        CASE CHR$(0) + CHR$(80)
                IF Player(1).Action <> 2 THEN
                        IF Player(1).NextDir = None THEN
                                IF Player(1).Action = Inactive THEN
                                        Player(1).Dir = Down: Player(1).NextDir = Down
                                        Player(1).Action = Moving
                                ELSE
                                        Player(1).NextDir = Down: Player(1).Action = Moving
                                END IF
                        END IF
                END IF
        CASE CHR$(0) + CHR$(72)
                IF Player(1).Action <> 2 THEN
                        IF Player(1).NextDir = None THEN
                                IF Player(1).Action = Inactive THEN
                                        Player(1).Dir = Up: Player(1).NextDir = Up
                                        Player(1).Action = Moving
                                ELSE
                                        Player(1).NextDir = Up: Player(1).Action = Moving
                                END IF
                        END IF
                END IF
        CASE CHR$(0) + CHR$(77)
                IF Player(1).Action <> 2 THEN
                        IF Player(1).NextDir = None THEN
                                IF Player(1).Action = Inactive THEN
                                        Player(1).Dir = Right: Player(1).NextDir = Right
                                        Player(1).Action = Moving
                                ELSE
                                        Player(1).NextDir = Right: Player(1).Action = Moving
                                END IF
                        END IF
                END IF
        CASE CHR$(0) + CHR$(75)
                IF Player(1).Action <> 2 THEN
                        IF Player(1).NextDir = None THEN
                                IF Player(1).Action = Inactive THEN
                                        Player(1).Dir = Left: Player(1).NextDir = Left
                                        Player(1).Action = Moving
                                ELSE
                                        Player(1).NextDir = Left: Player(1).Action = Moving
                                END IF
                        END IF
                END IF
        CASE "P"
        CASE CHR$(27)
        CASE CHR$(13)
        FOR c = 1 TO 4
        IF Pow > 0 THEN
                Sbdt = TIMER
                Ghost(c).Status = Vuln
                Pow = Pow - .25
        END IF
        NEXT c
END SELECT
SELECT CASE Player(1).Action
        CASE Moving
                SELECT CASE Player(1).Dir
                CASE Up
                IF LevelL(Player(1).Lx, Player(1).Ly - 1) = WLL THEN
                        Player(1).Action = Inactive
                        GOTO Leave
                END IF
                IF LevelL(Player(1).Lx, Player(1).Ly - 1) = SBall THEN
                        Pow = Pow + 1: Score = Score + 10
                        LevelL(Player(1).Lx, Player(1).Ly - 1) = BLNK
                END IF
                IF LevelL(Player(1).Lx, Player(1).Ly - 1) = BLL THEN
                        Score = Score + 10
                        LevelL(Player(1).Lx, Player(1).Ly - 1) = BLNK
                END IF
                IF LevelL(Player(1).Lx, Player(1).Ly - 1) <> WLL THEN
                        Player(1).y = Player(1).y - 1
                END IF
                CASE Down
                IF LevelL(Player(1).Lx, Player(1).Ly + 1) = WLL THEN
                        Player(1).Action = Inactive
                        GOTO Leave
                END IF
                IF LevelL(Player(1).Lx, Player(1).Ly + 1) = SBall THEN
                        Pow = Pow + 1: Score = Score + 10
                        LevelL(Player(1).Lx, Player(1).Ly + 1) = BLNK
                END IF
                IF LevelL(Player(1).Lx, Player(1).Ly + 1) = BLL THEN
                        Score = Score + 10
                        LevelL(Player(1).Lx, Player(1).Ly + 1) = BLNK
                END IF
                IF LevelL(Player(1).Lx, Player(1).Ly + 1) <> WLL THEN
                        Player(1).y = Player(1).y + 1
                END IF
                CASE Right
                IF LevelL(Player(1).Lx + 1, Player(1).Ly) = WLL THEN
                        Player(1).Action = Inactive
                        GOTO Leave
                END IF
                IF LevelL(Player(1).Lx + 1, Player(1).Ly) = SBall THEN
                        Pow = Pow + 1: Score = Score + 10
                        LevelL(Player(1).Lx + 1, Player(1).Ly) = BLNK
                END IF
                IF LevelL(Player(1).Lx + 1, Player(1).Ly) = BLL THEN
                        Score = Score + 10
                        LevelL(Player(1).Lx + 1, Player(1).Ly) = BLNK
                END IF
                IF LevelL(Player(1).Lx + 1, Player(1).Ly) <> WLL THEN
                        Player(1).x = Player(1).x + 1
                END IF
                CASE Left
                IF LevelL(Player(1).Lx - 1, Player(1).Ly) = WLL THEN
                        Player(1).Action = Inactive
                        GOTO Leave
                END IF
                IF LevelL(Player(1).Lx - 1, Player(1).Ly) = SBall THEN
                        Pow = Pow + 1: Score = Score + 10
                        LevelL(Player(1).Lx - 1, Player(1).Ly) = BLNK
                END IF
                IF LevelL(Player(1).Lx - 1, Player(1).Ly) = BLL THEN
                        Score = Score + 10
                        LevelL(Player(1).Lx - 1, Player(1).Ly) = BLNK
                END IF
                IF LevelL(Player(1).Lx - 1, Player(1).Ly) <> WLL THEN
                        Player(1).x = Player(1).x - 1
                END IF
                END SELECT
CASE Inactive
Leave:
END SELECT
IF Score > ScoreNewLife THEN
        Lives = Lives + 1
        ScoreNewLife = ScoreNewLife + 5000
END IF
FOR c = 1 TO 4
        IF Ghost(c).Status = Vuln THEN
                IF TIMER - Sbdt = 10 THEN
                        Ghost(c).Status = Normal
                        Points = 200
                END IF
        END IF
NEXT c
IF Player(1).x MOD 19 = 0 THEN
        IF Player(1).y MOD 19 = 0 THEN
                Player(1).Lx = Player(1).x / 19
                Player(1).Ly = Player(1).y / 19
                Player(1).Dir = Player(1).NextDir
                Player(1).NextDir = None
        END IF
END IF
IF Player(1).Dir = Right THEN
        PUT (Player(1).x, Player(1).y), Pacs&(P1 * 100), PSET
                Delay 0
        P1 = P1 + 1
END IF
IF P1 = 3 THEN P1 = 1
IF Player(1).Dir = Left THEN
        PUT (Player(1).x, Player(1).y), Pacs&(P2 * 100), PSET
                Delay 0
        P2 = P2 + 1
END IF
IF P2 = 5 THEN P2 = 3
IF Player(1).Dir = Up THEN
        PUT (Player(1).x, Player(1).y), Pacs&(P3 * 100), PSET
                Delay 0
        END IF
IF Player(1).Dir = Down THEN
        PUT (Player(1).x, Player(1).y), Pacs&(P4 * 100), PSET
                Delay 0
        P4 = P4 + 1
END IF
IF P4 = 8 THEN P4 = 6
MoveGhosts
LevelL(Player(1).Lx, Player(1).Ly) = Pac
FOR d = 0 TO 15
FOR dd = 0 TO 9
IF LevelL(d, dd) = BLL THEN g = g + 1
NEXT dd, d
IF g = 0 THEN Level = Level + 1: Delay 1: PlayGame
IF Object(1).Status = True THEN
        PUT (Object(1).x, Object(1).y), Goodies&(ot * 100), PSET
END IF
IF TIMER - stime > 15 THEN
        PUT (Object(1).x, Object(1).y), Blank, PSET
        Object(1).Status = False
END IF
IF Object(1).x > Player(1).x - 16 AND Object(1).x < Player(1).x + 16 THEN
        IF Object(1).y > Player(1).y - 16 AND Object(1).y < Player(1).y + 16 THEN
                IF Object(1).Status = True THEN
                        Pointss = ot * 100
                        Score = Score + Pointss
                        Object(1).Status = False
                END IF
        END IF
END IF
PrintStats
NEXT r
DrawLevel
NEXT gx
IF Object(1).Status = False THEN
        xo = INT((RND * 14) + 1)
        yo = INT((RND * 8) + 1)
        IF LevelL(xo, yo) = BLNK THEN
                stime = TIMER
                Object(1).x = xo * 19
                Object(1).y = yo * 19
                Object(1).Status = True
                ot = INT((RND * 6) + 1)
        END IF
END IF
LOOP
LOOP
END SUB

SUB PrintStats
COLOR 56
OutText 1, 0, "SCORE"
LOCATE 1, 6: PRINT Score
OutText 98, 0, "LIVES"
LOCATE 1, 19: PRINT Lives
OutText 168, 0, "LEVEL"
LOCATE 1, 27: PRINT Level
OutText 248, 0, "POW"
LOCATE 1, 36: PRINT Pow
END SUB

