DECLARE SUB doenemies (currentframe%)
DECLARE SUB dostatus ()
DECLARE SUB displaymap2 (x%, y%)
DEFINT A-Z
'$DYNAMIC
DECLARE SUB Start ()
DECLARE SUB FindShadow (x, y)
DECLARE SUB dosmoke ()
DECLARE SUB smokeline (x1%, y1%, x2%, y2%, col%)
DECLARE SUB addsmoke (x1%, y1%, x2%, y2%)
DECLARE SUB loadship (file$)
DECLARE SUB dobullets ()
DECLARE SUB fire ()
DECLARE SUB addbullet (x, y, dx, dy, kind)
DECLARE SUB fadein (arg%)
DECLARE SUB Init ()
DECLARE SUB displaymap (x, y%)
DECLARE SUB sprite (x%, y%, num%, arg%)
DECLARE SUB vCLS ()
DECLARE SUB vLINE (x1%, y1%, x2%, y2%, col%)
DECLARE SUB vBOX (x1%, y1%, x2%, y2%, col%)
DECLARE FUNCTION vscreeninit% (cmd$)
DECLARE SUB addsprite (sg%, lc%, xsize%, ysize%, n%)
DECLARE SUB transinit (cmd$)
DECLARE SUB palinit ()
DECLARE SUB changelimit (x1%, y1%, x2%, y2%)
DECLARE SUB doflames (modifier)
DECLARE FUNCTION nearcolr% (r, g, b)

CONST maptileoffset = 100
COMMON SHARED fh, vx, playerx, playery
COMMON SHARED shadowx, shadowy
COMMON SHARED xmin%, xmax%, ymin%, ymax%
COMMON SHARED vscreenseg%, vscreenloc%
COMMON SHARED flameseg, flameoff
COMMON SHARED numbays, my
COMMON SHARED shipx, shipy, flame1x, flame1y, flame2x, flame2y
COMMON SHARED err$

TYPE SpriteData
   Segment AS INTEGER
   Offset AS INTEGER
   xsize AS INTEGER
   ysize AS INTEGER
END TYPE
                       
TYPE projectiles
   x AS INTEGER
   y AS INTEGER
   dx AS INTEGER
   dy AS INTEGER
   kind AS INTEGER
   active AS INTEGER
END TYPE

TYPE guns
   x AS INTEGER
   y AS INTEGER
   kind AS INTEGER
   reload AS INTEGER
   reloadmax AS INTEGER
END TYPE

TYPE weapon
   reloadtime AS INTEGER
   damage AS INTEGER
   xspeed AS INTEGER
   yspeed AS INTEGER
END TYPE

TYPE lines
   colour AS INTEGER
   x1 AS INTEGER
   y1 AS INTEGER
   x2 AS INTEGER
   y2 AS INTEGER
END TYPE
          
TYPE groundbasedenemy
   active AS INTEGER
   x AS SINGLE
   y AS SINGLE
   xsize AS INTEGER
   ysize AS INTEGER
   hp AS INTEGER
   frames AS INTEGER
   cframe AS INTEGER
   firstframe AS INTEGER
   kind AS INTEGER
   movetype AS INTEGER
END TYPE

TYPE airenemy
   active AS INTEGER
   x AS SINGLE
   y AS SINGLE
   dx AS SINGLE
   dy AS SINGLE
   xsize AS INTEGER
   ysize AS INTEGER
   hp AS INTEGER
   frames AS INTEGER
   cframe AS INTEGER
   firstframe AS INTEGER
   kind AS INTEGER
   movetype AS INTEGER
END TYPE



ON ERROR GOTO phlegm

DIM SHARED vscreen(1 TO 19202) AS INTEGER
nsprites = vscreeninit%("n1000")

DIM SHARED Spriteinfo(nsprites) AS SpriteData
DIM SHARED tiles(1 TO 128, 120) AS DOUBLE
DIM SHARED laser1(1 TO 30)
DIM SHARED missile1(1 TO 46)
DIM SHARED smoketrail(250) AS lines
DIM SHARED map(9, 400)
DIM SHARED pal(255, 2), fixed(96), flame(450)
DIM SHARED kbcontrol(1024), kbmatrix(128)
DIM SHARED flametrans(14336)
DIM SHARED friendlyfire(100) AS projectiles
DIM SHARED bays(10) AS guns
DIM SHARED ship(512)
DIM SHARED weapongfx(400)
DIM SHARED weapons(5) AS weapon
DIM SHARED darken(255)
DIM SHARED lights(1 TO 50, 5)
DIM SHARED bayprev(1 TO 520)
DIM SHARED turret1(1 TO 40, 4) AS DOUBLE
DIM SHARED drone(1 TO 145) AS INTEGER
DIM SHARED enemies(20) AS groundbasedenemy
DIM SHARED aenemies(20) AS airenemy
DIM SHARED activegroundenemies(40) AS groundbasedenemy
DIM SHARED activeairenemies(40) AS airenemy

flameseg = VARSEG(flametrans(1))
flameoff = VARPTR(flametrans(1))

FOR lp = 0 TO 8
   READ bays(lp).x, bays(lp).y
NEXT

FOR lp = 0 TO 5
   READ weapons(lp).xspeed, weapons(lp).yspeed
   READ weapons(lp).reloadtime, weapons(lp).damage
NEXT
err$ = "Init Gfx"
Init
err$ = "Misc Setup"
CLS
DEF SEG = VARSEG(kbcontrol(0))
BLOAD "keyb.prg", 0
kbcontrol(128) = VARSEG(kbmatrix(0))
kbcontrol(129) = VARPTR(kbmatrix(0))
kbinit = 1

CALL ABSOLUTE(&H180)
FOR lp = 0 TO 128
   kbmatrix(lp) = 0
NEXT

playerx = 160
vx = 64
speed = 0
playery = 100

numbays = 8
bays(0).kind = 1
bays(1).kind = 8
bays(2).kind = 8
bays(3).kind = 1
bays(4).kind = 1
bays(5).kind = 5
bays(6).kind = 5
bays(7).kind = 3
bays(8).kind = 3
FOR lp = 0 TO 8
bays(lp).reloadmax = 1
NEXT
keytimer! = TIMER

OPEN "map.map" FOR BINARY ACCESS READ AS #1
FOR y = 0 TO 400
FOR x = 0 TO 9
map(x, y) = ASC(INPUT$(1, 1)) + maptileoffset
NEXT
NEXT
CLOSE

loadship "Scout.raw"

FOR lp = 0 TO 255
   OUT &H3C8, lp
   FOR l = 0 TO 2
      OUT &H3C9, 0
   NEXT
NEXT

OPEN "status.raw" FOR BINARY ACCESS READ AS #1
DEF SEG = &HA000
FOR y = 0 TO 199
   FOR x = 209 TO 304
      POKE y * 320 + x, ASC(INPUT$(1, 1))
   NEXT
NEXT
CLOSE
Start
'fadein 63

t! = TIMER
f = 0
speed = 2
rd = 1

craftdmg = 20
shields = 20

efile = FREEFILE
OPEN "map.enm" FOR INPUT AS efile

err$ = "End Of Startup"
DO
kbmatrix(128) = 0
f = f + 1

IF f MOD 2 = 1 THEN my = my + 1
IF f MOD 2 = 1 AND my MOD 32 = 0 THEN
   DO
      LINE INPUT #efile, wrk$
   LOOP UNTIL LEFT$(wrk$, 1) <> ";"
   IF VAL(wrk$) <> 0 THEN
   DO
      LINE INPUT #efile, wrk$
      SELECT CASE VAL(wrk$)
      CASE 1
         begin = gn
         DO
            gn = (gn + 1) MOD 40
         LOOP UNTIL activegroundenemies(gn).active = 0 OR gn = begin
            LINE INPUT #efile, nxt$
            activegroundenemies(gn).kind = VAL(nxt$) - 1
            LINE INPUT #efile, nxt$
            activegroundenemies(gn).x = VAL(nxt$)
            LINE INPUT #efile, nxt$
            activegroundenemies(gn).y = VAL(nxt$)
            LINE INPUT #efile, nxt$
            activegroundenemies(gn).movetype = VAL(nxt$)
            activegroundenemies(gn).active = 1
      CASE 2
         begin = an
         DO
            an = (an + 1) MOD 40
         LOOP UNTIL activeairenemies(gn).active = 0 OR an = begin
            LINE INPUT #efile, nxt$
            activeairenemies(an).kind = VAL(nxt$) - 1
            LINE INPUT #efile, nxt$
            activeairenemies(an).x = VAL(nxt$)
            LINE INPUT #efile, nxt$
            activeairenemies(an).y = VAL(nxt$)
            LINE INPUT #efile, nxt$
            activeairenemies(an).movetype = VAL(nxt$)
            activeairenemies(an).active = 1
      END SELECT
   LOOP UNTIL VAL(wrk$) = -1
   END IF
END IF


ox = playerx
playerx = playerx + (kbmatrix(&H4D) - kbmatrix(&H4B)) * speed
playery = playery + (kbmatrix(&H50) - kbmatrix(&H48)) * speed \ 2
IF playerx < 16 THEN playerx = 16 ELSE IF playerx > 304 THEN playerx = 304
IF playery > 168 THEN playery = 168 ELSE IF playery < 100 THEN playery = 100

FOR lp = 0 TO numbays
   bays(lp).reload = bays(lp).reload - 1
NEXT
IF kbmatrix(&H1D) THEN fire


IF TIMER - keytimer! >= .2 THEN
IF kbmatrix(&H2C) THEN rd = 1: keytimer! = TIMER: currentbay = currentbay - 1: IF currentbay < 0 THEN currentbay = numbays
IF kbmatrix(&H2D) THEN rd = 1: keytimer! = TIMER: currentbay = (currentbay + 1) MOD (numbays + 1)
IF kbmatrix(&H2E) THEN rd = 1: keytimer! = TIMER: bays(currentbay).kind = bays(currentbay).kind - 1: IF bays(currentbay).kind < 0 THEN bays(currentbay).kind = 0
IF kbmatrix(&H20) THEN rd = 1: keytimer! = TIMER: bays(currentbay).kind = bays(currentbay).kind + 1: IF bays(currentbay).kind > 8 THEN bays(currentbay).kind = 8
IF rd = 1 THEN
rd = 0
   LOCATE 23, 28
FOR lp = 0 TO numbays
   IF lp = currentbay THEN COLOR 10 ELSE COLOR 2
   PRINT LTRIM$(STR$(bays(lp).kind));
NEXT
COLOR 15
END IF
END IF

SELECT CASE playerx - vx
   CASE IS > 160: vx = vx + speed: IF vx > 128 THEN vx = 128
   CASE IS < 32: vx = vx - speed: IF vx < 0 THEN vx = 0
   CASE IS > 128: vx = vx + 1: IF vx > 128 THEN vx = 128
   CASE IS < 64: vx = vx - 1: IF vx < 0 THEN vx = 0
END SELECT

displaymap vx, my
doenemies f
FindShadow playerx - vx, playery: sprite shadowx - shipx, shadowy - shipy, 0, -5
dosmoke
dobullets
doflames 6 + (kbmatrix(&H50) * 2 - kbmatrix(&H48)) * 2

FOR lp = 0 TO 40
IF activeairenemies(lp).active THEN sprite activeairenemies(lp).x - vx, activeairenemies(lp).y \ 1, aenemies(activeairenemies(lp).kind).firstframe + activeairenemies(lp).cframe, 0
NEXT

sprite playerx - vx - shipx + flame1x, playery - shipy + flame1y, 300, -2
sprite playerx - vx - shipx + flame2x, playery - shipy + flame2y, 300, -3
sprite playerx - vx - shipx, playery - shipy, 0, 0
WAIT &H3DA, 8
PUT (16, 0), vscreen, PSET
dostatus
IF TIMER - t! > 1 THEN LOCATE 21, 31: PRINT FIX(f / (TIMER - t!) * 10) / 10
'CIRCLE (playerx - vx + 16, playery), 15, 10, , , .1
LOOP UNTIL kbmatrix(1)

phlegm:
DEF SEG = VARSEG(kbcontrol(0))
IF kbinit THEN CALL ABSOLUTE(&H1B0)
e = ERR
IF e <> 0 THEN SCREEN 0: PRINT err$: ERROR e
END

'Gun bay data (x,y)
DATA 0,-8
DATA 2,-5
DATA -2,-5
DATA 6,-4
DATA -6,-4
DATA 10,-2
DATA -10,-2
DATA 16,0
DATA -16,0

'Weapon data (dx,dy,reload,damage)

DATA 0,-8,4,1
DATA 0,-5,7,3
DATA 0,-10,5,10
DATA 1,5,30,40
DATA 0,3,10,35
DATA 2,-8,8,2

'laser 1

DATA 00,00,97,00,00
DATA 00,97,96,97,00
DATA 97,96,95,96,97
DATA 97,96,95,96,97
DATA 97,96,95,96,97
DATA 97,96,95,96,97
DATA 97,96,95,96,97
DATA 97,96,96,96,97
DATA 00,97,96,97,00
DATA 00,97,96,97,00
DATA 00,00,97,00,00
DATA 00,00,97,00,00

'missile

DATA 000,000,000,007,000,000,000
DATA 000,000,009,007,006,000,000
DATA 000,000,096,097,096,000,000
DATA 000,000,097,098,097,000,000
DATA 000,000,096,097,096,000,000
DATA 000,000,009,007,007,000,000
DATA 000,000,009,007,006,000,000
DATA 000,097,009,097,006,097,000
DATA 097,098,009,097,006,098,097
DATA 097,098,009,098,006,098,097
DATA 097,098,007,098,006,098,097
DATA 098,000,000,098,000,000,098
DATA 096,000,000,097,000,000,096


' single           2100
' dual             2800
' cannon           3600
' single missile   11200
' dual missile     14933
' plasma           16800
' beam             29400

REM $STATIC
SUB addbullet (x, y, dx, dy, kind) STATIC
begin = n
DO
   n = (n + 1) MOD 100
LOOP UNTIL friendlyfire(n).active = 0 OR n = begin
friendlyfire(n).x = x
friendlyfire(n).y = y
friendlyfire(n).dx = dx
friendlyfire(n).dy = dy
friendlyfire(n).kind = kind
friendlyfire(n).active = 1
END SUB

SUB addsmoke (x1, y1, x2, y2) STATIC
n = (n + 1) MOD 250
smoketrail(n).x1 = x1
smoketrail(n).y1 = y1
smoketrail(n).x2 = x2
smoketrail(n).y2 = y2
smoketrail(n).colour = 10
END SUB

SUB addsprite (sg, lc, xsize, ysize, n)
Spriteinfo(n).Segment = sg
Spriteinfo(n).Offset = lc
Spriteinfo(n).xsize = xsize - 1
Spriteinfo(n).ysize = ysize - 1
END SUB

SUB changelimit (x1%, y1%, x2%, y2%)
IF x1% > x2% THEN SWAP x1%, x2%
IF y1% > y2% THEN SWAP y1%, y2%
IF x1% < 0 THEN x1% = 0
IF x2% > 319 THEN x2% = 319
IF y1% < 0 THEN y1% = 0
IF y2% > 199 THEN y2% = 199
xmin = x1: ymin = y1
xmax = x2: ymax = y2

END SUB

SUB displaymap (x, y) STATIC
miny = y \ 32
FOR yd = miny TO miny + 8
   FOR xd = 0 TO 9
      sprite xd * 32 - x, 199 + y MOD 32 - (yd - miny) * 32, map(xd, yd MOD 400), -1
   NEXT
NEXT
END SUB

SUB displaymap2 (x, y)
miny = y \ 32
FOR yd = miny TO miny + 8
   FOR xd = 0 TO 9
      sprite xd * 32 - x, 199 + y MOD 32 - (yd - miny) * 32, map(xd, yd MOD 20), -1
   NEXT
NEXT
END SUB

SUB dobullets
err$ = "Bullets"
FOR lp = 0 TO 100
   IF friendlyfire(lp).active = 1 AND friendlyfire(lp).kind = 3 THEN
      sx = friendlyfire(lp).x + friendlyfire(lp).dx - vx
      sy = friendlyfire(lp).y + friendlyfire(lp).dy
      FindShadow sx, sy
      sprite shadowx - 3, shadowy - 2, 302, -5
   END IF
NEXT

FOR lp = 0 TO 100
   IF friendlyfire(lp).active = -1 THEN friendlyfire(lp).active = 0
   IF friendlyfire(lp).active = 1 THEN
      ox = friendlyfire(lp).x
      oy = friendlyfire(lp).y

      friendlyfire(lp).x = friendlyfire(lp).x + friendlyfire(lp).dx
      friendlyfire(lp).y = friendlyfire(lp).y + friendlyfire(lp).dy
      IF friendlyfire(lp).y < 0 THEN friendlyfire(lp).active = 0: IF friendlyfire(lp).kind < 2 THEN GOTO skipbullet
      xlc = friendlyfire(lp).x - vx
      ylc = friendlyfire(lp).y
      DEF SEG = vscreenseg
     
      SELECT CASE friendlyfire(lp).kind

         CASE 0:
         IF xlc > 0 AND xlc < 191 THEN
            FOR lp2 = 0 TO 2
               nlc = xlc + (ylc + lp2) * 192 + vscreenloc
               nc = PEEK(nlc)
               DEF SEG = flameseg
               nc2 = PEEK(FIX(95 - lp2 * 20 - RND * 20) * 256 + nc + flameoff)
               DEF SEG = vscreenseg
               POKE nlc, nc2
            NEXT
         END IF
                 
         CASE 1:
         IF xlc > 0 AND xlc < 191 THEN
            FOR lp2 = 0 TO 2
               nlc = xlc + (ylc + lp2) * 192 + vscreenloc
               nc = PEEK(nlc)
               DEF SEG = flameseg
               nc2 = PEEK(FIX(95 - lp2 * 40 - RND * 40) * 256 + nc + flameoff)
               DEF SEG = vscreenseg
               POKE nlc, nc2
               POKE nlc + 191, nc2
               POKE nlc + 193, nc2
            NEXT
         END IF
                 
         CASE 2: sprite xlc - 2, ylc - 2, 301, -4

         CASE 3: sprite xlc - 3, ylc - 2, 302, 0
                 friendlyfire(lp).dy = friendlyfire(lp).dy - 1
                 addsmoke friendlyfire(lp).x, friendlyfire(lp).y + 6, ox, oy + 5
     
         CASE 4:
         friendlyfire(lp).x = ox
         friendlyfire(lp).y = oy
         FOR drw = 0 TO friendlyfire(lp).dy
            smokeline xlc + drw, friendlyfire(lp).y - 3, xlc + drw, 0, -drw - (3 - friendlyfire(lp).dy)
            smokeline xlc - drw, friendlyfire(lp).y - 3, xlc - drw, 0, -drw - (3 - friendlyfire(lp).dy)
         NEXT
         friendlyfire(lp).dy = friendlyfire(lp).dy - 1
         IF friendlyfire(lp).dy = -1 THEN friendlyfire(lp).active = 0
     
      END SELECT
   END IF
skipbullet:
NEXT
END SUB

SUB doenemies (currentframe)
err$ = "Enemies"
FOR lp = 0 TO 40
IF activegroundenemies(lp).active = 1 THEN
   SELECT CASE activegroundenemies(lp).movetype
      CASE 0
      IF currentframe MOD 2 = 1 THEN activegroundenemies(lp).y = activegroundenemies(lp).y + 1
      IF activegroundenemies(lp).y > 230 THEN activegroundenemies(lp).active = 0
   END SELECT
   IF currentframe MOD 3 = 1 THEN activegroundenemies(lp).cframe = (activegroundenemies(lp).cframe + 1) MOD enemies(activegroundenemies(lp).kind).frames
   sprite activegroundenemies(lp).x - vx, activegroundenemies(lp).y \ 1, enemies(activegroundenemies(lp).kind).firstframe + activegroundenemies(lp).cframe, 0
END IF
NEXT
FOR lp = 0 TO 40
IF activeairenemies(lp).active = 1 THEN
   SELECT CASE activeairenemies(lp).movetype
      CASE 0
      activeairenemies(lp).y = activeairenemies(lp).y + 1
      IF activeairenemies(lp).y > 230 THEN activeairenemies(lp).active = 0
   END SELECT
   'IF currentframe MOD 3 = 1 THEN activeairenemies(lp).cframe = (activeairenemies(lp).cframe + 1) MOD aenemies(activeairenemies(lp).kind).frames
   FindShadow activeairenemies(lp).x - vx, activeairenemies(lp).y + 0: sprite shadowx, shadowy, aenemies(activeairenemies(lp).kind).firstframe + activeairenemies(lp).cframe, -5
END IF
NEXT

END SUB

SUB doflames (modifier)
DEF SEG = VARSEG(flame(0)): varof = VARPTR(flame(0))
FOR x = 0 TO 7:  POKE x + varof, 0: NEXT
FOR x% = 0 TO 12: POKE FIX(RND * 8) + varof, 95: NEXT

FOR y% = fh TO 0 STEP -1
of% = y * 8 + varof
FOR x% = 1 TO 7
of% = of% + 1
tot% = PEEK(of%) + PEEK(of% + 1) + PEEK(of% + 8) + PEEK(of% - 1) + PEEK(of% - 8)
tot% = tot% \ 5 - modifier * RND * 1
IF tot% < 2 THEN POKE (of% + 8), 0 ELSE POKE (of% + 8), tot%
NEXT
NEXT

END SUB

SUB dosmoke
FOR lp = 0 TO 250
   IF smoketrail(lp).colour > 1 THEN
      smoketrail(lp).colour = smoketrail(lp).colour - 1
      smokeline smoketrail(lp).x1 - vx, smoketrail(lp).y1 + 0, smoketrail(lp).x2 - vx, smoketrail(lp).y2 + 0, smoketrail(lp).colour
   END IF
NEXT
END SUB

SUB dostatus
FOR lp = 0 TO 2

rld = bays(lp).reload
mrld = bays(lp).reloadmax

IF rld < 0 THEN rld = 0
num = (1 - rld / mrld) * 10
FOR lite = 1 TO 10
IF lite <= num THEN
PUT (253 + lite * 4, 5 + lp * 10), lights(1, 0), PSET
ELSE
PUT (253 + lite * 4, 5 + lp * 10), lights(1, 1), PSET
END IF
NEXT
NEXT


END SUB

SUB fadein (fade)
FOR lp = 0 TO 255
   OUT &H3C8, lp
   FOR l = 0 TO 2
      OUT &H3C9, pal(lp, l) * fade \ 63
   NEXT
NEXT
END SUB

SUB FindShadow (x, y)
shadowx = 96 - (96 - x) / 1.1
shadowy = 99 - (99 - y) / 1.1
END SUB

SUB fire
FOR baynum = 0 TO numbays
   IF bays(baynum).reload <= 0 AND bays(baynum).kind <> 0 THEN
      SELECT CASE bays(baynum).kind
         CASE 1 TO 5:
            addbullet playerx + bays(baynum).x, playery + bays(baynum).y, weapons(bays(baynum).kind - 1).xspeed * SGN(bays(baynum).x), weapons(bays(baynum).kind - 1).yspeed, bays(baynum).kind - 1
            bays(baynum).reload = weapons(bays(baynum).kind - 1).reloadtime
         CASE 6:
            addbullet playerx + bays(baynum).x - 1, playery + bays(baynum).y, weapons(0).xspeed * SGN(bays(baynum).x), weapons(0).yspeed, 0
            addbullet playerx + bays(baynum).x + 1, playery + bays(baynum).y, weapons(0).xspeed * SGN(bays(baynum).x), weapons(0).yspeed, 0
            bays(baynum).reload = weapons(0).reloadtime * 1.5
         CASE 7:
            addbullet playerx + bays(baynum).x, playery + bays(baynum).y, weapons(3).xspeed * SGN(bays(baynum).x), weapons(3).yspeed, 3
            addbullet playerx + bays(baynum).x + SGN(bays(baynum).x) * 2, playery + bays(baynum).y, weapons(3).xspeed * SGN(bays(baynum).x) * 2, weapons(3).yspeed * 1.5, 3
            bays(baynum).reload = weapons(3).reloadtime * 1.5
         CASE 8:
            FOR lp = -1 TO 1
            addbullet playerx + bays(baynum).x, playery + bays(baynum).y, weapons(5).xspeed * lp, weapons(5).yspeed, 0
            NEXT
            bays(baynum).reload = weapons(5).reloadtime
     
      END SELECT
      bays(baynum).reloadmax = bays(baynum).reload
   END IF
NEXT
END SUB

SUB Init
addsprite VARSEG(laser1(1)), VARPTR(laser1(1)), 5, 12, 301
addsprite VARSEG(missile1(1)), VARPTR(missile1(1)), 7, 13, 302
addsprite VARSEG(flame(8)), VARPTR(flame(8)), 8, 100, 300

FOR lp = 0 TO 120
   addsprite VARSEG(tiles(1, lp)), VARPTR(tiles(1, lp)), 32, 32, lp + maptileoffset
NEXT

DEF SEG = &HA000
OPEN "anims\takoff.col" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 255
   FOR n = 0 TO 2
      pal(lp, n) = ASC(INPUT$(1, 1))
   NEXT
NEXT
FOR lp = 0 TO 255
   OUT &H3C8, lp
   FOR l = 0 TO 2
      OUT &H3C9, 0
   NEXT
NEXT
CLOSE

FOR lp = 0 TO 29
f$ = STRING$(2 - LEN(LTRIM$(STR$(lp))), "0") + LTRIM$(STR$(lp))
file$ = "anims\takoff" + f$ + ".ani"
BLOAD file$, 0
NEXT

BLOAD "anims\takoff00.ani", 0

FOR lp = 0 TO 63
WAIT &H3DA, 8
fadein lp
WAIT &H3DA, 8, 8
NEXT

OPEN "tiles.til" FOR BINARY ACCESS READ AS #1
'PRINT "Loading Tiles"
LINE (1, 16)-(120, 23), 4, BF
FOR lp = 1 TO 120
LINE (lp, 16)-(lp, 23), 2
FOR x = 1 TO 128
   tiles(x, lp) = CVD(INPUT$(8, 1))
NEXT
NEXT
CLOSE #1

FOR lp = 0 TO 255
OUT &H3C7, lp
FOR l = 0 TO 2
pal(lp, l) = INP(&H3C9)
NEXT
NEXT

PRINT : PRINT : PRINT
'PRINT "Translucency data"

LINE (0, 48)-(107, 55), 4, BF
DEF SEG = flameseg
of = flameoff
OPEN "transluc.ent" FOR BINARY ACCESS READ AS #1
FOR lp = 1 TO 14336
   flametrans(lp) = CVI(INPUT$(2, 1))
   IF lp MOD 128 = 1 THEN LINE (lp \ 128, 48)-(lp \ 128, 55), 2
NEXT
FOR lp = 0 TO 255
darken(lp) = ASC(INPUT$(1, 1))
NEXT
CLOSE #1

DEF SEG = VARSEG(laser1(1))
of = VARPTR(laser1(1))
FOR lp = 0 TO 59
READ nextbyte
POKE lp + of, nextbyte
NEXT

DEF SEG = VARSEG(missile1(1))
of = VARPTR(missile1(1))
FOR lp = 0 TO 90
READ nextbyte
POKE lp + of, nextbyte
NEXT

DEF SEG = VARSEG(weapongfx(1))
of = VARPTR(weapongfx(1))
OPEN "weapons.raw" FOR BINARY ACCESS READ AS #1
CLOSE #1

OPEN "lights.raw" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 5
FOR y = 0 TO 8
FOR x = 0 TO 2
PSET (x, y), ASC(INPUT$(1, 1))
NEXT
NEXT
GET (0, 0)-(2, 8), lights(1, lp)
NEXT
CLOSE #1

OPEN "turret1.raw" FOR BINARY ACCESS READ AS #1
enemies(0).xsize = ASC(INPUT$(1, 1)) - 1
enemies(0).ysize = ASC(INPUT$(1, 1)) - 1
enemies(0).frames = ASC(INPUT$(1, 1)) - 1
enemies(0).hp = CVI(INPUT$(2, 1))
junk$ = INPUT$(enemies(0).xsize - 4, 1)
enemies(0).firstframe = 50
FOR lp = 0 TO enemies(0).frames
   DEF SEG = VARSEG(turret1(1, lp))
   of = VARPTR(turret1(1, lp))
   addsprite VARSEG(turret1(1, lp)), of, enemies(0).xsize + 1, enemies(0).ysize + 1, enemies(0).firstframe + lp
   FOR y = 0 TO enemies(0).ysize
      FOR x = 0 TO enemies(0).xsize
         POKE x + y * (enemies(0).xsize + 1) + of, ASC(INPUT$(1, 1))
      NEXT
   NEXT
NEXT
CLOSE #1

err$ = "Loading Drone"
OPEN "drone.raw" FOR BINARY ACCESS READ AS #1
aenemies(0).xsize = ASC(INPUT$(1, 1)) - 1
aenemies(0).ysize = ASC(INPUT$(1, 1)) - 1
aenemies(0).frames = ASC(INPUT$(1, 1)) - 1
aenemies(0).hp = CVI(INPUT$(2, 1))
junk$ = INPUT$(aenemies(0).xsize - 4, 1)
aenemies(0).firstframe = 55
FOR lp = 0 TO aenemies(0).frames
   DEF SEG = VARSEG(drone(1))
   of = VARPTR(drone(1))
  
   err$ = "Adding Drone Sprite"
   addsprite VARSEG(drone(1)), of, aenemies(0).xsize + 1, aenemies(0).ysize + 1, aenemies(0).firstframe + lp
   err$ = "Loading Drone GFX"
  
   FOR y = 0 TO aenemies(0).ysize
      FOR x = 0 TO aenemies(0).xsize
         POKE x + y * (aenemies(0).xsize + 1) + of, ASC(INPUT$(1, 1))
      NEXT
   NEXT
NEXT
CLOSE #1

DEF SEG = &HA000
FOR lp = 0 TO 29
at! = TIMER
f$ = STRING$(2 - LEN(LTRIM$(STR$(lp))), "0") + LTRIM$(STR$(lp))
file$ = "anims\takoff" + f$ + ".ani"
WAIT &H3DA, 8
BLOAD file$, 0
DO: LOOP UNTIL TIMER - at! >= .04
FOR d = 0 TO 3
WAIT &H3DA, 8: WAIT &H3DA, 8, 8
NEXT
NEXT

SLEEP 2

FOR lp = 127 TO 0 STEP -1
WAIT &H3DA, 8
fadein lp \ 2
WAIT &H3DA, 8, 8
NEXT


OPEN "m1.col" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 255
FOR l = 0 TO 2
pal(lp, l) = ASC(INPUT$(1, 1))
NEXT
NEXT
CLOSE

END SUB

SUB loadship (file$)
OPEN file$ FOR BINARY ACCESS READ AS #1
shipxsize = ASC(INPUT$(1, 1)) - 1
shipysize = ASC(INPUT$(1, 1)) - 1
numbays = ASC(INPUT$(1, 1)) - 1
shipx = ASC(INPUT$(1, 1))
shipy = ASC(INPUT$(1, 1))
flame1x = ASC(INPUT$(1, 1)) - 4
flame1y = ASC(INPUT$(1, 1))
flame2x = ASC(INPUT$(1, 1)) - 4
flame2y = ASC(INPUT$(1, 1))
junk$ = INPUT$(shipxsize - 8, 1)
addsprite VARSEG(ship(0)), VARPTR(ship(0)), shipxsize + 1, shipysize + 1, 0

DEF SEG = VARSEG(ship(0))
of = VARPTR(ship(0))

FOR y = 0 TO shipysize
   FOR x = 0 TO shipxsize
      POKE x + y * (shipxsize + 1) + of, ASC(INPUT$(1, 1))
   NEXT
NEXT
FOR lp = 0 TO numbays
bays(lp).x = ASC(INPUT$(1, 1)) - shipx
bays(lp).y = ASC(INPUT$(1, 1)) - shipy
NEXT
CLOSE #1

END SUB

FUNCTION nearcolr% (r, g, b)
dist = 30000
FOR t = 0 TO 255
   rd = pal(t, 0) - r
   rg = pal(t, 1) - g
   rb = pal(t, 2) - b
   ndist = rd * rd + rg * rg + rb * rb
       
   IF ndist < dist THEN
      dist = ndist
      ncol = t
      IF dist = 0 THEN GOTO foundnear
   END IF
NEXT
foundnear:
nearcolr% = ncol
END FUNCTION

SUB palinit
END SUB

SUB smokeline (x1, y1, x2, y2, col) STATIC
DEF SEG = vscreenseg
lc = vscreenloc
transloc = (108 - col) * 256 + flameoff
IF x1 = x2 THEN GOTO tvvline
IF y1 = y2 THEN GOTO thvline
IF (y1 < 0 AND y2 < 0) OR (y1 > 199 AND y2 > 199) THEN EXIT SUB
IF x1 > x2 THEN SWAP x1, x2: SWAP y1, y2
IF x2 < 0 OR x1 > 190 THEN EXIT SUB
gradient! = (y2 - y1) / (x2 - x1)
IF ABS(gradient!) <= 1 THEN
   intercept = -gradient! * x1 + y1
   IF x1 < 1 THEN x1 = 1
   IF x2 > 190 THEN x2 = 190
   FOR x = x1 TO x2
      y = gradient! * x + intercept
      IF y >= 0 AND y <= 199 THEN
         nlc = x + y * 192 + lc
         FOR n = -1 TO 1
            oc = PEEK(nlc + n)
            DEF SEG = flameseg
            nc = PEEK(transloc + oc)
            DEF SEG = vscreenseg
            POKE nlc + n, nc
         NEXT
      END IF
   NEXT
EXIT SUB
END IF

IF y1 > y2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (x2 - x1) / (y2 - y1)
intercept = -gradient! * y1 + x1
IF y1 < 0 THEN y1 = 0
IF y2 > 199 THEN y2 = 199
FOR y = y1 TO y2
   x = gradient! * y + intercept
   IF x >= 1 AND x <= 190 THEN
      nlc = x + y * 192 + lc
      FOR n = -1 TO 1
         oc = PEEK(nlc + n)
         DEF SEG = flameseg
         nc = PEEK(transloc + oc)
         DEF SEG = vscreenseg
         POKE nlc + n, nc
      NEXT
   END IF
NEXT
EXIT SUB

tvvline:
IF y1 > y2 THEN SWAP y1, y2
IF x1 < 0 OR x1 > 190 THEN EXIT SUB
IF y1 < 0 THEN y1 = 0
IF y2 > ymax THEN y2 = ymax
xof = x1 + lc
FOR y = y1 TO y2
   nlc = xof + y * 192
   FOR n = -1 TO 1
      oc = PEEK(nlc + n)
      DEF SEG = flameseg
      nc = PEEK(transloc + oc)
      DEF SEG = vscreenseg
      POKE nlc + n, nc
   NEXT
NEXT
EXIT SUB

thvline:
IF x1 > x2 THEN SWAP x1, x2
IF y1 < 0 OR y1 > ymax THEN EXIT SUB
IF x1 < 0 THEN x1 = 0
IF x2 > 190 THEN x2 = 190
yof = y1 * 192 + lc
FOR x = x1 TO x2
   nlc = x + yof
   FOR n = -1 TO 1
      oc = PEEK(nlc + n)
      DEF SEG = flameseg
      nc = PEEK(transloc + oc)
      DEF SEG = vscreenseg
      POKE nlc + n, nc
   NEXT
NEXT
EXIT SUB

END SUB

SUB sprite (x%, y%, num%, arg%)
Segment = Spriteinfo(num).Segment
Offset = Spriteinfo(num).Offset
xsize = Spriteinfo(num).xsize
ysize = Spriteinfo(num).ysize
IF x < xmin THEN x1 = xmin - x ELSE x1 = 0
IF y < ymin THEN y1 = ymin - y ELSE y1 = 0
IF x > xmax - xsize THEN x2 = xmax - x ELSE x2 = xsize
IF y > ymax - ysize THEN y2 = ymax - y ELSE y2 = ysize
loc2 = vscreenloc + x + y * 192 + x1
xs2 = xsize + 1
SELECT CASE arg
   CASE -1:
      FOR yo = y1 TO y2
         yo2 = yo * 192 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            DEF SEG = Segment
            ln = PEEK(off2)
            DEF SEG = vscreenseg
            POKE yo2, ln
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT
   CASE -2:
      DEF SEG = Segment
      FOR yo = y1 TO y2
         yo2 = yo * 192 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            ln = PEEK(off2)
            IF ln > 95 THEN ln = 95
            IF ln > 0 THEN
               DEF SEG = vscreenseg
               tc = PEEK(yo2)
               DEF SEG = flameseg
               ncol = PEEK(flameoff + ln * 256 + tc)
               DEF SEG = vscreenseg
               POKE yo2, ncol
               DEF SEG = Segment
            END IF
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT
   CASE -3:
      DEF SEG = Segment
      FOR yo = y1 TO y2
         yo2 = yo * 192 + loc2
         off2 = yo * xs2 + Offset + x1 + xsize
         FOR xo = x1 TO x2
            ln = PEEK(off2)
            IF ln > 95 THEN ln = 95
            IF ln > 0 THEN
               DEF SEG = vscreenseg
               tc = PEEK(yo2)
               DEF SEG = flameseg
               ncol = PEEK(flameoff + ln * 256 + tc)
               DEF SEG = vscreenseg
               POKE yo2, ncol
               DEF SEG = Segment
            END IF
            off2 = off2 - 1
            yo2 = yo2 + 1
         NEXT
      NEXT
   CASE -4:
      DEF SEG = Segment
      FOR yo = y1 TO y2
         yo2 = yo * 192 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            ln = PEEK(off2)
            IF ln > 0 THEN
               DEF SEG = vscreenseg
               tc = PEEK(yo2)
               DEF SEG = flameseg
               ncol = PEEK(flameoff + ln * 256 + tc)
               DEF SEG = vscreenseg
               POKE yo2, ncol
               DEF SEG = Segment
            END IF
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT
   CASE -5:
      DEF SEG = Segment
      FOR yo = y1 TO y2
         yo2 = yo * 192 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            ln = PEEK(off2)
            IF ln <> 0 THEN DEF SEG = vscreenseg: tc = PEEK(yo2): POKE yo2, darken(tc): DEF SEG = Segment
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT
  
   CASE ELSE:
      DEF SEG = Segment
      FOR yo = y1 TO y2
         yo2 = yo * 192 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            ln = PEEK(off2)
            IF ln <> arg THEN DEF SEG = vscreenseg: POKE yo2, ln: DEF SEG = Segment
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT

END SELECT
END SUB

SUB Start
sspeed = 30
fh = 99
FOR lp = 0 TO 100
   doflames -4
NEXT

FOR lp = 0 TO 2
FOR lite = 1 TO 10
PUT (253 + lite * 4, 5 + lp * 10), lights(1, 1), PSET
NEXT
NEXT
FOR lp = 0 TO 1
FOR lite = 1 TO 20
PUT (213 + lite * 4, 50 + lp * 24), lights(1, 3 + lp * 2), PSET
NEXT
NEXT

RANDOMIZE TIMER
yl = -1
DEF SEG = VARSEG(bayprev(1))
bseg = VARSEG(bayprev(1))
sof = VARPTR(bayprev(1)) + 4

t! = TIMER
f = 0

DO
kbmatrix(128) = 0
f = f + 1
fade = fade + 2: IF fade = 64 THEN fade = 63
IF fade <= 63 THEN fadein fade
IF sspeed > 1 AND f MOD 10 = 0 AND f > 150 THEN sspeed = sspeed - 1
IF f > 120 AND f MOD 2 = 0 THEN weapdisp = weapdisp + 1
SELECT CASE weapdisp
CASE 1 TO 40
FOR lp = 0 TO 2
FOR lite = 1 TO weapdisp \ 4
PUT (253 + lite * 4, 5 + lp * 10), lights(1, 0), PSET
NEXT
NEXT
FOR lite = 1 TO weapdisp \ 2
PUT (213 + lite * 4, 74), lights(1, 4), PSET
NEXT
CASE 41 TO 60
FOR lite = 1 TO weapdisp - 40
PUT (213 + lite * 4, 50), lights(1, 2), PSET
NEXT

END SELECT



DEF SEG = bseg

BLOAD "scoutb.bin", sof - 4
slc = sof
FOR y = 0 TO 31
   SELECT CASE y
   CASE 0 TO 15
      IF 15 - yl > y THEN d = 1
      IF 15 - yl = y THEN d = -1
      IF 15 - yl < y THEN d = 0
   CASE 16 TO 31
      IF 16 + yl < y THEN d = 1
      IF 16 + yl = y THEN d = -1
      IF 16 + yl > y THEN d = 0
   END SELECT
   FOR x = 0 TO 31
      oc = PEEK(slc)
      IF oc > 15 AND oc < 230 AND d = 1 THEN POKE slc, 16 + FIX(RND * 8)
      IF oc > 15 AND oc < 230 AND d = -1 THEN POKE slc, 23 - RND * 2
      slc = slc + 1
   NEXT
NEXT
PUT (216, 3), bayprev(1), PSET
IF f > 63 AND f MOD 2 = 0 THEN yl = yl + 1

my = my + sspeed

ox = playerx

FOR lp = 0 TO numbays
   bays(lp).reload = bays(lp).reload - 1
NEXT

md = 11 - sspeed \ 2: IF sspeed < 8 THEN playery = playery + 1

displaymap2 vx, my
FindShadow playerx - vx, playery: sprite shadowx - shipx, shadowy - shipy, 0, -5

IF TIMER - t! > 1 THEN LOCATE 21, 31: PRINT FIX(f / (TIMER - t!) * 10) / 10

doflames md
sprite playerx - vx - shipx + flame1x, playery - shipy + flame1y, 300, -2
sprite playerx - vx - shipx + flame2x, playery - shipy + flame2y, 300, -3
sprite playerx - vx - shipx, playery - shipy, 0, 0
IF sspeed < 4 THEN WAIT &H3DA, 8
PUT (16, 0), vscreen, PSET
'CIRCLE (playerx - vx + 16, playery), 15, 10, , , .1
LOOP UNTIL kbmatrix(1) OR sspeed = 1
addsprite VARSEG(flame(8)), VARPTR(flame(8)), 8, 26, 300: fh = 26
my = my MOD 640
END SUB

SUB transinit (cmd$)
END SUB

SUB vBOX (x1%, y1%, x2%, y2%, col%)
DEF SEG = vscreenseg%
IF x1% > x2% THEN SWAP x1%, x2%
IF y1% > y2% THEN SWAP y1%, y2%
IF x1% < xmin THEN x1% = xmin
IF x2% > xmax THEN x2% = xmax
IF y1% < ymin THEN y1% = ymin
IF y2% > ymax THEN y2% = ymax
FOR y% = y1% TO y2%
of% = y% * 320 + vscreenloc%
FOR x% = x1% TO x2%
POKE of% + x%, col%
NEXT: NEXT
END SUB

DEFSNG A-Z
SUB vCLS
DEF SEG = vscreenseg%
FOR y% = 0 TO 199
of% = y% * 320 + vscreenloc%
FOR x% = 0 TO 319
POKE of% + x%, 0
NEXT: NEXT

END SUB

DEFINT A-Z
SUB vLINE (x1, y1, x2, y2, col) STATIC
DEF SEG = vscreenseg
IF x1 = x2 THEN GOTO vvline
IF y1 = y2 THEN GOTO hvline
IF (x1 < xmin AND x2 < xmin) OR (y1 < ymin AND y2 < xmin) OR (x1 > xmax AND x2 > xmax) OR (y1 > ymax AND y2 > ymax) THEN EXIT SUB
IF x1 > x2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (y2 - y1) / (x2 - x1)

IF ABS(gradient!) <= 1 THEN
   intercept = -gradient! * x1 + y1
   IF x1 < xmin THEN x1 = xmin
   IF x2 > xmax THEN x2 = xmax
   FOR x = x1 TO x2
      y = gradient! * x + intercept
      IF y >= ymin AND y <= ymax THEN POKE x + y * 320 + vscreenloc, col
   NEXT
EXIT SUB
END IF

IF y1 > y2 THEN SWAP x1, x2: SWAP y1, y2
gradient! = (x2 - x1) / (y2 - y1)
intercept = -gradient! * y1 + x1
IF y1 < ymin THEN y1 = ymin
IF y2 > ymax THEN y2 = ymax
FOR y = y1 TO y2
   x = gradient! * y + intercept
   IF x >= xmin AND x <= xmax THEN POKE x + y * 320 + vscreenloc, col
NEXT
EXIT SUB

vvline:
IF y1 > y2 THEN SWAP y1, y2
IF x1 < xmin OR x1 > xmax THEN EXIT SUB
IF y1 < ymin THEN y1 = ymin
IF y2 > ymax THEN y2 = ymax
xof = x1 + vscreenloc
FOR y = y1 TO y2
   POKE xof + y * 320, col
NEXT
EXIT SUB

hvline:
IF x1 > x2 THEN SWAP x1, x2
IF y1 < ymin OR y1 > ymax THEN EXIT SUB
IF x1 < xmin THEN x1 = xmin
IF x2 > xmax THEN x2 = xmax
yof = y1 * 320 + vscreenloc
FOR x = x1 TO x2
   POKE x + yof, col
NEXT
EXIT SUB
END SUB

FUNCTION vscreeninit% (cmd$)
cmd$ = UCASE$(cmd$)
IF INSTR(cmd$, "N") THEN vscreeninit% = VAL(MID$(cmd$, INSTR(cmd$, "N") + 1, 4)) ELSE vscreeninit = 2000
SCREEN 13
GET (0, 0)-(191, 199), vscreen
vscreenseg% = VARSEG(vscreen(3))
vscreenloc% = VARPTR(vscreen(3))
DEF SEG = vscreenseg%
xmin% = 0: xmax% = 191
ymin% = 0: ymax% = 199
IF INSTR(cmd$, "P") THEN palenable% = -1
IF INSTR(cmd$, "T") THEN transenable% = -1
END FUNCTION

