DECLARE SUB displaymap (x%, y%)
DECLARE SUB sprite (x%, y%, num%, arg%)
DECLARE FUNCTION vscreeninit% (cmd$)
DECLARE SUB addsprite (sg%, lc%, xsize%, ysize%, n%)
DECLARE FUNCTION nearcolr% (r%, g%, B%)
DEFINT A-Z
'$DYNAMIC

CONST maptileoffset = 100
COMMON SHARED fh, vx, playerx, playery
COMMON SHARED xmin%, xmax%, ymin%, ymax%
COMMON SHARED vscreenseg%, vscreenloc%
COMMON SHARED flameseg, flameoff
COMMON SHARED numbays, my

TYPE SpriteData
   Segment AS INTEGER
   Offset AS INTEGER
   xsize AS INTEGER
   ysize AS INTEGER
END TYPE

'ON ERROR GOTO phlegm

DIM SHARED vscreen(1 TO 32002) AS INTEGER
nsprites = vscreeninit%("n0200")

DIM SHARED Spriteinfo(nsprites) AS SpriteData
DIM SHARED tiles(0 TO 514, 120) AS INTEGER
DIM SHARED map(9, 400)
DIM SHARED groundmap(9, 400)
DIM SHARED pal(255, 2)


FOR lp = 0 TO 120
   GET (0, 0)-(31, 31), tiles(0, lp)
   addsprite VARSEG(tiles(2, lp)), VARPTR(tiles(2, lp)), 32, 32, lp
NEXT
OPEN "tiles.til" FOR BINARY ACCESS READ AS #1
PRINT "Loading Tiles"
LINE (1, 16)-(120, 23), 4, BF
FOR lp = 1 TO 120
LINE (lp, 16)-(lp, 23), 2
FOR x = 1 TO 512
   tiles(x + 1, lp) = CVI(INPUT$(2, 1))
NEXT
NEXT

FOR a = 0 TO 9
FOR B = 0 TO 400
map(a, B) = FIX(RND * 4) + 1
NEXT
NEXT

CLOSE #1

ymax = 167

OPEN "m1.col" FOR BINARY ACCESS READ AS #1
FOR lp = 0 TO 255
FOR n = 0 TO 2
pal(lp, n) = ASC(INPUT$(1, 1))
NEXT
NEXT
FOR lp = 0 TO 255
   OUT &H3C8, lp
   FOR l = 0 TO 2
      OUT &H3C9, pal(lp, l)
   NEXT
NEXT
CLOSE
CLS
ctile = 1
DO
LOCATE 1, 1: PRINT mx, my
LOCATE 1, 32: PRINT ctile
k$ = INKEY$
SELECT CASE LCASE$(k$)
CASE "+": ctile = (ctile + 1) MOD 121
CASE "-": ctile = ctile - 1: IF ctile < 0 THEN ctile = 120
CASE " ": map(mx, my) = ctile
CASE "8": my = my + 1: IF my > 400 THEN my = 400
CASE "5": my = my - 1: IF my < 0 THEN my = 0
CASE "4": mx = mx - 1: IF mx < 0 THEN mx = 0
CASE "6": mx = mx + 1: IF mx > 9 THEN mx = 9
CASE "s": GOSUB save
CASE "l": GOSUB load
END SELECT
PRINT my - (vy \ 32)
IF my - (vy \ 32) > 3 THEN vy = vy + 32
IF my - (vy \ 32) < 1 THEN vy = vy - 32
IF vy < 0 THEN vy = 0
displaymap 0, vy
PUT (287, 0), tiles(0, ctile), PSET
WAIT &H3DA, 8
PUT (0, 32), vscreen, PSET
LINE (mx * 32, 167 - (my - vy \ 32) * 32)-(mx * 32 + 31, 167 - (my - vy \ 32) * 32 + 31), RND * 256, B

LOOP UNTIL k$ = CHR$(27)

phlegm:
e = ERR
IF e <> 0 THEN SCREEN 0: ERROR e
END


save:
OPEN "map.map" FOR OUTPUT AS #1
FOR y = 0 TO 400
FOR x = 0 TO 9
PRINT #1, CHR$(map(x, y));
NEXT
NEXT
CLOSE
RETURN

load:
OPEN "map.map" FOR BINARY ACCESS READ AS #1
FOR y = 0 TO 400
FOR x = 0 TO 9
map(x, y) = ASC(INPUT$(1, 1))
NEXT
NEXT
CLOSE

RETURN

REM $STATIC
SUB addsprite (sg, lc, xsize, ysize, n)
Spriteinfo(n).Segment = sg
Spriteinfo(n).Offset = lc
Spriteinfo(n).xsize = xsize - 1
Spriteinfo(n).ysize = ysize - 1
END SUB

SUB changelimit (x1%, y1%, x2%, y2%)
IF x1% > x2% THEN SWAP x1%, x2%
IF y1% > y2% THEN SWAP y1%, y2%
IF x1% < 0 THEN x1% = 0
IF x2% > 319 THEN x2% = 319
IF y1% < 0 THEN y1% = 0
IF y2% > 199 THEN y2% = 199
xmin = x1: ymin = y1
xmax = x2: ymax = y2

END SUB

SUB displaymap (x, y) STATIC
miny = y \ 32
FOR yd = miny TO miny + 4
   FOR xd = 0 TO 9
      sprite xd * 32 - x, 135 + y MOD 32 - (yd - miny) * 32, map(xd, yd), -1
   NEXT
NEXT
END SUB

FUNCTION nearcolr% (r, g, B)
dist = 30000
FOR t = 0 TO 255
   rd = pal(t, 0) - r
   rg = pal(t, 1) - g
   rb = pal(t, 2) - B
   ndist = rd * rd + rg * rg + rb * rb
       
   IF ndist < dist THEN
      dist = ndist
      ncol = t
      IF dist = 0 THEN GOTO foundnear
   END IF
NEXT
foundnear:
nearcolr% = ncol
END FUNCTION

SUB sprite (x%, y%, num%, arg%)
Segment = Spriteinfo(num).Segment
Offset = Spriteinfo(num).Offset
xsize = Spriteinfo(num).xsize
ysize = Spriteinfo(num).ysize
IF x < xmin THEN x1 = xmin - x ELSE x1 = 0
IF y < ymin THEN y1 = ymin - y ELSE y1 = 0
IF x > xmax - xsize THEN x2 = xmax - x ELSE x2 = xsize
IF y > ymax - ysize THEN y2 = ymax - y ELSE y2 = ysize
loc2 = vscreenloc + x + y * 320 + x1
xs2 = xsize + 1
SELECT CASE arg
   CASE -1:
      FOR yo = y1 TO y2
         yo2 = yo * 320 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            DEF SEG = Segment
            ln = PEEK(off2)
            DEF SEG = vscreenseg
            POKE yo2, ln
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT
   CASE ELSE:
      DEF SEG = Segment
      FOR yo = y1 TO y2
         yo2 = yo * 320 + loc2
         off2 = yo * xs2 + Offset + x1
         FOR xo = x1 TO x2
            ln = PEEK(off2)
            IF ln <> arg THEN DEF SEG = vscreenseg: POKE yo2, ln: DEF SEG = Segment
            off2 = off2 + 1
            yo2 = yo2 + 1
         NEXT
      NEXT

END SELECT
END SUB

FUNCTION vscreeninit% (cmd$)
cmd$ = UCASE$(cmd$)
IF INSTR(cmd$, "N") THEN vscreeninit% = VAL(MID$(cmd$, INSTR(cmd$, "N") + 1, 4)) ELSE vscreeninit = 2000
SCREEN 13
GET (0, 32)-(319, 199), vscreen
vscreenseg% = VARSEG(vscreen(3))
vscreenloc% = VARPTR(vscreen(3))
DEF SEG = vscreenseg%
xmin% = 0: xmax% = 319
ymin% = 0: ymax% = 199
END FUNCTION

