'INVADERS.BAS
'Space Invaders
'vers 1.0
'created by Derek Andrews

'This is a clone of the game, Space Invaders, which was originally an
'arcade game in the late 1970's. The player uses the arrow keys to guide
'a small gunner across the bottom of the screen, firing at the Space Invaders
'above, until he has destroyed all of them.

'subs
DECLARE SUB ClearBuffer ()
DECLARE SUB Delay (Time!, Interval%)
DECLARE SUB DrawBase ()
DECLARE SUB DrawDefender ()
DECLARE SUB DrawEnemies ()
DECLARE SUB DrawLasers ()
DECLARE SUB DrawOverSeer ()
DECLARE SUB EnemyInc ()
DECLARE SUB FindLaserHits ()
DECLARE SUB InitPlay ()
DECLARE SUB InitProg ()
DECLARE SUB LoadBitmapData ()
DECLARE SUB PlayGame ()
DECLARE SUB RefreshBase ()
DECLARE SUB ResetScreen ()
DECLARE SUB ReviveEnemies ()
DECLARE SUB RunEnemyLasers ()
DECLARE SUB RunOverSeer ()
DECLARE SUB ShowHealth ()

'functions
DECLARE FUNCTION EnemyClearShot! (X!, Y!)
DECLARE FUNCTION HitKey ()
DECLARE FUNCTION NumEnemies! ()

'constants
CONST True% = 1
CONST False% = 0
CONST KeyLeft% = 75     'keyboard scancodes for the arrow keys
CONST KeyRight% = 77
CONST KeyUp% = 72
CONST KeyDown% = 80
CONST QuitKey% = 16
CONST NumSprites% = 16     'number of sprite bitmaps
CONST SpriteHeight% = 10   'height and width of each sprite bitmap
CONST SpriteWidth% = 16
CONST DefenderIndex% = 13  'first frame of the Defender
CONST BaseShieldIndex% = 14     'position of the base shield in Sprites()
CONST OverSeerIndex% = 15       'position of the Overseer in Sprites()
CONST OverSeerTime% = 15        'number of seconds before overseer appears
CONST OverSeerFrameTime% = 2    'number of seconds before overseer changes frames
CONST DefenderYcoord% = 180     'Y coordinate of Defender
CONST DefenderXcoord% = 155     'starting X coordinate of Defender
CONST BaseColor% = 3            'color of base
CONST NumEnemiesX% = 6          'number of enemies
CONST NumEnemiesY% = 6
CONST EnemyHit$ = "MLMBT255L64O1GFEDCBA"     'sound effects
CONST DefenderFire$ = "MLMBT255L64O3ABCABDA"
CONST EnemySquadMove$ = "MLMBT255L64O1BBAA"
CONST OverSeerAppear$ = "MLMBT255L64O2CBDGFDC"

TYPE LaserType
     X AS INTEGER
     Y AS INTEGER
     Alive AS INTEGER
END TYPE

TYPE EnemyType
     X AS INTEGER
     Y AS INTEGER
     Alive AS INTEGER
END TYPE

'global variables
DIM SHARED DefenderX%, DefenderY%     'Defender variables
DIM SHARED DefenderHealth%
DIM SHARED DefenderLaser AS LaserType
DIM SHARED EnemySquadX%, EnemySquadY% 'enemy squad variables
DIM SHARED EnemySquadInc%
DIM SHARED EnemyFrame%     'frame of enemy to be displayed
DIM SHARED OverSeer AS EnemyType
DIM SHARED OverSeerFrame%
DIM SHARED Speed!

'global arrays
DIM SHARED Sprites(1 TO 117, 1 TO NumSprites%)     'array to store sprites
DIM SHARED EnemySquad(1 TO NumEnemiesX%, 1 TO NumEnemiesY%) AS EnemyType    'enemy status
DIM SHARED EnemyLasers(1 TO NumEnemiesX%, 1 TO NumEnemiesY%) AS LaserType

'main program block
ResetScreen
COLOR 15
LOCATE 10, 1
PRINT "                         SPACE INVADERS v1.0"
PRINT "                      a game by Derek Andrews"
PRINT "Control:"
PRINT "        LEFT ARROW=LEFT,RIGHT ARROW=RIGHT,UP ARROW=FIRE,Q=END GAME"
PRINT "Object:"
PRINT "       Destroy as many enemies as you can before they kill you or"
PRINT "capture the base! You can receive more health by shooting the"
PRINT "overseer."
PRINT
PRINT "                        Press Enter to Continue"
WHILE HitKey <> 28: WEND
InitProg     'called ONCE---this initializes the program
PlayGame     'main program module

'sprite bitmap data
'enemy 1
DATA 0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0
DATA 0,0,1,1,1,3,1,1,1,1,3,1,1,1,0,0
DATA 0,1,1,1,3,9,3,1,1,3,9,3,1,1,1,0
DATA 1,1,1,3,9,0,9,5,5,9,0,9,3,1,1,1
DATA 1,1,1,3,3,3,3,5,5,3,3,3,3,1,1,1
DATA 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
DATA 0,0,1,7,8,7,8,7,8,7,8,7,8,1,0,0
DATA 0,1,1,0,7,8,7,8,7,8,7,8,0,1,1,0
DATA 1,0,1,0,1,0,0,0,0,0,0,1,0,1,0,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

DATA 0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0
DATA 0,0,1,1,1,3,1,1,1,1,3,1,1,1,0,0
DATA 0,1,1,1,3,0,3,1,1,3,0,3,1,1,1,0
DATA 1,1,1,3,9,9,9,5,5,9,9,9,3,1,1,1
DATA 1,1,1,3,3,3,3,5,5,3,3,3,3,1,1,1
DATA 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0
DATA 1,1,1,8,7,8,7,8,7,8,7,8,7,1,1,1
DATA 0,1,1,0,8,7,8,7,8,7,8,7,0,1,1,0
DATA 1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

'enemy 2
DATA 0,0,5,5,5,5,0,0,0,0,5,5,5,5,0,0
DATA 0,5,13,13,5,0,0,0,0,0,0,5,13,13,5,0
DATA 0,5,13,13,5,0,0,0,0,0,0,5,13,13,5,0
DATA 3,0,8,8,8,8,8,8,8,8,8,8,8,8,0,3
DATA 0,3,4,9,10,10,9,2,2,9,10,10,9,4,3,0
DATA 3,0,4,6,9,9,2,7,7,2,9,9,6,4,0,3
DATA 0,3,4,6,6,6,7,8,8,7,6,6,6,4,3,0
DATA 3,0,0,4,4,7,8,7,7,8,7,4,4,0,0,3
DATA 0,0,0,0,0,4,4,4,4,4,4,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

DATA 5,5,5,5,5,0,0,0,0,0,0,5,5,5,5,5
DATA 0,5,13,13,5,5,0,0,0,0,5,5,13,13,5,0
DATA 0,5,13,13,5,5,5,0,0,5,5,5,13,13,5,0
DATA 0,3,8,8,8,8,8,8,8,8,8,8,8,8,3,0
DATA 3,0,4,9,10,10,9,2,2,9,10,10,9,4,0,3
DATA 0,3,4,6,9,9,2,2,2,2,9,9,6,4,3,0
DATA 3,0,4,6,6,7,8,7,7,8,7,6,6,4,0,3
DATA 0,3,0,4,4,7,8,8,8,8,7,4,4,0,3,0
DATA 0,0,0,0,0,4,7,7,7,7,4,0,0,0,0,0
DATA 0,0,0,0,0,0,4,4,4,4,0,0,0,0,0,0

'enemy 3
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,3,3,3,4,4,4,4,3,3,3,0,0,0
DATA 0,0,3,2,2,3,15,15,15,15,3,2,2,3,0,0
DATA 0,3,2,2,2,3,15,0,0,15,3,2,2,2,3,0
DATA 3,2,2,2,2,3,15,15,15,15,3,2,2,2,2,3
DATA 3,2,2,2,3,3,3,4,4,3,3,3,2,2,2,3
DATA 3,2,2,3,13,12,12,15,15,12,12,13,3,2,2,3
DATA 3,2,3,0,13,12,12,15,15,12,12,13,0,3,2,3
DATA 3,3,0,0,0,13,13,12,12,13,13,0,0,0,3,3
DATA 3,0,0,0,0,0,0,13,13,0,0,0,0,0,0,3

DATA 3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,3
DATA 0,3,2,2,3,0,4,4,4,4,0,3,2,2,3,0
DATA 0,3,2,2,2,3,15,15,15,15,3,2,2,2,3,0
DATA 0,3,2,2,2,2,15,0,0,15,2,2,2,2,3,0
DATA 0,3,2,2,2,2,15,15,15,15,2,2,2,2,3,0
DATA 0,0,3,2,2,2,3,4,4,3,2,2,2,3,0,0
DATA 0,0,0,3,2,12,12,15,15,12,12,2,3,0,0,0
DATA 0,0,0,0,13,12,12,15,15,12,12,13,0,0,0,0
DATA 0,0,0,0,0,13,13,12,12,13,13,0,0,0,0,0
DATA 0,0,0,0,0,0,0,13,13,0,0,0,0,0,0,0

'enemy 4
DATA 5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5
DATA 5,5,0,0,0,5,5,5,5,5,5,0,0,0,5,5
DATA 5,1,5,0,5,1,8,8,8,8,1,5,0,5,1,5
DATA 5,1,9,5,15,15,1,8,8,1,15,15,5,9,1,5
DATA 5,1,9,1,15,12,15,1,1,15,12,15,1,9,1,5
DATA 5,1,9,1,15,12,15,15,15,15,12,15,1,9,1,5
DATA 5,1,9,5,7,15,15,7,7,15,15,7,5,9,1,5
DATA 5,1,5,0,5,8,8,8,8,8,8,5,0,5,1,5
DATA 5,5,0,0,0,5,5,5,5,5,5,0,0,0,5,5
DATA 5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5
    
DATA 0,0,5,0,0,0,0,0,0,0,0,0,0,5,0,0
DATA 0,0,5,5,0,5,5,5,5,5,5,0,5,5,0,0
DATA 0,0,5,1,5,1,8,8,8,8,1,5,1,5,0,0
DATA 0,0,5,5,15,15,1,8,8,1,15,15,5,5,0,0
DATA 0,0,5,9,15,12,15,1,1,15,12,15,9,5,0,0
DATA 0,0,5,9,15,12,15,15,15,15,12,15,9,5,0,0
DATA 0,0,5,5,7,15,15,7,7,15,15,7,5,5,0,0
DATA 0,0,5,1,5,8,8,8,8,8,8,5,1,5,0,0
DATA 0,0,5,5,0,5,5,5,5,5,5,0,5,5,0,0
DATA 0,0,5,0,0,0,0,0,0,0,0,0,0,5,0,0

'enemy 5
DATA 0,0,2,2,2,14,2,14,14,2,14,2,2,2,0,0
DATA 0,0,2,10,2,6,14,14,14,14,6,2,10,2,0,0
DATA 2,2,2,2,2,6,6,6,6,6,6,2,2,2,2,2
DATA 2,10,10,10,2,15,0,15,15,0,15,2,10,10,10,2
DATA 2,2,2,2,2,6,15,6,6,15,6,2,2,2,2,2
DATA 2,10,10,10,2,15,6,15,15,6,15,2,10,10,10,2
DATA 2,2,2,2,2,15,8,15,15,8,15,2,2,2,2,2
DATA 2,10,10,10,2,15,8,4,4,8,15,2,10,10,10,2
DATA 2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

DATA 0,0,0,0,2,14,2,14,14,2,14,2,0,0,0,0
DATA 0,0,0,0,2,6,14,14,14,14,6,2,0,0,0,0
DATA 0,0,2,2,2,6,6,6,6,6,6,2,2,2,0,0
DATA 0,0,2,10,2,15,0,15,15,0,15,2,10,2,0,0
DATA 0,0,2,2,2,6,15,6,6,15,6,2,2,2,0,0
DATA 0,0,2,10,2,15,6,15,15,6,15,2,10,2,0,0
DATA 0,0,2,2,2,15,8,15,15,8,15,2,2,2,0,0
DATA 0,0,2,10,2,15,8,4,4,8,15,2,10,2,0,0
DATA 0,0,2,2,2,0,0,0,0,0,0,2,2,2,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

'enemy 6
DATA 0,0,0,0,0,0,5,5,5,5,0,0,0,0,0,0
DATA 0,0,0,0,5,5,2,3,3,2,5,5,0,0,0,0
DATA 0,0,0,5,2,2,2,3,3,2,2,2,5,0,0,0
DATA 0,6,5,2,2,2,2,3,3,2,2,2,2,5,6,0
DATA 0,5,6,6,2,2,2,3,3,2,2,2,6,6,5,0
DATA 0,5,2,2,6,6,2,3,3,2,6,6,2,2,5,0
DATA 0,5,2,2,2,2,6,3,3,6,2,2,2,2,5,0
DATA 0,15,15,15,15,15,8,8,8,8,15,15,15,15,15,0
DATA 0,15,0,0,0,15,8,7,7,8,15,0,0,0,15,0
DATA 0,0,15,15,15,8,0,0,0,0,8,15,15,15,0,0

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,5,5,5,5,5,5,5,5,5,5,0,0,0
DATA 0,0,5,2,2,2,2,3,3,2,2,2,2,5,0,0
DATA 0,0,5,6,2,2,2,3,3,2,2,2,6,5,0,0
DATA 0,0,5,2,6,6,2,3,3,2,6,6,2,5,0,0
DATA 0,0,5,2,2,2,6,3,3,6,2,2,2,5,0,0
DATA 0,0,15,15,15,15,8,8,8,8,15,15,15,15,0,0
DATA 0,0,15,0,0,15,8,7,7,8,15,0,0,15,0,0
DATA 0,0,15,15,15,8,0,0,0,0,8,15,15,15,0,0

'defender
DATA 0,0,0,0,0,3,9,9,9,9,3,0,0,0,0,0
DATA 0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0
DATA 0,0,0,0,0,3,14,14,14,14,3,0,0,0,0,0
DATA 0,0,0,0,3,14,10,10,10,10,14,3,0,0,0,0
DATA 0,0,0,3,9,9,14,14,14,14,9,9,3,0,0,0
DATA 0,0,3,11,11,11,9,9,9,9,11,11,11,3,0,0
DATA 0,3,11,11,11,11,11,11,11,11,11,11,11,11,3,0
DATA 3,11,11,11,11,11,11,11,11,11,11,11,11,11,11,3
DATA 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
DATA 0,7,7,0,7,7,0,7,7,0,7,7,0,7,7,0

'base shield
DATA 0,0,0,8,8,8,8,8,8,8,8,8,8,0,0,0
DATA 0,0,8,6,6,6,6,6,6,6,6,6,6,8,0,0
DATA 0,8,6,6,6,6,6,6,6,6,6,6,6,6,8,0
DATA 8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8
DATA 8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8
DATA 8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8
DATA 8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8
DATA 8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8
DATA 8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8
DATA 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8

'overseer
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,8,8,8,8,8,8,8,8,8,8,0,0,0
DATA 0,0,8,1,1,1,1,1,1,1,1,1,1,8,0,0
DATA 0,8,1,1,1,1,1,1,1,1,1,1,1,1,8,0
DATA 8,1,10,10,10,1,10,10,10,10,1,10,10,10,1,8
DATA 8,1,10,10,10,1,10,10,10,10,1,10,10,10,1,8
DATA 0,8,1,1,1,1,1,1,1,1,1,1,1,1,8,0
DATA 0,0,8,1,1,1,1,1,1,1,1,1,1,8,0,0
DATA 0,0,0,8,8,8,8,8,8,8,8,8,8,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,8,8,8,8,8,8,8,8,8,8,0,0,0
DATA 0,0,8,1,1,1,1,1,1,1,1,1,1,8,0,0
DATA 0,8,1,1,1,1,1,1,1,1,1,1,1,1,8,0
DATA 8,1,9,9,9,1,9,9,9,9,1,9,9,9,1,8
DATA 8,1,9,9,9,1,9,9,9,9,1,9,9,9,1,8
DATA 0,8,1,1,1,1,1,1,1,1,1,1,1,1,8,0
DATA 0,0,8,1,1,1,1,1,1,1,1,1,1,8,0,0
DATA 0,0,0,8,8,8,8,8,8,8,8,8,8,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

'waits until INKEY$ is null
'
SUB ClearBuffer

WHILE LEN(INKEY$): WEND

END SUB

'delays for Time! every interval% calls.
'
SUB Delay (Time!, Interval%)

STATIC YesPause%     'save YesPause%
IF YesPause% >= Interval% THEN     'if YesPause% is bigger than Interval%, then pause for Time!
    T! = TIMER
    DO
         ClearBuffer     'clear keyboard buffer to avoid annoying beep
    LOOP UNTIL TIMER - T! >= Time!
    YesPause% = 0
END IF
IF Interval% > 0 THEN YesPause% = YesPause% + 1

END SUB

'This draws the base that you defend
'
SUB DrawBase

PUT (80, 150), Sprites(1, BaseShieldIndex%), PSET
PUT (150, 150), Sprites(1, BaseShieldIndex%), PSET
PUT (220, 150), Sprites(1, BaseShieldIndex%), PSET
LINE (49, DefenderY% + 6)-(320, 200), BaseColor%, BF
LINE (59, DefenderY% + 6)-STEP(-10, -10), BaseColor%, BF
LINE (270, DefenderY% + 6)-STEP(10, -10), BaseColor%, BF

END SUB

'Draws Defender at DefenderX%-SpriteWidth%,DefenderY%-SpriteHeight%
'
SUB DrawDefender

PUT (DefenderX% - 5, DefenderY% - 4), Sprites(1, DefenderIndex%), PSET

END SUB

'This procedure draws all enemies that are alive onto the screen
'
SUB DrawEnemies

SpriteIndex% = 1
EnemyIndexY% = 1
FOR Y = 1 TO 120 STEP 20
     EnemyIndexX% = 1
     FOR X = 1 TO 210 STEP 35
          IF EnemySquad(EnemyIndexX%, EnemyIndexY%).Alive = True% THEN
               PUT (X + EnemySquadX%, Y + EnemySquadY%), Sprites(1, SpriteIndex% + EnemyFrame%), PSET
          END IF
          EnemySquad(EnemyIndexX%, EnemyIndexY%).X = (X + EnemySquadX%)
          EnemySquad(EnemyIndexX%, EnemyIndexY%).Y = (Y + EnemySquadY%) + SpriteHeight%
          EnemyIndexX% = EnemyIndexX% + 1
     NEXT X
     EnemyIndexY% = EnemyIndexY% + 1
     SpriteIndex% = SpriteIndex% + 2
NEXT Y

END SUB

'This procedure draws all lasers that have been fired and
'checks to see if an enemy or the defender has been hit
'
SUB DrawLasers

IF DefenderLaser.Alive = True% THEN
     LINE (DefenderLaser.X, DefenderLaser.Y)-STEP(0, -4), 10
     DefenderLaser.Y = DefenderLaser.Y - 4
     IF POINT(DefenderLaser.X, DefenderLaser.Y - 2) <> 0 AND POINT(DefenderLaser.X, DefenderLaser.Y - 2) <> -1 THEN
          DefenderLaser.Alive = 0
          LINE (DefenderLaser.X, DefenderLaser.Y - 2)-STEP(0, 10), 0
     END IF
     IF DefenderLaser.Y + 7 <= DefenderY% THEN LINE (DefenderLaser.X, DefenderLaser.Y + 7)-STEP(0, 4), 0
     IF DefenderLaser.Y <= -20 THEN DefenderLaser.Alive = 0
END IF

FOR Y = 1 TO NumEnemiesY%
     FOR X = 1 TO NumEnemiesX%
          IF EnemyLasers(X, Y).Alive = True% THEN
               LINE (EnemyLasers(X, Y).X, EnemyLasers(X, Y).Y)-STEP(0, 4), 40
               EnemyLasers(X, Y).Y = EnemyLasers(X, Y).Y + 4
               IF EnemyLasers(X, Y).Y - 7 >= EnemySquad(X, Y).Y THEN LINE (EnemyLasers(X, Y).X, EnemyLasers(X, Y).Y - 7)-STEP(0, -4), 0
               IF EnemyLasers(X, Y).Y >= 220 THEN
                    EnemyLasers(X, Y).Alive = False%
                    LINE (EnemyLasers(X, Y).X, EnemyLasers(X, Y).Y)-STEP(0, -10), 0
                    EnemyLasers(X, Y).X = 0
                    EnemyLasers(X, Y).Y = 0
               END IF
               IF POINT(EnemyLasers(X, Y).X, EnemyLasers(X, Y).Y + 2) <> 0 AND EnemyLasers(X, Y).Y <= 160 THEN
                    EnemyLasers(X, Y).Alive = False%
                    LINE (EnemyLasers(X, Y).X, EnemyLasers(X, Y).Y + 2)-STEP(0, -10), 0
                    EnemyLasers(X, Y).X = 0
                    EnemyLasers(X, Y).Y = 0
               END IF
          END IF
     NEXT X
NEXT Y
END SUB

'This procedure draws the overseer on screen
'
SUB DrawOverSeer

PUT (OverSeer.X, OverSeer.Y), Sprites(1, OverSeerIndex% + OverSeerFrame%), PSET

END SUB

'This function returns whether or not an enemy can fire without hitting his
'comrades
'
FUNCTION EnemyClearShot (X, Y)

IF Y = NumEnemiesY% THEN EnemyClearShot = True%: EXIT FUNCTION
FOR C = Y + 1 TO NumEnemiesY%
     IF EnemySquad(X, C).Alive = True% THEN EnemyClearShot = False: EXIT FUNCTION
NEXT C
EnemyClearShot = True%

END FUNCTION

'This procedure increments a variable until it reaches Speed! and then
'increments the aliens
'
SUB EnemyInc

STATIC IncFlag%
IncFlag% = IncFlag% + 1
IF IncFlag% >= Speed! THEN
     IF EnemyFrame% = 0 THEN EnemyFrame% = 1 ELSE EnemyFrame% = 0
     IncFlag% = 0
     Count% = 0
     FOR Y = 1 TO NumEnemiesY%
          FOR X = 1 TO NumEnemiesX%
               IF EnemySquad(X, Y).Alive = True% AND EnemySquad(X, Y).X >= 5 AND EnemySquad(X, Y).X + SpriteWidth% <= 300 AND EnemySquad(X, Y).Y >= 0 AND EnemySquad(X, Y).Y + SpriteHeight% <= 200 THEN Count% = Count% + 1
               IF EnemySquad(X, Y).Y >= DefenderY% AND EnemySquad(X, Y).Alive = True% THEN ResetScreen: END
          NEXT X
     NEXT Y
     IF Count% = NumEnemies THEN
          EnemySquadX% = EnemySquadX% + EnemySquadInc%
          PLAY EnemySquadMove$
     ELSE
          EnemySquadY% = EnemySquadY% + 5
          EnemySquadInc% = -EnemySquadInc%
          EnemySquadX% = EnemySquadX% + EnemySquadInc%
          PLAY EnemySquadMove$
     END IF
END IF
END SUB

'This procedure detects collision of lasers with enemies or collision
'of the enemies' lasers with the player
'
SUB FindLaserHits

FOR Y = 1 TO NumEnemiesY%
     FOR X = 1 TO NumEnemiesX%
          IF DefenderLaser.X >= EnemySquad(X, Y).X + 5 AND DefenderLaser.X <= EnemySquad(X, Y).X + SpriteWidth% + 5 THEN
               IF EnemySquad(X, Y).Alive = True% AND DefenderLaser.Y >= EnemySquad(X, Y).Y - 5 AND DefenderLaser.Y <= EnemySquad(X, Y).Y + 8 THEN
                    EnemySquad(X, Y).Alive = 0
                    DefenderLaser.Alive = 0
                    Speed! = Speed! - .422
                    PLAY EnemyHit$
                    LINE (EnemySquad(X, Y).X + 5, EnemySquad(X, Y).Y - 5)-STEP(SpriteWidth%, SpriteHeight%), 0, BF
                    LINE (DefenderLaser.X, DefenderLaser.Y - 2)-STEP(0, 10), 0
                    DefenderLaser.X = DefenderX% + 9
                    DefenderLaser.Y = DefenderY% + 1
               END IF
          END IF
          IF EnemyLasers(X, Y).X >= DefenderX% AND EnemyLasers(X, Y).X <= DefenderX% + 16 AND EnemyLasers(X, Y).Y >= DefenderY% AND EnemyLasers(X, Y).Y <= DefenderY% + 10 THEN
               DefenderHealth% = DefenderHealth% - 1
          END IF
     NEXT X
NEXT Y

END SUB

'gets scancode from keyboard port
'The extra code here may not seem necessary, but on some computers,
'the scancode is irregular for the arrow keys. This ignores all codes
'above 215.
'
FUNCTION HitKey

STATIC PrevCode%     'save previous scancode
ScanCode% = INP(96)
IF ScanCode% > 215 THEN HitKey = PrevCode% ELSE HitKey = ScanCode%
IF ScanCode% <= 215 THEN PrevCode% = ScanCode%

END FUNCTION

'This procedure prepares game for further execution
'
SUB InitPlay

DefenderX% = DefenderXcoord%
DefenderY% = DefenderYcoord%
DefenderHealth% = 30
EnemySquadInc% = 5
EnemySquadX% = 10
EnemySquadY% = 15
OverSeer.X = 290
OverSeer.Y = 5
OverSeer.Alive = False%
EnemyFrame% = 0
Speed! = 15
DrawBase
ReviveEnemies

END SUB

'This procedure initializes screen mode, loads bitmap data, clears VRAM
'and uses system timer for random number seed.
'
SUB InitProg

SCREEN 13, 1    'initialize 320x200x16 resolution
VIEW PRINT 1 TO 25
CLS             'clear VRAM
RANDOMIZE TIMER     'use system timer for random number seed
LoadBitmapData      'load sprite bitmap data

END SUB

'This procedure loads bitmap data into Sprites() array.
'
SUB LoadBitmapData

FOR S = 1 TO NumSprites%     'index variable for Sprites() array
     FOR Y = 1 TO SpriteHeight%     'Y and X coordinates for PSET
          FOR X = 1 TO SpriteWidth%
               READ Col%     'reads pixel data for X,Y
               PSET (X + 5, Y + 5), Col%   'draws pixel at X,Y with color Col%
          NEXT X
     NEXT Y
     IF S = DefenderIndex% OR S = OverSeerIndex% OR S = OverSeerIndex% + 1 THEN
          GET (0, 6)-(SpriteWidth% + 12, SpriteHeight% + 5), Sprites(1, S)  'gets sprite image with black margin for mask
     ELSE
          GET (0, 0)-(SpriteWidth% + 12, SpriteHeight% + 5), Sprites(1, S)  'gets sprite image with black margin for mask
     END IF
NEXT S
CLS

END SUB

'Returns number of enemies still alive
'
FUNCTION NumEnemies

Count% = 0
FOR Y = 1 TO NumEnemiesY%
     FOR X = 1 TO NumEnemiesX%
          IF EnemySquad(X, Y).Alive = True% THEN Count% = Count% + 1
     NEXT X
NEXT Y
NumEnemies = Count%

END FUNCTION

'This is the main program module which calls all other modules.
'
SUB PlayGame

DO
     SCREEN 13: CLS
     VIEW PRINT 1 TO 25
     InitPlay
     DrawEnemies
     DrawDefender
     ShowHealth
     Delay 1, 0
     DO
          
          DrawEnemies
          DrawDefender
          EnemyInc
          Delay .01, 0
          ClearBuffer
          SELECT CASE HitKey
               CASE KeyLeft%
                    IF DefenderX% >= 68 THEN DefenderX% = DefenderX% - 3
               CASE KeyRight%
                    IF DefenderX% <= 244 THEN DefenderX% = DefenderX% + 3
               CASE KeyUp%
                    IF DefenderLaser.Alive = False% THEN
                         DefenderLaser.Alive = True%
                         PLAY DefenderFire$
                         DefenderLaser.X = DefenderX% + 9
                         DefenderLaser.Y = DefenderY% + 1
                    END IF
               CASE QuitKey%
                    ResetScreen
                    END
          END SELECT
          RunOverSeer
          RunEnemyLasers
          ShowHealth
          RefreshBase
          FindLaserHits
          DrawLasers
          IF NumEnemies = 0 THEN LOCATE 10, 15: PRINT " YOU WIN": Delay 1, 0: EXIT DO
          IF DefenderHealth% = 0 THEN LOCATE 10, 15: PRINT "GAME OVER": Delay 1, 0: EXIT DO
     LOOP
LOOP

END SUB

'This comensates for enemy's lasers destroying the base
'
SUB RefreshBase

LINE (49, DefenderY% + 6)-(320, 200), BaseColor%, BF
LINE (59, DefenderY% + 6)-STEP(-10, -10), BaseColor%, BF
LINE (270, DefenderY% + 6)-STEP(10, -10), BaseColor%, BF

END SUB

'resets screen mode for DOS operating system
'
SUB ResetScreen

SCREEN 0
WIDTH 80, 25
CLS
COLOR 7, 0

END SUB

'This procedure "revives" all enemies by setting their Alive variable
'to True%
'
SUB ReviveEnemies

FOR Y = 1 TO NumEnemiesY%
     FOR X = 1 TO NumEnemiesX%
          EnemySquad(X, Y).Alive = True%
     NEXT X
NEXT Y

END SUB

'This procedure fires enemies' lasers
'
SUB RunEnemyLasers

FOR X = 1 TO NumEnemiesX%
     FOR Y = NumEnemiesY% TO 1 STEP -1
          IF EnemySquad(X, Y).Alive = True% AND EnemyClearShot(X, Y) = True% THEN
               IF EnemyLasers(X, Y).Alive = False% THEN
                    Rand% = INT((RND * 10) + 1)
                    IF Rand% = 10 THEN
                         EnemyLasers(X, Y).Alive = True%
                         EnemyLasers(X, Y).X = EnemySquad(X, Y).X + 12
                         EnemyLasers(X, Y).Y = EnemySquad(X, Y).Y + 10
                         EXIT FOR
                    END IF
               END IF
          END IF
     NEXT Y
NEXT X

END SUB

SUB RunOverSeer

STATIC Time!, OverSeerFrameTimer!
IF Time! = 0 AND OverSeerFrameTimer! = 0 THEN
     Time! = TIMER
     OverSeerFrameTimer! = TIMER
END IF
IF TIMER - Time! >= OverSeerTime% THEN
     Time! = TIMER
     IF OverSeer.Alive = False% THEN OverSeer.Alive = True%: PLAY OverSeerAppear$
END IF
IF TIMER - OverSeerFrameTimer! >= OverSeerFrameTime% THEN
     OverSeerFrameTimer! = TIMER
     IF OverSeerFrame% = 0 THEN OverSeerFrame% = 1 ELSE OverSeerFrame% = 0
END IF
IF OverSeer.Alive = True% THEN
     DrawOverSeer
     OverSeer.X = OverSeer.X - 1
     IF OverSeer.X <= 10 THEN
          OverSeer.Alive = False%
          Time! = TIMER
          OverSeerFrameTimer! = TIMER
          LINE (OverSeer.X, OverSeer.Y)-STEP(SpriteWidth% + 10, SpriteHeight%), 0, BF
          OverSeer.X = 290
     END IF
END IF
IF DefenderLaser.X >= OverSeer.X + 5 AND DefenderLaser.X <= OverSeer.X + SpriteWidth% + 5 AND DefenderLaser.Y >= OverSeer.Y AND DefenderLaser.Y <= OverSeer.Y + 15 THEN
     DefenderLaser.Alive = False%
     OverSeer.Alive = False%
     Time! = TIMER
     PLAY EnemyHit$
     LINE (DefenderLaser.X, DefenderLaser.Y - 2)-STEP(0, 10), 0
     LINE (OverSeer.X, OverSeer.Y)-STEP(SpriteWidth% + 10, SpriteHeight%), 0, BF
     OverSeer.X = 290
     IF DefenderHealth% + 10 <= 25 THEN DefenderHealth% = DefenderHealth% + 10 ELSE DefenderHealth% = 25
END IF

END SUB

'Displays defender's health
'
SUB ShowHealth

LOCATE 24, 1
PRINT "Health"
LINE (0, 193)-STEP(DefenderHealth%, 10), 32, BF
LINE (DefenderHealth%, 193)-STEP(1, 10), 0, BF

END SUB

