'****************************************************************
'
' Speed (the card game)
'
'   author:   Steve Nunnally
'   company:  Acid Works Software
'   email:    nunnally@pinn.net
'   homepage: www.pinn.net/~nunnally/qbasic/
'
'****************************************************************
DEFINT A-Z

DECLARE FUNCTION CB% (xx1%, yy1%, xx2%, yy2%)
DECLARE SUB CheckCompGo ()
DECLARE SUB CheckPlayerGo ()
DECLARE SUB CompareCards (midl%)
DECLARE SUB CompareOne (midl%)
DECLARE SUB CompTurn ()
DECLARE SUB CoolPrint (xpos%, ypos%, text$, ctype%)
DECLARE SUB DoSides ()
DECLARE SUB DisplayBoard ()
DECLARE SUB FadeIn ()
DECLARE SUB FadeOut ()
DECLARE SUB HighScores ()
DECLARE SUB LoadPic (nfile$, darray%())
DECLARE SUB LoadMainPic ()
DECLARE SUB PalLoad (palname$)
DECLARE SUB PlayerVSComp ()
DECLARE SUB OnePlayer ()
DECLARE SUB OnePlayerBoard ()
DECLARE SUB Options ()
DECLARE SUB SetupOptions ()
DECLARE SUB SetupCards ()
DECLARE SUB SetupGame ()
DECLARE SUB ShowCompHand ()
DECLARE SUB ShowHand ()
DECLARE SUB ShowSideButtons ()
DECLARE SUB ShowOneHand ()

DECLARE SUB CheckBound (co1%, co2%, cu1%, cu2%)
DECLARE SUB DoMouse (xm%, ym%, mlines%)
DECLARE SUB Mouse (mup, mover, mbut)
DECLARE SUB MouseInit ()
DECLARE SUB MousePointer (mtype)
'****************************************************************
COMMON SHARED deck, hardness, seecomp, playvscomp
COMMON SHARED curComp, curPlayer, bgcolor, joker

COMMON SHARED mup, mover, mbut, mt, compmid, haderror
COMMON SHARED lmid, rmid, sides, compgo, playergo

DIM SHARED mouseCode(9), amask(150), mmask(150)
DIM SHARED arrow(150), aback(150), menua(150), cs(500)
DIM SHARED card(2300), palhold(0 TO 255, 1 TO 3)

DIM SHARED computer(1 TO 20), player(1 TO 20)
DIM SHARED ccards(1 TO 5), pcards(1 TO 7)
DIM SHARED lside(1 TO 5), rside(1 TO 5)
DIM SHARED scores(1 TO 10), temps$(1 TO 10), ti(1 TO 10)

'****************************************************************
'***** OPTIONS *****

bgcolor = 94        ' background color
hardness = 150      ' how tough the computer is(1 to 5)
deck = 1            ' which cards to use
seecomp = 0         ' see the computers cards: 1, or dont: 0
playvscomp = 1      ' play against the computer: 1, or for speed: 0
joker = 0           ' have joker's be wild: 1, or have no jokers: 0

'****************************************************************
CLS : SCREEN 13
RANDOMIZE TIMER

CALL MouseInit
CALL Mouse(mup, mover, mbut)

CALL FadeOut: CLS : CALL PalLoad("menu.pal"): CALL FadeOut

CALL LoadPic("cs.spd", cs()): CALL LoadMainPic

GET (mover, mup)-(mover + 8, mup + 11), aback
PUT (mover, mup), menua, OR
PUT (mover, mup), mmask, AND: CALL FadeIn

DO

 mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
 IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
 IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
 WAIT &H3DA, 8
 IF mo <> mover OR mu <> mup THEN
  PUT (mo, mu), aback, PSET
  GET (mover, mup)-(mover + 8, mup + 11), aback
  PUT (mover, mup), menua, OR
  PUT (mover, mup), mmask, AND
 END IF

 IF mbut = 1 THEN
  IF CB(112, 55, 208, 77) = 1 AND mbut = 1 THEN
   IF playvscomp = 1 THEN
    CALL PlayerVSComp
   ELSE
    CALL OnePlayer
   END IF
   CALL FadeOut: CLS : CALL PalLoad("menu.pal")
   CALL FadeOut: CALL LoadMainPic
   GET (mover, mup)-(mover + 8, mup + 11), aback
   PUT (mover, mup), menua, OR
   PUT (mover, mup), mmask, AND: CALL FadeIn: mbut = 0
  END IF

  IF CB(112, 77, 208, 106) = 1 AND mbut = 1 THEN
   CALL Options
   CALL FadeOut: CLS : CALL PalLoad("menu.pal")
   CALL FadeOut: CALL LoadMainPic
   GET (mover, mup)-(mover + 8, mup + 11), aback
   PUT (mover, mup), menua, OR
   PUT (mover, mup), mmask, AND: CALL FadeIn: mbut = 0
  END IF

  IF CB(112, 106, 208, 133) = 1 AND mbut = 1 THEN
   CALL HighScores
   CALL FadeOut: CLS : CALL PalLoad("menu.pal")
   CALL FadeOut: CALL LoadMainPic
   GET (mover, mup)-(mover + 8, mup + 11), aback
   PUT (mover, mup), menua, OR
   PUT (mover, mup), mmask, AND: CALL FadeIn: mbut = 0
  END IF

  IF CB(112, 133, 208, 157) = 1 AND mbut = 1 THEN CALL FadeOut: END
 END IF

 key$ = INKEY$
LOOP UNTIL key$ = CHR$(27)
CALL FadeOut
END



NewInputFile:
 CLOSE
 OPEN "scores.spd" FOR OUTPUT AS #2
  FOR i = 1 TO 10
   WRITE #2, "Nobody", 1000, 1000
  NEXT i
 CLOSE #2
 haderror = 1
 RESUME NEXT


DATA &HB8,&H00,&H00   :
DATA &H55             :
DATA &H8B,&HEC        :
DATA &HCD,&H33        :
DATA &H92             :
DATA &H8B,&H5E,&H06   :
DATA &H89,&H07        :
DATA &H5D             :
DATA &HCA,&H02,&H00   :

DATA 222000000
DATA 212200000
DATA 211220000
DATA 211122000
DATA 211112200
DATA 211111220
DATA 211111122
DATA 211111112
DATA 211111222
DATA 212211120
DATA 222221120
DATA 000022220

FUNCTION CB (xx1, yy1, xx2, yy2)

 CB = 0

 IF mup > yy1 THEN
  IF mup < yy2 THEN
   IF mover > xx1 THEN
    IF mover < xx2 THEN CB = 1
   END IF
  END IF
 END IF

END FUNCTION

SUB CheckBound (co1, co2, cu1, cu2)

 IF mover < co1 THEN mover = co1
 IF mover > co2 THEN mover = co2
 IF mup < cu1 THEN mup = cu1
 IF mup > cu2 THEN mup = cu2

END SUB

SUB CheckCompGo

 i = 1: yesgot = 0
 DO
  IF ccards(i) <> 0 THEN
   SELECT CASE ccards(i)
    CASE lmid - 1: yesgot = 1
    CASE lmid + 1: yesgot = 1
    CASE rmid - 1: yesgot = 1
    CASE rmid + 1: yesgot = 1
    CASE 1: IF lmid = 13 OR rmid = 13 THEN yesgot = 1
    CASE 13: IF lmid = 1 OR rmid = 1 THEN yesgot = 1
    CASE 14: yesgot = 1
   END SELECT
  END IF
  IF lmid = 14 OR rmid = 14 THEN yesgot = 1
  IF yesgot = 1 THEN i = 5
  i = i + 1
 LOOP UNTIL i = 6

 IF yesgot = 0 THEN compgo = 0 ELSE compgo = 1

END SUB

SUB CheckPlayerGo

 i = 1: yesgot = 0
 DO
  IF pcards(i) <> 0 THEN
   SELECT CASE pcards(i)
    CASE lmid - 1: yesgot = 1
    CASE lmid + 1: yesgot = 1
    CASE rmid - 1: yesgot = 1
    CASE rmid + 1: yesgot = 1
    CASE 1: IF lmid = 13 OR rmid = 13 THEN yesgot = 1
    CASE 13: IF lmid = 1 OR rmid = 1 THEN yesgot = 1
    CASE 14: yesgot = 1
   END SELECT
  END IF
  IF lmid = 14 OR rmid = 14 THEN yesgot = 1
  IF yesgot = 1 THEN i = 7
  i = i + 1
 LOOP UNTIL i = 8

 IF mt <> 0 THEN
  SELECT CASE mt
   CASE lmid - 1: yesgot = 1
   CASE lmid + 1: yesgot = 1
   CASE rmid - 1: yesgot = 1
   CASE rmid + 1: yesgot = 1
   CASE 1: IF lmid = 13 OR rmid = 13 THEN yesgot = 1
   CASE 13: IF lmid = 1 OR rmid = 1 THEN yesgot = 1
   CASE 14: yesgot = 1
  END SELECT
 END IF

 IF yesgot = 0 THEN playergo = 0 ELSE playergo = 1

END SUB

SUB CompareCards (midl)

 IF mt <> 0 THEN
  IF midl = 1 THEN
   IF mt = lmid - 1 OR mt = lmid + 1 THEN lmid = mt: mt = 0
   IF (mt = 1 AND lmid = 13) THEN lmid = mt: mt = 0
   IF (mt = 13 AND lmid = 1) THEN lmid = mt: mt = 0
   IF lmid = 14 AND mt <> 0 THEN lmid = mt: mt = 0
   IF mt = 14 THEN lmid = mt: mt = 0
  END IF
  IF midl = 2 THEN
   IF mt = rmid - 1 OR mt = rmid + 1 THEN rmid = mt: mt = 0
   IF (mt = 1 AND rmid = 13) THEN rmid = mt: mt = 0
   IF (mt = 13 AND rmid = 1) THEN rmid = mt: mt = 0
   IF rmid = 14 AND mt <> 0 THEN rmid = mt: mt = 0
   IF mt = 14 THEN rmid = mt: mt = 0
  END IF
  IF mt = 0 THEN
   curPlayer = curPlayer + 1
   FOR i = 1 TO 5
    IF curPlayer < 16 THEN
     IF pcards(i) = 0 THEN
      pcards(i) = player(curPlayer + 5)
      player(curPlayer + 5) = 0
     END IF
    END IF
   NEXT i
   CALL ShowHand
   PUT (mover, mup), aback, PSET
  
   LINE (((20 - curPlayer) * 8) + 56, 160)-STEP(16, 16), bgcolor, BF
  
   FOR i = 5 TO 19 - curPlayer
    PUT ((i * 8) + 56, 160), card(0), PSET
   NEXT i
  
   CALL DoMouse(mover, mup, 0)
  END IF
 END IF

END SUB

SUB CompareOne (midl)

 IF mt <> 0 THEN
  IF midl = 1 THEN
   IF mt = lmid - 1 OR mt = lmid + 1 THEN lmid = mt: mt = 0
   IF (mt = 1 AND lmid = 13) THEN lmid = mt: mt = 0
   IF (mt = 13 AND lmid = 1) THEN lmid = mt: mt = 0
   IF lmid = 14 AND mt <> 0 THEN lmid = mt: mt = 0
   IF mt = 14 THEN lmid = mt: mt = 0
  END IF
  IF midl = 2 THEN
   IF mt = rmid - 1 OR mt = rmid + 1 THEN rmid = mt: mt = 0
   IF (mt = 1 AND rmid = 13) THEN rmid = mt: mt = 0
   IF (mt = 13 AND rmid = 1) THEN rmid = mt: mt = 0
   IF rmid = 14 AND mt <> 0 THEN rmid = mt: mt = 0
   IF mt = 14 THEN rmid = mt: mt = 0
  END IF
  IF mt = 0 THEN
   curPlayer = curPlayer + 1
   FOR i = 1 TO 7
    IF curPlayer < 14 THEN
     IF pcards(i) = 0 THEN
      pcards(i) = player(curPlayer + 7)
      player(curPlayer + 7) = 0
     END IF
    END IF
   NEXT i
   CALL ShowOneHand
   PUT (mover, mup), aback, PSET
 
   LINE (((20 - curPlayer) * 8) + 40, 160)-STEP(16, 16), bgcolor, BF
 
   FOR i = 7 TO 19 - curPlayer
    PUT ((i * 8) + 40, 160), card(0), PSET
   NEXT i
 
   CALL DoMouse(mover, mup, 0)
  END IF
 END IF

END SUB

SUB CompTurn

 i = 1: yesgot = 0
 DO
  IF ccards(i) <> 0 THEN
   SELECT CASE ccards(i)
    CASE lmid - 1: yesgot = 1
    CASE lmid + 1: yesgot = 1
    CASE rmid - 1: yesgot = 2
    CASE rmid + 1: yesgot = 2
    CASE 1: IF lmid = 13 THEN yesgot = 1 ELSE IF rmid = 13 THEN yesgot = 2
    CASE 13: IF lmid = 1 THEN yesgot = 1 ELSE IF rmid = 1 THEN yesgot = 2
    CASE 14: yesgot = INT(RND * 2) + 1
   END SELECT
  END IF
  IF lmid = 14 THEN yesgot = 1
  IF rmid = 14 THEN yesgot = 2
  IF yesgot = 1 THEN lmid = ccards(i): ccards(i) = 0: i = 5
  IF yesgot = 2 THEN rmid = ccards(i): ccards(i) = 0: i = 5
  i = i + 1
 LOOP UNTIL i = 6

 IF yesgot <> 0 THEN
  curComp = curComp + 1
 
  FOR i = 1 TO 5
   IF curComp < 16 THEN
    IF ccards(i) = 0 THEN
     ccards(i) = computer(curComp + 5)
     computer(curComp + 5) = 0
    END IF
   END IF
  NEXT i
 
  CALL ShowCompHand
  
  PUT (mover, mup), aback, PSET
  LINE (((20 - curComp) * 8) + 56, 24)-STEP(16, 16), bgcolor, BF
  FOR i = 5 TO 19 - curComp
   PUT ((i * 8) + 56, 24), card(0), PSET
  NEXT i
  CALL DoMouse(mover, mup, 0)
 END IF
 
 PUT (mover, mup), aback, PSET
  PUT (126, 92), card(lmid * 150), PSET
  PUT (178, 92), card(rmid * 150), PSET
 CALL DoMouse(mover, mup, 0)

END SUB

SUB CoolPrint (xpos%, ypos%, text$, ctype%)

 xx% = xpos% - 1
 yy% = ypos%

 FOR chr% = 1 TO LEN(text$)
  xx% = xx% + 8
  ptr% = 8 * ASC(MID$(text$, chr%, 1)) + &HE

  adnum% = 8
  SELECT CASE ctype%
   CASE 0: col% = 5: adnum% = 1
   CASE 1: col% = 30
   CASE 2: col% = 62
   CASE 3: col% = 94
   CASE 4: col% = 126
   CASE 5: col% = 158
   CASE 6: col% = 190
   CASE ELSE: col% = ctype%: adnum% = 0
  END SELECT

  FOR L% = 0 TO 7
   DEF SEG = &HFFA6
    BitPattern% = PEEK(ptr% + L%)
   DEF SEG
   IF BitPattern% AND 1 THEN PSET (xx%, yy% + L%), col%
   IF BitPattern% AND 2 THEN PSET (xx% - 1, yy% + L%), col%
   IF BitPattern% AND 4 THEN PSET (xx% - 2, yy% + L%), col%
   IF BitPattern% AND 8 THEN PSET (xx% - 3, yy% + L%), col%
   IF BitPattern% AND 16 THEN PSET (xx% - 4, yy% + L%), col%
   IF BitPattern% AND 32 THEN PSET (xx% - 5, yy% + L%), col%
   IF BitPattern% AND 64 THEN PSET (xx% - 6, yy% + L%), col%
   IF BitPattern% AND 128 THEN PSET (xx% - 7, yy% + L%), col%
   col% = col% + adnum%
  NEXT

 NEXT
 DEF SEG

END SUB

SUB DisplayBoard

 WAIT &H3DA, 8

 PAINT (15, 15), bgcolor

 FOR i = curPlayer + 5 TO 19
  PUT ((i * 8) + 56, 160), card(0), PSET
 NEXT i

 FOR i = curComputer + 5 TO 19
  PUT ((i * 8) + 56, 24), card(0), PSET
 NEXT i

 PUT (126, 92), card(lmid * 150), PSET
 PUT (178, 92), card(rmid * 150), PSET

 FOR i = 5 TO 1 STEP -1
   IF lside(i) <> 0 THEN PUT (90, (i * 2) + 82), card(0), PSET
  IF rside(i) <> 0 THEN PUT (214, (i * 2) + 82), card(0), PSET
 NEXT i

 FOR i = 1 TO 5
  PUT ((i * 19) + 95, 130), card(pcards(i) * 150), PSET
  LINE ((i * 19) + 94, 129)-STEP(17, 17), bgcolor - 1, B
 NEXT i

 FOR i = 1 TO 5
  IF seecomp = 0 THEN
   IF ccards(i) <> 0 THEN PUT ((i * 19) + 95, 50), card(0), PSET
  ELSE
   IF ccards(i) <> 0 THEN PUT ((i * 19) + 95, 50), card(ccards(i) * 150), PSET
  END IF
 NEXT i

END SUB

SUB DoMouse (xm, ym, mlines)

 IF mlines = 1 THEN PUT (xm, ym), aback, PSET

 IF mt = 0 THEN
  GET (mover, mup)-(mover + 8, mup + 11), aback
  PUT (mover, mup), arrow, OR
  PUT (mover, mup), amask, AND
 ELSE
  GET (mover, mup)-(mover + 15, mup + 15), aback
  PUT (mover, mup), card(mt * 150), PSET
 END IF

END SUB

SUB DoSides

 sides = sides + 1

 lmid = lside(sides): lside(sides) = 0
 rmid = rside(sides): rside(sides) = 0

 WAIT &H3DA, 8

 PUT (mover, mup), aback, PSET
 
 LINE (90, 84)-STEP(16, 25), bgcolor, BF
 LINE (214, 84)-STEP(16, 25), bgcolor, BF

 FOR i = 5 TO 1 STEP -1
   IF lside(i) <> 0 THEN PUT (90, (i * 2) + 82), card(0), PSET
  IF rside(i) <> 0 THEN PUT (214, (i * 2) + 82), card(0), PSET
 NEXT i
 
 PUT (126, 92), card(lmid * 150), PSET
 PUT (178, 92), card(rmid * 150), PSET

 CALL DoMouse(mover, mup, 0)

END SUB

SUB FadeIn

 FOR a = 1 TO 62
  FOR c = 0 TO 255
   OUT &H3C7, c: r = INP(&H3C9): g = INP(&H3C9): B = INP(&H3C9)
   IF r < palhold(c, 1) THEN r = r + 1
   IF g < palhold(c, 2) THEN g = g + 1
   IF B < palhold(c, 3) THEN B = B + 1
   OUT &H3C8, c: OUT &H3C9, r: OUT &H3C9, g: OUT &H3C9, B
  NEXT c
  WAIT &H3DA, 8
 NEXT a

END SUB

SUB FadeOut

 FOR i = 0 TO 255
  OUT &H3C7, i: r = INP(&H3C9): g = INP(&H3C9): B = INP(&H3C9)
  palhold(i, 1) = r
  palhold(i, 2) = g
  palhold(i, 3) = B
 NEXT i

 FOR a = 1 TO 62
  FOR c = 0 TO 255
   OUT &H3C7, c: r = INP(&H3C9): g = INP(&H3C9): B = INP(&H3C9)
   IF r > 0 THEN r = r - 1
   IF g > 0 THEN g = g - 1
   IF B > 0 THEN B = B - 1
   OUT &H3C8, c: OUT &H3C9, r: OUT &H3C9, g: OUT &H3C9, B
  NEXT c
  WAIT &H3DA, 8
 NEXT a

END SUB

SUB HighScores

ShowHighScores:

 CALL FadeOut
 CLS : CALL PalLoad("speed.pal")
 CALL FadeOut

 REDIM pic(1500)
 CALL LoadPic("buttons2.spd", pic())
 PUT (135, 140), pic, PSET
 REDIM pic(0)

 CoolPrint 100, 5, "High Scores", 2
 CoolPrint 100, 13, "===========", 2

 CoolPrint 5, 23, "Names", 4: CoolPrint 5, 31, "-----", 4
 CoolPrint 210, 23, "Seconds", 4: CoolPrint 210, 31, "-------", 4
 CoolPrint 280, 23, "Score", 4: CoolPrint 280, 31, "-----", 4

 ON ERROR GOTO NewInputFile

 OPEN "scores.spd" FOR INPUT AS #1
  FOR i = 1 TO 10
   INPUT #1, guyname$, seconds, score
   IF haderror = 1 THEN
    OPEN "scores.spd" FOR INPUT AS #1
    INPUT #1, guyname$, seconds, score
    haderror = 0
   END IF
   CoolPrint 5, 40 + ((i - 1) * 8), guyname$, 6
   CoolPrint 210, 40 + ((i - 1) * 8), STR$(seconds), 6
   CoolPrint 280, 40 + ((i - 1) * 8), STR$(score), 6
  NEXT i
 CLOSE #1
 
 CALL DoMouse(mover, mup, 0)
 CALL FadeIn

 quitit = 0: mp = 1
 DO
  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)
 
  IF mbut = 1 AND mp = 0 THEN
   IF CB(135, 140, 185, 159) = 1 THEN
    mp = 1
    OPEN "scores.spd" FOR OUTPUT AS #1
    FOR i = 1 TO 10
     WRITE #1, "Nobody", 1000, 1000
    NEXT i
    CLOSE #1
    mp = 1
    GOTO ShowHighScores
   END IF
   IF CB(135, 160, 185, 179) = 1 THEN quitit = 1
  END IF
 
  IF mbut = 0 THEN mp = 0

  key$ = INKEY$
 LOOP UNTIL key$ = CHR$(27) OR quitit <> 0


END SUB

SUB LoadMainPic

 REDIM tempa(32000)
 DEF SEG = VARSEG(tempa(0)): BLOAD "menu.spd", VARPTR(tempa(0)): DEF SEG
 PUT (1, 1), tempa
 REDIM tempa(0)

END SUB

SUB LoadPic (nfile$, darray())

 ff = FREEFILE
 OPEN nfile$ FOR BINARY AS ff
  GET ff, , xx: GET ff, , yy
  lb = LBOUND(darray)
  DEF SEG = VARSEG(darray(lb))
  ptr& = VARPTR(darray(lb))
  pline$ = SPACE$((xx * yy) + 4)
  GET ff, , pline$
  FOR aa = 1 TO ((xx * yy) + 4)
   pl = ASC(MID$(pline$, aa, 1))
   POKE ptr&, pl
   ptr& = ptr& + 1
  NEXT aa
 CLOSE ff
 DEF SEG

END SUB

SUB Mouse (mup, mover, mbut)

 DEF SEG = VARSEG(mouseCode(0))

 POKE VARPTR(mouseCode(4)), &H92
 CALL ABSOLUTE(mup, VARPTR(mouseCode(0)))
   
 POKE VARPTR(mouseCode(4)), &H91
 CALL ABSOLUTE(mover, VARPTR(mouseCode(0)))
   
 mover = mover / 2

 POKE VARPTR(mouseCode(4)), &H93
 CALL ABSOLUTE(mbut, VARPTR(mouseCode(0)))

 DEF SEG

END SUB

SUB MouseInit

 DEF SEG = VARSEG(mouseCode(0))
 FOR i = 0 TO 17
  READ r: POKE VARPTR(mouseCode(0)) + i, r
 NEXT i

 CALL MousePointer(0)
 CALL MousePointer(3)

 DEF SEG

 mt = 0

 FOR i = 1 TO 12
  READ pnt$
  FOR a = 1 TO 9
   IF MID$(pnt$, a, 1) = "1" THEN PSET (a - 1, i - 1), 15
   IF MID$(pnt$, a, 1) = "2" THEN PSET (a - 1, i - 1), 1
  NEXT a
 NEXT i
 GET (0, 0)-(8, 11), arrow
 FOR i = 1 TO 12
  FOR a = 1 TO 9
   IF POINT(a - 1, i - 1) = 0 THEN PSET (a - 1, i - 1), 255
  NEXT a
 NEXT i
 GET (0, 0)-(8, 11), amask

 FOR i = 1 TO 12
  FOR a = 1 TO 9
   IF POINT(a - 1, i - 1) = 255 THEN PSET (a - 1, i - 1), 0
   IF POINT(a - 1, i - 1) = 15 THEN PSET (a - 1, i - 1), 150
  NEXT a
 NEXT i
 GET (0, 0)-(8, 11), menua
 FOR i = 1 TO 12
  FOR a = 1 TO 9
   IF POINT(a - 1, i - 1) = 0 THEN PSET (a - 1, i - 1), 255
  NEXT a
 NEXT i
 GET (0, 0)-(8, 11), mmask

 LINE (0, 0)-(8, 11), 0, BF

END SUB

SUB MousePointer (mtype)

 POKE VARPTR(mouseCode(0)) + 1, mtype
 CALL ABSOLUTE(c, VARPTR(mouseCode(0)))

END SUB

SUB OnePlayer

StartOnePlayer:

 DIM gametime AS SINGLE

 curPlayer = 0: sides = 0: quitit = 0: mt = 0

 CALL FadeOut
 CLS : CALL PalLoad("speed.pal")
 CALL FadeOut
 CALL SetupCards
 CALL SetupGame
 pcards(6) = player(6): player(6) = 0
 pcards(7) = player(7): player(7) = 0
 CALL OnePlayerBoard
 CALL ShowSideButtons
 CALL DoMouse(mover, mup, 0)
 CALL ShowOneHand
 CALL FadeIn

 REDIM readyback(1000), ready(1000)
 PUT (mover, mup), aback, PSET
 GET (140, 70)-(180, 114), readyback
 CALL LoadPic("ready.spd", ready())
 PUT (140, 70), ready, PSET
 CALL DoMouse(mover, mup, 0)
 DO
  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)
  IF mbut = 1 THEN IF CB(149, 93, 171, 109) = 1 THEN quitit = 1
 LOOP UNTIL quitit <> 0
 PUT (mover, mup), aback, PSET
 PUT (140, 70), readyback, PSET
 REDIM readyback(0), ready(0)
 CALL DoMouse(mover, mup, 0)

 quitit = 0: gt! = TIMER

 DO

  gametime = INT((TIMER - gt!) * 10) / 10

  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)

  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(95, 130, 111, 146) = 1 THEN SWAP mt, pcards(1): um = 1
   IF CB(114, 130, 130, 146) = 1 THEN SWAP mt, pcards(2): um = 1
   IF CB(133, 130, 149, 146) = 1 THEN SWAP mt, pcards(3): um = 1
   IF CB(152, 130, 168, 146) = 1 THEN SWAP mt, pcards(4): um = 1
   IF CB(171, 130, 187, 146) = 1 THEN SWAP mt, pcards(5): um = 1
   IF CB(190, 130, 206, 146) = 1 THEN SWAP mt, pcards(6): um = 1
   IF CB(209, 130, 225, 146) = 1 THEN SWAP mt, pcards(7): um = 1
   IF um = 1 THEN CALL ShowOneHand
   IF um = 0 THEN mp = 0
  END IF

  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(110, 74, 156, 121) = 1 THEN CALL CompareOne(1): um = 1
   IF CB(155, 74, 210, 121) = 1 THEN CALL CompareOne(2): um = 1
   IF um = 1 THEN
    PUT (mover, mup), aback, PSET
    PUT (126, 92), card(lmid * 150), PSET
    PUT (178, 92), card(rmid * 150), PSET
    CALL DoMouse(mover, mup, 0)
   END IF
   IF um = 0 THEN mp = 0
  END IF

  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(90, 84, 106, 109) = 1 THEN IF sides < 5 THEN um = 1
   IF CB(214, 84, 230, 109) = 1 THEN IF sides < 5 THEN um = 1
   IF um = 1 THEN CALL DoSides
   IF um = 0 THEN mp = 0
  END IF

  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(8, 70, 57, 89) = 1 THEN mp = 0: GOTO StartOnePlayer
   IF CB(8, 89, 57, 109) = 1 THEN quitit = 1: um = 1
   IF um = 0 THEN mp = 0
  END IF

  LOCATE 2, 3: PRINT "Time: "; gametime
  IF INT(gametime) = gametime THEN
   gt$ = STR$(INT(gametime))
   LOCATE 2, 9 + LEN(gt$): PRINT ".0"
  END IF

  IF curPlayer = 20 THEN quitit = 2

  CALL CheckPlayerGo
  IF playergo = 0 AND sides = 5 THEN quitit = 2
 
  IF mbut = 0 THEN mp = 0
  key$ = INKEY$
 LOOP UNTIL key$ = CHR$(27) OR quitit <> 0

 PUT (mover, mup), aback, PSET

 FOR i = 45 TO 0 STEP -1
  LINE (150 - (i * 2), 103 + i)-(170 + (i * 2), 89 - i), (i + 19) * 3, BF
  LINE (151 - (i * 2), 102 + i)-(169 + (i * 2), 90 - i), ((i + 19) * 3) - 2, BF
 NEXT i

 gscore = CINT(gametime) + ((20 - curPlayer) * 5)
 LOCATE 12, 16: PRINT "Game over"
 LOCATE 13, 13: PRINT "Your score is:";
 PRINT gscore

 ON ERROR GOTO NewInputFile

 OPEN "scores.spd" FOR INPUT AS #1
  FOR i = 1 TO 10
   INPUT #1, temps$(i), ti(i), scores(i)
   IF haderror = 1 THEN
    OPEN "scores.spd" FOR INPUT AS #1
    INPUT #1, temps$(i), ti(i), scores(i)
    haderror = 0
   END IF
  NEXT i
 CLOSE #1
 newscore = 0
 FOR i = 10 TO 1 STEP -1
  IF gscore < scores(i) THEN newscore = i
  IF gscore = scores(i) AND gametime < ti(i) THEN newscore = i
 NEXT i

 IF newscore > 0 THEN
 
  LOCATE 14, 13: PRINT "New high score!"
  LOCATE 15, 10: INPUT "Your name: ", guyname$
 
  FOR i = 9 TO newscore STEP -1
   temps$(i + 1) = temps$(i): ti(i + 1) = ti(i): scores(i + 1) = scores(i)
  NEXT i
  temps$(newscore) = guyname$
  ti(newscore) = gametime
  scores(newscore) = gscore
 
  OPEN "scores.spd" FOR OUTPUT AS #2
   FOR i = 1 TO 10
    WRITE #2, temps$(i), ti(i), scores(i)
   NEXT i
  CLOSE #2
 
  CALL HighScores
  CALL FadeOut: CLS
  PAINT (160, 100), bgcolor
  CALL ShowSideButtons
  CALL FadeIn
 END IF

 CALL DoMouse(mover, mup, 0)

 DO
  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)
  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(8, 70, 57, 89) = 1 THEN mp = 0: GOTO StartOnePlayer
   IF CB(8, 89, 57, 109) = 1 THEN quitit = 1: um = 1
   IF um = 0 THEN mp = 0
  END IF
  IF mbut = 0 THEN mp = 0
  key$ = INKEY$
 LOOP UNTIL key$ = CHR$(27) OR quitit = 1
 mt = 0


END SUB

SUB OnePlayerBoard

 WAIT &H3DA, 8

 PAINT (15, 15), bgcolor

 FOR i = curPlayer + 7 TO 19
  PUT ((i * 8) + 40, 160), card(0), PSET
 NEXT i

 PUT (126, 92), card(lmid * 150), PSET
 PUT (178, 92), card(rmid * 150), PSET

 FOR i = 5 TO 1 STEP -1
   IF lside(i) <> 0 THEN PUT (90, (i * 2) + 82), card(0), PSET
  IF rside(i) <> 0 THEN PUT (214, (i * 2) + 82), card(0), PSET
 NEXT i

 FOR i = 1 TO 7
  PUT ((i * 19) + 76, 130), card(pcards(i) * 150), PSET
  LINE ((i * 19) + 75, 129)-STEP(17, 17), bgcolor - 1, B
 NEXT i

END SUB

SUB Options

 quitit = 0

 CALL FadeOut
 CLS : CALL PalLoad("speed.pal")
 CALL FadeOut
 CALL SetupOptions
 CALL DoMouse(mover, mup, 0)
 CALL FadeIn

 DO

  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)

  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
  
   IF CB(218, -1, 319, 10) = 1 THEN quitit = 1: um = 1
  
   IF CB(147, 25, 171, 33) = 1 THEN playvscomp = 0: um = 1: lx = 147: ly = 33: sx = 23: sy = 8
   IF CB(147, 33, 171, 41) = 1 THEN playvscomp = 1: um = 1: lx = 147: ly = 25: sx = 23: sy = 8
  
   IF CB(179, 48, 202, 56) = 1 THEN seecomp = (seecomp + 1) MOD 2: um = 1: lx = 179: ly = 48: sx = 23: sy = 8
                                           
   IF CB(155, 72, 172, 108) = 1 THEN
    hardness = (108 - mup) * 10
    WAIT &H3DA, 8: PUT (mover, mup), aback, PSET
    LINE (155, 71)-STEP(23, 40), 0, BF
    LINE (171, 87)-STEP(22, 8), 0, BF
    CoolPrint 171, 87, STR$(hardness / 10), 0
    LINE (155, 73)-(172, 107), 4, BF
    LINE (155, 108 - (hardness / 10))-STEP(17, 0), 166
    GET (mover, mup)-(mover + 8, mup + 11), aback
    PUT (mover, mup), arrow, OR: PUT (mover, mup), amask, AND
   END IF
  
   IF CB(67, 126, 90, 198) = 1 THEN
    lx = 67: ly = 124: sx = 23: sy = 72: um = 1
    SELECT CASE mup
     CASE IS < 132: bgcolor = 94
     CASE IS < 140: bgcolor = 166
     CASE IS < 148: bgcolor = 22
     CASE IS < 156: bgcolor = 134
     CASE IS < 164: bgcolor = 151
     CASE IS < 172: bgcolor = 214
     CASE IS < 180: bgcolor = 138
     CASE IS < 188: bgcolor = 15
     CASE IS < 199: bgcolor = 0
    END SELECT
   END IF
  
   IF CB(276, 90, 299, 98) = 1 THEN joker = (joker + 1) MOD 2: um = 1: lx = 276: ly = 90: sx = 23: sy = 8
  
   IF CB(176, 134, 199, 143) = 1 THEN deck = 1: um = 1: lx = 176: ly = 134: sx = 120: sy = 8
   IF CB(224, 134, 247, 143) = 1 THEN deck = 2: um = 1: lx = 176: ly = 134: sx = 120: sy = 8
   IF CB(272, 134, 295, 143) = 1 THEN deck = 3: um = 1: lx = 176: ly = 134: sx = 120: sy = 8

   IF um = 1 THEN
    WAIT &H3DA, 8: PUT (mover, mup), aback, PSET
    LINE (lx, ly)-STEP(sx, sy), 0, BF
    CALL SetupOptions
    GET (mover, mup)-(mover + 8, mup + 11), aback
    PUT (mover, mup), arrow, OR: PUT (mover, mup), amask, AND
   END IF
   IF um = 0 THEN mp = 0
  END IF
 
  IF mbut = 0 THEN mp = 0

  key$ = INKEY$
 LOOP UNTIL key$ = CHR$(27) OR quitit = 1

END SUB

SUB PalLoad (palname$)

 Bc$ = " ": ff = FREEFILE
 OPEN palname$ FOR BINARY AS ff
  FOR i% = 0 TO 255
   OUT &H3C8, i%
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
  NEXT i%
 CLOSE ff

END SUB

SUB PlayerVSComp

StartPlayComp:

 curComp = 0: curPlayer = 0: mt = 0
 compmid = INT(hardness / 2)
 sides = 0: compgo = 1: quitit = 0

 CALL FadeOut
 CLS : CALL PalLoad("speed.pal")
 CALL FadeOut
 CALL SetupCards
 CALL SetupGame
 CALL DisplayBoard
 CALL ShowSideButtons
 CALL DoMouse(mover, mup, 0)
 CALL ShowHand
 CALL FadeIn

 REDIM readyback(1000), ready(1000)
 PUT (mover, mup), aback, PSET
 GET (140, 70)-(180, 114), readyback
 CALL LoadPic("ready.spd", ready())
 PUT (140, 70), ready, PSET
 CALL DoMouse(mover, mup, 0)
 DO
  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)
  IF mbut = 1 THEN IF CB(149, 93, 171, 109) = 1 THEN quitit = 1
 LOOP UNTIL quitit <> 0
 PUT (mover, mup), aback, PSET
 PUT (140, 70), readyback, PSET
 REDIM readyback(0), ready(0)
 CALL DoMouse(mover, mup, 0)

 quitit = 0

 DO

  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)
 
  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(114, 130, 130, 146) = 1 THEN SWAP mt, pcards(1): um = 1
   IF CB(133, 130, 149, 146) = 1 THEN SWAP mt, pcards(2): um = 1
   IF CB(152, 130, 168, 146) = 1 THEN SWAP mt, pcards(3): um = 1
   IF CB(171, 130, 187, 146) = 1 THEN SWAP mt, pcards(4): um = 1
   IF CB(190, 130, 206, 146) = 1 THEN SWAP mt, pcards(5): um = 1
   IF um = 1 THEN CALL ShowHand
   IF um = 0 THEN mp = 0
  END IF
 
  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(110, 74, 156, 121) = 1 THEN CALL CompareCards(1): um = 1
   IF CB(155, 74, 210, 121) = 1 THEN CALL CompareCards(2): um = 1
   IF um = 1 THEN
    PUT (mover, mup), aback, PSET
    PUT (126, 92), card(lmid * 150), PSET
    PUT (178, 92), card(rmid * 150), PSET
    CALL DoMouse(mover, mup, 0)
   END IF
   IF um = 0 THEN mp = 0
  END IF
 
  IF mbut = 1 AND mp = 0 AND compgo = 0 THEN
   mp = 1: um = 0
   IF CB(90, 84, 106, 109) = 1 THEN IF sides < 5 THEN um = 1
   IF CB(214, 84, 230, 109) = 1 THEN IF sides < 5 THEN um = 1
   IF um = 1 THEN CALL DoSides
   IF um = 0 THEN mp = 0
  END IF
 
  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(8, 70, 57, 89) = 1 THEN mp = 0: GOTO StartPlayComp
   IF CB(8, 89, 57, 109) = 1 THEN quitit = 1: um = 1
   IF um = 0 THEN mp = 0
  END IF

  IF INT(RND * hardness) + 1 = compmid THEN CALL CompTurn
 
  CALL CheckCompGo
 
  IF compgo = 0 THEN
   PUT (135, 1), cs, PSET
  ELSEIF compgo = 1 THEN
   LINE (135, 1)-(183, 17), bgcolor, BF
  END IF
 
  IF curPlayer = 20 THEN quitit = 2
  IF curComp = 20 THEN quitit = 3
 
  IF mbut = 0 THEN mp = 0
 
  key$ = INKEY$
 LOOP UNTIL key$ = CHR$(27) OR quitit <> 0

 IF quitit > 1 THEN
  PUT (mover, mup), aback, PSET

  IF quitit = 2 THEN
   FOR i = 16 TO 218 STEP 2
    CIRCLE (160, 99), (i - 16) / 2, i, , , .63
    CIRCLE (161, 99), (i - 16) / 2, i, , , .63
    CIRCLE (159, 99), (i - 16) / 2, i, , , .63
    CIRCLE (160, 98), (i - 16) / 2, i, , , .63
    CIRCLE (160, 100), (i - 16) / 2, i, , , .63
   NEXT i
   CIRCLE (160, 99), (i - 16) / 2, i + 2, , , .63
   LOCATE 13, 17: PRINT "You won!"
  ELSE
   c1 = 0: c2 = 0
   FOR i = 45 TO 0 STEP -1
    LINE (160 - (i * 2), 99 + i)-(160 + (i * 2), 99 - i), c1, BF
    IF c2 = 0 THEN c1 = c1 + 1
    IF c2 = 1 THEN c1 = c1 - 1
    IF c1 = 15 THEN c2 = 1
    IF c1 = 0 THEN c2 = 0
   NEXT i
   LOCATE 13, 17: PRINT "You lost"
  END IF
 
  CALL DoMouse(mover, mup, 0)
 END IF

 DO

  mo = mover: mu = mup: CALL Mouse(mup, mover, mbut)
  IF mt = 0 THEN CALL CheckBound(0, 311, 0, 188)
  IF mt <> 0 THEN CALL CheckBound(0, 304, 0, 184)
  WAIT &H3DA, 8
  IF mo <> mover OR mu <> mup THEN CALL DoMouse(mo, mu, 1)
 
  IF mbut = 1 AND mp = 0 THEN
   mp = 1: um = 0
   IF CB(8, 70, 57, 89) = 1 THEN mp = 0: GOTO StartPlayComp
   IF CB(8, 89, 57, 109) = 1 THEN quitit = 1: um = 1
   IF um = 0 THEN mp = 0
  END IF
 
  IF mbut = 0 THEN mp = 0

  key$ = INKEY$
 LOOP UNTIL key$ = CHR$(27) OR quitit = 1

 mt = 0

END SUB

SUB SetupCards

 DIM pic(2000)

 IF deck = 1 THEN
  CALL LoadPic("plain1.spd", pic()): PUT (0, 0), pic, PSET
  CALL LoadPic("plain2.spd", pic()): PUT (0, 50), pic, PSET
 ELSEIF deck = 2 THEN
  CALL LoadPic("big1.spd", pic()): PUT (0, 0), pic, PSET
  CALL LoadPic("big2.spd", pic()): PUT (0, 50), pic, PSET
 ELSEIF deck = 3 THEN
  CALL LoadPic("plasma1.spd", pic()): PUT (0, 0), pic, PSET
  CALL LoadPic("plasma2.spd", pic()): PUT (0, 50), pic, PSET
 END IF

 GET (34, 67)-(49, 82), card(0)        ' deck backing
 GET (0, 67)-(15, 82), card(1 * 150)   ' ace

 GET (0, 0)-(15, 15), card(2 * 150)    ' two
 GET (17, 0)-(32, 15), card(3 * 150)   ' three
 GET (34, 0)-(49, 15), card(4 * 150)   ' four

 GET (0, 17)-(15, 32), card(5 * 150)   ' five
 GET (17, 17)-(32, 32), card(6 * 150)  ' six
 GET (34, 17)-(49, 32), card(7 * 150)  ' seven

 GET (0, 34)-(15, 49), card(8 * 150)   ' eight
 GET (17, 34)-(32, 49), card(9 * 150)  ' nine
 GET (34, 34)-(49, 49), card(10 * 150) ' ten

 GET (0, 50)-(15, 65), card(11 * 150)  ' jack
 GET (17, 50)-(32, 65), card(12 * 150) ' queen
 GET (34, 50)-(49, 65), card(13 * 150) ' king

 GET (17, 67)-(32, 82), card(14 * 150) ' joker

END SUB

SUB SetupGame

 CLS

 DIM unused(1 TO 14, 1 TO 4)              'make temp array for setting
 FOR i = 1 TO 14                          ' up what has what cards, set
  FOR j = 1 TO 4                          ' to 1 for default not used
   unused(i, j) = 1
  NEXT j
 NEXT i
 unused(14, 3) = 0: unused(14, 4) = 0

 FOR time1 = 1 TO 2
  total = 0
  DO
   DO
    IF joker = 0 THEN ranCard = INT(RND * 13) + 1    'get a random card
    IF joker = 1 THEN ranCard = INT(RND * 14) + 1    'get a random card
    yesCard = 0
    i = 1
    DO
     IF unused(ranCard, i) = 1 THEN            'if unused, use it
      unused(ranCard, i) = 0                   'mark it as used
      yesCard = 1
     END IF
     i = i + 1
    LOOP UNTIL i = 5 OR yesCard = 1
   LOOP UNTIL yesCard = 1
   total = total + 1
   IF time1 = 1 THEN computer(total) = ranCard   'assign the card a position
   IF time1 = 2 THEN player(total) = ranCard
  LOOP UNTIL total = 20
 NEXT time1

 FOR time1 = 1 TO 2
  total = 0
  DO
   DO
    IF joker = 0 THEN ranCard = INT(RND * 13) + 1    'get a random card
    IF joker = 1 THEN ranCard = INT(RND * 14) + 1    'get a random card
    yesCard = 0
    i = 1
    DO
     IF unused(ranCard, i) = 1 THEN
      unused(ranCard, i) = 0
      yesCard = 1
     END IF
     i = i + 1
    LOOP UNTIL i = 5 OR yesCard = 1
   LOOP UNTIL yesCard = 1
   total = total + 1
   IF time1 = 1 THEN lside(total) = ranCard
   IF time1 = 2 THEN rside(total) = ranCard
  LOOP UNTIL total = 5
 NEXT time1

 count = 0
 FOR i = 1 TO 13
  FOR j = 1 TO 4
   IF unused(i, j) = 1 THEN
    IF count = 0 THEN rmid = i: count = 1
    IF count = 1 THEN lmid = i
   END IF
  NEXT j
 NEXT i

 FOR i = 1 TO 5
  ccards(i) = computer(i): computer(i) = 0
  pcards(i) = player(i): player(i) = 0
 NEXT i

END SUB

SUB SetupOptions

 CoolPrint 9, 5, "Options", 1                      ' Options title
 CoolPrint 9, 12, "=======", 2

 CoolPrint 220, 2, "Back to Menu", 254             ' Exit Options
 LINE (218, 0)-(316, 10), 252, B

 IF playvscomp = 1 THEN                            ' Play vs computer
  CoolPrint 3, 25, "Play for speed:   [ ]", 4
  CoolPrint 3, 33, "Play vs Computer: [*]", 4
 ELSE
  CoolPrint 3, 25, "Play for speed:   [*]", 4
  CoolPrint 3, 33, "Play vs Computer: [ ]", 4
 END IF

 IF seecomp = 0 THEN
  CoolPrint 3, 48, "See Computer's Cards: [ ]", 3
 ELSE
  CoolPrint 3, 48, "See Computer's Cards: [*]", 3
 END IF

 CoolPrint 3, 63, "Computer's Skill:", 6
 CoolPrint 3, 71, " Super Slow!!!!!:", 0
 CoolPrint 3, 79, " Grandmother:", 0
 CoolPrint 3, 87, " Average:", 0
 CoolPrint 3, 95, " Pretty Speedy:", 0
 CoolPrint 3, 103, " What the #@%$*!:", 0
 CoolPrint 171, 87, STR$(hardness / 10), 0
 LINE (155, 73)-(172, 107), 4, BF
 LINE (155, 108 - (hardness / 10))-STEP(17, 0), 166

 CoolPrint 3, 116, "Background Color:", 1
 CoolPrint 3, 124, " Green  [ ]", 94
 CoolPrint 3, 132, " Red    [ ]", 166
 CoolPrint 3, 140, " Blue   [ ]", 22
 CoolPrint 3, 148, " Yellow [ ]", 134
 CoolPrint 3, 156, " Orange [ ]", 151
 CoolPrint 3, 164, " Purple [ ]", 214
 CoolPrint 3, 172, " Brown  [ ]", 138
 CoolPrint 3, 180, " White  [ ]", 15
 CoolPrint 3, 188, " Black  [ ]", 7
 SELECT CASE bgcolor
  CASE 94: CoolPrint 3, 124, " Green  [*]", 94
  CASE 166: CoolPrint 3, 132, " Red    [*]", 166
  CASE 22: CoolPrint 3, 140, " Blue   [*]", 22
  CASE 134: CoolPrint 3, 148, " Yellow [*]", 134
  CASE 151: CoolPrint 3, 156, " Orange [*]", 151
  CASE 214: CoolPrint 3, 164, " Purple [*]", 214
  CASE 138: CoolPrint 3, 172, " Brown  [*]", 138
  CASE 15: CoolPrint 3, 180, " White  [*]", 15
  CASE 0: CoolPrint 3, 188, " Black  [*]", 7
 END SELECT

 CoolPrint 220, 82, "Joker's are", 5
 CoolPrint 220, 90, "wild:  [ ]", 5
 IF joker = 1 THEN CoolPrint 220, 90, "wild:  [*]", 5
 
 CoolPrint 160, 125, "Deck Style:", 4

 REDIM pic(2000)
 IF deck = 1 THEN
  CoolPrint 160, 134, " 1[*]  2[ ]  3[ ]:", 4
  CALL LoadPic("plain1.spd", pic()): PUT (166, 148), pic, PSET
  CALL LoadPic("plain2.spd", pic()): PUT (217, 148), pic, PSET
 ELSEIF deck = 2 THEN
  CoolPrint 160, 134, " 1[ ]  2[*]  3[ ]:", 4
  CALL LoadPic("big1.spd", pic()): PUT (166, 148), pic, PSET
  CALL LoadPic("big2.spd", pic()): PUT (217, 148), pic, PSET
 ELSEIF deck = 3 THEN
  CoolPrint 160, 134, " 1[ ]  2[ ]  3[*]:", 4
  CALL LoadPic("plasma1.spd", pic()): PUT (166, 148), pic, PSET
  CALL LoadPic("plasma2.spd", pic()): PUT (217, 148), pic, PSET
 END IF
 REDIM pic(0)

END SUB

SUB ShowCompHand

 PUT (mover, mup), aback, PSET

 FOR i = 1 TO 5
  IF ccards(i) <> 0 THEN
   IF seecomp = 1 THEN
    PUT ((i * 19) + 95, 50), card(ccards(i) * 150), PSET
   ELSE
    PUT ((i * 19) + 95, 50), card(0), PSET
   END IF
  ELSE
   LINE ((i * 19) + 95, 50)-STEP(15, 15), bgcolor, BF
  END IF
 NEXT i

 CALL DoMouse(mover, mup, 0)

END SUB

SUB ShowHand

 PUT (mover, mup), aback, PSET
 
 FOR i = 1 TO 5
  IF pcards(i) <> 0 THEN
   PUT ((i * 19) + 95, 130), card(pcards(i) * 150), PSET
  ELSE
   LINE ((i * 19) + 95, 130)-STEP(15, 15), bgcolor, BF
  END IF
 NEXT i

 CALL DoMouse(mover, mup, 0)

END SUB

SUB ShowOneHand

 PUT (mover, mup), aback, PSET

 FOR i = 1 TO 7
  IF pcards(i) <> 0 THEN
   PUT ((i * 19) + 76, 130), card(pcards(i) * 150), PSET
  ELSE
   LINE ((i * 19) + 76, 130)-STEP(15, 15), bgcolor, BF
  END IF
 NEXT i

 CALL DoMouse(mover, mup, 0)

END SUB

SUB ShowSideButtons

 REDIM pic(1500)
 
 CALL LoadPic("buttons1.spd", pic())
 PUT (8, 70), pic, PSET
 LINE (8, 89)-STEP(49, 0), bgcolor

 REDIM pic(0)


END SUB

SUB TimeIt (lent%)

 DEF SEG = 0
 DO UNTIL lent < 1
  CurrentTick% = PEEK(&H46C)
  DO WHILE CurrentTick% = PEEK(&H46C): LOOP
  lent = lent - 1
 LOOP

END SUB

