'$DYNAMIC
DEFINT A-Z
'$INCLUDE: 'STARSHOT.BI'

ERRTRAK$ = "SUB MODULE"

kbisrdata:
DATA &HE9,&H1D,&H00,&HE9,&H3C,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00
DATA &H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00,&H00
DATA &H00,&H00,&H00,&H00,&H1E,&H31,&HC0,&H8E,&HD8,&HBE,&H24,&H00,&H0E,&H07
DATA &HBF,&H14,&H00,&HFC,&HA5,&HA5,&H8C,&HC3,&H8E,&HC0,&HBF,&H24,&H00,&HB8
DATA &H56,&H00,&HFA,&HAB,&H89,&HD8,&HAB,&HFB,&H1F,&HCB,&H1E,&H31,&HC0,&H8E
DATA &HC0,&HBF,&H24,&H00,&HBE,&H14,&H00,&H0E,&H1F,&HFC,&HFA,&HA5,&HA5,&HFB
DATA &H1F,&HCB,&HFB,&H9C,&H50,&H53,&H51,&H52,&H1E,&H56,&H06,&H57,&HE4,&H60
DATA &HB4,&H01,&HA8,&H80,&H74,&H04,&HB4,&H00,&H24,&H7F,&HD0,&HE0,&H88,&HC3
DATA &HB7,&H00,&HB0,&H00,&H2E,&H03,&H1E,&H12,&H00,&H2E,&H8E,&H1E,&H10,&H00
DATA &H86,&HE0,&H89,&H07,&HE4,&H61,&H0C,&H82,&HE6,&H61,&H24,&H7F,&HE6,&H61
DATA &HB0,&H20,&HE6,&H20,&H5F,&H07,&H5E,&H1F,&H5A,&H59,&H5B,&H58,&H9D,&HCF
DATA -1

dmadata:
DATA 135,131,129,130,143,139,137,&h8A

QUIT:
PRINT
PRINT "Sorry. The correct way to run Star Shot is by typing STARSHOT"
END


SBMIDIData:
DATA 156,30,6,80,83,81,82,87,86,85,139,236,80,184,14,16,142,216,142,192,88,131,78,24,1,199,70,12,255,255,128,62
DATA 68,1,0,117,59,198,6,68,1,1,251,252,11,219,120,21,129,251,13,0,115,37,131,102,24,254,209,227,255,151,40,0
DATA 137,70,12,235,22,247,219,75,129,251,3,0,115,13,131,102,24,254,209,227,255,151,34,0,137,70,12,198,6,68,1,0
DATA 93,94,95,90,89,91,88,7,31,157,207,156,250,30,6,80,184,14,16,142,216,142,192,161,145,1,1,6,28,0,114,6
DATA 176,32,230,32,235,9,255,6,28,0,156,255,30,18,0,83,81,82,87,86,85,139,236,250,128,62,67,1,0,117,54,140
DATA 22,32,0,137,38,30,0,140,216,142,208,188,66,1,198,6,67,1,1,251,252,131,62,133,1,0,116,10,128,62,21,3
DATA 0,117,3,232,143,4,250,139,38,30,0,142,22,32,0,198,6,67,1,0,251,93,94,95,90,89,91,88,7,31,157,207
DATA 30,6,80,83,81,82,87,86,85,156,184,14,16,142,216,142,192,228,96,10,192,120,18,60,83,117,14,180,2,205,22,36
SBSIMData:
DATA 46,143,6,134,1,46,143,6,132,1,46,143,6,130,1,46,131,14,130,1,1,46,131,62,110,1,0,116,6,184,1,0
DATA 233,193,0,128,255,5,119,25,10,255,116,27,81,80,51,192,138,207,128,225,127,249,211,208,46,35,6,126,1,88,89,117
DATA 6,184,2,0,233,157,0,250,46,140,30,138,1,14,31,140,22,140,1,137,38,142,1,142,22,152,1,139,38,154,1,85
DATA 139,236,86,87,6,83,163,144,1,137,22,148,1,137,14,146,1,180,98,205,33,137,30,150,1,180,80,140,203,205,33,199
DATA 6,110,1,1,0,251,252,50,192,255,30,118,1,139,94,248,83,134,251,3,219,3,219,50,255,254,14,124,1,117,11,129
DATA 6,152,1,0,0,198,6,124,1,20,139,243,91,50,255,30,7,255,156,176,1,114,5,131,38,130,1,254,250,199,6,110
DATA 1,0,0,80,180,80,139,30,150,1,205,33,88,91,7,95,94,139,229,93,139,14,146,1,142,22,140,1,139,38,142,1
DATA 142,30,138,1,46,255,54,130,1,46,255,54,132,1,46,255,54,134,1,207,85,139,236,131,236,10,137,70,248,137,94,250

REM $STATIC
DEFSNG A-Z
SUB BlastCLS (Segment%, Offset%, col%)
  ERRTRAK$ = "BlastCLS"
  DEF SEG = VARSEG(code6%(0))
  CALL Absolute(BYVAL Segment%, BYVAL Offset%, BYVAL col%, VARPTR(code6%(0)))
  DEF SEG
END SUB

SUB BlastCopy (fsegment%, foffset%, tsegment%, toffset%)
  ERRTRAK$ = "BlastCopy"
  IF tsegment% = &HA000 THEN WAIT &H3DA, 8
  DEF SEG = VARSEG(code1%(0))
  CALL Absolute(BYVAL fsegment%, BYVAL foffset%, BYVAL tsegment%, BYVAL toffset%, VARPTR(code1%(0)))
  DEF SEG
END SUB

SUB BlastGet (dsegment%, doffset%, ssegment%, soffset%, X1%, Y1%, x2%, y2%)
  ERRTRAK$ = "BlastGet"
  DEF SEG = VARSEG(code4%(0))
  CALL Absolute(BYVAL dsegment%, BYVAL doffset%, BYVAL ssegment%, BYVAL soffset%, BYVAL X1%, BYVAL Y1%, BYVAL x2%, BYVAL y2%, VARPTR(code4%(0)))
  DEF SEG
END SUB

SUB BlastLine (dsegment%, doffset%, X1%, Y1%, x2%, y2%, colr%)
  ERRTRAK$ = "BlastLine"
  DEF SEG = VARSEG(code8%(0))
  CALL Absolute(BYVAL dsegment%, BYVAL doffset%, BYVAL X1%, BYVAL Y1%, BYVAL x2%, BYVAL y2%, BYVAL colr%, VARPTR(code8%(0)))
  DEF SEG
END SUB

FUNCTION BlastPoint% (Segment%, Offset%, xpos%, ypos%)
  ERRTRAK$ = "BlastPoint"
  col% = 0
  DEF SEG = VARSEG(code7%(0))
  CALL Absolute(BYVAL Segment%, BYVAL Offset%, BYVAL xpos%, BYVAL ypos%, BYVAL VARSEG(col%), BYVAL VARPTR(col%), VARPTR(code7%(0)))
  DEF SEG
  BlastPoint% = col%
END FUNCTION

SUB BlastPrint (Segment%, Offset%, xpos%, ypos%, TEXT$, col%)
  ERRTRAK$ = "BlastPrint"
  xx% = xpos% - 1
  yy% = ypos%
  FOR chr% = 1 TO LEN(TEXT$)
	xx% = xx% + 8
	ptr% = 8 * ASC(MID$(TEXT$, chr%, 1)) + &HE
	FOR L% = 0 TO 7
	  DEF SEG = &HFFA6: BitPattern% = PEEK(ptr% + L%): DEF SEG
	  IF BitPattern% AND 1 THEN CALL BlastPset(Segment%, Offset%, xx%, yy% + L%, col%)
	  IF BitPattern% AND 2 THEN CALL BlastPset(Segment%, Offset%, xx% - 1, yy% + L%, col%)
	  IF BitPattern% AND 4 THEN CALL BlastPset(Segment%, Offset%, xx% - 2, yy% + L%, col%)
	  IF BitPattern% AND 8 THEN CALL BlastPset(Segment%, Offset%, xx% - 3, yy% + L%, col%)
	  IF BitPattern% AND 16 THEN CALL BlastPset(Segment%, Offset%, xx% - 4, yy% + L%, col%)
	  IF BitPattern% AND 32 THEN CALL BlastPset(Segment%, Offset%, xx% - 5, yy% + L%, col%)
	  IF BitPattern% AND 64 THEN CALL BlastPset(Segment%, Offset%, xx% - 6, yy% + L%, col%)
	  IF BitPattern% AND 128 THEN CALL BlastPset(Segment%, Offset%, xx% - 7, yy% + L%, col%)
	NEXT
  NEXT
  DEF SEG
END SUB

SUB BlastPset (Segment%, Offset%, xpos%, ypos%, col%)
  ERRTRAK$ = "BlastPset"
  DEF SEG = VARSEG(code2%(0))
  CALL Absolute(BYVAL Segment%, BYVAL Offset%, BYVAL xpos%, BYVAL ypos%, BYVAL col%, VARPTR(code2%(0)))
  DEF SEG
END SUB

SUB BlastPut (dsegment%, doffset%, ssegment%, soffset%, xpos%, ypos%, icol%)
  ERRTRAK$ = "BlastPut"
  DEF SEG = VARSEG(code3%(0))
  CALL Absolute(BYVAL dsegment%, BYVAL doffset%, BYVAL ssegment%, BYVAL soffset%, BYVAL xpos%, BYVAL ypos%, BYVAL icol%, VARPTR(code3%(0)))
  DEF SEG
END SUB

DEFINT A-Z
SUB BossMusicParams
IF TimeMIDI! > 27.4 THEN RepeatBossMidi
END SUB

SUB Briefing
ERRTRAK$ = "Briefing"
SCREEN 0: WIDTH 80
PRINT "Approaching level"; LVL
PRINT "Location: "; LVLLOC$
PRINT "Bonus:"; BONUS
PRINT "Press a key to play"
DO: LOOP WHILE INKEY$ = ""
SCREEN 13
END SUB

DEFSNG A-Z
'BytesRequired - Returns the amount of memory needed to store a file.
FUNCTION BytesRequired& (Filename$)
ERRTRAK$ = "BytesRequired"
'Open the file.
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
'Store the length of the file.
FileLen& = LOF(FF%)
'Close the file.
CLOSE FF%
'If the length of the file is 0, assume it does not exist and delete it.
IF FileLen& = 0 THEN KILL Filename$
'Return the length of the file as the number of bytes required.
BytesRequired& = FileLen&
END FUNCTION

DEFINT A-Z
SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
ERRTRAK$ = "DriversLoaded"

'Check the interrupt handlers for int 80h-89h to see if they contain
'program code from either SBSIM or SBMIDI.  Only those 10 interrupts
'are checked because chances are slim that either driver will be loaded
'at int 8Ah or higher, and they will never load themselves below
'80h.

FOR i% = &H80 TO &H8A
	'Get the address of the interrupt handler.
	GetIntVector i%, Segment%, Offset%
	'If the address is null, then the interrupt is not in use, and can be
	'skipped.
	IF Segment% = 0 AND Offset% = 0 THEN GOTO Skip:
  
	'Point to the segment of the interrupt handler.
	DEF SEG = Segment%
	RESTORE SBMIDIData:
	FOR J% = 0 TO 255
		'Read a byte of the SBMIDI program code that has been previously
		'saved.
		READ Byte1%
		'Read a byte of code from the current interrupt handler.
		Byte2% = PEEK(Offset% + J%)
		'Do they match?  If so, we may have found SBMIDI!
		IF Byte1% = Byte2% THEN
			MatchSBMIDI% = 1
		'If not, this interrupt is definitely not occupied by SBMIDI.
		ELSE
			SELECT CASE J%
				CASE IS = 14, 15, 113, 114, 235, 236
				CASE ELSE
					MatchSBMIDI% = 0
					EXIT FOR
			END SELECT
		END IF
	NEXT J%
	'If there's a match, set SBMIDI% to the current interrupt.
	IF MatchSBMIDI% THEN SBMIDI% = i%
	RESTORE SBSIMData:
	FOR J% = 0 TO 255
		'Read a byte of the SBSIM program code that has been previously
		'saved.
		READ Byte1%
		'Read a byte of code from the current interrupt handler.
		Byte2% = PEEK(Offset% + J%)
		'If the values match, SBSIM may be loaded at this interrupt.
		IF Byte1% = Byte2% THEN
			MatchSBSIM% = 1
		'If not, then it isn't.
		ELSE
			MatchSBSIM% = 0
			EXIT FOR
		END IF
	NEXT J%
	'If this interrupt handler is a match, set SBSIM% to the current
	'interrupt number.
	IF MatchSBSIM% THEN SBSIM% = i%
  
	'If both SBMIDI% and SBSIM% have been detected, there's no need to
	'check the rest of the interrupt handling routines.
	IF MatchSBMIDI% AND MatchSBSIM% THEN EXIT FOR
Skip:
NEXT i%
END SUB

SUB EndText
ERRTRAK$ = "EndText"
IF TXTY > 40 AND TXTY < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY, "   After defeating the dread kahasu, you", 15
IF TXTY + (8 * 1) > 40 AND TXTY + (8 * 1) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 1), "feel great relief. You feel like a lot", 15
IF TXTY + (8 * 2) > 40 AND TXTY + (8 * 2) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 2), "of money and want to spend it. But you", 15
IF TXTY + (8 * 3) > 40 AND TXTY + (8 * 3) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 3), "didn't get a lot of money. You got your", 15
IF TXTY + (8 * 4) > 40 AND TXTY + (8 * 4) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 4), "fried rice. You win the fried rice. You", 15
IF TXTY + (8 * 5) > 40 AND TXTY + (8 * 5) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 5), "eat fried rice and be happy. You share", 15
IF TXTY + (8 * 6) > 40 AND TXTY + (8 * 6) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 6), "fried rice with friends and they happy.", 15
IF TXTY + (8 * 7) > 40 AND TXTY + (8 * 7) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 7), "                                        ", 15
IF TXTY + (8 * 8) > 40 AND TXTY + (8 * 8) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 8), "   What lies in the future is only begun", 15
IF TXTY + (8 * 9) > 40 AND TXTY + (8 * 9) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 9), "to be predicted. Crap, what of this is", 15
IF TXTY + (8 * 10) > 40 AND TXTY + (8 * 10) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 10), "that thing? What?", 15
IF TXTY + (8 * 11) > 40 AND TXTY + (8 * 11) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 11), "                                       ", 15
IF TXTY + (8 * 12) > 40 AND TXTY + (8 * 12) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 12), "   A big do, nut flies down and picks", 15
IF TXTY + (8 * 13) > 40 AND TXTY + (8 * 13) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 13), "you up. This is the end? What?", 15
IF TXTY + (8 * 14) > 40 AND TXTY + (8 * 14) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 14), "                                       ", 15
IF TXTY + (8 * 15) > 40 AND TXTY + (8 * 15) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 15), "   Only you will know. Is that, that is,", 15
IF TXTY + (8 * 16) > 40 AND TXTY + (8 * 16) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 16), "in Star Shot II, quest for the lost", 15
IF TXTY + (8 * 17) > 40 AND TXTY + (8 * 17) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 17), "do, nut.", 15
IF TXTY + (8 * 18) > 40 AND TXTY + (8 * 18) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 18), "                                       ", 15
IF TXTY + (8 * 19) > 40 AND TXTY + (8 * 19) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 19), "BIG NOTE: This game not Japanese. This", 15
IF TXTY + (8 * 20) > 40 AND TXTY + (8 * 20) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 20), "game spoof off Japanese crap game,", 15
IF TXTY + (8 * 21) > 40 AND TXTY + (8 * 21) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 21), "created by master creater LeBoneur of", 15
IF TXTY + (8 * 22) > 40 AND TXTY + (8 * 22) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 22), "Legendary software. I hope enjoyed you.", 15
IF TXTY + (8 * 23) > 40 AND TXTY + (8 * 23) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 23), "                                      ", 15
IF TXTY + (8 * 24) > 40 AND TXTY + (8 * 24) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 24), "               THE END", 15
IF TXTY + (8 * 25) > 40 AND TXTY + (8 * 25) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 25), "                                      ", 15
IF TXTY + (8 * 26) > 40 AND TXTY + (8 * 26) < 160 THEN BlastPrint VARSEG(SCRPAGE%(0)), VARPTR(SCRPAGE%(0)), 1, TXTY + (8 * 26), "(C) 1998 Legendary Software", 15
END SUB

SUB GetCommands
ERRTRAK$ = "GetCommands"
ON ERROR GOTO QUIT
OPEN "STARSHOT.TMP" FOR INPUT AS #1
INPUT #1, CMD$
CLOSE : KILL "STARSHOT.TMP"
TXT$ = CMD$
FOR F = 1 TO LEN(TXT$)
IF WSTART = 0 AND MID$(TXT$, F, 1) <> " " THEN WCOUNTER = WCOUNTER + 1: WSTART = 1
IF WSTART = 1 AND MID$(TXT$, F, 1) <> " " THEN WORDS$(WCOUNTER) = WORDS$(WCOUNTER) + MID$(TXT$, F, 1)
IF WSTART = 1 AND MID$(TXT$, F, 1) = " " THEN WSTART = 0
NEXT F
VALIDATION$ = WORDS$(1)
LVL = VAL(WORDS$(2))
SC! = VAL(WORDS$(3))
AMMO = VAL(WORDS$(4))
NRG = VAL(WORDS$(5))
PWRUPS = VAL(WORDS$(6))
EXIT SUB

END SUB

SUB GetIntVector (IntNum%, Segment%, Offset%) STATIC
ERRTRAK$ = "GetIntVector"
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
	asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&HCB)
	asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
	asm$ = asm$ + CHR$(&H60)
	asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
	GetIntVCodeLoaded% = 1
END IF
'Execute the code
DEF SEG = VARSEG(asm$)
CALL Absolute(IntNum%, Segment%, Offset%, SADD(asm$))
END SUB

SUB HiScoreChek
SCREEN 0: WIDTH 80

OPEN "DATA\HISCORE\STARSHOT.HSC" FOR INPUT AS #1
	INPUT #1, NAME$
	INPUT #1, SCTEMP!
	INPUT #1, LVLTEMP
CLOSE

IF SC! > SCTEMP! THEN
	PRINT "You got high score!!!"
	INPUT "Enter name: ", NAME$
	OPEN "DATA\HISCORE\STARSHOT.HSC" FOR OUTPUT AS #1
		PRINT #1, NAME$
		PRINT #1, SC!
		PRINT #1, LVL
	CLOSE
END IF
END SUB

DEFSNG A-Z
SUB InitLib
  ERRTRAK$ = "InitLib"
  code$ = "1E5589E58B460E8ED88B760C8B460A8EC08B7E08B9007DF3A55D1FCA0800"
  DEF SEG = VARSEG(code1%(0))
  FOR i% = 0 TO 29
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code1%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B46108ED88B760AB106D3E689F3B102D3E601DE8B5E0C01DE8B5E0E01DE8A460888045D1FCA0A00"
  DEF SEG = VARSEG(code2%(0))
  FOR i% = 0 TO 43
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code2%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B460C508B460A508B46108ED88B760E8B04B103D3E8508B5EFE"
  code$ = code$ + "01C3895EFE8B4402508B5EFC01C3895EFC83C60489760E89E58B46188ED8"
  code$ = code$ + "8B76168A04468976163A4610743DBB0000395E147C35395E127C30BB3F01"
  code$ = code$ + "395E147F28BBC700395E127F208B5E1C8EDB8B7612B106D3E689F3B102"
  code$ = code$ + "D3E601DE8B5E1401DE8B5E1A01DE88048B4614408946148B460639461475"
  code$ = code$ + "A18B46142B46028946148B4612408946128B46043946127589585858585D"
  code$ = code$ + "1FCA0E00"
  DEF SEG = VARSEG(code3%(0))
  FOR i% = 0 TO 182
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code3%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B460A508B4608508B460A2B460E40508B46082B460C40508B46128ED8"
  code$ = code$ + "8B76108B46FABB0800F7E3890446468B46F88904464689761089E58B5E"
  code$ = code$ + "1E8EDB8B7614B106D3E689F3B102D3E601DE8B5E1601DE8B5E1C01DE8A"
  code$ = code$ + "048B5E1A8EDB8B76188804468976188B4616408946168B460639461676"
  code$ = code$ + "C38B46162B46028946168B4614408946148B460439461476AB58585858"
  code$ = code$ + "5D1FCA1000"
  DEF SEG = VARSEG(code4%(0))
  FOR i% = 0 TO 153
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code4%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B460C8ED88B760A8B460888C4B900FA890483C60283E90275F65D1FCA0600"
  DEF SEG = VARSEG(code6%(0))
  FOR i% = 0 TO 34
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code6%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B46128ED88B760CB106D3E689F3B102D3E601DE8B5E0C01DE8B5E100"
  code$ = code$ + "1DE8A1C8B460A8ED88B7608881C5D1FCA0C00"
  DEF SEG = VARSEG(code7%(0))
  FOR i% = 0 TO 50
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code7%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B460C2B4610508B460A2B460E50B8010050B840015089E58B46188B5E1439"
  code$ = code$ + "D87E168B4602BBFFFFF7E38946028B4606BBFFFFF7E38946068B46168B5E"
  code$ = code$ + "1239D87E168B4600BBFFFFF7E38946008B4604BBFFFFF7E38946048B46"
  code$ = code$ + "1C8ED88B7616B106D3E689F3B102D3E601DE8B5E1801DE8B5E1A01DE"
  code$ = code$ + "8B46068B5E0439D87E2FBB000089C13D00007F07B9FFFFF7E189C18A46"
  code$ = code$ + "108804037602035E043B5E067C060376002B5E064983F9007DE4EB32B8"
  code$ = code$ + "000089D983FB007F0C89D8B9FFFFF7E189C1B800008A5E10881C037600"
  code$ = code$ + "0346063B46047C060376022B46044983F9007DE4585858585D1FCA0E00"
  DEF SEG = VARSEG(code8%(0))
  FOR i% = 0 TO 237
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code8%(0)) + i%, d%
  NEXT i%
  DEF SEG
  code$ = "1E5589E58B46108ED88B760E8B460C8EC08B7E0A8B4E08F3A45D1FCA0A00"
  DEF SEG = VARSEG(code9%(0))
  FOR i% = 0 TO 29
	d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
	POKE VARPTR(code9%(0)) + i%, d%
  NEXT i%
  DEF SEG
END SUB

SUB LoadAndPlayLarge (Filename$) STATIC
ERRTRAK$ = "LoadAndPlayLarge"
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(Filename$, 1) <> CHR$(0) THEN Filename$ = Filename$ + CHR$(0)
'Initialize the MIDI driver and load the file in memory
IF LoadCodeLoaded% = 0 THEN
		Lasm$ = ""
		Lasm$ = Lasm$ + CHR$(&H55)
		Lasm$ = Lasm$ + CHR$(&H89) + CHR$(&HE5)
		Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H7)
		Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
		Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H17)
		Lasm$ = Lasm$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H5)
		Lasm$ = Lasm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
		Lasm$ = Lasm$ + CHR$(&H5D)
		Lasm$ = Lasm$ + CHR$(&HCB)
		LoadCodeLoaded% = 1
END IF
DEF SEG = VARSEG(Lasm$)
Offset% = SADD(Lasm$)
CALL Absolute(SADD(Filename$), VARSEG(Filename$), Offset%)

'Start the music!!
IF PlayCodeLoaded% = 0 THEN
		Pasm$ = ""
		Pasm$ = Pasm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)
		Pasm$ = Pasm$ + CHR$(&HBA) + CHR$(&H1) + CHR$(&H0)
		Pasm$ = Pasm$ + CHR$(&HBB) + CHR$(&H1) + CHR$(&H5)
		Pasm$ = Pasm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
		Pasm$ = Pasm$ + CHR$(&HCB)
		PlayCodeLoaded% = 1
END IF
DEF SEG = VARSEG(Pasm$)
Offset% = SADD(Pasm$)
CALL Absolute(Offset%)
MIDI.LOADED = 1
MIDI.PLAYTIME = TIMER
END SUB

'LoadAndPlayMIDI - Loads a MIDI file into memory and plays it
SUB LOADANDPLAYMIDI (Filename$, MIDISegment%, MIDIOffset%)
ERRTRAK$ = "LoadAndPlayMIDI"
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)
'Check if the MIDI loading code has already been loaded;
'if not, do it now.
IF LoadCodeLoaded% = 0 THEN
		asm1$ = asm1$ + CHR$(&H1E)
		asm1$ = asm1$ + CHR$(&H55)
		asm1$ = asm1$ + CHR$(&H89) + CHR$(&HE5)
		asm1$ = asm1$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H17)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
		asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F)
		asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
		asm1$ = asm1$ + CHR$(&H89) + CHR$(&HC6)
		asm1$ = asm1$ + CHR$(&HB4) + CHR$(&H3F)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&HF)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H17)
		asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
		asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F)
		asm1$ = asm1$ + CHR$(&H89) + CHR$(&HF3)
		asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
		asm1$ = asm1$ + CHR$(&HB4) + CHR$(&H3E)
		asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21)
		asm1$ = asm1$ + CHR$(&H5D)
		asm1$ = asm1$ + CHR$(&H1F)
		asm1$ = asm1$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
		LoadCodeLoaded% = 1
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm1$)
CALL Absolute(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm1$))
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF PlayCodeLoaded% = 0 THEN
		'Load the machine codes into a string.
		asm2$ = asm2$ + CHR$(&H55)
		asm2$ = asm2$ + CHR$(&H89) + CHR$(&HE5)
		asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H17)
		asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
		asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H7)
		asm2$ = asm2$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
		asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
		asm2$ = asm2$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
		asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
		asm2$ = asm2$ + CHR$(&H5D)
		asm2$ = asm2$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
		'Indicate that the code has been loaded.
		PlayCodeLoaded% = 1
END IF
'Call the machine language routine to play the music.
DEF SEG = VARSEG(asm2$)
CALL Absolute(MIDISegment%, MIDIOffset%, SADD(asm2$))
'Start the MIDI timer.
MIDI.PLAYTIME = TIMER
END SUB

SUB LoadLarge (Filename$) STATIC
ERRTRAK$ = "LoadLarge"
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(Filename$, 1) <> CHR$(0) THEN Filename$ = Filename$ + CHR$(0)
'Initialize the MIDI driver and load the file in memory
IF CodeLoaded% = 0 THEN
		asm$ = ""
		asm$ = asm$ + CHR$(&H55)
		asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
		asm$ = asm$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H5)
		asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
		asm$ = asm$ + CHR$(&H5D)
		asm$ = asm$ + CHR$(&HCB)
		CodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL Absolute(SADD(Filename$), VARSEG(Filename$), Offset%)
MIDI.LOADED = 1
END SUB

'LoadMIDI - loads a MIDI file into memory
SUB LoadMIDI (Filename$, MIDISegment%, MIDIOffset%) STATIC
ERRTRAK$ = "LoadMIDI"
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)
'Check if the assembly language code has already been loaded;
'if not, do it now.
IF CodeLoaded% = 0 THEN
		asm$ = asm$ + CHR$(&H1E)
		asm$ = asm$ + CHR$(&H55)
		asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
		asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
		asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
		asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
		asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
		asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
		asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
		asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
		asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
		asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
		asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
		asm$ = asm$ + CHR$(&H5D)
		asm$ = asm$ + CHR$(&H1F)
		asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
		CodeLoaded% = 1
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm$)
CALL Absolute(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
END SUB

FUNCTION MIDIError$
ERRTRAK$ = "MidiError"
SELECT CASE MIDI.ERROR
		CASE 0: MIDIError$ = "NO ERROR"
		CASE 1: MIDIError$ = "FILE CONTAINS NO DATA"
		CASE 2: MIDIError$ = "FILE IS TOO LARGE"
		CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

DEFINT A-Z
SUB MusicParams
IF TimeMIDI! > 43 THEN RepeatRegMidi
END SUB

DEFSNG A-Z
SUB offkb
ERRTRAK$ = "OffKb"
IF (keyboardonflag% = 0) THEN EXIT SUB
keyboardonflag% = 0
DEF SEG = VARSEG(kbcontrol%(0))
CALL Absolute(3)
DEF SEG
END SUB

SUB ONKB
ERRTRAK$ = "OnKb"
IF keyboardonflag% THEN EXIT SUB
keyboardonflag% = 1
DEF SEG = VARSEG(kbcontrol%(0))
CALL Absolute(0)
DEF SEG
END SUB

'PauseMIDI - Pauses a MIDI file that is currently playing
SUB PauseMIDI
ERRTRAK$ = "PauseMIDI"
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN EXIT SUB
'Pause the music.
IF CodeLoaded% = 0 THEN
		asm$ = ""
		asm$ = asm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HBA) + CHR$(&H1) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HBB) + CHR$(&H3) + CHR$(&H5)
		asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
		asm$ = asm$ + CHR$(&HCB)
		CodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL Absolute(Offset%)
'Save the number of seconds the MIDI file has been playing.
PAUSED = TimeMIDI!
'If it hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
END SUB

SUB PlayLarge STATIC
ERRTRAK$ = "PlayLarge"
'If no MIDI file is loaded, exit now
IF MIDI.LOADED = 0 THEN EXIT SUB
'Start the music!!
IF CodeLoaded% = 0 THEN
		asm$ = ""
		asm$ = asm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HBA) + CHR$(&H1) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HBB) + CHR$(&H1) + CHR$(&H5)
		asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
		asm$ = asm$ + CHR$(&HCB)
		CodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL Absolute(Offset%)
MIDI.PLAYTIME = TIMER
END SUB

DEFINT A-Z
SUB PlayLoseMus
ERRTRAK$ = "PlayLoseMus"
REDIM MIDI%(BytesRequired&("DATA\AUDIO\END2.MUS") \ 2)
LOADANDPLAYMIDI "DATA\AUDIO\END2.MUS", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SUB

DEFSNG A-Z
'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
ERRTRAK$ = "PlayMIDI"
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF CodeLoaded% = 0 THEN
		'Load the machine codes into a string.
		asm$ = asm$ + CHR$(&H55)
		asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
		asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
		asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
		asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
		asm$ = asm$ + CHR$(&H5D)
		asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
		'Indicate that the code has been loaded.
		CodeLoaded% = 1
END IF
'Call the machine language routine to play the music.
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL Absolute(MIDISegment%, MIDIOffset%, Offset%)
'Start the MIDI timer.
MIDI.PLAYTIME = TIMER
END SUB

DEFINT A-Z
SUB PlayWinMus
ERRTRAK$ = "PlayWinMus"
REDIM MIDI%(BytesRequired&("DATA\AUDIO\END1.MUS") \ 2)
LOADANDPLAYMIDI "DATA\AUDIO\END1.MUS", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SUB

SUB ProveMusic
ERRTRAK$ = "ProveMusic"
DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
SELECT CASE SBMIDI.INTERRUPT
		CASE 0:
				PRINT "You do not have SBMIDI Installed."
				PRINT "Either disable it at the Main Menu, or run SBMIDI.EXE prior to running"
				PRINT "Star shot."
				SHELL "pause"
				END
END SELECT
END SUB

DEFSNG A-Z
SUB readassembly
ERRTRAK$ = "ReadAssembly"
RESTORE kbisrdata
DEF SEG = VARSEG(kbcontrol%(0))
i& = 0
GOTO skip0
DO
  POKE i&, q%
  i& = i& + 1
skip0:
  READ q%
LOOP WHILE q% > -1
i& = 16
n& = VARSEG(KBMATRIX%(0)): L& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE i&, L&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(KBMATRIX%(0)): L& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE i&, L&: POKE i& + 1, h&: i& = i& + 2
DEF SEG
EXIT SUB
END SUB

DEFINT A-Z
SUB ReadCfg
ERRTRAK$ = "ReadCfg"
OPEN "DATA\CONFIG\STARSHOT.CFG" FOR INPUT AS #1
INPUT #1, DTLVL, Sond, MUSIC
CLOSE
IF Sond = 0 THEN NoSamples = 1
END SUB

SUB RepeatBossMidi
ERRTRAK$ = "RepeatBossMidi"
PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SUB

SUB RepeatRegMidi
ERRTRAK$ = "RepeatRegMidi"
PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SUB

DEFSNG A-Z
'ResumeMIDI - Starts playing a MIDI file after it has been paused
SUB ResumeMIDI
ERRTRAK$ = "ResumeMIDI"
'If no MIDI file is paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Resume playing.
IF CodeLoaded% = 0 THEN
		asm$ = ""
		asm$ = asm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HBA) + CHR$(&H1) + CHR$(&H0)
		asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H5)
		asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
		asm$ = asm$ + CHR$(&HCB)
		CodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL Absolute(Offset%)
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
END SUB

DEFINT A-Z
SUB Shake
ERRTRAK$ = "Shake"
Delay = 5500
FOR x = 1 TO Delay
  OUT &H3D4, 8: OUT &H3D5, x
NEXT x
OUT &H3D4, 8: OUT &H3D5, 0
END SUB

SUB Sound.DeInitDSP
ERRTRAK$ = "Sound.DeInitDSP"
Sound.WriteDSP &HD3
OUT &H20, &H20
END SUB

SUB Sound.DMAplay (file$, spd)
ERRTRAK$ = "Sound.DMAplay"
SHARED IRQ
IF NoSamples = 0 AND TIMER > validtime! THEN

junk = Sound.ResetDSP

OPEN "DATA\AUDIO\" + file$ FOR BINARY ACCESS READ AS #1
	REDIM SndDat(1) AS STRING
	length& = LOF(1) - 1
	SndDat(1) = STRING$(LOF(1), 0)
	GET #1, , SndDat(1)': SndDat(1) = RIGHT$(SndDat(1), LEN(SndDat(1)) - 5)
CLOSE #1

Segment& = VARSEG(SndDat(1))
Offset& = SADD(SndDat(1))
IF Segment& < 0 THEN Segment& = Segment& + 65536
IF Offset& < 0 THEN Offset& = Offset& + 65536
MemLoc& = Segment& * 16 + Offset&

OUT &HA, &H4 + dma
OUT &HC, &H0
OUT &HB, &H0

OUT AddPort, MemLoc& AND &HFF
OUT AddPort, (MemLoc& AND &HFFFF&) \ &H100

Page = (MemLoc& AND &HF0000) \ &H10000

OUT PgPort, Page
OUT LenPort, length& AND &HFF
OUT LenPort, (length& AND &HFFFF&) \ &H100
OUT &HA, dma

OUT BasePort + 4, &H22                        'Set volume
OUT BasePort + 5, 255

Sound.WriteDSP &H40
Sound.WriteDSP spd
Sound.WriteDSP &H14
Sound.WriteDSP length& AND &HFF
Sound.WriteDSP ((length& AND &HFFFF&) \ &H100)

END IF
END SUB

SUB Sound.GetBlaster
ERRTRAK$ = "Sound.GetBlaster"
BasePort = VAL("&h220")
IRQ = 7
dma = 1
END SUB

FUNCTION Sound.ResetDSP
 ERRTRAK$ = "Sound.ResetDSP"
 OUT BasePort + 6, 1
 OUT BasePort + 6, 0
 FOR n = 1 TO 100
  WAIT &H3DA, 8
  WAIT &H3DA, 12
  IF INP(BasePort + &HE) AND 128 THEN GOTO ok
 NEXT n
 EXIT FUNCTION
ok:
 IF INP(BasePort + &HA) = &HAA THEN
  Sound.ResetDSP = 1

  OUT BasePort + 4, &H0
  OUT BasePort + 5, 0

  SELECT CASE dma
	CASE 0 TO 3
	 MskPort = &HA
	 ModPort = &HB
	 ClrPort = &HC
	CASE ELSE
	 MskPort = &HD4
	 ModPort = &HD6
	 ClrPort = &HD8
  END SELECT

  OUT MskPort, dma + 4
  OUT ClrPort, &H0
  OUT ModPort, 72 + dma
  OUT MskPort, dma

  Sound.WriteDSP &HD1
 
 END IF
END FUNCTION

SUB Sound.WriteDSP (byte)
 ERRTRAK$ = "Sound.WriteDSP"
 SHARED BasePort
 add = BasePort + 12
 s! = TIMER
 DO
  IF ABS(TIMER - s!) >= .5 THEN EXIT DO
 LOOP WHILE INP(add) AND &H80
 OUT add, byte
END SUB

SUB Sound.WriteReg (reg, info)
 ERRTRAK$ = "Sound.WriteReg"
 OUT &H388, reg
 FOR d = 1 TO 6: x = INP(&H388): NEXT d
 OUT &H389, info
 FOR d = 1 TO 35: x = INP(&H388): NEXT d
END SUB

SUB StartBossMidi
ERRTRAK$ = "StartBossMidi"
REDIM MIDI%(BytesRequired&("DATA\AUDIO\MUS2.MUS") \ 2)
LOADANDPLAYMIDI "DATA\AUDIO\MUS2.MUS", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SUB

SUB StartRegMidi
ERRTRAK$ = "StartRegMidi"
REDIM MIDI%(BytesRequired&("DATA\AUDIO\MUS1.MUS") \ 2)
LOADANDPLAYMIDI "DATA\AUDIO\MUS1.MUS", VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END SUB

DEFSNG A-Z
'StopMIDI - Stops playing MIDI file
SUB StopMIDI
ERRTRAK$ = "StopMIDI"
'Stop the music!!
asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
asm$ = asm$ + CHR$(&HCB)
'These next commented lines are for using the converted code.
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL Absolute(Offset%)
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMIDI!
ERRTRAK$ = "TimeMIDI"
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
	TimeMIDI! = PAUSED
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
	'Get the current time
	CurrentTime! = TIMER
	'If midnight has come since the MIDI file started playing, change
	'CurrentTime! accordingly
	IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
		CurrentTime! = 86400 + CurrentTime!
	END IF
	'Get the final result
	TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
ELSE
	MIDI.ERROR = 3
END IF
END FUNCTION

