DECLARE SUB timestall (millisec#)



screen 9
DIM firstname$(20),lastname$(20),typename$(10)
DIM companyname$(20),companyprice#(20),companytick$(20),companybuyprice#(20),companyqty#(20),companyvalue%(20),companysale%(20)

lowestvalue# = 2.00 'the lowest value a stock can reach.
fluxratio# = .05  ' the dollar amount of flux each day
speed# = .5         ' how fast do the days go.
saleflux% = 1         ' flux of the stock sale.
thisday% = 1
thismonth% = 1
thisyear% = 2000
accountcost# = 10

' main screen *************************************************************************************
mainmenu: 
cls : color 15
print " Stock Trader v1.2 by: Jace Masula 1998"
print ""
print " Main Menu"
print " -------------------------------------------------------------------------------"
print " (N)ew Account"
print " (L)oad Saved Account"
print " (I)nstructions"
print " (Q)uit Simulation"
do
    keypress$ = inkey$
    if keypress$ = "n" then goto newaccount
    if keypress$ = "l" then goto loadaccount
    if keypress$ = "i" then goto instructions
    if keypress$ = "q" then goto quitgame
loop

' quitgame ****************************************************************************************
quitgame:
end

' intruct ****************************************************************************************
instructions: cls
color 15
print ""
print "STOCKMAN INSTRUCTIONS"
color 7
print
print "The first thing you will need to do is VIEW the stock market. This will give"
print "you an idea on what stocks to buy. Keep in mind you don't start with much money,"
print "so it is a good idea to purchase some cheap stocks. As you view the stock market"
print "you can press (B) to buy stocks or (S) to sell them, the (SPACE) bar will take "
print "you back to the STOCK OPTIONS MENU."
print
print "The game autosaves so you can quit at any time and pick up where you left off."
print "to create a new account, just select NEW ACCOUNT from the main menu and type"
print "in an account name (MAX 8 characters)."
sleep
goto mainmenu
end

' create a new account ****************************************************************************
newaccount:
    ' set up new account variables
    accountcash# = 100.00
    print " Create New Account"
    input " Enter Account Name >> ", accountname$
    ' read the company file for data
    namesmax% = 20
    open "company.txt" for input as #1
    input #1,blank$
        for i% = 1 to namesmax%
            input #1, firstname$(i%)
        next i%
    input #1,blank$    
        for i% = 1 to namesmax%
            input #1, lastname$(i%)
        next i%
    close #1 
    ' Now create 20 unique cpmpany names
    print:print " Creating Company Data" :sleep 1
    for i% = 1 to namesmax%
    ' Pick a random firstname from the list    
        getfirstname:
        randomize timer
        randpick% = ((namesmax%-1) * rnd)+1
        if firstname$(randpick%) <> "" then 
            temp1$ = firstname$(randpick%)
            firstname$(randpick%) = ""
        else 
            goto getfirstname
        end if
        
     ' Pick a random lastname from the list   
        getlastname:
        randomize timer
        randpick% = ((namesmax%-1) * rnd)+1
        if lastname$(randpick%) <> "" then 
            temp2$ = lastname$(randpick%)
            lastname$(randpick%) = ""
        else 
            goto getlastname
        end if
        
     ' Pick a random type from the list        
        randomize timer
        randpick% = (9 * rnd)+1 
        temp3$ = typename$(randpick%)      
        
        companyname$(i%) = Temp1$ + " " + temp2$
        companyprice#(i%) = (99.9 * rnd) + .1 
        temp$= mid$(Temp1$,1,2) + mid$(Temp2$,4,2)
        companytick$(i%) = UCASE$(temp$)
        companysale%(i%) = (100 * rnd)+1
    next i%
        open accountname$+".txt" for output as #1
        for i% = 1 to 20
                write #1, companyname$(i%),companyprice#(i%),companytick$(i%),companybuyprice#(i%),companyqty#(i%),companyvalue%(i%),companysale%(i%)
        next i%
        write #1, accountcash#,thisday%,thismonth%,thisyear%
        
        close #1 
    print " Account Created.":sleep 1

goto mainmenu

' load an exsiting account ****************************************************************************
loadaccount:
    print " >> Load Existing Account"
    input " Enter Account Name >> ", accountname$
   ' read the company file for data
    namesmax% = 20
    open accountname$+".txt" for input as #1
    for i% = 1 to 20
        input #1, companyname$(i%),companyprice#(i%),companytick$(i%),companybuyprice#(i%),companyqty#(i%),companyvalue%(i%),companysale%(i%)
    next i%
    input #1, accountcash#,thisday%,thismonth%,thisyear%
    close #1
    print " Account Loaded.":sleep 1
    goto stockmenu




' Main stock menu **********************************************************************************
stockmenu:
cls : color 15
print " Stock Trader v1.2 by: Jace Masula 1998"
color 7
print ""
print " Stock Options Menu";"                            Date:"+str$(thismonth%)+"/"str$(thisday%)+"/"str$(thisyear%)
print " -------------------------------------------------------------------------------"
print " (V)iew Stock Market"
print " (B)uy Stock"
print " (S)ell Stock"
print " (Q)uit to Main Menu"
do
    keypress$ = inkey$
    if keypress$ = "v" then goto viewmarket
    'if keypress$ = "n" then goto newsreport
    if keypress$ = "b" then goto buystock
    if keypress$ = "s" then goto sellstock
    if keypress$ = "q" then goto mainmenu
loop

' startnewday ***************************************************************************************
newday:
minutes% = 0
thisday% = thisday% + 1

if accountcash# < 0 then goto gameover

if thisday% = 30 then thisday% = 1 : thismonth% = thismonth%+1
if thismonth% > 12 then thismonth% = 1 : thisyear% = thisyear% +1
accountcash# = accountcash# - accountcost# 
open accountname$+".txt" for output as #1
    for i% = 1 to 20    
        write #1, companyname$(i%),companyprice#(i%),companytick$(i%),companybuyprice#(i%),companyqty#(i%),companyvalue%(i%),companysale%(i%)
    next i%
    write #1, accountcash#,thisday%,thismonth%,thisyear%
close #1



' View the stock market *****************************************************************************
viewmarket:
cls : color 15
print " SYMB   SELL     BUY     COMPANY NAME           QTY        VALUE    SALE"
color 7
    for i% = 1 to 20 
        locate 1+i%,2
        PRINT companytick$(i%)
        locate 1+i%,26
        PRINT companyname$(i%)
        locate 1+i%,15
        PRINT USING "$$####.##"; companybuyprice#(i%)
        locate 1+i%,49
        PRINT str$(companyqty#(i%))

    next i%
    'color 15:locate 25,2: print "(M)enu (N)ews (B)uy (S)ell";
    color 7
    locate 22,2:color 8:print " -----------------------------------------------------------------------------";
    color 7
    locate 23,44:print "Date:"+str$(thismonth%)+"/"str$(thisday%)+"/"str$(thisyear%)


refreshmarket: 

if minutes% >= 78 then goto newday
minutes% = minutes% +1
locate 22,minutes%+1:color 15:print "-";
color 7
for i% = 1 to 20
    randomize timer
    flux% = (1 * rnd)
    sale% = int(saleflux% * rnd)
    if flux% = 0 then temp# = (-fluxratio# * rnd)
    if flux% = 1 then temp# = (fluxratio# * rnd)
    companyprice#(i%) = companyprice#(i%) + temp#
    if companyprice#(i%) < lowestvalue# then companyprice#(i%) = lowestvalue#
next i%  

'create news event --------------------------------------------------------------------
'--------------------------------------------------------------------------------------
pickcompany% = (19 * rnd)+1
pickevent% = (19 * rnd)+1

if pickevent% = 1 then
    newsevent$ = companyname$(pickcompany%)+ " shows quarterly profits at record high."
    companyprice#(pickcompany%) = companyprice#(pickcompany%) + (fluxratio# * rnd)*10
elseif pickevent% = 2 then
    newsevent$ = companyname$(pickcompany%)+ " shows quarterly profits at record low."
    companyprice#(pickcompany%) = companyprice#(pickcompany%) - (fluxratio# * rnd)*10
elseif pickevent% = 3 then
    newsevent$ = companyname$(pickcompany%)+ " reports additional shares of stock available."
    companysale%(pickcompany%) = companysale%(pickcompany%) + int(50 * rnd)+1
elseif pickevent% = 4 then
    newsevent$ = companyname$(pickcompany%)+ " reports shortage of available stock."
    companysale%(pickcompany%) = companysale%(pickcompany%) - int(50 * rnd)+1
    if companysale%(pickcompany%) < 0 then 
    companysale%(pickcompany%) = 0
    end if
end if


'----------------- --------------------------------------------------------------------
'--------------------------------------------------------------------------------------

avgprice# = 0
tempprice# = 0
totalvalue# = 0
for i% = 1 to 20 
    locate 1+i%,6
    PRINT USING "$$####.##"; companyprice#(i%)  
    tempprice# = tempprice# + companyprice#(i%)
    avgprice# = (tempprice# / 20)
    companyvalue#(i%) = companyqty#(i%) * companyprice#(i%)
    totalvalue# = totalvalue# + companyvalue#(i%)
    locate 1+i%,58  
    PRINT USING "$$####";companyvalue#(i%);
    locate 1+i%,68  
    PRINT USING "####";companysale%(i%);  
      
next i%
locate 25,2: print "                                                                              ";
locate 25,2: print newsevent$;
locate 23,2: print "Average Stock Price:";
PRINT USING "$$###.##"; avgprice#
print " Bank Account:";
PRINT USING "$$###,###,###.##"; accountcash#;
print "             Total Assets:";
PRINT USING "$$###,###,###.##"; totalvalue#;

    PAUSETIME# = speed#
    TIME# = TIMER 
    DO
    LOOP WHILE TIMER <= TIME# + PAUSETIME#

do
    keypress$ = inkey$
    
    if keypress$ = "n" then goto newsreport
    if keypress$ = "b" then goto buystock
    if keypress$ = "s" then goto sellstock
    if keypress$ = "m" or keypress$ = " " then goto stockmenu
    if keypress$ = "" then goto refreshmarket
loop




' create a news report ***************************************************************************************
newsreport:
cls : color 15

print " Stock Trader v1.2 by: Jace Masula 1998"
color 7
print ""
print " News Report on:"+str$(thismonth%)+"/"str$(thisday%)+"/"str$(thisyear%)
print " -------------------------------------------------------------------------------"
    color 15:locate 25,2: print "(SPACE) = Back      (V)iew (B)uy (S)ell";
    color 7
do
    keypress$ = inkey$
    
    if keypress$ = "n" then goto newsreport
    if keypress$ = "b" then goto buystock
    if keypress$ = "s" then goto sellstock
    if keypress$ = "v" then goto viewmarket
    if keypress$ = "m" or keypress$ = " " then goto stockmenu
loop

















' buy stock **********************************************************************************
buystock:
cls
    print
    buyselect% = 0
    input "Enter Company Symbol >> ", tempsymbol$
    for i% = 1 to 20
        if tempsymbol$ = "" then goto stockmenu
        if ucase$(tempsymbol$) = companytick$(i%) then buyselect% = i%: exit for
    next i%
        if buyselect% = 0 then goto buystock
    print
    print "Purchase stock from:"
    print ">>"+companyname$(buyselect%)
    print "Each share costs:";
    PRINT USING "$$###.##"; companyprice#(buyselect%)
    print "There are";companysale%(buyselect%);"available."

    print
    input "Purchase Quantity >> ", buyqty#
    print 
    'calculate total of transaction
    totalcost# = buyqty# * companyprice#(buyselect%)
    if totalcost# > accountcash# or buyqty# > companysale%(buyselect%) then
        print "Transaction Failed,"  
        print "Insufficient Funds." 
        sleep 3
        goto stockmenu
    else
        accountcash# = accountcash# - totalcost# 
        companyqty#(buyselect%) = companyqty#(buyselect%) + buyqty#
        companybuyprice#(buyselect%) = companyprice#(buyselect%)
        companysale%(buyselect%) = companysale%(buyselect%) - buyqty#
        print "Transaction complete."  
        sleep 3
        goto stockmenu
    end if
    
' sell stock **********************************************************************************
sellstock:
cls
    print
    input "Enter Company Symbol >> ", tempsymbol$
    for i% = 1 to 20
        if tempsymbol$ = "" then goto stockmenu
        if ucase$(tempsymbol$) = companytick$(i%) then sellselect% = i%: exit for
    next i%
    print
    print "Selling stock from:"
    print ">>"+companyname$(sellselect%)
    print "Each share sells for:";
    PRINT USING "$$####.##"; companyprice#(sellselect%)
    print "You have:"+ str$(companyqty#(sellselect%))+" Shares of Stock"
    input "How many will you sell?  >> ", sellqty#
    print 
    'calculate total of transaction
    totalcost# = sellqty# * companyprice#(sellselect%)
    if sellqty# > companyqty#(sellselect%) then
        print "Transaction Failed,"  
        print "Insufficient Qty." 
        sleep 3
        goto stockmenu
    else
        accountcash# = accountcash# + totalcost# 
        companyqty#(sellselect%) = companyqty#(sellselect%) - sellqty#
        companysale%(buyselect%) = companysale%(buyselect%) + sellqty#
        print "Transaction complete."  
        sleep 3
        goto stockmenu
    end if    




' sell stock **********************************************************************************
gameover:
cls
color 15
print " Stock Trader v1.2 by: Jace Masula 1998"
print ""
print "Game over"
print "You ran out of cash."




































































































'************************************************************ timestall ************************************************************
sub timestall (millisec#)
    PAUSETIME# = millisec#
    TIME# = TIMER 
    DO : keyget$ = inkey$
    LOOP WHILE TIMER <= TIME# + PAUSETIME#
end sub