DECLARE SUB MouseLoad ()
DECLARE FUNCTION MouseInit% ()
DECLARE SUB MouseStatus (lb%, rb%, xMouse%, yMouse%, div%)
DECLARE SUB MouseRange (X1%, Y1%, X2%, Y2%)
DECLARE SUB MousePut (x%, y%)
DECLARE SUB MouseHide ()
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseShow ()

COMMON SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER
COMMON SHARED MIDI.LOADED AS INTEGER, SBMIDI.INTERRUPT AS INTEGER
COMMON SHARED SBSIM.INTERRUPT AS INTEGER, PAUSED AS SINGLE
COMMON SHARED MIXER.CHIP AS INTEGER, SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
COMMON SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
COMMON SHARED BIT.STORAGE() AS INTEGER, SENSITIVE AS INTEGER
COMMON SHARED REVERSE.STEREO AS INTEGER, SOUND.DISABLED AS INTEGER
  COMMON SHARED PlaySndFlag%, WavFlag%
  COMMON SHARED BasePort%, LenPort%, Channel%, IRQ%, HaveBlast%, WavRep%, TheWavLen&
  COMMON SHARED TFWav() AS STRING * 15000
  COMMON SHARED SoundEvent%
 COMMON SHARED Mouse$

SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, Mouse%)
END SUB 'md

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

SUB MouseLoad
 Mouse$ = ""
                         '55,          89          ,E5,          8B,          5E         ,0C,          8B,         07,          50,          8B,          5E,         0A,          8B,         07,          50,          8B
 Mouse$ = Mouse$ + CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&H8B)
 Mouse$ = Mouse$ + CHR$(&H5E) + CHR$(&HC) + CHR$(&H8B) + CHR$(&H7)
 Mouse$ = Mouse$ + CHR$(&H50) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
 Mouse$ = Mouse$ + CHR$(&H8B) + CHR$(&H7) + CHR$(&H50) + CHR$(&H8B)
                         '5E,         08,          8B,         0F,          8B,          5E,         06,          8B,          17,          5B,          58,          1E,         07,          CD,          33,          53
 Mouse$ = Mouse$ + CHR$(&H5E) + CHR$(&H8) + CHR$(&H8B) + CHR$(&HF)
 Mouse$ = Mouse$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) + CHR$(&H8B)
 Mouse$ = Mouse$ + CHR$(&H17) + CHR$(&H5B) + CHR$(&H58) + CHR$(&H1E)
 Mouse$ = Mouse$ + CHR$(&H7) + CHR$(&HCD) + CHR$(&H33) + CHR$(&H53)
                         '8B,         5E,          0C,          89,         07,          58,          8B,          5E,         0A,          89,         07,          8B,          5E,         08,          89,         0F
 Mouse$ = Mouse$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC) + CHR$(&H89)
 Mouse$ = Mouse$ + CHR$(&H7) + CHR$(&H58) + CHR$(&H8B) + CHR$(&H5E)
 Mouse$ = Mouse$ + CHR$(&HA) + CHR$(&H89) + CHR$(&H7) + CHR$(&H8B)
 Mouse$ = Mouse$ + CHR$(&H5E) + CHR$(&H8) + CHR$(&H89) + CHR$(&HF)
                         '8B,          5E,         06,          89,          17,          5D,          CA,         08,         00
 Mouse$ = Mouse$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) + CHR$(&H89)
 Mouse$ = Mouse$ + CHR$(&H17) + CHR$(&H5D) + CHR$(&HCA) + CHR$(&H8)
 Mouse$ = Mouse$ + CHR$(&H0)
 
   ms% = MouseInit%
   IF ms% = 0 THEN
     PRINT "No mouse or non-compatible mouse detected."
     END
   END IF

END SUB 'ml

SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (X1%, Y1%, X2%, Y2%)
  ax% = 7
  cx% = X1%
  dx% = X2%
MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = Y1%
  dx% = Y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (lb%, rb%, xMouse%, yMouse%, div%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  xMouse% = cx% / div%
  yMouse% = dx%
END SUB

