'===========================================================================
' Subject: TIC-TAC-TOE IN TEXTMODE            Date: 07-31-98 (21:45)       
'  Author: Anders Olofsson                    Code: QB, QBasic, PDS        
'  Origin: anders.olofsson@mail.bip.net     Packet: GAMES.ABC
'===========================================================================
'
'      <<< Tic-Tac-Toe game in textmode, by Anders Olofsson 1998. >>>
'
'    Here is a quite intelligent Tic-Tac-Toe game with
'    randomized winning patterns...
'
'     e-mail: anders.olofsson@mail.bip.net
'
'-----------------------------------------------------------------------------
DEFINT A-Z
DECLARE SUB Think ()
DECLARE SUB DrawField ()

TYPE Pattern 'Winning patterns
 X1 AS INTEGER: Y1 AS INTEGER
 X2 AS INTEGER: Y2 AS INTEGER
 X3 AS INTEGER: Y3 AS INTEGER
END TYPE

DIM SHARED TicTac(1 TO 3, 1 TO 3) AS INTEGER
DIM SHARED Patterns(1 TO 8) AS Pattern, RandPattern(1 TO 8)
DIM SHARED CompWins, PlayerWins, NumTies, Player, Computer, Winner

RANDOMIZE TIMER

RESTORE Patterns 'Patterns to check out winner, moves etc...
FOR I = 1 TO 8: READ Patterns(I).X1, Patterns(I).Y1
READ Patterns(I).X2, Patterns(I).Y2: READ Patterns(I).X3, Patterns(I).Y3
RandPattern(I) = I: NEXT

'Set num-lock bit on (bit 5)
DEF SEG = &H40: POKE &H17, PEEK(&H17) OR 32: DEF SEG

GetSelection:
CLS : COLOR 9, 0
PRINT "Do you want to be " + CHR$(34) + "X" + CHR$(34) + " or " + CHR$(34) + "O" + CHR$(34) + "?"
PRINT "  1. X"
PRINT "  2. O"
PRINT
COLOR 4: PRINT "Please choose or press enter to be X."
COLOR 3: INPUT "-->>", Player
IF Player = 0 THEN Player = 1
IF Player <> 1 AND Player <> 2 THEN GOTO GetSelection
IF Player = 1 THEN Computer = 2 ELSE Computer = 1

NewGame:  'Randomize moves
FOR X = 1 TO 50: FOR Y = 1 TO 8
 SWAP RandPattern(Y), RandPattern(RND * 7 + 1)
NEXT Y, X

DO
GetUserInput:  DrawField
DO: K$ = INKEY$: LOOP UNTIL LEN(K$)
IF K$ = CHR$(27) THEN COLOR 7, 0: CLS : END ELSE V = VAL(K$): IF V = 0 THEN GOTO GetUserInput
IF V >= 7 THEN X = 1: Y = V - 6 ELSE IF V >= 4 THEN X = 2: Y = V - 3 ELSE IF V >= 1 THEN X = 3: Y = V
IF TicTac(X, Y) THEN PRINT : LOCATE 15, 20: COLOR 14, 1: PRINT "Busy!": SOUND 600, .2: SLEEP 1: GOTO GetUserInput
FOR CX = 1 TO 3: FOR CY = 1 TO 3: IF TicTac(CX, CY) = 0 THEN GOTO DoneChecking
NEXT CY, CX: GOTO GetUserInput
DoneChecking:  TicTac(X, Y) = Player
Think
DrawField
 IF Winner THEN
  IF Winner = Player THEN T$ = "You win!": PlayerWins = PlayerWins + 1
  IF Winner = Computer THEN T$ = "I Win!": CompWins = CompWins + 1
  IF Winner = -1 THEN T$ = "It's a tie!": NumTies = NumTies + 1
  FOR X = 1 TO 3: FOR Y = 1 TO 3: TicTac(X, Y) = 0: NEXT Y, X
  FOR X = 1200 TO 1600 STEP 50: SOUND X, .1: NEXT
  LOCATE 20, 41 - LEN(T$ + "  ") \ 2: COLOR 10, 4: PRINT " " + T$ + " "
  DO: LOOP UNTIL LEN(INKEY$)
  GOTO NewGame
 END IF
LOOP

Patterns:  'Winning patterns:
DATA 1,1, 1,2, 1,3
DATA 2,1, 2,2, 2,3
DATA 3,1, 3,2, 3,3
'-----------------
DATA 1,1, 2,1, 3,1
DATA 1,2, 2,2, 3,2
DATA 1,3, 2,3, 3,3
'----------------
DATA 1,1, 2,2, 3,3
DATA 3,1, 2,2, 1,3

SUB DrawField
SCREEN 0, , 1, 0: COLOR 3, 1: CLS
FOR X = 1 TO 3
FOR Y = 1 TO 3
 IF TicTac(X, Y) = 1 THEN
  Field$ = Field$ + "X"
 ELSEIF TicTac(X, Y) = 2 THEN
  Field$ = Field$ + "O"
 ELSE
  Field$ = Field$ + " "
 END IF
NEXT
NEXT
IF Player = 2 THEN Symbol$ = "O" ELSE Symbol$ = "X"
COLOR 10, 4
PRINT USING "  Score:              You  ###               Me ###              Tie's ###      "; PlayerWins; CompWins; NumTies
PRINT
COLOR 11, 1
PRINT "   Use the num-pad keys to place your " + CHR$(34) + Symbol$ + CHR$(34) + "."
PRINT
COLOR 10, 0

LOCATE 5, 20: PRINT "Ŀ"
LOCATE 6, 20: PRINT " " + MID$(Field$, 1, 1) + "  " + MID$(Field$, 2, 1) + "  " + MID$(Field$, 3, 1) + " "
LOCATE 7, 20: PRINT "Ĵ"
LOCATE 8, 20: PRINT " " + MID$(Field$, 4, 1) + "  " + MID$(Field$, 5, 1) + "  " + MID$(Field$, 6, 1) + " "
LOCATE 9, 20: PRINT "Ĵ"
LOCATE 10, 20: PRINT " " + MID$(Field$, 7, 1) + "  " + MID$(Field$, 8, 1) + "  " + MID$(Field$, 9, 1) + " "
LOCATE 11, 20: PRINT ""

COLOR 7, 1
LOCATE 5, 44: PRINT "Ŀ"
LOCATE 6, 44: PRINT " 7  8  9 "
LOCATE 7, 44: PRINT "Ĵ"
LOCATE 8, 44: PRINT " 4  5  6 "
LOCATE 9, 44: PRINT "Ĵ"
LOCATE 10, 44: PRINT " 1  2  3 "
LOCATE 11, 44: PRINT ""

PCOPY 1, 0: SCREEN 0, , 0, 0
END SUB

SUB Think
Winner = 0 'Reset winner!
'Computer is thinking...
IF TicTac(2, 2) = 0 THEN Pos1 = 2: Pos2 = 2: GOTO CheckDefence
FOR I = 1 TO 8    'First we check if the computer can win!
X1 = Patterns(I).X1: Y1 = Patterns(I).Y1: X2 = Patterns(I).X2: Y2 = Patterns(I).Y2: X3 = Patterns(I).X3: Y3 = Patterns(I).Y3
IF TicTac(X1, Y1) = 0 AND TicTac(X2, Y2) = Computer AND TicTac(X3, Y3) = Computer THEN TicTac(X1, Y1) = Computer
IF TicTac(X1, Y1) = Computer AND TicTac(X2, Y2) = 0 AND TicTac(X3, Y3) = Computer THEN TicTac(X2, Y2) = Computer
IF TicTac(X1, Y1) = Computer AND TicTac(X2, Y2) = Computer AND TicTac(X3, Y3) = 0 THEN TicTac(X3, Y3) = Computer
NEXT I
'  Check out if there is a winner...
FOR Current = 1 TO 2: FOR I = 1 TO 8
X1 = Patterns(I).X1: Y1 = Patterns(I).Y1: X2 = Patterns(I).X2: Y2 = Patterns(I).Y2: X3 = Patterns(I).X3: Y3 = Patterns(I).Y3
IF TicTac(X1, Y1) = Current AND TicTac(X2, Y2) = Current AND TicTac(X3, Y3) = Current THEN Winner = Current: EXIT SUB
NEXT I, Current
'  If not, find a chance to win...
FOR X = 1 TO 8: I = RandPattern(X) 'Randomized move.
X1 = Patterns(I).X1: Y1 = Patterns(I).Y1: X2 = Patterns(I).X2: Y2 = Patterns(I).Y2: X3 = Patterns(I).X3: Y3 = Patterns(I).Y3
IF TicTac(X1, Y1) = 0 THEN Pos1 = X1: Pos2 = Y1: GOTO CheckDefence
IF TicTac(X2, Y2) = 0 THEN Pos1 = X2: Pos2 = Y2: GOTO CheckDefence
IF TicTac(X3, Y3) = 0 THEN Pos1 = X3: Pos2 = Y3: GOTO CheckDefence
NEXT
Winner = -1: EXIT SUB  ' It's a tie

CheckDefence:  'We have found a good place - but before we decide to
FOR I = 1 TO 8 'place the computer's X/O there, we have to defence ourselves.
X1 = Patterns(I).X1: Y1 = Patterns(I).Y1: X2 = Patterns(I).X2: Y2 = Patterns(I).Y2: X3 = Patterns(I).X3: Y3 = Patterns(I).Y3
IF (TicTac(X2, Y2) = Player AND TicTac(X3, Y3) = Player) AND TicTac(X1, Y1) = 0 THEN TicTac(X1, Y1) = Computer: EXIT SUB
IF (TicTac(X1, Y1) = Player AND TicTac(X3, Y3) = Player) AND TicTac(X2, Y2) = 0 THEN TicTac(X2, Y2) = Computer: EXIT SUB
IF (TicTac(X1, Y1) = Player AND TicTac(X2, Y2) = Player) AND TicTac(X3, Y3) = 0 THEN TicTac(X3, Y3) = Computer: EXIT SUB
NEXT

' Nothing to defence - try to win!
TicTac(Pos1, Pos2) = Computer
END SUB
