{**************************************************************************}
{              㠫쭠 ॠ쭮. ᥪ⥫ 祩                    }
{                CopyRight (c) 1997 by AVK_SOFT                            }
{**************************************************************************}

{$I GRAPH13.INC}
{$I MATH.INC}

{  襭 짮⥫ ࠢ ஦  }
var
 UserErrorFlag:byte;

{  嬥୮  }
var
 SpriteAngels:array[0..319] of integer;
 WallsDist:array[0..319] of longint; { ﭨ  ᮢ ⥭ }
 WallsBottoms:array[0..319] of byte; {  ࠭ ⥭  ࠭ }
 { ଠ  䠩 }
 Walls:array[0..63,0..63] of byte; {  ⥭ }
 Floor:array[0..63,0..63] of byte; {   }
 Ceil:array[0..63,0..63] of byte;  {  ⮫ }

{  }
const
 MaxTextures=16; {  ⢮ ⥪ }
type
 TTextures=array[0..MaxTextures*4096-2] of byte;
 PTextures=^TTextures;
var
 WCTextures:PTextures; {  ⥭  ⮫}
 FTextures:PTextures; {  }
 STextures1:PTextures; {  ࠩ⮢}
 STextures2:PTextures; {  ࠩ⮢}

{ ࠩ }
const
 MaxSprites=50; { ᨬ쭮 ⢮ ࠩ⮢ }
 TotalSprites:byte=1; { 饥 ⢮ ࠩ⮢ }

type
 TSprite=record
  Name:byte;
  ID:byte;
  x,y:integer;
  Ray:integer;
  Scale:integer;
  Dist:longint;
  Dir:byte;
  Images:array[0..7] of byte;
  ViewImage:byte;{  ࠩ}
 end;

var
 Sprites:array[1..MaxSprites] of TSprite; { ᨢ ࠩ⮢ }

{ ப }
type
 TPlayer=record
  x,y:integer;
  view_angle:longint;
  Radius:byte;
  Dx,Dy:integer;
  Speed:integer;
  Rule:integer;
  Orient:integer;
 end;

{$I USER.INC}

{--------------------------------------------------------------------------}
{                         㦥 楤                              }
{--------------------------------------------------------------------------}
procedure InitTextures;
var
 j:word;
 F:file;
begin
 New(WCTextures);
 New(FTextures);
 New(STextures1);
 New(STextures2);
 Assign(F,'ttr.dat');
 Reset(F,1);
 BlockRead(F,WCTextures^,MaxTextures*4096-2,j);
 Close(F);
 Assign(F,'ttr2.dat');
 Reset(F,1);
 BlockRead(F,STextures1^,MaxTextures*4096-2,j);
 Close(F);
 Assign(F,'ttr3.dat');
 Reset(F,1);
 BlockRead(F,STextures2^,MaxTextures*4096-2,j);
 Close(F);
 Assign(F,'ttr1.dat');
 Reset(F,MaxTextures*4096-2);
 BlockRead(F,FTextures^,1,j);
 Close(F);
end;

procedure DoneTextures;
var
 i:byte;
begin
 Dispose(WCTextures);
 Dispose(FTextures);
 Dispose(STextures1);
 Dispose(STextures2);
end;

procedure LoadWorld;
var
 F:text;
 s:string;
 i,j:integer;
begin
 Assign(F,'walls.dat');
 Reset(F);
 for i:=0 to 63 do
  begin
   ReadLn(F,s);
   for j:=0 to 63 do
    if s[j+1]=' ' then Walls[i,j]:=0 else Walls[i,j]:=ord(s[j+1])-ord('0');
  end;
 Close(F);
 Assign(F,'floor.dat');
 Reset(F);
 for i:=0 to 63 do
  begin
   ReadLn(F,s);
   for j:=0 to 63 do
    if s[j+1]=' ' then Floor[i,j]:=0 else Floor[i,j]:=ord(s[j+1])-ord('0');
  end;
 Close(F);
 Assign(F,'ceil.dat');
 Reset(F);
 for i:=0 to 63 do
  begin
   ReadLn(F,s);
   for j:=0 to 63 do
    if s[j+1]=' ' then Ceil[i,j]:=0 else Ceil[i,j]:=ord(s[j+1])-ord('0');
  end;
 Close(F);
end;


{--------------------------------------------------------------------------}
{                      楤 ᮢ ࠩ⮢                       }
{--------------------------------------------------------------------------}
{   ࠩ⮢ }
procedure CalculateSprites(P:TPlayer);
var
 i:byte;
 dx,dy,rx,ry:longint;
 tn,tan30:real;
 scale:longint;
 rac:integer; {}
begin
 tan30:=Tan_Table^[ANGLE_30];
 for i:=1 to TotalSprites do
  begin
   { ࠩ  }
   Sprites[i].Ray:=-6666;
   {  ⠭樨  ப }
   dx:=Sprites[i].x-P.x;
   dy:=Sprites[i].y-P.y;
   Sprites[i].Dist:=LongSqrt(dx*dx+dy*dy);
   if Sprites[i].Dist=0 then Sprites[i].dist:=1;
   scale:=CosDist_Table^[160] div Sprites[i].dist;
   if scale>200 then scale:=200;
   Sprites[i].Scale:=scale;
   {    業 ࠩ }
   { 稢 dx,dy  㣮 ७ ப }
   rx:=(dx*Cos_Table^[P.View_angle]+dy*Sin_Table^[P.View_Angle]);
   ry:=(dy*Cos_Table^[P.View_angle]-dx*Sin_Table^[P.View_Angle]);
   if rx=0 then rx:=1;
   tn:=ry/rx; { 㣫  ப  ࠩ⮬}
   if ((rx>0) and (ry>0)) or ((rx>0) and (ry<0)) then
    begin
     if abs(tn)<tan30 then  {ࠩ    ?}
       Sprites[i].Ray:=160+trunc(160*tn/tan30);{ }
     { 뢠 ࠪ ࠩ }
     if (dx>0) and (dy>0) and (abs(dx)>=abs(dy))
      then rac:=Add7(0,Sprites[i].Dir);
     if (dx>0) and (dy>0) and (abs(dx)<abs(dy))
      then rac:=Add7(1,Sprites[i].Dir);
     if (dx>0) and (dy<0) and (abs(dx)>=abs(dy))
      then rac:=Add7(7,Sprites[i].Dir);
     if (dx>0) and (dy<0) and (abs(dx)<abs(dy))
      then rac:=Add7(6,Sprites[i].Dir);

     if (dx<0) and (dy>0) and (abs(dx)>=abs(dy))
      then rac:=Add7(3,Sprites[i].Dir);
     if (dx<0) and (dy>0) and (abs(dx)<abs(dy))
      then rac:=Add7(2,Sprites[i].Dir);
     if (dx<0) and (dy<0) and (abs(dx)>=abs(dy))
      then rac:=Add7(4,Sprites[i].Dir);
     if (dx<0) and (dy<0) and (abs(dx)<abs(dy))
      then rac:=Add7(5,Sprites[i].Dir);
     Sprites[i].ViewImage:=rac;
    end;
  end;
end;

{ ᮢ ࠩ }
procedure DrawSprite(n:byte);
var
 scale,scale1:integer;
 ray,r:integer;
 i,j,k:integer;
 col,top,addr1,addr:word;
 t,p:byte;
 f:boolean;
begin
 ray:=Sprites[n].ray;
 if ray<0 then exit; {᫨ ࠩ  ,   㥬}
 scale:=Sprites[n].scale;
 scale1:=scale;
 scale:=scale shr 1;
 {ᮢ ⥪ ࠩ}
 t:=Sprites[n].Images[Sprites[n].ViewImage]; { 뢮 ⥪}
 f:=false;
 if t>16 then begin t:=t-16;f:=true;end;
 for i:=-scale to scale do
  begin
   col:=(i+scale)*63 div scale1;
   r:=ray+i;
   if (Sprites[n].Dist<WallsDist[r]) and (r>=0) and (r<320) then
    begin
     if scale1>200 then scale1:=200;
     top:=(200-scale1) shr 1;
     addr1:=(t-1) shl 12+(col shl 6);
     for k:=0 to scale1 do
      begin
       j:=((k shl 6)-k) div scale1;
       addr:=top shl 8+top shl 6+r;
       if f then p:=STextures2^[addr1+j] else p:=STextures1^[addr1+j];
       if p<>0 then VideoBuffer^[addr]:=p;
       Inc(top);
      end;
    end;
  end;
end;

{ ᮢ ࠩ⮢ }
procedure DrawSprites(P:TPlayer);
var
 i,j:byte;
 S:TSprite;
begin
 MoveSprites;
 CalculateSprites(P);
 { ࢪ ࠩ⮢ }
 for i:=1 to TotalSprites-1 do
  for j:=i+1 to TotalSprites do
   if Sprites[i].Dist<Sprites[j].Dist then
    begin
     s:=Sprites[i];
     Sprites[i]:=Sprites[j];
     Sprites[j]:=s;
    end;
 {  ᮢ }
 for i:=1 to TotalSprites do DrawSprite(i);
end;

{--------------------------------------------------------------------------}
{                      楤 ᥪ⥫ 祩                          }
{--------------------------------------------------------------------------}
{ ᮢ  ⥪ }
procedure DrawTextureLine(aray,ascale,atype,acol:word);
var
 i,j:word;
 p:byte;
 top:word;
 addr,addr1:word;
begin
 if ascale>200 then ascale:=200;
 top:=(200-ascale) shr 1;
 WallsBottoms[aray]:=top+ascale;
 addr1:=(atype-1) shl 12+(acol shl 6);
 for i:=0 to ascale do
  begin
   j:=((i shl 6)-i) div ascale;
   addr:=top shl 8+top shl 6+aray;
   p:=WCTextures^[addr1+j];
   VideoBuffer^[addr]:=p;
   Inc(top);
  end;
end;

{ ᮢ /⮫ }
procedure FloorCeil_Caster(P:TPlayer);
var
 i,row:word;
 ang:integer;
 bot:byte;
 d:longint;
 xv,yv:longint;
 cell_x,cell_y:integer;
 T:byte;
 Pixel:byte;
begin
 for i:=0 to 319 do
  begin
   ang:=p.view_angle+(i-160);
   if (ang<ANGLE_0) then ang:=ang+ANGLE_360;
   if (ang>=ANGLE_360) then ang:=ang-ANGLE_360;
   bot:=WallsBottoms[i];
   for row:=bot+1 to 199 do
    begin
     d:=CosDist_Table^[i] div (2*row-199);
     yv:=p.y+d*sin_table^[ang] shr 10;
     xv:=p.x+d*cos_table^[ang] shr 10;
     cell_x:=xv shr 6;
     cell_y:=yv shr 6;
     {  }
     T:=Floor[cell_y,cell_x];
     If T<>0 then
       Pixel:=FTextures^[(T-1)shl 12+(yv and 63) shl 6+(xv and 63)]
     else Pixel:=0;
     VideoBuffer^[((row shl 8)+(row shl 6))+i]:=Pixel;
     { ⮫ }
     T:=Ceil[cell_y,cell_x];
     If T<>0 then
       Pixel:=WCTextures^[(T-1)shl 12+(yv and 63) shl 6+(xv and 63)]
     else Pixel:=1;
     VideoBuffer^[(((200-row) shl 8)+((200-row) shl 6))+i]:=Pixel;
    end;
  end;
end;


{ ᥪ⥫ 祩 }
var
 ray,cell_x,cell_y,xb_save,yb_save,x_hit_type,y_hit_type,top,bottom:integer;
 xi_save,yi_save,scale:longint;
 dist_x,dist_y:longint;

procedure Cast_X_Ray(P:TPlayer);
var
 x_bound,x_delta,next_x_cell,ystep:longint;
 yi:real;
begin
 if (p.view_angle<ANGLE_90) or (p.view_angle>=ANGLE_270) then
  begin
   x_bound:=64+(p.x and $FFC0);
   x_delta:=64;
   next_x_cell:=0;
  end
 else
  begin
   x_bound:=p.x and $FFC0;
   x_delta:=-64;
   next_x_cell:=-1;
  end;
 yi:=tan_table^[p.view_angle]*(x_bound-p.x)+p.y;
 while true do
  begin
   cell_x:=((x_bound+next_x_cell) SHR 6);
   cell_y:=trunc(yi);
   cell_y:=cell_y SHR 6;
   x_hit_type:=Walls[cell_y,cell_x];
   if (x_hit_type<>0) then
    begin
     dist_x:=trunc((yi-p.y)*inv_sin_table^[p.view_angle]);
     yi_save:=trunc(yi);
     xb_save:=x_bound;
     exit;
    end
   else
    begin
     yi:=yi+y_step^[p.view_angle];
     x_bound:=x_bound+x_delta;
    end;
  end;
end;

procedure Cast_Y_Ray(P:TPlayer);
var
 y_bound,y_delta,next_y_cell,xstep:longint;
 xi:real;
begin
 if (p.view_angle>=ANGLE_0) and (p.view_angle<ANGLE_180) then
  begin
   y_bound:=64+(p.y and $FFC0);
   y_delta:=64;
   next_y_cell:=0;
  end
 else
  begin
   y_bound:=p.y and $FFC0;
   y_delta:=-64;
   next_y_cell:=-1;
  end;
 xi:=inv_tan_table^[p.view_angle]*(y_bound-p.y)+p.x;
 while true do
  begin
   cell_x:=trunc(xi);
   cell_x:=cell_x SHR 6;
   cell_y:=((y_bound+next_y_cell) SHR 6);
   y_hit_type:=Walls[cell_y,cell_x];
   if (y_hit_type<>0) then
    begin
     dist_y:=trunc((xi-p.x)*inv_cos_table^[p.view_angle]);
     xi_save:=trunc(xi);
     yb_save:=y_bound;
     exit;
    end
   else
    begin
     xi:=xi+x_step^[p.view_angle];
     y_bound:=y_bound+y_delta;
    end;
  end;
end;

procedure Ray_Caster(P:TPlayer);
var
 NewP:TPlayer;
begin
 NewP:=P;
 NewP.view_angle:=NewP.view_angle-ANGLE_30;
 if NewP.view_angle<0 then NewP.view_angle:=ANGLE_360+NewP.view_angle;
 for ray:=0 to 319 do
  begin
   Cast_Y_Ray(NewP);
   Cast_X_Ray(NewP);
    if (dist_x<dist_y) then
     begin
      if dist_x>0 then
       begin
        WallsDist[ray]:=dist_x;
        scale:=CosDist_Table^[ray] div dist_x;
        if scale>0
         then DrawTextureLine(ray,scale,x_hit_type,yi_save and $003F);
       end;
     end
    else
     begin
      if dist_y>0 then
       begin
        WallsDist[ray]:=dist_y;
        scale:=CosDist_Table^[ray] div dist_y;
        if scale>0
         then DrawTextureLine(ray,scale,y_hit_type,xi_save and $003F);
       end;
     end;
    Inc(NewP.view_angle);
    if NewP.view_angle>=ANGLE_360 then NewP.view_angle:=0;
   end;
 NewP:=P;
 FloorCeil_Caster(NewP);
end;

{ ᮢ ࠭ }
procedure DrawAllScreen(P:TPlayer);
begin
 Ray_Caster(P);
 DrawSprites(P);
 Rectangle(0,0,319,199,0);
 OutInteger(280,5,P.Speed*3,14);
 if UserErrorFlag>0 then Bar(1,1,20,10,Red);
 ShowVideoBuffer;
end;
