   { ************************************* }
   { Text Window Unit                      }
   { Window system version 1.5             }
   { Copyright (c) 18.01.95 , AVK_SOFT     }
   { Programmed by A.V.Kuznetsov           }
   { ************************************* }

{  ꥪ⮢ (IDNumber) }
{ TView - 0                  }
{ TWindow - 1                }
{ TMenuString - 2            }
{ TMenu - 3                  }
{ TButton - 4                }
{ TScrollBar - 5             }
{ TLineScrollBar - 6         }
{ TListBox - 7               }
{ TFileSelection - 8         }
{ TPerCentLine - 9           }


unit TWU;

interface
uses Crt,Dos;

{  䮭 }
const
 _Black=0;
 _Blue=16;
 _Green=32;
 _Cyan=48;
 _Red=64;
 _Magenta=80;
 _Brown=96;
 _DarkGray=112;

{ Colors Constants }
{  :                     }
{ A - 梥 ࠬ          }
{ B - 梥 ⥪        }
{ C - 梥 .⥪         }
{ D - .梥 1              }
{ E - .梥 2              }
const
{  A (BLUE)            }
 clAA   =    27;
 clAB   =    Blue*16+Yellow;
 clAC   =    94;
 clAD   =    Blue*16+White;
 clAE   =    Blue*16+Black;

{  B (GRAY)            }
 clBA   =    7*16+White;
 clBB   =    7*16+Black;
 clBC   =    95;
 clBD   =    7*16+White;
 clBE   =    7*16+Black;

{  C (RED)             }
 clCA   =    Red*16+LightGreen;
 clCB   =    Red*16+Yellow;
 clCC   =    96;
 clCD   =    Red*16+White;
 clCE   =    Red*16+Black;

{  D (BLACK)           }
 clDA   =    Black*16+LightGreen;
 clDB   =    Black*16+Yellow;
 clDC   =    96;
 clDD   =    Black*16+White;
 clDE   =    Black*16+DarkGray;

{ Frame Constants }
 frSingle =  01;
 frDouble =  02;

{ Shadow Constants }
 shNormal =  08;
 shLight  =  07;
 shNo     =  00;

{ Wrap Constants }
 wrOn     =  true;
 wrOff    =  false;

{ Low Memory Size }
 LowMemorySize : word = 3000;

{ Service Procedures }
procedure WriteChar(ax,ay:shortint;achar:char);
procedure WriteAttr(ax,ay:shortint;aa:byte);
procedure SetChar(ax,ay:shortint;aw:word);
procedure WriteString(ax,ay:shortint;as:string;aa:byte);
procedure WriteAttrString(ax1,ay,ax2:shortint;aa:byte);
function ReadChar(ax,ay:shortint):char;
function ReadAttr(ax,ay:shortint):byte;
function GetChar(ax,ay:shortint):word;
procedure WriteDeskTop(aa:byte);
procedure WriteMenuBar(aa:byte);
procedure WriteStatusLine(aa:byte);
procedure ClearString(ax1,ay,ax2:shortint;aa:byte);
procedure HideCursor;
procedure DrawCursor;
function InputLine(ax,ay:shortint;an,aa:byte):string;
function InputDLine(ax,ay:shortint;an,aa:byte;as:string):string;
function InputPassword(ax,ay:shortint;an,aa:byte):string;
function LowMemory:boolean;{ TRUE ᫨ MaxAvail<LowMemorySize }
function DupSpace(n:byte):string;
function ChangeCaseString(as:string):string;
procedure WriteMessageBox(mess:string;aa1,aa2,ab1,ab2:byte);
procedure MessageBox(mess:string);
procedure ErrorBox(mess:string);
procedure PassiveBox(mess:string);
procedure WriteRight;
function MakeYesNoBox(ax,ay:shortint;mess,y,n:string):boolean;

{ Some Types }
type
 PWBuff=^TWBuff;
 TWBuff=array[0..1990] of word;

TKey=record
 CharCode:char;
 ScanCode:byte;
end;

procedure WaitKeyPressed(var AK:TKey);
procedure Pause;
procedure ClearKey(var AK:TKey);

{ Objects Types }

type
PView=^TView;
TView=object
 IDNumber:word;
 x1,y1,x2,y2:shortint;
 a1,a2:byte; { Attr 1 and 2 for TView }
 p:pointer;  { Pointer for TView Buffer }
 Title:string;

 constructor Init;
 destructor Done;virtual;
 procedure AssignTitle(at:string);
 procedure AssignXY(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure AssignColors(aa1,aa2:byte);virtual;
 function BuffSize(ax1,ay1,ax2,ay2:shortint):word;virtual;
 procedure SaveBuff(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure LoadBuff(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure DrawBuff(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure FreeBuff(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure MoveToCentre(ah,av:byte);virtual;
 function GetClipString(as:string):string;virtual;
end;


procedure CopyBlock(ax1,ay1,ax2,ay2,bx1,by1:shortint);

type
PWindow=^TWindow;
TWindow=object(TView)
 frame:array[1..6] of byte;
 shadow:byte;
 delaysize:word;

 constructor Init;
 destructor Done;virtual;
 procedure AssignFrame(af:byte);virtual;
 procedure AssignShadow(ash:byte);virtual;
 procedure AssignDelay(ad:word);virtual;
 procedure DrawFrame;virtual;
 procedure DrawBar;virtual;
 procedure DrawShadow;virtual;
 procedure OpenHorizontal;virtual;
 procedure OpenVertical;virtual;
 function GetTitleString(as:string):string;virtual;
 procedure Draw;virtual;
 procedure Hide;virtual;
end;

type
PMenuString=^TMenuString;
TMenuString=object(TView)
 y:shortint;
 wrap:boolean;

 constructor Init;
 destructor Done;virtual;
 procedure AssignLineColor(aa1:byte);
 procedure AssignXY(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure HandleKey(var AK:TKey);virtual;
 procedure Draw;virtual;
 procedure Hide;virtual;
 procedure AssignWrap(aw:boolean);virtual;
 function Execute:shortint;virtual;{ Returns -127 when ESC was pressed or Y}
                           { when ENTER was pressed                }
end;

type
 PMenuList=^TMenuList;
 TMenuList=array[1..23] of string;

type
PMenu=^TMenu;
TMenu=object(TWindow)
 MenuList:PMenuList;
 Focussed:byte;
 MaxL:byte;
 Point:TMenuString;

 constructor Init;
 procedure AssignWrap(aw:boolean);
 procedure AssignPlace(ax,ay:shortint);
 function GetMaxLength:byte;virtual;
 procedure AddMenuItem(as:string);virtual;
 procedure AssignFocussed(af:byte);virtual;
 procedure DrawList;virtual;
 procedure Draw;virtual;
 function Execute:shortint;virtual;
 destructor Done;virtual;
end;

type
PButton=^TButton;
TButton=object(TView)
 delaysize:word;

 constructor Init;
 destructor Done;virtual;
 procedure AssignDelay(ad:word);virtual;
 procedure DrawBar;virtual;
 procedure DrawLeftUpAngl(aa:byte);virtual;
 procedure DrawRightDownAngl(aa:byte);virtual;
 procedure Draw;virtual;
 procedure Hide;virtual;
 procedure Push;virtual;
end;

type
PScrollBar=^TScrollBar;
TScrollBar=object(TWindow)
 current:longint;  { Current in listing }
 MaxS:longint;     { Max in listing }
 py:shortint;      { Pointer on Scroll line }

 constructor Init;
 destructor Done;virtual;
 procedure AssignLimit(am:longint);virtual;
 procedure AssignXY(ax1,ay1,ax2,ay2:shortint);virtual;
 procedure DrawInterior;virtual;
 procedure DrawScrolling;virtual;
 procedure Draw;virtual;
 procedure OpenVertical;virtual;
 procedure OpenHorizontal;virtual;
 procedure Hide;virtual;
 procedure HandleKey(var AK:TKey);virtual;
 procedure WriteScrollPosition;virtual;
 function Execute:longint;virtual; { Retruns 0 when ESC was pressed }
                                   { Returns current when ENTER     }
end;

type
PLineScrollBar=^TLineScrollBar;
TLineScrollBar=object(TScrollBar)
 la:byte;  { Attr for Line }
 y:shortint; { Line position on screen }

 constructor Init;
 destructor Done;virtual;
 procedure Hide;virtual;
 procedure Draw;virtual;
 procedure DrawInterior;virtual;
 procedure AssignLineColor(aa:byte);virtual;
 procedure AssignXY(ax1,ay1,ax2,ay2:shortint);virtual;
 function Execute:longint;virtual; { Retruns 0 when ESC was pressed }
                                   { Returns current+y-y1-1 when ENTER }
end;

type
 TList=array[1..800] of string[80];
 PList=^TList;

type
PListBox=^TListBox;
TListBox=object(TLineScrollBar)
 List:PList;
 Focussed:word;

 constructor Init;
 destructor Done;virtual;
 procedure DrawInterior;virtual;
 procedure AddItem(as:string);virtual;
end;

type
 TFileArray=array[1..500] of SearchRec;
 PFileArray=^TFileArray;

type
PFileSelection=^TFileSelection;
TFileSelection=object(TLineScrollBar)
 FileArray:PFileArray;
 Mask:string;

 constructor Init;
 destructor Done;virtual;
 procedure DrawInterior;virtual;
 procedure AssignMask(amask:string);
 procedure AssignPlace(ax,ay1,ay2:shortint);
 procedure Draw;virtual;
 function Compare(key1,key2:word):integer;virtual;
 procedure SortDirectory;virtual;
 procedure GetDirectory;
 function Run:string;  { Returns message,error or path string }
end;

type
PPerCentLine=^TPerCentLine;
TPerCentLine=object(TView)
 fill1,fill2:char;

 constructor Init;
 destructor Done;virtual;
 procedure AssignFillChars(af1,af2:char);virtual;
 procedure Draw;virtual;
 procedure Hide;virtual;
 procedure WritePerCent(ap:byte);virtual;
end;

implementation

{ Service Procedures }

procedure WriteChar(ax,ay:shortint;achar:char);
begin
 if (ax<0) or (ax>79) then exit;
 if (ay<0) or (ay>24) then exit;
 mem[$B800:(ax+ay*80)*2]:=ord(achar);
end;

procedure WriteAttr(ax,ay:shortint;aa:byte);
begin
 if (ax<0) or (ax>79) then exit;
 if (ay<0) or (ay>24) then exit;
 mem[$B800:(ax+ay*80)*2+1]:=aa;
end;

procedure SetChar(ax,ay:shortint;aw:word);
begin
 if (ax<0) or (ax>79) then exit;
 if (ay<0) or (ay>24) then exit;
 memw[$B800:(ax+ay*80)*2]:=aw;
end;

procedure WriteString(ax,ay:shortint;as:string;aa:byte);
var
 i:byte;
begin
 for i:=1 to length(as) do
   SetChar(ax+i-1,ay,ord(as[i])+aa*256);
end;

procedure WriteAttrString(ax1,ay,ax2:shortint;aa:byte);
var
 i:shortint;
begin
 for i:=ax1 to ax2 do WriteAttr(i,ay,aa);
end;

function ReadChar(ax,ay:shortint):char;
begin
 if (ax<0) or (ax>79) then exit;
 if (ay<0) or (ay>24) then exit;
 ReadChar:=chr(mem[$b800:(ax+ay*80)*2]);
end;

function ReadAttr(ax,ay:shortint):byte;
begin
 if (ax<0) or (ax>79) then exit;
 if (ay<0) or (ay>24) then exit;
 ReadAttr:=mem[$b800:(ax+ay*80)*2+1];
end;

function GetChar(ax,ay:shortint):word;
begin
 if (ax<0) or (ax>79) then exit;
 if (ay<0) or (ay>24) then exit;
 GetChar:=memw[$b800:(ax+ay*80)*2];
end;

procedure WriteDeskTop(aa:byte);
var
 i,j:byte;
begin
 for i:=0 to 79 do
  for j:=0 to 24 do SetChar(i,j,177+aa*256);
end;

procedure WriteMenuBar(aa:byte);
var
 i:byte;
begin
 for i:=0 to 79 do SetChar(i,0,32+aa*256);
end;

procedure WriteStatusLine(aa:byte);
var
 i:byte;
begin
 for i:=0 to 79 do SetChar(i,24,32+aa*256);
end;

procedure ClearString(ax1,ay,ax2:shortint;aa:byte);
var
 i:shortint;
begin
 for i:=ax1 to ax2 do SetChar(i,ay,32+aa*256);
end;

procedure HideCursor;
var
 r:registers;
begin
 r.ah:=$01;
 r.ch:=$20;
 r.cl:=$20;
 Intr($10,r);
end;

procedure DrawCursor;
var
 r:registers;
begin
 r.ah:=$01;
 r.ch:=$09;
 r.cl:=$0A;
 Intr($10,r);
end;

procedure WaitKeyPressed(var AK:TKey);
begin
 while not keypressed do begin end;
 AK.CharCode:=ReadKey;
 if ord(AK.CharCode)=0 then AK.ScanCode:=ord(ReadKey);
end;

procedure Pause;
var
 k:TKey;
begin
 WaitKeyPressed(k);
end;

procedure ClearKey(var AK:TKey);
begin
 AK.CharCode:=chr(0);
 AK.ScanCode:=0;
end;

function InputLine(ax,ay:shortint;an,aa:byte):string;
var
 fs:string;
 ip:byte;
 k:tkey;
 ox:shortint;
begin
 for ip:=ax to ax+an do WriteAttr(ip,ay,aa);
 fs:='';
 if an=0 then an:=1;
 ip:=0;
 ox:=ax;
 SetChar(ax,ay,ord('_')+256*aa);
 while ip<an+1 do
  begin
   waitkeypressed(k);
   if (k.CharCode=chr(27)) then
    begin
     ClearString(ox,ay,ox+an,aa);
     ip:=0;
     ax:=ox;
     fs:='';
     SetChar(ax,ay,ord('_')+256*aa);
    end;
   if (ord(k.CharCode)=8) and (ip>0) then
    begin
     SetChar(ax,ay,32+256*aa);
     ip:=ip-1;
     ax:=ax-1;
     SetChar(ax,ay,ord('_')+256*aa);
     delete(fs,ip+1,2);
    end;
   if k.CharCode=chr(13) then
    begin
     InputLine:=fs;
     SetChar(ax,ay,32+256*aa);
     exit;
    end;
   if (ord(k.CharCode) in [32..254]) and (ip<an) then
    begin
     SetChar(ax,ay,ord(k.CharCode)+256*aa);
     ax:=ax+1;
     fs:=fs+k.CharCode;
     ip:=ip+1;
     SetChar(ax,ay,ord('_')+256*aa);
    end;
  end;
end;

{  ப  祭  㬮砭 as }
function InputDLine(ax,ay:shortint;an,aa:byte;as:string):string;
var
 fs:string;
 ip:byte;
 k:tkey;
 ox:shortint;
begin
 for ip:=ax to ax+an do WriteAttr(ip,ay,aa);
 fs:=Copy(as,1,an);
 WriteString(ax,ay,fs,aa);
 if an=0 then an:=1;
 ip:=length(fs);
 ox:=ax;
 ax:=ax+ip;
 SetChar(ax,ay,ord('_')+256*aa);
 while ip<an+1 do
  begin
   waitkeypressed(k);
   if (k.CharCode=chr(27)) then
    begin
     ClearString(ox,ay,ox+an,aa);
     ip:=0;
     ax:=ox;
     fs:='';
     SetChar(ax,ay,ord('_')+256*aa);
    end;
   if (ord(k.CharCode)=8) and (ip>0) then
    begin
     SetChar(ax,ay,32+256*aa);
     ip:=ip-1;
     ax:=ax-1;
     SetChar(ax,ay,ord('_')+256*aa);
     delete(fs,ip+1,2);
    end;
   if k.CharCode=chr(13) then
    begin
     InputDLine:=fs;
     SetChar(ax,ay,32+256*aa);
     exit;
    end;
   if (ord(k.CharCode) in [32..254]) and (ip<an) then
    begin
     SetChar(ax,ay,ord(k.CharCode)+256*aa);
     ax:=ax+1;
     fs:=fs+k.CharCode;
     ip:=ip+1;
     SetChar(ax,ay,ord('_')+256*aa);
    end;
  end;
end;

function InputPassword(ax,ay:shortint;an,aa:byte):string;
var
 fs:string;
 ip:byte;
 k:tkey;
 ox:shortint;
begin
 for ip:=ax to ax+an do WriteAttr(ip,ay,aa);
 fs:='';
 if an=0 then an:=1;
 ip:=0;
 ox:=ax;
 SetChar(ax,ay,ord('_')+256*aa);
 while ip<an+1 do
  begin
   waitkeypressed(k);
   if (k.CharCode=chr(27)) then
    begin
     ClearString(ox,ay,ox+an,aa);
     ip:=0;
     ax:=ox;
     fs:='';
     SetChar(ax,ay,ord('_')+256*aa);
    end;
   if (ord(k.CharCode)=8) and (ip>0) then
    begin
     SetChar(ax,ay,32+256*aa);
     ip:=ip-1;
     ax:=ax-1;
     SetChar(ax,ay,ord('_')+256*aa);
     delete(fs,ip+1,2);
    end;
   if k.CharCode=chr(13) then
    begin
     InputPassword:=fs;
     SetChar(ax,ay,32+256*aa);
     exit;
    end;
   if (ord(k.CharCode) in [32..254]) and (ip<an) then
    begin
     SetChar(ax,ay,ord('*')+256*aa);
     ax:=ax+1;
     fs:=fs+k.CharCode;
     ip:=ip+1;
     SetChar(ax,ay,ord('_')+256*aa);
    end;
  end;
end;

function ChangeCaseString(as:string):string;
var
 i:byte;
 s:string;
begin
 s:=as;
 for i:=1 to length(as) do
  if (as[i] in ['A'..'Z']) or (as[i] in ['a'..'z']) then
   s[i]:=chr(ord(as[i]) xor 32);
 ChangeCaseString:=s;
end;

function LowMemory:boolean;
begin
 LowMemory:=MaxAvail<LowMemorySize;
end;

function DupSpace(n:byte):string;
var
 s:string;
 i:byte;
begin
 s:='';
 for i:=1 to n do s:=s+' ';
 DupSpace:=s;
end;

{ TView Methods }
constructor TView.Init;
begin
 IDNumber:=0;
 x1:=5;
 y1:=5;
 x2:=75;
 y2:=20;
 a1:=clAA;
 a2:=clAB;
end;

destructor TView.Done;
begin
end;

procedure TView.AssignTitle(at:string);
begin
 Title:=at;
end;

procedure TView.AssignXY(ax1,ay1,ax2,ay2:shortint);
begin
 x1:=ax1;
 y1:=ay1;
 x2:=ax2;
 y2:=ay2;
end;

procedure TView.AssignColors(aa1,aa2:byte);
begin
 a1:=aa1;
 a2:=aa2;
end;

function TView.BuffSize(ax1,ay1,ax2,ay2:shortint):word;
begin
 BuffSize:=abs(ax2-ax1+1)*(ay2-ay1+1)*2;
end;

procedure TView.SaveBuff(ax1,ay1,ax2,ay2:shortint);
var
 i,j:shortint;
begin
 GetMem(p,BuffSize(ax1,ay1,ax2,ay2));
  for i:=ay1 to ay2 do
   for j:=ax1 to ax2 do
    PWBuff(p)^[(j-ax1)+(i-ay1)*(ax2-ax1+1)]:=GetChar(j,i);
end;


procedure TView.LoadBuff(ax1,ay1,ax2,ay2:shortint);
var
 i,j:shortint;
begin
 for i:=ay1 to ay2 do
  for j:=ax1 to ax2 do
   SetChar(j,i,PWBuff(p)^[(j-ax1)+(i-ay1)*(ax2-ax1+1)]);
   FreeMem(p,BuffSize(ax1,ay1,ax2,ay2));
end;

procedure TView.DrawBuff(ax1,ay1,ax2,ay2:shortint);
var
 i,j:shortint;
begin
 for i:=ay1 to ay2 do
  for j:=ax1 to ax2 do
   SetChar(j,i,PWBuff(p)^[(j-ax1)+(i-ay1)*(ax2-ax1+1)]);
end;

procedure TView.FreeBuff(ax1,ay1,ax2,ay2:shortint);
begin
 FreeMem(p,BuffSize(ax1,ay1,ax2,ay2));
end;

procedure TView.MoveToCentre(ah,av:byte);
begin
 x1:=(80-ah) div 2;
 x2:=x1+ah-1;
 y1:=(25-av) div 2;
 y2:=y1+av-1;
end;

function TView.GetClipString(as:string):string;
var
 i:byte;
 s:string;
begin
 s:='';
 if Length(as)>=(x2-x1-1) then
   begin
   GetClipString:=copy(as,1,x2-x1-1);
   exit;
   end;
 for i:=Length(as) to (x2-x1-2) do s:=s+' ';
 GetClipString:=as+s;
end;

procedure CopyBlock(ax1,ay1,ax2,ay2,bx1,by1:shortint);
var
 b:TView;
begin
 b.Init;
 b.SaveBuff(ax1,ay1,ax2,ay2);
 b.LoadBuff(bx1,by1,bx1+(ax2-ax1),by1+(ay2-ay1));
end;

{ TWindow Methods }

constructor TWindow.Init;
begin
 TView.Init;
 IDNumber:=1;
 frame[1]:=196;
 frame[2]:=179;
 frame[3]:=218;
 frame[4]:=191;
 frame[5]:=192;
 frame[6]:=217;
 shadow:=shNormal;
 delaysize:=30;
 Title:='';
end;

destructor TWindow.Done;
begin
 TView.Done;
 LoadBuff(x1,y1,x2+2,y2+1);
end;

procedure TWindow.Hide;
begin
 LoadBuff(x1,y1,x2+2,y2+1);
end;

procedure TWindow.AssignFrame(af:byte);
var
 i:byte;
begin
if af=frSingle then
   begin
   frame[1]:=196;
   frame[2]:=179;
   frame[3]:=218;
   frame[4]:=191;
   frame[5]:=192;
   frame[6]:=217;
   exit;
   end;
if af=frDouble then
   begin
   frame[1]:=205;
   frame[2]:=186;
   frame[3]:=201;
   frame[4]:=187;
   frame[5]:=200;
   frame[6]:=188;
   exit;
   end;
for i:=i to 6 do frame[i]:=af;
end;

procedure TWindow.AssignShadow(ash:byte);
begin
 shadow:=ash;
end;

procedure TWindow.AssignDelay(ad:word);
begin
 delaysize:=ad;
end;

procedure TWindow.DrawFrame;
var
 i:shortint;
begin
 for i:=x1+1 to x2-1 do
  begin
  SetChar(i,y1,frame[1]+256*a1);
  SetChar(i,y2,frame[1]+256*a1);
  end;
 for i:=y1+1 to y2-1 do
  begin
  SetChar(x1,i,frame[2]+256*a1);
  SetChar(x2,i,frame[2]+256*a1);
  end;
 SetChar(x1,y1,frame[3]+256*a1);
 SetChar(x2,y1,frame[4]+256*a1);
 SetChar(x1,y2,frame[5]+256*a1);
 SetChar(x2,y2,frame[6]+256*a1);
 WriteString(x1+1,y1,GetTitleString(Title),a1);
end;

procedure TWindow.DrawBar;
var
 i,j:shortint;
begin
 for i:=x1+1 to x2-1 do
  for j:=y1+1 to y2-1 do
   SetChar(i,j,32+256*a2);
end;

procedure TWindow.DrawShadow;
var
 i:shortint;
begin
 if shadow=0 then exit;
 for i:=x1+2 to x2+1 do WriteAttr(i,y2+1,shadow);
 for i:=y1+1 to y2+1 do WriteAttr(x2+1,i,shadow);
 for i:=y1+1 to y2+1 do WriteAttr(x2+2,i,shadow);
end;

function TWindow.GetTitleString(as:string):string;
var
 i:byte;
 s:string;
begin
 s:='';
 if Length(as)>=(x2-x1-1) then
   begin
   GetTitleString:=copy(as,1,x2-x1-1);
   exit;
   end;
 GetTitleString:=as;
end;

procedure TWindow.Draw;
begin
 SaveBuff(x1,y1,x2+2,y2+1);
 DrawFrame;
 DrawBar;
 DrawShadow;
end;

procedure TWindow.OpenVertical;
var
 i,j:shortint;
 ax1,ax2,ay1,ay2:shortint;
begin
 SaveBuff(x1,y1,x2+2,y2+1);
 ax1:=x1;
 ax2:=x2;
 ay1:=y1;
 ay2:=y2;
 for i:=y1+1 to ay2 do
  begin
   y2:=i;
   Delay(delaysize);
   DrawFrame;
   DrawBar;
   DrawShadow;
  end;
end;

procedure TWindow.OpenHorizontal;
var
 i,j:shortint;
 ax1,ax2,ay1,ay2:shortint;
begin
 SaveBuff(x1,y1,x2+2,y2+1);
 ax1:=x1;
 ax2:=x2;
 ay1:=y1;
 ay2:=y2;
 for i:=x1+1 to ax2 do
  begin
   x2:=i;
   Delay(delaysize);
   DrawFrame;
   DrawBar;
   DrawShadow;
  end;
end;

procedure WriteMessageBox(mess:string;aa1,aa2,ab1,ab2:byte);
var
 W:TWindow;
 B:TButton;
 l:byte;
begin
 W.Init;
 B.Init;
 W.AssignColors(aa1,aa2);
 B.AssignColors(ab1,ab2);
 l:=length(mess);
 W.AssignXY(34-(l div 2),9,46+trunc(l/2+0.5),17);
 B.AssignXY(35,14,45,16);
 W.Draw;
 B.Draw;
 WriteString(40-(l div 2),11,mess,aa2);
 WriteString(39,15,'Ok.',aa2);
 Pause;
 B.Push;
 Delay(200);
 B.Done;
 W.Done;
end;

procedure MessageBox(mess:string);
begin
 WriteMessageBox(mess,clAA,clAB,clAD,clAE);
end;

procedure ErrorBox(mess:string);
begin
 WriteMessageBox(mess,clCA,clCB,clCD,clCE);
end;

procedure PassiveBox(mess:string);
begin
 WriteMessageBox(mess,clBA,clBB,clBD,clBE);
end;

procedure WriteRight;
var
 s1,s2,s3:string;
begin
 s1:='SAT$@#JHG*^%#@#';
 s2:='HFGDH$#@%**^%#VRR$^+';
 s3:='~@#!K^&W';
 ErrorBox('Using '+s1[3]+s3[8]+'U'+' by '+s1[2]+s2[15]+s3[5]+'_'+s1[1]+
           'O'+s2[2]+s1[3]);
end;

{ TMenuString Mehods }
constructor TMenuString.Init;
begin
 TView.Init;
 IDNumber:=2;
 y:=y1;
 a1:=clAC;
 Wrap:=wrOff;
end;

procedure TMenuString.AssignLineColor(aa1:byte);
begin
 a1:=aa1;
end;

procedure TMenuString.AssignWrap(aw:boolean);
begin
 wrap:=aw;
end;

procedure TMenuString.AssignXY(ax1,ay1,ax2,ay2:shortint);
begin
 TView.AssignXY(ax1,ay1,ax2,ay2);
 y:=y1;
end;

procedure TMenuString.HandleKey(var AK:TKey);
begin
end;

procedure TMenuString.Draw;
var
 i:shortint;
begin
 SaveBuff(x1,y,x2,y);
 for i:=x1 to x2 do WriteAttr(i,y,a1);
end;

procedure TMenuString.Hide;
begin
 LoadBuff(x1,y,x2,y);
end;

destructor TMenuString.Done;
begin
 LoadBuff(x1,y,x2,y);
end;

function TMenuString.Execute:shortint;
var
 k:tkey;
begin
  repeat
  WaitKeyPressed(k);
  HandleKey(k);
   if (k.ScanCode=72) and (y>y1) then
    begin
     Hide;
     Dec(y);
     Draw;
     ClearKey(k);
    end;
   if (k.ScanCode=80) and (y<y2) then
    begin
     Hide;
     Inc(y);
     Draw;
     ClearKey(k);
    end;
   if (k.ScanCode=72) and (y=y1) and Wrap then
    begin
     Hide;
     y:=y2;
     Draw;
     ClearKey(k);
    end;
   if (k.ScanCode=80) and (y=y2) and Wrap then
    begin
     Hide;
     y:=y1;
     Draw;
     ClearKey(k);
    end;
  until ((k.CharCode=chr(13)) or (k.CharCode=chr(27)));
if k.CharCode=chr(27) then Execute:=-127
                      else Execute:=y;
end;

{ TMenu Methods }
constructor TMenu.Init;
begin
 TWindow.Init;
 IDNumber:=3;
 a1:=clBA;
 a2:=clBB;
 x1:=1;
 y1:=1;
 Focussed:=1;
 MaxL:=0;
 Point.Init;
 New(MenuList);
end;

function TMenu.GetMaxLength:byte;
var
 i:byte;
 res:byte;
begin
 res:=1;
 for i:=1 to MaxL do
  if Length(MenuList^[i])>res then res:=Length(MenuList^[i]);
 if res>78 then res:=78;
 GetMaxLength:=res;
end;

procedure TMenu.AssignFocussed(af:byte);
begin
 Focussed:=af;
end;

procedure TMenu.AssignWrap(aw:boolean);
begin
 Point.AssignWrap(aw);
end;

procedure TMenu.AssignPlace(ax,ay:shortint);
begin
 x1:=ax;
 y1:=ay;
end;

procedure TMenu.DrawList;
var
 i:shortint;
begin
 if MaxL=0 then exit;
 for i:=y1+1 to y2-1 do
  WriteString(x1+1,i,GetClipString(MenuList^[i-y1]),a2);
end;

procedure TMenu.Draw;
var
 l:byte;
begin
 l:=GetMaxLength;
 x2:=x1+l+1;
 y2:=y1+MaxL+1;
 TWindow.Draw;
 DrawList;
end;

procedure TMenu.AddMenuItem(as:string);
begin
 if MaxL=23 then exit;
 inc(MaxL);
 MenuList^[MaxL]:=as;
end;

function TMenu.Execute:shortint;
var
 res:shortint;
begin
 Draw;
 Point.AssignXY(x1+1,y1+1,x2-1,y2-1);
 Point.Draw;
 res:=Point.Execute;
 if res>0 then Execute:=res-y1 else Execute:=res;
end;

destructor TMenu.Done;
begin
 TWindow.Done;
 Dispose(MenuList);
end;

function MakeYesNoBox(ax,ay:shortint;mess,y,n:string):boolean;
var
 Menu:TMenu;
 Res:shortint;
begin
 Menu.Init;
 Menu.AssignPlace(ax,ay);
 Menu.AssignWrap(wrOn);
 Menu.AssignFrame(frDouble);
 Menu.AssignTitle(mess);
 Menu.AddMenuItem(y);
 Menu.AddMenuItem(n);
 Res:=Menu.Execute;
 Menu.Done;
 MakeYesNoBox:=(res=1)
end;

{ TButton Methods }
constructor TButton.Init;
begin
 TView.Init;
 IDNumber:=4;
 a1:=clAD;
 a2:=clAE;
 delaysize:=400;
end;

destructor TButton.Done;
begin
 LoadBuff(x1,y1,x2,y2);
end;

procedure TButton.AssignDelay(ad:word);
begin
 delaysize:=ad;
end;

procedure TButton.Hide;
begin
 LoadBuff(x1,y1,x2,y2);
end;

procedure TButton.DrawBar;
var
 i,j:shortint;
begin
 for i:=x1+1 to x2-1 do
  for j:=y1+1 to y2-1 do
   SetChar(i,j,32+256*a1);
end;

procedure TButton.DrawLeftUpAngl(aa:byte);
var
 i:shortint;
begin
 for i:=x1+1 to x2-1 do SetChar(i,y1,196+256*aa);
  for i:=y1+1 to y2-1 do SetChar(x1,i,179+256*aa);
 SetChar(x1,y1,218+256*aa);
 SetChar(x1,y2,192+256*aa);
end;

procedure TButton.DrawRightDownAngl(aa:byte);
var
 i:shortint;
begin
 for i:=x1+1 to x2-1 do SetChar(i,y2,196+256*aa);
  for i:=y1+1 to y2-1 do SetChar(x2,i,179+256*aa);
 SetChar(x2,y1,191+256*aa);
 SetChar(x2,y2,217+256*aa);
end;

procedure TButton.Draw;
begin
 SaveBuff(x1,y1,x2,y2);
 DrawLeftUpAngl(a1);
 DrawRightDownAngl(a2);
 DrawBar;
end;

procedure TButton.Push;
begin
 DrawLeftUpAngl(a2);
 DrawRightDownAngl(a1);
 Delay(delaysize);
 DrawLeftUpAngl(a1);
 DrawRightDownAngl(a2);
end;

{ TScrollBar Methods }
constructor TScrollBar.Init;
begin
 TWindow.Init;
 IDNumber:=5;
 current:=1;
 MaxS:=1;
 py:=y1+1;
end;

destructor TScrollBar.Done;
begin
 TWindow.Done;
end;

procedure TScrollBar.Hide;
begin
 TWindow.Hide;
end;

procedure TScrollBar.AssignLimit(am:longint);
begin
 MaxS:=am;
end;

procedure TScrollBar.AssignXY(ax1,ay1,ax2,ay2:shortint);
begin
 TWindow.AssignXY(ax1,ay1,ax2,ay2);
 py:=y1+2;
end;

procedure TScrollBar.DrawInterior;
var
 i:shortint;
 s:string;
begin
 for i:=y1+1 to y2-1 do
  begin
  Str(current+i-y1-1,s);
  WriteString(x1+1,i,GetClipString('Line N %'+s),a2);
  end;
end;

procedure TScrollBar.DrawScrolling;
var
 i:shortint;
begin
 WriteChar(x2,y1+1,#30);
 WriteChar(x2,y2-1,#31);
 for i:=y1+2 to y2-2 do WriteChar(x2,i,'');
end;

procedure TScrollBar.WriteScrollPosition;
var
 l,i:shortint;
begin
 if (py>y1) and (py<y2) then WriteChar(x2,py,'');
 if MaxS=0 then exit;
 l:=y1+2+trunc((current/MaxS)*(y2-y1-3)+0.5);
 if current=1 then l:=y1+2;
 if l>=y2-1 then l:=y2-2;
 if (l>y1) and (l<y2) then WriteChar(x2,l,'');
 py:=l;
end;

procedure TScrollBar.Draw;
begin
 TWindow.Draw;
 DrawScrolling;
 WriteScrollPosition;
 DrawInterior;
end;

procedure TScrollBar.OpenVertical;
var
 i,j:shortint;
 ax1,ax2,ay1,ay2:shortint;
begin
 SaveBuff(x1,y1,x2+2,y2+1);
 ax1:=x1;
 ax2:=x2;
 ay1:=y1;
 ay2:=y2;
 for i:=y1+1 to ay2 do
  begin
   y2:=i;
   Delay(delaysize);
   DrawFrame;
   DrawShadow;
   DrawScrolling;
   DrawInterior;
  end;
   WriteScrollPosition;
end;

procedure TScrollBar.OpenHorizontal;
var
 i,j:shortint;
 ax1,ax2,ay1,ay2:shortint;
begin
 SaveBuff(x1,y1,x2+2,y2+1);
 ax1:=x1;
 ax2:=x2;
 ay1:=y1;
 ay2:=y2;
 for i:=x1+1 to ax2 do
  begin
   x2:=i;
   Delay(delaysize);
   DrawFrame;
   DrawShadow;
   DrawScrolling;
   DrawInterior;
  end;
   WriteScrollPosition;
end;

procedure TScrollBar.HandleKey(var AK:TKey);
begin
end;

function TScrollBar.Execute:longint;
var
 k:TKey;
begin
 repeat
  WaitKeyPressed(k);
  HandleKey(k);
 if (k.ScanCode=80) and (current<(MaxS-(y2-y1-2))) then
     begin
     Inc(Current);
     WriteScrollPosition;
     DrawInterior;
     ClearKey(k);
     end;
 if (k.ScanCode=81) then
     begin
     if (current<(MaxS-2*(y2-y1-2))) then Inc(Current,y2-y1-1)
                                     else Current:=MaxS-(y2-y1-2);
     if Current<=0 then Current:=1;
     WriteScrollPosition;
     DrawInterior;
     ClearKey(k);
     end;
 if (k.ScanCode=73) then
     begin
     if (current>(y2-y1-2)) then Dec(Current,y2-y1-1)
                            else Current:=1;
     WriteScrollPosition;
     DrawInterior;
     ClearKey(k);
     end;
 if (k.ScanCode=72) and (current>1) then
     begin
     Dec(Current);
     WriteScrollPosition;
     DrawInterior;
     ClearKey(k);
     end;
 until ((k.CharCode=chr(13)) or (k.CharCode=chr(27)));
if k.CharCode=chr(13) then Execute:=current
                      else Execute:=0;
end;

{ TLineScrollBar Methods }
constructor TLineScrollBar.Init;
begin
 TScrollBar.Init;
 IDNumber:=6;
 la:=clAC;
 y:=y1+1;
end;

destructor TLineScrollBar.Done;
begin
 TScrollBar.Done;
end;

procedure TLineScrollBar.AssignLineColor(aa:byte);
begin
 la:=aa;
end;

procedure TLineScrollBar.AssignXY(ax1,ay1,ax2,ay2:shortint);
begin
 TScrollBar.AssignXY(ax1,ay1,ax2,ay2);
 y:=y1+1;
end;

procedure TLineScrollBar.Hide;
begin
 TScrollBar.Hide;
end;

procedure TLineScrollBar.DrawInterior;
var
 i:shortint;
 color:byte;
 s:string;
begin
 for i:=y1+1 to y2-1 do
  begin
  Str(Current+i-y1-1,s);
  if i=y then color:=la
         else color:=a2;
  WriteString(x1+1,i,GetClipString('Line N %'+s),color);
  end;
end;


procedure TLineScrollBar.Draw;
begin
 TScrollBar.Draw;
end;

function TLineScrollBar.Execute:longint;
var
 k:TKey;
begin
 repeat
  WaitKeyPressed(k);
  HandleKey(k);
 { if MaxS=0 then begin Execute:=0;exit;end;}
  if (k.ScanCode=72) and (y>(y1+1)) then
     begin
     Dec(y);
     ClearKey(k);
     DrawInterior;
     end;
  if (k.ScanCode=80) and (y<(y2-1)) and (current+y-y1-1<MaxS) then
     begin
     Inc(y);
     ClearKey(k);
     DrawInterior;
     end;
  if (k.ScanCode=72) and (y=y1+1) and (current>1) then
     begin
     Dec(current);
     WriteScrollPosition;
     DrawInterior;
     ClearKey(k);
     end;
  if (k.ScanCode=80) and (y=y2-1) and (current<(MaxS-(y2-y1-2))) then
     begin
     Inc(current);
     WriteScrollPosition;
     DrawInterior;
     ClearKey(k);
     end;
 until ((k.CharCode=chr(13)) or (k.CharCode=chr(27)));
if k.CharCode=chr(13) then Execute:=current+y-y1-1
                      else Execute:=0;
end;

{ TFileSelection Meyhods }
constructor TFileSelection.Init;
begin
 TLineScrollBar.Init;
 IDNumber:=8;
 x1:=1;
 y1:=1;
 x2:=35;
 y2:=16;
 MaxS:=1;
 Current:=1;
 y:=2;
 New(FileArray);
 Mask:='*.*';
end;

procedure TFileSelection.AssignMask(amask:string);
begin
 Mask:=amask;
end;

procedure TFileSelection.AssignPlace(ax,ay1,ay2:shortint);
begin
 TLineScrollBar.AssignXY(ax,ay1,ax+34,ay2);
end;

destructor TFileSelection.Done;
begin
 TLineScrollBar.Done;
 Dispose(FileArray);
end;

procedure TFileSelection.Draw;
begin
 TLineScrollBar.Draw;
end;

procedure TFileSelection.DrawInterior;
var
 i:shortint;
 s1,s2:string;
begin
 for i:=y1+1 to y2-1 do
  begin
  if (Current+i-y1-1)<=Maxs then
    begin
    Str(FileArray^[Current+i-y1-1].size,s1);
    if (FileArray^[Current+i-y1-1].Attr and Directory)<>0 then
    s1:='';
    s2:=FileArray^[Current+i-y1-1].Name+
    DupSpace(12-Length(FileArray^[Current+i-y1-1].Name))+'   '+
    s1+DupSpace(12-Length(s1));
    if (FileArray^[Current+i-y1-1].Attr and Directory)<>0 then
     s2:=s2+'   '+'DIR';
    if (FileArray^[Current+i-y1-1].Attr and Hidden)<>0 then
     s2:=s2+'   '+'HID';
    if y=i then WriteString(x1+1,i,GetClipString(s2),la)
           else WriteString(x1+1,i,GetClipString(s2),a2);
    end;
  end;
end;

function TFileSelection.Compare(key1,key2:word):integer;
begin
  if FileArray^[Key1].Name = FileArray^[Key2].Name then Compare := 0
  else if FileArray^[Key1].Name = '..' then Compare := 1
  else if FileArray^[Key2].Name = '..' then Compare := -1
  else if (FileArray^[Key1].Attr and Directory <> 0) and
     (FileArray^[Key2].Attr and Directory = 0) then Compare := 1
  else if (FileArray^[Key2].Attr and Directory <> 0) and
     (FileArray^[Key1].Attr and Directory = 0) then Compare := -1
  else if FileArray^[Key1].Name > FileArray^[Key2].Name then
    Compare := -1
  else Compare := 1;
end;

procedure TFileSelection.SortDirectory;
var
 oldDI:SearchRec;
 i,j:longint;
begin
 for i:=1 to MaxS-1 do
  for j:=i+1 to MaxS do
   if Compare(i,j)=-1 then
    begin
     oldDI:=FileArray^[i];
     FileArray^[i]:=FileArray^[j];
     FileArray^[j]:=oldDI;
    end;
end;

procedure TFileSelection.GetDirectory;
var
 i:word;
 DirInfo:SearchRec;
 s:string;
begin
 i:=1;
 MaxS:=1;
 FindFirst(Mask, ReadOnly+Archive, DirInfo);
  while (DosError=0) and (i<=500) do
   begin
    if ((DirInfo.Attr and SysFile)=0)
        and ((DirInfo.Attr and VolumeID)=0)
        and (not (DirInfo.Name='.')) then
         begin
          DirInfo.Name:=ChangeCaseString(DirInfo.Name);
          FileArray^[i]:=DirInfo;
          MaxS:=i;
          Inc(i);
         end;
          FindNext(DirInfo);
   end;
 FindFirst('*.*', Directory, DirInfo);
  while (DosError=0) and (i<=500) do
   begin
    if (DirInfo.Attr and Directory<>0) and (not (DirInfo.Name='.')) then
     begin
      FileArray^[i]:=DirInfo;
      MaxS:=i;
      Inc(i);
     end;
   FindNext(DirInfo);
   end;
 Current:=1;
end;

function TFileSelection.Run:string;
var
 res:longint;
begin
 if FileArray=nil then begin Run:='$MemoryError$';exit;end;
 GetDirectory;
 SortDirectory;
 Draw;
 repeat
  res:=Execute;
  if res=0 then begin Run:='$Esc$';exit;end;
  if (FileArray^[res].Attr and Archive)<>0 then
      begin Run:=FExpand(FileArray^[res].Name);exit;end;
  if filearray^[res].Name='..' then
     begin
      {$I-}
      chdir('..');
      {$I+}
      if IOResult<>0 then begin Run:='$Error$';exit;end;
     end;
  if filearray^[res].Name[1]<>'.' then
     begin
      {$I-}
      chdir(FileArray^[res].Name);
      {$I+}
      if IOResult<>0 then begin Run:='$Error$';exit;end;
     end;
  GetDirectory;
  SortDirectory;
  DrawBar;
  y:=y1+1;
  DrawInterior;
  WriteScrollPosition;
 until false;
end;

{ TPerCentLine Methods }
constructor TPerCentLine.Init;
begin
 TView.Init;
 IDNumber:=9;
 fill1:='';
 fill2:='';
 a1:=10;
 a2:=10;
end;

destructor TPerCentLine.Done;
begin
 LoadBuff(x1,y1,x2,y2);
end;

procedure TPerCentLine.Hide;
begin
 LoadBuff(x1,y1,x2,y2);
end;

procedure TPerCentLine.AssignFillChars(af1,af2:char);
begin
 fill1:=af1;
 fill2:=af2;
end;

procedure TPerCentLine.WritePerCent(ap:byte);
var
 i,j:shortint;
 count:byte;
begin
 count:=trunc((x2-x1+1)*ap/100);
 for i:=0 to (x2-x1) do
  for j:=y1 to y2 do
   if i<count then SetChar(i+x1,j,ord(fill1)+256*a1)
              else SetChar(i+x1,j,ord(fill2)+256*a2);
end;

procedure TPerCentLine.Draw;
begin
 SaveBuff(x1,y1,x2,y2);
 WritePerCent(0);
end;

{ TListBox Methods }
constructor TListBox.Init;
begin
 TLineScrollBar.Init;
 IDNumber:=7;
 New(List);
 Current:=1;
 MaxS:=0;
end;

destructor TListBox.Done;
begin
 Dispose(List);
 TLineScrollBar.Done;
end;

procedure TListBox.AddItem(as:string);
begin
 if MaxS<800 then
  begin
   Inc(MaxS);
   List^[MaxS]:=as;
  end;
end;

procedure TListBox.DrawInterior;
var
 i:shortint;
 color:byte;
begin
 for i:=y1+1 to y2-1 do
  begin
  if i=y then color:=la
         else color:=a2;
  if (Current+i-y1-1)<=MaxS then
       WriteString(x1+1,i,GetClipString(List^[Current+i-y1-1]),color);
  end;
end;


{ Main Program }
begin
end.
