DECLARE SUB helpMe ()
DECLARE SUB drawMap ()
DECLARE SUB options ()
COMMON SHARED holdCap(), land(), capitalX(), capitalY(), armies(), pCol(), powerName$(), relation(), navy(), states(), wc, stateStat(), VD, year, stateName$()
CLS : RANDOMIZE TIMER
wc = 1: year = 1914: day = 213
PRINT TAB(35); "World War"
PRINT "   This is a simulation of the events between 1914 and 1918 commonly known"
PRINT "as the First World War.  It resembles the game Diplomacy in its strategy-"
PRINT "oriented gameplay."
PRINT "   World War I started when Archduke of Austria Francis Ferdinand and his wife"
PRINT "were shot by radical Serbs protesting against the Austrian annexation of Bosnia"
PRINT "six years earlier.  Austria presented an ultimatum to Serbia; that it allow"
PRINT "Austria to search throughout Serbia for those responsible for the assassination."
PRINT "Serbia refused, and Austria declared war."
PRINT "   This might have seemed trivial if not for the complex network of alliances"
PRINT "created with the world powers.  Russia, which had an alliance with Serbia,"
PRINT "declared war on Austria.  Then Germany and Italy, under a similar alliance,"
PRINT "declared war on Russia.  Finally, France and England came to the aid of"
PRINT "Russia.  Because of this, all of Europe was fighting to avenge or justify the"
PRINT "slaying of one man."
DO WHILE INKEY$ = "": LOOP
DIM land(25, 36), holdCap(50), stateName$(50), powerName$(8), capitalX(50), capitalY(50)
DIM pCol(10), relation(8), armies(24, 35), navy(24, 35), states(8)
DIM stateStat(50), initState(50), foundArmy(50), message$(8, 8), landArea(8)
pCol(1) = 5: pCol(2) = 8: pCol(3) = 12: pCol(4) = 14: pCol(5) = 6: pCol(6) = 2: pCol(7) = 4: pCol(8) = 9: pCol(9) = 7
FOR I = 1 TO 8
states(I) = 4
NEXT I
states(6) = 5: states(4) = 3
relation(1) = 1: relation(2) = 2: VD = 5
relation(6) = 1: relation(5) = 2
relation(8) = 1: relation(4) = 2
holdCap(0) = 0
FOR I = 1 TO 4
holdCap(I) = 3
NEXT I
FOR I = 5 TO 8
holdCap(I) = 4
NEXT I
FOR I = 9 TO 13
holdCap(I) = 5
NEXT I
FOR I = 14 TO 18
holdCap(I) = 8
NEXT I
FOR I = 19 TO 23
holdCap(I) = 1
NEXT I
FOR I = 24 TO 28
holdCap(I) = 6
NEXT I
FOR I = 29 TO 30
holdCap(I) = 7
NEXT I
FOR I = 31 TO 35
holdCap(I) = 2
NEXT I
FOR I = 36 TO 50
holdCap(I) = 9
NEXT I
powerName$(1) = "Germany": powerName$(2) = "Russia"
powerName$(3) = "Spain": powerName$(4) = "United Kingdom": powerName$(5) = "France"
powerName$(6) = "Austria-Hungary": powerName$(7) = "Ottoman Empire": powerName$(8) = "Italy"
FOR I = 1 TO 24: FOR J = 1 TO 35
READ land(I, J)
NEXT J: NEXT I
FOR I = 1 TO 50
READ stateName$(I), capitalX(I), capitalY(I)
stateStat(I) = 1
armies(capitalX(I), capitalY(I)) = I
NEXT I
endOfHelp:
CLS
PRINT "Options:"
PRINT "1)Play game"
PRINT "2)Random map, some neutral"
PRINT "3)Random map, no neutral"
PRINT "4)Help File"
PRINT "5)Options"
DO
INPUT "Your choice"; choice
LOOP WHILE choice < 1 AND choice > 5
IF choice = 5 THEN CALL options: GOTO endOfHelp
IF choice = 4 THEN CALL helpMe: GOTO endOfHelp
IF choice = 2 THEN
FOR I = 1 TO 50
holdCap(I) = INT(RND * 9) + 1
NEXT I
END IF
IF choice = 3 THEN
FOR I = 1 TO 50
holdCap(I) = INT(RND * 8) + 1
NEXT I
END IF
FOR I = 1 TO 50
IF holdCap(I) = 9 THEN armies(capitalX(I), capitalY(I)) = 0
NEXT I
navy(8, 17) = 1
navy(4, 24) = 2
navy(15, 6) = 3
navy(7, 9) = 4
navy(11, 10) = 5
navy(16, 20) = 6
navy(22, 27) = 7
navy(20, 18) = 8
FOR I = 1 TO 50
initState(I) = holdCap(I)
NEXT I
DO
W = 1: PS = 1
FOR I = 1 TO 8
states(I) = 0
NEXT I
FOR I = 1 TO 50
IF holdCap(I) > 8 THEN GOTO goOn77
states(holdCap(I)) = states(holdCap(I)) + 1
goOn77:
NEXT I
FOR I = 1 TO 8
landArea(I) = 0
NEXT I
FOR I = 1 TO 24: FOR J = 1 TO 35
IF land(I, J) > 0 AND holdCap(land(I, J)) < 9 THEN landArea(holdCap(land(I, J))) = landArea(holdCap(land(I, J))) + 5184
NEXT J: NEXT I
FOR I = 1 TO 8
IF states(I) = 0 THEN relation(I) = -1
NEXT I
CALL drawMap
SELECT CASE day
CASE IS <= 31
PRINT day; "January"; year;
CASE IS <= 59
PRINT day - 31; "February"; year;
CASE IS <= 90
PRINT day - 59; "March"; year;
CASE IS <= 120
PRINT day - 90; "April"; year;
CASE IS <= 151
PRINT day - 120; "May"; year;
CASE IS <= 181
PRINT day - 151; "June"; year;
CASE IS <= 212
PRINT day - 181; "July"; year;
CASE IS <= 243
PRINT day - 212; "August"; year;
CASE IS <= 273
PRINT day - 243; "September"; year;
CASE IS <= 304
PRINT day - 273; "October"; year;
CASE IS <= 334
PRINT day - 304; "November"; year;
CASE ELSE
PRINT day - 334; "December"; year;
END SELECT
PRINT "hit any key";
DO WHILE INKEY$ = "": LOOP
party1 = 0: party2 = 0: flag7 = 1
FOR I = 1 TO 8
IF relation(I) = 1 THEN party1 = party1 + 1
IF relation(I) = 2 THEN party2 = party2 + 1
NEXT I
IF party1 = 0 OR party2 = 0 THEN COLOR 7: LOCATE 20, 1: PRINT "By mutual consent of the parties, war is over.": END
CLS
DO
IF W > 50 THEN W = 1
IF W < 1 THEN W = 50
COLOR 7
LOCATE 24, 1: PRINT "Press left/right arrows to move through the states, and <ESC> to end.";
IF holdCap(W) = 9 THEN LOCATE 23, 1: PRINT stateName$(W); "("; LTRIM$(RTRIM$(STR$(W))); ") is neutral"
IF holdCap(W) < 9 THEN
LOCATE 23, 1: PRINT stateName$(W); "("; LTRIM$(RTRIM$(STR$(W))); ") held by "; powerName$(holdCap(W))
LOCATE 25, 1: PRINT powerName$(holdCap(W)); " has"; states(holdCap(W)); "state(s).";
COLOR 2
LOCATE 1, 55: PRINT powerName$(holdCap(W))
LOCATE , 55: PRINT "Approx. area:"; landArea(holdCap(W)); "mi^2"
LOCATE , 55: PRINT "Relation:";
IF relation(holdCap(W)) = 0 THEN PRINT "Neutral"
IF relation(holdCap(W)) = 1 THEN PRINT "Central Power"
IF relation(holdCap(W)) = 2 THEN PRINT "Allied Power"
IF relation(holdCap(W)) = -2 THEN PRINT "Surrendered"
LOCATE , 55: PRINT "Now holds:"
K = 0
FOR I = 1 TO 50
IF holdCap(I) = holdCap(W) THEN
K = K + 1
IF K < 19 THEN LOCATE , 55: PRINT stateName$(I) ELSE LOCATE K - 18, 1: PRINT stateName$(I)
END IF
NEXT I
END IF
IF flag7 = 1 THEN
flag7 = 0
CLS
MinX = 99: MinY = 99: MaxX = 0: MaxY = 0
FOR I = 1 TO 24: FOR J = 1 TO 35
IF land(I, J) = W AND I < MinX THEN MinX = I
IF land(I, J) = W AND J < MinY THEN MinY = J
IF land(I, J) = W AND I > MaxX THEN MaxX = I
IF land(I, J) = W AND J > MaxY THEN MaxY = J
NEXT J: NEXT I
FOR I = 1 TO 24
FOR J = 1 TO 35
IF land(I, J) = W THEN
LOCATE I - MinX + 8, 2 * (J - MinY + 15) - 1
COLOR pCol(holdCap(W)) + 16: PRINT "  ";
FOR K = I - VD TO I + VD
FOR L = J - VD TO J + VD
IF K < 1 OR K > 24 OR L < 1 OR L > 35 THEN GOTO goOn7734
LOCATE K - MinX + 8, 2 * (L - MinY + 15) - 1
IF land(K, L) = 0 THEN COLOR wc + 8, wc: PRINT "  "; : COLOR , 0: GOTO goOn7734
IF SCREEN(K - MinX + 8, 2 * (L - MinY + 15) - 1) <> 219 THEN COLOR pCol(holdCap(land(K, L))): PRINT "  ";
goOn7734:
NEXT L: NEXT K
END IF
NEXT J: NEXT I
FOR I = MinY - VD TO MaxY + VD
COLOR 2
X$ = LTRIM$(RTRIM$(STR$(I)))
IF I < 10 THEN X$ = "0" + X$
IF I < 1 THEN X$ = ""
IF I > 35 THEN X$ = ""
LOCATE 7 - VD, 29 + 2 * (I - MinY): PRINT X$
NEXT I
FOR I = MinX - VD TO MaxX + VD
X$ = LTRIM$(RTRIM$(STR$(I)))
IF I < 10 THEN X$ = "0" + X$
IF I < 1 THEN X$ = ""
IF I > 24 THEN X$ = ""
LOCATE 8 + (I - MinX), 27 - 2 * VD: PRINT X$
NEXT I
END IF
LOCATE 22, 1
IF stateStat(W) = 0 THEN COLOR 4: PRINT "BARRICADED": COLOR 7 ELSE PRINT "          "
LOCATE 21, 1: IF holdCap(W) <> 9 THEN COLOR 2: PRINT "Hit <M> to see a map of "; powerName$(holdCap(W)); "."
X$ = INKEY$
IF X$ = CHR$(0) + "K" THEN W = W - 1: flag7 = 1
IF X$ = CHR$(0) + "M" THEN W = W + 1: flag7 = 1
IF X$ = " " THEN LOCATE 1, 1: INPUT "State number(1-50)"; W: flag7 = 1
IF W > 50 THEN W = W - 50
IF W < 1 THEN W = W + 50
IF X$ = "m" AND holdCap(W) <> 9 THEN
A = 7
IF pCol(holdCap(W)) = 7 THEN A = 6
IF A = wc THEN A = 4
IF A = 4 AND pCol(holdCap(W)) = 4 THEN A = 1
CLS
flag7 = 1
FOR I = 1 TO 23 STEP 2
FOR J = 1 TO 35
COLOR pCol(holdCap(W))
LOCATE (I + 1) / 2, J
IF holdCap(land(I, J)) = holdCap(W) AND holdCap(land(I + 1, J)) = holdCap(W) THEN PRINT " "
IF holdCap(land(I, J)) = holdCap(W) AND holdCap(land(I + 1, J)) <> holdCap(W) THEN
IF land(I + 1, J) = 0 THEN COLOR , wc ELSE COLOR , A
PRINT " "
COLOR , 0
END IF
IF holdCap(land(I, J)) <> holdCap(W) AND holdCap(land(I + 1, J)) = holdCap(W) THEN
IF land(I, J) = 0 THEN COLOR , wc ELSE COLOR , A
PRINT " "
COLOR , 0
END IF
IF holdCap(land(I, J)) <> holdCap(W) AND holdCap(land(I + 1, J)) <> holdCap(W) THEN
IF land(I, J) > 0 AND land(I + 1, J) > 0 THEN COLOR A, A
IF land(I, J) > 0 AND land(I + 1, J) = 0 THEN COLOR A, wc
IF land(I, J) = 0 AND land(I + 1, J) > 0 THEN COLOR wc, A
IF land(I, J) = 0 AND land(I + 1, J) = 0 THEN COLOR wc, wc
PRINT " "
COLOR , 0
END IF
NEXT J: NEXT I
COLOR pCol(holdCap(W))
LOCATE 13, 1: PRINT "Map of "; powerName$(holdCap(W))
DO WHILE INKEY$ = "": LOOP
END IF
LOOP UNTIL X$ = CHR$(27)
FOR I = 1 TO 8
     FOR Q = 1 TO 50
     IF holdCap(armies(capitalX(Q), capitalY(Q))) <> holdCap(Q) AND holdCap(armies(capitalX(Q), capitalY(Q))) <> 0 AND stateStat(Q) = 1 THEN holdCap(Q) = holdCap(armies(capitalX(Q), capitalY(Q)))
     foundArmy(Q) = 0
     NEXT Q
     FOR Q = 1 TO 24: FOR R = 1 TO 35
     IF armies(Q, R) > 0 THEN foundArmy(armies(Q, R)) = 1
     NEXT R: NEXT Q
     FOR Q = 1 TO 50
     IF foundArmy(Q) = 0 AND armies(capitalX(Q), capitalY(Q)) = 0 AND holdCap(Q) < 9 AND stateStat(Q) = 1 THEN armies(capitalX(Q), capitalY(Q)) = Q
     NEXT Q
CALL drawMap
IF relation(I) = -1 THEN PRINT powerName$(I); " is extinct.  Hit any key."; : DO WHILE INKEY$ = "": LOOP: GOTO endTurn
IF relation(I) = -2 THEN PRINT powerName$(I); " has surrendered.  Hit any key."; : DO WHILE INKEY$ = "": LOOP: GOTO endTurn
FOR Q = 1 TO 24: FOR R = 1 TO 35
IF armies(Q, R) = I OR navy(Q, R) = I THEN units = units + 1
NEXT R: NEXT Q
COLOR pCol(I)
LOCATE 25, 1
PRINT powerName$(I); " commander:";
IF relation(I) = 1 THEN PRINT "you are at war against the Allies."; : DO WHILE INKEY$ = "": LOOP
IF relation(I) = 2 THEN PRINT "you are at war against the Central Powers."; : DO WHILE INKEY$ = "": LOOP
IF relation(I) = 0 THEN
PRINT "you are neutral.";
DO WHILE INKEY$ = "": LOOP
DO
     FOR J = 1 TO 8
     IF message$(J, I) <> "" THEN
     COLOR 4
     LOCATE 25, 1
     PRINT "Message from "; powerName$(J); " embassy:"; message$(J, I);
     message$(J, I) = ""
     DO WHILE INKEY$ = "": LOOP
     COLOR pCol(I)
     END IF
     NEXT J
CLS
INPUT "Would you like to remain neutral(Y/N)"; choice$
choice$ = LCASE$(LEFT$(choice$, 1))
IF choice$ = "n" THEN
     PRINT "Choose your side: 1 = side w/Central, 2 = side w/Allies."
     DO
     INPUT "Which side"; relation(I)
     LOOP WHILE relation(I) > 2 OR relation(I) < 1
     COLOR 4: PRINT powerName$(I); " declares war against ";
     IF relation(I) = 1 THEN PRINT "the Allies!" ELSE PRINT "the Central Powers!"
     END IF
LOOP UNTIL choice$ = "y" OR choice$ = "n"
GOTO endTurn
END IF
     FOR J = 1 TO 8
     IF message$(J, I) <> "" THEN
     COLOR 4
     LOCATE 25, 1
     PRINT "Message from "; powerName$(J); " embassy:"; message$(J, I);
     message$(J, I) = ""
     DO WHILE INKEY$ = "": LOOP
     COLOR pCol(I)
     END IF
     NEXT J
reTry:
CLS
PRINT "(M)ove units, (O)ptions, (S)urrender, (D)elay, (C)ede state, (E)missary"
INPUT "Your choice"; choice$
choice$ = LCASE$(LEFT$(choice$, 1))
SELECT CASE choice$
CASE "s"
reDo:
     INPUT "Are you sure you want to surrender"; choice$
     choice$ = LCASE$(LEFT$(choice$, 1))
     IF choice$ = "n" THEN GOTO reTry
     IF choice$ <> "y" THEN GOTO reDo
     COLOR 4: PRINT powerName$(I); " surrenders!": COLOR 7
     relation(I) = -2
     FOR Q = 1 TO 24: FOR R = 1 TO 35
     IF holdCap(armies(Q, R)) = I THEN armies(Q, R) = 0
     IF navy(Q, R) = I THEN navy(Q, R) = 0
     NEXT R: NEXT Q
     FOR Q = 1 TO 50
     IF holdCap(Q) = I AND initState(Q) <> I THEN holdCap(Q) = 9
     NEXT Q
     FOR Q = 1 TO 50
     IF holdCap(Q) = I THEN stateStat(Q) = 0
     NEXT Q
CASE "o"
     PRINT "Options: 1 = change country name, 2 = change color, 3 = change state names,"
     PRINT "4 = change alliances, 5 = change view distance, 6 = leave"
     DO
     INPUT "Choose option"; decide
     LOOP WHILE decide < 1 OR decide > 6
     IF decide = 1 THEN INPUT "Country name"; powerName$(I): powerName$(I) = LEFT$(powerName$(I), 20)
     IF decide = 2 THEN
reTry666:
          INPUT "Choose color(0-15)"; pCol(I)
          FOR J = 1 TO 8
               IF pCol(J) = pCol(I) AND J <> I AND relation(J) > -1 THEN PRINT "It's been chosen!": GOTO reTry666
          NEXT J
     END IF
     IF decide = 3 THEN
          DO
          flag = 0
          INPUT "Which state #(1-50)"; sno
          IF sno < 1 OR sno > 50 THEN flag = 1
          IF holdCap(sno) <> I THEN PRINT "You don't own it.": flag = 1
          LOOP WHILE flag = 1
          INPUT "Name of this state"; stateName$(sno)
          END IF
          IF decide = 4 THEN
          DO
          INPUT "Choose your alliance(0 = Neutral, 1 = Central, 2 = Allied)"; choice
          LOOP WHILE choice > 2 OR choice < 0
          relation(I) = choice
          END IF
          IF decide = 5 THEN
          DO
          INPUT "Viewing distance(0-5)"; VD
          LOOP WHILE VD > 5 OR VD < 0
          END IF
GOTO reTry
CASE "m"
CLS 2
X = 1: Y = 1: AL = 0
DO
X2 = X: Y2 = Y
TS = 0
check1:
flag = 0
IF armies(X, Y) < 0 THEN flag = 1: GOTO skipIt1
IF holdCap(armies(X, Y)) <> I THEN flag = 1
skipIt1:
IF flag = 1 THEN X = X + 1
IF X = 25 AND Y = 35 THEN X = 1: Y = 1
IF X = 25 THEN X = 1: Y = Y + 1
IF flag = 1 AND X2 = X AND Y2 = Y THEN EXIT DO
IF flag = 1 THEN GOTO check1
reTryMove:
FOR A = X - VD TO X + VD
FOR B = Y - VD TO Y + VD
LOCATE 10 + (A - X), 39 + 2 * (B - Y)
IF A < 1 OR A > 24 OR B < 1 OR B > 35 THEN COLOR 8: PRINT "  ": GOTO goOn2141
IF armies(A, B) <> 0 THEN COLOR pCol(holdCap(ABS(armies(A, B)))): PRINT CHR$(1); CHR$(1): GOTO goOn2141
IF navy(A, B) > 0 THEN COLOR pCol(navy(A, B)): PRINT "--": GOTO goOn2141
FOR Q = 1 TO 50
     IF A = capitalX(Q) AND B = capitalY(Q) THEN
     IF stateStat(Q) = 0 THEN PRINT CHR$(8); CHR$(8): GOTO goOn2141
     COLOR pCol(holdCap(Q))
     X$ = LTRIM$(RTRIM$(STR$(Q)))
     IF Q < 10 THEN X$ = "0" + X$
     PRINT X$: GOTO goOn2141
     END IF
NEXT Q
IF land(A, B) = 0 THEN COLOR wc + 8, wc: PRINT "  ": COLOR , 0: GOTO goOn2141
COLOR pCol(holdCap(land(A, B))): PRINT "  "
goOn2141:
NEXT B
NEXT A
COLOR pCol(I) + 16: LOCATE 10, 39: PRINT CHR$(1); CHR$(1)
COLOR pCol(I)
FOR Q = 1 TO 50
IF X = capitalX(Q) AND Y = capitalY(Q) THEN LOCATE 19, 1: PRINT "(Now occupying "; stateName$(Q); ")": EXIT FOR
NEXT Q
LOCATE 20, 1
PRINT "Army at"; X; ","; Y; ": move which way(North, South, East, West, neXt, sTay)";
INPUT dir$
dir$ = LCASE$(LEFT$(dir$, 1))
IF dir$ <> "s" AND dir$ <> "n" AND dir$ <> "w" AND dir$ <> "e" AND dir$ <> "x" AND dir$ <> "t" THEN GOTO reTryMove
VIEW PRINT 19 TO 25: CLS 2: VIEW PRINT: LOCATE 21, 1
IF dir$ = "s" THEN
IF land(X + 1, Y) = 0 AND relation(navy(X + 1, Y)) <> relation(I) THEN PRINT "That's water.": GOTO reTryMove
IF armies(X + 1, Y) <> 0 THEN
IF holdCap(ABS(armies(X + 1, Y))) = I THEN PRINT "You have an army in the way.": GOTO reTryMove
sup1 = 0: sup2 = 0
FOR T1 = 0 TO 2
FOR T2 = -1 TO 1
IF X + T1 > 24 OR X + T1 < 1 OR Y + T2 < 1 OR Y + T2 > 35 THEN GOTO newTryS
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 1 THEN sup1 = sup1 + 1
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 2 THEN sup2 = sup2 + 1
newTryS:
NEXT T2: NEXT T1
IF relation(I) = 1 AND sup2 >= sup1 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF relation(I) = 2 AND sup1 >= sup2 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF X = 23 THEN GOTO noShoveS
IF armies(X + 2, Y) = 0 AND land(X + 2, Y) > 0 THEN armies(X + 2, Y) = -armies(X + 1, Y)
noShoveS:
PRINT "You move the army out of the way."
END IF
FOR Q = 1 TO 50
     IF capitalX(Q) = X + 1 AND capitalY(Q) = Y AND stateStat(Q) = 1 THEN
     TS = holdCap(Q)
     PRINT "You take the state of "; stateName$(Q); "."
     IF TS < 9 THEN states(holdCap(Q)) = states(holdCap(Q)) - 1
     states(I) = states(I) + 1
     holdCap(Q) = I
     IF capitalX(Q) = X + 1 AND capitalY(Q) = Y AND stateStat(Q) = 0 THEN PRINT "This city is under a military barricade.": GOTO reTryMove
     END IF
NEXT Q
armies(X + 1, Y) = -armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "n" THEN
IF land(X - 1, Y) = 0 AND relation(navy(X - 1, Y)) <> relation(I) THEN PRINT "That's water.": GOTO reTryMove
IF armies(X - 1, Y) <> 0 THEN
IF holdCap(ABS(armies(X - 1, Y))) = I THEN PRINT "You have an army in the way.": GOTO reTryMove
sup1 = 0: sup2 = 0
FOR T1 = -2 TO 0
FOR T2 = -1 TO 1
IF X + T1 > 24 OR X + T1 < 1 OR Y + T2 < 1 OR Y + T2 > 35 THEN GOTO newTryN
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 1 THEN sup1 = sup1 + 1
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 2 THEN sup2 = sup2 + 1
newTryN:
NEXT T2: NEXT T1
IF relation(I) = 1 AND sup2 >= sup1 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF relation(I) = 2 AND sup1 >= sup2 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF armies(X - 2, Y) = 0 AND land(X - 2, Y) > 0 THEN armies(X - 2, Y) = -armies(X - 1, Y)
PRINT "You move the army out of the way."
END IF
FOR Q = 1 TO 50
     IF capitalX(Q) = X - 1 AND capitalY(Q) = Y AND stateStat(Q) = 1 THEN
     TS = holdCap(Q)
     PRINT "You take the state of "; stateName$(Q); "."
     IF TS < 9 THEN states(holdCap(Q)) = states(holdCap(Q)) - 1
     states(I) = states(I) + 1
     holdCap(Q) = I
     END IF
     IF capitalX(Q) = X - 1 AND capitalY(Q) = Y AND stateStat(Q) = 0 THEN PRINT "This city is under a military barricade.": GOTO reTryMove
NEXT Q
armies(X - 1, Y) = -armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "w" THEN
IF land(X, Y - 1) = 0 AND relation(navy(X, Y - 1)) <> relation(I) THEN PRINT "That's water.": GOTO reTryMove
IF armies(X, Y - 1) <> 0 THEN
IF holdCap(ABS(armies(X, Y - 1))) = I THEN PRINT "You have an army in the way.": GOTO reTryMove
sup1 = 0: sup2 = 0
FOR T1 = -1 TO 1
FOR T2 = -2 TO 0
IF X + T1 > 24 OR X + T1 < 1 OR Y + T2 < 1 OR Y + T2 > 35 THEN GOTO newTryW
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 1 THEN sup1 = sup1 + 1
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 2 THEN sup2 = sup2 + 1
newTryW:
NEXT T2: NEXT T1
IF relation(I) = 1 AND sup2 >= sup1 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF relation(I) = 2 AND sup1 >= sup2 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF armies(X, Y - 2) = 0 AND land(X, Y - 2) > 0 THEN armies(X, Y - 2) = -armies(X, Y - 1)
PRINT "You move the army out of the way."
END IF
FOR Q = 1 TO 50
     IF capitalX(Q) = X AND capitalY(Q) = Y - 1 AND stateStat(Q) = 1 THEN
     TS = holdCap(Q)
     PRINT "You take the state of "; stateName$(Q); "."
     IF TS < 9 THEN states(holdCap(Q)) = states(holdCap(Q)) - 1
     states(I) = states(I) + 1
     holdCap(Q) = I
     END IF
     IF capitalX(Q) = X AND capitalY(Q) = Y - 1 AND stateStat(Q) = 0 THEN PRINT "This city is under a military barricade.": GOTO reTryMove
NEXT Q
armies(X, Y - 1) = -armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "e" THEN
IF Y = 35 THEN PRINT "That's off the map.": GOTO reTryMove
IF land(X, Y + 1) = 0 AND relation(navy(X, Y + 1)) <> relation(I) THEN PRINT "That's water.": GOTO reTryMove
IF armies(X, Y + 1) <> 0 THEN
IF holdCap(ABS(armies(X, Y + 1))) = I THEN PRINT "You have an army in the way.": GOTO reTryMove
sup1 = 0: sup2 = 0
FOR T1 = -1 TO 1
FOR T2 = 0 TO 2
IF X + T1 > 24 OR X + T1 < 1 OR Y + T2 < 1 OR Y + T2 > 35 THEN GOTO newTryE
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 1 THEN sup1 = sup1 + 1
IF relation(holdCap(ABS(armies(X + T1, Y + T2)))) = 2 THEN sup2 = sup2 + 1
newTryE:
NEXT T2: NEXT T1
IF relation(I) = 1 AND sup2 >= sup1 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF relation(I) = 2 AND sup1 >= sup2 THEN PRINT "You do not have enough support to attack this army.": GOTO reTryMove
IF Y < 34 THEN
IF armies(X, Y + 2) = 0 AND land(X, Y + 2) > 0 THEN armies(X, Y + 2) = -armies(X, Y + 1)
END IF
PRINT "You move the army out of the way."
END IF
FOR Q = 1 TO 50
     IF capitalX(Q) = X AND capitalY(Q) = Y + 1 AND stateStat(Q) = 1 THEN
     TS = holdCap(Q)
     PRINT "You take the state of "; stateName$(Q); "."
     IF TS < 9 THEN states(holdCap(Q)) = states(holdCap(Q)) - 1
     states(I) = states(I) + 1
     holdCap(Q) = I
     END IF
     IF capitalX(Q) = X AND capitalY(Q) = Y + 1 AND stateStat(Q) = 0 THEN PRINT "This city is under a military barricade.": GOTO reTryMove
NEXT Q
armies(X, Y + 1) = -armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "t" THEN
     FOR Q = 1 TO 50
          IF capitalX(Q) = X AND capitalY(Q) = Y AND stateStat(Q) = 1 THEN
          TS = holdCap(Q)
          PRINT "You take the state of "; stateName$(Q); "."
          IF TS < 10 THEN states(holdCap(Q)) = states(holdCap(Q)) - 1
          states(I) = states(I) + 1
          holdCap(Q) = I
          END IF
     NEXT Q
     armies(X, Y) = -armies(X, Y)
END IF
moveOn:
X = X + 1
IF X = 20 AND Y = 35 THEN X = 1: Y = 1
IF X = 20 THEN X = 1: Y = Y + 1
IF TS = 9 THEN GOTO goAgain
IF states(TS) = 0 AND TS > 0 THEN
COLOR 4: PRINT powerName$(TS); " has become extinct!": DO WHILE INKEY$ = "": LOOP: COLOR pCol(I)
relation(TS) = -1
FOR Q = 1 TO 24: FOR R = 1 TO 35
IF navy(Q, R) = TS THEN navy(Q, R) = I
NEXT R: NEXT Q
END IF
goAgain:
LOOP WHILE X$ <> CHR$(13)
FOR X = 1 TO 24: FOR Y = 1 TO 35
IF armies(X, Y) < 0 THEN armies(X, Y) = -armies(X, Y)
NEXT Y: NEXT X
FOR X = 1 TO 24: FOR Y = 1 TO 35
IF navy(X, Y) <> I THEN GOTO moveOn2
FOR A = X - VD TO X + VD
FOR B = Y - VD TO Y + VD
LOCATE 10 + (A - X), 39 + 2 * (B - Y)
IF A < 1 OR A > 24 OR B < 1 OR B > 35 THEN COLOR 8: PRINT "  ": GOTO goOn2799
IF armies(A, B) > 0 THEN COLOR pCol(holdCap(armies(A, B))): PRINT CHR$(1); CHR$(1): GOTO goOn2799
IF navy(A, B) > 0 THEN COLOR pCol(navy(A, B)): PRINT "--": GOTO goOn2799
FOR Q = 1 TO 50
     IF A = capitalX(Q) AND B = capitalY(Q) THEN
     COLOR pCol(holdCap(Q))
     X$ = LTRIM$(RTRIM$(STR$(Q)))
     IF Q < 10 THEN X$ = "0" + X$
     PRINT X$: GOTO goOn2799
     END IF
NEXT Q
IF land(A, B) = 0 THEN COLOR wc + 8, wc: PRINT "  ": COLOR , 0: GOTO goOn2799
COLOR pCol(holdCap(land(A, B))): PRINT "  "
goOn2799:
NEXT B
NEXT A
COLOR pCol(I) + 16: LOCATE 10, 39: PRINT "--"
COLOR pCol(I)
LOCATE 20, 1
reTryNavy:
PRINT "Navy at"; X; ","; Y; ": move which way(North, South, East, West, neXt)";
INPUT dir$
dir$ = LCASE$(LEFT$(dir$, 1))
IF dir$ <> "s" AND dir$ <> "n" AND dir$ <> "w" AND dir$ <> "e" AND dir$ <> "x" THEN GOTO reTryNavy
VIEW PRINT 19 TO 25: CLS 2: VIEW PRINT: LOCATE 21, 1
IF dir$ = "s" THEN
IF land(X + 1, Y) <> 0 THEN PRINT "Don't run aground!": GOTO reTryNavy
IF navy(X + 1, Y) <> 0 THEN PRINT "There's a navy there.": GOTO reTryNavy
navy(X, Y) = 0: navy(X + 1, Y) = -I
IF relation(holdCap(armies(X, Y))) = relation(I) THEN armies(X + 1, Y) = armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "n" THEN
IF land(X - 1, Y) <> 0 THEN PRINT "Don't run aground!": GOTO reTryNavy
IF navy(X - 1, Y) <> 0 THEN PRINT "There's a navy there.": GOTO reTryNavy
navy(X, Y) = 0: navy(X - 1, Y) = -I
IF relation(holdCap(armies(X, Y))) = relation(I) THEN armies(X - 1, Y) = armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "e" THEN
IF land(X, Y + 1) <> 0 THEN PRINT "Don't run aground!": GOTO reTryNavy
IF navy(X, Y + 1) <> 0 THEN PRINT "There's a navy there.": GOTO reTryNavy
navy(X, Y) = 0: navy(X, Y + 1) = -I
IF relation(holdCap(armies(X, Y))) = relation(I) THEN armies(X, Y + 1) = armies(X, Y): armies(X, Y) = 0
END IF
IF dir$ = "w" THEN
IF land(X, Y - 1) <> 0 THEN PRINT "Don't run aground!": GOTO reTryNavy
IF navy(X, Y - 1) <> 0 THEN PRINT "There's a navy there.": GOTO reTryNavy
navy(X, Y) = 0: navy(X, Y - 1) = -I
IF relation(holdCap(armies(X, Y))) = relation(I) THEN armies(X, Y - 1) = armies(X, Y): armies(X, Y) = 0
END IF
moveOn2:
NEXT Y: NEXT X
FOR X = 1 TO 24: FOR Y = 1 TO 35
IF navy(X, Y) < 0 THEN navy(X, Y) = -navy(X, Y)
NEXT Y: NEXT X
LOCATE 10, 39: COLOR pCol(I): PRINT "--"
CASE "d"
CASE "c"
INPUT "Which state(0 to quit)"; stateNo
IF stateNo = 0 THEN GOTO reTry
IF holdCap(stateNo) <> I THEN PRINT "You don't own it.": GOTO reTry
reInput:
INPUT "To which power"; powerNo
IF powerNo = 0 THEN GOTO reTry
IF powerNo > 8 OR powerNo < 1 THEN GOTO reInput
IF relation(powerNo) < -1 THEN PRINT "They're dead.": GOTO reTry
holdCap(stateNo) = powerNo
states(I) = states(I) - 1
states(powerNo) = states(powerNo) + 1
IF states(I) = 0 THEN
COLOR 4: PRINT powerName$(I); " has become extinct!"
FOR R = 1 TO 24
FOR J = 1 TO 35
IF navy(R, J) = I THEN navy(R, J) = powerNo
NEXT J: NEXT R
relation(I) = -1
GOTO endTurn
ELSE
GOTO reTry
END IF
CASE "e"
     DO
     INPUT "Send message to which power"; psend
     IF psend = 0 THEN GOTO reTry
     IF relation(psend) < 0 THEN PRINT "They're dead.": GOTO reTry
     LOOP WHILE psend < 1 OR psend > 8
     LINE INPUT "Type your message."; message$(I, psend)
     PRINT "The ambassador is on his way."
     GOTO reTry
CASE ELSE
     GOTO reTry
END SELECT
endTurn:
NEXT I
day = day + INT(RND * 7) + 8
IF day > 365 THEN year = year + 1: day = day - 365
LOOP
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,40,40,40,42,42,42, 0,32,32,32,32, 0,32,32,32,32,32,32,32
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,40,40,40,42,42,42, 0,32,32,32,32,32,32,32,32,32,34,34,34
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0,40,40,40,42,42,42, 0, 0,32,32,32,32,32,32,32,34,34,34,34
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 0,42,42, 0, 0, 0,32,32,32,32,32,32,34,34,34,34,34
DATA 0, 0, 0, 0, 0, 0, 5, 6, 6, 0, 7, 0, 0, 0, 0, 0, 0,41, 0,42,42, 0, 0,31,31,31,32,32,32,32,34,34,34,34,34
DATA 0, 0, 0, 0, 0, 0, 5, 5, 5, 0, 7, 7, 0, 0, 0, 0, 0,41, 0,42,42, 0, 0,31,31,31,32,32,32,32,35,34,34,34,34
DATA 0, 0, 0, 0, 0, 0, 5, 5, 0, 8, 8, 8, 0, 0, 0, 0, 0,41, 0, 0, 0, 0, 0,23,31,31,31,32,35,35,35,35,35,34,34
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 0, 0, 0, 0, 0,22,22,22, 0,23,23,23,23,31,31,33,35,35,35,35,35,35,35
DATA 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 0, 0, 0,38,38,19,22,22,22,23,23,23,23,31,31,31,33,33,33,35,35,35,35,35
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,11,37,37,19,19,22,22,22,23,23,31,31,31,31,31,33,33,33,35,35,35,35,35
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9,11,11,37,19,19,22,22,22,23,23,23,31,31,31,31,33,33,33,35,33,33,35,33
DATA 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9,11,11,11,20,20,21,21,25,25,25,25,28,28,28,28,33,33,33,33,33,33,33,33
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9,13,13,11,11,20,20,21,21,25,25,25,25,28,28,28,28,28,33,33,33,33,33,33,33
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0,10,13,13,13,13,12,39,39,39,24,24,24,25,25,27,27,27,27,28,43,33,33,33,33,33, 0
DATA 0, 0, 0, 1, 1, 0, 0, 0, 0,10,13,13,13,12,12,39,39,24,24,24,24,24,27,27,27,27,27,27,43,33, 0, 0,33, 0, 0
DATA 0, 0, 0, 1, 1, 1, 1, 1, 1,10,10,10,12,12,12,14,14,24,14, 0,26,26,26,26,27,27,43,43,43, 0, 0, 0, 0, 0, 0
DATA 0, 0, 0,36,36, 3, 3, 2, 2, 2,10,10,12,12,14,14,14,14, 0, 0,26,26,26,45,45,44,44,44,44, 0, 0, 0, 0, 0, 0
DATA 0, 0,36,36, 3, 3, 3, 2, 2, 2, 2, 0, 0, 0, 0, 0,15,15,15, 0, 0,26,26,45,45,44,44,44,44, 0, 0,30,30,30,30
DATA 0,36,36, 3, 3, 3, 3, 2, 2, 2, 0, 0, 0, 0, 0,12, 0,15,16,17, 0, 0, 0,46,45,44,44,29,29, 0,30,30,30,30,30
DATA 0,36,36, 3, 3, 3, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0,16,17,17, 0, 0,46,46,47,47,29,29,29,30,30,30,30,30
DATA 0, 0, 0, 3, 3, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0,14, 0, 0, 0,17,17,17, 0,46,47,47, 0, 0,29,29,29,29,29,30,30
DATA 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0,47,47, 0, 0, 0,29,29,29,29,30,30,30
DATA 48,48,48,48,49,49,49,49,49,49,49,49,50,50,0, 50,0,18,18, 0, 0, 0, 0, 0,47,47, 0, 0,29,29,29,29,29,29, 0
DATA 48,48,48,49,49,49,49,49,49,49,49,49,49,50,50,50,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
DATA "Castile", 16, 5
DATA "Aragon", 18, 10
DATA "Madrid", 19, 6
DATA "Andalusia", 21, 8
DATA "Ireland", 6, 8
DATA "Northern Ireland", 5, 9
DATA "Scotland", 5, 11
DATA "England", 8, 11
DATA "Britanny", 12, 11
DATA "Gascony", 16, 11
DATA "Champagne", 13, 15
DATA "Languedoc", 16, 13
DATA "Paris", 14, 13
DATA "Venetia", 16, 17
DATA "Tuscany", 18, 18
DATA "Rome", 20, 19
DATA "Naples", 22, 21
DATA "Sicily", 23, 19
DATA "Westphalia", 10, 17
DATA "Alsace-Lorraine", 12, 16
DATA "Bavaria", 12, 18
DATA "Brandenburg", 10, 20
DATA "Prussia", 8, 22
DATA "Austria", 14, 20
DATA "Bohemia", 13, 22
DATA "Bosnia", 16, 23
DATA "Hungary", 15, 25
DATA "Galicia", 13, 24
DATA "Constantinople", 20, 29
DATA "Ankara", 20, 34
DATA "Poland", 10, 24
DATA "St. Petersburg", 2, 29
DATA "Odessa", 14, 32
DATA "Moscow", 5, 35
DATA "Kiev", 11, 32
DATA "Portugal", 18, 4
DATA "Belgium", 10, 14
DATA "Netherlands", 9, 15
DATA "Switzerland", 14, 17
DATA "Norway", 2, 19
DATA "Denmark", 6, 18
DATA "Sweden", 4, 21
DATA "Romania", 16, 28
DATA "Bulgaria", 17, 27
DATA "Serbia", 18, 24
DATA "Albania", 20, 24
DATA "Greece", 21, 26
DATA "Morocco",23, 3
DATA "Algeria", 23, 8
DATA "Tunisia",23,14

SUB drawMap
CLS
FOR I = 1 TO 24
FOR J = 1 TO 35
LOCATE I, 2 * J - 1
IF holdCap(land(I, J)) = 0 THEN COLOR wc + 8, wc: PRINT "  "; : COLOR , 0 ELSE COLOR pCol(holdCap(land(I, J))): PRINT "  ";
NEXT J: NEXT I
FOR I = 1 TO 50
X$ = LTRIM$(RTRIM$(STR$(I)))
IF I < 10 THEN X$ = "0" + X$
COLOR pCol(holdCap(I))
LOCATE capitalX(I), 2 * capitalY(I) - 1: PRINT X$
IF stateStat(I) = 0 THEN LOCATE capitalX(I), 2 * capitalY(I) - 1: PRINT CHR$(8); CHR$(8)
NEXT I
FOR I = 1 TO 24: FOR J = 1 TO 35
IF navy(I, J) > 0 THEN LOCATE I, 2 * J - 1: COLOR pCol(navy(I, J)): PRINT "--": COLOR , 0
IF armies(I, J) > 0 THEN LOCATE I, 2 * J - 1: COLOR pCol(holdCap(armies(I, J))): PRINT CHR$(1); CHR$(1)
NEXT J: NEXT I
COLOR 7: LOCATE 25, 1
END SUB

SUB helpMe
CLS
PRINT "   World War is a war game mainly centered around the taking of states.  Each"
PRINT "of the nine countries is composed of between three and five mini-states.  Each"
PRINT "mini-state has a capital.  If you move one of your armies into a state's"
PRINT "capital, you take that state, it is absorbed into your country and you gain"
PRINT "control of the army that originated in that state."
PRINT "   If all your states are taken, you automatically surrender your navy to the"
PRINT "country that took the last state.  This means 'game over' for you."
PRINT "   Navies exist for the sole purpose of ferrying troops across rivers.  This"
PRINT "means that they are of utmost importance to powers such as Great Britain,"
PRINT "which is an island."
PRINT "   To attack an army, maneuver your army into it.  However, one army alone is"
PRINT "unable to defeat another army.  It needs support from allied armies.  Any"
PRINT "allied armies adjacent to the army being attacked will automatically support it."
PRINT "   Options in the menu:"
PRINT "(D)elay - do nothing.  You give up your turn."
PRINT "(M)ove units - mobilize your forces.  When moving armies, use the X key(next)"
PRINT "   to skip over an army.  You will come back to it.  Use the T key(stay) to"
PRINT "   have the army stand its ground.  With navies, the X key(next) does the same"
PRINT "   thing as the T key for armies."
PRINT "(O)ptions - do some spring cleaning.  Change your country's name or color and"
PRINT "   change the names of mini-states.  More importantly, you can relocate state"
PRINT "   capitals(inside the state borders) and change alliances."
DO WHILE INKEY$ = "": LOOP
PRINT "(S)urrender - when there's no hope, you can surrender.  This makes you"
PRINT "   necesarily neutral until the end of the game and neutralizes all states"
PRINT "   that were not yours at the game's outset.  Any states that you lost are"
PRINT "   not restored, but none of your current states will be able to be taken by"
PRINT "   other powers.  Also, all your armies and navies at the time you surrendered"
PRINT "   are disbanded and removed from the game.  This means that even if you could"
PRINT "   exit from the forced neutrality, you would be unable to do anything."
PRINT "(C)ede a state - use this command to hand over individual states to any other"
PRINT "   power.  Better one state than your whole country."
PRINT "(E)missary - This command is used to send messages to other powers."
PRINT : PRINT "That's all.  Now prepare for war!"
DO WHILE INKEY$ = "": LOOP
END SUB

SUB options
VIEW PRINT 9 TO 25
beginAgain:
CLS 2
LOCATE 9, 1
FOR I = 1 TO 8
COLOR pCol(I)
PRINT "  "; powerName$(I); " color"; pCol(I); "begins as ";
IF relation(I) = 0 THEN PRINT "neutral"
IF relation(I) = 1 THEN PRINT "central"
IF relation(I) = 2 THEN PRINT "Allied"
NEXT I
COLOR pCol(9)
PRINT "  Neutral territories are color"; pCol(9)
COLOR wc
PRINT "  Water is color"; wc
COLOR 7
PRINT "  Viewing distance is"; VD
PRINT "  Change state status"
COLOR 8: PRINT "  Exit(ESC)"
COLOR 7: PRINT "Enter changes names, Space changes alliances, left/right changes colors"
X = 1
DO
OX = X
V$ = INKEY$
IF V$ = CHR$(0) + "P" THEN OX = X: X = X + 1
IF V$ = CHR$(0) + "H" THEN OX = X: X = X - 1
IF V$ = CHR$(0) + "M" AND X = 11 THEN VD = VD + 1
IF VD = 6 THEN VD = 0
IF V$ = CHR$(0) + "K" AND X = 11 THEN VD = VD - 1
IF VD = -1 THEN VD = 5
LOCATE 19, 3: COLOR 7: PRINT "Viewing distance is"; VD
IF V$ = CHR$(0) + "M" AND X < 10 THEN
pCol(X) = pCol(X) + 1
reTry78:
FOR I = 1 TO 9
IF pCol(I) = pCol(X) AND I <> X THEN pCol(X) = pCol(X) + 1: GOTO reTry78
IF pCol(X) = wc THEN pCol(X) = pCol(X) + 1: GOTO reTry78
IF pCol(X) = 16 THEN pCol(X) = 1: GOTO reTry78
NEXT I
LOCATE 8 + X, 3: PRINT SPACE$(78)
COLOR pCol(X): LOCATE 8 + X, 3
IF X < 9 THEN
PRINT powerName$(X); " color"; pCol(X); "begins as ";
IF relation(X) = 0 THEN PRINT "neutral"
IF relation(X) = 1 THEN PRINT "central"
IF relation(X) = 2 THEN PRINT "Allied"
ELSE
PRINT "Neutral territories are color"; pCol(9)
END IF
END IF
IF V$ = CHR$(0) + "K" AND X = 10 THEN
wc = wc - 1
reTry82:
FOR I = 1 TO 9
IF pCol(I) = wc THEN wc = wc - 1: GOTO reTry82
IF wc = 0 THEN wc = 8: GOTO reTry82
NEXT I
LOCATE 18, 3: COLOR wc: PRINT "Water is color"; wc
END IF
IF V$ = CHR$(0) + "M" AND X = 10 THEN
wc = wc + 1
reTry85:
FOR I = 1 TO 9
IF pCol(I) = wc THEN wc = wc + 1: GOTO reTry85
IF wc = 9 THEN wc = 1: GOTO reTry85
NEXT I
LOCATE 18, 3: COLOR wc: PRINT "Water is color"; wc
END IF
IF V$ = CHR$(0) + "K" AND X < 10 THEN
pCol(X) = pCol(X) - 1
reTry77:
FOR I = 1 TO 9
IF pCol(I) = pCol(X) AND I <> X THEN pCol(X) = pCol(X) - 1: GOTO reTry77
IF wc = pCol(X) THEN pCol(X) = pCol(X) - 1: GOTO reTry77
IF pCol(X) = 0 THEN pCol(X) = 15: GOTO reTry77
NEXT I
LOCATE 8 + X, 3: PRINT SPACE$(78)
COLOR pCol(X): LOCATE 8 + X, 3
IF X < 9 THEN
PRINT powerName$(X); " color"; pCol(X); "begins as ";
IF relation(X) = 0 THEN PRINT "neutral"
IF relation(X) = 1 THEN PRINT "central"
IF relation(X) = 2 THEN PRINT "Allied"
ELSE
PRINT "Neutral territories are color"; pCol(9)
END IF
END IF
IF X = 0 THEN X = 13
IF X = 14 THEN X = 1
IF X = 13 AND V$ = CHR$(13) THEN EXIT DO
IF X = 12 AND V$ = CHR$(13) THEN
moved = 1
COLOR 7: LOCATE 22, 1: PRINT "Use up/down to change state, left/right to change nationality, enter to change"
PRINT "name, and ESCAPE to exit."
sloc = 1
LOCATE 14, 48: PRINT "-" + CHR$(16)
DO UNTIL V$ = CHR$(27)
IF moved = 1 THEN
moved = 0
FOR I = sloc - 5 TO sloc + 5
LOCATE 14 + (I - sloc), 50: PRINT SPACE$(30)
LOCATE 14 + (I - sloc), 50
IF I <= 50 AND I > 0 THEN COLOR pCol(holdCap(I)): PRINT stateName$(I)
IF I > 50 THEN COLOR pCol(holdCap(I - 50)): PRINT stateName$(I - 50)
IF I <= 0 THEN COLOR pCol(holdCap(I + 50)): PRINT stateName$(I + 50)
NEXT I
END IF
V$ = INKEY$
IF V$ = CHR$(0) + "P" THEN moved = 1: sloc = sloc + 1
IF sloc = 51 THEN sloc = 1
IF V$ = CHR$(0) + "H" THEN moved = 1: sloc = sloc - 1
IF sloc = 0 THEN sloc = 50
IF V$ = CHR$(0) + "M" THEN moved = 1: holdCap(sloc) = holdCap(sloc) + 1
IF holdCap(sloc) = 10 THEN holdCap(sloc) = 1
IF V$ = CHR$(0) + "K" THEN moved = 1: holdCap(sloc) = holdCap(sloc) - 1
IF holdCap(sloc) = 0 THEN holdCap(sloc) = 9
IF V$ = CHR$(13) THEN COLOR 7: LOCATE 20, 50: INPUT "New name"; stateName$(sloc): LOCATE 20, 50: PRINT SPACE$(30)
LOOP
V$ = ""
FOR I = 9 TO 19
LOCATE I, 50: PRINT SPACE$(30)
NEXT I
LOCATE 14, 48: PRINT "  "
LOCATE 22, 1
COLOR 7: PRINT "Enter changes names, Space changes alliances, left/right changes colors          "
LOCATE 23, 1: PRINT SPACE$(80)
END IF
IF X < 9 AND V$ = CHR$(13) THEN
COLOR pCol(X)
LOCATE 22, 1: PRINT "Old name = "; powerName$(X)
INPUT "New name"; powerName$(X)
LOCATE 8 + X, 3: PRINT SPACE$(78)
COLOR pCol(X): LOCATE 8 + X, 3
PRINT powerName$(X); " color"; pCol(X); "begins as ";
IF relation(X) = 0 THEN PRINT "neutral"
IF relation(X) = 1 THEN PRINT "central"
IF relation(X) = 2 THEN PRINT "Allied"
END IF
IF X < 9 AND V$ = " " THEN
COLOR pCol(X)
LOCATE 22, 1: PRINT "Previous alliance = ";
IF relation(X) = 0 THEN PRINT "neutral"
IF relation(X) = 1 THEN PRINT "central"
IF relation(X) = 2 THEN PRINT "Allied"
INPUT "New alliance (0 = neutral, 1 = central, 2 = Allied)"; relation(X)
LOCATE 8 + X, 3: PRINT SPACE$(78)
COLOR pCol(X): LOCATE 8 + X, 3
PRINT powerName$(X); " color"; pCol(X); "begins as ";
IF relation(X) = 0 THEN PRINT "neutral"
IF relation(X) = 1 THEN PRINT "central"
IF relation(X) = 2 THEN PRINT "Allied"
END IF
IF X <> OX THEN LOCATE 8 + OX, 1: PRINT "  "
LOCATE 8 + X, 1: COLOR 14: PRINT "-"; CHR$(16)
LOOP UNTIL V$ = CHR$(27)
VIEW PRINT: CLS : COLOR 7
END SUB


