
#include <stdio.h>
#include <dos.h>
#include <math.h>




#define maxangle    256
#define angle180    (maxangle/2)
#define PI          3.141592654


int RaceNbCheck=1;
int RaceNbTour=1;

struct bagnole {

               char numero;
               long px,py;
               int  accel;
               char angle;
               long incx,incy;
               long sincx,sincy;

               long incdepx,incdepy;
               char derap,depangle;

               char collision;
               char collix,colliy,collia,collic;

               char nbtour;
               char nbcheck;
               char actif;
               char ligne;

               char *sprite;
               char *affi_sprite;
               char *background;
               char *foreground;
               };

struct RACE   {
              char pixname[13];
              char fontname[13];
              char racename[20];

              char nbtour;
              char nbcheck;

              signed char clas[8];
              char minute,seconde,tick;

              int grillex[8],grilley[8];
              char grillea[8];
              };



long *horloge=(char *)0x46C;
long oldtime,newtime;
char *virtual;
char *screen=(char *)0xA0000;
long GPage=0;
char keytab[128];
long sinTable[maxangle];
long cosTable[maxangle];
unsigned char FONT[32768];


struct bagnole p[8];




void (__interrupt *ancint)();

void __interrupt newint()
{
char k;

_disable();
k=inp(0x60);
keytab[k&127]=1-(k>>7);

if(keytab[88]) reboot();
_enable();
outp(0x20,0x20);
}

void __interrupt complete()
{
char k;

_disable();
k=inp(0x60);
keytab[k&127]=1-(k>>7);

if(keytab[88]) reboot();
_enable();
ancint();
}

extern void reboot();
#pragma aux reboot=\
        "mov eax,0472h"\
        "mov ebx,eax"\
        "mov [ebx],1234h"\
        "mov ax,1"\
        "int 19h";





extern void graphmode();
#pragma aux graphmode=\
        "mov ax,3"\
        "int 10h"\
        "mov ax,4f02h"\
        "mov bx,101h"\
        "int 10h";

extern void textmode();
#pragma aux textmode=\
        "mov ax,3"\
        "int 10h";

extern void setpage(int);
#pragma aux setpage parm [edx]=\
        "pusha"\
        "mov ax,4f05h"\
        "mov bx,0"\
        "int 10h"\
        "popa";

void putpixel(int x,int y,char col)
{
unsigned long ad,pa;
char *scr;

ad=y;
ad*=640;
ad+=x;
pa=ad>>16;
if(pa!=GPage) { GPage=pa;setpage(GPage); }
scr=screen;
ad&=65535;
scr+=ad;
*scr=col;
}

char getpixel(int x,int y)
{
unsigned long ad,pa;
char *scr,col;

ad=y;
ad*=640;
ad+=x;
pa=ad>>16;
if(pa!=GPage) { GPage=pa;setpage(GPage); }
scr=screen;
ad&=65535;
scr+=ad;
col=*scr;
return col;
}

void clrgraph(char col)
{
char *scr;
unsigned int j,i;

for(j=0;j<5;j++)
    {
    GPage=j;
    setpage(GPage);
    scr=screen;
    for(i=0;i<65535;i++)
        *scr++=col;
    *scr++=col;
    }
GPage=0;
setpage(GPage);
}

void refresh()
{
char *scr,*vir;
long j,i;

vir=virtual;
for(j=0;j<4;j++)
    {
    GPage=j;
    setpage(GPage);
    scr=screen;
    for(i=0;i<65536;i++)
        *scr++=*vir++;
    }
    GPage=4;
    setpage(GPage);
    scr=screen;
    for(i=0;i<45056;i++)
        *scr++=*vir++;

GPage=0;
setpage(GPage);
}

void setpal(char col,char r,char g,char b)
{
outp(0x3c8,col);
outp(0x3c9,r);
outp(0x3c9,g);
outp(0x3c9,b);
}

void getpal(char col,char *r,char *g,char *b)
{
outp(0x3c7,col);
*r=inp(0x3c9);
*g=inp(0x3c9);
*b=inp(0x3c9);
}

long filesize(FILE *f)
{
long i,j;

i=ftell(f);
fseek(f,0,SEEK_END);
j=ftell(f);
fseek(f,i,SEEK_SET);
return j;
}





void teacher()
{
char *v,*tpv,*p,*tpp;
char *scr;
long j,i;

v=(char *)malloc(307200);
p=(char *)malloc(768);
tpv=v;
for(j=0;j<4;j++)
    {
    GPage=j;
    setpage(GPage);
    scr=screen;
    for(i=0;i<65536;i++)
        *tpv++=*scr++;
    }
    GPage=4;
    setpage(GPage);
    scr=screen;
    for(i=0;i<45056;i++)
        *tpv++=*scr++;
tpp=p;
for(i=0;i<256;i++)
    getpal(i,&tpp[i*3],&tpp[i*3+1],&tpp[i*3+2]);
textmode();
_dos_setvect(9,complete);

        {
        FILE *f;
        char *buf,*sc;

        buf=(char *)malloc(4000);
        f=fopen("capt.txt","rb");
        fread(buf,1,2000,f);
        fclose(f);
        sc=(char *)0xb8000;
        for(i=0;i<2000;i++)
            sc[i*2]=buf[i];
        while(1)
           if(getch()==0) if(getch()==59) break;
        free(buf);
        }

graphmode();
tpp=p;
for(i=0;i<256;i++)
    setpal(i,tpp[i*3],tpp[i*3+1],tpp[i*3+2]);
tpv=v;
for(j=0;j<4;j++)
    {
    GPage=j;
    setpage(GPage);
    scr=screen;
    for(i=0;i<65536;i++)
        *scr++=*tpv++;
    }
    GPage=4;
    setpage(GPage);
    scr=screen;
    for(i=0;i<45056;i++)
        *scr++=*tpv++;
_dos_setvect(9,newint);
free(v);
}





void charge_pcx(char *name,char *buf,char num)
{
FILE *f;
int size,i,j,k,l;
char *tmp,*b,pal[48];

f=fopen(name,"rb");
size=filesize(f);
tmp=(char *)malloc(size-896);
fseek(f,128,SEEK_SET);
fread(tmp,1,size-896,f);
fread(pal,1,48,f);
fclose(f);
b=buf;
i=0;
l=0;
while(l<576)
   if(tmp[i]>192)
      {
      j=tmp[i++];
      for(k=0;k<(j-192);k++)
          b[l++]=tmp[i];
      i++;
      }
      else
      b[l++]=tmp[i++];
for(i=0;i<576;i++)
    if(b[i]!=255) b[i]=b[i]+(num*16)+128;
for(i=0;i<16;i++)
    setpal(i+128+(num*16),pal[i*3]>>2,pal[i*3+1]>>2,pal[i*3+2]>>2);
free(tmp);
}

void charge_race(char *name)
{
FILE *f;
int size,i,j,k,l;
char *tmp,*b,pal[384];

f=fopen(name,"rb");
size=filesize(f);
tmp=(char *)malloc(size-896);
fseek(f,128,SEEK_SET);
fread(tmp,1,size-896,f);
fread(pal,1,384,f);
fclose(f);
b=virtual;
i=0;
l=0;
while(l<307200)
   if(tmp[i]>192)
      {
      j=tmp[i++];
      for(k=0;k<(j-192);k++)
          b[l++]=tmp[i];
      i++;
      }
      else
      b[l++]=tmp[i++];
for(i=0;i<128;i++)
    setpal(i,pal[i*3]>>2,pal[i*3+1]>>2,pal[i*3+2]>>2);
free(tmp);
}

void line_textu(int px,int py,int lon,char *buf)
{
long ad,pa;
char *scr,*fin;
int i;

ad=py;
ad*=640;
ad+=px;
pa=ad;
pa>>=16;
if(pa!=GPage) { GPage=pa;setpage(GPage); }
scr=screen;
ad&=65535;
scr+=ad;
fin=(char *)0xB0000;
for(i=0;i<lon;i++)
    {
    *scr++=*buf++;
    if(scr>=fin) { GPage++;setpage(GPage);scr=screen; }
    }
}

void affiche_voiture(struct bagnole *p)
{
int j,x,y;
char *f;

if(!p->actif) return;

x=(p->px)>>16;
y=(p->py)>>16;
f=p->foreground;
for(j=0;j<32;j++)
    {
    line_textu(x,y,32,f);
    y++;
    f+=32;
    }
}

void affichesprite(struct bagnole *p)
{
int i,j,x,y;
char *f,*vir,col;
long ad;

if(!p->actif) return;

x=(p->px)>>16;
y=(p->py)>>16;
f=p->affi_sprite;
vir=virtual;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        {
        col=*f++;
        if(col!=255) *vir++=col; else vir++;
        }
    vir+=608;
    }
}

void capture_back(struct bagnole *p)
{
int i,j,x,y;
char *f,*vir;
long ad;

if(!p->actif) return;

x=(p->px)>>16;
y=(p->py)>>16;
f=p->background;
vir=virtual;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        *f++=*vir++;
    vir+=608;
    }
}

void restore_back(struct bagnole *p)
{
int i,j,x,y,k,l;
char *f,*vir;
long ad;

if(!p->actif) return;

k=(p->sincx)>>16;
l=(p->sincy)>>16;
x=(p->px)>>16;
y=(p->py)>>16;
x-=k;
y-=l;
f=p->background;
vir=virtual;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        *vir++=*f++;
    vir+=608;
    }
}

void capture_fore(struct bagnole *p)
{
int i,j,x,y;
char *f,*vir,col;
long ad;

if(!p->actif) return;

x=(p->px)>>16;
y=(p->py)>>16;
f=p->foreground;
vir=virtual;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        *f++=*vir++;
    vir+=608;
    }
}

void clearsprite(struct bagnole *p,char col)
{
int i;
char *b;

if(!p->actif) return;

b=p->affi_sprite;
for(i=0;i<1024;i++)
    *b++=col;
}

void scroll_sprite(struct bagnole *p)
{
int k;

if(!p->actif) return;

   k=(p->sincx)>>16;
   p->sincx-=(k<<16);
   k=(p->sincy)>>16;
   p->sincy-=(k<<16);
}

extern long Mul16(long,long);
#pragma aux Mul16 parm [eax] [edx] = \
        "imul edx"\
        "shrd eax,edx,16";

void InitSinTable(void)
{
    int i;

    for (i=0; i<maxangle; i++)
	sinTable[i] = sin((double)i*PI / angle180) * 0x10000;

    for (i=0; i<maxangle; i++)
	cosTable[i] = cos((double)i*PI / angle180) * 0x10000;
}

void rotate(struct bagnole *p,int scale)
{
    unsigned char *dest;
    long u,v,rowV, rowU, startU, startV;
    long duCol,dvCol,duRow,dvRow;
    int x,y;
    char *bitmap,*buf;
    int angle;

if(!p->actif) return;

    bitmap=p->sprite;
    buf=p->affi_sprite;
    angle=(p->angle-64)&255;

    startU = 12 << 16;
    startV = 12 << 16;

    duCol = cosTable[angle];
    dvCol = sinTable[angle];

    duCol = Mul16(duCol,scale);
    dvCol = Mul16(dvCol,scale);

    duRow = -dvCol;
    dvRow = duCol;

    startU -= 16*duCol + 16*duRow;
    startV -= 16*dvCol + 16*dvRow;

    rowU = startU;
    rowV = startV;
    dest = buf;

    for (y=0; y<32; y++)
    {
	u = rowU;
	v = rowV;

        for (x=0; x<32; x++)
	{
                if((u>>16)>-1 && (u>>16)<24 && (v>>16)>-1 && (v>>16)<24)
                *dest++=bitmap[(u>>16) + ((v>>16) * 24)];
		else dest++;
	    u += duCol;
	    v += dvCol;
	}
	rowU += duRow;
	rowV += dvRow;
    }
}

int impact_mur(struct bagnole *p,int *impx,int *impy)
{
int i,j,x,y;
char *f,*vir,col,mur;
long ad;

x=(p->px)>>16;
y=(p->py)>>16;
vir=virtual;
f=p->affi_sprite;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
mur=0;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        {
        if(*f!=255)
            {
            col=*vir;
            if(col==127) { mur=1;*impx=i;*impy=j; }
            }
        vir++;
        f++;
        }
    vir+=608;
    }
return mur;
}

void controle_posi(struct bagnole *p)
{
int x,y;

if(!p->actif) return;

if(impact_mur(p,&x,&y))
    {
    p->accel>>=1;
    switch((p->angle)>>5)
        {
        case 0 :
                if(x>15 && x<27 && y<16) p->angle=(-p->angle)&255;
                break;
        case 1 :
                if(x>15 && y<16 && y>5) p->angle=(128-p->angle)&255;
                break;
        case 2 :
                if(x<16 && y<16 && y>5) p->angle=(128-p->angle)&255;
                break;
        case 3 :
                if(x<16 && x>5 && y<16) p->angle=(-p->angle)&255;
                break;
        case 4 :
                if(x<16 && x>5 && y>15) p->angle=(-p->angle)&255;
                break;
        case 5 :
                if(x<16 && y<27 && y>15) p->angle=(128-p->angle)&255;
                break;
        case 6 :
                if(x>15 && y<27 && y>15) p->angle=(128-p->angle)&255;
                break;
        case 7 :
                if(x>15 && x<27 && y>15) p->angle=(-p->angle)&255;
                break;
        }
    }
while(impact_mur(p,&x,&y))
    {
    if(x>15)
        p->incx=-0x10000;
        else
        p->incx=0x10000;
    p->px+=p->incx;
    p->sincx+=p->incx;
    if(y>15)
        p->incy=-0x10000;
        else
        p->incy=0x10000;
    p->py+=p->incy;
    p->sincy+=p->incy;
    p->derap=0;
    }
}

int impact_voiture(struct bagnole *p,int *impx,int *impy,char *c)
{
int i,j,x,y;
char *f,*vir,col,mur;
long ad;

x=(p->px)>>16;
y=(p->py)>>16;
vir=virtual;
f=p->affi_sprite;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
mur=0;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        {
        if(*f!=255)
            {
            col=*vir;
            if(col>127)
               if(col<(128+p->numero*16) || col>(143+p->numero*16))
                  { mur=1;*impx=i;*impy=j;*c=col; }
            }
        vir++;
        f++;
        }
    vir+=608;
    }
return mur;
}

void collision(struct bagnole *p)
{
int x,y;
char c;

if(!p->actif) return;

if(impact_voiture(p,&x,&y,&c))
   {
   p->collision=1;
   p->collix=x;
   p->colliy=y;
   p->collia=p->angle;
   p->collic=c;
   }
   else
   p->collision=0;
}

void retour_collision(struct bagnole *p)
{
long i,j;

if(!p->actif) return;

if(p->collision)
    {
    if(p->collix>15)
        p->incx=-0x10000;
        else
        p->incx=0x10000;
    if(p->colliy>15)
        p->incy=-0x10000;
        else
        p->incy=0x10000;

    p->px+=p->incx;
    p->sincx+=p->incx;
    p->py+=p->incy;
    p->sincy+=p->incy;
    p->derap=0;
    p->accel/=2;

/*
    if((p->collix>15 && p->colliy<16) || (p->collix<16 && p->colliy>15))
        p->angle++;
        else
        p->angle--;
*/
    i=(long)(p->colliy * cosTable[(-p->collia)&255] -
             p->collix * sinTable[(-p->collia)&255]);
    i>>=16;
    j=(long)(p->collix * cosTable[(-p->collia)&255] -
             p->colliy * sinTable[(-p->collia)&255]);
    j>>=16;
    p->collix=j;
    p->colliy=i;
    p->collic-=128;
    p->collic>>=4;
    }
}

void changefont(char *name)
{
unsigned char *bin;
int i,j;
FILE *f;

bin=(char *)malloc(4096);
f=fopen(name,"rb");
fread(bin,1,4096,f);
fclose(f);
for(i=0;i<4096;i++)
    for(j=7;j>-1;j--)
        FONT[i*8+7-j]=(bin[i]>>j)&1;
free(bin);
}

void outtextxy(int x,int y,unsigned char far *str,int col,int bck)
{
int i,j,l;
char ad;

l=0;
while(*str!=0)
   {
   for(j=0;j<16;j++)
       for(i=0;i<8;i++)
           {
           if(*str<32) getch();
           ad=FONT[(int)((*str)*128+j*8+i)];
           if(ad) { if(col>-1) putpixel(x+l*8+i,y+j,col*ad); }
		  else if(bck>-1) putpixel(x+l*8+i,y+j,bck);
           }
   str++;
   l++;
   }
}

int roule_ligne(struct bagnole *p)
{
int i,j,x,y;
char *f,*vir,col,mur;
long ad;

x=(p->px)>>16;
y=(p->py)>>16;
vir=virtual;
f=p->affi_sprite;
ad=y;
ad*=640;
ad+=x;
vir+=ad;
mur=0;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        {
        if(*f!=255)
            {
            col=*vir;
            if(col==126) mur=1;
            if(col==125) mur=2;
            }
        vir++;
        f++;
        }
    vir+=608;
    }
return mur;
}

void franchir_ligne(struct bagnole *p)
{
int c;

if(!p->actif) return;

c=roule_ligne(p);
if(c==1 && p->ligne==0 && p->nbcheck>=RaceNbCheck ) p->ligne=1;
if(c==0 && p->ligne==1 && p->nbcheck>=RaceNbCheck )
        {
        p->nbtour++;
        p->ligne=0;
        p->nbcheck=0;
        affiche_tour(p);
        }
if(c==2 && p->ligne==0) p->ligne=2;
if(c==0 && p->ligne==2) { p->nbcheck++;p->ligne=0; }
}



void initplayer(struct bagnole *p,char *n,char num)
{
int i,j;

if(!p->actif) return;

p->sprite=(char *)malloc(576);
p->affi_sprite=(char *)malloc(1024);
p->background=(char *)malloc(1024);
p->foreground=(char *)malloc(1024);
p->numero=num;
charge_pcx(n,p->sprite,p->numero);
}

void closeplayer(struct bagnole *p)
{
if(!p->actif) return;

free(p->sprite);
free(p->affi_sprite);
free(p->background);
free(p->foreground);
}

void race_player(struct bagnole *p,int x,int y,char angle)
{
if(!p->actif) return;

p->px=(long)(x<<16);
p->py=(long)(y<<16);
p->accel=0;
p->angle=angle;
p->incx=0;
p->incy=0;
p->sincx=0;
p->sincy=0;
p->nbtour=0;
p->nbcheck=0;
p->ligne=0;
p->derap=0;
p->incdepx=0;
p->incdepy=0;
p->collision=0;
}

void charge_depart(char *name,char *buf,int sizex,int sizey)
{
FILE *f;
int size,i,j,k,l;
char *tmp,*b,pal[48];

f=fopen(name,"rb");
size=filesize(f);
tmp=(char *)malloc(size-896);
fseek(f,128,SEEK_SET);
fread(tmp,1,size-896,f);
fclose(f);
b=buf;
i=0;
l=0;
while(l<(sizex*sizey))
   if(tmp[i]>192)
      {
      j=tmp[i++];
      for(k=0;k<(j-192);k++)
          b[l++]=tmp[i];
      i++;
      }
      else
      b[l++]=tmp[i++];
free(tmp);
}

void ready_go()
{
char *buf;
int i,j;

delay(500);
buf=(char *)malloc(36096);
charge_depart("ready.pre",buf,384,94);
for(j=0;j<94;j++)
    for(i=0;i<384;i++)
        if(buf[i+j*384]!=255) putpixel(128+i,193+j,buf[i+j*384]);
free(buf);
delay(2000);
refresh();
buf=(char *)malloc(28548);
charge_depart("go.pre",buf,234,122);
for(j=0;j<122;j++)
    for(i=0;i<234;i++)
        if(buf[i+j*234]!=255) putpixel(203+i,179+j,buf[i+j*234]);
free(buf);
delay(1000);
refresh();
}

void race_over()
{
char *buf;
int i,j;

buf=(char *)malloc(57152);
charge_depart("raceover.pre",buf,304,188);
for(j=0;j<188;j++)
    for(i=0;i<304;i++)
        if(buf[i+j*304]!=255) putpixel(168+i,146+j,buf[i+j*304]);
free(buf);
delay(3000);
}

void trace_pneus(struct bagnole *p)
{
int i,j;
char *b,*l;

if(!p->actif) return;

b=p->affi_sprite;
l=p->background;
for(j=0;j<32;j++)
    for(i=0;i<32;i++)
        {
        if(*b==(14+128+(p->numero*16)))
           l[j*32+i]=0;
        b++;
        }
}

void accelerator(struct bagnole *p)
{
int i,j;
char *b,*l;

if(!p->actif) return;

b=p->affi_sprite;
l=p->background;
for(j=0;j<32;j++)
    for(i=0;i<32;i++)
        {
        if(*b!=255)
            if(*l==123 || *l==124)
                if(p->accel<410) p->accel+=3;
        b++;
        l++;
        }
}




void affiche_tour(struct bagnole *p)
{
char num[10];

if(!p->actif) return;

convert_nbtour(RaceNbTour-p->nbtour,num);
outtextxy(51+70*p->numero,460,num,4,8);
}

void convert_nbtour(int i,char *b)
{
int k;
char l;

l=i/10;
i-=l*10;
*b++=(l+48);
l=i;
i-=l;
*b++=(l+48);
*b=0;
}

void player_accel(struct bagnole *p)
{
int rap_dep;

if(!p->actif) return;

if(p->accel)
   {
   p->incx=(cosTable[p->angle] * sqrt(p->accel*2)/15) ;
   p->incy=(-sinTable[p->angle] * sqrt(p->accel*2)/15 );
   if(p->derap>0)
      {
      p->incdepx=(cosTable[p->depangle] * sqrt(p->accel*2)/15);
      p->incdepy=(-sinTable[p->depangle] * sqrt(p->accel*2)/15);
      p->px+=(p->incdepx*2+p->incx*3)/5;
      p->py+=(p->incdepy*2+p->incy*3)/5;
      p->sincx+=(p->incdepx*2+p->incx*3)/5;
      p->sincy+=(p->incdepy*2+p->incy*3)/5;
      p->derap--;
      rap_dep=p->angle-p->depangle;
      if(rap_dep>0)
          {
          if(rap_dep>10)
              if(p->accel>1) p->accel-=2; else p->accel=0;
          if(rap_dep>64) trace_pneus(p);
	  }
	  else
          {
          if(rap_dep<-10)
              if(p->accel>1) p->accel-=2; else p->accel=0;
          if(rap_dep<-64) trace_pneus(p);
          }
      }
      else
      {
      p->px+=p->incx;
      p->py+=p->incy;
      p->sincx+=p->incx;
      p->sincy+=p->incy;
      }
   }
}

void select(char *name)
{
FILE *f;
int size,i,j,k,l;
char *tmp,*b,pal[384];

f=fopen(name,"rb");
size=filesize(f);
tmp=(char *)malloc(size-896);
fseek(f,128,SEEK_SET);
fread(tmp,1,size-896,f);
fread(pal,1,384,f);
fclose(f);
b=virtual;
i=0;
l=0;
while(l<307200)
   if(tmp[i]>192)
      {
      j=tmp[i++];
      for(k=0;k<(j-192);k++)
          b[l++]=tmp[i];
      i++;
      }
      else
      b[l++]=tmp[i++];
for(i=0;i<128;i++)
    setpal(i,pal[i*3]>>2,pal[i*3+1]>>2,pal[i*3+2]>>2);
free(tmp);
refresh();
}

void settimer()
{
long v;

v=(long)(1193180 / 165);
outp(0x43,54);
outp(0x40,v & 255);
outp(0x40,v >> 8);
}

void resettimer()
{
outp(0x43,54);
outp(0x40,0);
outp(0x40,0);
}

int lirenb(char **buf)
{
unsigned int i=0;

while(**buf!=13 && **buf!=32)
    {
    i*=10;
    i+=(**buf-48);
    *buf++;
    }
return i;
}

void lire_course(char *n,struct RACE *c)
{
FILE *f;
char *b,*buf;
int i,j;

f=fopen(n,"rb");
b=(char *)malloc(filesize(f));
buf=b;
fread(b,1,filesize(f),f);
fclose(f);

while(*b++!='N') {}
b++;i=0;
while(*b!=13 && *b!=32)
   c->pixname[i++]=*b++;
c->pixname[i]=0;

while(*b++!='D') {}
b++;i=0;
while(*b!='\\')
   c->racename[i++]=*b++;
c->racename[i]=0;

while(*b++!='F') {}
b++;i=0;
while(*b!=13 && *b!=32)
   c->fontname[i++]=*b++;
c->fontname[i]=0;

while(*b++!='T') {}
b++;
c->nbtour=0;
while(*b!=13 && *b!=32)
    {
    c->nbtour*=10;
    c->nbtour+=(*b-48);
    b++;
    }

while(*b++!='C') {}
b++;
c->nbcheck=0;
while(*b!=13 && *b!=32)
    {
    c->nbcheck*=10;
    c->nbcheck+=(*b-48);
    b++;
    }

for(i=0;i<8;i++)
    {
    while(*b++!=(i+49)) {}
    b++;
    j=0;
    while(*b!=32)
        {
        j*=10;
        j+=(*b-48);
        b++;
        }
    c->grillex[i]=j;
    b++;
    j=0;
    while(*b!=32)
        {
        j*=10;
        j+=(*b-48);
        b++;
        }
    c->grilley[i]=j;
    b++;
    j=0;
    while(*b!=13 && *b!=32)
        {
        j*=10;
        j+=(*b-48);
        b++;
        }
    c->grillea[i]=j;
    }

for(i=0;i<8;i++)
    c->clas[i]=-1;
c->minute=0;
c->seconde=0;
c->tick=0;

free(buf);
}

void transparence(char r,char g,char b)
{
char rr,gg,bb;
int j;

for(j=0;j<256;j++)
    {
    getpal(j,&rr,&gg,&bb);
    rr=(rr+r)>>1;
    gg=(gg+g)>>1;
    bb=(bb+b)>>1;
    setpal(j,rr,gg,bb);
    }
}

void classement(struct RACE *c,struct bagnole *p)
{
int j;
for(j=0;j<8;j++)
    if(c->clas[j]==p->numero) return;
for(j=0;j<8;j++)
    if(c->clas[j]==-1) { c->clas[j]=p->numero;return; }
}

void course(struct bagnole *play1,struct bagnole *play2,char *race)
{
struct RACE COURSE;

lire_course(race,&COURSE);

changefont(COURSE.fontname);
charge_race(COURSE.pixname);
RaceNbTour=COURSE.nbtour;
RaceNbCheck=COURSE.nbcheck;
refresh();

//******************************
// affichage en bas de l'cran

race_player(play1,5+play1->numero*70,451,0);
race_player(play2,5+play2->numero*70,451,0);

clearsprite(play1,255);
clearsprite(play2,255);
rotate(play1,0x10000);
rotate(play2,0x10000);
capture_back(play1);
capture_back(play2);
affichesprite(play1);
affichesprite(play2);
capture_fore(play1);
capture_fore(play2);
affiche_voiture(play1);
affiche_voiture(play2);

//*****************************

race_player(play1,COURSE.grillex[play1->numero],COURSE.grilley[play1->numero],COURSE.grillea[play1->numero]);
race_player(play2,COURSE.grillex[play2->numero],COURSE.grilley[play2->numero],COURSE.grillea[play2->numero]);

//*****************************
//affichage des voitures sur la piste au debut de la course

capture_back(play1);
capture_back(play2);
clearsprite(play1,255);
clearsprite(play2,255);
rotate(play1,0x10000);
rotate(play2,0x10000);
capture_back(play1);
capture_back(play2);
affichesprite(play1);
affichesprite(play2);
capture_fore(play1);
capture_fore(play2);
affiche_voiture(play1);
affiche_voiture(play2);

//*********************************

ancint = _dos_getvect(9);
_dos_setvect(9,newint);
settimer();

ready_go();

affiche_tour(play1);
affiche_tour(play2);

while(!(keytab[1]==1
      || ((play1->nbtour==RaceNbTour && play1->accel==0 || !play1->actif)
      &&  (play2->nbtour==RaceNbTour && play2->accel==0 || !play2->actif))))
{

if(play1->nbtour==RaceNbTour && play1->actif)
        classement(&COURSE,play1);
if(play2->nbtour==RaceNbTour && play2->actif)
        classement(&COURSE,play2);

oldtime=*horloge;
if(keytab[59]) teacher();
if(keytab[75]) {
               if(play1->accel>0) { play1->accel--; }
               if(play1->accel>150 && play1->derap==0)
                   {
                   play1->derap=((play1->accel-150)/2);
                   play1->depangle=play1->angle;
                   }
               play1->angle++;
               play1->angle&=255;
               }
               else
               if(keytab[77]) {
               if(play1->accel>0) { play1->accel--; }
               if(play1->accel>150 && play1->derap==0)
                   {
                   play1->derap=((play1->accel-150)/2);
                   play1->depangle=play1->angle;
                   }
               play1->angle--;
               play1->angle&=255;
               }
if(keytab[72] && play1->nbtour<RaceNbTour)
        { if(play1->accel<370) play1->accel++; }
        else if(play1->accel>1) { play1->accel-=2; } else play1->accel=0;
player_accel(play1);

if(keytab[30]) {
               if(play2->accel>0) { play2->accel--; }
               if(play2->accel>150 && play2->derap==0)
                   {
                   play2->derap=((play2->accel-150)/2);
                   play2->depangle=play2->angle;
		   }
               play2->angle++;
               play2->angle&=255;
               }
           else
           if(keytab[32]) {
               if(play2->accel>0) { play2->accel--; }
               if(play2->accel>150 && play2->derap==0)
                   {
                   play2->derap=((play2->accel-150)/2);
                   play2->depangle=play2->angle;
                   }
               play2->angle--;
               play2->angle&=255;
               }
if(keytab[17] && play2->nbtour<RaceNbTour)
        { if(play2->accel<370) play2->accel++; }
        else if(play2->accel>1) { play2->accel-=2; } else play2->accel=0;
player_accel(play2);


clearsprite(play1,255);
clearsprite(play2,255);

rotate(play1,0x10000);
rotate(play2,0x10000);

restore_back(play1);
restore_back(play2);

retour_collision(play1);
retour_collision(play2);

controle_posi(play1);
controle_posi(play2);

franchir_ligne(play1);
franchir_ligne(play2);

capture_back(play1);
capture_back(play2);

affichesprite(play1);
collision(play2);
affichesprite(play2);
collision(play1);

capture_fore(play1);
capture_fore(play2);

affiche_voiture(play1);
affiche_voiture(play2);

scroll_sprite(play1);
scroll_sprite(play2);

accelerator(play1);
accelerator(play2);

while(oldtime==*horloge) {}
}

race_over();

resettimer();
_dos_setvect(9,ancint);
transparence(0,0,0);
setpal(255,63,63,63);
outtextxy(270,150,"Race results",255,-1);
        {
        char str[12];
        int i;
        strcopy(" . Joueur  ",str);
        for(i=0;i<8;i++)
            {
            str[0]=i+49;
            str[10]=COURSE.clas[i]+49;
            outtextxy(230,190+i*16,str,255,-1);
            }
        }
getch();
}

void strcopy(char *s,char *d)
{
while(*s!=0)
   *d++=*s++;
*d=*s;
}

void fade_out()
{
char r,g,b;
int i,j;

for(i=0;i<64;i++)
    {
    for(j=0;j<256;j++)
        {
        getpal(j,&r,&g,&b);
        if(r) r--;
        if(g) g--;
        if(b) b--;
        setpal(j,r,g,b);
        }
    delay(3);
    }
}

void resto_carcase()
{
int i,j;
char *v;

v=virtual;
v+=464+384*640;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        putpixel(i+464,j+384,*v++);
    v+=608;
    }
v=virtual;
v+=144+384*640;
for(j=0;j<32;j++)
    {
    for(i=0;i<32;i++)
        putpixel(i+144,j+384,*v++);
    v+=608;
    }
}

void select_a_car(char *voi1,char *voi2)
{
char name_gril[15][13];
struct find_t filefind;
int nb=0,i,selec1=0,selec2=0;
struct bagnole p1,p2;
char ang1=0,ang2=0,key=0,fini1=0,fini2=0;

p1.actif=1;
p2.actif=1;

_dos_findfirst("*.car",_A_NORMAL,&filefind);
do
    {
    strcopy(filefind.name,name_gril[nb++]);
    }
while(_dos_findnext(&filefind)==0 && nb<15);
_dos_findclose(&filefind);

select("scar.pre");
changefont("font1.fnt");

while(fini2==0 || fini1==0)
{
for(i=0;i<nb;i++)
    {
    if(i==selec2)
        if(fini2)
            outtextxy(112,80+i*16,name_gril[i],15,-1);
            else
            outtextxy(112,80+i*16,name_gril[i],13,-1);
        else
        outtextxy(112,80+i*16,name_gril[i],14,-1);
    if(i==selec1)
        if(fini1)
            outtextxy(432,80+i*16,name_gril[i],15,-1);
            else
            outtextxy(432,80+i*16,name_gril[i],13,-1);
        else
        outtextxy(432,80+i*16,name_gril[i],14,-1);
    }
initplayer(&p1,name_gril[selec1],0);
race_player(&p1,464,384,ang1);
clearsprite(&p1,255);
rotate(&p1,0x10000);
capture_back(&p1);
affichesprite(&p1);
capture_fore(&p1);
affiche_voiture(&p1);

initplayer(&p2,name_gril[selec2],1);
race_player(&p2,144,384,ang2);
clearsprite(&p2,255);
rotate(&p2,0x10000);
capture_back(&p2);
affichesprite(&p2);
capture_fore(&p2);
affiche_voiture(&p2);

while(!kbhit())
    {
    clearsprite(&p1,255);
    rotate(&p1,0x10000);
    restore_back(&p1);
    capture_back(&p1);
    affichesprite(&p1);
    capture_fore(&p1);
    affiche_voiture(&p1);
    ang1++;
    ang1&=255;
    p1.angle=ang1;

    clearsprite(&p2,255);
    rotate(&p2,0x10000);
    restore_back(&p2);
    capture_back(&p2);
    affichesprite(&p2);
    capture_fore(&p2);
    affiche_voiture(&p2);
    ang2++;
    ang2&=255;
    p2.angle=ang2;
    delay(5);
    }

restore_back(&p1);
closeplayer(&p1);

restore_back(&p2);
closeplayer(&p2);

key=getch();
if(key==0)
    {
    key=getch();
    if(fini1==0 && key==80 && selec1<(nb-1)) selec1++;
    if(fini1==0 && key==72 && selec1>0) selec1--;
    if(key==75) { resto_carcase();selec1=nb+1;p1.actif=0;fini1=1; }
    if(key==77) { resto_carcase();selec1=0;p1.actif=1;fini1=0; }
    }
    else
    {
    if(key==13) fini1=1;
    if(fini2==0 && (key=='s' || key=='S') && selec2<(nb-1)) selec2++;
    if(fini2==0 && (key=='z' || key=='Z') && selec2>0) selec2--;
    if(key=='q' || key=='Q') { resto_carcase();selec2=nb+1;p2.actif=0;fini2=1; }
    if(key=='d' || key=='D') { resto_carcase();selec2=0;p2.actif=1;fini2=0; }
    if(key==' ') fini2=1;
    }
}
if(p1.actif)
        strcopy(name_gril[selec1],voi1);
        else
        voi1[0]='|';
if(p2.actif)
        strcopy(name_gril[selec2],voi2);
        else
        voi2[0]='|';
fade_out();
clrgraph(0);
}

void resto_namecase()
{
int i,j;
char *v;

v=virtual;
v+=240+40*640;
for(j=0;j<40;j++)
    {
    for(i=0;i<160;i++)
        putpixel(240+i,40+j,*v++);
    v+=480;
    }
}

void load_preview(char *n)
{
FILE *f;
char *buf,*b,pal[384];
int i,j;

b=(char *)malloc(307200);
buf=b;
charge_depart(n,buf,640,480);
f=fopen(n,"rb");
fseek(f,filesize(f)-768,SEEK_SET);
fread(pal,1,384,f);
fclose(f);
for(i=0;i<128;i++)
    setpal(i+128,pal[i*3]>>2,pal[i*3+1]>>2,pal[i*3+2]>>2);

for(j=0;j<96;j++)
    {
    for(i=0;i<128;i++)
        {
        putpixel(56+i,332+j,128 + *buf);
        buf+=5;
        }
    buf+=2560;
    }
free(b);
}

void select_a_race(char *n)
{
char name_gril[15][13];
struct find_t filefind;
int nb=0,i,selec=0;
char key=0,*buf;
struct RACE preview;

_dos_findfirst("*.rce",_A_NORMAL,&filefind);
do
    {
    strcopy(filefind.name,name_gril[nb++]);
    }
while(_dos_findnext(&filefind)==0 && nb<15);
_dos_findclose(&filefind);

select("strack.pre");
changefont("font1.fnt");

while(key!=13)
    {
    for(i=0;i<nb;i++)
        if(i==selec)
            outtextxy(72,40+selec*16,name_gril[i],13,-1);
            else
            outtextxy(72,40+i*16,name_gril[i],14,-1);
    lire_course(name_gril[selec],&preview);
    resto_namecase();
    outtextxy(240,50,preview.racename,14,-1);
    load_preview(preview.pixname);
    key=getch();
    if(key==0)
        {
        key=getch();
        if(key==80 && selec<(nb-1)) selec++;
        if(key==72 && selec>0 ) selec--;
        }
    }
strcopy(name_gril[selec],n);
fade_out();
clrgraph(0);
}






main(int argcount,char *argstr[])
{
char pixbagn[2][13];
char trackname[13];

virtual=(char *)malloc(307200);
graphmode();
InitSinTable();

select_a_car(pixbagn[0],pixbagn[1]);

select_a_race(trackname);

if(pixbagn[0][0]=='|') p[0].actif=0; else p[0].actif=1;
if(pixbagn[1][0]=='|') p[1].actif=0; else p[1].actif=1;

initplayer(&p[0],pixbagn[0],0);
initplayer(&p[1],pixbagn[1],1);

//**************************************************************************

course(&p[0],&p[1],trackname);

//***************************************************************************

closeplayer(&p[1]);
closeplayer(&p[0]);

textmode();

free(virtual);

printf("\n  Nom du JEU  par Ney'Boor (TFP)  et  N PEARSON   v0.3  0\n\n");
}
