'
'                       T H E   A D V E N T U R E S
'                               Version 1.1
'
'
'
'       Programming :  AM
'       Graphics    :  TM
'       Ideas       :  BM
'       For         :  TMB Production
'       Library     :  DirectQB 16.11
'
' Visit TMB Productions at : www.crosswinds.net/~tmb
'
' Please do NOT modify this source.
' It is published for learning - not stealing!
'
DEFINT A-Z                                      ' Speed incresement

'$INCLUDE: 'THEADVEN.BI'                        ' Include misc. stuff.

TIMER ON
ON ERROR GOTO ErrorHandling                     ' Shut down with style.
ON TIMER(1) GOSUB FramesPrSecond

DIM SHARED buffer(500)

HandyIconSize = DQBsize(251, 91, 262, 101)
BallIconSize = DQBsize(251, 103, 269, 112)
REDIM SHARED HandyIcon(HandyIconSize \ 2)
REDIM SHARED BallIcon(BallIconSize \ 2)

EpisodePicSize = DQBsize(0, 0, 159, 99)
REDIM SHARED EpisodePic(EpisodePicSize \ 2)




InstallProgram                                  ' Setup program

DQBinitVGA                                      ' Screen 13

DQBinstallKeyboard                              ' Install keyboardhandler

IF ShowIntro = TRUE THEN Intro                  ' Intro

LoadGraphics                                    ' Normal graphics

Players = 1                                     ' Numper of players


DQBsetFrameRate 500


'               ----------------------------------
'               Default episode = 1
Episode = 1

LoadEpisode                                     ' Load background & Sprites

REDIM SHARED Sprite1Spr((Sprite1Size \ 2) * 8)  ' 8 images of Handyman
REDIM SHARED Sprite2Spr((Sprite2Size \ 2) * 8)  ' 8 images of The little Ball
REDIM SHARED Sprite3Spr(Sprite3Size \ 2)        ' Springy 1
REDIM SHARED Sprite4Spr(Sprite4Size \ 2)        ' Springy 2
REDIM SHARED Sprite5Spr((Sprite5Size \ 2) * 2)  ' Enemy 1
REDIM SHARED Sprite6Spr((Sprite6Size \ 2) * 4)  ' Enemy 2
REDIM SHARED Sprite7Spr(Sprite7Size \ 2)        ' Strawberry
REDIM SHARED Sprite8Spr(Sprite8Size \ 2)        ' Moving Sprite 1 - Hoz.
REDIM SHARED Sprite9Spr(Sprite9Size \ 2)        ' Moving Sprite 2 - Hoz.
REDIM SHARED Sprite10Spr(Sprite10Size \ 2)       ' Moving Sprite 3 - Vec.
REDIM SHARED Sprite11Spr(Sprite11Size \ 2)       ' End the level
REDIM SHARED Sprite12Spr(Sprite12Size \ 2)       ' The cros (x)
REDIM SHARED Sprite13Spr(Sprite13Size \ 2)
REDIM SHARED Sprite14Spr(Sprite14Size \ 2)
REDIM SHARED Sprite15Spr(Sprite15Size \ 2)
REDIM SHARED Sprite16Spr(Sprite16Size \ 2)
REDIM SHARED Sprite17Spr(Sprite17Size \ 2)
REDIM SHARED Sprite18Spr(Sprite18Size \ 2)
REDIM SHARED Sprite19Spr(Sprite19Size \ 2)
REDIM SHARED Sprite20Spr(Sprite20Size \ 2)

LoadEpisodeGraphics




MenuLoop:
Menu                                            ' Menu

SetValues


LoadEpisodeLoop:
IF UserLevel = FALSE AND NOT MenuLoad = TRUE THEN SelectEpisodeToPlay

StartValues

ValuesForALevel

IF GotoMenu = TRUE THEN GotoMenu = FALSE: GOTO MenuLoop

HowManyPlayers

IF UserLevel = FALSE THEN DisplayMap

IF Sprite20(1).SizeX = 42 THEN Episode = 1
IF Sprite20(1).SizeX = 133 THEN Episode = 2

LoadEpisode                                     ' Load background & Sprites

REDIM SHARED Sprite1Spr((Sprite1Size \ 2) * 8)  ' 8 images of Handyman
REDIM SHARED Sprite2Spr((Sprite2Size \ 2) * 8)  ' 8 images of The little Ball
REDIM SHARED Sprite3Spr(Sprite3Size \ 2)        ' Springy 1
REDIM SHARED Sprite4Spr(Sprite4Size \ 2)        ' Springy 2
REDIM SHARED Sprite5Spr((Sprite5Size \ 2) * 2)  ' Enemy 1
REDIM SHARED Sprite6Spr((Sprite6Size \ 2) * 4)  ' Enemy 2
REDIM SHARED Sprite7Spr(Sprite7Size \ 2)        ' Strawberry
REDIM SHARED Sprite8Spr(Sprite8Size \ 2)        ' Moving Sprite 1 - Hoz.
REDIM SHARED Sprite9Spr(Sprite9Size \ 2)        ' Moving Sprite 2 - Hoz.
REDIM SHARED Sprite10Spr(Sprite10Size \ 2)       ' Moving Sprite 3 - Vec.
REDIM SHARED Sprite11Spr(Sprite11Size \ 2)       ' End the level
REDIM SHARED Sprite12Spr(Sprite12Size \ 2)       ' The cros (x)
REDIM SHARED Sprite13Spr(Sprite13Size \ 2)
REDIM SHARED Sprite14Spr(Sprite14Size \ 2)
REDIM SHARED Sprite15Spr(Sprite15Size \ 2)
REDIM SHARED Sprite16Spr(Sprite16Size \ 2)
REDIM SHARED Sprite17Spr(Sprite17Size \ 2)
REDIM SHARED Sprite18Spr(Sprite18Size \ 2)
REDIM SHARED Sprite19Spr(Sprite19Size \ 2)
REDIM SHARED Sprite20Spr(Sprite20Size \ 2)

LoadEpisodeGraphics



StartValues                                     ' Default values





MainLoop:
DQBplaySound 4, 1, 11050, ONCE

DO                                              ' Main Loop
  IF GotoMenu = TRUE THEN GotoMenu = FALSE: GOTO MenuLoop

  DQBcopyLayer 2, 1                             ' Copy Level1 bg to layer 1

  DrawBGLevel

IF Players = 2 THEN ControlBall                 ' Control the little Ball

ControlHandyMan                                 ' Control the Handyman

Enemy1Animation
Enemy2Animation

  DisplayPlayerInformation                      ' Display player information

  IF DQBkey(59) THEN Help                       ' F1 for Helpscreen

  IF DQBkey(60) THEN Screenshot                 ' F2 for ScreenShot
 
  IF DQBkey(61) AND UserLevel = FALSE THEN Save ' F3 for Save
 
  IF DQBkey(62) THEN DQBprint 1, "FPS:" + STR$(FPS), CENTERED, 1, 1

  IF DQBkey(63) AND WRT = TRUE THEN
  WRT = FALSE
  DO: LOOP UNTIL DQBkey(63) = FALSE
  END IF

  IF DQBkey(63) AND WRT = FALSE THEN
  WRT = TRUE
  DO: LOOP UNTIL DQBkey(63) = FALSE
  END IF


IF WRT = TRUE THEN DQBwait 1                    ' Update the videoscreen

IF WRT = FALSE THEN DO: LOOP UNTIL DQBframeReady

  DQBcopyLayer 1, VIDEO                         ' Copy layer 1 to Screen
 
  IF EndTheLevel = TRUE AND UserLevel = TRUE THEN GOTO MenuLoop
  IF EndTheLevel = TRUE AND UserLevel = FALSE THEN NextLevel

IF HandyLives = 0 THEN GameOver                         ' Game over
IF BallLives = 0 THEN GameOver                          ' Game over


Count = Count + 1
LOOP UNTIL DQBkey(1)                            ' Loop until ESC is pressed
EscKey                                          ' Release ESC
CLOSE
GOTO MenuLoop                                   ' Then the main loop




ErrorHandling:                                          ' An error ?
DQBinitText                                             ' Text mode
CLS
PRINT "An error was found while running The Adventures."
PRINT "We take bugs VERY seriously, so please report it"
PRINT "tmb@crosswinds.net"
PRINT
PRINT "Error:"; ERR
IF ERR = 9 THEN PRINT "Subscript out of range."
PRINT
DO: LOOP WHILE DQBkey(28) = FALSE
EndProgram


FramesPrSecond:
FPS = Count
Count = 0
RETURN

REM $DYNAMIC
SUB BallCheckLeft

BallLeft = FALSE
UpHillBall = FALSE

FOR Y = (BallY) TO (BallY + 18)
IF DQBpoint(1, ((BackGroundX + BallX) + 7), Y) = 250 THEN BallLeft = TRUE
IF Cheat = FALSE AND DQBpoint(1, ((BackGroundX + BallX) + 7), Y) > 252 THEN BallEnergy = BallEnergy - 1
IF DQBpoint(1, ((BackGroundX + BallX) + 7), Y) = 252 THEN EndTheLevel = TRUE
NEXT

IF DQBpoint(1, ((BackGroundX + BallX) + 7), BallY + 18) = 250 AND NOT DQBpoint(1, ((BackGroundX + BallX) + 7), BallY + 17) = 250 AND DQBkey(30) THEN
BallLeft = TRUE
BallJump = 1                                 ' The higest he can get
BJump = 1                                      ' Minimum
ShouldBallFly = FALSE
UpHillBall = TRUE
END IF



END SUB

SUB BallCheckRight

BallRight = FALSE

FOR Y = (BallY) TO (BallY + 18)
IF DQBpoint(1, ((BackGroundX + BallX) + 29), Y) = 250 THEN BallRight = TRUE
IF Cheat = FALSE AND DQBpoint(1, ((BackGroundX + BallX) + 29), Y) > 252 THEN BallEnergy = BallEnergy - 1
IF DQBpoint(1, ((BackGroundX + BallX) + 29), Y) = 252 THEN EndTheLevel = TRUE
NEXT

END SUB

SUB BallCheckUp

BallUp = FALSE

FOR X = ((BackGroundX + BallX) + 10) TO ((BackGroundX + BallX) + 25)
IF DQBpoint(1, X, (BallY - 1)) = 250 THEN BallUp = TRUE
NEXT

END SUB

SUB BallGravity

BallGround = FALSE
BallSpringy = FALSE
ShouldBallFly = FALSE

FOR X = ((BackGroundX + BallX) + 10) TO ((BackGroundX + BallX) + 25)
IF DQBpoint(1, X, (BallY + 19)) = 250 THEN BallGround = TRUE
IF DQBpoint(1, X, (BallY + 19)) = 251 THEN BallSpringy = TRUE
IF Cheat = FALSE AND DQBpoint(1, X, (BallY + 19)) = 254 THEN BallEnergy = BallEnergy - 1
NEXT

IF BallGround = TRUE THEN EXIT SUB
IF UpHillBall = FALSE THEN ShouldBallFly = TRUE
BallY = BallY + 1

END SUB

REM $STATIC
SUB CompletedEpisode

EnterKey

CLOSE


OPEN DatasPath$ + "Episodes.Sav" FOR RANDOM AS #1 LEN = LEN(EpisodesCompleted)
IF Episode = 1 THEN EpisodesCompleted.Episode1 = TRUE
IF Episode = 2 THEN EpisodesCompleted.Episode2 = TRUE
PUT #1, 1, EpisodesCompleted
CLOSE #1


OPEN DatasPath$ + "Episodes.Sav" FOR RANDOM AS #1 LEN = LEN(EpisodesCompleted)
GET #1, 1, EpisodesCompleted

DO

DQBcopyLayer 2, 1

  DQBfilterBox 1, 10, 50, 309, 190, 1, 1        ' Draw a filterbox
  DQBbox 1, 11, 155, 308, 189, 1

IF Episode = 1 THEN
DQBprints 1, "Episode 1 :  The Beach", CENTERED, 40, 1, ITALIC
DQBget 7, 0, 0, 159, 99, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))
IF EpisodesCompleted.Episode2 = TRUE THEN
DQBprint 1, "You have completed the game.", CENTERED, 160, 11
DQBprint 1, "The next episodes are soon avalible.", CENTERED, 170, 11
END IF
ELSE
DQBprint 1, "First episode completed.", CENTERED, 160, 11
DQBprint 1, "Now go to the jungle", CENTERED, 170, 11
END IF

IF Episode = 2 THEN
DQBprints 1, "Episode 2 :  The Jungle", CENTERED, 40, 1, ITALIC
DQBget 7, 160, 0, 319, 99, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))
IF EpisodesCompleted.Episode1 = TRUE THEN
DQBprint 1, "You have completed the game.", CENTERED, 160, 11
DQBprint 1, "The next episodes are soon avalible.", CENTERED, 170, 11
ELSE
DQBprint 1, "Second episode completed.", CENTERED, 160, 11
DQBprint 1, "Now go to the beach", CENTERED, 170, 11
END IF
END IF

DQBput 1, 81, 51, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))

DQBcopyLayer 1, VIDEO

DQBwait 1

LOOP UNTIL DQBkey(KEYENTER)
EnterKey

CLOSE


GotoMenu = TRUE




END SUB

REM $DYNAMIC
SUB ControlBall
' This sub controls the little ball.
' Just note that the collision detection with the enemies is placed in
' the subs Enemy1Animation and Enemy2Animation.

' Strawberry collision
FOR StrawNumber = 1 TO 15
IF DQBcollide(BallX, BallY, VARSEG(Sprite2Spr(0)), VARPTR(Sprite2Spr(0)), Sprite7(StrawNumber).X, Sprite7(StrawNumber).Y, VARSEG(Sprite7Spr(0)), VARPTR(Sprite7Spr(0))) = TRUE THEN
Sprite7(StrawNumber).X = -100                           ' Reset it
BallEnergy = BallEnergy + 50
END IF
NEXT


IF BallEnergy < 2 THEN BallLives = BallLives - 1: BallEnergy = 1009: ValuesForALevel

BallAnimation = STAND                           ' Default animation

BallGravity                                     ' Let him come down some times

BallCheckLeft                                   ' Check Left
BallCheckRight                                  ' Check Right

IF DQBkey(32) AND BallRight = FALSE THEN        ' Is Right-arrow(D) pressed?
BallX = BallX + 1                               ' Right
BallDirection = RIGHT                           ' Register in Direction
BWalk = BWalk + 1                               ' Animation
BallAnimation = WALK                            ' Animation to display
END IF
IF DQBkey(30) AND BallLeft = FALSE THEN         ' Is Left-arrow(A) pressed?
BallX = BallX - 1                               ' Move the little ball Left
BallDirection = LEFT
BWalk = BWalk + 1
BallAnimation = WALK
END IF
IF BWalk > 3 THEN BWalk = 0: BallWalk = BallWalk + 1
IF BallWalk > 3 THEN BallWalk = 0               ' Animation technique


IF BallY > 200 THEN
IF Cheat = FALSE THEN BallLives = BallLives - 1
  BallEnergy = 1009
  ValuesForALevel
END IF

IF BallSpringy = TRUE THEN                      ' Colour 251 = Springy
BallJump = 120                                  ' Max Y
BJump = 60                                      ' Min Y
IF UpHillBall = FALSE AND ShouldBallFly = FALSE THEN BallAnimation = JUMP
END IF


' Make the slide move.
IF DQBkey(31) AND BallGround = TRUE THEN BallAnimation = DUCK


' This section tests for a Jump call.

IF ShouldBallFly = TRUE THEN BallAnimation = FALL

  BallCheckUp                                   ' Check for colour 250 at Up
IF DQBkey(17) AND BallUp = FALSE AND NOT BallAnimation = DUCK THEN
IF BallGround = TRUE THEN BallJump = 55: BJump = 10: BallAnimation = JUMP
IF UpHillBall = FALSE AND BallGround = FALSE AND BJump = 0 AND BallJump > 0 THEN BallY = BallY - 2: BallAnimation = JUMP
END IF
 
IF BallJump > 0 THEN BallJump = BallJump - 1
IF DQBkey(17) = FALSE OR BallUp = TRUE OR BallAnimation = DUCK THEN BallJump = 0
IF BallUp = TRUE THEN BJump = 0
IF BJump > 0 AND BallUp = FALSE THEN
BJump = BJump - 1
BallY = BallY - 2
IF UpHillBall = FALSE AND ShouldBallFly = FALSE THEN BallAnimation = JUMP
END IF



IF BallDirection = LEFT THEN                   ' Animations for Left
IF BallAnimation = STAND THEN
DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 0))
END IF
IF BallAnimation = WALK THEN
IF BallWalk = 0 THEN DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 1))
IF BallWalk = 1 THEN DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 2))
IF BallWalk = 2 THEN DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 3))
IF BallWalk = 3 THEN DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 4))
END IF
IF BallAnimation = JUMP THEN
DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 6))
END IF
IF BallAnimation = FALL THEN
DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 5))
END IF
IF BallAnimation = DUCK THEN
DQBput 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 7))
END IF
END IF


IF BallDirection = RIGHT THEN                  ' Animations for Right
IF BallAnimation = STAND THEN
DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 0)), 1
END IF
IF BallAnimation = WALK THEN
IF BallWalk = 0 THEN DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 1)), 1
IF BallWalk = 1 THEN DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 2)), 1
IF BallWalk = 2 THEN DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 3)), 1
IF BallWalk = 3 THEN DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 4)), 1
END IF
IF BallAnimation = JUMP THEN
DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 6)), 1
END IF
IF BallAnimation = FALL THEN
DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 5)), 1
END IF
IF BallAnimation = DUCK THEN
DQBmPut 1, (BackGroundX + BallX), BallY, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 7)), 1
END IF
END IF


END SUB

REM $STATIC
SUB ControlHandyMan
' This sub controls the handyman.
' Just note that the collision detection with the enemies is placed in
' the subs Enemy1Animation and Enemy2Animation.

' Strawberry collision
FOR StrawNumber = 1 TO 15
IF DQBcollide(HandyX, HandyY, VARSEG(Sprite1Spr(0)), VARPTR(Sprite1Spr(0)), (Sprite7(StrawNumber).X + BackGroundX), Sprite7(StrawNumber).Y, VARSEG(Sprite7Spr(0)), VARPTR(Sprite7Spr(0))) = TRUE THEN
Sprite7(StrawNumber).X = -100                           ' Reset it
HandyEnergy = HandyEnergy + 50
END IF
NEXT


IF HandyEnergy < 2 THEN HandyLives = HandyLives - 1: HandyEnergy = 1009: ValuesForALevel

HandyAnimation = STAND                          ' Default animation

  HandyGravity                                  ' Control Gravity

  HandyCheckRight                               ' Check for colour 250 at R
  HandyCheckLeft                                ' Check for colour 250 at L

IF DQBjoyDetected(JOY1) THEN DQBpollJoy JOY1

IF (DQBkey(77) OR DQBjoyMove(JOY1, RIGHT)) AND NOT (DQBkey(75) OR DQBjoyMove(JOY1, LEFT)) AND HandyRight = FALSE THEN
IF HandyX = 160 THEN
BackGroundX = BackGroundX - 1
BGScrollR1 = BGScrollR1 + 1
END IF
IF BGScrollR1 = 3 THEN
  BGScrollR1 = 0
  DQBget 2, 0, 0, 1, 199, VARSEG(buffer(0)), VARPTR(buffer(0))
  DQBscroll 2, -1, 0
  DQBput 2, 318, 0, VARSEG(buffer(0)), VARPTR(buffer(0))
END IF
IF HandyX < 160 THEN HandyX = HandyX + 1
HandyDirection = RIGHT
HWalk = HWalk + 1
HandyAnimation = WALK
END IF
IF (DQBkey(75) OR DQBjoyMove(JOY1, LEFT)) AND NOT (DQBkey(77) OR DQBjoyMove(JOY1, RIGHT)) AND HandyLeft = FALSE THEN
IF HandyX = 100 THEN
BackGroundX = BackGroundX + 1
BGScrollL1 = BGScrollL1 + 1
END IF
IF BGScrollL1 = 3 THEN
  BGScrollL1 = 0
  DQBget 2, 318, 0, 319, 199, VARSEG(buffer(0)), VARPTR(buffer(0))
  DQBscroll 2, 1, 0
  DQBput 2, 0, 0, VARSEG(buffer(0)), VARPTR(buffer(0))
END IF
IF HandyX > 100 THEN HandyX = HandyX - 1
HandyDirection = LEFT
HWalk = HWalk + 1
HandyAnimation = WALK
END IF

IF HWalk > 3 THEN HWalk = 0: HandyWalk = HandyWalk + 1  ' A part of the
IF HandyWalk > 3 THEN HandyWalk = 0                     ' animation tecnique.


  IF HandyY > 175 THEN
  IF Cheat = FALSE THEN HandyLives = HandyLives - 1
  HandyEnergy = 1009
  ValuesForALevel
  END IF


IF HandySpringy = TRUE THEN                     ' Colour 251 = Springy
HandyJump = 120                                 ' The higest he can get
HJump = 60                                      ' Minimum
IF UpHill = FALSE AND ShouldHandyFly = FALSE THEN HandyAnimation = JUMP
END IF

  IF (DQBkey(80) OR DQBjoyMove(JOY1, DOWN)) AND HandyGround = TRUE THEN HandyAnimation = DUCK

IF ShouldHandyFly = TRUE THEN HandyAnimation = FALL

  HandyCheckUp                                  ' Check for colour 250 at Up
IF (DQBkey(57) OR DQBjoyFire(JOY1, BUTA)) AND HandyUp = FALSE AND NOT HandyAnimation = DUCK THEN
IF HandyGround = TRUE THEN HandyJump = 55: HJump = 10: HandyAnimation = JUMP
IF UpHill = FALSE AND HandyGround = FALSE AND HJump = 0 AND HandyJump > 0 THEN HandyY = HandyY - 2: HandyAnimation = JUMP
IF HJump = 10 THEN DQBplaySound 1, 1, 11050, ONCE
END IF


IF HandyJump > 0 THEN HandyJump = HandyJump - 1
IF (DQBkey(57) = FALSE AND DQBjoyFire(JOY1, BUTA) = FALSE) OR HandyUp = TRUE OR HandyAnimation = DUCK THEN HandyJump = 0
IF HandyUp = TRUE THEN HJump = 0
IF HJump > 0 AND HandyUp = FALSE THEN
HJump = HJump - 1
HandyY = HandyY - 2
IF UpHill = FALSE AND ShouldHandyFly = FALSE THEN HandyAnimation = JUMP
END IF

IF DQBpoint(1, HandyX + 14, (HandyY + 35)) = 250 AND HandyAnimation = FALL THEN DQBplaySound 2, 1, 11050, ONCE



IF HandyDirection = LEFT THEN                   ' Animations for Left
IF HandyAnimation = STAND THEN
DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 0))
END IF
IF HandyAnimation = WALK THEN
IF HandyWalk = 0 THEN DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 1))
IF HandyWalk = 1 THEN DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 2))
IF HandyWalk = 2 THEN DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 3))
IF HandyWalk = 3 THEN DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 4))
END IF
IF HandyAnimation = JUMP THEN
DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 6))
END IF
IF HandyAnimation = FALL THEN
DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 5))
END IF
IF HandyAnimation = DUCK THEN
DQBput 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 7))
END IF
END IF


IF HandyDirection = RIGHT THEN                  ' Animations for Right
IF HandyAnimation = STAND THEN
DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 0)), 1
END IF
IF HandyAnimation = WALK THEN
IF HandyWalk = 0 THEN DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 1)), 1
IF HandyWalk = 1 THEN DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 2)), 1
IF HandyWalk = 2 THEN DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 3)), 1
IF HandyWalk = 3 THEN DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 4)), 1
END IF
IF HandyAnimation = JUMP THEN
DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 6)), 1
END IF
IF HandyAnimation = FALL THEN
DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 5)), 1
END IF
IF HandyAnimation = DUCK THEN
DQBmPut 1, HandyX, HandyY, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 7)), 1
END IF
END IF


END SUB

SUB Credits

DQBsetClipBox 75, 50, 233, 124                          ' Set a clipbox

TextY = 130                                             ' Start pos. for text


DO                                                      ' The loop

DQBcopyLayer 6, 1                                       ' Copy the menu to 1

DQBprint 1, "TMB", CENTERED, TextY, 0                   ' Credits text shaddow
DQBprint 1, "Lead programmer", CENTERED, TextY + 40, 0
DQBprint 1, "AM", CENTERED, TextY + 50, 0
DQBprint 1, "Graphics", CENTERED, TextY + 90, 0
DQBprint 1, "TM", CENTERED, TextY + 100, 0
DQBprint 1, "Ideas", CENTERED, TextY + 140, 0
DQBprint 1, "BM", CENTERED, TextY + 150, 0
DQBprint 1, "DirectQB", CENTERED, TextY + 200, 0
DQBprint 1, "Enhanced Creations", CENTERED, TextY + 210, 0

DQBprint 1, "TMB", CENTERED, TextY + 1, 1               ' Credits text
DQBprint 1, "Lead programmer", CENTERED, TextY + 41, 1
DQBprint 1, "AM", CENTERED, TextY + 51, 1
DQBprint 1, "Graphics", CENTERED, TextY + 91, 1
DQBprint 1, "TM", CENTERED, TextY + 101, 1
DQBprint 1, "Ideas", CENTERED, TextY + 141, 1
DQBprint 1, "BM", CENTERED, TextY + 151, 1
DQBprint 1, "DirectQB", CENTERED, TextY + 201, 11
DQBprint 1, "Enhanced Creations", CENTERED, TextY + 211, 11

TextY = TextY - 1                                       ' Move it 1 pixel

DQBwait 2                                               ' Speed

DQBcopyLayer 1, VIDEO                                   ' Show it on screen

LOOP UNTIL TextY < -200 OR DQBkey(KEYESC)               ' Finish

DQBsetClipBox 0, 0, 319, 199                            ' Normal clipbox

EscKey                                                  ' Release Esc


END SUB

SUB DisplayMap


OPEN DatasPath$ + "Episodes.Sav" FOR RANDOM AS #1 LEN = LEN(EpisodesCompleted)
GET #1, 1, EpisodesCompleted

  DO
  DQBcopyLayer 5, 1                             ' Copy map to layer 4
 
  DisplayPlayerInformation                      ' Display player information

IF Episode = 1 OR EpisodesCompleted.Episode1 = TRUE THEN
IF Level > 1 THEN DQBput 1, 296, 169, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 2 THEN DQBput 1, 251, 162, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 3 THEN DQBput 1, 202, 165, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 4 THEN DQBput 1, 144, 166, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 5 THEN DQBput 1, 88, 168, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 6 THEN DQBput 1, 27, 149, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
END IF

IF Episode = 2 OR EpisodesCompleted.Episode2 = TRUE THEN
IF Level > 7 OR EpisodesCompleted.Episode1 = TRUE THEN DQBput 1, 39, 129, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 8 OR EpisodesCompleted.Episode1 = TRUE THEN DQBput 1, 65, 131, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 9 OR EpisodesCompleted.Episode1 = TRUE THEN DQBput 1, 93, 139, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 10 OR EpisodesCompleted.Episode1 = TRUE THEN DQBput 1, 142, 130, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 11 OR EpisodesCompleted.Episode1 = TRUE THEN DQBput 1, 182, 124, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
IF Level > 12 OR EpisodesCompleted.Episode1 = TRUE THEN DQBput 1, 218, 120, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
END IF


TextTime = TextTime + 1                         ' Blinking text
IF TextTime > 25 THEN
DQBprints 1, "Press enter", CENTERED, 186, 0, ITALIC
DQBprints 1, "Press enter", CENTERED, 185, 1, ITALIC
END IF
IF TextTime > 50 THEN TextTime = 0

  DQBwait 1                                     ' Update the videoscreen

  DQBcopyLayer 1, VIDEO                         ' Copy layer 1 to Screen

LOOP UNTIL DQBkey(KEYENTER)

CLOSE


END SUB

SUB DisplayPlayerInformation


 ' Display Energi
  DQBfilterBox 1, 260, 5, 317, 35, 1, 1           ' Draw a filterbox

  DQBput 1, 265, 10, VARSEG(HandyIcon(0)), VARPTR(HandyIcon(0))

  DQBprint 1, STR$(HandyLives), 280, 12, 31     ' Print the lives

  DQBprint 1, STR$(INT(HandyEnergy / 10)), 272, 22, 31 ' Print the energy

IF Players = 1 THEN EXIT SUB                    ' 2 Player mode ?

  DQBfilterBox 1, 2, 5, 59, 35, 1, 1              ' Draw a filterbox

  DQBput 1, 5, 10, VARSEG(BallIcon(0)), VARPTR(BallIcon(0))

  DQBprint 1, STR$(BallLives), 25, 12, 31       ' Print the lives

  DQBprint 1, STR$(INT(BallEnergy / 10)), 18, 22, 31

END SUB

SUB DrawBGLevel


'                        ----------------------------
'                         The drawing of the sprites
'                        ----------------------------

FOR T% = 1 TO 15

' Sprite 1 = Handyman
' Sprite 2 = Ball

IF Sprite3(T%).Y <> -200 THEN                           ' Springy 1
IF BackGroundX% > -(Sprite3(T%).X + Sprite3(T%).SizeX) AND BackGroundX% < -(Sprite3(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite3(T%).X), Sprite3(T%).Y, VARSEG(Sprite3Spr(0)), VARPTR(Sprite3Spr(0))
END IF
END IF

IF Sprite4(T%).Y <> -200 THEN                           ' Springy 2
IF BackGroundX% > -(Sprite4(T%).X + Sprite4(T%).SizeX) AND BackGroundX% < -(Sprite4(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite4(T%).X), Sprite4(T%).Y, VARSEG(Sprite4Spr(0)), VARPTR(Sprite4Spr(0))
END IF
END IF

' Sprite 5 & 6 are enemies, they have their own subs.

IF Sprite7(T%).Y <> -200 THEN                           ' Strawberry
IF BackGroundX% > -(Sprite7(T%).X + Sprite7(T%).SizeX) AND BackGroundX% < -(Sprite7(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite7(T%).X), Sprite7(T%).Y, VARSEG(Sprite7Spr(0)), VARPTR(Sprite7Spr(0))
END IF
END IF

IF Sprite8(T%).Y <> -200 THEN                        ' Moving Hoz 1
DQBput 1, (BackGroundX% + Sprite8(T%).X), Sprite8(T%).Y, VARSEG(Sprite8Spr(0)), VARPTR(Sprite8Spr(0))
IF Sprite8(T%).Direction = RIGHT THEN Sprite8(T%).X = Sprite8(T%).X + 1
IF Sprite8(T%).Direction = LEFT THEN Sprite8(T%).X = Sprite8(T%).X - 1
IF Sprite8(T%).X < Sprite8(T%).MinX THEN Sprite8(T%).Direction = RIGHT
IF Sprite8(T%).X > Sprite8(T%).MaxX THEN Sprite8(T%).Direction = LEFT
END IF

IF Sprite9(T%).Y <> -200 THEN                       ' Moving Hoz 2
IF Episode = 1 THEN DQBput 1, (BackGroundX% + Sprite9(T%).X), Sprite9(T%).Y, VARSEG(Sprite9Spr(0)), VARPTR(Sprite9Spr(0))
IF Episode = 2 THEN DQBbput 1, (BackGroundX% + Sprite9(T%).X), Sprite9(T%).Y, VARSEG(Sprite9Spr(0)), VARPTR(Sprite9Spr(0)), 1
IF Sprite9(T%).Direction = RIGHT THEN Sprite9(T%).X = Sprite9(T%).X + 1
IF Sprite9(T%).Direction = LEFT THEN Sprite9(T%).X = Sprite9(T%).X - 1
IF Sprite9(T%).X < Sprite9(T%).MinX THEN Sprite9(T%).Direction = RIGHT
IF Sprite9(T%).X > Sprite9(T%).MaxX THEN Sprite9(T%).Direction = LEFT
END IF

IF Sprite10(T%).Y <> -200 THEN                        ' Moving Vec 3
DQBput 1, (BackGroundX% + Sprite10(T%).X), Sprite10(T%).Y, VARSEG(Sprite10Spr(0)), VARPTR(Sprite10Spr(0))
IF Sprite10(T%).Direction = DOWN THEN Sprite10(T%).Y = Sprite10(T%).Y + 1
IF Sprite10(T%).Direction = UP THEN Sprite10(T%).Y = Sprite10(T%).Y - 1
IF Sprite10(T%).Y < Sprite10(T%).MinY THEN Sprite10(T%).Direction = DOWN
IF Sprite10(T%).Y > Sprite10(T%).MaxY THEN Sprite10(T%).Direction = UP
END IF


IF Sprite11(T%).Y <> -200 THEN                          ' End the level
IF BackGroundX% > -(Sprite11(T%).X + Sprite11(T%).SizeX) AND BackGroundX% < -(Sprite11(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite11(T%).X), Sprite11(T%).Y, VARSEG(Sprite11Spr(0)), VARPTR(Sprite11Spr(0))
END IF
END IF

IF Sprite13(T%).Y <> -200 THEN                          ' Sprite 13
IF BackGroundX% > -(Sprite13(T%).X + Sprite13(T%).SizeX) AND BackGroundX% < -(Sprite13(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite13(T%).X), Sprite13(T%).Y, VARSEG(Sprite13Spr(0)), VARPTR(Sprite13Spr(0))
END IF
END IF


IF Sprite14(T%).Y <> -200 THEN                          ' Sprite 14
IF BackGroundX% > -(Sprite14(T%).X + Sprite14(T%).SizeX) AND BackGroundX% < -(Sprite14(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite14(T%).X), Sprite14(T%).Y, VARSEG(Sprite14Spr(0)), VARPTR(Sprite14Spr(0))
END IF
END IF

IF Sprite15(T%).Y <> -200 THEN                          ' Sprite 15
IF BackGroundX% > -(Sprite15(T%).X + Sprite15(T%).SizeX) AND BackGroundX% < -(Sprite15(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite15(T%).X), Sprite15(T%).Y, VARSEG(Sprite15Spr(0)), VARPTR(Sprite15Spr(0))
END IF
END IF

IF Sprite16(T%).Y <> -200 THEN                          ' Sprite 16
IF BackGroundX% > -(Sprite16(T%).X + Sprite16(T%).SizeX) AND BackGroundX% < -(Sprite16(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite16(T%).X), Sprite16(T%).Y, VARSEG(Sprite16Spr(0)), VARPTR(Sprite16Spr(0))
END IF
END IF

IF Sprite17(T%).Y <> -200 THEN                          ' Sprite 17
IF BackGroundX% > -(Sprite17(T%).X + Sprite17(T%).SizeX) AND BackGroundX% < -(Sprite17(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite17(T%).X), Sprite17(T%).Y, VARSEG(Sprite17Spr(0)), VARPTR(Sprite17Spr(0))
END IF
END IF

IF Sprite18(T%).Y <> -200 THEN                          ' Sprite 18
IF BackGroundX% > -(Sprite18(T%).X + Sprite18(T%).SizeX) AND BackGroundX% < -(Sprite18(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite18(T%).X), Sprite18(T%).Y, VARSEG(Sprite18Spr(0)), VARPTR(Sprite18Spr(0))
END IF
END IF

IF Sprite19(T%).Y <> -200 THEN                          ' Sprite 19
IF BackGroundX% > -(Sprite19(T%).X + Sprite19(T%).SizeX) AND BackGroundX% < -(Sprite19(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite19(T%).X), Sprite19(T%).Y, VARSEG(Sprite19Spr(0)), VARPTR(Sprite19Spr(0))
END IF
END IF

IF Sprite20(T%).Y <> -200 THEN                          ' Sprite 20
IF BackGroundX% > -(Sprite20(T%).X + Sprite20(T%).SizeX) AND BackGroundX% < -(Sprite20(T%).X) + 320 THEN
DQBput 1, (BackGroundX% + Sprite20(T%).X), Sprite20(T%).Y, VARSEG(Sprite20Spr(0)), VARPTR(Sprite20Spr(0))
END IF
END IF



NEXT





END SUB

REM $DYNAMIC
SUB EndProgram



CLS                                                     ' Clear screen
DQBinitText                                             ' Text mode
WIDTH 80, 25
COLOR 14, 1
Text$ = "The Adventures ver. 1.1 - Shut down"
LOCATE 1, 1: PRINT SPACE$(80): LOCATE 1, 40 - (LEN(Text$) / 2): PRINT Text$
COLOR 7, 0
PRINT "Wait a moment.."
PRINT "Realese DirectQB...";                            ' Information text
DQBclose                                                ' Quit DQB
PRINT "ok."                                             ' Okay

PRINT "Realese conventional memory...";                 ' Release conven.
dummy& = SETMEM(66000)                                  ' release it
PRINT "ok."                                             ' Okay

Text$ = "Please read THEADVEN.DOC for copyright information"
LOCATE 15, 40 - (LEN(Text$) / 2): PRINT Text$

LOCATE 24, 1

SYSTEM                                                  ' Give control to DOS



END SUB

REM $STATIC
SUB Enemy1Animation

FOR EnemyNumber = 1 TO 15

IF Enemy1(EnemyNumber).Y <> -200 THEN

' Check for X and Y collision with Handyman.
IF DQBcollide(HandyX, HandyY, VARSEG(Sprite1Spr(0)), VARPTR(Sprite1Spr(0)), (Enemy1(EnemyNumber).X + BackGroundX), Enemy1(EnemyNumber).Y, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0))) = TRUE THEN
IF HandyEnergy > 250 AND HandyAnimation = DUCK THEN Enemy1(EnemyNumber).Finish = TRUE
IF Cheat = FALSE THEN HandyEnergy = HandyEnergy - 25: DQBplaySound 3, 1, 11050, ONCE
END IF
' Test for collision with Crap the little Ball.
IF DQBcollide(BallX, BallY, VARSEG(Sprite2Spr(0)), VARPTR(Sprite2Spr(0)), Enemy1(EnemyNumber).X, Enemy1(EnemyNumber).Y, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0))) = TRUE THEN
IF BallEnergy > 250 AND BallAnimation = DUCK THEN Enemy1(EnemyNumber).Finish = TRUE
IF Cheat = FALSE THEN BallEnergy = BallEnergy - 25
END IF


IF Enemy1(EnemyNumber).Finish = TRUE AND Enemy1(EnemyNumber).Y < 200 THEN Enemy1(EnemyNumber).Y = Enemy1(EnemyNumber).Y + 3

Enemy1(EnemyNumber).F = Enemy1(EnemyNumber).F + 1        ' Animation speed

IF Enemy1(EnemyNumber).F > 3 THEN                        ' The enemys speed
IF Enemy1(EnemyNumber).Direction = LEFT THEN Enemy1(EnemyNumber).X = Enemy1(EnemyNumber).X - 1
IF Enemy1(EnemyNumber).Direction = RIGHT THEN Enemy1(EnemyNumber).X = Enemy1(EnemyNumber).X + 1
END IF

IF Enemy1(EnemyNumber).F = 5 THEN Enemy1(EnemyNumber).Frame = Enemy1(EnemyNumber).Frame + 1: Enemy1(EnemyNumber).F = 0
IF Enemy1(EnemyNumber).Frame = 3 THEN Enemy1(EnemyNumber).Frame = 1

IF Enemy1(EnemyNumber).X > Enemy1(EnemyNumber).MaxX THEN Enemy1(EnemyNumber).Direction = LEFT
IF Enemy1(EnemyNumber).X < Enemy1(EnemyNumber).MinX THEN Enemy1(EnemyNumber).Direction = RIGHT

IF Enemy1(EnemyNumber).Direction = RIGHT THEN
IF Enemy1(EnemyNumber).Frame = 1 THEN DQBput 1, (BackGroundX + Enemy1(EnemyNumber).X), Enemy1(EnemyNumber).Y, VARSEG(Sprite5Spr(0)), (VARPTR(Sprite5Spr(0)) + (Sprite5Size * 0))
IF Enemy1(EnemyNumber).Frame = 2 THEN DQBput 1, (BackGroundX + Enemy1(EnemyNumber).X), Enemy1(EnemyNumber).Y, VARSEG(Sprite5Spr(0)), (VARPTR(Sprite5Spr(0)) + (Sprite5Size * 1))
END IF

IF Enemy1(EnemyNumber).Direction = LEFT THEN
IF Enemy1(EnemyNumber).Frame = 1 THEN DQBmPut 1, (BackGroundX + Enemy1(EnemyNumber).X), Enemy1(EnemyNumber).Y, VARSEG(Sprite5Spr(0)), (VARPTR(Sprite5Spr(0)) + (Sprite5Size * 0)), 1
IF Enemy1(EnemyNumber).Frame = 2 THEN DQBmPut 1, (BackGroundX + Enemy1(EnemyNumber).X), Enemy1(EnemyNumber).Y, VARSEG(Sprite5Spr(0)), (VARPTR(Sprite5Spr(0)) + (Sprite5Size * 1)), 1
END IF

END IF



NEXT


END SUB

REM $DYNAMIC
SUB Enemy2Animation

FOR EnemyNumber = 1 TO 15

IF Enemy2(EnemyNumber).Y <> -200 THEN

' Check for X and Y collision with Handyman.
IF DQBcollide(HandyX, HandyY, VARSEG(Sprite1Spr(0)), VARPTR(Sprite1Spr(0)), (Enemy2(EnemyNumber).X + BackGroundX), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0))) = TRUE THEN
IF HandyEnergy > 250 AND HandyAnimation = DUCK THEN Enemy2(EnemyNumber).Finish = TRUE
IF Cheat = FALSE THEN HandyEnergy = HandyEnergy - 25: DQBplaySound 3, 1, 11050, ONCE
END IF

' Test for collision with the little Ball.
IF DQBcollide(BallX, BallY, VARSEG(Sprite2Spr(0)), VARPTR(Sprite2Spr(0)), Enemy2(EnemyNumber).X, Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0))) = TRUE THEN
IF BallEnergy > 250 AND BallAnimation = DUCK THEN Enemy2(EnemyNumber).Finish = TRUE
IF Cheat = FALSE THEN BallEnergy = BallEnergy - 25
END IF

IF Enemy2(EnemyNumber).Finish = TRUE AND Enemy2(EnemyNumber).Y < 200 THEN Enemy2(EnemyNumber).Y = Enemy2(EnemyNumber).Y + 3

Enemy2(EnemyNumber).F = Enemy2(EnemyNumber).F + 1        ' Animation speed

IF Enemy2(EnemyNumber).F > 3 THEN                        ' The enemys speed
IF Enemy2(EnemyNumber).Direction = LEFT THEN Enemy2(EnemyNumber).X = Enemy2(EnemyNumber).X - 1
IF Enemy2(EnemyNumber).Direction = RIGHT THEN Enemy2(EnemyNumber).X = Enemy2(EnemyNumber).X + 1
END IF

IF Enemy2(EnemyNumber).F = 5 THEN Enemy2(EnemyNumber).Frame = Enemy2(EnemyNumber).Frame + 1: Enemy2(EnemyNumber).F = 0
IF Enemy2(EnemyNumber).Frame = 5 THEN Enemy2(EnemyNumber).Frame = 1

IF Enemy2(EnemyNumber).X > Enemy2(EnemyNumber).MaxX THEN Enemy2(EnemyNumber).Direction = LEFT
IF Enemy2(EnemyNumber).X < Enemy2(EnemyNumber).MinX THEN Enemy2(EnemyNumber).Direction = RIGHT

IF Enemy2(EnemyNumber).Direction = RIGHT THEN
IF Enemy2(EnemyNumber).Frame = 1 THEN DQBput 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 0))
IF Enemy2(EnemyNumber).Frame = 2 THEN DQBput 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 1))
IF Enemy2(EnemyNumber).Frame = 3 THEN DQBput 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 2))
IF Enemy2(EnemyNumber).Frame = 4 THEN DQBput 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 3))
END IF

IF Enemy2(EnemyNumber).Direction = LEFT THEN
IF Enemy2(EnemyNumber).Frame = 1 THEN DQBmPut 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 0)), 1
IF Enemy2(EnemyNumber).Frame = 2 THEN DQBmPut 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 1)), 1
IF Enemy2(EnemyNumber).Frame = 3 THEN DQBmPut 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 2)), 1
IF Enemy2(EnemyNumber).Frame = 4 THEN DQBmPut 1, (BackGroundX + Enemy2(EnemyNumber).X), Enemy2(EnemyNumber).Y, VARSEG(Sprite6Spr(0)), (VARPTR(Sprite6Spr(0)) + (Sprite6Size * 3)), 1
END IF

END IF


NEXT



END SUB

REM $STATIC
SUB EnterKey

DO: LOOP UNTIL DQBkey(28) = FALSE


END SUB

SUB EscKey


DO: LOOP UNTIL DQBkey(1) = FALSE


END SUB

SUB GameOver


  DO
  DQBcopyLayer 8, 1                             ' Copy image to layer 1

  DisplayPlayerInformation                      ' Display player information

TextTime = TextTime + 1                         ' Blinking text
IF TextTime > 25 THEN
DQBprints 1, "Press enter", CENTERED, 186, 0, ITALIC
DQBprints 1, "Press enter", CENTERED, 185, 1, ITALIC
END IF
IF TextTime > 50 THEN TextTime = 0

  DQBwait 1                                     ' Update the videoscreen

  DQBcopyLayer 1, VIDEO                         ' Copy layer 1 to Screen

LOOP UNTIL DQBkey(KEYENTER)
EnterKey

GotoMenu = TRUE


END SUB

SUB HandyCheckLeft

HandyLeft = FALSE
UpHill = FALSE

FOR Y = (HandyY) TO (HandyY + 34)
IF DQBpoint(1, (HandyX + 6), Y) = 250 THEN HandyLeft = TRUE
IF Cheat = FALSE AND DQBpoint(1, (HandyX + 6), Y) > 252 THEN HandyEnergy = HandyEnergy - 1
IF DQBpoint(1, (HandyX + 6), Y) = 252 THEN EndTheLevel = TRUE
NEXT

IF DQBpoint(1, (HandyX + 6), HandyY + 34) = 250 AND NOT DQBpoint(1, (HandyX + 6), HandyY + 33) = 250 AND (DQBkey(75) OR DQBjoyMove(JOY1, LEFT)) THEN
HandyLeft = TRUE
HandyJump = 1                                 ' The higest he can get
HJump = 1                                      ' Minimum
ShouldHandyFly = FALSE
UpHill = TRUE
END IF


END SUB

SUB HandyCheckRight

HandyRight = FALSE

FOR Y = (HandyY) TO (HandyY + 34)
IF DQBpoint(1, (HandyX + 18), Y) = 250 THEN HandyRight = TRUE
IF Cheat = FALSE AND DQBpoint(1, (HandyX + 21), Y) > 252 THEN HandyEnergy = HandyEnergy - 1
IF DQBpoint(1, (HandyX + 21), Y) = 252 THEN EndTheLevel = TRUE
NEXT


END SUB

SUB HandyCheckUp

HandyUp = FALSE

FOR X = (HandyX + 8) TO (HandyX + 17)
IF DQBpoint(1, X, (HandyY)) = 250 THEN HandyUp = TRUE
NEXT



END SUB

SUB HandyGravity

HandyGround = FALSE
HandySpringy = FALSE
ShouldHandyFly = FALSE

FOR X = (HandyX + 8) TO (HandyX + 17)
IF DQBpoint(1, X, (HandyY + 35)) = 250 THEN HandyGround = TRUE
IF DQBpoint(1, X, (HandyY + 35)) = 251 THEN HandySpringy = TRUE
IF Cheat = FALSE AND DQBpoint(1, X, (HandyY + 35)) = 254 THEN HandyEnergy = HandyEnergy - 1
NEXT


IF HandyGround = TRUE THEN EXIT SUB
IF UpHill = FALSE THEN ShouldHandyFly = TRUE
HandyY = HandyY + 1


END SUB

SUB Help

 
  DQBcopyLayer VIDEO, 3                         ' Copy Screen to layer 3

DO
  DQBcopyLayer 3, 4                             ' Copy Screen to layer 3

  DQBfilterBox 4, 10, 10, 309, 180, 1, 1          ' Draw a filterbox

  DQBprints 4, "The Adventures - Help", 25, 15, 1, BOLD

  DQBprints 4, "ESC - Main screen", CENTERED, 30, 1, NORMAL

  DQBprints 4, "F1 - Help", CENTERED, 40, 1, NORMAL

  DQBprints 4, "F2 - take a screenshot", CENTERED, 50, 1, NORMAL
  DQBprints 4, "F3 - save", CENTERED, 60, 1, NORMAL
  DQBprints 4, "F4 - view FPS", CENTERED, 70, 1, NORMAL
  DQBprints 4, "F5 - toggle WRT", CENTERED, 80, 1, NORMAL

  DQBprints 4, "Keyboard controls", CENTERED, 100, 2, NORMAL
  DQBprints 4, "Player 1        Player 2", CENTERED, 110, 41, NORMAL
  DQBprints 4, "      Right            D", 20, 120, 1, NORMAL
  DQBprints 4, CHR$(17) + "      Left             A", 20, 130, 1, NORMAL
  DQBprints 4, "Jump   Space            W", 20, 140, 1, NORMAL
  DQBprints 4, "Duck   Down             S", 20, 150, 1, NORMAL

  DQBbox 4, 15, 25, 303, 175, 1

TextTime = TextTime + 1
IF TextTime > 25 THEN
DQBprints 4, "Press enter", CENTERED, 186, 0, ITALIC
DQBprints 4, "Press enter", CENTERED, 185, 1, ITALIC
END IF
IF TextTime > 50 THEN TextTime = 0

  DQBwait 1                                     ' Update the videoscreen

  DQBcopyLayer 4, VIDEO                         ' Copy layer 1 to Screen

LOOP UNTIL DQBkey(KEYENTER)

END SUB

SUB HowManyPlayers



DO

DQBcopyLayer 2, 1

DQBprints 1, "Players", CENTERED, 5, 0, UNDERLINED
DQBprints 1, "Players", CENTERED, 5, 0, UNDERLINED
DQBprints 1, "Players", CENTERED, 6, 11, UNDERLINED

  DQBfilterBox 1, 10, 50, 309, 190, 1, 1        ' Draw a filterbox
  DQBbox 1, 11, 155, 308, 189, 1

  DQBbox 1, 80, 51, 250, 150, 0

DQBmPut 1, 100, 70, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 0)), 1
DQBprints 1, "The Handyman", 40, 160, 11, NORMAL

IF Players = 2 THEN
DQBput 1, 160, 87, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 0))
DQBprints 1, "and The little Ball", 144, 160, 11, NORMAL
END IF

IF DQBkey(KEYRIGHT) THEN Players = Players + 1
DO: LOOP UNTIL DQBkey(KEYRIGHT) = FALSE

IF DQBkey(KEYLEFT) THEN Players = Players - 1
DO: LOOP UNTIL DQBkey(KEYLEFT) = FALSE

IF Players > 2 THEN Players = 2
IF Players < 1 THEN Players = 1


DQBcopyLayer 1, VIDEO

DQBwait 1

LOOP UNTIL DQBkey(KEYENTER)
EnterKey


END SUB

REM $DYNAMIC
SUB InstallProgram

' --------- Install ---------
CLS
WIDTH 80, 25
COLOR 14, 1
Text$ = "The Adventures ver. 1.1 - Startup"
LOCATE 1, 1: PRINT SPACE$(80): LOCATE 1, 40 - (LEN(Text$) / 2): PRINT Text$
COLOR 7, 0
PRINT "Wait a moment.."
PRINT "EMS..";
IF DQBinit(8, 4, 0) THEN                       ' 8 Layers 2 sounds 0 personal
DQBclose
PRINT "failed."
PRINT DQBerror$
END
END IF
PRINT "ok."
PRINT "The EMS pageframe segment is located at " + HEX$(DQBemsLayer) + "h"
PRINT "Current dir :  "; DQBdrive$; ":\" + DQBpath$
PRINT "Conventional memory..";
' 66000 + 17000
'dummy& = SETMEM(-83000)
dummy& = SETMEM(-83000)

PRINT "ok."

PRINT "SoundBlaster...";
IF DQBinstallSB(TRUE, 1, 22050, &H220, AUTO, AUTO) THEN
    ' Bad initialization
    DQBclose
    PRINT "failed."
    PRINT DQBerror$
    END
END IF
PRINT "ok."

PRINT "Loading sounds...";
IF DQBloadSound(1, SoundsPath$ + "Jump.WAV") THEN DQBclose: PRINT DQBerror$: END
IF DQBloadSound(2, SoundsPath$ + "Fall.WAV") THEN DQBclose: PRINT DQBerror$: END
IF DQBloadSound(3, SoundsPath$ + "Hit.WAV") THEN DQBclose: PRINT DQBerror$: END
IF DQBloadSound(4, SoundsPath$ + "Begin.WAV") THEN DQBclose: PRINT DQBerror$: END
PRINT "ok."


IF DQBjoyDetected(JOY1) THEN PRINT "Joystick 1 detected"
IF DQBjoyDetected(JOY2) THEN PRINT "Joystick 2 detected"
IF NOT DQBjoyDetected(JOY1) THEN PRINT "Joystick 1 not detected"
IF NOT DQBjoyDetected(JOY2) THEN PRINT "Joystick 2 not detected"

PRINT
ShowIntro = TRUE
Cheat = FALSE
PRINT "Reading commandline..."
C$ = UCASE$(COMMAND$)
IF INSTR(C$, "INTRO") > 0 THEN ShowIntro = FALSE: PRINT "- Skipping Intro"
IF INSTR(C$, "TMB") > 0 THEN Cheat = TRUE: PRINT "- Cheat mode ON"
IF C$ = "" THEN PRINT

PRINT "press a key..."
WHILE INKEY$ = "": WEND

END SUB

REM $STATIC
SUB Intro

' This sub plays 3 FLI movies.
' 1 - TMB Production - logo
' 2 - The Adventures - Presentation
' 3 - The story


' First TMB presents
IF DQBopenFLI(MoviesPath$ + "TMB.FLI", FramesNumber, SpeedFactor) THEN
  DQBclose
  dummy& = SETMEM(66000)
  PRINT "Failed to load TMB.FLI"
  PRINT DQBerror$
  END
END IF
DO
  DQBplayFLIstep 2
DQBcopyLayer 2, 1
DQBwait 10
  DQBcopyLayer 1, VIDEO
Times = Times + 1
IF DQBkey(KEYESC) = TRUE THEN EscKey: EXIT DO
LOOP UNTIL Times > (FramesNumber * 2)
DQBwait 50
DQBclearLayer VIDEO
DQBcloseFLI                                             ' Remove it from mem.
dummy& = SETMEM(66000)
dummy& = SETMEM(-66000)




' Then The Adventures
Times = 0
DQBfadeIn Pal
IF DQBopenFLI(MoviesPath$ + "THEADVEN.FLI", FramesNumber, SpeedFactor) THEN
  DQBclose
  dummy& = SETMEM(66000)
  PRINT "Failed to load TheAdven.FLI"
  PRINT DQBerror$
  END
END IF
DO
DQBplayFLIstep 2
DQBcopyLayer 2, 1
DQBwait 10
DQBcopyLayer 1, VIDEO
Times = Times + 1
IF DQBkey(KEYESC) = TRUE THEN EscKey: EXIT DO
LOOP UNTIL Times > (FramesNumber * 1)
DQBclearLayer VIDEO
DQBcloseFLI                                             ' Remove it.
EscKey
  dummy& = SETMEM(66000)
dummy& = SETMEM(-66000)



' The whole intro
Times = 0
DQBfadeIn Pal
IF DQBopenFLI(MoviesPath$ + "Intro.FLI", FramesNumber, SpeedFactor) THEN
  DQBclose
  dummy& = SETMEM(66000)
  PRINT "Failed to load Intro.FLI"
  PRINT DQBerror$
  END
END IF
DO
DQBplayFLIstep 1
DQBcopyLayer 1, VIDEO
DQBwait 180
Times = Times + 1
IF DQBkey(KEYESC) THEN EXIT DO
LOOP UNTIL Times = (FramesNumber * 1)
DQBcloseFLI
DQBclearLayer VIDEO
EscKey
  dummy& = SETMEM(66000)
dummy& = SETMEM(-66000)





END SUB

SUB LoadEpisode


IF Episode = 1 THEN
' Define ALL sprites' sizes
Sprite1Size = DQBsize(1, 1, 24, 35)                     ' The Handyman
Sprite2Size = DQBsize(1, 57, 30, 92)                    ' The little Ball
Sprite3Size = DQBsize(9, 129, 29, 134)
Sprite4Size = DQBsize(9, 135, 29, 140)
Sprite5Size = DQBsize(1, 94, 59, 117)                   ' Enemy 1
Sprite6Size = DQBsize(1, 57, 30, 92)                    ' Enemy 2
Sprite7Size = DQBsize(251, 65, 264, 80)                 ' Strawberry
Sprite8Size = DQBsize(30, 129, 50, 134)                ' Moving sprite 1-hoz.
Sprite9Size = DQBsize(30, 135, 99, 144)             ' Moving sprite 2-hoz.
Sprite10Size = DQBsize(100, 135, 108, 194)               ' Moving sprite 3-vec.
Sprite11Size = DQBsize(251, 65, 264, 80)                ' End the level
Sprite12Size = DQBsize(275, 58, 292, 77)                ' Cross (x)
Sprite13Size = DQBsize(0, 0, 319, 10)
Sprite14Size = DQBsize(0, 11, 99, 50)
Sprite15Size = DQBsize(0, 51, 99, 90)
Sprite16Size = DQBsize(0, 91, 8, 150)
Sprite17Size = DQBsize(9, 91, 78, 100)
Sprite18Size = DQBsize(100, 11, 200, 111)
Sprite19Size = DQBsize(202, 12, 279, 94)
Sprite20Size = DQBsize(10, 102, 52, 127)
END IF

IF Episode = 2 THEN
' Define ALL sprites' sizes
Sprite1Size = DQBsize(1, 1, 24, 35)                     ' The Handyman
Sprite2Size = DQBsize(1, 57, 30, 92)                    ' The little Ball
Sprite3Size = DQBsize(9, 133, 29, 138)
Sprite4Size = DQBsize(9, 139, 29, 144)
Sprite5Size = DQBsize(127, 57, 160, 79)                ' Enemy 1
Sprite6Size = DQBsize(126, 81, 156, 107)                 ' Enemy 2
Sprite7Size = DQBsize(251, 65, 264, 80)                 ' Strawberry
Sprite8Size = DQBsize(10, 102, 71, 113)                ' Moving sprite 1-hoz.
Sprite9Size = DQBsize(9, 115, 117, 132)             ' Moving sprite 2-hoz.
Sprite10Size = DQBsize(1, 152, 23, 179)               ' Moving sprite 3-vec.
Sprite11Size = DQBsize(251, 65, 264, 80)                ' End the level
Sprite12Size = DQBsize(275, 58, 292, 77)                ' Cross (x)
Sprite13Size = DQBsize(0, 0, 319, 10)
Sprite14Size = DQBsize(0, 11, 99, 50)
Sprite15Size = DQBsize(0, 51, 99, 90)
Sprite16Size = DQBsize(0, 91, 8, 150)
Sprite17Size = DQBsize(9, 91, 78, 100)
Sprite18Size = DQBsize(100, 11, 182, 111)               ' BIG box
Sprite19Size = DQBsize(184, 12, 236, 86)                ' Palm
Sprite20Size = DQBsize(183, 88, 316, 188)               ' BIIG box
END IF


IF Episode = 3 THEN
' Define ALL sprites' sizes
Sprite1Size = DQBsize(1, 1, 24, 35)                     ' The Handyman
Sprite2Size = DQBsize(1, 57, 30, 92)                    ' The little Ball
Sprite3Size = DQBsize(9, 133, 29, 138)
Sprite4Size = DQBsize(9, 139, 29, 144)
Sprite5Size = DQBsize(1, 169, 23, 197)             ' Enemy 1
Sprite6Size = DQBsize(1, 130, 37, 167)           ' Enemy 2
Sprite7Size = DQBsize(251, 65, 264, 80)                 ' Strawberry
Sprite8Size = DQBsize(10, 102, 71, 113)                ' Moving sprite 1-hoz.
Sprite9Size = DQBsize(1, 152, 41, 161)          ' Moving sprite 2-hoz.
Sprite10Size = DQBsize(43, 152, 52, 192)           ' Moving sprite 3-vec.
Sprite11Size = DQBsize(251, 65, 264, 80)                ' End the level
Sprite12Size = DQBsize(275, 58, 292, 77)                ' Cross (x)
Sprite13Size = DQBsize(0, 0, 319, 10)
Sprite14Size = DQBsize(0, 11, 99, 50)
Sprite15Size = DQBsize(0, 51, 99, 90)
Sprite16Size = DQBsize(140, 125, 178, 198)
Sprite17Size = DQBsize(9, 91, 78, 100)
Sprite18Size = DQBsize(100, 11, 182, 111)               ' BIG box
Sprite19Size = DQBsize(184, 12, 236, 86)                ' Palm
Sprite20Size = DQBsize(188, 88, 283, 185)             ' BIIG box
END IF



END SUB

SUB LoadEpisodeGraphics


' Begin with the graphics that are the same in every episode.
' Handyman and co.' sprites.
IF DQBloadImage(4, 0, 0, GraphicsPath$ + "Sprites.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Sprites.bmp"
DQBclose
END
END IF
' Handyman
DQBget 4, 1, 1, 24, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 0))
DQBget 4, 26, 1, 49, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 1))
DQBget 4, 51, 1, 74, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 2))
DQBget 4, 76, 1, 99, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 3))
DQBget 4, 101, 1, 124, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 4))
DQBget 4, 126, 1, 149, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 5))
DQBget 4, 151, 1, 174, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 6))
DQBget 4, 176, 1, 199, 35, VARSEG(Sprite1Spr(0)), (VARPTR(Sprite1Spr(0)) + (Sprite1Size * 7))

' Ball
DQBget 4, 1, 37, 37, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 0))
DQBget 4, 39, 37, 75, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 1))
DQBget 4, 77, 37, 113, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 2))
DQBget 4, 115, 37, 151, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 3))
DQBget 4, 153, 37, 189, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 4))
DQBget 4, 191, 37, 227, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 5))
DQBget 4, 229, 37, 265, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 6))
DQBget 4, 267, 37, 303, 55, VARSEG(Sprite2Spr(0)), (VARPTR(Sprite2Spr(0)) + (Sprite2Size * 7))

' Strawberry
DQBget 4, 251, 83, 265, 88, VARSEG(Sprite7Spr(0)), VARPTR(Sprite7Spr(0))
' End the level
DQBget 4, 251, 65, 264, 80, VARSEG(Sprite11Spr(0)), VARPTR(Sprite11Spr(0))
' X - for the map
DQBget 4, 275, 58, 292, 77, VARSEG(Sprite12Spr(0)), VARPTR(Sprite12Spr(0))
' Handy icon
DQBget 4, 251, 91, 262, 101, VARSEG(HandyIcon(0)), VARPTR(HandyIcon(0))
' Ball icon
DQBget 4, 251, 103, 269, 112, VARSEG(BallIcon(0)), VARPTR(BallIcon(0))




'                               ------------------
'                                    Episode 1
'                               ------------------
IF Episode = 1 THEN
' Background picture
IF DQBloadImage(2, 0, 0, GraphicsPath$ + "bg1.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading bg1.bmp"
DQBclose
SYSTEM
END IF

' Destination for the sprites for episode 1
IF DQBloadImage(3, 0, 0, GraphicsPath$ + "Episode1.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Episode1.bmp"
DQBclose
SYSTEM
END IF

DQBget 3, 9, 129, 29, 134, VARSEG(Sprite3Spr(0)), VARPTR(Sprite3Spr(0))
DQBget 3, 9, 135, 29, 140, VARSEG(Sprite4Spr(0)), VARPTR(Sprite4Spr(0))

' Crocodile
DQBget 4, 1, 94, 59, 117, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0)) + (Sprite5Size * 0)
DQBget 4, 61, 94, 119, 117, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0)) + (Sprite5Size * 1)

' Crap
DQBget 4, 1, 57, 30, 92, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 0)
DQBget 4, 32, 57, 61, 92, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 1)
DQBget 4, 63, 57, 92, 92, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 2)
DQBget 4, 94, 57, 123, 92, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 3)

DQBget 3, 30, 129, 50, 134, VARSEG(Sprite8Spr(0)), VARPTR(Sprite8Spr(0))
DQBget 3, 30, 135, 99, 144, VARSEG(Sprite9Spr(0)), VARPTR(Sprite9Spr(0))
DQBget 3, 100, 135, 108, 194, VARSEG(Sprite10Spr(0)), VARPTR(Sprite10Spr(0))

' Long sprite
DQBget 3, 0, 0, 319, 10, VARSEG(Sprite13Spr(0)), VARPTR(Sprite13Spr(0))
' Large sprite
DQBget 3, 0, 11, 99, 50, VARSEG(Sprite14Spr(0)), VARPTR(Sprite14Spr(0))
' Skrew sprite
DQBget 3, 0, 51, 99, 90, VARSEG(Sprite15Spr(0)), VARPTR(Sprite15Spr(0))
' Vect. sprite
DQBget 3, 0, 91, 8, 150, VARSEG(Sprite16Spr(0)), VARPTR(Sprite16Spr(0))
' Little sprite
DQBget 3, 9, 91, 78, 100, VARSEG(Sprite17Spr(0)), VARPTR(Sprite17Spr(0))
' BIG sprite
DQBget 3, 100, 11, 200, 111, VARSEG(Sprite18Spr(0)), VARPTR(Sprite18Spr(0))
' Palm sprite
DQBget 3, 202, 12, 279, 94, VARSEG(Sprite19Spr(0)), VARPTR(Sprite19Spr(0))
' Bush
DQBget 3, 10, 102, 52, 127, VARSEG(Sprite20Spr(0)), VARPTR(Sprite20Spr(0))
END IF



'                               ------------------
'                                    Episode 2
'                               ------------------
IF Episode = 2 THEN
' Background picture
IF DQBloadImage(2, 0, 0, GraphicsPath$ + "bg2.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading bg2.bmp"
DQBclose
SYSTEM
END IF
' Destination for the sprites for episode 2
IF DQBloadImage(3, 0, 0, GraphicsPath$ + "Episode2.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Episode2.bmp"
DQBclose
SYSTEM
END IF

DQBget 3, 9, 133, 29, 138, VARSEG(Sprite3Spr(0)), VARPTR(Sprite3Spr(0))
DQBget 3, 9, 139, 29, 144, VARSEG(Sprite4Spr(0)), VARPTR(Sprite4Spr(0))

' Bird
DQBget 4, 127, 57, 160, 79, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0)) + (Sprite5Size * 0)
DQBget 4, 162, 57, 195, 79, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0)) + (Sprite5Size * 1)

' Tiger
DQBget 4, 126, 81, 156, 107, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 0)
DQBget 4, 157, 81, 187, 107, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 1)
DQBget 4, 188, 81, 218, 107, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 2)
DQBget 4, 219, 81, 249, 107, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 3)

DQBget 3, 10, 102, 71, 113, VARSEG(Sprite8Spr(0)), VARPTR(Sprite8Spr(0))
DQBget 3, 9, 115, 117, 132, VARSEG(Sprite9Spr(0)), VARPTR(Sprite9Spr(0))
DQBget 3, 1, 152, 23, 179, VARSEG(Sprite10Spr(0)), VARPTR(Sprite10Spr(0))


' Long sprite
DQBget 3, 0, 0, 319, 10, VARSEG(Sprite13Spr(0)), VARPTR(Sprite13Spr(0))
' Large sprite
DQBget 3, 0, 11, 99, 50, VARSEG(Sprite14Spr(0)), VARPTR(Sprite14Spr(0))
' Skrew sprite
DQBget 3, 0, 51, 99, 90, VARSEG(Sprite15Spr(0)), VARPTR(Sprite15Spr(0))
' Vect. sprite
DQBget 3, 0, 91, 8, 150, VARSEG(Sprite16Spr(0)), VARPTR(Sprite16Spr(0))
' Little sprite
DQBget 3, 9, 91, 78, 100, VARSEG(Sprite17Spr(0)), VARPTR(Sprite17Spr(0))
' BIG sprite
DQBget 3, 100, 11, 182, 111, VARSEG(Sprite18Spr(0)), VARPTR(Sprite18Spr(0))
' Palm sprite
DQBget 3, 184, 12, 236, 86, VARSEG(Sprite19Spr(0)), VARPTR(Sprite19Spr(0))
' BIIG box
DQBget 3, 183, 88, 316, 188, VARSEG(Sprite20Spr(0)), VARPTR(Sprite20Spr(0))

END IF


'                               ------------------
'                                    Episode 3
'                               ------------------
IF Episode = 3 THEN
' Background picture
IF DQBloadImage(2, 0, 0, GraphicsPath$ + "bg3.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading bg3.bmp"
DQBclose
SYSTEM
END IF
' Destination for the sprites for episode 3
IF DQBloadImage(3, 0, 0, GraphicsPath$ + "Episode3.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Episode3.bmp"
DQBclose
SYSTEM
END IF

DQBget 3, 9, 133, 29, 138, VARSEG(Sprite3Spr(0)), VARPTR(Sprite3Spr(0))
DQBget 3, 9, 139, 29, 144, VARSEG(Sprite4Spr(0)), VARPTR(Sprite4Spr(0))

' Abe
DQBget 4, 1, 169, 23, 197, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0)) + (Sprite5Size * 0)
DQBget 4, 25, 169, 47, 197, VARSEG(Sprite5Spr(0)), VARPTR(Sprite5Spr(0)) + (Sprite5Size * 1)

' Walking Crocodile
DQBget 4, 1, 130, 37, 167, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 0)
DQBget 4, 39, 130, 75, 167, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 1)
DQBget 4, 77, 130, 113, 167, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 2)
DQBget 4, 39, 130, 75, 167, VARSEG(Sprite6Spr(0)), VARPTR(Sprite6Spr(0)) + (Sprite6Size * 3)

DQBget 3, 10, 102, 71, 113, VARSEG(Sprite8Spr(0)), VARPTR(Sprite8Spr(0))
DQBget 3, 1, 152, 41, 161, VARSEG(Sprite9Spr(0)), VARPTR(Sprite9Spr(0))
DQBget 3, 43, 152, 52, 192, VARSEG(Sprite10Spr(0)), VARPTR(Sprite10Spr(0))


' Long sprite
DQBget 3, 0, 0, 319, 10, VARSEG(Sprite13Spr(0)), VARPTR(Sprite13Spr(0))
' Large sprite
DQBget 3, 0, 11, 99, 50, VARSEG(Sprite14Spr(0)), VARPTR(Sprite14Spr(0))
' Skrew sprite
DQBget 3, 0, 51, 99, 90, VARSEG(Sprite15Spr(0)), VARPTR(Sprite15Spr(0))
' Vect. sprite
DQBget 3, 140, 125, 178, 198, VARSEG(Sprite16Spr(0)), VARPTR(Sprite16Spr(0))
' Little sprite
DQBget 3, 9, 91, 78, 100, VARSEG(Sprite17Spr(0)), VARPTR(Sprite17Spr(0))
' BIG sprite
DQBget 3, 100, 11, 182, 111, VARSEG(Sprite18Spr(0)), VARPTR(Sprite18Spr(0))
' Palm sprite
DQBget 3, 184, 12, 236, 86, VARSEG(Sprite19Spr(0)), VARPTR(Sprite19Spr(0))
' BIIG box
DQBget 3, 188, 88, 283, 185, VARSEG(Sprite20Spr(0)), VARPTR(Sprite20Spr(0))

END IF




END SUB

REM $DYNAMIC
SUB LoadGraphics

'       Layer          Description
'       2               Episode1 background
'       3               Episode1 sprites
'       4               Sprites
'       5               Map
'       6               Menu
'       7               Episodes
'       8               Game over picture

IF DQBloadImage(5, 0, 0, GraphicsPath$ + "Map.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Map.bmp"
DQBclose
END
END IF

IF DQBloadImage(6, 0, 0, GraphicsPath$ + "Menu.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Menu.bmp"
DQBclose
END
END IF

IF DQBloadImage(7, 0, 0, GraphicsPath$ + "Episodes.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading Episodes.bmp"
DQBclose
END
END IF

IF DQBloadImage(8, 0, 0, GraphicsPath$ + "GameOver.bmp", Pal, 320, 200) THEN
DQBinitText
PRINT "Error loading GameOver.bmp"
DQBclose
END
END IF




DQBsetPal Pal                                   ' Palette from Bmp - files

IF DQBcreateBMap(1, 0, 255) THEN
dummy& = SETMEM(66000)
DQBinitText
PRINT "Couldn't create blender map."
PRINT DQBerror$
DQBclose
SYSTEM
END IF



FOR i = 1 TO 255                                ' Make a blenderMap
DQBgetCol i, R, g, b
Col = (R + g + b) / 3
Col = DQBfindCol(0, 0, Col)
DQBsetBMap 1, 1, i, Col                           ' For colour 1
NEXT



END SUB

REM $STATIC
SUB Menu

HandyLives = 3
Level = 1
HandyEnergy = 1000
GameIsOver = FALSE
EndTheLevel = FALSE
UserLevel = FALSE
MenuContent = 54
MenuStart = TRUE
MenuLoad = FALSE
MenuUserLevel = FALSE
SelectEpisode = TRUE
FileName = "        "

MenuStart:

  DO

  DQBcopyLayer 6, 1                                     ' Copy Menu to layer 1

IF DQBkey(80) THEN MenuContent = MenuContent + 10
IF DQBkey(72) THEN MenuContent = MenuContent - 10
IF MenuContent > 94 THEN MenuContent = 54
IF MenuContent < 54 THEN MenuContent = 94

IF MenuStart = TRUE AND DQBkey(28) = TRUE THEN          ' Start menu
IF MenuContent = 54 THEN EnterKey: UserLevel = FALSE: EXIT SUB
IF MenuContent = 64 THEN EnterKey: MenuLoad = TRUE: MenuStart = FALSE: EnterKey
IF MenuContent = 74 THEN EnterKey: MenuUserLevel = TRUE: MenuStart = FALSE
IF MenuContent = 84 THEN EnterKey: Credits: MenuContent = 54: MenuStart = TRUE
IF MenuContent = 94 THEN EnterKey: EndProgram
END IF


IF DQBkey(28) = TRUE THEN
EnterKey                                                ' Release Enter


IF MenuLoad = TRUE THEN                                 ' Load menu
IF MenuContent = 94 THEN MenuLoad = FALSE: MenuStart = TRUE: EnterKey: GOTO NoLoad
CLOSE #1
OPEN DatasPath$ + "TheAdven.Sav" FOR RANDOM AS #1 LEN = LEN(LoadGame)
IF MenuContent = 54 THEN GET #1, 1, LoadGame
IF MenuContent = 64 THEN GET #1, 2, LoadGame
IF MenuContent = 74 THEN GET #1, 3, LoadGame
IF MenuContent = 84 THEN GET #1, 4, LoadGame
IF NOT LoadGame.NameOfGame = "          " THEN
Episode = LoadGame.Episode
Level = LoadGame.Level
EXIT SUB
END IF
NoLoad:
END IF
END IF                                                  ' End of Enter key




IF MenuUserLevel = TRUE THEN                            ' Start menu
FileName = "        "
Characters = 1
FileNumber = 0
' Find out how many Map files there are.
File$ = DQBdir$(DatasPath$ + "*.MAP", ATTRIB.A)
IF File$ = "" THEN
DQBboxf VIDEO, 50, 50, 270, 150, 0                      ' Make a blackbox
DQBbox VIDEO, 50, 50, 270, 150, 1                       ' Red ring
DQBprint VIDEO, "No level files were found.", CENTERED, 100, 1    ' Report
DQBwait 100
MenuUserLevel = FALSE
MenuStart = TRUE
GOTO MenuStart
ELSE
DQBsetClipBox 75, 50, 233, 104                          ' Set a clipbox
NumberOfFiles = 0
DO
File$ = DQBdir$("", ATTRIB.A)
    IF File$ = "" THEN EXIT DO
NumberOfFiles = NumberOfFiles + 1
LOOP
NumberOfFiles = NumberOfFiles
END IF
DO
DQBcopyLayer 6, 1

IF DQBkey(KEYRIGHT) THEN FileNumber = FileNumber + 1
IF DQBkey(KEYLEFT) THEN FileNumber = FileNumber - 1
IF FileNumber < 0 THEN FileNumber = 0
IF FileNumber > NumberOfFiles THEN FileNumber = NumberOfFiles


File$ = DQBdir$(DatasPath$ + "*.MAP", ATTRIB.A)
AM = 1
IF FileNumber > 0 THEN
AM = 1
DO
File$ = DQBdir$("", ATTRIB.A)
AM = AM + 1
    IF File$ = "" THEN EXIT DO
LOOP UNTIL AM > FileNumber
END IF

DQBprint 1, File$, CENTERED, 55, 1
DQBprint 1, STR$(AM) + "/" + STR$(NumberOfFiles + 1), CENTERED, 70, 1
DQBcopyLayer 1, VIDEO
DQBwait 5

IF DQBkey(KEYESC) = TRUE THEN MenuUserLevel = FALSE: MenuStart = TRUE: DQBsetClipBox 0, 0, 319, 199: GOTO MenuStart

LOOP UNTIL DQBkey(KEYENTER)
EnterKey
UserLevelName = File$
DQBsetClipBox 0, 0, 319, 199
UserLevel = TRUE
HowManyPlayers
ValuesForALevel
EXIT SUB
END IF











DQBboxf 1, 85, MenuContent, 223, MenuContent + 10, 4    ' Selected content

IF MenuStart = TRUE THEN
DQBprints 1, "New game", CENTERED, 55, 0, NORMAL
DQBprints 1, "Load game", CENTERED, 65, 0, NORMAL
DQBprints 1, "Load level", CENTERED, 75, 0, NORMAL
DQBprints 1, "About", CENTERED, 85, 0, NORMAL
DQBprints 1, "Exit", CENTERED, 95, 0, NORMAL
DQBprints 1, "New game", CENTERED, 56, 11, NORMAL
DQBprints 1, "Load game", CENTERED, 66, 11, NORMAL
DQBprints 1, "Load level", CENTERED, 76, 11, NORMAL
DQBprints 1, "About", CENTERED, 86, 11, NORMAL
DQBprints 1, "Exit", CENTERED, 96, 11, NORMAL
END IF

IF MenuLoad = TRUE THEN
CLOSE #1
OPEN DatasPath$ + "TheAdven.Sav" FOR RANDOM AS #1 LEN = LEN(LoadGame)
LoadY = 45
FOR i% = 1 TO 4
GET #1, i%, LoadGame
LoadY = LoadY + 10
IF LoadGame.NameOfGame = "          " THEN
DQBprints 1, "Empty", CENTERED, LoadY, 0, NORMAL
DQBprints 1, "Empty", CENTERED, LoadY + 1, 1, NORMAL
ELSE
DQBprints 1, LoadGame.NameOfGame, CENTERED, LoadY, 0, NORMAL
DQBprints 1, LoadGame.NameOfGame, CENTERED, LoadY + 1, 1, NORMAL
END IF
NEXT
CLOSE #1
DQBprints 1, "Back", CENTERED, 95, 0, NORMAL
DQBprints 1, "Back", CENTERED, 96, 11, NORMAL
END IF



  DQBwait 5                                     ' Update the videoscreen

  DQBcopyLayer 1, VIDEO                         ' Copy layer 1 to Screen

LOOP UNTIL DQBkey(KEYESC)
EscKey
EndProgram

END SUB

SUB NextLevel

Level = Level + 1

DisplayMap

IF Episode = 1 AND Level = 7 THEN CompletedEpisode
IF Episode = 2 AND Level = 13 THEN CompletedEpisode

ValuesForALevel


END SUB

SUB Save

MenuContent = 64
GetNameOfLoad = FALSE
FileName = "          "
Characters = 1

  DQBcopyLayer VIDEO, 3                         ' Copy Screen to layer 3

DO
  DQBcopyLayer 3, 4                         ' Copy Screen to layer 3

  DQBfilterBox 4, 10, 10, 309, 180, 1, 1          ' Draw a filterbox

  DQBprints 4, "The Adventures - Save", 25, 15, 1, ITALIC

IF DQBkey(80) THEN MenuContent = MenuContent + 20
IF DQBkey(72) THEN MenuContent = MenuContent - 20
IF MenuContent > 124 THEN MenuContent = 64
IF MenuContent < 64 THEN MenuContent = 124

IF DQBkey(28) = TRUE THEN
EnterKey
DO
  DQBcopyLayer 3, 4                             ' Copy Screen to layer 3
  DQBfilterBox 4, 10, 10, 309, 180, 1, 1          ' Draw a filterbox
  DQBprints 4, "The Adventures - Save", 25, 15, 1, ITALIC
  DQBprints 4, "Copyright 1999 TMB Productions", CENTERED, 165, 1, NORMAL
  DQBbox 4, 15, 25, 303, 175, 1
DQBboxf 4, 85, MenuContent, 223, MenuContent + 10, 1


CLOSE #1
OPEN DatasPath$ + "TheAdven.Sav" FOR RANDOM AS #1 LEN = LEN(LoadGame)
LoadY = 45
FOR i% = 1 TO 4
GET #1, i%, LoadGame
LoadY = LoadY + 20
IF LoadGame.NameOfGame = "          " THEN
DQBprints 4, "Empty", CENTERED, LoadY, 0, NORMAL
DQBprints 4, "Empty", CENTERED, LoadY + 1, 11, NORMAL
ELSE
DQBprints 4, LoadGame.NameOfGame, CENTERED, LoadY, 0, NORMAL
DQBprints 4, LoadGame.NameOfGame, CENTERED, LoadY + 1, 11, NORMAL
END IF
NEXT
CLOSE #1

DQBcopyLayer 4, VIDEO                         ' Copy layer 1 to Screen

PressedKey = DQBreadKey                                  ' Get Scancode
PressedAscKey = DQBasc(PressedKey, FALSE)                ' Get Ascii code
IF PressedKey = 28 THEN EXIT SUB                         ' Exit loop if Enter

IF PressedAscKey > 47 AND PressedAscKey < 123 AND Characters < 9 THEN
MID$(FileName, Characters) = CHR$(PressedAscKey)
FileName = UCASE$(FileName)
Characters = Characters + 1
END IF

IF PressedKey = 14 AND Characters > 1 THEN              ' Backspace = Erase
Characters = Characters - 1
MID$(FileName, Characters) = " "
END IF

CLOSE #1
OPEN DatasPath$ + "TheAdven.Sav" FOR RANDOM AS #1 LEN = LEN(LoadGame)
LoadGame.NameOfGame = FileName
LoadGame.Episode = Episode
LoadGame.Level = Level
IF MenuContent = 64 THEN PUT #1, 1, LoadGame
IF MenuContent = 84 THEN PUT #1, 2, LoadGame
IF MenuContent = 104 THEN PUT #1, 3, LoadGame
IF MenuContent = 124 THEN PUT #1, 4, LoadGame



LOOP UNTIL DQBkey(28) = TRUE
EXIT SUB
END IF


DQBboxf 4, 85, MenuContent, 223, MenuContent + 10, 1    ' Selected content

CLOSE #1
OPEN DatasPath$ + "TheAdven.Sav" FOR RANDOM AS #1 LEN = LEN(LoadGame)
LoadY = 45
FOR i% = 1 TO 4
GET #1, i%, LoadGame
LoadY = LoadY + 20
IF LoadGame.NameOfGame = "          " THEN
DQBprints 4, "Empty", CENTERED, LoadY, 0, NORMAL
DQBprints 4, "Empty", CENTERED, LoadY + 1, 11, NORMAL
ELSE
DQBprints 4, LoadGame.NameOfGame, CENTERED, LoadY, 0, NORMAL
DQBprints 4, LoadGame.NameOfGame, CENTERED, LoadY + 1, 11, NORMAL
END IF
NEXT
CLOSE #1




  DQBprints 4, "Copyright 1999 TMB Productions", CENTERED, 165, 1, NORMAL

  DQBbox 4, 15, 25, 303, 175, 1

  DQBwait 5                                     ' Update the videoscreen

  DQBcopyLayer 4, VIDEO                         ' Copy layer 1 to Screen

LOOP UNTIL DQBkey(KEYESC)
EscKey

END SUB

SUB Screenshot

DQBprint VIDEO, "Saving ADVSHOT.PCX", 2, 190, 1
IF DQBsaveImage(1, 0, 0, 320, 200, "ADVSHOT.PCX", Pal, PCX) THEN
DQBinitText: PRINT "Error saving screenshot, program aborted"
DQBclose
END

END IF


END SUB

SUB SelectEpisodeToPlay

Episode = 1
EndTheLevel = FALSE
GameIsOver = FALSE
UserLevel = FALSE
LevelCheat = FALSE
DQBsetSolidPut

CLOSE
OPEN DatasPath$ + "Episodes.Sav" FOR RANDOM AS #1 LEN = LEN(EpisodesCompleted)
GET #1, 1, EpisodesCompleted

DO

DQBcopyLayer 2, 1

DQBprints 1, "Select episode", CENTERED, 5, 0, UNDERLINED
DQBprints 1, "Select episode", CENTERED, 6, 11, UNDERLINED

  DQBfilterBox 1, 10, 50, 309, 190, 1, 1        ' Draw a filterbox
  DQBbox 1, 11, 155, 308, 189, 1

IF Episode = 1 THEN
DQBprints 1, "Episode 1 :  The Beach", CENTERED, 40, 1, ITALIC
DQBget 7, 0, 0, 159, 99, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))
DQBprint 1, "Fight your way through the beach", CENTERED, 160, 11
END IF
IF Episode = 2 THEN
DQBprints 1, "Episode 2 :  The Jungle", CENTERED, 40, 1, ITALIC
DQBget 7, 160, 0, 319, 99, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))
DQBprint 1, "Look out in the deep dark jungle", CENTERED, 160, 11
END IF
IF Episode = 3 THEN
DQBprints 1, "Episode 3 :  The Village", CENTERED, 40, 1, ITALIC
DQBget 7, 0, 100, 159, 199, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))
DQBprint 1, "Not avalible", CENTERED, 160, 11
END IF
IF Episode = 4 THEN
DQBprints 1, "Episode 4 :  The Mountains", CENTERED, 40, 1, ITALIC
DQBget 7, 160, 100, 319, 199, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))
DQBprint 1, "Not avalible", CENTERED, 160, 11
END IF

DQBput 1, 81, 51, VARSEG(EpisodePic(0)), VARPTR(EpisodePic(0))

IF EpisodesCompleted.Episode1 = TRUE AND Episode = 1 THEN DQBprint 1, "COMPLETED", CENTERED, 70, 1
IF EpisodesCompleted.Episode2 = TRUE AND Episode = 2 THEN DQBprint 1, "COMPLETED", CENTERED, 70, 1
IF EpisodesCompleted.Episode3 = TRUE AND Episode = 3 THEN DQBprint 1, "COMPLETED", CENTERED, 70, 1
IF EpisodesCompleted.Episode4 = TRUE AND Episode = 4 THEN DQBprint 1, "COMPLETED", CENTERED, 70, 1


IF DQBkey(KEYRIGHT) THEN Episode = Episode + 1
DO: LOOP UNTIL DQBkey(KEYRIGHT) = FALSE

IF DQBkey(KEYLEFT) THEN Episode = Episode - 1
DO: LOOP UNTIL DQBkey(KEYLEFT) = FALSE

IF Episode > 4 THEN Episode = 4
IF Episode < 1 THEN Episode = 1

' Cheating section
IF DQBkey(2) THEN Level = 1: LevelCheat = TRUE
IF DQBkey(3) THEN Level = 2: LevelCheat = TRUE
IF DQBkey(4) THEN Level = 3: LevelCheat = TRUE
IF DQBkey(5) THEN Level = 4: LevelCheat = TRUE
IF DQBkey(6) THEN Level = 5: LevelCheat = TRUE
IF DQBkey(7) THEN Level = 6: LevelCheat = TRUE
IF LevelCheat = TRUE THEN DQBprint 1, "Level Cheat is ON", CENTERED, 192, 1
' End of Cheating section


DQBcopyLayer 1, VIDEO

DQBwait 1

LOOP UNTIL DQBkey(KEYENTER)
EnterKey

CLOSE #1

DQBsetTransPut


IF LevelCheat = FALSE AND Episode = 1 THEN Level = 1
IF LevelCheat = FALSE AND Episode = 2 THEN Level = 7
IF LevelCheat = FALSE AND Episode = 3 THEN Level = 13



END SUB

SUB SetValues

FOR S% = 1 TO 15
Sprite1(S%).X = -100
Sprite1(S%).Y = -200
Sprite2(S%).X = -100
Sprite2(S%).Y = -200
Sprite3(S%).X = -100
Sprite3(S%).Y = -200
Sprite3(S%).SizeX = 0
Sprite4(S%).X = -100
Sprite4(S%).Y = -200
Sprite4(S%).SizeX = 0

Sprite5(S%).X = -100
Sprite5(S%).Y = -200
Sprite5(S%).SizeX = 0
Sprite5(S%).MinX = -100
Sprite5(S%).MaxX = -100
Sprite6(S%).X = -100
Sprite6(S%).Y = -200
Sprite6(S%).SizeX = 0
Sprite6(S%).MinX = -100
Sprite6(S%).MaxX = -100

Sprite7(S%).X = -100
Sprite7(S%).Y = -200
Sprite7(S%).SizeX = 0

Sprite8(S%).X = -100
Sprite8(S%).Y = -200
Sprite8(S%).SizeX = 0
Sprite8(S%).MinX = -100
Sprite8(S%).MaxX = -100
Sprite8(S%).Direction = RIGHT
Sprite9(S%).X = -100
Sprite9(S%).Y = -200
Sprite9(S%).SizeX = 0
Sprite9(S%).MinX = -100
Sprite9(S%).MaxX = -100
Sprite9(S%).Direction = RIGHT
Sprite10(S%).X = -100
Sprite10(S%).Y = -200
Sprite10(S%).SizeX = 0
Sprite10(S%).MinY = -200
Sprite10(S%).MaxY = -200
Sprite10(S%).Direction = RIGHT

Sprite11(S%).X = -100
Sprite11(S%).Y = -200
Sprite11(S%).SizeX = 0
Sprite12(S%).X = -100
Sprite12(S%).Y = -200
Sprite12(S%).SizeX = 0

Sprite13(S%).X = -100
Sprite13(S%).Y = -200
Sprite13(S%).SizeX = 0
Sprite14(S%).X = -100
Sprite14(S%).Y = -200
Sprite14(S%).SizeX = 0
Sprite15(S%).X = -100
Sprite15(S%).Y = -200
Sprite15(S%).SizeX = 0
Sprite16(S%).X = -100
Sprite16(S%).Y = -200
Sprite16(S%).SizeX = 0

Sprite17(S%).X = -100
Sprite17(S%).Y = -200
Sprite17(S%).SizeX = 0
Sprite18(S%).X = -100
Sprite18(S%).Y = -200
Sprite18(S%).SizeX = 0
Sprite19(S%).X = -100
Sprite19(S%).Y = -200
Sprite19(S%).SizeX = 50
Sprite20(S%).X = -100
Sprite20(S%).Y = -200
Sprite20(S%).SizeX = 0
NEXT




END SUB

SUB StartValues

HandyLives = 3                                  ' Handymans lives from start

HandyEnergy = 1000                              ' HandyEnergy from start / 10

BallLives = 3                                   ' Ball lives from start

BallEnergy = 1000                               ' Ball energy / 10

BackGroundX = 0

FileName = "          "
Characters = 1


END SUB

SUB ValuesForALevel

CLOSE                                                   ' Close ALL files

'                  ------------------------------------
'            The values that aren't changing are defined here
'                  ------------------------------------
IF UserLevel = FALSE THEN                               ' No user level?
IF Episode = 1 THEN                                     ' Episode 1
IF Level = 1 THEN Levelname = "Level1.MAP"
IF Level = 2 THEN Levelname = "Level2.MAP"
IF Level = 3 THEN Levelname = "Level3.MAP"
IF Level = 4 THEN Levelname = "Level4.MAP"
IF Level = 5 THEN Levelname = "Level5.MAP"
IF Level = 6 THEN Levelname = "Level6.MAP"
END IF
IF Episode = 2 THEN                                     ' Episode 2
IF Level = 7 THEN Levelname = "Level7.MAP"
IF Level = 8 THEN Levelname = "Level8.MAP"
IF Level = 9 THEN Levelname = "Level9.MAP"
IF Level = 10 THEN Levelname = "Level10.MAP"
IF Level = 11 THEN Levelname = "Level11.MAP"
IF Level = 12 THEN Levelname = "Level12.MAP"
END IF
IF Episode = 3 THEN                                     ' Episode 3
IF Level = 13 THEN Levelname = "Level13.MAP"
IF Level = 14 THEN Levelname = "Level14.MAP"
IF Level = 15 THEN Levelname = "Level15.MAP"
IF Level = 16 THEN Levelname = "Level16.MAP"
IF Level = 17 THEN Levelname = "Level17.MAP"
IF Level = 18 THEN Levelname = "Level18.MAP"
END IF
END IF
IF UserLevel = TRUE THEN                                ' Do we have a user's
Levelname = UserLevelName
END IF

OPEN DatasPath$ + Levelname FOR BINARY AS #1
IF LOF(1) = 0 THEN
CLOSE
KILL DatasPath$ + Levelname
BEEP                                                    ' Beep if not exist
DQBboxf VIDEO, 50, 50, 270, 150, 0                      ' Make a blackbox
DQBbox VIDEO, 50, 50, 270, 150, 1                       ' Red ring
DQBprint VIDEO, "The level was not found.", CENTERED, 100, 1    ' Report
UserLevel = FALSE                                       ' No userlevel
DQBwait 150                                             ' Be sure user sore it
EnterKey                                                ' Enter released ?
EscKey                                                  ' Esc released ?
GotoMenu = TRUE                                         ' Goto menu
ELSE
END IF


CLOSE
OPEN DatasPath$ + Levelname FOR RANDOM AS #1 LEN = LEN(SpriteMap)

FOR T% = 1 TO 15
GET #1, T%, SpriteMap

Sprite1(T%).X = SpriteMap.x1                            ' Handy's X
Sprite1(T%).Y = SpriteMap.y1                            ' Handy's Y
Sprite2(T%).X = SpriteMap.x2                            ' Ball's X
Sprite2(T%).Y = SpriteMap.y2                            ' Ball's Y
Sprite3(T%).X = SpriteMap.x3                            ' Springy 1's X
Sprite3(T%).Y = SpriteMap.y3                            ' Springy 1's Y
Sprite3(T%).SizeX = SpriteMap.SizeX3                        ' Springy 1's Size
Sprite4(T%).X = SpriteMap.X4                            ' Springy 2's X
Sprite4(T%).Y = SpriteMap.Y4                            ' Springy 2's Y
Sprite4(T%).SizeX = SpriteMap.SizeX4                        ' Springy 2's Size
Enemy1(T%).X = SpriteMap.X5                            ' Enemy 1's X
Enemy1(T%).Y = SpriteMap.Y5                            ' Enemy 1's Y
Enemy1(T%).SizeX = SpriteMap.SizeX5                        ' Enemy 1's Size
Enemy1(T%).MinX = SpriteMap.MinX5                         ' Enemy 1's Min. X
Enemy1(T%).MaxX = SpriteMap.MaxX5                         ' Enemy 1's Max. X
Enemy2(T%).X = SpriteMap.X6                            ' Enemy 2's X
Enemy2(T%).Y = SpriteMap.Y6                            ' Enemy 2's Y
Enemy2(T%).SizeX = SpriteMap.SizeX6                        ' Enemy 2's Size
Enemy2(T%).MinX = SpriteMap.MinX6                         ' Enemy 2's Min. X
Enemy2(T%).MaxX = SpriteMap.MaxX6                        ' Enemy 2's Max. X
Sprite7(T%).X = SpriteMap.X7                            ' Strawberry's X
Sprite7(T%).Y = SpriteMap.Y7                            ' Strawberry's Y
Sprite7(T%).SizeX = SpriteMap.SizeX7                        ' Strawberry's Size
Sprite8(T%).X = SpriteMap.X8                            ' Mov 1's X
Sprite8(T%).Y = SpriteMap.Y8                            ' Mov 1's Y
Sprite8(T%).SizeX = SpriteMap.SizeX8                        ' Mov 1's Size
Sprite8(T%).MinX = SpriteMap.MinX8                         ' Mov 1's Min. X
Sprite8(T%).MaxX = SpriteMap.MaxX8                         ' Mov 1's Max. X
IF (Sprite8(T%).X - Sprite8(T%).MinX) >= (Sprite8(T%).X - Sprite8(T%).MinX) THEN Sprite8(T%).Direction = RIGHT
IF (Sprite8(T%).X - Sprite8(T%).MinX) < (Sprite8(T%).X - Sprite8(T%).MinX) THEN Sprite8(T%).Direction = LEFT
Sprite9(T%).X = SpriteMap.X9                            ' Mov 2's X
Sprite9(T%).Y = SpriteMap.Y9                            ' Mov 2's Y
Sprite9(T%).SizeX = SpriteMap.SizeX9                        ' Mov 2's Size
Sprite9(T%).MinX = SpriteMap.MinX9                         ' Mov 2's Min. X
Sprite9(T%).MaxX = SpriteMap.MaxX9                        ' Mov 2's Max. X
IF (Sprite9(T%).X - Sprite9(T%).MinX) >= (Sprite9(T%).X - Sprite9(T%).MinX) THEN Sprite9(T%).Direction = RIGHT
IF (Sprite9(T%).X - Sprite9(T%).MinX) < (Sprite9(T%).X - Sprite9(T%).MinX) THEN Sprite9(T%).Direction = LEFT
Sprite10(T%).X = SpriteMap.X10                           ' Mov 3's X
Sprite10(T%).Y = SpriteMap.Y10                           ' Mov 3's Y
Sprite10(T%).SizeX = SpriteMap.SizeX10                       ' Mov 3's Size
Sprite10(T%).MinY = SpriteMap.MinY10                        ' Mov 3's Min. Y
Sprite10(T%).MaxY = SpriteMap.MaxY10                       ' Mov 3's Max. Y
IF (Sprite10(T%).Y - Sprite10(T%).MinY) >= (Sprite10(T%).Y - Sprite10(T%).MinY) THEN Sprite10(T%).Direction = UP
IF (Sprite10(T%).Y - Sprite10(T%).MinY) < (Sprite10(T%).Y - Sprite10(T%).MinY) THEN Sprite10(T%).Direction = DOWN

Sprite11(T%).X = SpriteMap.X11                          ' Sprite 11's X
Sprite11(T%).Y = SpriteMap.Y11                          ' Sprite 11's Y
Sprite11(T%).SizeX = SpriteMap.SizeX11                  ' Sprite 11's Size

Sprite12(T%).X = SpriteMap.X12                          ' Sprite 12's X
Sprite12(T%).Y = SpriteMap.Y12                          ' Sprite 12's Y
Sprite12(T%).SizeX = SpriteMap.SizeX12                  ' Sprite 12's Size

Sprite13(T%).X = SpriteMap.X13                           ' Sprite 13's X
Sprite13(T%).Y = SpriteMap.Y13                           ' Sprite 13's Y
Sprite13(T%).SizeX = SpriteMap.SizeX13                       ' Sprite 13's Size
Sprite14(T%).X = SpriteMap.X14                           ' Sprite 14's X
Sprite14(T%).Y = SpriteMap.Y14                           ' Sprite 14's Y
Sprite14(T%).SizeX = SpriteMap.SizeX14                       ' Sprite 14's Size
Sprite15(T%).X = SpriteMap.X15                           ' Sprite 15's X
Sprite15(T%).Y = SpriteMap.Y15                           ' Sprite 15's Y
Sprite15(T%).SizeX = SpriteMap.SizeX15                       ' Sprite 15's Size
Sprite16(T%).X = SpriteMap.X16                           ' Sprite 16's X
Sprite16(T%).Y = SpriteMap.Y16                           ' Sprite 16's Y
Sprite16(T%).SizeX = SpriteMap.SizeX16                       ' Sprite 16's Size
Sprite17(T%).X = SpriteMap.X17                           ' Sprite 17's X
Sprite17(T%).Y = SpriteMap.Y17                           ' Sprite 17's Y
Sprite17(T%).SizeX = SpriteMap.SizeX17                       ' Sprite 17's Size
Sprite18(T%).X = SpriteMap.X18                           ' Sprite 18's X
Sprite18(T%).Y = SpriteMap.Y18                           ' Sprite 18's Y
Sprite18(T%).SizeX = SpriteMap.SizeX18                       ' Sprite 18's Size
Sprite19(T%).X = SpriteMap.X19                           ' Sprite 19's X
Sprite19(T%).Y = SpriteMap.Y19                           ' Sprite 19's Y
Sprite19(T%).SizeX = SpriteMap.SizeX19                       ' Sprite 19's Size
Sprite20(T%).X = SpriteMap.X20                           ' Sprite 20's X
Sprite20(T%).Y = SpriteMap.Y20                           ' Sprite 20's Y
Sprite20(T%).SizeX = SpriteMap.SizeX20                       ' Sprite 20's Size

IF Sprite20(T%).SizeX = 42 THEN Episode = 1
IF Sprite20(T%).SizeX = 133 THEN Episode = 2
IF Sprite20(T%).SizeX = 95 THEN Episode = 3

NEXT

CLOSE #1


' Start positions

HandyX = Sprite1(1).X                                   ' Handyman's X
HandyY = Sprite1(1).Y                                   ' Handyman's Y

BallX = Sprite2(1).X                                    ' Ball's X
BallY = Sprite2(1).Y                                    ' Ball's Y

HandyDirection = RIGHT                                  ' Direction = Right
BallDirection = RIGHT                                   ' Direction = Right

IF HandyLives > 0 THEN HandyEnergy = 1000       ' HandyEnergy from start / 10


IF BallLives > 0 THEN BallEnergy = 1000         ' Ball energy / 10


EndTheLevel = FALSE                                     ' Don't end the level

BackGroundX = 0                                         ' Start at ziro

FOR EnemyNumber = 1 TO 4
Enemy1(EnemyNumber).Finish = FALSE                      ' Don't kill - yet
Enemy1(EnemyNumber).Direction = RIGHT
NEXT

FOR EnemyNumber = 1 TO 4
Enemy2(EnemyNumber).Finish = FALSE                      ' Don't kill - yet
Enemy2(EnemyNumber).Direction = RIGHT
NEXT




END SUB

