'----------------------------------------------------------------------------
' DIRECTQB.BI
'   Include file for the DirectQB library version 1.6
'   by Angelo Mottola - Enhanced Creations 1998-99
'
' This file contains constants and function declarations used by the library
' Always include this file into your own programs!
'
' Include file created on 10-02-1998 by the DirectQB Library Manager v1.2
' Run DQBMAN again to modify your DirectQB module settings
'
'  Read DIRECTQB.DOC for detailed informations on how to use the library
'----------------------------------------------------------------------------

'$DYNAMIC
DEFINT A-Z

' Procedures from MAIN.OBJ:
DECLARE FUNCTION DQBinit% (BYVAL NumLayers%, BYVAL NumSounds%, BYVAL MemSize%)
DECLARE FUNCTION DQBver% ()
DECLARE FUNCTION DQBid$ ()
DECLARE FUNCTION DQBmapLayer% (BYVAL Layer%)
DECLARE SUB DQBclose ()
DECLARE SUB DQBpeek (BYVAL DataSeg%, BYVAL DataOff%, BYVAL Offset&, BYVAL Length%)
DECLARE SUB DQBpoke (BYVAL DataSeg%, BYVAL DataOff%, BYVAL Offset&, BYVAL Length%)
DECLARE SUB DQBsort (BYVAL ArraySeg%, BYVAL ArrayOff%, BYVAL NumRecords%, BYVAL RecordLen%, BYVAL IndexOff%)
DECLARE FUNCTION DQBangle% (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
DECLARE SUB DQBinitVGA ()
DECLARE SUB DQBinitText ()
DECLARE FUNCTION DQBsetBaseLayer% (BYVAL Layer%)
DECLARE SUB DQBcopyLayer (BYVAL SourceLayer%, BYVAL DestLayer%)
DECLARE SUB DQBclearLayer (BYVAL Layer%)
DECLARE SUB DQBwait (BYVAL Times%)
DECLARE SUB DQBsetFrameRate (BYVAL FPS%)
DECLARE FUNCTION DQBframeReady% ()
DECLARE FUNCTION DQBerror$ ()

' Procedures from DRAW.OBJ:
DECLARE SUB DQBcopyTransLayer (BYVAL SourceLayer%, BYVAL DestLayer%)
DECLARE SUB DQBcopyHitLayer (BYVAL SourceLayer%, BYVAL DestLayer%, BYVAL Col%)
DECLARE SUB DQBpset (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL Col%)
DECLARE FUNCTION DQBpoint% (BYVAL Layer%, BYVAL x%, BYVAL y%)
DECLARE SUB DQBline (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Col%)
DECLARE SUB DQBgline (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Col1%, BYVAL Col2%)
DECLARE SUB DQBellipse (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL rx%, BYVAL ry%, BYVAL Col%)
DECLARE SUB DQBbox (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Col%)
DECLARE SUB DQBboxf (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Col%)
DECLARE SUB DQBpaint (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL Col%)
DECLARE SUB DQBscroll (BYVAL Layer%, BYVAL dx%, BYVAL dy%)
DECLARE SUB DQBscrollArea (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Direction%)
DECLARE SUB DQBsetTransPut ()
DECLARE SUB DQBsetSolidPut ()
DECLARE SUB DQBget (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL BufSeg%, BYVAL BufOff%)
DECLARE SUB DQBput (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%)

' Procedures from IMAGE.OBJ:
DECLARE FUNCTION DQBloadImage% (Layer%, x%, y%, FileName$, Pal$, imgWidth%, imgHeight%)
DECLARE FUNCTION DQBsaveImage% (Layer%, x1%, y1%, x2%, y2%, FileName$, Pal$, Format%)
DECLARE FUNCTION DQBplayFLI% (FileName$, BufLayer%, KeyStop%, LoopFlag%)
DECLARE FUNCTION DQBopenFLI% (FileName$, Frames%, Speed%)
DECLARE SUB DQBplayFLIstep (BYVAL Layer%)
DECLARE SUB DQBcloseFLI ()

' Procedures from SPRITE.OBJ:
DECLARE FUNCTION DQBsize% (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
DECLARE SUB DQBsetClipBox (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
DECLARE SUB DQBfPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%)
DECLARE SUB DQBsPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%, BYVAL NewWidth%, BYVAL NewHeight%)
DECLARE SUB DQBrPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%, BYVAL Angle%, BYVAL Zoom%)
DECLARE SUB DQBxPut (BYVAL SourceLayer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL DestLayer%, BYVAL x%, BYVAL y%)
DECLARE SUB DQBmPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%, BYVAL Flip%)
DECLARE SUB DQBhPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%, BYVAL Col%)
DECLARE SUB DQBtPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%, BYVAL BitMode%)
DECLARE SUB DQBputOver (BYVAL BackSeg%, BYVAL BackOff%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%)
DECLARE SUB DQBsetCollideMethod (BYVAL Method%)
DECLARE FUNCTION DQBcollide% (BYVAL x1%, BYVAL y1%, BYVAL Seg1%, BYVAL Off1%, BYVAL x2%, BYVAL y2%, BYVAL Seg2%, BYVAL Off2%)
DECLARE FUNCTION DQBcollideOnLayer% (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL SpriteSeg%, BYVAL SpriteOff%)

' Procedures from BIT.OBJ:
DECLARE FUNCTION DQBsetBit% (BYVAL Value%, BYVAL BIT%)
DECLARE FUNCTION DQBresetBit% (BYVAL Value%, BYVAL BIT%)
DECLARE FUNCTION DQBreadBit% (BYVAL Value%, BYVAL BIT%)
DECLARE FUNCTION DQBtoggleBit% (BYVAL Value%, BYVAL BIT%)
DECLARE FUNCTION DQBshiftLeft% (BYVAL Value%, BYVAL nBits%)
DECLARE FUNCTION DQBshiftRight% (BYVAL Value%, BYVAL nBits%)

' Procedures from PALETTE.OBJ:
DECLARE SUB DQBsetCol (BYVAL ColorIndex%, BYVAL Red%, BYVAL Green%, BYVAL Blue%)
DECLARE SUB DQBgetCol (BYVAL ColorIndex%, Red%, Green%, Blue%)
DECLARE FUNCTION DQBfindCol% (BYVAL Red%, BYVAL Green%, BYVAL Blue%)
DECLARE FUNCTION DQBfindPalCol% (Pal$, Red%, Green%, Blue%)
DECLARE SUB DQBsetPal (Pal$)
DECLARE SUB DQBgetPal (Pal$)
DECLARE SUB DQBfadeIn (Pal$)
DECLARE SUB DQBfadeStepIn (Pal$)
DECLARE SUB DQBfadeTo (BYVAL Red%, BYVAL Green%, BYVAL Blue%)
DECLARE SUB DQBfadeStepTo (BYVAL Red%, BYVAL Green%, BYVAL Blue%)
DECLARE SUB DQBpalOff ()
DECLARE SUB DQBpalRotate (BYVAL FirstCol%, BYVAL LastCol%, BYVAL RotDir%)

' Procedures from FONT.OBJ:
DECLARE SUB DQBprint (Layer%, Text$, x%, y%, Col%)
DECLARE SUB DQBprints (Layer%, Text$, x%, y%, Col%, Style%)
DECLARE FUNCTION DQBlen% (Text$)
DECLARE SUB DQBsetBIOSfont ()
DECLARE FUNCTION DQBloadFont% (FileName$)
DECLARE SUB DQBsetFont (Font$)
DECLARE SUB DQBsetTextStyle (BYVAL Style%)
DECLARE SUB DQBsetTextBackCol (BYVAL Col%)
DECLARE SUB DQBsetTextSpacing (BYVAL Spacing%)
DECLARE SUB DQBsetTextBMap (BYVAL BMap%)
DECLARE SUB DQBsetFontTexture (BYVAL TextSeg%, BYVAL TextOff%)

' Procedures from DISK.OBJ:
DECLARE FUNCTION DQBdir$ (Mask$, Attributes%)
DECLARE FUNCTION DQBdrive$ ()
DECLARE FUNCTION DQBpath$ ()
DECLARE FUNCTION DQBnumDrives% ()
DECLARE SUB DQBsetDrive (NewDrive$)
DECLARE FUNCTION DQBchDir (NewDir$)

' Procedures from BLENDING.OBJ:
DECLARE SUB DQBfilterBox (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL Col%, BYVAL BMap%)
DECLARE SUB DQBbPut (BYVAL Layer%, BYVAL x%, BYVAL y%, BYVAL BufSeg%, BYVAL BufOff%, BYVAL BMap%)
DECLARE SUB DQBcopyBlendLayer (BYVAL SourceLayer%, BYVAL DestLayer%, BYVAL BMap%)
DECLARE FUNCTION DQBcreateBMap% (BYVAL BMap%, BYVAL FirstCol%, BYVAL LastCol%)
DECLARE FUNCTION DQBloadBMap% (BMap%, FileName$)
DECLARE FUNCTION DQBsaveBMap% (BMap%, FileName$)
DECLARE SUB DQBsetBMap (BYVAL BMap%, BYVAL ForeCol%, BYVAL BackCol%, BYVAL NewCol%)
DECLARE FUNCTION DQBgetBMap% (BYVAL BMap%, BYVAL ForeCol%, BYVAL BackCol%)

' Procedures from KEYBOARD.OBJ:
DECLARE SUB DQBinstallKeyboard ()
DECLARE SUB DQBremoveKeyboard ()
DECLARE FUNCTION DQBkey% (BYVAL ScanCode%)
DECLARE FUNCTION DQBreadKey% ()
DECLARE SUB DQBwaitKey (BYVAL ScanCode%)
DECLARE FUNCTION DQBasc% (BYVAL ScanCode%, BYVAL ShiftFlag%)
DECLARE FUNCTION DQBinkey$ ()

' Procedures from JOYSTICK.OBJ:
DECLARE FUNCTION DQBjoyDetected% (BYVAL JoyNum%)
DECLARE FUNCTION DQBjoyX% (BYVAL JoyNum%)
DECLARE FUNCTION DQBjoyY% (BYVAL JoyNum%)
DECLARE FUNCTION DQBjoyMove% (BYVAL JoyNum%, BYVAL Direction%)
DECLARE FUNCTION DQBjoyFire% (BYVAL JoyNum%, BYVAL Button%)
DECLARE SUB DQBpollJoy (BYVAL JoyNum%)
DECLARE SUB DQBresetJoy ()
DECLARE SUB DQBsetJoySens (BYVAL Sens%)

' Procedures from MOUSE.OBJ:
DECLARE FUNCTION DQBmouseDetected% ()
DECLARE FUNCTION DQBmouseX% ()
DECLARE FUNCTION DQBmouseY% ()
DECLARE FUNCTION DQBmouseLB% ()
DECLARE FUNCTION DQBmouseRB% ()
DECLARE SUB DQBsetMousePos (BYVAL x%, BYVAL y%)
DECLARE SUB DQBmouseShow ()
DECLARE SUB DQBmouseHide ()
DECLARE SUB DQBsetMouseRange (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
DECLARE SUB DQBsetMouseShape (hotX%, hotY%, Shape$)
DECLARE SUB DQBsetMouseSpeed (BYVAL HorSpeed%, BYVAL VerSpeed%)
DECLARE SUB DQBresetMouse ()

' Procedures from SOUND.OBJ:
DECLARE FUNCTION DQBinstallSB% (BYVAL VolActive%, BYVAL Channels%, BYVAL Freq%, BYVAL BaseAddr%, BYVAL IRQ%, BYVAL DMA%)
DECLARE FUNCTION DQBloadSound% (Slot%, FileName$)
DECLARE FUNCTION DQBloadRawSound% (Slot%, FileName$, Offset&, Length&)
DECLARE FUNCTION DQBinUse% (BYVAL Voice%)
DECLARE SUB DQBplaySound (BYVAL SoundNum%, BYVAL Voice%, BYVAL Freq%, BYVAL LoopFlag%)
DECLARE SUB DQBsetVoiceVol (BYVAL Voice%, BYVAL NewVol%)
DECLARE SUB DQBpauseSound ()
DECLARE SUB DQBresumeSound ()
DECLARE SUB DQBstopVoice (BYVAL Voice%)
DECLARE SUB DQBremoveSB ()
DECLARE SUB DQBsetVolume (BYVAL Volume%)

' Procedures from 3D.OBJ:
DECLARE SUB DQBtri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL x3%, BYVAL y3%, BYVAL Col%)
DECLARE SUB DQBbtri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL x3%, BYVAL y3%, BYVAL Col%, BYVAL BMap%)
DECLARE SUB DQBgtri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL c1%, BYVAL x2%, BYVAL y2%, BYVAL c2%, BYVAL x3%, BYVAL y3%, BYVAL c3%)
DECLARE SUB DQBbgtri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL c1%, BYVAL x2%, BYVAL y2%, BYVAL c2%, BYVAL x3%, BYVAL y3%, BYVAL c3%, BYVAL BMap%)
DECLARE SUB DQBttri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL x3%, BYVAL y3%, BYVAL u1%, BYVAL v1%, BYVAL u2%, BYVAL v2%, BYVAL u3%, BYVAL v3%, BYVAL TextureSeg%, BYVAL TextureOff%)
DECLARE SUB DQBbttri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL x3%, BYVAL y3%, BYVAL u1%, BYVAL v1%, BYVAL u2%, BYVAL v2%, BYVAL u3%, BYVAL v3%, BYVAL TextureSeg%, BYVAL TextureOff%, BYVAL BMap%)
DECLARE SUB DQBfttri (BYVAL Layer%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL x3%, BYVAL y3%, BYVAL u1%, BYVAL v1%, BYVAL u2%, BYVAL v2%, BYVAL u3%, BYVAL v3%, BYVAL TextureSeg%, BYVAL TextureOff%)
DECLARE SUB DQBsetTextureSize (BYVAL Size%)

' Procedures from DATAFILE.OBJ:
DECLARE FUNCTION DQBopenDataFile (FileName$, Password$)
DECLARE FUNCTION DQBunpackFont (PacketID$, Font$)
DECLARE FUNCTION DQBunpackImage (PacketID$, Layer%, x%, y%)
DECLARE FUNCTION DQBunpackSprite (PacketID$, SpriteSeg%, SpriteOff%)
DECLARE FUNCTION DQBunpackSound (PacketID$, Slot%)
DECLARE FUNCTION DQBunpackPal (PacketID$, Pal$)
DECLARE FUNCTION DQBunpackBMap (PacketID$, BMap%)
DECLARE FUNCTION DQBunpackCursor (PacketID$, Cursor$)
DECLARE FUNCTION DQBunpackUser (PacketID$, DataSeg%, DataOff%)
DECLARE SUB DQBcloseDataFile ()

' The Adventures SUBs
DECLARE SUB InstallProgram ()                   ' Misc SUBs
DECLARE SUB SetValues ()
DECLARE SUB EndProgram ()
DECLARE SUB LoadGraphics ()
DECLARE SUB LevelValues ()
DECLARE SUB DisplayPlayerInformation ()
DECLARE SUB Help ()
DECLARE SUB Screenshot ()
DECLARE SUB Intro ()
DECLARE SUB Menu ()
DECLARE SUB Credits ()
DECLARE SUB StartValues ()
DECLARE SUB EnterKey ()
DECLARE SUB EscKey ()
DECLARE SUB GameOver ()
DECLARE SUB HowManyPlayers ()

DECLARE SUB ControlHandyMan ()                  ' Handyman SUBs
DECLARE SUB HandyGravity ()
DECLARE SUB HandyCheckLeft ()
DECLARE SUB HandyCheckRight ()
DECLARE SUB HandyCheckUp ()

DECLARE SUB ControlBall ()                      ' Ball SUBs
DECLARE SUB BallCheckUp ()
DECLARE SUB BallCheckRight ()
DECLARE SUB BallGravity ()
DECLARE SUB BallCheckLeft ()

DECLARE SUB Enemy1Animation ()
DECLARE SUB Enemy2Animation ()

DECLARE SUB NextLevel ()                        ' Level SUBs
DECLARE SUB SelectEpisodeToPlay ()
DECLARE SUB CompletedEpisode ()
DECLARE SUB Save ()
DECLARE SUB Load ()
DECLARE SUB DisplayMap ()
DECLARE SUB ValuesForALevel ()
DECLARE SUB DrawBGLevel ()
DECLARE SUB LoadEpisodeGraphics ()
DECLARE SUB LoadEpisode ()



' Library constants:
CONST FALSE = 0, TRUE = NOT FALSE, VIDEO = 0
CONST B0 = &H8000, B1 = &H8001, B2 = &H8002, B3 = &H8003, B4 = &H8004
CONST B5 = &H8005, B6 = &H8006, B7 = &H8007, B8 = &H8008, B9 = &H8009
CONST BSV = 0, BMP = 1, PCX = 2
CONST HOR = 1, VER = 2, BOX = 0, PIXEL = 1, BIT.AND = 1, BIT.OR = 2, BIT.XOR = 3
CONST FORWARD = 0, BACKWARD = 1
CONST CENTERED = &H8000, NONE = 0, SOLID = &H1, BOLD = &H2, ITALIC = &H4
CONST UNDERLINED = &H8, BLENDED = &H10, TEXTURED = &H20
CONST ATTRIB.R = &H1, ATTRIB.H = &H2, ATTRIB.S = &H4
CONST ATTRIB.L = &H8, ATTRIB.D = &H10, ATTRIB.A = &H20
CONST KEYANY = -1, KEYESC = 1, KEYENTER = 28, KEYSPACE = 57
CONST KEYUP = 72, KEYDOWN = 80, KEYLEFT = 75, KEYRIGHT = 77
CONST UP = 0, DOWN = 1, LEFT = 2, RIGHT = 3
CONST JOY1 = 0, JOY2 = 1, GAMEPAD = 2
CONST BUTA = 0, BUTB = 1, BUTC = 2, BUTD = 3
CONST AUTO = -1, ONCE = 0, LOOPED = 1

CONST STAND = 0, WALK = 1, JUMP = 2, FALL = 3, DUCK = 4
CONST TheAdventuresVersion = "1.0"
CONST MoviesPath$ = "Movies/"
CONST GraphicsPath$ = "Graphics/"
CONST SoundsPath$ = "Sounds/"
CONST MusicPath$ = "Music/"
CONST DatasPath$ = "Datas/"


DIM SHARED Pal AS STRING * 768                  ' String holding the palette
DIM SHARED Episode AS INTEGER
DIM SHARED Level AS INTEGER                     ' Which level?
DIM SHARED Levelname AS STRING
DIM SHARED UserLevel AS INTEGER
DIM SHARED UserLevelName AS STRING
DIM SHARED Episode1Completed AS INTEGER
DIM SHARED Episode2Completed AS INTEGER
DIM SHARED Count AS INTEGER
DIM SHARED FPS AS INTEGER
DIM SHARED GameIsOver AS INTEGER
DIM SHARED BackGroundX AS INTEGER               ' Background X
DIM SHARED EndTheLevel AS INTEGER               ' End the level?
DIM SHARED Players AS INTEGER                   ' How many players?
DIM SHARED OptionSound AS INTEGER
DIM SHARED OptionMusic AS INTEGER
DIM SHARED TextTime AS INTEGER
DIM SHARED TextY AS INTEGER
DIM SHARED SelectEpisode AS INTEGER
DIM SHARED FileName AS STRING
DIM SHARED EndSub AS INTEGER
DIM SHARED GetNameOfLoad AS INTEGER
DIM SHARED Characters AS INTEGER                ' Filename
DIM SHARED Character AS STRING
DIM SHARED LevelCheat AS INTEGER
DIM SHARED GotoMenu AS INTEGER
DIM SHARED Cheat AS INTEGER
DIM SHARED ShowIntro AS INTEGER
DIM SHARED WRT AS INTEGER


DIM SHARED ShouldHandyFly AS INTEGER
DIM SHARED UpHill AS INTEGER
DIM SHARED ShouldBallFly AS INTEGER
DIM SHARED UpHillBall AS INTEGER
DIM SHARED BGScrollR1 AS INTEGER
DIM SHARED BGScrollR2 AS INTEGER
DIM SHARED BGScrollL1 AS INTEGER
DIM SHARED BGScrollL2 AS INTEGER


DIM SHARED MenuContent AS INTEGER               ' Menu stuff
DIM SHARED MenuStart AS INTEGER
DIM SHARED MenuOptions AS INTEGER
DIM SHARED MenuLoad AS INTEGER

DIM SHARED FramesNumber AS INTEGER              ' Fli animation
DIM SHARED SpeedFactor AS INTEGER

' Handyman stuff
DIM SHARED HandyX AS INTEGER                    ' X for Handyman
DIM SHARED HandyY AS INTEGER                    ' Y for HandyMan
DIM SHARED HandyGround AS INTEGER               ' Is he tuching the ground
DIM SHARED HandySpringy AS INTEGER              ' Detects springy
DIM SHARED HandyDirection AS INTEGER            ' Direction of Handyman
DIM SHARED HandyAnimation AS INTEGER            ' Which animation
DIM SHARED HandyLeft AS INTEGER                 ' Colour detection
DIM SHARED HandyRight AS INTEGER                ' Colour detection
DIM SHARED HandyUp AS INTEGER                   ' Colour detection
DIM SHARED HandyJump AS INTEGER                 ' Nr pixels to jump with SPC
DIM SHARED HJump AS INTEGER                     ' Nr pixels to jump w.out SPC
DIM SHARED HandyWalk AS INTEGER                 ' Used for Animation Walk
DIM SHARED HWalk AS INTEGER                     ' Used for Animation Walk
DIM SHARED HandyLives AS INTEGER
DIM SHARED HandyEnergy AS INTEGER

' Ball stuff
DIM SHARED BallX AS INTEGER                     ' X for Ball
DIM SHARED BallY AS INTEGER                     ' Y for Ball
DIM SHARED BallGround AS INTEGER                ' Is he tuching the ground
DIM SHARED BallSpringy AS INTEGER               ' Detects springy
DIM SHARED BallDirection AS INTEGER             ' Direction of Ball
DIM SHARED BallAnimation AS INTEGER             ' Which animation
DIM SHARED BallLeft AS INTEGER                  ' Colour detection
DIM SHARED BallRight AS INTEGER                 ' Colour detection
DIM SHARED BallUp AS INTEGER                    ' Colour detection
DIM SHARED BallJump AS INTEGER                  ' Nr pixels to jump with SPC
DIM SHARED BJump AS INTEGER                     ' Nr pixels to jump w.out SPC
DIM SHARED BallWalk AS INTEGER
DIM SHARED BWalk AS INTEGER
DIM SHARED BallLives AS INTEGER
DIM SHARED BallEnergy AS INTEGER



TYPE Enemy
x AS INTEGER
y AS INTEGER
F AS INTEGER
Frame AS INTEGER
Direction AS INTEGER
SizeX AS INTEGER
MaxX AS INTEGER
MinX AS INTEGER
Finish AS INTEGER
END TYPE
DIM SHARED Enemy1(1 TO 15) AS Enemy
DIM SHARED Enemy2(1 TO 15) AS Enemy


TYPE Load
NameOfGame AS STRING * 10
Episode AS INTEGER
Level AS INTEGER
END TYPE
DIM SHARED LoadGame AS Load

TYPE EpisodeLoad
Episode1 AS INTEGER
Episode2 AS INTEGER
Episode3 AS INTEGER
Episode4 AS INTEGER
END TYPE
DIM SHARED EpisodesCompleted AS EpisodeLoad


TYPE Sprite
x AS INTEGER                                    ' Sprite's X
y AS INTEGER                                    ' Sprite's Y
SizeX AS INTEGER                                ' X1 - X2
MinX AS INTEGER                                 ' If the sprite aren't
MaxX AS INTEGER                                 ' moving these will be X
MinY AS INTEGER                                 ' If the sprite aren't
MaxY AS INTEGER                                 ' moving these will be Y
Direction AS INTEGER                            ' Direction
END TYPE
DIM SHARED Sprite1(1 TO 15) AS Sprite
DIM SHARED Sprite2(1 TO 15) AS Sprite
DIM SHARED Sprite3(1 TO 15) AS Sprite
DIM SHARED Sprite4(1 TO 15) AS Sprite
DIM SHARED Sprite5(1 TO 15) AS Sprite
DIM SHARED Sprite6(1 TO 15) AS Sprite
DIM SHARED Sprite7(1 TO 15) AS Sprite
DIM SHARED Sprite8(1 TO 15) AS Sprite
DIM SHARED Sprite9(1 TO 15) AS Sprite
DIM SHARED Sprite10(1 TO 15) AS Sprite
DIM SHARED Sprite11(1 TO 15) AS Sprite
DIM SHARED Sprite12(1 TO 15) AS Sprite
DIM SHARED Sprite13(1 TO 15) AS Sprite
DIM SHARED Sprite14(1 TO 15) AS Sprite
DIM SHARED Sprite15(1 TO 15) AS Sprite
DIM SHARED Sprite16(1 TO 15) AS Sprite
DIM SHARED Sprite17(1 TO 15) AS Sprite
DIM SHARED Sprite18(1 TO 15) AS Sprite
DIM SHARED Sprite19(1 TO 15) AS Sprite
DIM SHARED Sprite20(1 TO 15) AS Sprite


TYPE SpritePositions
x1 AS INTEGER                                   ' Handy's X
y1 AS INTEGER                                   ' Handy's Y
x2 AS INTEGER                                   ' Ball's X
y2 AS INTEGER                                   ' Ball's Y
x3 AS INTEGER                                   ' Springy 1's X
y3 AS INTEGER                                   ' Springy 1's Y
SizeX3 AS INTEGER                               ' Springy 1's Size
X4 AS INTEGER                                   ' Springy 2's X
Y4 AS INTEGER                                   ' Springy 2's Y
SizeX4 AS INTEGER                               ' Springy 2's Size
X5 AS INTEGER                                   ' Enemy 1's X
Y5 AS INTEGER                                   ' Enemy 1's Y
SizeX5 AS INTEGER                               ' Enemy 1's Size
MinX5 AS INTEGER                                ' Enemy 1's Minimum X
MaxX5 AS INTEGER                                ' Enemy 1's Maximum X
X6 AS INTEGER                                   ' Enemy 2's X
Y6 AS INTEGER                                   ' Enemy 2's Y
SizeX6 AS INTEGER                               ' Enemy 2's Size
MinX6 AS INTEGER                                ' Enemy 2's Minimum X
MaxX6 AS INTEGER                                ' Enemy 2's Maximum X
X7 AS INTEGER                                   ' Strawberry's X
Y7 AS INTEGER                                   ' Strawberry's Y
SizeX7 AS INTEGER                               ' Strawberry's Size
X8 AS INTEGER                                   ' Moving Sprite 1's X
Y8 AS INTEGER                                   ' Moving Sprite 1's Y
SizeX8 AS INTEGER                               ' Moving Sprite 1's Size
MinX8 AS INTEGER                                ' Moving Sprite 1's Minimum X
MaxX8 AS INTEGER                                ' Moving Sprite 1's Maximum X
Direction8 AS INTEGER                           ' Moving Sprite 1's Direction
X9 AS INTEGER                                   ' Moving Sprite 2's X
Y9 AS INTEGER                                   ' Moving Sprite 2's Y
SizeX9 AS INTEGER                               ' Moving Sprite 2's Size
MinX9 AS INTEGER                                ' Moving Sprite 2's Minimum X
MaxX9 AS INTEGER                                ' Moving Sprite 2's Maximum X
Direction9 AS INTEGER                           ' Moving Sprite 2's Direction
X10 AS INTEGER                                  ' Moving Sprite 3's X
Y10 AS INTEGER                                  ' Moving Sprite 3's Y
SizeX10 AS INTEGER                              ' Moving Sprite 3's Size
MinY10 AS INTEGER                               ' Moving Sprite 3's Minimum Y
MaxY10 AS INTEGER                               ' Moving Sprite 3's Maximum Y
Direction10 AS INTEGER                          ' Moving Sprite 3's Direction
X11 AS INTEGER                                  ' EndTheLevel's X
Y11 AS INTEGER                                  ' EndTheLevel's Y
SizeX11 AS INTEGER                              ' EndTheLevel's Size
X12 AS INTEGER                                  ' x's X
Y12 AS INTEGER                                  ' x's Y
SizeX12 AS INTEGER                              ' x's Size
X13 AS INTEGER                                  ' Sprite 13's X
Y13 AS INTEGER                                  ' Sprite 13's Y
SizeX13 AS INTEGER                              ' Sprite 13's Size
X14 AS INTEGER                                  ' Sprite 14's X
Y14 AS INTEGER                                  ' Sprite 14's Y
SizeX14 AS INTEGER                              ' Sprite 14's Size
X15 AS INTEGER                                  ' Sprite 15's X
Y15 AS INTEGER                                  ' Sprite 15's Y
SizeX15 AS INTEGER                              ' Sprite 15's Size
X16 AS INTEGER                                  ' Sprite 16's X
Y16 AS INTEGER                                  ' Sprite 16's Y
SizeX16 AS INTEGER                              ' Sprite 16's Size
X17 AS INTEGER                                  ' Sprite 17's X
Y17 AS INTEGER                                  ' Sprite 17's Y
SizeX17 AS INTEGER                              ' Sprite 17's Size
X18 AS INTEGER                                  ' Sprite 18's X
Y18 AS INTEGER                                  ' Sprite 18's Y
SizeX18 AS INTEGER                              ' Sprite 18's Size
X19 AS INTEGER                                  ' Sprite 19's X
Y19 AS INTEGER                                  ' Sprite 19's Y
SizeX19 AS INTEGER                              ' Sprite 19's Size
X20 AS INTEGER                                  ' Sprite 20's X
Y20 AS INTEGER                                  ' Sprite 20's Y
SizeX20 AS INTEGER                              ' Sprite 20's Size
END TYPE
DIM SHARED SpriteMap AS SpritePositions         ' The way of loading levels.


DIM SHARED Sprite1Size AS INTEGER               ' The Handyman
DIM SHARED Sprite2Size AS INTEGER               ' The little Ball
DIM SHARED Sprite3Size AS INTEGER               ' Springy 1
DIM SHARED Sprite4Size AS INTEGER               ' Springy 2
DIM SHARED Sprite5Size AS INTEGER               ' Enemy 1
DIM SHARED Sprite6Size AS INTEGER               ' Enemy 2
DIM SHARED Sprite7Size AS INTEGER               ' Strawbarry
DIM SHARED Sprite8Size AS INTEGER               ' Moving Sprite 1 - Hoz.
DIM SHARED Sprite9Size AS INTEGER               ' Moving Sprite 2 - Hoz.
DIM SHARED Sprite10Size AS INTEGER              ' Moving Sprite 3 - Vec.
DIM SHARED Sprite11Size AS INTEGER              ' End of level
DIM SHARED Sprite12Size AS INTEGER              ' Cross (x)
DIM SHARED Sprite13Size AS INTEGER
DIM SHARED Sprite14Size AS INTEGER
DIM SHARED Sprite15Size AS INTEGER
DIM SHARED Sprite16Size AS INTEGER
DIM SHARED Sprite17Size AS INTEGER
DIM SHARED Sprite18Size AS INTEGER
DIM SHARED Sprite19Size AS INTEGER
DIM SHARED Sprite20Size AS INTEGER

DIM SHARED HandyIconSize AS INTEGER
DIM SHARED BallIconSize AS INTEGER
DIM SHARED EpisodePicSize AS INTEGER

