' Schiffspiel

' (c) 1999 by Andreas Meile, CH-8242 Hofen SH

DECLARE FUNCTION FuehrNull$ (w%, l%)

' Auszug aus BMP_LIB
DECLARE SUB LadeBild (dn$, f%(), ind%)
DECLARE SUB LadePalette (dn$, p&(), ind%, mo%)
CONST PalVGA% = 2   ' fr SCREEN 11/12/13

DECLARE SUB FuehreLeben (i%)
DECLARE SUB FuehrePunkte (i%)

' Liste mit Kisten
TYPE Kiste
  kx AS INTEGER
  yt0 AS SINGLE
  ly AS INTEGER
  gesc AS SINGLE
END TYPE

DIM kl(99) AS Kiste
' kx   : X-Koordinate, wo eine Kiste gerade herunterfllt
' ly   : Y-Koordinate, wo eine Kiste zuletzt gezeichnet wurde
' yt0  : Zeitpunkt, wann die Kiste oben vom Bildschirmrand heruntergefallen
'        ist
' gesc : Fallgeschwindigkeit in Pixel/Sekunde

RANDOMIZE TIMER

' Bilder und Shapes mit Farbpaletten laden
PRINT "Einen Moment, lade Bilder..."
DIM titel%(32001), titpal&(255)
LadeBild "titelbld", titel%(), LBOUND(titel%)
LadePalette "titelbld", titpal&(), LBOUND(titpal&), PalVGA%

DIM schiff%(2761), Kiste%(1302), pa&(15)
LadeBild "schiff", schiff%(), LBOUND(schiff%)
LadeBild "kiste", Kiste%(), LBOUND(Kiste%)
LadePalette "schiff", pa&(), LBOUND(pa&), PalVGA%

MaxPunkte% = 0
SoundEin% = -1

' Hauptprogramm: Hbscher :-) Titel anzeigen
DO
  SCREEN 13
  PALETTE USING titpal&
  PUT (0, 0), titel%, PSET
  t$ = INPUT$(1)
  SELECT CASE t$
  CASE " "
    GOSUB Spiel
    t$ = ""
  CASE "s", "S"
    SoundEin% = NOT SoundEin%
  END SELECT
LOOP UNTIL t$ = CHR$(27)

SCREEN 0
WIDTH 80, 25
END

Spiel:
SCREEN 12
PALETTE USING pa&

' Punkteanzeige
COLOR 3
PRINT " Aldis"
PRINT "Schiff-"
PRINT " spiel"
PRINT
COLOR 12
PRINT " Leben"
PRINT
PRINT " Punkte"
PRINT
PRINT " Rekord"
COLOR 13
PRINT " "; FuehrNull$(MaxPunkte%, 5)

DIM SHARED Leben%, Punkte%

Leben% = 5
Punkte% = 0
FuehrePunkte 0
FuehreLeben 0

xSchiff% = 260
PUT (xSchiff%, 415), schiff%

' Kisten per Zufallsgenerator-Zeitsteuerung herunterwerfen
AnzKisten% = 0  ' zu Beginn leerer Bildschirm
tBas! = TIMER + 100!
tna! = -100!    ' Zeitpunkt fr nchsten Kistenabwurf
Drinbleib% = -1
WHILE Leben% > 0 AND Drinbleib%
  t! = TIMER - tBas!
  IF t! > tna! THEN
    ' Neue Kiste abwerfen
    kl(AnzKisten%).kx = 76 + CINT(INT(468! * RND))
    kl(AnzKisten%).yt0 = tna!
    kl(AnzKisten%).gesc = 10! + 15! * RND
    kl(AnzKisten%).ly = CINT(kl(AnzKisten%).gesc * (t! - tna!))
    PUT (kl(AnzKisten%).kx, kl(AnzKisten%).ly), Kiste%
    IF SoundEin% THEN
      FOR i% = 700 TO 1000 STEP 5
        SOUND i%, .05
      NEXT i%
    END IF
    tna! = tna! + 2! + 3! * RND ' irgend eine zufllige Zeit bis zur nchsten
    AnzKisten% = AnzKisten% + 1
  END IF
  ' Alle Kisten bewegen
  i% = 0
  WHILE i% < AnzKisten%
    y% = CINT(kl(i%).gesc * (t! - kl(i%).yt0))
    IF y% >= 360 AND y% <= 410 AND kl(i%).kx >= xSchiff% + 10 AND kl(i%).kx <= xSchiff% + 91 THEN
      ' Erfolgreich geschnappt
      FuehrePunkte 1
      IF SoundEin% THEN
        FOR j% = 1 TO 3
          FOR f% = 260 TO 440 STEP 90
            SOUND f%, .5
          NEXT f%
        NEXT j%
      END IF
      PUT (kl(i%).kx, kl(i%).ly), Kiste%
      ' Kiste aus Liste wieder entfernen: Dazu wird einfach die Lcke
      ' mit dem Eintrag am Ende aufgefllt, damit das Array wieder
      ' lckenlos zusammenhngt
      AnzKisten% = AnzKisten% - 1
      kl(i%) = kl(AnzKisten%)
    ELSEIF y% <> kl(i%).ly THEN
      ' Position vom Schiff prfen: Der Spieler muss sich mit seinem
      ' Schiff darunterbefinden, damit die Kiste abgefangen wird und
      ' ein Punkt gibt
      IF y% > 415 THEN
        ' Kiste fllt ins Wasser! :-(
        FuehreLeben -1
        IF SoundEin% THEN
          FOR j% = 20 TO 12 STEP -1
            FOR f% = 50 * j% TO 25 * j% STEP -j%
              SOUND f%, .1
            NEXT f%
          NEXT j%
        END IF
        PUT (kl(i%).kx, kl(i%).ly), Kiste%
        ' Verlorene Kiste ebenfalls entfernen
        AnzKisten% = AnzKisten% - 1
        kl(i%) = kl(AnzKisten%)
      ELSE
        ' Ganz normale Bewegung
        PUT (kl(i%).kx, kl(i%).ly), Kiste%
        PUT (kl(i%).kx, y%), Kiste%
        kl(i%).ly = y%
        i% = i% + 1
      END IF
    ELSE
      i% = i% + 1
    END IF
  WEND
  ' Tastatur vom Spieler abfragen
  t$ = INKEY$
  SELECT CASE t$
  CASE CHR$(0) + "K"
    xn% = xSchiff% - 15
    IF xn% < 61 THEN
      xn% = 61
    END IF
  CASE CHR$(0) + "M"
    xn% = xSchiff% + 15
    IF xn% > 458 THEN
      xn% = 458
    END IF
  CASE CHR$(27)
    Drinbleib% = 0
    xn% = xSchiff%
  CASE " ", "p", "P"
    t1! = TIMER
    LOCATE 12, 2
    COLOR 12
    PRINT "Pause"
    d$ = INPUT$(1)
    LOCATE 12, 2
    PRINT SPACE$(5)
    t2! = TIMER - t1!
    tBas! = tBas! + t2!
  CASE "s", "S"
    SoundEin% = NOT SoundEin%
  CASE ELSE
    xn% = xSchiff%
  END SELECT
  IF xn% <> xSchiff% THEN
    PUT (xSchiff%, 415), schiff%
    PUT (xn%, 415), schiff%
    xSchiff% = xn%
  END IF
WEND
IF Leben% = 0 THEN
  LOCATE 13, 34
  COLOR 13
  PRINT "Game over! :-("
  IF SoundEin% THEN
    PLAY "t200o2l4gl8f#l4g>l8d#l4d.c.<b.>l4cl4c"
  END IF
  d$ = INPUT$(1)
END IF
' Hiscore nachfhren
IF Punkte% > MaxPunkte% THEN
  MaxPunkte% = Punkte%
END IF
RETURN

SUB FuehreLeben (i%)
  Leben% = Leben% + i%
  COLOR 13
  LOCATE 6, 2
  PRINT FuehrNull$(Leben%, 5)
END SUB

SUB FuehrePunkte (i%)
  Punkte% = Punkte% + i%
  COLOR 13
  LOCATE 8, 2
  PRINT FuehrNull$(Punkte%, 5);
END SUB

FUNCTION FuehrNull$ (w%, l%)
  h$ = MID$(STR$(w%), 2)
  FuehrNull$ = STRING$(l% - LEN(h$), "0") + h$
END FUNCTION

SUB LadeBild (dn$, f%(), ind%)
  OPEN dn$ + ".BMP" FOR INPUT AS 1
  CLOSE 1
  OPEN dn$ + ".BMP" FOR BINARY AS 1
  k$ = INPUT$(2, 1)
  IF k$ <> "BM" THEN
    PRINT "Kein gltiges Windows Bitmap Bild!"
    ERROR 5
  END IF
  SEEK 1, 11&
  basOf& = CVL(INPUT$(4, 1)) + 1&  ' ab hier beginnen die Nutzdaten
  SEEK 1, 19&
  xb& = CVL(INPUT$(4, 1))  ' Bildgrsse
  yb& = CVL(INPUT$(4, 1))
  anzBpl% = CVI(INPUT$(2, 1))
  IF anzBpl% <> 1 THEN
    PRINT "Bildformat einer knftigen Windowsversion"
    ERROR 5
  END IF
  bpp% = CVI(INPUT$(2, 1))
  komp& = CVL(INPUT$(4, 1))
  IF komp& <> 0& THEN
    PRINT "Komprimierung nicht untersttzt"
    ERROR 5
  END IF
  ' Start der Verarbeitung
  br& = (xb& * CLNG(bpp%) + 31& AND -32&) \ 8&
  IF bpp% = 8 THEN
    f%(ind%) = 8 * CINT(xb&)
  ELSE
    f%(ind%) = CINT(xb&)
  END IF
  f%(ind% + 1) = CINT(yb&)
  ind% = ind% + 2
  SELECT CASE bpp%
  CASE 1, 8
    IF bpp% = 1 THEN
      b% = CINT((xb& + 7&) \ 8&)
    ELSE
      b% = CINT(xb&)
    END IF
    Pu$ = ""
    FOR y& = basOf& + br& * (yb& - 1&) TO basOf& STEP -br&
      SEEK 1, y&
      FOR x% = 1 TO b%
        Pu$ = Pu$ + INPUT$(1, 1)
        IF LEN(Pu$) = 2 THEN
          f%(ind%) = CVI(Pu$)
          ind% = ind% + 1
          Pu$ = ""
        END IF
      NEXT x%
    NEXT y&
    IF Pu$ <> "" THEN
      f%(ind%) = CVI(Pu$ + " ")
      ind% = ind% + 1
    END IF
  CASE 4
    DIM h%(3)
    FOR i% = 0 TO 3
      h%(i%) = 0
    NEXT i%
    b% = CINT(br&) \ 4
    pu1$ = SPACE$(4 * b%)
    FOR y& = basOf& + br& * (yb& - 1&) TO basOf& STEP -br&
      SEEK 1, y&
      FOR x1% = 1 TO b%
        FOR x2% = 1 TO 4
          z% = ASC(INPUT$(1, 1))
          FOR x3% = 0 TO 3
            h%(x3%) = 4 * h%(x3%) + (z% AND 1) + (z% AND 16) \ 8
            z% = z% \ 2
          NEXT x3%
        NEXT x2%
        FOR i% = 0 TO 3
          MID$(pu1$, x1% + b% * i%) = CHR$(h%(i%))
          h%(i%) = 0
        NEXT i%
      NEXT x1%
      FOR i% = 1 TO LEN(pu1$) STEP 2
        f%(ind%) = CVI(MID$(pu1$, i%, 2))
        ind% = ind% + 1
      NEXT i%
    NEXT y&
  CASE 24
    PRINT "Echtfarb (True Color) nicht mglich"
    ERROR 5
  CASE ELSE
    PRINT "Unbekannte Bildtiefe"
    ERROR 5
  END SELECT
  CLOSE 1
END SUB

SUB LadePalette (dn$, p&(), ind%, mo%)
  OPEN dn$ + ".BMP" FOR INPUT AS 1
  CLOSE 1
  OPEN dn$ + ".BMP" FOR BINARY AS 1
  k$ = INPUT$(2, 1)
  IF k$ <> "BM" THEN
    PRINT "Kein gltiges Windows Bitmap Bild!"
    ERROR 5
  END IF
  SEEK 1, 15&
  palOf& = CVL(INPUT$(4, 1)) + 15&   ' ab hier beginnen die Farbeintrge
  SEEK 1, 27&
  anzBpl% = CVI(INPUT$(2, 1))
  IF anzBpl% <> 1 THEN
    PRINT "Bildformat einer knftigen Windowsversion"
    ERROR 5
  END IF
  bpp% = CVI(INPUT$(2, 1))
  IF bpp% > 12 THEN
    PRINT "Echtfarb verwendet keine Farbpalette"
    ERROR 5
  END IF
  ' Start der Verarbeitung
  aF% = 1
  FOR i% = 1 TO bpp%
    aF% = aF% * 2
  NEXT i%
  IF mo% = PalVlf% THEN
    ' verlustfreier Spezialmodus, der keinem SCREEN gehrt
    ' liest gesamter RGBQUAD ein
    SEEK 1, palOf&
    FOR i% = 1 TO aF&
      p&(ind%) = CVL(INPUT$(4, 1))
      ind% = ind% + 1
    NEXT i%
  ELSE
    FOR i% = 1 TO aF%
      SEEK 1, palOf&
      b% = ASC(INPUT$(1, 1))
      g% = ASC(INPUT$(1, 1))
      r% = ASC(INPUT$(1, 1))
      SELECT CASE mo%
      CASE PalCGA%  ' CGA-Palette von SCREEN 1/2/7/8
        Cga% = (r% AND 128) \ 32 + (g% AND 128) \ 64 + (b% AND 128) \ 128
        ' Selektion, ob hellerer oder dnklerer Farbton darstellen
        h% = (r% AND 127) + (g% AND 127) + (b% AND 127) - 192
        p&(ind%) = CLNG(Cga% - 8 * (h% > 0))
        IF p&(ind%) = 4 AND g% > 80 THEN
          p&(ind%) = 6   ' Spezialfall Orange
        END IF
      CASE PalEGA%  ' EGA-Palette von SCREEN 0/9
        p&(ind%) = CLNG((r% AND 64) \ 2 + (r% AND 128) \ 32 + (g% AND 64) \ 4 + (g% AND 128) \ 64 + (b% AND 64) \ 8 + (b% AND 128) \ 128)
      CASE PalVGA%  ' VGA-Palette von SCREEN 11/12/13
        p&(ind%) = CLNG(r% AND 252) \ 4& + CLNG(g% AND 252) * 64& + CLNG(b% AND 252) * 16384&
      CASE ELSE
        ERROR 5
      END SELECT
      palOf& = palOf& + 4&
      ind% = ind% + 1
    NEXT i%
  END IF
  CLOSE 1
END SUB

