'$DYNAMIC

DECLARE SUB LoadFont ()
DECLARE SUB PUTTEXT (Text$, C, XPos, YPos, Adj)
DECLARE SUB DRAWCHAR (WhichOne$, Position%, XPos%, YPos%)
DECLARE SUB Exceptional (xloc, yloc, block%)
DECLARE SUB Itemize (xloc, yloc, block$)
DECLARE SUB RGB (palval%, redval%, grnval%, bluval%)
DECLARE SUB pausit (ticker%)

TYPE Stats
	Charname AS STRING * 7
	Level AS INTEGER
	Experience AS INTEGER
	Health AS INTEGER
	MaxHealth AS INTEGER
	Magic AS INTEGER
	MaxMagic AS INTEGER
	Strength AS INTEGER
	Intel AS INTEGER
	Agility AS INTEGER
	Defense AS INTEGER
	Weapon AS STRING * 16
	Armor AS STRING * 16
END TYPE
TYPE Magical
	SpellName AS STRING * 16
	HitWho AS INTEGER
	MagPoints AS INTEGER
END TYPE
DIM BoxOpened(200) AS INTEGER
DIM LevUp(30) AS LONG
DIM SpellInfo(0 TO 20) AS Magical
DIM Action$(1 TO 4)
DIM EnAction$(1 TO 5)
DIM EnemHealth(1 TO 5) AS INTEGER
DIM Spells(1 TO 4, 1 TO 20) AS INTEGER
DIM Invent$(1 TO 100)
DIM Items(1 TO 100, 1 TO 100) AS INTEGER
DIM Itemcode$(0 TO 202)
DIM ItemPoint(0 TO 40) AS INTEGER
DIM Blocker(68) AS INTEGER
DIM MenuSel$(20)
DIM MenuSell(20) AS INTEGER
DIM SHARED TeamGuy(1 TO 4) AS Stats
DIM SHARED Except(68) AS INTEGER
DIM SHARED TerrGraph(3943) AS LONG
DIM SHARED map(1 TO 100, 1 TO 100) AS INTEGER
DIM SHARED CharSpr(224) AS INTEGER
DIM SHARED CharMsk(224) AS INTEGER
DIM SHARED AnimFrame AS INTEGER

DIM SHARED CharSet(32 TO 126, 1 TO 8, 1 TO 6) AS INTEGER

GOSUB SetSpells

RANDOMIZE TIMER
musicfile$ = "intro.mid"
TileFile$ = "tileset1.dat"

UPVAR$ = CHR$(0) + "H": DOWNVAR$ = CHR$(0) + "P"
LEFTVAR$ = CHR$(0) + "K": RIGHTVAR$ = CHR$(0) + "M"

ItemPoint(0) = 201

LoadFont

LevUp(1) = 30
FOR x = 2 TO 30
	LevUp(x) = LevUp(x - 1) * 1.5
NEXT x
LevUp(30) = 2147483647

SCREEN 13
DEFINT X-Y
CLS
COLOR 15
OPEN "CHAIN.DAT" FOR INPUT AS #1
LINE INPUT #1, TempStr$
	IF TempStr$ = "New Game" THEN
		CodeTag = 3
		CLOSE #1
		OPEN "CHAIN.DAT" FOR OUTPUT AS #1
			PRINT #1, "Do not delete this file!"
		CLOSE #1
		GOTO NewGame
	END IF
	IF TempStr$ = "Load Game" THEN
		CodeTag = 3
		LINE INPUT #1, SaveFile$
		CLOSE #1
		OPEN "CHAIN.DAT" FOR OUTPUT AS #1
			PRINT #1, "Do not delete this file!"
		CLOSE #1
		GOSUB LoadGame
		GOTO LetItBegin
	END IF
	IF TempStr$ = "Do Cutscene" THEN
		LINE INPUT #1, WhoCares$
		INPUT #1, CodeTag
		CodeTag = CodeTag + 1
		LINE INPUT #1, Filnam$
		INPUT #1, XPos
		INPUT #1, YPos
		FOR x = 1 TO 100
			LINE INPUT #1, Invent$(x)
		NEXT x
		LINE INPUT #1, TempStr$
		FOR x = 1 TO 200
			BoxOpened(x) = ASC(MID$(TempStr$, x, 1)) - 65
		NEXT x
		FOR x = 1 TO 4
			LINE INPUT #1, TempStr$
			FOR y = 1 TO 20
				Spells(x, y) = ASC(MID$(TempStr$, y, 1)) - 65
			NEXT y
		NEXT x
		INPUT #1, Gold
		FOR x = 1 TO 4
			LINE INPUT #1, TeamGuy(x).Charname
			INPUT #1, TeamGuy(x).Level
			INPUT #1, TeamGuy(x).Experience
			INPUT #1, TeamGuy(x).Health
			INPUT #1, TeamGuy(x).MaxHealth
			INPUT #1, TeamGuy(x).Magic
			INPUT #1, TeamGuy(x).MaxMagic
			INPUT #1, TeamGuy(x).Strength
			INPUT #1, TeamGuy(x).Intel
			INPUT #1, TeamGuy(x).Agility
			INPUT #1, TeamGuy(x).Defense
			LINE INPUT #1, TeamGuy(x).Weapon
			LINE INPUT #1, TeamGuy(x).Armor
		NEXT x
		CLOSE #1
		OPEN "CHAIN.DAT" FOR OUTPUT AS #1
			PRINT #1, "Do not delete this file!"
		CLOSE #1
		GOTO LetItBegin
	END IF
	PRINT "Please run ARC first"
	WHILE INKEY$ = "": WEND
CLOSE #1
SYSTEM

NewGame:

GOSUB Setplayers
Filnam$ = "world001.arc"
Loadpoint% = 1

LetItBegin:
direction% = 2
CharDraw$ = "Rydar"

GOSUB LoadTiles

Except(25) = 2: Except(27) = 2: Except(28) = 2: Except(29) = 2
Except(32) = 1: Except(3) = 1:  Except(13) = 1: Except(35) = 1
Except(62) = 1: Except(66) = 1

 Blocker(3) = 1:  Blocker(6) = 1:  Blocker(7) = 1: Blocker(9) = 1
Blocker(10) = 1: Blocker(11) = 1: Blocker(13) = 1: Blocker(15) = 1
Blocker(16) = 1: Blocker(24) = 1: Blocker(25) = 1: Blocker(26) = 1
Blocker(27) = 1: Blocker(35) = 1: Blocker(41) = 1: Blocker(42) = 1
Blocker(43) = 1: Blocker(44) = 1: Blocker(45) = 1: Blocker(46) = 1
Blocker(48) = 0: Blocker(53) = 1: Blocker(54) = 1: Blocker(55) = 1
Blocker(56) = 1: Blocker(58) = 1: Blocker(59) = 1: Blocker(60) = 1
Blocker(62) = 1: Blocker(66) = 1: Blocker(67) = 1: Blocker(68) = 1

AttackCounter% = 0
AnimFrame = 0

CLS
GOSUB LoadMap

startloop:
AnimFrame = AnimFrame + 1: IF AnimFrame > 2 THEN AnimFrame = 1
CanAttack = 0
IF AttackCounter% < 1 THEN AttackCounter% = INT(RND(1) * 20) + 25

WAIT &H3DA, 8
IF CodeTag <> 3 THEN GOTO AfterCutScene
FOR x = XScrn TO XScrn + 20
		IF Except(map(x, YScrn)) = 0 OR Except(map(x, YScrn)) = 2 THEN
			PUT (x * 15 - (15 * XScrn), 0), TerrGraph((map(x, YScrn) - 1) * 58), PSET
		END IF
		IF Except(map(x, YScrn)) = 1 THEN
			Exceptional x * 15 - (15 * XScrn), 0, map(x, YScrn)
		END IF
NEXT x
FOR y = YScrn + 1 TO YScrn + 12
	FOR x = XScrn TO XScrn + 20
		IF Except(map(x, y)) = 0 OR Except(map(x, y)) = 2 THEN
			PUT (x * 15 - (15 * XScrn), (y - YScrn) * 15), TerrGraph((map(x, y) - 1) * 58), PSET
		END IF
		IF Except(map(x, y)) > 0 THEN
			Exceptional x * 15 - (15 * XScrn), (y - YScrn) * 15, map(x, y)
		END IF
		IF Items(x, y) <> 0 THEN Itemize x * 15 - (15 * XScrn), (y - YScrn) * 15, Itemcode$(ItemPoint(Items(x, y)))
		IF XPos = x AND YPos = y THEN
			DRAWCHAR CharDraw$, direction%, (x - XScrn) * 15, (y - YScrn) * 15
			IF Itemcode$(ItemPoint(Items(XPos, YPos)) + 1) = "B" THEN
				PUT (x * 15 - (15 * XScrn), (y - YScrn) * 15), TerrGraph((map(x, y) - 1) * 58), PSET
				IF Itemcode$(ItemPoint(Items(XPos, YPos - 1)) + 1) = "T" THEN
					PUT (x * 15 - (15 * XScrn), (y - YScrn) * 15 - 15), TerrGraph((map(x, y - 1) - 1) * 58), PSET
				END IF
			END IF
			IF Itemcode$(ItemPoint(Items(XPos, YPos - 1)) + 1) = "B" THEN
				PUT (x * 15 - (15 * XScrn), (y - YScrn) * 15 - 15), TerrGraph((map(x, y - 1) - 1) * 58), PSET
			END IF
			IF Except(map(x, y)) > 0 THEN Exceptional x * 15 - (15 * XScrn), (y - YScrn) * 15, map(x, y)
		END IF
	NEXT x
NEXT y
AfterCutScene:

g$ = ""
AnimTime = TIMER
WHILE g$ = ""
	g$ = INKEY$
	IF TIMER - AnimTime > .25 AND g$ = "" THEN g$ = " "
WEND

DEF SEG = &H40
POKE &H1A, PEEK(&H1C)
POKE &H1B, PEEK(&H1D)
DEF SEG

IF g$ = "1" THEN CharDraw$ = RTRIM$(TeamGuy(1).Charname)
IF g$ = "2" THEN CharDraw$ = RTRIM$(TeamGuy(2).Charname)
IF g$ = "3" THEN CharDraw$ = RTRIM$(TeamGuy(3).Charname)
IF g$ = "4" THEN CharDraw$ = RTRIM$(TeamGuy(4).Charname)

IF g$ = "M" OR g$ = "m" THEN
	CLS
	FOR x = 1 TO 100
		FOR y = 1 TO 100
			PSET (x, y), map(x, y)
		NEXT y
	NEXT x
	WHILE INKEY$ = "": WEND
END IF

IF g$ = RIGHTVAR$ THEN
	CanAttack = 1
	direction% = 6
	XPos = XPos + 1
END IF
IF g$ = LEFTVAR$ THEN
	CanAttack = 1
	direction% = 4
	XPos = XPos - 1
END IF
IF g$ = UPVAR$ THEN
	CanAttack = 1
	direction% = 8
	YPos = YPos - 1
END IF
IF g$ = DOWNVAR$ THEN
	CanAttack = 1
	direction% = 2
	YPos = YPos + 1
END IF
 IF XPos > 100 THEN XPos = 100
 IF YPos > 100 THEN YPos = 100
 IF XPos < 1 THEN XPos = 1
 IF YPos < 1 THEN YPos = 1
 IF Items(XPos, YPos) <> 0 THEN GOSUB ActivateItem
 IF Blocker(map(XPos, YPos)) = 1 OR Itemcode$(ItemPoint(Items(XPos, YPos)) + 1) = "T" THEN
	IF Itemcode$(ItemPoint(Items(XPos, YPos)) + 1) <> "B" THEN
		XPos = oldx: YPos = oldy
		CanAttack = 0
	END IF
 END IF
 XScrn = XPos - 10
 YScrn = YPos - 6
 IF XScrn < 1 THEN XScrn = 1
 IF XScrn > 80 THEN XScrn = 80
 IF YScrn < 1 THEN YScrn = 1
 IF YScrn > 88 THEN YScrn = 88
IF CanAttack = 1 THEN AttackCounter% = AttackCounter% - 1
IF enemtype$ <> "None" AND AttackCounter% < 1 THEN GOSUB EnemiesSub
IF g$ = CHR$(27) THEN GOSUB MenuSub

oldx = XPos: oldy = YPos

GOTO startloop

LoadTiles:
	CLS
	LOCATE 10, 1
	FOR x = 1 TO 255
		RGB x, 0, 0, 0
	NEXT x
	BLOAD "dat\" + TileFile$
	FOR x = 1 TO 20
		GET ((x - 1) * 15, 0)-STEP(14, 14), TerrGraph((x - 1) * 58)
	NEXT x
	FOR x = 1 TO 20
		GET ((x - 1) * 15, 15)-STEP(14, 14), TerrGraph((x + 19) * 58)
	NEXT x
	FOR x = 1 TO 20
		GET ((x - 1) * 15, 30)-STEP(14, 14), TerrGraph((x + 39) * 58)
	NEXT x
	FOR x = 1 TO 8
		GET ((x - 1) * 15, 45)-STEP(14, 14), TerrGraph((x + 59) * 58)
	NEXT x
	CLS
	PALETTE
RETURN

LoadMap:
	AttackCounter% = INT(RND(1) * 20) + 25
	FOR x = 1 TO 100
		FOR y = 1 TO 100
			LINE ((x * 3.2) - 3.2, (y * 2) - 2)-((x * 3.2) + 3.2, (y * 2) + 2), 0, BF
			Items(x, y) = 0
			map(x, y) = 0
		NEXT y
	NEXT x
	FOR x = 1 TO 200
		Itemcode$(x) = ""
	NEXT x
	OPEN "mapfiles\" + Filnam$ FOR INPUT AS #1
		OldTiles$ = TileFile$
		LINE INPUT #1, TileFile$
		LINE INPUT #1, enemtype$
		LINE INPUT #1, musicfile$
		FOR y = 1 TO 100
			LINE INPUT #1, TempStr$
			FOR x = 1 TO 100
				map(x, y) = ASC(MID$(TempStr$, x, 1)) - 32
			NEXT x
		NEXT y
		FOR y = 1 TO 100
			LINE INPUT #1, TempStr$
			FOR x = 1 TO 100
				Items(x, y) = ASC(MID$(TempStr$, x, 1)) - 100
			NEXT x
		NEXT y
		CurItem% = 1
		ItemPoint(1) = 1
		FOR x = 1 TO 300
			IF EOF(1) THEN EXIT FOR
			LINE INPUT #1, Itemcode$(x)
			IF Itemcode$(x) = "EndofItem" THEN
				CurItem% = CurItem% + 1
				ItemPoint(CurItem%) = x + 1
			END IF
		NEXT x
	CLOSE #1
	IF UCASE$(OldTiles$) <> UCASE$(TileFile$) THEN GOSUB LoadTiles
	gotalready% = 0
	FOR x = 1 TO 100
		FOR y = 1 TO 100
			IF Items(x, y) <> 0 THEN
				CodeLine$ = Itemcode$(ItemPoint(Items(x, y)) + 2)
				IF LEFT$(CodeLine$, 6) = "ENTER:" AND VAL(RIGHT$(CodeLine$, 1)) = Loadpoint% THEN
					XPos = x
					YPos = y
					gotalready% = 1
				END IF
			END IF
			IF gotalready% = 1 THEN EXIT FOR
		NEXT y
		IF gotalready% = 1 THEN EXIT FOR
	NEXT x
	XScrn = XPos - 10
	oldx = XPos
	oldy = YPos
	IF XScrn < 1 THEN XScrn = 1
	IF XScrn > 80 THEN XScrn = 80
	YScrn = YPos - 6
	IF YScrn < 1 THEN YScrn = 1
	IF YScrn > 88 THEN YScrn = 88
RETURN
   
ActivateItem:
	TempX% = XPos
	TempY% = YPos
	codemode = 0
	ifmode = 0
	boxnum = 0
	FOR coding = CodeTag TO 300
		CodeLine$ = Itemcode$(ItemPoint(Items(XPos, YPos)) + coding - 1)
		SELECT CASE codemode
		CASE 0
			IF LEFT$(CodeLine$, 3) = "IF:" THEN
				ifmode = 1
				FOR x = 1 TO 100
					IF UCASE$(Invent$(x)) = UCASE$(MID$(CodeLine$, 4)) THEN
						ifmode = 0
					END IF
				NEXT x
			END IF
			IF LEFT$(CodeLine$, 6) = "IFNOT:" THEN
				ifmode = 0
				FOR x = 1 TO 100
					IF UCASE$(Invent$(x)) = UCASE$(MID$(CodeLine$, 7)) THEN
						ifmode = 1
					END IF
				NEXT x
			END IF
			IF ifmode = 0 THEN
				IF CodeLine$ = "EndofItem" THEN EXIT FOR
				IF LEFT$(CodeLine$, 7) = "EXITTO:" THEN
					CodeTag = 3
					Filnam$ = MID$(CodeLine$, 8, 12)
					Loadpoint% = VAL(RIGHT$(CodeLine$, 1))
					GOSUB LoadMap
					RETURN
				END IF
				IF CodeLine$ = "TEXT:" THEN
					codemode = 1
					LINE (0, 0)-(290, 80), 1, BF
					LINE (0, 0)-(290, 80), 15, B
					LOCATE 2, 1
					COLOR 15
				END IF
				IF LEFT$(CodeLine$, 7) = "ATTACK:" THEN
					CanRun% = 0
					OPEN "mapfiles\event.nme" FOR INPUT AS #1
						INPUT #1, NumberOf
						FOR A = 1 TO NumberOf
							LINE INPUT #1, EnemName$
							LINE INPUT #1, EnemPicName$
							INPUT #1, EnemGroupTotal
							INPUT #1, EnemHealth(1)
							FOR B = 2 TO 5
								EnemHealth(B) = EnemHealth(1)
							NEXT B
							INPUT #1, EnemMagic
							INPUT #1, EnemStrength
							INPUT #1, EnemDef
							INPUT #1, EnemAgile
							INPUT #1, EnemGiveGold
							INPUT #1, EnemGiveExp
							LINE INPUT #1, EnemGiveItem$
							LINE INPUT #1, EnemAttack$
							LINE INPUT #1, EnemMagic$
							LINE INPUT #1, EnemSpecial$
							IF EnemName$ = MID$(CodeLine$, 8) THEN EXIT FOR
						NEXT A
					CLOSE #1
					GOSUB BigBattle
				END IF
				IF LEFT$(CodeLine$, 4) = "BOX:" THEN
					boxnum = VAL(MID$(CodeLine$, 5))
					codemode = 2
				END IF
				IF LEFT$(CodeLine$, 4) = "INN:" THEN
					COLOR 15
					LOCATE 1, 1: PRINT "Would you like a room for"
					PRINT "$"; MID$(CodeLine$, 5); "?"
					PRINT "Y/N"
					ink$ = ""
					WHILE ink$ = ""
						ink$ = INKEY$
					WEND
					InnCost = VAL(MID$(CodeLine$, 5))
					IF UCASE$(ink$) = "Y" AND Gold >= InnCost THEN
						CLS
						COLOR 14
						PRINT "Good night!"
						Gold = Gold - InnCost
						FOR innchar = 1 TO 4
							TeamGuy(innchar).Health = TeamGuy(innchar).MaxHealth
							TeamGuy(innchar).Magic = TeamGuy(innchar).MaxMagic
						NEXT innchar
						WHILE INKEY$ = "": WEND
					ELSE
						IF UCASE$(ink$) = "Y" THEN BEEP
					END IF
				END IF
				IF CodeLine$ = "STORE:" THEN
					LOCATE 1, 1
					codemode = 3
					BuyThis% = 1
					ItemSel% = 1
				END IF
				IF LEFT$(CodeLine$, 8) = "SPECIAL:" THEN
					SELECT CASE MID$(CodeLine$, 9)
						CASE "GoodbyeCastle"
							RGB 0, 63, 0, 0
							FOR x% = 1 TO 50
								boomx% = INT(RND(1) * 320) + 1
								boomy% = INT(RND(1) * 60) + 1
								FOR h% = 1 TO 20
									SOUND RND * 1000 + 40, .05
									CIRCLE (boomx%, boomy%), h%, 14
								NEXT h%
							NEXT x%
							RGB 0, 0, 0, 0
						CASE "ItsAnAttack"
							LOCATE 10, 10: PRINT "Bokk: It's an attack!"
							SLEEP 1
						CASE "MoveDown"
							TempY% = TempY% + 1
						CASE "MoveUp"
							TempY% = TempY% - 1
						CASE "SwitchChicks"
							TeamGuy(2).Charname = "Tara"
							TeamGuy(2).MaxMagic = 80: TeamGuy(2).Magic = 80
							TeamGuy(2).Agility = TeamGuy(2).Agility / 2
							TeamGuy(2).Intel = TeamGuy(2).Intel * 2
							Spells(2, 1) = 1: Spells(2, 2) = 2
							Spells(2, 3) = 3: Spells(2, 4) = 4
						CASE "GiveMagic"
							TeamGuy(1).MaxMagic = 15: TeamGuy(1).Magic = 15
							TeamGuy(3).MaxMagic = 15: TeamGuy(3).Magic = 15
						CASE "FreeInn"
							LINE (0, 0)-(319, 199), 14, BF
							FOR innchar = 100 TO 1000 STEP 100
								SOUND innchar, .1
							NEXT innchar
							LINE (0, 0)-(319, 199), 0, BF
							FOR innchar = 1 TO 4
								TeamGuy(innchar).Health = TeamGuy(innchar).MaxHealth
								TeamGuy(innchar).Magic = TeamGuy(innchar).MaxMagic
							NEXT innchar
						CASE "FORCEA1"
							IF BoxOpened(102) = 0 THEN
								TempY% = TempY% + 1
								LOCATE 2, 2: PRINT "BLOCKED BY FORCE FIELD [A]"
								g$ = ""
								WHILE g$ <> " " AND g$ <> CHR$(13)
									g$ = INKEY$
								WEND
							END IF
						CASE "FORCEA2"
							BoxOpened(102) = 1
						CASE "FORCEB1"
							IF BoxOpened(103) = 0 THEN
								TempY% = TempY% - 1
								LOCATE 2, 2: PRINT "BLOCKED BY FORCE FIELD [B]"
								g$ = ""
								WHILE g$ <> " " AND g$ <> CHR$(13)
									g$ = INKEY$
								WEND
							END IF
						CASE "FORCEB2"
							BoxOpened(103) = 1
					END SELECT
				END IF
				IF LEFT$(CodeLine$, 9) = "CUTSCENE:" THEN
					OPEN "CHAIN.DAT" FOR OUTPUT AS #1
						PRINT #1, "Do Cutscene"
						PRINT #1, MID$(CodeLine$, 10)
						PRINT #1, coding
						PRINT #1, Filnam$
						PRINT #1, XPos
						PRINT #1, YPos
						FOR x = 1 TO 100
							PRINT #1, Invent$(x)
						NEXT x
						FOR x = 1 TO 200
							PRINT #1, CHR$(BoxOpened(x) + 65);
						NEXT x
						FOR x = 1 TO 4
							PRINT #1, ""
							FOR y = 1 TO 20
								PRINT #1, CHR$(Spells(x, y) + 65);
							NEXT y
						NEXT x
						PRINT #1, ""
						PRINT #1, Gold
						FOR x = 1 TO 4
							PRINT #1, TeamGuy(x).Charname
							PRINT #1, TeamGuy(x).Level
							PRINT #1, TeamGuy(x).Experience
							PRINT #1, TeamGuy(x).Health
							PRINT #1, TeamGuy(x).MaxHealth
							PRINT #1, TeamGuy(x).Magic
							PRINT #1, TeamGuy(x).MaxMagic
							PRINT #1, TeamGuy(x).Strength
							PRINT #1, TeamGuy(x).Intel
							PRINT #1, TeamGuy(x).Agility
							PRINT #1, TeamGuy(x).Defense
							PRINT #1, TeamGuy(x).Weapon
							PRINT #1, TeamGuy(x).Armor
						NEXT x
					CLOSE #1
					RUN "CUTSCENE"
				END IF
				IF LEFT$(CodeLine$, 5) = "GIVE:" THEN
					FOR GiveItem% = 1 TO 100
						IF Invent$(GiveItem%) = "" THEN
							Invent$(GiveItem%) = MID$(CodeLine$, 6)
							EXIT FOR
						END IF
					NEXT GiveItem%
				END IF
				IF LEFT$(CodeLine$, 5) = "TAKE:" THEN
					FOR TakeItem% = 1 TO 100
						IF Invent$(TakeItem%) = MID$(CodeLine$, 6) THEN
							Invent$(TakeItem%) = ""
							EXIT FOR
						END IF
					NEXT TakeItem%
				END IF
				IF CodeLine$ = ":ENDGAME:" THEN
					SYSTEM
				END IF
			END IF
			IF CodeLine$ = ":ENDIF" THEN ifmode = 0
		CASE 1
			IF CodeLine$ = ":END" THEN
				codemode = 0
			ELSE
				IF CodeLine$ = "-" THEN
					TempStr$ = ""
					WHILE TempStr$ <> " " AND TempStr$ <> CHR$(13) AND TempStr$ <> " "
						TempStr$ = INKEY$
					WEND
					LINE (0, 0)-(290, 80), 1, BF
					LINE (0, 0)-(290, 80), 15, B
					LOCATE 2, 1
				ELSE
					LOCATE CSRLIN, 2
					PUTTEXT CodeLine$, 23, 10, (CSRLIN - 1) * 9, 1
					PRINT
				END IF
			END IF
		CASE 2
			COLOR 15
			IF CodeLine$ = ":END" THEN
				codemode = 0
			ELSE
				IF BoxOpened(boxnum) = 0 THEN
					BoxOpened(boxnum) = 1
					FOR x = 1 TO 100
						IF Invent$(x) = "" THEN Invent$(x) = CodeLine$: EXIT FOR
					NEXT x
					LOCATE 2, 2: PRINT "You found "; CodeLine$
					g$ = ""
					WHILE g$ <> " " AND g$ <> CHR$(13)
						g$ = INKEY$
					WEND
				ELSE
					LOCATE 2, 2: PRINT "Empty"
					g$ = ""
					WHILE g$ <> " " AND g$ <> CHR$(13)
						g$ = INKEY$
					WEND
				END IF
			END IF
		CASE 3
			IF CodeLine$ = ":STORE" THEN
				StoreSelect$ = ";-)"
				WHILE StoreSelect$ <> " " AND StoreSelect$ <> CHR$(13)
					StoreSelect$ = INKEY$
					LOCATE 1, 1
					FOR ListItems% = 1 TO (BuyThis% - 1)
						COLOR 7
						IF ItemSel% = ListItems% THEN COLOR 14
						PRINT MenuSel$(ListItems%); ":"; MenuSell(ListItems%)
					NEXT ListItems%
					COLOR 8
					IF ItemSel% = BuyThis% THEN COLOR 4
					PRINT "Don't buy anything        "
					IF StoreSelect$ = UPVAR$ THEN
						ItemSel% = ItemSel% - 1
						IF ItemSel% < 1 THEN ItemSel% = BuyThis%
					END IF
					IF StoreSelect$ = DOWNVAR$ THEN
						ItemSel% = ItemSel% + 1
						IF ItemSel% > BuyThis% THEN ItemSel% = 1
					END IF
				WEND
				IF ItemSel% <> BuyThis% AND Gold >= MenuSell(ItemSel%) THEN
					Gold = Gold - MenuSell(ItemSel%)
					FOR ListItems% = 1 TO 100
						IF Invent$(ListItems%) = "" THEN Invent$(ListItems%) = MenuSel$(ItemSel%): EXIT FOR
					NEXT ListItems%
				ELSE
					IF ItemSel% <> BuyThis% THEN BEEP
				END IF
				codemode = 0
			ELSE
				FOR InsideStr% = 1 TO LEN(CodeLine$)
					IF MID$(CodeLine$, InsideStr%, 1) = "|" THEN EXIT FOR
				NEXT InsideStr%
				MenuSel$(BuyThis%) = LEFT$(CodeLine$, InsideStr% - 1)
				MenuSell(BuyThis%) = VAL(MID$(CodeLine$, InsideStr% + 1))
				PRINT "                          "
				BuyThis% = BuyThis% + 1
			END IF
		END SELECT
	NEXT coding
	XPos = TempX%
	YPos = TempY%
	CodeTag = 3
RETURN

Setplayers:
	OPEN "dat\teamstat.dat" FOR INPUT AS #1
		FOR x = 1 TO 4
			LINE INPUT #1, TeamGuy(x).Charname
			INPUT #1, TeamGuy(x).Level
			INPUT #1, TeamGuy(x).Experience
			INPUT #1, TeamGuy(x).Health
			INPUT #1, TeamGuy(x).MaxHealth
			INPUT #1, TeamGuy(x).Magic
			INPUT #1, TeamGuy(x).MaxMagic
			INPUT #1, TeamGuy(x).Strength
			INPUT #1, TeamGuy(x).Intel
			INPUT #1, TeamGuy(x).Agility
			INPUT #1, TeamGuy(x).Defense
			LINE INPUT #1, TeamGuy(x).Weapon
			LINE INPUT #1, TeamGuy(x).Armor
			FOR y = 1 TO 20
				Spells(x, y) = 0
			NEXT y
		NEXT x
	CLOSE #1
	FOR x = 1 TO 200
		IF x <= 100 THEN Invent$(x) = ""
		BoxOpened(x) = 0
	NEXT x
	Gold = 100
	Spells(4, 1) = 1
	Invent$(1) = "Health Potion"
RETURN

EnemiesSub:
	COLOR 7
	CLS
	NumberOf = 1
	OPEN "mapfiles\" + enemtype$ FOR INPUT AS #1
		INPUT #1, NumberOf
		WhichEnem = INT(RND(1) * NumberOf) + 1
		FOR A = 1 TO WhichEnem
			LINE INPUT #1, EnemName$
			LINE INPUT #1, EnemPicName$
			INPUT #1, EnemGroupTotal
			INPUT #1, EnemHealth(1)
			FOR B% = 2 TO 5
				EnemHealth(B%) = EnemHealth(1)
			NEXT B%
			INPUT #1, EnemMagic
			INPUT #1, EnemStrength
			INPUT #1, EnemDef
			INPUT #1, EnemAgile
			INPUT #1, EnemGiveGold
			INPUT #1, EnemGiveExp
			LINE INPUT #1, EnemGiveItem$
			LINE INPUT #1, EnemAttack$
			LINE INPUT #1, EnemMagic$
			LINE INPUT #1, EnemSpecial$
		NEXT A
	CLOSE #1
	GOSUB BigBattle
RETURN

BigBattle:
	RunningNow% = 0
	CanRun% = 1
	EnemGroupAttack = INT(RND(1) * EnemGroupTotal) + 1
	CurEnem = 1
	CLS
	PRINT "You are attacked by"
	PRINT EnemName$; ":"; EnemGroupAttack
	FOR x = 0 TO (EnemGroupAttack * 60) STEP 15
		FOR y = 30 TO 90 STEP 15
			PUT (x, y), TerrGraph((map(1, 1) - 1) * 58), PSET
		NEXT y
	NEXT x
	OPEN "img\" + EnemPicName$ FOR INPUT AS #1
		FOR y = 1 TO 75
			LINE INPUT #1, TempStr$
			FOR DrawEnemy = 1 TO EnemGroupAttack
				FOR x = 1 TO 60
					tempstr2$ = MID$(TempStr$, x, 1)
					IF tempstr2$ <> "!" THEN PSET (x + (60 * (DrawEnemy - 1)), y + 30), ASC(tempstr2$) - 33
				NEXT x
			NEXT DrawEnemy
		NEXT y
	CLOSE #1
StartBatLoop:
	FOR TeamDude = 1 TO 4
		IF EnemSel > EnemGroupAttack OR EnemSel < 1 THEN EnemSel = 1
		act$ = ""
		IF TeamGuy(TeamDude).Health < 1 THEN
			act$ = " "
			Action$(TeamDude) = "DEAD"
		END IF
		LOCATE 18, 3: PRINT "             "
		WHILE act$ = ""
			COLOR 1
			LOCATE 19, 2: PRINT "1)Fight"
			LOCATE 20, 2: PRINT "2)Magic"
			LOCATE 21, 2: PRINT "3)Run"
			LOCATE 22, 2: PRINT "4)Item"
			COLOR 7
			FOR TeamDudes = 1 TO 4
				LOCATE 17 + TeamDudes, 17
				IF TeamGuy(TeamDudes).Health > 0 THEN
					PRINT TeamGuy(TeamDudes).Charname; ":"; TeamGuy(TeamDudes).Health; "/"; TeamGuy(TeamDudes).MaxHealth
				ELSE
					PRINT "                      "
				END IF
			NEXT TeamDudes
			COLOR RND * 5 + 9
			LOCATE 17 + TeamDude, 17
			IF TeamGuy(TeamDude).Health > 0 THEN
				PRINT TeamGuy(TeamDude).Charname; ":"; TeamGuy(TeamDude).Health; "/"; TeamGuy(TeamDude).MaxHealth
			ELSE
				PRINT "                      "
			END IF
			COLOR 15
			LOCATE 18, 3: PRINT "MP:"; TeamGuy(TeamDude).Magic; "/"; TeamGuy(TeamDude).MaxMagic
			COLOR 14
			act$ = INKEY$
			SELECT CASE act$
				CASE ""
				CASE "1"
					LOCATE 19, 2: PRINT "1)Fight"
					GOSUB SelectAttackEnemy
				CASE "2"
					IF TeamGuy(TeamDude).MaxMagic > 0 THEN
						LOCATE 20, 2: PRINT "2)Magic"
						GOSUB SelectMagicSpell
					ELSE
						act$ = ""
					END IF
				CASE "3"
					LOCATE 21, 2: PRINT "3)Run"
					Action$(TeamDude) = "RUN"
				CASE "4"
					LOCATE 22, 2: PRINT "4)Item"
					GOSUB SelectItemToUse
				CASE ELSE
					act$ = ""
			END SELECT
		WEND
		LINE (0, 106)-(320, 116), 0, BF
	NEXT TeamDude
	FOR TeamEnemy% = 1 TO EnemGroupAttack
		IF EnemHealth(TeamEnemy%) > 0 THEN
			WhatShallIDo% = INT(RND(1) * 6 + 1)
			IF WhatShallIDo% = 1 THEN
				EnAction$(TeamEnemy%) = "KILL:" + STR$(INT(RND(1) * 4 + 1))
			END IF
			IF WhatShallIDo% >= 2 AND WhatShallIDo% <= 5 THEN
				EnAction$(TeamEnemy%) = "MAGI:" + STR$(INT(RND(1) * 4 + 1))
				IF EnemMagic$ = "None" THEN EnAction$(TeamEnemy%) = "KILL:" + STR$(INT(RND(1) * 4 + 1))
			END IF
			IF WhatShallIDo% = 6 THEN
				EnAction$(TeamEnemy%) = "SPEC:" + STR$(INT(RND(1) * 4 + 1))
				IF EnemSpecial$ = "None" THEN EnAction$(TeamEnemy%) = "KILL:" + STR$(INT(RND(1) * 4 + 1))
			END IF
		ELSE
			EnAction$(TeamEnemy%) = "DEAD"
		END IF
	NEXT TeamEnemy%
	BigTotal% = 4 + EnemGroupAttack
	FOR DoIt% = 1 TO BigTotal%
InsideGoto:
		COLOR 7
		ChooseBig% = INT(RND(1) * BigTotal% + 1)
		IF ChooseBig% > 4 THEN
			ChooseBig% = ChooseBig% - 4
			IF EnAction$(ChooseBig%) = "ALREADY" THEN GOTO InsideGoto
			IF EnAction$(ChooseBig%) = "DEAD" THEN EnAction$(ChooseBig%) = "ALREADY"
			IF LEFT$(EnAction$(ChooseBig%), 5) = "KILL:" OR LEFT$(EnAction$(ChooseBig%), 5) = "SPEC:" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				Damage% = INT(RND(1) * (EnemStrength / 2) + (EnemStrength / 2))
				IF LEFT$(EnAction$(ChooseBig%), 5) = "SPEC:" THEN Damage% = INT(Damage% * (RND * 1 + 2))
				GuyHit% = VAL(MID$(EnAction$(ChooseBig%), 6))
				Damage% = Damage% * (1 - (TeamGuy(GuyHit%).Defense / 100))
				IF TeamGuy(GuyHit%).Health > 0 THEN
					RGB 0, 63, 0, 0
					IF EnemName$ = "CyberDamien" THEN
						FOR fbatsound% = 1000 TO 200 STEP -50
							SOUND fbatsound%, .1
							SOUND fbatsound% * 2, .1
						NEXT fbatsound%
					END IF
					TeamGuy(GuyHit%).Health = TeamGuy(GuyHit%).Health - Damage%
					LOCATE 1, 1: COLOR 13: PRINT EnemName$;
					COLOR 7: PRINT " hits ";
					COLOR 14: PRINT RTRIM$(TeamGuy(GuyHit%).Charname);
					COLOR 7: PRINT " with ";
					IF LEFT$(EnAction$(ChooseBig%), 5) = "SPEC:" THEN PRINT EnemSpecial$;
					IF LEFT$(EnAction$(ChooseBig%), 5) = "KILL:" THEN PRINT EnemAttack$;
					PRINT " for";
					COLOR 4: PRINT Damage%;
					COLOR 7: PRINT "damage!"
					IF TeamGuy(GuyHit%).Health < 1 THEN
						IF Action$(GuyHit%) <> "ALREADY" THEN Action$(GuyHit%) = "DEAD"
						TeamGuy(GuyHit%).Health = 0
						COLOR 13
						LOCATE 3, 1: PRINT RTRIM$(TeamGuy(GuyHit%).Charname); " falls."
					END IF
					EnAction$(ChooseBig%) = "ALREADY"
					pausit 10
					RGB 0, 0, 0, 0
				ELSE
					EnAction$(ChooseBig%) = "ALREADY"
					LOCATE 1, 1
					COLOR 13: PRINT EnemName$;
					COLOR 7: PRINT " does nothing."
				END IF
				WHILE INKEY$ = "": WEND
			END IF
		ELSE
			IF Action$(ChooseBig%) = "ALREADY" THEN GOTO InsideGoto
			IF Action$(ChooseBig%) = "DEAD" THEN Action$(ChooseBig%) = "ALREADY"
			IF LEFT$(Action$(ChooseBig%), 9) = "ITEM:NHPT" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				HealthUp% = VAL(MID$(Action$(ChooseBig%), 10))
				LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
				IF TeamGuy(HealthUp%).Health > 0 THEN
					COLOR 7: PRINT " gives ";
					COLOR 14: PRINT RTRIM$(TeamGuy(HealthUp%).Charname);
					COLOR 7: PRINT " a Health Potion for";
					COLOR 15: PRINT " 50 ";
					COLOR 7: PRINT "HP"
					TeamGuy(HealthUp%).Health = TeamGuy(HealthUp%).Health + 50
					IF TeamGuy(HealthUp%).Health > TeamGuy(HealthUp%).MaxHealth THEN TeamGuy(HealthUp%).Health = TeamGuy(HealthUp%).MaxHealth
				ELSE
					COLOR 7: PRINT " tries to give ";
					COLOR 14: PRINT RTRIM$(TeamGuy(HealthUp%).Charname);
					COLOR 7
					PRINT " a Health Potion but fails."
				END IF
				Action$(ChooseBig%) = "ALREADY"
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 9) = "ITEM:MPPT" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				HealthUp% = VAL(MID$(Action$(ChooseBig%), 10))
				LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
				IF TeamGuy(HealthUp%).Health > 0 THEN
					COLOR 7: PRINT " restores ";
					COLOR 14: PRINT RTRIM$(TeamGuy(HealthUp%).Charname);
					COLOR 7: PRINT "'s MP to full!";
					TeamGuy(HealthUp%).Magic = TeamGuy(HealthUp%).MaxMagic
				ELSE
					COLOR 7: PRINT " tries to give ";
					COLOR 14: PRINT RTRIM$(TeamGuy(HealthUp%).Charname);
					COLOR 7
					PRINT " a Magic Potion but fails."
				END IF
				Action$(ChooseBig%) = "ALREADY"
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 9) = "ITEM:SHPT" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				HealthUp% = VAL(MID$(Action$(ChooseBig%), 10))
				LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
				IF TeamGuy(HealthUp%).Health > 0 THEN
					COLOR 7: PRINT " gives ";
					COLOR 14: PRINT RTRIM$(TeamGuy(HealthUp%).Charname);
					COLOR 7: PRINT " a Super Health Potion for";
					COLOR 15: PRINT " 300 ";
					COLOR 7: PRINT "HP"
					TeamGuy(HealthUp%).Health = TeamGuy(HealthUp%).Health + 300
					IF TeamGuy(HealthUp%).Health > TeamGuy(HealthUp%).MaxHealth THEN TeamGuy(HealthUp%).Health = TeamGuy(HealthUp%).MaxHealth
				ELSE
					COLOR 7: PRINT " tries to give ";
					COLOR 14: PRINT RTRIM$(TeamGuy(HealthUp%).Charname);
					COLOR 7
					PRINT " a Super Health Potion but fails."
				END IF
				Action$(ChooseBig%) = "ALREADY"
				WHILE INKEY$ = "": WEND
			END IF
			IF Action$(ChooseBig%) = "RUN" THEN
				TryToRun = INT(RND(1) * EnemAgile + 1)
				IF TryToRun <= TeamGuy(ChooseBig%).Agility THEN
					RunningNow% = 1
					EXIT FOR
				ELSE
					LOCATE 1, 1: PRINT "                                        "
					LOCATE 2, 1: PRINT "                                        "
					LOCATE 3, 1: PRINT "                                        "
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " tried to run, but was blocked."
					Action$(ChooseBig%) = "ALREADY"
				END IF
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 5) = "KILL:" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
			   
				TempStr$ = RTRIM$(UCASE$(TeamGuy(ChooseBig%).Charname))
				SELECT CASE RTRIM$(TeamGuy(ChooseBig%).Weapon)
					CASE "fist"
						WeaponWhack = 1
					CASE "wood stick"
						WeaponWhack = 1.1
						IF TempStr$ = "KALRIN" THEN WeaponWhack = 1.5
					CASE "metal pole"
						WeaponWhack = 1.4
						IF TempStr$ = "KALRIN" THEN WeaponWhack = 2
					CASE "spiked pole"
						WeaponWhack = 2.1
						IF TempStr$ = "KALRIN" THEN WeaponWhack = 2.8
					CASE "javelin"
						WeaponWhack = 3
						IF TempStr$ = "KALRIN" THEN WeaponWhack = 3.6
					CASE "iron sword"
						WeaponWhack = 1.6
						IF TempStr$ = "MALCOLM" THEN WeaponWhack = 1.2
						IF TempStr$ = "RYDAR" THEN WeaponWhack = 1.7
					CASE "steel sword"
						WeaponWhack = 2.1
						IF TempStr$ = "MALCOLM" THEN WeaponWhack = 1.4
						IF TempStr$ = "RYDAR" THEN WeaponWhack = 2.3
					CASE "katana"
						WeaponWhack = 3
						IF TempStr$ = "MALCOLM" THEN WeaponWhack = 2
						IF TempStr$ = "RYDAR" THEN WeaponWhack = 3.5
					CASE "spirit blade"
						WeaponWhack = 4.5
						IF TempStr$ = "MALCOLM" THEN WeaponWhack = 3
						IF TempStr$ = "RYDAR" THEN WeaponWhack = 6.7
					CASE "wooden axe"
						WeaponWhack = 1.7
						IF TempStr$ = "BOKK" THEN WeaponWhack = 1.9
					CASE "heavy axe"
						WeaponWhack = 2.4
						IF TempStr$ = "BOKK" THEN WeaponWhack = 2.7
					CASE "golden axe"
						WeaponWhack = 3.5
						IF TempStr$ = "BOKK" THEN WeaponWhack = 4
					CASE "monster axe"
						WeaponWhack = 5
						IF TempStr$ = "BOKK" THEN WeaponWhack = 7
					CASE "assault rifle"
						WeaponWhack = 10
						IF TempStr$ = "TARA" THEN WeaponWhack = 11
					CASE "blaster"
						WeaponWhack = 13
						IF TempStr$ = "TARA" THEN WeaponWhack = 14
				END SELECT
			  
				Damage% = INT(RND(1) * (TeamGuy(ChooseBig%).Strength / 2) + (TeamGuy(ChooseBig%).Strength / 2))
				Damage% = Damage% * (1 - (EnemDef / 100)) * WeaponWhack
				GuyHit% = VAL(MID$(Action$(ChooseBig%), 6))
				IF EnemHealth(GuyHit%) > 0 THEN
					RGB 0, 63, 63, 63
					IF EnemName$ = "CyberDamien" THEN
						FOR fbatsound% = 1000 TO 200 STEP -50
							SOUND fbatsound%, .1
							SOUND fbatsound% * 2, .1
						NEXT fbatsound%
					END IF
					EnemHealth(GuyHit%) = EnemHealth(GuyHit%) - Damage%
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " hits ";
					COLOR 13: PRINT EnemName$; " #"; GuyHit%;
					COLOR 7: PRINT "with "; RTRIM$(TeamGuy(ChooseBig%).Weapon); " for";
					COLOR 15: PRINT Damage%;
					COLOR 7: PRINT "damage!"
					IF EnemHealth(GuyHit%) < 1 THEN
						EnemHealth(GuyHit%) = 0
						LOCATE 3, 1: COLOR 13: PRINT EnemName$;
						COLOR 7: PRINT " falls."
						IF EnAction$(GuyHit%) <> "ALREADY" THEN EnAction$(GuyHit%) = "DEAD"
						FOR blood% = 1 TO 200
							LINE ((RND * 40) + ((GuyHit% - 1) * 60 + 10), RND * 65 + 40)-STEP(0, RND * 3), 4
						NEXT blood%
					END IF
					Action$(ChooseBig%) = "ALREADY"
					pausit 10
					RGB 0, 0, 0, 0
				ELSE
					Action$(ChooseBig%) = "ALREADY"
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " does nothing."
				END IF
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 6) = "MAGIC:" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				WeaponWhack = 1
				FOR FindWhichSpell% = 1 TO 20
					IF UCASE$(MID$(Action$(ChooseBig%), 7, 16)) = UCASE$(SpellInfo(FindWhichSpell%).SpellName) THEN
						WeaponWhack = SpellInfo(FindWhichSpell%).MagPoints
						SpellNum% = FindWhichSpell%
						EXIT FOR
					END IF
				NEXT FindWhichSpell%
				Damage% = TeamGuy(ChooseBig%).Intel * WeaponWhack
				Damage% = Damage% * (1 - (EnemMagic / 100))
				GuyHit% = VAL(MID$(Action$(ChooseBig%), 24))
				IF EnemHealth(GuyHit%) > 0 THEN
					RGB 0, 63, 63, 63
					IF EnemName$ = "CyberDamien" THEN
						FOR fbatsound% = 200 TO 800 STEP 50
							SOUND fbatsound%, .1
							SOUND fbatsound% * 2, .1
						NEXT fbatsound%
						FOR fbatsound% = 800 TO 200 STEP -50
							SOUND fbatsound%, .1
							SOUND fbatsound% * 2, .1
						NEXT fbatsound%
					END IF
					TeamGuy(ChooseBig%).Magic = TeamGuy(ChooseBig%).Magic - SpellInfo(SpellNum%).MagPoints
					EnemHealth(GuyHit%) = EnemHealth(GuyHit%) - Damage%
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " hits ";
					COLOR 13: PRINT EnemName$; " #"; GuyHit%;
					COLOR 7: PRINT "with ";
					COLOR 14: PRINT RTRIM$(SpellInfo(SpellNum%).SpellName);
					COLOR 7: PRINT ; " for";
					COLOR 15: PRINT Damage%;
					COLOR 7: PRINT "damage!"
					IF EnemHealth(GuyHit%) < 1 THEN
						EnemHealth(GuyHit%) = 0
						LOCATE 3, 1: COLOR 13: PRINT EnemName$;
						COLOR 7: PRINT " falls."
						IF EnAction$(GuyHit%) <> "ALREADY" THEN EnAction$(GuyHit%) = "DEAD"
						FOR blood% = 1 TO 200
							LINE ((RND * 40) + ((GuyHit% - 1) * 60 + 10), RND * 65 + 40)-STEP(0, RND * 3), 4
						NEXT blood%
					END IF
					Action$(ChooseBig%) = "ALREADY"
					pausit 10
					RGB 0, 0, 0, 0
				ELSE
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " does nothing."
					Action$(ChooseBig%) = "ALREADY"
				END IF
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 9) = "ALLMAGIC:" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				WeaponWhack = 1
				FOR FindWhichSpell% = 1 TO 20
					IF UCASE$(MID$(Action$(ChooseBig%), 10, 16)) = UCASE$(SpellInfo(FindWhichSpell%).SpellName) THEN
						WeaponWhack = SpellInfo(FindWhichSpell%).MagPoints
						SpellNum% = FindWhichSpell%
						EXIT FOR
					END IF
				NEXT FindWhichSpell%
				Damage% = TeamGuy(ChooseBig%).Intel * WeaponWhack
				Damage% = Damage% * (1 - (EnemMagic / 100))
				Damage% = INT(Damage% / EnemGroupAttack)
				RGB 0, 63, 63, 63
				IF EnemName$ = "CyberDamien" THEN
					FOR fbatsound% = 200 TO 800 STEP 50
						SOUND fbatsound%, .1
						SOUND fbatsound% * 2, .1
					NEXT fbatsound%
					FOR fbatsound% = 800 TO 200 STEP -50
						SOUND fbatsound%, .1
						SOUND fbatsound% * 2, .1
					NEXT fbatsound%
				END IF
				TeamGuy(ChooseBig%).Magic = TeamGuy(ChooseBig%).Magic - SpellInfo(SpellNum%).MagPoints
				LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
				COLOR 7: PRINT " hits the ";
				COLOR 13: PRINT EnemName$;
				COLOR 7: PRINT " group with ";
				COLOR 14: PRINT RTRIM$(SpellInfo(SpellNum%).SpellName);
				COLOR 7: PRINT ; " for";
				COLOR 15: PRINT Damage%;
				COLOR 7: PRINT "damage!"
				EnemiesDown% = 0
				FOR GuyHit% = 1 TO EnemGroupAttack
					IF EnemHealth(GuyHit%) > 0 THEN
						EnemHealth(GuyHit%) = EnemHealth(GuyHit%) - Damage%
						IF EnemHealth(GuyHit%) < 1 THEN
							EnemiesDown% = EnemiesDown% + 1
							EnemHealth(GuyHit%) = 0
							IF EnAction$(GuyHit%) <> "ALREADY" THEN EnAction$(GuyHit%) = "DEAD"
							FOR blood% = 1 TO 200
								LINE ((RND * 40) + ((GuyHit% - 1) * 60 + 10), RND * 65 + 40)-STEP(0, RND * 3), 4
							NEXT blood%
						END IF
					END IF
				NEXT GuyHit%
				IF EnemiesDown% > 0 THEN
					LOCATE 3, 1
					COLOR 13: PRINT EnemiesDown%; EnemName$;
					IF EnemiesDown% = 1 THEN
						COLOR 7
						PRINT " falls."
					END IF
					IF EnemiesDown% > 1 THEN
						PRINT "s";
						COLOR 7
						PRINT " fall."
					END IF
				END IF
				Action$(ChooseBig%) = "ALREADY"
				pausit 10
				RGB 0, 0, 0, 0
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 8) = "ALLHEAL:" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				HealMult = 1
				FOR FindWhichSpell% = 1 TO 20
					IF UCASE$(MID$(Action$(ChooseBig%), 9, 16)) = UCASE$(SpellInfo(FindWhichSpell%).SpellName) THEN
						HealMult = SpellInfo(FindWhichSpell%).MagPoints
						SpellNum% = FindWhichSpell%
						EXIT FOR
					END IF
				NEXT FindWhichSpell%
				HealTotal% = (TeamGuy(ChooseBig%).Intel * HealMult) + (TeamGuy(ChooseBig%).Level * HealMult)
				HealTotal% = INT(HealTotal% / 4)
				FOR GuyHit% = 1 TO 4
					IF TeamGuy(GuyHit%).Health > 0 THEN
						TeamGuy(GuyHit%).Health = TeamGuy(GuyHit%).Health + HealTotal%
						IF TeamGuy(GuyHit%).Health > TeamGuy(GuyHit%).MaxHealth THEN TeamGuy(GuyHit%).Health = TeamGuy(GuyHit%).MaxHealth
					END IF
				NEXT GuyHit%
				TeamGuy(ChooseBig%).Magic = TeamGuy(ChooseBig%).Magic - SpellInfo(SpellNum%).MagPoints
				LOCATE 1, 1: COLOR 15: PRINT "Everyone was healed";
				COLOR 14: PRINT HealTotal%;
				COLOR 7: PRINT "HP by ";
				COLOR 13: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname); "'s"
				COLOR 14: PRINT RTRIM$(SpellInfo(SpellNum%).SpellName);
				COLOR 7: PRINT " spell."
				Action$(ChooseBig%) = "ALREADY"
				WHILE INKEY$ = "": WEND
			END IF
			IF LEFT$(Action$(ChooseBig%), 5) = "HEAL:" THEN
				LOCATE 1, 1: PRINT "                                        "
				LOCATE 2, 1: PRINT "                                        "
				LOCATE 3, 1: PRINT "                                        "
				HealMult = 1
				FOR FindWhichSpell% = 1 TO 20
					IF UCASE$(MID$(Action$(ChooseBig%), 6, 16)) = UCASE$(SpellInfo(FindWhichSpell%).SpellName) THEN
						HealMult = SpellInfo(FindWhichSpell%).MagPoints
						SpellNum% = FindWhichSpell%
						EXIT FOR
					END IF
				NEXT FindWhichSpell%
				HealTotal% = (TeamGuy(ChooseBig%).Intel * HealMult) + (TeamGuy(ChooseBig%).Level * HealMult)
				GuyHit% = VAL(MID$(Action$(ChooseBig%), 23))
				IF TeamGuy(GuyHit%).Health > 0 THEN
					TeamGuy(ChooseBig%).Magic = TeamGuy(ChooseBig%).Magic - SpellInfo(SpellNum%).MagPoints
					TeamGuy(GuyHit%).Health = TeamGuy(GuyHit%).Health + HealTotal%
					IF TeamGuy(GuyHit%).Health > TeamGuy(GuyHit%).MaxHealth THEN TeamGuy(GuyHit%).Health = TeamGuy(GuyHit%).MaxHealth
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " heals ";
					COLOR 13: PRINT TeamGuy(GuyHit%).Charname;
					COLOR 7: PRINT " with ";
					COLOR 14: PRINT RTRIM$(SpellInfo(SpellNum%).SpellName);
					COLOR 7: PRINT ; " for ";
					COLOR 15: PRINT HealTotal%;
					COLOR 7: PRINT "HP."
					Action$(ChooseBig%) = "ALREADY"
					pausit 10
				ELSE
					LOCATE 1, 1: COLOR 14: PRINT RTRIM$(TeamGuy(ChooseBig%).Charname);
					COLOR 7: PRINT " does nothing."
					Action$(ChooseBig%) = "ALREADY"
				END IF
				WHILE INKEY$ = "": WEND
			END IF
		END IF
		TheyAreDead = 0: WeAreDead = 0
		FOR TestDead% = 1 TO EnemGroupAttack
			IF EnemHealth(TestDead%) < 1 THEN TheyAreDead = TheyAreDead + 1
		NEXT TestDead%
		FOR TestDead% = 1 TO 4
			IF TeamGuy(TestDead%).Health < 1 THEN
				WeAreDead = WeAreDead + 1
				LOCATE 17 + TestDead%, 17: PRINT "                      "
			ELSE
				LOCATE 17 + TestDead%, 17: PRINT TeamGuy(TestDead%).Charname; ":"; TeamGuy(TestDead%).Health; "/"; TeamGuy(TestDead%).MaxHealth
			END IF
		NEXT TestDead%
		IF TheyAreDead = EnemGroupAttack THEN EXIT FOR
		IF WeAreDead = 4 THEN
			CLS
			COLOR 14
			PRINT "GAME OVER!"
			g$ = ""
			WHILE g$ <> " " AND g$ <> CHR$(13)
				g$ = INKEY$
			WEND
			SYSTEM
		END IF
	NEXT DoIt%
	IF RunningNow% = 1 THEN GOTO AltEndBatLoop
	IF TheyAreDead = EnemGroupAttack THEN GOTO EndBatLoop:
GOTO StartBatLoop
EndBatLoop:
	CLS
	COLOR 15
	PRINT "You received:"
	COLOR 14
	PRINT EnemGiveGold * EnemGroupAttack; "gold"
	PRINT EnemGiveExp * EnemGroupAttack; "experience"
	Gold = Gold + (EnemGiveGold * EnemGroupAttack)
	COLOR 13
	NumAlive = 4
	FOR TestDead = 1 TO 4
		IF TeamGuy(TestDead).Health < 1 THEN NumAlive = NumAlive - 1
	NEXT TestDead
	FOR TeamDude = 1 TO 4
		IF TeamGuy(TeamDude).Health > 0 THEN
			TeamGuy(TeamDude).Experience = TeamGuy(TeamDude).Experience + INT((EnemGiveExp * EnemGroupAttack) / NumAlive)
		END IF
		IF TeamGuy(TeamDude).Experience > LevUp(TeamGuy(TeamDude).Level) THEN
			PRINT "Level up for "; RTRIM$(TeamGuy(TeamDude).Charname); "!"
			TeamGuy(TeamDude).Experience = TeamGuy(TeamDude).Experience - LevUp(TeamGuy(TeamDude).Level)
			TeamGuy(TeamDude).Level = TeamGuy(TeamDude).Level + 1
			TeamGuy(TeamDude).MaxHealth = INT(TeamGuy(TeamDude).MaxHealth * 1.2) + 1
			TeamGuy(TeamDude).MaxMagic = INT(TeamGuy(TeamDude).MaxMagic * 1.2)
			TeamGuy(TeamDude).Strength = INT(TeamGuy(TeamDude).Strength * 1.05) + 1
			TeamGuy(TeamDude).Agility = INT(TeamGuy(TeamDude).Agility * 1.05) + 1
			TeamGuy(TeamDude).Intel = INT(TeamGuy(TeamDude).Intel * 1.05) + 1
		END IF
	NEXT TeamDude
	g$ = ""
	WHILE g$ <> " " AND g$ <> CHR$(13)
		g$ = INKEY$
	WEND
RETURN
AltEndBatLoop:
	CLS
	COLOR 4
	PRINT RTRIM$(TeamGuy(ChooseBig%).Charname); " managed to run away"
	g$ = ""
	WHILE g$ <> " " AND g$ <> CHR$(13)
		g$ = INKEY$
	WEND
RETURN

MenuSub:
	ExitMenu = 0
	CurChoice = 1
	MenuMax = 5
	MenuSel$(1) = "  Status    "
	MenuSel$(2) = "  Items     "
	MenuSel$(3) = "  Magic     "
	MenuSel$(4) = "  Save      "
	MenuSel$(5) = "  End Game  "
	LOCATE 1, 1
StartMenuLoop:
	COLOR 7
	LOCATE 1, 1
	FOR x = 1 TO MenuMax
		IF CurChoice = x THEN COLOR 14
		PRINT MenuSel$(x)
		COLOR 7
	NEXT x
	COLOR 13
	PRINT "            "
	PRINT "            "
	PRINT "Gold:"; Gold
	h$ = INKEY$: SELECT CASE h$
	CASE UPVAR$
		CurChoice = CurChoice - 1
		IF CurChoice < 1 THEN CurChoice = MenuMax
	CASE DOWNVAR$
		CurChoice = CurChoice + 1
		IF CurChoice > MenuMax THEN CurChoice = 1
	CASE CHR$(13), " "
		IF CurChoice = 1 THEN GOSUB StatsView
		IF CurChoice = 2 THEN GOSUB ItemSub
		IF CurChoice = 3 THEN GOSUB MagicSub
		IF CurChoice = 4 THEN GOSUB SaveGame
		IF CurChoice = 5 THEN SYSTEM
	CASE CHR$(27)
		ExitMenu = 1
	END SELECT
IF ExitMenu = 0 THEN GOTO StartMenuLoop
RETURN

StatsView:
	SubChar = 1
	i$ = ""
	COLOR 7
	LINE (0, 0)-(300, 100), 0, BF
	WHILE i$ <> CHR$(27)
		i$ = INKEY$
		LOCATE 1, 1
		LINE (210, 9)-(271, 86), 6, B
		LINE (208, 7)-(273, 88), 6, B
		DRAWCHAR RTRIM$(TeamGuy(SubChar).Charname) + "F.img", 1, 210, 10
		PRINT "Name: "; TeamGuy(SubChar).Charname
		PRINT "Level:"; TeamGuy(SubChar).Level
		PRINT "Exp"; TeamGuy(SubChar).Experience; "/"; LevUp(TeamGuy(SubChar).Level)
		PRINT "HP:"; TeamGuy(SubChar).Health; "/"; TeamGuy(SubChar).MaxHealth
		PRINT "MP:"; TeamGuy(SubChar).Magic; "/"; TeamGuy(SubChar).MaxMagic
		PRINT "Strength:"; TeamGuy(SubChar).Strength
		PRINT "Intelligence:"; TeamGuy(SubChar).Intel
		PRINT "Agility:"; TeamGuy(SubChar).Agility
		PRINT "Defense:"; TeamGuy(SubChar).Defense
		PRINT "Weapon:"; TeamGuy(SubChar).Weapon
		PRINT "Armor:"; TeamGuy(SubChar).Armor
		LOCATE 1, 23: PRINT "^"
		LOCATE 11, 23: PRINT "v"
		IF i$ = UPVAR$ THEN
			LINE (0, 0)-(300, 100), 0, BF
			SubChar = SubChar - 1
			IF SubChar < 1 THEN SubChar = 4
		END IF
		IF i$ = DOWNVAR$ THEN
			LINE (0, 0)-(300, 100), 0, BF
			SubChar = SubChar + 1
			IF SubChar > 4 THEN SubChar = 1
		END IF
	WEND
	LINE (0, 0)-(300, 100), 0, BF
RETURN

ItemSub:
	SubCurSel = 1
	SubScreen = 1
	i$ = ""
	COLOR 7
	LINE (0, 0)-(200, 100), 0, BF
	WHILE i$ <> CHR$(27)
		i$ = INKEY$
		LOCATE 1, 1
		FOR x = SubScreen TO (SubScreen + 10)
			IF x = SubCurSel THEN COLOR 15
			IF Invent$(x) <> "" THEN
				PRINT Invent$(x)
			ELSE
				PRINT "---"
			END IF
			COLOR 7
		NEXT x
		LOCATE 1, 23: PRINT "^"
		LOCATE 11, 23: PRINT "v"
		IF UCASE$(i$) = "A" THEN
			FOR SelectItem% = 1 TO 98
				IF Invent$(SelectItem%) = "" THEN
					FOR ReArrange% = (SelectItem% + 1) TO 100
						IF Invent$(ReArrange%) <> "" THEN
							SWAP Invent$(SelectItem%), Invent$(ReArrange%)
							EXIT FOR
						END IF
					NEXT ReArrange%
				END IF
			NEXT SelectItem%
		END IF
		IF i$ = UPVAR$ THEN
			LINE (0, 0)-(200, 100), 0, BF
			SubCurSel = SubCurSel - 1
			IF SubCurSel < 1 THEN SubCurSel = 100
		END IF
		IF i$ = DOWNVAR$ THEN
			LINE (0, 0)-(200, 100), 0, BF
			SubCurSel = SubCurSel + 1
			IF SubCurSel > 100 THEN SubCurSel = 1
		END IF
		IF i$ = CHR$(13) OR i$ = " " THEN
			LINE (0, 0)-(200, 100), 0, BF
			COLOR 12: LOCATE 1, 1: PRINT "Who will use the"
			COLOR 14: PRINT Invent$(SubCurSel);
			COLOR 15: PRINT "?"
			PRINT "1) "; TeamGuy(1).Charname
			PRINT "2) "; TeamGuy(2).Charname
			PRINT "3) "; TeamGuy(3).Charname
			PRINT "4) "; TeamGuy(4).Charname
			COLOR 13
			PRINT "5) DROP ITEM"
			j$ = ""
			WHILE j$ = "": j$ = INKEY$
			WEND
			j = VAL(j$)
			IF j < 5 AND j > 0 THEN
				COLOR 14
				PRINT TeamGuy(j).Charname
				SELECT CASE UCASE$(Invent$(SubCurSel))
					CASE "RED KEYSTONE", "GREEN KEYSTONE", "BLUE KEYSTONE"
						PRINT "watches it glow."
					CASE "TENT"
						IF LEFT$(UCASE$(enemtype$), 5) = "WORLD" OR enemtype$ = "None" THEN
							FOR x = 1 TO 4
								TeamGuy(x).Health = TeamGuy(x).MaxHealth
								TeamGuy(x).Magic = TeamGuy(x).MaxMagic
							NEXT x
							PRINT "sets up the tent."
							PRINT "everyone's HP/MP"
							PRINT "restored!"
							Invent$(SubCurSel) = ""
						ELSE
							PRINT "cannot use the"
							PRINT "tent here!"
						END IF
					CASE "HEALTH POTION"
						TeamGuy(j).Health = TeamGuy(j).Health + 50
						IF TeamGuy(j).Health > TeamGuy(j).MaxHealth THEN TeamGuy(j).Health = TeamGuy(j).MaxHealth
						PRINT "healed 50 HP"
						COLOR 15: PRINT "Health:"; TeamGuy(j).Health
						Invent$(SubCurSel) = ""
					CASE "MAGIC POTION"
						TeamGuy(j).Magic = TeamGuy(j).MaxMagic
						PRINT "recovers all MP!"
						COLOR 15: PRINT "MP:"; TeamGuy(j).Magic
						Invent$(SubCurSel) = ""
					CASE "SUPER HEALTH POTION"
						TeamGuy(j).Health = TeamGuy(j).Health + 500
						IF TeamGuy(j).Health > TeamGuy(j).MaxHealth THEN TeamGuy(j).Health = TeamGuy(j).MaxHealth
						PRINT "healed 500 HP"
						COLOR 15: PRINT "Health:"; TeamGuy(j).Health
						Invent$(SubCurSel) = ""
					CASE "WORKER COSTUME"
						PRINT "likes the texture of it."
					CASE "AUTOGRAPH"
						PRINT "says 'What a shitty"
						PRINT "reward!'."
					CASE "BOMB"
						PRINT "says 'What is it?'"
					CASE "MEDALLION"
						PRINT "won it from Dread."
					CASE "BEACON"
						PRINT "looks at the device."
					CASE "WOOD STICK", "METAL POLE", "SPIKED POLE", "JAVELIN", "IRON SWORD", "STEEL SWORD", "KATANA", "SPIRIT BLADE", "ASSAULT RIFLE", "BLASTER"
						TempStr$ = ""
						IF RTRIM$(TeamGuy(j).Weapon) <> "fist" THEN TempStr$ = TeamGuy(j).Weapon
						TeamGuy(j).Weapon = Invent$(SubCurSel)
						Invent$(SubCurSel) = RTRIM$(TempStr$)
						PRINT "equips "; TeamGuy(j).Weapon; ""
						IF TempStr$ <> "" THEN PRINT "and unequips "; Invent$(SubCurSel)
					CASE "WOODEN AXE", "HEAVY AXE", "GOLDEN AXE", "MONSTER AXE"
						IF RTRIM$(TeamGuy(j).Charname) = "Malcolm" OR RTRIM$(TeamGuy(j).Charname) = "Kalrin" THEN
							PRINT "Cannot equip it!"
						ELSE
							TempStr$ = ""
							IF RTRIM$(TeamGuy(j).Weapon) <> "fist" THEN TempStr$ = TeamGuy(j).Weapon
							TeamGuy(j).Weapon = Invent$(SubCurSel)
							Invent$(SubCurSel) = RTRIM$(TempStr$)
							PRINT "equips "; TeamGuy(j).Weapon; ""
							IF TempStr$ <> "" THEN PRINT "and unequips "; Invent$(SubCurSel)
						END IF
					CASE "CLOTH", "THICK CLOTH", "CHAIN MAIL", "KNIGHT ARMOR", "STEEL ARMOR", "SILVER ARMOR", "BATTLE SUIT", "KEVLAR SUIT", "FORCE FIELD"
						TempStr$ = ""
						TempStr$ = TeamGuy(j).Armor
						TeamGuy(j).Armor = Invent$(SubCurSel)
						Invent$(SubCurSel) = RTRIM$(TempStr$)
						PRINT "equips "; TeamGuy(j).Armor
						PRINT "and unequips "; Invent$(SubCurSel)
						IF RTRIM$(TeamGuy(j).Armor) = "cloth" THEN TeamGuy(j).Defense = 5
						IF RTRIM$(TeamGuy(j).Armor) = "thick cloth" THEN TeamGuy(j).Defense = 8
						IF RTRIM$(TeamGuy(j).Armor) = "chain mail" THEN TeamGuy(j).Defense = 10
						IF RTRIM$(TeamGuy(j).Armor) = "knight armor" THEN TeamGuy(j).Defense = 16
						IF RTRIM$(TeamGuy(j).Armor) = "steel armor" THEN TeamGuy(j).Defense = 22
						IF RTRIM$(TeamGuy(j).Armor) = "silver armor" THEN TeamGuy(j).Defense = 30
						IF RTRIM$(TeamGuy(j).Armor) = "battle suit" THEN TeamGuy(j).Defense = 40
						IF RTRIM$(TeamGuy(j).Armor) = "kevlar suit" THEN TeamGuy(j).Defense = 65
						IF RTRIM$(TeamGuy(j).Armor) = "force field" THEN TeamGuy(j).Defense = 80
					CASE "RECOVERY RAY", "RECOVERY BLAST", "SUPER RECOVERY", "TOTAL HEALTH", "ELECTRIC SHOCK", "FIREBALL", "PLASMA BURST", "FIRESTORM", "BIG FIREBALL", "LIGHT BEAM"
						IF TeamGuy(j).MaxMagic = 0 THEN
							PRINT "can't learn magic"
						ELSE
							PRINT "learns the spell of"
							COLOR 14: PRINT Invent$(SubCurSel)
							FOR k% = 1 TO 20
								IF Invent$(SubCurSel) = RTRIM$(SpellInfo(k%).SpellName) THEN
									Spells(j, k%) = k%
									Invent$(SubCurSel) = ""
									EXIT FOR
								END IF
							NEXT k%
						END IF
					CASE "SHOCKWAVE", "ENERGY BALL", "ARC IMPULSE", "MEGAZAP", "SCORCHED EARTH", "LIGHTNING BOLT", "DISRUPTOR CHARGE", "POWER SURGE", "DEATH RAY", "HAND OF DOOM"
						IF TeamGuy(j).MaxMagic = 0 THEN
							PRINT "can't learn magic"
						ELSE
							PRINT "learns the spell of"
							COLOR 14: PRINT Invent$(SubCurSel)
							FOR k% = 1 TO 20
								IF Invent$(SubCurSel) = RTRIM$(SpellInfo(k%).SpellName) THEN
									Spells(j, k%) = k%
									Invent$(SubCurSel) = ""
									EXIT FOR
								END IF
							NEXT k%
						END IF
				END SELECT
				WHILE INKEY$ = "": WEND
				LINE (0, 0)-(200, 100), 0, BF
			END IF
			IF j = 5 THEN
				SELECT CASE UCASE$(Invent$(SubCurSel))
				CASE "AUTOGRAPH", "WORKER COSTUME", "BOMB", "RED KEYSTONE", "GREEN KEYSTONE", "BLUE KEYSTONE", "MEDALLION", "BEACON", "ANTI-SHIELD DEVICE"
					COLOR 4
					PRINT "Cannot drop!"
				CASE ELSE
					COLOR 14: PRINT Invent$(SubCurSel);
					COLOR 15: PRINT " dropped!"
					Invent$(SubCurSel) = ""
				END SELECT
				WHILE INKEY$ = "": WEND
				LINE (0, 0)-(200, 100), 0, BF
			END IF
		END IF
		IF SubCurSel < SubScreen THEN SubScreen = SubCurSel
		IF SubCurSel > (SubScreen + 10) THEN SubScreen = SubCurSel - 10
	WEND
	LINE (0, 0)-(200, 100), 0, BF
RETURN

MagicSub:
	SubCurSel = 1
	SubChar = 1
	SubScreen = 1
	LINE (0, 0)-(200, 100), 0, BF
	COLOR 15: LOCATE 1, 1: PRINT "Whose magic do you"
	PRINT "want to look at?"
	PRINT "1) "; TeamGuy(1).Charname
	PRINT "2) "; TeamGuy(2).Charname
	PRINT "3) "; TeamGuy(3).Charname
	PRINT "4) "; TeamGuy(4).Charname
	COLOR 13
	j$ = ""
	WHILE j$ = "": j$ = INKEY$
	WEND
	SubChar = VAL(j$)
	IF SubChar < 1 OR SubChar > 4 THEN
		LINE (0, 0)-(200, 100), 0, BF
		RETURN
	END IF
	IF TeamGuy(SubChar).MaxMagic = 0 THEN
		PRINT "Cannot use magic"
		WHILE INKEY$ = "": WEND
		LINE (0, 0)-(200, 100), 0, BF
		RETURN
	END IF
	i$ = ""
	COLOR 7
	LINE (0, 0)-(200, 100), 0, BF
	WHILE i$ <> CHR$(27)
		i$ = INKEY$
		LOCATE 1, 1
		FOR x = SubScreen TO (SubScreen + 10)
			IF x = SubCurSel THEN COLOR 15
			IF Spells(SubChar, x) <> 0 THEN
				PRINT SpellInfo(Spells(SubChar, x)).SpellName;
				COLOR 14
				PRINT SpellInfo(Spells(SubChar, x)).MagPoints
			ELSE
				PRINT "---"
			END IF
			COLOR 7
		NEXT x
		COLOR 13
		PRINT "Magic:"; TeamGuy(SubChar).Magic; "/"; TeamGuy(SubChar).MaxMagic
		COLOR 7
		LOCATE 1, 23: PRINT "^"
		LOCATE 11, 23: PRINT "v"
		IF i$ = UPVAR$ THEN
			LINE (0, 0)-(200, 100), 0, BF
			SubCurSel = SubCurSel - 1
			IF SubCurSel < 1 THEN SubCurSel = 20
		END IF
		IF i$ = DOWNVAR$ THEN
			LINE (0, 0)-(200, 100), 0, BF
			SubCurSel = SubCurSel + 1
			IF SubCurSel > 20 THEN SubCurSel = 1
		END IF
		IF (i$ = CHR$(13) OR i$ = " ") AND Spells(SubChar, SubCurSel) > 0 THEN
			LINE (0, 0)-(200, 100), 0, BF
			LOCATE 1, 1
			COLOR 14
			IF TeamGuy(SubChar).Magic < SpellInfo(SubCurSel).MagPoints THEN
				COLOR 4
				LOCATE 1, 1
				PRINT "Not enough Magic!"
			ELSE
				SELECT CASE SpellInfo(SubCurSel).HitWho
					CASE 1
						COLOR 15
						Healthy% = TeamGuy(SubChar).Intel * SpellInfo(SubCurSel).MagPoints + (TeamGuy(SubCurSel).Level * SpellInfo(SubCurSel).MagPoints)
						PRINT "Who do you want to heal?"
						PRINT "1) "; TeamGuy(1).Charname
						PRINT "2) "; TeamGuy(2).Charname
						PRINT "3) "; TeamGuy(3).Charname
						PRINT "4) "; TeamGuy(4).Charname
						COLOR 13
						j$ = ""
						WHILE j$ = "": j$ = INKEY$
						WEND
						k% = VAL(j$)
						IF k% > 0 AND k% < 5 THEN
							TeamGuy(k%).Health = TeamGuy(k%).Health + Healthy%
							IF TeamGuy(k%).Health > TeamGuy(k%).MaxHealth THEN TeamGuy(k%).Health = TeamGuy(k%).MaxHealth
							COLOR 14
							PRINT TeamGuy(k%).Charname
							PRINT "was healed by "; Healthy%; "HP"
							PRINT "Health: "; TeamGuy(k%).Health; "/"; TeamGuy(k%).MaxHealth
							TeamGuy(SubChar).Magic = TeamGuy(SubChar).Magic - SpellInfo(SubCurSel).MagPoints
						ELSE
							COLOR 4
							PRINT "Invalid selection"
						END IF
					CASE 2, 4
						COLOR 4
						PRINT "That spell can only"
						PRINT "be used in battle!"
					CASE 3
						Healthy% = TeamGuy(SubChar).Intel * SpellInfo(SubCurSel).MagPoints + (TeamGuy(SubCurSel).Level * SpellInfo(SubCurSel).MagPoints)
						Healthy% = INT(Healthy% / 4)
						FOR k% = 1 TO 4
							TeamGuy(k%).Health = TeamGuy(k%).Health + Healthy%
							IF TeamGuy(k%).Health > TeamGuy(k%).MaxHealth THEN TeamGuy(k%).Health = TeamGuy(k%).MaxHealth
						NEXT k%
						TeamGuy(SubChar).Magic = TeamGuy(SubChar).Magic - SpellInfo(SubCurSel).MagPoints
						PRINT "Everyone was healed by"
						PRINT Healthy%; "HP"
				END SELECT
			END IF
			WHILE INKEY$ = "": WEND
			LINE (0, 0)-(200, 100), 0, BF
		END IF
		IF SubCurSel < SubScreen THEN SubScreen = SubCurSel
		IF SubCurSel > (SubScreen + 10) THEN SubScreen = SubCurSel - 10
	WEND
	LINE (0, 0)-(200, 100), 0, BF
RETURN

SaveGame:
	LINE (0, 0)-(200, 100), 0, BF
	IF LEFT$(UCASE$(enemtype$), 5) <> "WORLD" AND enemtype$ <> "None" THEN
		LOCATE 1, 1: PRINT "Cannot save here!"
		WHILE INKEY$ = "": WEND
		LINE (0, 0)-(200, 100), 0, BF
		RETURN
	END IF
	INPUT "Filename:", SaveFile$
	OPEN "savegame\" + SaveFile$ FOR OUTPUT AS #1
		PRINT #1, Filnam$
		PRINT #1, XPos
		PRINT #1, YPos
		FOR x = 1 TO 100
			PRINT #1, Invent$(x)
		NEXT x
		FOR x = 1 TO 200
			PRINT #1, CHR$(BoxOpened(x) + 65);
		NEXT x
		FOR x = 1 TO 4
			PRINT #1, ""
			FOR y = 1 TO 20
				PRINT #1, CHR$(Spells(x, y) + 65);
			NEXT y
		NEXT x
		PRINT #1, ""
		PRINT #1, Gold
		FOR x = 1 TO 4
			PRINT #1, TeamGuy(x).Charname
			PRINT #1, TeamGuy(x).Level
			PRINT #1, TeamGuy(x).Experience
			PRINT #1, TeamGuy(x).Health
			PRINT #1, TeamGuy(x).MaxHealth
			PRINT #1, TeamGuy(x).Magic
			PRINT #1, TeamGuy(x).MaxMagic
			PRINT #1, TeamGuy(x).Strength
			PRINT #1, TeamGuy(x).Intel
			PRINT #1, TeamGuy(x).Agility
			PRINT #1, TeamGuy(x).Defense
			PRINT #1, TeamGuy(x).Weapon
			PRINT #1, TeamGuy(x).Armor
		NEXT x
	CLOSE #1
	LINE (0, 0)-(200, 100), 0, BF
RETURN

LoadGame:
	OPEN "savegame\" + SaveFile$ FOR INPUT AS #1
		LINE INPUT #1, Filnam$
		INPUT #1, XPos
		INPUT #1, YPos
		FOR x = 1 TO 100
			LINE INPUT #1, Invent$(x)
		NEXT x
		LINE INPUT #1, TempStr$
		FOR x = 1 TO 200
			BoxOpened(x) = ASC(MID$(TempStr$, x, 1)) - 65
		NEXT x
		FOR x = 1 TO 4
			LINE INPUT #1, TempStr$
			FOR y = 1 TO 20
				Spells(x, y) = ASC(MID$(TempStr$, y, 1)) - 65
			NEXT y
		NEXT x
		INPUT #1, Gold
		FOR x = 1 TO 4
			LINE INPUT #1, TeamGuy(x).Charname
			INPUT #1, TeamGuy(x).Level
			INPUT #1, TeamGuy(x).Experience
			INPUT #1, TeamGuy(x).Health
			INPUT #1, TeamGuy(x).MaxHealth
			INPUT #1, TeamGuy(x).Magic
			INPUT #1, TeamGuy(x).MaxMagic
			INPUT #1, TeamGuy(x).Strength
			INPUT #1, TeamGuy(x).Intel
			INPUT #1, TeamGuy(x).Agility
			INPUT #1, TeamGuy(x).Defense
			LINE INPUT #1, TeamGuy(x).Weapon
			LINE INPUT #1, TeamGuy(x).Armor
		NEXT x
	CLOSE #1
RETURN

SetSpells:
	OPEN "dat\magic.dat" FOR INPUT AS #1
		FOR x = 0 TO 20
			LINE INPUT #1, SpellInfo(x).SpellName
			INPUT #1, SpellInfo(x).HitWho
			INPUT #1, SpellInfo(x).MagPoints
		NEXT x
	CLOSE #1
RETURN

SelectAttackEnemy:
	act2$ = ""
	LowestHealth% = 7500
	IF EnemHealth(EnemSel) < 1 THEN
		FOR FindLow% = 1 TO EnemGroupAttack
			IF EnemHealth(FindLow%) < LowestHealth% AND EnemHealth(FindLow%) > 0 THEN EnemSel = FindLow%
		NEXT FindLow%
	END IF
	WHILE act2$ <> " " AND act2$ <> CHR$(13)
		Aero% = (EnemSel - 1) * 60
		LINE (Aero% + 30, 106)-(Aero% + 30, 116), 15
		LINE (Aero% + 25, 110)-(Aero% + 30, 106), 15
		LINE (Aero% + 30, 106)-(Aero% + 35, 110), 15
		act2$ = INKEY$
		IF act2$ = LEFTVAR$ THEN
			DO
				EnemSel = EnemSel - 1
				IF EnemSel < 1 THEN EnemSel = EnemGroupAttack
			LOOP WHILE EnemHealth(EnemSel) < 1
			LINE (Aero% + 25, 106)-(Aero% + 35, 116), 0, BF
		END IF
		IF act2$ = RIGHTVAR$ THEN
			DO
				EnemSel = EnemSel + 1
				IF EnemSel > EnemGroupAttack THEN EnemSel = 1
			LOOP WHILE EnemHealth(EnemSel) < 1
			LINE (Aero% + 25, 106)-(Aero% + 35, 116), 0, BF
		END IF
	WEND
	LINE (Aero% + 30, 106)-(Aero% + 30, 116), 0
	LINE (Aero% + 25, 110)-(Aero% + 30, 106), 0
	LINE (Aero% + 30, 106)-(Aero% + 35, 110), 0
	Action$(TeamDude) = "KILL:" + STR$(EnemSel)
RETURN

SelectMagicSpell:
	LINE (0, 110)-(320, 200), 0, BF
	SubScreen = 1
	SubCurSel = 1
	TempStr$ = "ENTER"
	WHILE TempStr$ <> "EXIT"
		i$ = INKEY$
		LOCATE 17, 1
		FOR x = SubScreen TO (SubScreen + 5)
			IF x = SubCurSel THEN COLOR 15
			IF Spells(TeamDude, x) <> 0 THEN
				PRINT SpellInfo(Spells(TeamDude, x)).SpellName;
				COLOR 14
				PRINT SpellInfo(Spells(TeamDude, x)).MagPoints
			ELSE
				PRINT "---"
			END IF
			COLOR 7
		NEXT x
		COLOR 13
		PRINT "Magic:"; TeamGuy(TeamDude).Magic; "/"; TeamGuy(TeamDude).MaxMagic
		COLOR 7
		LOCATE 17, 23: PRINT "^"
		LOCATE 22, 23: PRINT "v"
		IF i$ = CHR$(27) THEN
			LINE (0, 110)-(320, 200), 0, BF
			TempStr$ = "EXIT"
			act$ = ""
		END IF
		IF i$ = UPVAR$ THEN
			LINE (0, 110)-(320, 200), 0, BF
			SubCurSel = SubCurSel - 1
			IF SubCurSel < 1 THEN SubCurSel = 20
		END IF
		IF i$ = DOWNVAR$ THEN
			LINE (0, 110)-(320, 200), 0, BF
			SubCurSel = SubCurSel + 1
			IF SubCurSel > 20 THEN SubCurSel = 1
		END IF
		IF (i$ = CHR$(13) OR i$ = " ") AND Spells(TeamDude, SubCurSel) > 0 THEN
			LINE (0, 110)-(320, 200), 0, BF
			COLOR 14
			IF TeamGuy(TeamDude).Magic < SpellInfo(SubCurSel).MagPoints THEN
				COLOR 4
				LOCATE 17, 1
				PRINT "Not enough Magic!"
				act$ = ""
			ELSE
				IF SpellInfo(Spells(TeamDude, SubCurSel)).HitWho = 1 THEN
					LOCATE 17, 1
					PRINT "1)"; TeamGuy(1).Charname
					PRINT "2)"; TeamGuy(2).Charname
					PRINT "3)"; TeamGuy(3).Charname
					PRINT "4)"; TeamGuy(4).Charname
					WhoToHeal$ = ""
					WhoToHealINT% = 0
					WHILE WhoToHealINT% < 1 OR WhoToHeal% > 4
						WhoToHeal$ = INKEY$
						WhoToHealINT% = VAL(WhoToHeal$)
					WEND
					Action$(TeamDude) = "HEAL:" + UCASE$(SpellInfo(Spells(TeamDude, SubCurSel)).SpellName) + " " + WhoToHeal$
					LINE (0, 110)-(320, 200), 0, BF
				END IF
				IF SpellInfo(Spells(TeamDude, SubCurSel)).HitWho = 3 THEN
					Action$(TeamDude) = "ALLHEAL:" + UCASE$(SpellInfo(Spells(TeamDude, SubCurSel)).SpellName)
				END IF
				IF SpellInfo(Spells(TeamDude, SubCurSel)).HitWho = 2 THEN
					Action$(TeamDude) = "MAGIC:" + UCASE$(SpellInfo(Spells(TeamDude, SubCurSel)).SpellName)
					GOSUB SelectMagicEnemy
				END IF
				IF SpellInfo(Spells(TeamDude, SubCurSel)).HitWho = 4 THEN
					Action$(TeamDude) = "ALLMAGIC:" + UCASE$(SpellInfo(Spells(TeamDude, SubCurSel)).SpellName)
				END IF
				TempStr$ = "EXIT"
			END IF
		END IF
		IF SubCurSel < SubScreen THEN SubScreen = SubCurSel
		IF SubCurSel > (SubScreen + 5) THEN SubScreen = SubCurSel - 5
	WEND
RETURN

SelectItemToUse:
	LINE (0, 110)-(320, 200), 0, BF
	COLOR 7
	SubScreen = 1
	SubCurSel = 1
	TempStr$ = "ENTER"
	WHILE TempStr$ <> "EXIT"
		i$ = INKEY$
		LOCATE 17, 1
		FOR x = SubScreen TO (SubScreen + 5)
			IF x = SubCurSel THEN COLOR 15
			IF Invent$(x) <> "" THEN
				PRINT Invent$(x)
			ELSE
				PRINT "---"
			END IF
			COLOR 7
		NEXT x
		LOCATE 17, 23: PRINT "^"
		LOCATE 22, 23: PRINT "v"
		IF i$ = CHR$(27) THEN
			LINE (0, 110)-(320, 200), 0, BF
			act$ = ""
			TempStr$ = "EXIT"
		END IF
		IF i$ = UPVAR$ THEN
			LINE (0, 110)-(320, 200), 0, BF
			SubCurSel = SubCurSel - 1
			IF SubCurSel < 1 THEN SubCurSel = 100
		END IF
		IF i$ = DOWNVAR$ THEN
			LINE (0, 110)-(320, 200), 0, BF
			SubCurSel = SubCurSel + 1
			IF SubCurSel > 100 THEN SubCurSel = 1
		END IF
		IF i$ = CHR$(13) OR i$ = " " THEN
			LINE (0, 110)-(320, 200), 0, BF
			SELECT CASE UCASE$(Invent$(SubCurSel))
				CASE "HEALTH POTION", "SUPER HEALTH POTION", "MAGIC POTION"
					LOCATE 17, 1
					COLOR 14
					PRINT "Who will it be used on?"
					COLOR 13
					PRINT "1)"; TeamGuy(1).Charname
					PRINT "2)"; TeamGuy(2).Charname
					PRINT "3)"; TeamGuy(3).Charname
					PRINT "4)"; TeamGuy(4).Charname
					j$ = ""
					WHILE j$ = ""
						j$ = INKEY$
						j% = VAL(j$)
						IF j% < 1 OR j% > 4 THEN j$ = ""
					WEND
					IF UCASE$(Invent$(SubCurSel)) = "HEALTH POTION" THEN
						Invent$(SubCurSel) = ""
						Action$(TeamDude) = "ITEM:NHPT" + STR$(j%)
					END IF
					IF UCASE$(Invent$(SubCurSel)) = "MAGIC POTION" THEN
						Invent$(SubCurSel) = ""
						Action$(TeamDude) = "ITEM:MPPT" + STR$(j%)
					END IF
					IF UCASE$(Invent$(SubCurSel)) = "SUPER HEALTH POTION" THEN
						Invent$(SubCurSel) = ""
						Action$(TeamDude) = "ITEM:SHPT" + STR$(j%)
					END IF
					LINE (0, 110)-(320, 200), 0, BF
				CASE ELSE
					COLOR 4
					LOCATE 19, 1
					PRINT "Can't use!"
					WHILE INKEY$ = "": WEND
					act$ = ""
			END SELECT
			TempStr$ = "EXIT"
		END IF
		IF SubCurSel < SubScreen THEN SubScreen = SubCurSel
		IF SubCurSel > (SubScreen + 5) THEN SubScreen = SubCurSel - 5
	WEND
RETURN

SelectMagicEnemy:
	act2$ = ""
	LowestHealth% = 7500
	IF EnemHealth(EnemSel) < 1 THEN
		FOR FindLow% = 1 TO EnemGroupAttack
			IF EnemHealth(FindLow%) < LowestHealth% AND EnemHealth(FindLow%) > 0 THEN EnemSel = FindLow%
		NEXT FindLow%
	END IF
	WHILE act2$ <> " " AND act2$ <> CHR$(13)
		Aero% = (EnemSel - 1) * 60
		LINE (Aero% + 30, 106)-(Aero% + 30, 116), 15
		LINE (Aero% + 25, 110)-(Aero% + 30, 106), 15
		LINE (Aero% + 30, 106)-(Aero% + 35, 110), 15
		act2$ = INKEY$
		IF act2$ = LEFTVAR$ THEN
			DO
				EnemSel = EnemSel - 1
				IF EnemSel < 1 THEN EnemSel = EnemGroupAttack
			LOOP WHILE EnemHealth(EnemSel) < 1
			LINE (Aero% + 25, 106)-(Aero% + 35, 116), 0, BF
		END IF
		IF act2$ = RIGHTVAR$ THEN
			DO
				EnemSel = EnemSel + 1
				IF EnemSel > EnemGroupAttack THEN EnemSel = 1
			LOOP WHILE EnemHealth(EnemSel) < 1
			LINE (Aero% + 25, 106)-(Aero% + 35, 116), 0, BF
		END IF
	WEND
	LINE (Aero% + 30, 106)-(Aero% + 30, 116), 0
	LINE (Aero% + 25, 110)-(Aero% + 30, 106), 0
	LINE (Aero% + 30, 106)-(Aero% + 35, 110), 0
	Action$(TeamDude) = Action$(TeamDude) + STR$(EnemSel)
RETURN

REM $STATIC
DEFSNG X-Y
SUB DRAWCHAR (WhichOne$, Position%, XPos%, YPos%)
	SELECT CASE Position%
	CASE 1
		OPEN "img\" + WhichOne$ FOR INPUT AS #1
			FOR loading% = 1 TO 75
				LINE INPUT #1, TempStr$
				FOR loading2% = 1 TO 60
					colorval% = ASC(MID$(TempStr$, loading2%, 1)) - 33
					IF colorval% > 0 THEN PSET (XPos% + loading2%, YPos% + loading%), colorval%
				NEXT loading2%
			NEXT loading%
		CLOSE #1
	CASE 3
		OPEN "img\" + WhichOne$ FOR INPUT AS #1
			FOR loading% = 1 TO 75
				LINE INPUT #1, TempStr$
				FOR loading2% = 1 TO 60
					colorval% = ASC(MID$(TempStr$, (61 - loading2%), 1)) - 33
					IF colorval% > 0 THEN PSET (XPos% + loading2%, YPos% + loading%), colorval%
				NEXT loading2%
			NEXT loading%
		CLOSE #1
	CASE 2
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + ".spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + ".msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	CASE 8
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + "B.spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + "B.msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	CASE 4
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + "L.spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + "L.msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	CASE 6
		DEF SEG = VARSEG(CharSpr(0))
		BLOAD "sprmsk\" + WhichOne$ + "R.spr", VARPTR(CharSpr(0))
		DEF SEG = VARSEG(CharMsk(0))
		BLOAD "sprmsk\" + WhichOne$ + "R.msk", VARPTR(CharMsk(0))
		PUT (XPos%, YPos% - 15), CharMsk, AND
		PUT (XPos%, YPos% - 15), CharSpr, OR
	END SELECT
END SUB

SUB Exceptional (xloc, yloc, block%)
	SELECT CASE block%
		CASE 3
			LINE (xloc, yloc)-(xloc + 14, yloc + 14), 1, BF
			FOR x = 1 TO 5
				PSET (xloc + RND * 14, yloc + RND * 14), 9
			NEXT x
		CASE 13
			LINE (xloc, yloc)-(xloc + 14, yloc + 14), 4, BF
			FOR x = 1 TO 5
				PSET (xloc + RND * 14, yloc + RND * 14), 14
			NEXT x
		CASE 25
			LINE (xloc, yloc - 7)-(xloc + 14, yloc), 15, B
			LINE (xloc + 1, yloc - 6)-(xloc + 13, yloc - 1), 28, BF
		CASE 27
			LINE (xloc, yloc - 7)-(xloc + 14, yloc), 7, B
			LINE (xloc + 1, yloc - 6)-(xloc + 13, yloc - 1), 23, BF
		CASE 28, 29
			LINE (xloc + 7, yloc - 2)-(xloc + 8, yloc - 1), 0, B
		CASE 32
			LINE (xloc - 14, yloc - 14)-(xloc + 13, yloc + 13), 43, BF
			LINE (xloc - 15, yloc - 15)-(xloc - 1, yloc + 14), 6, B
			LINE (xloc, yloc - 15)-(xloc + 14, yloc + 14), 6, B
		CASE 35
			LINE (xloc, yloc)-(xloc + 14, yloc + 14), 6, BF
			FOR x = 1 TO 5
				PSET (xloc + RND * 14, yloc + RND * 14), 2
			NEXT x
		CASE 62
			LINE (xloc, yloc)-(xloc + 14, yloc + 14), 2, BF
			FOR x = 1 TO 5
				PSET (xloc + RND * 14, yloc + RND * 14), 10
			NEXT x
		CASE 66
			LINE (xloc, yloc)-(xloc + 14, yloc + 14), (yloc / 20) + 80, BF
	 END SELECT
END SUB

SUB Itemize (xloc, yloc, block$)
	block$ = UCASE$(block$)
	IF block$ <> "" THEN
		SELECT CASE block$
			CASE "DUDE", "DUDE1", "DUDE2", "DUDE3", "DUDEG", "DUDEB", "TREASURE", "KING", "TARA", "COLUMN", "KINGSTAT", "COLE", "LAMP", "DAMYDUDE"
				DEF SEG = VARSEG(CharSpr(0))
				BLOAD "sprmsk\" + block$ + ".SPR", VARPTR(CharSpr(0))
				DEF SEG = VARSEG(CharMsk(0))
				BLOAD "sprmsk\" + block$ + ".MSK", VARPTR(CharMsk(0))
				IF yloc >= 15 THEN
					PUT (xloc, yloc - 15), CharMsk, AND
					PUT (xloc, yloc - 15), CharSpr, OR
				END IF
			CASE "STEAM", "TORCH", "RSTONE", "GSTONE", "BSTONE"
				DEF SEG = VARSEG(CharSpr(0))
				IF AnimFrame = 1 THEN BLOAD "sprmsk\" + block$ + "1.SPR", VARPTR(CharSpr(0))
				IF AnimFrame = 2 THEN BLOAD "sprmsk\" + block$ + "2.SPR", VARPTR(CharSpr(0))
				DEF SEG = VARSEG(CharMsk(0))
				IF AnimFrame = 1 THEN BLOAD "sprmsk\" + block$ + "1.MSK", VARPTR(CharMsk(0))
				IF AnimFrame = 2 THEN BLOAD "sprmsk\" + block$ + "2.MSK", VARPTR(CharMsk(0))
				IF yloc >= 15 THEN
					PUT (xloc, yloc - 15), CharMsk, AND
					PUT (xloc, yloc - 15), CharSpr, OR
				END IF
		END SELECT
	END IF
END SUB

DEFINT A-Z
SUB LoadFont

DIM Counter, Char$

Char$ = " "
Counter = 0

OPEN "dat\font8x6.dat" FOR BINARY AS #1

FOR i = 32 TO 126
 FOR j = 1 TO 6
  Counter = Counter + 1
  GET #1, Counter, Char$
  Number = ASC(Char$)
  FOR k = 7 TO 0 STEP -1
   IF 2 ^ k > Number THEN CharSet(i, 8 - k, 7 - j) = 0 ELSE Number = Number - 2 ^ k: CharSet(i, 8 - k, 7 - j) = 1
  NEXT k
 NEXT j
NEXT i

CLOSE #1

END SUB

DEFSNG A-W, Z
SUB pausit (ticker%)
	DEF SEG = &H40
	POKE &H1A, PEEK(&H1C)
	POKE &H1B, PEEK(&H1D)
	DEF SEG
	ticker = ticker / 100
	ticker2 = TIMER
	WHILE (TIMER - ticker2) < ticker
	WEND
END SUB

DEFSNG X-Y
SUB PUTTEXT (Text$, C, XPos, YPos, Adj)
	IF XPos = -1 THEN XPos = 160 - LEN(Text$) * 3
	FOR i = 1 TO LEN(Text$)
		Char = ASC(MID$(Text$, i, 1))
			FOR j = 1 TO 8
				FOR k = 1 TO 6
					IF CharSet(Char, j, k) = 1 THEN
					PSET (XPos + k + (i * 6) - 6, YPos + j), C + (Adj * j)
					PSET (XPos + k + (i * 6) - 6, YPos + j + 1), 0
				END IF
			NEXT k
		NEXT j
	NEXT i
END SUB

DEFINT X-Y
SUB RGB (palval%, redval%, grnval%, bluval%)
  IF redval% < 0 THEN redval% = 0
  IF redval% > 63 THEN redval% = 63
  IF grnval% < 0 THEN grnval% = 0
  IF grnval% > 63 THEN grnval% = 63
  IF bluval% < 0 THEN bluval% = 0
  IF bluval% > 63 THEN bluval% = 63
  OUT &H3C8, palval%
  OUT &H3C9, redval%
  OUT &H3C9, grnval%
  OUT &H3C9, bluval%
END SUB

