#include <cmkey.h>
#include "global.h"

extern char far *vga;
extern Star_t 	stars[400];
extern Ship_t	CapSpace;

void PlayGame(void)
{
	int quit = 0;

	DrawShip();
	installkeyhandler();
	while (!quit)
	{
		if (keys[1])
			quit = 1;
		if ((keys[LEFT] || ekeys[LEFT]) && (CapSpace.x > 1))
		{
			EraseShip();
			CapSpace.x--;
			DrawShip();
		}
		if ((keys[RIGHT] || ekeys[RIGHT]) && (CapSpace.x < 302))
		{
			EraseShip();
			CapSpace.x++;
			DrawShip();
		}
		if ((keys[UP] || ekeys[UP]) && ((CapSpace.y + 4) > 1))
		{
			EraseShip();
			CapSpace.y--;
			DrawShip();
		}
		if ((keys[DOWN] || ekeys[DOWN]) && ((CapSpace.y + 12 < 199)))
		{
			EraseShip();
			CapSpace.y++;
			DrawShip();
		}

		for (int t = 0; t < NUMSTARS; t++)
		{
			vga[stars[t].x + stars[t].y * 320] = 0;

			if (stars[t].delaycounter == stars[t].brightness)
			{
				stars[t].delaycounter = 0;
				stars[t].x++;
			}
			else
				stars[t].delaycounter++;

			if ((stars[t].x > CapSpace.x) && (stars[t].x < (CapSpace.x + 16)))
				if ((stars[t].y > (CapSpace.y + 4)) && (stars[t].y < (CapSpace.y + 12)))
				{
					Die();
					quit = 1;
				}

			if (stars[t].x == 320)
			{
				stars[t].x = 0;
				stars[t].y = rand() % 200;
				stars[t].brightness = rand() % 5;
			}
			vga[stars[t].x + stars[t].y * 320] =
				25 + stars[t].brightness;
		}
		delay(5);
	}
	uninstallkeyhandler();
}