Unit GraphLib;

Interface

Uses MouseTpu,Dos;

Const
      VGA256 = $13;
      TextMode = 3;
      PalMask = $36C;
      PalRegR = $3C7;
      PalRegW = $3C8;
      PalData = $3C9;

Type TVidBuf = Array[1..64100] of Byte;
     TSpr = Array[0..15,0..15] of byte;
     TFont = Array[128..239,1..8] of byte;
     TMouseBuf = Array[1..16,1..16] of byte;

Var DoubleBuf : ^TVidBuf;
    GetBack : Byte;
    Fnt : ^TFont;
    Int1CSave : Pointer;
    MouseVis : Boolean;
    MouseX,MouseY : Integer;
    MouseBuf : ^TMouseBuf;
    MouseFile : File of TSpr;
    MouseSpr : ^TSpr;

Procedure Pixel(x,y : Word; Color : Byte);
Procedure PixelD(x,y : Word; Color : Byte);
Procedure SetMode(Mode : Byte);
Procedure SetPalReg(index,Red,Green,Blue : Byte);
Procedure ClrVid(color : Byte);
Procedure ClrVid2(color : Byte);
Procedure Print(S : String;x,y : Word; color : Byte);
Procedure PrintD(S : String;x,y : Word; color : Byte);
Procedure DrawSprite(Spr : TSpr;x,y : Word);
Procedure DrawSpriteD(Spr : TSpr;x,y : Word);
Procedure DrawSpriteT(Spr : TSpr;x,y : Word);
Procedure ReadUnderMouse;
Procedure ShowUnderMouse;
Procedure ShowMous;
Procedure ShowMous2;
Procedure ShowDouble;
Procedure ShowMouse;
Procedure HideMouse;
Procedure MakePal;
Procedure GrInit;
Procedure GrDone;

Implementation

Procedure SetMode(Mode : Byte); assembler;
Asm
  Mov AH,0
  Mov AL,Mode
  Int 16
End;

Procedure Pixel(x,y : Word; Color : Byte); assembler;
Asm
  Mov ax,$A000
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  Mov al,Byte Ptr color
  Mov es : [di],al
End;

Procedure PixelD(x,y : Word;Color : Byte); assembler;
Asm
  Les di,DoubleBuf
  Mov ax,es
  Inc ax
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  Mov al,Byte Ptr color
  Mov es : [di],al
End;

Procedure SetPalReg(index,Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegW]:=index;
  Port[PalData]:=Red;
  Port[PalData]:=Green;
  Port[PalData]:=Blue;
End;

Procedure ShMo;
Begin
  DrawSpriteD(MouseSpr^,MouseX,MouseY);
End;

Procedure RdMo; assembler;
Asm
  Push ds
  Les di,MouseBuf
  Mov si,MouseY
  Shl si,6
  Mov bx,si
  Shl si,2
  Add si,bx
  Add si,MouseX
  Push si
  Lds si,DoubleBuf
  Mov ax,ds
  Inc ax
  Mov ds,ax
  Pop si
  Mov cx,16
  Cld
@m1 :
  Push cx
  Mov cx,8
  Rep MovsW
  Pop cx
  Add si,304
  Loop @m1
  Pop ds
End;

Procedure ShowDouble; assembler;
Asm
  Mov dl,MouseVis
  Push dx
  Mov MouseVis,0
  Cmp dl,1
  Jne @dal1
  Call RdMo
  Call ShMo
@dal1 :
  Push ds
  Mov ax,$A000
  Mov es,ax
  Mov di,0
  Mov cx,32000
  Lds si,DoubleBuf
  Mov ax,ds
  Inc ax
  Mov ds,ax
  Mov si,0
  Cld
  Rep MovsW
  Pop ds
  Pop dx
  Mov MouseVis,dl
End;

Procedure MakePal;
Var I,j : Word;
Begin
  For i:=0 to 63 do
  Begin
    j:=i+30;
    SetPalReg(i,j,j,j);
    SetPalReg(i+64,j,0,0);
    SetPalReg(i+128,0,j,0);
    SetPalReg(i+192,0,0,j);
  End;
End;

Procedure ClrVid(color : Byte); assembler;
Asm
  Mov ax,$A000
  Mov es,ax
  Mov di,0
  Mov cx,32000
  Mov ah,color
  Mov al,ah
  Cld
  Rep StosW
  Mov GetBack,al
End;

Procedure ClrVid2(color : Byte); assembler;
Asm
  Les di,DoubleBuf
  Mov ax,es
  Inc ax
  Mov es,ax
  Mov di,0
  Mov cx,32000
  Mov ah,color
  Mov al,ah
  Cld
  Rep StosW
  Mov GetBack,al
End;

Procedure Print(S : String;x,y : Word; color : Byte);
Var i,x1,y1,Off : Word;

  Procedure Prt(Ch : Char;x,y,off : Word; color : Byte);
  Var WrkSeg,WrkOff,x2,y2,TOff : Word;
  BitMask,O : Byte;
  Begin
    If Ord(Ch)<128 then
    Begin
      TOff:=Off;
      WrkSeg:=$F000+(ord(Ch) shr 1);
      WrkOff:=$FA6E+((Ord(Ch) and 1) shl 3);
      For y:=0 to 7 do
      Begin
        BitMask:=$80;
        For x:=0 to 7 do
        Begin
          If Mem[WrkSeg:WrkOff] and BitMask<>0 then Mem[$A000:(TOff+x)]:=color
            else Mem[$A000:(TOff+x)]:=GetBack;
          BitMask:=BitMask shr 1;
        End;
        Inc(TOff,320);
        Inc(WrkOff);
      End;
    End else
    Begin
      TOff:=Off;
      O:=Ord(CH);
      For y:=1 to 8 do
      Begin
        BitMask:=$80;
        For x:=0 to 7 do
        Begin
          If Fnt^[o,y] and BitMask<>0 then Mem[$A000:(TOff+x)]:=color
            else Mem[$A000:(TOff+x)]:=GetBack;
          BitMask:=BitMask shr 1;
        End;
        Inc(TOff,320);
      End;
    End;
  End;

Begin
  x1:=x;y1:=y;
  Off:=(y shl 8)+(y shl 6)+x;
  For i:=1 to length(s) do
  Begin
    Prt(s[i],x1,y1,off,color);
    Inc(x1,8);
    Inc(off,8);
  End;
End;

Procedure PrintD(S : String;x,y : Word; color : Byte);
Var Segm,i,x1,y1,Off : Word;

  Procedure PrtD(Ch : Char;x,y,off : Word; color : Byte);
  Var WrkSeg,WrkOff,x2,y2,TOff : Word;
  BitMask,O : Byte;
  Begin
    If Ord(Ch)<128 then
    Begin
      TOff:=Off;
      WrkSeg:=$F000+(ord(Ch) shr 1);
      WrkOff:=$FA6E+((Ord(Ch) and 1) shl 3);
      For y:=0 to 7 do
      Begin
        BitMask:=$80;
        For x:=0 to 7 do
        Begin
          If Mem[WrkSeg:WrkOff] and BitMask<>0 then Mem[Segm:(TOff+x)]:=color
            else Mem[Segm:(TOff+x)]:=GetBack;
          BitMask:=BitMask shr 1;
        End;
        Inc(TOff,320);
        Inc(WrkOff);
      End;
    End else
    Begin
      TOff:=Off;
      O:=Ord(CH);
      For y:=1 to 8 do
      Begin
        BitMask:=$80;
        For x:=0 to 7 do
        Begin
          If Fnt^[o,y] and BitMask<>0 then Mem[Segm:(TOff+x)]:=color
            else Mem[Segm:(TOff+x)]:=GetBack;
          BitMask:=BitMask shr 1;
        End;
        Inc(TOff,320);
      End;
    End;
  End;

Begin
  x1:=x;y1:=y;
  Off:=(y shl 8)+(y shl 6)+x;
  Asm
    Les di,DoubleBuf
    Mov ax,es
    Inc ax
    Mov Segm,ax
  End;
  For i:=1 to length(s) do
  Begin
    PrtD(s[i],x1,y1,off,color);
    Inc(x1,8);
    Inc(off,8);
  End;
End;


Procedure DrawSprite(Spr : TSpr;x,y : Word); assembler;
Asm
  Mov ax,$A000
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  lds si,spr
  mov cx,16
@Met1 :
  push cx
  mov cx,8
  rep movsw
  pop cx
  add di,304
  Loop @Met1
  Pop ds
End;

Procedure DrawSpriteT(Spr : TSpr;x,y : Word); assembler;
Asm
  Mov ax,$A000
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  lds si,spr
  mov cx,16
@Metk1 :
  push cx
  mov cx,16
@metk2 :
  Mov al,[si]
  Cmp al,0
  Je @metk3
  Mov es:[di],al
@metk3 :
  Inc si
  Inc di
  Loop @metk2
  pop cx
  add di,304
  Loop @Metk1
  Pop ds
End;


Procedure DrawSpriteD(Spr : TSpr;x,y : Word); assembler;
Asm
  Les ax,DoubleBuf
  Mov ax,es
  Inc ax
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  lds si,spr
  mov cx,16
@Me1 :
  push cx
  mov cx,16
@Me2 :
  Mov al,[si]
  Cmp al,0
  Je @Me3
  Mov es:[di],al
@Me3 :
  Inc di
  Inc si
  Loop @Me2
  pop cx
  add di,304
  Loop @Me1
  Pop ds
End;

Procedure ReadUnderMouse; assembler;
Asm
  Push ds
  Les di,MouseBuf
  Mov si,MouseY
  Shl si,6
  Mov bx,si
  Shl si,2
  Add si,bx
  Add si,MouseX
  Mov ax,$A000
  Mov ds,ax
  Mov cx,16
  Cld
@m1 :
  Push cx
  Mov cx,8
  Rep MovsW
  Pop cx
  Add si,304
  Loop @m1
  Pop ds
End;

Procedure ShowUnderMouse; assembler;
Asm
  Push ds
  Mov ax,$A000
  Mov es,ax
  Mov di,MouseY
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,MouseX
  Lds si,MouseBuf
  Cld
  Mov cx,16
@mm1 :
  Push cx
  Mov cx,8
  Rep MovsW
  Pop cx
  Add di,304
  Loop @mm1
  Pop ds
End;

Procedure ShowMous;
Begin
  DrawSpriteT(MouseSpr^,MouseX,MouseY);
End;

Procedure ShowMous2;
Begin
  DrawSpriteD(MouseSpr^,MouseX,MouseY);
End;

Procedure ShowMouse;
Var Lb,Mb,Rb : Boolean;
Begin
  ReadMouseState(MouseX,MouseY,Lb,Mb,Rb);
  MouseX:=MouseX Shr 1;
  MouseVis:=True;
  ReadUnderMouse;
  ShowMous;
End;

Procedure HideMouse;
Begin
  MouseVis:=False;
  ShowUnderMouse;
End;

{$F+,S-,W-}
procedure TimerHandler; interrupt;
Var xm,ym : Integer;
Lb,Rb,Mb : Boolean;
  begin
    { Timer ISR }
    If MouseVis then
    Begin
      ReadMouseState(xm,ym,Lb,Mb,Rb);
      If (xm Shr 1<>MouseX) or (ym<>MouseY) then
      Begin
        ShowUnderMouse;
        MouseX:=Xm Shr 1;
        MouseY:=Ym;
        If MouseX>304 then MouseX:=304;
        If MouseY>184 then MouseY:=184;
        ReadUnderMouse;
        ShowMous;
      End;
    End;
  end;
{$F-,S+}

Procedure GrInit;
Var a,b : Longint;
F : File of Byte;
Lb,Rb,Mb : Boolean;
Begin
  New(MouseSpr);
  Assign(MouseFile,'Mouse.spr');
  Reset(MouseFile);
  Read(MouseFile,MouseSpr^);
  Close(MouseFile);
  New(MouseBuf);
  MouseVis:=False;
  ResetMouse;
  GetIntVec($1C,Int1CSave);
  SetIntVec($1C,Addr(TimerHandler));
  New(DoubleBuf);
  SetMode(VGA256);
  New(Fnt);
  Assign(F,'default.fnt');
  ReSet(F);
  seek(f,13);
  For a:=128 to 239 do
    For b:=1 to 6 do
      Read(F,Fnt^[a,b]);
  Close(F);
{  MakePal;}
  GetBack:=0;
End;

Procedure GrDone;
Begin
  Dispose(DoubleBuf);
  SetMode(TextMode);
  SetIntVec($01C,Int1CSave);
End;

Begin
End.