#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include <stdlib.h>
#include "pragmas.h"

	//MUST CALL MALLOC THIS WAY TO FORCE CALLS TO KMALLOC!
void *kmalloc(size_t size) { return(malloc(size)); }
void *kkmalloc(size_t size);
#pragma aux kkmalloc =\
	"call kmalloc",\
	parm [eax]\

	//MUST CALL FREE THIS WAY TO FORCE CALLS TO KFREE!
void kfree(void *buffer) { free(buffer); }
void kkfree(void *buffer);
#pragma aux kkfree =\
	"call kfree",\
	parm [eax]\

#define XDIM 640L
#define YDIM 480L
#define MAXTILES 4096
#define MAXMOVES 4096
#define MAXRECURSION 8L
#define LOGANIMSTEPS 8

#define NUMOPTIONS 8
#define NUMKEYS 19
static char option[NUMOPTIONS];
static char keys[NUMKEYS];
static char textfont[1024];

static long digihz[7] = {6000,8000,11025,16000,22050,32000,44100};

static char board[64], startboard[64] =
{
	20,18,19,21,22,19,18,20,
	17,17,17,17,17,17,17,17,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0,
	 9, 9, 9, 9, 9, 9, 9, 9,
	12,10,11,13,14,11,10,12,
};

static char validmove[MAXRECURSION+1][64];
static char validmovecnt[MAXRECURSION+1];
static char *globalvalidptr;

static long globnodes, turn = 0, timermode = 0, reverseboard = 0;
static long recursecnt, globrecursion, movelist[4096], movelistcnt = 0;
static long c = 4, d = 4, smartness[2];
static long rank2[24], rank[24] =
{
	0,0,0,0,0,0,0,0,
	0,+1,+3,+3,+5,+15,+1024,0,
	0,-1,-3,-3,-5,-15,-1024,0
};

static char buf[4096*7], palette[768];
static short tilesizx[MAXTILES], tilesizy[MAXTILES], buf2tile[256];
static long picanm[MAXTILES];

static char *screen, vesapageshift, curpag = 255;
static short randarray[4096], randprob[1024], randcnt = 4095;
static long frameplace, ylookup[YDIM];

static char tempbuf[576];
	//ENGINE CONTROLLED MULTIPLAYER VARIABLES:
#define MAXPLAYERS 16
extern short numplayers, myconnectindex;
extern short connecthead, connectpoint2[MAXPLAYERS];   //Player linked list variables (indeces, not connection numbers)

	//Variables that let you type messages to other player
static char getmessage[162], getmessageleng;
static long getmessagetimeoff;
static char typemessage[162], typemessageleng = 0, typemode = 0;
static char scantoasc[128] =
{
	0,0,'1','2','3','4','5','6','7','8','9','0','-','=',0,0,
	'q','w','e','r','t','y','u','i','o','p','[',']',0,0,'a','s',
	'd','f','g','h','j','k','l',';',39,'`',0,92,'z','x','c','v',
	'b','n','m',',','.','/',0,'*',0,32,0,0,0,0,0,0,
	0,0,0,0,0,0,0,'7','8','9','-','4','5','6','+','1',
	'2','3','0','.',0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
static char scantoascwithshift[128] =
{
	0,0,'!','@','#','$','%','^','&','*','(',')','_','+',0,0,
	'Q','W','E','R','T','Y','U','I','O','P','{','}',0,0,'A','S',
	'D','F','G','H','J','K','L',':',34,'~',0,'|','Z','X','C','V',
	'B','N','M','<','>','?',0,'*',0,32,0,0,0,0,0,0,
	0,0,0,0,0,0,0,'7','8','9','-','4','5','6','+','1',
	'2','3','0','.',0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

volatile unsigned char keystatus[256], readch, oldreadch, extended, keytemp;
void (__interrupt __far *oldkeyhandler)();
void __interrupt __far keyhandler(void);

#define TIMERRATE (1193181/120)
volatile long totalclock, chainintrclock = 0;
void (__interrupt __far *oldtimerhandler)();
void __interrupt __far timerhandler(void);

#pragma aux vesasetmode =\
	"mov ax, 0x4f02",\
	"int 0x10",\
	"and eax, 0x0000ffff",\
	parm [ebx]\
	modify [eax ebx]\

#pragma aux vesasetpage =\
	"mov cl, vesapageshift",\
	"shl dx, cl",\
	"cmp dl, curpag",\
	"je skipsetpage",\
	"mov curpag, dl",\
	"mov ax, 0x4f05",\
	"xor bx, bx",\
	"int 0x10",\
	"skipsetpage:",\
	parm [edx]\
	modify [eax ebx ecx]\

void __interrupt __far keyhandler()
{
	oldreadch = readch; readch = kinp(0x60);
	keytemp = kinp(0x61); koutp(0x61,keytemp|128); koutp(0x61,keytemp&127);
	if ((readch|1) == 0xe1)
		extended = 128;
	else
	{
		if (oldreadch != readch)
		{
			if (!(readch&128))
			{
				if (!keystatus[(readch&127)+extended])
					keystatus[(readch&127)+extended] = 1;
			}
			else
				keystatus[(readch&127)+extended] = 0;
		}
		extended = 0;
	}
	outp(0x20,0x20);
	if (keystatus[0x46]) cleanexit();
}

#define patchback(pat)                                                     \
{                                                                          \
	board[pat[0]] = pat[1]; board[pat[2]] = pat[3];                         \
	if (pat[4] != 255) { board[pat[4]] = pat[5]; board[pat[6]] = pat[7]; }  \
}                                                                          \

main(short int argc, char **argv)
{
	short other;
	long i, fil, x, y;

	initgroupfile("stuff.dat");
	if ((fil = open("setup.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(fil,option,NUMOPTIONS);
		read(fil,keys,NUMKEYS);
		close(fil);
	}
	if ((fil = kopen4load("tables.dat",0)) != -1)
	{
		klseek(fil,4096+1280,SEEK_SET);
		kread(fil,textfont,1024);
		kclose(fil);
	}

	oldkeyhandler = _dos_getvect(0x9);
	_disable(); _dos_setvect(0x9, keyhandler); _enable();

	inittimer();
	initmultiplayers(option[4],option[5]);

		//Init digitized sound
	initsb(option[1],option[2],digihz[option[7]>>4],((option[7]&4)>0)+1,((option[7]&2)>0)+1,60,option[7]&1);
	loadsong("neatsong.kdm");
	musicon();

	smartness[0] = 0;    //0 is so stupid it's a human
	smartness[1] = 4;    //4 is very smart and quick
	if (argc == 3)
	{
		smartness[0] = atol(argv[1]);
		if (smartness[0] < 0)
		{
			smartness[1] = min(max(-smartness[0],1),MAXRECURSION);
			timermode = atol(argv[2]);
			if (timermode < 1) timermode = 1;
			if (timermode > 120*60*10) timermode = 120*60*10;
			smartness[0] = 0;
		}
		else
		{
			if (smartness[0] > MAXRECURSION) smartness[0] = MAXRECURSION;
			smartness[1] = min(max(atol(argv[2]),0),MAXRECURSION);
			if ((smartness[0] > 0) && (!smartness[1])) reverseboard = 1;
		}
	}

	srand(readtimer());
	for(i=4095;i>=0;i--) randarray[i] = rand();
	for(i=1023;i>0;i--) randprob[i] = 32768/i;

	initgetvalidmoves();

	if (keystatus[0x2a]|keystatus[0x36])
	{
		for(i=0;i<64;i++) startboard[i] = 0;
		if (keystatus[0x2a])
		{
			for(i=0;i<32;i++) startboard[rand()&63] = (rand()%5)+(((rand()&3)==0)<<3)+9;
			startboard[rand()&63] = 14; startboard[rand()&63] = 22;
		}
		else
		{
			for(i=0;i<32;i++) startboard[rand()&63] = (rand()%5)+((rand()&1)<<3)+9;
			startboard[rand()&63] = 14; startboard[rand()&63] = 22;
		}
	}

	copybuf(startboard,board,64>>2);
	initpics();

	drawboard(0L,0L,XDIM,YDIM);
	blit(0L,0L,XDIM,YDIM);

	if (option[4] > 0)
	{
		sendlogon();

		x = (XDIM>>1)-(27<<2); y = (YDIM>>1);
		printext256(x,y,24L,-1L,"Waiting for other player...");
		blit(x,y,x+(27<<3),y+8);

		while (numplayers < 2)
		{
			if (getpacket(&other,tempbuf) > 0)
				if (tempbuf[0] == 255) cleanexit();
			if (keystatus[1]) cleanexit();
		}

		drawboard(x,y,x+(27<<3),y+8);
		blit(x,y,x+(27<<3),y+8);

		smartness[0] = 0, smartness[1] = -1;

		timermode = 0;
	}

	if (!check4check(turn))
		wsay("alarm.wav",4096L,255L,255L);
	else
		wsay("opendoor.wav",4096L,255L,255L);

	while (1)
	{
		pickmove(turn,smartness[turn]);
		drawboard(0L,0L,XDIM,YDIM);
		blit(0L,0L,XDIM,YDIM);
	}
	cleanexit();
}

cleanexit()
{
	long i;
	short *ptr;

	sendlogoff();         //Signing off
	setvesamode(0x3); setvmode(0x3);
	uninitmultiplayers();
	uninittimer();
	_disable(); _dos_setvect(0x9, oldkeyhandler); _enable();
		//Turn off shifts to prevent stucks with quitting
	ptr = (short *)0x417; *ptr &= ~0x030f;
	musicoff();
	uninitsb();
	uninitgroupfile();
	for(i=0;i<movelistcnt;i++)
		printf("%c%c%c%c ",((movelist[i]>>6)&7)+65,56-(movelist[i]>>9),(movelist[i]&7)+65,56-((movelist[i]>>3)&7));
	exit(0);
}

inittimer()
{
	koutp(0x43,0x36); koutp(0x40,TIMERRATE&255); koutp(0x40,TIMERRATE>>8);
	oldtimerhandler = _dos_getvect(0x8);
	_disable(); _dos_setvect(0x8, timerhandler); _enable();
}

uninittimer()
{
	koutp(0x43,0x36); koutp(0x40,0); koutp(0x40,0);           //18.2 times/sec
	_disable(); _dos_setvect(0x8, oldtimerhandler); _enable();
}

void __interrupt __far timerhandler()
{
	totalclock++;
	chainintrclock -= TIMERRATE;
	if (chainintrclock < 0)
	{
		chainintrclock += 65536;
		_chain_intr(oldtimerhandler);
	}
	//_chain_intr(oldtimerhandler);
	koutp(0x20,0x20);
}

initpics()
{
	long fil, i;

	setgamemode();

	if ((fil = kopen4load("palette.dat",0)) == -1) return;
	kread(fil,&palette[0],768);
	kclose(fil);
	outp(0x3c8,0);
	for(i=0;i<768;i++) outp(0x3c9,palette[i]);

	for(i=0;i<6;i++) loadnewall(i<<12,i+140);
	loadnewall(6L<<12,105L);
}

loadnewall (long bufplc, long wallnum)
{
	long fil, version, numtiles, localtilestart, localtileend, totsiz, z;

	if ((fil = kopen4load("tiles000.art",0)) == -1) return;

	kread(fil,&version,4);
	kread(fil,&numtiles,4);
	kread(fil,&localtilestart,4);
	kread(fil,&localtileend,4);
	kread(fil,tilesizx,(localtileend-localtilestart+1)<<1);
	kread(fil,tilesizy,(localtileend-localtilestart+1)<<1);
	kread(fil,picanm,(localtileend-localtilestart+1)<<2);

	totsiz = 0;
	for(z=0;z<wallnum;z++) totsiz += tilesizx[z]*tilesizy[z];
	klseek(fil,totsiz+16+((localtileend-localtilestart+1)<<3),SEEK_SET);
	kread(fil,&buf[bufplc],tilesizx[wallnum]*tilesizy[wallnum]);
	buf2tile[bufplc>>12] = wallnum;

	kclose(fil);
}

drawboard(long cx1, long cy1, long cx2, long cy2)
{
	long x, y, x1, y1, x2, y2, rad;
	char dat, *boardptr;

	boardptr = board;

	rad = ((YDIM<<5)/480L)+1;

	if (cx1 < ((XDIM-YDIM)>>1))
		fillrectangle(max(0L,cx1),max(0L,cy1),min((XDIM-YDIM)>>1,cx2),min(YDIM,cy2),0L);
	if (cx2 >= XDIM-((XDIM-YDIM)>>1))
		fillrectangle(max(XDIM-((XDIM-YDIM)>>1),cx1),max(0L,cy1),min(XDIM,cx2),min(YDIM,cy2),0L);

	y1 = 0; y2 = (YDIM>>3);
	for(y=0;y<8;y++)
	{
		x1 = ((XDIM-YDIM)>>1); x2 = x1+(YDIM>>3);
		for(x=0;x<8;x++)
		{
			if ((x1 <= cx2) && (cx1 <= x2) && (y1 <= cy2) && (cy1 <= y2))
				fillrectangle(max(x1,cx1),max(y1,cy1),min(x2,cx2),min(y2,cy2),(((x^y)&1^1)<<1)+12);
			dat = *boardptr++;
			if (dat)
			{
				x1 += (YDIM>>4); y1 += (YDIM>>4);
				if ((x1-rad <= cx2) && (cx1 <= x1+rad))
					if ((y1-rad <= cy2) && (cy1 <= y1+rad))
						drawchesspicture(x1,y1,(YDIM<<8)/480L,(long)dat-1);
				x1 -= (YDIM>>4); y1 -= (YDIM>>4);
			}
			x1 += (YDIM>>3); x2 += (YDIM>>3);
		}
		y1 += (YDIM>>3); y2 += (YDIM>>3);
	}
}

drawchesspicture (long dax, long day, long siz, long picnum)
{
	long dashade, xdim, ydim, nxdim, nydim, bufoffs, bufinc, x, y;
	long p, dat;

	if (picnum >= 16) dashade = -12; else dashade = 0;
	picnum &= 7;

	if (reverseboard) { dax = XDIM-1-dax; day = YDIM-1-day; }

	xdim = tilesizx[buf2tile[picnum]]; nxdim = ((xdim*siz)>>8); dax -= (nxdim>>1);
	ydim = tilesizy[buf2tile[picnum]]; nydim = ((ydim*siz)>>8); day -= (nydim>>1);
	if (day < 0) day = 0;

	bufinc = 65536/siz;
	for(x=0;x<nxdim;x++)
	{
		bufoffs = ((((x<<8)/siz)*ydim + (picnum<<12)) << 8);
		p = ylookup[day] + (x+dax) + frameplace;
		for(y=0;y<nydim;y++)
		{
			dat = buf[bufoffs>>8];
			if (dat != 255) *(char *)p = dat+dashade;
			p += XDIM;
			bufoffs += bufinc;
		}
	}
}

pickmove(long dacol, long dasmartness)
{
	long i, j, x1, y1, x2, y2;
	short tempbufleng, other;

	if (dasmartness <= 0)
	{
		if (!dasmartness)
		{
			if (playermove(dacol,&x1,&y1,&x2,&y2) < 0)
			{     //Oops - other player started
				movepiece(x1,y1,x2,y2,0); return;
			}

			if (option[4])
			{
				tempbuf[0] = 0;
				tempbuf[1] = (y1<<3)+x1;
				tempbuf[2] = (y2<<3)+x2;
				if (myconnectindex == connecthead)
					sendpacket(connectpoint2[connecthead],tempbuf,3);
				else
					sendpacket(connecthead,tempbuf,3);
			}
		}
		else
		{
			x1 = 255;
			while (x1 == 255)
			{
				if ((tempbufleng = getpacket(&other,tempbuf)) > 0)
				{
					switch(tempbuf[0])
					{
						case 0:  //Send move
							x1 = (tempbuf[1]&7); y1 = (tempbuf[1]>>3);
							x2 = (tempbuf[2]&7); y2 = (tempbuf[2]>>3);
							break;
						case 2:
							drawboard(0L,YDIM-64L,XDIM,YDIM);
							blit(0L,YDIM-64L,XDIM,YDIM);

							getmessageleng = tempbufleng-1;
							for(j=getmessageleng-1;j>=0;j--) getmessage[j] = tempbuf[j+1];
							getmessagetimeoff = totalclock+360+(getmessageleng<<4);
							break;
						case 255:  //[255] (logout)
							cleanexit();
					}
				}

				checktypemode();
			}
		}
	}
	else
	{
		if (computermove(dacol,&x1,&y1,&x2,&y2,dasmartness) < 0)
			playermove(dacol,&x1,&y1,&x2,&y2);
	}

	movepiece(x1,y1,x2,y2,0);
}

static long pointerx = (XDIM>>1), pointery = (YDIM>>1);
playermove (long dacol, long *x1, long *y1, long *x2, long *y2)
{
	char ch, spaceset, good, pat[8];
	short tempbufleng, other, mousx, mousy, obstatus, bstatus;
	long x, y, z, i, j, timestart, bakc, bakd, oreverseboard;

	//drawrect(c,d,95L);

	oreverseboard = reverseboard; reverseboard = 0;
	openrectangle(pointerx-2,pointery-2,pointerx+2,pointery+2,95L);
	blit(pointerx-2,pointery-2,pointerx+3,pointery+3);
	reverseboard = oreverseboard;

	spaceset = 0; bstatus = 0;
	timestart = totalclock;
	while (1)
	{
		if ((timermode > 0) && (totalclock > timestart+timermode))
		{
			//drawrect(c,d,(((c^d)&1^1)<<1)+12L);
			if (computermove(dacol,x1,y1,x2,y2,1L) >= 0) return(0);
		}

		if (option[4])
		{
			if ((tempbufleng = getpacket(&other,tempbuf)) > 0)
			{
				switch(tempbuf[0])
				{
					case 0:
						if (movelistcnt == 0)
						{
							smartness[0] = -1; smartness[1] = 0; reverseboard = 1;
							drawboard(0L,YDIM-64L,XDIM,YDIM);
							blit(0L,YDIM-64L,XDIM,YDIM);
							*x1 = (tempbuf[1]&7); *y1 = (tempbuf[1]>>3);
							*x2 = (tempbuf[2]&7); *y2 = (tempbuf[2]>>3);
							return(-1);
						}
						break;
					case 2:
						drawboard(0L,YDIM-64L,XDIM,YDIM);
						blit(0L,YDIM-64L,XDIM,YDIM);

						getmessageleng = tempbufleng-1;
						for(j=getmessageleng-1;j>=0;j--) getmessage[j] = tempbuf[j+1];
						getmessagetimeoff = totalclock+360+(getmessageleng<<4);
						break;
					case 255:  //[255] (logout)
						cleanexit();
				}
			}
		}
		checktypemode();


		obstatus = bstatus;
		readmousexy(&mousx,&mousy);
		readmousebstatus(&bstatus);

		if (mousx|mousy|bstatus)
		{
			if (reverseboard)
				drawboard(XDIM-1-(pointerx+3),YDIM-1-(pointery+3),XDIM-1-(pointerx-2),YDIM-1-(pointery-2));
			else
				drawboard(pointerx-2,pointery-2,pointerx+3,pointery+3);

			oreverseboard = reverseboard; reverseboard = 0;
			blit(pointerx-2,pointery-2,pointerx+3,pointery+3);

			pointerx = min(max(pointerx+mousx,((XDIM-YDIM)>>1)+2),XDIM-((XDIM-YDIM)>>1)-1-2);
			pointery = min(max(pointery+mousy,2),YDIM-1-2);

			i = (pointerx-((XDIM-YDIM)>>1))/(YDIM>>3);
			j = pointery/(YDIM>>3);
			if (oreverseboard) { i = 7-i; j = 7-j; }
			if ((i != c) || (j != d))
			{
				//drawrect(c,d,(((c^d)&1^1)<<1)+12L);
				c = i; d = j;
				//drawrect(c,d,95L);
			}

			openrectangle(pointerx-2,pointery-2,pointerx+2,pointery+2,95L);
			blit(pointerx-2,pointery-2,pointerx+3,pointery+3);

			reverseboard = oreverseboard;
		}


		/*i = keystatus[0xcd]-keystatus[0xcb];
		if (i)
		{
			keystatus[0xcb] = keystatus[0xcd] = 0;
			if (reverseboard) i = -i;
			j = min(max(c+i,0),7);
			if (j != c)
			{
				drawrect(c,d,(((c^d)&1^1)<<1)+12L); c = j;
				drawrect(c,d,95L);
			}
		}
		i = keystatus[0xd0]-keystatus[0xc8];
		if (i)
		{
			keystatus[0xc8] = keystatus[0xd0] = 0;
			if (reverseboard) i = -i;
			j = min(max(d+i,0),7);
			if (j != d)
			{
				drawrect(c,d,(((c^d)&1^1)<<1)+12L); d = j;
				drawrect(c,d,95L);
			}
		}*/

		if ((keystatus[0x38]|keystatus[0xb8]) || (bstatus&2))
		{
			i = (d<<3)+c;
			if ((board[i]) && ((board[i]&24) == (dacol<<3)+8))
			{
				spaceset = 1; bakc = c; bakd = d;

				getvalidmoves((long)(bakd<<3)+bakc,MAXRECURSION);
				for(z=validmovecnt[MAXRECURSION]-1;z>=0;z--)
				{
					i = validmove[MAXRECURSION][z];
						//Do move
					qmovepiece((long)(bakd<<3)+bakc,i,pat);
					good = check4check(dacol);
					patchback(pat);
					if (good) drawrect(i&7,i>>3,95L);
				}

				while ((keystatus[0x38]|keystatus[0xb8]) || (bstatus&2))
				{
					obstatus = bstatus;
					readmousexy(&mousx,&mousy);
					readmousebstatus(&bstatus);
					if (keystatus[1]) { keystatus[1] = 0; break; }
				}

				drawboard(0L,0L,XDIM,YDIM);
				blit(0L,0L,XDIM,YDIM);
				//drawrect(c,d,95L);
			}
		}

		if ((keystatus[0x39]) || ((bstatus&1) > (obstatus&1)))
		{
			//keystatus[0x39] = 0;
			i = (d<<3)+c;
			if ((board[i]) && ((board[i]&24) == (dacol<<3)+8))
				{ spaceset = 1; bakc = c; bakd = d; }
		}

		if ((keystatus[0x23]) && (!typemode))  //H
		{
			keystatus[0x23] = 0;

			//drawrect(c,d,(((c^d)&1^1)<<1)+12L);

			i = -1;
			while (i < 0)
			{
				if (keystatus[0x2]) keystatus[0x2] = 0, i = 1;
				if (keystatus[0x3]) keystatus[0x3] = 0, i = 2;
				if (keystatus[0x4]) keystatus[0x4] = 0, i = 3;
				if (keystatus[0x5]) keystatus[0x5] = 0, i = 4;
				if (keystatus[0x6]) keystatus[0x6] = 0, i = 5;
				//if (keystatus[0x7]) keystatus[0x7] = 0, i = 6;
				//if (keystatus[0x8]) keystatus[0x8] = 0, i = 7;
				//if (keystatus[0x9]) keystatus[0x9] = 0, i = 8;
			}
			i = min(max(i,1),MAXRECURSION);

			tempbuf[0] = 2;
			tempbuf[1] = 'H';
			tempbuf[2] = i+48;
			for(j=connecthead;j>=0;j=connectpoint2[j])
				if (j != myconnectindex)
					sendpacket(j,tempbuf,3);

			if (computermove(dacol,x1,y1,x2,y2,i) >= 0)
			{
				drawrect(*x1,*y1,95L);
				drawrect(*x2,*y2,95L);

				keystatus[0x1c] = 0;
				keystatus[0x39] = 0;
				while ((!keystatus[0x39]) && (!keystatus[0x23]))
				{
					obstatus = bstatus;
					readmousexy(&mousx,&mousy);
					readmousebstatus(&bstatus);

					if (bstatus != obstatus) break;
					if (keystatus[0x1c])
					{
						drawrect(*x1,*y1,(((*x1^*x2)&1^1)<<1)+12L);
						drawrect(*x2,*y2,(((*x2^*y2)&1^1)<<1)+12L);
						return(0);
					}
				}
				drawrect(*x1,*y1,(((*x1^*x2)&1^1)<<1)+12L);
				drawrect(*x2,*y2,(((*x2^*y2)&1^1)<<1)+12L);
			}
			//drawrect(c,d,95L);
		}
		if (((keystatus[0x1c]) || ((bstatus&1) < (obstatus&1))) && (spaceset) && (((d<<3)+c) != ((bakd<<3)+bakc)))
		{
			keystatus[0x1c] = 0;

			getvalidmoves((long)(bakd<<3)+bakc,0L);
			for(z=validmovecnt[0]-1;z>=0;z--)
				if (validmove[0][z] == (d<<3)+c)
					break;

			if (z >= 0)
			{
					//Do move
				qmovepiece((long)(bakd<<3)+bakc,(long)(d<<3)+c,pat);
				good = check4check(dacol);
				patchback(pat);

				if (good)
				{
					//drawrect(c,d,(((c^d)&1^1)<<1)+12L);
					*x1 = bakc; *y1 = bakd; *x2 = c; *y2 = d;
					return(0);
				}
				else
					wsay("alarm.wav",4096L,255L,255L);
			}
			else
				wsay("bouncy.wav",4096L,255L,255L);
		}
	}
}

drawrect(long c, long d, long col)
{
	long x, y, oreverseboard;

	if (reverseboard) { c = 7-c; d = 7-d; }

	x = (long)c*(YDIM>>3)+((XDIM-YDIM)>>1); y = (long)d*(YDIM>>3);
	openrectangle(x,y,x+(YDIM>>3)-1,y+(YDIM>>3)-1,col);
	oreverseboard = reverseboard; reverseboard = 0;
	blit(x,y,x+(YDIM>>3),y+(YDIM>>3));
	reverseboard = oreverseboard;
}

computermove (long dacol, long *x1, long *y1, long *x2, long *y2, long dasmartness)
{
	long i, j, bestmove, score[2], bestx1, besty1, bestx2, besty2, good;
	char pat[8];

	//score[0] = score[1] = 0;
	//for(i=63;i>=0;i--)
	//{
	//   j = board[i];
	//   if (((j-1)&7) < 5) score[(j>>3)-1] += rank[j];
	//}
	//if (score[dacol] > score[dacol^1])      score[dacol] = 4, score[dacol^1] = 3;
	//else if (score[dacol] < score[dacol^1]) score[dacol] = 3, score[dacol^1] = 4;
	//else                                    score[dacol] = 1, score[dacol^1] = 1;
	score[0] = score[1] = 1;
	for(i=8;i<16;i++) rank2[i] = rank[i]*score[0];
	for(i=16;i<24;i++) rank2[i] = rank[i]*score[1];

	do
	{
		globrecursion = dasmartness; recursecnt = 0;
		globalvalidptr = &validmove[-1][0];
		globnodes = 0;

		if (!dacol) i = bestwhite(&bestmove); else i = bestblack(&bestmove);

			//Do move
		qmovepiece(bestmove>>6,bestmove&63,pat);
		good = check4check(dacol);
		patchback(pat);

		dasmartness++;
	} while ((!good) && (dasmartness < 4));
	if (!good)
	{
		if (check4check(dacol))  //Play stalemate sound (computer only)
			wsay("shoot4.wav",4096L,255L,255L);
		else
			wsay("doh.wav",8192L,255L,255L);
		return(-1);
		//while (keystatus[0x1c]|keystatus[1]);
		//while (!(keystatus[0x1c]|keystatus[1]));
		//cleanexit();
	}

	drawboard(0L,YDIM-64L,XDIM,YDIM);

	sprintf(getmessage,"%ld %ld",globnodes,i);
	getmessageleng = strlen(getmessage);
	getmessagetimeoff = totalclock+360+(getmessageleng<<4);
	checktypemode();

	blit(0L,YDIM-64L,XDIM,YDIM);

	*x1 = ((bestmove>>6)&7); *y1 = (bestmove>>9);
	*x2 = (bestmove&7);      *y2 = ((bestmove>>3)&7);
	return(0);
}

bestblack(long *bestmove)
{
	long bestrank, darank, i, j, oj, z, numchoices;
	char pat[8];

	recursecnt++; globalvalidptr += 64;

	bestrank = 0x80000000; numchoices = 0;

	for(i=63;i>=0;i--)
		if ((board[i]&24) == 16)
		{
			getvalidmoves(i,recursecnt-1);
			globnodes += validmovecnt[recursecnt-1];
			for(z=validmovecnt[recursecnt-1]-1;z>=0;z--)
			{
				j = oj = globalvalidptr[z];
				darank = qmovepiece(i,j,pat);
				if (recursecnt < globrecursion)
					if (klabs(darank) < 512)  //if ((darank > bestrank) || (recursecnt < 3))
						darank += bestwhitedepth();
				patchback(pat);

				if (darank > bestrank)
					{ numchoices = 1; bestrank = darank; *bestmove = (i<<6)+oj; }
				else if (darank == bestrank)
				{
					j = randarray[randcnt--]; if (randcnt < 0) randcnt = 4095;
					if (j <= randprob[++numchoices])
						{ bestrank = darank; *bestmove = (i<<6)+oj; }
				}

				if (globrecursion > 4)
				{
					sprintf(getmessage,"%ld %ld",globnodes,bestrank);
					getmessageleng = strlen(getmessage);
					getmessagetimeoff = totalclock+360+(getmessageleng<<4);
					checktypemode();
				}
			}
		}

	recursecnt--; globalvalidptr -= 64;
	return(bestrank);
}

bestwhite(long *bestmove)
{
	long bestrank, darank, i, j, oj, z, numchoices;
	char pat[8];

	recursecnt++; globalvalidptr += 64;

	bestrank = 0x7fffffff; numchoices = 0;

	for(i=63;i>=0;i--)
		if ((board[i]&24) == 8)
		{
			getvalidmoves(i,recursecnt-1);
			globnodes += validmovecnt[recursecnt-1];
			for(z=validmovecnt[recursecnt-1]-1;z>=0;z--)
			{
				j = oj = globalvalidptr[z];
				darank = qmovepiece(i,j,pat);
				if (recursecnt < globrecursion)
					if (klabs(darank) < 512)  //if ((darank < bestrank) || (recursecnt < 3))
						darank += bestblackdepth();
				patchback(pat);

				if (darank < bestrank)
					{ numchoices = 1; bestrank = darank; *bestmove = (i<<6)+oj; }
				else if (darank == bestrank)
				{
					j = randarray[randcnt--]; if (randcnt < 0) randcnt = 4095;
					if (j <= randprob[++numchoices])
						{ bestrank = darank; *bestmove = (i<<6)+oj; }
				}

				if (globrecursion > 4)
				{
					sprintf(getmessage,"%ld %ld",globnodes,bestrank);
					getmessageleng = strlen(getmessage);
					getmessagetimeoff = totalclock+360+(getmessageleng<<4);
					checktypemode();
				}
			}
		}

	recursecnt--; globalvalidptr -= 64;
	return(bestrank);
}

bestblackdepth()
{
	long bestrank, darank, i, z;
	char pat[8];

	recursecnt++; globalvalidptr += 64;

	bestrank = 0x80000000;

	for(i=63;i>=0;i--)
		if ((board[i]&24) == 16)
		{
			getvalidmoves(i,recursecnt-1);
			globnodes += validmovecnt[recursecnt-1];
			for(z=validmovecnt[recursecnt-1]-1;z>=0;z--)
			{
				darank = qmovepiece(i,(long)globalvalidptr[z],pat);
				if (recursecnt < globrecursion)
					if (klabs(darank) < 512)
					//if ((darank > bestrank+1) || (recursecnt < 3))
						darank += bestwhitedepth();
				patchback(pat);

				if (darank > bestrank) bestrank = darank;
			}
		}

	recursecnt--; globalvalidptr -= 64;
	return(bestrank);
}

bestwhitedepth()
{
	long bestrank, darank, i, z;
	char pat[8];

	recursecnt++; globalvalidptr += 64;

	bestrank = 0x7fffffff;

	for(i=63;i>=0;i--)
		if ((board[i]&24) == 8)
		{
			getvalidmoves(i,recursecnt-1);
			globnodes += validmovecnt[recursecnt-1];
			for(z=validmovecnt[recursecnt-1]-1;z>=0;z--)
			{
				darank = qmovepiece(i,(long)globalvalidptr[z],pat);
				if (recursecnt < globrecursion)
					if (klabs(darank) < 512)
					//if ((darank < bestrank-1) || (recursecnt < 3))
						darank += bestblackdepth();
				patchback(pat);

				if (darank < bestrank) bestrank = darank;
			}
		}

	recursecnt--; globalvalidptr -= 64;
	return(bestrank);
}

static long horshead[64], rookhead[64], rookline[288], bishhead[64], bishline[260];
static char horslist[400], rooklist[1120], bishlist[756];
initgetvalidmoves()
{
	long i, j, x, y, z, hcnt, rcnt, rcnt2, bcnt, bcnt2;

	hcnt = rcnt = rcnt2 = bcnt = bcnt2 = j = 0;
	for(y=0;y<8;y++)
		for(x=0;x<8;x++)
		{

			horshead[j] = hcnt;
			if (x > 1)
			{
				if (y != 0) horslist[hcnt++] = j-2-8;
				if (y != 7) horslist[hcnt++] = j-2+8;
			}
			if (x < 6)
			{
				if (y != 0) horslist[hcnt++] = j+2-8;
				if (y != 7) horslist[hcnt++] = j+2+8;
			}
			if (y > 1)
			{
				if (x != 0) horslist[hcnt++] = j-1-16;
				if (x != 7) horslist[hcnt++] = j+1-16;
			}
			if (y < 6)
			{
				if (x != 0) horslist[hcnt++] = j-1+16;
				if (x != 7) horslist[hcnt++] = j+1+16;
			}
			horslist[hcnt++] = 255;


			rookhead[j] = rcnt;
			if (y > 0)
			{
				rookline[rcnt++] = rcnt2;
				for(i=y-1;i>=0;i--) rooklist[rcnt2++] = x+(i<<3);
				rooklist[rcnt2++] = 255;
			}
			if (y < 7)
			{
				rookline[rcnt++] = rcnt2;
				for(i=y+1;i<8;i++) rooklist[rcnt2++] = x+(i<<3);
				rooklist[rcnt2++] = 255;
			}
			if (x > 0)
			{
				rookline[rcnt++] = rcnt2;
				for(i=x-1;i>=0;i--) rooklist[rcnt2++] = i+(y<<3);
				rooklist[rcnt2++] = 255;
			}
			if (x < 7)
			{
				rookline[rcnt++] = rcnt2;
				for(i=x+1;i<8;i++) rooklist[rcnt2++] = i+(y<<3);
				rooklist[rcnt2++] = 255;
			}
			rookline[rcnt++] = 255;


			bishhead[j] = bcnt;
			if ((x > 0) && (y > 0))
			{
				bishline[bcnt++] = bcnt2;
				for(i=j,z=min(x,y);z>0;z--) { i += (-1-8); bishlist[bcnt2++] = i; }
				bishlist[bcnt2++] = 255;
			}
			if ((x < 7) && (y > 0))
			{
				bishline[bcnt++] = bcnt2;
				for(i=j,z=min(x^7,y);z>0;z--) { i += (+1-8); bishlist[bcnt2++] = i; }
				bishlist[bcnt2++] = 255;
			}
			if ((x > 0) && (y < 7))
			{
				bishline[bcnt++] = bcnt2;
				for(i=j,z=min(x,y^7);z>0;z--) { i += (-1+8); bishlist[bcnt2++] = i; }
				bishlist[bcnt2++] = 255;
			}
			if ((x < 7) && (y < 7))
			{
				bishline[bcnt++] = bcnt2;
				for(i=j,z=min(x^7,y^7);z>0;z--) { i += (+1+8); bishlist[bcnt2++] = i; }
				bishlist[bcnt2++] = 255;
			}
			bishline[bcnt++] = 255;


			j++;
		}
}

getvalidmoves (long j, long daboard)
{
	char *vptr, *svptr, *boardj, piece, playeroffs, xorplayeroffs, z;
	long i, k, x, y;

	svptr = &validmove[daboard][0];
	vptr = svptr;

	x = (j&7); y = (j>>3);
	boardj = &board[j]; piece = *boardj;
	if (!piece) { validmovecnt[daboard] = 0; return; }
	playeroffs = (piece&24); xorplayeroffs = playeroffs^24;
	piece &= 7;

	if (piece == 1)             //pawn
	{
		if (playeroffs >= 16)
		{
			if (!boardj[+8])
			{
				*vptr++ = j+8;
				if ((y == 1) && (!boardj[+16])) *vptr++ = j+16;
			}
			if ((x != 0) && ((boardj[-1+8]&24) == xorplayeroffs)) *vptr++ = j-1+8;
			if ((x != 7) && ((boardj[+1+8]&24) == xorplayeroffs)) *vptr++ = j+1+8;
			validmovecnt[daboard] = (((long)vptr)-((long)svptr));
			return;
		}
		else
		{
			if (!boardj[-8])
			{
				*vptr++ = j-8;
				if ((y == 6) && (!boardj[-16])) *vptr++ = j-16;
			}
			if ((x != 0) && ((boardj[-1-8]&24) == xorplayeroffs)) *vptr++ = j-1-8;
			if ((x != 7) && ((boardj[+1-8]&24) == xorplayeroffs)) *vptr++ = j+1-8;
			validmovecnt[daboard] = (((long)vptr)-((long)svptr));
			return;
		}
	}

	if (piece == 2)             //horse
	{
		i = horshead[j];
		if ((board[horslist[i]]&24) != playeroffs) *vptr++ = horslist[i];
		i++;
		do
		{
			if ((board[horslist[i]]&24) != playeroffs) *vptr++ = horslist[i];
			i++;
		} while (horslist[i] != 255);

		/*if (x > 1)
		{
			if ((y != 0) && ((boardj[-2-8]&24) != playeroffs)) *vptr++ = j-2-8;
			if ((y != 7) && ((boardj[-2+8]&24) != playeroffs)) *vptr++ = j-2+8;
		}
		if (x < 6)
		{
			if ((y != 0) && ((boardj[+2-8]&24) != playeroffs)) *vptr++ = j+2-8;
			if ((y != 7) && ((boardj[+2+8]&24) != playeroffs)) *vptr++ = j+2+8;
		}
		if (y > 1)
		{
			if ((x != 0) && ((boardj[-1-16]&24) != playeroffs)) *vptr++ = j-1-16;
			if ((x != 7) && ((boardj[+1-16]&24) != playeroffs)) *vptr++ = j+1-16;
		}
		if (y < 6)
		{
			if ((x != 0) && ((boardj[-1+16]&24) != playeroffs)) *vptr++ = j-1+16;
			if ((x != 7) && ((boardj[+1+16]&24) != playeroffs)) *vptr++ = j+1+16;
		}*/
		validmovecnt[daboard] = (((long)vptr)-((long)svptr));
		return;
	}

	if (piece == 6)                          //king
	{
		if (y)
		{
			if ((boardj[-8]&24) != playeroffs) *vptr++ = j-8;
			if ((x != 0) && ((boardj[-1-8]&24) != playeroffs)) *vptr++ = j-1-8;
			if ((x != 7) && ((boardj[+1-8]&24) != playeroffs)) *vptr++ = j+1-8;
		}
		if (y != 7)
		{
			if ((boardj[+8]&24) != playeroffs) *vptr++ = j+8;
			if ((x != 0) && ((boardj[-1+8]&24) != playeroffs)) *vptr++ = j-1+8;
			if ((x != 7) && ((boardj[+1+8]&24) != playeroffs)) *vptr++ = j+1+8;
		}
		if ((x != 0) && ((boardj[-1]&24) != playeroffs)) *vptr++ = j-1;
		if ((x != 7) && ((boardj[+1]&24) != playeroffs)) *vptr++ = j+1;

		if (x == 4)
			if (((y+1)&7) < 2)
			{
				if (!boardj[+1])
					if (!boardj[+2])
						if (boardj[+3] == playeroffs+4)
							*vptr++ = j+2;
				if (!boardj[-1])
					if (!boardj[-2])
						if (!boardj[-3])
							if (boardj[-4] == playeroffs+4)
								*vptr++ = j-2;
			}

		validmovecnt[daboard] = (((long)vptr)-((long)svptr));
		return;
	}

	if (piece != 4)         //bishop/queen
	{
		i = bishhead[j];
		do
		{
			k = bishline[i++];
			do
			{
				if (!board[bishlist[k]])
					*vptr++ = bishlist[k];
				else
				{
					if ((board[bishlist[k]]&24) != playeroffs) *vptr++ = bishlist[k];
					break;
				}
				k++;
			} while (bishlist[k] != 255);
		} while (bishline[i] != 255);

		/*i = j;
		for(z=min(x,y);z>0;z--)
		{
			i += (-1-8);
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}

		i = j;
		for(z=min(x^7,y);z>0;z--)
		{
			i += (+1-8);
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}

		i = j;
		for(z=min(x,y^7);z>0;z--)
		{
			i += (-1+8);
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}

		i = j;
		for(z=min(x^7,y^7);z>0;z--)
		{
			i += (+1+8);
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}*/
	}

	if (piece != 3)         //rook/queen
	{
		i = rookhead[j];
		do
		{
			k = rookline[i++];
			do
			{
				if (!board[rooklist[k]])
					*vptr++ = rooklist[k];
				else
				{
					if ((board[rooklist[k]]&24) != playeroffs) *vptr++ = rooklist[k];
					break;
				}
				k++;
			} while (rooklist[k] != 255);
		} while (rookline[i] != 255);

		/*i = j;
		for(z=x;z>0;z--)
		{
			i--;
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}

		i = j;
		for(z=(x^7);z>0;z--)
		{
			i++;
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}

		i = j;
		for(z=y;z>0;z--)
		{
			i -= 8;
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}

		i = j;
		for(z=(y^7);z>0;z--)
		{
			i += 8;
			if (board[i])
			{
				if ((board[i]&24) == xorplayeroffs) *vptr++ = i;
				break;
			}
			*vptr++ = i;
		}*/
	}
	validmovecnt[daboard] = (((long)vptr)-((long)svptr));
}

__inline qmovepiece (long i, long j, char *pat)
{
	char boardi;
	long deltarank;

	boardi = board[i]; pat[4] = 255;
	pat[0] = (char)i; pat[1] = boardi;
	pat[2] = (char)j; pat[3] = board[j];
	deltarank = rank2[pat[3]];
	switch(boardi&7)
	{
		case 1:                         //Pawn becomes Queen
			if (((j+8)&0x38) < (2<<3))
			{
				deltarank += (rank2[boardi]-rank2[boardi+4]);
				boardi += 4;
			}
			break;
		case 6:                        //Castle
			if ((i&7) == 4)
			{
				if ((j&7) == 6)
				{
					pat[4] = (char)i+1; pat[5] = board[i+1];
					pat[6] = (char)i+3; pat[7] = board[i+3];
					board[i+1] = board[i+3]; board[i+3] = 0;
				}
				if ((j&7) == 2)
				{
					pat[4] = (char)i-1; pat[5] = board[i-1];
					pat[6] = (char)i-4; pat[7] = board[i-4];
					board[i-1] = board[i-4]; board[i-4] = 0;
				}
			}
			break;
	}
	board[i] = 0; board[j] = boardi;

	return(deltarank);
}

movepiece (long x1, long y1, long x2, long y2, char movestat)
{
	long i, j, k, score[2], bestmove;
	long t, tx, ty, txinc, tyinc, tx2, ty2, txinc2;
	char oboardi, oboardj, castleit;

	i = (y1<<3)+x1; oboardi = board[i];
	j = (y2<<3)+x2; oboardj = board[j];
	board[i] = 0;

	if (!movestat)
	{
		movelist[movelistcnt++] = (((long)y1)<<9) + (((long)x1)<<6) + (((long)y2)<<3) + ((long)x2);

		tx = ((x1*(YDIM>>3)+((XDIM-YDIM)>>1)+(YDIM>>4))<<16);
		ty = ((y1*(YDIM>>3)+(YDIM>>4))<<16);
		txinc = (((x2-x1)*(YDIM>>3))<<(16-LOGANIMSTEPS));
		tyinc = (((y2-y1)*(YDIM>>3))<<(16-LOGANIMSTEPS));
		castleit = 0;
		if (((oboardi&7) == 6) && (x1 == 4))
		{
			if (x2 == 6)
			{
				board[i+3] = 0; castleit = 1;
				tx2 = ((7*(YDIM>>3)+((XDIM-YDIM)>>1)+(YDIM>>4))<<16);
				txinc2 = (((5-7)*(YDIM>>3))<<(16-LOGANIMSTEPS));
			}
			if (x2 == 2)
			{
				board[i-4] = 0; castleit = 1;
				tx2 = ((0*(YDIM>>3)+((XDIM-YDIM)>>1)+(YDIM>>4))<<16);
				txinc2 = (((3-0)*(YDIM>>3))<<(16-LOGANIMSTEPS));
			}
		}

		if (!castleit)
		{
			k = x1+x2; if (reverseboard) k = 14-k;
			switch(oboardi&7)
			{
				case 1: wsay("zipguns.wav",4096L,255-(k<<4),255-((14-k)<<4)); break;
				case 2: wsay("shoot2.wav",4096L,255-(k<<4),255-((14-k)<<4)); break;
				case 3: wsay("shoot2.wav",4096L,255-(k<<4),255-((14-k)<<4)); break;
				case 4: wsay("shoot2.wav",4096L,255-(k<<4),255-((14-k)<<4)); break;
				case 5: wsay("shoot3.wav",4096L,255-(k<<4),255-((14-k)<<4)); break;
				case 6: wsay("warp.wav",4096L,255-(k<<4),255-((14-k)<<4)); break;
			}
		}
		else
			wsay("warp.wav",4096L,255L,255L);

		for(t=0;t<(1<<LOGANIMSTEPS);t++)
		{
			if (!castleit)
			{
				drawboard((tx>>16)-((YDIM<<5)/480L)-8,(ty>>16)-((YDIM<<5)/480L)-8,(tx>>16)+((YDIM<<5)/480L)+8,(ty>>16)+((YDIM<<5)/480L)+8);
				drawchesspicture((long)tx>>16,(long)ty>>16,(YDIM<<8)/480L,(long)oboardi-1);
				if ((t*5 > (4<<LOGANIMSTEPS)) && (oboardj&7))
				{
					tx2 = x2*(YDIM>>3)+((XDIM-YDIM)>>1)+(YDIM>>4);
					ty2 = y2*(YDIM>>3)+(YDIM>>4);
					drawchesspicture(tx2,ty2,(YDIM*(256-(rand()&63)))/480L,6);
					blit(tx2-((YDIM<<5)/480L)-8,ty2-((YDIM<<5)/480L)-8,tx2+((YDIM<<5)/480L)+8,ty2+((YDIM<<5)/480L)+8);
				}
				blit((tx>>16)-((YDIM<<5)/480L)-8,(ty>>16)-((YDIM<<5)/480L)-8,(tx>>16)+((YDIM<<5)/480L)+8,(ty>>16)+((YDIM<<5)/480L)+8);
			}
			else
			{
				drawboard((min(tx,tx2)>>16)-((YDIM<<5)/480L)-8,(ty>>16)-((YDIM<<5)/480L)-8,(max(tx,tx2)>>16)+((YDIM<<5)/480L)+8,(ty>>16)+((YDIM<<5)/480L)+8);
				drawchesspicture((long)tx2>>16,(long)ty>>16,(YDIM<<8)/480L,(long)oboardi-3);
				tx2 += txinc2;
				drawchesspicture((long)tx>>16,(long)ty>>16,(YDIM<<8)/480L,(long)oboardi-1);
				blit((min(tx,tx2)>>16)-((YDIM<<5)/480L)-8,(ty>>16)-((YDIM<<5)/480L)-8,(max(tx,tx2)>>16)+((YDIM<<5)/480L)+8,(ty>>16)+((YDIM<<5)/480L)+8);
			}

			tx += txinc; ty += tyinc;
		}
		turn ^= 1;
	}

	switch(oboardi&7)
	{
		case 1:                         //Pawn becomes Queen
			if (((y2+1)&7) < 2) oboardi += 4;
			break;
		case 6:                        //Castle
			if (x1 == 4)
			{
				if (x2 == 6) { board[i+1] = oboardi-2; board[i+3] = 0; }
				if (x2 == 2) { board[i-1] = oboardi-2; board[i-4] = 0; }
			}
			break;
	}
	board[j] = oboardi;

	if (!movestat)
	{
		k = x2; if (reverseboard) k = 7-k;
		switch(oboardj&7)
		{
			case 0: break;
			case 1: wsay("getstuff.wav",4096L,255-(k<<5),255-((7-k)<<5)); break;
			case 2: wsay("blowup.wav",4096L,255-(k<<5),255-((7-k)<<5)); break;
			case 3: wsay("blowup.wav",4096L,255-(k<<5),255-((7-k)<<5)); break;
			case 4: wsay("blowup.wav",4096L,255-(k<<5),255-((7-k)<<5)); break;
			case 5: wsay("death.wav",4096L,255-(k<<5),255-((7-k)<<5)); break;
			case 6: wsay("closdoor.wav",4096L,255-(k<<5),255-((7-k)<<5)); break;
		}

		if (!check4mate(turn))
			wsay("closdoor.wav",4096L,255L,255L);
		else if (!check4check(turn))
			wsay("alarm.wav",4096L,255L,255L);

		if ((oboardj&7) == 6)
		{
			drawboard(0L,0L,XDIM,YDIM);
			blit(0L,0L,XDIM,YDIM);
			while (keystatus[0x1c]|keystatus[1]);
			while (!(keystatus[0x1c]|keystatus[1]));
			cleanexit();
		}
	}
}

openrectangle(long x1, long y1, long x2, long y2, long col)
{
	long i, x, y, p;

	if (x1 > x2) i = x1, x1 = x2, x2 = i;
	if (x1 < 0) x1 = 0;
	if (x2 >= XDIM) x2 = XDIM-1;

	if (y1 > y2) i = y1, y1 = y2, y2 = i;
	if (y1 < 0) y1 = 0;
	if (y2 >= YDIM) y2 = YDIM-1;

	if (x1 <= x2)
	{
		p = ylookup[y1]+x1+frameplace;
		i = x2-x1;
		for(y=y1;y<=y2;y++)
			{ *(char *)p = col; *(char *)(p+i) = col; p += XDIM; }
	}
	if (y1 <= y2)
	{
		p = ylookup[y1]+x1+frameplace;
		i = ylookup[y2-y1];
		for(x=x1;x<=x2;x++)
			{ *(char *)p = col; *(char *)(p+i) = col; p++; }
	}
}

fillrectangle(long x1, long y1, long x2, long y2, long col)
{
	long i, p, xcnt, dacol;

	if (reverseboard)
	{
		i = x1; x1 = XDIM-1-x2; x2 = XDIM-1-i;
		i = y1; y1 = YDIM-1-y2; y2 = YDIM-1-i;
	}

	if (x1 > x2) i = x1, x1 = x2, x2 = i;
	if (x1 < 0) x1 = 0;
	if (x2 >= XDIM) x2 = XDIM-1;
	if (y1 > y2) i = y1, y1 = y2, y2 = i;
	if (y1 < 0) y1 = 0;
	if (y2 >= YDIM) y2 = YDIM-1;
	if ((x1 > x2) || (y1 > y2)) return;

	dacol = ((long)col)+(((long)col)<<8); dacol += (dacol<<16);
	xcnt = x2-x1+1;

	p = ylookup[y1]+x1+frameplace;
	for(i=y2-y1;i>=0;i--) { clearbufbyte(p,xcnt,dacol); p += XDIM; }
}

setgamemode()
{
	long y, p;

	screen = (char *)malloc(XDIM*(YDIM+4));
	frameplace = (long)&screen[XDIM<<2];
	clearbuf(frameplace,(XDIM*YDIM)>>2,0L);

	p = 0;
	for(y=0;y<YDIM;y++) ylookup[y] = p, p += XDIM;

	if ((XDIM == 320) && (YDIM == 200)) setvmode(0x13);
	if ((XDIM == 640) && (YDIM == 480)) setvesamode(0x101);
	if ((XDIM == 800) && (YDIM == 600)) setvesamode(0x103);
	if ((XDIM == 1024) && (YDIM == 768)) setvesamode(0x105);
	if ((XDIM == 1280) && (YDIM == 1024)) setvesamode(0x107);
	if ((XDIM == 1600) && (YDIM == 1200)) setvesamode(0x120);
}

setvesamode(short vesamode)
{
	static struct rminfo
	{
		long EDI, ESI, EBP, ESP, EBX, EDX, ECX, EAX;
		short flags, ES, DS, FS, GS, IP, CS, SP, SS;
	} RMI;

	union REGS regs;
	struct SREGS sregs;
	short selector, segment;
	short *ptr, gran;

	memset(&sregs,0,sizeof(sregs));
	regs.w.ax = 0x0100;
	regs.w.bx = (256>>4);             //Number of paragraphs
	int386x(0x31,&regs,&regs,&sregs); // DPMI call 100h allocates DOS memory
	segment = regs.w.ax;
	selector = regs.w.dx;

	memset(&RMI,0,sizeof(RMI));    // Set up real-mode call structure
	RMI.EAX = 0x00004f01;
	RMI.ECX = (long)vesamode;
	RMI.ES = segment;
	RMI.EDI = 0;

	regs.w.ax = 0x0300;            // Use DMPI call 300h to issue the DOS interrupt
	regs.h.bl = 0x10;
	regs.h.bh = 0;
	regs.w.cx = 0;
	sregs.es = FP_SEG(&RMI);
	regs.x.edi = FP_OFF(&RMI);
	int386x(0x31,&regs,&regs,&sregs);

	if ((RMI.EAX&65535) != 0x004f) return(-1);

	ptr = (short *)((((long)segment)<<4)+4);
	gran = 64 / (*ptr);
	vesapageshift = 0;
	while (gran > 1) { vesapageshift++; gran >>= 1; }

	if (vesasetmode(vesamode) != 0x4f) return(-1);
	return(0);
}

	//Warning: blit is now: (0,0,XDIM,YDIM), not: (0,0,XDIM-1,YDIM-1)
blit (long x1, long y1, long x2, long y2)
{
	long y, p1, p2;

	if (reverseboard)
	{
		y = x1; x1 = XDIM-x2; x2 = XDIM-y;
		y = y1; y1 = YDIM-y2; y2 = YDIM-y;
	}
	if (x2 <= x1) return;
	if (y2 <= y1) return;
	if (x1 < 0) x1 = 0;
	if (x2 > XDIM) x2 = XDIM;
	if (y1 < 0) y1 = 0;
	if (y2 > YDIM) y2 = YDIM;

	p1 = ylookup[y1]+x1; p2 = ylookup[y1]+x2;
	for(y=y1;y<y2;y++)
	{
		vesasetpage(p1>>16);
		if ((p1^p2)&0xffff0000)
		{
			copybufbyte(p1+frameplace,(p1&65535)+0xa0000,65536-(p1&65535));
			vesasetpage(p2>>16);
			copybufbyte((p2&0xffff0000)+frameplace,0xa0000,p2&65535);
		}
		else
			copybufbyte(p1+frameplace,(p1&65535)+0xa0000,x2-x1);
		 p1 += XDIM; p2 += XDIM;
	}
}

printext256(long xpos, long ypos, long col, long bacol, char *dabuf)
{
	long i, x, y, p, dat, dat2, oreverseboard;

	for(i=0;i<strlen(dabuf);i++)
	{
		dat = (dabuf[i]<<3);
		for(y=0;y<8;y++)
		{
			p = ylookup[y+ypos]+xpos+frameplace;
			dat2 = textfont[dat+y];
			for(x=128;x>0;x>>=1)
			{
				if (dat2&x) *(char *)p = col;
				else if (bacol >= 0) *(char *)p = bacol;
				p++;
			}
		}
		xpos += 8;
	}
	oreverseboard = reverseboard; reverseboard = 0;
	blit(xpos-(strlen(dabuf)<<3),ypos,xpos,ypos+8);
	reverseboard = oreverseboard;
}

checktypemode()
{
	long i, j, charsperline, oreverseboard;

	if (keystatus[1])
	{
		keystatus[1] = 0;

		oreverseboard = reverseboard; reverseboard = 0;
		i = (XDIM>>1)-(30<<2); j = (YDIM>>1);
		printext256(i,j,24L,-1L,"Are you sure you want to quit?");
		blit(i,j,i+(30<<3),j+8);
		reverseboard = oreverseboard;

		while (1)
		{
			if (keystatus[0x15]) cleanexit();
			if ((keystatus[0x31]) || (keystatus[1]))
				{ keystatus[0x31] = keystatus[1] = 0; break; }
		}

		if (!reverseboard)
		{
			drawboard(i,j,i+(30<<3),j+8);
			blit(i,j,i+(30<<3),j+8);
		}
		else
		{
			drawboard(XDIM-i-(30<<3),YDIM-j-8,XDIM-i,YDIM-j);
			blit(XDIM-i-(30<<3),YDIM-j-8,XDIM-i,YDIM-j);
		}
	}

	if (typemode == 1)
	{
		charsperline = 80;
		for(i=0;i<=typemessageleng;i+=charsperline)
		{
			for(j=0;j<charsperline;j++) tempbuf[j] = typemessage[i+j];
			if (typemessageleng < i+charsperline)
			{
				tempbuf[(typemessageleng-i)] = '_';
				tempbuf[(typemessageleng-i)+1] = 0;
			}
			else
				tempbuf[charsperline] = 0;
			printext256(0L,(i/charsperline)<<3,183L,0L,tempbuf);
		}
	}
	if (getmessageleng > 0)
	{
		charsperline = 80;
		for(i=0;i<=getmessageleng;i+=charsperline)
		{
			for(j=0;j<charsperline;j++)
				tempbuf[j] = getmessage[i+j];
			if (getmessageleng < i+charsperline)
				tempbuf[getmessageleng-i] = 0;
			else
				tempbuf[charsperline] = 0;

			printext256(0L,((i/charsperline)<<3)+(YDIM-32-8)-(((getmessageleng-1)/charsperline)<<3),151L,0L,tempbuf);
		}
		if (totalclock > getmessagetimeoff)
		{
			getmessageleng = 0;
			drawboard(0L,YDIM-64L,XDIM,YDIM);
			blit(0L,YDIM-64L,XDIM,YDIM);
		}
	}

	if (!typemode)
	{
		if ((keystatus[0xe]) && (numplayers < 2))
		{
			keystatus[0xe] = 0;

			if (movelistcnt >= 2)
			{
				movelistcnt -= 2;
				copybuf(startboard,board,64>>2);
				for(i=0;i<movelistcnt;i++)
				{
					j = movelist[i];
					movepiece((j>>6)&7,j>>9,j&7,(j>>3)&7,1);
				}

				drawboard(0L,0L,XDIM,YDIM);
				blit(0L,0L,XDIM,YDIM);

				wsay("ouch.wav",4096L,255L,255L);
			}
		}

		if ((keystatus[keys[18]]) > 0)   //Typing mode
		{
			keystatus[keys[18]] = 0;
			typemode = 1;
		}
	}
	else
	{
		for(i=0;i<128;i++)
			if (keystatus[i] > 0)
			{
				if ((keystatus[0x2a]|keystatus[0x36]) > 0)
				{
					if (scantoascwithshift[i])
					{
						keystatus[i] = 0;
						if (typemessageleng < 159)
							typemessage[typemessageleng++] = scantoascwithshift[i];
					}
				}
				else
				{
					if (scantoasc[i])
					{
						keystatus[i] = 0;
						if (typemessageleng < 159)
							typemessage[typemessageleng++] = scantoasc[i];
					}
				}
			}

		if (keystatus[0xe] > 0)   //Backspace
		{
			keystatus[0xe] = 0;
				//Here's a trick of making key repeat after a 1/2 second
			if (typemessageleng > 0) typemessageleng--; else typemode = 0;

			drawboard(0L,0L,XDIM,64L);
			blit(0L,0L,XDIM,64L);
		}

		if ((keystatus[0x1c]|keystatus[0x9c]) > 0)  //Either ENTER
		{
			if (typemessageleng > 0)
			{
				i = 0;
				tempbuf[i++] = 2;          //Sending text is message type 2
				for(j=0;j<typemessageleng;j++)
					tempbuf[i++] = typemessage[j];

				for(i=connecthead;i>=0;i=connectpoint2[i])
					if (i != myconnectindex)
						sendpacket(i,tempbuf,j+1);

				drawboard(0L,0L,XDIM,64);
				blit(0L,0L,XDIM,64);
			}

			typemessageleng = 0;
			keystatus[0x1c] = 0;
			keystatus[0x9c] = 0;
			typemode = 0;
		}

		if ((keystatus[0xf]) > 0) //Tab
		{
			keystatus[0xf] = 0;
			typemode = 0;
		}
	}
}

check4check(long dacol)
{
	long i, j, bestmove;

	for(i=23;i>=0;i--) rank2[i] = rank[i];

	globrecursion = 1; recursecnt = 0;

	globalvalidptr = &validmove[-1][0];
	if (!dacol) i = bestblack(&bestmove); else i = bestwhite(&bestmove);

	return((board[bestmove&63]&7) != 6);
}

check4mate(long dacol)
{
	long i, j, bestmove, good;
	char pat[8];

	for(i=23;i>=0;i--) rank2[i] = rank[i];

	globrecursion = 2; recursecnt = 0;

	globalvalidptr = &validmove[-1][0];
	if (!dacol) i = bestwhite(&bestmove); else i = bestblack(&bestmove);

		//Do move
	qmovepiece(bestmove>>6,bestmove&63,pat);
	good = check4check(dacol);
	patchback(pat);

	return(good);
}
