uses crt,dos,xms,keypres2;
CONST
     PatchSize=128*128;{  ⥪ન (஢!)}
     MaxPlayers=4;{Network players}
     MaxLights=10;
     MaxObjects=500;
     MaxObjPrototypesPoligonNodes=20;
     Header3DM:string='-3D MAP FILE,USED BY SERs ENGINE AS MAP-';
     Eps=0.000001;
     EpsL3:double=0.01;
     g=9.81{};
     CriticalOverload=20*200;
     Mn=2000;
     HitKoef:double=1;
     Red=31;
     White=15;
     Gray=5;

TYPE
{SECTION of memory needs}
    VideoBuffer=array[0..65000] of byte;
    TextureBuffer=array[0..PatchSize] of byte;
    LightBuffer=array[0..16*256 {0..15,0..255}] of byte;
    ZBuffer=array[0..16000] of longint;
    ZBuf=^ZBuffer;
    LettersBuffer=array[0..7*320] of byte;

{SECTION of Road}
    RoadFlat=record {࠭  .    - 300 byte}
    {RoadFlat  "" -  ⮪ ண{}
             X,Y,Z:array[0..4] of longint;{न  ண}{60}
             Xm1,Ym1,Xm2,Ym2:double;{न । ண}{32}
             a1,b1:double;{2  ࠢ ண}{16}
             RWidth:longint;{ਭ   ண}{4}
             RWidth1:longint;{ਭ 砫  ண}{4}
             RLength:double;{ }{8}
             lll:double;{ᯮ⥫쭠 ६  ᫥ ਭ}{8}
             v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{ ⥬ }{72}
             RStaTexture,RCurTexture,RFinTexture:word;{ 樨 }{6}
             RStaLight,RCurLight,RFinLight:byte;{ᢥ饭 }{3}
             RFriction:double;{७  }{8}
             RDistanceFromStart:double;{ﭨ  砫 }{8}
             RScaling:double;{8}
             reserved:array[1..63] of byte;
             end;

{SECTION of Cars characteristics}
    EngineRecord=record {42 bytes}
                 EMaxSpeed:double;{ ࠧ ᪮}{8}
                 EAcceleration:double;{᪮७ ࠧ (.)}{8}
                 EMaxStreif:double;{.  ᪮}{8}
                 EStreifAcceleration:double;{᪮७  ᪮ (.)}{8}
                 EFriction:double;{樥 ମ ⥫}{8}
                 EDamage:integer;{饥 ० ⥫}{2}
                 end;

{SECTION of objects dynamic data}
    ObjRecord=record{Totaly 300 bytes . Used: 190+ _34_ =228 bytes}
              X,Y,Z:double;{Current position in 3d}{24}
              CPlato:longint;{न 設 ⭮⥫쭮 : ,}{4}
              CPlatoOfs,CDev:double;{ ᬥ饭  ,  ⪫  }{16}
              v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{Object's 3x3 vector system in 3d}{72}
              CStatus:integer;{Health percentage}{2}
        {+126}CEnergy:Double;{Energy}{8}
              CMass:Double;{Car mass}{8}
              CGravitation:Double;{Cars gravitation}{8}
              CEngine:EngineRecord;{Engine in this car}{sizeof(EngineRecord)}{42}
        {+176}CWidth,CLength,CHeight:longint;{Gabarities: Car width, length and height}{12}
              CCurrentSpeed,CStep:double;{Current car speed, Real cars step of movement}{16}
              CStreifSpeed,CStreif:double;{16}
              CCriticalOverload:double;{Value, which MULs to "g"-const gives the critical overloading level in velocity}{8}
        {+224}CXMSPrototypeOffset:longint;{Id of the object}{4}
              CDistanceFromStart:double;{8}
              CLaps:word;{Laps count}{2}
        {+246}Zt:double;{Z coordiate of the obj above the track}{8}
              CFalling:double;{Falling down step}{8}
        {+256}CFCONumber:word;{Nearest forward Object N...}{2}
              CBCONumber:word;{Nearest backward object N}{2}
              CFCollised:byte;{1=Collised with CFCONumber}{1}

              CHeadLightCounter:byte;{Counts the headlight brightness 0-15}{1}
              CBrakeLightSwitch:byte;{Switch: on=brake, off=no brake}{1}
              CTTL:word;{Time to live: 0..65534-tics to live;65535=Immortal}{1}

              CWeapon:byte;{Weapon number}{1}
              Mines,Rockets:byte;{Mines,Rockets count}{2}
              CReloadCounter:byte;{1}
              CShield:byte;{1}

              CId:byte;{Identification:0=Normal collised object,1=Explosive object,2=Non collised;255=dead}{1}
              CCounter:word;
              COwner:word;{Owner number}{2}
              Keys:array[1..6] of byte;{Pressed keys on keyboard, not more than 6 one time!}{6}
              {1=Fire;2=Change weapon;3=F/Bward;4=Streifs;5=Shield;6=Stop;{}
              BotControl:byte;{for robot}{1}
              CReserved:array[1..8] of byte;
              end;

{SETION of Objects vector prototypes}
    ObjPrototypeInfo=record{256 byte}
                     OPName:string[16];{16}
                     OPLength,OPWidth,OPHeight:double;{24}
                     OPViewX,OPViewY,OPViewZ:longint;{12}
                     OPGunX,OPGunY,OPGunZ:longint;{12}
                     OPMass:double;{8}
                     OPXMSSize:longint;{4}
                     OPXMSTexturesOffset:longint;{4}
                     OPPoligons:word;{2}
                     OPReserved:array[1..173] of byte;
                     end;
    ObjPrototypePoligon=record{Totaly 100 bytes. Used: 93 bytes}
                        OPNodes:word;{2}
                        OPStaTexture,OPTexturePhaze,OPFinTexture:word;{6}
                        OPStaLight,OPLightPhaze,OPFinLight:byte;{3}
                        OPControlFlag:byte;{1}
                        v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{72}
                        OPScaling:double;{8}
                        OPVisibility:byte;{1}
                        reserved:array[1..7] of byte;
                        end;
    ObjPrototypePoints3D=record{12}
                         X,Y,Z:longint{12}
                         end;
    ObjPrototypeDoublePoints3D=record{24}
                               X,Y,Z:double{24}
                               end;
{SECTION of camera dynamic data}
    CameraRecord=record{128 bytes}
                 X,Y,Z:double;{Current position in 3d}{24}
                 Sector:word;{Current sector the object belongs to}{2}
                 v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{Object's 3x3 vector system in 3d}{72}
                 MaxSpeed:longint;{Max possible camera's speed in 3d}{4}
                 SpeedX,SpeedY,SpeedZ:longint;{12}
                 Acceleration:longint;{acceleration for speed}{4}
                 MaxAngle:integer;{Max possible rotation delta angle}{2}
                 AngleX,AngleY,AngleZ:integer;{angles for turning}{6}
                 DeltaAngle:integer;{delta anlge for turning angles}{2}
                 FrictionSpeed:longint;{Frictional machanizm}{4}
                 FrictionAngle:integer;{Frictional machanizm}{2}
                 end;

var
   Vp:^VideoBuffer;{Visual page pointer}
   Tx:^TextureBuffer;{Textures page pointer}
   Lt:^LightBuffer;{Light table pointer}
   StaLiteGrad,CurLiteGrad,FinLiteGrad:word;{Change lite}
   ZB:array[0..3] of ZBuf;{4xZBuffer}
   Letters:^LettersBuffer;{Own Letters}

   PCO:array[1..MaxObjects] of word;{Potential Collised objects array. Numbers of 'nearest Y' cars}
   PCOcounter:word;{Counter of PCO objects}

   Lights:array[1..MaxLights] of record X,Y,Z,StaI,CurI,FinI,StepI:longint;end;
   Lites:byte;
   LightTrack:boolean;

   MRec : XMMRec;

   {Road flats variables}
   XMSRoadFlat:word;{ਯ   ,  ࠭  ஦ }
   RoadFlat1,RoadFlat2:RoadFlat;{⮪ ண1}
   RoadFlats:longint;{- ⪮ (=) ண, 稭  0}
   Distance,Distance1,DistanceKoef,RDev:double;

   {Textures variables}
   XMSTextures:word;{ਯ   ,  ࠭ ⥪ ஦ }
   Patches,PatchesSize,FSize:longint;{Patches in handle, their whole size and File size}
   TexturateMethod:byte;{Number of texturated method}
   Sectors:word;{Other needs}

   {System variables}
   ObjectsVectorPrototypesBlockSize:longint;
   MaxRoadSegments:longint;

   BIOSTime : LongInt  Absolute $40:$6C;
   Timer:byte;{1=timer on, 0 = off}
   OutCabin:byte;{1=Out,0=In}
   FPS:longint;{Frames Per Second}
   MemoryStatus:byte;{Status of XMS and Base memory allocation }
   lb,rb,ub,db:integer;{Screen bounders}
   v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{ ⥬  }
   R,k4:double;{Perspective=200}
   Zr:Double;{Other needs}
   strg:string;{string needs}
   ConsolStr:array[1..4] of string[40];{Consol strings}
   InterpretatesFile:string[8];{Currently interpretated file name}
   InterpretatesLine:longint;{For interpretator. Show number of line in interpretated file}
   GameOver:byte;

   {Network}
   Player:array[1..4] of word;{Network player object numbers.Example: Object number "Player[1]" is drived by Player1}
   Players:byte;{Network total players count}
   OwnNetworkNumber:byte;{Own offset in Player[] array}

   {Camera}
   Camera:CameraRecord;
   ScreenX,ScreenY:integer;
   AutoCamera:byte;
   CameraInCar:boolean;{True=Camera in car,False=Camera free}

   {Engine types}
   NoEngine,SimpleEngine,SuperEngine,HyperUltraEngine:EngineRecord;

   {Objects prototypes memory}
   XMSObjectsPrototypes:word;{ਯ   ,  ࠭ Vector Objects Prototypes}
   ObjPrototypeInfo1:ObjPrototypeInfo;
   ObjPrototypePoligon1:ObjPrototypePoligon;
   ObjXYZ:array[1..MaxObjPrototypesPoligonNodes] of ObjPrototypePoints3D;{Points3D for Prototypes}
   XMSObjectsPrototypeOffset:longint;{Final offset in XMS for OVP}
   _XMSObjectsPrototypeOffset:longint;{Other needs}
   XMSMineOffset:longint;{Offset in XMS for mine}
   XMSRocketOffset:longint;{Offset in XMS for rocket}
   XMSBangOffset:longint;{Offset in XMS for small bang}
   XMSSupBangOffset:longint;{Offset in XMS for super bang}
   XMSSmogOffset:longint;{Offset for smog}

   {Objects dynamic data}
   XMSObjects:word;{ਯ   ,  ࠭ Objects Current Data}
   Objects:word;{Track Objects count}
   Cars,CarsOfs:word;{Among object are cars and their offset in Objects}
   Obj1,Obj2:ObjRecord;{record to load up object from XMS}
   Speed,StreifSpeed:double;{For players car}
   FoundamentalObject:boolean;
   FoundamentalObjectNumber:word;{}

   {Test section}
   MinW:double;
   MaxL1,MaxL2,MaxL3,MaxL4:double;
   Indicate1:string;
   _CarNumber:word;
   _Distance:double;
   TestFlag:byte;
   HideAll:byte;

   _l1,_l2,_l3,_l4,_i1,_i2,_i3,_i4:double;
   _lft,_rht,_Zindex:longint;
   AutoTest:string;


   {Massives}
   sn:array[0..359] of double;{sinus table}

   Lbd,Rbd,MLbd,MRbd:array[0..200] of integer;{Floodfill massives}
   MinY,MaxY:longint;
   PMaxX,PMinX:longint;
   Mub,Mdb:integer;

   o,p:array[0..MaxObjPrototypesPoligonNodes+2] of longint;{2D Peaks on screen}
   plt:array[0..767] of byte;{palette}

   i,j:integer;

{==================Math support==============================================}
function sgn(x:double):integer;
begin
     if x<0 then sgn:=-1 else if x>0 then sgn:=1 else sgn:=0;
end;

function sgnl(x:longint):integer;
begin
     if x<0 then sgnl:=-1 else if x>0 then sgnl:=1 else sgnl:=0;
end;

function sinn(u:integer) : double;
begin
     u:=u mod 360;
     if u<0 then u:=360+u;
     sinn:=sn[u];
end;

function coss(u:integer) : double;
begin
     coss:=sinn(90-u);
end;




{=================Vectors support============================================}
Procedure InitVectorsSystem(var v11,v12,v13,v21,v22,v23,v31,v32,v33:Double);
begin
     v11:=1;v12:=0;v13:=0;
     v21:=0;v22:=1;v23:=0;
     v31:=0;v32:=0;v33:=1;
end;

{Init rotation matrix by follow angles U1,U2,U3 and rotate vectors system
by multiplicating it on rotation matrix}
Procedure RotateVectorsSystem(U1,U2,U3:integer;var v11,v12,v13,v21,v22,v23,v31,v32,v33:Double);
var
   c1,c2,c3,s1,s2,s3:double;
   vv11,vv12,vv13,vv21,vv22,vv23,vv31,vv32,vv33:double;
   m11,m12,m13,m21,m22,m23,m31,m32,m33:double;{Rotation matrix elements}
begin
     {Creating rotation matrix}
     c1:=coss(U1);c2:=coss(U2);c3:=coss(U3);
     s1:=sinn(U1);s2:=sinn(U2);s3:=sinn(U3);

     m11:=s3*s1+c3*c2*c1;m12:=c3*c2*s1-s3*c1;m13:=c3*s2;
     m21:=s2*c1;         m22:=s2*s1;         m23:=-c2;
     m31:=s3*c2*c1-c3*s1;m32:=s3*c2*s1+c3*c1;m33:=s3*s2;

     {Multiplicating}
     vv11:=v11;vv12:=v12;vv13:=v13;
     vv21:=v21;vv22:=v22;vv23:=v23;
     vv31:=v31;vv32:=v32;vv33:=v33;

     v11:=m11*vv11+m12*vv21+m13*vv31;
     v12:=m11*vv12+m12*vv22+m13*vv32;
     v13:=m11*vv13+m12*vv23+m13*vv33;

     v21:=m21*vv11+m22*vv21+m23*vv31;
     v22:=m21*vv12+m22*vv22+m23*vv32;
     v23:=m21*vv13+m22*vv23+m23*vv33;

     v31:=m31*vv11+m32*vv21+m33*vv31;
     v32:=m31*vv12+m32*vv22+m33*vv32;
     v33:=m31*vv13+m32*vv23+m33*vv33;
end;

procedure _Error(strg:string);forward;
{Creat Normal Vector to 2 others: (a1,b1,g1) and (a2,b2,g2) }
procedure normal(a1,b1,g1,a2,b2,g2:double;var a3,b3,g3:double);
var w1,w2,w3,ww,l:double;{}
begin
{     a3:=b1*g2-b2*g1;
     b3:=a2*g1-a1*g2;
     g3:=a1*b2-a2*b1;{}

     w1:=a1*b2-a2*b1;
     w2:=b1*g2-b2*g1;
     w3:=a1*g2-a2*g1;
     ww:=w1*w1+w2*w2+w3*w3;
     a3:=w2/ww;
     b3:=-w3/ww;
     g3:=w1/ww;
     l:=sqrt(a3*a3+b3*b3+g3*g3);
     a3:=a3/l;
     b3:=b3/l;
     g3:=g3/l;

{     if (abs(b1*g2-b2*g1-a3)>Eps)or(abs(a2*g1-a1*g2-b3)>Eps)or(abs(a1*b2-a2*b1-g3)>Eps) then
        _Error('Can not creat valid normal vector!');{}
end;

{==================CONSOL====================================================}
Procedure ScroolConsolStrings;
var i:byte;
begin
     for i:=2 to 4 do
         ConsolStr[i-1]:=ConsolStr[i];
     ConsolStr[4]:='';
end;

Procedure AddStrToConsol(msg:string);
begin
     ConsolStr[4]:=copy(msg,1,40);
end;


{==================TEXTMODE CO80 interface===================================}
Function ItoS(i:longint):string;
var s:string;
begin
     str(i,s);
     ItoS:=s;
end;

Function DtoS(d:double):string;
var s:string;
begin
     str(d:3:5,s);
     DtoS:=s;
end;


procedure msg(beginPos,col,backcolor:word;strg:string);
begin
textbackground(0);
write(' ':beginPos);
textcolor(col);
textbackground(backcolor);
write(strg);
end;

procedure msg_(beginPos,color,backcolor:word;strg:string);
begin
msg(beginPos,color,backcolor,strg);
writeln;
end;

Procedure FreeProgramMemory;
begin
     if MemoryStatus>0 then for i:=0 to 3 do dispose(ZB[i]);
     if MemoryStatus>1 then dispose(Vp);
     if MemoryStatus>2 then dispose(Tx);
     if MemoryStatus>3 then dispose(Lt);
     if MemoryStatus>4 then dispose(Letters);

     if MemoryStatus>13 then FreeXMS(XMSTextures);
     if MemoryStatus>14 then FreeXMS(XMSObjectsPrototypes);
     if MemoryStatus>15 then FreeXMS(XMSObjects);
     if MemoryStatus>16 then FreeXMS(XMSRoadFlat);
end;

procedure _Error(strg:string);
var s:string;
    f:text;
    CurVideoMode:byte;
begin
     FreeProgramMemory;
     asm mov ah,0fh;int 10h;mov CurVideoMode,al;end;
     if CurVideoMode<>3 then textmode(co80);
     textcolor(4);
     write(strg);
     textcolor(7);
     writeln(#13#10'SER Game Corporation 2000 year');
{---}
     assign(f,'dtr.log');
     append(f);
     str(MaxL1,s);writeln(f,'MaxL1=',s);
     str(MaxL2,s);writeln(f,'MaxL2=',s);
     str(MaxL3,s);writeln(f,'MaxL3=',s);
     str(MaxL4,s);writeln(f,'MaxL4=',s);
     str(MinW,s);writeln(f,'MinW=',s);
     writeln(f,'--- End of log ---');
     close(f);
{---}
     writeln('Avail memory=',maxavail);
     Remove_Handler;
     readkey;
     halt;
end;

{=====================FONT UNIT==============================================}
Function VGAcard : Boolean; Assembler;
Asm
  Mov   AX, 1A00h
  Int   10h
  Cmp   AL, 1Ah
  JNE   @@NotVGA
  Cmp   BL, 7
  JE    @@VGA
  Cmp   BL, 8
  JE    @@VGA
@@NotVGA:
  Mov   AL, 0
  Jmp   @@Quit
@@VGA:
  Mov   AL, 1
@@Quit:
End;

{Initializates 13h mode and sets the palette}
Procedure Init13h;
var i:integer;
    Color,Gradation:byte;
begin
{Creat the light table}
     for Color:=0 to 255 do
         begin
         for Gradation:=0 to Color mod 16 do
             LT^[Gradation*256+Color]:=Color-Gradation;
         inc(Gradation);
         while Gradation<16 do
               begin
               LT^[Gradation*256+Color]:=0;
               inc(Gradation);
               end;
         end;

   asm mov ax,13h;int 10h;end;
   for i:=0 to 255 do
       begin
       port[$3c8]:=i;
       port[$3c9]:=plt[i*3];
       port[$3c9]:=plt[i*3+1];
       port[$3c9]:=plt[i*3+2];
       end;
end;

Procedure ShowTx;
var i:byte;
begin
     for i:=0 to 127 do
         move(Tx^[i shl 7],mem[$a000:i*320],128);
     readkey;
end;


Procedure WriteStr(X,Y:integer;color,backcolor:byte;Msg:string);
var
   j,l:integer;
   Col:char;
   Clr:byte;
   VOfs,FOfs:longint;
begin
     for l:=1 to Length(Msg) do
         begin
         Col:=Msg[l];
         Case Col of
              'A'..'Z':FOfs:=6*(ord(Col)-65);
              'a'..'z':FOfs:=6*(ord(Col)-97);
              '0'..'9':FOfs:=6*(ord(Col)-48+26);
              '=':FOfs:=6*36;
              '-':FOfs:=6*37;
              '+':FOfs:=6*38;
              ':':FOfs:=6*39;
              ' ':FOfs:=320*7;
              end;

         VOfs:=longint(Y)*320+longint(X)+longint(L)*6-6;
         While FOfs<2240{320*7} do
             begin
             for j:=0 to 5 do
                 begin
                 Clr:=Letters^[FOfs];
                 if Clr>0 then vp^[VOfs]:=Color
                          else if BackColor>0 then vp^[VOfs]:=BackColor;
                 inc(FOfs);inc(VOfs);
                 end;
             inc(FOfs,314{320-6});inc(VOfs,314);
             end;
         end;
end;


{======================XMS-BASED MEMORY FUNCTIONS============================}

{Loading RoadFlat number "FlatNumber" data from XMS into "RoadFlat1" global record}
Procedure LoadRoadFlatFromXMS(var RoadFlat1:RoadFlat;FLatNumber:longint);
var XMSOffset:longint;
begin
     {Fullish checking}
     if FlatNumber>RoadFlats then FlatNumber:=FlatNumber-RoadFlats;

     XMSOffset:=longint(FlatNumber)*300;
     xms_move(MRec,XMSRoadFlat,word(XMSOffset and $FFFF),word(XMSOffset shr 16){},
              0,ofs(RoadFlat1),seg(RoadFlat1),
              300);
end;

Procedure SaveRoadFlatToXMS(var RoadFlat1:RoadFlat;FLatNumber:longint);
var XMSOffset:longint;
begin
     {Fullish checking}
     if FlatNumber>RoadFlats then FlatNumber:=FlatNumber-RoadFlats;

     XMSOffset:=longint(FlatNumber)*300;
     xms_move(MRec,0,ofs(RoadFlat1),seg(RoadFlat1),
              XMSRoadFlat,word(XMSOffset and $FFFF),word(XMSOffset shr 16){},
              300);
end;


{Loading XMSObjectsPrototypeInfo}
Procedure LoadObjPrototypeInfoFromXMS(var ObjPrototypeInfo1:ObjPrototypeInfo;XMSOffset:longint);
begin
     xms_move(MRec,XMSObjectsPrototypes,word(XMSOffset and $FFFF),word(XMSOffset shr 16){},
              0,ofs(ObjPrototypeInfo1),seg(ObjPrototypeInfo1),
              256);
end;

{Saving XMSObjectsPrototypeInfo}
Procedure SaveObjPrototypeInfoToXMS(var ObjPrototypeInfo1:ObjPrototypeInfo;XMSOffset:longint);
begin
     xms_move(MRec,0,ofs(ObjPrototypeInfo1),seg(ObjPrototypeInfo1),
              XMSObjectsPrototypes,word(XMSOffset and $FFFF),word(XMSOffset shr 16){},
              256);
end;


{Loading Objects number "ObjNumber" data from XMS into "Obj1" global record}
{Objects counts from 1 to MaxObjects}
Procedure LoadObjFromXMS(var Obj1:ObjRecord;ObjNumber:word);
var XMSOffset:longint;
begin
     XMSOffset:=longint(ObjNumber-1)*300;
     xms_move(MRec,XMSObjects,word(XMSOffset and 65535),word(XMSOffset shr 16){},
              0,ofs(Obj1),seg(Obj1),
              300);
end;

{Just the same as LoadObjFromXMS, but antipod}
Procedure SaveObjToXMS(var Obj1:ObjRecord;ObjNumber:word);
var XMSOffset:longint;
begin
     XMSOffset:=longint(ObjNumber-1)*300;
     xms_move(MRec,0,ofs(Obj1),seg(Obj1),
              XMSObjects,word(XMSOffset and 65535),word(XMSOffset shr 16){},
              300);
end;


{=======================OTHER FUNCTIONS======================================}

{Evaluating Distance From Start for current car's location}
Function EvaluateDistanceFromStartForObj(CPlato:longint;CPlatoOfs:double):double;
begin
     if CPlatoOfs>=0 then {Fastest method}
        begin
        {Hoping, the track was loaded}
        LoadRoadFlatFromXMS(RoadFlat2,CPlato);
        EvaluateDistanceFromStartForObj:=RoadFlat2.RDistanceFromStart+CPlatoOfs;
        end;
end;

{Method to determine the whole RoadLength}
{Helpfull only!}
Function EvaluateTheWholeTrackDistance(CPlato:longint):double;
var RoadFlat2:RoadFlat;
    XMSOffset:longint;
begin
     {Hoping, the track was loaded}
     LoadRoadFlatFromXMS(RoadFlat2,CPlato);
     EvaluateTheWholeTrackDistance:=RoadFlat2.RDistanceFromStart+RoadFlat2.RLength;
end;


{==============ACTIONS WITH OBJECTS==========================================}

{Creating Object Data by params. Save the created to XMS if LastAction.
Inc objects}
Procedure CreatObj(_Id:byte;{Identification}
                  _Plato:longint;_PlatoOfs,_Dev,_Z:double;{position}
                  _Status,_Energy:integer;
                  _Engine:EngineRecord;
                  _CCurrentSpeed,_CStep:double;
                  _CStreifSpeed,_CStreif:double;
                  _CGravitation,_CFalling:double;
                  _CriticalOverload:double;
                  _XMSPrototypeOffset:longint;
                  _TTL:word;
                  _Owner:word;
                  _ReloadCounter:byte;
                  var Obj1:ObjRecord;
                  SaveToXMS:boolean;
                  OVS:boolean
                  );
var
{Here!} r:integer;
   ObjPrototypeInfo1:ObjPrototypeInfo;
begin
     if Objects>=MaxObjects then
        _Error('Max number of possible objects is '+itos(MaxObjects)
              +'! But system have tried to creat one more object...');


     with Obj1 do
          begin
          CId:=_Id;{Identification}

          CPlato:=_Plato;CPlatoOfs:=_PlatoOfs;CDev:=_Dev;Z:=_Z;Zt:=_Z;{Coordinates}
          if OVS then InitVectorsSystem(v11,v12,v13,v21,v22,v23,v31,v32,v33);{and OVS}

          CStatus:=_Status;CEnergy:=_Energy;{Status and Energy}

          {Prototype: load info and point to it in XMS}
          CXMSPrototypeOffset:=_XMSPrototypeOffset;
          LoadObjPrototypeInfoFromXMS(ObjPrototypeInfo1,_XMSPrototypeOffset);

          {Gabarits}
          CWidth:=trunc(ObjPrototypeInfo1.OPWidth);
          CLength:=trunc(ObjPrototypeInfo1.OPLength);
          CHeight:=trunc(ObjPrototypeInfo1.OPHeight);

          {Physics features}
          CMass:=ObjPrototypeInfo1.OPMass;{Prototype Mass}
{Here!}   r:=random(10);
          if r>7 then CEngine:=HyperUltraEngine
          else if r>3 then CEngine:=SuperEngine
               else{} CEngine:=SimpleEngine;
(**)
{          CEngine:=NoEngine;{}
          if _CarNumber=1 then CEngine:=HyperUltraEngine;{Engine}

          CCurrentSpeed:=_CCurrentSpeed;CStep:=_CStep;
          CStreifSpeed:=_CStreifSpeed;CStreif:=_CStreif;
          CGravitation:=_CGravitation;CFalling:=_CFalling;
          CCriticalOverload:=CriticalOverload;

          CDistanceFromStart:=EvaluateDistanceFromStartForObj(CPlato,CPlatoOfs);
          CLaps:=0;

          CFCONumber:=65535;CFCollised:=0;{For bot needs}
          CBCONumber:=65535;

          CHeadLightCounter:=8;
          CBrakeLightSwitch:=0;
          CTTL:=_TTL;
          CCounter:=0;
          COwner:=_Owner;{Owner=parent for this object}

          {Ammo}
          CWeapon:=2;{Rockets}
          Mines:=100;
          Rockets:=100;
          CShield:=0;
          CReloadCounter:=_ReloadCounter;
          fillchar(Keys,6,0);{Fill zero keys array}
          BotControl:=1;{switch to bot}
          end;

    inc(Objects);
    if SaveToXMS then SaveObjToXMS(Obj1,Objects);
end;

{Delete the object number "ObjNum" on track}
Procedure DeleteObjFromXMS(var Obj1:ObjRecord;ObjNum:word);
begin
     fillchar(Obj1.Keys,6,0);
     if ObjNum<CarsOfs+Cars then
        begin {Deleting a car}
        Obj1.CId:=255;
        SaveObjToXMS(Obj1,ObjNum);
        exit;
        end;

     {Last Object stands to deleted object space in XMS}
     LoadObjFromXMS(Obj1,Objects);{Load last object in list}
     SaveObjToXMS(Obj1,ObjNum);{Move it to emptied space of deleted object}
     if Objects>0 then dec(Objects){Dec objects counter}
     else _Error('Delete object number 0 .. What still exist on track this case ?');
end;

{Explose object. Load|Save it if need.
Explose: show simple bang, show super bang, none to show}
Procedure ExploseObj(LoadFromXMS:boolean;var Obj:ObjRecord;ObjNum:word;SaveToXMS:boolean);
begin
     if LoadFromXMS then LoadObjFromXMS(Obj,ObjNum);
     with Obj do
          begin
          Case CId of
               0:CXMSPrototypeOffset:=XMSSupBangOffset;
               1:CXMSPrototypeOffset:=XMSBangOffset;{Objects Prototype=Explosion Prototype}
               2:begin DeleteObjFromXMS(Obj,ObjNum);exit;end;
               end;
          CMass:=10;{Mass=Non-moveable,No gabarits}
          CTTL:=15;{15 animation frames per explosion}
          CId:=2;{Non-collised object}
          CCounter:=0;{Counter to 0, for right animation}
          CReloadCounter:=0;
          end;
     if SaveToXMS then SaveObjToXMS(Obj,ObjNum);
     If ObjNum=CarsOfs then GameOver:=64;
end;

{Save the damages to Obj record}
Procedure DamageObj(LoadFromXMS:boolean;var Obj:ObjRecord;ObjNum:word;Damage:double;SaveToXMS:boolean);
begin
     if LoadFromXMS then LoadObjFromXMS(Obj,ObjNum);
     With Obj do
          begin
          {Proc "Shield" requiered}
          CStatus:=CStatus-trunc(Damage/(CShield+1));
          if CStatus<=0 then
             begin
             if Obj.CTTL>1 then Obj.CTTL:=1;{}
             end;
          if SaveToXMS then SaveObjToXMS(Obj,ObjNum);
          end;
end;


{============LOADING=========================================================}

Procedure LoadFont(FntName:string);
var f:file;
    Size:word;
begin
     msg_(3,8,0,'Trying to load Font file "'+FntName+'"..');
     if FSearch(FntName,GetEnv('PATH'))='' then _Error('File with font "'+FntName+'" was not found!');
     Assign(F,FntName);reset(f,1);blockread(F,Letters^,Sizeof(LettersBuffer),Size);close(f);
     if Size<>sizeof(LettersBuffer)-1 then _Error('Wrong Font file size !');
end;


{***************************3DM UNIT****************************************}

{Checking 3DM Files format,if all right then:
0.Check 3DM file presens by its name
1.Counting number of patches to "Patches"
2.Filling patches size to "PatchesSize"
3.Seting file size to "FSize"
4.Returning number of sectors to "Sectors"
    other case Showing an error}
Procedure Check3DM(Name3dm:string);
var sum,sizeX,sizeY:word;
    b,i:byte;
    f:file;
begin
     if FSearch(Name3dm,GetEnv('PATH'))='' then _Error('File "'+Name3dm+'" was not found !');
     msg_(3,8,0,'Checking "'+Name3dm+'" by 3DM format...');
     assign(f,Name3dm);
     reset(f,1);
     if filesize(f)<length(Header3DM) then _Error('It`s too small 3D Map file!');
     {Reading Header}
     strg:='';
     for i:=1 to length(Header3DM) do
         begin blockread(f,b,1);strg:=strg+chr(b);end;
     if strg<>Header3DM then _Error('Wrong header of 3D Map file');
     blockread(f,plt,768,sum);if sum<768 then _Error('This 3D Map file was cutted!');
     blockread(f,Patches,4,sum);if sum<4 then _Error('This 3D Map file was cutted!');
     blockread(f,PatchesSize,4,sum);if sum<4 then _Error('This 3D Map file was cutted!');
     blockread(f,Fsize,4,sum);if sum<4 then _Error('This 3D Map file was cutted!');
     blockread(f,Sectors,2,sum);if sum<2 then _Error('This 3D Map file was cutted!');
     if filesize(f)<>Fsize then _Error('This 3D Map file was cutted!');{}
     close(f);
end;


{Transforms Patch of different sizes to 128x128 ones}
Procedure TransformPatchTo_128x128(sizeX,sizeY:word);
var i,j:word;
begin
     if SizeX=75 then
        i:=i;
     if sizeX<128 then
        for i:=0 to sizeY-1 do
            begin
            j:=0;
            if sizeX<65 then
               for j:=1 to (128 div sizeX-1) do
                   move(Tx^[i*128],Tx^[i*128+j*sizeX],sizeX);
            if 128 mod sizeX>0 then move(Tx^[i*128],Tx^[i*128+j*sizeX+sizeX],128 mod sizeX);
            end;

     if sizeY<128 then
        begin
        i:=0;
        if sizeY<65 then
           for i:=0 to 128 div sizeY-1 do
               move(Tx^[0],Tx^[i*128*sizeY],128*sizeY);
        if 128 mod sizeY>0 then move(Tx^[0],Tx^[(i+1)*128*sizeY],128*(128 mod sizeY));
        end;
end;

{Allocating needed XMS memory (XMSStatus:=14) and trying to load 3DM file to XMS}
procedure LoadTextures(Name3DM:string);
var
   f:file;
   sizeX,sizeY,sizeR,Size:word;
   TotalPatches,XMSOffset:longint;
   i:integer;
   PatchName:double;
begin
     msg_(3,8,0,'Taking textures from "'+Name3DM+'" :');
     Check3DM(Name3DM);

     {=========XMS allocation==========}
{14} Size:=Patches*PatchSize div 1024+1;
     msg_(3,8,0,'Allocating XMS memory for textures ( '+itos(Size)+' KB )');
     GetXMS(XMSTextures,Size);
     if XMMError<>0 then _Error('XMS ERROR: Not enough Extended Memory!');
     inc(MemoryStatus);{MemoryStatus=14!}
     {================================}

     msg_(3,8,0,'Loading textures...');
     assign(f,Name3DM);
     reset(f,1);

(*     {------------Loading camera position and Vector system---------------}
     seek(f,822);
     with Camera do
          begin
     blockread(f,X,8);blockread(f,Y,8);blockread(f,Z,8);
     blockread(f,v11,8);blockread(f,v12,8);blockread(f,v13,8);
     blockread(f,v21,8);blockread(f,v22,8);blockread(f,v23,8);
     blockread(f,v31,8);blockread(f,v32,8);blockread(f,v33,8);
          end;
*)

{     Init13h;{Here!}
     seek(f,1000);
     XMSoffset:=0;TotalPatches:=0;
     while TotalPatches<Patches do
           begin
           blockread(f,PatchName,8,size);{Patches name}
           blockread(f,sizeX,2);          {size on X}
           blockread(f,sizeY,2);
           if sizeY>128 then sizeY:=128;
           if sizeX>128 then begin sizeR:=sizeX-128;sizeX:=128;end
                        else sizeR:=0;
           for i:=0 to sizeY-1 do
               begin
               blockread(f,Tx^[i shl 7],sizeX);
               seek(f,filepos(f)+sizeR);
               end;
{           ShowTx;{Here!}
           XMSoffset:=TotalPatches*PatchSize;
           if (sizeX<>0)and(sizeY<>0) then TransformPatchTo_128x128(sizeX,sizeY)
           else
               _Error('Hmm...it''s cool to have texture of zero sizes!');
{           ShowTx;{Here!}
           {Put patch to XMS}
           xms_move(MRec,0,ofs(Tx^),seg(Tx^),
                    XMSTextures,XMSoffset and $ffff,XMSoffset shr 16,
                    PatchSize);
           inc(TotalPatches);
           end;
     close(f);
end;

{====================TEXT FUNCTIONS & OPERATIONS ON STRINGS==================}

{removes all " " from begining of "s" string}
Function DelEmptySlotsInStr(s:string):string;
var j:byte;
begin
     j:=1;while s[j]=' ' do inc(j);
     DelEmptySlotsInStr:=copy(s,j,length(s)-j+1);
end;

{Makes chars in Lower case}
Function LowerCase(s:string):string;
var j:byte;
begin
     for j:=1 to length(s) do
         if s[j] in ['A'..'Z'] then s[j]:=chr(ord(s[j])+32);
     LowerCase:=s;
end;

{뤥  ப S ᫠ ⨯ Double, 稭  樨 Num  ⮩ ப}
Function GetValue(var Num:byte;s:string;RangeBound1,RangeBound2:double;ErrorMsg:string):double;
var i,j:byte;
    cd:word;
    Value:double;
begin
     j:=Num;
     while not (s[j] in ['-','+','.','0'..'9']) do
           inc(j);
     i:=j;
     while s[j] in ['-','+','.','0'..'9'] do
           inc(j);
     Num:=j;
     val(copy(s,i,j-i),Value,cd);
     if cd=0 then GetValue:=Value
             else _Error('Arithmetic parsing error in file "'+InterpretatesFile+'", line '+ItoS(InterpretatesLine)+': '+
                         #13#10+s+
                         #13#10+'Reason: '+ErrorMsg+
                         #13#10'Can not continue while problems exists!');
{The value's range checking}
  if RangeBound1<>RangeBound2 then
     if (Value<RangeBound1)or(Value>RangeBound2) then
        _Error('Range checking error in file "'+InterpretatesFile+'", line '+ItoS(InterpretatesLine)+': '+
               #13#10+'Source line: "'+s+'"'+
               #13#10+'Reason: '+ErrorMsg+
               #13#10+'        '+dtos(Value)+' is not in ['+dtos(rangeBound1)+'..'+dtos(RangeBound2)+'] range!'+
               #13#10'Can not continue while problems exists!');

end;


{=======================LOAD UP external Objects Prototypes==================}

{Loading Objects info}
Function LoadObjInfo(var f:text;ObjFileName:string):string;
var Status,j:byte;
    s:string;
begin
     Status:=0;
     while not eof(f) do
           begin
           inc(InterpretatesLine);
           readln(f,s);s:=Lowercase(s);
           j:=1;
           s:=DelEmptySlotsInStr(s);{㤠  . ஡}
           if (copy(s,j,4)='!end')and(Status>5) then
              begin
              ObjPrototypeInfo1.OPXMSTexturesOffset:=0;

              SaveObjPrototypeInfoToXMS(ObjPrototypeInfo1,XMSObjectsPrototypeOffset);

              inc(XMSObjectsPrototypeOffset,256);
              LoadObjInfo:='ok!';
              exit;
              end
           else LoadObjInfo:='File with car "'+ObjFileName+'" is cutted in INFO section!';{}
           if s[j]<>'%' then {஢ઠ  ਩}
              if s<>'' then {஢ઠ   ப}
              begin
              inc(Status);
              With ObjPrototypeInfo1 do
              case Status of
                   1:OPName:=copy(s,1,16);
                   2:begin{Gabarits}
                     OPLength:=GetValue(j,s,0,900,'Wrong objects Y gabarit');
                     OPWidth:=GetValue(j,s,0,900,'Wrong objects X gabarit');
                     OPHeight:=GetValue(j,s,0,900,'Wrong objects Z gabarit');
                     end;
                   3:begin{Driver view point in object}
                     OPViewX:=trunc(GetValue(j,s,-OPWidth,OPWidth,'Wrong objects X driver point'));
                     OPViewY:=trunc(GetValue(j,s,-OPLength,OPLength,'Wrong objects Y driver point'));
                     OPViewZ:=trunc(GetValue(j,s,-OPHeight,OPHeight,'Wrong objects Z driver point'));
                     end;
                   4:begin{Guns fixed point on object}
                     OPGunX:=trunc(GetValue(j,s,-900,900,'Wrong objects X guns point'));
                     OPGunY:=trunc(GetValue(j,s,-900,900,'Wrong objects X guns point'));
                     OPGunZ:=trunc(GetValue(j,s,-900,900,'Wrong objects X guns point'));
                     end;
                   5:OPMass:=GetValue(j,s,1,1000000,'Wrong objects mass');
                   6:OPPoligons:=trunc(GetValue(j,s,0,1000,'Wrong objects poligons count'));
              else dec(Status);
              end;
              end;
           end;
     LoadObjInfo:='File with car "'+ObjFileName+'" is cutted in INFO section!';
end;

{Loading one Objects poligon}
Function LoadObjPoligon(var f:text;ObjFileName:string):string;
var Status,j:byte;
    Nodes:word;
    s:string;
    dx,dy,dz,l:double;
begin
     Status:=0;
     while not eof(f) do
           begin
           if Status>5 then
              begin

              {Building Prototype Vector system for each Objects poligon}
              With ObjPrototypePoligon1 do
                   begin
                   dx:=ObjXYZ[1].X-ObjXYZ[2].X;
                   dy:=ObjXYZ[1].Y-ObjXYZ[2].Y;
                   dz:=ObjXYZ[1].Z-ObjXYZ[2].Z;
                   l:=sqrt(dx*dx+dy*dy+dz*dz);
                   v11:=dx/l;v12:=dy/l;v13:=dz/l;
                   dx:=ObjXYZ[3].X-ObjXYZ[2].X;
                   dy:=ObjXYZ[3].Y-ObjXYZ[2].Y;
                   dz:=ObjXYZ[3].Z-ObjXYZ[2].Z;
                   l:=sqrt(dx*dx+dy*dy+dz*dz);
                   v21:=dx/l;v22:=dy/l;v23:=dz/l;
                   normal(v11,v12,v13,v21,v22,v23,v31,v32,v33);
                   normal(v31,v32,v33,v11,v12,v13,v21,v22,v23);
                   end;

xms_move(MRec,0,ofs(ObjPrototypePoligon1),seg(ObjPrototypePoligon1),
         XMSObjectsPrototypes,word(XMSObjectsPrototypeOffset and 65535),word(XMSObjectsPrototypeOffset shr 16){},
         100);
         inc(XMSObjectsPrototypeOffset,100);

ObjXYZ[Nodes].X:=ObjXYZ[1].X;{This cycles the poligon, Nodes just = real nodes+1 = OPNodes }
ObjXYZ[Nodes].Y:=ObjXYZ[1].Y;
ObjXYZ[Nodes].Z:=ObjXYZ[1].Z;

xms_move(MRec,0,ofs(ObjXYZ),seg(ObjXYZ),
         XMSObjectsPrototypes,word(XMSObjectsPrototypeOffset and 65535),word(XMSObjectsPrototypeOffset shr 16){},
         ObjPrototypePoligon1.OPNodes*12{ToDD24});

              inc(XMSObjectsPrototypeOffset,ObjPrototypePoligon1.OPNodes*12{ToDD24});
              LoadObjPoligon:='ok!';
              exit;

              end;
           inc(InterpretatesLine);
           readln(f,s);s:=Lowercase(s);
           j:=1;
           s:=DelEmptySlotsInStr(s);{㤠  . ஡}

           if s[j]<>'%' then {஢ઠ  ਩}
              if s<>'' then {஢ઠ   ப}
              begin
              inc(Status);
              case Status of
                   1:begin
ObjPrototypePoligon1.OPNodes:=1+trunc(GetValue(j,s,0,MaxObjPrototypesPoligonNodes,'Wrong object poligon''s nodes count!'));
                     {Add external 1 node to cycle the poligon}
                     Nodes:=1;
                     end;
                   2:With ObjPrototypePoligon1 do
                     begin
                     OPStaTexture:=trunc(GetValue(j,s,0,Patches,'Wrong starting texture number!'));
                     OPTexturePhaze:=trunc(abs(GetValue(j,s,0,Patches,'Wrong current texture number!')-OPStaTexture));
                     OPFinTexture:=trunc(GetValue(j,s,0,Patches,'Wrong final texture number!'));
                     OPScaling:=trunc(GetValue(j,s,0,100,'Wrong scaling coefficient!'));
                     OPVisibility:=trunc(GetValue(j,s,0,1,'Wrong visibility value!'));
                     end;
                   3:With ObjPrototypePoligon1 do
                     begin
                     OPStaLight:=trunc(GetValue(j,s,0,31,'Wrong starting light value!'));
                     OPLightPhaze:=trunc(abs(GetValue(j,s,0,31,'Wrong current light value!')-OPStaLight));
                     OPFinLight:=trunc(GetValue(j,s,0,31,'Wrong final light value!'));
                     end;
                   4:ObjPrototypePoligon1.OPControlFlag:=trunc(GetValue(j,s,0,255,'Wrong control flag!'));
                 5:if Nodes<ObjPrototypePoligon1.OPNodes then
                        begin
                        ObjXYZ[Nodes].X:=trunc(GetValue(j,s,0,0,''));
                        ObjXYZ[Nodes].Y:=trunc(GetValue(j,s,0,0,''));
                        ObjXYZ[Nodes].Z:=trunc(GetValue(j,s,0,0,''));
                        inc(Nodes);
                        if Nodes<ObjPrototypePoligon1.OPNodes then dec(Status)
                           else Status:=6;
                        end;
              else dec(Status);
              end;
              end;
           end;
     LoadObjPoligon:='File with car "'+ObjFileName+'" is cutted in STRUCTURE section!';
end;

{Loading all objects structure}
Function LoadObjStructure(var f:text;ObjFileName:string):string;
var Poligons:integer;
begin
     {Loading all poligons of the currently loading object}
     for Poligons:=1 to ObjPrototypeInfo1.OPPoligons do
         begin
         strg:=LoadObjPoligon(f,ObjFileName);{strg= status message}
         if strg<>'ok!' then begin LoadObjStructure:=strg;exit;end;
         end;

     {Update Objects prototype info}
     ObjPrototypeInfo1.OPXMSSize:=XMSObjectsPrototypeOffset-_XMSObjectsPrototypeOffset;

     if XMSObjectsPrototypeOffset>ObjectsVectorPrototypesBlockSize*1024 then
        _Error('Not enough extended memory to load all objects prototypes!'+
         #13#10'Set the greater value in configurating file in line'+
         #13#10'"ObjectsVectorPrototypesBlockSize=..."');

     SaveObjPrototypeInfoToXMS(ObjPrototypeInfo1,_XMSObjectsPrototypeOffset);
     LoadObjStructure:='ok!';
end;


{Loading Object from external file with name to XMSObjectsPrototypes handle}
{Changes: XMSObjOffset - the global offset in XMSObjectsPrototypes handle}
Function LoadObj(ObjFileName:string):string;
var s:string;
    f:text;
begin
     InterpretatesFile:=ObjFileName;
     InterpretatesLine:=0;
     s:=Fsearch(ObjFileName,getenv('path'));
     if s='' then begin LoadObj:='File with object named "'+ObjFileName+'" not found!';exit;end
     else
     begin
     _XMSObjectsPrototypeOffset:=XMSObjectsPrototypeOffset;
     assign(f,s);reset(f);
     while not eof(f) do
           begin
           inc(InterpretatesLine);
           readln(f,s);
           s:=LowerCase(s);
           j:=1;
           s:=DelEmptySlotsInStr(s);{Skiping empty space}

           {Get first char: '%'=Comments, '!'=Description of block}
           if s[j]='!' then
              begin

              if copy(s,j,12)=LowerCase('!ObjectsInfo') then
                 begin
                 strg:=LoadObjInfo(f,ObjFileName);
                 if strg<>'ok!' then begin LoadObj:=strg;exit;end;
                 end;

              if copy(s,j,17)=LowerCase('!ObjectsStructure') then
                 begin
                 strg:=LoadObjStructure(f,ObjFileName);;
                 if strg<>'ok!' then begin LoadObj:=strg;exit;end;
                 end;

              end;
           end;
     close(f);
     end;
     LoadObj:='ok!';
end;

{============================LOAD Neccessary=================================}
Procedure LoadNeccessaryPrototypes;
begin
     msg_(3,8,0,'Load up neccessary prototypes...');

     XMSObjectsPrototypeOffset:=0;

     XMSBangOffset:=XMSObjectsPrototypeOffset;
     if LoadObj('Bang.dtr')<>'ok!' then _Error('"Bang.dtr" not found...');

     XMSSupBangOffset:=XMSObjectsPrototypeOffset;
     if LoadObj('SupBang.dtr')<>'ok!' then _Error('"SupBang.dtr" not found...');

     XMSSmogOffset:=XMSObjectsPrototypeOffset;
     if LoadObj('Smog.dtr')<>'ok!' then _Error('"Smog.dtr" not found...');

     XMSMineOffset:=XMSObjectsPrototypeOffset;
     if LoadObj('Mine.dtr')<>'ok!' then _Error('"Mine.dtr" not found...');

     XMSRocketOffset:=XMSObjectsPrototypeOffset;
     if LoadObj('Rocket.dtr')<>'ok!' then _Error('"Rocket.dtr" not found...');

end;



{============================LOAD Track file=================================}

{ ப "s"  ࠬ{}
Function ReadAndDecomposeTrackDataLine(var f:text;var X3,Y3,Z3,R3:longint;var T31,T32,T33:word;var M:double;
                                                      var L31,L32,L33:byte;var F3:double):string;
var j:byte;
    s:string;
begin
     while not eof(f) do
           begin
           inc(InterpretatesLine);
           readln(f,s);s:=Lowercase(s);
           s:=DelEmptySlotsInStr(s);{㤠  . ஡}
           if copy(s,1,4)='!end' then begin ReadAndDecomposeTrackDataLine:='!end';exit;end;
           j:=1;
           if s[j]<>'%' then {஢ઠ  ਩}
              if s<>'' then {஢ઠ   ப}
              begin
              X3:=trunc(GetValue(j,s,0,0,''));
              Y3:=trunc(GetValue(j,s,0,0,''));
              Z3:=trunc(GetValue(j,s,0,0,''));

              R3:=trunc(GetValue(j,s,0,900,'Wrong road width!'));

              T31:=trunc(GetValue(j,s,0,Patches,'Wrong starting texture number!'));
              T32:=trunc(GetValue(j,s,0,Patches,'Wrong current texture number!'));
              T33:=trunc(GetValue(j,s,0,Patches,'Wrong final texture number!'));
              {Make rigth animate sequence}
              if not (((T32>=T31)and(T32<=T33))or((T32>=T33)and(T32<=T31))) then T32:=T31;

              M:=GetValue(j,s,0,10,'Wrong road texture scaling coefficient!');

              L31:=trunc(GetValue(j,s,0,31,'Wrong starting light value!'));
              L32:=trunc(GetValue(j,s,0,31,'Wrong current light value!'));
              L33:=trunc(GetValue(j,s,0,31,'Wrong final light value!'));

              {Make rigth Light sequence}
              if not (((L32>=L31)and(L32<=L33))or((L32>=L33)and(L32<=L31))) then L32:=L31;

              F3:=GetValue(j,s,0,1,'Wrong road plato''s friction coefficient!');
              ReadAndDecomposeTrackDataLine:='!ok';
              exit;
              end;
           end;
     ReadAndDecomposeTrackDataLine:='!eof';
end;

{㧪  䠩 "f' (*.TRK)    ண  ନ஢ ᠬ
, 뢠 ⭮    }
Procedure LoadAndCreatRoad(var f:text);
LAbel ReadAfter;
var s:string;
    XMSOffset,j:longint;
    RFlag:byte;
    Flats:longint;
    X0,Y0,Z0:longint;
    X3,Y3,Z3,R3,X2,Y2,Z2,R2,X1,Y1,Z1,R1,_X3,_Y3,_Z3,_R3,_X2,_Y2,_Z2,_R2:longint;
    T31,T32,T33,T21,T22,T23,T11,T12,T13,_T31,_T32,_T33,_T21,_T22,_T23:word;
    M3,M2,M1,_M3,_M2:double;
    L31,L32,L33,L21,L22,L23,L11,L12,L13,_L31,_L32,_L33,_L21,_L22,_L23:byte;
    F3,F2,F1,_F3,_F2:double;
    dx,dy,dz:double;
    x,y,a2,b2,c,d,k,l:double;
    RELength:double;
begin
     msg_(6,8,0,'Building track road');
     {Read first push info}
     if ReadAndDecomposeTrackDataLine(f,X3,Y3,Z3,R3,T31,T32,T33,M3,L31,L32,L33,F3)<>'!ok' then
        _Error('TRK data file read error!');
     _X3:=X3;_Y3:=Y3;_Z3:=Z3;
     _R3:=R3;
     _T31:=T31;_T32:=T32;_T33:=T33;_M3:=M3;
     _L31:=L31;_L32:=L32;_L33:=L33;
     _F3:=F3;{Push this info}

     {Read second push info}
     if ReadAndDecomposeTrackDataLine(f,X2,Y2,Z2,R2,T21,T22,T23,M2,L21,L22,L23,F2)<>'!ok' then
        _Error('TRK data file read error!');
     _X2:=X2;_Y2:=Y2;_Z2:=Z2;
     _R2:=R2;
     _T21:=T21;_T22:=T22;_T23:=T23;_M2:=M2;
     _L21:=L21;_L22:=L22;_L23:=L23;
     _F2:=F2;{Push this info}

     RoadFlats:=0;{Counter of road flats}
     RFlag:=0;{Reading flag}
     Distance:=0;
{|}  while RFlag<3 do
           begin
           {!!!READING INFO!!!}
           if RFlag=0 then{Read from file}
              begin
              s:=ReadAndDecomposeTrackDataLine(f,X1,Y1,Z1,R1,T11,T12,T13,M1,L11,L12,L13,F1);
              if X1=0 then if Y1=500 then if Z1=0 then
                 i:=i;
              if s='!eof' then _Error('TRK data file read error!');
              if s='!end' then inc(RFlag);
              end;
           if RFlag=2 then{Read one more info from pushed}
              begin
              X1:=_X2;Y1:=_Y2;Z1:=_Z2;
              R1:=_R2;
              T11:=_T21;T12:=_T22;T13:=_T23;M1:=_M2;
              L11:=_L21;L12:=_L22;L13:=_L23;
              F1:=_F2;
              inc(RFlag);
              end;
           if RFlag=1 then{Read info from pushed}
              begin
              X1:=_X3;Y1:=_Y3;Z1:=_Z3;
              R1:=_R3;
              T11:=_T31;T12:=_T32;T13:=_T33;M1:=_M3;
              L11:=_L31;L12:=_L32;L13:=_L33;
              F1:=_F3;
              inc(RFlag);
              end;

           {!!!ACTION BODY OF THIS LOOP!!!}

           {஢ઠ   㧫    㣠}
           if (X2=X1)and(Y2=Y1) then _Error('Can not creat this track! Error number 1.');

{          ᫥    }
           dx:=x1-x2;dy:=y1-y2;
           c:=sqrt(dx*dx+dy*dy);
           RoadFlat1.a1:=dx/c;RoadFlat1.b1:=dy/c;

           dx:=x2-x3;dy:=y2-y3;
           d:=sqrt(dx*dx+dy*dy);
           a2:=dx/d;b2:=dy/d;

{           ஢ઠ 祭 室     ࠢ쭮{}
           if (Z3<>Z2)and(Z2<>Z1)and(a2<>RoadFlat1.a1)and(b2<>RoadFlat1.b1) then
              _Error('Can not creat this track! Error number 2.');

{*}        if Z3<>Z2 then {  ஢  ண!}
              begin
              RoadFlat1.X[1]:=trunc(X2+b2*R2);RoadFlat1.Y[1]:=trunc(Y2-a2*R2);RoadFlat1.Z[1]:=Z2;
              RoadFlat1.X[2]:=trunc(X2-b2*R2);RoadFlat1.Y[2]:=trunc(Y2+a2*R2);RoadFlat1.Z[2]:=Z2;
              {塞 3 設 ,  ᫥饣 ᥭ "lll"}
              RoadFlat1.X[3]:=trunc(X2-b2*R1);RoadFlat1.Y[3]:=trunc(Y2+a2*R1);

              With RoadFlat1 do
                   begin
                   dx:=X2-X3;dy:=Y2-Y3;dz:=Z2-Z3;
                   l:=sqrt(dx*dx+dy*dy+dz*dz);
                   v11:=dx/l;v12:=dy/l;v13:=dz/l;
                   v21:=-v12;v22:=v11;v23:=0;
                   normal(v11,v12,v13,v21,v22,v23,v31,v32,v33);
                   normal(v31,v32,v33,v11,v12,v13,v21,v22,v23);{}
                   end;
{*}           end
{**}       else           {  ⪠ ண}
           begin
           dx:=x1-x3;dy:=y1-y3;
           k:=(a2*dx+b2*dy-d);
           if k<>0 then k:=(a2*dy-b2*dx)/k;
           if k=0 then x:=d
                  else x:=d+(R2*sqrt(k*k+1)-R2)/k;
           y:=-R2;
           RoadFlat1.X[1]:=trunc(a2*x-b2*y+X3);RoadFlat1.Y[1]:=trunc(b2*x+a2*y+Y3);RoadFlat1.Z[1]:=Z2;
           if k<>0 then x:=d+(R2-R2*sqrt(k*k+1))/k
                   else x:=d;
           y:=R2;
           RoadFlat1.X[2]:=trunc(a2*x-b2*y+X3);RoadFlat1.Y[2]:=trunc(b2*x+a2*y+Y3);RoadFlat1.Z[2]:=Z2;
           With RoadFlat1 do
                begin
                v11:=a2;v12:=b2;v13:=0;
                v21:=-b2;v22:=a2;v23:=0;
                v31:=0;v32:=0;v33:=1;
                end;
           {塞 3 設 ,  ᫥饣 ᥭ "lll"}
           if k<>0 then x:=d+(R1-R1*sqrt(k*k+1))/k
                   else x:=d;
           y:=R1;
           RoadFlat1.X[3]:=trunc(a2*x-b2*y+X3);RoadFlat1.Y[3]:=trunc(b2*x+a2*y+Y3);
{**}       end;

           {࠭ 饩    ⪮ ண}
           With RoadFlat1 do
                begin
                Xm1:=x2;Ym1:=y2;
                Xm2:=x3;Ym2:=y3;
                a1:=a2;b1:=b2;
                RWidth:=R2;
                RWidth1:=R3;
                RLength:=d;
                RStaTexture:=T31;
                RCurTexture:=T32;
                RFinTexture:=T33;
                RScaling:=M3;
                RStaLight:=L31;
                RCurLight:=L32;
                RFinLight:=L33;
                RFriction:=F3;
                RDistanceFromStart:=Distance;
                Distance:=Distance+RLength;
                end;
           { ⪠ ண   (300 byte)}
           SaveRoadFlatToXMS(RoadFlat1,RoadFlats);

           {Enheritances}
           X3:=X2;Y3:=Y2;Z3:=Z2;
           R3:=R2;
           T31:=T21;T32:=T22;T33:=T23;M3:=M2;
           L31:=L21;L32:=L22;L33:=L23;
           F3:=F2;

           X2:=X1;Y2:=Y1;Z2:=Z1;
           R2:=R1;
           T21:=T11;T22:=T12;T23:=T13;M2:=M1;
           L21:=L11;L22:=L12;L23:=L13;
           F2:=F1;

           inc(RoadFlats);
           if RoadFlats>MaxRoadSegments then
              _Error('Number of Road Segments in this track is more than '+itos(MaxRoadSegments)+' !'+
               #13#10'Change the value in configurationg file in line "MaxRoadSegments=..."');
{|}        end;

           dec(RoadFlats);{쭮 - ᠭ  ண}

{HERE!}
     _Distance:=EvaluateTheWholeTrackDistance(RoadFlats);
     if abs(Distance-_Distance)>0.01 then _Error('LoadAndCreatRoad: Wrong evaluated track distance!');

     {⥫쭮 ନ஢   ண ( 窠 3D)}
     {+ ᫥ 祭 ६ "lll"}
     XMSOffset:=0;{}
     {뢠    RoadFlat1}
     LoadRoadFlatFromXMS(RoadFlat1,0);
     for j:=1 to RoadFlats do
         begin
         With RoadFlat1 do { न}
              begin
              X0:=X[1];Y0:=Y[1];Z0:=Z[1];
              X3:=X[2];Y3:=Y[2];Z3:=Z[2];
              if j=1 then begin _X3:=X[3];_Y3:=Y[3];end;
              end;
         LoadRoadFlatFromXMS(RoadFlat1,j);
         With RoadFlat1 do{९뢠  न ।. }
              begin
              {塞 "lll"}
              dx:=X[2]-_X3;dy:=Y[2]-_Y3;
              lll:=sqrt(dx*dx+dy*dy);
              _X3:=X[3];_Y3:=Y[3];
              {९뢠 न}
              X[0]:=X0;Y[0]:=Y0;Z[0]:=Z0;
              X[3]:=X3;Y[3]:=Y3;Z[3]:=Z3;
              X[4]:=X0;Y[4]:=Y0;Z[4]:=Z0;
              end;
         { ⥫쭮 १  }
         SaveRoadFlatToXMS(RoadFlat1,j);
         end;

     {  ⮪ ண ନ㥬 }
     With RoadFlat1 do{ न ᫥ }
          begin
          X0:=X[1];Y0:=Y[1];Z0:=Z[1];
          X3:=X[2];Y3:=Y[2];Z3:=Z[2];
          end;
     {뢠 ࢮ }
     LoadRoadFlatFromXMS(RoadFlat1,0);
     With RoadFlat1 do{뢠  न  }
          begin
          {塞 "lll"}
          dx:=X[2]-_X3;dy:=Y[2]-_Y3;
          lll:=sqrt(dx*dx+dy*dy);
          {९뢠 न}
          X[0]:=X0;Y[0]:=Y0;Z[0]:=Z0;
          X[3]:=X3;Y[3]:=Y3;Z[3]:=Z3;
          X[4]:=X0;Y[4]:=Y0;Z[4]:=Z0;
          end;
     {頥   ࢮ ⥫쭮 ନ஢ }
     SaveRoadFlatToXMS(RoadFlat1,0);
end;

{==================LOADING TRACK OBJECTS=====================================}

{㦠  ନ  ꥪ⮢,    ண}
Procedure Transform2dTo3d(CPlatoOfs,CDev:double;var Xr,Yr,Zr:double);forward;
Procedure DirectTheObjAlongTheTrack; forward;

Function LoadTrackObjects(var f:text):string;
Label EndOfLoop;
var
   s:string;
   Obj:word;
   j,rslt:byte;
   XMSOPOffset:longint;
   _CPlato:longint;
   _CPlatoOfs,_CDev,_Z:double;
   _TTL:word;
   _Id:byte;
   dx,dy,dz:double;{}
   iline:longint;
   ifile:string[8];

begin
     FoundamentalObject:=false;
     FoundamentalObjectNumber:=65535;
     msg_(6,8,0,'Standing track objects');
     Objects:=0;
     Cars:=0;
     while not eof(f) do
           begin
           inc(InterpretatesLine);
           readln(f,s);s:=Lowercase(s);
           s:=DelEmptySlotsInStr(s);{㤠  . ஡}

           if copy(s,1,10)='!startcars' then
              begin
              if Cars=0 then begin inc(Cars);inc(_CarNumber);end;
              goto EndOfLoop;
              end;

           if copy(s,1,4)='!end' then begin
           LoadTrackObjects:='ok!';dec(Cars);CarsOfs:=Objects-Cars+1;exit;end;

           j:=1;
           if s[j]<>'%' then
              if s<>'' then {஢ઠ   ப & ਩}

              if copy(s,1,5)='name=' then {if follows file name of the object}
{->}             begin
                 delete(s,1,5);

                 {Find it in list. To detect: loaded or not (rslt=1 or 0)}
                 rslt:=0;
                 For Obj:=1 to Objects do
                     begin
                     LoadObjFromXMS(Obj1,Obj);
                     LoadObjPrototypeInfoFromXMS(ObjPrototypeInfo1,Obj1.CXMSPrototypeOffset);

                     if ObjPrototypeInfo1.OPName=s then
                        begin rslt:=1;XMSOPOffset:=Obj1.CXMSPrototypeOffset;break;end;
                     end;

                 if rslt=0 then
                    begin
                    iline:=InterpretatesLine;
                    ifile:=InterpretatesFile;
                    if s[length(s)-3]<>'.' then s:=s+'.dtr';
                    s:=LoadObj(s);{Load objects prototype from external file}
                    if s<>'ok!' then _Error(s);
                    InterpretatesLine:=iline;
                    InterpretatesFile:=ifile;
                    end;

{->}             end

                 else

                 begin {other case - objects info in "s"}
                 if copy(s,1,12)='foundamental' then FoundamentalObject:=true;

                 _CPlato:=trunc(GetValue(j,s,0,65535,'Wrong plato''s number!'));
                 _CPlatoOfs:=GetValue(j,s,0,0,'Wrong plato''s offset!');
                 _CDev:=GetValue(j,s,0,0,'Wrong platoe''s Deviation!');
                 _Z:=GetValue(j,s,0,0,'Objects height is wrong');
                 _TTL:=trunc(GetValue(j,s,0,65535,'Wrong TTL'));
                 _Id:=trunc(GetValue(j,s,0,255,'Wrong identification'));

                 {Creating the object}
                 if rslt=0 then XMSOPOffset:=_XMSObjectsPrototypeOffset;

                 CreatObj(_Id,
                  _CPlato,_CPlatoOfs,_CDev,_Z,
                  100,100,
                  SimpleEngine,
                  0,0,{_CCurrentSpeed,_CStep}
                  0,0,
                  0,0,
                  200,
                  XMSOPOffset,
                  _TTL,
                  Objects+1,{Owner=self, counts from 1,2,3...}
                  0,{ReloadCounter=0, put 255 for start in game!!!}
                  Obj1,
                  false,
                  true);

                 if FoundamentalObject then
{~~~}               begin
                    Obj1.X:=_CPlatoOfs;
                    Obj1.Y:=_CDev;
                    Obj1.Z:=_Z;
                    Obj1.CId:=2;
                    if _CPlato=65535 then FoundamentalObjectNumber:=Objects;
                    end
                 else
{~~~}            begin

                 {Set some params of new created}

                 {Standing it on track}
                 LoadRoadFlatFromXMS(RoadFlat1,_CPlato);
                 Transform2dTo3d(_CPlatoOfs,_CDev,Obj1.X,Obj1.Y,Obj1.Z);

                 {Directing its Vector System along the track}
                 DirectTheObjAlongTheTrack;
                 Obj1.Z:=Obj1.Z+_Z+Obj1.v33*(Obj1.CHeight);

                 LoadRoadFlatFromXMS(RoadFlat1,Obj1.CPlato);{}
                 With RoadFlat1 do
                      begin
                      dx:=Obj1.X-X[0];
                      dy:=Obj1.Y-Y[0];
                      dz:=Obj1.Z-Z[0];
                      Obj1.Zt:=v31*dx+v32*dy+v33*dz;
                      end;{}
{~~~}            end;

                 {Finaly save it back}
                 SaveObjToXMS(Obj1,Objects);
                 FoundamentalObject:=false;

                 if Cars>0 then begin inc(Cars);inc(_CarNumber);end;{Cars counter, activates after "!StartCars" string}

{->}             end;
EndOfLoop:
           end;
     LoadTrackObjects:='File is cutted in Objects Section!';
end;


{㦠 䠩   ண 㤥 ᮧ }
Procedure LoadTrack(TrackName:string);
var f:text;
    s:string;
    Status:byte;
begin
     if TrackName[Length(TrackName)-3]<>'.' then TrackName:=TrackName+'.trk';
     msg_(3,8,0,'Loading track named "'+TrackName+'"');
     InterpretatesFile:=TrackName;
     InterpretatesLine:=0;
     TrackName:=fsearch(TrackName,getenv('path'));
     if TrackName='' then _Error('Such track was not found!');

     msg_(3,8,0,'Loading track data...');
     Status:=0;
     assign(f,TrackName);
     reset(f);
     while not eof(f) do
           begin
           inc(InterpretatesLine);
           readln(f,s);
           s:=LowerCase(s);
           j:=1;
           s:=DelEmptySlotsInStr(s);{Skiping empty space}
           {Get first char: '%'=Comments, '!'=Description of block}
           if s[j]='!' then
              begin
              if (copy(s,j,11)=LowerCase('!StartTrack'))and(Status=0) then
                 begin LoadAndCreatRoad(f);Status:=1;reset(f);end;
              if (copy(s,j,13)=LowerCase('!StartObjects'))and(Status=1) then
                 begin LoadTrackObjects(f);Status:=2;reset(f);end;
              end;
           end;
      close(f);
      if Status<2 then _Error('LoadTrack: Track "'+TrackName+'" was not loaded completely!');
end;



{=====================Show up Unit===========================================}

{ This draws a line from a,b to c,d of color col. }
{HERE! This proc does not belongs to project at the end!}
Procedure line(a,b,c,d:integer;col:byte);
var u,s,v,d1x,d1y,d2x,d2y,m,n:double;
    i:integer;
BEGIN
     u:= c - a;
     v:= d - b;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := INT(m / 2);
     FOR i := 0 TO round(m) DO
     BEGIN
          vp^[a+(b*320)]:=Col;
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               a:= a +round(d1x);
               b := b + round(d1y);
          END
          ELSE
          BEGIN
               a := a + round(d2x);
               b := b + round(d2y);
          END;
     END;
END;

{HERE! This proc does not belongs to project at the end!}
Procedure pr40(var x3,y3,x4,y4:longint;x,y:longint;var q:byte);
begin
if q=0 then begin x3:=x;y3:=y;q:=1;end
       else begin x4:=x;y4:=y;q:=2;end;
end;
{楤 ᮢ  ࠭ , ᥪ 室騥  ࠭ }
{HERE! This proc does not belongs to project at the end!}
Procedure ClipLine(x1,y1,x2,y2:longint;col:byte);
label DrawClipLine;
var k5:real;
    x,y,x3,y3,x4,y4,dx,dy:longint;
    q:byte;
begin
     q:=0;
     if x1>=lb then
        if x1<=rb then
           if y1>=ub then
              if y1<=db then pr40(x3,y3,x4,y4,x1,y1,q);
     if x2>=lb then
        if x2<=rb then
           if y2>=ub then
              if y2<=db then begin
                             pr40(x3,y3,x4,y4,x2,y2,q);
                             if q>1 then goto DrawClipLine;
                             end;

     dx:=x1-x2;dy:=y1-y2;
     if dy<>0 then begin
                   k5:=dx/dy;
                   x:=trunc(x1-y1*k5);y:=0;
                   if y1*y2<0 then
                      if x>=lb then
                         if x<=rb then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   x:=trunc(x1-(y1-db)*k5);y:=db;
                   if (y1-db)*(y2-db)<0 then
                      if x>=lb then
                         if x<=rb then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   end;
     if dx<>0 then begin
                   k5:=dy/dx;
                   y:=trunc(y1-x1*k5);x:=0;
                   if x1*x2<0 then
                      if y>=ub then
                         if y<=db then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   y:=trunc(y1-(x1-rb)*k5);x:=rb;
                   if (x1-rb)*(x2-rb)<0 then
                      if y>=ub then
                         if y<=db then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   end;
exit;{Because The Line is out of screen}

DrawClipLine:
     Line(x3,y3,x4,y4,col);
end;


{Find 2d poligon proection to screen, after build image.
In: ObjXYZ global array of points 3d , Number of nodes of 3d poligon.
Out:  true, if Lbd and Rbd arrays were filled or false if clipped}
Function BuildPoligonImage(Nodes3D:word;VisibilityCheck:boolean):boolean;
var
    i,l:integer;
    a,b,c,d,a1,b1,c1,ddx,ddy,ddz:double;
    f,f1:integer;
var
    x,StepX,q,x1,y1,x2,y2,dx,dy,y,yn,xl,sx,e:longint;
    flag:boolean;

{Detects poligons boundaries [(PMinX,PMinY) - (PMaxX,PMaxY)]}
Procedure Check2dLimits(x,y:longint);
begin
     if PMaxX<x then PMaxX:=x;
     if PMinX>x then PMinX:=x;
     if MaxY<y then MaxY:=y;
     if MinY>y then MinY:=y;
end;

begin
         PMaxX:=-Maxlongint;PMinX:=MaxLongint;
         MaxY:=-MaxLongint;MinY:=MaxLongint;
         l:=0;f1:=0;
         for i:=1 to Nodes3D do     {  ᥬ 窠  }
             begin
{^}          With Camera do
             begin
             ddx:=X-ObjXYZ[i].X;ddy:=Y-ObjXYZ[i].Y;ddz:=Z-ObjXYZ[i].Z;
             a:=v11*ddx+v12*ddy+v13*ddz;
             b:=v21*ddx+v22*ddy+v23*ddz;
             c:=v31*ddx+v32*ddy+v33*ddz;{}
{^}          end;
             f:=sgn(b-k4);
             if not((f<0)and(f1<=0)) then
                begin
{-----஢ઠ  祭  ⥭ 㠫쭮 ᪮}
                if f1*f<0 then
                   begin
                   a1:=a1-(b1-k4)*(a1-a)/(b1-b);
                   c1:=c1+(b1-k4)*(c-c1)/(b1-b);
                   inc(l);
                   o[l]:=longint(160-trunc(r*a1/k4));
                   p[l]:=longint(100+trunc(r*c1/k4));
                   Check2dLimits(o[l],p[l]);
                   if f1<=0 then
                      begin
                      inc(l);
                      o[l]:=longint(160-trunc(r*a/b));
                      p[l]:=longint(100+trunc(r*c/b));
                      Check2dLimits(o[l],p[l]);
                      end
                   end
                   else
                   begin
                   inc(l);
                   o[l]:=longint(160-trunc(r*a/b));
                   p[l]:=longint(100+trunc(r*c/b));
                   Check2dLimits(o[l],p[l]);
                   end;
                end;
             f1:=f;a1:=a;b1:=b;c1:=c;
             end;
    if o[l]-o[1]+p[l]-p[1]<>0 then
       begin inc(l);o[l]:=o[1];p[l]:=p[1];end;

{Check on 2d image clipping}
    if (PMaxX<Lb)or(PMinX>=Rb)or(MaxY<MUb)or(MinY>=MDb)or(L<3) then
       begin BuildPoligonImage:=false;exit;end;

{Check on perspective visibility}
    if VisibilityCheck then
       if longint((o[l-3]-o[l-2])*(p[l-1]-p[l-2])-(o[l-1]-o[l-2])*(p[l-3]-p[l-2]))<=0 then
          begin BuildPoligonImage:=false;exit;end;

{Build image}
    for i:=Mub to Mdb do begin Lbd[i]:=MRbd[i];rbd[i]:=MLbd[i];end;{set Clipping window}
    MinY:=MDb;MaxY:=Mub;

    for i:=1 to L-1 do
        begin
        x1:=o[i];y1:=p[i];x2:=o[i+1];y2:=p[i+1];

        if y1=y2 then continue;{Skipping Horizontal lines}

        if y2<y1 then begin q:=x1;x1:=x2;x2:=q;q:=y1;y1:=y2;y2:=q;end;{Must be Y1<=Y2 always}

        dy:=y2-y1;{always dy>0!}
        dx:=x2-x1;
        if dx>0 then sx:=1
                else sx:=-1;

        if y1<Mub then
           begin
{           x:=x1+trunc(1/dy*(Mub-y1)*dx);{}
           x:=x2-trunc(1/dy*y2*dx);
{           if Mub-y1<y2 then x:=x1+trunc(1/dy*(Mub-y1)*dx)
                        else x:=x2-trunc(1/dy*y2*dx);{}
           yn:=Mub;
           end {Clip Up poligon edge}

                  else begin x:=x1;yn:=y1;end;
        if y2>Mdb then y2:=Mdb; {Clip Down poligon edge}

        dx:=abs(dx);
        if dx>dy then begin StepX:=dx div dy;dx:=dx-StepX*dy;end
                 else StepX:=0;
        if sx<0 then begin StepX:=-StepX;end;


        if MinY>yn then MinY:=yn;
        if MaxY<y2 then MaxY:=y2;

        e:=0;
{------}for y:=yn to y2 do
            begin
            if x>MLbd[y] then
               begin
               Xl:=x;
               if Xl<MLbd[y] then Xl:=MLbd[y];
               if Xl>MRbd[y] then Xl:=MRbd[y];
               if lbd[y]>xl then lbd[y]:=xl;
               if rbd[y]<xl then rbd[y]:=xl;
               end
            else lbd[y]:=MLbd[y];

            x:=x+StepX;
            e:=e+dx;if e>=dy then begin x:=x+sx;e:=e-dy;end;
{------}    end;

        end;

     if MinY<Mub then MinY:=Mub;
     if MaxY>Mdb then MaxY:=Mdb;

     flag:=false;
     for y:=MinY to MaxY do
         begin
         if lbd[y]<MLbd[y] then lbd[y]:=MLbd[y];
         if rbd[y]>MRbd[y] then rbd[y]:=MRbd[y]; {}

         if Lbd[y]<>Rbd[y] then flag:=true
         else begin if flag then dec(maxY) else inc(minY);end;{}
         end;
    BuildPoligonImage:=flag;

(*
    for j:=MinY to MaxY do
        if Lbd[j]<=Rbd[j] then fillchar(vp^[j*320+Lbd[j]],Rbd[j]-Lbd[j]+1,15)
        else begin _Error('Lbd>Rbd!!!...');end;{Here!!!}
    for j:=2 to L do
        ClipLine(o[j-1],p[j-1],o[j],p[j],9);{}(**)
end;

procedure PTexturateTheLineWithoutLightness(l1,l2,l3,i1,i2,i3:double;rht,lft:longint);
{      16  }
var
  Zinv : double;
  u1, v1, u2, v2, du, dv : longint;
  {Tested}
  cx:integer;
  s2,s3:string;
begin
     if lft>=rht then exit;

     i3:=i3*16;i2:=i2*16;i1:=i1*16;
     if abs(L3)>0.01 then zinv:=128/l3 else Zinv:=1;
{---}
      if abs(L2*zinv)>2147483647 then
         begin
         str(L2,s2);str(Zinv,s3);
         _Error('Overflow! Case 1. L2='+s2+', Zinv='+s3);
         end;
      if abs(L1*zinv)>2147483647 then
         begin
         str(L1,s2);str(Zinv,s3);
         _Error('Overflow! Case 2. L1='+s2+', Zinv='+s3);
         end;
{---}

     u2:=longint(trunc(L2*zinv));v2:=longint(trunc(L1*zinv));

While Lft<=Rht do
      begin

      u1:=u2;v1:=v2;
      L1:=L1+I1;L2:=L2+I2;L3:=L3+I3;
      if abs(L3)>0.01 then zinv:=128/l3 else Zinv:=1;
{---}
      if abs(L2*zinv)>2147483647 then
         begin
         str(L2,s2);str(Zinv,s3);
         _Error('Overflow! Case 3. L2='+s2+', Zinv='+s3);
         end;
      if abs(L1*zinv)>2147483647 then
         begin
         str(L1,s2);str(Zinv,s3);
         _Error('Overflow! Case 4. L1='+s2+', Zinv='+s3);
         end;
{---}
      u2:=longint(trunc(L2*zinv));v2:=longint(trunc(L1*zinv));
      du:=(u2-u1) shr 4;dv:=(v2-v1) shr 4;

{      cx:=rht-lft+1;
      if cx>16 then cx:=16;
      while cx>0 do
            begin
            if vp^[Lft]=0 then
               begin
               vp^[Lft]:=Tx^[u1 and $3f80+v1 shr 7 and $7f];
               end;
            u1:=u1+du;v1:=v1+dv;
            inc(Lft);
            dec(cx);
            end;
{}
{----------------------------------------------}
{Lft:=Rht+1;{}

asm
    push  ds
    les   di, vp
    mov   di, word ptr lft
    lds   si,Tx
    mov   cx, word ptr rht
    sub   cx, word ptr lft
    inc   cx                                    {CX = Rht - Lft}
    cmp   cx,16
    jl    @@CX_isLowerThan17
    mov   cx,16
@@CX_isLowerThan17:                             {if cx>16 then cx=16}
    cld
    {db $66;} mov ax, word ptr u1
    {db $66;} mov bx, word ptr v1

@@cycle:
    cmp   byte ptr es:[di],0
    je    @@CanPutPixelHere
    inc   di                         {Video position was busy by other pixel}
    {db $66;} add ax, word ptr du
    {db $66;} add bx, word ptr dv
    loop  @@cycle
    jmp   @@OutOfLoop

@@CanPutPixelHere:
    mov   si, ax
    and   si, $3f80
    mov   dx, bx
    shr   dx, 7
    and   dx, $7f
    add   si, dx
    movsb

    {db $66;} add ax, word ptr du
    {db $66;} add bx, word ptr dv
    loop  @@cycle

@@OutOfLoop:

    mov   word ptr Lft, di
    pop   ds
end;
(**)
{----------------------------------------------}
     end;
end;


Procedure Z_Buffer(l1,l2,l3,l4,i1,i2,i3,i4:double;rht,lft:longint;ZOfs:word;var ZBf:ZBuf;Light:byte);
var
  Zinv : double;
  l, u1, v1, w1, u2, v2, w2, du, dv ,dw: longint;
  Texel,Texel1:byte;
  cx:word;
CONST
     NOPFI:longint=16;
     NOPFIbits:byte=4;
begin
     if lft>=rht then exit;

     i4:=i4*NOPFI;i3:=i3*NOPFI;i2:=i2*NOPFI;i1:=i1*NOPFI;
     if abs(L3)>0.01 then zinv:=512/l3 else Zinv:=1;{}
     u2:=longint(trunc(L2*zinv));
     v2:=longint(trunc(L1*zinv));
     w2:=longint(trunc(L4*zinv));

While Lft<=Rht do
      begin

      u1:=u2;v1:=v2;w1:=w2;
      L1:=L1+I1;L2:=L2+I2;L3:=L3+I3;L4:=L4+I4;
      if abs(L3)>0.01 then zinv:=512/l3 else Zinv:=1;
      u2:=longint(trunc(L2*zinv));
      v2:=longint(trunc(L1*zinv));
      w2:=longint(trunc(L4*zinv));
      du:=(u2-u1) shr NOPFIBits;
      dv:=(v2-v1) shr NOPFIBits;
      if w2>w1 then dw:=(w2-w1) shr NOPFIBits else dw:=-((w1-w2) shr NOPFIBits);
      cx:=rht-lft+1;
      if cx>NOPFI then cx:=NOPFI;

      while cx>0 do
            begin
            l:=w1;
            if ZBf^[Zofs] and $7fffff>l then{}
               begin
               Texel:=Tx^[u1 and $fe00 shr 2+v1 shr 9 and $7f];
               if Texel>0 then{}
                  begin
                  ZBf^[ZOfs]:=l;
{                  l:=Light+l shr 11;if l>15 then l:=15{};
                  vp^[Lft]:=LT^[light shl 8+Texel];
                  end;
               end;
            u1:=u1+du;v1:=v1+dv;w1:=w1+dw;
            inc(Lft);inc(ZOfs);
            dec(cx);
            end;
(**)

     end;
end;


Procedure IDTline16(EpsL3:double;Lft,Rht,ZOfs,CurLiteGrad:word;Vp,Tx,Zb,Tl:pointer;l1,l2,l3,l4,i1,i2,i3:double);
far;external;
{$L RIDTLine.obj}

{Texturating the poligon}
{Requires MaxY,MinY,Rbd,Lbd}
procedure TexturatePoligon(X0,Y0,Z0,a1,b1,g1,a2,b2,g2,a3,b3,g3:double;XMSOffset:longint;Scaling:double;Light:word);
var
   vv1,vv2,vv3,m1,m2,m3:double;
   rr,rht,lft,ZOfs,ZIndex:longint;
   k1,k2:integer;
   fg:byte;
   vp_ofs:word;
   l1,l2,l3,l4,i1,i2,i3,i4:double;
   dx,dy,dz,w1,w2,w3,w,_w1,_w2,_w3:double;
   LiteOfs:word;
begin
     LiteOfs:=Ofs(Lt^)+Light*256;

     w1:=a1*b2-a2*b1;w2:=b1*g2-b2*g1;w3:=a1*g2-a2*g1;
     w1:=w1*Scaling;w2:=w2*Scaling;w3:=w3*Scaling;{}

     _w1:=abs(w1);_w2:=abs(w2);_w3:=abs(w3);

     dx:=Camera.X-X0;dy:=Camera.Y-Y0;dz:=Camera.Z-Z0;

     vv3:=dy*w3-dz*w1-dx*w2;
     if vv3=0 then _Error('Oh fuck! VV3 became about zero...');

if (_w1>=_w2)and(_w1>=_w3) then begin vv1:=(dx*b2-dy*a2)/w1;vv2:=(dy*a1-dx*b1)/w1;fg:=0;end;
if (_w2>=_w1)and(_w2>=_w3) then begin vv1:=(dy*g2-dz*b2)/w2;vv2:=(dz*b1-dy*g1)/w2;fg:=1;end;
if (_w3>=_w1)and(_w3>=_w2) then begin vv1:=(dx*g2-dz*a2)/w3;vv2:=(dz*a1-dx*g1)/w3;fg:=2;end;

vp_ofs:=maxy*320;

{Uploading texture to Tx^ buffer}
xms_move(MRec,XMSTextures,word(XMSOffset and 65535),word(XMSOffset shr 16){},
         0,ofs(Tx^),seg(Tx^),
         PatchSize);
{ShowTx;{}

k2:=ScreenY-maxy;
while k2<=ScreenY-miny do
    begin
    rr:=longint(lbd[-k2+ScreenY]-ScreenX);
    with Camera do
    begin
    m1:=v11*rr-v21*r+v31*k2;
    m2:=v12*rr-v22*r+v32*k2;
    m3:=v13*rr-v23*r+v33*k2;

    lft:=vp_ofs+lbd[-k2+ScreenY];rht:=vp_ofs+rbd[-k2+ScreenY];
    if fg=0 then
       begin
       l1:=(m1*b2-m2*a2)/w1*vv3;
       i1:=(v11*b2-v12*a2)/w1*vv3;
       l2:=(m2*a1-m1*b1)/w1*vv3;
       i2:=(v12*a1-v11*b1)/w1*vv3;
       end
    else if fg=1 then
            begin
            l1:=(m2*g2-m3*b2)/w2*vv3;
            i1:=(v12*g2-v13*b2)/w2*vv3;
            l2:=(m3*b1-m2*g1)/w2*vv3;
            i2:=(v13*b1-v12*g1)/w2*vv3;
            end
         else if fg=2 then
                 begin
                 l1:=(m1*g2-m3*a2)/w3*vv3;
                 i1:=(v11*g2-v13*a2)/w3*vv3;
                 l2:=(m3*a1-m1*g1)/w3*vv3;
                 i2:=(v13*a1-v11*g1)/w3*vv3;
                 end;
   l3:=(m1*w2-m2*w3+m3*w1);
   i3:=(v11*w2-v12*w3+v13*w1);
   l4:=vv3*R{-(v21*m1+v22*m2+v23*m3)*vv3{};
   i4:=0{-(v21*v11+v22*v12+v23*v13)*vv3{};
   l1:=vv1*l3+l1;i1:=vv1*i3+i1;
   l2:=vv2*l3+l2;i2:=vv2*i3+i2;
   end;
   if k2<=0 then ZOfs:=(Lft-32000)
            else ZOfs:=Lft;

{Here! For statistic only!!!}
     if abs(MaxL1)<abs(L1) then MaxL1:=L1;
     if abs(MaxL2)<abs(L2) then MaxL2:=L2;
     if abs(MaxL3)<abs(L3) then MaxL3:=L3;
     if abs(MaxL4)<abs(L4) then MaxL4:=L4;
     if (_w1>=_w2)and(_w1>=_w3) then w:=_w1;
     if (_w2>=_w1)and(_w2>=_w3) then w:=_w2;
     if (_w3>=_w1)and(_w3>=_w2) then w:=_w3;
     if MinW>w then MinW:=w;
{Till Here!}


CASE TexturateMethod of
     1:PTexturateTheLineWithoutLightness(l1,l2,l3,i1,i2,i3,rht,lft);{}
     2:begin
       Zindex:=(ScreenY-k2) div 50;
       Z_Buffer(l1,l2,l3,l4,i1,i2,i3,i4,rht,lft,Lft-16000*ZIndex,ZB[Zindex],Light);
       end;
     3:begin
{Here!}
{       inc(TestCounter);
       if TestCounter=202 then Light:=202;{Here!}
       Zindex:=(ScreenY-k2) div 50;
{       _l1:=l1;_l2:=l2;_l3:=l3;_l4:=l4;
       _i1:=i1;_i2:=i2;_i3:=i3;_i4:=i4;
       _lft:=lft;_rht:=_rht;_Zindex:=Zindex;{}
       IDTLine16(EpsL3,Lft,Rht,word(Lft-ZIndex*16000),LiteOfs,{Ptr($a000,0){}Vp{},Tx,Zb[ZIndex],LT,
                 l1,l2,l3,l4,i1,i2,i3);(**)

(**)
       end;
     end;
   vp_ofs:=vp_ofs-320;
   inc(k2);
{   if TexturateMethod=0 then begin k2:=k2+1;vp_ofs:=vp_ofs-320;end;{}
   end;
end;


{Draw one object number "ObjNumber" at XMSObjects handle}
Procedure ShowObj3D(ObjNumber:word);
var
    CurTexture,XMSOffset,j:longint;
    i,k:integer;
    col,OPLight:byte;
    a,b,c:double;
    Size,OPTexture:longint;
    a1,b1,g1,a2,b2,g2,a3,b3,g3:double;
    {XYZ - for real 3D coordinates of starting point of accounting poligon}
    XYZ:ObjPrototypeDoublePoints3D;
begin
     LoadObjFromXMS(Obj1,ObjNumber);

     if Obj1.CId=255 then exit;{Not draw dead cars}

     XMSOffset:=Obj1.CXMSPrototypeOffset;
     {Load up Objects info block}
     xms_move(MRec,XMSObjectsPrototypes,XMSOffset and $ffff,XMSOffset shr 16,
              0,ofs(ObjPrototypeInfo1),seg(ObjPrototypeInfo1),256);
     inc(XMSOffset,256);

     For j:=1 to ObjPrototypeInfo1.OPPoligons do {  ᥬ poligons}
{Main}   begin
         {Load up poligon info block}
         xms_move(MRec,XMSObjectsPrototypes,XMSOffset and $ffff,XMSOffset shr 16,
              0,ofs(ObjPrototypePoligon1),seg(ObjPrototypePoligon1),100);

         inc(XMSOffset,100);

         Size:=ObjPrototypePoligon1.OPNodes*12{ToDD24};
         {Load up nodes of the poligon}
         xms_move(MRec,XMSObjectsPrototypes,XMSOffset and $ffff,XMSOffset shr 16,
              0,ofs(ObjXYZ),seg(ObjXYZ),Size);
         inc(XMSOffset,Size);

         With ObjPrototypePoligon1 do
{WOPP1}       begin

              {Evaluate real 3d objects coordinates of 3d world}
              for k:=1 to ObjPrototypePoligon1.OPNodes do     {  ᥬ 窠 }
                  With Obj1 do
                       begin
                       a:=X+v11*ObjXYZ[k].X+v21*ObjXYZ[k].Y+v31*ObjXYZ[k].Z;{}
                       b:=Y+v12*ObjXYZ[k].X+v22*ObjXYZ[k].Y+v32*ObjXYZ[k].Z;{}
                       c:=Z+v13*ObjXYZ[k].X+v23*ObjXYZ[k].Y+v33*ObjXYZ[k].Z;{}
                       if k=2 then begin XYZ.X:=a;XYZ.Y:=b;XYZ.Z:=c;end;
                       ObjXYZ[k].X:=round(a);ObjXYZ[k].Y:=round(b);ObjXYZ[k].Z:=round(c);{}
{                       ObjXYZ[k].X:=a;ObjXYZ[k].Y:=b;ObjXYZ[k].Z:=c;{ToDD24}
                       end;

              {Check poligon possible image at screen}
              if BuildPoligonImage(OPNodes,boolean(1-OPVisibility)) then
{PBI}             begin

                  {Texturate poligon}
                  With ObjPrototypePoligon1 do
{OPP1}                 begin
                       a1:=v11*Obj1.v11+v12*Obj1.v21+v13*Obj1.v31;
                       b1:=v11*Obj1.v12+v12*Obj1.v22+v13*Obj1.v32;
                       g1:=v11*Obj1.v13+v12*Obj1.v23+v13*Obj1.v33;
                       a2:=v21*Obj1.v11+v22*Obj1.v21+v23*Obj1.v31;
                       b2:=v21*Obj1.v12+v22*Obj1.v22+v23*Obj1.v32;
                       g2:=v21*Obj1.v13+v22*Obj1.v23+v23*Obj1.v33;
                       a3:=v31*Obj1.v11+v32*Obj1.v21+v33*Obj1.v31;
                       b3:=v31*Obj1.v12+v32*Obj1.v22+v33*Obj1.v32;
                       g3:=v31*Obj1.v13+v32*Obj1.v23+v33*Obj1.v33;

                       if OPStaLight=OPFinLight then OPLight:=OPStaLight
                          else{ OPLight = StaLight (+-) (CCounter+LightPhaze) mod abs(LightFrames) }
                              if OPStaLight<OPFinLight then
                                 OPLight:=OPStaLight+(Obj1.CCounter+word(OPLightPhaze)) mod (OPFinLight-OPStaLight+1)
                              else OPLight:=OPStaLight-(Obj1.CCounter+word(OPLightPhaze)) mod (OPStaLight-OPFinLight+1);

                       if OPLight<16 then
                          begin
                          OPLight:=OPLight+RoadFlat1.RCurLight;{Remembering of Road flat's light!!!}
                          if OPLight>15 then OPLight:=15;      {It doesn't influence to car's headlights}
                          end
                       else OPLight:=OPLight and $0F;{for 'allways lighted' obects Light=128+LightGradation}

                       if (ObjNumber>=CarsOfs)and(ObjNumber<CarsOfs+Cars) then
                          Case OPControlFlag of
                               1:if Obj1.CStreif<0 then OPLight:=Obj1.CHeadLightCounter;
                               2:if Obj1.CStreif>0 then OPLight:=Obj1.CHeadLightCounter;
                               3:if Obj1.CCurrentSpeed<0 then OPLight:=0 else OPLight:=5;
                               4:if Obj1.CBrakeLightSwitch=1 then OPLight:=0;
                               end;

                       if Obj1.CShield>0 then OPLight:=Obj1.CShield;

                  if OPStaTexture=OPFintexture then OPTexture:=OPStaTexture
                     else{ OPTexture = StaTexture (+-) (CCounter+TexturePhaze) mod abs(TextureFrames) }
                         if OPStaTexture<OPFintexture then
                            OPTexture:=OPStaTexture+(Obj1.CCounter+word(OPTexturePhaze)) mod (OPFinTexture-OPStaTexture+1)
                         else
                             OPTexture:=OPStaTexture-(Obj1.CCounter+word(OPTexturePhaze)) mod (OPStaTexture-OPFinTexture+1);

                  TexturatePoligon(XYZ.X,XYZ.Y,XYZ.Z,
                                   a1,b1,g1,a2,b2,g2,a3,b3,g3,
                                   ObjPrototypeInfo1.OPXMSTexturesOffset+OPTexture*longint(PatchSize),
                                   ObjPrototypePoligon1.OPScaling,
                                   OPLight);{}
{OPP1}                 end;

{BPI}             end;
{WOPP1}       end;

{Main}   end;
end;

{Draw all Objects, which belongs to Current Plato, following their Plato offsets}
Procedure DrawAllObjectsOnCurrentPlato(CurPlato:longint);
Const
     TooFar:double=1000000;
var Obj,ObjNum:word;
    XMSOffset,CPlato:longint;
    CPlatoOfs,q:double;
    {Udalennosti objectov}
    CL:array[1..MaxObjects] of double;
begin
     XMSOffset:=0;

     for Obj:=1 to Objects do
         begin

         xms_move(MRec,XMSObjects,XMSOffset and $ffff,XMSOffset shr 16,
                  0,ofs(Obj2),seg(Obj2),
                  300);{Zagruzim Object}
         inc(XMSOffset,300);

         if Obj2.CPlato=CurPlato then CL[Obj]:=Obj2.CPlatoOfs
                                 else CL[Obj]:=TooFar;
         end;

     repeat
           q:=TooFar;
           for Obj:=1 to Objects do
               if CL[Obj]<q then begin q:=CL[Obj];ObjNum:=Obj;end;

           if q<TooFar then
              begin
              ShowObj3D(ObjNum);
              CL[ObjNum]:=TooFar;
              end;
     until q=TooFar;
end;


{Draw all road flats (platoes).
StartingCPlato is needed to draw the right look from your Car's location}
Procedure ShowTrack3D(StartingCPlato:longint);
var
    XMSOffset,j:longint;
    i,l,k:integer;
    a,b,c,d,a1,b1,c1,a5,b5,c5,dx,dy,dz:double;
    f,f1:integer;
    col:byte;
begin
     XMSOffset:=StartingCPlato*300;
     For j:=0 to RoadFlats do {  ᥬ }
{|}      begin

         xms_move(MRec,XMSRoadFlat,XMSOffset and $ffff,XMSOffset shr 16,
                  0,ofs(RoadFlat1),seg(RoadFlat1),300);

         DrawAllObjectsOnCurrentPlato(XMSOffset div 300);{}

         For i:=0 to 4 do
             begin
             ObjXYZ[i+1].X:=RoadFlat1.X[i];
             ObjXYZ[i+1].Y:=RoadFlat1.Y[i];
             ObjXYZ[i+1].Z:=RoadFlat1.Z[i];
             end;

         {Animate Plato's textures}
         With RoadFlat1 do
         begin
         if RStaTexture<RFinTexture then
            begin if RCurTexture<RFinTexture then inc(RCurtexture) else RCurTexture:=RStaTexture;end
         else     if RCurTexture>RFinTexture then dec(RCurTexture) else RCurTexture:=RStaTexture;
         end;

         {Prelight Plato's textures}
         With RoadFlat1 do
         begin
         if RStaLight<RFinLight then
            begin if RCurLight<RFinLight then inc(RCurLight) else RCurLight:=RStaLight;end
         else     if RCurLight>RFinLight then dec(RCurLight) else RCurLight:=RStaLight;
         end;

         {Save to RoadFlat changed texture animation data}
         xms_move(MRec,0,ofs(RoadFlat1),seg(RoadFlat1),
                  XMSRoadFlat,XMSOffset and $ffff,XMSOffset shr 16,
                  300);
         inc(XMSOffset,300);
         if XMSOffset>RoadFlats*300 then XMSOffset:=0;


         if BuildPoligonImage(5,false) then
            with RoadFlat1 do
                 TexturatePoligon(X[0],Y[0],Z[0],
                                  v11,v12,v13,v21,v22,v23,v31,v32,v33,
                                  longint(RCurTexture)*PatchSize,
                                  RScaling,
                                  RCurLight);{}
{|}      end;

       {Draw surbubs if exist}
       if FoundamentalObjectNumber<65535 then
          ShowObj3d(FoundamentalObjectNumber);

end;


{Indicates needed tested system info to screen}
{+ counting Frames Per Second (FPS)}
Procedure ShowStatusInfo(var FrameCnt,BTP:LongInt);
var k,l:longint;
    Obj:ObjRecord;{}
begin
     {========TIMER CODE=============================}
     Inc (FrameCnt);
     if timer=1 then
        begin
        if (BIOSTime-BTP >= 18) then
           begin
           FPS := Round(FrameCnt/(BIOSTime-BTP)*18.2);
           FrameCnt := 0;
           BTP := BIOSTime
           end;
        WriteStr(0,193,Red,0,'FPS:'+ItoS(FPS));
        end
     else
         begin {Show the palette}
         for k:=0 to 255 do
             for l:=0 to 15 do
                 vp^[58560+k+l*320]:=LT^[l shl 8+k];
         end;
     {================================================}
     WriteStr(0,0,Red,0,'Forward Speed='+DtoS(Obj1.CCurrentSpeed)+
                      ' Streif Speed='+DtoS(Obj1.CStreifSpeed));

     strg:=' Status: '+Itos(Obj1.CStatus)+' Energy: '+DtoS(Obj1.CEnergy);
     If CameraInCar then
        begin
        if Obj1.BotControl=0 then WriteStr(0,8,Red,0,'Car is drived by: Player'+strg+':'+itos(Obj1.CId))
                             else WriteStr(0,8,Red,0,'Car is drived by: roBot'+strg+':'+itos(Obj1.CId))
        end
     else
         begin
         if AutoCamera=0 then WriteStr(0,8,Red,0,'Camera is drived by: Player'+strg+':'+itos(Obj1.CId))
                         else WriteStr(0,8,Red,0,'Camera is drived by: roBot'+strg+':'+itos(Obj1.CId))
         end;

     case TexturateMethod of
          1:WriteStr(0,16,White,0,'Texturated: Real,Pas/Asm,No Z-Buffer');
          2:WriteStr(0,16,White,0,'Texturated: Real,Pas,Z-Buffer');
          3:WriteStr(0,16,White,0,'Texturated: Real,Asm,Z-Buffer(IDTLine.asm)');
          4:WriteStr(0,16,White,0,'Texturated: Real,Asm,Z-Buffer(NDTLine1.asm)');
          end;

     WriteStr(0,24,Red,0,'Mines: '+itos(Obj1.Mines)+' Rockets: '+itos(Obj1.Rockets)+
     'CFCONum:'+itos(Obj1.CFCONumber));

     WriteStr(0,32,Red,0,'Bot actions'+Indicate1);

     if autoCamera=1 then WriteStr(0,40,Red,0,'AutoTest actions'+Autotest);{here!}

     if GameOver>0 then WriteStr(100,90,Red,Gray,'Game Over: '+itos(GameOver));{}

     WriteStr(0,180,Red,0,'Objects='+itoS(Objects));

end;


{=====================LIGHTING!!!============================================}
{Test section}
Procedure DoLight;
var i,j:longint;
    X1,Y1,Z1,dxi,dyi,dzi,dxj,dyj,dzj:double;
    Xt,Yt,Zt:double;
    dx,dy,dz:double;
    Light,MinL:byte;
    l,VOfs:longint;
begin
     VOfs:=0;
     Light:=1;

     {Change intensivity}
     inc(Lights[1].CurI,Lights[1].StepI);
     if Lights[1].CurI>Lights[1].FinI then Lights[1].CurI:=Lights[1].StaI;

     With Camera do
          begin
          dxj:=v11/r;dxi:=-v31/r-320*dxj{};
          dyj:=v12/r;dyi:=-v32/r-320*dyj{};
          dzj:=v13/r;dzi:=-v33/r-320*dzj{};

          X1:=-dxj*160-v21+v31/r*100;
          Y1:=-dyj*160-v22+v32/r*100;
          Z1:=-dzj*160-v23+v33/r*100;
          end;
     for i:=0 to 199 do
     begin
     for j:=0 to 319 do
{^}      begin

         if VOfs<16000 then l:=ZB[0]^[VOfs] shr 9
         else if VOfs<32000 then l:=ZB[1]^[VOfs-16000] shr 9
              else if VOfs<48000 then l:=ZB[2]^[VOfs-32000] shr 9
                   else l:=ZB[3]^[VOfs-48000] shr 9;
{        if b<$FFFF then
           begin{}

           With Camera do
                begin
                Xt:=Camera.X+X1*l;
                Yt:=Camera.Y+Y1*l;
                Zt:=Camera.Z+Z1*l;
                end;

{Dlja neskolkih istochnikov sveta}
{           MinL:=15;
           for Light:=1 to Lites do
               begin
               dx:=Lights[Light].X-Xt;dy:=Lights[Light].Y-Yt;dz:=Lights[Light].Z-Zt;
               l:=15-trunc(Lights[Light].Intensivity/(dx*dx+dy*dy+dz*dz));
               if l<0 then begin MinL:=0;break;end
                      else if l<MinL then MinL:=l;
               end;
{}
           dx:=Lights[Light].X-Xt;dy:=Lights[Light].Y-Yt;dz:=Lights[Light].Z-Zt;
           l:=15-trunc(Lights[Light].CurI/(dx*dx+dy*dy+dz*dz));
           if l<0 then l:=0;

           vp^[VOfs]:=LT^[l shl 8+vp^[VOfs]];
{           end;{}

           inc(VOfs);

           X1:=X1+dxj;Y1:=Y1+dyj;Z1:=Z1+dzj;{}
{^}      end;
     X1:=X1+dxi;Y1:=Y1+dyi;Z1:=Z1+dzi;
     end;

end;

{Prelight in Cars HeadLighting}
Procedure DoObjectsLighting;
begin
     if abs(Obj1.CStreif)>Obj1.CEngine.EMaxStreif/3 then
        begin
        if Obj1.CHeadLightCounter>0 then dec(Obj1.CHeadLightCounter)
                                    else Obj1.CHeadLightCounter:=8;
        end
     else Obj1.CHeadLightCounter:=8;
end;



{======================CONTROL CARs MOVEMENTS================================}

{ਡ  設  .  ᪮}
Procedure MoveCarForwardOrBackward(Direction:integer);
var q:double;
begin
     Direction:=sgn(Direction);
     With Obj1 do
          if CGRavitation>=0 then
             if abs(CCurrentSpeed)<CEngine.EMaxSpeed then
                begin
                CCurrentSpeed:=CCurrentSpeed+Direction*CEngine.EAcceleration;
                end;
end;


{ 設 , ᫨ Direction=-1  ࠢ ᫨ =1}
Procedure StreifCar(Direction:integer);
begin
     Direction:=sgn(Direction);
     With Obj1 do
          if CGravitation>=0 then
             if abs(CStreifSpeed)<CEngine.EMaxStreif then
                begin
                CStreifSpeed:=CStreifSpeed+Direction*CEngine.EStreifAcceleration;
                end;
end;

{Say to car BRAKING!}
Procedure StopCar;
begin
     With Obj1 do
     if CGravitation>=0 then{Stopping!}
        begin
        if abs(CCurrentSpeed)<1 then CCurrentSpeed:=0
                               else CCurrentSpeed:=CCurrentSpeed/1.2;
        if abs(CStreifSpeed)<1 then CStreifSpeed:=0
                               else CStreifSpeed:=CStreifSpeed/1.2;
        CBrakeLightSwitch:=1;
        end;
end;

{Energetic shiel enabled}
Procedure CarsShield(ObjNum:word);
begin
     With Obj1 do
     begin
     if CEnergy>0 then CShield:=15;
     end;
end;


Procedure RocketsSmog(ObjNum:word);
var Obj2:ObjRecord;
begin
     Obj2:=Obj1;
     With ObjPrototypeInfo1 do
     With Obj1 do
          CreatObj(2,
                CPlato,CPlatoOfs,CDev,Obj1.Z,
                100,30,
                NoEngine,
                0,0,{_CCurrentSpeed,_CStep}
                0,0, {Streif}
                0,0,{Gravitation}
                200,
                XMSSmogOffset,
                10,{TTL}
                ObjNum,{Owner, who shoted}
                2,
                Obj2,
                true,false);
end;

Procedure CarsFire(ObjNum:word);
var ObjPrototypeInfo1:ObjPrototypeInfo;
    Obj2:ObjRecord;
begin
 With ObjPrototypeInfo1 do
 With Obj1 do
     begin

     if Obj1.CReloadCounter>0 then exit;{reloading in progress. Cant shot!}

     Case Obj1.CWeapon of
          1:{Mines}
          begin
          If Obj1.Mines<1 then exit;
             LoadObjPrototypeInfoFromXMS(ObjPrototypeInfo1,Obj1.CXMSPrototypeOffset);
             CreatObj(1,
                CPlato,CPlatoOfs,CDev+OPGunX,Obj1.Z+OPGunZ,
                100,30,
                SimpleEngine,
                -20,0,{_CCurrentSpeed,_CStep}
                0,0, {Streif}
                20,0,{Gravitation}
                200,
                XMSMineOffset,
                100,{TTL}
                ObjNum,{Owner, who shoted}
                2,{Two steps non-destruction for owner}
                Obj2,
                true,true);
          dec(Obj1.Mines);
          Obj1.CReloadCounter:=3;
          end;
          2:{Rockets}
          begin
          If Obj1.Rockets<1 then exit;
             LoadObjPrototypeInfoFromXMS(ObjPrototypeInfo1,Obj1.CXMSPrototypeOffset);
             CreatObj(1,
                CPlato,CPlatoOfs,CDev+OPGunX,Obj1.Z+OPGunZ,
                100,30,
                SimpleEngine,
                90,0,{_CCurrentSpeed,_CStep}
                0,0, {Streif}
                30,0,{Gravitation}
                200,
                XMSRocketOffset,{}
                100,{TTL}
                ObjNum,{Owner, who shoted}
                2,{Two steps non-destruction for owner}
                Obj2,
                True,true);
          dec(Obj1.Rockets);
          Obj1.CReloadCounter:=5;
          end;
          end;
     end;
end;

{ॢ 2 न 設 ⭮⥫쭮 ண  3 न}
{ (CPlatoOfs;CDev) -> (x;y;z) }
{⠥,  ,  ஬ ᥩ ⫮ 2 न 㦥  RoadFlat1!!!}
Procedure Transform2dTo3d(CPlatoOfs,CDev:double;var Xr,Yr,Zr:double);
var dx,dy,ll:double;
    a2,b2:double;
    RELength,CEPlatoOfs:double;
    x1,x2,y1,y2,l,a1,b1:double;
begin
     With RoadFlat1 do
     begin
     RELength:=RLength-CDev*(RLength-lll)/RWidth;{Roads evaluted Length with car devinition "CDev"}
     CEPlatoOfs:=CPlatoOfs*RELength/RLength;{Cars evaluated offset on current RoadFlat}

     dx:=X[3]-Xm2;dy:=Y[3]-Ym2;
     ll:=sqrt(dx*dx+dy*dy);{ l<>0 because road flat width couldn't be zero length!}
     if abs(ll)<eps then _Error('Roads width is about zero!');
     a2:=dx/ll;b2:=dy/ll;
     ll:=CDev*ll/RWidth1;

     Xr:=Xm2+a2*ll+a1*CEPlatoOfs;
     Yr:=Ym2+b2*ll+b1*CEPlatoOfs;
     Zr:=Z[0]-CPlatoOfs*(Z[0]-Z[1])/RLength;
     end;
end;

{Directing this car along the track by rotation}
Procedure DirectTheObjAlongTheTrack;
var x1,y1,z1,x2,y2,z2,dx,dy,dz,l:double;
    XMSOffset,CurPlato:longint;
begin
     With Obj1 do
     begin
     {塞 3 न "।" 設}
     CurPlato:=CPlato;
     XMSOffset:=300*CurPlato;
     xms_move(MRec,XMSRoadFlat,XMSoffset and $ffff,XMSoffset shr 16,
              0,ofs(RoadFlat1),seg(RoadFlat1),300);
     l:=CLength*v33+CPlatoOfs;
     while l>=RoadFlat1.RLength do { ।  設 室  ᫥. }
           begin
           l:=l-RoadFlat1.RLength;
           {㦠 ᫥. }
           inc(CurPlato);
           if CurPlato>RoadFlats then CurPlato:=0;{஢ઠ  室 ᫥. 㣠 }
           XMSOffset:=300*CurPlato;
           xms_move(MRec,XMSRoadFlat,XMSoffset and $ffff,XMSoffset shr 16,
                    0,ofs(RoadFlat1),seg(RoadFlat1),300);
           end;
     { "l" - ᬥ饭  㦥  "RoadFlat1" }
     Transform2dTo3d(l,0,x1,y1,z1);

     {塞 3 न "" 設}
     CurPlato:=CPlato;
     XMSOffset:=300*CurPlato;
     xms_move(MRec,XMSRoadFlat,XMSoffset and $ffff,XMSoffset shr 16,
              0,ofs(RoadFlat1),seg(RoadFlat1),300);
     l:=CLength*v33-CPlatoOfs;
     while l>0 do { ।  設 室  ᫥. }
           begin
           {㦠 ᫥. }
           dec(CurPlato);
           if CurPlato<0 then CurPlato:=RoadFlats;{஢ઠ  室 "" 設  ।.  }
           XMSOffset:=300*CurPlato;
           xms_move(MRec,XMSRoadFlat,XMSoffset and $ffff,XMSoffset shr 16,
                    0,ofs(RoadFlat1),seg(RoadFlat1),300);
           l:=l-RoadFlat1.RLength;
           end;
     { "l" - ᬥ饭  㦥  "RoadFlat1" }
     Transform2dTo3d(-l,0,x2,y2,z2);

     { 窨 (x1;y1;z1) (x2;y2;z2) - }
     {塞 -⥬   (  設)}
     dx:=x1-x2;dy:=y1-y2;dz:=z1-z2;
     l:=sqrt(dx*dx+dy*dy+dz*dz);
     if abs(l)<Eps then _Error('Car has length about zero!');
     v21:=-dx/l;v22:=-dy/l;v23:=-dz/l;
     l:=sqrt(dx*dx+dy*dy);
     v11:=-dy/l;v12:=dx/l;v13:=0;
     normal(v11,v12,v13,v21,v22,v23,v31,v32,v33);
     end;
end;


{===============COLLISION DETECTOR============================================}


{Counting the value of "Obj1.CStep" field if Obj1 has collision with other car (Obj2)}
Procedure DetectForwardCollisionsWithOtherObjects(var Obj1:ObjRecord;ObjNumber:word);
Label TheEnd;
Const
     TooFar:double=1000000;
var Obj,Obje,ObjNum:word;
    Obj2:ObjRecord;
    q,qq,qqq,Dist,up,Low,MinF,MinB,HitCoef:double;
    ObjectsLengths,ObjectsHeights:double;
    Obj1_v33,Obj2_v33:double;
    DistanceX,DistanceY,DistanceZ:double;
    CommonSpeed,Obj1NewSpeed,Obj2NewSpeed:double;
    Obj1Damage,Obj2Damage:longint;
begin
     MinF:=TooFar;MinB:=TooFar;
     Obj1.CFCONumber:=65535;Obj1.CBCONumber:=65535;

     {Looking for the min distance between "ObjNumber" object and "Obj" object}
     Obje:=1;
     While Obje<=PCOcounter do {Taking all "PCO-Objects"}
{M}  begin
         Obj:=PCO[Obje];

         if Obj<>ObjNumber then {Not between equival objects!}
         begin
         LoadObjFromXMS(Obj2,Obj);
         if (Obj2.CId<2)and(Obj2.COwner<>ObjNumber)and(Obj1.COwner<>Obj) then {material object and not parent(owner)}
            begin

   {--------Count Normal Vectors, lengths and hieghts}
            Obj1_v33:=sqrt(1-Obj1.v33*Obj1.v33);
            Obj2_v33:=sqrt(1-Obj2.v33*Obj2.v33);

            ObjectsLengths:=abs(Obj1.v33*Obj1.Clength+Obj1_v33*Obj1.CHeight+
                                Obj2.v33*Obj2.Clength+Obj2_v33*Obj2.CHeight);

            ObjectsHeights:=abs(Obj1.v33*Obj1.CHeight+Obj1_v33*Obj1.CLength+
                                Obj2.v33*Obj2.CHeight+Obj2_v33*Obj2.CLength);

   {--------Count Distances X,Y,Z}
            {DistanceX: Obj2 levee Obj1 so znakom (-) ili pravee so znakom (+)}
            DistanceX:=Obj2.CDev-Obj1.CDev;
            {DistanceY: naskolko Obj2 vperedi Obj1 so znakom(+)}
            DistanceY:=Obj2.CDistanceFromStart-Obj1.CDistanceFromStart;
            if DistanceY<0 then DistanceY:=Distance+DistanceY;
            {DistanceZ: Obj2 vyshe Obj1 so znakom (+) ili nizhe so znakom (-)}
            if Obj1.CGravitation<0 then DistanceZ:=Obj2.Z-Obj1.Z{Esli v polete, to Z - absolutnye}
            else DistanceZ:=Obj2.Zt-Obj1.Zt;{inache: Z - vysota Objecta nad dorogoi}

   {-----------Check Y-collision}
               if abs(DistanceX)<=Obj1.CWidth+Obj2.CWidth+3{=EPS} then
                  if abs(DistanceZ)<=ObjectsHeights+3{=EPS} then
                     begin
                     {q = polozhitelnoe rasstojanie ot Obj1 do Obj2 pri dvizhenii Obj1 nazad}
                     q:=-(DistanceY-Distance)-ObjectsLengths;
                     {qq = polozhitelnoe rasstojanie ot Obj1 do Obj2 pri dvizhenii Obj1 vpered}
                     qq:=DistanceY-ObjectsLengths;
                     if Obj1.CStep>0 then begin qqq:=q;q:=qq;qq:=qqq;end;{swaps}
                     if q<=MinF then begin MinF:=q;Obj1.CFCONumber:=Obj;end;
                     if qq<=MinB then begin MinB:=qq;Obj1.CBCONumber:=Obj;end;
                     end;
            end;
         end;
     inc(Obje);
{M}  end;

{Poluchili "ObjNum" - nomer objecta s kotorym samaja korotkaja kollizija}
if Obj1.CFCONumber<65535 then {esli nashli hot' kakoi to object}
     begin
     {Extra obrabotka eps pogreshnostei}
     MinF:=MinF-5;{5=Eps pogreshnost}
     if MinF<0 then begin MinF:=0;Obj1.CStep:=0;end;

     if MinF<=abs(Obj1.CStep) then{Collision was!!!}
        begin
        Obj1.CStep:=MinF*sgn(Obj1.CStep);

        LoadObjFromXMS(Obj2,Obj1.CFCONumber);

        Obj1.CFCollised:=5;{For robots needs: 5 times to back}

        {Impulse exchange}
{        s1 := Obj1.CCurrentSpeed; s2 := Obj2.CCurrentSpeed}
{        m1*s1+m2*s2=m1*s1'+m2*s2'                // Impulse exchange }
{        s1'=(m1*s1+m2*s2)/(m1+m2)*(1-HitKoef)    // - for Obj1}
{        s2'=(m1*s1+m2*s2)/(m1+m2)*HitKoef        // - for Obj2}
{        Damage =[ ABS(PreviousSpeed-NewSpeed)*100% / CriticalSpeed ] }

        CommonSpeed:=(Obj1.CMass*Obj1.CCurrentSpeed+Obj2.CMass*Obj2.CCurrentSpeed)/
                     (Obj1.CMass+Obj2.CMass);{}

{        if Obj1.CMass<Obj2.CMass then HitCoef:=1-Obj1.CMass/Obj2.CMass
                                 else HitCoef:=Obj2.CMass/Obj1.CMass;{}

        Obj1NewSpeed:=CommonSpeed*(1-HitKoef);
        Obj2NewSpeed:=CommonSpeed*HitKoef;

        Obj1Damage:=round(abs(Obj1.CCurrentSpeed-Obj1NewSpeed)*100/CriticalOverload);
        Obj2Damage:=round(abs(Obj2.CCurrentSpeed-Obj2NewSpeed)*100/CriticalOverload);

        Obj1.CCurrentSpeed:=Obj1NewSpeed;
        Obj2.CCurrentSpeed:=Obj2NewSpeed;

        DamageObj(false,Obj1,ObjNum,Obj1Damage,true);
        DamageObj(false,Obj2,ObjNum,Obj2Damage,false);

        if Obj1.CId=1 then {if rocket(Obj1) has hited object(Obj2)}
           begin
           if Obj2.CId=1 then ExploseObj(false,Obj2,Obj1.CFCONumber,true){Explose Rocket|Mine}
                         else  DamageObj(false,Obj2,Obj1.CFCONumber,Obj1.CEnergy,true);{Damage object}
           ExploseObj(false,Obj1,ObjNumber,true);{Explose rocket}
           goto TheEnd;
           exit;
           end;
        if Obj2.CId=1 then {If Object(Obj1) has touched the mine(Obj2)}
           begin
           if Obj1.CId=1 then
              begin
              ExploseObj(false,Obj1,ObjNumber,true);{Explose Rocket|Mine}
              end
           else DamageObj(false,Obj1,ObjNumber,Obj2.CEnergy,false);{Damage object}
           ExploseObj(false,Obj2,Obj1.CFCONumber,true);{Explose Mine}
           goto TheEnd;
           exit;
           end;

        SaveObjToXMS(Obj2,Obj1.CFCONumber);

        end;
     end;
TheEnd:

end;

{Detects the streif collision with other objects.
ObjNumber and Obj1 - are the current detected objects number and record}
Procedure DetectStreifCollisionsWithOtherObjects(var Obj1:ObjRecord;ObjNumber:word);
Const
     TooFar:double=1000000;
var Obj,Obje,ObjNum:word;
    Obj2:ObjRecord;
    q,MinF,Up,Low,HitCoef:double;
    ObjectsLengths,ObjectsHeights:double;
    Obj1_v33,Obj2_v33:double;
    DistanceX,DistanceY,DistanceZ:double;
begin
     MinF:=TooFar;
     ObjNum:=65535;

{Looking for the min distance between "ObjNumber" Obj and "Obj" objects}
     Obje:=1;
     While Obje<=PCOcounter do {Taking all Objects}
{M}  begin
     Obj:=PCO[Obje];

      if Obj<>ObjNumber then{Not between equival objects!}
         begin
         LoadObjFromXMS(Obj2,Obj);

         if (Obj2.CId<2)and(Obj2.COwner<>ObjNumber)and(Obj1.COwner<>Obj) then {material object and not parent(owner)}
            begin

            {DistanceX: Obj2 levee Obj1 so znakom (-) ili pravee so znakom (+)}
            DistanceX:=Obj2.CDev-Obj1.CDev;

            if sgn(Obj1.CStreif)=sgn(DistanceX) then{v tom zhe napravlenii}
               begin

      {--------Count Normal Vectors, lengths and hieghts}
               Obj1_v33:=sqrt(1-Obj1.v33*Obj1.v33);
               Obj2_v33:=sqrt(1-Obj2.v33*Obj2.v33);

               ObjectsLengths:=abs(Obj1.v33*Obj1.Clength+Obj1_v33*Obj1.CHeight+
                                   Obj2.v33*Obj2.Clength+Obj2_v33*Obj2.CHeight);

               ObjectsHeights:=abs(Obj1.v33*Obj1.CHeight+Obj1_v33*Obj1.CLength+
                                   Obj2.v33*Obj2.CHeight+Obj2_v33*Obj2.CLength);

      {--------Count Distances X,Y,Z}
               {DistanceY: naskolko Obj2 vperedi Obj1 so znakom(+)}
               DistanceY:=Obj2.CDistanceFromStart-Obj1.CDistanceFromStart;
               if DistanceY<0 then DistanceY:=Distance+DistanceY;
               {DistanceZ: Obj2 vyshe Obj1 so znakom (+) ili nizhe so znakom (-)}
               if Obj1.CGravitation<0 then DistanceZ:=Obj2.Z-Obj1.Z{Esli v polete, to Z - absolutnye}
               else DistanceZ:=Obj2.Zt-Obj1.Zt;{inache: Z - vysota Objecta nad dorogoi}

      {--------Check X-collision}
               if (DistanceY<=ObjectsLengths+3{=EPS})or
                  (-DistanceY+Distance<=ObjectsLengths+3{=EPS}) then
                  if abs(DistanceZ)<=ObjectsHeights+3{=EPS} then
                        begin
                        q:=abs(DistanceX)-Obj1.CWidth-Obj2.CWidth;
                        if q<MinF then begin MinF:=q;ObjNum:=Obj;end;
                        end;

               end;
            end;
         end;
     inc(Obje);
{M}  end;

{Poluchili "ObjNum" - nomer mashyni s kotoroi samaja korotkaja kollizija}
if ObjNum<65535 then{esli nashli hot' kakoi to object}
     begin
     MinF:=MinF-5;{EPS pogreshnost' = 10}
     if MinF<0 then begin MinF:=0;Obj1.CStreif:=0;end;

     if MinF<abs(Obj1.CStreif) then{Collision was!!!}
        begin
        Obj1.CStreif:=MinF*sgn(Obj1.CStreif);
        LoadObjFromXMS(Obj2,ObjNum);

        {Impulse exchange}
        up:=Obj1.CMass*Obj1.CStreifSpeed+Obj2.CMass*Obj2.CStreifSpeed;
        Low:=Obj1.CMass+Obj2.CMass;
        HitCoef:=Obj2.CMass/Obj1.CMass;if HitCoef>1 then HitCoef:=1;
        Obj1.CStreifSpeed:=Up/Low*(1-HitKoef);
        Obj2.CStreifSpeed:=Up/Low*HitKoef;

        if Obj1.CId=1 then {if rocket(Obj1) has hited object(Obj2)}
           begin
           if Obj2.CId=1 then ExploseObj(false,Obj2,ObjNum,true){Explose Rocket|Mine}
                         else  DamageObj(false,Obj2,ObjNum,Obj1.CEnergy,true);{Damage object}
           ExploseObj(false,Obj1,ObjNumber,true);{Explose rocket}
           exit;
           end;
        if Obj2.CId=1 then {If Object(Obj1) has touched the mine(Obj2)}
           begin
           if Obj1.CId=1 then
              begin
              ExploseObj(false,Obj1,ObjNumber,true);{Explose Rocket|Mine}
              end
           else DamageObj(false,Obj1,ObjNumber,Obj2.CEnergy,false);{Damage object}
           ExploseObj(false,Obj2,ObjNum,true);{Explose Mine}
           exit;
           end;

        SaveObjToXMS(Obj2,ObjNum);

        end;
     end;
end;

{Detects the Z collision with other objects.
ObjNumber and Obj1 - are the current detected objects number and record}
Procedure DetectZCollisionsWithOtherObjects(var Obj1:ObjRecord;ObjNumber:word);
Const
     TooFar:double=1000000;
var Obj,Obje,ObjNum:word;
    Obj2:ObjRecord;
    q,MinF,Up,Low,HitCoef:double;
    ObjectsLengths,ObjectsHeights:double;
    Obj1_v33,Obj2_v33:double;
    DistanceX,DistanceY,DistanceZ:double;
begin
     MinF:=TooFar;
     ObjNum:=65535;

{Looking for the min distance between "ObjNumber" Obj and "Obj" objects}
     Obje:=1;
     While Obje<=PCOcounter do {Taking all Objects}
{M}  begin
     Obj:=PCO[Obje];

     if Obj<>ObjNumber then {Not between equival objects!}
        begin
        LoadObjFromXMS(Obj2,Obj);

        if (Obj2.CId<2)and(Obj2.COwner<>ObjNumber)and(Obj1.COwner<>Obj) then {material object and not parent(owner)}
           begin

           {DistanceZ: Obj2 vyshe Obj1 so znakom (+) ili nizhe so znakom (-)}
           if Obj1.CGravitation<0 then DistanceZ:=Obj2.Z-Obj1.Z{Esli v polete, to Z - absolutnye}
           else DistanceZ:=Obj2.Zt-Obj1.Zt;{inache: Z - vysota Objecta nad dorogoi}

           if sgn(Obj1.CFalling)=sgn(DistanceZ) then{v tom zhe napravlenii}
              begin

     {--------Count Normal Vectors, lengths and hieghts}
              Obj1_v33:=sqrt(1-Obj1.v33*Obj1.v33);
              Obj2_v33:=sqrt(1-Obj2.v33*Obj2.v33);

              ObjectsLengths:=abs(Obj1.v33*Obj1.Clength+Obj1_v33*Obj1.CHeight+
                                  Obj2.v33*Obj2.Clength+Obj2_v33*Obj2.CHeight);

              ObjectsHeights:=abs(Obj1.v33*Obj1.CHeight+Obj1_v33*Obj1.CLength+
                                  Obj2.v33*Obj2.CHeight+Obj2_v33*Obj2.CLength);

     {--------Count Distances X,Y,Z}
              {DistanceX: Obj2 levee Obj1 so znakom (-) ili pravee so znakom (+)}
              DistanceX:=Obj2.CDev-Obj1.CDev;
              {DistanceY: naskolko Obj2 vperedi Obj1 so znakom(+)}
              DistanceY:=Obj2.CDistanceFromStart-Obj1.CDistanceFromStart;
              if DistanceY<0 then DistanceY:=Distance+DistanceY;

              if abs(DistanceX)<=Obj1.CWidth+Obj2.CWidth+3{=EPS} then
                 if (DistanceY<=ObjectsLengths+3{=EPS})or
                    (-DistanceY+Distance<=ObjectsLengths+3{=EPS}) then
                    begin
                    q:=abs(DistanceZ)-ObjectsHeights;
                    if q<MinF then begin MinF:=q;ObjNum:=Obj;end;
                    end;

              end;
           end;
        end;
     inc(Obje);
{M}  end;


{Poluchili "ObjNum" - nomer mashyni s kotoroi samaja korotkaja kollizija}
  if ObjNum<65535 then {esli nashli hot' kakoi to object}
     begin
     MinF:=MinF-5;{EPS pogreshnost' = 10}
     if MinF<0 then begin MinF:=0;Obj1.CFalling:=0;end;

     if MinF<abs(Obj1.CFalling) then{Collision was!!!}  {"<=" - mozhno postavit'}
        begin
        Obj1.CFalling:=MinF*sgn(Obj1.CFalling);
        LoadObjFromXMS(Obj2,ObjNum);

        {Impulse exchange}
        up:=Obj1.CMass*Obj1.CGravitation+Obj2.CMass*Obj2.CGravitation;
        Low:=Obj1.CMass+Obj2.CMass;
        HitCoef:=Obj2.CMass/Obj1.CMass;if HitCoef>1 then HitCoef:=1;
        Obj1.CGravitation:=Up/Low*(1-HitKoef);
        Obj2.CGravitation:=Up/Low*HitKoef;

        if Obj1.CId=1 then {if rocket(Obj1) has hited object(Obj2)}
           begin
           if Obj2.CId=1 then ExploseObj(false,Obj2,ObjNum,true){Explose Rocket|Mine}
                         else  DamageObj(false,Obj2,ObjNum,Obj1.CEnergy,true);{Damage object}
           ExploseObj(false,Obj1,ObjNumber,true);{Explose rocket}
           exit;
           end;
        if Obj2.CId=1 then {If Object(Obj1) has touched the mine(Obj2)}
           begin
           if Obj1.CId=1 then
              begin
              ExploseObj(false,Obj1,ObjNumber,true);{Explose Rocket|Mine}
              end
           else DamageObj(false,Obj1,ObjNumber,Obj2.CEnergy,false);{Damage object}
           ExploseObj(false,Obj2,ObjNum,true);{Explose Mine}
           exit;
           end;

        SaveObjToXMS(Obj2,ObjNum);

        end;
     end;

end;


{RoBot for this "ObjNumber" object. Hope the "Obj1" record is loaded!}
Procedure Bot(ObjNumber:word);
var Obj,ObjNumAhead,ObjNumBackward:word;
    Obj2:ObjRecord;
    ObjectsLengths,ObjectsWidths,ObjectsHeights,F,S:double;
    Obj1_v33,Obj2_v33:double;

begin
     With Obj1 do
     begin
     CBrakeLightSwitch:=0;
{     exit;{}

     if CGravitation<0 then begin Indicate1:=':Disabled in fly..';exit;end;{Bot disabled, 'caurse the Obj is falling down}

{Forward object}
     if CFCONumber<65535 then
        begin
        Indicate1:=':FObject'+itos(CFCONumber);

        LoadObjFromXMS(Obj2,CFCONumber);

        if Obj2.CId=255 then exit;{esli ego uzhe vzorvali}

        {F - naskolko Obj2 vperedi Obj1 so znakom(+)}
        F:=Obj2.CDistanceFromStart-Obj1.CDistanceFromStart;
        if F<0 then F:=Distance+F;

        S:=Obj2.CDev-Obj1.CDev;{Streif otklonenie}

        Obj1_v33:=sqrt(1-Obj1.v33*Obj1.v33);
        Obj2_v33:=sqrt(1-Obj2.v33*Obj2.v33);

        ObjectsLengths:=abs(Obj1.v33*Obj1.Clength+Obj1_v33*Obj1.CHeight+
                            Obj2.v33*Obj2.Clength+Obj2_v33*Obj2.CHeight);

        ObjectsWidths:=Obj1.CWidth+Obj2.CWidth;

        ObjectsHeights:=abs(Obj1.v33*Obj1.CHeight+Obj1_v33*Obj1.CLength+
                            Obj2.v33*Obj2.CHeight+Obj2_v33*Obj2.CLength);


{When the situation is near to be collised with other object}
{^}     if F<ObjectsLengths*10 then
           begin
           Indicate1:=Indicate1+':SCover'+itos(-sgn(Obj2.CDev+Eps));
           StreifCar(-sgn(Obj2.CDev+Eps));

           if abs(S)<=ObjectsWidths+10{=EPS} then
              begin
              Obj1.CWeapon:=2;
              Keys[1]:=29;{For cars fire, 29=<Ctrl>}

              if CFCollised>0 then {esli vo chto-to vrezalsja}
                 begin
                 Indicate1:=Indicate1+':Backward';
                 MoveCarForwardOrBackward(-1);
                 exit;
                 end;

              if Obj1.CCurrentSpeed>70 then
                 begin
                 Indicate1:=Indicate1+':Stopping';
                 StopCar;
                 exit;
                 end;
              end;
           MoveCarForwardOrBackward(1);
           end
{The situation is favour to left some mines}
{^}        else
               begin
               Indicate1:=Indicate1+':ToTrackMiddle';
               StreifCar(-sgn(Obj1.CDev));
               MoveCarForwardOrBackward(1);
               end;
        end
     else
         begin
         Indicate1:='Searching objects..';
         StreifCar(-sgn(Obj1.CDev));
         MoveCarForwardOrBackward(1);
         end;

     end;

end;

{쭮 ६饭 設 "ObjNumber"  }
Procedure TryToMoveObj(ObjNumber:word);
Label FirstAmmoStep,Again;
var
   XMSOffset:longint;
   RELength,CEPlatoOfs,CurRWidth,l:double;
   a2,b2,streif:double;
   Zk1,Zk2:double;
   dx,dy,dz:double;
   KeyFire:boolean;
   Obj:word;
   DistanceY,Obj1_v33,Obj2_v33,ObjectsLengths:double;{OPTIMIZATION only!}
begin
     LoadObjFromXMS(Obj1,ObjNumber);

     KeyFire:=false;

     {Obj3:=Obj1;{}

Again:

     With Obj1 do
          begin

          inc(CCounter);{inc objects own counter}

          if CTTL<65535 then {Actions for TTL objects: dec(TTL)}
             begin
             dec(CTTL,1);
             if CTTL<1 then {Time expired -> ExploseObj}
                begin
                ExploseObj(false,Obj1,ObjNumber,true);{Explose&SaveToXMS!}
                goto Again;
                end;
             end;

          {㧨   ஬ ᥩ 室 object}
          LoadRoadFlatFromXMS(RoadFlat1,CPlato);{}

          if CShield>0 then
             begin
             dec(CShield);{if Shield was}
             if CEnergy>0 then CEnergy:=CEnergy-1;
             end;

          case CId of
               1:begin
                 if CReloadCounter=2 then

                 goto FirstAmmoStep;{appearance of explosive on scene}
                 end;
               2,255:begin SaveObjToXMS(Obj1,ObjNumber);{save TTL}exit;end;
               end;

          if ObjNumber>=CarsOfs then if ObjNumber<CarsOfs+Cars then{if took a car}
             begin
             {RoBots controls for movement}
             if BotControl=1 then Bot(ObjNumber);

             for i:=1 to 6 do
                 begin
                 if Keys[i]=19 then BotControl:=1-BotControl;
                 if Keys[i]=29 then KeyFire:=true;
                 if Keys[i]=2 then CWeapon:=1;{Player change to Weapon1}
                 if Keys[i]=3 then CWeapon:=2;{Player change to Weapon2}
                 if Keys[i]=72 then MoveCarForwardOrBackward(1);
                 if Keys[i]=80 then MoveCarForwardOrBackward(-1);
                 if Keys[i]=57 then StopCar else CBrakeLightSwitch:=0;
                 if Keys[i]=75 then StreifCar(-1);
                 if Keys[i]=77 then StreifCar(1);
                 if Keys[i]=36 then if CGravitation=0 then CGravitation:=50;
                 if Keys[i]=56 then CarsShield(CarsOfs);

                 Keys[i]:=0;
                 end;

             end;

          {㧨   ஬ ᥩ 室 設}
          LoadRoadFlatFromXMS(RoadFlat1,CPlato);

       if CGravitation>=0 then
          begin
          {ﭨ ମ ⥫  ⥪. ᪮}
          if abs(CCurrentSpeed)-CEngine.EFriction<0 then CCurrentSpeed:=0
          else CCurrentSpeed:=sgn(CCurrentSpeed)*(abs(CCurrentSpeed)-CEngine.EFriction);

          {ﭨ ମ ⥫  ⥪.  ᪮}
          if abs(CStreifSpeed)-CEngine.EFriction<0 then CStreifSpeed:=0
          else CStreifSpeed:=sgn(CStreifSpeed)*(abs(CStreifSpeed)-CEngine.EFriction);

          {ﭨ 㪫 ண  ⥪. ᪮}
          CCurrentSpeed:=CCurrentSpeed+sgn(RoadFlat1.Z[0]-RoadFlat1.Z[1])*sqrt(1-v33*v33)*g;

          {Uchet normali mashiny k peremesheniu}
          Speed:=CCurrentSpeed*v33;
          end

       else Speed:=CCurrentSpeed;{Elsi mashina v vozduhe...}

          {ﭨ  設  ७  ⨥ ண  ६饭}
          Speed:=Speed*Mn/CMass*RoadFlat1.RFriction;

          {६饭 設}
          CStep:=Speed;

{=========OPTIMIZATION=======================================================}
          {Detects potential "Y-collised" objects with "ObjNumber" object}
          PCOcounter:=0;
          Obj:=1;
          While Obj<=Objects do
                begin
                LoadObjFromXMS(Obj2,Obj);

                Obj1_v33:=sqrt(1-Obj1.v33*Obj1.v33);
                Obj2_v33:=sqrt(1-Obj2.v33*Obj2.v33);

                ObjectsLengths:=abs(Obj1.v33*Obj1.Clength+Obj1_v33*Obj1.CHeight+
                                    Obj2.v33*Obj2.Clength+Obj2_v33*Obj2.CHeight);

                if CStep>0 then{DistanceY: naskolko Obj2 vperedi Obj1 so znakom(+)}
                   begin
                   DistanceY:=Obj2.CDistanceFromStart-Obj1.CDistanceFromStart;
                   if DistanceY<0 then DistanceY:=Distance+DistanceY;
                   if (DistanceY<=ObjectsLengths+CStep+10{=EPS})or
                      (Distance-DistanceY<=ObjectsLengths+CStep+10{=EPS}) then
                      begin
                      inc(PCOcounter);
                      PCO[PCOcounter]:=Obj;
                      end;
                   end
                else{DistanceY: naskolko Obj1 vperedi Obj2 so znakom(+)}
                   begin
                   DistanceY:=Obj1.CDistanceFromStart-Obj2.CDistanceFromStart;
                   if DistanceY<0 then DistanceY:=Distance+DistanceY;
                   if (DistanceY<=ObjectsLengths+abs(CStep)+10{=EPS})or
                      (Distance-DistanceY<=ObjectsLengths+CStep+10{=EPS}) then
                      begin
                      inc(PCOcounter);
                      PCO[PCOcounter]:=Obj;
                      end;
                   end;
                inc(Obj);
                end;
{============================================================================}

{Forward Collision detector}
if abs(CStep)>0 then DetectForwardCollisionsWithOtherObjects(Obj1,ObjNumber)
                else CStep:=0;

          Streif:=0;

{1}if CStep>0 then

          while CStep>0 do{६饭 設 ।}
{------------->}begin

                With RoadFlat1 do
                begin
                RELength:=RLength-CDev*(RLength-lll)/RWidth;{Roads evaluted Length with Obj devinition "CDev"}
                CEPlatoOfs:=CPlatoOfs*RELength/RLength;{objects evaluated offset on current RoadFlat}
                end;

                if RELength<=CEPlatoOfs+CStep then{᫨ "५⥫"  }
                   begin
                   {Koef for Obj's jumping}
                   Zk1:=(RoadFlat1.Z[1]-RoadFlat1.Z[0])/RoadFlat1.RLength;

                   inc(CPlato);{室  ᫥饬  }
                   if CPlato>RoadFlats then begin CPlato:=0;inc(CLaps);end;{஢ઠ 室 設   }
                   CStep:=CStep-RELength+CEPlatoOfs;

                   RoadFlat2:=RoadFlat1;{sohranim predydushee RoadFlat1}

                   {㧨  ()  }
                   XMSOffset:=300*CPlato;
                   xms_move(MRec,XMSRoadFlat,XMSoffset and $ffff,XMSoffset shr 16,
                            0,ofs(RoadFlat1),seg(RoadFlat1),300);

                   CPlatoOfs:=0;

                if CGravitation>=0 then {maybe Obj has already jumped... }
                   begin
                   {Koef N2 for jumping Obj}
                   Zk2:=(RoadFlat1.Z[1]-RoadFlat1.Z[0])/RoadFlat1.RLength;

                   if Zk1>Zk2 then {Obj's jumping instead!}
                      begin
                      With RoadFlat2 do {objects vector system = Plato's V.S.}
                           begin
                           Obj1.v21:=-v11;Obj1.v22:=-v12;Obj1.v23:=-v13;
                           Obj1.v11:=v21;Obj1.v12:=v22;Obj1.v13:=v23;
                           Obj1.v31:=v31;Obj1.v32:=v32;Obj1.v33:=v33;
                           Obj1.CGravitation:=-0.01;
                           end;
                      end;
                   end;

                   {uchet zanosa na povorotah}
                   Streif:=Streif+(RoadFlat2.b1*RoadFlat1.a1-RoadFlat2.a1*RoadFlat1.b1)*Speed;{}
                   end

                else
                    begin {६饭 砥  ⮬ }
                    {ॢ CEPlatoOfs+CStep  騩 CPlatoOfs}
                    CPlatoOfs:=(CEPlatoOfs+CStep)*RoadFlat1.RLength/RELength;
                    CStep:=0;
                    end;
{------------->}end

{1}    else {if CStep<0!}

          while CStep<0 do{६饭 設 nazad}
{------------->}begin

                With RoadFlat1 do
                begin
                RELength:=RLength-CDev*(RLength-lll)/RWidth;{Roads evaluted Length with Obj devinition "CDev"}
                CEPlatoOfs:=CPlatoOfs*RELength/RLength;{objects evaluated offset on current RoadFlat}
                end;

{^^^}           if CEPlatoOfs+CStep<0 then{᫨ "५⥫"  }
                   begin
                   {Koef for Obj's jumping}
                   Zk1:=(RoadFlat1.Z[1]-RoadFlat1.Z[0])/RoadFlat1.RLength;

                   dec(CPlato);{室  predydushemu pered }
                   if CPlato<0 then begin CPlato:=RoadFlats;dec(CLaps);end;{஢ઠ 室 設  old }
                   CStep:=CStep+CEPlatoOfs;

                   RoadFlat2:=RoadFlat1;{sohranim predydushee}

                   {㧨  ()  }
                   XMSOffset:=300*CPlato;
                   xms_move(MRec,XMSRoadFlat,XMSoffset and $ffff,XMSoffset shr 16,
                            0,ofs(RoadFlat1),seg(RoadFlat1),300);

                   CPlatoOfs:=RoadFlat1.RLength;

                if CGravitation>=0 then {maybe Obj has already jumped... }
                   begin
                   {Koef N2 for jumping Obj}
                   Zk2:=(RoadFlat1.Z[1]-RoadFlat1.Z[0])/RoadFlat1.RLength;

                   if Zk2>Zk1 then {Obj's jumping instead!}
                      begin
                      With RoadFlat2 do {objects vector system = Plato's V.S.}
                           begin
                           Obj1.v21:=-v11;Obj1.v22:=-v12;Obj1.v23:=-v13;
                           Obj1.v11:=v21;Obj1.v12:=v22;Obj1.v13:=v23;
                           Obj1.v31:=v31;Obj1.v32:=v32;Obj1.v33:=v33;
                           Obj1.CGravitation:=-0.01;
                           end;
                      end;
                   end;

                   {uchet zanosa na povorotah}
                   Streif:=Streif+(RoadFlat2.b1*RoadFlat1.a1-RoadFlat2.a1*RoadFlat1.b1)*Speed;{}
                   end

{^^^}           else
                    begin {६饭 砥  ⮬ }
                    {ॢ CEPlatoOfs+CStep  騩 CPlatoOfs}
                    CPlatoOfs:=(CEPlatoOfs+CStep)*RoadFlat1.RLength/RELength;
                    CStep:=0;
                    end;
{------------->}end;


          {Count the distance from start}
          CDistanceFromStart:=EvaluateDistanceFromStartForObj(CPlato,CPlatoOfs);{}

          {pribavim vychislennuu velichinu zanosa}
          if Obj1.CId=0 then CStreif:=CStreifSpeed+Streif;

          {ﭨ  設  ७  ⨥ ண  -६饭}
          StreifSpeed:=CStreif*Mn/CMass;
          if CGravitation>=0 then {if not falling down}
             StreifSpeed:=StreifSpeed*RoadFlat1.RFriction{};

          CStreif:=StreifSpeed;

          {Streif Collision detector}


if CMass>10 then
   if abs(CStreif)>0 then DetectStreifCollisionsWithOtherObjects(Obj1,ObjNumber)
                     else CStreif:=0;

          With RoadFlat1 do
          begin
          CurRWidth:=RWidth1+(RWidth-RWidth1)*CPlatoOfs/RLength;{⥪ ਭ   ᬥ饭   = "CPlatoOfs"}
          CDev:=CDev+CStreif;{६饭 設 }
          if abs(CDev)>=CurRWidth then{᫨ 設 堫  稭}
             begin
             CCurrentSpeed:=CCurrentSpeed/1.1;{ମ  稭}
             CStreifSpeed:=CStreifSpeed/1.1;
             if abs(CDev)>=CurRWidth+CWidth then CDev:=sgn(CDev)*(CurRWidth+CWidth);
             end;
          end;

          CGravitation:=CGravitation-g;
          CFalling:=CGravitation;

if CMass>10 then
if abs(CFalling)>0 then DetectZCollisionsWithOtherObjects(Obj1,ObjNumber)
                   else CFalling:=0;{}

FirstAmmoStep:

          {ன न  設  (    "CHeight")}
          Transform2dTo3d(CPlatoOfs,CDev,Obj1.X,Obj1.Y,Zr);
          {X & Y koordinaty mashiny na treke}
          Obj1.X:=Obj1.X+Obj1.v31*Obj1.CHeight;
          Obj1.Y:=Obj1.Y+Obj1.v32*Obj1.CHeight;
          Zr:=Zr+Obj1.v33*(Obj1.CHeight);

          Obj1.Z:=Obj1.Z+Speed*sqrt(1-Obj1.v33*Obj1.v33)*sgn(RoadFlat1.Z[1]-RoadFlat1.Z[0])+CFalling;

          if Obj1.Z<=Zr then
             begin
             Obj1.Z:=Zr;

             if Obj1.CTTL=65535 then{Damages when has falled. > 10 g => Status-=1%}
                if CGravitation>CriticalOverload then
                   DamageObj(false,Obj1,ObjNumber,abs(trunc(CGravitation/CriticalOverload)),true);

             CGravitation:=0;
             end;

          {ன  ⥬ 設   }
          if CGravitation>=0 then
             begin
             DirectTheObjAlongTheTrack;
             end;
          end;

     With RoadFlat1 do {vychisljaem koordinatu Z mashiny otnositelno treka}
          begin
          dx:=Obj1.X-X[0];
          dy:=Obj1.Y-Y[0];
          dz:=Obj1.Z-Z[0];
          Obj1.Zt:=v31*dx+v32*dy+v33*dz;
          end;{}

     if ObjNumber>=CarsOfs then if ObjNumber<CarsOfs+Cars then DoObjectsLighting;

     if Obj1.CReloadCounter>0 then dec(Obj1.CReloadCounter){dec weapon reloading counter}
                              else Obj1.COwner:=ObjNumber;{Owner=Self}

     if Obj1.CFCOllised>0 then dec(Obj1.CFCollised);{pri vrezanii vo chto-to}

     if KeyFire then
        begin
        if Obj1.CId<>0 then
           _Error('Object can not fire if it is not a car! CId<>0!');
        CarsFire(ObjNumber);
        end;

     If Obj1.CXMSPrototypeOffset=XMSRocketOffset then
        RocketsSmog(ObjNumber);

     {Save Obj to XMS}
     SaveObjToXMS(Obj1,ObjNumber);

end;


{Movement of all dynamic objects on track}
Procedure TryToMoveObjects;
var Obj:word;
begin
     {This code is for all objects movement}
     Obj:=1{CarsOfs};
     While Obj<=Objects do
           begin
           TryToMoveObj(Obj);{}
           inc(Obj);
           end;
end;



Procedure MovingCamera;Forward;

{६饭 設  }
Procedure MovingCar;
var
   FrameCnt,BTP:LongInt;
begin
     CameraInCar:=true;

     BTP:=BIOSTime;
     FrameCnt:=0;
     FPS:=0;

     repeat
     LoadObjFromXMS(Obj1,Player[OwnNetworkNumber]);{Load own car info block}

      with Obj1 do
           begin
{Interface Switches}
           if KeyMap[38] then LightTrack:=not LightTrack;{}
           if KeyMap[33] then timer:=1-timer;{FPS Counter}
           if KeyMap[20] then
              begin
              inc(TexturateMethod);
              if TexturateMethod>4 then TexturateMethod:=1;
              end;
           if KeyMap[24] then if OutCabin<3 then OutCabin:=OutCabin+1 else OutCabin:=0;
           if (KeyMap[13])and(r<200) then begin lb:=lb-10;rb:=rb+10;ub:=ub-6;db:=db+6;r:=r+12;end;
           if (KeyMap[12])and(r>12) then begin lb:=lb+10;rb:=rb-10;ub:=ub+6;db:=db-6;r:=r-12;end;

{Change weapon number}
           if KeyMap[2] then Keys[2]:=2;{Mine}
           if KeyMap[3] then Keys[2]:=3;{Rocket}
           if KeyMap[19] then Keys[2]:=19;{Robot}
{Control car}
           if KeyMap[72] then Keys[3]:=72;{Forward}
           if KeyMap[80] then Keys[3]:=80;{Backward}
           if KeyMap[57] then Keys[6]:=57;{Stop}
           if KeyMap[75] then Keys[4]:=75;{Streif left}
           if KeyMap[77] then Keys[4]:=77;{Streif right}
           if KeyMap[36] then Keys[5]:=36;{Jump}
           if KeyMap[29] then Keys[1]:=29;{Fire}
           if KeyMap[56] then Keys[5]:=56;{Shield}

{1=Fire;2=Change weapon;3=F/Bward;4=Streifs;5=Shield;6=Stop;{}

           SaveObjToXMS(Obj1,Player[OwnNetworkNumber]);{Save changed of own car}

           TestFlag:=0;
           TryToMoveObjects;{쭮 ६饭 設    ६ }

           LoadObjFromXMS(Obj1,Player[OwnNetworkNumber]);{Load own car}

           {ன     設 Obj1}
           LoadObjPrototypeInfoFromXMS(ObjPrototypeInfo1,Obj1.CXMSPrototypeOffset);
           With ObjPrototypeInfo1 do
                With Obj1 do
                     begin
                     Camera.X:=X+v11*OPViewX+v21*OPViewY+v31*OPViewZ;
                     Camera.Y:=Y+v12*OPViewX+v22*OPViewY+v32*OPViewZ;
                     Camera.Z:=Z+v13*OPViewX+v23*OPViewY+v33*OPViewZ;
                     end;
           Camera.v11:=Obj1.v11;Camera.v12:=Obj1.v12;Camera.v13:=Obj1.v13;
           Camera.v21:=Obj1.v21;Camera.v22:=Obj1.v22;Camera.v23:=Obj1.v23;
           Camera.v31:=Obj1.v31;Camera.v32:=Obj1.v32;Camera.v33:=Obj1.v33;

           if KeyMap[41] then{back to 180 grads}
              With Camera do
                   RotateVectorsSystem(270,90,90,
                                       v11,v12,v13,v21,v22,v23,v31,v32,v33);

           if OutCabin=3 then{Camera near car}
              With Camera do
                   begin
                   RotateVectorsSystem(160,110,90,
                                       v11,v12,v13,v21,v22,v23,v31,v32,v33);
                   X:=Obj1.X-v11*300+v21*1000+v31*100;
                   Y:=Obj1.Y-v12*300+v22*1000+v32*100;
                   Z:=Obj1.Z-v13*300+v23*1000+v33*100;
                   end;{}

           if OutCabin=2 then{Camera above car}
              With Camera do
                   begin
                   RotateVectorsSystem(90,120,90,
                                       v11,v12,v13,v21,v22,v23,v31,v32,v33);
                   X:=Obj1.X-v11*0+v21*500+v31*50;
                   Y:=Obj1.Y-v12*0+v22*500+v32*50;
                   Z:=Obj1.Z-v13*0+v23*500+v33*50;
                   end;

           if OutCabin=1 then{Camera above car}
              With Camera do
                   begin
                   X:=Obj1.X-v11*(Obj1.CWidth+20)+v21*0+v31*0;
                   Y:=Obj1.Y-v12*(Obj1.CWidth+20)+v22*0+v32*0;
                   Z:=Obj1.Z-v13*(Obj1.CWidth+20)+v23*0+v33*0;
                   end;


           fillchar(vp^,64000,0);{}
if TexturateMethod<>3 then
   begin
   fillchar(ZB[0]^,64000,$FF);
   fillchar(ZB[1]^,64000,$FF);{}
   fillchar(ZB[2]^,64000,$FF);
   fillchar(ZB[3]^,64000,$FF);{}
   end
else
    begin
    fillchar(ZB[0]^,64000,0);
    fillchar(ZB[1]^,64000,0);{}
    fillchar(ZB[2]^,64000,0);
    fillchar(ZB[3]^,64000,0);{}
    end;

           {Set some screen params}
           Mub:=Ub;Mdb:=Db;
           for i:=Ub to Db do begin MLbd[i]:=Lb;MRbd[i]:=Rb;end;{Fill the screen bounds}

           ShowTrack3D(Obj1.CPlato);{}

           if LightTrack then DoLight;

           LoadObjFromXMS(Obj1,Player[OwnNetworkNumber]);{Load own cars info for show it up}
           ShowStatusInfo(FrameCnt,BTP);

           move(vp^,mem[$a000:0],64000);{}

           if (KeyMap[46])or(GameOver>0) then
              MovingCamera;
           end;

     until keyMap[sEsc];
end;


{=================CAMERA=====================================================}

Procedure IncreaseCamerasAngle(du1,du2,du3:integer);
begin
     With Camera do
     begin
     inc(AngleX,du1);if abs(AngleX)>MaxAngle then AngleX:=sgnl(AngleX)*MaxAngle;
     inc(AngleY,du2);if abs(AngleY)>MaxAngle then AngleY:=sgnl(AngleY)*MaxAngle;
     inc(AngleZ,du3);if abs(AngleZ)>MaxAngle then AngleZ:=sgnl(AngleZ)*MaxAngle;
     end;
end;

Procedure MoveCameraByVector(dv1,dv2,dv3:longint);
begin
     With Camera do
     begin
     inc(SpeedX,dv1);if abs(SpeedX)>MaxSpeed then SpeedX:=sgnl(SpeedX)*MaxSpeed;
     inc(SpeedY,dv2);if abs(SpeedY)>MaxSpeed then SpeedY:=sgnl(SpeedY)*MaxSpeed;
     inc(SpeedZ,dv3);if abs(SpeedZ)>MaxSpeed then SpeedZ:=sgnl(SpeedZ)*MaxSpeed;
     end;
end;

{Auto camera's movements. Directed to Object number "Player[OwnNetworkNumber]"}
Procedure CameraBot;
var
   dx,dy,dz:double;
   a,b,c:double;
   i:byte;
begin
     Camera.MaxSpeed:=round(Obj1.CCurrentSpeed);
     for i:=1 to $7F do KeyMap[i]:=false;{}

     LoadObjFromXMS(Obj2,Player[OwnNetworkNumber]);
     dx:=Obj2.X-Camera.X;dy:=Obj2.Y-Camera.Y;dz:=Obj2.Z-Camera.Z;

     With Camera do
          begin
          a:=v11*dx+v12*dy+v13*dz;
          b:=v21*dx+v22*dy+v23*dz;
          c:=v31*dx+v32*dy+v33*dz;
          end;

        if dz>10 then KeyMap[74]:=true;
        if dz<10 then KeyMap[78]:=true;


     if b<500 then
        begin
        KeyMap[17]:=true;
        if a<0 then KeyMap[75]:=true
               else KeyMap[77]:=true;

{        if c>0 then KeyMap[16]:=true
               else KeyMap[18]:=true;{}
        end
     else begin KeyMap[30]:=true;KeyMap[77]:=true;end;

     if GameOver>0 then
        begin
        dec(GameOver);
        if GameOver=0 then begin AutoCamera:=0;for i:=1 to $7F do KeyMap[i]:=false;end;
        end;

     if KeyMap[75] then AutoTest:='Left';
     if KeyMap[77] then AutoTest:='Right';
     if KeyMap[16] then AutoTest:=AutoTest+':Up';
     if KeyMap[18] then AutoTest:=AutoTest+':Down';
end;



{६饭    3 ࠭}
Procedure MovingCamera;
var
    i:integer;
    FrameCnt,BTP:LongInt;
begin
     AutoCamera:=0;
     CameraInCar:=false;

     with Camera do
     begin
     BTP:=BIOSTime;
     FrameCnt:=0;
     FPS:=0;
     repeat
           {THIS IS THE FRICTINAL MECHANIZM OF CAMERA}
{============================================================================}
{}         if abs(SpeedX)>=Acceleration then SpeedX:=sgnl(SpeedX)*(abs(SpeedX)-FrictionSpeed)
                                        else SpeedX:=0;
{}         if abs(SpeedY)>=Acceleration then SpeedY:=sgnl(SpeedY)*(abs(SpeedY)-FrictionSpeed)
                                        else SpeedY:=0;
{}         if abs(SpeedZ)>=Acceleration then SpeedZ:=sgnl(SpeedZ)*(abs(SpeedZ)-FrictionSpeed)
                                        else SpeedZ:=0;
{}         if abs(AngleX)>=DeltaAngle then AngleX:=sgnl(AngleX)*(abs(AngleX)-FrictionAngle)
                                      else AngleX:=0;
{}         if abs(AngleY)>=DeltaAngle then AngleY:=sgnl(AngleY)*(abs(AngleY)-FrictionAngle)
                                      else AngleY:=0;
{}         if abs(AngleZ)>=DeltaAngle then AngleZ:=sgnl(AngleZ)*(abs(AngleZ)-FrictionAngle)
                                      else AngleZ:=0;
{============================================================================}

           if KeyMap[35] then HideAll:=1-HideAll;

           if KeyMap[33] then timer:=1-timer;{FPS counter}

           if KeyMap[19] then AutoCamera:=1-AutoCamera;

           if KeyMap[20] then
              if TexturateMethod>2 then TexturateMethod:=1
                                   else inc(TexturateMethod);

           if KeyMap[38] then LightTrack:=not LightTrack;{}

           if (AutoCamera=1)or(GameOver>0) then CameraBot;

           if KeyMap[75] then IncreaseCamerasAngle(-DeltaAngle,0,0);
           if KeyMap[77] then IncreaseCamerasAngle(DeltaAngle,0,0);
           if KeyMap[16] then IncreaseCamerasAngle(0,-DeltaAngle,0);
           if KeyMap[18] then IncreaseCamerasAngle(0,DeltaAngle,0);
           if KeyMap[71] then IncreaseCamerasAngle(0,0,-DeltaAngle);
           if KeyMap[73] then IncreaseCamerasAngle(0,0,DeltaAngle);

           if KeyMap[41] then{turn on 180 grads}
              With Camera do
                   RotateVectorsSystem(270,90,90,v11,v12,v13,v21,v22,v23,v31,v32,v33);

           RotateVectorsSystem(90+AngleX,90+AngleY,90+AngleZ,v11,v12,v13,v21,v22,v23,v31,v32,v33);

           if KeyMap[74] then MoveCameraByVector(0,0,Acceleration);
           if KeyMap[78] then MoveCameraByVector(0,0,-Acceleration);
           if KeyMap[17] then MoveCameraByVector(0,-Acceleration,0);
           if KeyMap[31] then MoveCameraByVector(0,Acceleration,0);
           if KeyMap[30] then MoveCameraByVector(-Acceleration,0,0);
           if KeyMap[32] then MoveCameraByVector(Acceleration,0,0);

           {Real camera's movement}
           X:=X+v11*SpeedX+v21*SpeedY+v31*SpeedZ;
           Y:=Y+v12*SpeedX+v22*SpeedY+v32*SpeedZ;
           Z:=Z+v13*SpeedX+v23*SpeedY+v33*SpeedZ;

           if (KeyMap[13])and(r<200) then begin lb:=lb-10;rb:=rb+10;ub:=ub-6;db:=db+6;r:=r+12;end;
           if (KeyMap[12])and(r>12) then begin lb:=lb+10;rb:=rb-10;ub:=ub+6;db:=db-6;r:=r-12;end;{}

           TryToMoveObjects;{쭮 ६饭 設    ६ = }

           fillchar(vp^,64000,0);{}
if TexturateMethod<>3 then
   begin
   fillchar(ZB[0]^,64000,$FF);
   fillchar(ZB[1]^,64000,$FF);{}
   fillchar(ZB[2]^,64000,$FF);
   fillchar(ZB[3]^,64000,$FF);{}
   end
else
    begin
    fillchar(ZB[0]^,64000,0);
    fillchar(ZB[1]^,64000,0);{}
    fillchar(ZB[2]^,64000,0);
    fillchar(ZB[3]^,64000,0);{}
    end;
           {Set some screen params}
           Mub:=Ub;Mdb:=Db;
           for i:=Ub to Db do begin MLbd[i]:=Lb;MRbd[i]:=Rb;end;{Fill the screen bounds}

           if HideAll=0 then ShowTrack3D(Obj1.CPlato);{}

           if LightTrack then DoLight;

           LoadObjFromXMS(Obj1,Player[OwnNetworkNumber]);{Load own car info for show it up}
           ShowStatusInfo(FrameCnt,BTP);

           move(vp^,mem[$a000:0],64000);{}

     until (keyMap[sEsc]) or (KeyMap[46]);
     end;
end;


{====================OBJECTS & ACTIONS=======================================}
Procedure CreatTheCamera(_X,_Y,_Z:double;
                         _Sector:word;
                         _MaxSpeed:longint;
                         _Acceleration:longint;
                         _MaxAngle:integer;
                         _DeltaAngle:integer;
                         _FrictionSpeed:longint;
                         _FrictionAngle:integer
                         );
begin
     with Camera do
          begin
          X:=_X;Y:=_Y;Z:=_Z;
          Sector:=_Sector;
          InitVectorsSystem(v11,v12,v13,v21,v22,v23,v31,v32,v33);
          MaxSpeed:=_MaxSpeed;
          SpeedX:=0;SpeedY:=0;SpeedZ:=0;
          Acceleration:=_Acceleration;
          MaxAngle:=_MaxAngle;
          AngleX:=0;AngleY:=0;AngleZ:=0;
          DeltaAngle:=_DeltaAngle;
          FrictionSpeed:=_FrictionSpeed;
          FrictionAngle:=_FrictionAngle;
          end;
end;





Procedure AllocateNeededBasedMemory;
var s:string;
begin
     MemoryStatus:=0;
     msg_(0,7,0,'Allocating needed based memory :');

     msg_(3,8,0,'Had '+Itos(maxavail)+' bytes free.');

     msg_(3,8,0,'Z-Buffer: 4 segments x 64000 bytes (32 = 23bit integral : 9bit float)');
     For i:=0 to 3 do
{1}      if maxavail>=sizeof(ZBuffer) then new(ZB[i])
          else _Error('Not enough based memory for '+itos(i)+'segment of Zbuffer!');
     inc(MemoryStatus);

{2} msg_(3,8,0,'Visual page: '+Itos(sizeof(VideoBuffer))+' bytes.');
     if maxavail>=sizeof(VideoBuffer) then begin new(Vp);inc(MemoryStatus);end
     else _Error('Not enough based memory for videobuffer!');

{3} msg_(3,8,0,'Texture buffer: '+Itos(sizeof(TextureBuffer))+' bytes.');
     if maxavail>=sizeof(TextureBuffer) then begin new(Tx);inc(MemoryStatus);end
     else _Error('Not enough based memory for textures buffer!');

{4} msg_(3,8,0,'Light table: '+Itos(sizeof(LightBuffer))+' bytes.');
     if maxavail>=sizeof(LightBuffer) then begin new(Lt);inc(MemoryStatus);end
     else _Error('Not enough based memory for light buffer!');

{5} msg_(3,8,0,'Font: '+Itos(sizeof(LettersBuffer))+' bytes.');
     if maxavail>=sizeof(LettersBuffer) then begin new(Letters);inc(MemoryStatus);end
     else _Error('Not enough based memory for Font!');

     MemoryStatus:=13;
     msg_(3,8,0,'Remaineder '+Itos(maxavail)+' bytes free.');
end;

{=============================CONFIG==========================================}

Procedure CreatNewConfig(var ConfigFileName:string);
var f:text;
begin
     assign(f,ConfigFileName);rewrite(f);
     writeln(f,'%Death Track configurationg file. Created by SER 2000 year.');
     writeln(f,'%U can change it for your needs.');
     writeln(f,'');
     writeln(f,'ObjectsVectorPrototypesBlockSize=100Kb');
     writeln(f,'MaxRoadSegments=100segments');
     close(f);
end;

Procedure ReadConfig(var ConfigFileName:string);
var f:text;
    VarStatus:byte;
    j:byte;
begin
     ConfigFileName:=fsearch(ConfigFileName,getenv('path'));
     if ConfigFileName='' then
        begin
        CreatNewConfig(ConfigFileName);
        _Error('Configuration was not found!'+
         #13#10'System has created new config file "'+ConfigFileName+'"'+
         #13#10'Run Death Track program again!');
        end;

     assign(f,ConfigFileName);reset(f);
     VarStatus:=3;
     while not eof(f) do
           begin
           readln(f,strg);j:=1;
           DelEmptySlotsInStr(strg);
           if strg<>'' then
              if strg[1]<>'%' then
                 begin
                 if LowerCase(copy(strg,1,33))='objectsvectorprototypesblocksize=' then
                    begin
                    VarStatus:=VarStatus xor 1;j:=34;
                    ObjectsVectorPrototypesBlockSize:=trunc(GetValue(j,strg,0,0,''));
                    end;
                 if LowerCase(copy(strg,1,16))='maxroadsegments=' then
                    begin
                    VarStatus:=VarStatus xor 2;j:=17;
                    MaxRoadSegments:=trunc(GetValue(j,strg,0,0,''));
                    end;

                 end;
           end;
     close(f);

     if VarStatus<>0 then
        begin
        CreatNewConfig(ConfigFileName);
        _Error('Configuration was not complete, becaurse config file is wrong!'+
         #13#10'System has created new config file "'+ConfigFileName+'"'+
         #13#10'Run Death Track program again!');
        end;

end;


{樠  ࠬ஢}
Procedure InitParams(ConfigFileName:string);
var i,j:integer;
    g,c:integer;
    Color,Gradation:byte;
begin
     msg_(0,7,0,'Initializing :');

     msg_(3,8,0,'Testing main and numeric processors...');
     if Test8086<2 then _Error('80386 processor must be at least!');
     if Test8087<3 then _Error('80387 numeric processor must be at least!');
     msg_(3,8,0,'Looking for VGA card...');
     if not VGAcard then _Error('Hmm... That''s fun you have no VGA card! Impossible...');

     msg_(3,8,0,'Using configuration file "'+ConfigFileName+'".');
     ReadConfig(ConfigFileName);

     msg_(3,8,0,'Important variables.');

     {Test variables. Delete when tested!}
     _CarNumber:=0;
     HideAll:=0;

     Lites:=1;
     For i:=1 to Lites do
         begin
         Lights[i].X:=1000;
         Lights[i].Y:=0;
         Lights[i].Z:=1000;
         Lights[i].StaI:=1*10000000;{!!!Light}
         Lights[i].CurI:=Lights[i].StaI;{!!!Light}
         Lights[i].FinI:=9*10000000;{!!!Light}
         Lights[i].StepI:=1*1000000;{!!!Light}
         end;
     LightTrack:=false;

     R:=200;k4:=R/20;
     ScreenX:=160;ScreenY:=100;

     {Screen bounders}
     lb:=(200-round(r))*10 div 12;
     rb:=319-lb;
     ub:=(200-round(r))*6 div 12;
     db:=199-ub;

     {Optional}
     TexturateMethod:=3;
     CameraInCar:=true;
     Timer:=1;
     OutCabin:=0;
     GameOver:=0;

     msg_(3,8,0,'Creating SinusTable.');
     for i:=0 to 359 do
         sn[i]:=sin(pi/180*i);

     msg_(3,8,0,'Evaluating 16 gradational LightTable.');

     {Structures size checkings}
     msg_(3,8,0,'Checking sizes of some structures...');
     if sizeof(RoadFlat)<>300 then
        _Error('RoadFlat size = '+itos(sizeof(RoadFlat))+' ! - Need to be 300.');

     if sizeof(ObjRecord)<>300 then
        _Error('ObjRecord size = '+itos(sizeof(Objrecord))+' ! - Need to be 300.');

     if sizeof(ObjPrototypeInfo)<>256 then
        _Error('ObjPrototypeInfo size = '+itos(sizeof(ObjPrototypeInfo))+' ! - Need to be 256.');

     if sizeof(ObjPrototypePoligon)<>100 then
        _Error('ObjPrototypePoligon size = '+itos(sizeof(ObjPrototypePoligon))+' ! Against 100.');

     if sizeof(EngineRecord)<>42 then
        _Error('EngineRecord size = '+itos(sizeof(EngineRecord))+' ! - Need to be 42.');

     {}
     msg_(3,8,0,'Creating some objects&structures:');

     msg_(6,8,0,'Engines...');
     {Creating 3 engine types}
     With NoEngine do
          begin
          EMaxSpeed:=0;
          EAcceleration:=0;
          EMaxStreif:=0;
          EStreifAcceleration:=0;
          EFriction:=5;
          EDamage:=0;
          end;
     With SimpleEngine do
          begin
          EMaxSpeed:=100;
          EAcceleration:=10;
          EMaxStreif:=100;
          EStreifAcceleration:=10;
          EFriction:=5;
          EDamage:=100;
          end;
     With SuperEngine do
          begin
          EMaxSpeed:=150;
          EAcceleration:=15;
          EMaxStreif:=150;
          EStreifAcceleration:=15;
          EFriction:=5;
          EDamage:=100;
          end;
     With HyperUltraEngine do
          begin
          EMaxSpeed:=200;
          EAcceleration:=20;
          EMaxStreif:=200;
          EStreifAcceleration:=20;
          EFriction:=5;
          EDamage:=100;
          end;

     {Creating the Camera object}
     CreatTheCamera(0,0,30,0,150,10,10,2,5,1);

     With Camera do RotateVectorsSystem(90,90,90,v11,v12,v13,v21,v22,v23,v31,v32,v33);{---}

{Camera.X:=278.87539;Camera.Y:=-651.02179;Camera.Z:=120.61685;
Camera.v11:=-0.68712;Camera.v12:=0.70541;Camera.v13:=0.17400;
Camera.v21:=-0.72650;Camera.v22:=-0.66991;Camera.v23:=-0.15304;
Camera.v31:=0.00861;Camera.v32:=-0.23156;Camera.v33:=0.97278;{}

end;

{㦠 }
Procedure LoadAll;
var Obj:ObjRecord;
begin
     msg_(0,7,0,'Looking for extended memory:');
     if XMSInstalled = 0 then _Error('Your computer has no extended memory!');
     if HimemInstalled then msg_(3,8,0,'HIMEM.SYS is installed.')
                       else _Error('HIMEM.SYS is not installed!');
     msg_(3,8,0,'Maximum free XMS memory block has '+itos(XMSLargest)+' Kb');

     msg_(0,7,0,'Loading all needed data:');

     LoadFont('Font.fnt');

{14} LoadTextures('textures.3dm');{Patches:=100;{}

{15} msg_(3,8,0,'Allocating block for Objects Vector Prototypes: '+itos(ObjectsVectorPrototypesBlockSize)+' Kb');
     GetXMS(XMSObjectsPrototypes,ObjectsVectorPrototypesBlockSize);
     if XMMError=0 then inc(MemoryStatus)
                   else _Error('Not enough XMS memory for OVP!');

     LoadNeccessaryPrototypes;

{16} msg_(3,8,0,'Allocating block for Objects Data: '+itos(MaxObjects*sizeof(ObjRecord) div 1024+1)+' Kb');
     GetXMS(XMSObjects,MaxObjects*sizeof(ObjRecord) div 1024+1);
     if XMMError=0 then inc(MemoryStatus)
                   else _Error('Not enough XMS memory for OD!');
     Fillchar(Obj,sizeof(Obj),0);
     Obj.CId:=255;
     for objects:=1 to MaxObjects do
         SaveObjToXMS(Obj,Objects);

{17} msg_(3,8,0,'Allocating needed XMS memory for track data: '+itos(MaxRoadSegments*sizeof(RoadFlat) div 1024+1)+' Kb');

     GetXMS(XMSRoadFlat,MaxRoadSegments*sizeof(RoadFlat) div 1024+1);
     if XMMError<>0 then _Error('Can not allocate extended memory for track data!');
     inc(MemoryStatus);{MemoryStatus=17}

     LoadTrack(paramstr(1));
end;
{============================================================================}

Procedure PlayGame;
begin
     {For singal game}
     Players:=1;
     OwnNetworkNumber:=1;
     Player[OwnNetworkNumber]:=CarsOfs;
     Init13h;
     WaitForACSReleased;
     Set_Handler;

     if CameraInCar then MovingCar else MovingCamera;{}
     Remove_Handler;
end;

BEGIN

clrscr;
randomize;
msg_(20,9,0,'Death Track game v1.0 1999 by SER');
AllocateNeededBasedMemory;
InitParams('DTrack.cfg');
LoadAll;
PlayGame;
_Error('Death Track.');
end.