{$A+,B-,D+,E-,F-,G-,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+}
{$M 16384,0,655360}
uses crt,dos;
Label Escape;
const
     Header3DM:string='-3D MAP FILE,USED BY SERs ENGINE AS MAP-';
     ScreenWidth=320;
     ScreenHeight=200;
type
    Large=array[0..63999] of byte;
    Header=array[0..128] of byte;
var
   PcxHeader:^Header;
   buffer,swp:^Large;
   plt:array[0..767] of byte;
   PathToPCX,PathTo3DM,First3DM:string;
   X1,Y1,X2,Y2,Xt,Yt:longint;
   s,pero,PatchName:string;
   X,Y,stepX,stepY:word;
   sizeX,sizeY:word;
   ch,ch1,ch2:char;
   onWork:byte;
   Patches,Fsize,PatchesSize:longint;
   Sectors,Size:word;
   AfterPatch:longint;
   Color:byte;
   i,j,k:longint;


procedure msg(beginPos,col,backcolor:word;strg:string);
begin
textbackground(0);
write(' ':beginPos);
textcolor(col);
textbackground(backcolor);
write(strg);
end;

procedure msg_(beginPos,color,backcolor:word;strg:string);
begin
msg(beginPos,color,backcolor,strg);
writeln;
end;


procedure _Error(strg:string);
begin
     textcolor(7);
     write(strg);
     dispose(PcxHeader);
     dispose(buffer);
     dispose(swp);
     halt(1);
end;

Function ItoS(i:longint):string;
var s:string;
begin
     str(i,s);
     ItoS:=s;
end;

{Makes chars in Lower case}
Function LowerCase(s:string):string;
var j:byte;
begin
     for j:=1 to length(s) do
         if s[j] in ['A'..'Z'] then s[j]:=chr(ord(s[j])+32);
     LowerCase:=s;
end;


procedure ShowBuffer;
begin
     move(buffer^,mem[$a000:0],sizeOf(Buffer^));
end;

Procedure ShowBar(X1,Y1,X2,Y2:integer);
var i:word;
begin
     fillchar(mem[$a000:Y1*320+X1],X2-X1,255);
     fillchar(mem[$a000:Y2*320+X1],X2-X1,255);
     for i:=Y1 to Y2 do
         begin
         fillchar(mem[$a000:i*320+X1],1,255);
         fillchar(mem[$a000:i*320+X2],1,255);
         end;
end;

Procedure ShowCoordinates(X1,Y1,X2,Y2:integer);
begin
     directvideo:=false;
     gotoxy(1,1);write(X1,',',Y1,':',X2,',',Y2);
     directvideo:=true;
end;

Procedure Init13h;
var i:byte;
begin
     asm mov  ax,13h;int  10h;end;
     for i:=0 to 255 do
         begin
         port[$3c8]:=i;
         port[$3c9]:=plt[i*3];
         port[$3c9]:=plt[i*3+1];
         port[$3c9]:=plt[i*3+2];
         end;
end;

{Incoming: plt - current pictures palette, swp^ - those to quantanize}
Procedure QuantanizePalette;
var i,j:word;
    reverse:array[0..255] of byte;
    r1,g1,b1,r2,g2,b2,ColNum:byte;
    d,MinD:double;{Hehe... is it so cool for that problem?}
begin
     for i:=0 to 255 do
         begin
         r1:=plt[i*3];
         g1:=plt[i*3+1];
         b1:=plt[i*3+2];
         MinD:=255*255*255+1;ColNum:=0;
         for j:=0 to 255 do
             begin
             r2:=swp^[j*3+length(Header3DM)];
             g2:=swp^[j*3+1+length(Header3DM)];
             b2:=swp^[j*3+2+length(Header3DM)];

             d:=sqr(r1-r2)+sqr(g1-g2)+sqr(b1-b2);
             if d<MinD then begin MinD:=d;ColNum:=j;end;
             if MinD=0 then break;
             end;

             reverse[i]:=ColNum
{             if ColNum>0 then reverse[i]:=ColNum
                         else reverse[i]:=1;{}

         end;
     {Reverse the buffer of image}
     for i:=0 to 63999 do
         buffer^[i]:=reverse[buffer^[i]];
end;

procedure LoadPCX;
var
   b,data:byte;
   j,sum:word;
   i:byte;
   f:file;
begin
     msg_(5,8,0,'Looking for PCX file "'+PathToPCX+'"...');
     if FSearch(PathToPcx,GetEnv('PATH'))='' then _Error('Mistake: File not found !');
     msg_(5,7,0,'Loading PCX : '+PathToPCX+'...');
     fillchar(buffer^,sizeOf(buffer^),0);
     assign(f,PathToPCX);
     reset(f,1);
     blockread(f,PcxHeader^,128);
     X1:=PcxHeader^[4]+PcxHeader^[5] shl 8;
     Y1:=PcxHeader^[6]+PcxHeader^[7] shl 8;
     X2:=PcxHeader^[8]+PcxHeader^[9] shl 8;
     Y2:=PcxHeader^[10]+PcxHeader^[11] shl 8;
     if Y1>199 then exit;
     if Y2>199 then Y2:=199;
     if X1>319 then exit;
     if X2>319 then X2:=319;
     Xt:=X2-X1+1;
     Yt:=Y2-Y1+1;

     Y:=Y1;
     while (Y<=Y2) do
           begin
           X:=X1;
           while X<=X2 do
                 begin
                 blockread(f,b,1,sum);
                 if b>191 then
                    begin
                    blockread(f,data,1,sum);
                    for i:=b-192 downto 1 do
                        begin
                        buffer^[word(Y*320+X)]:=data;{}
                        inc(X);
                        end;
                    end
                    else
                        begin
                        buffer^[word(Y*320+X)]:=b;{}
                        inc(X);
                        end;
                 end;
           inc(Y);
           end;
     seek(f,filesize(f)-768);{}
     blockread(f,plt,768,sum);
     for i:=0 to 255 do
         begin
         plt[i*3]:=plt[i*3] div 4;
         plt[i*3+1]:=plt[i*3+1] div 4;
         plt[i*3+2]:=plt[i*3+2] div 4;
         end;
end;

Procedure SaveAsBuf(Bufname:string);
var
   f:file;
begin
     Textmode(LastMode);
     msg_(0,7,0,'Saving picture 320x200 as "'+BufName+'"...');
     assign(f,Bufname);
     rewrite(f,1);
     blockwrite(f,buffer^,sizeOf(Buffer^));
     blockwrite(f,plt,768);
     close(f);
     _Error('');
end;

Procedure SaveAsDump(DumpName:string);
var
   f:file;
begin
     Textmode(LastMode);
     msg_(0,7,0,'Saving picture as "'+DumpName+'"...');
     assign(f,DumpName);
     rewrite(f,1);
     blockwrite(f,buffer^,(Y2-Y1+1)*(X2-X1+1));
     close(f);
     _Error('');
end;

{Creating new file in order of PthName and saving to it Header and Palette}
Procedure CreatNew3DMFile(Name3DM:string);
var
   f:file;
   i,b:byte;
begin
     msg_(5,7,0,'Creating new 3DM file: '+Name3DM+'...');
     Patches:=0;
     PatchesSize:=0;
     FSize:=1000;
     Sectors:=0;

     assign(f,Name3DM);
     rewrite(f,1);
     {Saving Header}
     for i:=1 to length(Header3DM) do
         begin
         b:=ord(Header3DM[i]);
         blockwrite(f,b,1);
         end;
     blockwrite(f,plt,768); {Saving palette}
     blockwrite(f,Patches,4); {Patches number}
     blockwrite(f,PatchesSize,4); {Size of Patches block}
     blockwrite(f,FSize,4);       {File size}
     blockwrite(f,Sectors,2);     {Sectors in 3DM}
     b:=0;                        {And other yet unused info}
     for i:=1 to 178 do
         blockwrite(f,b,1);
     close(f);
end;

{Checking 3DM Files format and loading palette to PLT[768] +
counting Number of patches to "Patches"}
Function Check3DM(Name3dm:string;var Patches:longint;WithOutPalette:boolean):boolean;
var
    message,strg:string;
    b,i:byte;
    f:file;
begin
     Check3DM:=true;
     message:='Cant recognize "'+Name3dm+'" as valid 3DM file!';
     if FSearch(Name3dm,GetEnv('PATH'))='' then begin msg_(5,4,0,'File "'+Name3dm+'" is not found !');Check3DM:=false;exit;end;
     msg_(5,8,0,'Checking "'+Name3dm+'" by 3DM format...');
     assign(f,Name3dm);
     reset(f,1);
     if filesize(f)<length(Header3DM) then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
     {Reading Header}
     strg:='';
     for i:=1 to length(Header3DM) do
         begin blockread(f,b,1);strg:=strg+chr(b);end;
     if strg<>Header3DM then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
     if not WithOutPalette then
        begin
        blockread(f,plt,768,Size);
        if Size<768 then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
        end
     else seek(f,length(Header3DM)+768);
     blockread(f,Patches,4,Size);if Size<4 then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
     blockread(f,PatchesSize,4,Size);if Size<4 then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
     blockread(f,Fsize,4,Size);if Size<4 then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
     blockread(f,Sectors,2,Size);if Size<2 then begin msg_(5,4,0,message);Check3DM:=false;exit;end;
     if filesize(f)<>Fsize then begin msg_(5,4,0,'ERROR: File is cutted!');Check3DM:=false;exit;end;
     close(f);
end;


{Add new patch "PatchName" to existing 3DM file in order of patchbar}
Procedure AddPatchTo3DM(Name3DM:string;PatchName:string;X1,Y1,X2,Y2:integer;AfterPatch:longint);
var
   f,g:file;
   i,dx,dy:word;
   b:byte;
   Patch:longint;
begin
     if not Check3DM(Name3DM,Patches,true) then exit;
     msg_(5,7,0,'Adding picture to file "'+Name3DM+'" ...');
     assign(f,Name3DM);reset(f,1);
     assign(g,'CBAn4uK.swp');rewrite(g,1);
     blockread(f,swp^,length(Header3DM)+768);

     QuantanizePalette;{palette synhronization}

     blockwrite(g,swp^,length(Header3DM)+768);
     {+1 patche}
     blockread(f,Patches,4);
     inc(Patches);
     blockwrite(g,Patches,4);
     dec(Patches);
     {+PatchesSize}
     blockread(f,PatchesSize,4);
     inc(PatchesSize,8+2+2+(X2-X1+1)*(Y2-Y1+1));
     blockwrite(g,PatchesSize,4);
     dec(PatchesSize,8+2+2+(X2-X1+1)*(Y2-Y1+1));
     {+File Size}
     blockread(f,FSize,4);
     FSize:=FSize+longint(12{=8+2+2})+longint(X2-X1+1)*longint(Y2-Y1+1);
     blockwrite(g,FSize,4);
     {Sectors=Sectors}
     blockread(f,Sectors,2);
     blockwrite(g,Sectors,2);
     {Saving reserved 178 bytes}
     blockread(f,swp^,178);
     blockwrite(g,swp^,178);

     {move existing patches from F-file to G-file}
     Patch:=0;if AfterPatch<0 then AfterPatch:=Patches-1;
     while Patch<Patches do
           begin
           {Reading name of Patch. Writing name}
           blockread(f,swp^,8);blockwrite(g,swp^,8);
           {Reading size of this Patch. Writing sizes}
           blockread(f,sizeX,2);blockwrite(g,sizeX,2);
           blockread(f,sizeY,2);blockwrite(g,sizeY,2);
           {Reading patch. Writing patch}
           blockread(f,swp^,longint(sizeX*sizeY),Size);blockwrite(g,swp^,Size);

           {insert new patch after patch number "AfterPatch"}
           if Patch=AfterPatch then
              begin
              {Saving Patch name}
              insert('        ',PatchName,Length(PatchName)+1);
              for i:=1 to 8 do
                  begin
                  b:=ord(PatchName[i]);
                  blockwrite(g,b,1);
                  end;
              {Saving sizes}
              dx:=word(X2-X1+1);dy:=word(Y2-Y1+1);
              blockwrite(g,dx,2);
              blockwrite(g,dy,2);
              {Saving picture (or patch)}
              for i:=Y1 to Y2 do
                  blockwrite(g,buffer^[i*320+X1],dx);
              end;

           inc(Patch);
           end;

{It was recently}
(*
     while PatchesSize>0 do
           begin
           if PatchesSize>=64000 then Size:=64000
                                else Size:=PatchesSize;
           blockread(f,swp^,Size);
           blockwrite(g,swp^,Size);
           dec(PatchesSize,Size);
           end;
     {---------------Saving new patch----------------}
     {Saving Patch name}
     insert('        ',PatchName,Length(PatchName)+1);
     for i:=1 to 8 do
         begin
         b:=ord(PatchName[i]);
         blockwrite(g,b,1);
         end;
     {Saving sizes}
     dx:=word(X2-X1+1);dy:=word(Y2-Y1+1);
     blockwrite(g,dx,2);
     blockwrite(g,dy,2);
     {Saving picture (or patch)}
     for i:=Y1 to Y2 do
         blockwrite(g,buffer^[i*320+X1],dx);
*)
     {------------ Move MAP structure of F-file to G-file -------}
     Size:=1;
     while Size>0 do
           begin
           blockread(f,swp^,sizeOf(swp^),Size);
           blockwrite(g,swp^,Size);
           end;
     close(f);close(g);
     erase(f);rename(g,Name3DM);
     if AfterPatch>Patches then msg_(0,4,0,'Patch was not added! Cause the entered number was greater than '+Itos(Patches));
end;

Procedure RemovePatch(Name3DM,PatchName:string);
var
   dPatchName:string;
   b:byte;
   sizeX,sizeY:word;
   f,g:file;
   flag:byte;
   i:word;
   PictureSize,DelPatches:longint;
begin
     if not Check3DM(Name3DM,Patches,false) then exit;
     {Adding extra ' ' to PatchName 'caurse need to make the length=8}
     if Length(PatchName)<8 then for i:=Length(PatchName)+1 to 8 do
                                     PatchName:=PatchName+' ';
     msg_(5,7,0,'Looking patch "'+PatchName+'" in file "'+Name3DM+'"...');

     assign(f,Name3DM);assign(g,'CBAn4uK.swp');
     reset(f,1);rewrite(g,1);
     {rewriting Header}
     blockread(f,swp^,1000);
     blockwrite(g,swp^,1000);
     {move existing patches from F-file to G-file}
     flag:=0;
     PictureSize:=0;DelPatches:=0;
     while Patches>0 do
           begin
           {Reading name of Patch}
           dPatchName:='';
           for i:=1 to 8 do
               begin
               blockread(f,b,1);
               dPatchName:=dPatchName+chr(b);
               end;
           {Reading size of this Patch}
           blockread(f,sizeX,2);
           blockread(f,sizeY,2);
           {Reading patch}
           for i:=0 to sizeY-1 do
               blockread(f,Buffer^[word(i*320)],sizeX,Size);

           if PatchName=dPatchName then
              begin
              flag:=1;
              msg_(5,7,0,'Patch called as "'+PatchName+'" was found! Removing it ...');
              PictureSize:=PictureSize+8+4+sizeX*sizeY;
              inc(DelPatches);
              end
           else begin
                {Saving Patch Name}
                for i:=1 to 8 do
                    begin
                    b:=ord(dPatchName[i]);
                    blockwrite(g,b,1);
                    end;

                {Saving size of this Patch}
                blockwrite(g,sizeX,2);
                blockwrite(g,sizeY,2);
                {Saving patch}
                for i:=0 to sizeY-1 do
                    blockwrite(g,Buffer^[word(i*320)],sizeX);
                end;
           dec(Patches);
           end;
     {MAP block in file}
     Size:=1;
     while Size>0 do
           begin
           blockread(f,swp^,sizeOf(swp^),Size);
           blockwrite(g,swp^,Size);
           end;
     close(f);close(g);
     erase(f);rename(g,Name3DM);
if flag=0 then msg_(5,7,0,'Such patch doesnt exist in this file !')
          else begin
               filemode:=2;
               assign(g,Name3DM);reset(g,1);
               seek(g,808);
               blockread(g,Patches,4);
               blockread(g,PatchesSize,4);
               blockread(g,FSize,4);
               {FSize has yet loaded!}

               if Patches>0 then dec(Patches,DelPatches);
               dec(PatchesSize,PictureSize);
               dec(FSize,PictureSize);{}
               seek(g,808);
               blockwrite(g,Patches,4);
               blockwrite(g,PatchesSize,4);
               blockwrite(g,FSize,4);
               close(g);
               msg_(5,7,0,'Patch(es) was/were removed !');
               end;
end;

Procedure DeletePatch(Name3DM:string;StaPatchNum,FinPatchNum:longint);
var
   dPatchName:string[8];
   sizeX,sizeY:word;
   f,g:file;
   b,flag:byte;
   i:word;
   PictureSize,Patch,DelPatches:longint;
begin
     if not Check3DM(Name3DM,Patches,false) then exit;
     msg_(5,7,0,'Looking for patch number N'+itos(StaPatchNum)+' in file "'+Name3DM+'"...');

     assign(f,Name3DM);assign(g,'CBAn4uK.swp');
     reset(f,1);rewrite(g,1);
     {rewriting Header}
     blockread(f,swp^,1000);
     blockwrite(g,swp^,1000);
     {move existing patches from F-file to G-file}
     DelPatches:=0;
     flag:=0;
     PictureSize:=0;
     Patch:=0;
     while Patch<Patches do
           begin
           {Reading name of Patch}
           dPatchName:='';
           for i:=1 to 8 do
               begin
               blockread(f,b,1);
               dPatchName:=dPatchName+chr(b);
               end;
           {Reading size of this Patch}
           blockread(f,sizeX,2);
           blockread(f,sizeY,2);
           {Reading patch}
           for i:=0 to sizeY-1 do
               blockread(f,Buffer^[word(i*320)],sizeX,Size);

           if (Patch>=StaPatchNum)and(Patch<=FinPatchNum) then
              begin
              inc(DelPatches);
              flag:=1;
              msg_(5,7,0,'Found the patch number N'+itos(Patch)+'! It is called "'+dPatchName+'", removing it ...');
              PictureSize:=PictureSize+8+4+sizeX*sizeY;
              end
           else begin
                {Saving Patch Name}
                for i:=1 to 8 do
                    begin
                    b:=ord(dPatchName[i]);
                    blockwrite(g,b,1);
                    end;

                {Saving size of this Patch}
                blockwrite(g,sizeX,2);
                blockwrite(g,sizeY,2);
                {Saving patch}
                for i:=0 to sizeY-1 do
                    blockwrite(g,Buffer^[word(i*320)],sizeX);
                end;
           inc(Patch);
           end;
     {MAP block in file}
     Size:=1;
     while Size>0 do
           begin
           blockread(f,swp^,sizeOf(swp^),Size);
           blockwrite(g,swp^,Size);
           end;
     close(f);close(g);
     erase(f);rename(g,Name3DM);

if flag=0 then msg_(5,7,0,'Such patch number is too big for this file ! MaxNumber='+itos(Patches))
          else begin
               filemode:=2;
               assign(g,Name3DM);reset(g,1);
               seek(g,808);
               blockread(g,Patches,4);
               blockread(g,PatchesSize,4);
               blockread(g,FSize,4);
               {FSize has yet loaded!}

               Patches:=Patches-DelPatches;
               if Patches<0 then Patches:=0;
               dec(PatchesSize,longint(PictureSize));
               dec(FSize,longint(PictureSize));{}
               seek(g,808);
               blockwrite(g,Patches,4);
               blockwrite(g,PatchesSize,4);
               blockwrite(g,FSize,4);
               close(g);
               msg_(5,7,0,'Patch(es) was/were removed !');
               end;
end;


procedure Show3DM(Name3DM:string);
Label TheEnd;
var cd,Size:word;
    b:byte;
    PatchName:string;
    f:file;
    i:word;
    Patch:longint;
    k,l,ii,jj:integer;
begin
     if not Check3DM(Name3DM,Patches,false) then exit;
     msg(5,7,0,'Reading Data from '+Name3DM+' ...');

     assign(f,Name3DM);
     reset(f,1);
     seek(f,length(Header3DM));{skiping Header}
     blockread(f,plt,768);{Reading the palette}
     seek(f,1000);{Filepos to Patches block}
     Init13h;{Init mode 13h with seting Pth palette}
{Show the palette}
     for k:=0 to 7 do
     for l:=0 to 31 do
         for ii:=0 to 9 do
             for jj:=0 to 9 do
                 mem[$a000:k*10*320+ii*320+l*10+jj]:=k*32+l;

     textcolor(123);
     gotoxy(1,24);
     directvideo:=false;
     writeln('Name: Palette');
     write('Press to continue...');
     readkey;
{-----------------}

     Patch:=0;
     while Patch<Patches do
           begin
           PatchName:='';
           {Reading name of Patch}
           for i:=1 to 8 do
               begin
               blockread(f,b,1);
               PatchName:=PatchName+chr(b);
               end;
           {Reading size of this Patch}
           blockread(f,sizeX,2);
           blockread(f,sizeY,2);
           fillchar(buffer^,64000,0);
           for i:=0 to sizeY-1 do
               blockread(f,buffer^[word(i*320)],sizeX);

           ShowBuffer;
           textcolor(123);
           gotoxy(1,24);
           directvideo:=false;
           writeln('Name:',PatchName,',PatchCount:',Patch);
           write('Press to continue...');
           ch:=readkey;
           if ch=#27 then goto TheEnd;
           inc(Patch);
           end;
TheEnd:
     close(f);
     Textmode(LastMode);
end;


Procedure Glue3DM(First3DM,PathTo3DM:string);
var cd,Size:word;
    f,g:file;
    Patches1,PatchesSize1:longint;
begin
     if not Check3DM(First3DM,Patches,false) then exit;
     if not Check3DM(PathTo3DM,Patches1,false) then exit;

     msg(5,7,0,'Gluing patches from '+First3DM+'and '+PathTo3DM+' together to '+First3DM+' ...');

     assign(f,First3DM);
     reset(f,1);
     filemode:=2;
     seek(f,filesize(f));{Filepos to end}

     Assign(g,PathTo3DM);
     reset(g,1);
     seek(g,1000);{Filepos to Patches block}

     Size:=1;PatchesSize1:=0;
     while Size>0 do
           begin
           blockread(g,buffer^,64000,Size);
           blockwrite(f,buffer^,Size);
           inc(PatchesSize1,Size);
           end;
     close(f);close(g);

     reset(f,1);
     seek(f,808);
     blockread(f,Patches,4);
     blockread(f,PatchesSize,4);
     blockread(f,FSize,4);

     Patches:=Patches+Patches1;
     inc(PatchesSize,PatchesSize1);
     inc(FSize,PatchesSize1);{}

     seek(f,808);
     blockwrite(f,Patches,4);
     blockwrite(f,PatchesSize,4);
     blockwrite(f,FSize,4);
     close(f);
     msg_(5,7,0,'Done!');
end;

Procedure Fix3DM(Name3dm:string);
var cd,Size:word;
    f:file;
begin
     msg_(5,7,0,'Fixing errors in "'+Name3DM+'"...');

     assign(f,Name3DM);
     reset(f,1);
     filemode:=2;
     seek(f,808);
     blockread(f,Patches,4);
     blockread(f,PatchesSize,4);
     blockread(f,FSize,4);

     PatchesSize:=Filesize(f)-1000;
     FSize:=Filesize(f);

     seek(f,808);
     blockwrite(f,Patches,4);
     blockwrite(f,PatchesSize,4);
     blockwrite(f,FSize,4);
     close(f);
     msg_(5,7,0,'File was fixed!');
end;



BEGIN
     textcolor(co80);clrscr;
     msg_(10,9,0,'- PCX files converter to 3DM v1.0 Made by SER 1998 -');
     if maxavail<sizeof(buffer)+sizeOf(PcxHeader)+sizeOf(swp) then
        begin
        msg_(9,4,0,'Fatal message: cant take enough memory to run program.');
        halt;
        end;
     new(PcxHeader);
     new(buffer);
     new(swp);
     if paramcount<1 then
        begin
        msg_(0,7,0,'Nothing to do! Try to read the help info that case :');
        msg_(0,7,0,'Example:');
        msg_(0,7,0,'PcxTo3DM.exe screen.pcx screen.3dm - to add PCX patch to screen.3DM.');
        msg_(0,7,0,'PcxTo3DM.exe show screen.3dm       - to show all patches from screen.3DM.');
        msg_(0,7,0,'PcxTo3DM remove map1.3dm           - to remove patch(es) from file "map1.3dm"');
        msg_(0,7,0,'PcxTo3DM delete map1.3dm           - to delete patch number(s) from file "map1.3dm"');
        msg_(0,7,0,'PcxTo3DM map1.3dm map2.3dm         - to glue patches: "map1.3dm = map1.3dm + map2.3dm"');
        msg_(0,7,0,'PcxTo3DM fix map2.3dm              - to fix errors with "map1.3dm"');
        _Error('Much more clear? So do your choice!');
        end;
     PathToPcx:=paramstr(1);
     if paramcount>1 then
        begin
        PathTo3DM:=paramstr(2);
        if LowerCase(paramstr(1))='remove' then
           begin
           onWork:=0;
           while onWork=0 do
                 begin
                 msg(1,7,0,'Enter Patch name for removing,please (8 symbols):');
                 readln(PatchName);
                 if length(PatchName)>8 then delete(PatchName,Length(PatchName),Length(PatchName)-8);
                 RemovePatch(PathTo3DM,PatchName);
                 msg_(1,8,0,'One more? (Y/N)');
                 ch:=readkey;
                 if (ch='n')or(ch='N') then onWork:=1;
                 end;
           goto Escape;
           end;

        if LowerCase(paramstr(1))='delete' then
           begin
           onWork:=0;
           while onWork=0 do
                 begin
                 msg(1,7,0,'Enter starting patch number to delete it :');
                 readln(j);
                 msg(1,7,0,'Enter final patch number to delete it last :');
                 readln(k);
                 DeletePatch(PathTo3DM,j,k);
                 msg_(1,8,0,'One more? (Y/N)');
                 ch:=readkey;
                 if (ch='n')or(ch='N') then onWork:=1;
                 end;
           goto Escape;
           end;

        if LowerCase(paramstr(1))='show' then
           begin
           Show3DM(PathTo3DM);
           goto Escape;
           end;

        if LowerCase(copy(paramstr(1),length(Paramstr(1))-3,4))='.3dm' then
           begin
           First3DM:=ParamStr(1);
           Glue3DM(First3DM,PathTo3DM);
           goto Escape;
           end;

        if LowerCase(paramstr(1))='fix' then
           begin
           Fix3DM(PathTo3DM);
           goto Escape;
           end;

        end;


     LoadPCX;
     Init13h;
     ShowBuffer;{}

     {Ravnjaem ramku po X na dlinu risunka}
     X2:=319;
     Color:=Buffer^[X2];
     While X2>=0 do
           begin
           for i:=0 to 199 do
               if Buffer^[i*320+X2]<>Color then break;
           if Buffer^[i*320+X2]<>Color then break;
           dec(X2);
           end;
     if X2=0 then X2:=319;

     {Ravnjaem ramku po Y na vysotu risunka}
     Y2:=199;
     Color:=Buffer^[Y2*320];
     While Y2>=0 do
           begin
           for j:=0 to 319 do
               if Buffer^[Y2*320+j]<>Color then break;
           if Buffer^[Y2*320+j]<>Color then break;
           dec(Y2);
           end;
     if Y2=0 then Y2:=199;

     X1:=0;Y1:=0;{X2:=127;Y2:=127;}
     pero:='down';textcolor(123);

     ShowBar(X1,Y1,X2,Y2);
     ShowCoordinates(X1,Y1,X2,Y2);
     ch:=#0;
     repeat

           ch2:=ch1;ch1:=ch;ch:=readkey;
           asm mov ah,$0c;int $21;end;{Clearing keyboard buffer}
           if ch2=ch then begin stepX:=stepX+1;stepY:=stepY+1;end
                     else begin stepX:=1;stepY:=1;end;
           case ch of
                'b','B':SaveAsBuf('default.buf');
                'd','D':SaveAsDump('Dump.bin');
                #75:begin
                    if pero='down' then if X2-stepX>=X1 then dec(X2,stepX)
                                                        else X2:=X1;
                    if pero='up' then if X1-stepX>=0 then begin dec(X1,stepX);dec(X2,stepX);end
                                                     else begin X2:=X2-X1;X1:=0;end;
                    end;
                #77:begin
                    if pero='down' then if X2+stepX<=319 then inc(X2,stepX)
                                                         else X2:=319;
                    if pero='up' then if X2+stepX<=319 then begin inc(X1,stepX);inc(X2,stepX);end
                                                       else begin X1:=X1+319-X2;X2:=319;end;
                    end;
                #72:begin
                    if pero='down' then if Y2-stepY>=Y1 then dec(Y2,stepY)
                                                        else Y2:=Y1;
                    if pero='up' then if Y1-stepY>=0 then begin dec(Y1,stepY);dec(Y2,stepY);end
                                                     else begin Y2:=Y2-Y1;Y1:=0;end;

                    end;
                #80:begin
                    if pero='down' then if Y2+stepY<200 then inc(Y2,stepY)
                                                        else Y2:=200;
                    if pero='up' then if Y2+stepY<200 then begin inc(Y1,stepY);inc(Y2,stepY);end
                                                      else begin Y1:=Y1+200-Y2;Y2:=200;end;
                    end;
                #32:if pero='down' then pero:='up'
                                   else pero:='down';

                #27:begin textmode(LastMode);goto Escape;end;
           end;

          ShowBuffer;{}
          ShowBar(X1,Y1,X2,Y2);
          ShowCoordinates(X1,Y1,X2,Y2);
     until ch=#13;

     textmode(LastMode);
     if paramcount>1 then
        begin
        msg(1,7,0,'Enter Patch name,please (8 symbols):');readln(PatchName);
        msg(1,7,0,'Enter patch number after which to insert this (-1 means to end):');readln(AfterPatch);
        if length(PatchName)>8 then delete(PatchName,Length(PatchName),Length(PatchName)-8);

        if FSearch(paramstr(2),GetEnv('PATH'))='' then CreatNew3DMFile(paramstr(2));
        AddPatchTo3DM(paramstr(2),PatchName,X1,Y1,X2,Y2,AfterPatch);
        end;
Escape:
     _Error('3DM operation utility. Created by SER 2000 year');
END.