.386
.387

;---------------------------------------;
;     *TEXTURE MAPPING  INNER LOOP*     ;
;    !Numeric processor is required!    ;
;                                       ;
;     (c) 1999 by Ser Predatorsky       ;
;             and Alexei A. Frounze     ;
;---------------------------------------;


;===============================================================================
; Characteristics :
;Used Z-Buffer = 320 x 200 x 32bit (4 segments = 256 Kb)
;Each Z-value consists 23bits int part and 9bits float part
;Interpolation: group of 16 pixels
;Light: 16 gradational table TL


PUBLIC          IDTLINE16

CODE    SEGMENT PARA PUBLIC USE16
        ASSUME CS:CODE

;------------------------------------------------------------;
;        !!! ;
;            !!!    !!!             ;
;           16        ;
;------------------------------------------------------------;

IDTLINE16 PROC PASCAL FAR
LOCAL ZINV : QWORD
LOCAL U1 : DWORD, V1 : DWORD
LOCAL U2 : DWORD, V2 : DWORD
LOCAL DU : DWORD, DV : DWORD
LOCAL Z : DWORD, DZ : DWORD
LOCAL Cxx : WORD, N512 : WORD, N16:WORD
LOCAL N:WORD, Const_21Bit:DWORD
LOCAL II1:Qword, II2:Qword, II3:Qword

I3              EQU     SS:[BP+6]
I2              EQU     SS:[BP+14]
I1              EQU     SS:[BP+22]
L4              EQU     SS:[BP+30]
L3              EQU     SS:[BP+38]
L2              EQU     SS:[BP+46]
L1              EQU     SS:[BP+54]
Tl		EQU	SS:[BP+62]	;Tl^
Zb		EQU     SS:[BP+66]	;Zb^
Tx		EQU     SS:[BP+70]	;Tx^
Vp		EQU     SS:[BP+74]	;Vp^
Lite		EQU	SS:[BP+78]	;Lite gradation
ZOfs            EQU     SS:[BP+80]      ;ZOfs
Rht             EQU     SS:[BP+82]	;Rht
Lft             EQU     SS:[BP+84]	;Lft
Eps		EQU	SS:[BP+86]	;Eps=0.01

;=======START POINT=============================================================
;===============================================================================

        Push    DS

        Mov     Ax, Word ptr Rht        ;if ((N=Rht-Lft+1) <= 0) then goto TheEnd
        Cmp     Ax, Word ptr Lft
	jb	TheEnd
	Sub	Ax,Word ptr Lft
	inc	Ax

	Mov	Word ptr N,Ax

	And	Ax,0Fh			;Cxx=N mod 16
	je	Futher

;-------This part is only when the line span is not fully divide by 16
	Mov	Word ptr Cxx,Ax
	Fild	Word ptr Cxx
	Fld	Qword ptr I1		;II1=I1*Cxx
	Fmul	St,ST(1)
	Fstp	Qword ptr II1
	Fld	Qword ptr I2		;II2=I2*Cxx
	Fmul	St,ST(1)
	Fstp	Qword ptr II2
	Fld	Qword ptr I3		;II3=I3*Cxx
	Fmul	St,ST(1)
	Fstp	Qword ptr II3
	Fistp	Word ptr Cxx

Futher:
	Mov	DWord ptr Const_21bit,8388608	;Const_21bit for real evaluatings

	Fld	QWord ptr L3		; Z=trunc(L3*Const_21bit/L4)
	FiMul	DWord ptr Const_21bit
	FDiv	QWord ptr L4
	FISTP	DWord ptr Z
	Mov	Edx,Dword ptr Z		; EDX = Z

	Fld	QWord ptr I3		; DZ=trunc(I3*Const_21bit/L4)
	FiMul	DWord ptr Const_21bit
	FDiv	QWord ptr L4
	Fistp	Dword ptr DZ

;=======PREDVOUR ACTIONS========================================================
;===============================================================================
        Mov     ES, Word ptr Vp+2	;ES:DI = VP^
        Mov     DS, Word ptr Tl+2	;DS:SI = Tl^
	Mov	GS, Word ptr Tx+2	;GS:SI = Tx^
        Mov     FS, Word ptr ZB+2	;FS:SI = ZB^

        Mov     Ax,Word ptr Lite        ;Lite=Ofs(Tl^)+Lite*256
	Shl	Ax, 8
	Add	Ax,Word ptr Tl
        Mov     Word ptr Lite,Ax

        Mov     Word Ptr N512, 512	;N512=512

        Mov     Word Ptr N16, 16	;N16=16

        Mov     Ax,Word ptr ZOfs        ;ZOfs=Ofs(Zb^)+ZOfs*4
	Shl	Ax,2
        Add     Ax,Word ptr Zb
        Mov     Word ptr ZOfs,Ax

;=======THE BEGINING==========================================================
;=============================================================================
	Fild	Word ptr N16		;Push N16 into numeric processor

	Fld	Qword ptr I1		;I1=I1*16
	Fmul	ST,ST(1)
	Fstp	Qword ptr I1

	Fld	Qword ptr I2		;I2=I2*16
	Fmul	ST,ST(1)
	Fstp	Qword ptr I2

	Fld	Qword ptr I3		;I3=I3*16
	Fmul	ST,ST(1)
	Fstp	Qword ptr I3

	Fistp	N16			;Pop N16 from numeric processor

;---------------------
	Fld	Qword ptr Eps           ; ST(1) = Eps
	FLD	Qword ptr L3		; ST(0) = L3
	FABS				; ST = ABS(ST) = ABS(L3)
	FCOMPP				; COMPARE L3 with Eps
	FSTSW	AX			; SAVE FPU STATUS WORD TO AX REG
	SAHF				; SAVE AH REG TO FLAGS REG
	JBE	@@1			; JUMP IF ST <= 0.01
	Fild	Word ptr N512		; ST = N512
	Fld	QWord ptr L3		; ST = N512/L3 = Zinv
	FDiv
	JMP	@@END
@@1:
	FLD1
@@END:
        FLD	QWord Ptr L2		;U2=L2*Zinv=512*(L2/L3)
        FMul    ST, ST(1)
        FISTP   DWord ptr U2
        FLD     QWord Ptr L1		;V2=L1*Zinv=512*(L1/L3)
        FMul    ST, ST(1)
        FISTP   DWord ptr V2
        FSTP    QWord ptr ZINV

;=======MAIN LOOP===============================================================
;===============================================================================
MainLoop:
	Cmp	Word ptr N,0		;if Lft>Rht then goto TheEnd
	jle	TheEnd

        Mov     EAX, DWord Ptr U2	;U1=U2
        Mov     DWord Ptr U1, EAX

        Mov     EAX, DWord Ptr V2	;V1=V2
        Mov     DWord Ptr V1, EAX

	Mov	Ax,Word ptr N		;if N>=16 then Cxx=16 else Cxx=N
	Mov	Word ptr Cxx,Ax
	cmp	Ax,16
	jb	AxBelow16		;if N<16 then goto AxBelow16

	Mov	Word ptr Cxx,16

	Fld	QWord ptr I1		;L1=L1+I1
	Fld	QWord ptr L1
	FAddp
	Fstp	Qword ptr L1

	Fld	QWord ptr I2		;L2=L2+I2
	Fld	QWord ptr L2
	FAddp
	Fstp	Qword ptr L2

	Fld	QWord ptr I3		;L3=L3+I3
	Fld	QWord ptr L3
	FAddp
	Fstp	Qword ptr L3

;---------------------
	Fld	Qword ptr Eps           ; ST(1) = Eps
	FLD	Qword ptr L3		; ST(0) = L3
	FABS				; ST = ABS(ST) = ABS(L3)
	FCOMPP				; COMPARE L3 with Eps
	FSTSW	AX			; SAVE FPU STATUS WORD TO AX REG
	SAHF				; SAVE AH REG TO FLAGS REG
	JBE	@@2			; JUMP IF ST <= 0.01
	Fild	Word ptr N512		; ST = N512
	Fld	QWord ptr L3		; ST = N512/L3 = Zinv
	FDiv
	JMP	@@END1
@@2:
	FLD1
@@END1:
        FLD	QWord Ptr L2		;U2=L2*Zinv=512*(L2/L3)
        FMul    ST, ST(1)
        FISTP   DWord ptr U2
        FLD     QWord Ptr L1		;V2=L1*Zinv=512*(L1/L3)
        FMul    ST, ST(1)
        FISTP   DWord ptr V2
        FSTP    QWord ptr ZINV

        Mov     EAX, DWord Ptr U2	;DU=(U2-U1)/16
        Sub     EAX, DWord Ptr U1
        Sar     EAX, 4
        Mov     DU, EAX

        Mov     EAX, DWord Ptr V2       ;DV=(V2-V1)/16
        Sub     EAX, DWord Ptr V1
        Sar     EAX, 4
        Mov     DV, EAX

	jmp	Futher1


AxBelow16:
	Fld	QWord ptr II1		;L1=L1+II1
	Fld	QWord ptr L1
	FAddp
	Fstp	Qword ptr L1

	Fld	QWord ptr II2		;L2=L2+II2
	Fld	QWord ptr L2
	FAddp
	Fstp	Qword ptr L2

	Fld	QWord ptr II3		;L3=L3+II3
	Fld	QWord ptr L3
	FAddp
	Fstp	Qword ptr L3

;---------------------
	Fld	Qword ptr Eps           ; ST(1) = Eps
	FLD	Qword ptr L3		; ST(0) = L3
	FABS				; ST = ABS(ST) = ABS(L3)
	FCOMPP				; COMPARE L3 with Eps
	FSTSW	AX			; SAVE FPU STATUS WORD TO AX REG
	SAHF				; SAVE AH REG TO FLAGS REG
	JBE	@@3			; JUMP IF ST <= 0.01
	Fild	Word ptr N512		; ST = N512
	Fld	QWord ptr L3		; ST = N512/L3 = Zinv
	FDiv
	JMP	@@END2
@@3:
	FLD1
@@END2:
        FLD	QWord Ptr L2		;U2=L2*Zinv=512*(L2/L3)
        FMul    ST, ST(1)
        FISTP   DWord ptr U2
        FLD     QWord Ptr L1		;V2=L1*Zinv=512*(L1/L3)
        FMul    ST, ST(1)
        FISTP   DWord ptr V2
        FSTP    QWord ptr ZINV

        Mov     EAX, DWord Ptr U1	;DU=(U2-U1)/N
        Sub     DWord Ptr U2,EAX
	Fild	Word ptr N
	Fild	Dword Ptr U2
	Fdiv	ST, ST(1)
        Fistp	Dword ptr DU

        Mov     EAX, DWord Ptr V1       ;DV=(V2-V1)/N
        Sub     DWord Ptr V2,EAX
	Fild	Dword Ptr V2
	Fdiv	ST, ST(1)
        Fistp	Dword ptr DV
	Fistp	Word ptr N
	
	Mov	Word ptr N,16		;Next operation will be "N=0" :)

Futher1:

	Sub	Word ptr N,16		;N=N-16, for N<16 see previose command

	Mov	AX, WORD PTR du         ;EAX = du shl 16 + dv
	Shl	EAX, 16
	Mov	AX, WORD PTR dv
	Mov	BX, WORD PTR ZOfs	;BX = ZOfs
	Mov	CX,  WORD PTR u1	;ECX = u1 shl 16 + v1
	Shl	ECX, 16
	Mov	CX,  WORD PTR v1

        Mov     DI, WORD PTR Lft	;DI = Ofs(Vp^)+Lft
        Add     DI, Word ptr Vp
					;EDX = Z (See the START POINT)

;=======INNER LOOP============================================================
;===============================================================================
InnerLoop:
	CMP	DWORD PTR FS:[BX],EDX	; if ZB^[ZOfs]>Z then goto Next
	Ja	Next

        Xor     SI,SI
	Shld	ESI,ECX,7		; SI=Texel=Tx^[U1,V1]
	Shld	SI,CX,7
        Add     SI,Word ptr Tx
	CMP	BYTE PTR GS:[SI],0	; if Texel=0 then goto Next
	Jz	Next

	Mov	FS:[BX],EDX		; ZB^[ZOfs]=Z
	Movzx	SI,GS:[SI]		; SI = GS:[SI] =Texel
	Add	SI,Word ptr Lite	; Vp^[Lft]=Tl^[Lite,Texel]=Tl[SI]
	Movsb				; inc(Lft);

	Add	ECX, EAX		; U1 = U1 + DU; V1 = V1 + DV
	Add	EDX, DWORD PTR DZ	; Z = Z + DZ
	Add	Bx,4			; inc(ZOfs,4)
        dec     WORD PTR Cxx
        jz      EndOfInnerLoop
	jmp	InnerLoop

Next:
	inc	DI
	Add	ECX, EAX		; U1 = U1 + DU; V1 = V1 + DV
	Add	EDX, DWORD PTR DZ	; Z = Z + DZ
	Add	Bx,4			; inc(ZOfs,4)
        dec     WORD PTR Cxx
        jz      EndOfInnerLoop
	jmp	InnerLoop

EndOfInnerLoop:
        Mov     Word ptr Lft,DI         ;Lft=Lft+Cxx
        Mov     Word Ptr ZOfs,BX        ;ZOfs=ZOfs+2*Cxx (in bytes, not words!)

        Jmp     MainLoop

TheEnd:

        Pop     DS
	Leave
        Ret	88			;88 = the whole params size
IDTLINE16 ENDP

CODE    ENDS

END
