{$A+,B-,D+,E+,F+,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 4000,0,655360}

uses crt,dos,xms,keypres2;
CONST
     PatchSize=128*128;{  ⥪ન (஢!)}
     Header3DM:string='-3D MAP FILE,USED BY SERs ENGINE AS MAP-';
     g=9.81{};
     Mn=2000;
     Eps:double=0.01;
     HitKoef:double=1;

TYPE
{SECTION of memory needs}
    VideoBuffer=packed array[0..65000] of byte;
    TextureBuffer=array[0..PatchSize] of byte;
    LightBuffer=array[0..16*256 {0..15,0..255}] of byte;
    ZBuffer=array[0..16000] of longint;
    ZBuf=^ZBuffer;

{SECTION of Road}
    RoadFlat=record {࠭  .    - 300 byte}
    {RoadFlat  "" -  ⮪ ண{}
             X,Y,Z:array[0..4] of longint;{न  ண}{60}
             Xm1,Ym1,Xm2,Ym2:double;{न । ண}{32}
             a1,b1:double;{2  ࠢ ண}{16}
             RWidth:longint;{ਭ   ண}{4}
             RWidth1:longint;{ਭ 砫  ண}{4}
             RLength:double;{ }{8}
             lll:double;{ᯮ⥫쭠 ६  ᫥ ਭ}{8}
             v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{ ⥬ }{72}
             RStaTexture,RCurTexture,RFinTexture:word;{ 樨 }{6}
             RStaLight,RCurLight,RFinLight:byte;{ᢥ饭 }{3}
             RFriction:double;{७  }{8}
             RDistanceFromStart:double;{ﭨ  砫 }{8}
             RScaling:double;{8}
             reserved:array[1..63] of byte;
             end;

{SECTION of camera dynamic data}
    CameraRecord=record{128 bytes}
                 X,Y,Z:double;{Current position in 3d}{24}
                 Sector:word;{Current sector the object belongs to}{2}
                 v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{Object's 3x3 vector system in 3d}{72}
                 MaxStep:double;{Max possible objects step in 3d}{8}
                 CurStep:double;{Current step}{8}
                 Step:double;{Real evaluated step}{8}
                 MaxAngle:integer;{Max possible rotation delta angle}{2}
                 CurAngle:integer;{Current delta anlge}{2}
                 Angle:integer;{delta anlge}{2}
                 end;

var
   Vp:^VideoBuffer;{Visual page pointer}
   Tx:^TextureBuffer;{Textures page pointer}
   Lt:^LightBuffer;{Light table pointer}
   StaLiteGrad,CurLiteGrad,FinLiteGrad:word;{Change lite}
   ZB:array[0..3] of ZBuf;{4xZBuffer}
   MRec : XMMRec;

   {Road flats variables}
   XMSRoadFlat:word;{ਯ   ,  ࠭  ஦ }
   RoadFlat1:RoadFlat;{⮪ ண1}

   {Textures variables}
   XMSTextures:word;{ਯ   ,  ࠭ ⥪ ஦ }
   Patches,PatchesSize,FSize:longint;{Patches in handle, their whole size and File size}
   TexturateMethod:byte;{Number of texturated method}
   Sectors:word;{Other needs}

   {System variables}
   BIOSTime : LongInt  Absolute $40:$6C;
   Timer:byte;{1=timer on, 0 = off}
   BotControl:byte;{1=Bot on,0=off}
   OutCabin:byte;{1=Out,0=In}
   FPS:longint;{Frames Per Second}
   MemoryStatus:byte;{Status of XMS and Base memory allocation }
   lb,rb,ub,db:integer;{Screen bounders}
   v11,v12,v13,v21,v22,v23,v31,v32,v33:double;{ ⥬  }
   R,k4:longint;{Perspective=200}
   strg:string;{string needs}

   {Camera}
   Camera:CameraRecord;
   ScreenX,ScreenY:integer;
   v1,v2,v3:double;
   U1,U2,U3:integer;

   {Massives}
   sn:array[0..359] of double;{sinus table}

   Lbd,Rbd,MLbd,MRbd:array[0..200] of longint;{Floodfill massives}
   Mub,Mdb:integer;
   MinY,MaxY:longint;
   PMaxX,PMinX:longint;

   o,p:array[0..10] of longint;{2D Peaks on screen}
   plt:array[0..767] of byte;{palette}

   i,j:integer;

   {Test}
   Constanta:longint;


{==================Math support==============================================}
function sgn(x:double):integer;
begin
     if x<0 then sgn:=-1 else if x>0 then sgn:=1 else sgn:=0;
end;

function sinn(u:integer) : double;
begin
     u:=u mod 360;
     if u<0 then u:=360+u;
     sinn:=sn[u];
end;

function coss(u:integer) : double;
begin
     coss:=sinn(90-u);
end;



{=================Vectors support============================================}
Procedure InitVectorSystem(var v11,v12,v13,v21,v22,v23,v31,v32,v33:Double);
begin
     v11:=1;v12:=0;v13:=0;
     v21:=0;v22:=1;v23:=0;
     v31:=0;v32:=0;v33:=1;
end;

{Init rotation matrix by follow angles U1,U2,U3 and rotate vectors system
by multiplicating it on rotation matrix}
Procedure RotateVectorsSystem(U1,U2,U3:integer;var v11,v12,v13,v21,v22,v23,v31,v32,v33:Double);
var
   c1,c2,c3,s1,s2,s3:double;
   vv11,vv12,vv13,vv21,vv22,vv23,vv31,vv32,vv33:double;
   m11,m12,m13,m21,m22,m23,m31,m32,m33:double;{Rotation matrix elements}
begin
     {Creating rotation matrix}
     c1:=coss(U1);c2:=coss(U2);c3:=coss(U3);
     s1:=sinn(U1);s2:=sinn(U2);s3:=sinn(U3);

     m11:=s3*s1+c3*c2*c1;m12:=c3*c2*s1-s3*c1;m13:=c3*s2;
     m21:=s2*c1;         m22:=s2*s1;         m23:=-c2;
     m31:=s3*c2*c1-c3*s1;m32:=s3*c2*s1+c3*c1;m33:=s3*s2;

     {Multiplicating}
     vv11:=v11;vv12:=v12;vv13:=v13;
     vv21:=v21;vv22:=v22;vv23:=v23;
     vv31:=v31;vv32:=v32;vv33:=v33;

     v11:=m11*vv11+m12*vv21+m13*vv31;
     v12:=m11*vv12+m12*vv22+m13*vv32;
     v13:=m11*vv13+m12*vv23+m13*vv33;

     v21:=m21*vv11+m22*vv21+m23*vv31;
     v22:=m21*vv12+m22*vv22+m23*vv32;
     v23:=m21*vv13+m22*vv23+m23*vv33;

     v31:=m31*vv11+m32*vv21+m33*vv31;
     v32:=m31*vv12+m32*vv22+m33*vv32;
     v33:=m31*vv13+m32*vv23+m33*vv33;
end;


{Creat Normal Vector to 2 others: (a1,b1,g1) and (a2,b2,g2) }
procedure normal(a1,b1,g1,a2,b2,g2:double;var a3,b3,g3:double);
var w1,w2,w3,ww,l:double;{}
begin
{     a3:=b1*g2-b2*g1;
     b3:=a2*g1-a1*g2;
     g3:=a1*b2-a2*b1;{}

     w1:=a1*b2-a2*b1;
     w2:=b1*g2-b2*g1;
     w3:=a1*g2-a2*g1;
     ww:=w1*w1+w2*w2+w3*w3;
     a3:=w2/ww;
     b3:=-w3/ww;
     g3:=w1/ww;
     l:=sqrt(a3*a3+b3*b3+g3*g3);
     a3:=a3/l;
     b3:=b3/l;
     g3:=g3/l;{}
end;

Procedure BuildPoligonVectorsSystem(var v11,v12,v13,v21,v22,v23,v31,v32,v33:Double);
var dx,dy,dz,l:double;
begin
     {Building Prototype Vector system for each Objects poligon}
     With RoadFlat1 do
     begin
     dx:=X[0]-X[1];
     dy:=Y[0]-Y[1];
     dz:=Z[0]-Z[1];
     l:=sqrt(dx*dx+dy*dy+dz*dz);
     v11:=dx/l;v12:=dy/l;v13:=dz/l;
     dx:=X[2]-X[1];
     dy:=Y[2]-Y[1];
     dz:=Z[2]-Z[1];
     l:=sqrt(dx*dx+dy*dy+dz*dz);
     v21:=dx/l;v22:=dy/l;v23:=dz/l;
     normal(v11,v12,v13,v21,v22,v23,v31,v32,v33);
     normal(v31,v32,v33,v11,v12,v13,v21,v22,v23);
     end;
end;



{==================TEXTMODE CO80 interface===================================}
Function ItoS(i:longint):string;
var s:string;
begin
     str(i,s);
     ItoS:=s;
end;

Function DtoS(d:double):string;
var s:string;
begin
     str(d,s);
     DtoS:=s;
end;


procedure msg(beginPos,col,backcolor:word;strg:string);
begin
textbackground(0);
write(' ':beginPos);
textcolor(col);
textbackground(backcolor);
write(strg);
end;

procedure msg_(beginPos,color,backcolor:word;strg:string);
begin
msg(beginPos,color,backcolor,strg);
writeln;
end;

Procedure FreeProgramMemory;
begin
     if MemoryStatus>9 then for i:=0 to 3 do dispose(ZB[i]);{}
     if MemoryStatus>10 then dispose(Vp);
     if MemoryStatus>11 then dispose(Tx);
     if MemoryStatus>12 then dispose(Lt);

     FreeXMS(XMSTextures);

end;

procedure _Error(strg:string);
var s:string;
    f:text;
    CurVideoMode:byte;
begin
     FreeProgramMemory;
     asm mov ah,0fh;int 10h;mov CurVideoMode,al;end;
     if CurVideoMode<>3 then textmode(co80);
     textcolor(4);
     write(strg);
     textcolor(7);
     write(#13#10'SER Game Corporation 2000 year');
     halt;
end;


Procedure SavePositionToFile(FName:string);
var f:text;
begin
     assign(f,FName);
     if FSearch(FName,getenv('path'))='' then rewrite(f)
                                         else append(f);
     strg:='Camera.X:='+DtoS(Camera.X)+';Camera.Y:='+DtoS(Camera.Y)+';Camera.Z:='+Dtos(Camera.Z)+';';
     writeln(f,strg);
     strg:='Camera.v11:='+DtoS(Camera.v11)+';Camera.v12:='+DtoS(Camera.v12)+';Camera.v13:='+Dtos(Camera.v13)+';';
     writeln(f,strg);
     strg:='Camera.v21:='+DtoS(Camera.v21)+';Camera.v22:='+DtoS(Camera.v22)+';Camera.v23:='+Dtos(Camera.v23)+';';
     writeln(f,strg);
     strg:='Camera.v31:='+DtoS(Camera.v31)+';Camera.v32:='+DtoS(Camera.v32)+';Camera.v33:='+Dtos(Camera.v33)+';';
     writeln(f,strg);
     writeln(f,'--=End of write=--');
     close(f);
end;

{============LOADING=========================================================}

{***************************3DM UNIT****************************************}

{Checking 3DM Files format,if all right then:
0.Check 3DM file presens by its name
1.Counting number of patches to "Patches"
2.Filling patches size to "PatchesSize"
3.Seting file size to "FSize"
4.Returning number of sectors to "Sectors"
    other case Showing an error}
Procedure Check3DM(Name3dm:string);
var sum,sizeX,sizeY:word;
    b,i:byte;
    f:file;
begin
     if FSearch(Name3dm,GetEnv('PATH'))='' then _Error('File "'+Name3dm+'" was not found !');
     msg_(3,8,0,'Checking "'+Name3dm+'" by 3DM format...');
     assign(f,Name3dm);
     reset(f,1);
     if filesize(f)<length(Header3DM) then _Error('It`s too small 3D Map file!');
     {Reading Header}
     strg:='';
     for i:=1 to length(Header3DM) do
         begin blockread(f,b,1);strg:=strg+chr(b);end;
     if strg<>Header3DM then _Error('Wrong header of 3D Map file');
     blockread(f,plt,768,sum);if sum<768 then _Error('This 3D Map file was cutted!');
     blockread(f,Patches,4,sum);if sum<4 then _Error('This 3D Map file was cutted!');
     blockread(f,PatchesSize,4,sum);if sum<4 then _Error('This 3D Map file was cutted!');
     blockread(f,Fsize,4,sum);if sum<4 then _Error('This 3D Map file was cutted!');
     blockread(f,Sectors,2,sum);if sum<2 then _Error('This 3D Map file was cutted!');
     if filesize(f)<>Fsize then _Error('This 3D Map file was cutted!');{}
     close(f);
end;


{Transforms Patch of different sizes to 128x128 ones}
Procedure TransformPatchTo_128x128(sizeX,sizeY:word);
var i,j:word;
begin
     if sizeX<128 then
        for i:=0 to sizeY-1 do
            begin
            if sizeX<65 then
               for j:=1 to (128 div sizeX-1) do
                   move(Tx^[i*128],Tx^[i*128+j*sizeX],sizeX);
            if 128 mod sizeX>0 then move(Tx^[i*128],Tx^[i*128+j*sizeX+sizeX],128 mod sizeX);
            end;

     if sizeY<128 then
        begin
        if sizeY<65 then
           for i:=0 to 128 div sizeY-1 do
               move(Tx^[0],Tx^[i*128*sizeY],128*sizeY);
        if 128 mod sizeY>0 then move(Tx^[0],Tx^[(i+1)*128*sizeY],128*(128 mod sizeY));
        end;
end;

{Allocating needed XMS memory (XMSStatus:=14) and trying to load 3DM file to XMS}
procedure LoadTextures(Name3DM:string);
var
   f:file;
   sizeX,sizeY,sizeR,Size:word;
   TotalPatches,XMSOffset:longint;
   i:integer;
   PatchName:double;
begin
     msg_(3,8,0,'Taking textures from "'+Name3DM+'" :');
     Check3DM(Name3DM);

     {=========XMS allocation==========}
{14} Size:=Patches*PatchSize div 1024+1;
     msg_(3,8,0,'Allocating XMS memory for textures ( '+itos(Size)+' KB )');
     GetXMS(XMSTextures,Size);
     if XMMError<>0 then _Error('XMS ERROR: Not enough Extended Memory!');
     inc(MemoryStatus);{MemoryStatus=14!}
     {================================}

     msg_(3,8,0,'Loading textures...');
     assign(f,Name3DM);
     reset(f,1);

(*     {------------Loading camera position and Vector system---------------}
     seek(f,822);
     with Camera do
          begin
     blockread(f,X,8);blockread(f,Y,8);blockread(f,Z,8);
     blockread(f,v11,8);blockread(f,v12,8);blockread(f,v13,8);
     blockread(f,v21,8);blockread(f,v22,8);blockread(f,v23,8);
     blockread(f,v31,8);blockread(f,v32,8);blockread(f,v33,8);
          end;
*)

{     Init13h;{}
     seek(f,1000);
     XMSoffset:=0;TotalPatches:=0;
     while TotalPatches<Patches do
           begin
           blockread(f,PatchName,8,size);{Patches name}
           blockread(f,sizeX,2);          {size on X}
           blockread(f,sizeY,2);
           if sizeY>128 then sizeY:=128;
           if sizeX>128 then begin sizeR:=sizeX-128;sizeX:=128;end
                        else sizeR:=0;
           for i:=0 to sizeY-1 do
               begin
               blockread(f,Tx^[i shl 7],sizeX);
               seek(f,filepos(f)+sizeR);
               end;
{           ShowTx;{}
           XMSoffset:=TotalPatches*PatchSize;
           if (sizeX<>0)and(sizeY<>0) then TransformPatchTo_128x128(sizeX,sizeY)
           else
               _Error('Hmm...it''s cool to have texture of zero sizes!');
{           ShowTx;{}
           {Put patch to XMS}
           xms_move(MRec,0,ofs(Tx^),seg(Tx^),
                    XMSTextures,XMSoffset and $ffff,XMSoffset shr 16,
                    PatchSize);
           inc(TotalPatches);
           end;
end;


{=====================Show up Unit===========================================}
{Initializates 13h mode and sets the palette}
Procedure Init13h;
var i:integer;
    Color,Gradation:byte;
begin
{Creat the light table}
     for Color:=0 to 255 do
         begin
         for Gradation:=0 to Color mod 16 do
             LT^[Gradation*256+Color]:=Color-Gradation;
         inc(Gradation);
         while Gradation<16 do
               begin
               LT^[Gradation*256+Color]:=0;
               inc(Gradation);
               end;
         end;

   asm mov ax,13h;int 10h;end;{}
   for i:=0 to 255 do
       begin
       port[$3c8]:=i;
       port[$3c9]:=plt[i*3];
       port[$3c9]:=plt[i*3+1];
       port[$3c9]:=plt[i*3+2];
       end;
end;



{ This draws a line from a,b to c,d of color col. }
{HERE! This proc does not belongs to project at the end!}
Procedure line(a,b,c,d:integer;col:byte);
var u,s,v,d1x,d1y,d2x,d2y,m,n:double;
    i:integer;
BEGIN
     u:= c - a;
     v:= d - b;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := INT(m / 2);
     FOR i := 0 TO round(m) DO
     BEGIN
          vp^[a+(b*320)]:=Col;
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               a:= a +round(d1x);
               b := b + round(d1y);
          END
          ELSE
          BEGIN
               a := a + round(d2x);
               b := b + round(d2y);
          END;
     END;
END;

{HERE! This proc does not belongs to project at the end!}
Procedure pr40(var x3,y3,x4,y4:longint;x,y:longint;var q:byte);
begin
if q=0 then begin x3:=x;y3:=y;q:=1;end
       else begin x4:=x;y4:=y;q:=2;end;
end;
{楤 ᮢ  ࠭ , ᥪ 室騥  ࠭ }
{HERE! This proc does not belongs to project at the end!}
Procedure ClipLine(x1,y1,x2,y2:longint;col:byte);
label DrawClipLine;
var k5:double;
    x,y,x3,y3,x4,y4,dx,dy:longint;
    q:byte;
begin
     q:=0;
     if x1>=lb then
        if x1<=rb then
           if y1>=ub then
              if y1<=db then pr40(x3,y3,x4,y4,x1,y1,q);
     if x2>=lb then
        if x2<=rb then
           if y2>=ub then
              if y2<=db then begin
                             pr40(x3,y3,x4,y4,x2,y2,q);
                             if q>1 then goto DrawClipLine;
                             end;

     dx:=x1-x2;dy:=y1-y2;
     if dy<>0 then begin
                   k5:=dx/dy;
                   x:=trunc(x1-y1*k5);y:=0;
                   if y1*y2<0 then
                      if x>=lb then
                         if x<=rb then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   x:=trunc(x1-(y1-db)*k5);y:=db;
                   if (y1-db)*(y2-db)<0 then
                      if x>=lb then
                         if x<=rb then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   end;
     if dx<>0 then begin
                   k5:=dy/dx;
                   y:=trunc(y1-x1*k5);x:=0;
                   if x1*x2<0 then
                      if y>=ub then
                         if y<=db then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   y:=trunc(y1-(x1-rb)*k5);x:=rb;
                   if (x1-rb)*(x2-rb)<0 then
                      if y>=ub then
                         if y<=db then begin
                                       pr40(x3,y3,x4,y4,x,y,q);
                                       if q>1 then goto DrawClipLine;
                                       end;
                   end;
exit;{Because The Line is out of screen}

DrawClipLine:
     Line(x3,y3,x4,y4,col);
end;

Procedure Z_Buffer(l1,l2,l3,l4,i1,i2,i3,i4:double;rht,lft:longint;ZOfs:word;var ZBf:ZBuf;Light:byte);
var
  Zinv : double;
  l, u1, v1, w1, u2, v2, w2, du, dv ,dw: longint;
  Texel,Texel1:byte;
  Z,dz: longint;
  cx,n:word;
CONST
     NOPFI:longint=16;
     NOPFIbits:byte=4;
begin
     if lft>=rht then exit;

     n:=rht-lft+1;
     Z:=round(L3*Constanta/L4);
     dz:=round(I3*Constanta/L4);

     i3:=i3*NOPFI;i2:=i2*NOPFI;i1:=i1*NOPFI;
     if abs(L3)>0.01 then zinv:=512/l3 else Zinv:=1;{}
     u2:=longint(trunc(L2*zinv));
     v2:=longint(trunc(L1*zinv));

While Lft<=Rht do
      begin

      u1:=u2;v1:=v2;
      L1:=L1+I1;L2:=L2+I2;L3:=L3+I3;
      if abs(L3)>0.01 then zinv:=512/l3 else Zinv:=1;
      u2:=longint(trunc(L2*zinv));
      v2:=longint(trunc(L1*zinv));
      du:=(u2-u1) shr NOPFIBits;
      dv:=(v2-v1) shr NOPFIBits;
      cx:=rht-lft+1;
      if cx>NOPFI then cx:=NOPFI;

      while cx>0 do
            begin
            if ZBf^[Zofs]<Z then{}
               begin
               Texel:=Tx^[u1 and $fe00 shr 2+v1 shr 9 and $7f];
               if Texel>0 then{}
                  begin
                  ZBf^[ZOfs]:=Z;
                  vp^[Lft]:=Texel;
                  end;
               end;
            u1:=u1+du;v1:=v1+dv;
            Z:=Z+dz;
            inc(Lft);inc(ZOfs);
            dec(cx);
            end;
     end;
end;



Procedure IDTline16(Eps:double;Lft,Rht,ZOfs,CurLiteGrad:word;Vp,Tx,Zb,Tl:pointer;l1,l2,l3,l4,i1,i2,i3:double);external;
{$L RIDTLine.obj}

{Texturating the poligon}
{MRequires axY,MinY,Rbd,Lbd}
procedure TexturateTheWall(X0,Y0,Z0,a1,b1,g1,a2,b2,g2,a3,b3,g3:double;XMSOffset:longint;Scaling:double;Light:byte);
var
   vv1,vv2,vv3,m1,m2,m3:double;
   rr,rht,lft,ZOfs,ZIndex:longint;
   k1,k2:integer;
   fg:byte;
   vp_ofs:word;
   LAfin:word;
   l1,l2,l3,l4,i1,i2,i3,i4:double;
   dx,dy,dz,w1,w2,w3,w,_w1,_w2,_w3:double;
   LiteOfs:word;
begin
     LiteOfs:=Ofs(Lt^)+Light*256;
     w1:=a1*b2-a2*b1;w2:=b1*g2-b2*g1;w3:=a1*g2-a2*g1;
     w1:=w1*Scaling;w2:=w2*Scaling;w3:=w3*Scaling;{}

     _w1:=abs(w1);_w2:=abs(w2);_w3:=abs(w3);

     dx:=Camera.X-X0;dy:=Camera.Y-Y0;dz:=Camera.Z-Z0;

     vv3:=dy*w3-dz*w1-dx*w2;
     if vv3=0 then
        _Error('VV3=0!!!');

if (_w1>=_w2)and(_w1>=_w3) then begin vv1:=(dx*b2-dy*a2)/w1;vv2:=(dy*a1-dx*b1)/w1;fg:=0;end;
if (_w2>=_w1)and(_w2>=_w3) then begin vv1:=(dy*g2-dz*b2)/w2;vv2:=(dz*b1-dy*g1)/w2;fg:=1;end;
if (_w3>=_w1)and(_w3>=_w2) then begin vv1:=(dx*g2-dz*a2)/w3;vv2:=(dz*a1-dx*g1)/w3;fg:=2;end;

vp_ofs:=MaxY*320;

XMSOffset:=19*PatchSize;

{Uploading texture to Tx^ buffer}
xms_move(MRec,XMSTextures,word(XMSOffset and 65535),word(XMSOffset shr 16){},
         0,ofs(Tx^),seg(Tx^),
         PatchSize);
{ShowTx;{}

k2:=ScreenY-MaxY;
while k2<=ScreenY-MinY do
    begin
    rr:=longint(lbd[-k2+ScreenY]-ScreenX);
    with Camera do
    begin
    m1:=v11*rr-v21*r+v31*k2;
    m2:=v12*rr-v22*r+v32*k2;
    m3:=v13*rr-v23*r+v33*k2;

    lft:=vp_ofs+lbd[-k2+ScreenY];rht:=vp_ofs+rbd[-k2+ScreenY];
    if fg=0 then
       begin
       l1:=(m1*b2-m2*a2)/w1*vv3;
       i1:=(v11*b2-v12*a2)/w1*vv3;
       l2:=(m2*a1-m1*b1)/w1*vv3;
       i2:=(v12*a1-v11*b1)/w1*vv3;
       end
    else if fg=1 then
            begin
            l1:=(m2*g2-m3*b2)/w2*vv3;
            i1:=(v12*g2-v13*b2)/w2*vv3;
            l2:=(m3*b1-m2*g1)/w2*vv3;
            i2:=(v13*b1-v12*g1)/w2*vv3;
            end
         else if fg=2 then
                 begin
                 l1:=(m1*g2-m3*a2)/w3*vv3;
                 i1:=(v11*g2-v13*a2)/w3*vv3;
                 l2:=(m3*a1-m1*g1)/w3*vv3;
                 i2:=(v13*a1-v11*g1)/w3*vv3;
                 end;
   l3:=(m1*w2-m2*w3+m3*w1);
   i3:=(v11*w2-v12*w3+v13*w1);
   l4:=vv3*r{-(v21*m1+v22*m2+v23*m3)*vv3{};
   i4:=0{-(v21*v11+v22*v12+v23*v13)*vv3{};
   l1:=vv1*l3+l1;i1:=vv1*i3+i1;
   l2:=vv2*l3+l2;i2:=vv2*i3+i2;
   end;

   Case TexturateMethod of
   1:begin
     Zindex:=(ScreenY-k2) div 50;
     IDTLine16(Eps,Lft,Rht,word(Lft-ZIndex*16000),LiteOfs,Vp,Tx,Zb[ZIndex],LT,
               l1,l2,l3,l4,i1,i2,i3);
     end;

   2:begin
     Zindex:=(ScreenY-k2) div 50;
     Z_Buffer(l1,l2,l3,l4,i1,i2,i3,i4,rht,lft,Lft-16000*ZIndex,ZB[Zindex],CurLiteGrad);
     end;
   end;

   vp_ofs:=vp_ofs-320;
   inc(k2);
{   if TexturateMethod=0 then begin k2:=k2+1;vp_ofs:=vp_ofs-320;end;{}
   end;
end;


{Find 2d poligon proection to screen, after build image.
In: Number of nodes of 3d poligon.
Out:  true, if Lbd and Rbd arrays were filled or false if clipped}
Function BuildPoligonImage(Nodes3D:word;VisibilityCheck:boolean):boolean;
var
    i,l:integer;
    a,b,c,d,a1,b1,c1,ddx,ddy,ddz,xd,yd:double;
    f,f1:integer;
    P2DTLI,P2DTRI:word;{Top leftest and rightest indexes in o,p arrays}
    P2DTI,P2DBI:word;
    P2DTL,P2DTR:longint;{Top left and right X-coordinates}
    Step:integer;
    Flag:byte;
var
    x,StepX,q,x1,y1,x2,y2,dx,dy,y,yn,xl,sx,e:longint;

{Detects poligons boundaries [(PMinX,PMinY) - (PMaxX,PMaxY)]}
Procedure Check2dLimits(x,y:longint);
begin
     if PMaxX<x then PMaxX:=x;
     if PMinX>x then PMinX:=x;
     if MaxY<=y then begin MaxY:=y;P2DBI:=l;end;{looking for Bottom index}
     if MinY>=y then begin MinY:=y;P2DTI:=l;end;{for Top index}
end;

begin
         PMaxX:=-Maxlongint;PMinX:=MaxLongint;
         MaxY:=-MaxLongint;MinY:=MaxLongint;

         P2DTLI:=65535;P2DTRI:=65535;
         P2DTL:=Maxlongint;P2DTR:=-Maxlongint;

         l:=0;f1:=0;
         for i:=0 to Nodes3D do     {  ᥬ 窠 }
             begin
{^}          With Camera do
             begin
              ddx:=X-RoadFlat1.X[i];ddy:=Y-RoadFlat1.Y[i];ddz:=Z-RoadFlat1.Z[i];
             a:=v11*ddx+v12*ddy+v13*ddz;
             b:=v21*ddx+v22*ddy+v23*ddz;
             c:=v31*ddx+v32*ddy+v33*ddz;{}
{^}          end;
             f:=sgn(b-k4);
             if not((f<0)and(f1<=0)) then
                begin
{-----஢ઠ  祭  ⥭ 㠫쭮 ᪮}
                if f1*f<0 then
                   begin
                   a1:=a1-(b1-k4)*(a1-a)/(b1-b);
                   c1:=c1+(b1-k4)*(c-c1)/(b1-b);
                   inc(l);
                   xd:=160-a1*r/k4;
                   yd:=100+c1*r/k4;
                   o[l]:=round(xd);p[l]:=round(yd);
                   Check2dLimits(o[l],p[l]);
                   if f1<=0 then
                      begin
                      inc(l);
                      xd:=160-a*r/b;
                      yd:=100+c*r/b;
                      o[l]:=round(xd);p[l]:=round(yd);
                      Check2dLimits(o[l],p[l]);
                      end
                   end
                   else
                   begin
                   inc(l);
                   xd:=160-a*r/b;
                   yd:=100+c*r/b;
                   o[l]:=round(xd);p[l]:=round(yd);
                   Check2dLimits(o[l],p[l]);
                   end;
                end;
             f1:=f;a1:=a;b1:=b;c1:=c;
             end;
    if o[l]-o[1]+p[l]-p[1]<>0 then
       begin inc(l);o[l]:=o[1];p[l]:=p[1];end;

{Check on 2d image clipping}
    if (PMaxX<Lb)or(PMinX>=Rb)or(MaxY<MUb)or(MinY>=MDb)or(L<4) then
       begin BuildPoligonImage:=false;exit;end;

{Check on perspective visibility}
    a:=o[l-3]-o[l-2];b:=o[l-1]-o[l-2];
    c:=p[l-3]-p[l-2];d:=p[l-1]-p[l-2];
    a:=sgn(a*d-b*c);

    if VisibilityCheck then
       if a<0 then{not visible poligon, proected on clock arrow}
          begin BuildPoligonImage:=false;exit;end;

{Build image}
{    move(MRbd[Mub],Lbd[Mub],Mdb-Mub+1);
    move(MLbd[Mub],Rbd[Mub],Mdb-Mub+1);{}
{    for i:=Mub to Mdb do begin Lbd[i]:=MRbd[i];rbd[i]:=MLbd[i];end;{set Clipping window}
    MinY:=MDb;MaxY:=Mub;

    if a>=0 then Step:=1
            else Step:=-1;

    P2DTLI:=P2DTI;
    {Fill left bound of poligon proection}
    While (P2DTLI<>P2DBI) do
          begin
          x1:=o[P2DTLI];y1:=p[P2DTLI];
          P2DTLI:=P2DTLI+Step;{next node below Top Left Index}
          if P2DTLI<1 then P2DTLI:=l-1;{Check chain numbers}
          if P2DTLI>L-1 then P2DTLI:=1;
          x2:=o[P2DTLI];y2:=p[P2DTLI];
          {y2>y1 always!!!}
          if y2<Mub then continue;
          if y1>Mdb then continue;

          dy:=y2-y1;{always dy>0!}
          if dy=0 then continue;{skip horizontal lines}
          dx:=x2-x1;
          if dx>0 then sx:=1 else sx:=-1;

          if y1<Mub then
             begin{Clip Top poligon edge}
  {           x:=x1+trunc(1/dy*(Mub-y1)*dx);{another version}
             x:=x2-trunc(1/dy*y2*dx);
             y1:=Mub;
             end
          else x:=x1;

          if y2>Mdb then y2:=Mdb; {Clip Bottom poligon edge}

          dx:=abs(dx);
          if dx>dy then begin StepX:=dx div dy;dx:=dx-StepX*dy;end
                   else StepX:=0;
          if sx<0 then begin StepX:=-StepX;end;

          e:=0;
          for y:=y1 to y2 do
              begin
              Lbd[y]:=x;
              x:=x+StepX;
              e:=e+dx;if e>=dy then begin x:=x+sx;e:=e-dy;end;
              end;

          if MinY>y1 then MinY:=y1;
          if MaxY<y2 then MaxY:=y2;

          end;

    P2DTRI:=P2DTI;
    {Fill left bound of poligon proection}
    While (P2DTRI<>P2DBI) do
          begin
          x1:=o[P2DTRI];y1:=p[P2DTRI];
          P2DTRI:=P2DTRI-Step;{next node below Top Left Index}
          if P2DTRI<1 then P2DTRI:=l-1;{Check chain numbers}
          if P2DTRI>L-1 then P2DTRI:=1;
          x2:=o[P2DTRI];y2:=p[P2DTRI];
          {y2>y1 always!!!}
          if y2<Mub then continue;
          if y1>Mdb then continue;

          dy:=y2-y1;{always dy>0!}
          if dy=0 then continue;{skip horizontal lines}
          dx:=x2-x1;
          if dx>0 then sx:=1 else sx:=-1;

          if y1<Mub then
             begin{Clip Top poligon edge}
  {           x:=x1+trunc(1/dy*(Mub-y1)*dx);{another version}
             x:=x2-trunc(1/dy*y2*dx);
             y1:=Mub;
             end
          else x:=x1;

          if y2>Mdb then y2:=Mdb; {Clip Bottom poligon edge}

          dx:=abs(dx);
          if dx>dy then begin StepX:=dx div dy;dx:=dx-StepX*dy;end
                   else StepX:=0;
          if sx<0 then begin StepX:=-StepX;end;

          e:=0;
          for y:=y1 to y2 do
              begin
              Rbd[y]:=x;
              x:=x+StepX;
              e:=e+dx;if e>=dy then begin x:=x+sx;e:=e-dy;end;
              end;

          if MinY>y1 then MinY:=y1;
          if MaxY<y2 then MaxY:=y2;

          end;

     Flag:=0;
     y1:=MinY;y2:=MaxY;
     For y:=y1 to y2 do
         begin
         if (Lbd[y]>MRbd[y])or(Rbd[y]<Mlbd[y]) then
            begin
            if flag=0 then inc(MinY) else dec(MaxY);
            continue;
            end;
         Flag:=1;
         if Lbd[y]<MLbd[y] then Lbd[y]:=MLbd[y];
         if Rbd[y]>MRbd[y] then Rbd[y]:=MRbd[y];
         end;

     BuildPoligonImage:=boolean(Flag);

{    for j:=MinY to MaxY do
        if Lbd[j]<=Rbd[j] then fillchar(vp^[j*320+Lbd[j]],Rbd[j]-Lbd[j]+1,15)
        else begin SavePositionToFile('Error.log');_Error('Lbd>Rbd!!! See "Error.log"...');end;
    for j:=2 to 6 do
        ClipLine(o[j-1],p[j-1],o[j],p[j],j*16-1);{}

end;

Procedure ShowPoly;
var
    XMSOffset,j:longint;
    Poligons:byte;
    Poligon:byte;
begin
     Poligons:=3;
     for Poligon:=1 to Poligons do
         begin
         case Poligon of
              1:begin
                With RoadFlat1 do
                     begin
                     X[0]:=30000;Y[0]:=0;Z[0]:=0;
                     X[1]:=0;Y[1]:=0;Z[1]:=0;
                     X[2]:=0;Y[2]:=30000;Z[2]:=0;
                     X[3]:=30000;Y[3]:=30000;Z[3]:=0;
                     X[4]:=30000;Y[4]:=0;Z[4]:=0;

                     BuildPoligonVectorsSystem(v11,v12,v13,v21,v22,v23,v31,v32,v33);
                     RScaling:=10;
                     end;
                end;
              2:begin
                With RoadFlat1 do
                     begin
                     X[0]:=30000;Y[0]:=000;Z[0]:=1000;
                     X[1]:=000;Y[1]:=000;Z[1]:=1000;
                     X[2]:=000;Y[2]:=000;Z[2]:=-1000;
                     X[3]:=30000;Y[3]:=000;Z[3]:=-1000;
                     X[4]:=30000;Y[4]:=000;Z[4]:=1000;

                     X[0]:=1000;Y[0]:=0;Z[0]:=400;
                     X[1]:=0;Y[1]:=0;Z[1]:=400;
                     X[2]:=0;Y[2]:=0;Z[2]:=0;
                     X[3]:=1000;Y[3]:=0;Z[3]:=0;
                     X[4]:=1000;Y[4]:=0;Z[4]:=400;

                     BuildPoligonVectorsSystem(v11,v12,v13,v21,v22,v23,v31,v32,v33);
                     RScaling:=1;
                     end;
                end;
              3:begin
                With RoadFlat1 do
                     begin
                     X[0]:=30000;Y[0]:=30000;Z[0]:=1000;
                     X[1]:=10000;Y[1]:=10000;Z[1]:=1000;
                     X[2]:=0;Y[2]:=0;Z[2]:=0;
                     X[3]:=30000;Y[3]:=30000;Z[3]:=0;
                     X[4]:=30000;Y[4]:=30000;Z[4]:=1000;

                     X[0]:=0;Y[0]:=300;Z[0]:=400;
                     X[1]:=1000;Y[1]:=300;Z[1]:=400;
                     X[2]:=1000;Y[2]:=300;Z[2]:=0;
                     X[3]:=0;Y[3]:=300;Z[3]:=0;
                     X[4]:=0;Y[4]:=300;Z[4]:=400;

                     BuildPoligonVectorsSystem(v11,v12,v13,v21,v22,v23,v31,v32,v33);
                     RScaling:=1;
                     end;
                end;

                end;


         if BuildPoligonImage(4,true) then
            with RoadFlat1 do
                 TexturateTheWall(X[0],Y[0],Z[0],
                                  v11,v12,v13,v21,v22,v23,v31,v32,v33,
                                  16384*longint(Poligon),
                                  RScaling,
                                  0);{}

         end;
end;

Procedure IncreaseCamerasAngle(du1,du2,du3:integer);
begin
     U1:=U1+du1;U2:=U2+du2;U3:=U3+du3;
     with Camera do
          begin
          CurAngle:=CurAngle+Angle+Angle;
          if CurAngle>MaxAngle then CurAngle:=MaxAngle;
          end;
end;

Procedure SetObjectsDirectionVector(_v1,_v2,_v3:double;var Obj:CameraRecord);
begin
     v1:=_v1;v2:=_v2;v3:=_v3;
     Obj.CurStep:=Obj.CurStep+10;
     if Obj.CurStep>Obj.MaxStep then Obj.CurStep:=Obj.MaxStep;
end;


{६饭    3 ࠭}
Procedure MovingCamera;
var iii:integer;
    FrameCnt,BTP:LongInt;
    XMSOffset:longint;
begin
     with Camera do
     begin
     WaitForACSReleased;
     Set_Handler;
     BTP:=BIOSTime;
     FrameCnt:=0;
     FPS:=0;
     repeat
{}           Camera.CurStep:=Camera.CurStep-5;if Camera.CurStep<0 then Camera.CurStep:=0;
{}           dec(Camera.CurAngle,Camera.Angle);if Camera.CurAngle<0 then Camera.CurAngle:=0;


            if KeyMap[47] then Constanta:=Constanta shl 1;
            if KeyMap[48] then Constanta:=Constanta shr 1;

           if KeyMap[20] then timer:=1-timer;
           if KeyMap[21] then TexturateMethod:=3-TexturateMethod;{}
           if KeyMap[25] then{}
              SavePositionToFile('Position.log');{}

           U1:=90;U2:=90;U3:=90;
           if KeyMap[75] then
              IncreaseCamerasAngle(-CurAngle,0,0);
           if KeyMap[77] then IncreaseCamerasAngle(CurAngle,0,0);
           if KeyMap[16] then IncreaseCamerasAngle(0,-CurAngle,0);
           if KeyMap[18] then IncreaseCamerasAngle(0,CurAngle,0);
           if KeyMap[71] then IncreaseCamerasAngle(0,0,-CurAngle);
           if KeyMap[73] then IncreaseCamerasAngle(0,0,CurAngle);

           RotateVectorsSystem(U1,U2,U3,v11,v12,v13,v21,v22,v23,v31,v32,v33);

           if KeyMap[74] then SetObjectsDirectionVector(v31,v32,v33,Camera);
           if KeyMap[78] then SetObjectsDirectionVector(-v31,-v32,-v33,Camera);
           if KeyMap[17] then SetObjectsDirectionVector(-v21,-v22,-v23,Camera);
           if KeyMap[31] then SetObjectsDirectionVector(v21,v22,v23,Camera);
           if KeyMap[30] then SetObjectsDirectionVector(-v11,-v12,-v13,Camera);
           if KeyMap[32] then SetObjectsDirectionVector(v11,v12,v13,Camera);{}

           if KeyMap[41] then
              With Camera do
                   RotateVectorsSystem(270,90,90,v11,v12,v13,v21,v22,v23,v31,v32,v33);

           X:=X+CurStep*v1;
           Y:=Y+CurStep*v2;
           Z:=Z+CurStep*v3;

           if (KeyMap[13])and(r<200) then begin lb:=lb-10;rb:=rb+10;ub:=ub-6;db:=db+6;r:=r+12;end;
           if (KeyMap[12])and(r>12) then begin lb:=lb+10;rb:=rb-10;ub:=ub+6;db:=db-6;r:=r-12;end;{}


           fillchar(vp^,64000,0);{}

           fillchar(ZB[0]^,64000,0);
           fillchar(ZB[1]^,64000,0);{}
           fillchar(ZB[2]^,64000,0);
           fillchar(ZB[3]^,64000,0);{}

           {Set some screen params}
           Mub:=Ub;Mdb:=Db;
           for i:=Ub to Db do begin MLbd[i]:=Lb;MRbd[i]:=Rb;end;{Fill the screen bounds}

           {Change gradation}
           if CurLiteGrad<FinLiteGrad then inc(CurLiteGrad)
                                       else CurLiteGrad:=0;

           ShowPoly;{}

           move(vp^,mem[$a000:0],64000);{}
           directvideo:=false;
{           gotoxy(1,1);
           case TexturateMethod of
                1:write('TMapping:Asm/FPU');
                2:write('TMapping:Pascal');
                end;
     Gotoxy(1,2);Write('Constanta=',Constanta);{}

     {========TIMER CODE=============================}
     Inc (FrameCnt);
     if timer=1 then
        begin
        if (BIOSTime-BTP >= 18) then
           begin
           FPS := Round(FrameCnt/(BIOSTime-BTP)*18.2);
           FrameCnt := 0;
           BTP := BIOSTime
           end;
        gotoxy(1,25);write('FPS:',FPS);
        end
     {================================================}


     until (keyMap[sEsc]) or (KeyMap[46]);
     Remove_Handler;
     end;
end;


{====================OBJECTS & ACTIONS=======================================}
Procedure CreatTheObject(_X,_Y,_Z:double;
                         _Sector:word;
                         _MaxStep:double;
                         _MaxAngle,
                         _Angle:integer;
                         var Obj:CameraRecord);
begin
     with Obj do
          begin
          X:=_X;Y:=_Y;Z:=_Z;
          Sector:=se;
          InitVectorSystem(v11,v12,v13,v21,v22,v23,v31,v32,v33);
          MaxStep:=_MaxStep;
          CurStep:=0;
          Step:=0;
          MaxAngle:=_MaxAngle;
          CurAngle:=0;
          Angle:=_Angle;
          end;
end;





Procedure AllocateNeededBasedMemory;
var s:string;
begin
     MemoryStatus:=9;
     msg_(0,7,0,'Allocating needed based memory');
     For i:=0 to 3 do
{10}      if maxavail>=sizeof(ZBuffer) then new(ZB[i])
          else _Error('Not enough based memory for Zbuffer!');
     inc(MemoryStatus);

{11} if maxavail>=sizeof(VideoBuffer) then begin new(Vp);inc(MemoryStatus);end
     else _Error('Not enough based memory for videobuffer!');
{12} if maxavail>=sizeof(TextureBuffer) then begin new(Tx);inc(MemoryStatus);end
     else _Error('Not enough based memory for textures buffer!');
{13} if maxavail>=sizeof(LightBuffer) then begin new(Lt);inc(MemoryStatus);end
     else _Error('Not enough based memory for light buffer!');

end;


{樠  ࠬ஢}
Procedure InitParams;
var i,j:integer;
    g,c:integer;
    Color,Gradation:byte;
begin
     Constanta:=2097152;
     R:=200;k4:=R div 20;
     ScreenX:=160;ScreenY:=100;
     {Screen bounders}
     lb:=(200-r)*10 div 12;
     rb:=319-lb;
     ub:=(200-r)*6 div 12;
     db:=199-ub;
     {Optional}
     TexturateMethod:=1;
     Timer:=1;
     {Lite}
     StaLiteGrad:=2;
     CurLiteGrad:=2;
     FinLiteGrad:=15;

     for i:=0 to 359 do
         sn[i]:=sin(pi/180*i);

     {Creating the Camera object}
     CreatTheObject(500,150,200,0,r/2,15,1,Camera);
{
Camera.X:= 3.60009248219435E+0003;Camera.Y:= 9.01271761350980E+0003;Camera.Z:= 2.81391696839882E+0003;
Camera.v11:= 8.36543049493525E-0001;Camera.v12:= 4.23883621850981E-0001;Camera.v13:=-3.47157603215841E-0001;
Camera.v21:=-3.24299333155951E-0001;Camera.v22:= 8.93771130551421E-0001;Camera.v23:= 3.09843684311039E-0001;
Camera.v31:= 4.41617106619160E-0001;Camera.v32:=-1.46614601316950E-0001;Camera.v33:= 8.85143203002764E-0001;
{}
     With Camera do RotateVectorsSystem(0,90,90,v11,v12,v13,v21,v22,v23,v31,v32,v33);{---}
end;

{㦠 }
Procedure LoadAll;
begin
     msg_(0,7,0,'Looking for extended memory:');
     if XMSInstalled = 0 then _Error('Your computer has no extended memory!');
     if HimemInstalled then msg_(3,8,0,'HIMEM.SYS is installed.')
                       else _Error('HIMEM.SYS is not installed!');
     msg_(3,8,0,'Maximum free XMS memory block has '+itos(XMSLargest)+' Kb');

     msg_(0,7,0,'Loading all needed data:');

{14} LoadTextures('texture.3dm');

end;
{============================================================================}

Procedure PlayGame;
begin
     Init13h;
     MovingCamera;{}
end;

BEGIN

clrscr;
randomize;
AllocateNeededBasedMemory;
InitParams;
LoadAll;
PlayGame;
_Error('Death Track.');
end.