Unit XMS;
{$G+}
Interface

Type
  XMMRec = Record
    Size    : LongInt;
    DSource : Word;
    OSource : Pointer;
    DDest   : Word;
    ODest   : Pointer
  End;

Var
  XMMAddr   : Pointer;                  { Himem service entry point address }
  XMMVersion: Word;                     { Himem version }
  XMMError  : Byte;                     { Contains error code or 0 after calling Himem services }
  HMAAvaible: Boolean;

Function XMSInstalled : Word;
Function HimemInstalled : Boolean;
Procedure GetHMA (Size : Word); { Bytes }
Procedure FreeHMA;
Procedure EnableA20G;
Procedure DisableA20G;
Procedure EnableA20L;
Procedure DisableA20L;
Function ActiveA20 : Boolean;
Function XMSFree : Word; { KBytes }
Function XMSLargest : Word; { KBytes }
Procedure GetXMS (Var Desc : Word; Size : Word); { KBytes }
Procedure FreeXMS (Desc : Word);
Procedure XMS_move (Var MRec : XMMRec;_DSource : Word; _SOfs,_SSeg:word;
                    _DDest   : Word; _DOfs,_DSeg:word;
                    _Size : LongInt);

{Procedure MoveXMS2 (_DSource : Word; _OSource : Pointer;
                    _DDest : Word; _ODest : Pointer; _Size : LongInt);{}
Procedure LockXMS (Desc : Word; Var AbsAddr : LongInt);
Procedure UnLockXMS (Desc : Word);
Procedure GetInfoXMS (Desc : Word; Var Size : Word; Var Locks : Byte); { KB }
Procedure ResizeXMS (Desc, Size : Word); { KBytes }
Function UMBFree : Word; { Paragraphs }
Procedure GetUMB (Var UMBSeg : Word; Var FactPrgrfs : Word; Prgrfs : Word);
Procedure FreeUMB (UMBSeg : Word);

Implementation

Function XMSInstalled : Word; Assembler;
{ May not work properly if computer has 64MB RAM or more. }
{ I have not checked this yet. }
Asm
  Mov   AL, 30h
  Out   70h, AL
  Jmp   @in1
@in1:
  In    AL, 71h
  Mov   BL, AL
  Mov   AL, 31h
  Out   70h, AL
  Jmp   @in2
@in2:
  In    AL, 71h
  Mov   AH, AL
  Mov   AL, BL
End;

Function HimemInstalled : Boolean; Assembler;
Asm
  Mov   Word Ptr XMMAddr, 0
  Mov   Word Ptr XMMAddr+2, 0
  Mov   AX, 4300h
  Int   2Fh
  Cmp   AL, 80h
  JE    @GetAddr
  Xor   AL, AL
  Jmp   @End
@GetAddr:
  Mov   AX, 4310h
  Int   2Fh
  Mov   Word Ptr XMMAddr, BX
  Mov   Word Ptr XMMAddr+2, ES
@GetVer:
  Xor   AH, AH
  Call  DWord Ptr XMMAddr
  Mov   XMMVersion, AX
  Mov   HMAAvaible, DL
  Mov   AL, 1
@End:
End;

Procedure GetHMA (Size : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Size
  Mov   AH, 1
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure FreeHMA; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AH, 2
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure EnableA20G; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AH, 3
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure DisableA20G; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AH, 4
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure EnableA20L; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AH, 5
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure DisableA20L; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AH, 6
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Function ActiveA20 : Boolean; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AH, 7
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Function XMSFree : Word; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   XMMError, 80h
  JZ    @End
  Mov   AH, 8
  Call  DWord Ptr XMMAddr
  Mov   XMMError, BL
  Mov   AX, DX
@End:
End;

Function XMSLargest : Word; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   XMMError, 80h
  JZ    @End
  Mov   AH, 8
  Call  DWord Ptr XMMAddr
  Mov   XMMError, BL
@End:
End;

Procedure GetXMS (Var Desc : Word; Size : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Size
  Mov   AH, 9
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
  Mov   DI, Word Ptr Desc
  Mov   ES, Word Ptr Desc+2
  Mov   ES:[DI], DX
End;

Procedure FreeXMS (Desc : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Desc
  Mov   AH, 0Ah
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure XMS_move (var MRec:XMMRec;{}_DSource : Word; _SOfs,_SSeg:word;
                    _DDest   : Word; _DOfs,_DSeg:word;
                    _Size : LongInt);
begin
  With MRec do
       begin
       Size := _Size;
       DSource := _DSource;
       OSource := PTR(_SSeg,_SOfs);{_OSource;}
       DDest := _DDest;
       ODest := PTR(_DSeg,_DOfs);{_ODest;}
       end;

Asm
  Push  DS
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   AX, DS
  Mov   ES, AX
  Mov   SI, Word Ptr MRec
  Mov   DS, Word Ptr MRec+2
  Mov   AH, 0Bh
  Call  DWord Ptr ES:XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Pop   DS
  Mov   XMMError, BL
end;
End;

Procedure LockXMS (Desc : Word; Var AbsAddr : LongInt); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Desc
  Mov   AH, 0Ch
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Mov   DI, Word Ptr AbsAddr
  Mov   ES, Word Ptr AbsAddr+2
  Mov   ES:[DI],BX
  Mov   ES:[DI+2],DX
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure UnLockXMS (Desc : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Desc
  Mov   AH, 0Dh
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure GetInfoXMS (Desc : Word; Var Size : Word; Var Locks : Byte); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Desc
  Mov   AH, 0Eh
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Mov   DI, Word Ptr Size
  Mov   ES, Word Ptr Size+2
  Mov   ES:[DI], DX
  Mov   DI, Word Ptr Locks
  Mov   ES, Word Ptr Locks+2
  Mov   ES:[DI], BH
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure ResizeXMS (Desc, Size : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Desc
  Mov   BX, Size
  Mov   AH, 0Fh
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Function UMBFree : Word; Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, 0FFFFh
  Mov   AH, 10h
  Call  DWord Ptr XMMAddr
  Cmp   BL, 0B1h
  JNE   @1
  Xor   DX, DX
  Xor   BL, BL
  Jmp   @End
@1:
  Cmp   BL, 0B0h
  JNE   @2
  Xor   BL, BL
  Jmp   @End
@2:
  Xor   DX, DX
@End:
  Mov   XMMError, BL
  Mov   AX, DX
End;

Procedure GetUMB (Var UMBSeg : Word; Var FactPrgrfs : Word; Prgrfs : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, Prgrfs
  Mov   AH, 10h
  Call  DWord Ptr XMMAddr
  Mov   DI, Word Ptr FactPrgrfs
  Mov   ES, Word Ptr FactPrgrfs+2
  Mov   ES:[DI], DX
  Or    AX, AX
  JZ    @End
  Mov   DI, Word Ptr UMBSeg
  Mov   ES, Word Ptr UMBSeg+2
  Mov   ES:[DI], BX
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

Procedure FreeUMB (UMBSeg : Word); Assembler;
Asm
  Mov   AX, Word Ptr XMMAddr
  Or    AX, Word Ptr XMMAddr+2
  Mov   BL, 80h
  JZ    @End
  Mov   DX, UMBSeg
  Mov   AH, 11h
  Call  DWord Ptr XMMAddr
  Or    AX, AX
  JZ    @End
  Xor   BL, BL
@End:
  Mov   XMMError, BL
End;

End.
