Unit XmsTools;
Interface
   Var
      XMS_Error:byte; {0-ok}
      XMSDrv:procedure;
      Function  XMS_Total_Free:word;
      Function  XMS_Free_Block:word;        {ᮮ頥 . ᢮  }
      Function  XMS_Get_Mem(Size:word):word;{ ,.- handle}
      Procedure XMS_Release(Handle:word);   {᢮}
      Procedure XMS_Move(
                 SourceHandle:word;  SourceOffset:word; SourceSegment:word;
                 DestHandle  :word;  DestOffset  :word; DestSegment  :word;
                 Size        :Longint);     {Handle=0-() }
      Procedure XMS_Lock(Handle:word);      {Protected Mode}
      Procedure XMS_Unlock(Handle:word);
      Function  XMS_Get_Size(Handle:word):word;{  }
      Function  XMS_Handles_Avail(Handle:word):byte;
      Function  XMS_Lock_Count(Handle:word):byte;
      Procedure XMS_Resize(Handle,NewSize:word);{ ࠧ Handle}
Implementation
   Var

      XMSLoaded:byte;
      DrvSeg,DrvOfs:word;
      tmp:word;
      tmp1:byte;

      Procedure UseXMS;assembler;
      label ok;
      asm
         call XMSDrv
         mov  XMS_Error,0
         cmp  ax,1
         je   ok
         mov  XMS_Error,bl
         ok:
      end;

      Function  XMS_Total_Free:word;
      begin
         asm
            mov  ah,8
            call XMSDrv
            mov  tmp,dx
            mov  XMS_Error,bl
         end;
         XMS_Total_Free:=tmp;
      end;

      Function  XMS_Free_Block:word;
      begin
         asm
            mov  ah,8
            call XMSDrv
            mov  tmp,ax
            mov  XMS_Error,bl
         end;
         XMS_Free_Block:=tmp;
      end;

      Function  XMS_Get_Mem(Size:word):word;
      begin
         asm
            mov  ah,9
            mov  dx,size
            call UseXMS
            mov  tmp,dx
         end;
         XMS_Get_Mem:=tmp;
      end;

      Procedure XMS_Release(Handle:word);
      begin
         asm
            mov  ah,10
            mov  dx,handle
            call UseXMS
         end;
      end;

      Procedure XMS_Move(
                 SourceHandle:word;  SourceOffset:word; SourceSegment:word;
                 DestHandle  :word;  DestOffset  :word; DestSegment  :word;
                 Size        :Longint);
      var
        Buffer:record
             Sz:Longint;
             SoHa:Word;
             SoOf:Word;
             SoSg:Word;
             DeHa:Word;
             DeOf:Word;
             DeSg:Word;
        end;
        BufSeg,BufOfs:Word;
        _ds:word;
        proc:procedure;
        err:byte;
        f:word;
      begin
        with Buffer do begin
           Sz:=Size;
           SoHa:=SourceHandle;
           SoOf:=SourceOffset;
           SoSg:=SourceSegment;
           DeHa:=DestHandle;
           DeOf:=DestOffset;
           DeSg:=DestSegment;
        end;
        BufSeg:=Seg(Buffer);
        BufOfs:=Ofs(Buffer);
        proc:=XMSDrv;
        asm
           mov  dx,ds
           mov  _ds,dx
           mov  si,BufOfs
           mov  ax,BufSeg
           mov  ds,ax
           mov  ah,11
           call proc
           mov  dx,_ds
           mov  ds,dx
           mov  f,ax
           mov  err,bl
        end;
        if f=0 then XMS_Error:=err
               else XMS_Error:=0;
      end;

      Procedure XMS_Lock(Handle:word);
      begin
         asm
            mov  ah,12
            mov  dx,Handle
            call UseXMS
         end;
      end;

      Procedure XMS_Unlock(Handle:word);
      begin
         asm
            mov  ah,13
            mov  dx,Handle
            call UseXMS
         end;
      end;

      Function  XMS_Get_Size(Handle:word):word;
      begin
         asm
            mov  ah,14
            mov  dx,Handle
            call UseXMS
            mov  tmp,dx
         end;
         XMS_Get_Size:=tmp;
      end;

      Function  XMS_Handles_Avail(Handle:word):byte;
      begin
         asm
            mov  ah,14
            mov  dx,Handle
            call UseXMS
            mov  tmp1,bl
         end;
         XMS_Handles_Avail:=tmp1;
      end;

      Function  XMS_Lock_Count(Handle:word):byte;
      begin
         asm
            mov  ah,14
            mov  dx,Handle
            call UseXMS
            mov  tmp1,bh
         end;
         XMS_Lock_Count:=tmp1;
      end;

      Procedure XMS_Resize(Handle,NewSize:word);
      begin
         asm
            mov  ah,15
            mov  dx,Handle
            mov  bx,NewSize
            call UseXMS
         end;
      end;

Begin
      asm
         mov  ax,4300h
         int  2fh
         mov  XMSLoaded,al
      end;
      if not (XMSLoaded=$80) then begin
         Writeln('XMS driver is not found!');
         Halt(255);
      end;
      asm
         mov  ax,4310h
         int  2fh
         mov  ax,es
         mov  DrvSeg,ax
         mov  DrvOfs,bx
      end;
      @XMSDrv:=ptr(DrvSeg,DrvOfs);
End.
