{$IFDEF DPMI}
FOR REAL MODE ONLY!!! (not Protected mode)
{$ENDIF}{$IFDEF WINDOWS}
FOR REAL MODE ONLY!!! (not Windows)
{$ENDIF}

{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}                                                                                     {

{$Happy_Birthday+,$Best_Wishes+,$Birthday_Person=Sergey_Chapkin}

{ $DEFINE DEBUG}    { delete space before $ to look all sprites }
{ $DEFINE FINAL}    { delete space before $ to look "birthday" screen }


Uses Dos,Crt,Key,Sounds,SBReal,Intro;
Const
      PalMask = $36C;
      PalRegR = $3C7;
      PalRegW = $3C8;
      PalData = $3C9;

      FadeSpeed = 20; { Fading speed }

      SN = 9;
      SpellN : Array[1..SN] of String[10] =
      ('PORTAL','XORMINUS','XORPLUS','XORTEST','TELIPORT','WORM','OUT','FAC',
       'PRESENT');

Type TPalette = Array[0..255] of record R,G,B : Byte; End;
     TFont = Array[128..255,0..7] of byte;
     TFont2 = Array[0..255,0..5] of byte;

Var
DBuf : Pointer; { Double Buffer }
Fnt : ^TFont;
Fnt2 : ^TFont2;
SegDB : Word;   { Segment of double-buffer }
Pal,NullPal : TPalette; { Palette for sprites and clear palette }
Spr : Array[1..100] of Pointer; { Sprites }
W,H : Array[1..100] of Word; { Sprite dimensions }
NSpr : LongInt;
Ch : Char;
A,B,C : LongInt;
CrowdA : LongInt;
S : String;
Time : LongInt;
Timer : LongInt absolute $40:$6c;
GetBack : Byte;
HLoc,HSpeed,Hx,Hy,HDir,HAni : LongInt;
Txt : Array[1..100] of record N : LongInt;S : Array[1..20] of ^String; End;
sp1,sp2,NTxt : LongInt;
V : Array[1..100] of LongInt; { quest variables }
{
  1.  =1 if the portal is open
  2.  =0 if Merlin didn't speak
      =1 if Task#1 is on the floor
      =2 if 1st spell was casted
      =3 if 2nd spell was casted
      =4 if portal was opened
  3.  =1 after talk with Merlin (dog shown)
      =2 dog is worm
      =3 if portal was opened
}

{$L fnt}
{$L pal}
{$L spr}
{$L fnt2}
{$L talk}
Procedure GameFont; far; external;
Procedure MyFont; far; external;
Procedure GamePalette; far; external;
Procedure GameSprites; far; external;
Procedure Talk; far; external;

Procedure SetPalReg(index,Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegW]:=index;
  Port[PalData]:=Red;
  Port[PalData]:=Green;
  Port[PalData]:=Blue;
End;

procedure VRT; assembler;
asm
  mov dx,3DAh
@VRT1:
  in al,dx
  test al,8
  jnz @VRT1
@VRT2:
  in al,dx
  test al,8
  jz @VRT2
end;

Procedure PlaySnd(x : LongInt);
Begin
  PlayRaw(SndData[x],SndSize[x],11000);
End;

type
 ar=array [0..65534] of byte;

var
  page:pointer;
  x,y,z:integer;
  sintable,
  costable : Array [0..255] of longint;
  sqrttable: ^ar;

Procedure PrintD(S : String;x,y : Word; color : Byte);
Var i,x1,y1,Off : Word;

  Procedure Prt(Ch : Char;x,y,off : Word; color : Byte);
  Var WrkSeg,WrkOff,x2,y2,TOff : Word;
  BitMask,O : Byte;
  Begin
    If Ord(Ch)<128 then
    Begin
      TOff:=Off;
      WrkSeg:=$F000+(ord(Ch) shr 1);
      WrkOff:=$FA6E+((Ord(Ch) and 1) shl 3);
      For y:=0 to 7 do
      Begin
        BitMask:=$80;
        For x:=0 to 7 do
        Begin
          If Mem[WrkSeg:WrkOff] and BitMask<>0 then Mem[SegDB:(TOff+x)]:=color else
            If GetBack<>$FE then Mem[SegDB:(TOff+x)]:=GetBack;
          BitMask:=BitMask shr 1;
        End;
        Inc(TOff,320);
        Inc(WrkOff);
      End;
    End else
    Begin
      TOff:=Off;
      O:=Ord(CH);
      For y:=0 to 7 do
      Begin
        BitMask:=$80;
        For x:=0 to 7 do
        Begin
          If Fnt^[o,y] and BitMask<>0 then Mem[SegDB:(TOff+x)]:=color else
            If GetBack<>$FE then Mem[SegDB:(TOff+x)]:=GetBack;
          BitMask:=BitMask shr 1;
        End;
        Inc(TOff,320);
      End;
    End;
  End;

Begin
  x1:=x;y1:=y;
  Off:=(y shl 8)+(y shl 6)+x;
  For i:=1 to length(s) do
  Begin
    Prt(s[i],x1,y1,off,color);
    Inc(x1,8);
    Inc(off,8);
  End;
End;

Procedure Print2(S : String;x,y : Word; color : Byte);
Var i,x1,y1,Off : Word;

  Procedure Prt(Ch : Char;x,y,off : Word; color : Byte);
  Var WrkOff,x2,y2,TOff : Word;
  BitMask,O : Byte;
  Begin
    TOff:=Off;
    O:=Ord(CH);
    For y:=0 to 5 do
    Begin
      BitMask:=$20;
      For x:=0 to 5 do
      Begin
        If Fnt2^[o,y] and BitMask<>0 then
        Begin
          Mem[SegDB:(TOff+x)]:=color;
          Mem[SegDB:(TOff+x+160)]:=color;
          Mem[SegDB:(TOff+x+320)]:=color;
        End;
        BitMask:=BitMask shr 1;
      End;
      Inc(TOff,320);
    End;
  End;

Begin
  x1:=x;y1:=y;
  Off:=y*80+x;
  For i:=1 to length(s) do
  Begin
    Prt(s[i],x1,y1,off,color);
    Inc(x1,6);
    Inc(off,6);
  End;
End;

procedure SetPal (c, r, g, b : Byte); Assembler;
ASM
  mov  dx, 3c8h
  mov  al, c
  out  dx, al
  inc  dx
  mov  al, r
  out  dx, al
  mov  al, g
  out  dx, al
  mov  al, b
  out  dx, al
End;

Procedure InitMode; { unchained 80x133 }
var
  x : Byte;

Begin
  ASM
    mov  ax, 13h
    int  10h
    mov  dx, 3c4h
    mov  al, 4
    out  dx, al
    inc  dx
    in   al, dx
    and  al, 0F7h
    or   al, 4h
    out  dx, al
    dec  dx
    mov  ax, 0F02h
    out  dx, ax
    mov  ax, 0A000h
    mov  es, ax
    xor  di, di
    xor  ax, ax
    mov  cx, 0ffffh
    rep  stosw
    mov  dx, 3D4h
    mov  al, 14h
    out  dx, al
    inc  dx
    in   al, dx
    and  al, 0BFh
    out  dx, al
    dec  dx
    mov  al, 17h
    out  dx, al
    inc  dx
    in   al, dx
    or   al, 40h
    out  dx, al
    mov  dx, 3D4h
    mov  al, 9
    out  dx, al
    inc  dx
    in   al, dx
    and  al, 70h
    out  dx, al
    mov  dx, 03C4h
    mov  al, 2
    mov  ah, 0Fh
    out  dx, ax
  End;
  For x := 0 to 63 do Begin
    SetPal (x,     x, 0, 0);
    SetPal (x+64,  0, x, 0);
    SetPal (x+128, 0, 0, x);
  End;
End;

procedure pixel(x,y:integer;r,g,b:byte);
begin
 asm
  mov es,word(page+2)
  mov ax,y
  mov bx,ax
  shl ax,6
  shl bx,4
  add bx,ax
  add bx,x

  mov al,es:[bx]
  add al,r
  cmp al,63
  jbe @ok
  mov al,63
  @ok:
  mov es:[bx], al

  add bx, 133*80

  mov al,es:[bx]
  add al,g
  cmp al,63
  jbe @ok2
  mov al,63
  @ok2:
  mov es:[bx], al

  add bx, 133*80

  mov al,es:[bx]
  add al,b
  cmp al,63
  jbe @ok3
  mov al,63
  @ok3:
  mov es:[bx], al
 end;
end;

procedure viewpage;
var
 x,y:word;
begin
 asm
  push ds
  mov  es,SegDB
  mov  ds,word (page+2)
  xor  si,si
  xor  di,di
  mov  cx,130
  @xhere:
    mov bx,80/4
    @yhere:
 {     mov ax,[si]
      mov es:[di],ax
      mov ax,[si+2]
      mov es:[di+2],ax
      mov ax,[si+$2990]
      add ax,$4040
      mov es:[di+320],ax
      mov ax,[si+$2992]
      add ax,$4040
      mov es:[di+322],ax
      mov ax,[si+$5320]
      add ax,$8080
      mov es:[di+640],ax
      mov ax,[si+$5322]
      add ax,$8080
      mov es:[di+642],ax}
     db $66;mov ax,ds:[si]
     db $66;mov es:[di],ax
     db $66;mov ax,ds:[si+10640]
     db $66;add ax,$4040;dw $4040
     db $66;mov es:[di+80], ax
     db $66;mov ax,ds:[si+21280]
     db $66;add ax,$8080;dw $8080
     db $66;mov es:[di+160], ax
     add si,4
     add di,4
     dec bx
   jnz @yhere
   add di,160
   dec cx
  jnz @xhere
  pop ds
 end;
end;

procedure blur;
var
 x,y:word;
 c:integer;
begin
 asm
  mov es, word(page+2)
  xor di, di
  mov cx, 133*80*3-1
  @here:
   mov al, es:[di]
   mov ah, al
   shr al, 1
   shr ah, 2
   add al, ah
   mov es:[di], al
   inc di
   dec cx
  jnz @here
 end;
end;

procedure light (j, k:word;c1,c2,c3:byte);
var
 x,y,z:integer;
 c,d:integer;
 r,g,b:byte;

begin
 for x := 0 to 63 div 2 do
   for y := 0 to 63 do begin
     d := sqrttable^[sqr(x shl 1-31)+sqr(y-31)];
     r := (costable [d]{*d div 64})div c1;
     g := (costable [d]{*d div 64})div c2;
     b := (costable [d]{*d div 64})div c3;
 asm
  mov es,word(page+2)
  mov ax,y
  add ax,k
  mov bx,ax
  shl ax,6
  shl bx,4
  add bx,ax
  add bx,x
  add bx,j
  mov al,es:[bx]
  add al,r
  cmp al,63
  jbe @ok
  mov al,63
  @ok:
  mov es:[bx], al

  add bx, 133*80

  mov al,es:[bx]
  add al,g
  cmp al,63
  jbe @ok2
  mov al,63
  @ok2:
  mov es:[bx], al

  add bx, 133*80

  mov al,es:[bx]
  add al,b
  cmp al,63
  jbe @ok3
  mov al,63
  @ok3:
  mov es:[bx], al
  end;
 end;
end;

var rr,gg,bb : Byte;
    rp,gp,bp : ShortInt;
    go : LongInt;

Procedure ShowPict;
Begin
  SetPal(255,rr,gg,bb);
  Print2('Happy',25,140,255);
  Print2('Birthday!',14,180,255);
  Inc(go);
  If go and 3=0 then
  Begin
    Inc(rr,rp);
    If (rr<1) or (rr>62) then rp:=-rp;
    Inc(gg,gp);
    If (gg<1) or (gg>62) then gp:=-gp;
    Inc(bb,bp);
    If (bb<1) or (bb>62) then bp:=-bp;
  End;
End;

Procedure ShowDouble2; assembler;
Asm
  Push ds
  Mov ax,SegA000
  Mov es,ax
  Mov di,0
  Mov cx,16000
  Mov ax,SegDB
  Mov ds,ax
  Mov si,0
  Cld
  Rep MovsW
  Pop ds
End;

Procedure ClsD2(Color : Byte); assembler;
asm
  mov es,SegDB
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,16000
  Cld
  rep stosw
End;

Procedure ShowBirth;
var
  w:word;
begin
  asm
    mov ax,3
    int 10h
  end;
  PlaySnd(1);
  rr:=63;
  gg:=20;
  bb:=40;
  rp:=-1;
  gp:=1;
  bp:=-1;
  go:=0;
  getmem (page, 32768+16);
  if ofs(page^)<>0 then
  Begin
    page:=Ptr(Ofs(Page)+1,0);
  End;
  fillchar(page^,32000,0);
  InitMode;
  new(sqrttable);
  for x:=0 to 255 do begin
    sintable[x]:= round(sin(x*2*pi/256)*31);
    costable[x]:=-round(cos(x*2*pi/192)*31)+32;
  end;
  for w:=0 to 65534 do begin
    x:=63-round(sqrt(w))*2;
    if x>63 then x:=0;
    if x<0 then x:=0;
    sqrttable^[w]:=x;
  end;
  clsd2(0);
  While port[$60]<>1 do begin
    light (round(sin(x*2*pi/90)*25)+23, round(cos(x*2*pi/180)*35)+36, 3,3,1);
    light (round(sin(y*2*pi/90)*25)+23, round(cos(y*2*pi/180)*35)+36, 3,1,3);
    light (round(sin(z*2*pi/90)*25)+23, round(cos(z*2*pi/180)*35)+36, 1,3,3);
    viewpage;
    blur;
    VRT;
    ShowPict;
    ShowDouble2;
    inc (x, 1);
    inc (y, 2);
    inc (z, -3);
  End;
  asm
    mov  ax, 03h
    int  10h
  End;
  While KeyPressed do ReadKey;
  Halt;
End;

Procedure GrInit;
var a,b,c : longint;
s,o : Word;
Begin
  New(Fnt);
  S:=Seg(GameFont);
  O:=Ofs(GameFont);
  c:=0;
  For a:=128 to 255 do
    For b:=0 to 7 do
    Begin
      Fnt^[a,b]:=Mem[S:O+c];
      Inc(c);
    End;
  New(Fnt2);
  S:=Seg(MyFont);
  O:=Ofs(MyFont);
  c:=6;
  For a:=0 to 255 do
    For b:=0 to 5 do
    Begin
      Fnt2^[a,b]:=Mem[S:O+c];
      Inc(c);
    End;
  GetMem(DBuf,64000+16);
  SegDB:=Seg(DBuf^)+1;
  asm
    mov ax,13h
    int 10h
  end;
End;

Procedure GrDone;
Begin
  FreeMem(DBuf,64000+16);
  asm
    mov ax,3
    int 10h
  end;
End;

Procedure PixelD(x,y : Word;Color : Byte); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  Mov al,Byte Ptr color
  Mov es : [di],al
End;

Procedure GetPalReg(index : Byte; Var Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegR]:=index;
  Red:=Port[PalData];
  Green:=Port[PalData];
  Blue:=Port[PalData];
End;

Procedure SetPalette(Pal : TPalette);
Var I : Byte;
Begin
  For I:=0 to 255 do SetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Procedure GetPalette(Var Pal :TPalette);
Var I : Byte;
Begin
  For I:=0 to 255 do GetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;


Procedure FadePal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=FadeSpeed downto 0 do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure LightPal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=0 to FadeSpeed do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure ShowDouble; assembler;
Asm
  Push ds
  Mov ax,SegA000
  Mov es,ax
  Mov di,0
  Mov cx,32000
  Mov ax,SegDB
  Mov ds,ax
  Mov si,0
  Cld
  Rep MovsW
  Pop ds
End;

Procedure Cls(Color : Byte); assembler;
asm
  mov ax,0A000h
  mov es,ax
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure ClsD(Color : Byte); assembler;
asm
  mov es,SegDB
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure ShowTransD(x,y,w,h : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,h
  mov bx,w
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,$FE
  jz @Met3
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  Loop @Met1
  Pop ds
End;

Procedure ShowRevD(x,y,w,h : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,h
  mov bx,w
  add di,bx
  dec di
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,$FE
  jz @Met3
  mov es:[di],al
@Met3:
  dec di
  inc si
  loop @Met2
  pop cx
  add di,320
  add di,bx
  Loop @Met1
  Pop ds
End;

procedure ShowImageD(x,y : Integer;spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov bx,16
  lds si,spr
@Met1 :
  mov cx,8
  rep movsw
  add di,304
  dec bx
  jnz @Met1
  Pop ds
End;

Procedure LoadAll;
Var S,O : Word;
Ss : String;
  Procedure GetNext;
  Begin
    ss:='';
    While Mem[S:O]<>13 do
    Begin
      ss:=ss+Char(Mem[S:O]);
      Inc(O);
    End;
    Inc(O,2);
  End;
Begin
  S:=Seg(GameSprites);
  O:=Ofs(GameSprites);
  For A:=1 to 86 do
  Begin
    W[A]:=MemW[S:O];
    H[A]:=MemW[S:O+2];
    GetMem(Spr[A],W[A]*H[A]);
    Move(Mem[S:O+4],Spr[A]^,W[A]*H[A]);
    Inc(O,4+W[A]*H[A]);
  End;
  Pal:=TPalette((@GamePalette)^);

  S:=Seg(Talk);
  O:=Ofs(Talk);
  NTxt:=0;
  While True do
  Begin
    GetNext;
    If Ss[1]='~' then Break;
    If Ss[1]='_' then
    Begin
      Inc(NTxt);
      Txt[NTxt].N:=0;
    End else
    Begin
      With Txt[NTxt] do
      Begin
        Inc(N);
        If N>20 then Begin WriteLn('BAD'); Halt; End;
        GetMem(S[N],Length(Ss)+1);
        S[N]^:=Ss;
      End;
    End;
  End;
  SndData[1]:=@Snd1;
  SndData[2]:=@Snd2;
  SndData[3]:=@Snd3;
End;

Procedure CheckMainEvent;
Begin
End;

Procedure ShowCrowd;
Var A,B,Save : LongInt;
Begin
  Save:=RandSeed;
  RandSeed:=35325;
  For A:=0 to 17 do
    For B:=0 to 4 do
    Begin
      ShowTransD(A*17+5,B*11,17,11,Spr[61+Random(11)*2+(((CrowdA and 15)*(Random(10)+1)) div 16) and 1]);
    End;
  RandSeed:=Save;
End;

Function Around(X,Y : LongInt) : Boolean;
Begin
  Around:=(Abs(X-HX)<23) and (Abs(Y-HY)<27);
End;

Procedure ShowText(T : LongInt);
Var A,B : LongInt;
Begin
  For A:=0 to 319 do
    For B:=20 to 180 do
      PixelD(A,B,1);
  GetBack:=1;
  For A:=1 to Txt[T].N do
    PrintD(Txt[T].S[A]^,0,A*8+20,14);
  ShowDouble;
  repeat until not pressed[scspace];
  repeat
  until pressed[scenter] or pressed[scEsc] or pressed[scSpace];
  repeat
  until not pressed[scenter] and not pressed[scesc] and not pressed[scspace];
End;

Procedure StartCrowd;
Begin
  If CrowdA=0 then
  Begin
    CrowdA:=1;
    PlaySnd(1);
  End;
End;

Procedure ShowAll; forward;

Procedure ShowSpell;
Var A,B : LongInt;
Begin
  PlaySnd(2);
  FillChar(NullPal,768,63);
  SetPalette(NullPal);
  time:=timer;
  repeat until timer-time>3;
  FillChar(NullPal,768,0);
  SetPalette(Pal);
  Time:=Timer;
  Repeat
    A:=Random(10);
    B:=Random(10);
    Move(Mem[SegDB:A*320+B],Mem[SegA000:0],(200-A)*320-320-B);
  Until Timer-Time>5;
  ShowDouble;
End;

Function Check1 : Boolean;
  Function XorPlus(V : Byte) : Byte; forward;
  Function XorMinus(V : Byte) : Byte;
  Begin
    V:=V xor 1;
    If V=1 then V:=0 else V:=XorPlus(V);
    XorMinus:=V;
  End;
  Function XorPlus(V : Byte) : Byte;
  Begin
    V:=V xor 1;
    If V=0 then V:=XorMinus(V);
    XorPlus:=V;
  End;
  Function XorTest(V : Byte) : Byte;
  Begin
    V:=XorMinus(V); V:=V xor 1; V:=XorPlus(V);
    If V=0 then V:=XorMinus(V) else V:=XorPlus(V);
    XorTest:=V;
  End;
Var A,B : Byte;
Begin
  Case sp1 of
  2: Case sp2 of
     2: Begin A:=XorMinus(XorMinus(0));B:=XorMinus(XorMinus(1)); End;
     3: Begin A:=XorPlus(XorMinus(0));B:=XorPlus(XorMinus(1)); End;
     4: Begin A:=XorTest(XorMinus(0));B:=XorTest(XorMinus(1)); End;
     End;
  3: Case sp2 of
     2: Begin A:=XorMinus(XorPlus(0));B:=XorMinus(XorPlus(1)); End;
     3: Begin A:=XorPlus(XorPlus(0));B:=XorPlus(XorPlus(1)); End;
     4: Begin A:=XorTest(XorPlus(0));B:=XorTest(XorPlus(1)); End;
     End;
  4: Case sp2 of
     2: Begin A:=XorMinus(XorTest(0));B:=XorMinus(XorTest(1)); End;
     3: Begin A:=XorPlus(XorTest(0));B:=XorPlus(XorTest(1)); End;
     4: Begin A:=XorTest(XorTest(0));B:=XorTest(XorTest(1)); End;
     End;
  End;
  If (A=1) and (B=1) then Check1:=True else Check1:=False;
End;

Procedure ShowLocation;
Begin
  Case HLoc of
  1:
    Begin
      ShowRevD(250,150,17,21,Spr[49]);
      If V[1]=1 then ShowTransD(50,100,17,11,Spr[86]);
    End;
  2:
    Begin
      ShowTransD(10,170,17,21,Spr[47]);
      If V[2] in [1..3] then
      Begin
        GetBack:=0;
        PrintD(':   ।',20,70,5);
        PrintD('      ﭨ.',20,78,5);
        PrintD(':  ᫥⥫쭮',20,86,5);
        PrintD('      , ॢ  ',20,94,5);
        PrintD('      ⮥ ﭨ.',20,102,5);
        If V[2]>1 then
        Begin
          PrintD(SpellN[sp1],30,120,9);
        End;
        If V[2]>2 then
        Begin
          PrintD(SpellN[sp2],30,128,9);
        End;
      End else
      If V[2]=4 then
      Begin
        ShowTransD(50,100,17,11,Spr[86]);
      End;
    End;
  3:
    Begin
      ShowRevD(110,100,17,21,Spr[47]);
      If V[3]=1 then
      Begin
        ShowTransD(10,170,17,21,Spr[3]);
      End else
      If V[3] in [2,3] then
        ShowRevD(10,170,17,21,Spr[59]);
      If V[3]=3 then
        ShowTransD(50,100,17,11,Spr[86]);
    End;
  4:
    Begin
      ShowRevD(110,100,17,21,Spr[47]);
      ShowRevD(210,130,17,21,Spr[27]);
      If V[4]=2 then
        ShowTransD(50,100,17,11,Spr[86]);
    End;
  5:
    Begin
      ShowRevD(110,100,17,21,Spr[49]);
    End;
  End;
End;

Procedure NewLocation;
Begin
  PlaySnd(3);
  CrowdA:=0;
End;

Procedure PerformAction;
Begin
  Case HLoc of
  1:
    Begin
      If (V[1]=0) and Around(250,150) then
      Begin
        ShowText(1);
      End else
      If (V[1]=1) and Around(50,100) then
      Begin
        NewLocation;
        FadePal(Pal);
        HLoc:=2;
        ShowAll;
        ShowDouble;
        LightPal(Pal);
        StartCrowd;
      End;
    End;
  2:
    Begin
      If (V[2]=0) and Around(10,170) then
      Begin
        ShowText(2);
        V[2]:=1;
        ShowSpell;
      End else
      If (V[2] in [1,2]) and Around(10,170) then
      Begin
        ShowText(3);
      End else
      If (V[2]=3) and Around(10,170) then
      Begin
        If Check1 then
          ShowText(4) else
          Begin
            ShowText(5);
            ShowSpell;
            V[2]:=1;
          End;
      End else
      If (V[2]=4) and Around(50,100) then
      Begin
        NewLocation;
        FadePal(Pal);
        HLoc:=3;
        ShowAll;
        ShowDouble;
        LightPal(Pal);
        StartCrowd;
      End;
    End;
  3:
    Begin
      If (V[3]=0) and Around(110,100) then
      Begin
        ShowText(6);
        V[3]:=1;
        ShowSpell;
      End else
      If (V[3]=1) and Around(10,170) then
      Begin
        ShowText(7);
      End else
      If (V[3]=2) and Around(10,170) then
      Begin
        ShowText(8);
      End else
      If (V[3]=3) and Around(50,100) then
      Begin
        NewLocation;
        FadePal(Pal);
        HLoc:=4;
        ShowAll;
        ShowDouble;
        LightPal(Pal);
        StartCrowd;
      End;
    End;
  4:
    Begin
      If (V[4]=0) and Around(110,100) then
      Begin
        ShowText(9);
      End else
      If (V[4]<=1) and Around(210,130) then
      Begin
        ShowText(10);
        ShowText(11);
        ShowText(12);
        V[4]:=1;
      End else
      If (V[4]=2) and Around(50,100) then
      Begin
        NewLocation;
        FadePal(Pal);
        HLoc:=5;
        ShowAll;
        ShowDouble;
        LightPal(Pal);
        StartCrowd;
      End;
    End;
  5:
    Begin
      If (V[5]=0) and Around(110,100) then
      Begin
        ShowText(13);
      End;
    End;
  End;
End;

Procedure ShowAll;
Begin
  ClsD(0);
  ShowCrowd;
  ShowLocation;
  HAni:=HAni and 1;
  If HDir=1 then
    ShowTransD(HX,HY,17,21,Spr[1+HAni]) else
    ShowRevD(HX,HY,17,21,Spr[1+HAni]);
End;

Procedure CastSpell;
Var Buf : Array[0..12*320-1] of Byte;
S,s1 : String;
Begin
  FillChar(Mem[SegDB:0],12*320,3);
  GetBack:=3;
  PrintD(' :_',8,2,8);
  Move(Mem[SegDB:0],Buf,12*320);
  For A:=0 to 11 do
  Begin
    Time:=Timer;
    ShowAll;
    B:=0;
    For C:=199-A to 199 do
    Begin
      Move(Buf[B],Mem[SegDB:C*320],320);
      Inc(B,320);
    End;
    VRT;
    ShowDouble;
    Repeat Until Timer-Time>0;
  End;
  S:='';
  repeat
    LastPressed:=0;
    While LastPressed=0 do ;
    If Pressed[scEnter] or Pressed[scEsc] then Break;
    S1:=KeyName[LastPressed];
    If (Length(S)<10) and (Length(S1)=1) then
    Begin
      S:=S+S1;
      GetBack:=3;
      PrintD(S+'_',176,190,8);
    End;
    If Pressed[scBackSpace] and (S<>'') then
    Begin
      Dec(S[0]);
      GetBack:=3;
      PrintD(S+'_ ',176,190,8);
    End;
    ShowDouble;
  until False;
  If Pressed[scEnter] then Move(Mem[SegDB:$EB00],Buf,12*320) else S:='';
  repeat
  until not pressed[scenter] and not pressed[scesc];
  For A:=11 downto 0 do
  Begin
    Time:=Timer;
    ShowAll;
    B:=0;
    For C:=199-A to 199 do
    Begin
      Move(Buf[B],Mem[SegDB:C*320],320);
      Inc(B,320);
    End;
    VRT;
    ShowDouble;
    Repeat Until Timer-Time>0;
  End;
  If S<>'' then
  Begin
    B:=0;
    For A:=1 to SN do
      If SpellN[A]=S then B:=A;
    If B<>0 then
    Begin
      Case HLoc of
      1:
        Begin
          If B=1 then
          Begin
            ShowSpell;
            V[1]:=V[1] xor 1;
            ShowAll;
            ShowDouble;
            StartCrowd;
          End;
        End;
      2:
        Begin
          If V[2]=1 then
          Begin
            If B in [2..4] then
            Begin
              sp1:=B;
              V[2]:=2;
              ShowSpell;
            End;
          End else
          If V[2]=2 then
          Begin
            If B in [2..4] then
            Begin
              sp2:=B;
              V[2]:=3;
              ShowSpell;
              If Check1 then StartCrowd;
            End;
          End else
          If V[2]=3 then
          Begin
            If B=5 then
            Begin
              V[2]:=4;
              ShowSpell;
            End;
          End;
        End;
      3:
        Begin
          If V[3]=1 then
          Begin
            If B=6 then
            Begin
              V[3]:=2;
              ShowSpell;
              StartCrowd;
            End;
          End else
          If V[3]=2 then
          Begin
            If B=7 then
            Begin
              V[3]:=3;
              ShowSpell;
            End;
          End;
        End;
      4:
        Begin
          If (V[4]<=1) then
          Begin
            If B=8 then
            Begin
              ShowSpell;
              V[4]:=2;
            End;
          End;
        End;
      5:
        Begin
          If B=9 then
          Begin
            ShowSpell;
            FadePal(Pal);
            Restore_Handler;
{            GrDone;
            Release(HeapOrg);}
            ShowBirth;
          End;
        End;
      End;
    End;
  End;
End;

Procedure GetKeys;
Var ch : Boolean;
Begin
  ch:=True;
  If Pressed[scLeft] then
  Begin
    if HDir<>-1 then HDir:=-1 else
    Begin
      Inc(HAni);
      Inc(HX,HDir*HSpeed);
      If HX<1 then Dec(HX,HDir*HSpeed);
      If HX>301 then Dec(HX,HDir*HSpeed);
    End;
    ch:=False;
  End;
  If Pressed[scRight] then
  Begin
    if HDir<>1 then HDir:=1 else
    Begin
      Inc(HAni);
      Inc(HX,HDir*HSpeed);
      If HX<1 then Dec(HX,HDir*HSpeed);
      If HX>301 then Dec(HX,HDir*HSpeed);
    End;
    ch:=False;
  End;
  If Pressed[scUp] then
  Begin
    If ch then Inc(HAni);
    Dec(HY,HSpeed);
    If HY<55 then Inc(HY,HSpeed);
    ch:=False;
  End;
  If Pressed[scDown] then
  Begin
    If ch then Inc(HAni);
    Inc(HY,HSpeed);
    If HY>177 then Dec(HY,HSpeed);
    ch:=False;
  End;
  If ch then HAni:=0;
  If Pressed[scSpace] then
    PerformAction;
  If Pressed[scEnter] then
    CastSpell;
End;

Begin
  Write('Do you want sound? [y/n] ');
  Repeat
    Ch:=UpCase(ReadKey);
  Until Ch in ['Y','N'];
  If Ch='Y' then InitDigital($220,5,1);
  ShowIntro;
  Release(HeapOrg);
  While KeyPressed do ReadKey;
  LoadAll;
  GrInit;
  Cls(0);
  CrowdA:=0;
  HAni:=0;
  HX:=50;
  HY:=100;
  HDir:=1;
  HSpeed:=3;
  HLoc:=1;
  SetPalette(Pal);

  {$IFDEF FINAL}
  ShowBirth;
  {$ENDIF}
  {$IFDEF DEBUG}
  ClsD(0);
  For A:=0 to 8 do
    For B:=0 to 17 do
    If A*18+B+1>86 then Break else
    Begin
      ShowTransD(B*17,A*21,17,H[A*18+B+1],Spr[A*18+B+1])
    End;
  ShowDouble;
  ReadLn;
  {$ELSE}
  SetPalette(NullPal);
  ShowAll;
  ShowDouble;
  LightPal(Pal);
  Install_Handler;
  Repeat
    Time:=Timer;
    ShowAll;
    GetKeys;
    VRT;
    ShowDouble;
    If CrowdA>0 then
    Begin
      Inc(CrowdA);
      If CrowdA>60 then CrowdA:=0;
    End;
    Repeat Until Timer-Time>0;
  Until Pressed[scEsc];
  Restore_Handler;
  {$ENDIF}

  GrDone;
  DeInitDigital;
  Release(HeapOrg);
End.