{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}

Unit Intro;

Interface

Procedure ShowIntro;

Implementation

Uses Crt;
Const
      PalMask = $36C;
      PalRegR = $3C7;
      PalRegW = $3C8;
      PalData = $3C9;

      FadeSpeed : Integer = 20; { Fading speed }

Type TPalette = Array[0..255] of record R,G,B : Byte; End;

Var
DBuf : Pointer; { Double Buffer }
SegDB : Word;   { Segment of double-buffer }
Pal,NullPal : TPalette; { Palette for sprites and clear palette }
Spr : Array[1..100] of Pointer; { Sprites }
W,H : Array[1..100] of Word; { Sprite dimensions }
NSpr : LongInt;
A,B,C,D,E : LongInt;
S : String;
Some,Time : LongInt;
Timer : LongInt absolute $40:$6c;
Anim1,Anim2 : LongInt;
X,Y : LongInt;

{$L introspr}
Procedure IntroSprites; far; external;

Procedure SetPalReg(index,Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegW]:=index;
  Port[PalData]:=Red;
  Port[PalData]:=Green;
  Port[PalData]:=Blue;
End;

procedure VRT; assembler;
asm
  mov dx,3DAh
@VRT1:
  in al,dx
  test al,8
  jnz @VRT1
@VRT2:
  in al,dx
  test al,8
  jz @VRT2
end;

Procedure GrInit;
var a,b,c : longint;
s,o : Word;
Begin
  GetMem(DBuf,64000+16);
  SegDB:=Seg(DBuf^)+1;
  asm
    mov ax,13h
    int 10h
  end;
End;

Procedure GrDone;
Begin
  FreeMem(DBuf,64000+16);
  asm
    mov ax,3
    int 10h
  end;
End;

Procedure PixelD(x,y : Word;Color : Byte); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  Mov al,Byte Ptr color
  Mov es : [di],al
End;

Procedure GetPalReg(index : Byte; Var Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegR]:=index;
  Red:=Port[PalData];
  Green:=Port[PalData];
  Blue:=Port[PalData];
End;

Procedure SetPalette(Pal : TPalette);
Var I : Byte;
Begin
  For I:=1 to 254 do SetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Procedure GetPalette(Var Pal :TPalette);
Var I : Byte;
Begin
  For I:=0 to 255 do GetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Procedure FadePal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  FadeSpeed:=10;
  For B:=FadeSpeed downto 0 do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    For A:=0 to 255 do SetPalReg(A,P[A].R,P[A].G,P[A].B);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure FadePal1(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=FadeSpeed downto 0 do
  Begin
    For A:=1 to 254 do
    Begin
      P[A].R:=63-Trunc((63-Pal[A].R)*B/FadeSpeed);
      P[A].G:=63-Trunc((63-Pal[A].G)*B/FadeSpeed);
      P[A].B:=63-Trunc((63-Pal[A].B)*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure LightPal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=0 to FadeSpeed do
  Begin
    For A:=1 to 254 do
    Begin
      P[A].R:=63-Trunc((63-Pal[A].R)*B/FadeSpeed);
      P[A].G:=63-Trunc((63-Pal[A].G)*B/FadeSpeed);
      P[A].B:=63-Trunc((63-Pal[A].B)*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure ShowDouble; assembler;
Asm
  Push ds
  Mov ax,SegA000
  Mov es,ax
  Mov di,0
  Mov cx,32000
  Mov ax,SegDB
  Mov ds,ax
  Mov si,0
  Cld
  Rep MovsW
  Pop ds
End;

Procedure Cls(Color : Byte); assembler;
asm
  mov ax,0A000h
  mov es,ax
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure ClsD(Color : Byte); assembler;
asm
  mov es,SegDB
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure ShowTransD_a(x,y,w,h : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,h
  mov bx,w
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,$4
  jz @Met3
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  Loop @Met1
  Pop ds
End;

Procedure ShowTCD_a(x,y,w,h,adr,wa : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,h
  mov bx,w
  mov dx,wa
  lds si,spr
  add si,adr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,4
  jz @Met3
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  add si,dx
  Loop @Met1
  Pop ds
End;


Procedure ShowTransD(x,y : LongInt;w,h : Word;Spr : Pointer);
Var A,B,C,D : Word;
Begin
  If (X<=-W) or (Y<=-H) or (X>319) or (Y>199) then exit;
  If (X>=0) and (Y>=0) and (X<321-W) and (Y<=201-H) then
    ShowTransD_a(X,Y,W,H,Spr) else
    Begin
      A:=0; B:=0; C:=W-1; D:=H-1;
      If X<0 then Begin A:=-X; X:=0; End;
      If Y<0 then Begin B:=-Y; Y:=0; End;
      If X>320-W then C:=319-X;
      If Y>200-H then D:=199-Y;
      if (c-a+1<=0) or (d-b+1<=0) then
        a:=a;
      ShowTCD_a(x,y,c-a+1,d-b+1,b*w+a,w-c+a-1,spr);
    End;
End;

Procedure ShowRevD(x,y,w,h : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,h
  mov bx,w
  add di,bx
  dec di
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,$4
  jz @Met3
  mov es:[di],al
@Met3:
  dec di
  inc si
  loop @Met2
  pop cx
  add di,320
  add di,bx
  Loop @Met1
  Pop ds
End;

procedure ShowImageD(x,y : Integer;spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov bx,16
  lds si,spr
@Met1 :
  mov cx,8
  rep movsw
  add di,304
  dec bx
  jnz @Met1
  Pop ds
End;

Procedure LoadAll;
Var S,O : Word;
Begin
  S:=Seg(IntroSprites);
  O:=Ofs(IntroSprites);
  For A:=1 to 17 do
  Begin
    W[A]:=MemW[S:O];
    H[A]:=MemW[S:O+2];
    GetMem(Spr[A],longint(W[A])*H[A]);
    Move(Mem[S:O+4],Spr[A]^,longint(W[A])*H[A]);
    Inc(O,4+longint(W[A])*H[A]);
  End;
  Pal:=TPalette(Ptr(S,O)^);
End;

Procedure ShowIntro;
Begin
  LoadAll;
  GrInit;
  Cls(0);
  ClsD(0);
  FillChar(NullPal,SizeOf(NullPal),63);
  SetPalette(NullPal);
  SetPalReg(0,63,63,63);
  SetPalReg($ff,0,0,0);

  X:=-240;
  repeat
    If X<20 then
    Inc(X,5);
    time:=timer;
    ClsD(0);
    ShowTransD(X,0,W[15],H[15],Spr[15]);
    vrt;
    ShowDouble;
  Until KeyPressed or (X=20);
  If KeyPressed then Begin FadePal(Pal); GrDone; Exit; End;
  ShowTransD(100,40,W[1+Anim1 shr 1],H[1+Anim1 shr 1],Spr[1+Anim1 shr 1]);
  ShowDouble;
  LightPal(Pal);

  Anim1:=0;
  X:=330;
  repeat
    If X>100 then
    Dec(X,5);
    time:=timer;
    ClsD(0);
    ShowTransD(100,40,W[1+Anim1 shr 1],H[1+Anim1 shr 1],Spr[1+Anim1 shr 1]);
    ShowTransD(20,0,W[15],H[15],Spr[15]);
    ShowTransD(X,105,W[16],H[16],Spr[16]);
    vrt;
    ShowDouble;
    Anim1:=(Anim1+1) and 3;
  Until KeyPressed or (X=100);
  If KeyPressed then Begin FadePal(Pal); GrDone; Exit; End;


  Anim2:=0;
  Y:=150;
  X:=-49;
  Some:=Timer;
  repeat
    time:=timer;
    ClsD(0);
    ShowTransD(100,40,W[1+Anim1 shr 1],H[1+Anim1 shr 1],Spr[1+Anim1 shr 1]);
    ShowTransD(20,0,W[15],H[15],Spr[15]);
    ShowTransD(100,105,W[16],H[16],Spr[16]);
    ShowTransD(X-W[17]+25,170,W[17],H[17],Spr[17]);

    ShowTransD(X,Y,W[3+Anim2 shr 0],H[3+Anim2 shr 0],Spr[3+Anim2 shr 0]);
    If X<280 then
    Begin
    If Anim2 in [5..9] then Inc(X,10);
    If Anim2 in [5..7] then Dec(Y,6);
    If Anim2 in [8..10] then Inc(Y,6);
    Anim2:=(Anim2+1) mod 12;
    End else If Anim2<>0 then Anim2:=(Anim2+1) mod 12;

    vrt;
    ShowDouble;
    repeat until timer-time>0;
    Anim1:=(Anim1+1) and 3;
  until keypressed or (Timer-Some>110);
  If KeyPressed then Begin FadePal(Pal); GrDone; Exit; End;

  repeat
    time:=timer;
    ClsD(0);
    ShowTransD(100,40,W[1+Anim1 shr 1],H[1+Anim1 shr 1],Spr[1+Anim1 shr 1]);
    ShowTransD(20,0,W[15],H[15],Spr[15]);
    ShowTransD(100,105,W[16],H[16],Spr[16]);
    ShowTransD(-5,170,W[17],H[17],Spr[17]);

    ShowTransD(X,Y,W[3+Anim2 shr 0],H[3+Anim2 shr 0],Spr[3+Anim2 shr 0]);
    If Anim2 in [5..9] then Inc(X,10);
    If Anim2 in [5..7] then Dec(Y,6);
    If Anim2 in [8..10] then Inc(Y,6);
    Anim2:=(Anim2+1) mod 12;

    vrt;
    ShowDouble;
    repeat until timer-time>0;
    Anim1:=(Anim1+1) and 3;
  until (X>330);
  X:=-6;
  repeat
    time:=timer;
    ClsD(0);
    ShowTransD(100,40,W[1+Anim1 shr 1],H[1+Anim1 shr 1],Spr[1+Anim1 shr 1]);
    ShowTransD(20,0,W[15],H[15],Spr[15]);
    ShowTransD(100,105,W[16],H[16],Spr[16]);
    ShowTransD(X,170,W[17],H[17],Spr[17]);
    Dec(X,5);

    vrt;
    ShowDouble;
    Anim1:=(Anim1+1) and 3;
  until KeyPressed or (X<-W[17]);
  If KeyPressed then Begin FadePal(Pal); GrDone; Exit; End;

  X:=100;
  repeat
    If X<330 then
    Inc(X,5);
    time:=timer;
    ClsD(0);
    ShowTransD(100,40,W[1+Anim1 shr 1],H[1+Anim1 shr 1],Spr[1+Anim1 shr 1]);
    ShowTransD(20,0,W[15],H[15],Spr[15]);
    ShowTransD(X,105,W[16],H[16],Spr[16]);
    vrt;
    ShowDouble;
    Anim1:=(Anim1+1) and 3;
  Until KeyPressed or (X=330);
  If KeyPressed then Begin FadePal(Pal); GrDone; Exit; End;

  FadePal1(Pal);
  X:=20;
  repeat
    If X>-240 then
    Dec(X,5);
    time:=timer;
    ClsD(0);
    ShowTransD(X,0,W[15],H[15],Spr[15]);
    vrt;
    ShowDouble;
  Until KeyPressed or (X=-240);
  If KeyPressed then Begin FadePal(Pal); GrDone; Exit; End;

  GrDone;
End;

End.