unit key;
interface
uses dos;
const
      keyname : Array[0..102] of String = (
      '#0','ESC','1','2','3','4','5','6','7','8','9','0','-','=','BackSpace',
      'TAB','Q','W','E','R','T','Y','U','I','O','P','[',']','ENTER','Left CTRL',
      'A','S','D','F','G','H','J','K','L',';','''','`',
      'Left Shift','\','Z','X','C','V','B','N','M',',','.','/','Right Shift',
      'Gray "*"','Left ALT','SPACE','CAPS LOCK','F1','F2','F3','F4','F5','F6','F7','F8',
      'F9','F10','NUM LOCK','Scroll Lock','Pad 7','Pad 8','Pad 9','Gray "-"',
      'Pad 4','Pad 5','Pad 6','Gray "+"','Pad 1','Pad 2','Pad 3','Pad 0','Pad "."(Del)',
      '#84','#85','#86','F11','F12','Right CTRL','Right Alt','Gray "/"',
      'Pad ENTER','Insert','Delete','Home','End','Page Up','Page Down',
      'Left','Right','Up','Down'
      );
      scEsc       = 001;
      scF1        = 059;
      scF2        = 060;
      scF3        = 061;
      scF4        = 062;
      scF5        = 063;
      scF6        = 064;
      scF7        = 065;
      scF8        = 066;
      scF9        = 067;
      scF10       = 068;
      scF11       = 087;
      scF12       = 088;
      scScrlLock  = 070;

      { Upper Row }

      scTilde     = 041;
      sc1         = 002;
      sc2         = 003;
      sc3         = 004;
      sc4         = 005;
      sc5         = 006;
      sc6         = 007;
      sc7         = 008;
      sc8         = 009;
      sc9         = 010;
      sc0         = 011;
      scMinus     = 012;
      scEqual     = 013;
      scBackSpace = 014;

      { QWERTY Row }

      scTab       = 015;
      scQ         = 016;
      scW         = 017;
      scE         = 018;
      scR         = 019;
      scT         = 020;
      scY         = 021;
      scU         = 022;
      scI         = 023;
      scO         = 024;
      scP         = 025;
      scOpenSq    = 026;
      scCloseSq   = 027;
      scEnter     = 028;

      { Home Row }

      scCapsLock  = 058;
      scA         = 030;
      scS         = 031;
      scD         = 032;
      scF         = 033;
      scG         = 034;
      scH         = 035;
      scJ         = 036;
      scK         = 037;
      scL         = 038;
      scSemicolon = 039;
      scQoute     = 040;

      { Bottom Key Row }

      scLShift    = 042;
      scBackSlash = 043;
      scZ         = 044;
      scX         = 045;
      scC         = 046;
      scV         = 047;
      scB         = 048;
      scN         = 049;
      scM         = 050;
      scComma     = 051;
      scPeriod    = 052;
      scSlash     = 053;
      scRShift    = 054;

      { Spacebar Row }

      scLCtrl     = 029;
      scRCtrl     = 089;
      scLAlt      = 056;
      scRAlt      = 090;
      scSpace     = 057;

      { Numeric Keypad }

      scPad7      = 071;
      scPad8      = 072;
      scPad9      = 073;
      scPad4      = 075;
      scPad5      = 076;
      scPad6      = 077;
      scPad1      = 079;
      scPad2      = 080;
      scPad3      = 081;
      scNumLock   = 069;
      scGrayMinus = 074;
      scGrayPlus  = 078;
      scAsterisk  = 055;
      scPadIns    = 082;
      scPadDel    = 083;
      scGraySlash = 091;
      scPadEnter  = 092;
      scIns       = 093;
      scDel       = 094;
      scHome      = 095;
      scEnd       = 096;
      scPageUp    = 097;
      scPageDown  = 098;
      scLeft      = 099;
      scRight     = 100;
      scUp        = 101;
      scDown      = 102;

var
  pressed : array [0..127] of boolean;
  lastpressed : byte;
  lastreleased : byte;
  isE0 : boolean;
  saveint09 : procedure;
procedure int09handler; interrupt;
procedure install_handler;
procedure restore_handler;
implementation
procedure int09handler;
Begin
 asm
  in al,60h
  mov dl,al
  mov al,20h
  out 20h,al
  cmp dl,0E0h
  jne @@next
  mov [isE0],true
  jmp @@finish
  @@next:
  cmp [isE0],true
  jne @@next2
  mov [isE0],false
  mov dh,dl
  and dh,$7F
  cmp dh,29
  jne @d1
  mov dh,89
  jmp @c2
  @d1:
  cmp dh,56
  jnz @d2
  mov dh,90
  jmp @c2
  @d2:
  cmp dh,53
  jnz @d3
  mov dh,91
  jmp @c2
  @d3:
  cmp dh,28
  jnz @d4
  mov dh,92
  jmp @c2
  @d4:
  cmp dh,82
  jnz @d5
  mov dh,93
  jmp @c2
  @d5:
  cmp dh,83
  jnz @d6
  mov dh,94
  jmp @c2
  @d6:
  cmp dh,71
  jnz @d7
  mov dh,95
  jmp @c2
  @d7:
  cmp dh,79
  jnz @d8
  mov dh,96
  jmp @c2
  @d8:
  cmp dh,73
  jnz @d9
  mov dh,97
  jmp @c2
  @d9:
  cmp dh,81
  jnz @d10
  mov dh,98
  jmp @c2
  @d10:
  cmp dh,75
  jnz @d11
  mov dh,99
  jmp @c2
  @d11:
  cmp dh,77
  jnz @d12
  mov dh,100
  jmp @c2
  @d12:
  cmp dh,72
  jnz @d13
  mov dh,101
  jmp @c2
  @d13:
  cmp dh,80
  jnz @d14
  mov dh,102
  jmp @c2
  @d14:

  jmp @@finish
  @c2:
  and dl,$80
  or dl,dh
  @@next2:
  xor dh,dh
  mov si,dx
  and si,007Fh
  test dl,80h
  jnz @@released
    mov [lastpressed],dl
    mov al,true
  jmp @@savestate
  @@released:
    and dl,7Fh
    mov [lastreleased],dl
    mov al,false
  @@savestate:
  mov ds:byte ptr [pressed+si],al
  @@finish:
{  pushf}
 End;
{ SaveInt09;}
end;

procedure install_handler;
Begin
  IsE0:=False;
  FillChar(Pressed,SizeOf(Pressed),False);
  GetIntVec(9,@SaveInt09);
  SetIntVec(9,@int09handler);
End;
{asm
  xor ax,ax
  mov di,offset pressed
  mov cx,(128+1+1)/2
  cld
  segds rep stosw
  cli
  mov es,ax
  mov ax,es:[09h*4]
  mov bx,es:[09h*4+2]
  mov word ptr [saveint09],ax
  mov word ptr [saveint09+2],bx
  mov es:word ptr [09h*4],offset int09handler
  mov es:word ptr [09h*4+2],cs
  sti
end;}

procedure restore_handler;
Begin
  SetIntVec(9,@SaveInt09);
End;
{
asm
  cli
  xor ax,ax
  mov es,ax
  mov ax,word ptr [saveint09]
  mov bx,word ptr [saveint09+2]
  mov es:[09h*4],ax
  mov es:[09h*4+2],bx
  sti
end;}
end.