{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}
Unit SBReal;

Interface

Var
    Dig_Play : Boolean; { ࠥ      
                        (TRUE, ᫨ ࠥ) }

Procedure InitDigital(Base : Word;Irq,Dma : Byte);
Procedure DeInitDigital;
Procedure PlayRaw(Sound: Pointer; Size: Word; Frequency: Word);

Implementation

Uses Dos,Crt;

const dma_page:array[0..3] of byte= ($87,$83,$81,$81);

Var
    Blaster_OK : Boolean;
    old_irq_int : Pointer;
    sbIrq : Byte;
    sbDma : Byte;
    sbPort : Word;
    Blaster_Reset: Word;                { SB variables }
    Blaster_Read: Word;
    Blaster_Write: Word;
    Blaster_Status: Word;
    Blaster_Data: Word;


Procedure NewIrq; interrupt; {  뢠 뢠,  DMA
稫(??) ந뢠  (..,    ந뢠
᫥饣 , ᫨    㬥頥  ᥣ) }
Begin
     ASM  (* Preparing the sound card *)
     mov dx,20h
     mov ax,dx
     out dx,al
     mov cl,100
     mov bx,sbport
     add bx,0Ah
     @bcl:
     dec cl
     mov dx,bx
     in al,dx
     add dx,4
     in al,dx
     or cl,cl
     jz @finb
     cmp al,0AAh
     jnz @bcl
     @finb:
     end;
  Dig_Play:=False; {    ࠥ }
End;

Function Reset_Blaster(Base: Word;Irq,Dma : Byte): Boolean;
Var IrqMsk : Byte;
Begin
  Dig_Play:=False;
  sbPort:=Base;
  sbIrq:=Irq;
  sbDma:=Dma;
  GetIntVec($8+sbIrq,old_irq_int);

  Blaster_Reset := Base + $6;
  Blaster_Read := Base + $A;
  Blaster_Write := Base + $C;
  Blaster_Status := Base + $C;
  Blaster_Data := Base + $E;

  Port[Blaster_Reset] := 1;
  Delay(5);
  Port[Blaster_Reset] := 0;
  Delay(5);
  If (Port[Blaster_Data] AND 128 = 128) AND
     (Port[Blaster_Read] = $AA) then
     Begin
       Reset_Blaster := True;
       SetIntVec($8+sbIrq,@NewIrq);
       IrqMsk:=1 shl sbIrq;
       Port[$21]:=Port[$21] and byte(not IrqMsk);
     End
  Else
     Reset_Blaster := False;
End;

Procedure Write_To_Blaster(Value: Byte); Assembler;
Asm
   mov    dx,Blaster_Status     { Setup port }

@NoWrite:
   in     al,dx                 { Read from port }
   and    al,10000000b
   jnz    @NoWrite              { Wait until bit 7 is clear }

   mov    dx,Blaster_Write
   mov    al,Value              { Write byte }
   out    dx,al
End;

Function Read_From_Blaster: Byte;
Begin
  While (Port[Blaster_Data] AND 128 = 0) Do;
  Read_From_Blaster := Port[Blaster_Read];
End;

Procedure Turn_Speaker_On;
Begin
  Write_To_Blaster($D1);
End;

Procedure Turn_Speaker_Off;
Begin
  Write_To_Blaster($D3);
End;

Procedure Stop_Dma;
Begin
  Write_To_Blaster($D0);
End;

Procedure PlayRaw(Sound: Pointer; Size: Word; Frequency: Word);
Var Time_constant: Byte;
    Page, Offs: Word;
Begin
  If Not Blaster_OK then Exit;
  Stop_DMA;
  Size := Size + 1;

  { Set up the DMA chip }
  Offs := LongInt(Seg(sound^)) shl 4 + Ofs(sound^);
  Page := (Seg(sound^) + Ofs(sound^) shr 4) shr 12;

  Asm                             { Program DMA channel 1 for output to SB }
    mov    dx,0ah
    mov    al,sbdma
    add    al,4
    out    dx,al                  { Mask off DMA channel 1 }

    mov    dx,0ch
    xor    al,al
    out    dx,al                  { Clear byte pointer F/F to lower byte }

    mov    dx,0bh
    mov    al,sbdma
    add    al,48h
    out    dx,al                  { Set transfer mode to DAC }

    mov    dl,sbdma
    shl    dl,1
    mov    ax,Offs
    out    dx,al                  { Write LSB of base adress }
    mov    al,ah
    out    dx,al                  { Write MSB of base adress }

    xor bx,bx     (* portw[sma_page[sbdma]]:= seg_ *)
    mov bl,sbdma
    xor dx,dx
    mov dl,byte ptr dma_page[bx]
    mov ax,Page
    out dx,ax       { Write Page Number }

    mov    dl,sbdma
    shl    dl,1
    inc    dl
    mov    ax,Size
    out    dx,al                  { Write LSB of sample length }
    mov    al,ah
    out    dx,al                  { Write MSB of sample length }

    mov dx,0Ah
    mov al,sbdma
    out dx,al
  End;
  Dig_Play:=True;

  { Set playback frequency }
  Time_constant := 256 - (1000000 div frequency);
  Write_To_Blaster($40);
  Write_To_Blaster(Time_constant);

  { Set playback type to 8-bit }
  Write_To_Blaster($14);
  Write_To_Blaster(Lo(size));
  Write_To_Blaster(Hi(size));
End;

Procedure InitDigital(Base : Word;Irq,Dma : Byte);
Begin
  If Base=0 then Blaster_OK:=False else
    Blaster_OK:=Reset_Blaster(Base,Irq,Dma);
  If Blaster_OK then
    Turn_Speaker_On;
End;

Procedure DeInitDigital;
Begin
  If Blaster_OK then
  Begin
    SetIntVec($8+sbIrq,old_irq_int);
    Stop_DMA;
    Turn_Speaker_Off;
  End;
End;

Begin
  Blaster_OK:=False;
End.
