DECLARE FUNCTION PlayBoss% ()
'$STATIC
'$INCLUDE: 'DIRECTQB.BI'
DEFINT A-Z

DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION LoadMidi% (Filename$)
DECLARE FUNCTION MusicDone% ()
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB PlayMIDI ()
DECLARE SUB StopMIDI ()

TYPE Registers
    AX    AS INTEGER
    BX    AS INTEGER
    CX    AS INTEGER
    DX    AS INTEGER
    BP    AS INTEGER
    SI    AS INTEGER
    DI    AS INTEGER
    FLAGS AS INTEGER
    DS    AS INTEGER
    ES    AS INTEGER
END TYPE

DECLARE SUB LoadLevel (Level$)
DECLARE SUB Credits ()
DECLARE SUB UpdateKeys ()
DECLARE SUB HighScores ()
DECLARE FUNCTION PlayGame% (Level%)
DECLARE FUNCTION CheckCMD% (CMD$, Parm$)
DECLARE FUNCTION MainMenu% ()
DECLARE FUNCTION CheckFile% (Filename$)
DECLARE FUNCTION GenPass$ (Level%, Score&)
DECLARE FUNCTION UsePass% (Pass$)

'QMidi
DIM SHARED QMIDIRegs AS Registers, Mem.Segment AS INTEGER
DIM SHARED SBMIDI.Interrupt AS INTEGER, Mem.Allocated AS LONG
DIM SHARED SBSIM.Interrupt AS INTEGER

DIM SHARED SoundSystem AS INTEGER, MusicSystem AS INTEGER
DIM SHARED Sprites(19890) AS INTEGER
DIM SHARED ScoreTable(9) AS LONG
DIM SHARED ScoreNames(9) AS STRING * 20
DIM SHARED Torp1X(7 TO 13) AS INTEGER, Torp1Y(7 TO 13) AS INTEGER
DIM SHARED Torp2X(7 TO 13) AS INTEGER, Torp2Y(7 TO 13) AS INTEGER
DIM SHARED Score AS LONG, CurTrack%

DIM SHARED Paleta$, Pal$
Paleta$ = STRING$(768, 0)
Pal$ = STRING$(768, 0)
DIM SHARED JoyAvail AS INTEGER, JoyNum AS INTEGER
DIM SHARED UpKeyPressed AS INTEGER
DIM SHARED DownKeyPressed AS INTEGER
DIM SHARED LeftKeyPressed AS INTEGER
DIM SHARED RightKeyPressed AS INTEGER
DIM SHARED FireKeyPressed AS INTEGER
DIM SHARED QuitKeyPressed AS INTEGER

CLS
COLOR 14, 1
PRINT " Dolphin Fighter v1.00.00          Leandro_Pardini@Hotmail.com          TLP1999 "

COLOR 7, 0

OPEN "DOLPHIN.CFG" FOR BINARY AS #1 'Dolphin.cfg
FOR b = 0 TO 9
   GET #1, , ScoreTable(b)
   GET #1, , ScoreNames(b)
NEXT b
CLOSE #1

PRINT "  Initializing DirectQB v1.61 ... ";

a = DQBinit(2, 3, 0)
IF a > 0 THEN PRINT "Failed. "; DQBerror$: END
PRINT "Done."

PRINT "  Installing DirectQB keyboard driver ... ";
CALL DQBinstallKeyboard
PRINT "Done."

CMD$ = LTRIM$(RTRIM$(UCASE$(COMMAND$)))

IF INSTR(CMD$, "/NOJOY") = 0 THEN
PRINT "  Installing DirectQB joystick driver ... ";
IF DQBjoyDetected(GAMEPAD) THEN
   JoyAvail = -1
   JoyNum = GAMEPAD
   PRINT "Done: Using Gamepad."
ELSEIF DQBjoyDetected(JOY1) THEN
   JoyAvail = -1
   JoyNum = JOY1
   PRINT "Done: Using Joystick 1."
ELSEIF DQBjoyDetected(JOY2) THEN
   JoyAvail = -1
   JoyNum = JOY2
   PRINT "Done: Using Joystick 2."
ELSE
   PRINT "Failed. No joystick detected."
END IF
END IF

IF INSTR(CMD$, "/NOSOUND") = 0 THEN
PRINT "  Initializing DirectQB Sound System... ";
a% = DQBinstallSB(False, 3, 11025, AUTO, AUTO, AUTO)
IF a% > 0 THEN
   PRINT "Failed. "; DQBerror$; "."
ELSE
   PRINT "Done."
   PRINT "   Loading BOOM.SND... ";
   a% = DQBloadRawSound(1, "BOOM.SND", 0, 17355)
   IF a% > 0 THEN
      PRINT "Failed. "; DQBerror$; "."
      DQBremoveSB
   ELSE
      PRINT "Done."
      SoundSystem = SoundSystem + 1
   END IF
   PRINT "   Loading SHIELDS.SND... ";
   a% = DQBloadRawSound(2, "SHIELDS.SND", 0, 4281)
   IF a% > 0 THEN
      PRINT "Failed. "; DQBerror$; "."
      DQBremoveSB
   ELSE
      PRINT "Done."
      SoundSystem = SoundSystem + 1
   END IF
   PRINT "   Loading DSHIELDS.SND... ";
   a% = DQBloadRawSound(3, "DSHIELDS.SND", 0, 7351)
   IF a% > 0 THEN
      PRINT "Failed. "; DQBerror$; "."
      DQBremoveSB
   ELSE
      PRINT "Done."
      SoundSystem = SoundSystem + 1
   END IF
END IF
IF SoundSystem = 3 THEN SoundSystem = -1 ELSE SoundSystem = 0
END IF

IF INSTR(CMD$, "/NOMUSIC") = 0 THEN
PRINT "  Initializing QMidi... ";
DriversLoaded SBMIDI.Interrupt, SBSIM.Interrupt
IF SBMIDI.Interrupt + SBSIM.Interrupt = 0 THEN
   PRINT "Failed: SBMIDI and SBSIM not found."
   MusicSystem = 0
ELSEIF SBMIDI.Interrupt = 0 THEN
   PRINT "Failed: SBMIDI not found."
   MusicSystem = 0
ELSEIF SBSIM.Interrupt = 0 THEN
   PRINT "Failed: SBSIM not found."
   MusicSystem = 0
ELSE
   PRINT "Done."
   MusicSystem = -1
END IF
END IF

CALL DQBpset(1, 0, 0, 0)
CALL DQBpset(1, 0, 1, 240)
CALL DQBpset(1, 0, 2, 0)
CALL DQBpset(1, 1, 0, 240)
CALL DQBpset(1, 1, 1, 255)
CALL DQBpset(1, 1, 2, 240)
CALL DQBpset(1, 2, 2, 0)
CALL DQBpset(1, 2, 1, 240)
CALL DQBpset(1, 2, 2, 0)
CALL DQBget(1, 0, 0, 2, 2, VARSEG(Sprites(19887)), VARPTR(Sprites(19887)))

PRINT "   Press any key to start..."

DO
   CALL UpdateKeys
   IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
LOOP

CALL DQBinitVGA

Pal$ = STRING$(768, 0)
CALL DQBsetPal(Pal$)
a = DQBloadImage(0, 0, 0, "LOGO.PCX", Pal$, 0, 0)
CALL DQBfadeIn(Pal$)

DO
   CALL UpdateKeys
   IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
LOOP

CALL DQBfadeTo(63, 63, 63)

DO
SELECT CASE MainMenu
CASE 1
   CurTrack% = 0
   Level% = 1
   Score = 0
   DO
      IF PlayGame(Level%) = 1 THEN EXIT DO
      Level% = Level% + 1
      IF Level% = 11 THEN EXIT DO
   LOOP
   IF Level% = 11 THEN a = PlayBoss
   CALL HighScores
   IF MusicSystem THEN CALL StopMIDI
CASE 2
   a = DQBloadImage(0, 0, 0, "PASSWORD.PCX", Pal$, 0, 0)
   CALL DQBsetTextStyle(SOLID)
   CALL DQBprint(0, "PASSWORD: ", 100, 180, 177)
   CALL DQBfadeIn(Pal$)

   Pass$ = ""
   CALL DQBprint(0, "_ ", 180, 180, 177)
   DO
      i$ = DQBinkey$
      SELECT CASE i$
      CASE CHR$(8)
         IF Pass$ > "" THEN
            Pass$ = LEFT$(Pass$, LEN(Pass$) - 1)
            CALL DQBprint(0, Pass$ + "_ ", 180, 180, 177)
         END IF
      CASE "A" TO "Z", "a" TO "z", "0" TO "9"
         IF LEN(Pass$) < 5 THEN
            Pass$ = Pass$ + LCASE$(i$)
            CALL DQBprint(0, Pass$ + "_ ", 180, 180, 177)
         END IF
      CASE CHR$(13)
         IF LEN(Pass$) = 5 THEN EXIT DO
      END SELECT
   LOOP
  
   Level% = UsePass%(Pass$)
   IF Level% < 0 THEN
      CALL DQBprint(0, "INVALID PASSWORD ", 95, 180, 177)
      DO
         CALL UpdateKeys
         IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
      LOOP
      CALL DQBfadeTo(0, 0, 0)
   ELSE
      CALL DQBfadeTo(0, 0, 0)
      CurTrack% = 0
      Level% = Level% + 1
      IF Level < 11 THEN
         DO
            IF PlayGame(Level%) = 1 THEN EXIT DO
            Level% = Level% + 1
            IF Level% = 11 THEN EXIT DO
         LOOP
         IF Level% = 11 THEN a = PlayBoss
      ELSE
         a = PlayBoss
      END IF
      CALL HighScores
      IF MusicSystem THEN CALL StopMIDI
   END IF
CASE 3: CALL Credits
CASE 4: EXIT DO
END SELECT
LOOP

OPEN "DOLPHIN.CFG" FOR BINARY AS #1 'Dolphin.cfg
FOR b = 0 TO 9
   PUT #1, , ScoreTable(b)
   PUT #1, , ScoreNames(b)
NEXT b
CLOSE #1

CALL DQBclose

IntXCodeData:
DATA &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA &H02, &H00

REM $DYNAMIC
SUB Credits

DIM Creditos$(51), Colores(51)
Colores(0) = 250: Creditos$(0) = "MAIN PROGRAMMING"
Colores(1) = 2: Creditos$(1) = "Leandro Pardini"
Colores(2) = 6: Creditos$(2) = "lpardini@startrekmail.com"
Colores(4) = 250: Creditos$(4) = "DIRECTQB LIBRARY"
Colores(5) = 2: Creditos$(5) = "Angelo Mottola from Enhanced Creations"
Colores(6) = 6: Creditos$(6) = "http://ec.quickbasic.com/"
Colores(8) = 250: Creditos$(8) = "QMIDI LIBRARY"
Colores(9) = 2: Creditos$(9) = "Jesse Dorland"
Colores(10) = 6: Creditos$(10) = "JesseDorland@Hotmail.com"
Colores(12) = 250: Creditos$(12) = "SBMIDI AND SBSIM DRIVERS"
Colores(13) = 2: Creditos$(13) = "Copyright Creative Technology"
Colores(14) = 6: Creditos$(14) = "http://www.creativelabs.com/"
Colores(16) = 250: Creditos$(16) = "DOLPHIN IMAGES"
Colores(17) = 2: Creditos$(17) = "Original model by Mike Wright"
Colores(18) = 6: Creditos$(18) = "http://www.3dwarriors.com/"
Colores(19) = 2: Creditos$(19) = "Conversion to 3DS: Erik Timmermans"
Colores(20) = 2: Creditos$(20) = "Conversion to trueSpace: Leandro Pardini"
Colores(22) = 250: Creditos$(22) = "SHIP STYLES"
Colores(23) = 2: Creditos$(23) = "Level 1: Todd Warnken"
Colores(24) = 6: Creditos$(24) = "TWarnken@aol.com"
Colores(25) = 2: Creditos$(25) = "Level 2: Ryan Jillek"
Colores(26) = 6: Creditos$(26) = "rjilek@hotmail.com"
Colores(27) = 2: Creditos$(27) = "Level 3: Stuart John Bernard"
Colores(28) = 6: Creditos$(28) = "bigbear@stupendousgames.com"
Colores(29) = 2: Creditos$(29) = "Level 4: Richard L. Bouchard"
Colores(30) = 6: Creditos$(30) = "richardb@interlinx.qc.ca"
Colores(31) = 2: Creditos$(31) = "Level 5: Gary Lawler"
Colores(32) = 6: Creditos$(32) = "glawler@iol.ie"
Colores(33) = 2: Creditos$(33) = "Level 6: Salvatore Vilardi"
Colores(34) = 6: Creditos$(34) = "VilardiS@cascadeng.com"
Colores(35) = 2: Creditos$(35) = "Level 7: Paul Cocker"
Colores(36) = 6: Creditos$(36) = "quitch@fickle.demon.co.uk"
Colores(37) = 2: Creditos$(37) = "Level 8: " + CHR$(34) + "Robbers" + CHR$(34)
Colores(38) = 6: Creditos$(38) = "Unknown Author"
Colores(39) = 2: Creditos$(39) = "Level 9: Alvin Helms"
Colores(40) = 6: Creditos$(40) = "wykan@siscom.net"
Colores(41) = 2: Creditos$(41) = "Level 10: Alvin Helms"
Colores(42) = 6: Creditos$(42) = "wykan@siscom.net"
Colores(43) = 2: Creditos$(43) = "Boss: " + CHR$(34) + "Cheyenne" + CHR$(34)
Colores(44) = 6: Creditos$(44) = "Unknown Author"
Colores(46) = 250: Creditos$(46) = "BETA TESTER"
Colores(47) = 2: Creditos$(47) = "Thomas Laguzzi"
Colores(48) = 6: Creditos$(48) = "laguzzi@mail.dada.it"
Colores(50) = 250: Creditos$(50) = "THIS GAME IS FREEWARE"
Colores(51) = 6: Creditos$(51) = "http://tlp.virtualave.net/"
                                                
a = DQBloadImage(2, 0, 0, "HEADER.PCX", Pal$, 0, 0)
CALL DQBcopyLayer(2, 0)
CALL DQBfadeIn(Pal$)

CALL DQBsetClipBox(0, 47, 319, 199)

c% = 225

IF MusicSystem THEN
IF LoadMidi%("CREDITS.MID") = 0 THEN PlayMIDI
END IF

DO
CALL DQBcopyLayer(2, 1)
IF c% = -472 THEN EXIT DO
FOR b% = 0 TO 51
   CALL DQBprint(1, Creditos$(b%), 160 - ((LEN(Creditos$(b%)) * 8) \ 2), c% + (b% * 10), Colores(b%))
NEXT b%
c% = c% - 1
CALL DQBcopyLayer(1, 0)
CALL DQBwait(5)
CALL UpdateKeys
IF FireKeyPressed OR QuitKeyPressed THEN QuitNow = 63
LOOP

IF MusicSystem THEN
DO: LOOP UNTIL MusicDone
StopMIDI
END IF

CALL DQBsetClipBox(0, 0, 319, 199)
CALL DQBfadeTo(63, 63, 63)
END SUB

SUB DriversLoaded (SBMIDI%, SBSIM%)
SBMIDI% = 0
SBSIM% = 0
FOR i% = &H80 TO &HFF
   InternalGetIntVector i%, Segment&, Offset&
   IF Segment& > 0 THEN
      IF SBMIDI% = 0 THEN
         DEF SEG = Segment& - 17
         TEMP$ = ""
         FOR J% = 1 TO 6
            TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
         NEXT
         IF TEMP$ = "SBMIDI" THEN SBMIDI% = i%
      END IF
      IF SBSIM% = 0 AND Segment& <> 0 THEN
         DEF SEG = Segment& - 1
         TEMP$ = ""
         FOR J% = 1 TO 5
            TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
         NEXT
         IF TEMP$ = "SBSIM" THEN SBSIM% = i%
      END IF
      IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
   END IF
NEXT i%
END SUB

REM $STATIC
FUNCTION GenPass$ (Level%, Score&)
Normal$ = "qwertyuiopasdfghjklzxcvbnm0123456789"
a$ = MID$(Normal$, Level% + (Score& - (Score& \ 26) * 26) + 1, 1)
Points& = Score&
WHILE Points& > 0
   P& = Points& \ 36
   a$ = a$ + MID$(Normal$, Points& - (P& * 36) + 1, 1)
   Points& = P&
WEND
WHILE LEN(a$) < 5
   a$ = a$ + "q"
WEND
GenPass$ = a$
END FUNCTION

REM $DYNAMIC
SUB HighScores

a = DQBloadImage(0, 0, 0, "HIGHS.PCX", Pal$, 0, 0)

a = -1

FOR b = 0 TO 9
   IF Score > ScoreTable(b) THEN
      FOR a = 8 TO b STEP -1
         ScoreTable(a + 1) = ScoreTable(a)
         ScoreNames(a + 1) = ScoreNames(a)
      NEXT a
      ScoreNames(b) = ""
      ScoreTable(b) = Score
      a = b
      EXIT FOR
   END IF
NEXT b

FOR b = 0 TO 9
   Shields$ = STR$(ScoreTable(b))
   Shields$ = STRING$(8 - LEN(Shields$), 32) + Shields$
   IF b = a THEN
      CALL DQBprint(0, ScoreNames(b) + Shields$, 52, (b * 10) + 70, 255)
   ELSE
      CALL DQBprint(0, ScoreNames(b) + Shields$, 52, (b * 10) + 70, 222)
   END IF
NEXT b

CALL DQBfadeIn(Pal$)

CALL DQBsetTextStyle(SOLID)
IF a > -1 THEN
   Name$ = ""
   Shields$ = STR$(ScoreTable(a))
   Shields$ = STRING$(8 - LEN(Shields$), 32) + Shields$
   ScoreNames(a) = "_"
   CALL DQBprint(0, ScoreNames(a) + Shields$, 52, (a * 10) + 70, 255)
   WHILE i$ <> CHR$(13)
      i$ = DQBinkey$
      SELECT CASE i$
      CASE CHR$(8)
         IF Name$ > "" THEN
            Name$ = LEFT$(Name$, LEN(Name$) - 1)
            ScoreNames(a) = Name$ + "_"
            CALL DQBprint(0, ScoreNames(a) + Shields$, 52, (a * 10) + 70, 255)
         END IF
      CASE "A" TO "Z", "a" TO "z", "0" TO "9", " ", "-"
         Name$ = Name$ + i$
         ScoreNames(a) = Name$ + "_"
         CALL DQBprint(0, ScoreNames(a) + Shields$, 52, (a * 10) + 70, 255)
      END SELECT
   WEND
   ScoreNames(a) = Name$
   CALL DQBprint(0, ScoreNames(a) + Shields$, 52, (a * 10) + 70, 255)
END IF

DO
   CALL UpdateKeys
   IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
LOOP

CALL DQBfadeTo(0, 0, 0)

END SUB

SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
Segment& = QMIDIRegs.ES
Offset& = QMIDIRegs.BX
END SUB

SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC

STATIC Filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
        
DIM IntCode AS STRING * 145
IF NOT Loaded THEN
   RESTORE IntXCodeData:
  
   FOR k% = 1 TO 145
      READ h%
      MID$(IntCode, k%, 1) = CHR$(h%)
   NEXT
 
   IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
   Loaded% = -1
END IF

DEF SEG = VARSEG(IntCode)
POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum
CALL Absolute(Regs, VARPTR(IntCode$))
DEF SEG

END SUB

SUB LoadLevel (Level$)
a = DQBloadImage(1, 0, 0, "Sprites.pcx", Paleta$, 0, 0)
FOR a = 0 TO 6
CALL DQBget(1, a * 42, 0, (a * 42) + 41, 44, VARSEG(Sprites(a * 947)), VARPTR(Sprites(a * 947)))
CALL DQBget(1, a * 42, 45, (a * 42) + 41, 89, VARSEG(Sprites((a + 14) * 947)), VARPTR(Sprites((a + 14) * 947)))
NEXT a
a = DQBloadImage(1, 0, 0, Level$ + ".pcx", Pal$, 0, 0)
FOR a = 0 TO 6
CALL DQBget(1, a * 42, 0, (a * 42) + 41, 44, VARSEG(Sprites((a + 7) * 947)), VARPTR(Sprites((a + 7) * 947)))
NEXT a
OPEN Level$ + ".pos" FOR INPUT AS #1
FOR a = 7 TO 13
INPUT #1, Torp1X(a), Torp1Y(a), Torp2X(a), Torp2Y(a)
NEXT a
CLOSE #1
END SUB

FUNCTION LoadMidi% (Filename$)
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN KILL Filename$: LoadMidi% = 1: EXIT FUNCTION
Filename$ = Filename$ + CHR$(0)

QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)

IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
   LargestBlock& = QMIDIRegs.BX
   LargestBlock& = LargestBlock& * 16
   Mem.Allocated = (FileLen& + 2048) - LargestBlock&
   a& = SETMEM(-Mem.Allocated)
   QMIDIRegs.AX = &H4800
   QMIDIRegs.BX = (FileLen& \ 16) + 1
   CALL IntX(&H21, QMIDIRegs)
   IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
      a& = SETMEM(Mem.Allocated)
      LoadMidi% = 1
      Mem.Segment = 0
      EXIT FUNCTION
   END IF
END IF
Mem.Segment = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

QMIDIRegs.AX = &H3D00
QMIDIRegs.DX = SADD(Filename$)
QMIDIRegs.DS = VARSEG(Filename$)
CALL IntX(&H21, QMIDIRegs)
Handle% = QMIDIRegs.AX
FOR i& = 1 TO FileLen& STEP 16384
   QMIDIRegs.AX = &H3F00
   QMIDIRegs.CX = 16384
   QMIDIRegs.DX = 0
   QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
   QMIDIRegs.BX = Handle%
   CALL IntX(&H21, QMIDIRegs)
   MIDISegment& = MIDISegment& + 1024
NEXT i&

QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)
END FUNCTION

FUNCTION MainMenu%

CALL DQBsetTextStyle(NONE)

a = DQBloadImage(1, 0, 0, "HEADER.PCX", Pal$, 0, 0)
CALL DQBprint(1, "BEGIN GAME", 120, 120, 2)
CALL DQBprint(1, "PASSWORD", 128, 130, 2)
CALL DQBprint(1, "CREDITS", 132, 140, 2)
CALL DQBprint(1, "QUIT GAME", 124, 150, 2)
CALL DQBcopyLayer(1, 0)
CALL DQBprint(0, "BEGIN GAME", 119, 119, 250)
CALL DQBfadeIn(Pal$)

CurItem% = 1
Redraw% = 0

DO
   CALL DQBwait(5)

   CALL UpdateKeys
  
   IF UpKeyPressed THEN
      CurItem% = CurItem% - 1
      IF CurItem% = 0 THEN CurItem% = 4
      Redraw% = -1
   END IF
   IF DownKeyPressed THEN
      CurItem% = CurItem% + 1
      IF CurItem% = 5 THEN CurItem% = 1
      Redraw% = -1
   END IF
   IF FireKeyPressed THEN
      MainMenu% = CurItem%
      EXIT DO
   END IF
   IF QuitKeyPressed THEN
      MainMenu% = 3
      EXIT DO
   END IF

   IF Redraw% THEN
      CALL DQBcopyLayer(1, 0)
      SELECT CASE CurItem%
      CASE 1: CALL DQBprint(0, "BEGIN GAME", 119, 119, 250)
      CASE 2: CALL DQBprint(0, "PASSWORD", 127, 129, 250)
      CASE 3: CALL DQBprint(0, "CREDITS", 131, 139, 250)
      CASE 4: CALL DQBprint(0, "QUIT GAME", 123, 149, 250)
      END SELECT
      Redraw% = 0
   END IF
LOOP

CALL DQBfadeTo(0, 0, 0)

END FUNCTION

FUNCTION MusicDone%
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.Interrupt, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN QMIDIRegs.AX = -1 ELSE QMIDIRegs.AX = 0
MusicDone% = QMIDIRegs.AX
END FUNCTION

REM $STATIC
FUNCTION PlayBoss
 
a = DQBloadImage(0, 0, 0, "START.PCX", Pal$, 0, 0)
CALL DQBprint(0, "STARTING BOSS LEVEL", 84, 180, 199)
CALL DQBfadeIn(Pal$)

a = DQBloadImage(1, 0, 0, "Sprites.pcx", Paleta$, 0, 0)
FOR a = 0 TO 6
CALL DQBget(1, a * 42, 0, (a * 42) + 41, 44, VARSEG(Sprites(a * 947)), VARPTR(Sprites(a * 947)))
CALL DQBget(1, a * 42, 45, (a * 42) + 41, 89, VARSEG(Sprites((a + 14) * 947)), VARPTR(Sprites((a + 14) * 947)))
NEXT a

a = DQBloadImage(1, 0, 0, "boss.pcx", Paleta$, 0, 0)
CALL DQBget(1, 0, 0, 114, 105, VARSEG(Sprites(6629)), VARPTR(Sprites(6629)))

OPEN "boss.pos" FOR INPUT AS #1
FOR a = 7 TO 9
INPUT #1, Torp1X(a), Torp1Y(a), Torp2X(a), Torp2Y(a)
NEXT a
CLOSE #1

DIM StarsX(49) AS INTEGER
DIM StarsY(49) AS INTEGER

DIM TorpedoX(99) AS INTEGER
DIM TorpedoY(99) AS INTEGER
DIM TorpedoT(99) AS INTEGER

RANDOMIZE TIMER

FOR a = 0 TO 49
   StarsX(a) = INT(RND * 320)
   StarsY(a) = INT(RND * 200)
NEXT a

DolphinX = 138
DolphinY = 154
DolphinH = 0
DolphinV = 0
DolphinS = 1000
EnemyIncr = 1
EnemyVert = 1
EnemyX = 102
EnemyY = -106
EnemyS = 100
Stat = 0
Fade = 64
Torp = 2

CALL DQBsetCollideMethod(1)
CALL DQBsetTextStyle(NONE)

Pal$ = Paleta$

DO
   CALL UpdateKeys
   IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
LOOP

CALL DQBfadeTo(0, 0, 0)

DO

IF MusicSystem THEN
   IF MusicDone THEN
      CurTrack% = CurTrack% + 1
      IF CurTrack% = 4 THEN CurTrack% = 1
      IF LoadMidi%("TRACK" + LTRIM$(STR$(CurTrack%)) + ".MID") = 0 THEN
         PlayMIDI
      END IF
   END IF
END IF

CALL DQBclearLayer(1)

IF StarsV = 10 THEN StarsV = 0
StarsV = StarsV + 1

FOR a = 0 TO 29
   CALL DQBpset(1, StarsX(a), StarsY(a), 24)
   IF StarsV = 10 THEN
      StarsY(a) = StarsY(a) + 1
      IF StarsY(a) = 200 THEN
         StarsX(a) = INT(RND * 320)
         StarsY(a) = 0
      END IF
   END IF
NEXT a

FOR a = 30 TO 49
   CALL DQBpset(1, StarsX(a), StarsY(a), 31)
   IF StarsV = 5 OR StarsV = 10 THEN
      StarsY(a) = StarsY(a) + 1
      IF StarsY(a) = 200 THEN
         StarsX(a) = INT(RND * 320)
         StarsY(a) = 0
      END IF
   END IF
NEXT a

IF Stat = 0 THEN
   CALL UpdateKeys
   IF QuitKeyPressed THEN
      Pal$ = STRING$(768, 63)
      Fade = 64
      Quit = -1
      Stat = 14
      IF SoundSystem THEN CALL DQBplaySound(1, 1, 11025, ONCE)
      Boom = -1
   END IF

   IF LeftKeyPressed THEN
      DolphinH = DolphinH - 1
      IF DolphinH < -30 THEN DolphinH = -30
   ELSE
      IF DolphinH < 0 THEN DolphinH = DolphinH + 1
   END IF

   IF RightKeyPressed THEN
      DolphinH = DolphinH + 1
      IF DolphinH > 30 THEN DolphinH = 30
   ELSE
      IF DolphinH > 0 THEN DolphinH = DolphinH - 1
   END IF

   IF UpKeyPressed THEN
      DolphinV = DolphinV - 1
      IF DolphinV < -30 THEN DolphinV = -30
   ELSE
      IF DolphinV < 0 THEN DolphinV = DolphinV + 1
   END IF

   IF DownKeyPressed THEN
      DolphinV = DolphinV + 1
      IF DolphinV > 30 THEN DolphinV = 30
   ELSE
      IF DolphinV > 0 THEN DolphinV = DolphinV - 1
   END IF

   IF Torp > 2 THEN Torp = Torp - 1
   IF FireKeyPressed AND Torp = 2 THEN
   FOR a = 0 TO 99 STEP 2
      IF TorpedoT(a) = 0 THEN
         TorpedoT(a) = 1
         TorpedoY(a) = DolphinY + 15
         TorpedoX(a) = DolphinX + 6
         TorpedoT(a + 1) = 1
         TorpedoY(a + 1) = DolphinY + 15
         TorpedoX(a + 1) = DolphinX + 35
         Torp = 10
         EXIT FOR
      END IF
   NEXT a
   END IF

   DolphinX = DolphinX + (DolphinH \ 10)
   IF DolphinX > 277 THEN DolphinX = 277
   IF DolphinX < 0 THEN DolphinX = 0

   DolphinY = DolphinY + (DolphinV \ 10)
   IF DolphinY > 154 THEN DolphinY = 154
   IF DolphinY < 0 THEN DolphinY = 0
ELSEIF Stat > 13 THEN
   CALL DQBput(1, DolphinX, DolphinY, VARSEG(Sprites(Stat * 947)), VARPTR(Sprites(Stat * 947)))
   IF StarsV = 3 OR StarsV = 6 OR StarsV = 9 THEN Stat = Stat + 1: IF Stat = 21 THEN Stat = 1
END IF

IF NOT TOTALBOOM THEN
EnemyX = EnemyX + EnemyIncr
IF EnemyX = 0 THEN
   EnemyIncr = 1
ELSEIF EnemyX = 204 THEN
   EnemyIncr = -1
END IF
EnemyY = EnemyY + EnemyVert
IF EnemyY = -50 THEN
   EnemyVert = 1
ELSEIF EnemyY = 50 THEN
   EnemyVert = -1
END IF

CALL DQBput(1, EnemyX, EnemyY, VARSEG(Sprites(0)), VARPTR(Sprites(6629)))
     
      IF StarsV = 10 THEN
         FOR a = 7 TO 9
            FOR b = 0 TO 99 STEP 2
               IF TorpedoT(b) = 0 THEN
                  TorpedoT(b) = 2
                  TorpedoX(b) = EnemyX + Torp1X(a)
                  TorpedoY(b) = EnemyY + Torp1Y(a)
                  TorpedoT(b + 1) = 2
                  TorpedoX(b + 1) = EnemyX + Torp2X(a)
                  TorpedoY(b + 1) = EnemyY + Torp2Y(a)
                  EXIT FOR
               END IF
            NEXT b
         NEXT a
      END IF

FOR a = 0 TO 99
   SELECT CASE TorpedoT(a)
   CASE 1
      IF NOT Quit THEN
      IF Stat = 0 THEN
    
      IF DQBcollide(EnemyX, EnemyY, VARSEG(Sprites(6629)), VARPTR(Sprites(6629)), TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887))) THEN
         IF Stat = 0 THEN DolphinS = DolphinS + 10
         IF DolphinS > 1000 THEN DolphinS = 1000
         EnemyS = EnemyS - 1
       
         IF EnemyS = 0 THEN
            Score = Score + 100
            TOTALBOOM = -1
            FOR c = 0 TO 49
             TorpedoX(c) = (RND * 115) + EnemyX
             TorpedoY(c) = (RND * 106) + EnemyY
            NEXT c
            IF MusicSystem THEN CALL StopMIDI
            IF SoundSystem THEN CALL DQBplaySound(1, 1, 8000, ONCE)
            FOR boomstat = 14 TO 20
            FOR c = 0 TO 49
            CALL DQBput(1, TorpedoX(c) - 21, TorpedoY(c) - 23, VARSEG(Sprites(boomstat * 947)), VARPTR(Sprites(boomstat * 947)))
            CALL DQBput(1, DolphinX, DolphinY, VARSEG(Sprites(((DolphinH \ 10) + 3) * 947)), VARPTR(Sprites(((DolphinH \ 10) + 3) * 947)))
            CALL DQBcopyLayer(1, 0)
            NEXT c
            NEXT boomstat
            Quit = -1
            Fade = 64
            Pal$ = STRING$(768, 0)
            Boom = 0
            CALL DQBfadeTo(63, 63, 63)
         ELSE
            Score = Score + 100
            CALL DQBput(1, TorpedoX(a) - 21, TorpedoY(a) - 23, VARSEG(Sprites(13258)), VARPTR(Sprites(13258)))
            IF SoundSystem THEN CALL DQBplaySound(2, 2, 11025, ONCE)
         END IF
         TorpedoT(a) = 0
      END IF
      END IF
      END IF
    
      CALL DQBput(1, TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887)))
      TorpedoY(a) = TorpedoY(a) - 4
      IF TorpedoY(a) < 0 THEN TorpedoT(a) = 0
   CASE 2
      IF NOT Quit THEN
      IF DQBcollide(DolphinX, DolphinY, VARSEG(Sprites(((DolphinH \ 10) + 3) * 947)), VARPTR(Sprites(((DolphinH \ 10) + 3) * 947)), TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887))) THEN
         DolphinS = DolphinS - 20
         IF SoundSystem THEN CALL DQBplaySound(3, 3, 11025, ONCE)
         IF DolphinS < 0 THEN
            DolphinS = 0
            IF Stat = 0 THEN
               Pal$ = STRING$(768, 63)
               Fade = 64
               Quit = -1
               Boom = -1
               Stat = 14
               IF SoundSystem THEN CALL DQBplaySound(1, 1, 11025, ONCE)
            END IF
         ELSE
            IF Stat = 0 THEN CALL DQBput(1, TorpedoX(a) - 21, TorpedoY(a) - 23, VARSEG(Sprites(18940)), VARPTR(Sprites(18940)))
         END IF
         TorpedoT(a) = 0
      END IF
      END IF
      CALL DQBput(1, TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887)))
      TorpedoY(a) = TorpedoY(a) + 4
      IF TorpedoY(a) > 200 THEN TorpedoT(a) = 0
   END SELECT
NEXT a

END IF

Shields$ = STR$(DolphinS \ 10) + "%"
Shields$ = STRING$(5 - LEN(Shields$), 32) + Shields$

IF Stat = 0 THEN CALL DQBput(1, DolphinX, DolphinY, VARSEG(Sprites(((DolphinH \ 10) + 3) * 947)), VARPTR(Sprites(((DolphinH \ 10) + 3) * 947)))

CALL DQBprint(1, "Shields:" + Shields$, 0, 192, 254)

Shields$ = STR$(Score)
Shields$ = STRING$(8 - LEN(Shields$), 32) + Shields$
 
IF Score > ScoreTable(0) THEN
   CALL DQBprint(1, "HighScore:" + Shields$, 176, 192, 254)
ELSE
   CALL DQBprint(1, "Score:" + Shields$, 208, 192, 254)
END IF
 
CALL DQBwait(1)
IF Fade > 0 THEN
   CALL DQBfadeStepIn(Pal$)
   Fade = Fade - 1
   IF Fade = 0 AND Quit THEN EXIT DO
END IF
CALL DQBcopyLayer(1, 0)
LOOP

IF Boom THEN
   PlayBoss = 1
ELSE
   IF MusicSystem THEN
   IF LoadMidi%("WINNER.MID") = 0 THEN
      PlayMIDI
   END IF
   END IF
   a = DQBloadImage(0, 0, 0, "WINNER.PCX", Pal$, 0, 0)
   PlayBoss = 2
   CALL DQBfadeIn(Pal$)
   DO
      CALL UpdateKeys
      IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
   LOOP
   CALL DQBfadeTo(0, 0, 0)
END IF

END FUNCTION

REM $DYNAMIC
FUNCTION PlayGame% (Level%)
  
a = DQBloadImage(0, 0, 0, "START.PCX", Pal$, 0, 0)
PlayGame = 2
CALL DQBprint(0, "STARTING LEVEL" + STR$(Level%), 92, 180, 199)
CALL DQBfadeIn(Pal$)

CALL LoadLevel("LEVEL" + MID$(STR$(Level%), 2))

DIM StarsX(49) AS INTEGER
DIM StarsY(49) AS INTEGER

DIM TorpedoX(99) AS INTEGER
DIM TorpedoY(99) AS INTEGER
DIM TorpedoT(99) AS INTEGER

DIM EnemyX(5) AS INTEGER
DIM EnemyY(5) AS INTEGER
DIM EnemyN(5) AS INTEGER
DIM EnemyS(5) AS INTEGER

RANDOMIZE TIMER

FOR a = 0 TO 2
   EnemyX(a) = 0
   EnemyY(a) = 100 - (a * 75)
   EnemyN(a) = 0
   EnemyS(a) = 0
   EnemyX(a + 3) = 274 - EnemyX(a)
   EnemyY(a + 3) = EnemyY(a)
   EnemyN(a + 3) = 0
   EnemyS(a + 3) = 0
NEXT a

FOR a = 0 TO 49
   StarsX(a) = INT(RND * 320)
   StarsY(a) = INT(RND * 200)
NEXT a

DolphinX = 138
DolphinY = 154
DolphinH = 0
DolphinV = 0
DolphinS = 1000

Stat = 0
Fade = 64
Torp = 2

CALL DQBsetCollideMethod(1)
CALL DQBsetTextStyle(NONE)

Pal$ = Paleta$

DO
   CALL UpdateKeys
   IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
LOOP

CALL DQBfadeTo(0, 0, 0)

DO

IF MusicSystem THEN
   IF MusicDone THEN
      CurTrack% = CurTrack% + 1
      IF CurTrack% = 4 THEN CurTrack% = 1
      IF LoadMidi%("TRACK" + LTRIM$(STR$(CurTrack%)) + ".MID") = 0 THEN
         PlayMIDI
      END IF
   END IF
END IF

CALL DQBclearLayer(1)

IF StarsV = 10 THEN StarsV = 0
StarsV = StarsV + 1

FOR a = 0 TO 29
   CALL DQBpset(1, StarsX(a), StarsY(a), 24)
   IF StarsV = 10 THEN
      StarsY(a) = StarsY(a) + 1
      IF StarsY(a) = 200 THEN
         StarsX(a) = INT(RND * 320)
         StarsY(a) = 0
      END IF
   END IF
NEXT a

FOR a = 30 TO 49
   CALL DQBpset(1, StarsX(a), StarsY(a), 31)
   IF StarsV = 5 OR StarsV = 10 THEN
      StarsY(a) = StarsY(a) + 1
      IF StarsY(a) = 200 THEN
         StarsX(a) = INT(RND * 320)
         StarsY(a) = 0
      END IF
   END IF
NEXT a

IF Stat = 0 THEN
   CALL UpdateKeys
   IF QuitKeyPressed THEN
      Pal$ = STRING$(768, 63)
      Fade = 64
      Quit = -1
      Stat = 14
      IF SoundSystem THEN CALL DQBplaySound(1, 1, 11025, ONCE)
      Boom = -1
   END IF

   IF LeftKeyPressed THEN
      DolphinH = DolphinH - 1
      IF DolphinH < -30 THEN DolphinH = -30
   ELSE
      IF DolphinH < 0 THEN DolphinH = DolphinH + 1
   END IF

   IF RightKeyPressed THEN
      DolphinH = DolphinH + 1
      IF DolphinH > 30 THEN DolphinH = 30
   ELSE
      IF DolphinH > 0 THEN DolphinH = DolphinH - 1
   END IF

   IF UpKeyPressed THEN
      DolphinV = DolphinV - 1
      IF DolphinV < -30 THEN DolphinV = -30
   ELSE
      IF DolphinV < 0 THEN DolphinV = DolphinV + 1
   END IF

   IF DownKeyPressed THEN
      DolphinV = DolphinV + 1
      IF DolphinV > 30 THEN DolphinV = 30
   ELSE
      IF DolphinV > 0 THEN DolphinV = DolphinV - 1
   END IF

   IF Torp > 2 THEN Torp = Torp - 1
   IF FireKeyPressed AND Torp = 2 THEN
   FOR a = 0 TO 99 STEP 2
      IF TorpedoT(a) = 0 THEN
         TorpedoT(a) = 1
         TorpedoY(a) = DolphinY + 15
         TorpedoX(a) = DolphinX + 6
         TorpedoT(a + 1) = 1
         TorpedoY(a + 1) = DolphinY + 15
         TorpedoX(a + 1) = DolphinX + 35
         Torp = 10
         EXIT FOR
      END IF
   NEXT a
   END IF

   DolphinX = DolphinX + (DolphinH \ 10)
   IF DolphinX > 277 THEN DolphinX = 277
   IF DolphinX < 0 THEN DolphinX = 0

   DolphinY = DolphinY + (DolphinV \ 10)
   IF DolphinY > 154 THEN DolphinY = 154
   IF DolphinY < 0 THEN DolphinY = 0
ELSEIF Stat > 13 THEN
   CALL DQBput(1, DolphinX, DolphinY, VARSEG(Sprites(Stat * 947)), VARPTR(Sprites(Stat * 947)))
   IF StarsV = 3 OR StarsV = 6 OR StarsV = 9 THEN Stat = Stat + 1: IF Stat = 21 THEN Stat = 1
END IF

FOR a = 0 TO 5
   IF EnemyN(a) > 0 AND EnemyN(a) > -45 THEN
      CALL DQBput(1, EnemyX(a), EnemyY(a), VARSEG(Sprites(EnemyN(a) * 947)), VARPTR(Sprites(EnemyN(a) * 947)))
      IF EnemyN(a) < 14 THEN
         IF EnemyY(a) < DolphinY AND Stat = 0 THEN
         IF EnemyX(a) < DolphinX + 41 AND EnemyX(a) + 41 > DolphinX THEN
         IF StarsV = 10 THEN
            FOR b = 0 TO 99 STEP 2
               IF TorpedoT(b) = 0 THEN
                  TorpedoT(b) = 2
                  TorpedoX(b) = EnemyX(a) + Torp1X(EnemyN(a))
                  TorpedoY(b) = EnemyY(a) + Torp1Y(EnemyN(a))
                  TorpedoT(b + 1) = 2
                  TorpedoX(b + 1) = EnemyX(a) + Torp2X(EnemyN(a))
                  TorpedoY(b + 1) = EnemyY(a) + Torp2Y(EnemyN(a))
                  EXIT FOR
               END IF
            NEXT b
         END IF
         END IF
         END IF
      ELSE
         IF (StarsV AND 1) THEN EnemyN(a) = EnemyN(a) + 1
         IF EnemyN(a) = 21 THEN EnemyN(a) = 0
      END IF
   END IF
   EnemyY(a) = EnemyY(a) + 1
   IF EnemyY(a) > 199 AND a < 3 THEN
      EnemyX(a) = INT(RND * 100)
      EnemyY(a) = -45
      EnemyN(a) = INT(RND * 7) + 7
      EnemyS(a) = EnemyN(a) - 6
      EnemyX(a + 3) = 274 - EnemyX(a)
      EnemyY(a + 3) = -45
      EnemyN(a + 3) = EnemyN(a)
      EnemyS(a + 3) = EnemyN(a) - 6
   END IF
NEXT a

FOR a = 0 TO 99
   SELECT CASE TorpedoT(a)
   CASE 1
      IF NOT Quit THEN
      IF Stat = 0 THEN
      FOR b = 0 TO 5
      IF EnemyN(b) > 0 AND EnemyN(b) < 14 THEN
      IF DQBcollide(EnemyX(b), EnemyY(b), VARSEG(Sprites(EnemyN(b) * 947)), VARPTR(Sprites(EnemyN(b) * 947)), TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887))) THEN
         IF Stat = 0 THEN DolphinS = DolphinS + 5
         IF DolphinS > 1000 THEN DolphinS = 1000
         EnemyS(b) = EnemyS(b) - 1
         IF EnemyS(b) = 0 THEN
            Score = Score + (EnemyN(b) * 9)
            EnemyN(b) = 14
            IF SoundSystem THEN CALL DQBplaySound(1, 1, 11025, ONCE)
            ShipsBoomed = ShipsBoomed + 1
            IF ShipsBoomed = 25 THEN
               Quit = -1
               Fade = 64
               Pal$ = STRING$(768, 0)
               Boom = 0
            END IF
         ELSE
            CALL DQBput(1, TorpedoX(a) - 21, TorpedoY(a) - 23, VARSEG(Sprites(18940)), VARPTR(Sprites(18940)))
            IF SoundSystem THEN CALL DQBplaySound(2, 2, 11025, ONCE)
         END IF
         TorpedoT(a) = 0
      END IF
      END IF
      NEXT b
      END IF
      END IF
      CALL DQBput(1, TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887)))
      TorpedoY(a) = TorpedoY(a) - 4
      IF TorpedoY(a) < 0 THEN TorpedoT(a) = 0
   CASE 2
      IF NOT Quit THEN
      IF DQBcollide(DolphinX, DolphinY, VARSEG(Sprites(((DolphinH \ 10) + 3) * 947)), VARPTR(Sprites(((DolphinH \ 10) + 3) * 947)), TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887))) THEN
         DolphinS = DolphinS - 20
         IF SoundSystem THEN CALL DQBplaySound(3, 3, 11025, ONCE)
         IF DolphinS < 0 THEN
            DolphinS = 0
            IF Stat = 0 THEN
               Pal$ = STRING$(768, 63)
               Fade = 64
               Quit = -1
               Boom = -1
               Stat = 14
               IF SoundSystem THEN CALL DQBplaySound(1, 1, 11025, ONCE)
            END IF
         ELSE
            IF Stat = 0 THEN CALL DQBput(1, TorpedoX(a) - 21, TorpedoY(a) - 23, VARSEG(Sprites(18940)), VARPTR(Sprites(18940)))
         END IF
         TorpedoT(a) = 0
      END IF
      END IF
      CALL DQBput(1, TorpedoX(a) - 1, TorpedoY(a) - 1, VARSEG(Sprites(19887)), VARPTR(Sprites(19887)))
      TorpedoY(a) = TorpedoY(a) + 4
      IF TorpedoY(a) > 200 THEN TorpedoT(a) = 0
   END SELECT
NEXT a

Shields$ = STR$(DolphinS \ 10) + "%"
Shields$ = STRING$(5 - LEN(Shields$), 32) + Shields$

IF Stat = 0 THEN CALL DQBput(1, DolphinX, DolphinY, VARSEG(Sprites(((DolphinH \ 10) + 3) * 947)), VARPTR(Sprites(((DolphinH \ 10) + 3) * 947)))

CALL DQBprint(1, "Shields:" + Shields$, 0, 192, 254)

Shields$ = STR$(Score)
Shields$ = STRING$(8 - LEN(Shields$), 32) + Shields$
  
IF Score > ScoreTable(0) THEN
   CALL DQBprint(1, "HighScore:" + Shields$, 176, 192, 254)
ELSE
   CALL DQBprint(1, "Score:" + Shields$, 208, 192, 254)
END IF
  
CALL DQBwait(1)
IF Fade > 0 THEN
   CALL DQBfadeStepIn(Pal$)
   Fade = Fade - 1
   IF Fade = 0 AND Quit THEN EXIT DO
END IF
CALL DQBcopyLayer(1, 0)
LOOP

IF Boom THEN
   PlayGame = 1
ELSE
   a = DQBloadImage(0, 0, 0, "COMPLETE.PCX", Pal$, 0, 0)
   PlayGame = 2
   CALL DQBprint(0, "PASSWORD: " + GenPass$(Level%, Score), 100, 180, 199)
   CALL DQBfadeIn(Pal$)
   DO
      CALL UpdateKeys
      IF FireKeyPressed OR QuitKeyPressed THEN EXIT DO
   LOOP
   CALL DQBfadeTo(0, 0, 0)
END IF

END FUNCTION

SUB PlayMIDI
QMIDIRegs.BX = 4
QMIDIRegs.DX = Mem.Segment
QMIDIRegs.AX = 0
CALL IntX(SBMIDI.Interrupt, QMIDIRegs)
QMIDIRegs.BX = 5
CALL IntX(SBMIDI.Interrupt, QMIDIRegs)
END SUB

SUB StopMIDI
QMIDIRegs.BX = 4
QMIDIRegs.DX = Mem.Segment
QMIDIRegs.AX = 0
CALL IntX(SBMIDI.Interrupt, QMIDIRegs)
QMIDIRegs.ES = Mem.Segment
QMIDIRegs.AX = &H4900
CALL IntX(&H21, QMIDIRegs)
a& = SETMEM(Mem.Allocated)
Mem.Segment = 0
END SUB

SUB UpdateKeys
UpKeyPressed = 0
DownKeyPressed = 0
LeftKeyPressed = 0
RightKeyPressed = 0
FireKeyPressed = 0
QuitKeyPressed = 0

IF DQBkey(KEYUP) THEN UpKeyPressed = -1
IF DQBkey(KEYDOWN) THEN DownKeyPressed = -1
IF DQBkey(KEYLEFT) THEN LeftKeyPressed = -1
IF DQBkey(KEYRIGHT) THEN RightKeyPressed = -1
IF DQBkey(29) OR DQBkey(KEYENTER) OR DQBkey(57) THEN FireKeyPressed = -1
IF DQBkey(KEYESC) THEN QuitKeyPressed = -1

IF JoyAvail THEN
    DQBpollJoy JoyNum
    IF DQBjoyMove(JoyNum, UP) THEN UpKeyPressed = -1
    IF DQBjoyMove(JoyNum, DOWN) THEN DownKeyPressed = -1
    IF DQBjoyMove(JoyNum, LEFT) THEN LeftKeyPressed = -1
    IF DQBjoyMove(JoyNum, RIGHT) THEN RightKeyPressed = -1
    IF DQBjoyFire(JoyNum, BUTA) THEN FireKeyPressed = -1
    IF DQBjoyFire(JoyNum, BUTB) THEN QuitKeyPressed = -1
END IF
END SUB

REM $STATIC
FUNCTION UsePass% (Pass$)

Normal$ = "qwertyuiopasdfghjklzxcvbnm0123456789"
v& = (INSTR(Normal$, MID$(Pass$, 5, 1)) - 1) * 46656
v& = v& + ((INSTR(Normal$, MID$(Pass$, 4, 1)) - 1) * 1296&)
v& = v& + ((INSTR(Normal$, MID$(Pass$, 3, 1)) - 1) * 36&)
v& = v& + INSTR(Normal$, MID$(Pass$, 2, 1)) - 1
n% = INSTR(Normal$, LEFT$(Pass$, 1)) - (v& - (v& \ 26) * 26) - 1

IF (n% < 1) OR (n% > 10) OR (v& < (n% * 1575)) OR (v& > (n% * 2925)) THEN
   UsePass% = -1
ELSE
   UsePass% = n%
   Score = v&
END IF

END FUNCTION

