REM The Dungeon Player Edit Utility v12.0 r3.0 Program Source

' declare all variables as integer type
DEFINT A-Z

' declares variable storage for user record structure type
TYPE UserType
 Codename AS STRING * 32
 Password AS STRING * 32
 Spell(1 TO 40) AS INTEGER
 Wand(1 TO 10) AS INTEGER
 Potion(1 TO 10) AS INTEGER
 Staff(1 TO 10) AS INTEGER
 Ring(1 TO 10) AS INTEGER
 Globe(1 TO 10) AS INTEGER
 Stats1(1 TO 6) AS DOUBLE
 Stats2(1 TO 17) AS INTEGER
END TYPE

' define error routine trap label
ON ERROR GOTO Error.Routine

' declare structures common to main program
DIM UserRec AS UserType

' define function to convert encrypted string to 20 character string
DEF FNdecrypt$ (z$)
  i$ = ""' reset decrypted return string
  FOR j = 1 TO 4' loop in 4 blocks of 5 bytes
    j$ = ""' reset block string
    z# = CVD(MID$(z$, j * 8 - 7, 8))' store block value
    FOR q = 1 TO 5' loop in block bytes
      dvid# = INT(z# / 1000)' store block byte value
      num# = z# - dvid# * 1000' compute block byte value
      z# = dvid#' decrement block value
      j$ = j$ + CHR$(num#)' add byte to string
    NEXT ' next block byte
    Y$ = MID$(j$, 1, 1)' reverse stored bytes
    MID$(j$, 1, 1) = MID$(j$, 5, 1)' reverse
    MID$(j$, 5, 1) = Y$' reverse
    Y$ = MID$(j$, 2, 1)' reverse stored bytes
    MID$(j$, 2, 1) = MID$(j$, 4, 1)' reverse
    MID$(j$, 4, 1) = Y$' reverse
    i$ = i$ + j$' add string to return string
  NEXT ' next block
  FNdecrypt$ = i$' store return function string
END DEF ' end decryption function

' define password
COLOR 7, 0 ' white on black
CLS ' clear screen
PRINT "Edit password"; ' display input prompt
INPUT Input.String$ ' get a keystroke from keyboard
Input.String$ = UCASE$(Input.String$) ' force input to uppercase
IF Input.String$ <> "JUGGERNAUT" THEN ' check password input
   END ' quit program if not equal
END IF ' end check password input

' main program
GOSUB Open.User.File ' open the users data file
User.Number = 1 ' reset user number being edited
DO ' loop through all users in data file
   GOSUB Page.Header ' display edit page header
   COLOR 14 ' color yellow
   GET 1, User.Number, UserRec ' read the next user record from data file
   User.Name$ = FNdecrypt$(UserRec.Codename) ' read encrypted user name
   MID$(User.Name$, 1, 1) = UCASE$(MID$(User.Name$, 1, 1)) ' uppercase name
   User.Name$ = RTRIM$(User.Name$) ' trim right side of user name
   PRINT User.Name$; ": Edit(Y/N/Q)? "; ' prompt to edit user name
   Input.Char$ = INPUT$(1) ' get one keystroke
   SELECT CASE UCASE$(Input.Char$) ' determine input key pressed
   CASE "N" ' input no
      User.Number = User.Number + 1 ' increment to next user
   CASE "Y" ' input yes
      GOSUB Edit.User ' edit current user
      User.Number = User.Number + 1 ' increment to next user
   CASE "Q" ' input quit
      EXIT DO ' exit editing loop
   END SELECT ' end input key determine
' check user number to end of user data file
LOOP WHILE User.Number <= LOF(1) / LEN(UserRec)
GOSUB Press.Key ' get a key press
COLOR 7, 0 ' white on black
CLS ' clear screen
END ' quit program

' define routine to prompt for key press
Press.Key:
 LOCATE 25, 1, 0 ' locate cursor to bottom of screen
 COLOR 10 ' color magenta
 PRINT "Press a key to continue:"; ' display prompt message
 WHILE INKEY$ = "" ' wait for key press
 WEND ' end wait for key press
 RETURN ' exit routine

' routine to input edit values for user
Edit.User:
 COLOR 11 ' color cyan
 PRINT ' empty linefeed
 PRINT "Strength(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(1) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Wisdom(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(2) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Intellect(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(3) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Constitution(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(4) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Dexterity(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(5) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Charisma(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(6) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Weapon(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(7) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Shield(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(8) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Armor(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(9) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Cloak(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(10) = INT(Input.Value%) ' store valid numeric entry
 END IF ' end validate numeric range
 PRINT "Helmet(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(11) = INT(Input.Value%) ' store valid input entry
 END IF ' end validate numeric range
 PRINT "Boots(1-99)"; ' display input prompt
 INPUT Input.Value% ' get numeric input value
 IF INT(Input.Value%) > 0 AND INT(Input.Value%) < 100 THEN ' validate numeric range
    UserRec.Stats2(12) = INT(Input.Value%) ' store valid input entry
 END IF ' end validate numeric range
 PRINT "Experience"; ' display input prompt
 INPUT Input.Value# ' get numeric input value
 UserRec.Stats1(3) = CDBL(INT(Input.Value#)) ' store double precision input entry
 PRINT "Gold"; ' display input prompt
 INPUT Input.Value# ' get numeric input value
 UserRec.Stats1(5) = CDBL(INT(Input.Value#)) ' store double precision input entry
 PUT 1, User.Number, UserRec ' write user number record to data file
 RETURN ' exit routine

' display the edit page header on screen
Page.Header:
 COLOR 14, 1 ' yellow on blue
 CLS ' clear screen
 COLOR 15 ' white foreground
 PRINT "The Dungeon Player Edit 11.0 Utility" ' display header
 PRINT STRING$(36, "=") ' display header underline
 RETURN ' exit routine

' open the user file, length of user record
Open.User.File:
 CLOSE 1 ' close file 1
 ' open user file random
 OPEN "players.dat" FOR RANDOM SHARED AS #1 LEN = LEN(UserRec)
 RETURN ' exit routine

' trap any fatal errors and quit program
Error.Routine:
 COLOR 7, 0 ' white on black
 CLS ' clear screen
 PRINT "The Editor Crashed.." ' display error message
 END ' quit program

