// SHAMLib

// PRIMIT.H
// Mode 13h Graphics Primitives (pixel, line, etc.)

#include <mem.h>
#include <dos.h>

#define SCREEN_WIDTH        320
#define SCREEN_HEIGHT       240
#define NUM_COLORS          256
#define sgn(x) 				((x<0)?-1:((x>0)?1:0))

typedef unsigned short word;

unsigned char far *vid_buffer=(unsigned char far *)0xA0000000L;
//unsigned char far *mem_buffer=(unsigned char far *) malloc(64000);

int offset;
//int offset2;

void pset(int x, int y, int color);
void c4_pset(int x, int y, int color);
int point(int x, int y);
void line(int x1, int y1, int x2, int y2, int color);
void box(int x1, int y1, int x2, int y2, int color);
void circle(int x, int y, int radius, int color);
void fill(int seedx, int seedy, int color);

// C4_PSET
// Puts a pixel on the screen in Chain-4 Mode
void c4_pset(int x, int y, int color)
{
 offset = (y<<8) + (y<<6) + x;
 vid_buffer[offset] = color;
}

// PSET
// Puts a pixel on the screen at 'x','y' with 'color'
void pset(int x, int y, int color)
{
  outportb(SC_INDEX, MAP_MASK);          /* select plane */
  outportb(SC_DATA,  1 << (x&3) );

  vid_buffer[(y<<6) + (y<<4) + (x>>2)]=color;

//  asm les DI, vid_buffer
//  asm mov BX, x
//  asm shr BX, 2
//  asm add DI, BX
//  asm mov AX, y
//  asm shl AX, 6
//  asm add DI, AX
//  asm mov DX, y
//  asm shl DX, 4
//  asm add DI, DX
//  asm mov CX, color
//  asm mov ES:[DI], CX
}

// POINT
// Returns the color of the pixel at 'x','y'
int point(int x, int y)
{
// offset = (y<<8)+(y<<6)+x;
 offset = vid_buffer[(y<<6) + (y<<4) + (x>>2)];
 return vid_buffer[offset];
}

// LINE
// Draws a line of thickness 1 from 'x1','y1' to 'x2','y2' in 'color'
void line(int x1, int y1, int x2, int y2, int color)
{
  int i,dx,dy,sdx,sdy,dxabs,dyabs,x,y,px,py;

  dx=x2-x1;      /* the horizontal distance of the line */
  dy=y2-y1;      /* the vertical distance of the line */
  dxabs=abs(dx);
  dyabs=abs(dy);
  sdx=sgn(dx);
  sdy=sgn(dy);
  x=dyabs>>1;
  y=dxabs>>1;
  px=x1;
  py=y1;

//  vid_buffer[(py<<8)+(py<<6)+px]=color;
  c4_pset(px,py,color);

  if (dxabs>=dyabs) /* the line is more horizontal than vertical */
  {
	for(i=0;i<dxabs;i++)
	{
	  y+=dyabs;
	  if (y>=dxabs)
	  {
		y-=dxabs;
		py+=sdy;
	  }
	  px+=sdx;
//	  vid_buffer[(py<<8)+(py<<6)+px]=color;
	  c4_pset(px,py,color);
	}
  }
  else /* the line is more vertical than horizontal */
  {
	for(i=0;i<dyabs;i++)
	{
	  x+=dxabs;
	  if (x>=dyabs)
	  {
		x-=dyabs;
		px+=sdx;
	  }
	  py+=sdy;
//	  vid_buffer[(py<<8)+(py<<6)+px]=color;
	  c4_pset(px,py,color);
	}
  }
}

// BOX
// Plots a box by drawing four lines
void box(int x1, int y1, int x2, int y2, int color)
{
 line(x1,y1,x2,y1,color);
 line(x1,y1,x1,y2,color);
 line(x2,y2,x1,y2,color);
 line(x2,y2,x2,y1,color);
}

void clear(int x1, int y1, int x2, int y2, int color)
{
 int x,y;
 for (x=x1;x<x2;x++)
 {
  for (y=y1;y<y2;y++)
  {
   c4_pset(x,y,color);
  }
 }
}

// FILL
// Flood fills a closed shape
void fill(int seedx, int seedy, int color)
{

}

// CIRCLE
// Draws a circle at 'x','y' that is 'radius' in size and in 'color'
void circle(int x, int y, int radius, int color)
{
 float x1,y1,x2,y2,angle;

 x1 = x;
 y1 = y;

 pset(x1+radius,y1,color);
 pset(x1-radius,y1,color);
 pset(x1,y1-radius,color);
 pset(x1,y1+radius,color);

 for (angle=1; angle<90; angle++)
 {
  x2 = x1;
  y2 = y1;

  x2+=sin(angle*(M_PI/180))*radius;
  y2-=cos(angle*(M_PI/180))*radius;

  pset(x2,y2,color);
 }
 for (angle=1; angle<90; angle++)
 {
  x2 = x1;
  y2 = y1;

  x2+=sin(angle*(M_PI/180))*radius;
  y2+=cos(angle*(M_PI/180))*radius;

  pset(x2,y2,color);
 }
 for (angle=1; angle<90; angle++)
 {
  x2 = x1;
  y2 = y1;

  x2-=sin(angle*(M_PI/180))*radius;
  y2+=cos(angle*(M_PI/180))*radius;

  pset(x2,y2,color);
 }
 for (angle=1; angle<90; angle++)
 {
  x2 = x1;
  y2 = y1;

  x2-=sin(angle*(M_PI/180))*radius;
  y2-=cos(angle*(M_PI/180))*radius;

  pset(x2,y2,color);
 }
}

void polygon(int x, int y, int radius, int sides, int color, int shift=0)
{
 float x1,y1,x2,y2,x3,y3,angle;

 x1 = x;
 y1 = y;

 x3=0;
 y3=0;

 for (angle=1+shift; angle<420+shift; angle+=360/sides)
 {
  x2 = x1;
  y2 = y1;

  x2+=sin(angle*(M_PI/180))*radius;
  y2-=cos(angle*(M_PI/180))*radius;

  if (x3==0 && y3==0) {x3=x2; y3=y2;}

  line(x2,y2,x3,y3,color);
  x3 = x2;
  y3 = y2;
 }
}