// Star Shooter game
// Stars.h
// Plotting and scoring

#define TYPE_STAR		0			// Object is a star (non-score)
#define RANDOM_OBJECT   1           // Object is a random object (score++)
#define DEATH_OBJECT	2

void draw_sprite(int color, int SubType, int Degrees, int Distance);

int sprites[3][16][16] = {{
 {0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
 {0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0},
 {0,0,0,1,0,1,0,1,1,0,1,0,1,0,0,0},
 {0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0},
 {0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
 {0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0},
 {0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0},
 {0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0},
 {0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0},
 {0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0},
 {1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
 {0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0},
 {0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0},
 {0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0},
 {0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
 {0,0,1,1,0,1,1,0,0,1,1,0,1,1,0,0},
 {0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0},
 {0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0},
 {0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

{{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0},
 {0,1,0,1,0,0,1,0,0,1,0,0,0,1,0,0},
 {0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0},
 {0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
 {0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0},
 {0,0,0,1,1,1,0,1,1,0,1,1,1,0,0,0},
 {0,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0},
 {0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0},
 {0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0},
 {0,0,0,0,1,0,1,0,0,1,0,1,0,0,0,0},
 {0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0},
 {0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}};

enum boolean {FALSE=0, TRUE=1};

extern int PLAYER_SCORE;

int DegreesToX(int degrees, int distance);
int DegreesToY(int degrees, int distance);

class StarObject
{
 public:
 int Score;
 boolean Active;
 int Type;
  int SubType;
 int Degrees;
 int Distance;
 int Speed;

 void Reset(void)
 {
  Score=0;
  Active=FALSE;
  Distance=0;
 }

 void Move(int opt=0)
 {
  if (DegreesToX(Degrees, Distance) > 0) Distance+=Speed; else {if (opt == 0) RndInit(); else Active=FALSE;}
  if (DegreesToX(Degrees, Distance) < 319) Distance+=Speed; else {if (opt == 0) RndInit(); else Active=FALSE;}
  if (DegreesToY(Degrees, Distance) > 0) Distance+=Speed; else {if (opt == 0) RndInit(); else Active=FALSE;}
  if (DegreesToY(Degrees, Distance) < 199) Distance+=Speed; else {if (opt == 0) RndInit(); else Active=FALSE;}
 }

 void Implode(void)
 {
  if (DegreesToX(Degrees, Distance) > 0) Distance-=Speed;
  if (DegreesToX(Degrees, Distance) < 319) Distance-=Speed;
  if (DegreesToY(Degrees, Distance) > 0) Distance-=Speed;
  if (DegreesToY(Degrees, Distance) < 199) Distance-=Speed;
  if (Distance <= 1) Active = FALSE;
 }

 void Shoot(void)
 {
  Plot(9); delay(15); Plot(0); delay(5);
  Plot(10); delay(15); Plot(0); delay(5);
  Plot(11); delay(15); Plot(0); delay(5);
  Plot(12); delay(15); Plot(0); delay(5);
  Plot(13); delay(15); Plot(0); delay(5);
  Plot(14); delay(15); Plot(0); delay(5);
  Plot(15); delay(15); Plot(0); delay(5);

  PLAYER_SCORE += Score;
  RndInit();
 }

 void RndInit(void)
 {
  Active=TRUE;
  Score = 0;
  Type = TYPE_STAR;
  SubType = 0;
  Degrees = random(360);
  Distance = 1;
  Speed = random(2)+1;
 }

 void ObjInit(void)
 {
  Active=TRUE;
  Score = random(50)+50;
  Type = RANDOM_OBJECT;
  SubType = random(3);
  Degrees = random(360);
  Distance = 1;
  Speed = random(2)+1;
 }

 void DeathInit(void)
 {
  Active=TRUE;
  Score = -1 * (random(50)+50);
  Type = DEATH_OBJECT;
  SubType = random(2)+1;
  Degrees = random(360);
  Distance = 1;
  Speed = 1;
 }

 void Plot(int color)
 {
  if (Type == TYPE_STAR) c4_pset(DegreesToX(Degrees, Distance),DegreesToY(Degrees, Distance),color);
  if (Type == RANDOM_OBJECT)
  {
   draw_sprite(color, SubType, Degrees, Distance);
  }
  if (Type == DEATH_OBJECT)
  {
   draw_sprite(color, SubType, Degrees, Distance);
  }
 }
};

void draw_sprite(int color, int SubType, int Degrees, int Distance)
{
 int x;
 int y;
 for (y=0; y<16; y++)
 {
  for (x=0; x<16; x++)
  {
   if (sprites[SubType][y][x] == 1) c4_pset((DegreesToX(Degrees, Distance)-8)+x,(DegreesToY(Degrees, Distance)-8)+y,color);
  }
 }
}

int DegreesToX(int degrees, int distance)
{
 int x = 160;
 int y = 100;

 x+=sin(degrees*(M_PI/180))*distance;
 y-=cos(degrees*(M_PI/180))*distance;

 return x;
}

int DegreesToY(int degrees, int distance)
{
 int x = 160;
 int y = 100;

 x+=sin(degrees*(M_PI/180))*distance;
 y-=cos(degrees*(M_PI/180))*distance;

 return y;
}