// ELIMINATOR
// GAME AND CODE (C) 1999 SHaM TECHNOLOGY
// PROGRAMMED BY BRADLEY SMITH

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include "scr_mode.h"
#include "primit.h"
#include <iostream.h>
#include <time.h>

#include "stars.h"
#include "stars.num"
#include "stars.fnt"

int PLAYER_SCORE = 100;
int HIGH_SCORE = 0;
int EXIT_CALL = 0;
char scorebox[10];
char highchar[10];

union REGS regs;   					// Set up DOS registers
void mouse_func(int axvalue);       // General Purpose Mouse Function
void show_cursor(int state=15);
StarObject StarMatrix[20];          // Create 20 recyclable star objects
StarObject TitleS[180];
int MAX_STARS = 19;                 // There are only 20 stars

int cycles = 0;

int selected;

void title_screen(void)
{
 gcout("SH M TECHNOLOGY", 10, 0, 0, 1);
 gcout("  A            ", 10, 0, 5, 1);

 int x,y;
 for (x=0; x<180; x++)
 {
  for (y=0; y<15; y++)
  {
   c4_pset(70+x,90+y,graph_buf[x][y]);
  }
  delay(25);
 }

 delay(750);
 clear(0,50,319,150,0);

 int i;
 for (i=0; i<180; i++)
 {
  TitleS[i].Active = TRUE;
  TitleS[i].Type = TYPE_STAR;
  TitleS[i].Speed = random(4)+1;
  TitleS[i].Degrees = i*2;
  TitleS[i].Distance = random(20)+1;
 }

 int p;
 for (p=0; p<65; p++)
 {
  for (i=0; i<180; i++)
  {
   if (TitleS[i].Active == TRUE)
   {
	TitleS[i].Move(1);
	TitleS[i].Plot(10);
   }
  }
  delay(50);
  for (i=0; i<180; i++)
  {
   TitleS[i].Plot(0);
  }
 }

 for (i=0; i<180; i++)
 {
  TitleS[i].Active = TRUE;
  TitleS[i].Type = TYPE_STAR;
  TitleS[i].Speed = random(4)+1;
  TitleS[i].Degrees = i*2;
  TitleS[i].Distance = random(20)+150;
 }

 for (p=0; p<50; p++)
 {
  for (i=0; i<180; i++)
  {
   if (TitleS[i].Active == TRUE)
   {
	TitleS[i].Implode();
	TitleS[i].Plot(10);
   }
  }
  delay(50);
  for (i=0; i<180; i++)
  {
   TitleS[i].Plot(0);
  }
 }

 clear(150,90,170,110,0);

 for (i=0; i<35; i++)
 {
  box(160-(i*2),100-i,160+(i*2),100+i,10);
  delay(70);
  box(160-(i*2),100-i,160+(i*2),100+i,0);
 }
 box(160-70,100-35,160+70,100+35,10);

 gcout("ELIMINATOR", 10, 100, 95);
 delay(2000);
 gcout("ELIMINATOR", 0, 100, 95);

 gcout("GET READY", 12, 104, 95);
 delay(1000);
 gcout("GET READY", 0, 104, 95);

 gprintf("3", 14, 157, 97);
 delay(750);
 gprintf("3", 0, 157, 97);
 gprintf("2", 13, 157, 97);
 delay(750);
 gprintf("2", 0, 157, 97);
 gprintf("1", 11, 157, 97);
 delay(750);
 gprintf("1", 0, 157, 97);
}

void main(void)
{
 restart_game:
 set_mode(MODE_3H);
 mouse_func(0);
 delay(500);
 mouse_func(3);
 if (regs.x.bx == 1)
 {
  gotoxy(0,0);
  cprintf("ELIMINATOR WAS WRITTEN AND PROGRAMMED BY BRADLEY SMITH\n\r");
  cprintf("UNDER SHaM TECHNOLOGY. ALL RIGHTS RESERVED.\n\r\n\r");
  cprintf("THIS SCREEN OF INFORMATION HAS BEEN ACCESSED ILLICITLY.\n\r");
  cprintf("WELL DONE.\n\r\n\r");
  cprintf("KERRY CHIKAROVSKI MUST DIE\n\r\n\r");
  cprintf("PRESS ANY KEY TO SEE THE HIDDEN SPRITE...");
  getch();
  set_mode(MODE_13H);

  int hidden[16][16] =
{{0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
 {0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0},
 {0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0},
 {0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0},
 {0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,0},
 {0,1,0,0,0,1,0,1,1,0,1,0,0,0,1,0},
 {1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1},
 {1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1},
 {1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1},
 {1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1},
 {0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
 {0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,0},
 {0,0,1,0,0,0,1,1,1,1,0,0,0,1,0,0},
 {0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0},
 {0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0},
 {0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0}};

  int x, y;

  for (x=0; x<16; x++)
  {
   for (y=0; y<16; y++)
   {
	if (hidden[y][x] == 1) c4_pset(157+x,97+y,10);
   }
  }
  getch();
  EXIT_CALL = 1;
 }

 set_mode(MODE_13H);   				// Set Mode 13h - 320x200x256
 title_screen();					// Jump to the title screen

 set_mode(MODE_13H);   				// Set Mode 13h - 320x200x256
 mouse_func(0);                     // Reset or initialise the mouse driver
 //mouse_func(1);					// Unremark this for a gunky pointer

 int i;
 for (i=0; i<MAX_STARS; i++)        // Randomly initialise the stars
 {
  StarMatrix[i].RndInit();
 }

 while (regs.x.bx != 3)             // As long as both buttons are off...
 {
  cycles++;
  if (cycles == 500) cycles = 0;

  // Initialise new objects
  if ((cycles % 30) == 0)
  {
   selected = random(MAX_STARS)+1;
   StarMatrix[selected].ObjInit();
  }
  if ((cycles % 50) == 0)
  {
   selected = random(MAX_STARS)+1;
   StarMatrix[selected].DeathInit();
  }

  for (i=0; i<MAX_STARS; i++)
  {
   StarMatrix[i].Move();            // Move each star out one step
   if (StarMatrix[i].Type == DEATH_OBJECT)
   {
	StarMatrix[i].Plot(16+(cycles % 10));
   }
   if (StarMatrix[i].Type == RANDOM_OBJECT)
   {
	StarMatrix[i].Plot(15);
   }
   if (StarMatrix[i].Type == TYPE_STAR)
   {
	StarMatrix[i].Plot(15);
   }
  }

  mouse_func(3);                    // Update the new mouse location info
  show_cursor();                    // Show the anti-gunk cursor

  // Time to process user input
  if (regs.x.bx == 1)
  {
   for (i=0; i<MAX_STARS; i++)
   {
	if (StarMatrix[i].Type != TYPE_STAR)
	{
	 if ((regs.x.cx/2) < (DegreesToX(StarMatrix[i].Degrees, StarMatrix[i].Distance)+8))
	 {
	  if ((regs.x.cx/2) > (DegreesToX(StarMatrix[i].Degrees, StarMatrix[i].Distance)-8))
	  {
	   if (regs.x.dx < (DegreesToY(StarMatrix[i].Degrees, StarMatrix[i].Distance)+8))
	   {
		if (regs.x.dx > (DegreesToY(StarMatrix[i].Degrees, StarMatrix[i].Distance)-8))
		{
		 // Providing that the object in question is an object (vs. a star)
		 // and it has been clicked on properly, shoot or kill the object
		 StarMatrix[i].Shoot();
		}
	   }
	  }
	 }
	}
   }
  }

  delay(50);                        // Delay between star cycles

  show_cursor(0);                   // Hide the anti-gunk cursor

  if (PLAYER_SCORE > HIGH_SCORE) HIGH_SCORE = PLAYER_SCORE;

  if (kbhit())
  {
   if (getch() == '') EXIT_CALL = 1;
  }

  if (PLAYER_SCORE <= 0 || EXIT_CALL == 1)
  {
   clear(60,75,270,125,0);
   box(60,75,270,125,10);
   gcout("GAME OVER", 10, 106, 80);
   line(65,85,100,85,10);
   line(219,85,265,85,10);
   gcout("HIGH SCORE", 10, 100, 100);
   sprintf(highchar, "%i", HIGH_SCORE);
   gprintf(highchar, 10, 160-(strlen(highchar)*6-6), 115);

   again:
   mouse_func(3);
   if (regs.x.bx == 1 || kbhit()) break;
   goto again;
  }

  for (i=0; i<MAX_STARS; i++)
  {
   StarMatrix[i].Plot(0);           // Remove old stars
  }

  if (regs.x.bx == 2)
  {
   gcout("CLICK TO RESUME", 15, 70, 95);
   int a = 16;
   mouse_func(3);
   while (regs.x.bx != 1)
   {
	mouse_func(3);
	a++; if (a == 24) a=16;
	gcout("CLICK TO RESUME", a, 70, 95);
	delay(100);
   }
   gcout("CLICK TO RESUME", 0, 70, 95);
  }

  // Show the score
  sprintf(scorebox, "%i", PLAYER_SCORE);
  gprintf(scorebox, 15, 5, 5);
 }

 mouse_func(2);		// If the game is over, disable the mouse

 set_mode(MODE_3H);
}

// mouse_func(int axvalue)
// General purpose mouse call function
//
// The parameter passed to it is what will be sent to
// the ax register of interrupt 33 (mouse)
void mouse_func(int axvalue)
{
 regs.x.ax = axvalue;               // Load parameter into ax
 int86(0x33, &regs, &regs);			// Send instruction to port 33
}

// show_cursor(int state)
// Anti-gunk cursor
//
// The standard mode 13h bios cursor is prone to decay
// from pixels plotted and turned off. This function
// creates a more appropriate cursor without gunk
void show_cursor(int state)
{
 int pointer[9][9] = {
 {0,0,0,0,1,0,0,0,0},
 {0,0,0,0,1,0,0,0,0},
 {0,0,1,0,1,0,1,0,0},
 {0,0,0,1,0,1,0,0,0},
 {1,1,1,0,0,0,1,1,1},
 {0,0,0,1,0,1,0,0,0},
 {0,0,1,0,1,0,1,0,0},
 {0,0,0,0,1,0,0,0,0},
 {0,0,0,0,1,0,0,0,0}};

 int xcoord = regs.x.cx / 2; 		// Mouse X is relavtive to half of cx
 int ycoord = regs.x.dx;			// Mouse Y is relative to dx

 int x; int y;
 for (y=0; y<9; y++)
 {
  for (x=0; x<9; x++)
  {
   if (pointer[x][y] == 1) c4_pset((xcoord-4)+x,(ycoord-4)+y,state);
  }
 }
}