'$INCLUDE: 'ef.bi'

REM $DYNAMIC
SUB BlastCLS (segment%, offset%, col%)
  '
  ' Clear the screen!
  '
  DEF SEG = VARSEG(code6%(0))
  '
  CALL ABSOLUTE(BYVAL segment%, BYVAL offset%, BYVAL col%, VARPTR(code6%(0)))
  '
  DEF SEG
  '
END SUB

SUB BlastCopy (fsegment%, foffset%, tsegment%, toffset%)
  '
  ' No error checking is done for this routine, so be careful when
  ' you set the from and to segements and offsets - you could crash
  ' your machine...
  '
  ' I have noticed on slower machines running QuickBASIC that the following
  ' line slows the code down. Comment this line out if you notice it. For
  ' some reason QBASIC is unaffected. This line is only used to cut down on
  ' screen shearing at the time of the copy, and isn't needed unless you need
  ' the most solid display anyhow...
  '
  WAIT &H3DA, 8              ' Wait for vertical retrace
  '
  ' Copy!
  '
  DEF SEG = VARSEG(code1%(0))
  '
  CALL ABSOLUTE(BYVAL fsegment%, BYVAL foffset%, BYVAL tsegment%, BYVAL toffset%, VARPTR(code1%(0)))
  '
  DEF SEG
  '
END SUB

SUB BlastGet (dsegment%, doffset%, ssegment%, soffset%, x1%, y1%, x2%, y2%)
  '
  ' No error checking is done for X and Y coordinates, nor for any segments
  ' and offsets into memory. Therefore, use care when setting them so you
  ' don't crash your machine.
  '
  DEF SEG = VARSEG(code4%(0))
  '
  CALL ABSOLUTE(BYVAL dsegment%, BYVAL doffset%, BYVAL ssegment%, BYVAL soffset%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, VARPTR(code4%(0)))
  '
  DEF SEG
  '
END SUB

SUB BlastPset (segment%, offset%, xpos%, ypos%, col%)
  '
  ' No error checking is done for X and Y coordinates, nor for any segments
  ' and offsets into memory. Therefore, use care when setting them so you
  ' don't crash your machine.
  '
  ' Plot the pixel!
  '
  DEF SEG = VARSEG(code2%(0))
  '
  CALL ABSOLUTE(BYVAL segment%, BYVAL offset%, BYVAL xpos%, BYVAL ypos%, BYVAL col%, VARPTR(code2%(0)))
  '
  DEF SEG
  '
END SUB

SUB BlastPut (dsegment%, doffset%, ssegment%, soffset%, xpos%, ypos%, icol%)
  '
  ' No error checking is done for X and Y coordinates, nor for any segments
  ' and offsets into memory. Therefore, use care when setting them so you
  ' don't crash your machine.
  '
  DEF SEG = VARSEG(code3%(0))
  '
  CALL ABSOLUTE(BYVAL dsegment%, BYVAL doffset%, BYVAL ssegment%, BYVAL soffset%, BYVAL xpos%, BYVAL ypos%, BYVAL icol%, VARPTR(code3%(0)))
  '
  DEF SEG
  '
END SUB

SUB FadeIn (R%, G%, B%, Frames%)
  FOR Fade% = Frames% TO 0 STEP -1
    OUT &H3C8, 0
    FOR Count% = 0 TO 255
      IF R% < ASC(Pal(Count%, 0)) THEN
        OUT &H3C9, ASC(Pal(Count%, 0)) - (((ASC(Pal(Count%, 0)) - R%) / Frames%) * Fade%)
      ELSEIF R% > ASC(Pal(Count%, 0)) THEN
        OUT &H3C9, ASC(Pal(Count%, 0)) + (((R% - ASC(Pal(Count%, 0))) / Frames%) * Fade%)
      ELSE
        OUT &H3C9, R%
      END IF
      IF G% < ASC(Pal(Count%, 1)) THEN
        OUT &H3C9, ASC(Pal(Count%, 1)) - (((ASC(Pal(Count%, 1)) - G%) / Frames%) * Fade%)
      ELSEIF G% > ASC(Pal(Count%, 1)) THEN
        OUT &H3C9, ASC(Pal(Count%, 1)) + (((G% - ASC(Pal(Count%, 1))) / Frames%) * Fade%)
      ELSE
        OUT &H3C9, G%
      END IF
      IF B% < ASC(Pal(Count%, 2)) THEN
        OUT &H3C9, ASC(Pal(Count%, 2)) - (((ASC(Pal(Count%, 2)) - B%) / Frames%) * Fade%)
      ELSEIF B% > ASC(Pal(Count%, 2)) THEN
        OUT &H3C9, ASC(Pal(Count%, 2)) + (((B% - ASC(Pal(Count%, 2))) / Frames%) * Fade%)
      ELSE
        OUT &H3C9, B%
      END IF
    NEXT
    WAIT 986, 8
    WAIT 986, 8, 8
  NEXT
  FOR Count% = 0 TO 255
    OUT &H3C8, Count%
    OUT &H3C9, ASC(Pal(Count%, 0))
    OUT &H3C9, ASC(Pal(Count%, 1))
    OUT &H3C9, ASC(Pal(Count%, 2))
  NEXT
  WAIT 986, 8
  WAIT 986, 8, 8
END SUB

SUB FadeOut (R%, G%, B%, Frames%)
  FOR Fade% = 0 TO Frames% STEP 1
    OUT &H3C8, 0
    FOR Count% = 0 TO 255
      IF R% < ASC(Pal(Count%, 0)) THEN
        OUT &H3C9, ASC(Pal(Count%, 0)) - (((ASC(Pal(Count%, 0)) - R%) / Frames%) * Fade%)
      ELSEIF R% > ASC(Pal(Count%, 0)) THEN
        OUT &H3C9, ASC(Pal(Count%, 0)) + (((R% - ASC(Pal(Count%, 0))) / Frames%) * Fade%)
      ELSE
        OUT &H3C9, R%
      END IF
      IF G% < ASC(Pal(Count%, 1)) THEN
        OUT &H3C9, ASC(Pal(Count%, 1)) - (((ASC(Pal(Count%, 1)) - G%) / Frames%) * Fade%)
      ELSEIF G% > ASC(Pal(Count%, 1)) THEN
        OUT &H3C9, ASC(Pal(Count%, 1)) + (((G% - ASC(Pal(Count%, 1))) / Frames%) * Fade%)
      ELSE
        OUT &H3C9, G%
      END IF
      IF B% < ASC(Pal(Count%, 2)) THEN
        OUT &H3C9, ASC(Pal(Count%, 2)) - (((ASC(Pal(Count%, 2)) - B%) / Frames%) * Fade%)
      ELSEIF B% > ASC(Pal(Count%, 2)) THEN
        OUT &H3C9, ASC(Pal(Count%, 2)) + (((B% - ASC(Pal(Count%, 2))) / Frames%) * Fade%)
      ELSE
        OUT &H3C9, B%
      END IF
    NEXT
    WAIT 986, 8
    WAIT 986, 8, 8
  NEXT
  FOR Count% = 0 TO 255
    OUT &H3C8, Count%
    OUT &H3C9, R%
    OUT &H3C9, G%
    OUT &H3C9, B%
  NEXT
  WAIT 986, 8
  WAIT 986, 8, 8
END SUB

SUB GetPal
  OUT &H3C7, 0
  FOR Count% = 0 TO 255
    Pal(Count%, 0) = CHR$(INP(&H3C9))
    Pal(Count%, 1) = CHR$(INP(&H3C9))
    Pal(Count%, 2) = CHR$(INP(&H3C9))
  NEXT
END SUB

SUB InitLib
  '
  ' BlastCopy! (BLSTCOPY.ASM)
  '
  code$ = "1E5589E58B460E8ED88B760C8B460A8EC08B7E08B9007DF3A55D1FCA0800"
  '
  DEF SEG = VARSEG(code1%(0))
  '
  FOR I% = 0 TO 29
    d% = VAL("&h" + MID$(code$, I% * 2 + 1, 2))
    POKE VARPTR(code1%(0)) + I%, d%
  NEXT I%
  '
  DEF SEG
  '
  ' BlastPset! (BLSTPSET.ASM)
  '
  code$ = "1E5589E58B46108ED88B760AB106D3E689F3B102D3E601DE8B5E0C01DE8B5E0E01DE8A460888045D1FCA0A00"
  '
  DEF SEG = VARSEG(code2%(0))
  '
  FOR I% = 0 TO 43
    d% = VAL("&h" + MID$(code$, I% * 2 + 1, 2))
    POKE VARPTR(code2%(0)) + I%, d%
  NEXT I%
  '
  DEF SEG
  '
  ' BlastPut! (BLASTPUT.ASM)
  '
  code$ = "1E5589E58B460C508B460A508B46108ED88B760E8B04B103D3E8508B5EFE"
  code$ = code$ + "01C3895EFE8B4402508B5EFC01C3895EFC83C60489760E89E58B46188ED8"
  code$ = code$ + "8B76168A04468976163A461074208B5E1C8EDB8B7612B106D3E689F3B102"
  code$ = code$ + "D3E601DE8B5E1401DE8B5E1A01DE88048B4614408946148B460639461475"
  code$ = code$ + "BE8B46142B46028946148B4612408946128B460439461275A6585858585D"
  code$ = code$ + "1FCA0E00"
  '
  DEF SEG = VARSEG(code3%(0))
  '
  FOR I% = 0 TO 153
    d% = VAL("&h" + MID$(code$, I% * 2 + 1, 2))
    POKE VARPTR(code3%(0)) + I%, d%
  NEXT I%
  '
  DEF SEG
  '
  ' BlastGet! (BLASTGET.ASM)
  '
  code$ = "1E5589E58B460A508B4608508B460A2B460E40508B46082B460C40508B46128ED8"
  code$ = code$ + "8B76108B46FABB0800F7E3890446468B46F88904464689761089E58B5E"
  code$ = code$ + "1E8EDB8B7614B106D3E689F3B102D3E601DE8B5E1601DE8B5E1C01DE8A"
  code$ = code$ + "048B5E1A8EDB8B76188804468976188B4616408946168B460639461676"
  code$ = code$ + "C38B46162B46028946168B4614408946148B460439461476AB58585858"
  code$ = code$ + "5D1FCA1000"
  '
  DEF SEG = VARSEG(code4%(0))
  '
  FOR I% = 0 TO 153
    d% = VAL("&h" + MID$(code$, I% * 2 + 1, 2))
    POKE VARPTR(code4%(0)) + I%, d%
  NEXT I%
  '
  DEF SEG
  '
  ' BlastCLS! (BLASTCLS.ASM)
  '
  code$ = "1E5589E58B460C8ED88B760A8B460888C4B900FA890483C60283E90275F65D1FCA0600"
  '
  DEF SEG = VARSEG(code6%(0))
  '
  FOR I% = 0 TO 34
    d% = VAL("&h" + MID$(code$, I% * 2 + 1, 2))
    POKE VARPTR(code6%(0)) + I%, d%
  NEXT I%
  '
  DEF SEG
  '
END SUB

SUB ToScreen

    BlastCopy VARSEG(Buffer%(0)), VARPTR(Buffer%(0)), &HA000, 0

END SUB

