'       Eternal Frost
'
'       Created by: DarkDread
'

'$INCLUDE: 'ef.bi'

DIM SHARED Wave(0) AS WaveHeaderType
DIM SHARED MixRoutine%(29)

DIM SHARED MEM.SEGMENT(0 TO 255) AS INTEGER
DIM SHARED MEM.ALLOCATED(0 TO 255) AS LONG
DIM SHARED BIT.STORAGE(0 TO 7) AS INTEGER

DIM SHARED Pal(255, 2) AS STRING * 1
DIM SHARED code1%(14), code2%(21), code3%(76), code4%(76), code6%(17)

DIM SHARED ChrSet%(33 TO 95, 1 TO 6, 1 TO 6)

DIM SHARED Item$(1 TO 9)
DIM SHARED Magic$(1 TO 9)
DIM SHARED NextLevel(2 TO 50) AS LONG

DIM SHARED Story%(5)

DIM SHARED Maze(1 TO 50, 1 TO 50) AS INTEGER
DIM SHARED Image%(31999), Buffer%(31999)

DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN
    CLS
    PRINT "The SBMIDI driver is not loaded, or did not load correctly.  Please run the game"
    PRINT "using the START.BAT file."
    PRINT
    PRINT "Press any key to exit..."
    WHILE INKEY$ = "": WEND
    NoDriver% = True
END IF
IF NoDriver% THEN SYSTEM
IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
DetectSettings SB.BASEPORT, SB.IRQ, SB.LODMA, SB.HIDMA, SB.CARDTYPE, SB.MPU401
IF SB.CARDTYPE = 0 THEN SetCard 2
IF SB.BASEPORT = 0 THEN SB.BASEPORT = &H220
IF SB.IRQ = 0 THEN SB.IRQ = 5
IF SB.LODMA = 0 THEN SB.LODMA = 1
IF SB.HIDMA = 0 AND SB.CARDTYPE = 6 THEN SB.HIDMA = 5

CLS

PRINT "Loading fonts..."
CALL LoadFont
PRINT "Loading data..."
CALL LevelUpData
PRINT "Initializing Blast! routines..."
CALL InitLib
PRINT "Initializing DSP..."
InitMixer8bit
InitConvert2FAST
Baseport% = &H220: IRQ% = 5: DMA% = 1
GetBLASTER
SpeakerState 1
MasterVolume 12, 12, 0
MasterVolume Right%, Left%, 1
DIM SHARED WavBuffer(0 TO 1) AS STRING * blocklen

PRINT "Free string memory: "; FRE("")
PRINT "Free array memory: "; FRE(-1)
PRINT "Press any key to begin..."
WHILE INKEY$ = "": WEND

SCREEN 13

CALL GetPal
CALL IntroCredits
CALL CutScene1B

CLS

Moved = True

Zen = 50
RavynHp = 24
RavynMaxHP = 24
RavynMp = 8
RavynMaxMP = 8
RavynST = 7
RavynAG = 5
RavynDF = 8
RavynMS = 5
RavynMD = 1
RavynLvl = 1

RavynWeapon$ = "[Short"
RavynArmor$ = "\Leather"
RavynStatus$ = "Healthy"
          
CALL ReadData("Arren")
Level$ = "Arren"
MIDIHandle% = LoadMIDI("arren.mid")
PlayMIDI MIDIHandle%
CALL ShowScreen
CALL ToScreen

DO
    IF Quit% THEN EXIT DO
    Moved = False
   
    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(72)
        MoveUp
        EnemyGo = True
    CASE CHR$(0) + CHR$(80)
        MoveDown
        EnemyGo = True
    CASE CHR$(0) + CHR$(75)
        MoveLeft
        EnemyGo = False
    CASE CHR$(0) + CHR$(77)
        MoveRight
        EnemyGo = False
    CASE CHR$(13)
        Inventory
    CASE "c", "C"
        GetScreen
    CASE CHR$(27)
        Quit% = True
    END SELECT
 
    IF Moved THEN
        CALL DrawLocation
        CALL ToScreen
        IF Level$ = "GloomStone" THEN
            Fight = INT(RND * 10) + 1
            IF Fight = 5 AND EnemyGo THEN
                StopMIDI
                UnloadMIDI MIDIHandle%
                MIDIHandle% = LoadMIDI("fight.mid")
                PlayMIDI MIDIHandle%
                CALL EnemyFight
                StopMIDI
                UnloadMIDI MIDIHandle%
                MIDIHandle% = LoadMIDI("gloomsto.mid")
                PlayMIDI MIDIHandle%
            END IF
        END IF
    END IF

    IF Maze(x, y) = 1 AND Level$ = "Arren" THEN
            WeaponShop
        ELSEIF Maze(x, y) = 2 AND Level$ = "Arren" THEN
            Inn
        ELSEIF Maze(x, y) = 3 AND Level$ = "Arren" THEN
            ItemShop
        ELSEIF Maze(x, y) = 4 AND Level$ = "Arren" THEN
            CALL Baron
            y = y - 2
            CALL ShowScreen
            CALL ToScreen
        ELSEIF Maze(x, y) = 5 AND Level$ = "Arren" THEN
            CALL Gate
            IF Level$ = "Arren" THEN
                    y = y + 1
                ELSEIF Level$ = "GloomStone" THEN
                    StopMIDI
                    UnloadMIDI MIDIHandle%
                    MIDIHandle% = LoadMIDI("gloomsto.mid")
                    PlayMIDI MIDIHandle%
            END IF
            CALL ShowScreen
            CALL ToScreen
        ELSEIF Maze(x, y) = 5 AND Level$ = "GloomStone" THEN
            IF Level$ = "GloomStone" THEN
                    y = y - 1
                ELSEIF Level$ = "Arren" THEN
                    StopMIDI
                    UnloadMIDI MIDIHandle%
                    MIDIHandle% = LoadMIDI("arren.mid")
                    PlayMIDI MIDIHandle%
            END IF
            CALL ShowScreen
            CALL ToScreen
    END IF
    LoopMIDI

LOOP

IF NOT MusicDone% THEN StopMIDI
UnloadMIDI MIDIHandle%
CleanUpMIDI

SCREEN 0: WIDTH 80
PRINT "Game aborted..."
SYSTEM

REM $DYNAMIC
SUB CreateBackGround

    IF NOT InShop THEN
        CALL PutSprite(191, 11, 2)
        PutText "Ravyn", 245, 12
        PutText "HP", 245, 24
        PutNumber RavynHp, 290, 24, 3
        PutText "MP", 245, 30
        PutNumber RavynMp, 290, 30, 3
        PutText RavynWeapon$, 245, 42
        PutText RavynArmor$, 245, 48
        PutText RavynStatus$, 245, 60
    END IF
    PutText "Zen", 192, 121
    PutNumber Zen, 272, 121, 6

END SUB

SUB GetScreen

    DEF SEG = &HA000
    BSAVE "screen.fsi", 0, 64000

END SUB

SUB InvBack

    DEF SEG = VARSEG(Buffer%(0))
    BLOAD "back2.fsi", VARPTR(Buffer%(0))

END SUB

SUB Inventory

    CALL ShowInventory
    CALL ToScreen

    DO
        IF Chosen THEN
            CALL ShowInventory
            CALL ToScreen
            Chosen = False
        END IF

        SELECT CASE INKEY$
        CASE IS = "1"
            CALL ShowStatus
            Chosen = True
        CASE IS = "2"
            CALL UseEquip
            Chosen = True
        CASE IS = "3"
            CALL UseMagic
            Chosen = True
        CASE IS = "4"
            QuitInventory = True
        CASE IS = "5"
            QuitInventory = True
            Quit% = True
        END SELECT
    LOOP UNTIL QuitInventory

    CALL ShowScreen
    CALL ToScreen

END SUB

SUB LoadFont

    OPEN "ef.bmf" FOR INPUT AS #1

    FOR I = 1 TO 6
        IF I = 1 THEN
                FontNum = 33
            ELSEIF I = 2 THEN
                FontNum = 36
            ELSEIF I = 3 THEN
                FontNum = 39
            ELSEIF I = 4 THEN
                FontNum = 44
            ELSEIF I = 5 THEN
                FontNum = 45
            ELSEIF I = 6 THEN
                FontNum = 46
        END IF
        FOR FontY = 1 TO 6
            FOR FontX = 1 TO 6
                INPUT #1, ChrSet%(FontNum, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR I = 48 TO 59
        FOR FontY = 1 TO 6
            FOR FontX = 1 TO 6
                INPUT #1, ChrSet%(I, FontX, FontY)
            NEXT FontX
        NEXT FontY
    NEXT I
    FOR FontY = 1 TO 6
        FOR FontX = 1 TO 6
            INPUT #1, ChrSet%(63, FontX, FontY)
        NEXT FontX
    NEXT FontY
    FOR I = 65 TO 95
        FOR FontY = 1 TO 6
            FOR FontX = 1 TO 6
                INPUT #1, ChrSet%(I, FontX, FontY)
            NEXT FontX
         NEXT FontY
    NEXT I

    CLOSE #1

END SUB

SUB LoadMaze


END SUB

REM $STATIC
DEFSNG A-Z
SUB PutLong (Value&, PosX%, PosY%, Digits%)

    Sentence$ = RIGHT$(STR$(Value&), LEN(STR$(Value&)) - 1)
    IF Digits% - LEN(Sentence$) > 0 THEN
        Sentence$ = SPACE$(Digits% - LEN(Sentence$)) + Sentence$
    END IF

    FOR Csr = 1 TO LEN(Sentence$)

        CN = ASC(MID$(UCASE$(Sentence$), Csr, 1))
        IF CN = 33 OR CN = 36 OR CN = 39 OR CN > 43 AND CN < 47 OR CN > 47 AND CN < 60 OR CN = 63 OR CN > 64 AND CN < 96 THEN
            FOR FontY = 1 TO 6
                FOR FontX = 1 TO 6
                  IF ChrSet%(CN, FontX, FontY) <> 0 THEN BlastPset VARSEG(Buffer%(0)), VARPTR(Buffer%(0)), PosX% + (FontX - 1), PosY% + (FontY - 1), ChrSet%(CN, FontX, FontY)
                NEXT FontX
            NEXT FontY
        END IF

        PosX% = PosX% + 6
        IF PosX% >= 320 THEN
            PosX% = 0
            PosY% = PosY% + 6
        END IF

   NEXT Csr

END SUB

REM $DYNAMIC
DEFINT A-Z
SUB PutNumber (Value%, PosX%, PosY%, Digits%)

    Sentence$ = RIGHT$(STR$(Value%), LEN(STR$(Value%)) - 1)
    IF Digits% - LEN(Sentence$) > 0 THEN
        Sentence$ = SPACE$(Digits% - LEN(Sentence$)) + Sentence$
    END IF
    FOR Csr = 1 TO LEN(Sentence$)

        CN = ASC(MID$(UCASE$(Sentence$), Csr, 1))
        IF CN = 33 OR CN = 36 OR CN = 39 OR CN > 43 AND CN < 47 OR CN > 47 AND CN < 60 OR CN = 63 OR CN > 64 AND CN < 96 THEN
            FOR FontY = 1 TO 6
                FOR FontX = 1 TO 6
                  IF ChrSet%(CN, FontX, FontY) <> 0 THEN BlastPset VARSEG(Buffer%(0)), VARPTR(Buffer%(0)), PosX% + (FontX - 1), PosY% + (FontY - 1), ChrSet%(CN, FontX, FontY)
                NEXT FontX
            NEXT FontY
        END IF

        PosX% = PosX% + 6
        IF PosX% >= 320 THEN
            PosX% = 0
            PosY% = PosY% + 6
        END IF

   NEXT Csr

END SUB

SUB PutSprite (SprX%, SprY%, SprNum%)
   
    IF SprNum% = 0 THEN
        ELSEIF SprNum% = 2 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "RAVYN.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 3 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "SHOP_W.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 4 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "INN.BGF", VARPTR(Image%(0))
        ' Arren
        ELSEIF SprNum% = 5 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1BACK_N.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 6 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 7 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 8 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 9 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 10 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 11 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 12 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WLT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 13 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WLT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 14 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WLT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 15 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WRT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 16 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WRT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 17 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WRT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 18 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LDT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 19 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LDT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 20 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LDT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 21 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RDT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 22 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RDT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 23 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RDT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 24 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LW1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 25 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LW2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 26 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LW3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 27 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RW1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 28 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RW2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 29 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RW3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 30 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LW1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 31 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LWI2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 32 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LWI3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 33 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RW1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 34 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RWI2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 35 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RWI3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 36 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LD1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 37 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LD2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 38 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1LD3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 39 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RD1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 40 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RD2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 41 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1RD3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 42 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WA1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 43 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WA2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 44 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WA3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 45 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1DA1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 46 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1DA2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 47 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1DA3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 48 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WA1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 49 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WIA2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 50 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1WIA3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 51 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1BACK_E.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 52 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1BACK_S.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 53 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "1BACK_W.BGF", VARPTR(Image%(0))
        ' Gloomstone
        ELSEIF SprNum% = 60 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2BACK.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 61 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 62 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 63 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 64 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 65 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 66 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 67 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 68 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 69 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 70 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 71 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 72 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 73 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LDT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 74 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LDT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 75 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LDT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 76 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RDT1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 77 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RDT2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 78 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RDT3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 79 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LW1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 80 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LW2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 81 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LW3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 82 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RW1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 83 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RW2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 84 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RW3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 85 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LL1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 86 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LL2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 87 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LL3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 88 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RL1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 89 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RL2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 90 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RL3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 91 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LD1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 92 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LD2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 93 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LD3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 94 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RD1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 95 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RD2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 96 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2RD3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 97 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2WA1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 98 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2WA2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 99 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2WA3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 100 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2DA1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 101 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2DA2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 102 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2DA3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 103 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LA1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 104 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LA2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 105 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "2LA3.BGF", VARPTR(Image%(0))
        ' Other stuff
        ELSEIF SprNum% = 54 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "D_BOX.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 55 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ITEM.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 56 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "BARON.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 57 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "GATE.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 1000 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ZOMBIE1.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 1001 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ZOMBIE2.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 1002 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ZOMBIE3.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 1003 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ZOMBIE4.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 1004 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ZOMBIE5.BGF", VARPTR(Image%(0))
        ELSEIF SprNum% = 1005 THEN
            DEF SEG = VARSEG(Image%(0)): BLOAD "ZOMBIE6.BGF", VARPTR(Image%(0))
    END IF

    BlastPut VARSEG(Buffer%(0)), VARPTR(Buffer%(0)), VARSEG(Image%(0)), VARPTR(Image%(0)), SprX%, SprY%, 0

END SUB

SUB PutText (Sentence$, PosX%, PosY%)

    FOR Csr = 1 TO LEN(Sentence$)

        CN = ASC(MID$(UCASE$(Sentence$), Csr, 1))
        IF CN = 33 OR CN = 36 OR CN = 39 OR CN > 43 AND CN < 47 OR CN > 47 AND CN < 60 OR CN = 63 OR CN > 64 AND CN < 96 THEN
            FOR FontY = 1 TO 6
                FOR FontX = 1 TO 6
                  IF ChrSet%(CN, FontX, FontY) <> 0 THEN BlastPset VARSEG(Buffer%(0)), VARPTR(Buffer%(0)), PosX% + (FontX - 1), PosY% + (FontY - 1), ChrSet%(CN, FontX, FontY)
                NEXT FontX
            NEXT FontY
        END IF

        PosX% = PosX% + 6
        IF PosX% >= 320 THEN
            PosX% = 0
            PosY% = PosY% + 6
        END IF

   NEXT Csr

END SUB

SUB ShowBackGround

    DEF SEG = VARSEG(Buffer%(0))
    BLOAD "back1.fsi", VARPTR(Buffer%(0))

END SUB

SUB ShowInventory

    CALL InvBack

    PutText "1 Status", 12, 12
    PutText "2 Items", 12, 18
    PutText "3 Magic", 12, 24
    PutText "4 Return", 12, 30
    PutText "5 Quit", 12, 36

END SUB

SUB ShowItems (NumItems)

    LINE (191, 11)-(308, 127), 0, BF
    FOR ItemY = 1 TO NumItems
        YItemPos = 6 * (ItemY + 1)
        XItemPos = 196
        PutNumber ItemY, XItemPos, YItemPos, 1
        PutText WItem$(ItemY), XItemPos + 12, YItemPos
        PutNumber WZen(ItemY), 270, YItemPos, 6
    NEXT ItemY

END SUB

SUB ShowItems1

    LINE (191, 11)-(308, 127), 0, BF
    FOR ItemY = 1 TO 9
        YItemPos = 6 * (ItemY + 1)
        XItemPos = 196
        PutNumber ItemY, XItemPos, YItemPos, 1
        PutText Item$(ItemY), XItemPos + 12, YItemPos
    NEXT ItemY

END SUB

SUB ShowItems2

    LINE (91, 11)-(308, 132), 0, BF
    ItemNumber = 0
    FOR YItem = 12 TO 112 STEP 12
        ItemNumber = ItemNumber + 1
        PutNumber ItemNumber, 96, YItem, 1
        PutText Item$(ItemNumber), 108, YItem
    NEXT YItem

END SUB

SUB ShowScreen

    BlastCLS VARSEG(Buffer%(0)), VARPTR(Buffer%(0)), 0
    CALL ShowBackGround
    CALL CreateBackGround
    IF NOT InShop THEN CALL DrawLocation

END SUB

SUB ShowStatus

    CALL PutSprite(91, 11, 2)

    PutText "Ravyn", 144, 12
    PutText RavynWeapon$, 144, 30
    PutText RavynArmor$, 144, 36
    PutText RavynStatus$, 144, 48

    PutText "HP", 96, 66
    PutNumber RavynMaxHP, 288, 66, 3
    PutNumber RavynHp, 264, 66, 3
    PutText "MP", 96, 72
    PutNumber RavynMaxMP, 288, 72, 3
    PutNumber RavynMp, 264, 72, 3

    PutText "ST", 96, 78
    PutNumber RavynST, 288, 78, 3
    PutText "AG", 96, 84
    PutNumber RavynAG, 288, 84, 3
    PutText "DF", 96, 90
    PutNumber RavynDF, 288, 90, 3
    PutText "MS", 96, 96
    PutNumber RavynMS, 288, 96, 3
    PutText "MD", 96, 102
    PutNumber RavynMD, 288, 102, 3

    PutText "Level", 96, 114
    PutNumber RavynLvl, 288, 114, 3
    PutText "Experience", 96, 120
    PutLong RavynExp, 270, 120, 6
    PutText "Next Level", 96, 126
    PutLong NextLevel(RavynLvl + 1) - RavynExp, 270, 126, 6

    CALL ToScreen
    WHILE INKEY$ = "": WEND

END SUB

SUB UnEquipArmor (ItemNum)

    IF RavynArmor$ = "\Leather" THEN
            RavynDF = RavynDF - 6
            RavynArmor$ = ""
            Item$(ItemNum) = "\Leather"
        ELSEIF RavynArmor$ = "\Chain" THEN
            RavynDF = RavynDF - 10
            RavynArmor$ = ""
            Item$(ItemNum) = "\Chain"
        ELSEIF RavynArmor$ = "\Steel" THEN
            RavynDF = RavynDF - 12
            RavynMD = RavynMD - 2
            RavynArmor$ = ""
            Item$(ItemNum) = "\Steel"
    END IF

END SUB

SUB UnEquipWeapon (ItemNum)

    IF RavynWeapon$ = "[Short" THEN
            RavynST = RavynST - 5
            RavynWeapon$ = ""
            Item$(ItemNum) = "[Short"
        ELSEIF RavynWeapon$ = "[Breaker" THEN
            RavynST = RavynST - 10
            RavynWeapon$ = ""
            Item$(ItemNum) = "[Breaker"
        ELSEIF RavynWeapon$ = "[Long" THEN
            RavynST = RavynST - 14
            RavynWeapon$ = ""
            Item$(ItemNum) = "[Long"
    END IF

END SUB

SUB UseEquip STATIC

    DO
        
        CALL ShowInventory
        PutText "Select and item to use: (0 - 9)", 96, 144

        NotChosen = False: Chosen = False
        CALL ShowItems2
        CALL ToScreen

        DO
            Choice = VAL(INPUT$(1))
            IF Choice > 0 AND Choice < 10 THEN Chosen = True ELSE NotChosen = True
        LOOP UNTIL Chosen OR NotChosen

        CALL ShowInventory
        CALL ShowItems2
        IF Chosen AND NOT NotChosen THEN
        IF Item$(Choice) = "Vial" THEN
                PutText "Restores 25 HP.  Use? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    Item$(Choice) = ""
                    RavynHp = RavynHp + 25
                    IF RavynHp > RavynMaxHP THEN RavynHp = RavynMaxHP
                    CALL ShowInventory
                    PutText "Ravyn recovers 25 HP.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "Full Vial" THEN
                PutText "Restores 100 HP.  Use? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    Item$(Choice) = ""
                    RavynHp = RavynHp + 100
                    IF RavynHp > RavynMaxHP THEN RavynHp = RavynMaxHP
                    CALL ShowInventory
                    PutText "Ravyn recovers 100 HP.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "Herb" THEN
                PutText "Cures poison.  Use? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    IF RavynStatus$ = "Poisoned" THEN
                            Item$(Choice) = ""
                            RavynStatus$ = "Healthy"
                            PutText "Ravyn's poison is neutralized.", 96, 144
                            CALL ShowItems2
                            CALL ToScreen
                            WHILE INKEY$ = "": WEND
                        ELSE
                            PutText "Ravyn is not poisoned.", 96, 144
                            CALL ToScreen
                            WHILE INKEY$ = "": WEND
                    END IF
                END IF
            ELSEIF Item$(Choice) = "[Short" THEN
                PutText "[Short, +5 ST.  Equip? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    UnEquipWeapon (Choice)
                    RavynWeapon$ = "[Short"
                    RavynST = RavynST + 5
                    PutText "Ravyn equips [Short.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "[Breaker" THEN
                PutText "[Breaker, +10 ST.  Equip? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    UnEquipWeapon (Choice)
                    RavynWeapon$ = "[Breaker"
                    RavynST = RavynST + 10
                    PutText "Ravyn equips [Breaker.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "[Long" THEN
                PutText "[Long, +14 ST.  Equip? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    UnEquipWeapon (Choice)
                    RavynWeapon$ = "[Long"
                    RavynST = RavynST + 14
                    PutText "Ravyn equips [Long.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "\Leather" THEN
                PutText "\Leather, +6 DF.  Equip? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    UnEquipArmor (Choice)
                    RavynArmor$ = "\Leather"
                    RavynDF = RavynDF + 6
                    PutText "Ravyn equips \Leather.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "\Chain" THEN
                PutText "\Chain, +10 DF.  Equip? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    UnEquipArmor (Choice)
                    RavynArmor$ = "\Chain"
                    RavynDF = RavynDF + 10
                    PutText "Ravyn equips \Chain.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
            ELSEIF Item$(Choice) = "\Steel" THEN
                PutText "\Steel, +12 DF +1 MD.  Equip? (y/n)", 96, 144
                CALL ToScreen
                UseItem$ = LCASE$(INPUT$(1))
                IF UseItem$ = "y" THEN
                    CALL ShowInventory
                    UnEquipArmor (Choice)
                    RavynArmor$ = "\Steel"
                    RavynDF = RavynDF + 12
                    RavynMD = RavynMD + 1
                    PutText "Ravyn equips \Steel.", 96, 144
                    CALL ShowItems2
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                END IF
        END IF
        END IF
    LOOP UNTIL NotChosen

END SUB

SUB UseMagic

    DO
        CALL ShowInventory
        ItemNumber = 0
        FOR YItem = 12 TO 112 STEP 12
            ItemNumber = ItemNumber + 1
            PutNumber ItemNumber, 96, YItem, 1
            PutText Magic$(ItemNumber), 108, YItem
        NEXT YItem
        PutText "Select the magic to use: (0 - 9)", 96, 144

        NotChosen = False: Chosen = False
        CALL ToScreen
        DO
            Choice = VAL(INPUT$(1))
            IF Choice > 0 AND Choice < 10 THEN Chosen = True ELSE NotChosen = True
        LOOP UNTIL Chosen OR NotChosen

        CALL ShowInventory
        ItemNumber = 0
        FOR YItem = 12 TO 112 STEP 12
            ItemNumber = ItemNumber + 1
            PutNumber ItemNumber, 96, YItem, 1
            PutText Magic$(ItemNumber), 108, YItem
        NEXT YItem

        IF Chosen AND NOT NotChosen THEN
            IF Magic$(Choice) = "Poison Touch" THEN
                    PutText "This is battle only magic.", 96, 144
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                ELSEIF Magic$(Choice) = "Weak Fire" THEN
                    PutText "This is battle only magic.", 96, 144
                    CALL ToScreen
                    WHILE INKEY$ = "": WEND
                ELSEIF Magic$(Choice) = "Weak Cure" THEN
                    PutText "4 MP to cast.  Use Weak Cure? (y/n)", 96, 144
                    CALL ToScreen
                    UseSpell$ = LCASE$(INPUT$(1))
                    IF UseSpell$ = "y" THEN
                        IF RavynMp > 3 THEN
                                RavynHp = RavynHp + (RavynMS * 2)
                                IF RavynHp > RavynMaxHP THEN RavynHp = RavynMaxHP
                                RavynMp = RavynMp - 4
                                Txt$ = "Ravyn casts Weak Cure.  Cure" + STR$(RavynMS * 2) + " HP."
                                PutText Txt$, 96, 144
                                CALL ToScreen
                                WHILE INKEY$ = "": WEND
                            ELSE
                                PutText "Not enough MP to cast Weak Cure.", 96, 144
                                CALL ToScreen
                                WHILE INKEY$ = "": WEND
                        END IF
                    END IF
            END IF
        END IF

    LOOP UNTIL NotChosen

END SUB

