'$DYNAMIC
DEFINT A-Z

TYPE Registers
         AX    AS INTEGER
         BX    AS INTEGER
         CX    AS INTEGER
         DX    AS INTEGER
         BP    AS INTEGER
         SI    AS INTEGER
         DI    AS INTEGER
         FLAGS AS INTEGER
         DS    AS INTEGER
         ES    AS INTEGER
END TYPE

TYPE WaveInfoType
        StereoWav AS INTEGER
        Freq AS LONG
        Length AS LONG
        playtime AS DOUBLE
        sixteenbit AS INTEGER
END TYPE
TYPE WaveHeaderType
                RiffID           AS STRING * 4 'should be 'RIFF'
                RiffLength       AS LONG
                'rept. chunk id and size then chunk data
                WavID            AS STRING * 4 'should be 'WAVE'
                FmtID            AS STRING * 4
                FmtLength        AS LONG
        'FMT ' chunk - common fields
                wavformattag     AS INTEGER ' word - format category e.g. 0x0001=PCM
                Channels         AS INTEGER ' word - number of Channels 1=mono 2=stereo
                SamplesPerSec    AS LONG    'dword - sampling rate e.g. 44100Hz
                avgBytesPerSec   AS LONG    'dword - to estimate buffer size
                blockalign       AS INTEGER ' word - buffer size must be int. multiple of this
                FmtSpecific      AS INTEGER ' word
                DataID           AS STRING * 4
                DataLength       AS LONG
END TYPE

DECLARE SUB InitMixer8bit ()
DECLARE SUB Convert2FAST (Bseg%, Boff&, L%)
DECLARE SUB InitConvert2FAST ()
DECLARE SUB PlayWave (Filename$)
DECLARE SUB ConvertStereo (Freq&, Bseg%, Boff%, L%)
DECLARE SUB Convert1 (Bseg%, Boff%, L%)
DECLARE SUB Convert2 (Bseg%, Boff&, L%)
DECLARE SUB Convert4 (Bseg%, Boff%, L%)
DECLARE SUB Convert5 (Bseg%, Boff%, L%)
DECLARE SUB Convert6 (Bseg%, Boff&, L%)
DECLARE SUB Convert7 (Bseg%, Boff&, L%)
DECLARE SUB Mix2Buffers (Bseg%, Boff&, Bseg2%, Boff2&, L%, sixteenbit%)
DECLARE SUB Play2Waves (File1$, File2$)
DECLARE SUB getWaveInfo ()
DECLARE FUNCTION DEC2HEX$ (longnum&)
DECLARE FUNCTION int2ULong& (signedint%)
DECLARE FUNCTION Ulong2int% (Ulong&)
DECLARE FUNCTION SpeakerStatus% ()
DECLARE FUNCTION DMAStatus% ()
DECLARE FUNCTION DMADone% (DMA16%, L&)
DECLARE FUNCTION ResetDSP% ()
DECLARE FUNCTION ReadDSP% ()
DECLARE FUNCTION ReadDAC% ()
DECLARE SUB FMVolume (Right%, Left%, Getvol%)
DECLARE SUB VocVolume (Right%, Left%, Getvol%)
DECLARE SUB MasterVolume (Right%, Left%, Getvol%)
DECLARE SUB MicVolume (Gain%, Getvol%)
DECLARE SUB LineVolume (Right%, Left%, Getvol%)
DECLARE SUB CDVolume (Right%, Left%, Getvol%)
DECLARE SUB InputSource (InputSrc%, GetSrc%)
DECLARE SUB WriteDSP (byte%)
DECLARE SUB SetStereo (OnOff%)
DECLARE SUB WriteDAC (byte%)
DECLARE SUB SpeakerState (OnOff%)
DECLARE SUB DMAState (StopGo%)
DECLARE SUB DMAPlay (Segment&, offset&, Length&, Freq&, StereoWav%)
DECLARE SUB DMAPlay16 (Segment&, offset&, L&, Freq&, StereoWav%, sixteenbit%)
DECLARE SUB DMARecord (Segment&, offset&, Length&, Freq&)
DECLARE SUB GetBLASTER ()
DECLARE FUNCTION DSPVersion! ()

DECLARE SUB Delay (Repetitions%)
DECLARE SUB DetectSettings (Baseport%, IRQ%, LoDMA%, HiDMA%, CardType%, MPU401%)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB GetBass (LeftChannel%, RightChannel%)
DECLARE SUB GetTreble (LeftChannel%, RightChannel%)
DECLARE SUB GetMaster (LeftChannel%, RightChannel%)
DECLARE SUB GetMIDI (LeftChannel%, RightChannel%)
DECLARE SUB GetVoice (LeftChannel%, RightChannel%)
DECLARE FUNCTION GetSynth% ()
DECLARE FUNCTION LoadMIDI% (Filename$)
DECLARE SUB LoopMIDI ()
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MixerChip$ ()
DECLARE FUNCTION MusicDone% ()
DECLARE SUB PauseMIDI ()
DECLARE SUB ResumeMIDI ()
DECLARE SUB PlayMIDI (Handle%)
DECLARE SUB SetBass (LeftChannel%, RightChannel%)
DECLARE SUB SetTreble (LeftChannel%, RightChannel%)
DECLARE SUB SetMaster (LeftChannel%, RightChannel%)
DECLARE SUB SetMIDI (LeftChannel%, RightChannel%)
DECLARE SUB SetVoice (LeftChannel%, RightChannel%)
DECLARE SUB SetCard (CardType%)
DECLARE FUNCTION SoundCard$ (CardType%)
DECLARE SUB StopMIDI ()
DECLARE FUNCTION TimeMIDI! ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE SUB InternalBitSet (Variable%, BitNum%, OnOff%)
DECLARE SUB InternalBitToggle (Variable%, BitNum%)
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, offset&)
DECLARE SUB InternalSetIntVector (IntNum%, Segment&, offset&)
DECLARE SUB InternalGetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalWriteMixer (Index%, Value%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB UnloadMIDI (Handle%)
DECLARE SUB CleanUpMIDI ()
DECLARE FUNCTION MemUsed& (Handle%)

DECLARE SUB PutSprite (SprX%, SprY%, SprNum%)

DECLARE SUB FadeIn (R%, G%, B%, Frames%)
DECLARE SUB FadeOut (R%, G%, B%, Frames%)
DECLARE SUB GetPal ()

DECLARE SUB InitLib ()
DECLARE SUB BlastCopy (fsegment%, foffset%, tsegment%, toffset%)
DECLARE SUB BlastPut (dsegment%, doffset%, ssegment%, soffset%, xpos%, ypos%, icol%)
DECLARE SUB BlastPset (Segment%, offset%, xpos%, ypos%, col%)
DECLARE SUB BlastCLS (Segment%, offset%, col%)

DECLARE SUB LevelUpData ()
DECLARE SUB EnemyAppears ()
DECLARE SUB CutScene1B ()
DECLARE SUB IntroCredits ()
DECLARE SUB Baron ()
DECLARE SUB ItemShop ()
DECLARE SUB ShowEnemyAttack ()
DECLARE SUB LoadMaze ()
DECLARE SUB InvBack ()
DECLARE SUB ShowScreen ()
DECLARE SUB ShowEnemy ()
DECLARE SUB ToScreen ()
DECLARE SUB Inn ()
DECLARE SUB ShowItems2 ()
DECLARE SUB ShowBackGround ()
DECLARE SUB EnemyFight ()
DECLARE SUB RavynHit ()
DECLARE SUB CalcAgil ()
DECLARE SUB RavynMiss ()
DECLARE SUB EnemyHit ()
DECLARE SUB EnemyMiss ()
DECLARE SUB ShowItems1 ()
DECLARE SUB ShowItems (NumItems%)
DECLARE SUB UseMagic ()
DECLARE SUB UnEquipWeapon (ItemNum%)
DECLARE SUB UnEquipArmor (ItemNum%)
DECLARE SUB UseEquip ()
DECLARE SUB PutNumber (Value%, PosX%, PosY%, Digits%)
DECLARE SUB PutLong (Value&, PosX%, PosY%, Digits%)
DECLARE SUB ShowStatus ()
DECLARE SUB ShowInventory ()
DECLARE SUB Inventory ()
DECLARE SUB PutText (Sentence$, PosX%, PosY%)
DECLARE SUB WeaponShop ()
DECLARE SUB LoadFont ()
DECLARE SUB GetScreen ()
DECLARE SUB CreateBackGround ()
DECLARE SUB ReadData (Filename$)
DECLARE SUB LoadGraphics ()
DECLARE SUB PrintMessage ()
DECLARE SUB SetupScreen ()
DECLARE SUB DrawLocation ()
DECLARE SUB MoveDown ()
DECLARE SUB MoveLeft ()
DECLARE SUB MoveRight ()
DECLARE SUB MoveUp ()
DECLARE SUB PutSprite (SprX%, SprY%, SprNum%)
DECLARE SUB ShowScreen ()
DECLARE SUB ToScreen ()
DECLARE SUB PutText (Sentence$, PosX%, PosY%)
DECLARE SUB FadeIn (R%, G%, B%, Frames%)
DECLARE SUB FadeOut (R%, G%, B%, Frames%)
DECLARE SUB Refresh1B ()
DECLARE SUB Gate ()

DECLARE SUB BlastPut (dsegment%, doffset%, ssegment%, soffset%, xpos%, ypos%, icol%)
DECLARE SUB BlastCopy (fsegment%, foffset%, tsegment%, toffset%)
DECLARE SUB BlastCLS (Segment%, offset%, col%)
DECLARE SUB InitLib ()
DECLARE SUB CutScene1B ()

CONST True = -1, False = 0

CONST Solids = 50
CONST MaxX = 15, MaxY = 15

CONST PathNum = 0
CONST WallNum = 50
CONST WindowNum = 51
CONST DoorNum = 52

CONST blocklen = 32760
CONST HeaderSize = 45

COMMON SHARED code1%(), code2%(), code3%(), code4%(), code6%()
COMMON SHARED Image%(), Buffer%(), Story%()
COMMON SHARED ChrSet%(), Quit%, Pal() AS STRING * 1

COMMON SHARED QMIDIRegs AS Registers, MEM.SEGMENT()   AS INTEGER
COMMON SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER, PAUSED AS SINGLE
COMMON SHARED SBMIDI.INTERRUPT AS INTEGER, MEM.ALLOCATED()   AS LONG
COMMON SHARED SBSIM.INTERRUPT AS INTEGER, MIXER.CHIP AS INTEGER
COMMON SHARED SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
COMMON SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
COMMON SHARED SB.MPU401 AS INTEGER, BIT.STORAGE()   AS INTEGER
COMMON SHARED SENSITIVE AS INTEGER, REVERSE.STEREO AS INTEGER
COMMON SHARED SOUND.DISABLED AS INTEGER, CURRENTHANDLE AS INTEGER
COMMON SHARED MIDIHandle%, MIDIName$

COMMON SHARED Baseport%, LenPort%, DMA%, DMA16%, cardversion%
COMMON SHARED Wave()  AS WaveHeaderType
COMMON SHARED WaveInfo AS WaveInfoType
COMMON SHARED MixRoutine%()
COMMON SHARED WavBuffer() AS STRING * blocklen

COMMON SHARED WItem$()
COMMON SHARED WZen() AS INTEGER
COMMON SHARED Item$()

COMMON SHARED TEXT$

COMMON SHARED Magic$()
COMMON SHARED SprLoc%

COMMON SHARED Level$
COMMON SHARED PDir$
COMMON SHARED x AS INTEGER
COMMON SHARED y AS INTEGER
COMMON SHARED Moved AS INTEGER
COMMON SHARED Noise AS INTEGER
COMMON SHARED Dot AS STRING
COMMON SHARED Answer AS STRING
COMMON SHARED InShop AS INTEGER

COMMON SHARED Zen AS INTEGER

COMMON SHARED Enemy$
COMMON SHARED PlayerGo AS INTEGER
COMMON SHARED EnemyGo AS INTEGER
COMMON SHARED EnemyHP AS INTEGER
COMMON SHARED EnemyMP AS INTEGER
COMMON SHARED EnemyST AS INTEGER
COMMON SHARED EnemyDF AS INTEGER
COMMON SHARED EnemyAG AS INTEGER
COMMON SHARED EnemyMS AS INTEGER
COMMON SHARED EnemyMD AS INTEGER

COMMON SHARED RavynLvl AS INTEGER
COMMON SHARED RavynExp AS LONG
COMMON SHARED RavynWeapon$, RavynArmor$, RavynStatus$
COMMON SHARED RavynHp AS INTEGER
COMMON SHARED RavynMaxHP AS INTEGER
COMMON SHARED RavynMp AS INTEGER
COMMON SHARED RavynMaxMP AS INTEGER
COMMON SHARED RavynST AS INTEGER
COMMON SHARED RavynAG AS INTEGER
COMMON SHARED RavynDF AS INTEGER
COMMON SHARED RavynMS AS INTEGER
COMMON SHARED RavynMD AS INTEGER

COMMON SHARED Maze() AS INTEGER, NextLevel() AS LONG

