DECLARE SUB TitleScreen ()
'      ͻ
'       E T E R N I T Y ' S   B L E S S I N G  
'      Ŀ
'           By Alan Farnsworth (tojo-mojo@geocities.com) 
'          
'
' Version: 0.5
'
' Purpose: A game that's more fun than... well... Pong.
'
' Total working time: Don't even ask.  I have no idea.  LONG time.
'
' This is a project of mine I've been working on for some time now.  This
'is an early demo of what might one day be a nice, finished program.  This
'demo allows you to visit a few towns and talk to some people.  You can also
'view previews of the battle and menu system.
'  Keys:
'    [NUMPAD]: Movement on walkabout screen and menus.
'    [ARROW KEYS]: Movement on walkabout screen ONLY.  (This will change)
'    [SPACEBAR]: Accept choice/option
'    [ESCAPE]: Cancel/ go back to previous menu
'    [S]: Open the status menu.  Partially completed.  You can change the
'       colors of the dialog boxes and save/load games (Yes, really!).
'    [V]: Display version number.
'    [C]: Run Credits
'    Typing in MOHOROVICIC will open a debug menu.  Pressing 'M' at the debug
'       menu will let you open a map file.  Pressing 'N' will rename the char.
'       to see the others, look below.
'
'   To talk to people, open doors, and examine objects, you need only press
'the direction it's in (as if you were going to walk on it).
'   Using the status menu, you can adjust the colors and such.

'----------------------------------------------------------------------------
'==                             SUB Declarations                           ==
'----------------------------------------------------------------------------


DEFINT A-Z
DECLARE SUB DrawLetter (MainString$, NewString$, MaxSize, size)
DECLARE SUB Intro ()
DECLARE SUB Credits ()
DECLARE SUB CreateCharacter ()
DECLARE SUB StatusFileScreen ()
DECLARE FUNCTION ExtractSpcs$ (InString$)
DECLARE SUB DoNPC (NPCVal%)
DECLARE SUB PutRealNPC (x%, y%, pic%)
DECLARE SUB TextBox (txt$, Speaker$, TopOfScreen%, Animate%, Style%)
DECLARE SUB Text (Line1$, Line2$, Line3$, Line4$, Line5$, Line6$, TopOfScreen%, Style%, Animate%)
DECLARE SUB FadeToBlack (SetPal%)
DECLARE SUB LoadTileSet (n$)
DECLARE SUB ProcessMove (key$)
DECLARE SUB ScreenRefresh ()
DECLARE SUB StatusOrderScreen ()
DECLARE SUB RealizeStandardPalette (ResetPal)
DECLARE SUB GetClr (Clr AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER)
DECLARE SUB ScreenFade (Loops, Darken)
DECLARE SUB WaitSecs (InTime!)
DECLARE SUB BattleDemo ()
DECLARE SUB QuitConfirm (CanQuit)
DECLARE SUB StatusOptionColors ()
DECLARE SUB StatusOptionSpeed ()
DECLARE SUB StatusOptionBattle ()
DECLARE SUB Menu (MenuReturn)
DECLARE SUB StatusMagicScreen ()
DECLARE SUB StatusOptionScreen ()
DECLARE SUB BoxAnimate (x1, y1, x2, y2, Style, increment)
DECLARE SUB StatusItemScreen ()
DECLARE SUB DoTime (TimeReturn$)
DECLARE SUB ClrCycl (Clr, r, g, b)
DECLARE SUB StatusMenu ()
DECLARE SUB SmallDialog (msg$)
DECLARE SUB Box (x1, y1, x2, y2, Style)
DECLARE SUB dispbox (x, y)
DECLARE SUB fade (x1, y1, x2, y2, numtofade)
DECLARE SUB melt (x1, y1, x2, y2, incr, Backg, fadeBlack)
DECLARE SUB LoadFile (FileName$)
DECLARE SUB PutNPC (x, y, pic)
DEF SEG = &HA000 'This is for any peeks and/or pokes that might be around.

'----------------------------------------------------------------------------
'==                             Variable TYPEs                             ==
'----------------------------------------------------------------------------


TYPE RGBClr    'Used for holding palettes
  r AS INTEGER
  g AS INTEGER
  b AS INTEGER
END TYPE

TYPE Character
  Str AS INTEGER          'STRength: Used for phys atks.
  Dfn AS INTEGER          'DeFeNce: Armor/Endurance.  Subtracted from enemy atk.
  Mag AS INTEGER          'MAGic: Magical attack power.
  Blf AS INTEGER          'BeLieF: Belief in powers of magic.  Strengthens atk
                          ' but lowers defence against magic.
  Agl AS INTEGER          'AGiLity: How often the char atks in combat.
  Dex AS INTEGER          'DEXterity: Skill. Used for both Phys & Mag atks.
  Chem AS INTEGER         'CHEMistry: Ability to use items.
  HP AS INTEGER           'Hit Points: How much the char can take.
  MaxHP AS INTEGER        'Max Hit Points: How much HP char can have fully healed
  MP AS INTEGER           'Magic Points: Consumed each time spell is cast
  MaxMP AS INTEGER        'Max Magic Points: How much MP if fully healed
  CharName AS STRING * 12 'Character's Name: You name him.
  Xp AS INTEGER           'EXPerience Points: How your char is progressing
  Lvl AS INTEGER          'LeVeL: How powerful char is.  With each lvl, char
                          ' becomes more powerful
  Status AS STRING * 12   'Status: What is ailing you, my friend?
  Tags AS INTEGER         'Tags: This might hold story stuff
  InParty AS INTEGER      'InParty: Is he in the party or not?
END TYPE

'----------------------------------------------------------------------------
'==                           Constant Variables                           ==
'----------------------------------------------------------------------------

CONST LEFTRIGHT = 1: CONST UPDOWN = 0
CONST TRUE = 1: CONST FALSE = 0
CONST MAXNPCS = 20: CONST MAXQUESTS = 10 'Quests are not used yet...

'----------------------------------------------------------------------------
'==                      SHARED Variables and Arrays                       ==
'----------------------------------------------------------------------------


'Ugh!! a TON of SHARED VARIABLES.  Lets run through a few.

DIM SHARED tiles(10800), CurTileSet$, CurMap$, CurLoc$

'*tTiles(10800)*: Holds the GET data for the various tiles.  Max=27 Tiles
'*CurTileSet$*: Keeps track of what Tile set is loaded
'*CurMap$*: Hold which map the player is on.  File name.
'*CurLoc$*: The name of the map.  Used on status menu.

DIM SHARED Hero(2, 20, 20), HeroFrame, Party(4) AS Character, WalkAboutSpeed

'*Hero(2,20,20)*: Holds color data for hero.  Hero has to be PSETed.
'*heroframe*: Which frame of animation hero is on.
'*Party(4)*: Holds RPG stats for characters in party.
'*WalkAboutSpeed*: Unused.  Would be used to animate movement

DIM SHARED map(60, 60), mapx, mapy, MapBkg, posx, posy, Curs, maps(60, 60) AS STRING * 2

'*map(60,60)*: Holds map tile data
'*mapx*, *mapy*: Map dimensions
'*MapBkg*: Tile to put past boundries of map
'*posx*,*posy*: Current position on map (goes by upper-leftmost tile on screen)
'*Curs*: Last cursor position on status menu
'*maps*: Holds the special data for a spot on the map, eg passable or NPC

DIM SHARED StartTime AS DOUBLE, Trgtx, Trgty, ReturnToMain

'*StartTime*: When you started playing, value of TIMER.  Used for status menu.
'*Trgtx*,*Trgty*: Used when moving.  Holds the spot party is moving to.
'*ReturnToMain*: Used to tell status menu to exit and return to map.  Usually after loading game

DIM SHARED MenuItems$(10), MenuPosX(10), MenuPosY(10), MenuItems, MenuKeys, MenuHints$(10), MenuHintsToggle, MenuHinty, MenuHintx, MenuCancel

'*Menu-----(10)*:Menu variables. Faster than passing them to the sub (i think;)

DIM SHARED BkgClr AS RGBClr, TextClr, Pal(255) AS RGBClr, StdPal(200) AS RGBClr

'*BkgClr*, *TextClr*: These will be trashed soon.
'*Pal(255)*: Holds the current palette values, for nighttime effects.
'*StdPal(255)*: Holds the standard BASIC palette.  Used for restoring screen.

DIM SHARED NPCQuestNum(MAXNPCS, 5), NPCCond(MAXNPCS, 5) AS STRING * 1, NPCVal(MAXNPCS, 5)
DIM SHARED NPCPic(MAXNPCS), NPCPicData(10, 20, 20), Quests(10)

'*NPC-----(MAXNPCS,5)*: Holds the various pices of data for NPCs.  The
'  5 is for when conditionals are completed (so that NPCs will say different
'  things depending on player's progress in game)
'*NPCPicData(10,20,20)*: Holds the image data for NPC sprites.
'*Quests(10)*:Will keep track of players progress through game eventually.

'----------------------------------------------------------------------------
'==                               Startup                                  ==
'----------------------------------------------------------------------------


PRINT : PRINT "Eternity's Blessing": PRINT "1998-1999 Tojo Mojo"

FOR i = 63 TO 0 STEP -2
  FOR Clr = 1 TO 16
    CALL ClrCycl(Clr, i, i, i) 'Fade DOS screen to black as a nifty effect
  NEXT Clr
  'CALL WaitSecs(.005)
NEXT i


RANDOMIZE TIMER
BkgClr.r = 0: BkgClr.g = 0: BkgClr.b = 33 'Blue Final Fantasy-type color
TextClr = 63
StartTime = TIMER 'Starttime is used to tell how long one has been playing
ReturnToMain = FALSE
CreateCharacter  'Sets up character stats.  Go to the sub to change them
WalkAboutSpeed = 4  'Used for movement animations.
gp = RND * 100'Gold (Money)

SCREEN 13

'--Get palette colors, and cycle all to black so as not to see load

OPEN "Standard.pal" FOR INPUT AS #1

FOR i = 0 TO 200
  INPUT #1, InString$
  StdPal(i).r = ASC(MID$(InString$, 1, 1)) - 100
  StdPal(i).g = ASC(MID$(InString$, 2, 1)) - 100
  StdPal(i).b = ASC(MID$(InString$, 3, 1)) - 100
  Pal(i).r = 0
  Pal(i).g = 0
  Pal(i).b = 0

  CALL ClrCycl(i, 0, 0, 0)
'  SLEEP
NEXT i
CLOSE #1


'----------------------------------------------------------------------------
'==                             Open Files                                 ==
'----------------------------------------------------------------------------

'                  ---------Hero sprites

n$ = "wizards.acp"
OPEN n$ FOR INPUT AS #1
INPUT #1, numpics: INPUT #1, dummy: INPUT #1, dummy
FOR n = 1 TO 2'numpics
FOR x = 1 TO 20
    INPUT #1, InCharList$
    FOR y = 1 TO 20
        InChar$ = MID$(InCharList$, y, 1)
        IF InChar$ <> "" THEN Hero(n, x, y) = ASC(InChar$)
NEXT y, x, n
CLOSE

'                  ---------NPC sprites

OPEN "Peoples.acp" FOR INPUT AS #1
INPUT #1, numpics: INPUT #1, dummy: INPUT #1, dummy
FOR n = 1 TO numpics
FOR x = 1 TO 20
    INPUT #1, InCharList$
    FOR y = 1 TO 20
        InChar$ = MID$(InCharList$, y, 1)
        IF InChar$ <> "" THEN NPCPicData(n, x, y) = ASC(InChar$)
NEXT y, x, n
CLOSE


CALL LoadFile("Alan4") 'Starting map.

TitleScreen
CALL FadeToBlack(TRUE)

MAXY = 9 'USed for refreshing screen.  # of tiles in y dimension.
MAXX = 15 '# of tiles in x dimension


HeroFrame = 1

'----------------------------------------------------------------------------
'==                              Main Loop                                 ==
'----------------------------------------------------------------------------


MainLoop:
  ScreenRefresh  'Refresh the screen- that is, draw tiles!
CALL ClrCycl(254, BkgClr.r, BkgClr.g, BkgClr.b)' Init Menu colors
CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)
CALL ScreenFade(63, FALSE): CALL RealizeStandardPalette(TRUE)  'Load in palette
COLOR 15
CALL TextBox("Eternity's Blessing v0.5- demo for ABC Archives.  Programmed by Alan Farnsworth (tojo-mojo@geocities.com).  Press [I] to see the intro sequence.", "Tojo Mojo", TRUE, TRUE, 1)

WHILE UCASE$(a$) <> "Q" AND a$ <> CHR$(27)
  a$ = ""
  WHILE a$ = "": a$ = UCASE$(INKEY$): WEND
  KeyList$ = KeyList$ + a$: IF LEN(KeyList$) > 20 THEN KeyList$ = RIGHT$(KeyList$, 20)
  IF a$ = CHR$(0) + "H" THEN a$ = "8"
  IF a$ = CHR$(0) + "P" THEN a$ = "2"
  IF a$ = CHR$(0) + "K" THEN a$ = "4"
  IF a$ = CHR$(0) + "M" THEN a$ = "6"
  OldPosX = posx: OldPosY = posy
  IF a$ = "8" OR a$ = "4" OR a$ = "6" OR a$ = "2" THEN CALL ProcessMove(a$)
  IF a$ = "S" THEN StatusMenu: move = LEFTRIGHT
  IF a$ = "I" THEN CALL Intro: CALL TextBox("Yep. All that will eventually be tied into the game somehow. The rest of the intro will be finished someday.", "Tojo Mojo", TRUE, TRUE, 1)
  'IF a$ = "D" THEN
  IF RIGHT$(KeyList$, 4) = "MOHO" THEN 'Debug menu
  CALL SmallDialog("Enter a valid debug command")
    dc$ = "": WHILE dc$ = "": dc$ = UCASE$(INKEY$): WEND
    IF dc$ = "V" THEN CALL SmallDialog("Enternity's Blessing v0.5")
    IF dc$ = "C" THEN Credits: CALL RealizeStandardPalette(TRUE)
    IF dc$ = "D" THEN CALL ScreenFade(63, TRUE)     'Fade to black
    IF dc$ = "L" THEN CALL ScreenFade(63, FALSE)    'Fade in from black
    IF dc$ = "B" THEN CALL BattleDemo               'View battle screen
    IF dc$ = "S" THEN CALL RealizeStandardPalette(TRUE) 'In case palette is messed up
    IF dc$ = "N" THEN LOCATE 13, 7: PRINT "                            ": LOCATE 13, 7: INPUT "New name for char:", Party(1).CharName
    IF dc$ = "T" THEN CALL TextBox("   This is an interactive demo of Eternity's Blessing.  Save up your pennies, this thing is going commercial one day.", "Tojo Mojo", TRUE, TRUE, 1)
    IF dc$ = "W" THEN
      FOR i = 1 TO 263
        FOR Clr = 1 TO i
          IF Clr < 200 THEN
            Pal(Clr).r = Pal(Clr).r + 1: IF Pal(Clr).r > 63 THEN Pal(Clr).r = 63
            Pal(Clr).g = Pal(Clr).g + 1: IF Pal(Clr).g > 63 THEN Pal(Clr).g = 63
            Pal(Clr).b = Pal(Clr).b + 1: IF Pal(Clr).b > 63 THEN Pal(Clr).b = 63
            CALL ClrCycl(Clr, Pal(Clr).r, Pal(Clr).g, Pal(Clr).b)
          END IF
        NEXT Clr
        IF i MOD 4 = 0 THEN WaitSecs (.005)
      NEXT i
    END IF
    IF dc$ = "M" THEN  'Use this debug command to load a custom map
      LOCATE 13, 7: PRINT "                            "
      LOCATE 13, 13: INPUT "Enter a map:"; NewMap$
      CALL ScreenFade(63, TRUE): LoadFile (NewMap$)
      ScreenRefresh
      CALL ScreenFade(63, FALSE): RealizeStandardPalette (TRUE)
    END IF
  END IF

'-------------------------
'== Movement animation  ==
'-------------------------

'Unquote the following four IF chunks to get animated movement.  Not complete
'Note that you must also unquote two arrays:
'DIM SlideData(320), TempSlide(400)
'
'IF OldPosY + 1 = PosY THEN 'Hero moved down one space
'    incr = WalkAboutSpeed * -1
'    FOR main = 20 TO 1 STEP incr
'   FOR y = incr * -1 TO 199
'      GET (0, y)-(319, y), SlideData
'      PUT (0, y + incr), SlideData, PSET
'    NEXT y
'    LINE (0, 200)-(320, 200 + incr), 16, BF
'    CALL WaitSecs(.01)
'  NEXT main
'END IF
'
'IF OldPosY - 1 = PosY THEN 'Hero moved up one space
'  incr = WalkAboutSpeed
'  FOR main = 1 TO 20 STEP incr
'  FOR y = 199 - incr TO 0 STEP -1
'    GET (0, y)-(319, y), SlideData
'    PUT (0, y + incr), SlideData, PSET
'  NEXT y
'  LINE (0, 0)-(320, incr - 1), 16, BF
'  CALL WaitSecs(.01)
'  NEXT main
'END IF
'
'IF OldPosX + 1 = PosX THEN 'Hero moved right one space
'    incr = INT(WalkAboutSpeed * -1.6 - .5)
'    FOR main = 16 TO 1 STEP incr
'    FOR x = incr * -1 TO 319
'      GET (x, 0)-(x, 199), SlideData
'      PUT (x + incr, 0), SlideData, PSET
'    NEXT x
'    LINE (320, 0)-(320 + incr, 200), 16, BF
'    CALL WaitSecs(.01)
'  NEXT main
'
'END IF
'
'IF OldPosX - 1 = PosX THEN 'Hero moved left one space
'  incr = INT(WalkAboutSpeed * 1.6 + .5)
'  FOR main = 1 TO 18 STEP incr
'  FOR x = 319 - incr TO 0 STEP -1
'    GET (x, 0)-(x, 199), SlideData
'    PUT (x + incr, 0), SlideData, PSET
'  NEXT x
'  LINE (0, 0)-(incr - 1, 200), 16, BF
'  CALL WaitSecs(.01)
'  NEXT main
'
'END IF
'
''/\ END ANIMATED MOVEMENT SECTION /\

  ScreenRefresh
  HeroFrame = ABS(HeroFrame - 3)    'Update screen

WEND

CALL QuitConfirm(OkayResult)
IF OkayResult = FALSE THEN a$ = "": GOTO MainLoop 'Confirm quitting

'CALL fade(140, 100, 159, 119, 5)
LINE (0, 0)-(0, 200), 0
LINE (319, 0)-(319, 200), 0
ClrCycl 0, 0, 0, 0
CALL melt(0, 0, 318, 199, 6, 16, TRUE) 'Melt the screen
CLS

WINDOW (0, 0)-(320, 200)  'Reverse the screen.  This was useful before, but
                          'not so much now.

FOR i = 0 TO 189
  LINE (0, i)-(i, 0), 163 - (i / 3)  'Fill the screen with some nifty lines
NEXT i

FOR i = 0 TO 189
  LINE (320 - i, 200)-(320, 200 - i), 163 - (i / 3)
NEXT i

FOR i = 100 TO 163
    ClrCycl i, i - 100, i - 100, i - 100 'and cycle them to greyscale
NEXT i

COLOR 15: CALL ClrCycl(15, 63, 63, 63)

LOCATE 12, 6: PRINT "Copyright 1998-99 Tojo Mojo"
LOCATE 14, 12: PRINT "Press any key..."
SLEEP

'This is a demo of what the battle screen will look like.  Pressing a key
'will cause stars to come out.  Eventually, this game will include a day/night
'cycle.
SUB BattleDemo

DEF SEG = &HA000

CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)

Pal(252).r = 0: Pal(252).g = 63: Pal(252).b = 0
Pal(251).r = 0: Pal(251).g = 0: Pal(251).b = 63
Pal(250).r = 63: Pal(250).g = 63: Pal(250).b = 63
Pal(249).r = 63: Pal(249).g = 63: Pal(249).b = 0
Pal(248).r = 0: Pal(248).g = 0: Pal(248).b = 63
Pal(247).r = 63: Pal(247).g = 63: Pal(247).b = 63
Pal(246).r = 63: Pal(246).g = 63: Pal(246).b = 0

FOR i = 246 TO 252
  CALL ClrCycl(i, Pal(i).r, Pal(i).g, Pal(i).b)
NEXT i

LINE (0, 0)-(319, 66), 251, BF
LINE (0, 66)-(319, 200), 252, BF
CIRCLE (280, 20), 15, 249
PAINT (280, 20), 249, 249

CALL BoxAnimate(0, 146, 63, 200, 1, 3)
CALL BoxAnimate(63, 146, 320, 200, 1, 6)

COLOR 14
LOCATE 20, 11: PRINT "NAME"
LOCATE 20, 24: PRINT "Hits"
LOCATE 20, 33: PRINT "Magic"
COLOR 15

FOR i = 1 TO 4
  LOCATE 20 + i, 11: PRINT ExtractSpcs$(Party(i).CharName);
  LOCATE 20 + i, 26 - LEN(ExtractSpcs$(STR$(Party(i).HP)))
  PRINT ExtractSpcs$(STR$(Party(i).HP) + "/" + STR$(Party(i).MaxHP));
  LOCATE 20 + i, 35 - LEN(ExtractSpcs$(STR$(Party(i).HP)))
  PRINT ExtractSpcs$(STR$(Party(i).MP) + "/" + STR$(Party(i).MaxMP));
NEXT i

FOR i = 1 TO 45
  x = RND * 40 + 20: y = RND * 20 + 20
  CIRCLE (x, y), 10, 250
 'PAINT (x, y), 250, 250
NEXT i

FOR i = 1 TO 50
  x = RND * 40 + 100: y = RND * 25 + 10
  CIRCLE (x, y), 10, 250
 'PAINT (x, y), 250, 250
NEXT i

FOR i = 1 TO 65
  x = RND * 60 + 200: y = RND * 20 + 30
  CIRCLE (x, y), 10, 250
 'PAINT (x, y), 250, 250
NEXT i


FOR i = 1 TO 200
  x = INT(RND * 320): y = INT(RND * 63)
  PSET (x, y), PEEK(x + y * 320&) - 3
NEXT i
SLEEP

FOR i = 1 TO 63
  FOR Clr = 246 TO 249
    IF Pal(Clr).r < 63 THEN Pal(Clr).r = Pal(Clr).r + 1
    IF Pal(Clr).g < 63 THEN Pal(Clr).g = Pal(Clr).g + 1
    IF Pal(Clr).b < 63 THEN Pal(Clr).b = Pal(Clr).b + 1
  NEXT Clr
 
  FOR Clr = 250 TO 251
    IF Pal(Clr).r > 0 THEN Pal(Clr).r = Pal(Clr).r - 1
    IF Pal(Clr).g > 0 THEN Pal(Clr).g = Pal(Clr).g - 1
    IF Pal(Clr).b > 0 THEN Pal(Clr).b = Pal(Clr).b - 1
  NEXT Clr
  
  IF i / 2 = INT(i / 2) THEN Pal(252).g = Pal(252).g - 1
 
  FOR Clr = 246 TO 252
    CALL ClrCycl(Clr, Pal(Clr).r, Pal(Clr).g, Pal(Clr).b)
  NEXT Clr
 
  CALL WaitSecs(.03)

NEXT i

SLEEP

END SUB

'Draws a somewhat rounded box on the screen.  USed for textboxes, etc.
'  This sub is called numerous times during BoxAnimate
'   *x1*,*y1*: XY dimensions for upper-left corner
'   *x2*,*y2*: XY dimensions for lower-right corner
'   *Style*: 1 is a normal dialog box, 0 is a transparent box (useless)
SUB Box (x1, y1, x2, y2, Style)

  LINE (x1 + 1, y1)-(x2 - 1, y1), 23
  LINE (x1 + 1, y2)-(x2 - 1, y2), 23
  LINE (x1, y1 + 1)-(x1, y2 - 1), 23
  LINE (x2, y1 + 1)-(x2, y2 - 1), 23

  LINE (x1 + 1, y1 + 1)-(x2 - 1, y2 - 1), 29, B
  LINE (x1 + 2, y1 + 2)-(x2 - 2, y2 - 2), 31, B
  PSET (x1 + 1, y1 + 1), 23: PSET (x2 - 1, y1 + 1), 23
  PSET (x1 + 1, y2 - 1), 23: PSET (x2 - 1, y2 - 1), 23
  IF Style = 1 THEN LINE (x1 + 3, y1 + 3)-(x2 - 3, y2 - 3), 254, BF
  PSET (x1 + 3, y1 + 3), 31: PSET (x2 - 3, y1 + 3), 31
  PSET (x1 + 3, y2 - 3), 31: PSET (x2 - 3, y2 - 3), 31
 

END SUB

'BoxAnimate cause the dialog boxes, etc. to open from the uper left.
'   *x1*,*y1*: XY dimensions for upper-left corner
'   *x2*,*y2*: XY dimensions for lower-right corner
'   *Style*: 1 is a normal dialog box, 0 is a transparent box (useless)
'   *increment*: Should be higher for bigger boxes.
SUB BoxAnimate (x1, y1, x2, y2, Style, increment)

  'increment = 1
  yLength = ABS(y2 - y1)
  xLength = ABS(x2 - x1)

  IF xLength > yLength THEN Total = xLength ELSE Total = yLength
  Portion = INT(Total * .2)
 
  FOR i = 5 TO Total STEP increment
    IF i > yLength THEN iy = y2 ELSE iy = y1 + i
    IF i > xLength THEN ix = x2 ELSE ix = x1 + i
    CALL Box(x1, y1, ix, iy, Style)
    IF i MOD Portion = 0 THEN WaitSecs (.005)
  NEXT i

  CALL Box(x1, y1, x2, y2, Style)

END SUB

' ClrCycl changes a color's monitor entry values.  This is much faster than
'using the PALETTE statement.
'   *Clr*: Palette color (0-255) to change.
'   *r*, *b*, *g*: Red, Blue, and Green values, respectively.
SUB ClrCycl (Clr, r, g, b)

OUT &H3C8, Clr
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, b


END SUB

'This is nowhere near finished.  For now, it just creates some sample stats.
SUB CreateCharacter

Party(1).Str = 11
Party(1).Dfn = 12
Party(1).Mag = 16
Party(1).Blf = 73
Party(1).Agl = 10
Party(1).Dex = 12
Party(1).Chem = 70
Party(1).Xp = 0
Party(1).Lvl = 1
Party(1).Status = "Normal"
Party(1).Tags = 0
Party(1).InParty = TRUE

Party(1).CharName = "Tojo-Mojo"
Party(1).HP = RND * 100: Party(1).MaxHP = Party(1).HP + RND * 30
Party(1).MP = RND * 100: Party(1).MaxMP = Party(1).MP + RND * 30

Party(2).CharName = "Alan"
Party(2).HP = RND * 100: Party(2).MaxHP = Party(2).HP + RND * 30
Party(2).MP = RND * 100: Party(2).MaxMP = Party(2).MP + RND * 30

Party(3).CharName = "Stephen"
Party(3).HP = RND * 100: Party(3).MaxHP = Party(3).HP + RND * 30
Party(3).MP = RND * 100: Party(3).MaxMP = Party(3).MP + RND * 30

Party(4).CharName = "Bob"
Party(4).HP = RND * 100: Party(4).MaxHP = Party(4).HP + RND * 30
Party(4).MP = RND * 100: Party(4).MaxMP = Party(4).MP + RND * 30


'CALL BoxAnimate(2, 2, 320, 200, 4, 1)

END SUB

SUB Credits

CLS : CALL ClrCycl(0, 0, 0, 0)

DIM GetData(2000), GetData2(2000)

FOR i = 1 TO 30
  ClrCycl i, 0, 0, 0
NEXT i

COLOR 2: LOCATE 24, 12: PRINT "Alan Farnsworth";

'(96, 174)-(216, 192), GetData

GET (88, 174)-(216, 192), GetData
CLS
PUT (92, 174), GetData
COLOR 1: LOCATE 23, 11: PRINT "Programing and art:";
GET (80, 174)-(232, 192), GetData

FOR i = 174 TO 111 STEP -1
  PUT (80, i), GetData, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  CALL ClrCycl(1, 63 - (i - 111), 0, 0)
  CALL ClrCycl(2, 0, 0, 63 - (i - 111))
  IF i MOD 2 = 0 THEN WaitSecs .005
'  SLEEP
NEXT i

FOR i = 110 TO 64 STEP -1
  PUT (80, i), GetData, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  IF i MOD 2 = 0 THEN WaitSecs .005
NEXT i

ClrCycl 3, 0, 0, 0
ClrCycl 4, 0, 0, 0

COLOR 3: LOCATE 23, 14: PRINT "Character Art:";
COLOR 4: LOCATE 24, 13: PRINT "Stephen Mitchell";
GET (80, 174)-(232, 192), GetData2

FOR i = 63 TO 0 STEP -1
  PUT (80, i), GetData, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  CALL ClrCycl(1, i, 0, 0)
  CALL ClrCycl(2, 0, 0, i)
  PUT (80, i + 111), GetData2, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  CALL ClrCycl(3, 63 - i, 0, 0)
  CALL ClrCycl(4, 0, 0, 63 - i)
  IF i MOD 2 = 0 THEN WaitSecs .005
NEXT i

FOR i = 110 TO 64 STEP -1
  PUT (80, i), GetData2, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  IF i MOD 2 = 0 THEN WaitSecs .005
NEXT i

ClrCycl 5, 0, 0, 0
ClrCycl 6, 0, 0, 0

COLOR 5: LOCATE 23, 9: PRINT "Somewhat Helpful Advice:";
COLOR 6: LOCATE 24, 15: PRINT "Mr. Dimezzo";
GET (64, 174)-(252, 192), GetData

FOR i = 63 TO 0 STEP -1
  PUT (80, i), GetData2, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  CALL ClrCycl(3, i, 0, 0)
  CALL ClrCycl(4, 0, 0, i)
  PUT (64, i + 111), GetData, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  CALL ClrCycl(5, 63 - i, 0, 0)
  CALL ClrCycl(6, 0, 0, 63 - i)
  IF i MOD 2 = 0 THEN WaitSecs .005
NEXT i

FOR i = 110 TO 64 STEP -1
  PUT (64, i), GetData, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  IF i MOD 2 = 0 THEN WaitSecs .005
NEXT i

FOR i = 63 TO 0 STEP -1
  PUT (64, i), GetData, PSET
  LINE (0, i + 1)-(320, i + 1), 0
  CALL ClrCycl(5, i, 0, 0)
  CALL ClrCycl(6, 0, 0, i)
  IF i MOD 2 = 0 THEN WaitSecs .005
NEXT i

ClrCycl 7, 0, 0, 0
ClrCycl 8, 0, 0, 0
ClrCycl 9, 0, 0, 0
ClrCycl 10, 0, 0, 0
ClrCycl 11, 0, 0, 0
ClrCycl 12, 0, 0, 0

COLOR 7: LOCATE 7, 12: PRINT "Absolutely nothing:";
COLOR 8: LOCATE 9, 14: PRINT "James Delles"
COLOR 9: LOCATE 11, 14: PRINT "Ross Stoltz";
COLOR 10: LOCATE 13, 14: PRINT "Dan Fletcher";
COLOR 11: LOCATE 15, 10: PRINT "Those guys that sit"
COLOR 11: LOCATE 16, 13: PRINT "in the back row"

FOR i = 1 TO 183
  FOR Clr = 0 TO 5
    IF Clr = 0 THEN
        IF i < 64 THEN CALL ClrCycl(7, i, 0, 0)
    ELSE
      IF INT(i / 20) > Clr - 1 AND i - Clr * 20 < 64 THEN CALL ClrCycl(Clr + 7, 0, 0, i - Clr * 20)
    END IF
  NEXT Clr
  IF i MOD 2 = 0 THEN CALL WaitSecs(.005)
NEXT i

CALL WaitSecs(1)

FOR i = 183 TO 1 STEP -1
  FOR Clr = 0 TO 5
    IF Clr = 0 THEN
        IF i < 64 THEN CALL ClrCycl(7, i, 0, 0)
    ELSE
      IF INT(i / 20) > Clr - 1 AND i - Clr * 20 < 64 THEN CALL ClrCycl(Clr + 7, 0, 0, i - Clr * 20)
    END IF
  NEXT Clr
  IF i MOD 2 = 0 THEN CALL WaitSecs(.005)
NEXT i


SLEEP


END SUB

'Draws a tile to the screen.  X and y are multiplied by 20 to fit tiles
'   *x*, *y*: Coordinates to place tile.  Like I said, they are * by 20.
SUB dispbox (x, y)

      IF y + posy > -1 AND y + posy < mapy AND x + posx > -1 AND x + posx < mapx THEN
        PUT (x * 20, y * 20), tiles((map(x + posx, y + posy) - 1) * 400), PSET
        'IF MID$(maps(x + posx, y + posy), 2, 1) = "X" THEN LINE (x * 20, y * 20)-(x * 20 + 19, y * 20 + 19), 15, B
       
        NPCVal = ASC(MID$(maps(x + posx, y + posy), 2, 1)) - 97
        IF NPCVal > -1 AND NPCVal < 21 THEN
          CALL PutRealNPC(x, y, NPCPic(NPCVal))
        END IF

      ELSE
        PUT (x * 20, y * 20), tiles(MapBkg * 400), PSET
      END IF
  
    IF x = 7 AND y = 5 THEN CALL PutNPC(7, 5, HeroFrame)

END SUB

' This sub looks up an NPC's text and displays it.  It will eventually check
'conditionals too.
'   *NPCVal*: Which NPC it is.
SUB DoNPC (NPCVal)

DIM NPCText$(5)

NPCFile$ = CurMap$ + ".NPC"

OPEN NPCFile$ FOR INPUT AS #1
  FOR i = 0 TO NPCVal
    INPUT #1, NPCPic(i)
    FOR j = 0 TO 5
      INPUT #1, NPCQuestNum(i, j), NPCCond(i, j)
      INPUT #1, NPCVal(i, j), NPCText$(j)
    NEXT j
  NEXT i
CLOSE

CALL TextBox(NPCText$(1), "", TRUE, TRUE, 1)

END SUB

' This sub takes Starttime and TIMER and determines how long the player
'has been playing.  It converts them into a string with preceding zeros.
'   *TimeReturn$*: The string that holds the time.  Should probably make this
'       whole thing a FUNCTION.
SUB DoTime (TimeReturn$)

  CurTime = TIMER - StartTime
  tmHours = INT((CurTime / 60) / 60)
  tmMinutes = INT(CurTime / 60) - tmHours * 60
  tmSeconds = CurTime MOD 60
  
  IF tmHours = 0 THEN
    TimePrev$ = TimePrev$ + "00:"
  ELSE IF tmHours < 10 THEN TimePrev$ = TimePrev$ + "0" + STR$(tmHours) + ":"
  END IF
  IF tmHours > 9 THEN TimePrev$ = TimePrev$ + STR$(tmHours) + ":"

  IF tmMinutes = 0 THEN
    TimePrev$ = TimePrev$ + "00:"
  ELSE IF tmMinutes < 10 THEN TimePrev$ = TimePrev$ + "0" + STR$(tmMinutes) + ":"
  END IF
  IF tmMinutes > 9 THEN TimePrev$ = TimePrev$ + STR$(tmMinutes) + ":"

  IF tmSeconds = 0 THEN
    TimePrev$ = TimePrev$ + "00"
  ELSE IF tmSeconds < 10 THEN TimePrev$ = TimePrev$ + "0" + STR$(tmSeconds)
  END IF
  IF tmSeconds > 9 THEN TimePrev$ = TimePrev$ + STR$(tmSeconds)

  TimeReturn$ = ExtractSpcs$(TimePrev$)
  'FOR i = 1 TO LEN(TimePrev$)
  '  IF MID$(TimePrev$, i, 1) <> " " THEN TimeReturn$ = TimeReturn$ + MID$(TimePrev$, i, 1)
  'NEXT i

END SUB

SUB DrawLetter (MainString$, NewString$, MaxSize, size)

IF MaxSize > size THEN incr = -1:  ELSE incr = 1

FOR a = MaxSize TO size STEP incr
  DRAW "s" + STR$(size) + MainString$
  'DRAW "s" + STR$(a) + "bm" + STR$(INT(0 - (a - size) / 2)) + "," + STR$(INT(0 - (a - size) / 2)) + NewString$
  DRAW "s" + STR$(a) + "bh" + STR$(INT((a - size) / 2)) + NewString$
  'DRAW "s" + STR$(a) + NewString$
  PCOPY 1, 0
  CLS
  'IF a MOD 3 = 0 THEN CALL WaitSecs(.005)
NEXT a

MainString$ = MainString$ + NewString$

END SUB

' A nice little function I made up to take all the spaces out of a string.
' Usage is :  a$=ExtractSpcs$(a$)
'   *InString$*: String to take spaces out of
FUNCTION ExtractSpcs$ (InString$)
   
    FOR i = 1 TO LEN(InString$)
      IF MID$(InString$, i, 1) <> " " THEN NewWord$ = NewWord$ + MID$(InString$, i, 1)
    NEXT i

    ExtractSpcs$ = NewWord$

END FUNCTION

'This effect is pretty stupid now.  Maybe someday it'll be okay.  It takes a
' section of the screen and converts it to greyscale, then fades that section
' to black.
'   *x1*, *y1*, *x2*, *y2*: Coordinates of box to fade.
'   *numtofade*: should alwauys be 16
SUB fade (x1, y1, x2, y2, numtofade)

DEF SEG = &HA000

FOR y = y1 TO y2
    FOR x = x1 TO x2
      PSET (x, y), (POINT(x, y)) MOD 16 + 16
    NEXT x
  NEXT y

FOR Clr = 1 TO 16
  FOR y = y1 TO y2
    FOR x = x1 TO x2
      IF (POINT(x, y) - 1) > 16 THEN
        PSET (x, y), POINT(x, y) - 1
      ELSE
        PSET (x, y), 0
      END IF
    NEXT x
  NEXT y
NEXT Clr


END SUB

'This sub really cuts to black.  Used during map transitions.
'   *SetPal*: Whether or not to set all Pal variables to 0 (black)
SUB FadeToBlack (SetPal)

FOR i = 1 TO 200
  CALL ClrCycl(i, 0, 0, 0)
  IF SetPal = TRUE THEN Pal(i).r = 0: Pal(i).g = 0: Pal(i).b = 0
NEXT i

END SUB

'Kind of the opposite of ClrCycl.  This sub returns the current palette value.
'   *Clr*: Color to get value of
'   *r*,*g*,*b*: Red, Green, and Blue values (repsectively) to return
SUB GetClr (Clr, r, g, b)

OUT &H3C8, (Clr + 1)
r = INP(&H3C9)
g = INP(&H3C9)
b = INP(&H3C9)

END SUB

SUB Intro
  OldMap$ = CurMap$: oldx = posx: oldy = posy: HeroFrame = 0
  CALL ScreenFade(63, TRUE)
  CALL LoadFile("dreams2")
  posx = 17: posy = 45: ScreenRefresh
  CALL ScreenFade(63, FALSE)
 

  CALL ScreenRefresh: CALL TextBox("The Castle of Dreams...", "", TRUE, FALSE, 1)
  FOR posy = 45 TO 38 STEP -1: CALL ScreenRefresh: CALL WaitSecs(.2): NEXT posy
  FOR posx = 17 TO 25: ScreenRefresh: CALL WaitSecs(.2): NEXT posx
 
  CALL ScreenRefresh: CALL TextBox("The Castle of Dreams was filled with people...", "", TRUE, FALSE, 1)
  FOR posy = 38 TO 40: ScreenRefresh: CALL WaitSecs(.2): NEXT posy
  FOR posx = 25 TO 7 STEP -1: ScreenRefresh: CALL WaitSecs(.2): NEXT posx
 
  CALL ScreenRefresh: CALL TextBox("...Many cheerful people...", "", TRUE, FALSE, 1)
  CALL ScreenFade(63, TRUE): posx = 17: posy = 29: ScreenRefresh: CALL ScreenFade(63, FALSE)

  CALL ScreenRefresh: CALL TextBox("...And beautiful gardens.", "", TRUE, FALSE, 1)
  FOR posy = 29 TO 17 STEP -1: ScreenRefresh: CALL WaitSecs(.2): NEXT posy
 
  CALL ScreenRefresh: CALL TextBox("Until one day...", "", TRUE, FALSE, 1)
  FOR posy = 17 TO 20: ScreenRefresh: CALL WaitSecs(.2): NEXT posy
 

  FOR i = 1 TO 63
    FOR Clr = 1 TO 200
      IF Pal(Clr).r < 63 THEN Pal(Clr).r = Pal(Clr).r + 1
      IF Pal(Clr).g < 63 THEN Pal(Clr).g = Pal(Clr).g + 1
      IF Pal(Clr).b < 63 THEN Pal(Clr).b = Pal(Clr).b + 1
      CALL ClrCycl(Clr, Pal(Clr).r, Pal(Clr).g, Pal(Clr).b)
    NEXT Clr
    IF i MOD 2 = 0 THEN CALL WaitSecs(.05)
  NEXT i
  CALL LoadFile("dreams")
  posx = 17: posy = 20: ScreenRefresh
  FOR i = 1 TO 63
    FOR Clr = 1 TO 200
      IF Pal(Clr).r > StdPal(Clr).r THEN Pal(Clr).r = Pal(Clr).r - 1
      IF Pal(Clr).g > StdPal(Clr).g THEN Pal(Clr).g = Pal(Clr).g - 1
      IF Pal(Clr).b > StdPal(Clr).b THEN Pal(Clr).b = Pal(Clr).b - 1
      CALL ClrCycl(Clr, Pal(Clr).r, Pal(Clr).g, Pal(Clr).b)
    NEXT Clr
    CALL WaitSecs(.05)
  NEXT i
 
  CALL ScreenRefresh: CALL TextBox("The castle fell silent.", "", TRUE, FALSE, 1)
  CALL ScreenFade(63, TRUE): LoadFile ("dreams2"): posx = 35: posy = 40: CALL ScreenRefresh: CALL ScreenFade(63, FALSE)

  FOR i = 1 TO 63
    FOR Clr = 1 TO 200
      IF Pal(Clr).r < 63 THEN Pal(Clr).r = Pal(Clr).r + 1
      IF Pal(Clr).g < 63 THEN Pal(Clr).g = Pal(Clr).g + 1
      IF Pal(Clr).b < 63 THEN Pal(Clr).b = Pal(Clr).b + 1
      CALL ClrCycl(Clr, Pal(Clr).r, Pal(Clr).g, Pal(Clr).b)
    NEXT Clr
    IF i MOD 2 = 0 THEN CALL WaitSecs(.05)
  NEXT i
  CALL LoadFile("dreams")
  posx = 35: posy = 40: ScreenRefresh
  FOR i = 1 TO 63
    FOR Clr = 1 TO 200
      IF Pal(Clr).r > StdPal(Clr).r THEN Pal(Clr).r = Pal(Clr).r - 1
      IF Pal(Clr).g > StdPal(Clr).g THEN Pal(Clr).g = Pal(Clr).g - 1
      IF Pal(Clr).b > StdPal(Clr).b THEN Pal(Clr).b = Pal(Clr).b - 1
      CALL ClrCycl(Clr, Pal(Clr).r, Pal(Clr).g, Pal(Clr).b)
    NEXT Clr
    CALL WaitSecs(.05)
  NEXT i

  CALL TextBox("The banquet halls were emptied", "", TRUE, FALSE, 1)

  HeroFrame = 1: CALL LoadFile(OldMap$): posx = oldx: posy = oldy
END SUB

'This loads a map file and it's NPC file.  It also checks to make sure the
'correct tileset is loaded.  If not, it loads it.
'   *FileName$*: Name of map (w/o extension) to open.
SUB LoadFile (FileName$)

  OldTiles$ = CurTileSet$

  CurMap$ = LCASE$(FileName$)
  NPCFile$ = FileName$ + ".NPC"
  FileName$ = FileName$ + ".MAP"
 
  FOR y = 0 TO 50
    FOR x = 0 TO 50
     map(x, y) = 0
     maps(x, y) = "nZ"
   NEXT x
  NEXT y


'  PRINT "Opening "; FileName$

  OPEN FileName$ FOR INPUT AS #1
  INPUT #1, CurTileSet$
  INPUT #1, CurLoc$
  INPUT #1, mapy
  INPUT #1, mapx
  INPUT #1, MapBkg
  INPUT #1, posx
  INPUT #1, posy
  FOR y = 0 TO mapy
    FOR x = 0 TO mapx
      INPUT #1, InString$
      IF LEN(InString$) < 3 THEN
        map(x, y) = VAL(InString$)
      ELSE
        IF MID$(InString$, 2, 1) = " " THEN
          map(x, y) = VAL(MID$(InString$, 1, 1))
          maps(x, y) = MID$(InString$, 4, 1) + MID$(InString$, 3, 1)
        ELSE
          map(x, y) = VAL(MID$(InString$, 1, 2))
          maps(x, y) = MID$(InString$, 5, 1) + MID$(InString$, 4, 1)
        END IF
      END IF
    NEXT x
  NEXT y

CLOSE

OPEN NPCFile$ FOR INPUT AS #1
  FOR i = 0 TO MAXNPCS
    INPUT #1, NPCPic(i)
    FOR j = 0 TO 5
      INPUT #1, NPCQuestNum(i, j), NPCCond(i, j)
      INPUT #1, NPCVal(i, j), NPCText$
    NEXT j
  NEXT i
CLOSE


  IF OldTiles$ <> CurTileSet$ THEN CALL LoadTileSet(CurTileSet$)

END SUB

'This sub loads a tileset.  It's a good idea to make sure the palette has been
' set to black, otherwise you will see the tiles load.
'   *N$*: Name of tileset (with extension ".ACP") to open
SUB LoadTileSet (n$)
'CALL RealizeStandardPalette(FALSE)
OPEN n$ FOR INPUT AS #1
INPUT #1, numpics  'get number of pictures
INPUT #1, xpic'get hieght/width
INPUT #1, ypic

FOR n = 1 TO numpics
'LOCATE 20, 23: PRINT N
  FOR x = 1 TO 20
    INPUT #1, InCharList$
    FOR y = 1 TO 20
        InChar$ = MID$(InCharList$, y, 1)
        IF InChar$ <> "" AND InChar$ <> "" THEN PSET (x, y), ASC(InChar$) ELSE PSET (x, y), 0
NEXT y, x
GET (1, 1)-(20, 20), tiles((n - 1) * 400)
NEXT n
CLOSE

END SUB

'This is the melting effect seen when exiting the game.  Very simple, really.
'   *x1*,*y1*,*x2*,*y2*: Area to melt
'   *incr*: Amount to melt by (smaller number is better looking, but slower)
'   *Backg*: Color to place where screen has melted.  Usually 16 (black)
'   *fadeBlack*: Whether or not to fade to black while melting (affects entire screen)
SUB melt (x1, y1, x2, y2, incr, Backg, fadeBlack)
DEF SEG = &HA000
DIM GetData(480), yLength(320)
NumStringsDone = 0
main = 1
quarter = (x2 - x1) / 4

FOR i = x1 TO x2: yLength(i) = y1: NEXT i

WHILE INKEY$ = "" AND main < INT((y2 - y1) / (1.5 * incr))
main = main + 1
  FOR i = x1 TO x2
    SlideLength = INT(RND * (incr + 1) + incr / 2)

    IF yLength(i) + incr * 2 < y2 THEN
    GET (i, yLength(i))-(i + 1, y2 - SlideLength), GetData
    ELSE GET (i, y1)-(i, y1 + 1), GetData
    END IF

    IF yLength(i) + SlideLength < y2 THEN PUT (i, yLength(i) + SlideLength), GetData, PSET
  
      yLength(i) = yLength(i) + SlideLength
    
      IF yLength(i) + incr + SlideLength > y2 THEN yLength(i) = (y2 - incr) - SlideLength
      LINE (i, y1)-(i, yLength(i) + incr + SlideLength), Backg
      IF i MOD quarter = 0 AND fadeBlack = TRUE THEN CALL ScreenFade(1, TRUE)
   NEXT i

'NEXT Main
WEND


END SUB

'Using the menu variables you can call this to make a menu on the screen.
' See one of the Status Menu's sub-menus as an example (such as the item menu)
'   *MenuReturn*: Returns choice made by user.  Probably will be a FUNCTION someday.
SUB Menu (MenuReturn)

MenuReturn = -1

  FOR i = 0 TO MenuItems
    LOCATE MenuPosY(i), MenuPosX(i): PRINT MenuItems$(i);
  NEXT i

cr = 0: LOCATE MenuPosY(cr), MenuPosX(cr) - 1: COLOR 255: PRINT "": COLOR 15
WHILE MenuReturn = -1

MaxCycl = 63
a$ = "": Dir = 0: i = 63
WHILE a$ = ""
  a$ = INKEY$
    IF i < 63 AND Dir = 1 THEN i = i + 1
     IF i = 63 THEN Dir = 0
     IF i > 20 AND Dir = 0 THEN i = i - 1
     IF i = 20 THEN Dir = 1
     CALL ClrCycl(255, i, i, i)
     COLOR 15: IF MenuHintsToggle = TRUE THEN LOCATE MenuHinty, MenuHintx: PRINT MenuHints$(cr);
     IF i MOD 2 = 0 THEN CALL WaitSecs(.005)
WEND

IF a$ = "8" AND cr > 0 AND MenuKeys = UPDOWN THEN
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: PRINT " "
  cr = cr - 1
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: COLOR 255: PRINT "": COLOR 15
END IF

IF a$ = "2" AND cr < MenuItems AND MenuKeys = UPDOWN THEN
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: PRINT " "
  cr = cr + 1
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: COLOR 255: PRINT "": COLOR 15
END IF

IF a$ = "4" AND cr > 0 AND MenuKeys = LEFTRIGHT THEN
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: PRINT " "
  cr = cr - 1
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: COLOR 255: PRINT "": COLOR 15
END IF

IF a$ = "6" AND cr < MenuItems AND MenuKeys = LEFTRIGHT THEN
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: PRINT " "
  cr = cr + 1
  LOCATE MenuPosY(cr), MenuPosX(cr) - 1: COLOR 255: PRINT "": COLOR 15
END IF


IF a$ = " " THEN MenuReturn = cr
IF a$ = CHR$(27) THEN MenuReturn = MenuCancel
WEND

LOCATE MenuPosY(cr), MenuPosX(cr) - 1: COLOR 15: PRINT ""

MenuCancel = -1: MenuHintsToggle = FALSE

END SUB

'This is one BIG sub.  It makes sure the character can move to the new space,
' call NPC sub if there is an NPC, and transfers between maps if necessary.
' Very hard to understand.
'   *key$*: Direction char is moving in (8,2,4,6) as in NUMPAD keys.
SUB ProcessMove (key$)

  Trgtx = posx + 7: Trgty = posy + 5
  IF key$ = "8" AND posy > -5 THEN Trgty = posy + 4
  IF key$ = "2" AND posy < mapy THEN Trgty = posy + 6
  IF key$ = "4" AND posx > -7 THEN Trgtx = posx + 6
  IF key$ = "6" AND posx < mapx - 6 THEN Trgtx = posx + 8
  'LOCATE 1, 1: PRINT key$; "Pos:"; posx; posy; "Target:"; Trgtx; Trgty
  
  IF MID$(maps(Trgtx, Trgty), 2, 1) <> "X" THEN pass = TRUE
  NPCVal = ASC(MID$(maps(Trgtx, Trgty), 2, 1)) - 97
  IF NPCVal > -1 AND NPCVal < 21 THEN pass = FALSE: CALL DoNPC(NPCVal)

    LoopDone = FALSE
    IF MID$(maps(Trgtx, Trgty), 1, 1) = "d" THEN map(Trgtx, Trgty) = 5
    'PRINT CurMap$; MID$(maps(Trgtx, Trgty), 1, 1)
   
    IF CurMap$ = "alan4" AND LoopDone = FALSE THEN
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "q" THEN
        FadeToBlack (TRUE): CALL LoadFile("twnhall")
        posx = -1: posy = 6: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "w" THEN
        FadeToBlack (TRUE): CALL LoadFile("twnhall")
        posx = 0: posy = 6: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "r" THEN
        FadeToBlack (TRUE): CALL LoadFile("twnhall2")
        posx = 3: posy = -3: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "c" THEN
        CALL ScreenFade(63, TRUE): CALL LoadFile("wmkazeel")
        posx = 3: posy = 12: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      LoopDone = TRUE
    END IF
   
    IF CurMap$ = "alan3" AND LoopDone = FALSE THEN
      'IF MID$(maps(Trgtx, Trgty), 1, 1) = "i" THEN
      '  FadeToBlack (TRUE): CALL LoadFile("twnhall2")
      '  Posx = 3: Posy = -3: ScreenRefresh: CALL ScreenFade(63, FALSE)
      '  pass = FALSE
      'END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "c" THEN
        CALL ScreenFade(63, TRUE): CALL LoadFile("wmkazeel")
        posx = 3: posy = -2: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      LoopDone = TRUE
    END IF

    IF CurMap$ = "ruins" AND LoopDone = FALSE THEN
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "c" THEN
        CALL FadeToBlack(TRUE): CALL LoadFile("field")
        posx = 14: posy = 37: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      LoopDone = TRUE
    END IF
  

    IF CurMap$ = "twnhall" AND LoopDone = FALSE THEN
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "q" THEN
        FadeToBlack (TRUE): CALL LoadFile("alan4")
        posx = 11: posy = 11: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "w" THEN
        FadeToBlack (TRUE): CALL LoadFile("alan4")
        posx = 12: posy = 11: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "r" THEN
        FadeToBlack (TRUE): CALL LoadFile("twnhall2")
        posx = 0: posy = -3: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      LoopDone = TRUE
    END IF

    IF CurMap$ = "wmkazeel" AND LoopDone = FALSE THEN
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "a" THEN
        CALL ScreenFade(63, TRUE): CALL LoadFile("alan3")
        CALL ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "b" THEN
        CALL ScreenFade(63, TRUE): CALL LoadFile("field")
        CALL ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "c" THEN
        CALL ScreenFade(63, TRUE): CALL LoadFile("alan4")
        CALL ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      LoopDone = TRUE
    END IF

    IF CurMap$ = "field" AND LoopDone = FALSE THEN
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "c" THEN
        CALL ScreenFade(63, TRUE): CALL LoadFile("wmkazeel")
        posx = 13: posy = 26: CALL ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "b" THEN
        CALL FadeToBlack(TRUE): CALL LoadFile("ruins")
        CALL ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      'IF MID$(maps(Trgtx, Trgty), 1, 1) = "r" THEN
      '  CALL ScreenFade(63, TRUE): CALL LoadFile("twnhall")
      '  Posx = 3: Posy = -3: ScreenRefresh: CALL ScreenFade(63, FALSE)
      '  pass = FALSE
      'END IF
      LoopDone = TRUE
    END IF


   
    IF CurMap$ = "twnhall2" AND LoopDone = FALSE THEN
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "r" THEN
        'CALL SmallDialog("No time for beer now!")
        CALL TextBox("Come on!  You don't have time to be drinking!  You're trying to save the world, remember?", "", FALSE, TRUE, 1)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "b" THEN
        CALL SmallDialog("It's full of beer!")
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "q" THEN
        FadeToBlack (TRUE): CALL LoadFile("twnhall")
        posx = 0: posy = -3: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF
      IF MID$(maps(Trgtx, Trgty), 1, 1) = "w" THEN
        FadeToBlack (TRUE): CALL LoadFile("alan4")
        posx = 13: posy = 6: ScreenRefresh: CALL ScreenFade(63, FALSE)
        pass = FALSE
      END IF

      LoopDone = TRUE
    END IF
   
   
    IF pass = TRUE THEN posx = Trgtx - 7: posy = Trgty - 5

  'END IF
 
  IF MID$(maps(Trgtx, Trgty), 1, 1) = "l" THEN SmallDialog ("It's locked.")
  IF MID$(maps(Trgtx, Trgty), 1, 1) = "e" THEN SmallDialog ("It's empty.")
  'PRINT maps(Trgtx, Trgty)
  'SLEEP
END SUB

'The name is decieving.  This sub actually puts the hero sprite on the screen
'   *x*,*y*: Location to put hero on the screen.  Multiplied by 20.
'   *pic*: Which frame to use.
SUB PutNPC (x, y, pic)

FOR yy = 1 TO 20
  FOR xx = 1 TO 20
    IF Hero(pic, xx, yy) > 0 THEN PSET (x * 20 + xx - 1, y * 20 + yy - 1), Hero(pic, xx, yy)
  NEXT xx
NEXT yy

END SUB

'This displays an NPC to the screen (unlike the incorrectly named PutNPC sub)
'   *x*,*y*: Location to put hero on the screen.  Multiplied by 20.
'   *pic*: Which NPC picture to use.
SUB PutRealNPC (x, y, pic)

FOR yy = 1 TO 20
  FOR xx = 1 TO 20
    IF NPCPicData(pic, xx, yy) > 0 THEN PSET (x * 20 + xx - 1, y * 20 + yy - 1), NPCPicData(pic, xx, yy)
  NEXT xx
NEXT yy


END SUB

'Makes sure the user wants to quit.
'   *CanQuit*: Returns whether the user opted to quit or not.
SUB QuitConfirm (CanQuit)
  CONST TRUE = 1
  CONST FALSE = 0

  CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)
  CALL BoxAnimate(50, 82, 253, 118, 1, 5)
  COLOR 15: LOCATE 12, 9:            PRINT "Sure you want to quit?"

  MenuItems$(0) = "Yes": MenuPosY(0) = 14: MenuPosX(0) = 12
  MenuItems$(1) = "Maybe": MenuPosY(1) = 14: MenuPosX(1) = 18
  MenuItems$(2) = "No": MenuPosY(2) = 14: MenuPosX(2) = 26
  MenuItems = 2: MenuKeys = LEFTRIGHT: MenuHintsToggle = FALSE
  CALL Menu(mnReturn)
  a$ = INKEY$
  IF mnReturn = 1 THEN CanQuit = FALSE: LOCATE 12, 9: PRINT " Okay, think it over  ": SLEEP
  IF mnReturn = 0 THEN CanQuit = TRUE
  IF mnReturn = 2 THEN CanQuit = FALSE
END SUB

'Sets all colors to the colors stored in StdPal
'   *ResetPal*: Whether or not to set the Pal colors to the StdPal ones.
SUB RealizeStandardPalette (ResetPal)

CALL ClrCycl(254, BkgClr.r, BkgClr.g, BkgClr.b)
CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)

FOR i = 1 TO 200
  CALL ClrCycl(i, StdPal(i).r, StdPal(i).g, StdPal(i).b)
NEXT i

IF ResetPal = TRUE THEN
FOR i = 1 TO 200
   Pal(i).r = StdPal(i).r
   Pal(i).g = StdPal(i).g
   Pal(i).b = StdPal(i).b
NEXT i
END IF

END SUB

'This fades the screen to black and fades it back to the standard palette
'   *Loops*: How much to fade the screen by.  63 is a complete fade.
'   *Darken*: If TRUE then fade to black, otherwise fades in from black.
SUB ScreenFade (Loops, Darken)


'I tried to put this all into one sub.  Sorry about the size, but I wanted
' the different options.

IF Darken = FALSE THEN Loops = Loops * -1: incr = -1
IF Darken = TRUE THEN incr = 1

FOR main = 1 TO Loops STEP incr

IF Darken = TRUE THEN
    FOR i = 1 TO 200
      IF Pal(i).r > 0 THEN Pal(i).r = Pal(i).r - 1
      IF Pal(i).g > 0 THEN Pal(i).g = Pal(i).g - 1
      IF Pal(i).b > 0 THEN Pal(i).b = Pal(i).b - 1
      CALL ClrCycl(i, Pal(i).r, Pal(i).g, Pal(i).b)
    NEXT i
  ELSE
    'LOCATE 1, 1: PRINT Main; Loops; Darken; Target
    FOR i = 1 TO 200
      IF Pal(i).r < StdPal(i).r AND 63 + main < StdPal(i).r THEN Pal(i).r = Pal(i).r + 1
      IF Pal(i).g < StdPal(i).g AND 63 + main < StdPal(i).g THEN Pal(i).g = Pal(i).g + 1
      IF Pal(i).b < StdPal(i).b AND 63 + main < StdPal(i).b THEN Pal(i).b = Pal(i).b + 1
      CALL ClrCycl(i, Pal(i).r, Pal(i).g, Pal(i).b)
    NEXT i
  END IF
  IF main MOD 5 = 0 THEN CALL WaitSecs(.005)
  NEXT main

END SUB

' Updates the screen
SUB ScreenRefresh
 
  FOR y = 0 TO 9
    FOR x = 0 TO 15
      CALL dispbox(x, y)
  NEXT x, y

END SUB

'Displays a small, centered box with a single line of text.
'   *msg$*: Text to display
SUB SmallDialog (msg$)
  CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)
  CALL Box(152 - LEN(msg$) * 4, 90, 168 + LEN(msg$) * 4, 110, 1)
  COLOR 15: LOCATE 13, 21 - LEN(msg$) / 2: PRINT msg$
  SLEEP
END SUB

'This is the screen which saves and loads files.  One of the most complicated
' subs.
SUB StatusFileScreen
DIM SlotExist(20)
CLS
COLOR 254
FILES "slot??.sav"

Done = FALSE: row = 2
WHILE Done = FALSE
  IF CHR$(SCREEN(row, 1)) = "S" THEN
    SlotExist(VAL(CHR$(SCREEN(row, 5)) + CHR$(SCREEN(row, 6)))) = TRUE
  ELSE Done = TRUE
  END IF
  IF CHR$(SCREEN(row, 19)) = "S" THEN
    SlotExist(VAL(CHR$(SCREEN(row, 23)) + CHR$(SCREEN(row, 24)))) = TRUE
  ELSE Done = TRUE
  END IF
  row = row + 1
WEND
CLS
COLOR 15: TopSlot = 0

  CALL BoxAnimate(2, 2, 318, 32, 1, 5)
  LOCATE 1, 4: PRINT "FILES"
  COLOR 7
  LOCATE 3, 3: PRINT "SAVE"
  LOCATE 3, 9: PRINT "LOAD"
  LOCATE 3, 15: PRINT "DELETE"
  LOCATE 3, 28: PRINT "BACK TO MENU"
  CALL BoxAnimate(2, 32, 318, 198, 1, 9)
  CALL BoxAnimate(5, 35, 315, 83, 1, 9) '48!!
  CALL BoxAnimate(5, 83, 315, 131, 1, 9) '48!!
  CALL BoxAnimate(5, 131, 315, 179, 1, 9) '48!!
  CALL BoxAnimate(5, 180, 148, 195, 1, 3)
  CALL BoxAnimate(148, 180, 315, 195, 1, 3)
'  FOR i = 1 TO 24: LOCATE i, 1: PRINT i; : NEXT i
StatusFileMenu:
  IF ReturnToMain = TRUE THEN CLS : GOTO FileSubEnd
  CALL Box(2, 32, 318, 198, 1)
  CALL Box(5, 35, 315, 83, 1) '48!!
  CALL Box(5, 83, 315, 131, 1) '48!!
  CALL Box(5, 131, 315, 179, 1) '48!!
  CALL Box(5, 180, 148, 195, 1)
  CALL Box(148, 180, 315, 195, 1)

  COLOR 7
  MenuItems$(0) = "SAVE": MenuPosY(0) = 3: MenuPosX(0) = 3:          MenuHints$(0) = "Save game to a slot"
  MenuItems$(1) = "LOAD": MenuPosY(1) = 3: MenuPosX(1) = 9:          MenuHints$(1) = "Load a saved game  "
  MenuItems$(2) = "DELETE": MenuPosY(2) = 3: MenuPosX(2) = 15:       MenuHints$(2) = "Delete an old game "
  MenuItems$(3) = "BACK TO MENU": MenuPosY(3) = 3: MenuPosX(3) = 28: MenuHints$(3) = "Return to main menu"
  MenuItems = 3: MenuKeys = LEFTRIGHT: MenuHinty = 24: MenuHintx = 20: MenuHintsToggle = TRUE

  CALL Menu(mnReturn)
  MenuHintsToggle = FALSE

  IF mnReturn < 3 THEN
    IF mnReturn = 0 THEN LOCATE 24, 2: PRINT "Save to where?  ";
    IF mnReturn = 1 THEN LOCATE 24, 2: PRINT "Load which slot?";
    IF mnReturn = 2 THEN LOCATE 24, 2: PRINT "Del which slot? ";
    
    SelSlot = TopSlot + 1
  a$ = "": j = 53: Dir = 0
  WHILE a$ <> CHR$(27)
    CALL Box(5, 35, 315, 83, 1) '48!!
    CALL Box(5, 83, 315, 131, 1) '48!!
    CALL Box(5, 131, 315, 179, 1) '48!!
    FOR i = 1 TO 3
      COLOR 4: LOCATE i * 6, 2: PRINT " Slot"; TopSlot + i;
      IF SlotExist(TopSlot + i) = TRUE THEN
        IF TopSlot + i < 10 THEN
          OPEN ExtractSpcs$("SLOT0" + STR$(TopSlot + i) + ".SAV") FOR INPUT AS #1
        ELSE
          OPEN ExtractSpcs$("SLOT" + STR$(TopSlot + i) + ".SAV") FOR INPUT AS #1
        END IF
        INPUT #1, txt$
        INPUT #1, Loc$
        INPUT #1, dummy$
        INPUT #1, dummy
        INPUT #1, dummy
       
        INPUT #1, r: INPUT #1, g: INPUT #1, b
        INPUT #1, txtclrsav
       
        CALL ClrCycl(200 + i * 2, r, g, b)
        CALL ClrCycl(201 + i * 2, txtclrsav, txtclrsav, txtclrsav)
        PAINT (20, 48 * i), 200 + i * 2, 31
        COLOR 4: LOCATE i * 6, 2: PRINT " Slot"; TopSlot + i;
        COLOR 201 + i * 2: PRINT "'"; txt$; "'"
        LOCATE 6 * i + 4, 3: PRINT Loc$
       
        CLOSE #1
      END IF
      IF SlotExist(TopSlot + i) = FALSE THEN LOCATE i * 6 + 2, 6: PRINT "EMPTY"
      'PRINT i; topslot; topslot + i; SlotExist(topslot + i)
    NEXT i
    LOCATE (SelSlot - TopSlot) * 6, 2: COLOR 255: PRINT ">"
    a$ = INKEY$: a$ = ""
    WHILE a$ = ""
      IF j = 63 THEN Dir = 0
      IF j = 5 THEN Dir = 1
      IF j < 63 AND Dir = 1 THEN j = j + 1
      IF j > 5 AND Dir = 0 THEN j = j - 1
      CALL ClrCycl(255, j, j, j)
      IF j MOD 3 = 0 THEN CALL WaitSecs(.005)
      a$ = INKEY$
    WEND
    IF a$ = "8" AND SelSlot - 1 > TopSlot THEN
      SelSlot = SelSlot - 1
    ELSE IF a$ = "8" AND SelSlot - 2 < TopSlot AND TopSlot > 0 THEN TopSlot = TopSlot - 1: SelSlot = SelSlot - 1
    END IF
    IF a$ = "2" AND SelSlot + 1 < TopSlot + 4 THEN
      SelSlot = SelSlot + 1
    ELSE IF a$ = "2" AND SelSlot + 2 > TopSlot + 4 AND TopSlot < 17 THEN TopSlot = TopSlot + 1: SelSlot = SelSlot + 1
    END IF
    IF a$ = " " THEN
      IF TopSlot + SelSlot < 10 THEN
        FileName$ = ExtractSpcs$("SLOT0" + STR$(SelSlot) + ".SAV")
      ELSE FileName$ = ExtractSpcs$("SLOT" + STR$(SelSlot) + ".SAV")
      END IF
      IF mnReturn = 0 THEN
        SlotExist(SelSlot) = TRUE
        CALL Box(2, 2, 318, 32, 1): LOCATE 1, 4: COLOR 15: PRINT "FILES"
        COLOR 15: LOCATE 3, 2: INPUT "Enter a name for save:", NameSave$
        CALL Box(2, 2, 318, 32, 1): LOCATE 1, 4: COLOR 15: PRINT "FILES"
        COLOR 4: LOCATE 3, 2:  PRINT "Saving to"; FileName$
        OPEN FileName$ FOR OUTPUT AS #1
          WRITE #1, NameSave$
          WRITE #1, CurLoc$
          WRITE #1, CurMap$
          WRITE #1, posx
          WRITE #1, posy
          WRITE #1, BkgClr.r: WRITE #1, BkgClr.g: WRITE #1, BkgClr.b
          WRITE #1, StdPal(15).r
          WRITE #1, INT(TIMER - StartTime)
          FOR Saving = 1 TO 4
            WRITE #1, Party(Saving).Str
            WRITE #1, Party(Saving).Dfn
            WRITE #1, Party(Saving).Mag
            WRITE #1, Party(Saving).Blf
            WRITE #1, Party(Saving).Agl
            WRITE #1, Party(Saving).Dex
            WRITE #1, Party(Saving).Chem
            WRITE #1, Party(Saving).HP
            WRITE #1, Party(Saving).MaxHP
            WRITE #1, Party(Saving).MP
            WRITE #1, Party(Saving).MaxMP
            WRITE #1, Party(Saving).CharName
            WRITE #1, Party(Saving).Xp
            WRITE #1, Party(Saving).Lvl
            WRITE #1, Party(Saving).Status
            WRITE #1, Party(Saving).Tags
            WRITE #1, Party(Saving).InParty
          NEXT Saving
          FOR Saving = 1 TO 10
            WRITE #1, Quests(Saving)
          NEXT Saving
        CLOSE #1
        CALL Box(2, 2, 318, 32, 1): LOCATE 1, 4: COLOR 15: PRINT "FILES"
      END IF
      IF mnReturn = 1 THEN
        OPEN FileName$ FOR INPUT AS #1
          INPUT #1, NameSave$
          INPUT #1, CurLoc$
          INPUT #1, NewMap$
          INPUT #1, NewPosx
          INPUT #1, NewPosy
          INPUT #1, BkgClr.r
          INPUT #1, BkgClr.g
          INPUT #1, BkgClr.b
          INPUT #1, TxtClr
          INPUT #1, ElapsedTime
          StartTime = TIMER - ElapsedTime
          FOR Saving = 1 TO 4
            INPUT #1, Party(Saving).Str
            INPUT #1, Party(Saving).Dfn
            INPUT #1, Party(Saving).Mag
            INPUT #1, Party(Saving).Blf
            INPUT #1, Party(Saving).Agl
            INPUT #1, Party(Saving).Dex
            INPUT #1, Party(Saving).Chem
            INPUT #1, Party(Saving).HP
            INPUT #1, Party(Saving).MaxHP
            INPUT #1, Party(Saving).MP
            INPUT #1, Party(Saving).MaxMP
            INPUT #1, Party(Saving).CharName
            INPUT #1, Party(Saving).Xp
            INPUT #1, Party(Saving).Lvl
            INPUT #1, Party(Saving).Status
            INPUT #1, Party(Saving).Tags
            INPUT #1, Party(Saving).InParty
          NEXT Saving
          FOR Saving = 1 TO 10
            INPUT #1, Quests(Saving)
          NEXT Saving
        CLOSE #1
        a$ = CHR$(27)
        CLS : CALL FadeToBlack(FALSE)
        CALL LoadFile(NewMap$)
        CALL RealizeStandardPalette(TRUE)
        posx = NewPosx: posy = NewPosy
        CALL ClrCycl(254, BkgClr.r, BkgClr.g, BkgClr.b)
        CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)
        CALL ClrCycl(15, TxtClr, TxtClr, TxtClr)
        StdPal(15).r = TxtClr: StdPal(15).g = TxtClr: StdPal(15).b = TxtClr
        Pal(15).r = TxtClr: Pal(15).g = TxtClr: Pal(15).b = TxtClr
        ReturnToMain = TRUE
      END IF
      IF mnReturn = 2 THEN
        KILL FileName$
        SlotExist(SelSlot) = FALSE
      END IF
    END IF
  WEND
    GOTO StatusFileMenu
  END IF

FileSubEnd:

END SUB

'This will eventually be an item screen.  It does provide a good example of
' the menu sub.
SUB StatusItemScreen


COLOR 15
  CALL BoxAnimate(2, 2, 318, 32, 1, 5)
  LOCATE 1, 4: PRINT "ITEMS"
  COLOR 7
  LOCATE 3, 3: PRINT "USE"
  LOCATE 3, 8: PRINT "SORT"
  LOCATE 3, 14: PRINT "DISCARD"
  LOCATE 3, 28: PRINT "BACK TO MENU"
  CALL BoxAnimate(2, 32, 318, 198, 1, 9)
  CALL BoxAnimate(148, 180, 315, 195, 1, 3)
 
  MenuItems$(0) = "USE": MenuPosY(0) = 3: MenuPosX(0) = 3:           MenuHints$(0) = "Utilize an item    "
  MenuItems$(1) = "SORT": MenuPosY(1) = 3: MenuPosX(1) = 8:          MenuHints$(1) = "Sort the items     "
  MenuItems$(2) = "DISCARD": MenuPosY(2) = 3: MenuPosX(2) = 14:      MenuHints$(2) = "Get rid of an item "
  MenuItems$(3) = "BACK TO MENU": MenuPosY(3) = 3: MenuPosX(3) = 28: MenuHints$(3) = "Return to main menu"
  MenuItems = 3: MenuKeys = LEFTRIGHT: MenuHinty = 24: MenuHintx = 20: MenuHintsToggle = TRUE
 
  CALL Menu(mnReturn)

  MneuHintsToggle = FALSE
CALL ClrCycl(255, 63, 63, 63)

LOCATE 9, 4: PRINT mnReturn

  SLEEP

END SUB

'This will allow the player to view and cast spells eventually.
SUB StatusMagicScreen

COLOR 15
  CALL BoxAnimate(2, 2, 318, 32, 1, 5)
  LOCATE 1, 4: PRINT "MAGIC"
  COLOR 7
  LOCATE 3, 3: PRINT "CAST"
  LOCATE 3, 9: PRINT "HERO"
  LOCATE 3, 15: PRINT "LEARN"
  LOCATE 3, 28: PRINT "BACK TO MENU"

  CALL BoxAnimate(2, 32, 50, 198, 1, 7)

  CALL PutNPC(1, 2, 1)
  CALL PutNPC(1, 4, 1)
  CALL PutNPC(1, 6, 1)
  CALL PutNPC(1, 8, 1)

  CALL BoxAnimate(50, 32, 318, 198, 1, 9)
  CALL BoxAnimate(148, 180, 315, 195, 1, 3)


  MenuItems$(0) = "CAST": MenuPosY(0) = 3: MenuPosX(0) = 3:          MenuHints$(0) = "Cast a spell       "
  MenuItems$(1) = "HERO": MenuPosY(1) = 3: MenuPosX(1) = 9:          MenuHints$(1) = "Select the hero    "
  MenuItems$(2) = "LEARN": MenuPosY(2) = 3: MenuPosX(2) = 15:        MenuHints$(2) = "Learn a new spell  "
  MenuItems$(3) = "BACK TO MENU": MenuPosY(3) = 3: MenuPosX(3) = 28: MenuHints$(3) = "Return to main menu"
  MenuHintsToggle = TRUE: MenuItems = 3: MenuKeys = LEFTRIGHT: MenuHinty = 24: MenuHintx = 20
 
  CALL Menu(mnReturn)

  MenuHintsToggle = FALSE
  SLEEP


END SUB

'This is the game's status menu.  All sub-menus are still under construction.
' The blank space between OPTIONS and FILE may be filled in with another menu.
SUB StatusMenu

CALL RealizeStandardPalette(FALSE)
Animate = 1

Start:
CLS
COLOR 15
CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)
i = i MOD 63

'FOR i = 1 TO 318 STEP 9
'  IF i > 198 THEN ix = 198 ELSE ix = i
'  CALL box(2, 2, i, ix, 1)
'NEXT i
CALL Box(2, 2, 318, 198, 1)
LOCATE 1, 4: PRINT "Menu"

FOR i = 1 TO 4
LOCATE i * 5 - 2, 10: PRINT ExtractSpcs$(Party(i).CharName)
LOCATE i * 5 - 1, 10: PRINT "HP "; ExtractSpcs$(STR$(Party(i).HP) + "/" + STR$(Party(i).MaxHP))
LOCATE i * 5, 10: PRINT "MP "; ExtractSpcs$(STR$(Party(i).MP) + "/" + STR$(Party(i).MaxMP))
LOCATE i * 5 + 1, 10: PRINT "Wizard"
NEXT i


CALL PutNPC(2, 1, 1)
CALL PutNPC(2, 3, 2)
CALL PutNPC(2, 5, 1)
CALL PutNPC(2, 7, 2)

IF Animate = 1 THEN CALL BoxAnimate(240, 5, 315, 140, 1, 3) ELSE CALL Box(240, 5, 315, 140, 1)

LOCATE 3, 33: PRINT "ITEMS"
LOCATE 5, 33: PRINT "MAGIC"
LOCATE 7, 33: PRINT "EQUIP"
LOCATE 9, 33: PRINT "ORDER"
LOCATE 11, 33: PRINT "STATUS"
LOCATE 13, 33: PRINT "OPTION"
LOCATE 17, 33: PRINT "FILE"

'FOR i = 1 TO 115 STEP 2
'  IF i > 40 THEN ix = 180 ELSE ix = i + 140
'  CALL Box(200, 140, 200 + i, ix, 1)
'NEXT i
IF Animate = 1 THEN CALL BoxAnimate(200, 140, 315, 180, 1, 2) ELSE CALL Box(200, 140, 315, 180, 1)

'a$ = ""
tim$ = ""
CALL DoTime(tim$)
LOCATE 20, 27: PRINT "TIME:" + tim$
LOCATE 22, 28: PRINT USING "######## GIL"; gp

CALL Box(115, 170, 194, 183, 1)
IF Animate = 1 THEN CALL BoxAnimate(100, 180, 315, 195, 1, 3) ELSE CALL Box(100, 180, 315, 195, 1)

PSET (116, 180), 29 'Clean up the Location tab
PSET (117, 180), 31: PSET (117, 181), 31: PSET (117, 182), 254
PSET (193, 180), 29
PSET (192, 180), 31: PSET (192, 181), 31: PSET (192, 182), 254
LINE (118, 180)-(120, 182), 254, BF
LOCATE 23, 16: PRINT "Location:";
LOCATE 24, 14: PRINT CurLoc$;

LOCATE 3 + Curs * 2, 32: COLOR 255: PRINT ""
COLOR 15

KeyLoop:
MaxCycl = 61
a$ = "":  Dir = 0: i = MaxCycl
WHILE a$ = ""
  tim$ = "": CALL DoTime(tim$)
  LOCATE 20, 27: PRINT "TIME:" + tim$
  a$ = INKEY$
  'IF INT(TIMER) > tmSecs THEN
     IF i < MaxCycl AND Dir = 1 THEN i = i + 1
     IF i = MaxCycl THEN Dir = 0
     IF i > 5 AND Dir = 0 THEN i = i - 1
     IF i = 5 THEN Dir = 1
     CALL ClrCycl(255, i, i, i)
     'tmSecs = INT(TIMER)
     'i = ABS(i - 1)
  'END IF
WEND

IF a$ = "8" AND Curs > 0 THEN LOCATE 3 + Curs * 2, 32: PRINT " ": Curs = Curs - 1: LOCATE 3 + Curs * 2, 32: COLOR 255: PRINT "": COLOR 15: GOTO KeyLoop
IF a$ = "2" AND Curs < 7 THEN LOCATE 3 + Curs * 2, 32: PRINT " ": Curs = Curs + 1: LOCATE 3 + Curs * 2, 32: COLOR 255: PRINT "": COLOR 15: GOTO KeyLoop
IF a$ = " " THEN
  SELECT CASE Curs
    CASE 0: CALL StatusItemScreen
    CASE 1: CALL StatusMagicScreen
    'CASE 2: CALL StatusEquipScreen
    CASE 3: CALL StatusOrderScreen
    'CASE 4: CALL StatusStatusScreen
    CASE 5: CALL StatusOptionScreen
    CASE 7: CALL StatusFileScreen
  END SELECT
  IF ReturnToMain = FALSE THEN a$ = INKEY$: Animate = 0: GOTO Start ELSE a$ = CHR$(27)
END IF
IF a$ <> CHR$(27) THEN GOTO KeyLoop
ScreenRefresh
ReturnToMain = FALSE
'CLS
END SUB

' Battle options.
SUB StatusOptionBattle

END SUB

' This menu lets you set the game's colors.
SUB StatusOptionColors
 
 CALL BoxAnimate(154, 9, 311, 96, 1, 4)
 cr = 0
 LOCATE 2, 22: PRINT "Color Adjust"
 COLOR 14: LOCATE 4, 22: PRINT "Background color"
 LOCATE 5, 23: COLOR 255: PRINT ""; : COLOR 15: PRINT "R:"; BkgClr.r
 LOCATE 6, 24:  PRINT "G:"; BkgClr.g
 LOCATE 7, 24:  PRINT "B:"; BkgClr.b
 COLOR 14: LOCATE 9, 22: PRINT "Text Color"
 COLOR 15: LOCATE 10, 23: PRINT "Normal Text:"; TextClr


WHILE a$ <> CHR$(27)
MaxCycl = 63
a$ = "": Dir = 0: i = MaxCycl
WHILE a$ = ""
  a$ = INKEY$
     IF i < MaxCycl AND Dir = 1 THEN i = i + 1
     IF i = MaxCycl THEN Dir = 0
     IF i > 20 AND Dir = 0 THEN i = i - 1
     IF i = 20 THEN Dir = 1
     CALL ClrCycl(255, i, i, i)
     IF i MOD 2 = 0 THEN CALL WaitSecs(.005)
WEND

IF a$ = "8" AND cr = 3 THEN LOCATE 10, 22: PRINT " "
IF a$ = "8" AND cr > 0 THEN LOCATE 5 + cr, 23: PRINT " ": cr = cr - 1: LOCATE 5 + cr, 23: COLOR 255: PRINT "": COLOR 15
IF a$ = "2" AND cr > 1 AND cr < 3 THEN LOCATE 7, 23: PRINT " ": cr = cr + 1: LOCATE 10, 22: COLOR 255: PRINT "": COLOR 15
IF a$ = "2" AND cr < 2 THEN LOCATE 5 + cr, 23: PRINT " ": cr = cr + 1: LOCATE 5 + cr, 23: COLOR 255: PRINT "": COLOR 15


IF a$ = "4" OR a$ = "6" THEN
  SELECT CASE cr
    CASE 0:
      IF BkgClr.r > 0 AND a$ = "4" THEN BkgClr.r = BkgClr.r - 1
      IF BkgClr.r < 63 AND a$ = "6" THEN BkgClr.r = BkgClr.r + 1
      LOCATE 5, 24:  PRINT "R:"; BkgClr.r
    CASE 1:
      IF BkgClr.g > 0 AND a$ = "4" THEN BkgClr.g = BkgClr.g - 1
      IF BkgClr.g < 63 AND a$ = "6" THEN BkgClr.g = BkgClr.g + 1
      LOCATE 6, 24:  PRINT "G:"; BkgClr.g
    CASE 2:
      IF BkgClr.b > 0 AND a$ = "4" THEN BkgClr.b = BkgClr.b - 1
      IF BkgClr.b < 63 AND a$ = "6" THEN BkgClr.b = BkgClr.b + 1
      LOCATE 7, 24:  PRINT "B:"; BkgClr.b
    CASE 3:
      IF TextClr > 0 AND a$ = "4" THEN TextClr = TextClr - 1
      IF TextClr < 63 AND a$ = "6" THEN TextClr = TextClr + 1
      LOCATE 10, 23:  PRINT "Normal Text:"; TextClr
  END SELECT
  CALL ClrCycl(254, BkgClr.r, BkgClr.g, BkgClr.b)
  CALL ClrCycl(0, BkgClr.r, BkgClr.g, BkgClr.b)
  CALL ClrCycl(15, TextClr, TextClr, TextClr)
  StdPal(15).r = TxtClr: StdPal(15).g = TxtClr: StdPal(15).b = TxtClr
  Pal(15).r = TxtClr: Pal(15).g = TxtClr: Pal(15).b = TxtClr
END IF

WEND

a$ = ""

END SUB

'Lets you set various options.  Not really much in this sub.
SUB StatusOptionScreen

COLOR 15
  CALL BoxAnimate(2, 2, 148, 198, 1, 9)
   LOCATE 1, 4: PRINT "OPTIONS"
  CALL BoxAnimate(148, 2, 318, 198, 1, 9)
  CALL BoxAnimate(151, 180, 315, 195, 1, 3)
OptionScreenLoop:
 MenuItems$(0) = "Set Colors": MenuPosY(0) = 3: MenuPosX(0) = 3:     MenuHints$(0) = "Adjust Game Colors"
  MenuItems$(1) = "Set Speed": MenuPosY(1) = 5: MenuPosX(1) = 3:     MenuHints$(1) = "Adjust Game Speeds"
  MenuItems$(2) = "Battle Config": MenuPosY(2) = 7: MenuPosX(2) = 3: MenuHints$(2) = "Battle Options    "
  MenuItems$(3) = "BACK TO MENU": MenuPosY(3) = 22: MenuPosX(3) = 3: MenuHints$(3) = "Return to Menu    "
  MenuHinty = 24: MenuHintx = 21: MenuItems = 3: MenuKeys = UPDOWN: MenuHintsToggle = TRUE: MenuCancel = 3
 
  CALL Menu(mnReturn)
  MenuHintsToggle = FALSE
  IF mnReturn = 0 THEN CALL StatusOptionColors: GOTO OptionScreenLoop
  IF mnReturn = 1 THEN CALL StatusOptionSpeed: GOTO OptionScreenLoop
  IF mnReturn = 2 THEN CALL StatusOptionBattle: GOTO OptionScreenLoop


END SUB

'Will eventually contain various speed options.
SUB StatusOptionSpeed

END SUB

'This actually isn't a sub menu.  It will allow the player to re-arrange
' the members of the party.
SUB StatusOrderScreen

  MenuItems$(0) = "": MenuPosY(0) = 4: MenuPosX(0) = 6
  MenuItems$(1) = "": MenuPosY(1) = 9: MenuPosX(1) = 6
  MenuItems$(2) = "": MenuPosY(2) = 14: MenuPosX(2) = 6
  MenuItems$(3) = "": MenuPosY(3) = 19: MenuPosX(3) = 6
  MenuItems = 3: MenuKeys = UPDOWN

  CALL Menu(mnReturn)
  OldSpot = mnReturn

END SUB

'This nifty sub displays a text box with text.  It automactly wraps words
' so that they are not split on the screen.  It also replaces '^' with ','
' and /n with the name of the main character
'   *Txt$*: Text to display.  Sub automaticaly fits it to box.
'   *Speaker$*: If it's not "", displays name at the top of the box (like FF7)
'   *TopOfScreen*: if TRUE, box is displayed at top of screen (opposed to bottom)
'   *Animate*: Whether to call BoxAnimate or Box
'   *Style*: Style of box (for future expansion)
SUB TextBox (txt$, Speaker$, TopOfScreen, Animate, Style)
DIM lines$(8)
MAXLENGTH = 38
i = 1
CurLine = 1

WHILE i < LEN(txt$)
  WHILE Char$ <> " " AND i < LEN(txt$) + 1
    Char$ = MID$(txt$, i, 1)
    IF Char$ = "^" THEN Char$ = ","
    IF Char$ <> " " THEN word$ = word$ + Char$
    IF Char$ = "/" AND MID$(txt$, i + 1, 1) = "n" THEN
      word$ = ExtractSpcs$(Party(1).CharName)
      i = i + 1
    END IF
    i = i + 1
  WEND

  IF LEN(lines$(CurLine)) + LEN(word$) + 1 < MAXLENGTH THEN
    lines$(CurLine) = lines$(CurLine) + " " + word$
  ELSE
    IF LEN(lines$(CurLine)) + LEN(word$) + 1 > MAXLENGTH THEN
      CurLine = CurLine + 1
      lines$(CurLine) = lines$(CurLine) + " " + word$
    END IF
  END IF
  word$ = "": Char$ = ""
WEND
  IF Speaker$ <> "" THEN CurLine = CurLine + 1
  IF TopOfScreen = TRUE THEN
    Start = 2
    IF Animate = TRUE THEN CALL BoxAnimate(2, 2, 318, 12 + CurLine * 8, Style, 2) ELSE CALL Box(2, 2, 318, 10 + CurLine * 9, Style)
  ELSE
    Start = 19
    IF Animate = TRUE THEN CALL BoxAnimate(2, 140, 318, 140 + CurLine * 8, Style, 2) ELSE CALL Box(2, 140, 318, 140 + CurLine * 9, Style)
  END IF

  IF Speaker$ <> "" THEN LOCATE Start, 2: PRINT Speaker$; ":": Start = Start + 1
 
  FOR i = 0 TO 4
    'LOCATE i + Start, 20 - LEN(lines$(i + 1)) / 2: PRINT lines$(i + 1)
    LOCATE i + Start, 2: PRINT lines$(i + 1)
  NEXT i

SLEEP: ScreenRefresh


END SUB

SUB TitleScreen

SCREEN 7, 0, 1, 0
'e$ = "c4 r18e2d8h2l10g2d6f2r10e2d8h2l10g2d6f2r10e2d8h2l18e2u28h2 bf4 p4,4 bh4 B m+22,+2 "
e$ = "r18e2d8h2l10g2d6f2r10e2d8h2l10g2d6f2r10e2d8h2l18e2u28h2 Bm+22,+2 "
t$ = "m+18,+4 m-2,+6 u2 m-6,-2 d20f4l12e4u20 m-6,-2 g2 m+2,-6 B m+18,+10"
le$ = "r12d6h2l4d4r4d4l4d4r4e2d6l12e2u16h2 Br14"
r$ = "r10 m+6,+6 m-6,+6 f8l8e2h6d6f2l8e2u16h2 Bm+6,+4 r4f2g2l4u4 Bm+14,-4"
n$ = "R6 M+8,+14 U14R6G2D18L4 M-8,-14 D14L6E2U16H2 BR22"
i$ = "R16D6H2L4D12R4E2D6L16U6F2R4U12L4G2U6 BR20"
lt$ = "R16D6H2L4D14F2L8E2U14L4G2U6 BR18"
y$ = "R4F6E6R4G8D10F2L8E2U10H8 BM+22,+2 M+4,-2 U2L2 M-2,+4 BM+6,-2"
'apos$ = "M+4,-2 U2L2 M-2,+4 BM+6,-2"
s$ = "r8d6h2l6g2f2r4f4d4g4l8u6f2r6e2h2l4h4u4e4"
MoveToB$ = "BM-154,27"
b$ = "r16f4d8g4f4d8g4l16 M+2,-4 U24 M-2,-4 BM+6,+4 R8F2D6G2L8U10 BD14 R8F2D6G2L8U10 BM+18,-14"
l$ = "R8 M-2,+4 D20R12 M+2,-4 D8L22E4U20 M-2,-4 BM+24,+8"
g$ = "BR4 R6F4G2H2L4G2D8F2R4U2H2U2R6D6G4L6H4U12E4"

MaxSize = 16: size = 7: MainString$ = "c14Bm15,10"
CALL DrawLetter(MainString$, e$, MaxSize, size)
CALL DrawLetter(MainString$, t$, MaxSize, size)
CALL DrawLetter(MainString$, le$, MaxSize, size)
CALL DrawLetter(MainString$, r$, MaxSize, size)
CALL DrawLetter(MainString$, n$, MaxSize, size)
CALL DrawLetter(MainString$, i$, MaxSize, size)
CALL DrawLetter(MainString$, lt$, MaxSize, size)
CALL DrawLetter(MainString$, y$, MaxSize, size)
'CALL DrawLetter(MainString$, apos$, MaxSize, size)
CALL DrawLetter(MainString$, s$, MaxSize, size)
MainString$ = MainString$ + MoveToB$
CALL DrawLetter(MainString$, b$, MaxSize, size)
CALL DrawLetter(MainString$, l$, MaxSize, size)
CALL DrawLetter(MainString$, le$, MaxSize, size)
MainString$ = MainString$ + "BR6"
CALL DrawLetter(MainString$, s$, MaxSize, size)
MainString$ = MainString$ + "BR16"
CALL DrawLetter(MainString$, s$, MaxSize, size)
MainString$ = MainString$ + "BR12"
CALL DrawLetter(MainString$, i$, MaxSize, size)
CALL DrawLetter(MainString$, n$, MaxSize, size)
CALL DrawLetter(MainString$, g$, MaxSize, size)

DRAW "s" + STR$(size) + MainString$
COLOR 14: LOCATE 20, 4: PRINT "Copyright 1998-99 Tojo Mojo Productions"
COLOR 14: LOCATE 22, 4: PRINT "Press C during game to see full credits"
PCOPY 1, 0
SLEEP

SCREEN 13: CLS
DRAW "s" + STR$(size) + MainString$
COLOR 14: LOCATE 20, 4: PRINT "Copyright 1998-99 Tojo Mojo Productions"
COLOR 14: LOCATE 22, 4: PRINT "Press C during game to see full credits"

FOR Clr = 63 TO 0 STEP -1
  CALL ClrCycl(14, Clr, Clr, 0)
  IF Clr MOD 2 = 0 THEN CALL WaitSecs(.05)
NEXT Clr

END SUB

DEFSNG A-Z
'Waits a desired amount of seconds.  Minimum is .005 seconds.
'   *InTime!*: Number of seconds to wait.
SUB WaitSecs (InTime!)

  EndTime! = TIMER + InTime!
  WHILE EndTime! > TIMER: WEND

END SUB

