REM HAUNTED HOUSE ADVENTURE
REM ***********************

REM INITIALISATION

CONST NumberOfRooms% = 63
CONST NumberOfVerbs% = 27
CONST WordListSize% = 36
CONST NumberOfGettableObjects% = 18
CONST FALSE% = 0
CONST TRUE% = NOT FALSE%

RANDOMIZE -TIMER
DIM RoomExits$(NumberOfRooms%), RoomDescription$(NumberOfRooms%)
DIM ObjectRoomDescription$(WordListSize%), VerbList$(NumberOfVerbs%)
DIM ObjectCarried%(WordListSize%), ObjectLocation%(NumberOfGettableObjects%)
DIM Flags%(WordListSize%)
FOR Index% = 1 TO NumberOfGettableObjects%
    READ ObjectLocation%(Index%)
NEXT Index%
FOR Index% = 1 TO NumberOfVerbs%
    READ VerbList$(Index%)
NEXT Index%
FOR Index% = 0 TO NumberOfRooms%
    READ RoomExits$(Index%)
NEXT Index%
FOR Index% = 0 TO NumberOfRooms%
    READ RoomDescription$(Index%)
NEXT Index%
FOR Index% = 1 TO WordListSize%
    READ ObjectRoomDescription$(Index%)
NEXT Index%
Flags%(2) = TRUE%
Flags%(17) = TRUE%
Flags%(18) = TRUE%
Flags%(23) = TRUE%
Flags%(26) = TRUE%
Flags%(28) = TRUE%
LitCandleLife% = 60
RoomNumber% = 57
Message$ = "OK"
WIDTH 40

REM DESCRIPTION AND FEEDBACK

DO
    CLS
    PRINT "Haunted House"
    PRINT "-------------"
    PRINT "Your Location"
    PRINT RoomDescription$(RoomNumber%)
    PRINT "Exits: ";
    LengthOfExitString% = LEN(RoomExits$(RoomNumber%))
    FOR Index% = 1 TO LengthOfExitString%
        PRINT MID$(RoomExits$(RoomNumber%), Index%, 1);
        IF Index% < LengthOfExitString% THEN
            PRINT ", ";
        END IF
    NEXT Index%
    PRINT
    FOR Index% = 1 TO NumberOfGettableObjects%
        IF ObjectLocation%(Index%) = RoomNumber% AND NOT Flags%(Index%) THEN
            PRINT "You can see "; ObjectRoomDescription$(Index%); " here"
        END IF
    NEXT Index%
    PRINT "========================="
    PRINT Message$
    Message$ = "What?"

REM INPUT AND INPUT ANALYSIS

    INPUT "What will you do now"; UserResponse$
    UserResponse$ = UCASE$(UserResponse$)
    Verb$ = ""
    Word$ = ""
    VerbNumber% = 0
    ObjectNumber% = 0
    FOR Index% = 1 TO LEN(UserResponse$)
        IF MID$(UserResponse$, Index%, 1) = " " AND Verb$ = "" THEN
            Verb$ = LEFT$(UserResponse$, Index% - 1)
        END IF
        IF MID$(UserResponse$, Index% + 1, 1) <> " " AND Verb$ <> "" THEN
            Word$ = MID$(UserResponse$, Index% + 1, LEN(UserResponse$) - 1)
            Index% = LEN(UserResponse$)
        END IF
    NEXT Index%
    IF Word$ = "" THEN
        Verb$ = UserResponse$
    END IF
    FOR Index% = 1 TO NumberOfVerbs%
        IF Verb$ = VerbList$(Index%) THEN
            VerbNumber% = Index%
        END IF
    NEXT Index%
    FOR Index% = 1 TO WordListSize%
        IF Word$ = ObjectRoomDescription$(Index%) THEN
            ObjectNumber% = Index%
        END IF
    NEXT Index%

REM ERROR MESSAGES OVERRIDE CONDITIONS

    IF Word$ > "" AND ObjectNumber% = 0 THEN
        Message$ = "That's silly!"
    END IF
    IF VerbNumber% = 0 THEN
        VerbNumber% = NumberOfVerbs% + 1
    END IF
    IF Word$ = "" THEN
        Message$ = "I need TWO words!"
    END IF
    IF VerbNumber% > NumberOfVerbs% AND ObjectNumber% > 0 THEN
        Message$ = "You can't '" + UserResponse$ + "'"
    END IF
    IF VerbNumber% > NumberOfVerbs% AND ObjectNumber% = 0 THEN
        Message$ = "You don't make sense!"
    END IF
    IF VerbNumber% < NumberOfVerbs% AND ObjectNumber% > 0 AND NOT ObjectCarried%(ObjectNumber%) THEN
        Message$ = "You don't have '" + Word$ + "'"
    END IF
    IF Flags%(26) AND RoomNumber% = 13 AND FIX(RND(1) * 4) <> 3 AND VerbNumber% <> 21 THEN
        Message$ = "Bats attacking!"
    ELSE
        IF RoomNumber% = 44 AND FIX(RND(1) * 3) = 1 AND NOT Flags%(24) THEN
            Flags%(27) = TRUE%
        END IF
        IF Flags%(0) THEN
            LitCandleLife% = LitCandleLife% - 1
        END IF
        IF LitCandleLife% < 1 THEN
            Flags%(0) = FALSE%
        END IF

REM PROCESS VERBS

        SELECT CASE VerbNumber%
            CASE 1                     '| HELP
                PRINT "Words I know: "
                FOR Index% = 1 TO NumberOfVerbs%
                    PRINT VerbList$(Index%);
                    IF Index% < NumberOfVerbs% THEN
                        PRINT ", ";
                    END IF
                NEXT Index%
                Message$ = ""
                PRINT
                INPUT "PRESS RETURN TO CONTINUE"; UserResponse$
            CASE 2                     '| CARRYING?
                PRINT "You are carrying: "
                FOR Index% = 1 TO NumberOfGettableObjects%
                    IF ObjectCarried%(Index%) THEN
                        PRINT ObjectRoomDescription$(Index%); ", ";
                    END IF
                NEXT Index%
                Message$ = ""
                PRINT
                INPUT "PRESS RETURN TO CONTINUE"; UserResponse$
            CASE 3 TO 9                '| GO - MOVEMENT
                Direction% = 0
                IF ObjectNumber% = 0 THEN
                    Direction% = VerbNumber% - 3
                END IF
                IF ObjectNumber% = 19 THEN
                    Direction% = 1
                END IF
                IF ObjectNumber% = 20 THEN
                    Direction% = 2
                END IF
                IF ObjectNumber% = 21 THEN
                    Direction% = 3
                END IF
                IF ObjectNumber% = 22 THEN
                    Direction% = 4
                END IF
                IF ObjectNumber% = 23 THEN
                    Direction% = 5
                END IF
                IF ObjectNumber% = 24 THEN
                    Direction% = 6
                END IF
                IF RoomNumber% = 20 AND Direction% = 5 THEN
                    Direction% = 1
                END IF
                IF RoomNumber% = 20 AND Direction% = 6 THEN
                    Direction% = 3
                END IF
                IF RoomNumber% = 22 AND Direction% = 6 THEN
                    Direction% = 2
                END IF
                IF RoomNumber% = 22 AND Direction% = 5 THEN
                    Direction% = 3
                END IF
                IF RoomNumber% = 36 AND Direction% = 6 THEN
                    Direction% = 1
                END IF
                IF RoomNumber% = 36 AND Direction% = 5 THEN
                    Direction% = 2
                END IF
                IF Flags%(14) THEN
                    Message$ = "CRASH!  You fell out of the tree!"
                    Flags%(14) = FALSE%
                ELSEIF Flags%(27) AND RoomNumber% = 52 THEN
                    Message$ = "Ghosts will not let you move"
                ELSEIF RoomNumber% = 45 AND ObjectCarried%(1) AND NOT Flags%(34) THEN
                    Message$ = "A magical barrier to the west"
                ELSEIF (RoomNumber% = 26 AND NOT Flags%(0)) AND (Direction% = 1 OR Direction% = 4) THEN
                    Message$ = "You need a light"
                ELSEIF RoomNumber% = 54 AND NOT ObjectCarried%(15) THEN
                    Message$ = "You're stuck!"
                ELSEIF ObjectCarried%(15) AND NOT (RoomNumber% = 53 OR RoomNumber% = 54 OR RoomNumber% = 55 OR RoomNumber% = 47) THEN
                    Message$ = "You can't carry a boat!"
                ELSEIF (RoomNumber% > 26 AND RoomNumber% < 30) AND NOT Flags%(0) THEN
                    Message$ = "Too dark to move!"
                ELSE
                    Flags%(35) = FALSE%
                    RL = LEN(RoomExits$(RoomNumber%))
                    FOR Index% = 1 TO RL
                        U$ = MID$(RoomExits$(RoomNumber%), Index%, 1)
                        IF (U$ = "N" AND Direction% = 1 AND NOT Flags%(35)) THEN
                            RoomNumber% = RoomNumber% - 8
                            Flags%(35) = TRUE%
                        END IF
                        IF (U$ = "S" AND Direction% = 2 AND NOT Flags%(35)) THEN
                            RoomNumber% = RoomNumber% + 8
                            Flags%(35) = TRUE%
                        END IF
                        IF (U$ = "W" AND Direction% = 3 AND NOT Flags%(35)) THEN
                            RoomNumber% = RoomNumber% - 1
                            Flags%(35) = TRUE%
                        END IF
                        IF (U$ = "E" AND Direction% = 4 AND NOT Flags%(35)) THEN
                            RoomNumber% = RoomNumber% + 1
                            Flags%(35) = TRUE%
                        END IF
                    NEXT Index%
                    Message$ = "OK"
                    IF NOT Flags%(35) THEN
                        Message$ = "Can't go that way!"
                    END IF
                    IF Direction% < 1 THEN
                        Message$ = "Go where?"
                    END IF
                    IF RoomNumber% = 41 AND Flags%(23) THEN
                        RoomExits$ = "SW"
                        Message$ = "The door slams shut!"
                        Flags%(23) = FALSE%
                    END IF
                END IF
            CASE 10 TO 11              '| GET/TAKE
                IF ObjectNumber% > NumberOfGettableObjects% THEN
                    Message$ = "I can't get " + Word$
                ELSE
                    IF ObjectLocation%(ObjectNumber%) <> RoomNumber% THEN
                        Message$ = "It isn't here"
                    END IF
                    IF Flags%(ObjectNumber%) THEN
                        Message$ = "What " + Word$ + "?"
                    END IF
                    IF ObjectCarried%(ObjectNumber%) THEN
                        Message$ = "You already have it"
                    END IF
                    IF ObjectNumber% > 0 AND ObjectLocation%(ObjectNumber%) = RoomNumber% AND NOT Flags%(ObjectNumber%) THEN
                        ObjectCarried%(ObjectNumber%) = TRUE%
                        ObjectLocation%(ObjectNumber%) = 65
                        Message$ = "You have the " + Word$
                    END IF
                END IF
            CASE 12                    '| OPEN
                IF RoomNumber% = 43 AND (ObjectNumber% = 28 OR ObjectNumber% = 29) THEN
                    Flags%(17) = FALSE%
                    Message$ = "Drawer open"
                END IF
                IF RoomNumber% = 28 AND ObjectNumber% = 25 THEN
                    Message$ = "It's locked"
                END IF
                IF RoomNumber% = 38 AND ObjectNumber% = 32 THEN
                    Message$ = "That's creepy!"
                    Flags%(2) = FALSE%
                END IF
            CASE 13                    '| EXAMINE
                IF ObjectNumber% = 30 THEN
                    Flags%(18) = FALSE%
                    Message$ = "Something here!"
                END IF
                IF ObjectNumber% = 31 THEN
                    Message$ = "That's disgusting!"
                END IF
                IF (ObjectNumber% = 28 OR ObjectNumber% = 29) THEN
                    Message$ = "There's a drawer"
                END IF
                IF ObjectNumber% = 33 OR ObjectNumber% = 5 THEN
                    IF RoomNumber% = 42 AND ObjectNumber% = 33 THEN
                        Message$ = "They are DEMONIC WORKS!"
                    END IF
                    IF (ObjectNumber% = 3 OR ObjectNumber% = 36) AND ObjectCarried%(3) AND NOT Flags%(34) THEN
                        Message$ = "Use this word with care 'XZANFAR'"
                    END IF
                    IF ObjectCarried%(5) AND ObjectNumber% = 5 THEN
                        Message$ = "The script os in an ALIEN TONGUE!"
                    END IF
                END IF
                IF RoomNumber% = 43 AND ObjectNumber% = 35 THEN
                    Message$ = "There's something beyond..."
                END IF
                IF ObjectNumber% = 32 THEN
                    IF RoomNumber% = 43 AND (ObjectNumber% = 28 OR ObjectNumber% = 29) THEN
                        Flags%(17) = FALSE%
                        Message$ = "Drawer open"
                    END IF
                    IF RoomNumber% = 28 AND ObjectNumber% = 25 THEN
                        Message$ = "It's locked"
                    END IF
                    IF RoomNumber% = 38 AND ObjectNumber% = 32 THEN
                        Message$ = "That's creepy!"
                        Flags%(2) = FALSE%
                    END IF
                END IF
            CASE 14                    '| READ
                IF RoomNumber% = 42 AND ObjectNumber% = 33 THEN
                    Message$ = "They are DEMONIC WORKS"
                END IF
                IF (ObjectNumber% = 3 OR ObjectNumber% = 36) AND ObjectCarried%(3) AND NOT Flags%(34) THEN
                    Message$ = "Use this word with care 'XZANFAR'"
                END IF
                IF ObjectCarried%(5) AND ObjectNumber% = 5 THEN
                    Message$ = "The script is in an ALIEN TONGUE"
                END IF
            CASE 15                    '| SAY
                Message$ = "OK '" + Word$ + "'"
                IF ObjectCarried%(3) AND ObjectNumber% = 34 THEN
                    Message$ = "*MAGIC OCCURS*"
                    IF RoomNumber% <> 45 THEN
                        RoomNumber% = FIX(RND(1) * 64)
                    END IF
                END IF
                IF ObjectCarried%(3) AND ObjectNumber% = 34 AND RoomNumber% = 45 THEN
                    Flags%(34) = TRUE%
                END IF
            CASE 16                    '| DIG
                IF ObjectCarried%(12) THEN
                    IF RoomNumber% = 30 THEN
                        Message$ = "Dug the bars out"
                        RoomDescription$(RoomNumber%) = "Hole in the wall"
                        RoomExits$(RoomNumber%) = "NSE"
                    ELSE
                        Message$ = "You made a hole"
                    END IF
                END IF
            CASE 17                    '| SWING
                IF NOT ObjectCarried%(14) AND RoomNumber% = 7 THEN
                    Message$ = "This is no time to play games!"
                END IF
                IF ObjectNumber% = 14 AND ObjectCarried%(14) THEN
                    Message$ = "You swing the AXE"
                END IF
                IF ObjectNumber% = 13 AND ObjectCarried%(13) THEN
                    Message$ = "WHOOSH"
                END IF
                IF ObjectNumber% = 13 AND ObjectCarried%(13) AND RoomNumber% = 43 THEN
                    RoomExits$(RoomNumber%) = "WN"
                    RoomDescription$(RoomNumber%) = "Study with a secret room"
                    Message$ = "You broke the thin wall"
                END IF
            CASE 18                    '| CLIMB
                IF ObjectNumber% = 14 AND ObjectCarried%(14) THEN
                    Message$ = "It isn't attached to anything!"
                END IF
                IF ObjectNumber% = 14 AND NOT ObjectCarried%(14) AND RoomNumber% = 7 AND NOT Flags%(14) THEN
                    IF NOT Flags%(14) THEN
                        Message$ = "You see thick forrest and a cliff to the south"
                        Flags%(14) = TRUE%
                    ELSE
                        Message$ = "GOING DOWN!"
                        Flags%(14) = FALSE%
                    END IF
                END IF
            CASE 19                    '| LIGHT
                IF ObjectNumber% = 17 AND ObjectCarried%(17) AND NOT ObjectCarried%(8) THEN
                    Message$ = "It will burn your hands"
                END IF
                IF ObjectNumber% = 17 AND ObjectCarried%(17) AND NOT ObjectCarried%(9) THEN
                    Message$ = "Nothing to light it with"
                END IF
                IF ObjectNumber% = 17 AND ObjectCarried%(17) AND ObjectCarried%(9) AND ObjectCarried%(8) THEN
                    Message$ = "It casts a flickering light"
                    Flags%(0) = TRUE%
                END IF
            CASE 20                    '| UNLIGHT
                IF Flags%(0) THEN
                    Flags%(0) = FALSE%
                    Message$ = "Extinguished"
                END IF
            CASE 21                    '| SPRAY
                IF ObjectNumber% = 16 AND ObjectCarried%(16) THEN
                    Message$ = "HISSSS"
                END IF
                IF ObjectNumber% = 16 AND ObjectCarried%(16) AND Flags%(26) THEN
                    Flags%(26) = FALSE%
                    Message$ = "PFFT!  Got them!"
                END IF
            CASE 22                    '| USE
                IF ObjectNumber% = 10 AND ObjectCarried%(10) AND ObjectCarried%(11) THEN
                    Message$ = "Switched on"
                    Flags%(24) = TRUE%
                END IF
                IF Flags%(27) AND Flags%(24) THEN
                    Message$ = "WHIZZ - vacuumed the GHOSTS up!"
                    Flags%(27) = FALSE%
                END IF
            CASE 23                    '| UNLOCK
                IF RoomNumber% = 43 AND (ObjectNumber% = 27 OR ObjectNumber% = 28) THEN
                    IF RoomNumber% = 43 AND (ObjectNumber% = 28 OR ObjectNumber% = 29) THEN
                        Flags%(17) = FALSE%
                        Message$ = "Drawer open"
                    END IF
                    IF RoomNumber% = 28 AND ObjectNumber% = 25 THEN
                        Message$ = "It's locked!"
                    END IF
                    IF RoomNumber% = 38 AND ObjectNumber% = 32 THEN
                        Message$ = "That's creepy!"
                        Flags%(2) = FALSE%
                    END IF
                END IF
                IF RoomNumber% = 28 AND ObjectNumber% = 25 AND NOT Flags%(25) AND ObjectCarried%(18) THEN
                    Flags%(25) = TRUE%
                    RoomExits$(RoomNumber%) = "SEW"
                    RoomDescription$(RoomNumber%) = "Huge open door"
                    Message$ = "The key turns"
                END IF
            CASE 24                    '| LEAVE
                IF ObjectCarried%(ObjectNumber%) THEN
                    ObjectCarried%(ObjectNumber%) = FALSE%
                    ObjectLocation%(ObjectNumber%) = RoomNumber%
                    Message$ = "DONE"
                END IF
            CASE 25                    '| SCORE
                Score% = 0
                PRINT
                FOR Index% = 1 TO NumberOfGettableObjects%
                    IF ObjectCarried%(Index%) THEN
                        Score% = Score% + 1
                    END IF
                NEXT Index%
                IF Score% = 17 AND NOT ObjectCarried%(15) AND RoomNumber% <> 57 THEN
                    PRINT "YOU HAVE EVERYTHING"
                    PRINT "RETURN TO THE GATE FOR FINAL SCORE"
                END IF
                IF Score% = 17 AND RoomNumber% = 57 THEN
                    PRINT "DOUBLE SCORE FOR REACHING HERE!"
                    Score% = Score% * 2
                END IF
                PRINT "YOUR SCORE = "; Score%
                IF Score% > 18 THEN
                    PRINT "WELL DONE! YOU HAVE FINISHED THE GAME"
                    END
                END IF
                Message$ = ""
                PRINT
                INPUT "PRESS RETURN TO CONTINUE"; UserResponse$
            CASE 26                    '| QUIT
                WIDTH 80
                END
            CASE 27                    '| RESTART
                RUN
        END SELECT
        IF LitCandleLife% = 10 THEN
            Message$ = "Your candle is waning!"
        END IF
        IF LitCandleLife% = 1 THEN
            Message$ = "Your candle is out!"
        END IF
    END IF
LOOP

DATA 46,38,35,50,13,18,28,42,10,25,26,4,2,7,47,60,43,32
DATA HELP,CARRYING?,GO,N,S,W,E,U,D,GET,TAKE,OPEN,EXAMINE,READ,SAY
DATA DIG,SWING,CLIMB,LIGHT,UNLIGHT,SPRAY,USE,UNLOCK,LEAVE,SCORE,QUIT,RESTART
DATA SE,WE,WE,SWE,WE,WE,SWE,WS
DATA NS,SE,WE,NW,SE,W,NE,NSW
DATA NS,NS,SE,WE,NWUD,SE,WSUD,NS
DATA N,NS,NSE,WE,WE,NSW,NS,NS
DATA S,NSE,NSW,S,NSUD,N,N,NS
DATA NE,NW,NE,W,NSE,WE,W,NS
DATA SE,NSW,E,WE,NW,S,SW,NW
DATA NE,NWE,WE,WE,WE,NWE,NWE,W
DATA DARK CORNER,OVERGROWN GARDEN,BY LARGE WOODPILE,YARD BY RUBBISH
DATA WEEDPATCH,FOREST,THICK FOREST,BLASTED TREE
DATA CORNER OF HOUSE,ENTRANCE TO KITCHEN,KITCHEN AND GRIMEY COOKER,SCULLERY DOOR
DATA ROOM WITH INCHES OF DUST,REAR TURRET ROOM,CLEARING BY HOUSE,PATH
DATA SIDE OF HOUSE,BACK OF HALLWAY,DARK ALCOVE,SMALL DARK ROOM
DATA BOTTOM OF SPIRAL STAIRCASE,WIDE PASSAGE,SLIPPERY STEPS,CLIFFTOP
DATA NEAR CRUMBLING WALL,GLOOMY PASSAGE,POOL OF LIGHT,IMPRESSIVE VAULTED HALLWAY
DATA HALL BY THICK WOODEN DOOR,TROPHY ROOM,CELLAR WITH BARRED WINDOW,CLIFF PATH
DATA CUPBOARD WITH HANGING COAT,FRONT HALL,SITTING ROOM,SECRET ROOM
DATA STEEP MARBLE STAIRS,DINING ROOM,DEEP CELLAR WITH COFFIN,CLIFF PATH
DATA CLOSET,FRONT LOBBY,LIBRARY OF EVIL BOOKS,STUDY WITH DESK AND HOLE IN WALL
DATA WEIRD COBWEBBY ROOM,VERY COLD CHAMBER,SPOOKY ROOM,CLIFF PATH BY MARSH
DATA RUBBLE-STREWN VERANDAH,FRONT PORCH,FRONT TOWER,SLOPING CORRIDOR
DATA UPPER GALLERY,MARSH BY WALL,MARSH,SOGGY PATH
DATA BY TWISTED RAILING, PATH THROUGH IRON GATE,BY RAILINGS,BENEATH FRONT TOWER
DATA DEBRIS FROM CRUMBLING FACADE,LARGE FALLEN BRICKWORK,ROTTING STONE ARCH,CRUMBLING CLIFFTOP
DATA PAINTING,RING,MAGIC SPELLS,GOBLET,SCROLL,COINS,STATUE,CANDLESTICK
DATA MATCHES,VACUUM,BATTERIES,SHOVEL,AXE,ROPE,BOAT,AEROSOL,CANDLE,KEY
DATA NORTH,SOUTH,WEST,EAST,UP,DOWN
DATA DOOR,BATS,GHOSTS,DRAWER,DESK,COAT,RUBBISH
DATA COFFIN,BOOKS,XZANFAR,WALL,SPELLS

