'----------------------------------------------------------------------------
' DQBLITE.BI
'   Include file for the DirectQB library version 1.3 Lite
'
' This file contains constants and function declarations used by the library
' Always include this file into your own programs!
'
' Detailed informations on how to use the library can be found into the
' DIRECTQB.DOC and DQBLITE.DOC files; read them carefully!
'----------------------------------------------------------------------------

'$DYNAMIC
DEFINT A-Z

' 49 routine declarations
DECLARE FUNCTION DQBinit (BYVAL NumLayers, BYVAL NumSounds)
DECLARE FUNCTION DQBver ()
DECLARE FUNCTION DQBemsSeg ()
DECLARE FUNCTION DQBpoint (BYVAL Layer, BYVAL x, BYVAL y)
DECLARE FUNCTION DQBlen (Text AS STRING)
DECLARE FUNCTION DQBloadLayer (Layer AS INTEGER, FileName AS STRING, Pal AS STRING)
DECLARE FUNCTION DQBsaveLayer (Layer AS INTEGER, FileName AS STRING, Pal AS STRING, Format AS INTEGER)
DECLARE FUNCTION DQBkey (BYVAL ScanCode)
DECLARE FUNCTION DQBinstallSB (Channels AS INTEGER, BaseAddr AS INTEGER, IRQ AS INTEGER, DMA AS INTEGER)
DECLARE FUNCTION DQBloadSound (Slot AS INTEGER, FileName AS STRING)
DECLARE FUNCTION DQBloadRawSound (Slot AS INTEGER, FileName AS STRING, Offset AS LONG, Length AS LONG)
DECLARE SUB DQBcopyLayer (BYVAL SourceLayer, BYVAL DestLayer)
DECLARE SUB DQBclearLayer (BYVAL Layer)
DECLARE SUB DQBpset (BYVAL Layer, BYVAL x, BYVAL y, BYVAL Col)
DECLARE SUB DQBline (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBellipse (BYVAL Layer, BYVAL x, BYVAL y, BYVAL rx, BYVAL ry, BYVAL Col)
DECLARE SUB DQBbox (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBboxf (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBscroll (BYVAL Layer, BYVAL dx, BYVAL dy)
DECLARE SUB DQBwait (BYVAL Times)
DECLARE SUB DQBsetTransPut ()
DECLARE SUB DQBsetSolidPut ()
DECLARE SUB DQBsetClipBox (BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2)
DECLARE SUB DQBget (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBput (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBxPut (BYVAL SourceLayer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL DestLayer, BYVAL x, BYVAL y)
DECLARE SUB DQBsetCol (BYVAL ColorIndex, BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE SUB DQBgetCol (BYVAL ColorIndex, Red, Green, Blue)
DECLARE SUB DQBsetPal (Pal AS STRING)
DECLARE SUB DQBgetPal (Pal AS STRING)
DECLARE SUB DQBfadeIn (Pal AS STRING)
DECLARE SUB DQBfadeTo (BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE SUB DQBpalOff ()
DECLARE SUB DQBprint (Layer AS INTEGER, Text AS STRING, x AS INTEGER, y AS INTEGER, Col AS INTEGER)
DECLARE SUB DQBprints (Layer AS INTEGER, Text AS STRING, x AS INTEGER, y AS INTEGER, Col AS INTEGER, Style AS INTEGER)
DECLARE SUB DQBsetBIOSfont ()
DECLARE SUB DQBsetFont (Font AS STRING)
DECLARE SUB DQBsetTextStyle (BYVAL Style)
DECLARE SUB DQBsetTextBackCol (BYVAL Col)
DECLARE SUB DQBinstallKeyboard ()
DECLARE SUB DQBremoveKeyboard ()
DECLARE SUB DQBclose ()
DECLARE SUB DQBplaySound (BYVAL SoundNum, BYVAL Voice, BYVAL LoopFlag)
DECLARE SUB DQBpauseSound ()
DECLARE SUB DQBresumeSound ()
DECLARE SUB DQBstopVoice (BYVAL Voice)
DECLARE SUB DQBsetSamplingRate (Rate AS INTEGER)
DECLARE SUB DQBremoveSB ()
DECLARE SUB DQBsetVolume (BYVAL Volume)

' Library constants
CONST FALSE = 0, TRUE = NOT FALSE
CONST VIDEO = 0, BSV = 0, BMP = 1, PCX = 2
CONST NONE = 0, SOLID = 1, BOLD = 2, ITALIC = 4, UNDERLINED = 8
CONST KEYESC = 1, KEYENTER = 28, KEYSPACE = 57
CONST KEYUP = 72, KEYDOWN = 80, KEYLEFT = 75, KEYRIGHT = 77
CONST AUTO = -1, ONCE = 0, LOOPED = 1

