'$DYNAMIC
'$INCLUDE: 'DQBlite.Bi'

'QMIDI
DECLARE FUNCTION int86qb$ (intnr%, flag%, AX%, bx%, cx%, dx%, di%, si%, bp%, ds%, es%)
 DECLARE FUNCTION int2str$ (sword%)
  DECLARE FUNCTION PlayMIDI% ()
   DECLARE FUNCTION LoadAndPlayMIDI% (Filename$)
  DECLARE SUB LoadMIDI (Filename$)
 DECLARE SUB StopMIDI ()
DECLARE FUNCTION TimeMIDI! ()
DIM SHARED MIDI.LOADED AS INTEGER
 DIM SHARED MIDI.PLAYTIME AS SINGLE
  DIM SHARED MIDI.INTERRUPT AS INTEGER
  MIDI.LOADED = 0
 MIDI.PLAYTIME = 0
MIDI.INTERRUPT = &H81

'JR Intro By Jason Earl 1999
DEFSNG A-Z
R = DQBinit(2, 0)
C$ = COMMAND$


SCREEN 13
ON ERROR GOTO 12
'Mad4DOS game palette type 1.0
OPEN "newpal.dat" FOR INPUT AS #1
 FOR a = 255 TO 82 STEP -1
  INPUT #1, R, g, b
   OUT &H3C6, &HFF
    OUT &H3C8, a
    OUT &H3C9, R
   OUT &H3C9, g
  OUT &H3C9, b
 NEXT a
CLOSE #1

DEF SEG = &HA000
BLOAD "pics-256\backdrop\8.bin", 0
DQBcopylayer 0, 2

FOR a = 0 TO 82
   OUT &H3C6, &HFF
    OUT &H3C8, a
    OUT &H3C9, 0
   OUT &H3C9, 0
  OUT &H3C9, 0

IF a > 35 THEN

R = RND * 16
   S = RND * 10 - 2
   IF S = 0 THEN R = R * 3
   OUT &H3C6, &HFF
    OUT &H3C8, a
    OUT &H3C9, RND * 8
   OUT &H3C9, RND * 8
  OUT &H3C9, R
END IF
NEXT


OPEN "config.def" FOR INPUT AS #1
INPUT #1, sounds, MIDI, joypad
CLOSE

'Loader
OPEN "Intro.Dat" FOR INPUT AS #1
FOR z = 1 TO 3
INPUT #1, header$
SELECT CASE header$
CASE "[midi]": GOSUB Midiload
CASE "[text]": GOSUB textload
CASE "[bad]": GOSUB badload
END SELECT
NEXT

REDIM sx(200), sy(200), ss(200), sc(200)
FOR a = 1 TO 200
sx(a) = RND * 319
GOSUB workout
NEXT
GOTO cont

Midiload:
INPUT #1, midifile$, time
PRINT , midifile$, time
IF MIDI THEN LoadMIDI (file$)
'IF sounds THEN R = LoadAndPlayMIDI("sound\2.mid")
OPEN "nul" FOR OUTPUT AS #4
FOR op = 1 TO 50
IF MIDI THEN player = PlayMIDI
NEXT op
FOR op = 1 TO 200
NEXT
CLOSE #4

ON TIMER(time) GOSUB replay
TIMER ON
RETURN

badload:
INPUT #1, numdata, maxarray
   REDIM badfile$(numdata), badindex(numdata), bad%(1028, maxarray)
    FOR b = 1 TO numdata
    INPUT #1, file$, start
     DEF SEG = VARSEG(bad%(0, start))
   BLOAD "pics-256\new\bin\ani\" + file$ + ".", VARPTR(bad%(0, start))
  NEXT b
 INPUT #1, num
    REDIM bx(num), by(num), bm(num), bstartframe(num), bnumoffframes(num), bx1(num), by1(num), bx2(num), by2(num), Bdelay(num), bspeed!(num)
     REDIM bbx!(num), bby!(num), bbm(num), bbframe(num), Animate(num)
    FOR a = 1 TO num
  INPUT #1, bx(a), by(a), bm(a), bstartframe(a), bnumoffframes(a), bx1(a), by1(a), bx2(a), by2(a), Bdelay(a), bspeed!(a)
  NEXT a
FOR a = 1 TO num
 IF killall THEN bkill(a) = -1
  bbx!(a) = bx(a)
   bby!(a) = by(a)
    SELECT CASE bm(a)
      CASE 1, 2, 3, 4, 5, 6: bbm(a) = bm(a)
     CASE 7: bbm(a) = 1
    CASE 8: bbm(a) = 2
   CASE ELSE
  END SELECT
 bbframe(a) = bstartframe(a)
NEXT
RETURN

textload:
INPUT #1, boxes, maxtexts, maxwidth
REDIM boxx1(boxes), boxy1(boxes), boxx2(boxes), boxy2(boxes), move(boxes)
REDIM col1(boxes), col2(boxes), repeat(boxes), col(boxes), poss(boxes)
REDIM text$(boxes, maxtexts), text(boxes), pointer(boxes)
FOR a = 1 TO boxes
INPUT #1, boxx1(a), boxy1(a), boxx2(a), boxy2(a), move(a)
INPUT #1, col1(a), col2(a), repeat(a), pointer(a)
INPUT #1, text(a)
FOR b = 1 TO text(a)
INPUT #1, text$(a, b)
NEXT b, a
RETURN


cont:
CLOSE
OPEN "hiscore.dat" FOR INPUT AS #1
INPUT #1, tables
REDIM hi$(tables + 1), score(tables + 1)
FOR a = 1 TO tables
INPUT #1, hi$(a), score(a)
NEXT a
CLOSE

OPEN "hi.dat" FOR INPUT AS #1
INPUT #1, hi$(tables + 1), score(tables + 1)
CLOSE

flips = 1
WHILE flips
flips = 0
FOR a = 1 TO tables
IF score(a) = score(a + 1) THEN score(a) = 0
IF score(a) < score(a + 1) THEN SWAP hi$(a), hi$(a + 1): SWAP score(a), score(a + 1): flips = 1
NEXT
WEND

OPEN "hiscore.dat" FOR OUTPUT AS #1
WRITE #1, tables
FOR a = 1 TO tables
WRITE #1, hi$(a), score(a)
NEXT a
CLOSE


table$ = "The top Hi Scoring Raider's of Johnny Raider are ..."
FOR a = tables TO 1 STEP -1
table$ = table$ + "   At place number " + STR$(a) + " is " + hi$(a) + " with $" + STR$(score(a) / 100) + " ..."
NEXT



DO
DQBcopylayer 2, 1
FOR a = 1 TO 200
sx(a) = sx(a) - ss(a)
IF sx(a) < 0 THEN GOSUB workout
DQBpset 1, sx(a), sy(a), sc(a)
NEXT

GOSUB badit
GOSUB baddraw

'Text
FOR a = 1 TO boxes
DQBsetClipBox boxx1(a), boxy1(a), boxx2(a), boxy2(a)
poss(a) = poss(a) + 1

SELECT CASE INKEY$
CASE "Q", "q": EXIT DO
CASE "P", "p": o = -1: EXIT DO
CASE "R", "r": o = -2: EXIT DO
CASE "C", "c": o = -3: EXIT DO
END SELECT

IF move(a) = 1 OR move(a) = 2 THEN
FOR b = 1 TO text(a)
d = boxx2(a) - (poss(a) + ((maxwidth(a) * 8) * b))
col(a) = col(a) + 1
e = col1(a) + col(a)
IF e + (b * 2) > col2(a) THEN col(a) = 0
IF e + (b * 2) < col1(a) THEN col(a) = 0
DQBprint 1, text$(a, b), INT(d) + 1, boxy1(a) * b + 1, 248
DQBprint 1, text$(a, b), INT(d), boxy1(a) * b, e + (b * 2)
IF pointer(a) < poss(a) THEN poss(a) = 0
NEXT b
END IF

IF move(a) = 3 OR move(a) = 4 THEN
FOR b = 1 TO text(a)
d = boxx2(a) - ((poss(a) / 2) + ((maxwidth(a) * 8) * b))
e = col1(a) + ((col2(a) - col1(a)) * (boxx2(a) - boxx1(a)) * (x - (poss(a) + ((maxwidth(a) * 8) * b))))
IF e + (b * 2) < col1(a) THEN e = col1(a)
DQBprint 1, text$(a, b), INT(boxx1(a)) + 1, d + (b * 8 - 8) + 1, 250
DQBprint 1, text$(a, b), INT(boxx1(a)), d + (b * 8 - 8), e + (b * 2)
IF pointer(a) < poss(a) THEN poss(a) = 0
NEXT b
END IF

NEXT a

pss = pss + 1
y1 = 40
y2 = 60
x1 = 10
x2 = 310
col1 = 85
DQBsetClipBox x1, y1, x2, y2
d = x2 - (pss + ((maxwidth(a) * 8) * b))
DQBprint 1, table$, INT(d) + 1, y1 + 1, 248
DQBprint 1, table$, INT(d), INT(y1), 110
IF 8000 < pss THEN pss = 0

DQBsetClipBox 0, 0, 319, 199
DQBcopylayer 1, 0
LOOP
StopMIDI
DQBclose
IF o = -1 THEN OPEN "temp\null." FOR OUTPUT AS 1: WRITE #1, COMMAND$: CLOSE : CHAIN "data.dat"
IF o = -2 THEN OPEN "temp\null." FOR OUTPUT AS 1: WRITE #1, COMMAND$: CLOSE : RUN "readme.com"
IF o = -3 THEN OPEN "temp\null." FOR OUTPUT AS 1: WRITE #1, COMMAND$: CLOSE : RUN "config.exe"
SHELL "mode 80"
SHELL "type readme.txt"
SHELL "echo."
SHELL "pause"
SHELL "sound\sbsim /u >nul"
SHELL "sound\sbmidi /u >nul"
IF o = 0 THEN OPEN "test" FOR OUTPUT AS #1: WRITE a: CLOSE
SYSTEM




replay:
R = PlayMIDI
RETURN

'BADDY MOVES
m1:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
  bby!(a) = bby!(a) - bspeed!(a)
 IF bby!(a) < by1(a) THEN bby!(a) = by2(a)
RETURN

m2:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
  bby!(a) = bby!(a) + bspeed!(a)
 IF bby!(a) > by2(a) THEN bby!(a) = by1(a)
RETURN

m3:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
  bbx!(a) = bbx!(a) - bspeed!(a)
 IF bbx!(a) < bx1(a) THEN bbx!(a) = bx2(a)
RETURN

m4:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
  bbx!(a) = bbx!(a) + bspeed!(a)
 IF bbx!(a) > bx2(a) THEN bbx!(a) = bx1(a)
RETURN

m5:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
 IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
RETURN

m6:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
   SELECT CASE bbm(a)
    CASE 6: GOTO s6
     CASE 7: GOTO s7
    CASE 8: GOTO s8
   CASE 9: GOTO s9
  CASE ELSE
 END SELECT
RETURN
s6:
 bbx!(a) = bbx!(a) - bspeed!(a): bby!(a) = bby!(a) - bspeed!(a)
  IF bbx!(a) < bx1(a) THEN
   bbx!(a) = bbx!(a) + bspeed!(a): bby!(a) = bby!(a) + bspeed!(a): bbm(a) = 7
    END IF
   IF bby!(a) < by1(a) THEN
  bbx!(a) = bbx!(a) + bspeed!(a): bby!(a) = bby!(a) + bspeed!(a): bbm(a) = 9
 END IF
RETURN
s7:
 bbx!(a) = bbx!(a) + bspeed!(a): bby!(a) = bby!(a) - bspeed!(a)
  IF bbx!(a) > bx2(a) THEN
   bbx!(a) = bbx!(a) - bspeed!(a): bby!(a) = bby!(a) + bspeed!(a): bbm(a) = 6
    END IF
   IF bby!(a) < by1(a) THEN
  bbx!(a) = bbx!(a) - bspeed!(a): bby!(a) = bby!(a) + bspeed!(a): bbm(a) = 8
 END IF
RETURN
s8:
 bbx!(a) = bbx!(a) + bspeed!(a): bby!(a) = bby!(a) + bspeed!(a)
  IF bbx!(a) > bx2(a) THEN
   bbx!(a) = bbx!(a) - bspeed!(a): bby!(a) = bby!(a) - bspeed!(a): bbm(a) = 9
    END IF
   IF bby!(a) > by2(a) THEN
  bbx!(a) = bbx!(a) - bspeed!(a): bby!(a) = bby!(a) - bspeed!(a): bbm(a) = 7
 END IF
RETURN
s9:
 bbx!(a) = bbx!(a) - bspeed!(a): bby!(a) = bby!(a) + bspeed!(a)
  IF bbx!(a) < bx1(a) THEN
   bbx!(a) = bbx!(a) + bspeed!(a): bby!(a) = bby!(a) - bspeed!(a): bbm(a) = 8
    END IF
   IF bby!(a) > by2(a) THEN
  bbx!(a) = bbx!(a) + bspeed!(a): bby!(a) = bby!(a) - bspeed!(a): bbm(a) = 6
 END IF
RETURN

M7:
 IF Animate(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
   SELECT CASE bbm(a)
    CASE 1: GOTO s1
   CASE 2: GOTO s2
  CASE ELSE
scrap:
 END SELECT
RETURN
s1:
 bby!(a) = bby!(a) - bspeed!(a)
 IF bby!(a) < by1(a) THEN bby!(a) = bby!(a) + bspeed!(a): bbm(a) = 2
GOTO scrap
s2:
 bby!(a) = bby!(a) + bspeed!(a)
 IF bby!(a) > by2(a) THEN bby!(a) = bby!(a) - bspeed!(a): bbm(a) = 1
GOTO scrap

M8:
 IF bspeed!(a) = 2 THEN bbframe(a) = bbframe(a) + 1
  IF bbframe(a) > bstartframe(a) + bnumoffframes(a) THEN bbframe(a) = bstartframe(a)
   SELECT CASE bbm(a)
   CASE 1: GOTO s3
  CASE 2: GOTO s4
 CASE ELSE
scrap2:
 END SELECT
 RETURN
s3:
 bbx!(a) = bbx!(a) - bspeed!(a)
 IF bbx!(a) < bx1(a) THEN bbx!(a) = bbx!(a) + bspeed!(a): bbm(a) = 2
GOTO scrap2
s4:
 bbx!(a) = bbx!(a) + bspeed!(a)
 IF bbx!(a) > bx2(a) THEN bbx!(a) = bbx!(a) - bspeed!(a): bbm(a) = 1
GOTO scrap2

workout:
sx(a) = 289 + RND * 40
sy(a) = RND * 200
sc(a) = 245 + RND * 10
ss(a) = RND * 3 + 1
RETURN

badit:

'BADDY UPDATE
 FOR a = 1 TO num
  Animate(a) = Animate(a) + 1
    IF Animate(a) > Bdelay(a) THEN Animate(a) = 1
     SELECT CASE bm(a)
      CASE 1: GOSUB m1 'up
       CASE 2: GOSUB m2 'down
       CASE 3: GOSUB m3 'left
      CASE 4: GOSUB m4 'right
     CASE 5: GOSUB m5 'still
    CASE 6: GOSUB m6 'bounce
   CASE 7: GOSUB M7 'up+down
  CASE 8: GOSUB M8 'left+right
END SELECT
NEXT
RETURN

baddraw:
FOR gi = 1 TO num
DQBput 1, bbx!(gi), bby!(gi), VARSEG(bad%(0, bbframe(gi))), VARPTR(bad%(0, bbframe(gi)))
NEXT
RETURN

12
RESUME NEXT

REM $STATIC
FUNCTION int2str$ (sword%)
'This function is translating SWORD Integers into a string. Its only use
'is when you still use asm$ for assembler functions( like i do). In that
'case you can make your integer values usable ..
'THis function simply translates the hexa bytes
'into stringbytes as is.
'----------------------------------------------------
DEF SEG = VARSEG(sword%)
ptr% = VARPTR(sword%)
int2str$ = CHR$(PEEK(ptr%)) + CHR$(PEEK(ptr% + 1))
DEF SEG

END FUNCTION

FUNCTION int86qb$ (intnr%, flag%, AX%, bx%, cx%, dx%, di%, si%, bp%, ds%, es%)
'------------------------------------------------------------------------
'Conversion of all integers in strings
flag$ = LEFT$(int2str$(flag%), 1): AX$ = int2str$(AX%):
bx$ = int2str$(bx%): cx$ = int2str$(cx%): dx$ = int2str$(dx%):
di$ = int2str$(di%): si$ = int2str$(si%): bp$ = int2str$(bp%):
ds$ = int2str$(ds%): es$ = int2str$(es%):
'Now all integersvalues are direct usable in asm$
'------------------------------------------------------------------------
DIM datas%(11)    'that is all we need
dataseg% = VARSEG(datas%(0)): flagoff% = VARPTR(datas%(0))
dataseg$ = int2str$(dataseg%): flagoff$ = int2str$(flagoff%)
axoff$ = int2str$(flagoff% + 2): bxoff$ = int2str$(flagoff% + 4)
cxoff$ = int2str$(flagoff% + 6): dxoff$ = int2str$(flagoff% + 8)
dioff$ = int2str$(flagoff% + 10): sioff$ = int2str$(flagoff% + 12)
bpoff$ = int2str$(flagoff% + 14): dsoff$ = int2str$(flagoff% + 16)
esoff$ = int2str$(flagoff% + 18): intnroff$ = int2str$(flagoff% + 20)
'Now all integers are directly adressable in memory through asm$
'We could have used only this as pointers and leave the immediate values
'but....we don't.
'------------------------------------------------------------------------
asm$ = ""
asm$ = asm$ + CHR$(&H9C)                       'pushf
asm$ = asm$ + CHR$(&H50)                       'push ax
asm$ = asm$ + CHR$(&H53)                       'push bx
asm$ = asm$ + CHR$(&H51)                       'push cx
asm$ = asm$ + CHR$(&H52)                       'push dx
asm$ = asm$ + CHR$(&H57)                       'push di
asm$ = asm$ + CHR$(&H56)                       'push si
asm$ = asm$ + CHR$(&H55)                       'push bp
asm$ = asm$ + CHR$(&H1E)                       'push ds
asm$ = asm$ + CHR$(&H6)                        'push es

'2)LOAD REGISTERS
'First the flags( questionable if this ever happens):
asm$ = asm$ + CHR$(&HB4) + flag$              'mov ax,flag$
asm$ = asm$ + CHR$(&H9E)                      'sahf stores ah into flags

'Segment registers mbv ax :  only when not (accidentally) 0
IF ds% <> 0 THEN                              'safety
  asm$ = asm$ + CHR$(&HB8) + ds$              'mov ax,ds$
  asm$ = asm$ + CHR$(&H8E) + CHR$(&HD8)       'mov ds,ax
END IF
IF es% <> 0 THEN                              'safety
  asm$ = asm$ + CHR$(&HB8) + es$              'mov ax,es$
  asm$ = asm$ + CHR$(&H8E) + CHR$(&HC0)       'mov es,ax
END IF
'the rest of registers :
asm$ = asm$ + CHR$(&HB8) + AX$                'mov ax,ax$
asm$ = asm$ + CHR$(&HBB) + bx$                'mov bx,bx$
asm$ = asm$ + CHR$(&HB9) + cx$                'mov cx,cx$
asm$ = asm$ + CHR$(&HBA) + dx$                'mov dx,dx$
asm$ = asm$ + CHR$(&HBF) + di$                'mov di,di$
asm$ = asm$ + CHR$(&HBE) + si$                'mov si,si$
asm$ = asm$ + CHR$(&HBD) + bp$                'mov bp,bp$
'oke now the interrupt himself
asm$ = asm$ + CHR$(&HCD) + CHR$(intnr%)       'interrupt nr

'First make our DATAS% adressable:
asm$ = asm$ + CHR$(&H1E)                         'push ds
asm$ = asm$ + CHR$(&HB8) + dataseg$              'mov ax,DATASseg$
asm$ = asm$ + CHR$(&H8E) + CHR$(&HD8)            'mov ds,ax
                                          
'We first pushed DS segment register since we want to adress our DATA_segment
asm$ = asm$ + CHR$(&H8F) + CHR$(&H6) + dsoff$    'pop dsoff$
asm$ = asm$ + CHR$(&H8C) + CHR$(&H6) + esoff$    'mov esoff$,ES

asm$ = asm$ + CHR$(&H9F)                         'lahf
asm$ = asm$ + CHR$(&H88) + CHR$(&H26) + flagoff$ 'mov flagoff$,ah
                    
'The rest is more simple i think:
asm$ = asm$ + CHR$(&H89) + CHR$(&H2E) + bpoff$   'mov bpoff$,bp
asm$ = asm$ + CHR$(&H89) + CHR$(&H36) + sioff$   'mov sioff$,si
asm$ = asm$ + CHR$(&H89) + CHR$(&H3E) + dioff$   'mov dioff$,di
asm$ = asm$ + CHR$(&H89) + CHR$(&H16) + dxoff$   'mov dxoff$,dx
asm$ = asm$ + CHR$(&H89) + CHR$(&HE) + cxoff$    'mov cxoff$,cx
asm$ = asm$ + CHR$(&H89) + CHR$(&H1E) + bxoff$   'mov bxoff$,bx
asm$ = asm$ + CHR$(&HA3) + axoff$                'mov axoff$,ax
                               
'Now let us neatly finish by just popping everything back in order
asm$ = asm$ + CHR$(&H7)                          'pop es
asm$ = asm$ + CHR$(&H1F)                         'pop ds
asm$ = asm$ + CHR$(&H5D)                         'pop bp
asm$ = asm$ + CHR$(&H5E)                         'pop si
asm$ = asm$ + CHR$(&H5F)                         'pop di
asm$ = asm$ + CHR$(&H5A)                         'pop dx
asm$ = asm$ + CHR$(&H59)                         'pop cx
asm$ = asm$ + CHR$(&H5B)                         'pop bx
asm$ = asm$ + CHR$(&H58)                         'pop ax
asm$ = asm$ + CHR$(&H9D)                         'popf
'We are done?
asm$ = asm$ + CHR$(&HCB)                         'retf

DEF SEG = VARSEG(asm$)
offcode% = SADD(asm$): CALL absolute(offcode%): DEF SEG

ui$ = HEX$(intnr%)
FOR I% = 0 TO 9
  hx$ = HEX$(datas%(I%))
  hx$ = STRING$(4 - LEN(hx$), "0") + hx$
  ui$ = ui$ + "," + hx$
NEXT

int86qb$ = ui$

END FUNCTION

'LoadAndPlayMIDI - Loads a MIDI file into memory and plays it
FUNCTION LoadAndPlayMIDI% (Filename$)
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(Filename$, 1) <> CHR$(0) THEN Filename$ = Filename$ + CHR$(0)
'If MIDI.INTERRUPT is not defined, set it to 81H
IF MIDI.INTERRUPT = 0 THEN MIDI.INTERRUPT = &H81
'Initialize the MIDI driver and load the file in memory
a$ = int86qb$(MIDI.INTERRUPT, 0, SADD(Filename$), &H500, 0, VARSEG(Filename$), 0, 0, 0, 0, 0)
MIDI.LOADED = -1
'Start the music!!
a$ = int86qb$(MIDI.INTERRUPT, 0, 0, &H501, 0, 0, 0, 0, 0, 0, 0)
AX$ = MID$(a$, 9, 4)
AX% = VAL(AX$)
IF NOT AX% THEN
       LoadAndPlayMIDI% = -1
       MIDI.PLAYTIME = TIMER
END IF

END FUNCTION

'LoadMIDI - loads a MIDI file into memory
SUB LoadMIDI (Filename$)
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(Filename$, 1) <> CHR$(0) THEN Filename$ = Filename$ + CHR$(0)
'If MIDI.INTERRUPT is not defined, set it to 81H
IF MIDI.INTERRUPT = 0 THEN MIDI.INTERRUPT = &H81
'Initialize the MIDI driver and load the file in memory
a$ = int86qb$(MIDI.INTERRUPT, 0, SADD(Filename$), &H500, 0, VARSEG(Filename$), 0, 0, 0, 0, 0)
MIDI.LOADED = -1
END SUB

'PlayMIDI - Begins playing a MIDI file in the background.
FUNCTION PlayMIDI%
'If no MIDI file is loaded, exit now
IF MIDI.LOADED = 0 THEN EXIT FUNCTION
'If MIDI.INTERRUPT is not defined, set it to 81H
IF MIDI.INTERRUPT = 0 THEN MIDI.INTERRUPT = &H81
'Start the music!!
a$ = int86qb$(MIDI.INTERRUPT, 0, 0, &H501, 0, 0, 0, 0, 0, 0, 0)
AX$ = MID$(a$, 9, 4)
AX% = VAL(AX$)
IF NOT AX% THEN
       PlayMIDI% = -1
       MIDI.PLAYTIME = TIMER
END IF
END FUNCTION

SUB Pokestring (SEGJE%, OFFJE%, Main$)
'------------------------------------------------------
'This function pokes a string (might be ASCIIZ)into
'memory at a given location, making it possible to
'access strings in byte form
'------------------------------------------------------

DEF SEG = SEGJE%
FOR I% = 0 TO LEN(Main$) - 1
  POKE OFFJE% + I%, ASC(MID$(Main$, I% + 1, 1))
NEXT
DEF SEG

END SUB

'StopMIDI - Stops playing MIDI file
SUB StopMIDI
'If MIDI.INTERRUPT is not defined, set it to 81H
IF MIDI.INTERRUPT = 0 THEN MIDI.INTERRUPT = &H81
'Stop the music!!
a$ = int86qb$(MIDI.INTERRUPT, 0, 0, &H502, 0, 0, 0, 0, 0, 0, 0)
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is playing, carry out the timing routine
IF MIDI.PLAYTIME THEN
'Get the current time
CurrentTime! = TIMER
'If midnight has come since the MIDI file started playing, change
'CurrentTime! accordingly
IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
CurrentTime! = 86400 + CurrentTime!
END IF
'Get the final result
TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
END IF
END FUNCTION

